<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_mall_goods_category extends inc_mod_admin {

	function sql_list($pid = 0) {
		$arr_return = array("list" => array());
		$obj_db = cls_obj::db();
		$arr = array();
		//取排序字段
		$arr_config_info = tab_sys_user_config::get_info("mall.goods.category"  , $this->app_dir);
		$sort = $arr_config_info["sortby"];
		$arr_return["sort"] = $arr_config_info["sort"];
		$obj_result = $obj_db->select("select category_id,category_name,category_child,category_unit,category_sort,category_pid,category_depth from " . cls_config::DB_PRE . "mall_goods_category where category_pid='" . $pid . "'" . $sort);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr[] = $obj_rs;
		}
		$arr_return['list'] = $arr;
		return $arr_return;
	}
	function on_move_save() {
		$arr_return = array("code"=>0 , "id"=>0 , "msg" => cls_language::get("save_ok"));
		$id = (int)fun_get::get("id");
		$pid = (int)fun_get::get("category_id");
		if(empty($id)) {
			$arr_return["code"] = 22;
			$arr_return['msg']  = cls_language::get("no_id");
			return $arr_return;
		}
		$arr = tab_mall_goods_category::on_move($id , $pid);
		if($arr['code']==0) {
			if(isset($arr['id'])) $arr_return['id'] = $arr['id'];
		} else {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	/* 保存数据
	 * 
	 */
	function on_save_all() {
		$arr_return = array("code" => 0 ,"id"=>0 , "msg" => cls_language::get("save_ok"));
		$arr_category_name = fun_get::get("category_name");
		$arr_category_sort = fun_get::get("category_sort");
		$pid  = fun_get::get("url_pid");
		$arr_category_unit  = fun_get::get("category_unit");
		$arr_category_id   = fun_get::get("category_id");

		$arr_resave = array();
		$lng_count = count($arr_category_name);

		$obj_rs = cls_obj::db()->get_one("select category_pids from ".cls_config::DB_PRE."mall_goods_category where category_id='" . $pid . "'");
		if(!empty($obj_rs)) {
			$pids = $obj_rs["category_pids"] . "," . $pid;
		} else {
			$pids = $pid;
		}
		$depth = count(explode("," , $pids));
		//循环统计已有 id
		for( $i = 1 ; $i < $lng_count ; $i++) {
			$arr_fields = array(
				"category_id" => (int)$arr_category_id[$i],
				"category_name" => $arr_category_name[$i],
				"category_sort" => $arr_category_sort[$i],
				"category_unit" => $arr_category_unit[$i],
				"category_pid" => $pid,
				"category_pids" => $pids,
				"category_depth" => $depth
			);
			$arr_re = tab_mall_goods_category::on_save($arr_fields);
			if($arr_re["code"]!=0) {
				return $arr_re;
			}
		}
		return $arr_return;
	}
	/* 保存数据
	 * 
	 */
	function on_save() {
		$arr_return = array("code" => 0 , "id"=>0 , "msg" => cls_language::get("save_ok"));
		$id = (int)fun_get::post("id");
		$arr_comments = fun_get::get("category_comments" , array());
		$comments = implode("|" , $arr_comments);
		$arr_fields = array(
			"id"     => $id,
			"category_name" => fun_get::post("category_name"),
			"category_unit"   => fun_get::post("category_unit"),
			"category_sort"   => (int)fun_get::post("category_sort"),
			"category_pid"   => (int)fun_get::post("category_pid"),
			"category_pic"   => fun_get::post("category_pic"),
			"category_comments" => $comments,
			"category_wap_show"   => (int)fun_get::post("category_wap_show"),
		);
		$arr = tab_mall_goods_category::on_save($arr_fields);
		if($arr['code']==0) {
			if(isset($arr['id'])) $arr_return['id'] = $arr['id'];
		} else {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	//取指定id，分类所有属性
	function get_attribute_list($id) {
		$obj_db = cls_obj::db();
		$arr = array();
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "mall_goods_category_attribute where attribute_category_id='" . $id . "'");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr[] = $obj_rs;
		}
		return $arr;
	}
	//取指定id，分类所有品牌
	function get_brand_list($id) {
		$obj_db = cls_obj::db();
		$arr = array();
		$obj_result = $obj_db->select("select a.*,b.brand_name,b.brand_pic from " . cls_config::DB_PRE . "mall_goods_category_brand a left join " . cls_config::DB_PRE . "mall_brand b on a.brand_id=b.brand_id where brand_category_id='" . $id . "'");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr[] = $obj_rs;
		}
		return $arr;
	}
	function on_brand_save() {
		$arr['brand_id'] = (int)fun_get::get("brand_id");
		$arr['brand_category_id'] = (int)fun_get::get("category_id");
		$arr_msg = tab_mall_goods_category_brand::on_save($arr);
		return $arr_msg;
	}
	//取指定id，分类所有属性
	function get_attribute_edit($id) {
		$obj_rs = cls_obj::db()->edit(cls_config::DB_PRE."mall_goods_category_attribute" , "attribute_id='".$id."'");
		return $obj_rs;
	}
	//取指定id，分类
	function get_edit($id) {
		$obj_rs = cls_obj::db()->edit(cls_config::DB_PRE."mall_goods_category" , "category_id='".$id."'");
		if(!empty($obj_rs)) {
			$obj_rs['comments'] = explode("|" , $obj_rs["category_comments"]);
		} else {
			$obj_rs['comments'] = array();
		}
		return $obj_rs;
	}
	/* 保存属性数据
	 * 
	 */
	function on_attribute_save() {
		$arr_return = array("code" => 0 , "id"=>0 , "msg" => cls_language::get("save_ok"));
		$arr_fields = array(
			"attribute_id"=>fun_get::post("id"),
			"attribute_name"=>fun_get::post("attribute_name"),
			"attribute_type"=>fun_get::post("attribute_type"),
			"attribute_val"=>fun_get::post("attribute_val"),
			"attribute_default"=>fun_get::post("attribute_default"),
			"attribute_category_id"=>(int)fun_get::post("url_category_id"),
		);
		$arr = tab_mall_goods_category_attribute::on_save($arr_fields);
		if($arr['code']==0) {
			if(isset($arr['id'])) $arr_return['id'] = $arr['id'];
		} else {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	/* 删除指定  id 数据
	 */
	function on_attribute_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		$arr = tab_mall_goods_category_attribute::on_delete($str_id);
		if($arr['code'] != 0) {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	function get_path($pid , $topid=-1) {
		$arr_return = array();
		if($pid == $topid) return $arr_return;
		$str_sql="select category_id,category_name,category_pid from " . cls_config::DB_PRE . "mall_goods_category where category_id='".$pid."'";
		$obj_result = cls_obj::db()->query($str_sql);
		if($obj_rs = cls_obj::db()->fetch_array($obj_result))	{
			$arr_return[] = $obj_rs;
			$arr = $this->get_path($obj_rs['category_pid'] , $topid);
			if(count($arr)>0) {
				$arr_return = array_merge($arr , $arr_return);
			}
		}
		return $arr_return;
	}
	function on_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		$arr = tab_mall_goods_category::on_delete($str_id);
		if($arr['code'] != 0) {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}

}