<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_mall_goods_comment extends inc_mod_mall {
	/* 按模块查询菜单信息并返回数组列表
	 * module : 指定查询模块
	 */
	function get_pagelist() {
		$arr_where = array();
		$arr_where_s = array();
		$str_where = '';
		$lng_issearch = 0;
		//取查询参数
		$arr_search_key = array(
			'addtime1' => fun_get::get("s_time1"),
			'addtime2' => fun_get::get("s_time2"),
			'gid' => fun_get::get("s_gid"),
			'oid' => (int)fun_get::get("s_oid"),
			'uid' => (int)fun_get::get("s_uid"),
		);
		if( fun_is::isdate( $arr_search_key['addtime1'] ) ) $arr_where_s[] = "comment_addtime >= '" . strtotime( $arr_search_key['addtime1'] ) . "'"; 
		if( fun_is::isdate( $arr_search_key['addtime2'] ) ) $arr_where_s[] = "comment_addtime <= '" . fun_get::endtime($arr_search_key['addtime2']) . "'"; 
		if( !empty( $arr_search_key['gid'] ) ) {
			$arr = explode("-",$arr_search_key['gid']);
			$arr_where_s[] = "comment_goods_id='" . (int)$arr[0] . "'"; 
			if(count($arr)>1) $arr_where_s[] = "comment_goods_detail_id='" . (int)$arr[1] . "'";
		}
		if( !empty( $arr_search_key['oid'] ) ) $arr_where_s[] = "comment_order_id='" . $arr_search_key['oid'] . "'";
		if( !empty( $arr_search_key['uid'] ) ) $arr_where_s[] = "comment_user_id='" . $arr_search_key['uid'] . "'";
		//合并查询数组
		$arr_where = array_merge($arr_where , $arr_where_s);
		if(count($arr_where)>0) $str_where = " where " . implode(" and " , $arr_where);
		$arr_return = $this->sql_list($str_where , (int)fun_get::get('page'));

		if( count($arr_where_s) > 0 ) $lng_issearch = 1;
		$arr_return['issearch'] = $lng_issearch;

		return $arr_return;
	}


	/* 实现按具体条件查询数据表，并返回分页信息
	 * str_where : sql 查询条件 , lng_page : 当前页
	 */
	function sql_list($str_where = "" , $lng_page = 1) {
		$arr_return = array("list" => array());
		$obj_db = cls_obj::db();
		//取排序字段
		$arr_config_info = tab_sys_user_config::get_info("mall.goods.comment"  , $this->app_dir);
		$lng_pagesize = $arr_config_info["pagesize"];
		//取分页信息
		$sort = " order by comment_id desc";
		$arr_return["list"] = $arr_uid = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_goods_comment" , $str_where , $lng_page , $lng_pagesize);
		$obj_result = $obj_db->select("SELECT * FROM ".cls_config::DB_PRE."mall_goods_comment" . $str_where . $sort . $arr_return['pageinfo']['limit']);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			$obj_rs['goods'] = empty($obj_rs['comment_goods']) ? array() : unserialize($obj_rs['comment_goods']);
			$obj_rs['comment_pic'] = empty($obj_rs['comment_pic']) ? array() : explode("|" , $obj_rs['comment_pic']);
			$obj_rs['comment_addtime'] = date("Y-m-d H:i:s" , $obj_rs['comment_addtime']);
			$obj_rs['user_name'] = '';
			$arr_uid[] = $obj_rs['comment_user_id'];
			$obj_rs['comment_list'] = tab_mall_goods_comment::on_deformat($obj_rs['comment_list']);
			$arr_return["list"][] = $obj_rs;
		}
		if(count($arr_uid)>0) {
			$user_info = cls_obj::get("cls_user")->get_user($arr_uid);
			$count = count($arr_return["list"]);
			for($i = 0 ; $i < $count ; $i++) {
				$arr_return["list"][$i]['user_name'] = array_search($arr_return["list"][$i]['comment_user_id'] , $user_info);
			}
		}
		$arr_return['pagebtns']   = $this->get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}

	/* 删除指定  shop_id 数据
	 */
	function on_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		$arr = tab_mall_goods_comment::on_delete($str_id);
		if($arr['code'] != 0) {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	function get_comment_detail($id) {
		$arr_cid = $arr_gid = $arr_pids = $arr_goods = array();
		$obj_order['commented'] = array();
		$obj_order = cls_obj::db()->get_one("select a.*,b.order_detail from " . cls_config::DB_PRE . "mall_goods_comment a left join " . cls_config::DB_PRE . "mall_order b on a.comment_order_id=b.order_id where comment_id='" . $id . "'");
		$obj_order['comment_list'] = tab_mall_goods_comment::on_deformat($obj_order['comment_list']);
		$obj_order['comment_pic'] = empty($obj_order['comment_pic'] ) ? array() : explode("|" , $obj_order['comment_pic']);
		$obj_order['order_detail'] = unserialize($obj_order['order_detail']);
		if($obj_order['comment_goods_detail_id']>0) {
			$obj_order['gid'] = $obj_order['comment_goods_id'] . "-" . $obj_order['comment_goods_detail_id'];
		} else {
			$obj_order['gid'] = $obj_order['comment_goods_id'];
		}
		foreach($obj_order['order_detail']['goods'] as $goods) {
			$arr = explode("-" , $goods['id']);
			$arr_gid[] = $arr[0];
			$goods['gid'] = $arr[0];
			$arr_goods[] = $goods;
		}
		$obj_order['order_detail']['goods'] = $arr_goods;
		$ids = implode("," , $arr_gid);
		$obj_result = cls_obj::db()->select("select goods_id,goods_category_id,category_pids,category_comments from " . cls_config::DB_PRE . "mall_goods a inner join " . cls_config::DB_PRE . "mall_goods_category b on a.goods_category_id=b.category_id where goods_id in(" . $ids . ")");

		while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
			$arr_cid[] = array('gid' => $obj_rs['goods_id'] , 'cid' => $obj_rs['goods_category_id'] , 'pids' => $obj_rs['category_pids'] , 'comments' => $obj_rs['category_comments'] );
			if(!empty($obj_rs['category_pids'])) $arr_pids[] = $obj_rs['category_pids'];
		}
		if(!empty($arr_pids)) {
			$ids = implode("," , $arr_pids);
			$obj_result = cls_obj::db()->select("select category_id,category_comments from " . cls_config::DB_PRE . "mall_goods_category where category_id in(" . $ids . ")");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				if(empty($obj_rs['category_comments'])) continue;
				$arr_category['id_' . $obj_rs['category_id']] = $obj_rs;
			}
		}
		$obj_order['comments'] = array();
		foreach($arr_cid as $item) {
			$arr = explode("," , $item['pids']);
			$arr_comments = array();
			if(!empty($item['comments'])) $arr_comments[] = $item['comments'];
			foreach($arr as $item2) {
				if(isset($arr_category['id_' . $item2])) $arr_comments[] = $arr_category['id_' . $item2]['category_comments'];
			}
			$comments = implode("|" , $arr_comments);
			$arritem = explode("|" , $comments);
			$obj_order['comments']['id_' . $item['gid']] = array();
			foreach($arritem as $item2) {
				if(!in_array($item2 , $obj_order['comments']['id_' . $item['gid']]) ) $obj_order['comments']['id_' . $item['gid']][] = $item2;
			}
		}
		return $obj_order;
	}

	function order_comment_save() {
		$arr_return = array("code" => 0 , "msg" => "保存成功");
		$arr_pic = fun_get::get('pic',array());
		$pic = implode("|" , $arr_pic);
		$commentname = fun_get::get("commentname");
		$arr_comment = array();
		if(!empty($commentname) && is_array($commentname)) {
			foreach($commentname as $item) {
				$val = fun_get::get("comment".$item);
				if(empty($val)) continue;
				$arr_comment[] = $item . "=>" . $val;
			}
		}
		$arr_fields = array(
			'comment_id' => (int)fun_get::get('id'),
			'comment_beta' => fun_get::get('beta'),
			'comment_pic' => $pic,
			'comment_val' => (int)fun_get::get('commentval'),
			'comment_list' => implode("|" , $arr_comment),
		);
		if(empty($arr_fields['comment_id'])) return array('code' => 500 , 'msg' => '评论不存在');
		$arr = tab_mall_goods_comment::on_save($arr_fields);
		if($arr['code'] != 0 ) $arr_return = $arr;
		return $arr_return;
	}
	function on_recont() {
		$id = (int)fun_get::get("id");
		$cont = fun_get::get("cont");
		$arr = cls_obj::db_w()->on_update(cls_config::DB_PRE . "mall_goods_comment" , array("comment_recont" => $cont , "comment_re_time" => TIME , "comment_re_uid" => cls_obj::get("cls_user")->uid) , "comment_id=" . $id);
		$arr['id'] = $id;
		return $arr;
	}

}