<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_mall_goods extends inc_mod_mall {
	/* 按模块查询菜单信息并返回数组列表
	 * module : 指定查询模块
	 */
	function get_pagelist() {
		$arr_where = array();
		$arr_where_s = array();
		$str_where = '';
		$lng_issearch = 0;
		//取查询参数
		$arr_search_key = array(
			'addtime1' => fun_get::get("s_addtime1"),
			'addtime2' => fun_get::get("s_addtime2"),
			'key' => fun_get::get("s_key"),
			'price1' => (int)fun_get::get("s_price1"),
			'price2' => (int)fun_get::get("s_price2"),
			'category_id' => (int)fun_get::get("s_category_id"),
		);
		if( fun_is::isdate( $arr_search_key['addtime1'] ) ) $arr_where_s[] = "goods_addtime >= '" . strtotime( $arr_search_key['addtime1'] ) . "'"; 
		if( fun_is::isdate( $arr_search_key['addtime2'] ) ) $arr_where_s[] = "goods_addtime <= '" . fun_get::endtime($arr_search_key['addtime2']) . "'"; 
		if( $arr_search_key['price1'] > 0 ) $arr_where_s[] = "goods_price>='" . $arr_search_key['price1'] . "'"; 
		if( $arr_search_key['price2'] > 0 ) $arr_where_s[] = "goods_price<='" . $arr_search_key['price2'] . "'"; 
		if( $arr_search_key['key'] != '' ) $arr_where_s[] = "(goods_name like '%" . $arr_search_key['key'] . "%')";
		if( !empty($arr_search_key['category_id']) ) {
			$arr = array();
			$obj_result = cls_obj::db()->select("select category_id from " . cls_config::DB_PRE . "mall_goods_category where " . cls_obj::db()->concat(",","category_pids",",") . " like '%," . $arr_search_key['category_id'] . "%'");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				$arr[] = $obj_rs['category_id'];
			}
			if(empty($arr)) {
				$arr_where_s[] = "goods_category_id='" . $arr_search_key['category_id'] . "'"; 
			} else {
				$arr[] = $arr_search_key['category_id'];
				$ids = implode("," , $arr);
				$arr_where_s[] = "goods_category_id in(" . $ids . ")"; 
			}
		}
		//店铺
		if($this->admin_shop['id']>0) $arr_where[] = "goods_shop_id='" . $this->admin_shop['id'] . "'";
		//合并查询数组
		$arr_where = array_merge($arr_where , $arr_where_s);
		if(count($arr_where)>0) $str_where = " where " . implode(" and " , $arr_where);
		$arr_return = $this->sql_list($str_where , (int)fun_get::get('page'));

		if( count($arr_where_s) > 0 ) $lng_issearch = 1;
		$arr_return['issearch'] = $lng_issearch;

		return $arr_return;
	}


	/* 实现按具体条件查询数据表，并返回分页信息
	 * str_where : sql 查询条件 , lng_page : 当前页
	 */
	function sql_list($str_where = "" , $lng_page = 1) {
		$arr_return = array("list" => array());
		$obj_db = cls_obj::db();
		$arr_type = tab_mall_goods::get_perms("type");
		//取字段信息
		$arr_cfg_fields = tab_sys_user_config::get_fields("mall.goods" , $this->app_dir , "mall");
		$arr_return['tabtd'] = $arr_cfg_fields["tabtd"];
		$arr_return['tabtit'] = $arr_cfg_fields["tabtit"];
		//取排序字段
		$arr_config_info = tab_sys_user_config::get_info("mall.goods"  , $this->app_dir);
		$sort = $arr_config_info["sortby"];
		$lng_pagesize = $arr_config_info["pagesize"];
		$arr_return["sort"] = $arr_config_info["sort"];
		$arr_state = tab_mall_goods::get_perms("state");
		//取分页信息
		$arr_return["list"] = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_goods" , $str_where , $lng_page , $lng_pagesize);
		$obj_result = $obj_db->select("SELECT " . $arr_cfg_fields["sel"] . " FROM ".cls_config::DB_PRE."mall_goods" . $str_where . $sort . $arr_return['pageinfo']['limit']);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			if(isset($obj_rs["goods_state"])) $obj_rs["goods_state"] = array_search($obj_rs["goods_state"] , $arr_state);
			if(isset($obj_rs["goods_addtime"])) $obj_rs["goods_addtime"] = date("Y-m-d H:i:s" , $obj_rs["goods_addtime"]);
			if(isset($obj_rs["goods_updatetime"])) $obj_rs["goods_updatetime"] = date("Y-m-d H:i:s" , $obj_rs["goods_updatetime"]);
			$arr_return["list"][] = $obj_rs;
		}
		$arr_return['pagebtns']   = $this->get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}

	/* 查询配置表指定id信息
	 * msg_id : sys_config 表中 config_id
	 */
	function get_editinfo($msg_id) {
		$obj_db = cls_obj::db();
		$get_url_type = fun_get::get("url_type");
		$obj_editinfo = $obj_db->edit(cls_config::DB_PRE."mall_goods" , "goods_id='".$msg_id."'");
		$obj_goods_ext = $obj_db->edit(cls_config::DB_PRE."mall_goods_ext" , "ext_goods_id='".$msg_id."'");
		$obj_editinfo = array_merge($obj_editinfo , $obj_goods_ext);
		$obj_editinfo["goods_store"] = $obj_editinfo["goods_store"] - $obj_editinfo["goods_sold"];
		$obj_editinfo["category_path"] = '';
		$obj_editinfo["format_list"] = '[]';
		$obj_editinfo["attribute_list"] = array();
		$obj_editinfo["attribute_name"] = '';
		$obj_editinfo['brand_name'] = '';
		$obj_editinfo["shop_name"] = '';
		$obj_editinfo["attribute_val"] = array();
		$obj_editinfo["price"] = '';
		$obj_editinfo['postage_areas'] = array();
		$obj_editinfo['postage_mode'] = 0;
		if( empty($obj_editinfo["goods_id"]) ) {
			$obj_editinfo["goods_state"] = 1;
			$obj_editinfo["format"] = array();
		} else {
			//计算库存
			if(!empty($obj_goods_ext['goods_sold'])) {
				$obj_editinfo['goods_store'] = $obj_editinfo['goods_store'] - $obj_goods_ext['goods_sold'];
			}
			//默认价格
			$obj_editinfo['price'] = $obj_editinfo['goods_price'] . "|" . $obj_editinfo['goods_price_market'] . "|" . $obj_editinfo['goods_price_cost'];
			if(!empty($obj_editinfo['goods_price_vip'])) $obj_editinfo['price'] .= "|" . $obj_editinfo['goods_price_vip'];
			$obj_editinfo["format"] = empty($obj_editinfo["goods_format"]) ? array() : unserialize($obj_editinfo["goods_format"]);
			//取规格值列表
			$arr_ids = $arr_format_list = array();
			foreach($obj_editinfo['format'] as $item) {
				$arr_ids[] = $item['id'];
			}
			$str_ids = implode("," , $arr_ids);
			if(!empty($str_ids)) {
				$obj_result = cls_obj::db()->select('select format_id,format_name,format_val from ' . cls_config::DB_PRE . 'mall_goods_format where format_id in (' . $str_ids . ')');
				while($obj_format = cls_obj::db()->fetch_array($obj_result)) {
					$arr_format_list[] = array("id"=>$obj_format["format_id"] , "name"=>$obj_format["format_name"] , "list"=>unserialize($obj_format["format_val"]));
				}
			}
			if(count($arr_format_list)>0) $obj_editinfo['format_list'] = fun_format::json($arr_format_list);
			//取分类名称
			$arr_path = array();
			$obj_val = $obj_db->get_one("select category_id,category_pids,category_name from " . cls_config::DB_PRE . "mall_goods_category where category_id='" . $obj_editinfo['goods_category_id'] . "'");
			if(!empty($obj_val)) {
				$obj_result = $obj_db->select("select category_name,category_id from " . cls_config::DB_PRE . "mall_goods_category where category_id in(" . $obj_val['category_pids'] . ") order by category_depth");
				while($obj_rs = $obj_db->fetch_array($obj_result)) {
					$arr_path[] = $obj_rs["category_name"];
				}
				$arr_path[] = $obj_val["category_name"];
			}
			$obj_editinfo["category_path"] = implode("->" , $arr_path);
			//分类所有属性
			if(!empty($obj_editinfo['goods_category_id'])) {
				$arr_x = array();
				$arr = tab_mall_goods_category::get_attribute($obj_editinfo['goods_category_id']);
				$obj_editinfo['attribute_list'] = $arr['list'];
				foreach($obj_editinfo['attribute_list'] as $item) {
					$arr_x[] = $item['name'];
				}
				$obj_editinfo['attribute_name'] = implode("|" , $arr_x);
			}
			//当前分类属性
			$arr = explode("|" , $obj_editinfo["goods_category_attribute"]);
			foreach($arr as $item) {
				$arr_x = explode("=>" , $item);
				$obj_editinfo["attribute_val"][$arr_x[0]][] = $arr_x[1];
			}
		}
		if(!empty($obj_editinfo['goods_brand_id'])) {
			$obj_brand = cls_obj::db()->get_one("select brand_name from " . cls_config::DB_PRE . "mall_brand where brand_id='".$obj_editinfo["goods_brand_id"]."'");
			if(!empty($obj_brand)) $obj_editinfo["brand_name"] = $obj_brand["brand_name"];
		}
		if(!empty($obj_editinfo['goods_shop_id'])) {
			$obj_shop = cls_obj::db()->get_one("select shop_name from " . cls_config::DB_PRE . "mall_shop where shop_id='".$obj_editinfo["goods_shop_id"]."'");
			if(!empty($obj_shop)) $obj_editinfo["shop_name"] = $obj_shop["shop_name"];
		}
		$arr_postage = tab_mall_goods::format_postage($obj_editinfo['goods_postage_areas']);
		if(!empty($arr_postage['ids'])) {
			$arr_names = array();
			$ids = implode("," , $arr_postage['ids']);
			if(empty($ids)) $ids = '0';
			$obj_result = cls_obj::db()->select("select area_name,area_id from " . cls_config::DB_PRE . "sys_area where area_id in(" . $ids . ")");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				if(!isset($arr_postage['id_' . $obj_rs['area_id']])) continue;
				$arr_names[] = array('name' => $obj_rs['area_name'] , 'id' => $obj_rs['area_id'] , 'postage' => $arr_postage['id_' . $obj_rs['area_id']]);
			}
			$obj_editinfo['postage_areas'] = $arr_names;
			$obj_editinfo['postage_mode'] = $arr_postage['mode'];
		}
		return $obj_editinfo;
	}
	/* 保存数据
	 * vip定价格格式：vip_id=价格|vip_id=价格 如果价格中有%表示按折扣
	 */
	function on_save() {
		$arr_return = array("code" => 0 , "id"=>0 , "msg" => cls_language::get("save_ok"));
		$price_val = fun_get::post("goods_price");
		if(empty($price_val)) $price_val = fun_get::post("price_val");
		$arr = explode("|" , $price_val);
		$goods_price = $goods_price_market = $goods_price_cost = 0;
		$goods_price_vip = '';
		if(count($arr)>1) {
			$goods_price = $arr[0];//售价
			$goods_price_market = $arr[1];//市场价
			$goods_price_cost = $arr[2];//成本价
			$arr = array_slice($arr , 3);
			$goods_price_vip = implode("|" , $arr);
		}
		//规格列信息
		$goods_format = fun_get::post("goods_format");
		$arr_format_info = $arr_format_id = $arr_format = array();
		$arr = explode("||" , $goods_format);
		$format_ispicid = fun_get::post("format_ispicid");
		foreach($arr as $item) {
			$arr_x = explode("|" , $item);
			if(count($arr_x)>1) {
				$arr_format_info["id_" . $arr_x[0]] = fun_get::post("format_val_" . $arr_x[0]);
				$arr_format_id[] = $arr_x[0];
				$ispic = ($format_ispicid == $arr_x[0]) ? 1 : 0;
				$arr_format[] = array("id"=>$arr_x[0] , "name"=>$arr_x[1] , 'ispic' => $ispic);
			}
		}
		//取库存
		if(count($arr_format)>0) {
			$goods_store = (int)fun_get::post("store")+(int)fun_get::get("goods_sold");
		} else {
			$goods_store = (int)fun_get::post("goods_store")+(int)fun_get::get("goods_sold");
		}
		//获取属性值
		$arr_attribute = array();
		$arr = explode("|" , fun_get::post("attribute_name"));
		foreach($arr as $item) {
			$arr_x = fun_get::post($item);
			if(is_array($arr_x)) {
				foreach($arr_x as $val) {
					$arr_attribute[] = $item . tab_mall_goods::get_perms("sp2") . $val;
				}
			} else {
				$arr_attribute[] = $item . tab_mall_goods::get_perms("sp2") . $arr_x;
			}
		}
		//取邮费地区
		$arr_postageid = fun_get::post("postageid");
		$arr_postageval = fun_get::post("postageval");
		$postagemode = (int)fun_get::post("postagemode");
		$postage_areas = '';
		if(!empty($arr_postageid) && count($arr_postageid) == count($arr_postageval)) {
			$arr_x = array();
			for($i = 0 ; $i < count($arr_postageid) ; $i++) {
				$arr_x[] = $arr_postageid[$i] . '=' . $arr_postageval[$i];
			}
			$postage_areas = implode("|" , $arr_x) . ">" . $postagemode;
		}
		$goods_id = (int)fun_get::post("id");
		$arr_fields = array(
			"id"     => $goods_id,
			"goods_name" => fun_get::post("goods_name"),
			"goods_category_id" => fun_get::post("goods_category_id"),
			"goods_number" => fun_get::post("goods_number"),
			"goods_store" => $goods_store,
			"goods_alarm" => fun_get::post("goods_alarm"),
			"goods_price" => $goods_price,
			"goods_price_vip" => $goods_price_vip,
			"goods_price_market" => $goods_price_market,
			"goods_intro"  => fun_get::post("goods_intro"),
			"goods_detail"  => fun_get::post("goods_detail"),
			"goods_pic"  => fun_get::post("goods_pic"),
			"goods_pic_small"  => fun_get::post("goods_pic_small"),
			"goods_state"  => fun_get::post("goods_state"),
			"goods_format"  => serialize($arr_format),
			"goods_category_attribute"  => implode("|" , ($arr_attribute)),
			"goods_weight" => (int)fun_get::post("goods_weight"),
			"goods_price_cost"  => $goods_price_cost,
			"goods_brand_id" => (int)fun_get::post("goods_brand_id"),
			"goods_sold" => (int)fun_get::post("goods_sold"),
			"goods_shop_id" => (int)fun_get::post("goods_shop_id"),
			"goods_postage_areas"  => $postage_areas,
		);
		//保存商品基本信息
		$arr_goods_return = tab_mall_goods::on_save($arr_fields);
		//$arr_goods_return = array("code"=>0 , "id"=>1);
		if($arr_goods_return['code']!=0) {
			$arr_return['code'] = $arr_goods_return['code'];
			$arr_return['msg']  = $arr_goods_return['msg'];
			return $arr_return;
		} else {
			$arr_return['id'] = $arr_goods_return['id'];
		}
		//保存详细货品
		$detail_id = fun_get::post("detail_id" , array());
		//清除已删除的详细货品
		$arr = array();
		foreach($detail_id as $item) {
			if(intval($item)>0) $arr[] = $item;
		}
		$where = "detail_goods_id='" . $arr_goods_return["id"] . "'";
		if(!empty($arr)) $where .= " and not detail_id in(" . implode("," , $arr) . ")";
		tab_mall_goods_detail::on_delete('' , $where);
		$detail_number = fun_get::post("detail_number" , array());
		$detail_price = fun_get::post("detail_price" , array());
		$detail_weight = fun_get::post("detail_weight" , array());
		$detail_position = fun_get::post("detail_position" , array());
		$detail_state = fun_get::post("detail_state" , array());
		$detail_pic = fun_get::post("detail_pic" , array());
		$detail_store = fun_get::post("detail_store" , array());
		$detail_sold = fun_get::post("detail_sold" , array());
		$count = count($detail_number);
		for($i = 0 ; $i < $count ; $i++) {
			//分析价格
			$arr = explode("|" , $detail_price[$i]);
			$goods_price = $goods_price_market = 0;
			$goods_price_vip = '';
			if(count($arr)>1) {
				$goods_price = $arr[0];//售价
				$goods_price_market = $arr[1];//市场价
				$arr = array_slice($arr , 2);
				$goods_price_vip = implode("|" , $arr);
			}
			//取当前规格值
			$arr_val = array();
			$arr_name = array();
			foreach($arr_format_id as $item) {
				if(isset($arr_format_info["id_" . $item]) && is_array($arr_format_info["id_" . $item]) && count($arr_format_info["id_" . $item])>=$i) {
					$arr = explode("|" , $arr_format_info["id_" . $item][$i]);
					if( count($arr)>1 ) {
						$arr_val["id_".$item]=array(
							"id"=>$item,
							"name"=>$arr[0],
							"pic"=>$arr[1]
						);
						$arr_name[] = $arr[0];
					}
				}

			}
			$arr_detail = array(
				"detail_id" => $detail_id[$i],
				"detail_goods_id" => $arr_goods_return["id"],
				"detail_number" => $detail_number[$i],
				"detail_price" => $goods_price,
				"detail_price_market" => $goods_price_market,
				"detail_price_vip" => $goods_price_vip,
				"detail_weight" => $detail_weight[$i],
				"detail_position" => $detail_position[$i],
				"detail_state" => $detail_state[$i],
				"detail_pic" => $detail_pic[$i],
				"detail_store" => (int)$detail_store[$i] + (int)$detail_sold[$i],
				"detail_format" => serialize($arr_val),
				"detail_name" => implode("、" , $arr_name)
			);
			$arr_detail_return = tab_mall_goods_detail::on_save($arr_detail);
		}
		//保存配件
		$parts_id = fun_get::get("parts_id" , array());
		$parts_name = fun_get::get("parts_name" , array());
		$parts_discount_type = fun_get::get("parts_discount_type" , array());
		$parts_discount = fun_get::get("parts_discount" , array());
		$parts_goods_ids = fun_get::get("parts_goods_ids" , array());
		$count = count($parts_id);
		for($i = 0 ; $i < $count ; $i++ ) {
			$arr_parts = array(
				"parts_id" => $parts_id[$i],
				"parts_name" => $parts_name[$i],
				"parts_discount_type" => $parts_discount_type[$i],
				"parts_discount" => $parts_discount[$i],
				"parts_format_ids" => $parts_goods_ids[$i],
				"parts_goods_id" => $arr_goods_return["id"],
			);
			$arr_parts_return = tab_mall_goods_parts::on_save($arr_parts);
		}
		//保存相册
		$pic1_url = fun_get::get("pic1_url" , array());
		$pic1_id = fun_get::get("pic1_id" , array());
		$pic1_sort = fun_get::get("pic1_sort" , array());
		$arr_id = array();
		foreach($pic1_id as $item) {
			if(empty($item)) continue;
			$arr_id[] = $item;
		}
		$ids = implode("," , $arr_id);
		if(!empty($ids)) cls_obj::db_w()->on_exe("delete from " . cls_config::DB_PRE . "mall_goods_pic where pic_goods_id='" . $goods_id . "' and pic_id not in(" . $ids . ")");
		for($i = 1 ; $i < count($pic1_id) ; $i++ ) {
			$arr_pic = array("pic_url" => $pic1_url[$i] , "pic_sort" => $pic1_sort[$i] , "pic_goods_id" => $arr_goods_return["id"]);
			if(empty($pic1_id[$i])) {
				cls_obj::db_w()->on_insert(cls_config::DB_PRE."mall_goods_pic", $arr_pic);
			} else {
				cls_obj::db_w()->on_update(cls_config::DB_PRE."mall_goods_pic", $arr_pic , "pic_id='" . $pic1_id[$i] . "'");
			}
		}
		return $arr_return;
	}

	/* 删除指定  shop_id 数据
	 */
	function on_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		$arr = tab_mall_goods::on_delete($str_id);
		if($arr['code'] != 0) {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	/* 指定商品id 货品列表 
	 *
	 */
	function get_detail_list($id) {
		$arr = array();
		$obj_result = cls_obj::db()->select("select * from " . cls_config::DB_PRE . "mall_goods_detail where detail_goods_id='" . $id . "'");
		while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
			$obj_rs["store"] = $obj_rs["detail_store"] - $obj_rs["detail_sold"];
			$obj_rs["price"] = $obj_rs["detail_price"] . "|" . $obj_rs["detail_price_market"] . "|" . $obj_rs["detail_price_vip"];
			if(!empty($obj_rs["detail_format"])) {
				$obj_rs["format"] = unserialize($obj_rs["detail_format"]);
			} else {
				$obj_rs["format"] = array("name"=>'' , 'pic'=>'' , "id"=>0);
			}
			$arr[] = $obj_rs;
		}
		return $arr;
	}
	/* 指定商品id 配件列表 
	 *
	 */
	function get_parts_list($id) {
		$arr = $arr_ids = $arr_goods = array();
		$obj_result = cls_obj::db()->select("select * from " . cls_config::DB_PRE . "mall_goods_parts where parts_goods_id='" . $id . "'");
		while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
			$obj_rs["goods"] = explode("," , $obj_rs["parts_format_ids"]);
			if(!empty($obj_rs["parts_format_ids"])) $arr_ids[] = $obj_rs["parts_format_ids"];
			$arr[] = $obj_rs;
		}
		//获取商品信息
		$str_ids = implode("," , $arr_ids);
		if(!empty($str_ids)) {
			$obj_result = cls_obj::db()->select("select goods_name,goods_id,detail_id,detail_name,detail_pic,goods_pic_small from " . cls_config::DB_PRE . "mall_goods a left join " . cls_config::DB_PRE . "mall_goods_detail b on a.goods_id=b.detail_goods_id where b.detail_id in(" . $str_ids . ")");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				$obj_rs["name"] = $obj_rs["goods_name"];
				if(!empty($obj_rs["detail_name"])) $obj_rs["name"] .= " " . $obj_rs["detail_name"];
				$obj_rs["pic"] = $obj_rs["detail_pic"];
				if(empty($obj_rs["pic"])) $obj_rs["pic"] = $obj_rs["goods_pic_small"];
				$arr_goods["id_" . $obj_rs["detail_id"]] = $obj_rs;
			}
		}
		$arr_return = array("parts"=>$arr , "goods"=>$arr_goods);
		return $arr_return;
	}
	//商品相册列表
	function get_pic_list($id) {
		if(empty($id)) return array();
		$arr_return = array();
		$obj_db = cls_obj::db();
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "mall_goods_pic where pic_goods_id='" . $id . "' order by pic_sort,pic_id");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr_return[] = $obj_rs;
		}
		return $arr_return;
	}
	function on_tj() {
		$arr_return = array('code' => 0 , 'msg' => '设置成功');
		$arr_id = fun_get::get("selid",array());
		$arrid = array();
		foreach($arr_id as $item) {
			$item = (int)$item;
			if($item>0) $arrid[] = $item;
		}
		if(empty($arrid)) return array("code" => 500 , "msg" => "请选择要推荐的商品");
		$arr_goods_tj = tab_mall_goods::get_perms("tj");
		$arr_fields = array();
		foreach($arr_goods_tj as $item=>$key) {
			$arr_fields['goods_tj'.$key] = (int)fun_get::get("tj_val".$key);
		}
		$ids = implode("," , $arrid);
		$arr = cls_obj::db_w()->on_update(cls_config::DB_PRE."mall_goods" , $arr_fields , "goods_id in(" . $ids . ")");
		if($arr['code'] != 0) $arr_return = $arr;
		return $arr_return;
	}
}