<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_mall_order extends inc_mod_mall {
	/* 按模块查询菜单信息并返回数组列表
	 * module : 指定查询模块
	 */
	function get_pagelist() {
		$arr_where = array();
		$arr_where_s = array();
		$str_where = '';
		$lng_issearch = 0;
		//取查询参数
		$arr_search_key = array(
			'addtime1' => fun_get::get("s_addtime1"),
			'addtime2' => fun_get::get("s_addtime2"),
			'user_id' => (int)fun_get::get("s_user_id"),
			'state' => (int)fun_get::get("url_state" , -999),
			'key' => fun_get::get("s_key"),
		);
		if( fun_is::isdate( $arr_search_key['addtime1'] ) ) $arr_where_s[] = "order_datetime >= '" . $arr_search_key['addtime1'] . "'"; 
		if( fun_is::isdate( $arr_search_key['addtime2'] ) ) $arr_where_s[] = "order_datetime <= '" . date("Y-m-d H:i:s" , fun_get::endtime($arr_search_key['addtime2'])) . "'"; 
		if( $arr_search_key['state'] != -999 ) $arr_where_s[] = "order_state = '" . $arr_search_key['state'] . "'"; 
		if( $arr_search_key['user_id'] != 0 ) $arr_where_s[] = "order_user_id = '" . $arr_search_key['user_id'] . "'"; 
		if( $arr_search_key['key'] != '' ) $arr_where_s[] = "(order_name like '%" . $arr_search_key['key'] . "%' or order_tel like '%" . $arr_search_key['key'] . "%' or order_mobile like '%" . $arr_search_key['key'] . "%')";
		//合并查询数组
		$arr_where = array_merge($arr_where , $arr_where_s);
		if(count($arr_where)>0) $str_where = " where " . implode(" and " , $arr_where);
		$arr_return = $this->sql_list($str_where , (int)fun_get::get('page'));

		if( count($arr_where_s) > 0 ) $lng_issearch = 1;
		$arr_return['issearch'] = $lng_issearch;
		return $arr_return;
	}


	/* 实现按具体条件查询数据表，并返回分页信息
	 * str_where : sql 查询条件 , lng_page : 当前页
	 */
	function sql_list($str_where = "" , $lng_page = 1) {
		$arr_return = array("list" => array());
		$obj_db = cls_obj::db();
		//取字段信息
		$arr_cfg_fields = tab_sys_user_config::get_fields("mall.order" , $this->app_dir , "mall");
		$arr_cfg_fields["sel"] = substr(str_replace(",user_name," , "," , "," . $arr_cfg_fields["sel"] . ","),1,-1);
		$arr_return['tabtd'] = $arr_cfg_fields["tabtd"];
		$arr_return['tabtit'] = $arr_cfg_fields["tabtit"];
		//取排序字段
		$arr_config_info = tab_sys_user_config::get_info("mall.order"  , $this->app_dir);
		$sort = $arr_config_info["sortby"];
		$arr_return["sort"] = $arr_config_info["sort"];
		$lng_pagesize = $arr_config_info["pagesize"];
		$arr_state = tab_mall_order::get_perms("state");
		$arr_award = tab_mall_order::get_perms("award");
		//取分页信息
		$arr_uid = array();
		$arr_return["list"] = $arr_areaid = $arr_act_id = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_order" , $str_where , $lng_page , $lng_pagesize);
		$obj_result = $obj_db->select("SELECT " . $arr_cfg_fields["sel"] . " FROM ".cls_config::DB_PRE."mall_order" . $str_where . $sort . $arr_return['pageinfo']['limit']);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			if(isset($obj_rs["order_state"])) {
				$obj_rs['state'] = $obj_rs['order_state'];
				if($obj_rs["order_state"]>0) {
					$obj_rs["order_state"] = array_search($obj_rs["order_state"] , $arr_state);
				} else {
					$obj_rs["order_state"] = "<font color='#ff0000'>" . array_search($obj_rs["order_state"] , $arr_state) . "</font>";
				}
			}
			if(isset($obj_rs['order_pay_val']) && isset($obj_rs['order_total_pay']) ) {
				$obj_rs['order_total_pay'] = $obj_rs['order_total_pay'] - $obj_rs['order_pay_val'];
				if($obj_rs['order_total_pay']==0) $obj_rs['order_total_pay'] = "0.00";
			}
			$arr_uid[] = $obj_rs['order_user_id'];
			$arr_return["list"][] = $obj_rs;
		}
		if(count($arr_uid)>0) {
			$user_info = cls_obj::get("cls_user")->get_user($arr_uid);
			$count = count($arr_return["list"]);
			for($i = 0 ; $i < $count ; $i++) {
				$arr_return["list"][$i]['user_name'] = array_search($arr_return["list"][$i]['order_user_id'] , $user_info);
			}
		}

		$arr_return['pagebtns']   = $this->get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}

	/* 删除指定  order_id 数据
	 */
	function on_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		$arr = tab_mall_order::on_delete($str_id);
		if($arr['code'] != 0) {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
	/* 批量取消订单
	 */
	function on_cancel() {
		$id = (int)fun_get::get("id");
		$arr_return = array("code"=>0 , "msg"=> "处理成功" , "id" => $id);
		$beta = fun_get::get("beta");
		$arr = tab_mall_order::on_cancel($id , $beta);
		$arr['id'] = $id;
		if($arr['code'] != 0) return $arr;
		return $arr_return;
	}
	/* 发货
	 */
	function on_send() {
		$id = (int)fun_get::get("id");
		$arr_return = array("code"=>0 , "msg"=> "处理成功" , "id" => $id);
		$beta = fun_get::get("beta");
		$arr = tab_mall_order::on_send($id , $beta);
		$arr['id'] = $id;
		if($arr['code'] != 0) return $arr;
		return $arr_return;
	}
	function get_detail($id) {
		$obj_db = cls_obj::db();
		$obj_order = $obj_db->edit(cls_config::DB_PRE."mall_order" , "order_id='" . $id . "'");
		$obj_order['number'] = tab_mall_order::get_number($obj_order['order_id'],$obj_order['order_user_id'],$obj_order['order_datetime']);
		$obj_sendinfo = $obj_db->get_one("select sendinfo_name from " . cls_config::DB_PRE . "mall_sendinfo where sendinfo_id='" . $obj_order['order_sendinfo_id'] . "'");
		$obj_order['sendinfo_name'] = (!empty($obj_sendinfo)) ? $obj_sendinfo['sendinfo_name'] : '';
		$arr_paymethod = tab_mall_order::get_perms("paymethod");
		$obj_order['paymethod'] = (isset($arr_paymethod[$obj_order['order_pay_method']])) ? $arr_paymethod[$obj_order['order_pay_method']] : '';
		$order_detail = (empty($obj_order['order_detail'])) ? array() : unserialize($obj_order['order_detail']);
		$obj_order['goods'] = (isset($order_detail['goods'])) ? $order_detail['goods'] : array();
		return $obj_order;
	}

	function on_editprice() {
		$sendprice = (float)fun_get::get('sendprice');
		$favorable = (float)fun_get::get('favorable');
		$id = (int)fun_get::get("id");
		$obj_rs = cls_obj::db()->get_one("select * from " . cls_config::DB_PRE . "mall_order where order_id='" . $id . "'");
		if(empty($obj_rs)) return array("code" => 500 , "msg" => "订单不存在");
		if($obj_rs['order_state'] != 0) return array("code" => 500 , "msg" => "只有待付款的订单能调整价格");
		$arr_fields = array();
		if($sendprice != 0) {
			$arr_fields['order_sendprice'] = $obj_rs['order_sendprice'] + $sendprice;
			$obj_rs['order_sendprice'] = $arr_fields['order_sendprice'];
			if($arr_fields['order_sendprice']<0) return array("code" => 500 , "msg" => "运费不能小于0");
		}
		if($favorable != 0) {
			$arr_fields['order_favorable'] = $obj_rs['order_favorable'] + $favorable;
			$obj_rs['order_favorable'] = $arr_fields['order_favorable'];
			if($arr_fields['order_favorable']<0) return array("code" => 500 , "msg" => "优惠不能小于0");
		}
		if(!empty($arr_fields)) {
			$arr_fields['order_total_pay'] = $obj_rs['order_total_goods'] + $obj_rs['order_sendprice'] - $obj_rs['order_favorable'] - $obj_rs['order_repay'];
			if($arr_fields['order_total_pay']<0) return array("code" => 500 , "msg" => "应付款不能小于0");
			$arr_fields['order_id'] = $id;
			$arr = tab_mall_order::on_save($arr_fields);
			return $arr;
		} else {
			return array('code' => 500 , 'msg' => '没有设置要改动的价格');
		}

	}
}