<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_mall_vip extends inc_mod_mall {

	/* 实现按具体条件查询数据表，并返回分页信息
	 * 
	 */
	function sql_list() {
		$arr_return = array("list" => array());
		$str_where = "";
		$obj_db = cls_obj::db();
		//取字段信息
		$arr_cfg_fields = tab_sys_user_config::get_fields("mall.vip" , $this->app_dir , "mall");
		$arr_return['tabtd'] = $arr_cfg_fields["tabtd"];
		$arr_return['tabtit'] = $arr_cfg_fields["tabtit"];
		//取排序字段
		$arr_config_info = tab_sys_user_config::get_info("mall.vip"  , $this->app_dir);
		$sort = $arr_config_info["sortby"];
		$arr_return["sort"] = $arr_config_info["sort"];
		//取分页信息
		$arr_return["list"] = array();
		$obj_result = $obj_db->select("SELECT " . $arr_cfg_fields["sel"] . " FROM ".cls_config::DB_PRE."mall_vip" . $str_where . $sort);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			$arr_return["list"][] = $obj_rs;
		}
		return $arr_return;
	}
	/* 保存数据
	 * 
	 */
	function on_save() {
		$arr_return = array("code" => 0 ,"id"=>0 , "msg" => cls_language::get("save_ok"));
		$arr_vip_id = fun_get::get("vip_id");
		if(fun_is::set("vip_name")) $arr_vip_name = fun_get::get("vip_name");
		if(fun_is::set("vip_experience")) $arr_vip_experience = fun_get::get("vip_experience");
		if(fun_is::set("vip_discount")) $arr_vip_discount = fun_get::get("vip_discount");
		$arr_resave = array();
		$lng_count = count($arr_vip_id);

		//循环统计已有 id
		$arr_id = array();
		for( $i = 1 ; $i < $lng_count ; $i++) {
			$lng_id = (int)$arr_vip_id[$i];
			if($lng_id > 0) $arr_id[] = $lng_id;
		}
		$str_ids = fun_format::arr_id($arr_id);
		$str_where = '';
		if( !empty($str_ids) ) {
			$str_where = "vip_id not in(".$str_ids.")";
		}
		//首先删除没在保存id中的所有记录
		tab_mall_vip::on_delete(array(),$str_where);
		for( $i = 1 ; $i < $lng_count ; $i++) {
			$arr_fields = array(
				"vip_id" => (int)$arr_vip_id[$i],
			);
			if(isset($arr_vip_name)) $arr_fields["vip_name"] = $arr_vip_name[$i];
			if(isset($arr_vip_experience)) $arr_fields["vip_experience"] = $arr_vip_experience[$i];
			if(isset($arr_vip_discount)) $arr_fields["vip_discount"] = $arr_vip_discount[$i];
			$arr = tab_mall_vip::on_save($arr_fields);
			if($arr["code"] != 0) {
				$arr_return['code'] = $arr["code"];
				$arr_return['msg'] = $arr["msg"];
				return $arr_return;
			}
		}
		return $arr_return;
	}
	/* 删除指定  area_id 数据
	 */
	function on_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		$arr = tab_mall_vip::on_delete($str_id);
		if($arr['code'] != 0) {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}
}