<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_mall_sendinfo extends inc_mod_admin {
	/* 按模块查询用户信息并返回数组列表
	 * module : 指定查询模块
	 * isdel : 是否为回收站 , 1:是，0:非
	 */
	function get_pagelist($is_del = 0) {
		$arr_where = array();
		$arr_where_s = array();
		$str_where = '';
		$lng_issearch = 0;
		//取查询参数
		$arr_search_key = array(
			'state' => (int)fun_get::get("s_state",-999),
			'key' => fun_get::get("s_key"),
		);
		if( $arr_search_key['state'] != -999 ) $arr_where_s[] = "sendinfo_state = '" . $arr_search_key['state'] . "'"; 
		if( $arr_search_key['key'] != '' ) $arr_where_s[] = "sendinfo_name like '%" . $arr_search_key['key'] . "%'"; 
		$arr_where = array_merge($arr_where , $arr_where_s);
		if(count($arr_where)>0) $str_where = " where " . implode(" and " , $arr_where);
		$arr_return = $this->sql_list($str_where , (int)fun_get::get('page'));

		if( count($arr_where_s) > 0 ) $lng_issearch = 1;
		$arr_return['issearch'] = $lng_issearch;

		return $arr_return;
	}

	/* 实现按具体条件查询数据表，并返回分页信息
	 * str_where : sql 查询条件 , lng_page : 当前页
	 */
	function sql_list($str_where = "" , $lng_page = 1) {
		$arr_return = array("list" => array());
		$obj_db = cls_obj::db();
		//相关属性
		$arr_return["state"] = tab_mall_sendinfo::get_perms("state");
		$arr_type = tab_mall_sendinfo::get_perms("type");
		//取字段信息
		$arr_cfg_fields = tab_sys_user_config::get_fields("mall.sendinfo" , $this->app_dir , "mall");
		$arr_return['tabtd'] = $arr_cfg_fields["tabtd"];
		$arr_return['tabtit'] = $arr_cfg_fields["tabtit"];
		//取排序字段
		$arr_config_info = tab_sys_user_config::get_info("mall.sendinfo"  , $this->app_dir);
		$sort = $arr_config_info["sortby"];
		$arr_return["sort"] = $arr_config_info["sort"];
		$lng_pagesize = $arr_config_info["pagesize"];
		//取分页信息
		$arr_uid = array();
		$arr_return["list"] = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_sendinfo" , $str_where , $lng_page , $lng_pagesize);
		$obj_result = $obj_db->select("SELECT " . $arr_cfg_fields["sel"] . " FROM ".cls_config::DB_PRE."mall_sendinfo" . $str_where . $sort . $arr_return['pageinfo']['limit']);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			if(isset($obj_rs["sendinfo_state"])) {
				$obj_rs["state:style"] = $this->get_state_style($obj_rs["sendinfo_state"]);
				$obj_rs["sendinfo_state"] = array_search($obj_rs["sendinfo_state"],$arr_return["state"]);
				if(!empty($obj_rs["state:style"])) $obj_rs["sendinfo_state"] = "<font ".$obj_rs["state:style"].">" . $obj_rs["sendinfo_state"] . "</font>";
			}
			if(isset($obj_rs["sendinfo_addtime"])) $obj_rs["sendinfo_addtime"] = date("Y-m-d H:i:s" , $obj_rs["sendinfo_addtime"]);
			$arr_return["list"][] = $obj_rs;
		}
		$arr_return['pagebtns']   = $this->get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}

	/* 查询配置表指定id信息
	 * msg_id : sys_config 表中 config_id
	 */
	function get_editinfo($msg_id) {
		$obj_rs = cls_obj::db()->edit(cls_config::DB_PRE."mall_sendinfo" , "sendinfo_id='".$msg_id."'");
		$obj_rs['area'] = array();
		$obj_rs['time'] = '';
		if(!empty( $obj_rs['sendinfo_detail'] )) {
			$arr = unserialize($obj_rs['sendinfo_detail']);
			if(isset($arr['area'])) $obj_rs['area'] = $arr['area'];
			if(isset($arr['time'])) {
				$arr_time = array();
				foreach($arr['time'] as $item => $key) {
					$arr_time[] = $key . "=>" . $item;
				}
				$obj_rs['time'] = implode(chr(10) , $arr_time);
			}
		}
		return $obj_rs;
	}

	/* 保存数据
	 * 
	 */
	function on_save() {
		$arr_return = array("code" => 0 , "id"=>0 , "msg" => cls_language::get("save_ok"));
		$id = (int)fun_get::post("id");
		$arr_fields = array(
			"id"     => $id,
			"sendinfo_name" => fun_get::post("sendinfo_name"),
			"sendinfo_unit"   => fun_get::post("sendinfo_unit"),
			"sendinfo_payment"   => fun_get::post("sendinfo_payment"),
			"sendinfo_unit_next"   => fun_get::post("sendinfo_unit_next"),
			"sendinfo_price"   => fun_get::post("sendinfo_price"),
			"sendinfo_price_next"    => fun_get::post("sendinfo_price_next"),
			"sendinfo_bj_per"  => fun_get::post("sendinfo_bj_per"),
			"sendinfo_bj_min"  => fun_get::post("sendinfo_bj_min"),
			"sendinfo_bj"  => fun_get::post("sendinfo_bj"),
			"sendinfo_sort"  => fun_get::post("sendinfo_sort"),
			"sendinfo_state"  => fun_get::post("sendinfo_state"),
			"sendinfo_area_type"  => fun_get::post("sendinfo_area_type"),

		);
		if(fun_get::post("istime") == '1') {
			$arr_fields["sendinfo_arrivedelay"] = (int)fun_get::post("sendinfo_arrivedelay");
			$arr_fields['sendinfo_detail']['time'] = fun_get::post("sendtime");
			if(empty($arr_fields["sendinfo_arrivedelay"]) || $arr_fields["sendinfo_arrivedelay"]<0) return array("提前下单时间必须大于零");
			if(empty($arr_fields['sendinfo_detail']['time'])) return array("配送时间不能为空");
		}
		if($arr_fields['sendinfo_area_type'] != 0) {
			$area_ids = fun_get::post("area_ids");
			$area_names = fun_get::post("area_names");
			$sendinfo_prices = fun_get::post("sendinfo_prices");
			$sendinfo_price_nexts = fun_get::post("sendinfo_price_nexts");
			$arr_detail = array();
			for($i = 0 ; $i < count($area_ids) ; $i++) {
				if(empty($area_ids[$i])) return array("code" => 500 , "msg"=>"配送地区不能为空");
				$arr_detail[] = array("i" => $i , "ids" => $area_ids[$i] , "price" => (float)$sendinfo_prices[$i] , "next" => (float)$sendinfo_price_nexts[$i] , "names" => $area_names[$i] );
			}
			$arr_fields['sendinfo_detail']['area'] = $arr_detail;
		}
		$arr = tab_mall_sendinfo::on_save($arr_fields);
		if($arr['code']==0) {
			if(isset($arr['id'])) $arr_return['id'] = $arr['id'];
		} else {
			$arr_return['code'] = $arr['code'];
			$arr_return['msg']  = $arr['msg'];
		}
		return $arr_return;
	}

	/* 删除指定  user_id 数据
	 */
	function on_delete() {
		$arr_return = array("code"=>0 , "msg"=> cls_language::get("delete_ok"));
		$str_id = fun_get::get("id");
		$arr_id = fun_get::get("selid");
		if( empty($arr_id) && empty($str_id) ) {
			$arr_return['code'] = 22;//见参数说明表
			$arr_return['msg']  = cls_language::get("delete_no_id");
			return $arr_return;
		}
		if(!empty($arr_id)) $str_id = $arr_id; //优先考虑 arr_id
		//删除用户信息
		$arr = tab_mall_sendinfo::on_delete($str_id);
		if($arr['code'] != 0) return $arr;
		return $arr_return;
	}
	/* 设置状态
	 */
	function on_state() {
		$arr_return = array("code" => 0 , "msg" => cls_language::get("set_ok"));
		$arr_id = fun_get::get("selid");
		$state_val = (int)fun_get::get("state_val");
		$str_id = fun_format::arr_id($arr_id);
		if(empty($str_id)) {
			$arr_return["code"] = 22;
			$arr_return["msg"] = cls_language::get("no_id");
			return $arr_return;
		}
		$arr = cls_obj::db_w()->on_update(cls_config::DB_PRE."mall_sendinfo" , array("sendinfo_state" => $state_val) , "sendinfo_id in(" . $str_id . ")");
		if($arr["code"] != 0) {
			$arr_return["code"] = $arr["code"];
			$arr_return["msg"] = $arr["msg"];
		}
		return $arr_return;
	}
}