<?php
class mod_mall_ajax extends mod_mall {
	function get_sendinfo($area_ids) {
		$obj_db = cls_obj::db();
		$where = " where sendinfo_state=1";
		$arr_areaid = explode("," , $area_ids);
		$arr_list = array();
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "mall_sendinfo" . $where . " order by sendinfo_sort");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr_detail = (!empty($obj_rs['sendinfo_detail'])) ? unserialize($obj_rs['sendinfo_detail']) : "";
			if($obj_rs['sendinfo_area_type'] != 0 && isset($arr_detail['area'])) {
				$arr_area = array();
				foreach($arr_detail['area'] as $item) {
					$arr1 = explode("," , $item['ids']);
					$arr2 = array_intersect($arr1 , $arr_areaid);
					if(!empty($arr2)) {
						$arr_area = $item;
					}
					if($item['ids'] == -1) $arr_area = $item;
				}
				if(!empty($arr_area)) {
					if(!empty($arr_area['price'])) $obj_rs['sendinfo_price'] = $arr_area['price'];
					if(!empty($arr_area['next'])) $obj_rs['sendinfo_price_next'] = $arr_area['next'];
				} else if($obj_rs['sendinfo_area_type'] == 1) {//单独配置地区
					continue;//不在配置的地区，则跳出
				}
			}
			$arr_time = array();
			if( !empty($obj_rs['sendinfo_arrivedelay']) && isset($arr_detail['time']) ) {
				foreach($arr_detail['time'] as $time => $key) {
					$arr_time[] = $time;
				}
			}
			$arr_list[] = array('id'=>$obj_rs['sendinfo_id'] , 'name' => $obj_rs['sendinfo_name'] , 'unit' => $obj_rs['sendinfo_unit'] , 'unit_next' => $obj_rs['sendinfo_unit_next'] , 'price'=>$obj_rs['sendinfo_price'] , 'next' => $obj_rs['sendinfo_price_next'] , 'bj' => $obj_rs['sendinfo_bj'] , 'bj_per' => $obj_rs['sendinfo_bj_per'] , 'bj_min' => $obj_rs['sendinfo_bj_min'] , 'payment' => $obj_rs['sendinfo_payment'] , 'time' => $arr_time);
		}
		return $arr_list;
	}

	function get_sold_record() {
		$id = fun_get::get("id");
		$page = (int)fun_get::get("page");
		$arr_return = array();
		$obj_db = cls_obj::db();
		$where = " where " . $obj_db->concat("," , "order_goods_ids" , ",") . " like '%," . $id . ",%'";
		$lng_pagesize = 12;
		$arr_return["list"] = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_order" , $where , $page , $lng_pagesize);
		$obj_result = $obj_db->select("SELECT order_detail,order_datetime,order_name FROM ".cls_config::DB_PRE."mall_order" . $where . $arr_return['pageinfo']['limit']);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			$arr = unserialize($obj_rs['order_detail']);
			foreach($arr['goods'] as $item) {
				$arr_x = explode('-' , $item['id']);
				if($arr_x[0] == $id) {
					$arr_return['list'][] = array('price'=>$item['price'] , 'total' => $item['total'] , 'num' => $item['num'] , 'pic' => $item['pic'] , 'name' => $item['name'] , 'uname' => $obj_rs['order_name'] , "date" => $obj_rs['order_datetime']);
				}
			}
		}
		$arr_return['pagebtns'] = fun_kj::get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}
	function get_comment_record() {
		$id = fun_get::get("id");
		$page = (int)fun_get::get("page");
		$arr_return = array("list" => array() );
		$obj_db = cls_obj::db();
		$where = " where comment_goods_id='" . $id . "'";
		$lng_pagesize = 12;
		$arr_return["list"] = $arr_list = $arr_uid = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_goods_comment" , $where , $page , $lng_pagesize);
		$obj_result = $obj_db->select("SELECT comment_beta,comment_pic,comment_user_id,comment_addtime FROM ".cls_config::DB_PRE."mall_goods_comment" . $where . $arr_return['pageinfo']['limit']);
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			$obj_rs['comment_addtime'] = date("Y-m-d H:i");
			$arr_list[] = $obj_rs;
			$arr_uid[] = $obj_rs['comment_user_id'];
		}
		if(!empty($arr_uid)) {
			$user_info = cls_obj::get("cls_user")->get_user($arr_uid);
			//用户等级
			$ids = implode("," , $arr_uid);
			$arr_level = array();
			$obj_result = $obj_db->select("select user_id,user_experience from " . cls_config::DB_PRE . "sys_user where user_id in(" . $ids . ")");
			while($obj_rs = $obj_db->fetch_array($obj_result)) {
				$level = tab_sys_user::get_level($obj_rs["user_experience"]);
				$arr_level['id_' . $obj_rs['user_id']] = $level;
			}
			foreach($arr_list as $item) {
				$uname = array_search($item['comment_user_id'] , $user_info);
				$level = (isset($arr_level['id_'.$item['comment_user_id']])) ? $arr_level['id_'.$item['comment_user_id']] : 0;
				$arr_return['list'][] = array('beta' => $item['comment_beta'] , 'pic' => fun_get::html_url($item['comment_pic']) , 'uname' => $uname , "level" => $level , 'time' => $item['comment_addtime']);
			}
		}
		$arr_return['pagebtns'] = fun_kj::get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}

	//添加收藏 或 解除收藏
	function set_goods_collect() {
		if(!cls_obj::get("cls_user")->is_login()) return array("code" => 500 , "msg" => "请先登录后再来收藏商品");
		$id = (int)fun_get::get("id");
		if(empty($id)) return array("code" => 500 , "msg" => "没有指定收藏的商品");
		$user_id = cls_obj::get("cls_user")->uid;
		$obj_db = cls_obj::db_w();
		$where = " where collect_user_id='" . $user_id . "' and collect_goods_id='" . $id . "'";
		$obj_collect = $obj_db->get_one("select * from " . cls_config::DB_PRE . "mall_goods_collect" . $where);
		//未收藏，则收藏
		if(empty($obj_collect)) {
			$arr_return = $obj_db->on_insert(cls_config::DB_PRE . "mall_goods_collect",array(
				'collect_user_id' => $user_id,
				'collect_goods_id' => $id,
				'collect_datetime' => date("Y-m-d H:i:s"),
			));
		} else {
			//已收藏，则解除收藏
			$arr_return = $obj_db->on_exe("delete from " . cls_config::DB_PRE . "mall_goods_collect" . $where);
		}
		return $arr_return;
	}
}