<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class mod_user extends inc_mod_default {
	function __construct($arr_v) {
		//是否登录
		if(!cls_obj::get("cls_user")->is_login()) {
			$agent = fun_get::agent();
			$act = '';
			if(!in_array($agent,array('','ipad'))) {
				$jump_url = fun_get::get("jump_url");    //获取跳转地址
				echo cls_app::on_display(KJ_WAP_DIR , '' , "index" , "login" , array( "jump_fromurl"=>$jump_url ) );exit;
			} else {
				cls_error::on_error("no_login");
			}
		}
		parent::__construct($arr_v);
		$arr_info['experience'] = cls_obj::get("cls_user")->get_experience();
		$arr_info['experience_next'] = tab_sys_user::get_level_next( $arr_info['experience'] );
		$arr_info['experience_poor'] = $arr_info['experience_next'] - $arr_info['experience'];
		$arr_info['level'] = cls_obj::get("cls_user")->get_level();
		$arr_info['level_next'] = $arr_info['level'] + 1;
		$arr_info['process'] = (int)($arr_info['experience'] / $arr_info['experience_next'] * 100);
		$this->user_info = $arr_info;
	}
	function get_repayment_list() {
		$obj_db = cls_obj::db();
		$page = (int)fun_get::get("page");
		//取排序字段
		$str_where = " where repayment_user_id='" . cls_obj::get("cls_user")->uid . "'";
		$pagesize = 20;

		$repayment_id = 0;
		$arr_return["list"] = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."sys_user_repayment" , $str_where , $page , $pagesize);
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "sys_user_repayment" . $str_where . " order by repayment_id desc" . $arr_return['pageinfo']['limit']);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			if(empty($repayment_id)) $repayment_id = $obj_rs["repayment_id"];
			if(empty($obj_rs["repayment_beta"])) {
				$arr = tab_sys_user_repayment::$this_type;
				$obj_rs["beta"] = array_search($obj_rs["repayment_type"] , $arr);
			} else {
				$obj_rs["beta"] = $obj_rs["repayment_beta"];
			}
			$obj_rs["repayment_addtime"] = date("Y-m-d H:i:s" , $obj_rs["repayment_addtime"]);
			$arr_return["list"][]= $obj_rs;
		}
		$arr_return["repayment"] = cls_obj::get("cls_user")->get_repayment();
		$arr_return['pagebtns']   = fun_kj::get_pagebtns($arr_return['pageinfo']);

		return $arr_return;
	}

	/*获取当前用户行为列表
	 * type: 0表示经验，1表示积分
	 */
	function get_action_list($type = 0) {
		$obj_db = cls_obj::db();
		$page = (int)fun_get::get("page");
		//取排序字段
		$str_where = " where action_user_id='" . cls_obj::get("cls_user")->uid . "'";
		if($type==0) {
			$str_where .= " and action_experience!=0";
		} else {
			$str_where .= " and action_score!=0";
		}
		$pagesize = 20;

		$action_id = 0;
		$arr_return["list"] = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."sys_user_action" , $str_where , $page , $pagesize);
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "sys_user_action" . $str_where . " order by action_id desc" . $arr_return['pageinfo']['limit']);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			if(empty($action_id)) $action_id = $obj_rs["action_id"];
			if(empty($obj_rs["action_beta"])) {
				$arr = cls_config::get($obj_rs["action_key"] , 'user.action' , '' , '');
				$obj_rs["beta"] = (isset($arr["title"]))? $arr["title"] : "";
			} else {
				$obj_rs["beta"] = $obj_rs["action_beta"];
			}
			$obj_rs["action_addtime"] = date("Y-m-d H:i:s" , $obj_rs["action_addtime"]);
			$arr_return["list"][]= $obj_rs;
		}
		$obj_rs = $obj_db->get_one("select sum(action_score) as score,sum(action_experience) as experience from " . cls_config::DB_PRE . "sys_user_action where action_user_id='" . cls_obj::get("cls_user")->uid . "' and action_id<='" . $action_id . "'");
		if(!empty($obj_rs)) {
			$arr_return["score"] = $obj_rs["score"];
			$arr_return["experience"] = $obj_rs["experience"];
		}
		$arr_return['pagebtns']   = $this->get_pagebtns($arr_return['pageinfo']);

		return $arr_return;
	}

	function get_order_list() {
		$uid = cls_obj::get("cls_user")->uid;
		$where = " where order_user_id='" . $uid . "'";
		$page = (int)fun_get::get("page");
		$s_key = fun_get::get("s_key");
		$s_state = fun_get::get("s_state");
		if($s_state !== null) $where .= " and order_state='" . $s_state . "'";
		if($s_key !== null) {
			if(is_numeric($s_key)) {
				$where .= " and order_id='" . $s_key . "'";
			} else {
				$where .= " and order_detail like '%" . $s_key . "%'";
			}
		}
		$pagesize = 10;
		$obj_db = cls_obj::db();
		$arr_state = tab_mall_order::get_perms("state");
		$arr_return = array("list" => array());
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_order" , $where , $page , $pagesize);
		$obj_result = $obj_db->select("select * from " . cls_config::DB_PRE . "mall_order" . $where . " order by order_id desc" . $arr_return['pageinfo']['limit']);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$obj_rs['order_detail'] = unserialize($obj_rs['order_detail']);
			$obj_rs['goods'] = (isset($obj_rs['order_detail']['goods'])) ? $obj_rs['order_detail']['goods'] : array();
			$obj_rs['state'] = array_search($obj_rs['order_state'] , $arr_state);
			$arr_return['list'][] = $obj_rs;
		}
		$arr_return['pagebtns']   = $this->get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}
	function get_order_detail($id) {
		$obj_db = cls_obj::db();
		$obj_order = $obj_db->edit(cls_config::DB_PRE."mall_order" , "order_id='" . $id . "'");
		$obj_order['number'] = tab_mall_order::get_number($obj_order['order_id'],$obj_order['order_user_id'],$obj_order['order_datetime']);
		$obj_sendinfo = $obj_db->get_one("select sendinfo_name from " . cls_config::DB_PRE . "mall_sendinfo where sendinfo_id='" . $obj_order['order_sendinfo_id'] . "'");
		$obj_order['sendinfo_name'] = (!empty($obj_sendinfo)) ? $obj_sendinfo['sendinfo_name'] : '';
		$arr_paymethod = tab_mall_order::get_perms("paymethod");
		$obj_order['paymethod'] = (isset($arr_paymethod[$obj_order['order_pay_method']])) ? $arr_paymethod[$obj_order['order_pay_method']] : '';
		$order_detail = (empty($obj_order['order_detail'])) ? array() : unserialize($obj_order['order_detail']);
		$obj_order['goods'] = (isset($order_detail['goods'])) ? $order_detail['goods'] : array();
		return $obj_order;
	}
	function get_goods_history() {
		$arr = cls_obj::get("cls_session")->get("goods.history");
		if(empty($arr)) return array();
		$arr_id = array();
		foreach($arr as $item) {
			$arr_id[] = $item['id'];
		}
		if(empty($arr_id)) return;
		$ids = implode("," , $arr_id);
		$obj_db = cls_obj::db();
		$arr_list = array();
		$obj_result = $obj_db->select("select goods_id,goods_name,goods_price,goods_price_market,goods_pic,goods_pic_small,goods_attribute_new,goods_attribute_tj,goods_attribute_hot from " . cls_config::DB_PRE . "mall_goods where goods_id in(" . $ids . ")");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			if(empty($obj_rs['goods_pic'])) $obj_rs['goods_pic'] = $obj_rs['goods_pic_small'];
			if(!isset($arr['id_' . $obj_rs['goods_id']])) continue;
			$obj_rs['goods_pic'] = fun_get::html_url($obj_rs['goods_pic']);
			$obj_rs['time'] = date("m-d H:i" , strtotime($arr['id_' . $obj_rs['goods_id']]['time']));
			$arr_list[$arr['id_' . $obj_rs['goods_id']]['time']] = $obj_rs;
		}
		krsort($arr_list);
		return $arr_list;
	}

	function get_goods_collect() {
		$obj_db = cls_obj::db();
		$page = (int)fun_get::get("page");
		//取排序字段
		$str_where = " where collect_user_id='" . cls_obj::get("cls_user")->uid . "'";
		$pagesize = 20;
		$arr_return["list"] = array();
		$arr_return["pageinfo"] = $obj_db->get_pageinfo(cls_config::DB_PRE."mall_goods_collect" , $str_where , $page , $pagesize);
		$obj_result = $obj_db->select("select collect_id,collect_datetime,goods_id,goods_name,goods_price,goods_price_market,goods_pic,goods_pic_small,goods_attribute_new,goods_attribute_tj,goods_attribute_hot from " . cls_config::DB_PRE . "mall_goods_collect a left join " . cls_config::DB_PRE . "mall_goods b on a.collect_goods_id=b.goods_id" . $str_where . " order by collect_id desc" . $arr_return['pageinfo']['limit']);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			if(empty($obj_rs['goods_id'])) continue;
			if(empty($obj_rs['goods_pic'])) $obj_rs['goods_pic'] = $obj_rs['goods_pic_small'];
			$obj_rs['goods_pic'] = fun_get::html_url($obj_rs['goods_pic']);
			$arr_return["list"][]= $obj_rs;
		}
		$arr_return['pagebtns']   = fun_kj::get_pagebtns($arr_return['pageinfo']);
		return $arr_return;
	}

	//用户中心修改密码
	function on_editpwd(){
		$lng_user_id = cls_obj::get('cls_user')->uid;
		if(empty($lng_user_id)) return array("code" => 500 , "msg" => "您还没有登录，无法修改密码");
		$arr_return = array( "code" => 0 , "msg" => "修改成功" );
		$arr_pwd=array(
			"oldpwd" => fun_get::post("oldpwd"),
			"pwd1" => fun_get::post('pwd1'),
			"pwd2" =>fun_get::post("pwd2")
		);
		if( $arr_pwd["pwd1"] != $arr_pwd["pwd2"] )  return array("code" => 1 , "msg" => "两次输入密码不一致");
		$arr = cls_obj::get("cls_user")->on_update_pwd($arr_pwd["oldpwd"] , $arr_pwd["pwd1"]);
		return $arr;
	}
	//绑定手机号
	function on_bind_verifytel() {
		$tel = fun_get::post("mobile");
		$key = fun_get::post("verifycode");
		$arr_return = tab_sys_verify::on_verify($tel , $key , 4);

		//查看用户是否已绑定过电话
		$obj_user = cls_obj::db()->get_one("select user_mobile from " . cls_config::DB_PRE . "sys_user where user_id='" . cls_obj::get("cls_user")->uid . "'");
		$mobile = '';
		if(isset($obj_user['user_mobile'])) $mobile = $obj_user['user_mobile'];
		$anquan_verify = cls_obj::get("cls_session")->get('anquan.verify');
		if(!empty($mobile) && empty($anquan_verify)) return array("code" => 500 , "msg" => "验证已过期，请刷新重新验证通过后再来绑定新手机");

		if($arr_return['code'] != 0) return $arr_return;
		$arr_return = tab_sys_user::on_save(array(
			'user_id' => cls_obj::get('cls_user')->uid,
			'user_mobile' => $tel,
			'user_verify_tel' => 1,
		));
		cls_obj::get("cls_session")->destroy('anquan.verify');
		return $arr_return;
	}
	//保存验证码
	function on_save_safeask() {
		$uid = cls_obj::get("cls_user")->uid;
		$arr_ask = cls_obj::db_w()->get_one("select 1 from " . cls_config::DB_PRE . "sys_safeask where safeask_user_id='" . $uid . "'");
		$anquan_verify = cls_obj::get("cls_session")->get('anquan.verify');
		if(!empty($arr_ask) && empty($anquan_verify)) return array("code" => 500 , "msg" => "验证已过期请重新验证后再来修改密保");
		$arr = array(
			array('safeask_question' => fun_get::post('ask1') , 'safeask_answer' => fun_get::post("answer1") , 'safeask_user_id' => $uid),
			array('safeask_question' => fun_get::post('ask2') , 'safeask_answer' => fun_get::post("answer2") , 'safeask_user_id' => $uid),
			array('safeask_question' => fun_get::post('ask3') , 'safeask_answer' => fun_get::post("answer3") , 'safeask_user_id' => $uid)
		);
		$ii = 1;
		foreach($arr as $item) {
			$item['safeask_number'] = $ii;
			$ii++;
			$arr_msg = tab_sys_safeask::on_save($item);
			if($arr_msg['code'] != 0) {
				cls_obj::db_w()->on_exe("delete from " . cls_config::DB_PRE . "sys_safeask where safeask_user_id='" . cls_obj::get("cls_user")->uid . "' and safeask_addtime='" . TIME . "'");
				return $arr_msg;
			}
		}
		$arr_msg = cls_obj::db_w()->on_exe("delete from " . cls_config::DB_PRE . "sys_safeask where safeask_user_id='" . cls_obj::get("cls_user")->uid . "' and safeask_addtime<'" . TIME . "'");
		if($arr_msg['code'] != 0) {
			cls_obj::db_w()->on_exe("delete from " . cls_config::DB_PRE . "sys_safeask where safeask_user_id='" . cls_obj::get("cls_user")->uid . "' and safeask_addtime='" . TIME . "'");
			return $arr_msg;
		}
		cls_obj::get("cls_session")->destroy('anquan.verify');
		return array("code" => 0 , "msg" => "设置成功");
	}
	//取进度条
	function myvip_progress() {
		$experience = $this->user_info["experience"];
		if($experience >= 5000) {
			$val = '100%';
		} else if($experience >= 5000) {
			$lng_val = $experience - 5000;
			$lng_x = 5000;
			$lng_y = 532;
			$val = $lng_y + intval($lng_val/$lng_x * 133);
		} else if($experience >= 2000) {
			$lng_val = $experience - 2000;
			$lng_x = 3000;
			$lng_y = 414;
			$val = $lng_y + intval($lng_val/$lng_x * 120);
		} else if($experience >= 800) {
			$lng_val = $experience - 800;
			$lng_x = 1200;
			$lng_y = 294;
			$val = $lng_y + intval($lng_val/$lng_x * 115);
		} else if($experience >= 300) {
			$lng_val = $experience - 300;
			$lng_x = 500;
			$lng_y = 194;
			$val = $lng_y + intval($lng_val/$lng_x * 100);
		} else if($experience >= 100) {
			$lng_val = $experience - 100;
			$lng_x = 200;
			$lng_y = 92;
			$val = $lng_y + intval($lng_val/$lng_x * 102);
		} else {
			$lng_val = $experience;
			$lng_x = 100;
			$lng_y = 0;
			$val = $lng_y + intval($lng_val/$lng_x * 86);
		}
		if(is_numeric($val)) $val = ($val + 6) . 'px';
		return $val;
	}
	//保存用户评论
	function order_comment_save() {
		$uid = cls_obj::get("cls_user")->uid;
		$goodsid = fun_get::get('gid');
		$arr = explode("-" , $goodsid);
		$oid = (int)fun_get::get("oid");
		$gid = $arr[0];
		$detail_id = (count($arr)>1) ? $arr[1] : 0;
		$arr_pic = fun_get::get('pic',array());
		$pic = implode("|" , $arr_pic);
		$commentname = fun_get::get("commentname");
		$arr_comment = array();
		if(!empty($commentname) && is_array($commentname)) {
			foreach($commentname as $item) {
				$val = fun_get::get("comment".$item);
				if(empty($val)) continue;
				$arr_comment[] = $item . "=>" . $val;
			}
		}
		$arr_fields = array(
			'comment_id' => (int)fun_get::get('id'),
			'comment_goods_id' => $gid,
			'comment_goods_detail_id' => $detail_id,
			'comment_order_id' => (int)fun_get::get('oid'),
			'comment_user_id' => $uid,
			'comment_beta' => fun_get::get('beta'),
			'comment_pic' => $pic,
			'comment_val' => (int)fun_get::get('commentval'),
			'comment_list' => implode("|" , $arr_comment),
		);
		if(empty($arr_fields['comment_id'])) {
			$obj_comment = cls_obj::db()->get_one("select comment_id from " . cls_config::DB_PRE . "mall_goods_comment where comment_goods_id='" . $arr_fields['comment_goods_id'] . "' and comment_goods_detail_id='" . $arr_fields['comment_goods_detail_id'] . "' and comment_order_id='" . $arr_fields['comment_user_id'] . "'");
			if(!empty($obj_comment)) $arr_fields['comment_id'] = $obj_comment['comment_id'];
		}
		if(empty($arr_fields['comment_id'])) {
			$obj_order = cls_obj::db()->get_one("select order_detail from " . cls_config::DB_PRE . "mall_order where order_id='" . $oid . "'");
			if(empty($obj_order)) return array("code" => 500 , "msg" => "订单不存在或已删除");
			$arr_detail = unserialize($obj_order['order_detail']);
			$arr_goods = array();
			foreach($arr_detail['goods'] as $goods) {
				if($goods['id'] == $goodsid) {
					$arr_goods = $goods;break;
				}
			}
			if(empty($arr_goods)) return array("code" => 500 , "msg" => "评价订单商品信息不存在");
			$goods_detail = serialize($arr_goods);
			$arr_fields['comment_goods'] = $goods_detail;
		}
		$arr = tab_mall_goods_comment::on_save($arr_fields);
		$arr['gid'] = fun_get::get('gid');
		return $arr;
	}
	function get_comment_detail($id) {
		$arr_cid = $arr_gid = $arr_pids = $arr_goods = array();
		$obj_order = cls_obj::db()->get_one("select * from " . cls_config::DB_PRE . "mall_order where order_id='" . $id . "'");
		if(empty($obj_order)) cls_error::on_exit("订单不存在");
		$obj_order['commented'] = array();
		$obj_result = cls_obj::db()->select("select * from " . cls_config::DB_PRE . "mall_goods_comment where comment_order_id='" . $id . "'");
		while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
			$obj_rs['comment_list'] = tab_mall_goods_comment::on_deformat($obj_rs['comment_list']);
			$obj_rs['comment_pic'] = empty($obj_rs['comment_pic'] ) ? array() : explode("|" , $obj_rs['comment_pic']);
			if(empty($obj_rs['comment_goods_detail_id'])) {
				$obj_order['commented']['id_' . $obj_rs['comment_goods_id']] = $obj_rs;
			} else {
				$obj_order['commented']['id_' . $obj_rs['comment_goods_id'] . "-" . $obj_rs['comment_goods_detail_id']] = $obj_rs;
			}
		}
		$obj_order['order_detail'] = unserialize($obj_order['order_detail']);
		foreach($obj_order['order_detail']['goods'] as $goods) {
			$arr = explode("-" , $goods['id']);
			$arr_gid[] = $arr[0];
			$goods['gid'] = $arr[0];
			$arr_goods[] = $goods;
		}
		$obj_order['order_detail']['goods'] = $arr_goods;
		$ids = implode("," , $arr_gid);
		$obj_result = cls_obj::db()->select("select goods_id,goods_category_id,category_pids,category_comments from " . cls_config::DB_PRE . "mall_goods a inner join " . cls_config::DB_PRE . "mall_goods_category b on a.goods_category_id=b.category_id where goods_id in(" . $ids . ")");

		while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
			$arr_cid[] = array('gid' => $obj_rs['goods_id'] , 'cid' => $obj_rs['goods_category_id'] , 'pids' => $obj_rs['category_pids'] , 'comments' => $obj_rs['category_comments'] );
			if(!empty($obj_rs['category_pids'])) $arr_pids[] = $obj_rs['category_pids'];
		}
		if(!empty($arr_pids)) {
			$ids = implode("," , $arr_pids);
			$obj_result = cls_obj::db()->select("select category_id,category_comments from " . cls_config::DB_PRE . "mall_goods_category where category_id in(" . $ids . ")");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				if(empty($obj_rs['category_comments'])) continue;
				$arr_category['id_' . $obj_rs['category_id']] = $obj_rs;
			}
		}
		$obj_order['comments'] = array();
		foreach($arr_cid as $item) {
			$arr = explode("," , $item['pids']);
			$arr_comments = array();
			if(!empty($item['comments'])) $arr_comments[] = $item['comments'];
			foreach($arr as $item2) {
				if(isset($arr_category['id_' . $item2])) $arr_comments[] = $arr_category['id_' . $item2]['category_comments'];
			}
			$comments = implode("|" , $arr_comments);
			$arritem = explode("|" , $comments);
			$obj_order['comments']['id_' . $item['gid']] = array();
			foreach($arritem as $item2) {
				if(!in_array($item2 , $obj_order['comments']['id_' . $item['gid']]) ) $obj_order['comments']['id_' . $item['gid']][] = $item2;
			}
		}
		return $obj_order;
	}
}