<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class cls_mall {
	//取购物车列表
	static function cart_list() {
		$arr_return = array('list' => array() , 'total' => 0 , 'num' => 0 , 'weight' => 0);
		$cartids = cls_session::get_cookie("mcart_ids");
		if(empty($cartids)) return $arr_return;
		$arr = explode("|" , $cartids);
		$arr_cartid = $arr_num = $arr_detailid = array();
		foreach($arr as $item) {
			$arrx = explode("," , $item);
			$arry = explode("-" , $arrx[0]);
			$id = (int)$arry[0];
			if(empty($id)) continue;
			$arr_num['id_' . $arrx[0]] = (int)$arrx[1];
			if(count($arry)==1) {
				$arr_cartid[] = $id;
			} else {
				$arr_detailid[] = $arry[1];
			}
		}
		if(empty($arr_cartid) && empty($arr_detailid) ) return $arr_return;
		if(!empty($arr_cartid)) {
			$ids = implode("," , $arr_cartid);
			$obj_result = cls_obj::db()->select("select goods_pic,goods_pic_small,goods_id,goods_name,goods_price,goods_weight,goods_sold,goods_store,goods_price_vip,goods_price_cost,goods_shop_id,goods_postage_areas from " . cls_config::DB_PRE . "mall_goods where goods_id in(" . $ids . ")");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				$arr = array();
				$arr['pic'] = (empty($obj_rs['goods_pic_small'])) ? fun_get::html_url($obj_rs['goods_pic']) : fun_get::html_url($obj_rs['goods_pic_small']);
				$arr['name'] = $obj_rs['goods_name'];
				$arr['price'] = cls_mall::get_price($obj_rs['goods_price'],$obj_rs['goods_price_vip']);
				$arr['id'] = $obj_rs['goods_id'];
				$arr['num'] = $arr_num['id_' . $arr['id']];
				$arr['total'] = $arr['num'] * $arr['price'];
				$arr['weight'] = $obj_rs['goods_weight'];
				$arr['store'] = $obj_rs['goods_store'] - $obj_rs['goods_sold'];
				$arr['format'] = array();
				$arr['cost'] = $obj_rs['goods_price_cost'];
				$arr['shop_id'] = $obj_rs['goods_shop_id'];
				$arr['postage'] = $obj_rs['goods_postage_areas'];
				$arr_return['list'][] = $arr;
				$arr_return['total'] += $arr['num'] * $arr['price'];
				$arr_return['num'] += $arr['num'];
				$arr_return['weight'] += $arr['weight'] * $arr['num'];//总重量
			}
		}
		if(!empty($arr_detailid)) {
			$ids = implode("," , $arr_detailid);
			$obj_result = cls_obj::db()->select("select a.goods_name,a.goods_pic,c.goods_format,a.goods_price,a.goods_price_vip,b.* from " . cls_config::DB_PRE . "mall_goods a left join " . cls_config::DB_PRE . "mall_goods_ext c on a.goods_id=c.ext_goods_id left join " . cls_config::DB_PRE . "mall_goods_detail b on a.goods_id=b.detail_goods_id where detail_id in(" . $ids . ")");
			while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
				if($obj_rs['detail_price']<=0) $obj_rs['detail_price'] = $obj_rs['goods_price'];
				if(empty($obj_rs['detail_price_vip'])) {
					$obj_rs['detail_price_vip'] = $obj_rs['goods_price_vip'];
				} else if(!empty($obj_rs['goods_price_vip'])) {
					$obj_rs['detail_price_vip'] .= "|" . $obj_rs['goods_price_vip'];
				}
				$arr = array();
				$arr['pic'] = (empty($obj_rs['detail_pic'])) ? fun_get::html_url($obj_rs['goods_pic']) : fun_get::html_url($obj_rs['detail_pic']);
				$arr['name'] = $obj_rs['goods_name'];
				$arr['price'] = cls_mall::get_price($obj_rs['detail_price'],$obj_rs['detail_price_vip']);
				$arr['id'] = $obj_rs['detail_goods_id'] . '-' . $obj_rs['detail_id'];
				$arr['num'] = $arr_num['id_' . $arr['id']];
				$arr['total'] = $arr['num'] * $arr['price'];
				$arr['weight'] = $obj_rs['detail_weight'];
				$arr['store'] = $obj_rs['detail_store'] - $obj_rs['detail_sold'];
				$arr_format = array();
				$arr_format_name = unserialize($obj_rs['goods_format']);
				$arr_format_val = unserialize($obj_rs['detail_format']);
				foreach($arr_format_name as $format) {
					if(!isset($arr_format_val['id_' . $format['id']])) continue;
					$arr_format[] = array('name'=>$format['name'],'val'=>$arr_format_val['id_' . $format['id']]['name'],'pic'=>$arr_format_val['id_' . $format['id']]['pic']);
				}
				$arr['format'] = $arr_format;
				$arr_return['list'][] = $arr;
				$arr_return['total'] += $arr['num'] * $arr['price'];
				$arr_return['num'] += $arr['num'];
				$arr_return['weight'] += $arr['weight'] * $arr['num'];//总重量
			}
		}
		return $arr_return;
	}

	//清空购物车
	static function cart_clear() {
		cls_session::set_cookie("mcart_ids" , "");
	}
	static function get_price($price , $price_vip = '') {
		$vip = cls_obj::get("cls_user")->get_vip();
		if(!empty($price_vip) && $vip > 0) {
			$arr = explode("|" , $price_vip);
			foreach($arr as $item) {
				$arrx = explode("=" , $item);
				if(count($arrx)!=2) continue;
				if( (int)$arrx[0] == $vip && !empty($arrx[1]) ) {
					$price = $arrx[1];
					break;
				}
			}
		}
		return $price;
	}
	static function get_vip_list() {
		$arr = cls_config::get("" , "user.vip" , "" , "");
		$arr_return = array();
		foreach($arr as $item=>$key) {
			$key['id'] = $item+1;
			$arr_return[] = $key;
		}
		return $arr_return;
	}
}