<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class tab_mall_goods_category {
	static $perms;

	//获取表配置参数
	static function get_perms($key) {
		if( empty(self::$perms) ) {
			self::$perms = array(
				"wap_show" => array(1=>"列表",2=>"图片"),
			);
		}
		$arr_return = array();
		if(isset(self::$perms[$key])) $arr_return = self::$perms[$key];
		return $arr_return;
	}

	/* 保存操作
	 * arr_fields : 为字段数据，默认如果包函 id，则为修改，否则为插入
	 * where : 默认为空，用于有时候条件修改
	 */
	static function on_save($arr_fields , $where = '') {
		$arr_return = array("code"=>0,"id"=>0,"msg"=>"");
		if(isset($arr_fields['category_id'])) {
			$arr_fields['id'] = $arr_fields['category_id'];
			unset($arr_fields['category_id']);
		}
		if( isset($arr_fields['id']) ) {
			$arr_return['id'] = (int)$arr_fields['id'];
			unset($arr_fields['id']);
			if( $arr_return['id'] > 0 ) { //大于零，为修改状态
				if( empty($where) ){
					$where = " category_id='" . $arr_return['id'] . "'";
				} else {
					$where = "(" . $where . ") and category_id='" . $arr_return['id'] . "'";
				}
			}
		}
		$pid = null;
		$obj_db = cls_obj::db_w();
		$arr_fields['category_updatetime'] = TIME;
		if( empty($where) ) {

			//必填项检查
			if(!isset($arr_fields['category_name']) || empty($arr_fields['category_name'])) {
				$arr_return['code'] = 113;
				$arr_return['msg']  = cls_language::get("name_is_null" , "mall");//用户组名不能为空
				return $arr_return;
			}
			
			//初始默认值
			$arr_fields['category_addtime'] = TIME;
			if(!isset($arr_fields["category_pid"])) $arr_fields["category_pid"] = 0;
			if(!isset($arr_fields['category_sort']) || empty($arr_fields['category_sort'])) {
				$obj_rs = $obj_db->get_one("select max(category_sort) as sort from " . cls_config::DB_PRE . "mall_goods_category where category_pid=" . $arr_fields["category_pid"]);
				(!empty($obj_rs))? $arr_fields['category_sort'] = $obj_rs["sort"] + 1 : $arr_fields['category_sort'] = 1;
			}
			//插入到用户表
			$arr = $obj_db->on_insert(cls_config::DB_PRE."mall_goods_category",$arr_fields);
			if($arr['code'] == 0) {
				$arr_return['id'] = $obj_db->insert_id();
				//其它非mysql数据库不支持insert_id 时
				if(empty($arr_return['id'])) {
					$where  = "category_sort='" . $arr_fields['category_sort'] . " and category_addtime=" . $arr_fields['category_addtime'] . " and category_name='".$arr_fields['category_name'] . "' and category_pid='".$arr_fields["category_pid"]."'";
					$obj_rs = $obj_db->get_one("select category_id from ".cls_config::DB_PRE."mall_goods_category where ".$where);
					if(!empty($obj_rs)) $arr_return['id'] = $obj_rs['category_id'];
				}
			} else {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
			$pid = $arr_fields['category_pid'];
		} else {
			if($arr_return['id'] < 1) {
				$obj_rs = $obj_db->get_one("select category_id,category_pid from ".cls_config::DB_PRE."mall_goods_category where ".$where);
				if(!empty($obj_rs)) {
					$arr_return['id'] = $obj_rs['category_id'];
					$pid = $obj_rs['category_pid'];
				} else {
					$arr_return['code'] = 114;
					$arr_return['msg']  = cls_language::get("no_editinfo");//修改信息不在在
					return $arr_return;
				}
				$where = "category_id='".$arr_return['id']."'";
			}
			//不允许修改父id，只能通过移动
			if(isset($arr_fields['category_pid'])) {
				$pid = $arr_fields['category_pid']; 
				unset($arr_fields['category_pid']);
			}
			//修改数据表
			$arr = $obj_db->on_update(cls_config::DB_PRE."mall_goods_category" , $arr_fields , $where);
			if($arr['code'] != 0) {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		}
		if($pid !== null) self::on_tongbu($pid , $arr_return['id']);
		return $arr_return;
	}
	/* 统计子集数及深度
	 * pid 为统计子集 , id 为计算深度
	 */
	static function on_tongbu($pid , $id = 0) {
		$arr_update = array();
		$obj_db = cls_obj::db_w();
		if( !empty($pid) ) {
			$child = 0;
			$obj_rs = $obj_db->get_one("select category_pids,category_child from ".cls_config::DB_PRE."mall_goods_category where category_id=".$pid);
			if(!empty($obj_rs) && !empty($obj_rs["category_pids"])) {
				$arr_update["category_pids"] = $obj_rs["category_pids"] . "," . $id;
				$arr_update["category_depth"] = count(explode("," , $arr_update["category_pids"]));
				$child = $obj_rs['category_child'];
			} else {
				$arr_update["category_pids"] = $id;
				$arr_update["category_depth"] = 1;
			}
			//计算父级子集数量
			$obj_rs = $obj_db->get_one("select 1 from " . cls_config::DB_PRE . "mall_goods_category where category_pid='" . $pid . "' limit 0,1");
			$val = (!empty($obj_rs)) ? 1 : 0;
			if($child != $val) $obj_db->on_update(cls_config::DB_PRE."mall_goods_category" , array('category_child'=>$val) , "category_id=" . $pid);
		} else {
			$arr_update["category_pids"] = $id;
			$arr_update["category_depth"] = 1;
		}
		if(!empty($id)) $arr = $obj_db->on_update(cls_config::DB_PRE."mall_goods_category" , $arr_update , "category_id=" . $id);
	}
	static function on_tongbu_all() {
		$obj_db = cls_obj::db();
		$obj_result = $obj_db->select("select category_id,category_pid from " . cls_config::DB_PRE . "mall_goods_category order by category_depth,category_sort,category_id");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			self::on_tongbu($obj_rs['category_pid'],$obj_rs['category_id']);
		}
	}
	/* 删除函数
	 * arr_id : 要删除的 id数组
	 * where : 删除附加条件
	 */
	static function on_delete($arr_id , $where = '') {
		$arr_return = array("code"=>0,"msg"=>"");
		$str_id = fun_format::arr_id($arr_id);
		if( $str_id == "" && empty($where) ){
			$arr_return["code"] = 22;
			$arr_return["msg"]="id".cls_language::get("not_null");
			return $arr_return;
		}
		if( !empty($str_id) ) {
			(is_numeric($str_id)) ? $arr_where[] = "category_id='".$str_id."'" : $arr_where[] = "category_id in(".$str_id.")";
		}
		if( !empty($where) ) {
			if(stristr($where , " or ") && substr(trim($where),0,1) != "(") $where = "(" . $where . ")";
			$arr_where[] = $where;
		}
		$where = implode(" and " , $arr_where);
		//删除子分类
		$arr_id = array();
		$obj_result = cls_obj::db()->select("select category_id,category_pid from " . cls_config::DB_PRE."mall_goods_category where " . $where);
		while($obj_rs = cls_obj::db()->fetch_array($obj_result)) {
			$arr_id[] = $obj_rs;
		}
		$arr_return=cls_obj::db_w()->on_delete(cls_config::DB_PRE."mall_goods_category" , $where);
		if($arr_return['code'] == 0) {
			foreach($arr_id as $item) {
				cls_obj::db_w()->on_delete(cls_config::DB_PRE."mall_goods_category" , cls_obj::db()->concat(',','category_pids',',') . " like '%," . $item['category_id'] . ",%'");
			}
			if(!empty($item['category_pid'])) {
				self::on_tongbu($item['category_pid']);
			}
		}
		return $arr_return;
	}
	/* 移动分组
	 *  id : 要移动的分组id , pid : 要移向的父id
	 */
	static function on_move($id , $pid , $pids='') {
		$obj_db = cls_obj::db_w();
		if(empty($pids)) {
			$obj_rs = $obj_db->get_one("select category_pids from ".cls_config::DB_PRE."mall_goods_category where category_id=".$pid);
			if(!empty($obj_rs) && !empty($obj_rs["category_pids"])) {
				$pids = $obj_rs["category_pids"] . "," . $pid;
			} else {
				$pids = $pid;
			}
		} else {
			$pids .=  "," . $pid;
		}
		$depth = '';
		if(!empty($pids)) $depth = count(explode("," , $pids));
		$arr_return = $obj_db->on_exe("update ".cls_config::DB_PRE."mall_goods_category set category_pid=".$pid.",category_pids='".$pids."',category_depth='".$depth."' where category_id='".$id."'");
		if($arr_return["code"] == 0) {
			//循环移动子集
			$obj_result = $obj_db->select("select category_id from " . cls_config::DB_PRE . "mall_goods_category where category_pid='".$id."'");
			while($obj_rs = $obj_db->fetch_array($obj_result)){
				self::on_move($obj_rs["category_id"] , $id , $pids);
			}
		}
		return $arr_return;
	}
	static function get_path($id , $name = null,$pids = null) {
		$obj_db = cls_obj::db();
		$arr_path = array();
		if( $name == null || $pids == null ) {
			$obj_val = $obj_db->get_one("select category_id,category_pids,category_name from " . cls_config::DB_PRE . "mall_goods_category where category_id='" . $id . "'");
			if(empty($obj_val)) return array();
			$pids = $obj_val['category_pids'];
		}
		if(empty($pids)) return $arr_path;
		$obj_result = $obj_db->select("select category_name,category_id from " . cls_config::DB_PRE . "mall_goods_category where category_id in(" . $pids . ") order by category_depth");
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr_path[] = array('id' => $obj_rs['category_id'] , 'name' => $obj_rs['category_name']);
		}
		return $arr_path;
	}
	/** 按层次返回列表记录
	 *	pid : 指定父级id , layer : 当前层次 ，where : 附加条件
	 */
	static function get_list_layer($pid = 0 , $layer = 1 , $where = '') {
		$arr_list = array();
		$max_layer = 0;
		$obj_db = cls_obj::db_w();
		$str_where = " where category_pid=".$pid;
		if($where != '') $str_where .= " and " . $where;
		$obj_result = $obj_db->select("SELECT * FROM ".cls_config::DB_PRE."mall_goods_category" . $str_where . " order by category_sort,category_id");
		while( $obj_rs = $obj_db->fetch_array($obj_result) ) {
			$obj_rs["layer"] = $layer;
			if($layer > $max_layer) $max_layer = $layer;
			$arr_list[] = $obj_rs;
			$arr = self::get_list_layer($obj_rs["category_id"] , $layer+1 , $where);
			if( count($arr["list"])>0 ) {
				$arr_list = array_merge($arr_list , $arr["list"]);
				if($arr["maxlayer"] > $max_layer) $max_layer = $arr["maxlayer"];
			}
		}
		$arr_return=array("list" => $arr_list , "maxlayer" => $max_layer);
		return $arr_return ;
	}
	//取指定分类id属性列表
	static function get_attribute($id , $msg_where = '') {
		if(empty($id)) return array('code'=>500 , 'list'=>array() , '' => '');
		$id = (int)$id;
		$obj_db = cls_obj::db();
		$arr_id = array();//主要因为包括父级所以用数组来排序，父级优先
		//取父级属性
		$obj_category = $obj_db->get_one("select category_pids from " . cls_config::DB_PRE . "mall_goods_category where category_id='" . $id . "'");
		if(!empty($obj_category) && !empty($obj_category['category_pids']) ) {
			$arr_id = explode("," , $obj_category['category_pids']);
			$where = " where attribute_category_id in(" . $obj_category['category_pids'] . ")";
		} else {
			$arr_id[] = $id;
			$where = " where attribute_category_id='" . $id . "'";
		}
		if(!empty($msg_where)) $where .= " and " . $msg_where;
		$arr_list = array();
		$obj_result = $obj_db->select("select attribute_name,attribute_val,attribute_default,attribute_type,attribute_category_id from " . cls_config::DB_PRE . "mall_goods_category_attribute" . $where);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$obj_rs["attribute_val"] = tab_mall_goods_category_attribute::format_val($obj_rs["attribute_val"]);
			$arr_list['id_' . $obj_rs['attribute_category_id']][] = array("name"=>$obj_rs["attribute_name"],"list"=>$obj_rs["attribute_val"],"type"=>$obj_rs["attribute_type"],"default"=>$obj_rs["attribute_default"]);
		}
		$arr = array();
		foreach($arr_id as $item) {
			if(!isset($arr_list['id_' . $item])) continue;
			foreach($arr_list['id_' . $item] as $item_next) {
				$arr[] = $item_next;
			}
			unset($arr_list['id_' . $item]);
		}
		return array("code" => 0 , "list" => $arr );
	}
}