<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class tab_mall_goods_comment {
	/* 保存操作
	 * arr_fields : 为字段数据，默认如果包函 id，则为修改，否则为插入
	 * where : 默认为空，用于有时候条件修改
	 */
	static function on_save($arr_fields , $where = '') {
		$arr_return = array("code"=>0,"id"=>0,"msg"=>"");
		if(isset($arr_fields['comment_id'])) {
			$arr_fields['id'] = $arr_fields['comment_id'];
			unset($arr_fields['comment_id']);
		}
		if( isset($arr_fields['id']) ) {
			$arr_return['id'] = (int)$arr_fields['id'];
			unset($arr_fields['id']);
			if( $arr_return['id'] > 0 ) { //大于零，为修改状态
				if( empty($where) ){
					$where = " comment_id='" . $arr_return['id'] . "'";
				} else {
					$where = "(" . $where . ") and comment_id='" . $arr_return['id'] . "'";
				}
			}
		}
		if(isset($arr_fields['comment_goods_format']) && is_array($arr_fields['comment_goods_format'])) {
			$arr_fields['comment_goods_format'] = serialize($arr_fields['comment_goods_format']);
		}
		$old_commentlist = '';
		$obj_db = cls_obj::db_w();
		if( empty($where) ) {
			if(!isset($arr_fields["comment_user_id"])) $arr_fields["comment_user_id"] = cls_obj::get("cls_user")->uid;
			if(empty($arr_fields["comment_user_id"])) return array("code" => 500 , "msg" => "未登录或登录超时");
			if(!isset($arr_fields["comment_goods_id"]) || empty($arr_fields["comment_goods_id"])) return array("code" => 500 , "msg" => "评论商品不存在");
			if(!isset($arr_fields["comment_order_id"]) || empty($arr_fields["comment_order_id"])) return array("code" => 500 , "msg" => "评论订单不存在");
			$arr_fields["comment_addtime"] = TIME;
			//插入到表
			$arr = $obj_db->on_insert(cls_config::DB_PRE."mall_goods_comment",$arr_fields);
			if($arr['code'] == 0) {
				$arr_return['id'] = $obj_db->insert_id();
				//其它非mysql数据库不支持insert_id 时
				if(empty($arr_return['id'])) {
					$where  = "comment_name='".$arr_fields['comment_name'] . "' and comment_addtime='".$arr_fields["comment_addtime"]."'";
					$obj_rs = $obj_db->get_one("select comment_id from ".cls_config::DB_PRE."mall_goods_comment where ".$where);
					if(!empty($obj_rs)) $arr_return['id'] = $obj_rs['comment_id'];
				}
			} else {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		} else {
			if($arr_return['id'] < 1) {
				$obj_rs = $obj_db->get_one("select comment_id,comment_list,comment_val from ".cls_config::DB_PRE."mall_goods_comment where ".$where);
				if(!empty($obj_rs)) {
					$old_commentlist = $obj_rs['comment_list'];
					$arr_return['id'] = $obj_rs['comment_id'];
				} else {
					$arr_return['code'] = 114;
					$arr_return['msg']  = cls_language::get("no_editinfo");//修改信息不在在
					return $arr_return;
				}
				$where = "comment_id='".$arr_return['id']."'";
			}
			//修改数据表
			$arr = $obj_db->on_update(cls_config::DB_PRE."mall_goods_comment" , $arr_fields , $where);
			if($arr['code'] != 0) {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		}
		//同步商品评价
		if(isset($arr_fields['comment_goods_id']) && isset($arr_fields['comment_list'])  && isset($arr_fields['comment_val']) ) {
			self::on_tongbu($arr_fields['comment_goods_id'] , $arr_fields['comment_list'] , $old_commentlist);
		}
		return $arr_return;
	}
	static function on_tongbu($gid , $comment = '' , $old_comment = '') {
		$obj_db = cls_obj::db_w();
		$obj_goods = $obj_db->get_one("select goods_comments from " . cls_config::DB_PRE . "mall_goods_ext where ext_goods_id='" . $gid . "'");
		if(empty($obj_goods)) return array("code" => 500 , "msg" => "");
		//同步统计
		$obj_comment = $obj_db->get_one("select count(1) as 'num', sum(comment_val) as 'val' from " . cls_config::DB_PRE . "mall_goods_comment where comment_goods_id='" . $gid . "'");
		$val = $obj_comment['val']/$obj_comment['num'];
		$obj_db->on_exe("update " . cls_config::DB_PRE . "mall_goods set goods_comment_val='" . $val . "',goods_comment_num='" . $obj_comment['num'] . "' where goods_id='" . $gid . "'");
		$arr_comments = empty($obj_goods['goods_comments']) ? array() : unserialize($obj_goods['goods_comments']);
		if(!empty($old_comment)) {
			$arr = self::on_deformat($old_comment);
			foreach($arr as $item=>$key) {
				if(isset($arr_comments[$item][$key])) {
					$arr_comments[$item][$key] = intval($arr_comments[$item][$key])-1;
					if($arr_comments[$item][$key]<=0) unset($arr_comments[$item][$key]);
				}
			}
		}
		if(!empty($comment)) {
			$arr = self::on_deformat($comment);
			foreach($arr as $item=>$key) {
				if(isset($arr_comments[$item][$key])) {
					$arr_comments[$item][$key] = intval($arr_comments[$item][$key])+1;
				} else {
					$arr_comments[$item][$key] = 1;
				}
			}
		}
		if(!empty($old_comment) || !empty($comment)) {
			$cont = serialize($arr_comments);
			$arr = $obj_db->on_exe("update " . cls_config::DB_PRE . "mall_goods_ext set goods_comments='" . $cont . "' where ext_goods_id='" . $gid . "'");
		}
		return array('code' => 0 , "msg" => "");
	}
	/* 删除函数
	 * arr_id : 要删除的 id数组
	 * where : 删除附加条件
	 */
	static function on_delete($arr_id , $where = '') {
		$arr_return = array("code"=>0,"msg"=>"");
		$str_id = fun_format::arr_id($arr_id);
		if( empty($str_id) && empty($where) ){
			$arr_return["code"] = 22;
			$arr_return["msg"]="id".cls_language::get("not_null");
			return $arr_return;
		}
		$obj_db = cls_obj::db_w();
		if( !empty($str_id) ) {
			(is_numeric($str_id)) ? $arr_where[] = "comment_id='".$str_id."'" : $arr_where[] = "comment_id in(".$str_id.")";
		}
		if( !empty($where) ) {
			if(stristr($where , " or ") && substr(trim($where),0,1) != "(") $where = "(" . $where . ")";
			$arr_where[] = $where;
		}
		$arr_comment = array();
		$where = implode(" and " , $arr_where);
		$obj_result = $obj_db->select("select comment_goods_id,comment_list from " . cls_config::DB_PRE . "mall_goods_comment where " . $where);
		while($obj_rs = $obj_db->fetch_array($obj_result)) {
			$arr_comment[] = $obj_rs;
		}
		$arr_return = $obj_db->on_delete(cls_config::DB_PRE."mall_goods_comment" , $where);
		if($arr_return['code'] == 0) {
			foreach($arr_comment as $item) {
				self::on_tongbu($item['comment_goods_id'] , '' , $item['comment_list']);
			}
		}
		return $arr_return;
	}
	static function on_deformat($str) {
		if(empty($str)) return array();
		$arr = explode("|" , $str);
		$arr_return = array();
		foreach($arr as $item) {
			$arr1 = explode("=>" , $item);
			$arr_return[$arr1[0]] = $arr1[1];
		}
		return $arr_return;
	}
	static function get_list_rate($arr) {
		if(!is_array($arr)) {
			$arr = empty($arr) ? array() : unserialize($arr);
		}
		if(empty($arr)) return array();
		$arr_return = array();
		foreach($arr as $item=>$val) {
			$total = 0;
			$maxval = 0;
			foreach($val as $item2=>$val2) {
				$total += $val2;
				if($maxval < $val2 ) $maxval = $val2;
			}
			$arr_return[$item] = array();
			foreach($val as $item2=>$val2) {
				$ismax = 0;
				if($val2==$maxval) {
					$ismax = 1;
					$maxval++;
				}
				$arr_return[$item][] = array('name'=>$item2 , 'val'=>$val2 , 'rate'=>$val2/$total*100 , 'ismax'=>$ismax);
			}
		}
		return $arr_return;
	}
}