<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class tab_mall_goods {
	static $perms;
	static function get_perms($key) {
		if( empty(self::$perms) ) {
			self::$perms = array(
				"state" => array( "上架" => 1 , "下架" => 0) ,
				"sp1" => "|" , //goods_category_attribute 分隔符
				"sp2" => "=>" , //goods_category_attribute 名称 与 内容 分隔符
				"tj" => array("推荐1"=>1 , "推荐2"=>2 , "推荐3" => 3 , "推荐4" => 4),
			);
		}
		$arr_return = array();
		if(isset(self::$perms[$key])) $arr_return = self::$perms[$key];
		return $arr_return;
	}
	static function on_save($arr_fields,$where = '') {
		$arr_return = array("code"=>0,"id"=>0,"msg"=>"");
		if(isset($arr_fields['goods_id'])) {
			$arr_fields['id'] = $arr_fields['goods_id'];
			unset($arr_fields['goods_id']);
		}
		if( isset($arr_fields['id']) ) {
			$arr_return['id'] = (int)$arr_fields['id'];
			unset($arr_fields['id']);
			if( $arr_return['id'] > 0 ) { //大于零，为修改状态
				if( empty($where) ){
					$where = " goods_id='" . $arr_return['id'] . "'";
				} else {
					$where = "(" . $where . ") and goods_id='" . $arr_return['id'] . "'";
				}
			}
		}
		$arr_ext_fields = array();
		if(isset($arr_fields['goods_detail'])) {
			$arr_ext_fields['goods_detail'] = $arr_fields['goods_detail'];
			unset($arr_fields['goods_detail']);
		}
		if(isset($arr_fields['goods_intro'])) {
			$arr_ext_fields['goods_intro'] = $arr_fields['goods_intro'];
			unset($arr_fields['goods_intro']);
		}
		if(isset($arr_fields['goods_pic_list'])) {
			$arr_ext_fields['goods_pic_list'] = $arr_fields['goods_pic_list'];
			unset($arr_fields['goods_pic_list']);
		}
		if(isset($arr_fields['goods_templates'])) {
			$arr_ext_fields['goods_templates'] = $arr_fields['goods_templates'];
			unset($arr_fields['goods_templates']);
		}
		if(isset($arr_fields['goods_format'])) {
			$arr_ext_fields['goods_format'] = $arr_fields['goods_format'];
			unset($arr_fields['goods_format']);
		}
		$goods_category_attribute = '';//原属性
		$obj_db = cls_obj::db_w();
		if( empty($where) ) {

			//必填项检查
			if(!isset($arr_fields['goods_name']) || $arr_fields['goods_name'] == '' ) {
				$arr_return['code'] = 113;
				$arr_return['msg']  = cls_language::get("goods_name_is_null" , "mall");//店铺名称不能为空
				return $arr_return;
			}
			//没有指定用户id
			if(!empty($arr_fields["goods_user_id"])) $arr_fields["goods_user_id"] = cls_obj::get("cls_user")->uid;
			//初始必要值
			$arr_fields['goods_addtime'] = $arr_fields['goods_updatetime'] = TIME;

			//插入到表
			$arr = $obj_db->on_insert(cls_config::DB_PRE."mall_goods",$arr_fields);
			if($arr['code'] == 0) {
				$arr_return['id'] = $obj_db->insert_id();
				//其它非mysql数据库不支持insert_id 时
				if(empty($arr_return['id'])) {
					$obj_rs = $obj_db->get_one("select goods_id from ".cls_config::DB_PRE."mall_goods where goods_addtime='" . $arr_fields["goods_addtime"] . " and goods_name='" . $arr_fields["goods_name"] . "' and goods_shop_id='" . $arr_fields["goods_shop_id"] . "'");
					if(!empty($obj_rs)) $arr_return['id'] = $obj_rs['goods_id'];
				}
				//初始扩展表
				$arr_ext_fields['ext_goods_id'] = $arr_return['id'];
				$arr = $obj_db->on_insert(cls_config::DB_PRE."mall_goods_ext",$arr_ext_fields);
			} else {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		} else {
			if($arr_return['id'] < 1) {
				$obj_rs = $obj_db->get_one("select goods_id,goods_category_attribute from ".cls_config::DB_PRE."mall_goods where ".$where);
				if(!empty($obj_rs)) {
					$arr_return['id'] = $obj_rs['goods_id'];
					$goods_category_attribute = $obj_rs['goods_category_attribute'];
				} else {
					$arr_return['code'] = 114;
					$arr_return['msg']  = cls_language::get("no_editinfo");//修改信息不在在
					return $arr_return;
				}
				$where = "goods_id='".$arr_return['id']."'";
			} else if(isset($arr_fields['goods_category_id']) && isset($arr_fields['goods_category_attribute']) ) {//取原属性，方便下面同步到分类表
				$obj_rs = $obj_db->get_one("select goods_category_attribute from ".cls_config::DB_PRE."mall_goods where ".$where);
				if(!empty($obj_rs)) $goods_category_attribute = $obj_rs['goods_category_attribute'];
			}
			//修改数据表
			$arr = $obj_db->on_update(cls_config::DB_PRE."mall_goods" , $arr_fields , $where);
			if($arr['code'] != 0) {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
			if(!empty($arr_ext_fields)) $obj_db->on_update(cls_config::DB_PRE."mall_goods_ext" , $arr_ext_fields , "ext_goods_id=" . $arr_return['id']);
		}

		//同步分类属性
		if($arr_return['code'] == 0 && isset($arr_fields['goods_category_id']) && isset($arr_fields['goods_category_attribute'])) {
			$obj_pids = $obj_db->get_one("select category_pids from " . cls_config::DB_PRE . "mall_goods_category where category_id='" . $arr_fields['goods_category_id'] . "'");
			$pids = (empty($obj_pids) || empty($obj_pids['category_pids']) ) ? $arr_fields['goods_category_id'] : $obj_pids['category_pids'] . "," . $arr_fields['goods_category_id'];
			tab_mall_goods_category_attributed::on_goods_save($pids , $arr_fields['goods_category_attribute'] , $goods_category_attribute);
		}
		return $arr_return;
	}

	/* 删除函数
	 * arr_id : 要删除的 id数组
	 * where : 删除附加条件
	 */
	static function on_delete($arr_id , $where = '') {
		$arr_return = array("code"=>0,"msg"=>"");
		$str_id = fun_format::arr_id($arr_id);
		if( empty($str_id) && empty($where) ){
			$arr_return["code"] = 22;
			$arr_return["msg"]=cls_language::get("not_where");
			return $arr_return;
		}
		if( !empty($str_id) ) {
			(is_numeric($str_id)) ? $arr_where[] = "goods_id='".$str_id."'" : $arr_where[] = "goods_id in(".$str_id.")";
		}
		if( !empty($where) ) {
			if(stristr($where , " or ") && substr(trim($where),0,1) != "(") $where = "(" . $where . ")";
			$arr_where[] = $where;
		}
		$where = implode(" and " , $arr_where);

		$arr_return=cls_obj::db_w()->on_delete(cls_config::DB_PRE."mall_goods" , $where);
		return $arr_return;
	}
	static function format_postage($postage) {
		$arr_val = array('ids' => array() , 'mode' => 0);
		$arr_x = explode('>' , $postage);
		if(count($arr_x)!=2) return $arr_val;
		$arr_val['mode'] = $arr_x[1];
		$arr = explode("|" , $arr_x[0]);
		foreach($arr as $item) {
			$arr_x = explode("=" , $item);
			if(count($arr_x)!=2) continue;
			$arr_val['ids'][] = $arr_x[0];
			$arr_val['id_' . $arr_x[0]] = (float)$arr_x[1];
		}
		return $arr_val;
	}
}