<?php
/* 快捷商城系统
 * 版本号：2.0
 * 官网：http://www.kjcms.cn
 * 2015-02-16
 */
class tab_mall_sendinfo {
	static $perms;

	//获取表配置参数
	static function get_perms($key) {
		if( empty(self::$perms) ) {
			self::$perms = array(
				"unit" => array("500克" => 500 , "1千克" => 1000 , "2千克" => 2000 , "5千克" => 5000, "10千克" => 10000 , "20千克" => 20000 , "50千克" => 50000),
				"state" => array("启用" => 1 , "关闭" => 0),
			);
		}
		$arr_return = array();
		if(isset(self::$perms[$key])) $arr_return = self::$perms[$key];
		return $arr_return;
	}

	/* 保存操作
	 * arr_fields : 为字段数据，默认如果包函 id，则为修改，否则为插入
	 * where : 默认为空，用于有时候条件修改
	 */
	static function on_save($arr_fields , $where = '') {
		$arr_return = array("code"=>0,"id"=>0,"msg"=>"");
		if(isset($arr_fields['sendinfo_id'])) {
			$arr_fields['id'] = $arr_fields['sendinfo_id'];
			unset($arr_fields['sendinfo_id']);
		}
		if( isset($arr_fields['id']) ) {
			$arr_return['id'] = (int)$arr_fields['id'];
			unset($arr_fields['id']);
			if( $arr_return['id'] > 0 ) { //大于零，为修改状态
				if( empty($where) ){
					$where = " sendinfo_id='" . $arr_return['id'] . "'";
				} else {
					$where = "(" . $where . ") and sendinfo_id='" . $arr_return['id'] . "'";
				}
			}
		}
		if(isset($arr_fields['sendinfo_detail']) && is_array($arr_fields['sendinfo_detail'])) {
			if(isset($arr_fields['sendinfo_detail']['time']) && !is_array($arr_fields['sendinfo_detail']['time'])) {
				$str_opentime = str_replace( chr(13) , chr(10) , $arr_fields['sendinfo_detail']['time']);
				$str_opentime = str_replace( chr(10).chr(10) , chr(10) , $str_opentime);
				$arr = explode(chr(10) , $str_opentime);
				$arr_fields['sendinfo_detail']['time'] = array();
				foreach($arr as $item) {
					$arr_x = explode("=&gt;" , $item);
					if(count($arr_x)!=2 || !is_numeric($arr_x[0])) continue;
					$arr_fields['sendinfo_detail']['time'][$arr_x[1]] = $arr_x[0];
				}

			}
			$arr_fields['sendinfo_detail'] = serialize($arr_fields['sendinfo_detail']);
		}
		$obj_db = cls_obj::db_w();
		if( empty($where) ) {
			$arr_fields["sendinfo_addtime"] = TIME;
			if(!isset($arr_fields['sendinfo_sort']) || empty($arr_fields['sendinfo_sort'])) {
				$arr_fields["sendinfo_addtime"] = 1;
				$obj_sort = $obj_db->get_one("select max(sendinfo_sort) as sort from " . cls_config::DB_PRE . "mall_sendinfo");
				if($obj_sort) $arr_fields["sendinfo_addtime"] = $obj_sort['sort']+1;
			}
			//插入到表
			$arr = $obj_db->on_insert(cls_config::DB_PRE."mall_sendinfo",$arr_fields);
			if($arr['code'] == 0) {
				$arr_return['id'] = $obj_db->insert_id();
				//其它非mysql数据库不支持insert_id 时
				if(empty($arr_return['id'])) {
					$where  = "sendinfo_name='".$arr_fields['sendinfo_name'] . "' and sendinfo_addtime='".$arr_fields["sendinfo_addtime"]."'";
					$obj_rs = $obj_db->get_one("select sendinfo_id from ".cls_config::DB_PRE."mall_sendinfo where ".$where);
					if(!empty($obj_rs)) $arr_return['id'] = $obj_rs['sendinfo_id'];
				}
			} else {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		} else {

			if($arr_return['id'] < 1) {
				$obj_rs = $obj_db->get_one("select sendinfo_id from ".cls_config::DB_PRE."mall_sendinfo where ".$where);
				if(!empty($obj_rs)) {
					$arr_return['id'] = $obj_rs['sendinfo_id'];
				} else {
					$arr_return['code'] = 114;
					$arr_return['msg']  = cls_language::get("no_editsendinfo");//修改信息不在在
					return $arr_return;
				}
				$where = "sendinfo_id='".$arr_return['id']."'";
			}
			//修改数据表
			$arr = $obj_db->on_update(cls_config::DB_PRE."mall_sendinfo" , $arr_fields , $where);
			if($arr['code'] != 0) {
				$arr_return['code'] = $arr['code'];
				$arr_return['msg']  = cls_language::get("db_edit");
			}
		}
		return $arr_return;
	}

	static function get_sendprice($id , $weight , $arr_areaid) {
		$obj_sendinfo = cls_obj::db()->get_one("select * from " . cls_config::DB_PRE . "mall_sendinfo where sendinfo_id='" . $id . "'");
		if(empty($obj_sendinfo)) return array('code' => 500 , 'msg' => '配送方式不存在');
		if(!is_array($arr_areaid)) $arr_areaid = explode("," , $arr_areaid);
		$arr_detail = (!empty($obj_sendinfo['sendinfo_detail'])) ? unserialize($obj_sendinfo['sendinfo_detail']) : "";
		if($obj_sendinfo['sendinfo_area_type'] != 0 && isset($arr_detail['area'])) {
			$arr_area = array();
			foreach($arr_detail['area'] as $item) {
				$arr1 = explode("," , $item['ids']);
				$arr2 = array_intersect($arr1 , $arr_areaid);
				if(!empty($arr2)) {
					$arr_area = $item;
				}
			}
			if(!empty($arr_area)) {
				if(!empty($arr_area['price'])) $obj_sendinfo['sendinfo_price'] = $arr_area['price'];
				if(!empty($arr_area['next'])) $obj_sendinfo['sendinfo_price_next'] = $arr_area['next'];
			} else if($obj_sendinfo['sendinfo_area_type'] == 1) {//单独配置地区
				return array('code' => 500 , 'msg' => '不支持配送当前地区，请换一种配送方式');
			}
		}
		$price = $obj_sendinfo['sendinfo_price'];
		if( $weight > $obj_sendinfo['sendinfo_unit'] ) {
			$weight = $weight - $obj_sendinfo['sendinfo_unit'];
			$price_next = $weight / $obj_sendinfo['sendinfo_unit_next'];
			if($price_next != (int)$price_next) {
				$price_next = (int)$price_next + 1;
			}
			$price += $price_next * $obj_sendinfo['sendinfo_price_next'];
		}
		return array("code" => 0 , "price" => $price , "payment" => $obj_sendinfo['sendinfo_payment']);
	}
	/* 删除函数
	 * arr_id : 要删除的 id数组
	 * where : 删除附加条件
	 */
	static function on_delete($arr_id , $where = '') {
		$arr_return = array("code"=>0,"msg"=>"");
		$str_id = fun_format::arr_id($arr_id);
		if( empty($str_id) && empty($where) ){
			$arr_return["code"] = 22;
			$arr_return["msg"]="id".cls_language::get("not_null");
			return $arr_return;
		}
		$obj_db = cls_obj::db_w();
		if( !empty($str_id) ) {
			(is_numeric($str_id)) ? $arr_where[] = "sendinfo_id='".$str_id."'" : $arr_where[] = "sendinfo_id in(".$str_id.")";
		}
		if( !empty($where) ) {
			if(stristr($where , " or ") && substr(trim($where),0,1) != "(") $where = "(" . $where . ")";
			$arr_where[] = $where;
		}
		$where = implode(" and " , $arr_where);
		$arr_return = $obj_db->on_delete(cls_config::DB_PRE."mall_sendinfo" , $where);
		return $arr_return;
	}
}