var pageCart = new function() {
	this.arealist = {};//json格式，指定id包函的子地区
	this.areainfo = {};//对应id地区详细信息
	this.depth = 0;//当前地区深度
	this.sendprice = 0;//配送费
	this.sendprice_default = 0;//默认配送费
	this.sendinfo = [];
	this.info_id = 0;
	this.info_oldid = 0;
	//地区下拉发生改变时触发
	this.changearea = function(val , index , defautval) {
		var obj,i,ii;
		index++;
		//当index大于深度时跳出
		if(index>this.depth) return;
		//发生改变后，重置之后的地区下拉
		for(i = index ; i < this.depth; i++) {
			obj = kj.obj("#id_area_" + i);
			if(!obj) break;
			obj.options.length = 0;
			if(i>index) {
				if(kj.obj("#id_area_" + i)) kj.obj("#id_area_" + i).style.display = 'none';
			}
		}
		var key = "id_" + val;
		var key2 = key;
		if(val!='') {
			for(i = 0; i <10 ;i++) {
				if(key in this.areainfo && kj.toint(this.areainfo[key]["sendprice"])>0) {
					this.sendprice = this.areainfo[key]["sendprice"];
					break;
				}
				if(key in this.areainfo && 'pid' in this.areainfo[key] && this.areainfo[key]["pid"]) {
					key = "id_" + this.areainfo[key]["pid"];
				} else {
					this.sendprice = this.sendprice_default;
					break;
				}
			}
		}
		if(!(key2 in this.arealist) || !("length" in this.arealist[key2]) || !kj.obj("#id_area_" + index)) {
			//跳出则刷新当前地区值
			if(kj.obj("#id_area_" + index)) kj.obj("#id_area_" + index).style.display = 'none';
			this.refresh_area_val();
			return;
		}
		kj.add_option("#id_area_" + index , '' , '');
		for(i = 0 ; i < this.arealist[key2].length ; i++ ) {
			obj = kj.obj("#id_area_" + index);
			ii = this.arealist[key2][i];
			if( !("id_" + ii in this.areainfo ) ) continue;
			kj.add_option(obj , this.areainfo["id_" + ii]["name"] , ii);
			//选中默认值
			if(obj.options[i+1].value == defautval) {
				obj.options[i+1].selected=true;
			}
		}
		if(kj.obj("#id_area_" + index)) kj.obj("#id_area_" + index).style.display = '';
		this.changearea(obj.value , index);
		this.refresh_area_val();
	}
	this.refresh_area_val = function() {
		var obj = kj.obj(":area_id[]");
		var arr_id = [];
		var arr_val = [];
		var val = '';
		var id = 0;
		for(var i = 0 ; i < obj.length ; i++) {
			if(obj[i].value != '') {
				if( !("id_" + obj[i].value in this.areainfo ) ) continue;
				arr_id[arr_id.length] = obj[i].value;
				val = ( 'val' in this.areainfo["id_" + obj[i].value] ) ? this.areainfo["id_" + obj[i].value]['val'] : this.areainfo["id_" + obj[i].value]['name'];
				arr_val[arr_val.length] = val;
			} else {
				break;
			}
		}
		if(arr_id.length>0) {
			kj.obj("#id_area_id").value = arr_id[arr_id.length-1];
		} else {
			kj.obj("#id_area_id").value = '';
		}
		kj.obj("#id_area_allid").value = arr_id.join(",");
		kj.obj("#id_area").value = arr_val.join(" ");
		//同步配送方式
		arr = kj.obj(".Tareaselect select");
		for(i = arr.length-1;i>=0;i--) {
			if(arr[i].style.display == '') {
				if(arr[i].selectedIndex>0) {
					break;//表示可以刷新配送方式
				} else {
					kj.obj("#id_sendinfo").innerHTML = '<li>请选择配送地区</li>';
					return;
				}
			}
		}
		this.load_sendinfo();
	}
	//提交订单
	this.submit = function() {
		//检测配送地区
		if(!this.chk_area_info()) return;
		jscart.save_cookie();
		var obj_form = {};
		//收货信息
		var obj_info_id = kj.radio(document.frmMain.info_id);
		obj_form.info_id = obj_info_id.value;
		if(obj_info_id && obj_info_id.value == '0') {
			obj_form.info_name = document.frmMain.info_name.value;
			obj_form.info_address = document.frmMain.info_address.value;
			obj_form.info_tel = document.frmMain.info_tel.value;
			obj_form.info_area = document.frmMain.info_area.value;
			obj_form.info_area_id = document.frmMain.info_area_id.value;
			obj_form.info_area_allid = document.frmMain.info_area_allid.value;
		}
		//支付方式
		var obj_paymethod = kj.radio(document.frmMain.paymethod);
		if(obj_paymethod) {
			obj_form.paymethod = obj_paymethod.value;
		} else {
			alert("请选择支付方式");
			return;
		}
		//配送方式
		var obj_sendinfo = kj.radio(document.frmMain.sendinfo);
		if(obj_sendinfo) {
			obj_form.sendinfo_id = obj_sendinfo.value;
		} else {
			alert("请选择配送方式");
			return;
		}
		//配送时间
		if(kj.obj("#id_arrivetime").style.display == '') {
			obj_form.arrivetime = document.frmMain.arrivetime.value;
		}
		kj.ajax.post('?app=ajax&app_act=save.order' , obj_form , function(data) {
			var obj_data = kj.json(data);
			if(obj_data.isnull) {
				alert("下单失败，原因：系统繁忙");return;
			}
			if(obj_data.code == '0') {
				kj.alert.show("下单成功" , function() {
					window.open(kj.cfg('baseurl') + "/index.php?app_act=cart.ok&id="+obj_data.id,"_self");
				});
			} else {
				alert(obj_data.msg);
			}
		});
	}
	//
	this.chk_area_info = function() {
		var obj = document.frmMain;
		var obj_infoid = kj.radio(obj.info_id);
		if(!obj_infoid) {
			alert("请选拔配送地址");
			return false;
		}
		if(obj_infoid.value != '0') return true;
		//检查地区
		for(var i = 0 ; i < this.depth ; i++) {
			x = kj.obj("#id_area_" + i);
			if(x && x.value=="" && x.style.display=='') {
				alert("请选择您所在地区范围");
				x.focus();
				return false;
			}
		}
		if(obj.info_address.value == '') {
			alert("收货地址不能为空");
			obj.info_address.focus();
			return false;
		}
		if(obj.info_name.value == '') {
			alert("请填写收货姓名");
			obj.info_name.focus();
			return false;
		}
		if(obj.info_tel.value=='' || !kj.rule.types.tel(obj.info_tel.value)) {
			alert("请填写收货联系电话");
			obj.info_tel.focus();
			return false;
		}
		return true;
	}
	//选择收货地址时
	this.infosel = function(o ,id){
		if(this.info_id) {
			this.info_cancel();
			this.info_id = 0;
		}
		var val,x;
		val = kj.toint(o.value);
		if(val > 0) {
			kj.hide("#id_info_0 .Tnewinfo");
		} else {
			kj.show("#id_info_0 .Tnewinfo");
		}
		kj.delClassName(kj.obj(".area_active") , "area_active");
		kj.addClassName(kj.parent(o , 'ul'), "area_active");

		//同步配送区域
		if(id == 0) {
			arr = kj.obj(".Tareaselect select");
			for(i = arr.length-1;i>=0;i--) {
				if(arr[i].style.display == '') {
					if(arr[i].selectedIndex>0) {
						break;//表示可以刷新配送方式
					} else {
						kj.obj("#id_sendinfo").innerHTML = '<li>请选择配送地区</li>';
						return;
					}
				}
			}
		}
		this.load_sendinfo();
	}
	this.load_sendinfo = function() {
		var arr = kj.obj(".area_active .Tareaids");
		var areaids = '';
		if(arr && arr.length>0) areaids = arr[0].value;
		kj.ajax.get("./common.php?app=mall.ajax&app_act=sendinfo&areaids="+areaids , function(data) {
			pageCart.sendinfo = kj.json(data);
			pageCart.refresh_sendinfo();
		});
	}

	this.refresh_sendinfo = function() {
		var arr = kj.obj(":paymethod");
		var paymethod = '';
		for(var i = 0 ; i < arr.length ; i++) {
			if(arr[i].checked) {
				paymethod = arr[i].value;
			}
		}
		var obj_sendinfo = (document.frmMain.sendinfo) ? kj.radio(document.frmMain.sendinfo) : null;
		sendinfo_val = (obj_sendinfo) ? obj_sendinfo.value : "";
		var obj_data = this.sendinfo;
		var is_payment = false , ischeck = '';
		var html = '' , html2 = '' , html3 = '';
		for(var i = 0 ; i < obj_data.length ; i++) {
			ischeck = (sendinfo_val == obj_data[i].id) ? " checked" : "";
			html = '<li class="row_group"><p class="row_in">';
			html += '<label style="width:150px;display:inline"><input type="radio" value="' + obj_data[i].id + '" name="sendinfo" onclick="pageCart.refresh_time();"'+ischeck+'>';
			html += '<font>' + obj_data[i].name + '</font></label>&nbsp;&nbsp;<font class="Tsendprice" style="display:inline"></font></p></li>';
			html2 += html;
			if(obj_data[i].payment == '1') is_payment = true;
			if(paymethod == 'afterpayment' && obj_data[i].payment != '1' ) continue;
			html3 += html;
		}
		if(html3 == '' || is_payment == false ) {//说明是货到付款，但是没有支持货到付款的配送
			kj.obj("#id_afterpayment").disabled = true;
			kj.obj("#id_afterpayment").checked = false;
			kj.show("#id_afterpayment_beta");
			html3 = html2;
		} else if(kj.obj("#id_afterpayment").disabled == true) {
			kj.obj("#id_afterpayment").disabled = false;
			kj.hide("#id_afterpayment_beta");
		}
		kj.obj("#id_sendinfo").innerHTML = html3;
		this.get_sendprice();
	}

	this.refresh_time = function() {
		var arr = kj.obj(":sendinfo");
		for(var i = 0 ; i < arr.length ; i++) {
			if(arr[i].checked) {
				break;
			}
		}
		if(i >= arr.length) { 
			kj.hide(".Tarrivetime");
			kj.set(".Ttotalsendprice","innerHTML" ,"0");
			jscart.refresh_price();
			return;
		}
		//更新配送费用
		arr= kj.obj("#id_sendprice_" + arr[i].value);
		if(arr) {
			kj.set(".Ttotalsendprice","innerHTML" ,kj.toint(arr.value));
			jscart.refresh_price();
		}
		if( !('length' in this.sendinfo[i].time) || this.sendinfo[i].time.length <1 ) {
			kj.hide(".Tarrivetime");
			return;
		}
		var option = document.frmMain.arrivetime.options;
		option.length = 0;
		for(var j = 0 ; j < this.sendinfo[i].time.length ; j++) {
			kj.add_option(document.frmMain.arrivetime , this.sendinfo[i].time[j] , this.sendinfo[i].time[j]);
		}
		kj.show(".Tarrivetime");
	}

	this.get_sendprice = function() {
		var arr_weight = kj.obj(":weight[]");
		var arr_num = kj.obj(".TcartNum");
		if(!arr_weight || !arr_num) return;
		if(arr_weight.length != arr_num.length) return;
		var weight = 0;
		for(var i = 0 ; i < arr_weight.length ; i++) {
			weight += kj.toint(arr_weight[i].value) * kj.toint(arr_num[i].value);
		}
		this.weight = weight;
		kj.set("#id_total_weight" , "innerHTML" , "重：" + weight + "克");
		var price = 0 , weight_next = 0;
		var arr_sendprice = kj.obj(".Tsendprice");
		for( i = 0 ; i < this.sendinfo.length ; i++ ) {
			weight_next = weight - kj.toint(this.sendinfo[i].unit);
			price = this.sendinfo[i].price;
			if( weight_next > 0 ) {
				x = weight_next/kj.toint(this.sendinfo[i].unit_next);
				if(x > parseInt(x)) x = parseInt(x) + 1;
				price += x * kj.toint(this.sendinfo[i].next);
			}
			html = (price == 0) ? "免运费" : "运费：" + price;
			arr_sendprice[i].innerHTML = html + '<input type="hidden" name="sendprice[]" value="' + price + '" id="id_sendprice_' + this.sendinfo[i].id + '">';
		}
	}

	this.info_edit = function(id) {
		var obj_edit = kj.obj("#id_edit_" + id);
		var obj_new = kj.obj("#id_info_0");
		kj.delClassName(kj.obj(".area_active") , "area_active");
		kj.addClassName("#id_info_0" , "area_active");
		var arr = kj.obj("#id_info_0 :info_id");
		if(arr && arr.length>0) {
			arr[0].checked = true;
		}
		var obj , name = '',tel = '',address = '';
		obj = kj.obj(".Tname" , obj_edit);
		if(obj && obj.length>0) name = obj[0].innerHTML;
		obj = kj.obj(".Ttel" , obj_edit);
		if(obj && obj.length>0) tel = obj[0].innerHTML;
		obj = kj.obj(".Taddress" , obj_edit);
		if(obj && obj.length>0) address = obj[0].innerHTML;
		document.frmMain.info_name.value = name;
		document.frmMain.info_tel.value = tel;
		document.frmMain.info_address.value = address;
		obj = kj.obj(":allids[]" , obj_edit);
		if(obj && obj.length>0) {
			this.info_seldefault(obj[0].value);
		}
		obj = kj.obj(".Ttitle" , obj_new);
		if(obj && obj.length>0) obj[0].innerHTML = '编辑地址';
		var oldid = this.info_oldid;
		if(oldid!='0') kj.show("#id_edit_" + oldid);
		this.info_oldid = id;
		kj.show("#id_info_btn");
		kj.show(".Tnewinfo");
		kj.insert_after(obj_edit.parentNode , obj_edit , obj_new);
		kj.hide(obj_edit);
	}
	this.info_cancel = function() {
		var id = this.info_oldid;
		var obj_edit = kj.obj("#id_edit_" + id);
		var obj_new = kj.obj("#id_info_0");
		kj.show(obj_edit);
		document.frmMain.info_name.value = '';
		document.frmMain.info_tel.value = '';
		document.frmMain.info_address.value = '';
		kj.hide("#id_info_btn");
		kj.hide(".Tnewinfo");
		obj = kj.obj(".Ttitle" , obj_new);
		if(obj && obj.length>0) obj[0].innerHTML = '新地址';
		this.info_oldid = 0;
		kj.insert_before(obj_new.parentNode , kj.obj("#id_paymethod_tit") , obj_new);
		var arr = kj.obj("#id_edit_" + id + " :info_id");
		if(arr && arr.length>0) {
			arr[0].checked = true;
			this.infosel(arr[0] , id);
		}
	}

	this.info_seldefault = function(allid) {
		if(!allid || allid=='') return;
		var arr = allid.split(",");
		//加载默认值选中
		this.select_sel(kj.obj("#id_area_0") , arr[0]);
		for(var i=0 ; i < this.depth ; i++) {
			//if(arr.length-1<=i) break;
			this.changearea(arr[i],i,arr[i+1]);
		}
		if(arr.length<2) this.refresh_area_val();
	}
	this.select_sel = function(obj,val) {
		var is_sel = false;
		for(var i = 0 ; i < obj.length; i++) {
			if(obj[i].value == val) {
				obj[i].selected = true;
				is_sel = true;
				break;
			}
		}
		if(!is_sel && obj.length>0 ) obj[0].selected = true;
	}
	this.info_save = function() {
		if(this.chk_area_info() == false) return;
		var obj_form = {"info_id":this.info_oldid , "info_name":document.frmMain.info_name.value, "info_address":document.frmMain.info_address.value,"info_area":document.frmMain.info_area.value,"info_tel":document.frmMain.info_tel.value,"info_area_id":document.frmMain.info_area_id.value,"info_area_allid":document.frmMain.info_area_allid.value};
		kj.ajax.post('?app=ajax&app_act=info.save' , obj_form , function(data) {
			var obj_data = kj.json(data);
			if(obj_data.isnull) {
				alert("保存失败");
				return;
			}
			if(obj_data.code!='0') {
				alert(obj_data.msg);
			} else {
				var obj_edit = kj.obj("#id_edit_" + pageCart.info_oldid);
				obj = kj.obj(".Tname" , obj_edit);
				if(obj && obj.length>0) obj[0].innerHTML = document.frmMain.info_name.value;
				obj = kj.obj(".Ttel" , obj_edit);
				if(obj && obj.length>0) obj[0].innerHTML = document.frmMain.info_tel.value;
				obj = kj.obj(".Taddress" , obj_edit);
				if(obj && obj.length>0) obj[0].innerHTML = document.frmMain.info_address.value;
				obj = kj.obj(".Tarea" , obj_edit);
				if(obj && obj.length>0) obj[0].innerHTML = document.frmMain.info_area.value;
				pageCart.info_cancel();
			}
		});
	}

}