<?php
/**
 *      [XCECP] (C) COLNET Inc.
 *      This is NOT a freeware, use is subject to license terms
 */
if(!defined("IN_QKWEB")){exit("Access Denied");}
class Uploader
{
	public $msg = '';
    private $fileField;            //文件域名
    private $file;                 //文件上传对象
    private $config;               //配置信息
    private $oriName;              //原始文件名
    private $fileName;             //新文件名
    private $fullName;             //完整文件名,即从当前配置目录开始的URL
    private $fileSize;             //文件大小
    private $fileType;             //文件类型
    private $stateInfo;            //上传状态信息,
    private $stateMap = array(    //上传状态映射表，国际化用户需考虑此处数据的国际化
        "SUCCESS" ,                //上传成功标记，在UEditor中内不可改变，否则flash判断会出错
        "文件大小超出 upload_max_filesize 限制" ,
        "文件大小超出 MAX_FILE_SIZE 限制" ,
        "文件未被完整上传" ,
        "没有文件被上传" ,
        "上传文件为空" ,
        "POST" => "文件大小超出 post_max_size 限制" ,
        "SIZE" => "文件大小超出网站限制" ,
        "TYPE" => "不允许的文件类型" ,
        "DIR" => "目录创建失败" ,
        "IO" => "输入输出错误" ,
        "UNKNOWN" => "未知错误" ,
        "MOVE" => "文件保存时出错"
    );

    /**
     * 构造函数
     * @param string $fileField 表单名称
     * @param array $config  配置项
     * @param bool $base64  是否解析base64编码，可省略。若开启，则$fileField代表的是base64编码的字符串表单名
     */
    public function __construct( $fileField='' , $config='' , $base64 = false )
    {
		if($fileField){
			$this->fileField = $fileField;
			$this->config = $config;
			$this->stateInfo = $this->stateMap[ 0 ];
			$this->upFile( $base64 );
		}
    }

    /**
     * 上传文件的主处理方法
     * @param $base64
     * @return mixed
     */
    private function upFile( $base64 )
    {
        //处理base64上传
        if ( "base64" == $base64 ) {
            $content = $_POST[ $this->fileField ];
            $this->base64ToImage( $content );
            return;
        }

        //处理普通上传
        $file = $this->file = $_FILES[ $this->fileField ];
        if ( !$file ) {
            $this->stateInfo = $this->getStateInfo( 'POST' );
            return;
        }
        if ( $this->file[ 'error' ] ) {
            $this->stateInfo = $this->getStateInfo( $file[ 'error' ] );
            return;
        }
        if ( !is_uploaded_file( $file[ 'tmp_name' ] ) ) {
            $this->stateInfo = $this->getStateInfo( "UNKNOWN" );
            return;
        }

        $this->oriName = $file[ 'name' ];
        $this->fileSize = $file[ 'size' ];
        $this->fileType = $this->getFileExt();

        if ( !$this->checkSize() ) {
            $this->stateInfo = $this->getStateInfo( "SIZE" );
            return;
        }
        if ( !$this->checkType() ) {
            $this->stateInfo = $this->getStateInfo( "TYPE" );
            return;
        }
        $this->fullName = $this->getFolder() . '/' . $this->getName();
        if ( $this->stateInfo == $this->stateMap[ 0 ] ) {
            if ( !move_uploaded_file( $file[ "tmp_name" ] , $this->fullName ) ) {
                $this->stateInfo = $this->getStateInfo( "MOVE" );
            }
        }
    }

    /**
     * 处理base64编码的图片上传
     * @param $base64Data
     * @return mixed
     */
    private function base64ToImage( $base64Data )
    {
        $img = base64_decode( $base64Data );
        $this->fileName = time() . rand( 1 , 10000 ) . ".png";
        $this->fullName = $this->getFolder() . '/' . $this->fileName;
        if ( !file_put_contents( $this->fullName , $img ) ) {
            $this->stateInfo = $this->getStateInfo( "IO" );
            return;
        }
        $this->oriName = "";
        $this->fileSize = strlen( $img );
        $this->fileType = ".png";
    }

    /**
     * 获取当前上传成功文件的各项信息
     * @return array
     */
    public function getFileInfo()
    {
        return array(
            "originalName" => $this->oriName ,
            "name" => $this->fileName ,
            "url" => $this->fullName ,
            "size" => $this->fileSize ,
            "type" => $this->fileType ,
            "state" => $this->stateInfo
        );
    }

    /**
     * 上传错误检查
     * @param $errCode
     * @return string
     */
    private function getStateInfo( $errCode )
    {
        return !$this->stateMap[ $errCode ] ? $this->stateMap[ "UNKNOWN" ] : $this->stateMap[ $errCode ];
    }

    /**
     * 重命名文件
     * @return string
     */
    private function getName()
    {
        return $this->fileName = time() . rand( 1 , 10000 ) . $this->getFileExt();
    }

    /**
     * 文件类型检测
     * @return bool
     */
    private function checkType()
    {
        return in_array( $this->getFileExt() , $this->config[ "allowFiles" ] );
    }

    /**
     * 文件大小检测
     * @return bool
     */
    private function  checkSize()
    {
        return $this->fileSize <= ( $this->config[ "maxSize" ] * 1024 );
    }

    /**
     * 获取文件扩展名
     * @return string
     */
    private function getFileExt()
    {
        return strtolower( strrchr( $this->file[ "name" ] , '.' ) );
    }

    /**
     * 按照日期自动创建存储文件夹
     * @return string
     */
    private function getFolder()
    {
        $pathStr = $this->config[ "savePath" ];
        if ( strrchr( $pathStr , "/" ) != "/" ) {
            $pathStr .= "/";
        }
		/*
        $pathStr .= date( "Ymd" );
        if ( !file_exists( $pathStr ) ) {
            if ( !mkdir( $pathStr , 0777 , true ) ) {
                return false;
            }
        }
		*/
        return $pathStr;
    }

	function goodsPicUp($fileField,$thumb=true){
			$config = array(
				"savePath" => ROOT_PATH."data/attachment/",
				"maxSize" => 1024 , //单位KB
				"allowFiles" => array( ".gif" , ".png" , ".jpg" , ".jpeg" , ".bmp"  )
			);
			$save_path =  ROOT_PATH."/data/attachment/";
			$year = date("Y",time());
			$save_path .=$year."/";
			if(!file_exists($save_path)){mkdir($save_path);}
			$day = date("md",time());
			$save_path .=$day."/";
			if(!file_exists($save_path)){mkdir($save_path);}
			$url_path = "data/attachment/".$year."/".$day."/";
			$config['savePath'] = ROOT_PATH.$url_path;

			$this->fileField = $fileField;
			$this->config = $config;
			$this->stateInfo = $this->stateMap[ 0 ];
			$ret = $this->upFile(false);
			$info = $this->getFileInfo();
			if($info['state']=='SUCCESS'){
				$info['success'] = true;
				$info['url'] = $url_path.$info['name'];
				if($thumb){
					global $db;
					$sql = "insert into qk_attachment set url='".$info['url']."',parentId=0,typeId=1,originalUrl='',posttime=UNIX_TIMESTAMP()";
					$db->query($sql);
					$insertId = $db->insert_id();
					$thumb = $this->goodsThumbCreate($insertId);
					if($thumb['success']){
						$info['data'] = $thumb['data'];
					}
				}
			}else{
				$info['success'] = false;
			}
			return $info;
	}

	function goodsPicSave($url,$thumb=true){
		$url = trim($url);
		if(substr($url,0,7)!="http://"){$this->msg='该网络图片地址错误';return false;}
		global $db;
		//$id = $db->getOne("select id from qk_attachment where originalUrl='$url'");
		//if($id){$this->msg='该网络图片已存在';return false;}
		//$url = strtolower($url);
		$img = fopen($url,'rb');
		if(!$img){$this->msg='打开网络图片失败';return false;}
		$file = "";
		while(!feof($img)){$file .= fgets($img,1024);}
		fclose($img);
		$save_path =  ROOT_PATH."/data/attachment/";
		$year = date("Y",time());
		$save_path .=$year."/";
		if(!file_exists($save_path)){if(!@mkdir($save_path)){ $this->msg='创建图片目录失败，请检查data目录权限';return false; };}
		$day = date("md",time());
		$save_path .=$day."/";
		if(!file_exists($save_path)){if(!@mkdir($save_path)){ $this->msg='创建图片目录失败，请检查data目录权限';return false; };}
		$url_path = "data/attachment/".$year."/".$day."/";
		$insertId = false;
		if(preg_match("/\.png$/",$url)){
			$ext = ".png";
		}
		if(preg_match("/\.gif$/",$url)){
			$ext = ".gif";
		}
		if(preg_match("/\.bmp$/",$url)){
			$ext = ".bmp";
		}
		if(preg_match("/\.(jpg|jpeg)$/",$url)){
			$ext = ".jpg";
		}
		$filename = time().rand(1000,9999);
		$filename =  $url_path.$filename.$ext;

	$write = @fopen(ROOT_PATH.$filename,"w");
	if($write==false){$this->msg='打开新文件失败';return false;}     
	if(fwrite($write,$file)==false){$this->msg='写入新文件失败';return false;}
    if(fclose($write)==false){$this->msg='结束写入新文件失败';return false;}
	$sql = "insert into qk_attachment set url='$filename',parentId=0,typeId=1,originalUrl='$url',posttime=UNIX_TIMESTAMP()";
	$db->query($sql);
	$insertId = $db->insert_id();
	$info=array("success"=>true,"url"=>$filename);
	if($thumb){
		$thumb = $this->goodsThumbCreate($insertId);
		if($thumb['success']){
				$info['data'] = $thumb['data'];
		}
	}
	return $info;
		//file_put_contents();

	}

	function goodsThumbCreate($orifile,$indb=true){
		global $db;
		$save_path =  ROOT_PATH."/data/attachment/";
		$year = date("Y",time());
		$save_path .=$year."/";
		if(!file_exists($save_path)){mkdir($save_path);}
		$day = date("md",time());
		$save_path .=$day."/";
		if(!file_exists($save_path)){mkdir($save_path);}
		$url_path = "data/attachment/".$year."/".$day."/";
		$insertId = false;
		if(is_numeric($orifile)){
			$insertId = $orifile;
			$url = $db->getOne("select url from qk_attachment where id='$insertId'");
			if($url && substr($url,0,7)!='http://'){
				$orifile = ROOT_PATH.$url;
			}else{
				return false;
			}
		}else{
			if(substr($orifile,0,7)!="http://"){
				$insertId = $db->getOne("select id from qk_attachment where url='$orifile' order by id asc limit 1");
				if(!$insertId){
					if(file_exists(ROOT_PATH.$orifile)){
						$db->query("insert into qk_attachment set url='$orifile',parentId=0,typeId=1,posttime=UNIX_TIMESTAMP()");
						$insertId = $db->insert_id();
						$orifile  = ROOT_PATH.$orifile;
					}else{
						return false;
					}
				}else{
					$orifile = ROOT_PATH.$orifile;
				}
			}
		}
		$info = getimagesize($orifile);
		$file_name = basename($orifile);
		$w = $info[0];
		$h  = $info[1];
		$surl=$url_path;
		if(($w!=PREVIEW_SW || $h!=PREVIEW_SH) && ($w>PREVIEW_SW || $h>PREVIEW_SH)){
			$opath = $save_path;
			$save_path .= "s/";
			$surl .= "s/";
			if(!file_exists($save_path)){mkdir($save_path);}
			img2thumb($orifile,$save_path.$file_name,PREVIEW_SW,PREVIEW_SH);
		}
		if($indb && $insertId){
			if(!$s_insertId = $db->getOne("select id from qk_attachment where url='".$surl.$file_name."' and parentId='$insertId' and typeId=2 order by id asc")){
				$sql = "insert into qk_attachment set url='".$surl.$file_name."',parentId=".$insertId.",typeId=2,posttime=UNIX_TIMESTAMP()";
				$db->query($sql);
				$s_insertId = $db->insert_id();
			}
		}
		if(!isset($s_insertId) || !settype($s_insertId,"integer")){$s_insertId=0;}
		$save_path = $opath;
		$murl=$url_path;
		if(($w!=PREVIEW_MW || $h!=PREVIEW_MH) && ($w>PREVIEW_MW || $h>PREVIEW_MH)){
			$opath = $save_path;
			$save_path .= "m/";
			$murl.="m/";
			if(!file_exists($save_path)){mkdir($save_path);}
			img2thumb($orifile,$save_path.$file_name,PREVIEW_MW,PREVIEW_MH);
		}
		if($indb && $insertId){
			if(!$m_insertId = $db->getOne("select id from qk_attachment where url='".$murl.$file_name."' and parentId='$insertId' and typeId=3 order by id asc")){
				$sql = "insert into qk_attachment set url='".$murl.$file_name."',parentId=".$insertId.",typeId=3,posttime=UNIX_TIMESTAMP()";
				$db->query($sql);
				$m_insertId = $db->insert_id();
			}
		}
		if(!isset($m_insertId) || !settype($m_insertId,"integer")){$m_insertId=0;}
		//大图
		$save_path = $opath;
		$lurl=$url_path;
		if(($w!=PREVIEW_LW || $h!=PREVIEW_LH) && ($w>PREVIEW_LW || $h>PREVIEW_LH)){
			$opath = $save_path;
			$save_path .= "l/";
			$lurl.="l/";
			if(!file_exists($save_path)){mkdir($save_path);}
			img2thumb($orifile,$save_path.$file_name,PREVIEW_LW,PREVIEW_LH);
		}
		if($indb && $insertId){
			if(!$l_insertId = $db->getOne("select id from qk_attachment where url='".$lurl.$file_name."' and parentId='$insertId' and typeId=4 order by id asc")){
				$sql = "insert into qk_attachment set url='".$lurl.$file_name."',parentId=".$insertId.",typeId=4,posttime=UNIX_TIMESTAMP()";
				$db->query($sql);
				$l_insertId = $db->insert_id();
			}
		}
		if(!isset($l_insertId) || !settype($l_insertId,"integer")){$l_insertId=0;}
		$save_path = $opath;
		if($s_insertId){$insertId.=",".$s_insertId;}
		if($m_insertId){$insertId.=",".$m_insertId;}
		if($l_insertId){$insertId.=",".$l_insertId;}
		$ret = array('success'=>true,'data'=>$insertId);
		return $ret;
	}
}