<?php
class Upop extends Pay{
	private $info;
	private $path;
	function __construct(){
		$path = str_replace("/Upop.class.php","/",str_replace("\\","/",__FILE__));
		$this->path = $path;
	}

	function pay($paymentId,$amount,$tradeNo,$loginName="",$name=""){
		$payConfig = $this->getConfig($paymentId);
		if(!$payConfig){Msg::show('该支付接口未配置');}
		$bankCode = getgpc('bankCode');
		if(!preg_match("/^([A-Z]+)$/",$bankCode)){$bankCode='';}
		$payConfig['backEndUrl']="http://".$_SERVER['HTTP_HOST']."/pay/payNotify/upop";
		$payConfig['frontEndUrl']="http://".$_SERVER['HTTP_HOST']."/pay/payReturn/upop";
		$url = 'https://unionpaysecure.com/api/Pay.action';
		$param=array(
			'version'=>'1.0.0',
			'charset'=>'UTF-8',
			'signMethod'=>'md5',
			'signature'=>'',
			'transType'=>'01',
			'merAbbr'=>$payConfig['merAbbr'],
			'merId'=>$payConfig['merId'],
			'merCode'=>$payConfig['merCode'],
			'backEndUrl'=>$payConfig['backEndUrl'],
			'frontEndUrl'=>$payConfig['frontEndUrl'],
			'acqCode'=>$payConfig['acqCode'],
			'orderTime'=>date('YmdHis'),
			'orderNumber'=>$tradeNo,
			'commodityName'=>'',
			'commodityUrl'=>'',
			'commodityUnitPrice'=>'',
			'commodityQuantity'=>'',
			'transferFee'=>'',
			'commodityDiscount'=>'',
			'orderAmount'=>$amount*100,
			'orderCurrency'=>'156',
			'customerName'=>'',
			'defaultPayType'=>'',
			'defaultBankNumber'=>'',
			'transTimeout'=>'',
			'customerIp'=>getIp(),
			'origQid'=>'',
			'merReserved'=>''
		);

		$param['signature'] = $this->secret($param,$payConfig['secret']);		
		echo parent::html($url,$param,'post');
	}
	function secret($param,$secret){
		ksort($param);$str = '';
		foreach($param as $key=>$val){if($key!="signMethod" && $key!="signature"){$str .= $key.'='.$val.'&';}}
		$str .= md5($secret);	//echo $str;
		return md5($str);
	}
	
	function check($notify=false,$secret){
		$upopParam = array('charset','cupReserved','exchangeDate','exchangeRate','merAbbr','merId','orderAmount','orderCurrency','orderNumber','qid','respCode','respMsg','respTime','settleAmount','settleCurrency','settleDate','traceNumber','traceTime','transType','version','signMethod','signature','cupReserved');
		if(isset($_POST) && count($_POST)>0){
			$param=array();foreach($_POST as $key=>$val){ if(in_array($key,$upopParam)){ $param[$key]=$val; } }
			ksort($param);//print_R($param);exit;
			$str = '';
			foreach($param as $key=>$val){if($key!="signMethod" && $key!="signature"){$str .= $key.'='.$val.'&';}}
			$str .= md5($secret);//echo $secret;
			$signature = md5($str);
			if($signature == $param['signature']){
				$orderNumber = $param['orderNumber'];
				$qid = $param['qid'];
				$orderAmount = $param['orderAmount'];
				$respCode = $param['respCode'];
				$respMsg = $param['respMsg'];
				$this->msg = 'Success';return true;
			}else{
				$this->msg = 'Signature Error';return false;
			}
		}else{
			$this->msg = 'Data Empty';return false;
		}
		return false;
	}

	function payNotify(){
		$orderNumber = getgpc('orderNumber');
		$log = '';foreach($_REQUEST as $key=>$val){$log .= $key.'='.$val.'&';}if($log){saveLog('服务器端：银联通知数据：'.$log);}
		$paymentId = $GLOBALS['db']->getOne("select paymentId from qk_onlinepay where outTradeNo='".$orderNumber."'");
		if(!$paymentId){echo '订单不存在';exit;}
		$payConfig = $this->getConfig($paymentId);
		$secret = $payConfig['secret'];//echo $secret;
		if($this->check(true,$secret)){
			$resultShow = "http://".$_SERVER['HTTP_HOST']."/pay/result/status/failed";
			$result = '1';
			$respCode=getgpc('respCode','P');
			$orderAmount = getgpc('orderAmount','P');
			if($respCode=='00'){//成功
					if($url=$this->payResult($orderNumber,$orderAmount/100,$remark,getgpc("qid",'P'))){
						 saveLog('服务器端：支付结果本地校验成功');
						 if(preg_match("/^http:\/\//",$url)){
							$resultShow = $url;
						 }else{
							$resultShow = "http://".$_SERVER['HTTP_HOST']."/pay/result/status/success";
						 }
						$result = '1';
					}else{
						 saveLog('服务器端：支付结果本地校验失败');
					}
			 }else{	
				 saveLog('服务器端：返回的支付结果非交易成功');
			 }
			echo '<result>'.$result.'</result><redirecturl><![CDATA['.$resultShow.']]></redirecturl>';
		}else{
				saveLog('服务器端：签名错误！');
			die("签名错误！");
		}
	}
	function payReturn(){
		return true;
	}
}
?>