<?php
error_reporting(E_ALL ^ E_NOTICE);
require '../Baidu.php';

require("config.php");
$baidu = new Baidu($apiKey, $secretKey, new BaiduCookieStore($apiKey));
//$baidu->useHttps();

// Get User ID
$user = $baidu->getLoggedInUser();
//print_r($user);	//Array ( [uid] => 2501329766 [uname] => qkweb ) 
if ($user) {
	$user_profile = $baidu->api('passport/users/getInfo', array('fields' => 'userid,username,sex,birthday'));
	if ($user_profile === false) {
		//get user profile failed
		var_dump(var_export(array('errcode' => $baidu->errcode(), 'errmsg' => $baidu->errmsg()), true));
		$user = null;
	}
}

// Login or logout url will be needed depending on current user state.
$host = $_SERVER['HTTP_HOST'];
if ($user) {
  $logoutUrl = $baidu->getLogoutUrl(array('next' => 'http://'.$host.'/demo/logout_callback2.php'));
} else {
  $loginUrl = $baidu->getLoginUrl(array('response_type' => 'code',
  										'redirect_uri' => 'http://'.$host.'/demo/login_callback2.php'));
}
echo $loginUrl;
?>
<!doctype html>
<html>
  <head>
  	<meta http-equiv="content-type" content="text/html;charset=utf-8">
    <title>php-sdk</title>
    <link rel="stylesheet" type="text/css" href="LightFace.css"> 
    <style>
      body {
        font-family: 'Lucida Grande', Verdana, Arial, sans-serif;
      }
      h1 a {
        text-decoration: none;
        color: #3b5998;
      }
      h1 a:hover {
        text-decoration: underline;
      }
    </style>
  </head>
  <body>
    <h1>php-sdk</h1>

    <?php if ($user): ?>

      <a id="logoutfrombaidu" href="<?php echo $logoutUrl; ?>">Logout</a>
    <?php else: ?>
      <div>
        Login using OAuth 2.0 handled by the PHP SDK:
        <a id="loginwithbaidu" href="#">Login with Baidu</a>
      </div>
    <?php endif ?>

    <h3>User Cookie:</h3>
    <pre><?php print_r($_COOKIE); ?></pre>

    <?php if ($user): ?>
      <h3>Your User Object:</h3>
      <pre><?php var_dump(var_export($user_profile, true)); ?></pre>
    <?php else: ?>
      <strong><em>You are not Connected.</em></strong>
    <?php endif ?>
    <div id="logindialog"></div>
    
    <script type="text/javascript" src="mootools-1.3.js"></script> 
	<script type="text/javascript" src="LightFace.js"></script> 
	<script type="text/javascript" src="LightFace.IFrame.js"></script> 
    
    <script>
	
    <?php if (!$user): ?>
    document.id('loginwithbaidu').addEvent('click',function() {
    	new LightFace.IFrame({height:320, width:560, url: '<?php echo $loginUrl;?>'}).open();
    });
    new LightFace.IFrame({height:320, width:560, url: '<?php echo $loginUrl;?>'}).open();
    
    <?php else: ?>
    document.id('logoutfrombaidu').addEvent('click', function() {
		document.getElementById('logout_form').submit();
		return false;
    });
    <?php endif ?>
    </script>
  <script src="http://app.baidu.com/static/appstore/monitor.st"></script>
  <script>
  baidu.app.autoHeight();
  baidu.app.setHeight(400);
  </script>
  </body>
</html>
