<?php
define("IN_QKWEB",true);
require("../../includes/init.php");
// Code for Session Cookie workaround
	if (isset($_POST["PHPSESSID"])) {
		session_id($_POST["PHPSESSID"]);
	} else if (isset($_GET["PHPSESSID"])) {
		session_id($_GET["PHPSESSID"]);
	}
	session_start();
// Check post_max_size (http://us3.php.net/manual/en/features.file-upload.php#73762)
	$POST_MAX_SIZE = ini_get('post_max_size');
	$unit = strtoupper(substr($POST_MAX_SIZE, -1));
	$multiplier = ($unit == 'M' ? 1048576 : ($unit == 'K' ? 1024 : ($unit == 'G' ? 1073741824 : 1)));

	if ((int)$_SERVER['CONTENT_LENGTH'] > $multiplier*(int)$POST_MAX_SIZE && $POST_MAX_SIZE) {
		header("HTTP/1.1 500 Internal Server Error"); // This will trigger an uploadError event in SWFUpload
		echo "POST exceeded maximum allowed size.";
		exit(0);
	}

// Settings
if(!file_exists(ROOT_PATH."data")){HandleError("Path data not exists");exit();}
if(!file_exists(ROOT_PATH."data/attachment")){HandleError("Path attachment not exists");exit();}
	$save_path =  ROOT_PATH."/data/attachment/";				// The path were we will save the file (getcwd() may not be reliable and should be tested in your environment)
	$year = date("Y",time());
	$save_path .=$year."/";
	if(!file_exists($save_path)){mkdir($save_path);}
	$day = date("md",time());
	$save_path .=$day."/";
	if(!file_exists($save_path)){mkdir($save_path);}

	$url_path = "data/attachment/".$year."/".$day."/";
	$upload_name = "Filedata";
	$max_file_size_in_bytes = 2147483647;				// 2GB in bytes
	$extension_whitelist = array("jpg", "gif", "png","zip","rar");	// Allowed file extensions
	$valid_chars_regex = '.A-Z0-9_ !@#$%^&()+={}\[\]\',~`-';				// Characters allowed in the file name (in a Regular Expression format)
	
// Other variables	
	$MAX_FILENAME_LENGTH = 260;
	$file_name = "";
	$file_extension = "";
	$uploadErrors = array(
        0=>"There is no error, the file uploaded with success",
        1=>"The uploaded file exceeds the upload_max_filesize directive in php.ini",
        2=>"The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
        3=>"The uploaded file was only partially uploaded",
        4=>"No file was uploaded",
        6=>"Missing a temporary folder"
	);


// Validate the upload
	if (!isset($_FILES[$upload_name])) {
		HandleError("No upload found in \$_FILES for " . $upload_name);
		exit(0);
	} else if (isset($_FILES[$upload_name]["error"]) && $_FILES[$upload_name]["error"] != 0) {
		HandleError($uploadErrors[$_FILES[$upload_name]["error"]]);
		exit(0);
	} else if (!isset($_FILES[$upload_name]["tmp_name"]) || !@is_uploaded_file($_FILES[$upload_name]["tmp_name"])) {
		HandleError("Upload failed is_uploaded_file test.");
		exit(0);
	} else if (!isset($_FILES[$upload_name]['name'])) {
		HandleError("File has no name.");
		exit(0);
	}
	
// Validate the file size (Warning: the largest files supported by this code is 2GB)
	$file_size = @filesize($_FILES[$upload_name]["tmp_name"]);
	if (!$file_size || $file_size > $max_file_size_in_bytes) {
		HandleError("File exceeds the maximum allowed size");
		exit(0);
	}
	
	if ($file_size <= 0) {
		HandleError("File size outside allowed lower bound");
		exit(0);
	}


// Validate file name (for our purposes we'll just remove invalid characters)
	$file_name = preg_replace('/[^'.$valid_chars_regex.']|\.+$/i', "", basename($_FILES[$upload_name]['name']));
	if (strlen($file_name) == 0 || strlen($file_name) > $MAX_FILENAME_LENGTH) {
		HandleError("Invalid file name");
		exit(0);
	}

// Validate file extension
	$path_info = pathinfo($_FILES[$upload_name]['name']);
	$file_extension = $path_info["extension"];
	$is_valid_extension = false;
	foreach ($extension_whitelist as $extension) {
		if (strcasecmp($file_extension, $extension) == 0) {
			$is_valid_extension = true;
			break;
		}
	}
	if (!$is_valid_extension) {
		HandleError("Invalid file extension");
		exit(0);
	}

	if($file_extension=="jpg" || $file_extension=="png" || $file_extension=="gif" || $file_extension=="bmp"){
		$file_name = time().rand(1000,9999).".".$file_extension;
	}

	function checkExists($file){
		global $save_path;
		global $file_extension;
		if(file_exists($save_path.$file)){
			$file_name = time().rand(1000,9999).".".$file_extension;
			return checkExists($file_name);

		}else{
			return array("return"=>true,"fileName"=>$file);
		}
	}
	
	$c = checkExists($file_name);
	if($c['return']){
		$file_name = $c['fileName'];
	}

// Validate that we won't over-write an existing file
	if (file_exists($save_path . $file_name)) {
		HandleError("File with this name already exists".$_FILES[$upload_name]['type'].$upload_name.$_FILES[$upload_name]['name']);
		exit(0);
	}

// Validate file contents (extension and mime-type can't be trusted)
	/*
		Validating the file contents is OS and web server configuration dependant.  Also, it may not be reliable.
		See the comments on this page: http://us2.php.net/fileinfo
		
		Also see http://72.14.253.104/search?q=cache:3YGZfcnKDrYJ:www.scanit.be/uploads/php-file-upload.pdf+php+file+command&hl=en&ct=clnk&cd=8&gl=us&client=firefox-a
		 which describes how a PHP script can be embedded within a GIF image file.
		
		Therefore, no sample code will be provided here.  Research the issue, decide how much security is
		 needed, and implement a solution that meets the needs.
	*/


// Process the file
	/*
		At this point we are ready to process the valid file. This sample code shows how to save the file. Other tasks
		 could be done such as creating an entry in a database or generating a thumbnail.
		 
		Depending on your server OS and needs you may need to set the Security Permissions on the file after it has
		been saved.
	*/
	if (!@move_uploaded_file($_FILES[$upload_name]["tmp_name"], $save_path.$file_name)) {
		HandleError("File could not be saved");
		exit(0);
	}else{
		$sql = "insert into qk_attachment set url='".$url_path.$file_name."',typeId=1,posttime=UNIX_TIMESTAMP()";
		$db->query($sql);
		$insertId = $db->insert_id();
		if(!settype($insertId,"integer")){$insertId=0;}
		$info = getimagesize($save_path.$file_name);
		$w = $info[0];
		$h  = $info[1];
$type = getgpc("type");
$createThumb = getgpc("createThumb");
$surl=$url_path;
if($type=="goods"){
//Сͼ
		if($createThumb=="true" && ($w!=160 || $h!=160) && ($w>160 || $h>160)){
			$opath = $save_path;
			$save_path .= "s/";
			$surl .= "s/";
			if(!file_exists($save_path)){mkdir($save_path);}
			img2thumb($opath.$file_name,$save_path.$file_name,160,160);
		}
		$sql = "insert into qk_attachment set url='".$surl.$file_name."',parentId=".$insertId.",typeId=2,posttime=UNIX_TIMESTAMP()";
		$db->query($sql);
		$s_insertId = $db->insert_id();
		if(!settype($s_insertId,"integer")){$s_insertId=0;}
		$save_path = $opath;

//ͼ
		$murl=$url_path;
		if($createThumb=="true" && ($w!=350 || $h!=350) && ($w>350 || $h>350)){
			$opath = $save_path;
			$save_path .= "m/";
			$murl.="m/";
			if(!file_exists($save_path)){mkdir($save_path);}
			img2thumb($opath.$file_name,$save_path.$file_name,350,350);
		}
		$sql = "insert into qk_attachment set url='".$murl.$file_name."',parentId=".$insertId.",typeId=3,posttime=UNIX_TIMESTAMP()";
		$db->query($sql);
		$m_insertId = $db->insert_id();
		if(!settype($m_insertId,"integer")){$m_insertId=0;}
		$save_path = $opath;
//ͼ
		$lurl=$url_path;
		if($createThumb=="true" && ($w!=800 || $h!=800) && ($w>800 || $h>800)){
			$opath = $save_path;
			$save_path .= "l/";
			$lurl.="l/";
			if(!file_exists($save_path)){mkdir($save_path);}
			img2thumb($opath.$file_name,$save_path.$file_name,800,800);
		}
		$sql = "insert into qk_attachment set url='".$lurl.$file_name."',parentId=".$insertId.",typeId=4,posttime=UNIX_TIMESTAMP()";
		$db->query($sql);
		$l_insertId = $db->insert_id();
		if(!settype($l_insertId,"integer")){$l_insertId=0;}
		$save_path = $opath;
		
		if($s_insertId){$insertId.=",".$s_insertId;}
		if($m_insertId){$insertId.=",".$m_insertId;}
		if($l_insertId){$insertId.=",".$l_insertId;}
}

		HandleError('{"success":true,"url":"'.urlencode($surl.$file_name).'","id":"'.$insertId.'"}');
	}

	exit(0);

/* Handles the error output. This error message will be sent to the uploadSuccess event handler.  The event handler
will have to check for any error messages and react as needed. */
function HandleError($message) {
	echo $message;
}
?>