<?php

include('../api.php');

define('API_DELETEUSER', 1);		//note ûɾ API ӿڿ
define('API_RENAMEUSER', 1);		//note û API ӿڿ
define('API_GETTAG', 1);		//note ȡǩ API ӿڿ
define('API_SYNLOGIN', 1);		//note ͬ¼ API ӿڿ
define('API_SYNLOGOUT', 1);		//note ͬǳ API ӿڿ
define('API_UPDATEPW', 1);		//note û 
define('API_UPDATEBADWORDS', 1);	//note ¹ؼб 
define('API_UPDATEHOSTS', 1);		//note  
define('API_UPDATEAPPS', 1);		//note Ӧб 
define('API_UPDATECLIENT', 1);		//note ¿ͻ˻ 
define('API_UPDATECREDIT', 1);		//note û 
define('API_GETCREDITSETTINGS', 1);	//note  UCenter ṩ 
define('API_GETCREDIT', 1);		//note ȡûĳ 
define('API_UPDATECREDITSETTINGS', 1);	//note Ӧû 

define('API_RETURN_SUCCEED', '1');
define('API_RETURN_FAILED', '-1');
define('API_RETURN_FORBIDDEN', '-2');


define('UC_KEY',PHPAPP::$config['uc_key']); 

define('UC_APPID',PHPAPP::$config['uc_appid']);


if(!defined('IN_UC')) {

	error_reporting(0);
	set_magic_quotes_runtime(0);
	
	defined('MAGIC_QUOTES_GPC') || define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());

	$_DCACHE = $get = $post = array();

	$code = @$_GET['code'];
	parse_str(_authcode($code, 'DECODE', UC_KEY), $get);

	$timestamp = time();
	if($timestamp - $get['time'] > 3600) {
		exit('Authracation has expiried');
	}
	if(empty($get)) {
		exit('Invalid Request');
	}

	require_once '../phpapp/apps/ucclient/uc_client/lib/xml.class.php';
	$post = xml_unserialize(file_get_contents('php://input'));
	
	if(in_array($get['action'], array('test', 'deleteuser', 'renameuser', 'gettag', 'synlogin', 'synlogout', 'updatepw', 'updatebadwords', 'updatehosts', 'updateapps', 'updateclient', 'updatecredit', 'getcreditsettings', 'updatecreditsettings'))) {

		$uc_note = new uc_note();
		exit($uc_note->$get['action']($get, $post));
	} else {
		exit(API_RETURN_FAILED);
	}



}

class uc_note {
	
	 var $appdir = '';


	function _serialize($arr, $htmlon = 0) {
		if(!function_exists('xml_serialize')) {
			include_once ROOT.'/uc_client/lib/xml.class.php';
		}
		return xml_serialize($arr, $htmlon);
	}
	
	
	 function uc_note() {
		  $this->appdir = substr(dirname(__FILE__), 0, -3).'./phpapp/apps/ucclient';
	 }
	 
     function test($get, $post) {
	      return API_RETURN_SUCCEED;
     }

	 function updatehosts($get, $post) {
		if(!API_UPDATEHOSTS) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = $this->appdir.'/uc_client/data/cache/hosts.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'hosts\'] = '.var_export($post, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	function updateapps($get, $post) {
		if(!API_UPDATEAPPS) {
			return API_RETURN_FORBIDDEN;
		}
		$UC_API = $post['UC_API'];

		$cachefile = $this->appdir.'/uc_client/data/cache/apps.php';
		
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'apps\'] = '.var_export($post, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);

		return API_RETURN_SUCCEED;
	}

	function updateclient($get, $post) {
		if(!API_UPDATECLIENT) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = $this->appdir.'/uc_client/data/cache/settings.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'settings\'] = '.var_export($post, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	function updatebadwords($get, $post) {
		if(!API_UPDATEBADWORDS) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = $this->appdir.'/uc_client/data/cache/badwords.php';
		$fp = fopen($cachefile, 'w');
		$data = array();
		if(is_array($post)) {
			foreach($post as $k => $v) {
				$data['findpattern'][$k] = $v['findpattern'];
				$data['replace'][$k] = $v['replacement'];
			}
		}
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'badwords\'] = '.var_export($data, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	function updatepw($get, $post) {
		if(!API_UPDATEPW) {
			return API_RETURN_FORBIDDEN;
		}
		
		$uid = $get['uid'];
		$username = $get['username'];
		$password = $get['password'];
		
		return API_RETURN_SUCCEED;
	}
	
	
	function synlogin($get, $post) {
		 
		$username = $get['username'];
		$uid = $get['uid'];
		
		if(!API_SYNLOGIN) {
			return API_RETURN_FORBIDDEN;
		}

		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
		
        include_once(APPS.'/member/main_phpapp.php');
		
		$member=new MemberMainControls();
		
        $member->SetCookies($uid,$username);
		
	}

	function synlogout($get, $post) {
		
		if(!API_SYNLOGOUT) {
			return API_RETURN_FORBIDDEN;
		}

		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
		
		include_once(APPS.'/member/main_phpapp.php');
		$member=new MemberMainControls();
        $member->OutLoginAction();
		
	}
	
	
	function updatecredit($get, $post) {

		if(!API_UPDATECREDIT) {
			return API_RETURN_FORBIDDEN;
		}
		
        $credit = intval($get['credit']);
		$amount = intval($get['amount']);
		$uid = intval($get['uid']);

		if($uid){
			
			  if($credit){
				   include_once(APPS.'/apppay/class/consume_class_phpapp.php');
				   $consume=new UserConsume();
				   $consume->UpdateUserConsumeMoney($amount,$uid);
			  }else{
				   include_once(APPS.'/credit/member_phpapp.php');
			       $credit=new CreditMemberControls($uid);
			       $credit->UpdateUserCredit($amount,$uid);
			  }
		}
		
		return API_RETURN_SUCCEED;
	}

	function getcredit($get, $post) {

		if(!API_GETCREDIT) {
			return API_RETURN_FORBIDDEN;
		}
		
		$uid = intval($get['uid']);
		
		if($uid){
			
			  include_once(APPS.'/credit/member_phpapp.php');
			  $credit=new CreditMemberControls($uid);
			  return $credit->GetUserCredit($uid);
			
		}else{

		      return 0;
		
		}
		
	}

	function getcreditsettings($get, $post) {
			
		if(!API_GETCREDITSETTINGS) {
			return API_RETURN_FORBIDDEN;
		}
	
		$credits = array(array("",""),array("","Ԫ"));
		//foreach($_G['setting']['extcredits'] as $id => $extcredits) {
			//$credits[$id] = array(strip_tags($extcredits['title']), $extcredits['unit']);
		//}
		return $this->_serialize($credits);
	}

	function updatecreditsettings($get, $post) {
		if(!API_UPDATECREDITSETTINGS) {
			return API_RETURN_FORBIDDEN;
		}
	
		$outextcredits = array();
		foreach($get['credit'] as $appid => $credititems) {
			if($appid == UC_APPID) {
				foreach($credititems as $value) {
					$outextcredits[$value['appiddesc'].'|'.$value['creditdesc']] = array(
						'appiddesc' => $value['appiddesc'],
						'creditdesc' => $value['creditdesc'],
						'creditsrc' => $value['creditsrc'],
						'title' => $value['title'],
						'unit' => $value['unit'],
						'ratiosrc' => $value['ratiosrc'],
						'ratiodesc' => $value['ratiodesc'],
						'ratio' => $value['ratio']
					);
				}
			}
		}
		$tmp = array();
		foreach($outextcredits as $value) {
			$key = $value['appiddesc'].'|'.$value['creditdesc'];
			if(!isset($tmp[$key])) {
				$tmp[$key] = array('title' => $value['title'], 'unit' => $value['unit']);
			}
			$tmp[$key]['ratiosrc'][$value['creditsrc']] = $value['ratiosrc'];
			$tmp[$key]['ratiodesc'][$value['creditsrc']] = $value['ratiodesc'];
			$tmp[$key]['creditsrc'][$value['creditsrc']] = $value['ratio'];
		}
		$outextcredits = $tmp;
	
		$cachefile = $this->appdir.'/uc_client/data/cache/creditsettings.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'creditsettings\'] = '.var_export($outextcredits, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
	
		return API_RETURN_SUCCEED;
	}

}


function _authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
	$ckey_length = 4;

	$key = md5($key ? $key : UC_KEY);
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
				return '';
			}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}

}