<?php

defined('XUEJIAN') || exit('Access Denied!');
/**
RSS类，节省自雪箭主题
*/

class RSS_X {
	// 判断是否开启固定链接形式
	protected $structure = '';

	/**
	载入RSS环境、并将固定链接写入$structure成员中，此功能
	若写在构造方法中，当关闭RSS功能时将产生Cannot redeclare的错误，不过可以使用include_once载入也可避免此错误，
	此处直接使用一个方法来载入更安全
	*/
	public function load_rss_script () {
		$this->structure = '1';
		include(ABSPATH . WPINC . '/rss.php');
	}

	/**
	获取RSS URL
	功能：通过$this->structure判断是否开启固定链接形式、拼接合适的RSS URL并返回
	@access protected 受保护非公开的方法
	@param $blog_url string 博客网址
	@return string 返回动态或静态形式的RSS URL
	*/
	protected function get_rss_url ($blog_url,$cat) {
		return $this->structure ? $blog_url . '/feed/?cat=' . $cat : $blog_url . '/?feed=rss2&cat=' . $cat;
	}

	/**
	获取RSS数据
	@param $blog_url string 博客网址、非RSS数据源地址，不包含网址后面的斜杠(/)
	@param $count int 获取RSS条目数
	@param $cat int 分类ID，指定获取或排除分类，排除分类前面加'-'，多个之间加'&cat='，如：-3&cat=-5
	@return array 返回
	*/
	public function fetch_rss ($blog_url = '', $count = 10, $cat = 0) {
		if (function_exists('fetch_rss')) {
			$rss_url = $this->get_rss_url($blog_url, $cat);
			if ($rss = @fetch_rss($rss_url,$count)) {
				return array_slice($rss->items, 0, $count);
			}
		}
	}

}