<?php
defined('XUEJIAN') || exit('Access Denied!');

// Robot class
class Robot {
	private $errors = array(
		'Insufficient permissions',
		'Token call limited',
		'Invalid app',
		'Invalid keyword',
		'Connect failed',
		'Curl disabled',
		'Success',
	);
	private $item_id = '0';

	// error report
	public function error ($errno) {
		echo $this->errors[$errno];
		exit;
	}

	// item id exists?
	public function exists ($item_id) {
		$this->item_id = $item_id;
		$post_id = $this->getPost();
		$post_id = $post_id == '0' ? $this->getPost('draft') : $post_id;
		$post_id = $post_id == '0' ? $this->getPost('trash') : $post_id;
		return $post_id;
	}

	// get posts
	private function getPost ($status = 'publish') {
		global $post;
		$args = array(
			'meta_key' =>'num_iid',
			'meta_value' =>$this->item_id,
			'post_status' => $status,
		);
		$post_id = ($posts = get_posts($args)) ? $posts[0]->ID : '0';
		return $post_id;
	} 
}
