<?php 
	defined('XUEJIAN') || exit('Access Denied!');
	$cats_array = get_categories('hide_empty=0');
?>
<ul id="ul_op1">
	<form method="post">
		<h4>商品参数 </h4>
		<li class="keyword">
			<input type="text" name="key" placeholder="Keyword..." value=""/><span>设置商品关键词</span>
		</li>
		<li>
			<input type="text" name="page" value="1"/><span>请求商品页数，数值过大将会出现重复商品，建议<em>10</em>页内</span>
		</li>
		<li class="offset">
			<input type="text" name="offset" value="0"/><span>偏移页数可指定从第N+1页开始获取商品</span>
		</li>
		<li>
			<input type="text" name="time" value="30"/><span>允许单次任务持续最长时间，若超时则放弃任务</span>
		</li>
		<li class="checkbox">
			<label><input type="checkbox" name="tmall" value="true" />天猫</label>
			<label><input type="checkbox" name="custAssurance" value="true" />消费者保障</label>
			<label><input type="checkbox" name="exchange7" value="true" />7天退换</label>
			<label><input type="checkbox" name="itemAssurance" value="true" />正品保障</label>
		</li>
		<h4>商品入库</h4>
		<li>
			<select name="status">
				<option value="draft">草稿</option>
				<option value="publish" selected="selected">发布</option>
			</select><span>发布状态，直接发布采集文章或暂存草稿箱</span>
		</li>
		<li>
			<select name="cat">
			<?php for ($i = 0; $i < count($cats_array); $i++) : 
				$cat_id = $cats_array[$i]->cat_ID;
				$parent_cat = get_cat_name($cats_array[$i]->parent);
				$args = array(
					'numberposts'=>-1,
					'category'=>$cat_id,
					 'tax_query' => array(
						array(
						  'taxonomy' => 'post_format',
						  'field' => 'slug',
						  'terms' => 'post-format-link',
						  'operator' => 'IN'
						)
					 )
				);
				$posts = get_posts($args);
				$post_counts = count($posts);
			?>
			<option value="<?php echo $cat_id; ?>"><?php if ($parent_cat) echo $parent_cat . '->' ; echo $cats_array[$i]->cat_name . '(' . $post_counts . ')'; ?></option>
			<?php endfor; ?>
			</select><span>所属分类，采集文章发布或存放到指定的目录下</span>
		</li>
		<li>
			<select name="clear">
				<option value="1">更新</option>
				<option value="2">删除</option>
				<option value="3">仅删</option>
			</select>
			<span>更新、保留或删除当前分类下的商品文章</span>
		</li>
		<li class="delete_mode">
			<select name="force">
				<option value="1">清空</option>
				<option value="0">回收站</option>
			</select>
			<span>若删除文章，可绕过回收站直接删除</span>
		</li>
		<li><?php wp_nonce_field('xuejian-update-options','_xuejiannonce',true,true); ?></li>
		<li><input type="hidden" name="action" value="update" /></li>
		<li id="btn1_tb"><input type="button" name="option_save" class="reset" value="<?php _e('xuejiancn.com'); ?>" /></li>
		<li id="btn2_tb"><input type="button" name="option_save" class="button" value="<?php _e('Save options'); ?>" /></li>
	</form>
</ul>