<?php

// Load wp environment
require( dirname(__FILE__) . '/../../../wp-load.php' );
require(WP_PLUGIN_DIR . '/xuejian-taoke-robot/class/Robot.class.php');

// Robot tools
$robot = new Robot();

if (!current_user_can('level_10')) $robot->error(0);
if (!wp_verify_nonce($_POST['_xuejiannonce'], 'xuejian-update-options')) $robot->error(1);

// App & time stamp
$_POST['app_id'] = get_option('xuejian_app_id');
$_POST['app_key'] = get_option('xuejian_app_key');
$_POST['time_stamp'] = time();

if (empty($_POST['app_id']) || empty($_POST['app_key'])) $robot->error(2);
if ($_POST['clear'] != 3 && (!isset($_POST['key']) || !$_POST['key'])) $robot->error(3);

// Delete posts
if ($_POST['clear'] == 2 || $_POST['clear'] == 3) {
	// Query posts link format
	$args = array(
		'cat' => $_POST['cat'],
		'showposts'=> -1,
		'tax_query' => array(
			array(
			  'taxonomy' => 'post_format',
			  'field' => 'slug',
			  'terms' => 'post-format-link',
			  'operator' => 'IN' 
			)
		)
	);
	query_posts($args);
	if (have_posts()) : while (have_posts()) : the_post(); 
	wp_delete_post( get_the_id(), $_POST['force']);
	endwhile; endif; 
	wp_reset_query();

	// Delete posts only
	if ($_POST['clear'] == 3) $robot->error(6);  // Success
}

// Conbine params for api
$permits = array('time_stamp','app_id','app_key','key','page','tmall','custAssurance','exchange7','itemAssurance');
$params = '';
foreach ($_POST as $key => $param) {
	if ($param && in_array($key,$permits))
	$params .= $key . '=' . $param . '&';
}
$params = rtrim($params,'&');

$_POST['time'] = isset($_POST['time']) && is_numeric ($_POST['time']) ? $_POST['time'] : 30;
if ($_POST['time'] > 30) @ini_set('max_execution_time', $_POST['time']);

// Curl request
// fsockopen
// http_post_data
$api_url = 'http://www.xuejiancn.com/openapi?app=robot';

if (function_exists('curl_init')) {
	$ch = curl_init();      
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_URL, $api_url);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_TIMEOUT, $_POST['time']); // time out
	curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
	$data = curl_exec($ch);
	curl_close($ch);
} else if (ini_get('allow_url_fopen')) {
	$info = parse_url($api_url);
	$fp = fsockopen($info['host'], 80, $errno, $errstr, 4);
	$head = 'POST ' . $info['path'] . '?' . $info['query'] . " HTTP/1.0 \r\n";
	$head .= 'Host: ' . $info['host'] . "\r\n";
	$head .= 'Referer: ' . 'http://' . $info['host'] . $info['path'] . "\r\n";
	$head .= 'Content-type: application/x-www-form-urlencoded' . " \r\n";
	$head .= 'Content-Length: ' . strlen($params) . "\r\n";
	$head .= "\r\n";
	$head .= trim($params);
	fputs($fp, $head);

	$contents = '';
	while (!feof($fp)) {
		$contents .= fread($fp, 4096);
	}
	fclose($fp);
	preg_match('/<\?xml version=\"1.0\".*/s',$contents, $data);
	$data = isset($data[0]) ? $data[0] : $data;
} else {
	$robot->error(5);
}

//echo $data;exit;

// Check data
if (isset($data) && preg_match('/xml\sversion=\"1\.0\"\sencoding=\"utf-8\"/',$data)) {
	// parse XML
	$sxe = new SimpleXMLElement($data);
	$sxe->asXML();
	$items = $sxe->xpath('/root/item');

	// url prefix
	if (!$prefix = get_option('xuejian_prefix_link')) $prefix = 'item';

	// loop insert database
	foreach ($items as $item) {
		$item = (array)$item;

		// Insert posts
		$post_id = $robot->exists($item['itemId']);

		$new_post = array(
			'ID' =>$post_id,
			'post_title' => $item['description'],
			'post_name'=>$prefix . $item['itemId'],
			'post_content' =>'',
			'post_status' => $_POST['status'],
			'post_date' => date('Y-m-d H:i:s'),
			'post_author' => $user_ID,
			'post_type' => 'post',
			'comment_status'=>'open',
			'post_category' => array($_POST['cat'])
		);

		$post_id = wp_insert_post($new_post, false);	

		// Update format
		set_post_format( $post_id , 'link');

		// Update fidles
		update_post_meta($post_id, 'num_iid',$item['itemId']);
		update_post_meta($post_id, 'product-title',$item['description']);
		update_post_meta($post_id, 'sellerid' ,$item['sellerId']);
		update_post_meta($post_id, 'nick' ,$item['nick']);
		update_post_meta($post_id, 'pic-s60-0' ,$item['origPicUrl'] . '_' . get_option('thumbnail_size_w') . 'x' . get_option('thumbnail_size_w') . '.jpg');
		update_post_meta($post_id, 'oprice' ,$item['price']);
		update_post_meta($post_id, 'price' ,$item['realPrice']);
		update_post_meta($post_id, 'sales' ,$item['saleCount']);
		update_post_meta($post_id, 'express_fee' ,$item['freeShipping']);
		update_post_meta($post_id, 'location' ,$item['itemLocation']);
		update_post_meta($post_id, 'from' ,$item['userType']);
		update_post_meta($post_id, 'discount' ,$item['discount']);

		global $wpdb;
		$counts = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->comments WHERE comment_post_ID= '$post_id' AND comment_approved = '1'");

		// Insert comment
		if (!$counts) {
			$data = array(
				'comment_post_ID' => $post_id,
				'comment_author' => $item['commentNickName'],
				'comment_content' => $item['comment'],
				'comment_date' => date('Y-m-d H:i:s'),
				'comment_date_gmt' => date('Y-m-d H:i:s'),
				'comment_approved' => 1,
			);
			wp_insert_comment($data);
		}
	}

	$robot->error(6); // Success

} else {
	echo $data;
}