
var $ = jQuery;
var __FILE__ = $("script").last().attr("src");
$(function () {

	// Xpanel Logo链接
	$('.panel_title,#btn1 input, #btn1_tb input').bind('click', function () {
		window.open('http://www.xuejiancn.com/', '_blank');
	});

	// 左侧菜单点击切换设置选项
	$('#ul_menu a').bind('click', function () {
		var iIndex = $('#ul_menu a').index(this);
		$('#ul_menu a').removeClass('current');
		$(this).addClass('current');
		$('#panel_options ul').css('display', 'none');
		$('#panel_options ul').eq(iIndex).css('display', 'block');
	});
	
	// 焦点边框颜色
	$('input,textarea').bind('focus', function () {
		if (this.name != 'option_save') $(this).css('border-color', '#1abc9c');
	});
	$('input,textarea').bind('blur', function () {
		if (this.name != 'option_save') $(this).css('border-color', '#dfdfdf');
	});

	// 切换文章删除模式
	$($('#ul_op1 form')[0]['clear']).bind('change', function () {
		if (this.value == 2 || this.value == 3) {
			$('#ul_op1 .delete_mode').show();
		} else {
			$('#ul_op1 .delete_mode').hide();
		}
	});


	// ajax采集
	$('#btn2_tb input').bind('click', function () {
		// 提醒输入关键词
		if (this.form['key'].value == '' && this.form['clear'].value != 3) {
			$('#xpaner-ajax-saved').show().html('Please input keyword..');
			setTimeout(function () {
				$('#xpaner-ajax-saved').hide().html('xpaner-ajax-saved');
			},1000);
			return false;
		}
		var oThis = this;
		oThis.disabled = true;  // 禁用按钮
		// Ajax loading...
		$('#xpaner-ajax-saving').show();
		var iPage = parseInt(this.form['page'].value);
		var formData = $(this.form).serialize();
		var sUrl = __FILE__.replace(/script.*/,'robot_request.php');
		$.ajax( {
			type : 'post',
			url : sUrl,
			timeout : parseInt(this.form['time'].value) * 1000, //超时时间设置，单位毫秒
			processData : true,
			data : formData,
			success: function(data) {

				data = StatusReport(data);

				$('ul .error').remove();
				$('#ul_op1 form').after('<li class="error">Status : '+ data +'</li>');
				$('#xpaner-ajax-saved').show().html(data);	
				
				setTimeout(function () {
					$('#xpaner-ajax-saved').hide();
					// 断点续采
					oThis.form['page'].value = iPage - 1;
					oThis.form['clear'].value = 1;
					if (parseInt(oThis.form['page'].value) > 0 && data.indexOf('302 Found') == -1) {
						oThis.disabled = false;
						oThis.click();
					} else {
						//oThis.form.reset();
						oThis.form['page'].value = 1;
						oThis.disabled = false;
					}
				}, 2000);
			},
			complete : function (XMLHttpRequest,status) {
				$('#xpaner-ajax-saving').hide();

				//status状态包含 success,error,timeout 等值的情况、此处检测只分为成功、超时连接、与错误
				if (status != 'success') {
					switch (status) {
						case 'timeout' :
							$('#xpaner-ajax-saved').show().html('Timeout...');
							$('form').after('<li class="error">Status : Timeout</li>');
							break;
						default :
							$('#xpaner-ajax-saved').show().html('Error...');
							$('form').after('<li class="error">Status : Unknown error</li>');
					}
					setTimeout(function () {
						$('#xpaner-ajax-saved').hide();
						oThis.disabled = false;
					},2000);
				}
			}
		}
	 );
		return false;
	});
	

});

// 任务状态翻译器
function StatusReport (data) {
	switch (data) {
		case 'Insufficient permissions' :
			data = '非法操作';
			break;
		case 'Token call limited' :
			data = '非法操作';
			break;
		case 'Invalid app' :
			data = '无效的APP';
			break;
		case 'Invalid keyword' :
			data = '无效的关键词';
			break;
		case 'Invalid time' :
			data = '系统时间异常';
			break;
		case 'Not enough points' :
			data = '积分不足';
			break;
		case 'Update failed' :
			data = '更新失败,请向雪箭反应';
			break;
		case 'Time limit' :
			data = '时间限制';
			break;
		case 'App is closed' :
			data = '应用维护中';
			break;
		case 'Mission failed' :
			data = '任务失败,请向雪箭反应';
			break;
		case 'Connect failed' :
			data = '服务器连接失败';
			break;
		case 'Curl disabled' :
			data = 'Curl & fsockopen 都不可用，遇到这种服务器我也是醉了';
			break;
		case 'Success' :
			data = '任务完成';
			break;
		default :
			data = '未知错误,请向雪箭反应';
	}
	return data;
}