<?php

namespace Home\Controller;
use Think\Controller;
class CommonController extends Controller {

    public $loginMarked;
    public $cUid;

    
    public function _initialize() {
        header("Content-Type:text/html; charset=utf-8");
        header('Content-Type:application/json; charset=utf-8');
        $systemConfig = include APP_PATH . '/Common/Conf/systemConfig.php';
        if (empty($systemConfig['TOKEN']['member_marked'])) {
            $systemConfig['TOKEN']['admin_marked'] = "admin.oncoo.net";
            $systemConfig['TOKEN']['admin_timeout'] = 3600;
            $systemConfig['TOKEN']['member_marked'] = "home.oncoo.net";
            $systemConfig['TOKEN']['member_timeout'] = 3600;
            set_config("systemConfig", $systemConfig, APP_PATH . "/Common/Conf/");
            if (is_dir(APP_PATH . "install/")) {
                
            }
        } 
        $this->loginMarked = md5($systemConfig['TOKEN']['member_marked']);
        
        $markedArr = explode('_', $_COOKIE[$this->loginMarked]);
        $this->cUid=substr($markedArr[0],0,-32);
        $this->uid = $this->cUid;
        
        $this->login = $this->checkLogin(0);
        
        $this->nowtime = time();
        
        $this->smsc = M('mysms')->where(array('uid'=>$this->cUid,'status'=>0))->count();
        
        
        $this->upWholeUrl = __ROOT__.trim(C('UPLOADS_PICPATH'),'.');
        
        if($this->checkLogin(0)){
            $this->nickname = M('Member')->where('uid ='.$this->cUid)->cache('nickname'.$this->cUid,$systemConfig['TOKEN']['admin_timeout'],'file')->getField('nickname');
        }
        $cate = M('Goods_category');
        
        $this->channelMenu=$cate->where(array('pid'=>0))->select();
        $this->assign("site", $systemConfig);
    }
    public function checkLogin($type) {
        if (isset($_COOKIE[$this->loginMarked])) {
            $cookie = explode("_", $_COOKIE[$this->loginMarked]);
            $timeout = C("TOKEN");
            if (time() > (end($cookie) + $timeout['member_timeout'])) {
                setcookie("$this->loginMarked", NULL, -3600, "/");
                unset($_SESSION[$this->loginMarked], $_COOKIE[$this->loginMarked]);
                if($type){
                    $this->error("登录超时，请重新登录", U("Login/index"));
                }else{
                    return false;
                }
            } else {
                if ($cookie[0] == $_SESSION[$this->loginMarked]) {
                    setcookie("$this->loginMarked", $cookie[0] . "_" . time(), 0, "/");
                } else {
                    setcookie("$this->loginMarked", NULL, -3600, "/");
                    unset($_SESSION[$this->loginMarked], $_COOKIE[$this->loginMarked]);
                    if($type){
                        $this->error("帐号异常，请重新登录", U("Login/index"));
                    }else{
                        return false;
                    } 
                }
            }
        } else {
            if($type){
                $this->redirect("Index/index");
            }else{
                return false;
            } 
        }
        return TRUE;
    }

    
    protected function checkToken() {
        if (IS_POST) {
            if (!M("Admin")->autoCheckToken($_POST)) {
                die(json_encode(array('status' => 0, 'info' => '重复提交数据！')));
            }
            unset($_POST[C("TOKEN_NAME")]);
        }
    }

}?>
