<?php

namespace Home\Controller;
use Think\Controller;
class MemberController extends CommonController {
	public function _initialize() {
		parent::_initialize();
		$this->checkLogin(1);

	}
    public function index(){
        $order = M('goods_order');
        $info=M('Member')->where(array('uid'=>$this->cUid))->find();
        $info['pledge_live']=$info['wallet_pledge']-$info['wallet_pledge_freeze'];
        $info['limsum_live']=$info['wallet_limsum']-$info['wallet_limsum_freeze'];
        $info['smsc']=M('mysms')->where(array('uid'=>$this->cUid))->count();
        $waitW=array(
            'uid'=>$this->cUid,
            'type'=>array('in','0,1')
        );
        $info['waitpay']=$order->where($waitW)->where(array('status'=>0))->count();
        $info['waitgain']=$order->where($waitW)->where(array('status'=>2))->count();
        $this->info=$info;

        $this->display();
    }
	
    public function my_info(){
        if(IS_POST){
        	$this->checkToken();
            $data = I('post.');
            $region = I('post.region');
            unset($data['region']);
            $data = array_merge($data,$region);
            if(M('Member')->save($data)){
                S('nickname'.$this->cUid,NULL);
            	echo json_encode(array('status' => 1, 'info' => '已修改','url'=>__SELF__));
            }else{
            	echo json_encode(array('status' => 0, 'info' => '修改失败','url'=>__SELF__));
            }
        }else{
        	$my_info = M('Member')->where(array('uid'=>$this->cUid))->find();
        	$this->my_info = $my_info;
        	$this->display();
        }
    }
    
    public function my_portrait(){
        if(IS_POST){
            $this->checkToken();
            $data=array(
                'uid'=>$this->cUid,
                'avatar'=>I('post.avatar')
                );
            if(M('Member')->save($data)){
                echo json_encode(array('status' => 1, 'info' => '已修改','url'=>__SELF__));
            }else{
                echo json_encode(array('status' => 0, 'info' => '修改失败','url'=>__SELF__));
            }
        }else{
            $my_info = M('Member')->where(array('uid'=>$this->cUid))->field(array('uid','avatar'))->find();

            $this->my_info = $my_info;
            $this->display();
        }
    }
    
    public function check(){
        $member = M('Member');
        $uid =$this->cUid; 
        if(IS_POST){
            
            if(I('post.type')=='email'){
                $checkcode = $member->where(array('uid'=>$uid))->getField('verify_code');
                if($checkcode == I('post.checkcode')){
                    $svdata = array('uid'=>$uid,'verify_status'=>1);
                    if($member->save($svdata)){
                        echo json_encode(array('status' => 1, 'info' => "认证成功！",'url'=>U('Member/index')));
                    }
                }else{
                    echo json_encode(array('status' => 0, 'info' => "验证码错误，请检查"));
                }
            }
            
            if(I('post.type')=='mobile'){
                 $checkcode = $member->where(array('uid'=>$uid))->getField('verify_mobile_code');
                if($checkcode == I('post.checkcode')){
                    $svdata = array('uid'=>$uid,'verify_mobile_status'=>1);
                    if($member->save($svdata)){
                        echo json_encode(array('status' => 1, 'info' => "认证成功！",'url'=>U('Member/index')));
                    }
                }else{
                    echo json_encode(array('status' => 0, 'info' => "验证码错误，请检查"));
                }
            }
        }else{
            $info = $member->where(array('uid'=>$uid))->find();
            if(I('get.type')=='email'){
                $type ='email';
            }
            if(I('get.type')=='mobile'){
                $type ='mobile';
            }
            $this->info=$info;
            $this->type=$type;
            $this->display();
        }
    }
    
    public function checkSend(){
        if(IS_POST){
            
            if(I('post.type')=='email'){
                $checkEmail = I('post.checkadr');
                $member = M('member');
                
                $cw = array(
                    'uid'=>array('neq',$this->cUid),
                    'email'=>$checkEmail
                    );
                if($member->where($cw)->find()){
                    echo json_encode(array('status' => 0, 'info' => "邮箱已被注册，请更换"));
                    exit;
                }
                
                $rc = randCode(5);
                $verifyData=array(
                    'email'=>$checkEmail,
                    'verify_code'=>$rc,
                    'verify_time'=>time(),
                    'verify_exp_time'=>time()+3600*24
                    );
                if($member->where(array('uid'=>$this->cUid))->save($verifyData)){
                    $body = "您好：<br/>".C('SITE_INFO.name')."<br/>".C('SITE_INFO.summary')."<br/>您的验证码为:".$rc."<br/>请在二十四小时内验证！";
                    $return = send_mail($checkEmail, "", "邮箱验证--".C('SITE_INFO.name'), $body);
                    if ($return == 1) {
                        echo json_encode(array('status' => 1, 'info' => "验证码已发送到您的邮箱" . $checkEmail . "中，请注意查收"));
                    } else {
                        echo json_encode(array('status' => 0, 'info' => "$return"));
                    } 
                }

            }
            
            if(I('post.type')=='mobile'){
                $checkMobile = I('post.checkadr');
                $member = M('member');
                
                $cw = array(
                    'uid'=>array('neq',$this->cUid),
                    'mobile'=>$checkMobile
                    );
                if($member->where($cw)->find()){
                    echo json_encode(array('status' => 0, 'info' => "手机号已被注册，请更换"));
                    exit;
                }
                
                $rc = randCode(5);
                $verifyData=array(
                    'mobile'=>$checkMobile,
                    'verify_mobile_code'=>$rc,
                    'verify_mobile_time'=>time(),
                    'verify_mobile_exp_time'=>time()+3600*24
                    );
                if($member->where(array('uid'=>$this->cUid))->save($verifyData)){
                    $body = "您好：<br/>".C('SITE_INFO.name')."<br/>".C('SITE_INFO.summary')."<br/>您的验证码为:".$rc."<br/>请在二十四小时内验证！";
                    $noteStatus = sendNote($checkMobile,$body);
                    if ($noteStatus['status'] == 1) {
                        echo json_encode(array('status' => 1, 'info' => "验证码已发送到您的手机" . $checkMobile . "中，请注意查收"));
                    } else {
                        echo json_encode($noteStatus);
                    } 
                }
            }
        }
    }

	
    public function reset_pwd(){
    	if(IS_POST){
    		$this->checkToken();
            echo json_encode(D('Member')->reset_pwd());
        }else{
        	$this->display();
        }
    }
    
    public function pledge(){
        
        $where = array('uid'=>$this->cUid);
        $bill = M('member_pledge_bill')->where($where)->order('time desc')->select();
        foreach ($bill as $key => $value) {
            $bill[$key]['matter']=unserialize($bill[$key]['matter']);
            $bill[$key]['remark'] = $bill[$key]['matter']['remark']; 
            for ($i=0; $i < count($bill[$key]['matter']) ; $i++) { 
                switch ($bill[$key]['matter']['type']) {
                    
                    
                    case 'deposit':
                        $str = '';
                        if($bill[$key]['matter']['tid'] == 1){
                            $str = '通过'.getPayname($bill[$key]['matter']['paytype']).'充值';
                        }else{
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }
                        $bill[$key]['matter']=$str;
                        break;
                    
                    
                    
                    
                    
                    case 'freeze':
                        if($bill[$key]['matter']['tid'] == 0){
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 1) {
                            $str = '参与竞拍'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 2) {
                            $str = '商品定金'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 3){
                            $str = '申请提现'.$bill[$key]['matter']['paytype'];
                        }
                        $bill[$key]['matter']=$str;
                        break;
                    
                    
                    
                    
                    
                    case 'unfreeze':
                        if($bill[$key]['matter']['tid'] == 0){
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 1) {
                            $str = '参与竞拍'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 2) {
                            $str = '商品定金'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 3){
                            $str = '提现被驳回'.$bill[$key]['matter']['paytype'];
                        }
                        $bill[$key]['matter']=$str;
                        break;
                    
                    
                    
                    case 'extract':
                        if($bill[$key]['matter']['tid'] == 0){
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }elseif ($bill[$key]['matter']['tid'] == 3){
                            $str = '提现'.$bill[$key]['matter']['paytype'];
                        }
                        $bill[$key]['matter']=$str;
                        break;
                }
                $bill[$key]['time'] = date('Y-m-d H:i',$bill[$key]['time']);
            }
            
        }
        $this->bill=$bill;
        
        $where = array('uid'=>$this->cUid);
        $pledge=M('Member')->where($where)->field('wallet_pledge,wallet_pledge_freeze')->find();
        $pledge['usable'] = $pledge['wallet_pledge'] - $pledge['wallet_pledge_freeze'];
        $this->pledge=$pledge;
    	$this->display();
    }
    
    public function pledge_take(){
        if(IS_POST){
            $this->checkToken();
            $info = I('post.');
            $info['uid']=$this->cUid;
            $member = M('Member');
            $pledge = $member->where('uid='.$info['uid'])->field('wallet_pledge,wallet_pledge_freeze')->find();
            $takeMoney = $pledge['wallet_pledge'] - $pledge['wallet_pledge_freeze'];
            if(!$takeMoney<=0){
                if ($takeMoney>=$info['money']) {
                    $info['time'] =  time();
                    unset($info[C('TOKEN_NAME')]);
                    if($tid = M('member_pledge_take')->add($info)){
                        
                        if($member->where('uid='.$info['uid'])->setInc('wallet_pledge_freeze',$info['money'])){
                            $matter=array(
                                'type'=>'freeze', 
                                'tid'=>3, 
                                'paytype' =>'冻结', 
                                'remark' => '提现暂时冻结保证金，等待提现完成扣除！'
                                );
                            $data = array(
                                'order_no'=> createNo('TK'),
                                'uid'=> $info['uid'],
                                'time'=> time(),
                                'matter' => serialize($matter),
                                'expend' => $info['money']
                                );
                            if(M('member_pledge_bill')->add($data)){
                                
                                sendSms($info['uid'],'系统提示','系统'.$matter['paytype'].'保证金'.$info['money'].'元！备注：'.$matter['remark']);
                                echo json_encode(array("status" => 1, "info" => "已提交申请，等待退款",'url' => U('Member/pledge_take')));
                            } 
                        }
                        
                    }else{
                        echo json_encode(array("status" => 0, "info" => "提交申请失败",'url' => U('Member/pledge_take')));
                    }
                }else{
                    echo json_encode(array("status" => 0, "info" => "可提现金额不足！请检查！",'url' => __SELF__));
                }
            }else{
                echo json_encode(array("status" => 0, "info" => "可提现金额为0元，不支持提现！",'url' => __SELF__));
            }
        }else{
            if(I('get.take')=='form'){
                $this->display('pledge_take_form');
            }else{
                $pledge_take = M('member_pledge_take');
                $where = array('uid'=>$this->cUid);
                
                $count = $pledge_take->where($where)->count();
                $pConf = page($count,10);
                $this->take_list = $pledge_take->where($where)->limit($pConf['first'].','.$pConf['list'])->order('time desc')->select();
                $this->page = $pConf['show'];
                
                $pledge=M('Member')->where($where)->field('wallet_pledge,wallet_pledge_freeze')->find();
                $pledge['usable'] = $pledge['wallet_pledge'] - $pledge['wallet_pledge_freeze'];
                $this->pledge=$pledge;
                $this->display();
            }
            
        }
        
    }

    
    public function limsum(){
        
        $where = array('uid'=>$this->cUid);
        $bill = M('member_limsum_bill')->where($where)->select();
        foreach ($bill as $key => $value) {
            $bill[$key]['matter']=unserialize($bill[$key]['matter']);
            $bill[$key]['remark'] = $bill[$key]['matter']['remark']; 
            for ($i=0; $i < count($bill[$key]['matter']) ; $i++) { 
                switch ($bill[$key]['matter']['type']) {
                    case 'deposit':
                        $str = '';
                        if($bill[$key]['matter']['tid'] == 1){
                            $str = '通过'.getPayname($bill[$key]['matter']['paytype']).'充值';
                        }else{
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }
                        $bill[$key]['matter']=$str;
                        break;
                    case 'freeze':
                        if($bill[$key]['matter']['tid'] == 0){
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }else{
                            $str = '参与';
                            $str.= '商品拍卖冻结';
                        }
                        $bill[$key]['matter']=$str;
                        break;
                    case 'unfreeze':
                        if($bill[$key]['matter']['tid'] == 0){
                            $str = '管理员后台'.$bill[$key]['matter']['paytype'];
                        }else{
                            $str = '拍品';
                            $str.= '结束，解冻';
                        }
                        $bill[$key]['matter']=$str;
                        break;
                    case 'extract':
                        $str = '提现';
                        $bill[$key]['matter']=$str;
                        break;
                }
                $bill[$key]['time'] = date('Y-m-d H:i',$bill[$key]['time']);
            }
            
        }
        $this->bill=$bill;
        
        $limsum=M('Member')->where($where)->field('wallet_limsum,wallet_limsum_freeze')->find();
        $limsum['usable'] = $limsum['wallet_limsum'] - $limsum['wallet_limsum_freeze'];
        $this->limsum=$limsum;
        $this->display();
    }
    
    public function payment(){
        if(IS_POST){
            
            
            $paytype = I('post.payType');
            $pay = new \Think\Pay($paytype, C($paytype));
            
            if(I('post.use')=='pledge'){
                $order_no = $pay->createOrderNo();
                $use=array(
                    'use'=>'pledge',
                    'body'=>C('SITE_INFO.name').'——'."保证金充值",
                    'title'=>C('SITE_INFO.name').'——'."保证金充值",
                    'callback'=>"Home/Member/pledge_pay",  
                    'url'=>U("Home/Member/pledge"), 
                    'param'=>array(
                        'order_no'=>$order_no,
                        'uid'=>$this->cUid,
                        'use' => 'pledge',
                        'paytype'=>$paytype
                    )
                );
            
            }elseif (I('post.use')=='auction') {
                $order_info = M('goods_order')->where(array('order_no'=>I('post.order_no')))->find();
                $bidinfo = M('auction')->where(array('pid'=>$order_info['gid']))->field(array('pname','nowprice','uid'))->find();
                $order_no = I('post.order_no');
                $use=array(
                    'use'=>'auction',
                    'body'=>C('SITE_INFO.name').'——'.$bidinfo['pname'],
                    'title'=>C('SITE_INFO.name').'——'.$bidinfo['pname'],
                    'callback'=>"Home/Member/goods_pay",  
                    'url'=>U("Home/Member/mysucc",array('st'=>1)), 
                    'param'=>array(
                        'order_no'=>$order_no,
                        'uid'=>$this->cUid,
                        'use' => 'auction',
                        'paytype'=>$paytype
                    )
                );
            }
            $vo = new \Think\Pay\PayVo();
            $vo->setBody($use['body']) 
                    ->setFee(I('post.money')) 
                    ->setOrderNo($order_no) 
                    ->setTitle($use['title']) 
                    ->setCallback($use['callback']) 
                    ->setUrl($use['url']) 
                    ->setParam($use['param']); 
            echo $pay->buildRequestForm($vo);
        }else{
            
            $use=I('get.use');
            switch ($use) {
                
                case 'pledge':
                    $this->od_url=U('Home/Member/pledge');
                    break;
                
                case 'auction':
                    if(I('get.order_no')!=''){
                        
                        $order = M('goods_order');
                        $bidmap = D('Auction');
                        if($odinfo = $order->where(array('order_no'=>I('get.order_no')))->find()){
                            $odinfo['bidinfo']=$bidmap->where('pid ='.$odinfo['gid'])->find();

                        }else{
                            $this->error('不存在的订单号！');
                        }
                        $this->odinfo=$odinfo;
                    }
                    $this->od_url=U('Home/Member/mysucc',array('st'=>1));
                    break;
                
                default:
                    $this->od_url=U('Home/Member/pledge');
                    $use='pledge';
                    break;
            }
            $this->use=$use;
            
            $payment = include APP_PATH . 'Common/Conf/payment.php'; 
            foreach ($payment as $pk => $pv) {
                if($payment[$pk]['status']){
                    $pay[] = $pk;
                }
            }
            $this->pay=$pay;
            $this->display();
        }
    }
    
    public function goods_pay($money, $param) {
        if (session("pay_verify") == true) {
            session("pay_verify", null);
            $order = M('goods_order');
            $oInfo = $order->where(array('order_no'=>$param['order_no']))->find();
            $order->where(array('order_no'=>$param['order_no']))->setField('status',1);
            
            $gfeez = M('Goods_user')->where(array('g-u'=>'p-u','uid'=>$oInfo['uid'],'gid'=>$oInfo['gid']))->find();
            
            $m = M('member');
            $wr = array('uid'=>$gfeez['uid']);
            $freeze = $m->where($wr)->getField('wallet_pledge_freeze');
            $pname =M('Auction')->where(array('pid'=>$gfeez['gid']))->getField('pname');
            
            if($gfeez['pledge']!=0){
                
               if($m->where($wr)->setDec('wallet_pledge_freeze',$gfeez['pledge'])){

                    $matter=array(
                        'type'=>'unfreeze', 
                        'gid' =>$gfeez['uid'],
                        'tid'=>1, 
                        'paytype' =>'解冻', 
                        'remark' => '有效期内支付拍品订单—【<a href="'.U('Auction/details',array('pid'=>$gfeez['gid'])).'">'.$pname.'</a>】'
                        );

                    $data = array(
                        'order_no'=> createNo('BUF'),
                        'uid'=> $gfeez['uid'],
                        'time'=> time(),
                        'matter' => serialize($matter),
                        'income' => $gfeez['pledge']
                        );

                    if(M('member_pledge_bill')->add($data)){
                        
                        sendSms($data['uid'],'系统提示','有效期内支付拍品订单'.$matter['paytype'].'保证金'.$data['income'].'元！<br/>备注：'.$matter['remark']);
                    } 
                } 
            }
            
            if($gfeez['limsum']!=0){
                if($m->where($wr)->setDec('wallet_limsum_freeze',$gfeez['limsum'])){
                    $matter=array(
                        'type'=>'unfreeze', 
                        'gid' =>$gfeez['uid'],
                        'tid'=>1, 
                        'paytype' =>'解冻', 
                        'remark' => '有效期内支付拍品订单—【<a href="'.U('Auction/detail',array('pid'=>$gfeez['gid'])).'">'.$pname.'</a>】'
                        );
                    $data = array(
                        'order_no'=> createNo('BLUF'),
                        'uid'=> $gfeez['uid'],
                        'time'=> time(),
                        'matter' => serialize($matter),
                        'income' => $gfeez['limsum']
                        );
                    if(M('member_limsum_bill')->add($data)){
                        
                        sendSms($data['uid'],'系统提示','按时支付拍品订单，'.$matter['paytype'].'信用额度'.$data['income'].'元！<br/>备注：'.$matter['remark']);
                    } 
                }
            }

        } else {
            E("Access Denied");
        }
    }

    


    
    public function pledge_pay($money, $param) {
        if (session("pay_verify") == true) {
            session("pay_verify", null);
            
            if(M('Member')->where(array('uid' => $param['uid']))->setInc('wallet_pledge', $money)){
                $matter=array(
                    'type'=>'deposit', 
                    'tid'=>1, 
                    'paytype' =>$param['paytype'], 
                    'remark'=>'充值保证金'
                    );
                $data = array(
                    'order_no'=> $param['order_no'],
                    'uid'=> $param['uid'],
                    'time'=> time(),
                    'matter' => serialize($matter),
                    'income' => $money
                    );
                M('member_pledge_bill')->add($data); 
            }
        } else {
            E("Access Denied");
        }
    }

    
    public function region(){
        if (IS_POST) {
            $region = M('region');
            $field = array('region_id','region_name');
            if (I('post.tier') == 1) {
                $tier = 2;
                $selected = '——选择城市——';
            }elseif (I('post.tier') == 2) {
                $tier = 3;
                $selected = '——选择区、县——';
            }
            $option = $region->field($field)->where(array('parent_id'=>I('post.pid')))->select();
            $optionHtml = '<option selected="selected" tier="'.$tier.'" value="0">'.$selected.'</option>';
            foreach ($option as $ok => $ov) {
                $optionHtml .= '<option tier="'.$tier.'" value="'.$ov['region_id'].'">'.$ov['region_name'].'</option>';
            }
            echo json_encode(array('status' => 1, 'msg' => $optionHtml)); 
        }
    }
    
    public function attention(){
        if (IS_POST) {
            $att = M('attention');
            $data = array(
                'gid'=>I('post.gid'),
                'rela'=>I('post.rela'),
                'uid'=>$this->cUid
            );
            if(I('post.yn')=='n'){
                if($att->add($data)){
                    echo json_encode(array('status' => 1, 'msg' => '关注成功'));  
                }else{
                    echo json_encode(array('status' => 0, 'msg' => '关注失败，请刷新页面重试'));
                } 
            }elseif(I('post.yn')=='y'){

                if($att->where($data)->delete()){
                    echo json_encode(array('status' => 1, 'msg' => '已取消关注'));  
                }else{
                    echo json_encode(array('status' => 0, 'msg' => '取消关注失败，请刷新页面重试'));
                } 
            }
        }
    }
    
    public function mysms(){
        $mysms = M('mysms');
        if (IS_POST) {
            $sid=I('post.sid');
            foreach ($sid as $pk => $pv) {
                if($mysms->where('sid='.$pv)->delete()){
                   $dcount+=1; 
                }
            }
            if($dcount==count($sid)){
                echo json_encode(array("status" => 1, "info" => "删除成功",'url' => U('Member/mysms', array('time' => time()))));
            }else{
                echo json_encode(array("status" => 0, "info" => "删除失败，请重试",'url' => U('Member/mysms', array('time' => time()))));
            }
        }else{
            
            $smsid=$mysms->where(array('uid'=>$this->cUid))->getField('sid',true);
            foreach ($smsid as $smk => $smv) {
                $mysms->where('sid='.$smv)->setField('status',1);
            }
            
            $count = $mysms->where(array('uid'=>$this->cUid))->count();
            $pConf = page($count,20);
            $slist = $mysms->where(array('uid'=>$this->cUid))->limit($pConf['first'].','.$pConf['list'])->order('time desc')->select();
            $this->slist=$slist;
            $this->page = $pConf['show'];
            $this->display(); 
        }
    }
    
    public function myatt(){
        $att = M('attention');
        $bidmap = D('Auction');
        $member =M('member');
        $nowTime=time();
        
        if(I('get.type') == 'pm'){
            
            $inPid = $att->where(array('rela'=>'p-u','uid'=>$this->cUid))->getField('gid',true);
            $swhere = array('pid'=>array('in',$inPid));
            if(I('get.st')=='future'){
                
                $swhere['starttime'] = array('gt',$nowTime);
                $st = 'future';
            }elseif (I('get.st')=='end') {
                
                $swhere['endtime']=array('elt',$nowTime);
                $st = 'end';
            }else{
                
                $swhere['starttime']=array('elt',$nowTime);
                $swhere['endtime']=array('egt',$nowTime);
                $st = 'ing';
            }
            
            $count = $bidmap->where($swhere)->count();
            $pConf = page($count,5);
            $alist = $bidmap->where($swhere)->limit($pConf['first'].','.$pConf['list'])->select();
            foreach ($alist as $ak => $av) {
                $alist[$ak]['nickname']=$member->where(array('uid'=>$av['uid']))->getField('nickname');
            }
            $this->alist=$alist;
            $this->st=$st;
            $this->page = $pConf['show'];
            $this->display('myatt');
        
        }elseif (I('get.type') == 'ykj') {
            $glist = $att->where(array('rela'=>'g-u','uid'=>$this->cUid))->select();
            $this->alist=$alist;
            $this->display('myatt_goods');
        }
    }
    
    public function mybid(){
        $goods_user = M('goods_user');
        $bidmap = D('Auction');
        $member =M('member');
        $nowTime=time();

        $inPid = $goods_user->where(array('g-u'=>'p-u','uid'=>$this->cUid))->getField('gid',true);
        $swhere = array('pid'=>array('in',$inPid));
        if(I('get.st')=='end') {
            
            $swhere['endtime']=array('elt',$nowTime);
            $st = 'end';
        }else{
            
            $swhere['starttime']=array('elt',$nowTime);
            $swhere['endtime']=array('egt',$nowTime);
            $st = 'ing';
        }
        
        $count = $bidmap->where($swhere)->count();
        $pConf = page($count,5);
        $alist = $bidmap->where($swhere)->limit($pConf['first'].','.$pConf['list'])->select();
        foreach ($alist as $ak => $av) {
            $alist[$ak]['nickname']=$member->where(array('uid'=>$av['uid']))->getField('nickname');
        }
        $this->alist=$alist;
        $this->st=$st;
        $this->page = $pConf['show'];
        $this->display();
    }
    
    public function mybid_list(){
        $record = M('auction_record');
        $where = array('pid'=>I('get.pid'),'uid'=>$this->cUid);
        $count = $record->where($where)->count();
        $pConf = page($count,10);
        $list = $record->where($where)->limit($pConf['first'].','.$pConf['list'])->select();
        $this->list=$list;
        $this->page = $pConf['show'];
        $this->display();
    }
    
    public function mysucc(){
        $order = M('goods_order');
        $bidmap = D('Auction');
        $where = array('uid'=>$this->cUid);
        if(I('get.st')!=''){
            $where['status']=I('get.st');
        }
        $count = $order->where($where)->count();
        $pConf = page($count,5);
        $alist = $order->where($where)->limit($pConf['first'].','.$pConf['list'])->order('time')->select();
        foreach ($alist as $a => $av) {
            $alist[$a]['bidinfo']= $bidmap->where('pid ='.$av['gid'])->find();
            
            if($av['losetime']<time()){
                
                $alist[$a]['lose'] = 0;
            }elseif ($av['losetime']==0) {
                
                $alist[$a]['lose'] = 1;
            }else{
                $alist[$a]['lose'] = 2;
            }
        }

        $this->alist=$alist;
        $this->st = I('get.st');
        $this->page = $pConf['show'];
        $this->display();
    }
}?>
