CREATE TABLE IF NOT EXISTS `shopnc_album_class` (
  `aclass_id` int(10) unsigned NOT NULL auto_increment COMMENT '相册id',
  `aclass_name` varchar(100) NOT NULL COMMENT '相册名称',
  `store_id` int(10) unsigned NOT NULL COMMENT '所属店铺id',
  `aclass_des` varchar(255) NOT NULL COMMENT '相册描述',
  `aclass_sort` tinyint(3) unsigned NOT NULL COMMENT '排序',
  `aclass_cover` varchar(255) NOT NULL COMMENT '相册封面',
  `upload_time` int(10) unsigned NOT NULL COMMENT '图片上传时间',
  `is_default` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否为默认相册,1代表默认',
  PRIMARY KEY  (`aclass_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='相册表';

CREATE TABLE IF NOT EXISTS `shopnc_album_pic` (
  `apic_id` int(10) unsigned NOT NULL auto_increment COMMENT '相册图片表id',
  `apic_name` varchar(100) NOT NULL COMMENT '图片名称',
  `apic_tag` varchar(255) NOT NULL COMMENT '图片标签',
  `aclass_id` int(10) unsigned NOT NULL COMMENT '相册id',
  `apic_cover` varchar(255) NOT NULL COMMENT '图片路径',
  `apic_size` int(10) unsigned NOT NULL COMMENT '图片大小',
  `apic_spec` varchar(100) NOT NULL COMMENT '图片规格',
  `store_id` int(10) unsigned NOT NULL COMMENT '所属店铺id',
  `upload_time` int(10) unsigned NOT NULL COMMENT '图片上传时间',
  PRIMARY KEY  (`apic_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='相册图片表';

CREATE TABLE IF NOT EXISTS `shopnc_complain` (
  `complain_id` int(11) NOT NULL auto_increment COMMENT '投诉id',
  `order_id` int(11) NOT NULL COMMENT '订单id',
  `order_goods_count` int(11) NOT NULL COMMENT '订单商品数量',
  `complain_goods_count` int(11) NOT NULL COMMENT '投诉商品数量',
  `accuser_id` int(11) NOT NULL COMMENT '原告id',
  `accuser_name` varchar(50) NOT NULL COMMENT '原告名称',
  `accused_id` int(11) NOT NULL COMMENT '被告id',
  `accused_name` varchar(50) NOT NULL COMMENT '被告名称',
  `complain_subject_content` varchar(50) NOT NULL COMMENT '投诉主题',
  `complain_subject_id` int(11) NOT NULL COMMENT '投诉主题id',
  `complain_content` varchar(255) NOT NULL COMMENT '投诉内容',
  `complain_pic1` varchar(100) NOT NULL COMMENT '投诉图片1',
  `complain_pic2` varchar(100) NOT NULL COMMENT '投诉图片2',
  `complain_pic3` varchar(100) NOT NULL COMMENT '投诉图片3',
  `complain_datetime` int(11) NOT NULL COMMENT '投诉时间',
  `complain_handle_datetime` int(11) NOT NULL COMMENT '投诉处理时间',
  `complain_handle_member_id` int(11) NOT NULL COMMENT '投诉处理人id',
  `appeal_message` varchar(255) NOT NULL COMMENT '申诉内容',
  `appeal_datetime` int(11) NOT NULL COMMENT '申诉时间',
  `appeal_pic1` varchar(100) NOT NULL COMMENT '申诉图片1',
  `appeal_pic2` varchar(100) NOT NULL COMMENT '申诉图片2',
  `appeal_pic3` varchar(100) NOT NULL COMMENT '申诉图片3',
  `final_handle_message` varchar(255) NOT NULL COMMENT '最终处理意见',
  `final_handle_datetime` int(11) NOT NULL COMMENT '最终处理时间',
  `final_handle_member_id` int(11) NOT NULL COMMENT '最终处理人id',
  `complain_type` tinyint(4) NOT NULL COMMENT '投诉类型(1-买家投诉/2-卖家投诉)',
  `complain_state` tinyint(4) NOT NULL COMMENT '投诉状态(10-新投诉/20-投诉通过转给被投诉人/30-被投诉人已申诉/40-提交仲裁/99-已关闭)',
  `complain_active` tinyint(4) NOT NULL default '1' COMMENT '投诉是否通过平台审批(1未通过/2通过)',
  PRIMARY KEY  (`complain_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='投诉表';

CREATE TABLE IF NOT EXISTS `shopnc_complain_goods` (
  `complain_goods_id` int(11) NOT NULL auto_increment COMMENT '投诉商品序列id',
  `complain_id` int(11) NOT NULL COMMENT '投诉id',
  `goods_id` int(11) NOT NULL COMMENT '商品id',
  `goods_name` varchar(100) NOT NULL COMMENT '商品名称',
  `spec_id` int(11) NOT NULL COMMENT '规格id',
  `spec_info` varchar(50) NOT NULL default '' COMMENT '规格描述',
  `goods_price` decimal(10,2) NOT NULL COMMENT '商品价格',
  `goods_num` int(11) NOT NULL COMMENT '商品数量',
  `goods_image` varchar(100) NOT NULL default '' COMMENT '商品图片',
  `evaluation` tinyint(1) NOT NULL default '0' COMMENT '评价类型: 1好评 2中评 3差评',
  `comment` varchar(255) NOT NULL default '' COMMENT '评论',
  `complain_message` varchar(100) NOT NULL COMMENT '被投诉商品的问题描述',
  PRIMARY KEY  (`complain_goods_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='投诉商品表';

CREATE TABLE IF NOT EXISTS `shopnc_complain_subject` (
  `complain_subject_id` int(11) NOT NULL auto_increment COMMENT '举报主题id',
  `complain_subject_content` varchar(50) NOT NULL COMMENT '举报主题',
  `complain_subject_desc` varchar(100) NOT NULL COMMENT '举报主题描述',
  `complain_subject_type` tinyint(4) NOT NULL COMMENT '举报主题类型(1-买家/2-卖家)',
  `complain_subject_state` tinyint(4) NOT NULL COMMENT '举报主题状态(1-有效/2-失效)',
  PRIMARY KEY  (`complain_subject_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='举报主题表';

CREATE TABLE IF NOT EXISTS `shopnc_complain_talk` (
  `talk_id` int(11) NOT NULL auto_increment COMMENT '投诉对话id',
  `complain_id` int(11) NOT NULL COMMENT '投诉id',
  `talk_member_id` int(11) NOT NULL COMMENT '发言人id',
  `talk_member_name` varchar(50) NOT NULL COMMENT '发言人名称',
  `talk_member_type` varchar(10) NOT NULL COMMENT '发言人类型(1-投诉人/2-被投诉人/3-平台)',
  `talk_content` varchar(255) NOT NULL COMMENT '发言内容',
  `talk_state` tinyint(4) NOT NULL COMMENT '发言状态(1-显示/2-不显示)',
  `talk_admin` int(11) NOT NULL default '0' COMMENT '对话管理员，屏蔽对话人的id',
  `talk_datetime` int(11) NOT NULL COMMENT '对话发表时间',
  PRIMARY KEY  (`talk_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='投诉对话表';

CREATE TABLE IF NOT EXISTS `shopnc_inform` (
  `inform_id` int(11) NOT NULL auto_increment COMMENT '举报id',
  `inform_member_id` int(11) NOT NULL COMMENT '举报人id',
  `inform_member_name` varchar(50) NOT NULL COMMENT '举报人会员名',
  `inform_goods_id` int(11) NOT NULL COMMENT '被举报的商品id',
  `inform_goods_name` varchar(100) NOT NULL COMMENT '被举报的商品名称',
  `inform_subject_id` int(11) NOT NULL COMMENT '举报主题id',
  `inform_subject_content` varchar(50) NOT NULL COMMENT '举报主题',
  `inform_content` varchar(100) NOT NULL COMMENT '举报信息',
  `inform_pic1` varchar(100) NOT NULL COMMENT '图片1',
  `inform_pic2` varchar(100) NOT NULL COMMENT '图片2',
  `inform_pic3` varchar(100) NOT NULL COMMENT '图片3',
  `inform_datetime` int(11) NOT NULL COMMENT '举报时间',
  `inform_store_id` int(11) NOT NULL COMMENT '被举报商品的店铺id',
  `inform_state` tinyint(4) NOT NULL COMMENT '举报状态(1未处理/2已处理)',
  `inform_handle_type` tinyint(4) NOT NULL COMMENT '举报处理结果(1无效举报/2恶意举报/3有效举报)',
  `inform_handle_message` varchar(100) NOT NULL COMMENT '举报处理信息',
  `inform_handle_datetime` int(11) NOT NULL default '0' COMMENT '举报处理时间',
  `inform_handle_member_id` int(11) NOT NULL default '0' COMMENT '管理员id',
  PRIMARY KEY  (`inform_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='举报表';

CREATE TABLE IF NOT EXISTS `shopnc_inform_subject` (
  `inform_subject_id` int(11) NOT NULL auto_increment COMMENT '举报主题id',
  `inform_subject_content` varchar(100) NOT NULL COMMENT '举报主题内容',
  `inform_subject_type_id` int(11) NOT NULL COMMENT '举报类型id',
  `inform_subject_type_name` varchar(50) NOT NULL COMMENT '举报类型名称 ',
  `inform_subject_state` tinyint(11) NOT NULL COMMENT '举报主题状态(1可用/2失效)',
  PRIMARY KEY  (`inform_subject_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='举报主题表';

CREATE TABLE IF NOT EXISTS `shopnc_inform_subject_type` (
  `inform_type_id` int(11) NOT NULL auto_increment COMMENT '举报类型id',
  `inform_type_name` varchar(50) NOT NULL COMMENT '举报类型名称 ',
  `inform_type_desc` varchar(100) NOT NULL COMMENT '举报类型描述',
  `inform_type_state` tinyint(4) NOT NULL COMMENT '举报类型状态(1有效/2失效)',
  PRIMARY KEY  (`inform_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='举报类型表';

CREATE TABLE IF NOT EXISTS `shopnc_map` (
  `map_id` int(11) NOT NULL auto_increment COMMENT '地图ID',
  `member_id` int(11) NOT NULL COMMENT '会员ID',
  `member_name` varchar(20) NOT NULL COMMENT '会员名称',
  `area_id` int(11) NOT NULL COMMENT '地区ID',
  `area_info` varchar(50) NOT NULL COMMENT '地区内容',
  `address` varchar(50) default NULL COMMENT '地址',
  `point_lng` float NOT NULL default '0' COMMENT '地理经度',
  `point_lat` float NOT NULL default '0' COMMENT '地理纬度',
  `store_name` varchar(20) default NULL COMMENT '店铺名称',
  `store_id` int(11) default '0' COMMENT '店铺ID',
  `map_api` char(9) NOT NULL default 'baidu' COMMENT '地图API(暂时只有baidu)',
  PRIMARY KEY  (`map_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='地图表';

CREATE TABLE IF NOT EXISTS `shopnc_points_cart` (
  `pcart_id` int(11) NOT NULL auto_increment COMMENT '自增ID',
  `pmember_id` int(11) NOT NULL COMMENT '会员编号',
  `pgoods_id` int(11) NOT NULL COMMENT '积分礼品序号',
  `pgoods_name` varchar(100) NOT NULL COMMENT '积分礼品名称',
  `pgoods_points` int(11) NOT NULL COMMENT '积分礼品兑换积分',
  `pgoods_choosenum` int(11) NOT NULL COMMENT '选择积分礼品数量',
  `pgoods_image` varchar(100) default NULL COMMENT '积分礼品图片',
  PRIMARY KEY  (`pcart_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分礼品兑换购物车';

CREATE TABLE IF NOT EXISTS `shopnc_points_goods` (
  `pgoods_id` int(11) NOT NULL auto_increment COMMENT '积分礼品索引id',
  `pgoods_name` varchar(100) NOT NULL COMMENT '积分礼品名称',
  `pgoods_price` decimal(10,2) NOT NULL default '0.00' COMMENT '积分礼品原价',
  `pgoods_points` int(11) NOT NULL COMMENT '积分礼品兑换所需积分',
  `pgoods_image` varchar(100) NOT NULL COMMENT '积分礼品默认封面图片',
  `pgoods_tag` varchar(100) NOT NULL COMMENT '积分礼品标签',
  `pgoods_serial` varchar(50) NOT NULL COMMENT '积分礼品货号',
  `pgoods_storage` int(11) NOT NULL default '0' COMMENT '积分礼品库存数',
  `pgoods_show` tinyint(1) NOT NULL COMMENT '积分礼品上架 0表示下架 1表示上架',
  `pgoods_commend` tinyint(1) NOT NULL COMMENT '积分礼品推荐',
  `pgoods_add_time` int(11) NOT NULL COMMENT '积分礼品添加时间',
  `pgoods_keywords` varchar(100) default NULL COMMENT '积分礼品关键字',
  `pgoods_description` varchar(200) default NULL COMMENT '积分礼品描述',
  `pgoods_body` text NOT NULL COMMENT '积分礼品详细内容',
  `pgoods_state` tinyint(1) NOT NULL default '0' COMMENT '积分礼品状态，0开启，1禁售',
  `pgoods_close_reason` varchar(255) default NULL COMMENT '积分礼品禁售原因',
  `pgoods_salenum` int(11) NOT NULL default '0' COMMENT '积分礼品售出数量',
  `pgoods_view` int(11) NOT NULL default '0' COMMENT '积分商品浏览次数',
  `pgoods_islimit` tinyint(1) NOT NULL COMMENT '是否限制每会员兑换数量',
  `pgoods_limitnum` int(11) default NULL COMMENT '每会员限制兑换数量',
  `pgoods_freightcharge` tinyint(1) NOT NULL default '0' COMMENT '运费承担方式 0表示卖家承担 1表示买家承担',
  `pgoods_freightprice` decimal(10,2) default NULL COMMENT '运费价格',
  `pgoods_islimittime` tinyint(1) NOT NULL default '0' COMMENT '是否限制兑换时间 0为不限制 1为限制',
  `pgoods_starttime` int(11) default NULL COMMENT '兑换开始时间',
  `pgoods_endtime` int(11) default NULL COMMENT '兑换结束时间',
  `pgoods_sort` int(11) NOT NULL default '0' COMMENT '礼品排序',
  PRIMARY KEY  (`pgoods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='积分礼品表';

CREATE TABLE IF NOT EXISTS `shopnc_points_log` (
  `pl_id` int(11) NOT NULL auto_increment COMMENT '积分日志编号',
  `pl_memberid` int(11) NOT NULL COMMENT '会员编号',
  `pl_membername` varchar(100) NOT NULL COMMENT '会员名称',
  `pl_adminid` int(11) default NULL COMMENT '管理员编号',
  `pl_adminname` varchar(100) default NULL COMMENT '管理员名称',
  `pl_points` int(11) NOT NULL default '0' COMMENT '积分数负数表示扣除',
  `pl_addtime` int(11) NOT NULL COMMENT '添加时间',
  `pl_desc` varchar(100) NOT NULL COMMENT '操作描述',
  `pl_stage` varchar(50) NOT NULL COMMENT '操作阶段',
  PRIMARY KEY  (`pl_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员积分日志表';

CREATE TABLE IF NOT EXISTS `shopnc_points_order` (
  `point_orderid` int(11) NOT NULL auto_increment COMMENT '兑换订单编号',
  `point_ordersn` varchar(100) NOT NULL COMMENT '兑换订单编号',
  `point_buyerid` int(11) NOT NULL COMMENT '兑换会员id',
  `point_buyername` varchar(50) NOT NULL COMMENT '兑换会员姓名',
  `point_buyeremail` varchar(100) NOT NULL COMMENT '兑换会员email',
  `point_addtime` int(11) NOT NULL COMMENT '兑换订单生成时间',
  `point_paymentid` int(11) NOT NULL COMMENT '支付方式id',
  `point_paymentname` varchar(50) NOT NULL COMMENT '支付方式名称',
  `point_paymentcode` varchar(50) NOT NULL COMMENT '支付方式名称代码',
  `point_paymentdirect` tinyint(1) default '1' COMMENT '支付类型:1是即时到帐,2是但保交易',
  `point_outsn` varchar(100) NOT NULL COMMENT '订单编号，外部支付时使用，有些外部支付系统要求特定的订单编号',
  `point_paymenttime` int(11) default NULL COMMENT '支付(付款)时间',
  `point_paymessage` varchar(300) default NULL COMMENT '支付留言',
  `point_shippingtime` int(11) default NULL COMMENT '配送时间',
  `point_shippingcode` varchar(50) default NULL COMMENT '物流单号',
  `point_shippingdesc` varchar(500) default NULL COMMENT '发货描述',
  `point_outpaymentcode` varchar(255) default NULL COMMENT '外部交易平台单独使用的标识字符串',
  `point_finnshedtime` int(11) default NULL COMMENT '订单完成时间',
  `point_allpoint` int(11) NOT NULL default '0' COMMENT '兑换总积分',
  `point_orderamount` decimal(10,2) NOT NULL COMMENT '兑换订单总金额',
  `point_shippingcharge` tinyint(1) NOT NULL default '0' COMMENT '运费承担方式 0表示卖家 1表示买家',
  `point_shippingfee` decimal(10,2) NOT NULL default '0.00' COMMENT '运费金额',
  `point_ordermessage` varchar(300) default NULL COMMENT '订单留言',
  `point_orderstate` int(11) NOT NULL default '10' COMMENT '订单状态：10(默认):未付款;11已付款;20:确认付款;30:已发货;40:已收货;50已完成;2已取消',
  PRIMARY KEY  (`point_orderid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='兑换订单表';

CREATE TABLE IF NOT EXISTS `shopnc_points_orderaddress` (
  `point_oaid` int(11) NOT NULL auto_increment COMMENT '自增id',
  `point_orderid` int(11) NOT NULL COMMENT '订单id',
  `point_truename` varchar(50) NOT NULL COMMENT '收货人姓名',
  `point_areaid` int(11) NOT NULL COMMENT '地区id',
  `point_areainfo` varchar(100) NOT NULL COMMENT '地区内容',
  `point_address` varchar(200) NOT NULL COMMENT '详细地址',
  `point_zipcode` varchar(20) NOT NULL COMMENT '邮政编码',
  `point_telphone` varchar(20) NOT NULL COMMENT '电话号码',
  `point_mobphone` varchar(20) NOT NULL COMMENT '手机号码',
  PRIMARY KEY  (`point_oaid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='兑换订单地址表';

CREATE TABLE IF NOT EXISTS `shopnc_points_ordergoods` (
  `point_recid` int(11) NOT NULL auto_increment COMMENT '订单礼品表索引',
  `point_orderid` int(11) NOT NULL COMMENT '订单id',
  `point_goodsid` int(11) NOT NULL COMMENT '礼品id',
  `point_goodsname` varchar(100) NOT NULL COMMENT '礼品名称',
  `point_goodspoints` int(11) NOT NULL COMMENT '礼品兑换积分',
  `point_goodsnum` int(11) NOT NULL COMMENT '礼品数量',
  `point_goodsimage` varchar(100) default NULL COMMENT '礼品图片',
  PRIMARY KEY  (`point_recid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='兑换订单商品表';

CREATE TABLE IF NOT EXISTS `shopnc_predeposit_cash` (
  `pdcash_id` int(11) NOT NULL auto_increment COMMENT '自增编号',
  `pdcash_sn` varchar(100) NOT NULL COMMENT '记录唯一标示',
  `pdcash_memberid` int(11) NOT NULL COMMENT '会员编号',
  `pdcash_membername` varchar(50) NOT NULL COMMENT '会员名称',
  `pdcash_price` decimal(10,2) NOT NULL default '0.00' COMMENT '金额',
  `pdcash_payment` varchar(50) NOT NULL COMMENT '支付方式',
  `pdcash_paymentaccount` varchar(100) default NULL COMMENT '支付账号',
  `pdcash_toname` varchar(100) default NULL COMMENT '收款人姓名',
  `pdcash_tobank` varchar(100) default NULL COMMENT '收款银行',
  `pdcash_memberremark` varchar(1000) default NULL COMMENT '会员提现备注',
  `pdcash_addtime` int(11) NOT NULL COMMENT '添加时间',
  `pdcash_state` tinyint(1) NOT NULL default '0' COMMENT '状态 0为申请 1为完成 2为关闭',
  `pdcash_paystate` tinyint(1) NOT NULL default '0' COMMENT '提现支付状态 0为未支付 1为支付',
  `pdcash_adminid` int(11) default NULL COMMENT '管理员编号',
  `pdcash_adminname` varchar(100) default NULL COMMENT '管理员姓名',
  `pdcash_adminremark` varchar(1000) default NULL COMMENT '管理员备注',
  `pdcash_remark` varchar(1000) default NULL COMMENT '管理员和会员都可查看的备注',
  PRIMARY KEY  (`pdcash_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='预存款提现记录表';

CREATE TABLE IF NOT EXISTS `shopnc_predeposit_log` (
  `pdlog_id` int(11) NOT NULL auto_increment COMMENT '自增编号',
  `pdlog_memberid` int(11) NOT NULL COMMENT '会员编号',
  `pdlog_membername` varchar(50) NOT NULL COMMENT '会员名称',
  `pdlog_adminid` int(11) default NULL COMMENT '管理员编号',
  `pdlog_adminname` varchar(50) default NULL COMMENT '管理员名称',
  `pdlog_stage` enum('system','recharge','cash','order','admin') NOT NULL COMMENT '日志类型 枚举 system 系统自动 recharge 充值 cash 提现 order 订单 admin 管理员手动修改',
  `pdlog_type` tinyint(1) NOT NULL default '0' COMMENT '日志类型 0表示可用金额 1表示冻结金额',
  `pdlog_price` decimal(10,2) NOT NULL default '0.00' COMMENT '金额',
  `pdlog_addtime` int(11) NOT NULL COMMENT '添加时间',
  `pdlog_desc` varchar(1000) default NULL COMMENT '描述',
  PRIMARY KEY  (`pdlog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='预存款日志表';

CREATE TABLE IF NOT EXISTS `shopnc_predeposit_recharge` (
  `pdr_id` int(11) NOT NULL auto_increment COMMENT '自增编号',
  `pdr_sn` varchar(100) NOT NULL COMMENT '记录唯一标示',
  `pdr_memberid` int(11) NOT NULL COMMENT '会员编号',
  `pdr_membername` varchar(50) NOT NULL COMMENT '会员名称',
  `pdr_price` decimal(10,2) NOT NULL default '0.00' COMMENT '充值金额',
  `pdr_payment` varchar(50) default NULL COMMENT '支付方式',
  `pdr_onlinecode` varchar(100) default NULL COMMENT '线上支付的交易流水号',
  `pdr_remittancename` varchar(100) default NULL COMMENT '汇款人姓名',
  `pdr_remittancebank` varchar(100) default NULL COMMENT '汇款银行',
  `pdr_remittancedate` int(11) default NULL COMMENT '汇款日期',
  `pdr_memberremark` varchar(1000) default NULL COMMENT '会员备注',
  `pdr_addtime` int(11) NOT NULL COMMENT '添加时间',
  `pdr_state` tinyint(1) NOT NULL default '0' COMMENT '充值状态 0 表示申请中 1表示完成 2表示关闭',
  `pdr_paystate` tinyint(1) NOT NULL default '0' COMMENT '支付状态 0表示未支付 1表示支付',
  `pdr_adminid` int(11) default NULL COMMENT '管理员编号',
  `pdr_adminname` varchar(100) default NULL COMMENT '管理员名称',
  `pdr_adminremark` varchar(1000) default NULL COMMENT '管理员备注',
  PRIMARY KEY  (`pdr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='预存款充值信息表';

CREATE TABLE IF NOT EXISTS `shopnc_refund_log` (
  `log_id` int(10) unsigned NOT NULL auto_increment COMMENT '退款记录ID',
  `order_id` int(10) unsigned NOT NULL COMMENT '订单ID',
  `refund_sn` varchar(100) NOT NULL COMMENT '退款编号',
  `order_sn` varchar(100) NOT NULL COMMENT '订单编号',
  `seller_id` int(10) unsigned NOT NULL COMMENT '卖家ID',
  `store_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  `store_name` varchar(20) NOT NULL COMMENT '店铺名称',
  `buyer_id` int(10) unsigned NOT NULL COMMENT '买家ID',
  `buyer_name` varchar(50) NOT NULL COMMENT '买家会员名',
  `add_time` int(10) unsigned NOT NULL COMMENT '添加时间',
  `order_amount` decimal(10,2) NOT NULL COMMENT '订单金额',
  `order_refund` decimal(10,2) NOT NULL COMMENT '退款金额',
  `refund_paymentname` varchar(50) NOT NULL COMMENT '支付方式名称',
  `refund_paymentcode` varchar(50) NOT NULL COMMENT '支付方式代码',
  `refund_message` varchar(300) default NULL COMMENT '退款备注',
  PRIMARY KEY  (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='退款表';

CREATE TABLE IF NOT EXISTS `shopnc_return` (
  `return_id` int(10) unsigned NOT NULL auto_increment COMMENT '退货记录ID',
  `order_id` int(10) unsigned NOT NULL COMMENT '订单ID',
  `return_sn` varchar(100) NOT NULL COMMENT '退货编号',
  `order_sn` varchar(100) NOT NULL COMMENT '订单编号',
  `seller_id` int(10) unsigned NOT NULL COMMENT '卖家ID',
  `store_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  `store_name` varchar(20) NOT NULL COMMENT '店铺名称',
  `buyer_id` int(10) unsigned NOT NULL COMMENT '买家ID',
  `buyer_name` varchar(50) NOT NULL COMMENT '买家会员名',
  `return_goodsnum` int(10) unsigned NOT NULL COMMENT '退货数量',
  `add_time` int(10) unsigned NOT NULL COMMENT '添加时间',
  `return_message` varchar(300) default NULL COMMENT '退货备注',
  PRIMARY KEY  (`return_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='退货表';

CREATE TABLE IF NOT EXISTS `shopnc_return_goods` (
  `log_id` int(10) unsigned NOT NULL auto_increment COMMENT '退货商品记录ID',
  `return_id` int(10) unsigned NOT NULL COMMENT '退货记录ID',
  `order_id` int(10) unsigned NOT NULL COMMENT '订单ID',
  `goods_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `goods_name` varchar(100) NOT NULL COMMENT '商品名称',
  `spec_id` int(10) unsigned NOT NULL COMMENT '规格ID',
  `spec_info` varchar(50) default NULL COMMENT '规格描述',
  `goods_price` decimal(10,2) NOT NULL COMMENT '商品价格',
  `goods_num` int(10) unsigned NOT NULL COMMENT '商品数量',
  `goods_returnnum` int(10) unsigned NOT NULL COMMENT '退货数量',
  `goods_image` varchar(100) default NULL COMMENT '商品图片',
  PRIMARY KEY  (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='退货商品表';

CREATE TABLE IF NOT EXISTS `shopnc_voucher` (
  `voucher_id` int(11) NOT NULL auto_increment COMMENT '代金券编号',
  `voucher_code` varchar(32) NOT NULL COMMENT '代金券编码',
  `voucher_t_id` int(11) NOT NULL COMMENT '代金券模版编号',
  `voucher_title` varchar(50) NOT NULL COMMENT '代金券标题',
  `voucher_desc` varchar(255) NOT NULL COMMENT '代金券描述',
  `voucher_start_date` int(11) NOT NULL COMMENT '代金券有效期开始时间',
  `voucher_end_date` int(11) NOT NULL COMMENT '代金券有效期结束时间',
  `voucher_price` int(11) NOT NULL COMMENT '代金券面额',
  `voucher_limit` decimal(10,2) NOT NULL COMMENT '代金券使用时的订单限额',
  `voucher_store_id` int(11) NOT NULL COMMENT '代金券的店铺id',
  `voucher_state` tinyint(4) NOT NULL COMMENT '代金券状态(1-未用,2-已用,3-过期,4-收回)',
  `voucher_active_date` int(11) NOT NULL COMMENT '代金券发放日期',
  `voucher_type` tinyint(4) NOT NULL COMMENT '代金券类别',
  `voucher_owner_id` int(11) NOT NULL COMMENT '代金券所有者id',
  `voucher_owner_name` varchar(50) NOT NULL COMMENT '代金券所有者名称',
  `voucher_order_id` int(11) default NULL COMMENT '使用该代金券的订单编号',
  PRIMARY KEY  (`voucher_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='代金券表';

CREATE TABLE IF NOT EXISTS `shopnc_voucher_price` (
  `voucher_price_id` int(11) NOT NULL auto_increment COMMENT '代金券面值编号',
  `voucher_price_describe` varchar(255) NOT NULL COMMENT '代金券描述',
  `voucher_price` int(11) NOT NULL COMMENT '代金券面值',
  PRIMARY KEY  (`voucher_price_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='代金券面额表';

CREATE TABLE IF NOT EXISTS `shopnc_voucher_template` (
  `voucher_t_id` int(11) NOT NULL auto_increment COMMENT '代金券模版编号',
  `voucher_t_title` varchar(50) NOT NULL COMMENT '代金券模版名称',
  `voucher_t_desc` varchar(255) NOT NULL COMMENT '代金券模版描述',
  `voucher_t_start_date` int(11) NOT NULL COMMENT '代金券模版有效期开始时间',
  `voucher_t_end_date` int(11) NOT NULL COMMENT '代金券模版有效期结束时间',
  `voucher_t_price` int(11) NOT NULL COMMENT '代金券模版面额',
  `voucher_t_limit` decimal(10,2) NOT NULL COMMENT '代金券使用时的订单限额',
  `voucher_t_store_id` int(11) NOT NULL COMMENT '代金券模版的店铺id',
  `voucher_t_creator_id` int(11) NOT NULL COMMENT '代金券模版的创建者id',
  `voucher_t_state` tinyint(4) NOT NULL COMMENT '代金券模版状态(1-有效,2-失效)',
  `voucher_t_total` int(11) NOT NULL COMMENT '模版可发放的代金券总数',
  `voucher_t_giveout` int(11) NOT NULL COMMENT '模版已发放的代金券数量',
  `voucher_t_used` int(11) NOT NULL COMMENT '模版已经使用过的代金券',
  `voucher_t_add_date` int(11) NOT NULL COMMENT '模版的创建时间',
  `voucher_t_type` tinyint(4) NOT NULL COMMENT '代金券模版类型',
  PRIMARY KEY  (`voucher_t_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='代金券模版表';

ALTER TABLE `shopnc_member` ADD `member_qqinfo` text NULL COMMENT 'qq账号相关信息' AFTER `member_qqopenid`;
ALTER TABLE `shopnc_member` ADD `member_sinaopenid` varchar(100) NULL COMMENT '新浪微博登录id' AFTER `member_qqinfo`;
ALTER TABLE `shopnc_member` ADD `member_sinainfo` text NULL COMMENT '新浪账号相关信息序列化值' AFTER `member_sinaopenid`;
ALTER TABLE `shopnc_member` ADD `member_points` int(11) NOT NULL DEFAULT '0' COMMENT '会员积分' AFTER `member_sinainfo`;
ALTER TABLE `shopnc_member` ADD `available_predeposit` decimal(10,2) NOT NULL DEFAULT '0' COMMENT '预存款可用金额' AFTER `member_points`;
ALTER TABLE `shopnc_member` ADD `freeze_predeposit` decimal(10,2) NOT NULL DEFAULT '0' COMMENT '预存款冻结金额' AFTER `available_predeposit`;
ALTER TABLE `shopnc_member` ADD `inform_allow` tinyint(1) NOT NULL DEFAULT  '1' COMMENT  '是否允许举报(1可以/2不可以)' AFTER `freeze_predeposit`;

ALTER TABLE `shopnc_order` ADD `order_pointscount` int(11) NOT NULL DEFAULT '0' COMMENT '订单赠送积分' AFTER `order_state`;
ALTER TABLE `shopnc_order` ADD `voucher_id` int(11) NULL  COMMENT  '代金券id' AFTER `order_pointscount`;
ALTER TABLE `shopnc_order` ADD `voucher_price` int(11) NULL  COMMENT  '代金券面额' AFTER `voucher_id`;
ALTER TABLE `shopnc_order` ADD `voucher_code` varchar(32) NULL COMMENT '代金券编码' AFTER `voucher_price`;
ALTER TABLE `shopnc_order` ADD `refund_state` tinyint(1) unsigned NULL DEFAULT '0' COMMENT '退款状态:0是无退款,1是部分退款,2是全部退款' AFTER `voucher_code`;
ALTER TABLE `shopnc_order` ADD `return_state` tinyint(1) unsigned NULL DEFAULT '0' COMMENT '退货状态:0是无退货,1是部分退货,2是全部退货' AFTER `refund_state`;
ALTER TABLE `shopnc_order` ADD `refund_amount` decimal(10,2) NULL DEFAULT '0.00' COMMENT '退款金额' AFTER `return_state`;
ALTER TABLE `shopnc_order` ADD `return_num` int(10) unsigned NULL DEFAULT '0' COMMENT '退货数量' AFTER `refund_amount`;

ALTER TABLE `shopnc_order_goods` ADD `evaluation_state` tinyint(1) NULL DEFAULT '0' COMMENT '评价信息的状态 0为正常 1为禁止显示 2 为取消评价' AFTER `comment`;
ALTER TABLE `shopnc_order_goods` ADD `evaluation_remark` varchar(500) NULL COMMENT '管理员对评价的处理备注' AFTER `evaluation_state`;
ALTER TABLE `shopnc_order_goods` ADD `goods_returnnum` int(10) unsigned NULL DEFAULT '0' COMMENT '退货数量' AFTER `evaluation_remark`;

ALTER TABLE `shopnc_recommend` ADD `recommend_config` varchar(255) NULL COMMENT '配置信息' AFTER `recommend_desc`;

INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('qq_appcode', NULL);
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('sina_isuse', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('sina_wb_akey','');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('sina_wb_skey','');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('points_isuse', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('points_reg', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('points_login', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('points_comments', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('points_orderrate', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('points_ordermax', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('pointprod_isuse', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('voucher_allow', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('predeposit_isuse', '0');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('complain_time_limit', '2592000');
INSERT INTO `shopnc_setting` (`name`, `value`) VALUES('creditrule', 'a:3:{s:5:"heart";a:5:{i:1;a:2:{i:0;s:1:"1";i:1;s:3:"100";}i:2;a:2:{i:0;s:3:"101";i:1;s:3:"200";}i:3;a:2:{i:0;s:3:"201";i:1;s:3:"300";}i:4;a:2:{i:0;s:3:"301";i:1;s:3:"400";}i:5;a:2:{i:0;s:3:"401";i:1;s:3:"500";}}s:7:"diamond";a:5:{i:1;a:2:{i:0;s:3:"501";i:1;s:3:"600";}i:2;a:2:{i:0;s:3:"601";i:1;s:3:"700";}i:3;a:2:{i:0;s:3:"701";i:1;s:3:"800";}i:4;a:2:{i:0;s:3:"801";i:1;s:3:"900";}i:5;a:2:{i:0;s:3:"901";i:1;s:4:"1000";}}s:5:"crown";a:5:{i:1;a:2:{i:0;s:4:"1001";i:1;s:4:"1100";}i:2;a:2:{i:0;s:4:"1101";i:1;s:4:"1200";}i:3;a:2:{i:0;s:4:"1201";i:1;s:4:"1300";}i:4;a:2:{i:0;s:4:"1301";i:1;s:4:"1400";}i:5;a:2:{i:0;s:4:"1401";i:1;s:4:"1500";}}}');

INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (2, '男女服饰', 'clothing_item', '这里面的商品将在首页的男女服饰区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (3, '鞋包配饰', 'ornament_item', '这里面的商品将在首页的鞋包配饰区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (4, '美容美妆', 'cosmetic_item', '这里面的商品将在首页的美容美妆区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (5, '运动户外', 'sports_item', '这里面的商品将在首页的运动户外区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (6, '数码家电', 'electron_item', '这里面的商品将在首页的数码家电区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (7, '家居家装', 'furniture_item', '这里面的商品将在首页的家居家装区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (8, '食品保健', 'food_item', '这里面的商品将在首页的食品保健区域显示', NULL);
INSERT INTO `shopnc_recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (9, '母婴用品', 'gravida_item', '这里面的商品将在首页的母婴用品区域显示', NULL);

INSERT INTO `shopnc_complain_subject` (`complain_subject_id`, `complain_subject_content`, `complain_subject_desc`, `complain_subject_type`, `complain_subject_state`) VALUES (7, '未收到货', '交易成功，未收到货，钱已经付给卖家，可进行维权。', 1, 1);
INSERT INTO `shopnc_complain_subject` (`complain_subject_id`, `complain_subject_content`, `complain_subject_desc`, `complain_subject_type`, `complain_subject_state`) VALUES (8, '售后保障服务', '交易完成后30天内，在使用商品过程中，发现商品有质量问题或无法正常使用，可进行维权。', 1, 1);
INSERT INTO `shopnc_complain_subject` (`complain_subject_id`, `complain_subject_content`, `complain_subject_desc`, `complain_subject_type`, `complain_subject_state`) VALUES (9, '未收到货款', '货物已经发出，未收到货款，商品已经寄给买家，可进行维权。', 2, 1);

INSERT INTO `shopnc_inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (1, '管制刀具、弓弩类、其他武器等', 1, '出售禁售品', 1);
INSERT INTO `shopnc_inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (2, '赌博用具类', 1, '出售禁售品', 1);
INSERT INTO `shopnc_inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (3, '枪支弹药', 1, '出售禁售品', 1);
INSERT INTO `shopnc_inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (4, '毒品及吸毒工具', 1, '出售禁售品', 1);

INSERT INTO `shopnc_inform_subject_type` (`inform_type_id`, `inform_type_name`, `inform_type_desc`, `inform_type_state`) VALUES (1, '出售禁售品', '销售商城禁止和限制交易规则下所规定的所有商品。', 1);

INSERT INTO `shopnc_voucher_price` (`voucher_price_id`, `voucher_price_describe`, `voucher_price`) VALUES (1, '10元面额', 10);
INSERT INTO `shopnc_voucher_price` (`voucher_price_id`, `voucher_price_describe`, `voucher_price`) VALUES (2, '50元面额', 50);