<?php
/**
 * PHP SDK for QQ登录 OpenAPI
 *
 * @version 1.3
 * @author connect@qq.com
 * @copyright © 2012, Tencent Corporation. All rights reserved.
 */

/**
 * @brief 本文件作为demo的配置文件。
 */

/**
 * 正式运营环境请关闭错误信息
 * ini_set("error_reporting", E_ALL);
 * ini_set("display_errors", TRUE);
 * QQDEBUG = true  开启错误提示
 * QQDEBUG = false 禁止错误提示
 * 默认禁止错误信息
 */
define("QQDEBUG", false);
if (defined("QQDEBUG") && QQDEBUG)
{
    @ini_set("error_reporting", E_ALL);
    @ini_set("display_errors", TRUE);
}

//包含配置信息
$cache_file = BasePath.DS.'cache'.DS.'setting.php';
require($cache_file);
//判读qq互联是否开启
if($data['qq_isuse'] != 1){
	@header('location: index.php');
	exit;
}

/**
 * session
 */
//include_once("session.php");
require_once(BasePath.DS.'api'.DS.'qq'.DS.'comm'.DS."session.php");

/**
 * 在你运行本demo之前请到 http://connect.opensns.qq.com/申请appid, appkey, 并注册callback地址
 */
//申请到的appid
//$_SESSION["appid"]    = yourappid;
$_SESSION["appid"]    = trim($data['qq_appid']);

//申请到的appkey
//$_SESSION["appkey"]   = "yourappkey"; 
$_SESSION["appkey"]   = trim($data['qq_appkey']);

//QQ登录成功后跳转的地址,请确保地址真实可用，否则会导致登录失败。
//$_SESSION["callback"] = SiteUrl.DS."api".DS."qq".DS."oauth".DS."get_access_token.php";
$_SESSION["callback"] = SiteUrl."/api.php?act=toqq&op=g";
//print_r ($_SESSION);
?>
