CREATE TABLE `#__activity` (
  `activity_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_title` varchar(255) NOT NULL COMMENT '',
  `activity_type` enum('1','2') DEFAULT NULL COMMENT ' 1:Ʒ 2:Ź',
  `activity_banner` varchar(255) NOT NULL COMMENT 'ͼƬ',
  `activity_style` varchar(255) NOT NULL COMMENT 'ҳģʽʶ',
  `activity_desc` varchar(1000) NOT NULL COMMENT '',
  `activity_start_date` int(10) NOT NULL COMMENT 'ʼʱ',
  `activity_end_date` int(10) DEFAULT NULL COMMENT 'ʱ',
  `activity_sort` tinyint(1) unsigned NOT NULL DEFAULT '255' COMMENT '',
  `activity_state` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '״̬ 0Ϊر 1Ϊ',
  PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='';

CREATE TABLE `#__activity_detail` (
  `activity_detail_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_id` int(11) NOT NULL COMMENT '',
  `item_id` int(11) NOT NULL COMMENT 'ƷŹı',
  `item_name` varchar(255) NOT NULL COMMENT 'ƷŹ',
  `store_id` int(11) NOT NULL COMMENT '̱',
  `store_name` varchar(255) NOT NULL COMMENT '',
  `activity_detail_state` enum('0','1','2','3') NOT NULL DEFAULT '0' COMMENT '״̬ 0:(Ĭ) 1:ͨ 2:δͨ 3:ٴ',
  `activity_detail_sort` tinyint(1) unsigned NOT NULL DEFAULT '255' COMMENT '',
  PRIMARY KEY (`activity_detail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ϸڱ';

CREATE TABLE `#__address` (
  `address_id` mediumint(10) unsigned NOT NULL auto_increment COMMENT 'ַID',
  `member_id` mediumint(10) unsigned NOT NULL default '0' COMMENT 'ԱID',
  `true_name` varchar(50) NOT NULL COMMENT 'Ա',
  `area_id` mediumint(10) unsigned NOT NULL default '0' COMMENT 'ID',
  `city_id` mediumint(9) default NULL COMMENT 'мID',
  `area_info` varchar(255) NOT NULL default '' COMMENT '',
  `address` varchar(255) NOT NULL COMMENT 'ַ',
  `zip_code` char(6) default NULL COMMENT 'ʱ',
  `tel_phone` varchar(20) default NULL COMMENT '绰',
  `mob_phone` varchar(15) default NULL COMMENT 'ֻ绰',
  PRIMARY KEY (`address_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ҵַϢ';

CREATE TABLE `#__admin` (
  `admin_id` int(11) unsigned NOT NULL auto_increment COMMENT 'ԱID',
  `admin_permission` varchar(3000) default NULL COMMENT 'Ȩ',
  `admin_name` varchar(20) NOT NULL COMMENT 'Ա',
  `admin_password` varchar(32) NOT NULL default '' COMMENT 'Ա',
  `admin_login_time` int(10) NOT NULL default '0' COMMENT '¼ʱ',
  `admin_login_num` int(11) NOT NULL default '0' COMMENT '¼',
  `admin_is_super` tinyint(1) NOT NULL default '0' COMMENT 'Ƿ񳬼Ա',
  PRIMARY KEY  (`admin_id`),
  KEY `member_id` (`admin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ա';

CREATE TABLE `#__adv` (
  `adv_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ʶ',
  `ap_id` int(10) unsigned NOT NULL COMMENT 'λid',
  `adv_title` varchar(255) NOT NULL COMMENT '',
  `adv_content` varchar(1000) NOT NULL COMMENT '',
  `adv_start_date` int(10) default NULL COMMENT '濪ʼʱ',
  `adv_end_date` int(10) default NULL COMMENT 'ʱ',
  `slide_sort` int(10) unsigned NOT NULL COMMENT 'õƬ',
  `member_id` int(11) NOT NULL COMMENT 'ԱID',
  `member_name` varchar(50) NOT NULL COMMENT 'Աû',
  `click_num` int(10) unsigned NOT NULL COMMENT '',
  `is_allow` smallint(1) unsigned NOT NULL COMMENT 'ԱĹǷͨ0δ1ͨ2δͨ',
  `buy_style` varchar(10) NOT NULL COMMENT 'ʽ',
  `goldpay` int(10) unsigned NOT NULL COMMENT '֧Ľ',
  PRIMARY KEY  (`adv_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='';

CREATE TABLE `#__adv_click` (
  `adv_id` int(10) unsigned NOT NULL COMMENT 'id',
  `ap_id` int(10) unsigned NOT NULL COMMENT 'λid',
  `click_year` int(4) unsigned NOT NULL COMMENT '',
  `click_month` int(2) unsigned NOT NULL COMMENT '·',
  `click_num` int(10) unsigned NOT NULL COMMENT '',
  `adv_name` varchar(100) NOT NULL COMMENT '',
  `ap_name` varchar(100) NOT NULL COMMENT 'λ'
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʱ';

CREATE TABLE `#__adv_position` (
  `ap_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'λid',
  `ap_name` varchar(100) NOT NULL COMMENT 'λ',
  `ap_intro` varchar(1000) NOT NULL COMMENT 'λ',
  `ap_class` smallint(1) unsigned NOT NULL COMMENT '0ͼƬ12õ3Flash',
  `ap_display` smallint(1) unsigned NOT NULL COMMENT 'չʾʽ0õƬ1չʾ2չʾ',
  `is_use` smallint(1) unsigned NOT NULL COMMENT 'λǷã01',
  `ap_width` int(10) NOT NULL COMMENT 'λ',
  `ap_height` int(10) NOT NULL COMMENT 'λ߶',
  `ap_price` int(10) unsigned NOT NULL COMMENT 'λ',
  `adv_num` int(10) unsigned NOT NULL COMMENT 'ӵеĹ',
  `click_num` int(10) unsigned NOT NULL COMMENT 'λ',
  `default_content` varchar(100) NOT NULL COMMENT 'λĬ',
  PRIMARY KEY (`ap_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='λ';

CREATE TABLE `#__album_class` (
  `aclass_id` int(10) unsigned NOT NULL auto_increment COMMENT 'id',
  `aclass_name` varchar(100) NOT NULL COMMENT '',
  `store_id` int(10) unsigned NOT NULL COMMENT 'id',
  `aclass_des` varchar(255) NOT NULL COMMENT '',
  `aclass_sort` tinyint(3) unsigned NOT NULL COMMENT '',
  `aclass_cover` varchar(255) NOT NULL COMMENT '',
  `upload_time` int(10) unsigned NOT NULL COMMENT 'ͼƬϴʱ',
  `is_default` tinyint(1) unsigned NOT NULL default '0' COMMENT 'ǷΪĬ,1Ĭ',
  PRIMARY KEY (`aclass_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='';

CREATE TABLE `#__album_pic` (
  `apic_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ͼƬid',
  `apic_name` varchar(100) NOT NULL COMMENT 'ͼƬ',
  `apic_tag` varchar(255) NOT NULL COMMENT 'ͼƬǩ',
  `aclass_id` int(10) unsigned NOT NULL COMMENT 'id',
  `apic_cover` varchar(255) NOT NULL COMMENT 'ͼƬ·',
  `apic_size` int(10) unsigned NOT NULL COMMENT 'ͼƬС',
  `apic_spec` varchar(100) NOT NULL COMMENT 'ͼƬ',
  `store_id` int(10) unsigned NOT NULL COMMENT 'id',
  `upload_time` int(10) unsigned NOT NULL COMMENT 'ͼƬϴʱ',
  PRIMARY KEY  (`apic_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ͼƬ';

CREATE TABLE `#__article` (
  `article_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `ac_id` int(11) DEFAULT NULL COMMENT 'id',
  `article_url` varchar(100) DEFAULT NULL COMMENT 'ת',
  `article_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Ƿʾ0Ϊ1ΪǣĬΪ1',
  `article_sort` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '',
  `article_title` varchar(100) DEFAULT NULL COMMENT '',
  `article_content` text COMMENT '',
  `article_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='±';

CREATE TABLE `#__article_class` (
  `ac_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `ac_code` varchar(255) DEFAULT NULL COMMENT 'ʶ',
  `ac_name` varchar(100) NOT NULL COMMENT '',
  `ac_parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `ac_sort` tinyint(1) unsigned NOT NULL DEFAULT '255' COMMENT '',
  PRIMARY KEY (`ac_id`),
  KEY `ac_parent_id` (`ac_parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='·';

CREATE TABLE `#__attribute` (
	`attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
	`attr_name` varchar(100) NOT NULL COMMENT '',
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
	`attr_value` text NOT NULL COMMENT 'ֵ',
	`attr_show` tinyint(1) unsigned NOT NULL COMMENT 'Ƿʾ0Ϊʾ1Ϊʾ',
	`attr_sort` tinyint(1) unsigned NOT NULL COMMENT '',
	PRIMARY KEY  (`attr_id`),
	KEY `attr_id` (`attr_id`,`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷԱ';

CREATE TABLE `#__attribute_value` (
	`attr_value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ֵid',
	`attr_value_name` varchar(100) NOT NULL COMMENT 'ֵ',
	`attr_id` int(10) unsigned NOT NULL COMMENT 'id',
  PRIMARY KEY (`attr_value_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒֵ';

CREATE TABLE `#__brand` (
  `brand_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `brand_name` varchar(100) DEFAULT NULL COMMENT 'Ʒ',
  `brand_class` varchar(100) DEFAULT NULL COMMENT '',
  `brand_pic` varchar(100) DEFAULT NULL COMMENT 'ͼƬ',
  `brand_sort` tinyint(3) unsigned DEFAULT '0' COMMENT '',
  `brand_recommend` tinyint(1) DEFAULT '0' COMMENT 'Ƽ0Ϊ1ΪǣĬΪ0',
  `store_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `brand_apply` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Ʒ룬0ΪУ1ΪͨĬΪ1빦ǻԱʹãϵͳ̨ĬΪ1',
  PRIMARY KEY (`brand_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷƱ';

CREATE TABLE `#__cart` (
  `cart_id` int(11) NOT NULL auto_increment COMMENT 'ﳵid',
  `member_id` int(11) NOT NULL COMMENT 'Աid',
  `store_id` int(11) NOT NULL COMMENT 'id',
  `goods_id` int(11) NOT NULL COMMENT 'Ʒid',
  `goods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `spec_id` int(11) NOT NULL COMMENT 'id',
  `spec_info` text NOT NULL COMMENT '',
  `goods_store_price` decimal(10,2) NOT NULL COMMENT 'Ʒ۸',
  `goods_num` int(11) NOT NULL COMMENT 'Ʒ',
  `goods_images` varchar(100) NOT NULL COMMENT 'ƷͼƬ',
  PRIMARY KEY  (`cart_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ﳵݱ';

CREATE TABLE `#__complain` (
  `complain_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ͷid',
  `order_id` int(11) NOT NULL COMMENT 'id',
  `order_goods_count` int(11) NOT NULL COMMENT 'Ʒ',
  `complain_goods_count` int(11) NOT NULL COMMENT 'ͶƷ',
  `accuser_id` int(11) NOT NULL COMMENT 'ԭid',
  `accuser_name` varchar(50) NOT NULL COMMENT 'ԭ',
  `accused_id` int(11) NOT NULL COMMENT 'id',
  `accused_name` varchar(50) NOT NULL COMMENT '',
  `complain_subject_content` varchar(50) NOT NULL COMMENT 'Ͷ',
  `complain_subject_id` int(11) NOT NULL COMMENT 'Ͷid',
  `complain_content` varchar(255) NOT NULL COMMENT 'Ͷ',
  `complain_pic1` varchar(100) NOT NULL COMMENT 'ͶͼƬ1',
  `complain_pic2` varchar(100) NOT NULL COMMENT 'ͶͼƬ2',
  `complain_pic3` varchar(100) NOT NULL COMMENT 'ͶͼƬ3',
  `complain_datetime` int(11) NOT NULL COMMENT 'Ͷʱ',
  `complain_handle_datetime` int(11) NOT NULL COMMENT 'Ͷߴʱ',
  `complain_handle_member_id` int(11) NOT NULL COMMENT 'Ͷߴid',
  `appeal_message` varchar(255) NOT NULL COMMENT '',
  `appeal_datetime` int(11) NOT NULL COMMENT 'ʱ',
  `appeal_pic1` varchar(100) NOT NULL COMMENT 'ͼƬ1',
  `appeal_pic2` varchar(100) NOT NULL COMMENT 'ͼƬ2',
  `appeal_pic3` varchar(100) NOT NULL COMMENT 'ͼƬ3',
  `final_handle_message` varchar(255) NOT NULL COMMENT 'մ',
  `final_handle_datetime` int(11) NOT NULL COMMENT 'մʱ',
  `final_handle_member_id` int(11) NOT NULL COMMENT 'մid',
  `complain_type` tinyint(4) NOT NULL COMMENT 'Ͷ(1-Ͷ/2-Ͷ)',
  `complain_state` tinyint(4) NOT NULL COMMENT 'Ͷ״̬(10-Ͷ/20-ͶͨתͶ/30-Ͷ/40-ύٲ/99-ѹر)',
  `complain_active` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'ͶǷͨƽ̨(1δͨ/2ͨ)',
  PRIMARY KEY (`complain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ͷ߱';

CREATE TABLE `#__complain_goods` (
  `complain_goods_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ͶƷid',
  `complain_id` int(11) NOT NULL COMMENT 'Ͷid',
  `goods_id` int(11) NOT NULL COMMENT 'Ʒid',
  `goods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `spec_id` int(11) NOT NULL COMMENT 'id',
  `spec_info` varchar(50) NOT NULL DEFAULT '' COMMENT '',
  `goods_price` decimal(10,2) NOT NULL COMMENT 'Ʒ۸',
  `goods_num` int(11) NOT NULL COMMENT 'Ʒ',
  `goods_image` varchar(100) NOT NULL DEFAULT '' COMMENT 'ƷͼƬ',
  `evaluation` tinyint(1) NOT NULL DEFAULT '0' COMMENT ': 1 2 3',
  `comment` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `complain_message` varchar(100) NOT NULL COMMENT 'ͶƷ',
  PRIMARY KEY (`complain_goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ͶƷ';

CREATE TABLE `#__complain_subject` (
  `complain_subject_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ٱid',
  `complain_subject_content` varchar(50) NOT NULL COMMENT 'ٱ',
  `complain_subject_desc` varchar(100) NOT NULL COMMENT 'ٱ',
  `complain_subject_type` tinyint(4) NOT NULL COMMENT 'ٱ(1-/2-)',
  `complain_subject_state` tinyint(4) NOT NULL COMMENT 'ٱ״̬(1-Ч/2-ʧЧ)',
  PRIMARY KEY (`complain_subject_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ٱ';

CREATE TABLE `#__complain_talk` (
  `talk_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ͷ߶Իid',
  `complain_id` int(11) NOT NULL COMMENT 'Ͷid',
  `talk_member_id` int(11) NOT NULL COMMENT 'id',
  `talk_member_name` varchar(50) NOT NULL COMMENT '',
  `talk_member_type` varchar(10) NOT NULL COMMENT '(1-Ͷ/2-Ͷ/3-ƽ̨)',
  `talk_content` varchar(255) NOT NULL COMMENT '',
  `talk_state` tinyint(4) NOT NULL COMMENT '״̬(1-ʾ/2-ʾ)',
  `talk_admin` int(11) NOT NULL DEFAULT '0' COMMENT 'ԻԱζԻ˵id',
  `talk_datetime` int(11) NOT NULL COMMENT 'Իʱ',
  PRIMARY KEY (`talk_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ͷ߶Ի';

CREATE TABLE `#__consult` (
  `consult_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ѯ',
  `goods_id` int(11) default '0' COMMENT 'Ʒ',
  `cgoods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `member_id` int(11) NOT NULL default '0' COMMENT 'ѯ߻Ա(0ο)',
  `cmember_name` varchar(100) default NULL COMMENT 'Ա',
  `seller_id` int(11) NOT NULL COMMENT 'ұ',
  `email` varchar(255) default NULL COMMENT 'ѯ',
  `consult_content` varchar(4000) default NULL COMMENT 'ѯ',
  `consult_addtime` int(10) default NULL COMMENT 'ѯʱ',
  `consult_reply` varchar(4000) default NULL COMMENT 'ѯظ',
  `consult_reply_time` int(10) default NULL COMMENT 'ѯظʱ',
  `isanonymous` tinyint(1) NOT NULL default '0' COMMENT '0ʾ 1ʾ',
  PRIMARY KEY (`consult_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒѯ';

CREATE TABLE `#__coupon` (
  `coupon_id` int(11) NOT NULL auto_increment COMMENT 'id',
  `coupon_title` varchar(255) NOT NULL COMMENT 'Żȯ',
  `coupon_type` enum('1','2') default NULL COMMENT '',
  `coupon_pic` varchar(255) NOT NULL COMMENT '',
  `coupon_desc` varchar(1000) NOT NULL COMMENT 'Żȯ',
  `coupon_start_date` int(10) NOT NULL COMMENT 'Żȯʼ',
  `coupon_end_date` int(10) NOT NULL COMMENT 'Żȯֹ',
  `coupon_price` decimal(10,2) NOT NULL default '0.00' COMMENT 'Żݽ',
  `coupon_limit` decimal(10,2) NOT NULL default '0.00' COMMENT '',
  `store_id` int(11) default NULL COMMENT 'id',
  `coupon_state` enum('1','2') default '1' COMMENT 'ϼ¼״̬',
  `coupon_storage` int(11) NOT NULL default '0' COMMENT 'ܹ',
  `coupon_usage` int(11) NOT NULL default '0' COMMENT 'ʹ',
  `coupon_lock` enum('1','2') NOT NULL default '1' COMMENT 'Ƿ',
  `coupon_add_date` int(10) NOT NULL COMMENT '',
  `coupon_class_id` int(11) NOT NULL COMMENT '',
  `coupon_click` int(11) NOT NULL default '1' COMMENT '',
  `coupon_print_style` varchar(255) NOT NULL default '4STYLE' COMMENT '4STYLE STANDS FOR 4 COUPONS PER A4 PAGE, AND 8STYLE STANDS FOR 8 COUPONS PER A4 PAGE',
  `coupon_recommend` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0Ƽ 1Ƽҳ',
  `coupon_allowstate` tinyint(1) unsigned DEFAULT '1' COMMENT '״̬ 0Ϊ 1ͨ 2δͨ',
  `coupon_allowremark` varchar(255) NULL COMMENT '˱ע',
  PRIMARY KEY  (`coupon_id`),
  KEY `store_id` (`store_id`),
  KEY `coupon_title` (`coupon_title`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Żȯ';

CREATE TABLE `#__coupon_class` (
  `class_id` int(11) NOT NULL auto_increment COMMENT 'Żȯid',
  `class_parent_id` int(11) NOT NULL default '0' COMMENT 'id',
  `class_name` varchar(100) NOT NULL COMMENT '',
  `class_sort` tinyint(1) unsigned NOT NULL default '0' COMMENT '',
  `class_show` enum('0','1') NOT NULL default '0' COMMENT 'Ƿʾ',
  PRIMARY KEY  (`class_id`),
  KEY `class_parent_id` (`class_parent_id`),
  KEY `class_sort` (`class_sort`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Żȯ';

CREATE TABLE `#__document` (
  `doc_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `doc_code` varchar(255) NOT NULL COMMENT 'ñʶ',
  `doc_title` varchar(255) NOT NULL COMMENT '',
  `doc_content` text NOT NULL COMMENT '',
  `doc_time` int(10) unsigned NOT NULL COMMENT 'ʱ/޸ʱ',
  PRIMARY KEY (`doc_id`),
  UNIQUE KEY `doc_code` (`doc_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ϵͳ±';

CREATE TABLE `#__evaluate_goods` (
  `geval_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `geval_orderid` int(11) NOT NULL COMMENT 'ID',
  `geval_orderno` varchar(100) NOT NULL COMMENT '',
  `geval_ordergoodsid` int(11) NOT NULL COMMENT 'Ʒ',
  `geval_goodsid` int(11) NOT NULL COMMENT 'Ʒ',
  `geval_goodsname` varchar(100) NOT NULL COMMENT 'Ʒ',
  `geval_specinfo` varchar(50) default NULL COMMENT '',
  `geval_goodsprice` decimal(10,2) default NULL COMMENT 'Ʒ۸',
  `geval_scores` tinyint(1) NOT NULL COMMENT '1 0 -1',
  `geval_content` varchar(500) default NULL COMMENT '',
  `geval_isanonymous` tinyint(1) NOT NULL default '0' COMMENT '0ʾ 1ʾ',
  `geval_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `geval_storeid` int(11) NOT NULL COMMENT '̱',
  `geval_storename` varchar(100) NOT NULL COMMENT '',
  `geval_frommemberid` int(11) NOT NULL COMMENT '˱',
  `geval_frommembername` varchar(100) NOT NULL COMMENT '',
  `geval_tomemberid` int(11) NOT NULL COMMENT '˱',
  `geval_tomembername` varchar(100) NOT NULL COMMENT 'û',
  `geval_state` tinyint(1) NOT NULL default '0' COMMENT 'Ϣ״̬ 0Ϊ 1Ϊֹʾ',
  `geval_remark` varchar(500) default NULL COMMENT 'Ա۵Ĵע',
  `geval_explain` varchar(500) default NULL COMMENT '',
  `geval_bothstate` tinyint(1) NOT NULL default '1' COMMENT 'ۻ״̬ 12˫',
  `geval_showtime` int(11) NOT NULL COMMENT 'չʾʱͳƵȶԸֵΪ׼',
  `geval_type` tinyint(1) NOT NULL default '1' COMMENT ' 1 2',
  PRIMARY KEY  (`geval_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='۱';

CREATE TABLE `#__evaluate_goodsstat` (
  `gevalstat_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `gevalstat_storeid` int(11) NOT NULL COMMENT 'ID',
  `gevalstat_type` tinyint(1) NOT NULL COMMENT 'ͳ 1һ 2һ 3 4ǰ 5ܼ¼',
  `gevalstat_level1num` int(11) NOT NULL default '0' COMMENT '',
  `gevalstat_level2num` int(11) NOT NULL default '0' COMMENT '',
  `gevalstat_level3num` int(11) NOT NULL default '0' COMMENT '',
  PRIMARY KEY  (`gevalstat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷͳƱ';

CREATE TABLE `#__evaluate_store` (
  `seval_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `seval_orderid` int(11) NOT NULL COMMENT 'ID',
  `seval_orderno` varchar(100) NOT NULL COMMENT '',
  `seval_type` tinyint(1) NOT NULL COMMENT '  1ʾ 2ʾҷ̬ 3ʾҷٶ',
  `seval_scores` tinyint(1) NOT NULL default '0' COMMENT '۷',
  `seval_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `seval_storeid` int(11) NOT NULL COMMENT '̱',
  `seval_storename` varchar(100) NOT NULL COMMENT '',
  `seval_memberid` int(11) NOT NULL COMMENT 'ұ',
  `seval_membername` varchar(100) NOT NULL COMMENT '',
  PRIMARY KEY  (`seval_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ֱ';

CREATE TABLE `#__evaluate_storestat` (
  `evalstat_id` int(11) NOT NULL auto_increment COMMENT 'ͳID',
  `evalstat_storeid` int(11) NOT NULL COMMENT 'ID',
  `evalstat_type` tinyint(1) NOT NULL COMMENT 'ͳ 1ʾ 2ʾҷ̬ 3ʾҷٶ',
  `evalstat_average` float NOT NULL default '0' COMMENT 'ƽ',
  `evalstat_timesnum` int(11) NOT NULL default '0' COMMENT '۴',
  `evalstat_onenum` int(11) NOT NULL default '0' COMMENT 'һǴ',
  `evalstat_twonum` int(11) NOT NULL default '0' COMMENT 'Ǵ',
  `evalstat_threenum` int(11) NOT NULL default '0' COMMENT 'Ǵ',
  `evalstat_fournum` int(11) NOT NULL default '0' COMMENT 'Ǵ',
  `evalstat_fivenum` int(11) NOT NULL default '0' COMMENT 'Ǵ',
  PRIMARY KEY  (`evalstat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ͳƱ';

CREATE TABLE `#__favorites` (
  `member_id` int(10) unsigned NOT NULL COMMENT 'ԱID',
  `fav_id` int(10) unsigned NOT NULL COMMENT 'ղID',
  `fav_type` varchar(20) NOT NULL COMMENT 'ղ',
  `fav_time` varchar(10) NOT NULL COMMENT 'ղʱ'
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ղر';

CREATE TABLE `#__gold_buy` (
  `gbuy_id` int(11) NOT NULL auto_increment COMMENT 'id',
  `gbuy_mid` int(11) NOT NULL COMMENT 'Ա',
  `gbuy_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `gbuy_storeid` int(11) NOT NULL COMMENT '̱',
  `gbuy_storename` varchar(50) NOT NULL COMMENT '',
  `gbuy_num` int(11) NOT NULL default '0' COMMENT '',
  `gbuy_price` decimal(10,2) NOT NULL COMMENT '',
  `gbuy_addtime` int(11) NOT NULL COMMENT '¼ʱ',
  `gbuy_ispay` tinyint(4) NOT NULL default '0' COMMENT 'ǷѾ֧ 0 δ֧ 1֧',
  `gbuy_adminid` int(11) default NULL COMMENT '¼Ա',
  `gbuy_sys_remark` varchar(500) default NULL COMMENT 'ע',
  `gbuy_user_remark` varchar(500) default NULL COMMENT 'ûע',
  `gbuy_check_type` varchar(100) default NULL COMMENT 'ҵ֧',
  PRIMARY KEY  (`gbuy_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ҹ¼';

CREATE TABLE `#__gold_log` (
  `glog_id` int(11) NOT NULL auto_increment COMMENT '',
  `glog_memberid` int(11) NOT NULL COMMENT 'Ա',
  `glog_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `glog_storeid` int(11) NOT NULL COMMENT '̱',
  `glog_storename` varchar(50) NOT NULL COMMENT '',
  `glog_adminid` int(11) NOT NULL COMMENT 'ԱţûйԱΪ0',
  `glog_adminname` varchar(20) NOT NULL COMMENT 'Ա',
  `glog_goldnum` int(11) NOT NULL default '0' COMMENT '',
  `glog_method` tinyint(4) NOT NULL default '1' COMMENT 'ʽ 1 2',
  `glog_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `glog_desc` varchar(500) default NULL COMMENT '',
  `glog_stage` varchar(20) NOT NULL default 'system' COMMENT '',
  PRIMARY KEY  (`glog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='־';

CREATE TABLE `#__gold_payment` (
  `payment_id` tinyint(1) unsigned NOT NULL COMMENT '֧id',
  `payment_code` char(10) NOT NULL COMMENT '֧',
  `payment_name` varchar(20) NOT NULL COMMENT '֧',
  `payment_info` varchar(255) default NULL COMMENT '֧ӿڽ',
  `payment_config` text COMMENT '֧ӿϢ',
  `payment_online` tinyint(1) unsigned default '0' COMMENT 'ǷΪ߽ӿڣ1ǣ0',
  `payment_state` tinyint(1) unsigned default '1' COMMENT 'ӿ״̬1ã2',
  `payment_sort` tinyint(1) unsigned default '3' COMMENT '֧',
  PRIMARY KEY  (`payment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='֧ʽ';

CREATE TABLE `#__goods` (
  `goods_id` int(10) unsigned NOT NULL auto_increment COMMENT 'Ʒid',
  `goods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `gc_id` int(10) unsigned NOT NULL COMMENT 'Ʒid',
  `gc_name` varchar(200) NOT NULL COMMENT 'Ʒ',
  `brand_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ƷƷid',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `store_id` int(10) unsigned NOT NULL COMMENT 'id',
  `spec_open` tinyint(1) NOT NULL default '0' COMMENT 'Ʒ״̬10ر',
  `spec_id` int(11) NOT NULL COMMENT 'ƷĬ϶ӦĹid',
  `spec_name` varchar(255)  NOT NULL DEFAULT '' COMMENT '',
  `goods_image` varchar(100) NOT NULL COMMENT 'ƷĬϷͼƬ',
  `goods_image_more` text default NULL COMMENT 'Ʒͼ',
  `goods_store_price` decimal(10,2) NOT NULL COMMENT 'Ʒ̼۸',
  `goods_store_price_interval` varchar(30) NOT NULL DEFAULT '' COMMENT 'Ʒ۸',
  `goods_serial` varchar(50) NOT NULL DEFAULT '' COMMENT 'Ʒ',
  `goods_show` tinyint(1) NOT NULL COMMENT 'Ʒϼ',
  `goods_click` int(11) NOT NULL default '1' COMMENT 'Ʒ',
  `goods_state` tinyint(1) NOT NULL default '0' COMMENT 'Ʒ״̬01Υ¼',
  `goods_commend` tinyint(1) NOT NULL COMMENT 'ƷƼ',
  `goods_add_time` varchar(10) NOT NULL COMMENT 'Ʒʱ',
  `goods_keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'Ʒؼ',
  `goods_description` varchar(255) NOT NULL DEFAULT '' COMMENT 'Ʒ',
  `goods_body` text NOT NULL COMMENT 'Ʒϸ',
  `goods_attr` text default '' COMMENT 'Ʒ',
  `goods_spec` text default '' COMMENT 'Ʒ',
  `goods_col_img` text default NULL COMMENT 'ɫԶͼƬ',
  `goods_indate` tinyint(1) unsigned NOT NULL default '7' COMMENT 'Ч',
  `goods_starttime` varchar(10) default NULL COMMENT 'ʼʱ',
  `goods_endtime` varchar(10) default NULL COMMENT 'ʱ',
  `goods_form` tinyint(1) unsigned NOT NULL default '1' COMMENT 'Ʒ,1Ϊȫ¡2Ϊ',
  `transport_id` mediumint(8) unsigned default '0' COMMENT '˷ģIDʹ˷ģֵΪ0',
  `py_price` decimal(10,2) default '0.00' COMMENT 'ƽ',
  `kd_price` decimal(10,2) default '0.00' COMMENT '',
  `es_price` decimal(10,2) default '0.00' COMMENT 'EMS',
  `city_id` mediumint(8) unsigned default '0' COMMENT 'Ʒڵ()',
  `province_id` mediumint(8) unsigned default '0' COMMENT 'Ʒڵ(ʡ)',
  `goods_close_reason` varchar(255) default NULL COMMENT 'ƷΥ¼ԭ',
  `goods_store_state` tinyint(1) NOT NULL default '0' COMMENT 'Ʒڵ״̬ 0 1ر',
  `commentnum` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '۴',
  `salenum` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '۳',
  `goods_collect` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ʒղ',
  `goods_goldnum` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ֱͨʣҶ',
  `goods_isztc` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ǷֱͨƷ 0 1ֱͨƷ',
  `goods_ztcstate` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ֱͨ״̬  1ʾ 2ʾֹ',
  `goods_ztcstartdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
  `goods_ztclastdate` int(10) unsigned NULL COMMENT 'ѽҵʱ ûõĻûм',
  `group_flag` tinyint(1) unsigned NULL DEFAULT '0' COMMENT 'Źʶ(Ź1/Ź0)',
  `group_price` decimal(10,2) NOT NULL default '0.00' COMMENT 'Ź۸',
  `xianshi_flag` tinyint(1) unsigned NOT NULL default '0' COMMENT 'ʱۿƷ־(1-/0-)',
  `xianshi_discount` decimal(10,2) NOT NULL default '0.00' COMMENT 'ʱۿ',
  `goods_transfee_charge` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ʒ˷ѳеʽ Ĭ 0Ϊҳе 1Ϊҳе',
  PRIMARY KEY  (`goods_id`),
  KEY `goods_name` (`goods_name`,`gc_id`,`store_id`),
  KEY `spec_id` (`spec_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__goods_attr_index` (
	`goods_id` int(10) unsigned NOT NULL COMMENT 'Ʒid',
	`gc_id` int(10) unsigned NOT NULL COMMENT 'Ʒid',
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
	`attr_id` int(10) unsigned NOT NULL COMMENT 'id',
	`attr_value_id` int(10) unsigned NOT NULL COMMENT 'ֵid',
	PRIMARY KEY (`goods_id`,`gc_id`,`attr_value_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷԶӦ';

CREATE TABLE `#__goods_class` (
  `gc_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `gc_name` varchar(100) NOT NULL COMMENT '',
  `type_id` int(10) unsigned NOT NULL COMMENT 'id',
  `type_name` varchar(100) NOT NULL COMMENT '',
  `store_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID0Ϊϵͳ̨',
  `gc_parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `gc_sort` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `gc_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ǰ̨ʾ0Ϊ1ΪǣĬΪ1',
  `gc_index_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ҳʾ 1Ĭ ʾ 0ʾ',
  `gc_keywords` varchar(200) NOT NULL COMMENT 'ؼ',
  `gc_description` varchar(200) NOT NULL COMMENT '',
  PRIMARY KEY (`gc_id`),
  KEY `store_id` (`store_id`,`gc_parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__goods_class_staple` (
	`staple_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '÷id',
	`staple_name` varchar(255) NOT NULL COMMENT '÷',
	`gc_id` int(10) unsigned NOT NULL COMMENT 'id',
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
	`store_id` int(10) unsigned NOT NULL COMMENT 'id',
  PRIMARY KEY (`staple_id`),
	KEY `store_id` (`store_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='̳÷';

CREATE TABLE `#__goods_class_tag` (
	`gc_tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'TAGid',
	`gc_id_1` int(10) unsigned NOT NULL COMMENT 'һid',
	`gc_id_2` int(10) unsigned NOT NULL COMMENT 'id',
	`gc_id_3` int(10) unsigned NOT NULL COMMENT 'id',
	`gc_tag_name` varchar(255) NOT NULL COMMENT 'TAG',
	`gc_tag_value` text NOT NULL COMMENT 'TAGֵ',
	`gc_id` int(10) unsigned NOT NULL COMMENT 'Ʒid',
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
  PRIMARY KEY (`gc_tag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷTAG';

CREATE TABLE `#__goods_group` (
  `group_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ŹID',
  `group_name` varchar(255) NOT NULL COMMENT '',
  `template_id` int(10) unsigned NOT NULL COMMENT 'Ź',
  `template_name` varchar(50) NOT NULL COMMENT 'Ź',
  `group_help` varchar(255) DEFAULT NULL COMMENT '˵',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ƷID',
  `goods_name` varchar(200) NOT NULL COMMENT  'Ʒ',
  `store_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `store_name` varchar(50) NOT NULL COMMENT  '',
  `spec_price` varchar(255) NOT NULL COMMENT '۸',
  `goods_price` decimal(10,2) NOT NULL COMMENT  'Ʒԭ',
  `groupbuy_price` decimal(10,2) NOT NULL COMMENT  'Ź۸',
  `limit_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT ' 1. 2.ռ',
  `virtual_quantity` int(10) unsigned NOT NULL COMMENT  '⹺',
  `buyer_count` int(10) unsigned NOT NULL COMMENT  'ѹ',
  `def_quantity` int(10) NOT NULL DEFAULT '0' COMMENT 'Ѷ',
  `min_quantity` int(10) NOT NULL DEFAULT '0' COMMENT 'СŹ',
  `sale_quantity` int(10) NOT NULL DEFAULT '0' COMMENT 'ÿ޹',
  `max_num` int(10) NOT NULL DEFAULT '0' COMMENT '߼',
  `group_intro` text DEFAULT NULL COMMENT 'Ž',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ź״̬ 1.δ 2.ȡ 3. 4. 5.ѽ',
  `recommended` tinyint(1) unsigned NOT NULL COMMENT 'ǷƼ 0.δƼ 1.Ƽ',
  `published` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ񷢲 1.δ 2.ѷ',
  `views` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '鿴',
  `cancel_intro` varchar(255) DEFAULT NULL COMMENT 'ȡ˵',
  `class_id` int(10) unsigned NOT NULL COMMENT  'Ź',
  `area_id` int(10) unsigned NOT NULL COMMENT  'Ź',
  `group_pic` varchar(100) NOT NULL COMMENT  'ŹͼƬ',
  `rebate` decimal(10,2) NOT NULL COMMENT 'ۿ',
  `remark` varchar(255) NOT NULL COMMENT 'ע',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ŹƷ';

CREATE TABLE `#__goods_spec` (
  `spec_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ʒid',
  `goods_id` int(11) NOT NULL COMMENT 'Ʒid',
  `spec_name` varchar(255) NOT NULL COMMENT '',
  `spec_goods_price` decimal(10,2) NOT NULL COMMENT 'Ʒ۸',
  `spec_goods_storage` int(11) NOT NULL COMMENT 'Ʒ',
  `spec_salenum` int NOT NULL DEFAULT '0' COMMENT '۳',
  `spec_goods_color` varchar(20) NOT NULL COMMENT 'Ʒɫ',
  `spec_goods_serial` varchar(50) NOT NULL COMMENT 'Ʒ',
  `spec_goods_spec` text NOT NULL COMMENT 'Ʒл',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__goods_spec_index` (
	`goods_id` int(10) unsigned NOT NULL COMMENT 'Ʒid',
	`gc_id` int(10) unsigned NOT NULL COMMENT 'Ʒid',
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
	`sp_id` int(10) unsigned NOT NULL COMMENT 'id',
	`sp_value_id` int(10) unsigned NOT NULL COMMENT 'ֵid',
	`sp_value_name` varchar(100) NULL COMMENT 'ֵ',
	PRIMARY KEY (`goods_id`,`gc_id`,`sp_value_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷӦ';

CREATE TABLE  `#__groupbuy_area` (
	`area_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT  '',
	`area_name` varchar(50) NOT NULL COMMENT  '',
	`area_parent_id` int(10) unsigned NOT NULL COMMENT  '',
	`area_sort` tinyint(1) unsigned NOT NULL COMMENT  '',
	`area_deep` tinyint(1) unsigned NOT NULL COMMENT  '',
	PRIMARY KEY (`area_id`)
) ENGINE=MYISAM  DEFAULT CHARSET=gbk COMMENT='Ź';

CREATE TABLE `#__groupbuy_class` (
  `class_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '',
  `class_name` varchar(20) NOT NULL COMMENT '',
  `class_parent_id` int(10) unsigned NOT NULL COMMENT '',
  `sort` tinyint(1) unsigned NOT NULL COMMENT '',
  `deep` tinyint(1) unsigned NOT NULL COMMENT '',
  PRIMARY KEY (`class_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ź';

CREATE TABLE `#__groupbuy_price_range` (
  `range_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '۸',
  `range_name` varchar(20) NOT NULL COMMENT '',
  `range_start` int(10) unsigned NOT NULL COMMENT '',
  `range_end` int(10) unsigned NOT NULL COMMENT '',
  PRIMARY KEY (`range_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COMMENT='Ź۸';

CREATE TABLE `#__groupbuy_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Ź',
  `template_name` varchar(50) NOT NULL COMMENT 'Źܹ',
  `start_time` int(10) unsigned NOT NULL COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `join_end_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-ɱ/2-ѹ)',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ź';

CREATE TABLE `#__inform` (
  `inform_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ٱid',
  `inform_member_id` int(11) NOT NULL COMMENT 'ٱid',
  `inform_member_name` varchar(50) NOT NULL COMMENT 'ٱ˻Ա',
  `inform_goods_id` int(11) NOT NULL COMMENT 'ٱƷid',
  `inform_goods_name` varchar(100) NOT NULL COMMENT 'ٱƷ',
  `inform_subject_id` int(11) NOT NULL COMMENT 'ٱid',
  `inform_subject_content` varchar(50) NOT NULL COMMENT 'ٱ',
  `inform_content` varchar(100) NOT NULL COMMENT 'ٱϢ',
  `inform_pic1` varchar(100) NOT NULL COMMENT 'ͼƬ1',
  `inform_pic2` varchar(100) NOT NULL COMMENT 'ͼƬ2',
  `inform_pic3` varchar(100) NOT NULL COMMENT 'ͼƬ3',
  `inform_datetime` int(11) NOT NULL COMMENT 'ٱʱ',
  `inform_store_id` int(11) NOT NULL COMMENT 'ٱƷĵid',
  `inform_state` tinyint(4) NOT NULL COMMENT 'ٱ״̬(1δ/2Ѵ)',
  `inform_handle_type` tinyint(4) NOT NULL COMMENT 'ٱ(1Чٱ/2ٱ/3Чٱ)',
  `inform_handle_message` varchar(100) NOT NULL COMMENT 'ٱϢ',
  `inform_handle_datetime` int(11) NOT NULL DEFAULT '0' COMMENT 'ٱʱ',
  `inform_handle_member_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Աid',
  PRIMARY KEY (`inform_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ٱ';

CREATE TABLE `#__inform_subject` (
  `inform_subject_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ٱid',
  `inform_subject_content` varchar(100) NOT NULL COMMENT 'ٱ',
  `inform_subject_type_id` int(11) NOT NULL COMMENT 'ٱid',
  `inform_subject_type_name` varchar(50) NOT NULL COMMENT 'ٱ ',
  `inform_subject_state` tinyint(11) NOT NULL COMMENT 'ٱ״̬(1/2ʧЧ)',
  PRIMARY KEY (`inform_subject_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ٱ';

CREATE TABLE `#__inform_subject_type` (
  `inform_type_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ٱid',
  `inform_type_name` varchar(50) NOT NULL COMMENT 'ٱ ',
  `inform_type_desc` varchar(100) NOT NULL COMMENT 'ٱ',
  `inform_type_state` tinyint(4) NOT NULL COMMENT 'ٱ״̬(1Ч/2ʧЧ)',
  PRIMARY KEY (`inform_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ٱͱ';

CREATE TABLE `#__link` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `link_title` varchar(100) DEFAULT NULL COMMENT '',
  `link_url` varchar(100) DEFAULT NULL COMMENT '',
  `link_pic` varchar(100) DEFAULT NULL COMMENT 'ͼƬ',
  `link_sort` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='';

CREATE TABLE `#__mail_msg_temlates` (
  `name` varchar(100) NOT NULL COMMENT 'ģ',
  `title` varchar(100) DEFAULT NULL COMMENT 'ģ',
  `code` varchar(100) NOT NULL COMMENT 'ģô',
  `content` text NOT NULL COMMENT 'ģ',
  `type` tinyint(1) NOT NULL COMMENT 'ģ0Ϊʼ1ΪϢĬΪ0',
  `mail_switch` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  PRIMARY KEY (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʼģ';

CREATE TABLE `#__map` (
  `map_id` int(11) NOT NULL auto_increment COMMENT 'ͼID',
  `member_id` int(11) NOT NULL COMMENT 'ԱID',
  `member_name` varchar(20) NOT NULL COMMENT 'Ա',
  `area_id` int(11) NOT NULL COMMENT 'ID',
  `area_info` varchar(50) NOT NULL COMMENT '',
  `address` varchar(50) default NULL COMMENT 'ַ',
  `point_lng` float NOT NULL default '0' COMMENT '',
  `point_lat` float NOT NULL default '0' COMMENT 'γ',
  `store_name` varchar(20) default NULL COMMENT '',
  `store_id` int(11) default '0' COMMENT 'ID',
  `map_api` char(9) NOT NULL default 'baidu' COMMENT 'ͼAPI(ʱֻbaidu)',
  PRIMARY KEY  (`map_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ͼ';

CREATE TABLE `#__member` (
  `member_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Աid',
  `member_name` varchar(50) NOT NULL COMMENT 'Ա',
  `member_truename` varchar(50) DEFAULT NULL COMMENT 'ʵ',
  `store_id` int(11) NOT NULL COMMENT 'id',
  `member_avatar` varchar(50) DEFAULT NULL COMMENT 'Աͷ',
  `member_sex` tinyint(1) DEFAULT NULL COMMENT 'ԱԱ',
  `member_birthday` date DEFAULT NULL COMMENT '',
  `member_passwd` varchar(32) NOT NULL COMMENT 'Ա',
  `member_email` varchar(100) NOT NULL COMMENT 'Ա',
  `member_qq` varchar(100) DEFAULT NULL COMMENT 'qq',
  `member_msn` varchar(100) DEFAULT NULL COMMENT 'msn',
  `member_ww` varchar(100) DEFAULT NULL COMMENT '',
  `member_login_num` int(11) NOT NULL DEFAULT '1' COMMENT '¼',
  `member_time` varchar(10) NOT NULL COMMENT 'Աעʱ',
  `member_login_time` varchar(10) NOT NULL COMMENT 'ǰ¼ʱ',
  `member_old_login_time` varchar(10) NOT NULL COMMENT 'ϴε¼ʱ',
  `member_login_ip` varchar(20) DEFAULT NULL COMMENT 'ǰ¼ip',
  `member_old_login_ip` varchar(20) DEFAULT NULL COMMENT 'ϴε¼ip',
  `member_goldnum` int(11) NOT NULL DEFAULT '0' COMMENT '',
  `member_goldnumcount` int(11) NOT NULL DEFAULT '0' COMMENT 'ӵй',
  `member_goldnumminus` int(11) NOT NULL DEFAULT '0' COMMENT 'Ѿѽ',
  `member_qqopenid` varchar(100) NULL COMMENT 'qqid',
  `member_qqinfo` text NULL COMMENT 'qq˺Ϣ',
  `member_sinaopenid` varchar(100) NULL COMMENT '΢¼id',
  `member_sinainfo` text NULL COMMENT '˺Ϣлֵ',
  `member_points` int(11) NOT NULL DEFAULT '0' COMMENT 'Ա',
  `available_predeposit` decimal(10,2) NOT NULL DEFAULT '0' COMMENT 'Ԥý',
  `freeze_predeposit` decimal(10,2) NOT NULL DEFAULT '0' COMMENT 'Ԥ',
  `inform_allow` tinyint(1) NOT NULL default '1' COMMENT 'Ƿٱ(1/2)',
  `is_buy` tinyint(1) NOT NULL default '1' COMMENT 'ԱǷйȨ 1Ϊ 0Ϊر',
  `is_allowtalk` tinyint(1) NOT NULL default '1' COMMENT 'ԱǷѯͷվŵȨ 1Ϊ 0Ϊر',
  `member_state` tinyint(1) NOT NULL default '1' COMMENT 'ԱĿ״̬ 1Ϊ 0Ϊر',
  `member_credit` int(11) NOT NULL default '0' COMMENT 'Ա',
  `member_snsvisitnum` int(11) NOT NULL default '0' COMMENT 'snsռʴ',
  `member_areaid` int(11) default NULL COMMENT 'ID',
  `member_cityid` int(11) default NULL COMMENT 'ID',
  `member_provinceid` int(11) default NULL COMMENT 'ʡID',
  `member_areainfo` varchar(255) default NULL COMMENT '',
  PRIMARY KEY (`member_id`),
  KEY `member_name` (`member_name`,`store_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ա';

CREATE TABLE `#__message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ϣid',
  `message_parent_id` int(11) NOT NULL COMMENT 'ظϢmessage_id',
  `from_member_id` int(11) NOT NULL COMMENT 'Ϣ',
  `to_member_id` varchar(1000) NOT NULL COMMENT 'Ϣ',
  `message_title` varchar(50) DEFAULT NULL COMMENT 'Ϣ',
  `message_body` varchar(255) NOT NULL COMMENT 'Ϣ',
  `message_time` varchar(10) NOT NULL COMMENT 'Ϣʱ',
  `message_update_time` varchar(10) DEFAULT NULL COMMENT 'Ϣظʱ',
  `message_open` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ϣ״̬',
  `message_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ϣ״̬0Ϊ״̬1Ϊɾ״̬2Ϊɾ״̬',
  `message_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0Ϊͨš1ΪϵͳϢ2ΪCRMϢ',
  `read_member_id` varchar(1000) NULL COMMENT 'ѾϢĻԱid',
  `del_member_id` varchar(1000) NULL COMMENT 'ѾɾϢĻԱid',
  `message_ismore` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'վǷΪһû 0Ϊ 1Ϊ ',
  `from_member_name` varchar(100)  NULL COMMENT 'Ϣû',
  `to_member_name` varchar(100) NULL COMMENT 'û',
  PRIMARY KEY (`message_id`),
  KEY `from_member_id` (`from_member_id`),
  KEY `to_member_id` (`to_member_id`),
  KEY `message_ismore` (`message_ismore`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ϣ';

CREATE TABLE `#__navigation` (
  `nav_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `nav_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0Զ嵼1Ʒ࣬2µ3ĬΪ0',
  `nav_title` varchar(100) DEFAULT NULL COMMENT '',
  `nav_url` varchar(255) DEFAULT NULL COMMENT '',
  `nav_location` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'λã0ͷ1в2ײĬΪ0',
  `nav_new_open` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ´ڴ򿪣0Ϊ1ΪǣĬΪ0',
  `nav_sort` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'IDӦnav_typeеݣĬΪ0',
  PRIMARY KEY (`nav_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ҳ浼';

CREATE TABLE `#__order` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `order_sn` varchar(100) NOT NULL COMMENT 'ţ̳ڲʹ',
  `seller_id` int(11) NOT NULL COMMENT 'id',
  `store_id` int(11) NOT NULL COMMENT 'ҵid',
  `store_name` varchar(50) NOT NULL COMMENT 'ҵ',
  `buyer_id` int(11) NOT NULL COMMENT 'id',
  `buyer_name` varchar(50) NOT NULL COMMENT '',
  `buyer_email` varchar(100) NOT NULL COMMENT 'ҵ',
  `add_time` varchar(10) NOT NULL COMMENT 'ʱ',
  `order_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT ' 0.ͨ 1.Ź',
  `payment_id` int(11) NOT NULL COMMENT '֧ʽid',
  `payment_name` varchar(50) NOT NULL COMMENT '֧ʽ',
  `payment_code` varchar(50) NOT NULL COMMENT '֧ʽƴ',
  `payment_direct` char(1) NULL DEFAULT '1' COMMENT '֧:1Ǽʱ,2ǵ',
  `out_sn` varchar(100) NOT NULL COMMENT 'ţⲿ֧ʱʹãЩⲿ֧ϵͳҪضĶ',
  `payment_time` varchar(10) DEFAULT NULL COMMENT '֧()ʱ',
  `pay_message` varchar(300) DEFAULT NULL COMMENT '֧',
  `shipping_time` varchar(10) DEFAULT NULL COMMENT 'ʱ',
  `shipping_code` varchar(50) DEFAULT NULL COMMENT '',
  `out_payment_code` varchar(255) DEFAULT NULL COMMENT 'ⲿƽ̨ʹõıʶַ',
  `finnshed_time` varchar(10) DEFAULT NULL COMMENT 'ʱ',
  `invoice` varchar(100) DEFAULT NULL COMMENT 'ƱϢ',
  `goods_amount` decimal(10,2) NOT NULL COMMENT 'Ʒܼ۸',
  `discount` decimal(10,2) DEFAULT NULL COMMENT 'ۿۼ۸',
  `order_amount` decimal(10,2) NOT NULL COMMENT 'ܼ۸',
  `shipping_fee` decimal(10,2) default NULL COMMENT '˷Ѽ۸',
  `evaluation_status` tinyint(1) DEFAULT NULL COMMENT '״̬ 0Ϊۣ1',
  `evaluation_time` varchar(10) DEFAULT NULL COMMENT 'ʱ',
  `evalseller_status` tinyint(1) NOT NULL default '0' COMMENT 'Ƿ',
  `evalseller_time` int(11) default NULL COMMENT 'ҵʱ',
  `order_message` varchar(300) DEFAULT NULL COMMENT '',
  `order_state` int(11) NOT NULL DEFAULT '10' COMMENT '״̬10(Ĭ):δ;20:Ѹ;30:ѷ;40:ջ;50:ύ;60ȷ;',
  `order_pointscount` int(11) NOT NULL DEFAULT '0' COMMENT 'ͻ',
  `voucher_id` int(11) NULL COMMENT 'ȯid',
  `voucher_price` int(11) NULL COMMENT 'ȯ',
  `voucher_code` varchar(32) NULL COMMENT 'ȯ',
  `refund_state` tinyint(1) unsigned NULL DEFAULT '0' COMMENT '˿״̬:0˿,1ǲ˿,2ȫ˿',
  `return_state` tinyint(1) unsigned NULL DEFAULT '0' COMMENT '˻״̬:0˻,1ǲ˻,2ȫ˻',
  `refund_amount` decimal(10,2) NULL DEFAULT '0.00' COMMENT '˿',
  `return_num` int(10) unsigned NULL DEFAULT '0' COMMENT '˻',
  `group_id` int(10) unsigned NULL DEFAULT '0' COMMENT 'Ź(ŹΪ0)',
  `group_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ź',
  `xianshi_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT ' ʱۿ۱',
  `xianshi_explain` varchar(100) NOT NULL DEFAULT '' COMMENT 'ʱۿ˵',
  `mansong_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͱ',
  `mansong_explain` varchar(200) NOT NULL DEFAULT '' COMMENT '˵',
  `order_from` enum('1','2') default '1' COMMENT '1PC2ֻ',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='';

CREATE TABLE `#__order_address` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `true_name` varchar(50) NOT NULL COMMENT 'ջ',
  `area_id` int(11) NOT NULL COMMENT 'id',
  `area_info` varchar(100) NOT NULL COMMENT '',
  `address` varchar(200) NOT NULL COMMENT 'ϸַ',
  `zip_code` varchar(20) NOT NULL COMMENT '',
  `tel_phone` varchar(20) NOT NULL COMMENT '绰',
  `mob_phone` varchar(20) NOT NULL COMMENT 'ֻ',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ϣ';

CREATE TABLE `#__order_goods` (
  `rec_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ʒid',
  `order_id` int(11) NOT NULL COMMENT 'id',
  `goods_id` int(11) NOT NULL COMMENT 'Ʒid',
  `goods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `spec_id` int(11) NOT NULL COMMENT 'id',
  `spec_info` varchar(50) DEFAULT NULL COMMENT '',
  `goods_price` decimal(10,2) NOT NULL COMMENT 'Ʒ۸',
  `goods_num` int(11) NOT NULL COMMENT 'Ʒ',
  `goods_image` varchar(100) DEFAULT NULL COMMENT 'ƷͼƬ',
  `goods_returnnum` int(10) unsigned NULL DEFAULT '0' COMMENT '˻',
  `shipping_fee` decimal(10,2) default '0.00' COMMENT 'ͷ',
  `shipping_name` char(3) default NULL COMMENT 'ͷʽ',
  PRIMARY KEY (`rec_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__order_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ʷid',
  `order_id` int(11) NOT NULL COMMENT 'id',
  `order_state` varchar(20) NOT NULL COMMENT '״̬Ϣ',
  `change_state` varchar(20) NOT NULL COMMENT 'һ״̬Ϣ',
  `state_info` varchar(20) NOT NULL COMMENT '״̬',
  `log_time` varchar(10) NOT NULL COMMENT 'ʱ',
  `operator` varchar(50) NOT NULL COMMENT '',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʷ';

CREATE TABLE `#__payment` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '֧id',
  `payment_code` varchar(50) NOT NULL COMMENT '֧',
  `payment_name` varchar(50) NOT NULL COMMENT '֧',
  `payment_info` varchar(255) DEFAULT NULL COMMENT '֧ӿڽ',
  `payment_config` text NOT NULL COMMENT '֧ӿϢ',
  `store_id` int(11) NOT NULL COMMENT 'Ӧĵid',
  `payment_online` tinyint(1) NOT NULL COMMENT 'ǷΪ߽ӿڣ1ǣ0',
  `payment_state` tinyint(1) NOT NULL COMMENT 'ӿ״̬1ã2',
  `payment_sort` int(11) NOT NULL COMMENT '֧',
  PRIMARY KEY (`payment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='֧ӿݱ';

CREATE TABLE `#__points_cart` (
  `pcart_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `pmember_id` int(11) NOT NULL COMMENT 'Ա',
  `pgoods_id` int(11) NOT NULL COMMENT 'Ʒ',
  `pgoods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `pgoods_points` int(11) NOT NULL COMMENT 'Ʒһ',
  `pgoods_choosenum` int(11) NOT NULL COMMENT 'ѡƷ',
  `pgoods_image` varchar(100) default NULL COMMENT 'ƷͼƬ',
  PRIMARY KEY  (`pcart_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒһﳵ';

CREATE TABLE `#__points_goods` (
  `pgoods_id` int(11) NOT NULL auto_increment COMMENT 'Ʒid',
  `pgoods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `pgoods_price` decimal(10,2) NOT NULL default '0.00' COMMENT 'Ʒԭ',
  `pgoods_points` int(11) NOT NULL COMMENT 'Ʒһ',
  `pgoods_image` varchar(100) NOT NULL COMMENT 'ƷĬϷͼƬ',
  `pgoods_tag` varchar(100) NOT NULL COMMENT 'Ʒǩ',
  `pgoods_serial` varchar(50) NOT NULL COMMENT 'Ʒ',
  `pgoods_storage` int(11) NOT NULL default '0' COMMENT 'Ʒ',
  `pgoods_show` tinyint(1) NOT NULL COMMENT 'Ʒϼ 0ʾ¼ 1ʾϼ',
  `pgoods_commend` tinyint(1) NOT NULL COMMENT 'ƷƼ',
  `pgoods_add_time` int(11) NOT NULL COMMENT 'Ʒʱ',
  `pgoods_keywords` varchar(100) default NULL COMMENT 'Ʒؼ',
  `pgoods_description` varchar(200) default NULL COMMENT 'Ʒ',
  `pgoods_body` text NOT NULL COMMENT 'Ʒϸ',
  `pgoods_state` tinyint(1) NOT NULL default '0' COMMENT 'Ʒ״̬01',
  `pgoods_close_reason` varchar(255) default NULL COMMENT 'Ʒԭ',
  `pgoods_salenum` int(11) NOT NULL default '0' COMMENT 'Ʒ۳',
  `pgoods_view` int(11) NOT NULL default '0' COMMENT 'Ʒ',
  `pgoods_islimit` tinyint(1) NOT NULL COMMENT 'ǷÿԱһ',
  `pgoods_limitnum` int(11) default NULL COMMENT 'ÿԱƶһ',
  `pgoods_freightcharge` tinyint(1) NOT NULL default '0' COMMENT '˷ѳеʽ 0ʾҳе 1ʾҳе',
  `pgoods_freightprice` decimal(10,2) default NULL COMMENT '˷Ѽ۸',
  `pgoods_islimittime` tinyint(1) NOT NULL default '0' COMMENT 'Ƿƶһʱ 0Ϊ 1Ϊ',
  `pgoods_starttime` int(11) default NULL COMMENT 'һʼʱ',
  `pgoods_endtime` int(11) default NULL COMMENT 'һʱ',
  `pgoods_sort` int(11) NOT NULL default '0' COMMENT 'Ʒ',
  PRIMARY KEY  (`pgoods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__points_log` (
	`pl_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '־',
	`pl_memberid` int(11) NOT NULL COMMENT 'Ա',
	`pl_membername` varchar(100) NOT NULL COMMENT 'Ա',
	`pl_adminid` int(11) NULL COMMENT 'Ա',
	`pl_adminname` varchar(100) NULL COMMENT 'Ա',
	`pl_points` int(11) NOT NULL DEFAULT '0' COMMENT 'ʾ۳',
	`pl_addtime` int(11) NOT NULL COMMENT 'ʱ',
	`pl_desc` varchar(100) NOT NULL COMMENT '',
	`pl_stage` varchar(50) NOT NULL COMMENT '׶',
	PRIMARY KEY (`pl_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ա־';

CREATE TABLE `#__points_order` (
  `point_orderid` int(11) NOT NULL auto_increment COMMENT 'һ',
  `point_ordersn` varchar(100) NOT NULL COMMENT 'һ',
  `point_buyerid` int(11) NOT NULL COMMENT 'һԱid',
  `point_buyername` varchar(50) NOT NULL COMMENT 'һԱ',
  `point_buyeremail` varchar(100) NOT NULL COMMENT 'һԱemail',
  `point_addtime` int(11) NOT NULL COMMENT 'һʱ',
  `point_paymentid` int(11) NOT NULL COMMENT '֧ʽid',
  `point_paymentname` varchar(50) NOT NULL COMMENT '֧ʽ',
  `point_paymentcode` varchar(50) NOT NULL COMMENT '֧ʽƴ',
  `point_paymentdirect` tinyint(1) default '1' COMMENT '֧:1Ǽʱ,2ǵ',
  `point_outsn` varchar(100) NOT NULL COMMENT 'ţⲿ֧ʱʹãЩⲿ֧ϵͳҪضĶ',
  `point_paymenttime` int(11) default NULL COMMENT '֧()ʱ',
  `point_paymessage` varchar(300) default NULL COMMENT '֧',
  `point_shippingtime` int(11) default NULL COMMENT 'ʱ',
  `point_shippingcode` varchar(50) default NULL COMMENT '',
  `point_shippingdesc` varchar(500) default NULL COMMENT '',
  `point_outpaymentcode` varchar(255) default NULL COMMENT 'ⲿƽ̨ʹõıʶַ',
  `point_finnshedtime` int(11) default NULL COMMENT 'ʱ',
  `point_allpoint` int(11) NOT NULL default '0' COMMENT 'һܻ',
  `point_orderamount` decimal(10,2) NOT NULL COMMENT 'һܽ',
  `point_shippingcharge` tinyint(1) NOT NULL default '0' COMMENT '˷ѳеʽ 0ʾ 1ʾ',
  `point_shippingfee` decimal(10,2) NOT NULL default '0.00' COMMENT '˷ѽ',
  `point_ordermessage` varchar(300) default NULL COMMENT '',
  `point_orderstate` int(11) NOT NULL default '10' COMMENT '״̬10(Ĭ):δ;11Ѹ;20:ȷϸ;30:ѷ;40:ջ;50;2ȡ',
  PRIMARY KEY  (`point_orderid`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='һ';

CREATE TABLE `#__points_orderaddress` (
  `point_oaid` int(11) NOT NULL auto_increment COMMENT 'id',
  `point_orderid` int(11) NOT NULL COMMENT 'id',
  `point_truename` varchar(50) NOT NULL COMMENT 'ջ',
  `point_areaid` int(11) NOT NULL COMMENT 'id',
  `point_areainfo` varchar(100) NOT NULL COMMENT '',
  `point_address` varchar(200) NOT NULL COMMENT 'ϸַ',
  `point_zipcode` varchar(20) NOT NULL COMMENT '',
  `point_telphone` varchar(20) NOT NULL COMMENT '绰',
  `point_mobphone` varchar(20) NOT NULL COMMENT 'ֻ',
  PRIMARY KEY  (`point_oaid`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='һַ';

CREATE TABLE `#__points_ordergoods` (
  `point_recid` int(11) NOT NULL auto_increment COMMENT 'Ʒ',
  `point_orderid` int(11) NOT NULL COMMENT 'id',
  `point_goodsid` int(11) NOT NULL COMMENT 'Ʒid',
  `point_goodsname` varchar(100) NOT NULL COMMENT 'Ʒ',
  `point_goodspoints` int(11) NOT NULL COMMENT 'Ʒһ',
  `point_goodsnum` int(11) NOT NULL COMMENT 'Ʒ',
  `point_goodsimage` varchar(100) default NULL COMMENT 'ƷͼƬ',
  PRIMARY KEY  (`point_recid`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='һƷ';

CREATE TABLE `#__predeposit_cash` (
  `pdcash_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '',
  `pdcash_sn` varchar(100) NOT NULL COMMENT '¼Ψһʾ',
  `pdcash_memberid` int(11) NOT NULL COMMENT 'Ա',
  `pdcash_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `pdcash_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '',
  `pdcash_payment` varchar(50) NOT NULL COMMENT '֧ʽ',
  `pdcash_paymentaccount` varchar(100) DEFAULT NULL COMMENT '֧˺',
  `pdcash_toname` varchar(100) DEFAULT NULL COMMENT 'տ',
  `pdcash_tobank` varchar(100) DEFAULT NULL COMMENT 'տ',
  `pdcash_memberremark` varchar(1000) DEFAULT NULL COMMENT 'Աֱע',
  `pdcash_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `pdcash_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT '״̬ 0Ϊ 1Ϊ 2Ϊر',
  `pdcash_paystate` tinyint(1) NOT NULL DEFAULT '0' COMMENT '֧״̬ 0Ϊδ֧ 1Ϊ֧',
  `pdcash_adminid` int(11) DEFAULT NULL COMMENT 'Ա',
  `pdcash_adminname` varchar(100) DEFAULT NULL COMMENT 'Ա',
  `pdcash_adminremark` varchar(1000) DEFAULT NULL COMMENT 'Աע',
  `pdcash_remark` varchar(1000) DEFAULT NULL COMMENT 'ԱͻԱɲ鿴ıע',
  PRIMARY KEY (`pdcash_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ԥּ¼';

CREATE TABLE `#__predeposit_log` (
  `pdlog_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '',
  `pdlog_memberid` int(11) NOT NULL COMMENT 'Ա',
  `pdlog_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `pdlog_adminid` int(11) DEFAULT NULL COMMENT 'Ա',
  `pdlog_adminname` varchar(50) DEFAULT NULL COMMENT 'Ա',
  `pdlog_stage` enum('system','recharge','cash','order','admin') NOT NULL COMMENT '־ ö system ϵͳԶ recharge ֵ cash  order  admin Աֶ޸',
  `pdlog_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '־ 0ʾý 1ʾ',
  `pdlog_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '',
  `pdlog_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `pdlog_desc` varchar(1000) DEFAULT NULL COMMENT '',
  PRIMARY KEY (`pdlog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ԥ־';

CREATE TABLE `#__predeposit_recharge` (
  `pdr_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '',
  `pdr_sn` varchar(100) NOT NULL COMMENT '¼Ψһʾ',
  `pdr_memberid` int(11) NOT NULL COMMENT 'Ա',
  `pdr_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `pdr_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'ֵ',
  `pdr_payment` varchar(50) DEFAULT NULL COMMENT '֧ʽ',
  `pdr_onlinecode` varchar(100) DEFAULT NULL COMMENT '֧Ľˮ',
  `pdr_remittancename` varchar(100) DEFAULT NULL COMMENT '',
  `pdr_remittancebank` varchar(100) DEFAULT NULL COMMENT '',
  `pdr_remittancedate` int(11) DEFAULT NULL COMMENT '',
  `pdr_memberremark` varchar(1000) DEFAULT NULL COMMENT 'Աע',
  `pdr_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `pdr_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ֵ״̬ 0 ʾ 1ʾ 2ʾر',
  `pdr_paystate` tinyint(1) NOT NULL DEFAULT '0' COMMENT '֧״̬ 0ʾδ֧ 1ʾ֧',
  `pdr_adminid` int(11) DEFAULT NULL COMMENT 'Ա',
  `pdr_adminname` varchar(100) DEFAULT NULL COMMENT 'Ա',
  `pdr_adminremark` varchar(1000) DEFAULT NULL COMMENT 'Աע',
  PRIMARY KEY (`pdr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ԤֵϢ';

CREATE TABLE `#__promotion_mansong` (
  `mansong_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ͻ',
  `mansong_name` varchar(50) NOT NULL COMMENT '',
  `quota_id` int(10) unsigned NOT NULL COMMENT 'ײͱ',
  `start_time` int(10) unsigned NOT NULL COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `member_id` int(10) unsigned NOT NULL COMMENT 'û',
  `store_id` int(10) unsigned NOT NULL COMMENT '̱',
  `member_name` varchar(50) NOT NULL COMMENT 'û',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-δ/2-/3-ȡ/4-ʧЧ/5-)',
  `remark` varchar(200) NOT NULL COMMENT 'ע',
  PRIMARY KEY  (`mansong_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ͻ';

CREATE TABLE `#__promotion_mansong_apply` (
  `apply_id` int(10) unsigned NOT NULL auto_increment COMMENT '',
  `member_id` int(10) unsigned NOT NULL COMMENT 'û',
  `member_name` varchar(50) NOT NULL COMMENT 'û',
  `store_id` int(10) unsigned NOT NULL COMMENT '̱',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `apply_quantity` tinyint(1) unsigned NOT NULL COMMENT '',
  `apply_date` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-/2-ͨ/3-ȡ/4-ʧ)',
  PRIMARY KEY  (`apply_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ײ';

CREATE TABLE `#__promotion_mansong_quota` (
  `quota_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ײͱ',
  `apply_id` int(10) unsigned NOT NULL COMMENT '',
  `member_id` int(10) unsigned NOT NULL COMMENT 'û',
  `store_id` int(10) unsigned NOT NULL COMMENT '̱',
  `member_name` varchar(50) NOT NULL COMMENT 'û',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `start_time` int(10) unsigned NOT NULL COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-/2-ȡ/3-)',
  PRIMARY KEY  (`quota_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ײͱ';

CREATE TABLE `#__promotion_mansong_rule` (
  `rule_id` int(10) unsigned NOT NULL auto_increment COMMENT '',
  `mansong_id` int(10) unsigned NOT NULL COMMENT '',
  `level` tinyint(1) unsigned NOT NULL COMMENT '򼶱(1/2/3)',
  `price` int(10) unsigned NOT NULL COMMENT '۸',
  `shipping_free` tinyint(1) unsigned NOT NULL COMMENT 'ʱ־(0-/1-ʷ)',
  `discount` int(10) unsigned NOT NULL COMMENT 'ֽŻݽ',
  `gift_name` varchar(50) NOT NULL COMMENT 'Ʒ',
  `gift_link` varchar(100) NOT NULL COMMENT 'Ʒ',
  PRIMARY KEY (`rule_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ͻ';

CREATE TABLE `#__promotion_xianshi` (
  `xianshi_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ʱ',
  `goods_limit` int(10) unsigned NOT NULL COMMENT 'Ʒ',
  `xianshi_name` varchar(50) NOT NULL COMMENT '',
  `quota_id` int(10) unsigned NOT NULL COMMENT 'ײͱ',
  `start_time` int(10) unsigned NOT NULL COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `member_id` int(10) unsigned NOT NULL COMMENT 'û',
  `store_id` int(10) unsigned NOT NULL COMMENT '̱',
  `member_name` varchar(50) NOT NULL COMMENT 'û',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `discount` decimal(10,2) NOT NULL COMMENT 'ۿ',
  `buy_limit` int(10) unsigned NOT NULL COMMENT '',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-δ/2-/3-ȡ/4-ʧЧ/5-)',
  PRIMARY KEY  (`xianshi_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʱۿۻ';

CREATE TABLE `#__promotion_xianshi_apply` (
  `apply_id` int(10) unsigned NOT NULL auto_increment COMMENT '',
  `member_id` int(10) unsigned NOT NULL COMMENT 'û',
  `member_name` varchar(50) NOT NULL COMMENT 'û',
  `store_id` int(10) unsigned NOT NULL COMMENT '̱',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `apply_quantity` tinyint(1) unsigned NOT NULL COMMENT '',
  `apply_date` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-/2-ͨ/3-ȡ/4-ʧ)',
  PRIMARY KEY  (`apply_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʱۿײ';

CREATE TABLE `#__promotion_xianshi_goods` (
  `xianshi_goods_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ʱۿƷ',
  `xianshi_id` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `xianshi_name` varchar(50) NOT NULL COMMENT '',
  `quota_id` int(10) unsigned NOT NULL COMMENT 'ײͱ',
  `goods_id` int(10) unsigned NOT NULL COMMENT 'Ʒ',
  `goods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `goods_store_price` decimal(10,2) NOT NULL COMMENT '̼۸',
  `discount` decimal(10,2) NOT NULL COMMENT 'ۿ',
  `buy_limit` int(10) unsigned NOT NULL COMMENT '޶',
  `xianshi_price` decimal(10,2) NOT NULL COMMENT 'ʱۿۼ۸',
  `goods_image` varchar(100) NOT NULL COMMENT 'ƷͼƬ',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-/2-ȡ)',
  PRIMARY KEY  (`xianshi_goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʱۿƷ';

CREATE TABLE `#__promotion_xianshi_quota` (
  `quota_id` int(10) unsigned NOT NULL auto_increment COMMENT 'ʱۿײͱ',
  `apply_id` int(10) unsigned NOT NULL COMMENT '',
  `member_id` int(10) unsigned NOT NULL COMMENT 'û',
  `store_id` int(10) unsigned NOT NULL COMMENT '̱',
  `member_name` varchar(50) NOT NULL COMMENT 'û',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `start_time` int(10) unsigned NOT NULL COMMENT 'ײͿʼʱ',
  `end_time` int(10) unsigned NOT NULL COMMENT 'ײͽʱ',
  `times_limit` int(10) unsigned NOT NULL COMMENT 'ײʱ',
  `published_times` int(10) unsigned NOT NULL COMMENT 'ѷ',
  `goods_limit` int(10) unsigned NOT NULL COMMENT 'Ʒ',
  `state` tinyint(1) unsigned NOT NULL COMMENT '״̬(1-/2-ȡ/3-)',
  PRIMARY KEY  (`quota_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ʱۿײͱ';

CREATE TABLE `#__recommend` (
  `recommend_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `recommend_name` varchar(50) DEFAULT NULL COMMENT '',
  `recommend_code` varchar(255) NOT NULL COMMENT 'Ƽʶ',
  `recommend_desc` varchar(255) NOT NULL COMMENT 'Ƽ',
  `recommend_config` varchar(255) NULL COMMENT 'Ϣ',
  PRIMARY KEY (`recommend_id`),
  UNIQUE KEY `recommend_code` (`recommend_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ƽͱ';

CREATE TABLE `#__recommend_goods` (
  `recommend_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'ƼID',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'ƷID',
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '255' COMMENT '',
  PRIMARY KEY (`recommend_id`,`goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƼƷ';

CREATE TABLE `#__refund_log` (
  `log_id` int(10) unsigned NOT NULL auto_increment COMMENT '˿¼ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `refund_sn` varchar(100) NOT NULL COMMENT '˿',
  `order_sn` varchar(100) NOT NULL COMMENT '',
  `seller_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `store_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `store_name` varchar(20) NOT NULL COMMENT '',
  `buyer_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `buyer_name` varchar(50) NOT NULL COMMENT 'һԱ',
  `add_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `order_amount` decimal(10,2) NOT NULL COMMENT '',
  `order_refund` decimal(10,2) NOT NULL COMMENT '˿',
  `refund_paymentname` varchar(50) NOT NULL COMMENT '֧ʽ',
  `refund_paymentcode` varchar(50) NOT NULL COMMENT '֧ʽ',
  `refund_message` varchar(300) default NULL COMMENT '˿ע',
  PRIMARY KEY  (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='˿';

CREATE TABLE `#__return` (
  `return_id` int(10) unsigned NOT NULL auto_increment COMMENT '˻¼ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `return_sn` varchar(100) NOT NULL COMMENT '˻',
  `order_sn` varchar(100) NOT NULL COMMENT '',
  `seller_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `store_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `store_name` varchar(20) NOT NULL COMMENT '',
  `buyer_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `buyer_name` varchar(50) NOT NULL COMMENT 'һԱ',
  `return_goodsnum` int(10) unsigned NOT NULL COMMENT '˻',
  `add_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
  `return_message` varchar(300) default NULL COMMENT '˻ע',
  PRIMARY KEY  (`return_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='˻';

CREATE TABLE `#__return_goods` (
  `log_id` int(10) unsigned NOT NULL auto_increment COMMENT '˻Ʒ¼ID',
  `return_id` int(10) unsigned NOT NULL COMMENT '˻¼ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `goods_id` int(10) unsigned NOT NULL COMMENT 'ƷID',
  `goods_name` varchar(100) NOT NULL COMMENT 'Ʒ',
  `spec_id` int(10) unsigned NOT NULL COMMENT 'ID',
  `spec_info` varchar(50) default NULL COMMENT '',
  `goods_price` decimal(10,2) NOT NULL COMMENT 'Ʒ۸',
  `goods_num` int(10) unsigned NOT NULL COMMENT 'Ʒ',
  `goods_returnnum` int(10) unsigned NOT NULL COMMENT '˻',
  `goods_image` varchar(100) default NULL COMMENT 'ƷͼƬ',
  PRIMARY KEY  (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='˻Ʒ';

CREATE TABLE `#__setting` (
  `name` varchar(50) NOT NULL COMMENT '',
  `value` text COMMENT 'ֵ',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ϵͳñ';

CREATE TABLE `#__sns_comment` (
  `comment_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `comment_memberid` int(11) NOT NULL COMMENT 'ԱID',
  `comment_membername` varchar(100) NOT NULL COMMENT 'Ա',
  `comment_memberavatar` varchar(100) default NULL COMMENT 'Աͷ',
  `comment_originalid` int(11) NOT NULL COMMENT 'ԭID',
  `comment_originaltype` tinyint(1) NOT NULL default '0' COMMENT 'ԭ 0ʾ̬Ϣ 1ʾƷ ĬΪ0',
  `comment_content` varchar(500) NOT NULL COMMENT '',
  `comment_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `comment_ip` varchar(50) NOT NULL COMMENT 'ԴIP',
  `comment_state` tinyint(1) NOT NULL default '0' COMMENT '״̬ 0 1',
  PRIMARY KEY  (`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='۱';

CREATE TABLE `#__sns_friend` (
  `friend_id` int(11) NOT NULL auto_increment COMMENT 'idֵ',
  `friend_frommid` int(11) NOT NULL COMMENT 'Աid',
  `friend_frommname` varchar(100) default NULL COMMENT 'Ա',
  `friend_frommavatar` varchar(100) default NULL COMMENT 'Աͷ',
  `friend_tomid` int(11) NOT NULL COMMENT 'id',
  `friend_tomname` varchar(100) NOT NULL COMMENT 'ѻԱ',
  `friend_tomavatar` varchar(100) default NULL COMMENT 'ͷ',
  `friend_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `friend_followstate` tinyint(1) NOT NULL default '1' COMMENT 'ע״̬ 1Ϊע 2Ϊ˫ע',
  PRIMARY KEY  (`friend_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ݱ';

CREATE TABLE `#__sns_goods` (
  `snsgoods_goodsid` int(11) NOT NULL COMMENT 'ƷID',
  `snsgoods_goodsname` varchar(100) NOT NULL COMMENT 'Ʒ',
  `snsgoods_goodsimage` varchar(100) default NULL COMMENT 'ƷͼƬ',
  `snsgoods_goodsprice` decimal(10,2) NOT NULL default '0.00' COMMENT 'Ʒ۸',
  `snsgoods_storeid` int(11) NOT NULL COMMENT 'ID',
  `snsgoods_storename` varchar(100) NOT NULL COMMENT '',
  `snsgoods_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `snsgoods_likenum` int(11) NOT NULL default '0' COMMENT 'ϲ',
  `snsgoods_likemember` text COMMENT 'ϲĻԱIDöŷָ',
  `snsgoods_sharenum` int(11) NOT NULL default '0' COMMENT '',
  UNIQUE KEY `snsgoods_goodsid` (`snsgoods_goodsid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COMMENT='SNSƷ';

CREATE TABLE `#__sns_sharegoods` (
  `share_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `share_goodsid` int(11) NOT NULL COMMENT 'ƷID',
  `share_memberid` int(11) NOT NULL COMMENT 'ԱID',
  `share_membername` varchar(100) NOT NULL COMMENT 'Ա',
  `share_content` varchar(500) default NULL COMMENT '',
  `share_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `share_likeaddtime` int(11) NOT NULL default '0' COMMENT 'ϲʱ',
  `share_privacy` tinyint(1) NOT NULL default '0' COMMENT '˽ɼ 0˿ɼ 1ѿɼ 2Լɼ',
  `share_commentcount` int(11) NOT NULL default '0' COMMENT '',
  `share_isshare` tinyint(1) NOT NULL default '0' COMMENT 'Ƿ 0Ϊδ 1Ϊ',
  `share_islike` tinyint(1) NOT NULL default '0' COMMENT 'Ƿϲ 0Ϊδϲ 1Ϊϲ',
  PRIMARY KEY  (`share_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__sns_sharestore` (
  `share_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `share_storeid` int(11) NOT NULL COMMENT '̱',
  `share_storename` varchar(100) NOT NULL COMMENT '',
  `share_memberid` int(11) NOT NULL COMMENT 'ԱID',
  `share_membername` varchar(100) NOT NULL COMMENT 'Ա',
  `share_content` varchar(500) default NULL COMMENT '',
  `share_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `share_privacy` tinyint(1) NOT NULL default '0' COMMENT '˽ɼ 0˿ɼ 1ѿɼ 2Լɼ',
  PRIMARY KEY  (`share_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='̱';

CREATE TABLE `#__sns_tracelog` (
  `trace_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `trace_originalid` int(11) NOT NULL default '0' COMMENT 'ԭ̬ID ĬΪ0',
  `trace_originalmemberid` int(11) NOT NULL default '0' COMMENT 'ԭԱ',
  `trace_originalstate` tinyint(1) NOT NULL default '0' COMMENT 'ԭɾ״̬ 0Ϊ 1Ϊɾ',
  `trace_memberid` int(11) NOT NULL COMMENT 'ԱID',
  `trace_membername` varchar(100) NOT NULL COMMENT 'Ա',
  `trace_memberavatar` varchar(100) default NULL COMMENT 'Աͷ',
  `trace_title` varchar(500) default NULL COMMENT '̬',
  `trace_content` text NOT NULL COMMENT '̬',
  `trace_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `trace_state` tinyint(1) NOT NULL default '0' COMMENT '״̬  0 1Ϊֹʾ ĬΪ0',
  `trace_privacy` tinyint(1) NOT NULL default '0' COMMENT '˽ɼ 0˿ɼ 1ѿɼ 2Լɼ',
  `trace_commentcount` int(11) NOT NULL default '0' COMMENT '',
  `trace_copycount` int(11) NOT NULL default '0' COMMENT 'ת',
  `trace_orgcommentcount` int(11) NOT NULL default '0' COMMENT 'ԭ۴',
  `trace_orgcopycount` int(11) NOT NULL default '0' COMMENT 'ԭת',
  PRIMARY KEY  (`trace_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='̬Ϣ';

CREATE TABLE `#__sns_visitor` (
  `v_id` int(11) NOT NULL auto_increment COMMENT 'ID',
  `v_mid` int(11) NOT NULL COMMENT 'ÿͻԱID',
  `v_mname` varchar(100) NOT NULL COMMENT 'ÿͻԱ',
  `v_mavatar` varchar(100) default NULL COMMENT 'ÿͻԱͷ',
  `v_ownermid` int(11) NOT NULL COMMENT '˻ԱID',
  `v_ownermname` varchar(100) NOT NULL COMMENT '˻Ա',
  `v_ownermavatar` varchar(100) default NULL COMMENT '˻Աͷ',
  `v_addtime` int(11) NOT NULL COMMENT 'ʱ',
  PRIMARY KEY  (`v_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='snsÿͱ';

CREATE TABLE `#__spec` (
	`sp_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
	`sp_name` varchar(100) NOT NULL COMMENT '',
	`sp_format` enum('text', 'image') NOT NULL COMMENT 'ʾ',
	`sp_value` text NOT NULL COMMENT 'ֵ',
	`sp_sort` tinyint(1) unsigned NOT NULL COMMENT '',
  PRIMARY KEY  (`sp_id`)
) ENGINE = MYISAM CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__spec_value` (
	`sp_value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ֵid',
	`sp_value_name` varchar(100) NOT NULL COMMENT 'ֵ',
	`sp_id` int(10) unsigned NOT NULL COMMENT 'id',
	`sp_value_image` varchar(100) NULL COMMENT 'ͼƬ',
	`sp_value_sort` tinyint(1) unsigned NOT NULL COMMENT '',
  PRIMARY KEY  (`sp_value_id`)
) ENGINE = MYISAM CHARSET=gbk COMMENT='Ʒֵ';

CREATE TABLE `#__store` (
  `store_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `store_name` varchar(50) NOT NULL COMMENT '',
  `store_auth` tinyint(1) DEFAULT '0' COMMENT '֤',
  `name_auth` tinyint(1) DEFAULT '0' COMMENT '֤',
  `grade_id` int(11) NOT NULL COMMENT '̵ȼ',
  `member_id` int(11) NOT NULL COMMENT 'Աid',
  `member_name` varchar(50) NOT NULL COMMENT 'Ա',
  `store_owner_card` varchar(50) NOT NULL COMMENT '֤',
  `sc_id` int(11) NOT NULL COMMENT '̷',
  `area_id` int(11) NOT NULL COMMENT 'id',
  `area_info` varchar(100) NOT NULL COMMENT 'ݣ',
  `store_address` varchar(100) NOT NULL COMMENT 'ϸ',
  `store_zip` varchar(10) NOT NULL COMMENT '',
  `store_tel` varchar(50) NOT NULL COMMENT '绰',
  `store_image` varchar(100) DEFAULT NULL COMMENT '֤ϴ',
  `store_image1` varchar(100) DEFAULT NULL COMMENT 'ִϴ',
  `store_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT '״̬',
  `store_close_info` varchar(255) DEFAULT NULL COMMENT '̹رԭ',
  `store_sort` int(11) NOT NULL DEFAULT '0' COMMENT '',
  `store_time` varchar(10) NOT NULL COMMENT 'ʱ',
  `store_end_time` varchar(10) DEFAULT NULL COMMENT '̹رʱ',
  `store_label` varchar(255) default NULL COMMENT 'logo',
  `store_banner` varchar(255) DEFAULT NULL COMMENT '̺',
  `store_logo` varchar(255) DEFAULT NULL COMMENT '',
  `store_keywords` varchar(255)  NOT NULL DEFAULT '' COMMENT 'seoؼ',
  `store_description` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo',
  `store_qq` varchar(50) DEFAULT NULL COMMENT 'QQ',
  `store_ww` varchar(50) DEFAULT NULL COMMENT '',
  `store_msn` varchar(50) DEFAULT NULL COMMENT 'MSN',
  `description` text COMMENT '̼',
  `store_domain` varchar(50) DEFAULT NULL COMMENT '̶',
  `store_domain_times` tinyint(1) unsigned NULL DEFAULT '0' COMMENT '޸Ĵ',
  `store_recommend` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƽ0Ϊ1ΪǣĬΪ0',
  `store_audit` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ˣ0Ϊδͨ1ΪͨĬΪ0',
  `store_theme` varchar(50) NOT NULL DEFAULT 'default' COMMENT '̵ǰ',
  `store_credit` int(10) NOT NULL DEFAULT '0' COMMENT '',
  `praise_rate` float NOT NULL DEFAULT '0' COMMENT '̺',
  `store_desccredit` float NOT NULL default '0' COMMENT 'ȷ',
  `store_servicecredit` float NOT NULL default '0' COMMENT '̬ȷ',
  `store_deliverycredit` float NOT NULL default '0' COMMENT 'ٶȷ',
  `store_code` varchar(255) NOT NULL DEFAULT 'default_qrcode.png' COMMENT '̶ά',
  `store_collect` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ղ',
  `store_slide` text DEFAULT NULL COMMENT '̻õƬ',
  `store_slide_url` text COMMENT '̻õƬ',
  `store_center_quicklink` text COMMENT 'ĵĳò',
  PRIMARY KEY (`store_id`),
  KEY `store_name` (`store_name`),
  KEY `sc_id` (`sc_id`),
  KEY `area_id` (`area_id`),
  KEY `store_state` (`store_state`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ݱ';

CREATE TABLE `#__store_class` (
  `sc_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `sc_name` varchar(100) NOT NULL COMMENT '',
  `sc_parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `sc_sort` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '',
  PRIMARY KEY (`sc_id`),
  KEY `sc_parent_id` (`sc_parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='̷';

CREATE TABLE `#__store_class_goods` (
  `stc_id` int(11) NOT NULL COMMENT 'Ʒid',
  `goods_id` int(11) NOT NULL COMMENT 'Ʒid'
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ̷洢';

CREATE TABLE `#__store_goods_class` (
  `stc_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `stc_name` varchar(50) NOT NULL COMMENT 'Ʒ',
  `stc_parent_id` int(11) NOT NULL COMMENT 'id',
  `stc_state` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ʒ״̬',
  `store_id` int(11) NOT NULL DEFAULT '0' COMMENT 'id',
  `stc_sort` int(11) NOT NULL DEFAULT '0' COMMENT 'Ʒ',
  PRIMARY KEY (`stc_id`),
  KEY `stc_parent_id` (`stc_parent_id`,`stc_sort`),
  KEY `store_id` (`store_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒ';

CREATE TABLE `#__store_grade` (
  `sg_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `sg_name` varchar(100) DEFAULT NULL COMMENT 'ȼ',
  `sg_goods_limit` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ʒ',
  `sg_space_limit` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϴռСλMB',
  `sg_template_number` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ѡģ',
  `sg_template` varchar(255) DEFAULT NULL COMMENT 'ģ',
  `sg_price` varchar(100) DEFAULT NULL COMMENT '',
  `sg_confirm` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ˣ0Ϊ1ΪǣĬΪ1',
  `sg_description` text COMMENT '˵',
  `sg_function` varchar(255) DEFAULT NULL COMMENT 'ӹ',
  `sg_sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ĿԽ󼶱Խ',
  PRIMARY KEY (`sg_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='̵ȼ';

CREATE TABLE `#__store_gradelog` (
  `gl_id` int(11) NOT NULL auto_increment COMMENT 'ȼ־',
  `gl_shopid` int(11) NOT NULL COMMENT '̱',
  `gl_shopname` varchar(50) NOT NULL COMMENT '',
  `gl_memberid` int(11) NOT NULL COMMENT 'Ա',
  `gl_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `gl_sgid` int(11) NOT NULL COMMENT 'ȼ',
  `gl_sgname` varchar(100) NOT NULL COMMENT 'ȼ',
  `gl_sgconfirm` tinyint(4) NOT NULL default '1' COMMENT 'ǷҪ 0Ҫ 1Ҫ',
  `gl_sgsort` tinyint(3) NOT NULL COMMENT '',
  `gl_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `gl_allowstate` tinyint(1) NOT NULL COMMENT '״̬ 0Ϊ 1ͨ 2 δͨ',
  `gl_allowadminid` int(11) NOT NULL default '0' COMMENT 'Ա ĬΪ0 ',
  `gl_allowadminname` varchar(100) NOT NULL default 'system' COMMENT 'Ա ĬΪsystem ʾϵͳԶ',
  `gl_allowremark` varchar(500) NOT NULL COMMENT '˱ע',
  PRIMARY KEY  (`gl_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='¼';

CREATE TABLE `#__store_navigation` (
  `sn_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `sn_title` varchar(50) NOT NULL COMMENT '',
  `sn_store_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ҵID',
  `sn_content` text COMMENT '',
  `sn_sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `sn_if_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿʾ',
  `sn_add_time` int(10) NOT NULL COMMENT '',
  `sn_url` varchar(255) default NULL COMMENT '̵URL',
  `sn_new_open` tinyint(1) unsigned NOT NULL default '0' COMMENT '̵Ƿ´ڴ򿪣0´1´ڣĬ0',
  PRIMARY KEY (`sn_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ҵ̵Ϣ';

CREATE TABLE `#__store_partner` (
  `sp_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '̺ID',
  `sp_store_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `sp_title` varchar(100) NOT NULL COMMENT '̺',
  `sp_link` varchar(255) NOT NULL COMMENT '̺',
  `sp_logo` varchar(255) DEFAULT NULL COMMENT '̺LOGO',
  `sp_sort` tinyint(1) unsigned NOT NULL DEFAULT '255' COMMENT '̺',
  PRIMARY KEY (`sp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ҵ̺';

CREATE TABLE `#__store_watermark` (
  `wm_id` int(11) NOT NULL auto_increment COMMENT 'ˮӡid',
  `jpeg_quality` int(3) NOT NULL default '90' COMMENT 'jpegͼƬ',
  `wm_image_name` varchar(255) default NULL COMMENT 'ˮӡͼƬ·Լļ',
  `wm_image_pos` tinyint(1) NOT NULL default '1' COMMENT 'ˮӡͼƬõλ',
  `wm_image_transition` int(3) NOT NULL default '20' COMMENT 'ˮӡͼƬԭͼƬں϶ ',
  `wm_text` text COMMENT 'ˮӡ',
  `wm_text_size` int(3) NOT NULL default '20' COMMENT 'ˮӡִС',
  `wm_text_angle` tinyint(1) NOT NULL default '4' COMMENT 'ˮӡֽǶ',
  `wm_text_pos` tinyint(1) NOT NULL default '3' COMMENT 'ˮӡַλ',
  `wm_text_font` varchar(50) default NULL COMMENT 'ˮӡֵ',
  `wm_text_color` varchar(7) NOT NULL default '#CCCCCC' COMMENT 'ˮӡɫֵ',
  `wm_is_open` tinyint(1) NOT NULL default '0' COMMENT 'ˮӡǷ 0ر 1',
  `store_id` int(11) default NULL COMMENT 'id',
  PRIMARY KEY  (`wm_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ˮӡͼƬ';

CREATE TABLE `#__transport` (
  `id` mediumint(8) unsigned NOT NULL auto_increment COMMENT '˷ģID',
  `title` varchar(120) default NULL COMMENT '˷ģ',
  `send_tpl_id` mediumint(8) unsigned default NULL COMMENT 'ģID',
  `member_id` mediumint(8) unsigned default NULL COMMENT 'ԱID',
  `update_time` int(10) unsigned default '0' COMMENT 'ʱ',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='˷ģ';

CREATE TABLE `#__transport_extend` (
  `id` mediumint(8) unsigned NOT NULL auto_increment COMMENT '˷ģչID',
  `type` char(2) default NULL COMMENT 'ƽpy kd EMS es',
  `area_id` text COMMENT 'мIDɵĴԣҲУ',
  `top_area_id` text COMMENT 'ʡIDɵĴԣҲУ',
  `area_name` text COMMENT 'nameɵĴԣ',
  `snum` mediumint(8) unsigned default '1' COMMENT '׼',
  `sprice` decimal(10,2) default '0.00' COMMENT '׼˷',
  `xnum` mediumint(8) unsigned default '1' COMMENT '',
  `xprice` decimal(10,2) default '0.00' COMMENT '˷',
  `is_default` enum('1','2') default '2' COMMENT 'ǷĬ˷12',
  `transport_id` mediumint(8) unsigned NOT NULL COMMENT '˷ģID',
  `transport_title` varchar(120) default NULL COMMENT '˷ģ',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='˷ģչ';

CREATE TABLE `#__type` (
	`type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
	`type_name` varchar(100) NOT NULL COMMENT '',
	`type_sort` tinyint(1) unsigned NOT NULL COMMENT '',
	 PRIMARY KEY  (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='Ʒͱ';

CREATE TABLE `#__type_brand` (
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
	`brand_id` int(10) unsigned NOT NULL COMMENT 'Ʒid'
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷƷƶӦ';

CREATE TABLE `#__type_spec` (
	`type_id` int(10) unsigned NOT NULL COMMENT 'id',
	`sp_id` int(10) unsigned NOT NULL COMMENT 'id'
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ƷӦ';

CREATE TABLE `#__upload` (
  `upload_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `file_name` varchar(100) DEFAULT NULL COMMENT 'ļ',
  `file_thumb` varchar(100) DEFAULT NULL COMMENT '΢ͼƬ',
  `file_wm` varchar(100) NULL COMMENT 'ˮӡͼƬ',
  `file_size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ļС',
  `store_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID0ΪԱ',
  `upload_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ļ0Ϊޣ1ΪͼƬĬΪ02ΪƷлͼƬ3ΪƷͼƬ4ΪϵͳͼƬ5ΪƷлͼƬ6ΪƷͼƬ',
  `upload_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `item_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'ϢID',
  PRIMARY KEY (`upload_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ϴļ';

CREATE TABLE `#__voucher` (
  `voucher_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ȯ',
  `voucher_code` varchar(32) NOT NULL COMMENT 'ȯ',
  `voucher_t_id` int(11) NOT NULL COMMENT 'ȯģ',
  `voucher_title` varchar(50) NOT NULL COMMENT 'ȯ',
  `voucher_desc` varchar(255) NOT NULL COMMENT 'ȯ',
  `voucher_start_date` int(11) NOT NULL COMMENT 'ȯЧڿʼʱ',
  `voucher_end_date` int(11) NOT NULL COMMENT 'ȯЧڽʱ',
  `voucher_price` int(11) NOT NULL COMMENT 'ȯ',
  `voucher_limit` decimal(10,2) NOT NULL COMMENT 'ȯʹʱĶ޶',
  `voucher_store_id` int(11) NOT NULL COMMENT 'ȯĵid',
  `voucher_state` tinyint(4) NOT NULL COMMENT 'ȯ״̬(1-δ,2-,3-,4-ջ)',
  `voucher_active_date` int(11) NOT NULL COMMENT 'ȯ',
  `voucher_type` tinyint(4) NOT NULL COMMENT 'ȯ',
  `voucher_owner_id` int(11) NOT NULL COMMENT 'ȯid',
  `voucher_owner_name` varchar(50) NOT NULL COMMENT 'ȯ',
  `voucher_order_id` int(11) DEFAULT NULL COMMENT 'ʹøôȯĶ',
  PRIMARY KEY (`voucher_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ȯ';

CREATE TABLE `#__voucher_price` (
  `voucher_price_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ȯֵ',
  `voucher_price_describe` varchar(255) NOT NULL COMMENT 'ȯ',
  `voucher_price` int(11) NOT NULL COMMENT 'ȯֵ',
  PRIMARY KEY (`voucher_price_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ȯ';

CREATE TABLE `#__voucher_template` (
  `voucher_t_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ȯģ',
  `voucher_t_title` varchar(50) NOT NULL COMMENT 'ȯģ',
  `voucher_t_desc` varchar(255) NOT NULL COMMENT 'ȯģ',
  `voucher_t_start_date` int(11) NOT NULL COMMENT 'ȯģЧڿʼʱ',
  `voucher_t_end_date` int(11) NOT NULL COMMENT 'ȯģЧڽʱ',
  `voucher_t_price` int(11) NOT NULL COMMENT 'ȯģ',
  `voucher_t_limit` decimal(10,2) NOT NULL COMMENT 'ȯʹʱĶ޶',
  `voucher_t_store_id` int(11) NOT NULL COMMENT 'ȯģĵid',
  `voucher_t_creator_id` int(11) NOT NULL COMMENT 'ȯģĴid',
  `voucher_t_state` tinyint(4) NOT NULL COMMENT 'ȯģ״̬(1-Ч,2-ʧЧ)',
  `voucher_t_total` int(11) NOT NULL COMMENT 'ģɷŵĴȯ',
  `voucher_t_giveout` int(11) NOT NULL COMMENT 'ģѷŵĴȯ',
  `voucher_t_used` int(11) NOT NULL COMMENT 'ģѾʹùĴȯ',
  `voucher_t_add_date` int(11) NOT NULL COMMENT 'ģĴʱ',
  `voucher_t_type` tinyint(4) NOT NULL COMMENT 'ȯģ',
  PRIMARY KEY (`voucher_t_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ȯģ';

CREATE TABLE `#__ztc_glodlog` (
  `glog_id` int(11) NOT NULL auto_increment COMMENT '',
  `glog_goodsid` int(11) NOT NULL COMMENT 'Ʒ',
  `glog_goodsname` varchar(100) NOT NULL COMMENT 'Ʒ',
  `glog_memberid` int(11) NOT NULL COMMENT 'Ա',
  `glog_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `glog_storeid` int(11) NOT NULL COMMENT '̱',
  `glog_storename` varchar(50) NOT NULL COMMENT '',
  `glog_type` tinyint(4) NOT NULL COMMENT '־ 1 2',
  `glog_goldnum` int(11) NOT NULL default '0' COMMENT 'Ҷ',
  `glog_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `glog_desc` varchar(500) NOT NULL COMMENT '',
  PRIMARY KEY  (`glog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ֱͨ־';

CREATE TABLE `#__ztc_goods` (
  `ztc_id` int(11) NOT NULL auto_increment COMMENT '',
  `ztc_goodsid` int(11) NOT NULL COMMENT 'Ʒ',
  `ztc_goodsname` varchar(100) NOT NULL COMMENT 'Ʒ',
  `ztc_goodsimage` varchar(100) NOT NULL COMMENT 'ƷͼƬ',
  `ztc_memberid` int(11) NOT NULL COMMENT 'Ա',
  `ztc_membername` varchar(50) NOT NULL COMMENT 'Ա',
  `ztc_storeid` int(11) NOT NULL COMMENT '̱',
  `ztc_storename` varchar(50) NOT NULL COMMENT '',
  `ztc_gold` int(11) NOT NULL COMMENT 'ֱͨĽҶ',
  `ztc_remark` varchar(200) NOT NULL COMMENT 'עϢ',
  `ztc_addtime` int(11) NOT NULL COMMENT 'ʱ',
  `ztc_startdate` int(11) default NULL COMMENT 'ֱͨʼʱ䣬ûñ̿ʼ',
  `ztc_state` tinyint(1) NOT NULL default '0' COMMENT '״̬ 0δ 1ͨ 2 δͨ',
  `ztc_paystate` tinyint(4) NOT NULL default '0' COMMENT '֧״̬ 0δ֧ 1֧',
  `ztc_type` tinyint(4) NOT NULL default '0' COMMENT 'ֵ 0ʾ¼ 1ʾֵ¼ֱӸֱͨӽ',
  PRIMARY KEY  (`ztc_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='ֱͨ';

INSERT INTO `#__setting` (`name`, `value`) VALUES('time_zone', '8');
INSERT INTO `#__setting` (`name`, `value`) VALUES('time_format_simple', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('time_format_complete', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('default_goods_image', 'default_goods_image.gif');
INSERT INTO `#__setting` (`name`, `value`) VALUES('default_store_logo', 'default_store_logo.gif');
INSERT INTO `#__setting` (`name`, `value`) VALUES('default_user_portrait', 'default_user_portrait.gif');
INSERT INTO `#__setting` (`name`, `value`) VALUES('statistics_code', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('guest_comment', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('rewrite_enabled', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_keywords', 'ShopNC');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_logo', 'logo.png');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_description', 'ShopNC̳ϵͳ');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_name', 'ShopNC');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_title', 'ShopNC̳ϵͳ');
INSERT INTO `#__setting` (`name`, `value`) VALUES('icp_number', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('image_dir_type','1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('gold_isuse', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('gold_rmbratio', '10');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ztc_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ztc_dayprod', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('qq_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('qq_appid', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('qq_appkey', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('qq_appcode', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('sina_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('sina_wb_akey','');
INSERT INTO `#__setting` (`name`, `value`) VALUES('sina_wb_skey','');
INSERT INTO `#__setting` (`name`, `value`) VALUES('sina_appcode', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('points_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('points_reg', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('points_login', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('points_comments', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('points_orderrate', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('points_ordermax', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('pointprod_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('voucher_allow', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('predeposit_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('complain_time_limit', '2592000');
INSERT INTO `#__setting` (`name`, `value`) VALUES('creditrule', 'a:3:{s:5:"heart";a:5:{i:1;a:2:{i:0;s:1:"1";i:1;s:3:"100";}i:2;a:2:{i:0;s:3:"101";i:1;s:3:"200";}i:3;a:2:{i:0;s:3:"201";i:1;s:3:"300";}i:4;a:2:{i:0;s:3:"301";i:1;s:3:"400";}i:5;a:2:{i:0;s:3:"401";i:1;s:3:"500";}}s:7:"diamond";a:5:{i:1;a:2:{i:0;s:3:"501";i:1;s:3:"600";}i:2;a:2:{i:0;s:3:"601";i:1;s:3:"700";}i:3;a:2:{i:0;s:3:"701";i:1;s:3:"800";}i:4;a:2:{i:0;s:3:"801";i:1;s:3:"900";}i:5;a:2:{i:0;s:3:"901";i:1;s:4:"1000";}}s:5:"crown";a:5:{i:1;a:2:{i:0;s:4:"1001";i:1;s:4:"1100";}i:2;a:2:{i:0;s:4:"1101";i:1;s:4:"1200";}i:3;a:2:{i:0;s:4:"1201";i:1;s:4:"1300";}i:4;a:2:{i:0;s:4:"1301";i:1;s:4:"1400";}i:5;a:2:{i:0;s:4:"1401";i:1;s:4:"1500";}}}');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_status', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('closed_reason', 'С');
INSERT INTO `#__setting` (`name`, `value`) VALUES('hot_search', ',Ϳ,Kappa,˫,');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_type', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_host', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_port', '25');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_addr', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_id', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_pass', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('captcha_status_login', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('captcha_status_register', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('captcha_status_goodsqa', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('captcha_status_backend', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('store_allow', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('enabled_subdomain', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('subdomain_suffix', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('subdomain_reserved', 'www');
INSERT INTO `#__setting` (`name`, `value`) VALUES('subdomain_length', '3-12');
INSERT INTO `#__setting` (`name`, `value`) VALUES('subdomain_edit', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('subdomain_times', '3');
INSERT INTO `#__setting` (`name`, `value`) VALUES('tpl_type', 'nc');
INSERT INTO `#__setting` (`name`, `value`) VALUES('session_expire', '1440');
INSERT INTO `#__setting` (`name`, `value`) VALUES('md5_key', '91be7deb1a5efcb6ca2fe5c66272e9bc');
INSERT INTO `#__setting` (`name`, `value`) VALUES('email_enabled', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_status', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_app_id', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_app_key', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_ip', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_connect_type', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_mysql_server', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_mysql_username', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_mysql_passwd', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_mysql_name', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_mysql_pre', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_url', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ucenter_type','discuz');
INSERT INTO `#__setting` (`name`, `value`) VALUES('debug_isuse', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('groupbuy_allow', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('image_max_filesize', '1024');
INSERT INTO `#__setting` (`name`, `value`) VALUES('image_allow_ext', 'gif,jpg,jpeg,bmp,png,swf,tbi');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_tiny_width', '60');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_tiny_height', '60');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_small_width', '160');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_small_height', '160');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_mid_width', '310');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_mid_height', '310');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_max_width', '1024');
INSERT INTO `#__setting` (`name`, `value`) VALUES('thumb_max_height', '1024');
INSERT INTO `#__setting` (`name`, `value`) VALUES('memcache_enable','0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('memcache_server','127.0.0.1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('memcache_port','11211');
INSERT INTO `#__setting` (`name`, `value`) VALUES('memcache_pconnect','0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('memcache_prefix','');
INSERT INTO `#__setting` (`name`, `value`) VALUES('class_generation_cache', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('promotion_allow', '1');
INSERT INTO `#__setting` (`name`, `value`) VALUES('promotion_mansong_price', '20');
INSERT INTO `#__setting` (`name`, `value`) VALUES('promotion_xianshi_price', '20');
INSERT INTO `#__setting` (`name`, `value`) VALUES('promotion_xianshi_times_limit', '20');
INSERT INTO `#__setting` (`name`, `value`) VALUES('promotion_xianshi_goods_limit', '20');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_open', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_ssl_state', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_server', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_port', '21');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_username', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_password', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_pasv', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_attach_dir', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_access_url', '');
INSERT INTO `#__setting` (`name`, `value`) VALUES('ftp_timeout', '0');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_phone', '23456789,88997788');
INSERT INTO `#__setting` (`name`, `value`) VALUES('site_email', 'abc@shopnc.net');

INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (9, 'ҳײͨͼƬ', 'λҳײͨͼƬ', 0, 2, 1, 1000, 90, 100, 0, 0, '84de815edad64024ae2e2c45979dc77e.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (13, 'ҳõƬ', 'ҳõƬ', 2, 0, 1, 500, 210, 100, 3, 0, '8d2b873c7dd4ed47aa907b95d7852e6f.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (14, 'ҳ', 'ҳ', 0, 2, 0, 150, 240, 100, 0, 0, '8d1531247fc8ce90b373360fd0b55fd4.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (15, 'ҳ', 'ҳ', 0, 2, 0, 150, 240, 100, 0, 0, '9a708eade54a7070918643a652cd3d7e.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (16, 'ﳵλ1', 'λڹﳵϢҳ·ͼƬ', 0, 2, 1, 240, 135, 100, 0, 0, 'eb1ab09f6eb9fe7517c0612b3c45b503.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (17, 'ﳵλ2', 'λڹﳵϢҳ·ͼƬ', 0, 2, 1, 240, 135, 100, 0, 0, '989d9e7bdefaa9568388c7d155ebb066.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (18, 'ﳵλ3', 'λڹﳵϢҳ·ͼƬ', 0, 2, 1, 240, 135, 100, 0, 0, '8357db899b3ba02b5549702be7c4d17d.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (19, 'ﳵλ4', 'λڹﳵϢҳ·ͼƬ', 0, 2, 1, 240, 135, 100, 0, 0, '96d16971074cbf29cc8fc08d2dcda137.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (20, 'ҳرƼ-ĸֻλ01', '̳رƼֶ\r\nĸͼƬΪһչʾ', 0, 1, 1, 110, 131, 100, 1, 1, 'f1414e558d853ebd8835f50bda72fdce.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (21, 'ҳرƼ-ĸֻλ02', '̳رƼֶ\r\nĸͼƬΪһչʾ', 0, 2, 1, 110, 131, 100, 0, 0, 'dafee38e6539ffe625f7658033e64bb1.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (22, 'ҳرƼ-ĸֻλ03', '̳رƼֶ\r\nĸͼƬΪһչʾ', 0, 2, 1, 110, 131, 100, 0, 0, '3b489eb71d6d7a760e61803cf191c1b7.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (23, 'ҳرƼ-ĸֻλ04', '̳رƼֶ\r\nĸͼƬΪһչʾ', 0, 2, 1, 110, 131, 100, 0, 0, '290e4cd2096b2b3ab1ce633cf3441401.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (24, 'ҳرƼ-ֻλ01', '̳رƼֶ\r\nͼƬΪһչʾ', 0, 2, 1, 215, 115, 150, 0, 0, '3067e3fbe549d28e183590463cf9c97d.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (25, 'ҳرƼ-ֻλ02', '̳رƼֶ\r\nͼƬΪһչʾ', 0, 2, 1, 215, 115, 150, 0, 0, '28d1eff4411f81442c8d4eb3ac255672.jpg');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (26, 'ҳƷչʾ·', 'ҳƷչʾ·', 0, 1, 1, 760, 100, 100, 4, 0, '');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (27, 'ֹ1-Ů·', 'ֹ1-Ů·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ1-Ů·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (28, 'ֹ2-Ь·', 'ֹ2-Ь·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ2-Ь·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (29, 'ֹ3-ױ·', 'ֹ3-ױ·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ3-ױ·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (30, 'ֹ4-˶·', 'ֹ4-˶·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ4-˶·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (31, 'ֹ5-ҵ·', 'ֹ5-ҵ·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ5-ҵ·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (32, 'ֹ6-ҾӼװ·', 'ֹ6-ҾӼװ·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ6-ҾӼװ·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (33, 'ֹ7-ʳƷ·', 'ֹ7-ʳƷ·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ7-ʳƷ·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (34, 'ֹ8-ĸӤƷ·', 'ֹ8-ĸӤƷ·ֹ', 1, 2, 1, 30, 0, 30, 0, 0, 'ֹ8-ĸӤƷ·ֹ');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (35, 'бҳвλ', 'бҳвλ', 0, 1, 1, 780, 254, 30, 0, 0, 'f448e48ee0deb06707480d46a2a360ae.gif');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (36, 'бҳҲײλ', 'бҳҲײλ', 0, 1, 1, 208, 341, 30, 0, 0, '38fd59a0e57dd03768315b5ad1223ad3.gif');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (37, 'Ʒбҳλ', 'Ʒбҳλ', 0, 1, 1, 200, 350, 100, 0, 0, '7a4832d109ee46fe7677c1d3c30e067f.gif');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (371, 'ҳҲλ', 'ҳҲλ', 0, 1, 1, 200, 350, 100, 0, 0, 'adv200-300.gif');
INSERT INTO `#__adv_position` (`ap_id`, `ap_name`, `ap_intro`, `ap_class`, `ap_display`, `is_use`, `ap_width`, `ap_height`, `ap_price`, `adv_num`, `click_num`, `default_content`) VALUES (372, 'ҳҲλ', 'ҳҲλ', 0, 1, 1, 200, 350, 100, 0, 0, 'adv200-300.gif');

INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (1, 13, 'ҳõƬԹ1', 'a:2:{s:13:"adv_slide_pic";s:36:"271b2785f67f6119332213367516a426.jpg";s:13:"adv_slide_url";s:14:"www.shopnc.net";}', 1306857600, 1622476800, 1, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (2, 13, 'ҳõƬԹ2', 'a:2:{s:13:"adv_slide_pic";s:36:"bd32bd9949a93f96eeb7bf7fdc619361.jpg";s:13:"adv_slide_url";s:14:"www.shopnc.net";}', 1306857600, 1623772800, 2, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (3, 13, 'ҳõƬԹ3', 'a:2:{s:13:"adv_slide_pic";s:36:"7dbaaa6f5324cd4b7a3531dfc5ca810b.jpg";s:13:"adv_slide_url";s:14:"www.shopnc.net";}', 1306857600, 1622476800, 3, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (4, 13, 'ҳõƬԹ4', 'a:2:{s:13:"adv_slide_pic";s:36:"1c8f6c1c8192d7fa5d3cc7f30d7db09c.jpg";s:13:"adv_slide_url";s:14:"www.shopnc.net";}', 1306857600, 1622476800, 4, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (5, 13, 'ҳõƬԹ5', 'a:2:{s:13:"adv_slide_pic";s:36:"33e9d8a94c644cd87ca97f7ced8024af.jpg";s:13:"adv_slide_url";s:14:"www.shopnc.net";}', 1306857600, 1622476800, 5, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (8, 26, 'ҳƷչʾ', 'a:2:{s:7:"adv_pic";s:36:"faf06d944be7bf3393f2a7d871754d49.jpg";s:11:"adv_pic_url";s:0:"";}', 1320076800, 1353772800, 0, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (9, 25, 'ֻ02', 'a:2:{s:7:"adv_pic";s:36:"5591c0054e33b3d86fbdadb536bb50a5.jpg";s:11:"adv_pic_url";s:14:"www.shopnc.net";}', 1321977600, 1343404800, 0, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (10, 24, 'ֻ01', 'a:2:{s:7:"adv_pic";s:36:"97caa4b287891a56f9434af1a5b71c82.jpg";s:11:"adv_pic_url";s:14:"www.shopnc.net";}', 1321977600, 1351353600, 0, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (11, 23, 'ĸֻ01', 'a:2:{s:7:"adv_pic";s:36:"edbbe33a9dd3ca37861f4045e34edd5c.jpg";s:11:"adv_pic_url";s:14:"www.shopnc.net";}', 1321977600, 1356796800, 0, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (12, 22, 'ĸֻ02', 'a:2:{s:7:"adv_pic";s:36:"606a56dfbd9509033358ad8beb8ac631.jpg";s:11:"adv_pic_url";s:14:"www.shopnc.net";}', 1321977600, 1353772800, 0, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (13, 21, 'ĸֻ03', 'a:2:{s:7:"adv_pic";s:36:"7f7c874c8f3a4f3835c8fe0348b96600.jpg";s:11:"adv_pic_url";s:14:"www.shopnc.net";}', 1321977600, 1351353600, 0, 0, '', 0, 1, '', 0);
INSERT INTO `#__adv` (`adv_id`, `ap_id`, `adv_title`, `adv_content`, `adv_start_date`, `adv_end_date`, `slide_sort`, `member_id`, `member_name`, `click_num`, `is_allow`, `buy_style`, `goldpay`) VALUES (14, 20, 'ĸֻ04', 'a:2:{s:7:"adv_pic";s:36:"c2d7e0d98aab6f4f4f3c8639fe4b4722.jpg";s:11:"adv_pic_url";s:14:"www.shopnc.net";}', 1321977600, 1353772800, 0, 0, '', 0, 1, '', 0);

INSERT INTO `#__gold_payment` (`payment_id`, `payment_code`, `payment_name`, `payment_info`, `payment_config`, `payment_online`, `payment_state`, `payment_sort`) VALUES(1, 'offline', '֧', '֧', 'a:1:{s:0:"";s:0:"";}', 0, 1, 3);
INSERT INTO `#__gold_payment` (`payment_id`, `payment_code`, `payment_name`, `payment_info`, `payment_config`, `payment_online`, `payment_state`, `payment_sort`) VALUES(2, 'alipay', '֧', '', 'a:1:{s:0:"";s:0:"";}', 1, 2, 3);
INSERT INTO `#__gold_payment` (`payment_id`, `payment_code`, `payment_name`, `payment_info`, `payment_config`, `payment_online`, `payment_state`, `payment_sort`) VALUES(3, 'tenpay', 'Ƹͨ', '', 'a:2:{s:14:"tenpay_account";s:10:"1900000109";s:10:"tenpay_key";s:32:"8934e7d15453e97507ef794cf7b0519d";}', 1, 2, 3);
INSERT INTO `#__gold_payment` (`payment_id`, `payment_code`, `payment_name`, `payment_info`, `payment_config`, `payment_online`, `payment_state`, `payment_sort`) VALUES(4, 'chinabank', '', '', 'a:2:{s:17:"chinabank_account";s:4:"1001";s:13:"chinabank_key";s:4:"test";}', 1, 1, 3);
INSERT INTO `#__gold_payment` (`payment_id`, `payment_code`, `payment_name`, `payment_info`, `payment_config`, `payment_online`, `payment_state`, `payment_sort`) VALUES('5', 'predeposit', 'Ԥ', NULL, NULL, '1', '2', '3');

INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(1, 'notice', '̳ǹ', 0, 255);
INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(2, 'member', '', 0, 255);
INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(3, 'store', '֮', 0, 255);
INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(4, 'payment', '֧ʽ', 0, 255);
INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(5, 'sold', 'ۺ', 0, 255);
INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(6, 'service', 'ͷ', 0, 255);
INSERT INTO `#__article_class` (`ac_id`, `ac_code`, `ac_name`, `ac_parent_id`, `ac_sort`) VALUES(7, 'about', '', 0, 255);

INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(6, 2, '', 1, 255, 'עΪԱ', '<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:24px;color:#003399;font-family:Microsoft YaHei;background-color:#ffffff;"><span style="font-size:18px;">¼̳ҳҳϷעᡱ</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span lang="EN-US" style="font-size:9pt;color:red;line-height:115%;font-family:Calibri;mso-bidi-font-size:8.0pt;mso-fareast-font-family:;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><?xml:namespace prefix = v ns = "urn:schemas-microsoft-com:vml" /><v:shapetype id="_x0000_t75" coordsize="21600,21600" o:spt="75" o:preferrelative="t" path="m@4@5l@4@11@9@11@9@5xe" stroked="f" filled="f"><span style="font-size:24px;">&nbsp;</span><img alt="" src="./upload/editor/20110128134626_62236.jpg" border="0" /></v:shapetype></span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span lang="EN-US" style="font-size:9pt;color:red;line-height:115%;font-family:Calibri;mso-bidi-font-size:8.0pt;mso-fareast-font-family:;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><v:shapetype coordsize="21600,21600" o:spt="75" o:preferrelative="t" path="m@4@5l@4@11@9@11@9@5xe" stroked="f" filled="f"><span style="font-size:24px;">&nbsp;</span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;"><span style="font-size:small;color:#003399;"><span style="font-size:18px;">עҳ棬дϢĶûֲ</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;"><span style="font-size:small;color:#335a89;"><img alt="" src="./upload/editor/20110128135022_79350.jpg" border="0" /></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;"><span style="font-size:small;color:#003399;"><span style="font-size:18px;">дɺעᡱύ</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;"><span style="font-size:small;color:#003399;"><img alt="" src="./upload/editor/20110128135237_43758.jpg" border="0" /></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;"><span style="font-size:small;color:#003399;"><span style="font-size:18px;">ʾעɹ</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;"><span style="font-size:small;color:#003399;"><img alt="" src="./upload/editor/20110128135406_55835.jpg" border="0" /></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3>&nbsp;</h3>\r\n</v:shapetype></span></span></span>', 1294709136);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(7, 2, '', 1, 255, '', '<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:24px;color:#003399;font-family:Microsoft YaHei;background-color:#ffffff;"><span style="font-size:18px;">¼̳ҳƷҪƷĹؼ֣</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:24px;color:#003399;font-family:Microsoft YaHei;background-color:#ffffff;"><span style="font-size:18px;"><img alt="" src="./upload/editor/20110208093142_97861.jpg" border="0" /></span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:24px;color:#003399;font-family:Microsoft YaHei;background-color:#ffffff;"><span style="font-size:18px;">ֺйؼֵƷҳ</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:24px;color:#003399;font-family:Microsoft YaHei;background-color:#ffffff;"><span style="font-size:18px;"><img alt="" src="./upload/editor/20110208094130_68431.jpg" border="0" width="700px" /></span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>', 1294709301);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(8, 2, '', 1, 255, '', '<span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"> <h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">Ա¼ҳ棬롱</span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110208095308_38085.jpg" border="0" /></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ҳдûϢύһء</span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110208095715_55839.jpg" border="0" /></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:x-small;color:#ff0000;">ַҪдעûǵ</span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="color:#003399;">ʾʼѷͳɹ</span></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110208095945_10374.jpg" border="0" /></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">¼鿴һ</span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110208100610_22468.jpg" border="0" /></span></span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n</span></h3>\r\n</span></h3>\r\n<h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n</span></span></span>', 1294709313);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(9, 2, '', 1, 255, 'Ҫ', '<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">Ա½̳ҳƷϢҳ</span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110208170115_29919.jpg" border="0" width="700px" /></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">д빺ﳵ</span></span></span></p>\r\n<p></p>\r\n<p><img alt="" src="./upload/editor/20110209093017_89659.jpg" border="0" /></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">鿴ﳵ</span></span></span></p>\r\n<p><img alt="" src="./upload/editor/20110209093309_99011.jpg" border="0" /></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">дȷ϶</span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110209093721_30123.jpg" border="0" width="700px" /></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">дϢµɲ֧</span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110209093819_87401.jpg" border="0" width="700px" /></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">ѡ֧ʽȷ֧</span></span></span></span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110209094020_49119.jpg" border="0" width="700px" /></span></span></span></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">Ʒɹ</span></span></span></span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110209094145_20766.jpg" border="0" width="700px" /></span></span></span></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>', 1294709365);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(10, 2, '', 1, 255, '鿴ѹƷ', '<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">Ա¼̳ǣû</span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110209094358_99646.jpg" border="0" /></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;">ҰҵĶ룬ɲ鿴ѹ򱦱</span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110209094502_62272.jpg" border="0" width="700px" /></span></span></span></p>', 1294709380);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(11, 3, '', 1, 255, 'ι', '<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-size:18px;color:#003399;font-family:SimSun;">&nbsp;</span><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">Ա½̳ǽûģҰҵá</span></span></span></span></span></span></p>\r\n<p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110209101544_91746.jpg" border="0" /></span></span></span></span></span></span></p>\r\n<span style="font-family:SimSun;"><span style="font-size:18px;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">дϢύ</span></span></span></p>\r\n<h3 style="margin:15pt 0cm 0pt;"></h3>\r\n<h3 style="margin:15pt 0cm 0pt;"><img alt="" src="./upload/editor/20110209132805_31517.jpg" border="0" /></h3>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">ҵĵҳɲ鿴úҳ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110209133004_49592.jpg" border="0" /></span></span></span></p>\r\n</span></span></span></span></span></span> <p><span style="font-family:SimSun;"><span style="font-size:18px;"><span style="font-size:18px;color:#003399;font-family:SimSun;">&nbsp;</p>\r\n<p class="MsoNormal" style="margin:10pt 0cm;"><span style="font-size:x-small;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span lang="EN-US" style="font-size:10pt;line-height:115%;font-family:Calibri;mso-fareast-font-family:;mso-bidi-font-family:Times New Roman;mso-bidi-font-size:10.5pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><?xml:namespace prefix = v /><v:shapetype stroked="f" filled="f" path="m@4@5l@4@11@9@11@9@5xe" o:preferrelative="t" o:spt="75" coordsize="21600,21600"></v:shapetype></span></span></span></span>&nbsp;</p>\r\n<p class="MsoNormal" style="margin:10pt 0cm;"><span style="font-size:x-small;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span lang="EN-US" style="font-size:10pt;line-height:115%;font-family:Calibri;mso-fareast-font-family:;mso-bidi-font-family:Times New Roman;mso-bidi-font-size:10.5pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><v:shapetype stroked="f" filled="f" path="m@4@5l@4@11@9@11@9@5xe" o:preferrelative="t" o:spt="75" coordsize="21600,21600"><span style="color:#000000;"><?xml:namespace prefix = v ns = "urn:schemas-microsoft-com:vml" /><v:stroke joinstyle="miter"></v:stroke></span><v:formulas><v:f eqn="if lineDrawn pixelLineWidth 0"></v:f><v:f eqn="sum @0 1 0"></v:f><v:f eqn="sum 0 0 @1"></v:f><v:f eqn="prod @2 1 2"></v:f><v:f eqn="prod @3 21600 pixelWidth"></v:f><v:f eqn="prod @3 21600 pixelHeight"></v:f><v:f eqn="sum @0 0 1"></v:f><v:f eqn="prod @6 1 2"></v:f><v:f eqn="prod @7 21600 pixelWidth"></v:f><v:f eqn="sum @8 21600 0"></v:f><v:f eqn="prod @7 21600 pixelHeight"></v:f><v:f eqn="sum @10 21600 0"></v:f></v:formulas><v:path o:connecttype="rect" gradientshapeok="t" o:extrusionok="f"></v:path><?xml:namespace prefix = o ns = "urn:schemas-microsoft-com:office:office" /><o:lock aspectratio="t" v:ext="edit"></o:lock></v:shapetype></span></span></span></span>&nbsp;</p>\r\n</span></span></span>', 1294709442);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(12, 3, '', 1, 255, '鿴۳Ʒ', '<span style="font-size:18px;color:#003399;font-family:SimSun;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">Ա½̳ǽûģҰҵ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110209141334_26280.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">鿴</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110209143053_56888.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span>', 1294709506);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(13, 3, '', 1, 255, 'η', '<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">жбҳ棬յ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110209144219_67019.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;">дȷ</span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110209144319_11772.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="color:#335a89;font-size:small;">жбҳ棬</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110209150146_55268.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="color:#335a89;font-size:small;">дԼȷ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110209150256_60581.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span></span> <p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span></span></span>', 1294709579);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(14, 3, '', 1, 255, '̳ƷƼ', '<p><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-bidi-font-size:8.0pt;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">Ա½̳ǽûģҰҵƷ</span></p>\r\n<p><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-bidi-font-size:8.0pt;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110209154027_17581.jpg" border="0" /></span></p>\r\n<p>&nbsp;</p>\r\n<span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-bidi-font-size:8.0pt;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ƷбеƷġ༭</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><img alt="" src="./upload/editor/20110209155654_54046.jpg" border="0" /></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ѡƼύ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><img alt="" src="./upload/editor/20110209160008_38544.jpg" border="0" /></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><img alt="" src="./upload/editor/20110209160122_33174.jpg" border="0" /></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span>', 1294709599);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(15, 3, '', 1, 255, '뿪', '<p><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">¼̳ҳϽǡû</span><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"></span></p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><img alt="" src="./upload/editor/20110209162925_19705.jpg" border="0" /></span></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">Աûҳ棬·</span><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">뿪ꡱ</span></span></span></p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110209163229_20901.jpg" border="0" /></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">ѡͣշѱ׼ȣꡱ</span></span></span></span></span></p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110209163457_37558.jpg" border="0" width="700px"/></span></span></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">дϢꡱ</span></span></span></span></span></p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110209164206_43906.jpg" border="0" /></span></span></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">ʾ뿪ɹ</span></span></span></span></span></p>\r\n<p><span lang="EN-US" style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;mso-fareast-font-family:;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:SimSun;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><span style="color:#000000;"><span style="font-size:18px;color:#003399;font-family:;mso-bidi-font-size:12.0pt;mso-ascii-font-family:Times New Roman;mso-hansi-font-family:Times New Roman;mso-bidi-font-family:Times New Roman;mso-font-kerning:1.0pt;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110209164344_55309.jpg" border="0" /></span></span></span></span></span></p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>', 1294709809);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(16, 4, '', 1, 255, 'ע֧', '<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">Ա½̳ǽûģҰҵ֧ʽ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110210083402_90837.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">Ҫӵ֧ʽġװ</span></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110210084935_79853.jpg" border="0" /></span></span></span></span></p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"> <h3 style="margin:15pt 0cm 0pt;">&nbsp;</h3>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">дϢύ</span></span></p>\r\n</span></span></span></span> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110210085515_46504.jpg" border="0" /></span></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>', 1294709827);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(17, 4, '', 1, 255, '֧', '֧', 1294713631);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(18, 6, '', 1, 255, 'Ա޸', '<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">Ա¼̳ǣϽǡûġ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110210100016_71548.jpg" border="0" width="700px" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">ҵ˻ϡ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110210100143_75461.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">ڸҳ޸롱</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110210100354_81369.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;">дύ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;font-family:SimSun;"><img alt="" src="./upload/editor/20110210100612_16845.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>', 1294713819);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(19, 6, '', 1, 255, 'Ա޸ĸ', '<p><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">Ա¼̳ǣϽǡûġ</span></p>\r\n<p><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110210100846_23142.jpg" border="0" /></span></p>\r\n<p>&nbsp;</p>\r\n<span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ûĵҵ˻ϡ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210101042_74191.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ҲûĬϽ棨˻ſ༭ϡ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210101209_36181.jpg" border="0" /></span></p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">дϢϣͷ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><img alt="" src="./upload/editor/20110210101333_62566.jpg" border="0" /></span></span></p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;">бϴͼƬͷ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210101528_80109.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">޸ͷдɸϢ޸ġ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110210101632_31534.jpg" border="0" /></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="color:#003399;">ɸϢ޸</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="color:#003399;"><img alt="" src="./upload/editor/20110210101732_37374.jpg" border="0" /></span></span></span></p>\r\n</span></span> <p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span></span> <p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span></span></span>', 1294713836);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(20, 6, '', 1, 255, 'Ʒ', '<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">Ա½̳ǽûģҰҵƷ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210102523_43795.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ƷбеƷ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210102626_41732.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">дƷϸϢύ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210102729_99892.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;">ʾƷɹ</span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210102812_84565.jpg" border="0" /></span></p>\r\n</span></span></span>', 1294713852);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(21, 6, '', 1, 255, '޸ջַ', '<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;">Ա¼̳ǽûģҰҵҵĵַ</span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;"><img alt="" src="./upload/editor/20110210103254_50780.jpg" border="0" /></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;">ڵַбҳõַġ༭</span></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"><img alt="" src="./upload/editor/20110210103509_39444.jpg" border="0" /></span></span></span></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><span style="font-size:small;color:#335a89;"><span style="font-size:18px;color:#003399;"><span style="font-size:18px;color:#003399;line-height:115%;font-family:SimSun;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-size:8.0pt;mso-bidi-font-family:Times New Roman;mso-ansi-language:EN-US;mso-fareast-language:ZH-CN;mso-bidi-language:AR-SA;"> <p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;">ɶԸõַϢ޸ĺ󣬵༭ַ</span></p>\r\n<p style="margin:15pt 0cm 0pt;"><span style="font-family:;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;"><img alt="" src="./upload/editor/20110210103710_47524.jpg" border="0" /></span></p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n</span></span></span></span> <p style="margin:15pt 0cm 0pt;">&nbsp;</p>\r\n<p style="margin:15pt 0cm 0pt;">&nbsp;</p>', 1294713910);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(22, 7, '', 1, 255, 'ShopNC', '<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ǴƼι˾λϿרҵϢѯĸ¼ҵ˾ӵж˲źҵרҡ</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ˾ӵһ֧ڿءս۹гжгӪ飬һʵҵ׷׿Խ˲ţһս㣬ḻĿŶӡ˾ְִҵƶȺгɰ£ӪģͬʱעҵƷзнĿ˺ǿľ ҹ˾ҲڴͳҵϢ죬ʻƷı׼淶̣ͨ˲ŵļʣƷĿǰѾ֪ʶȨ̳ڻڵƽ̨ЧܡЧĹϵͳΪһعг¼ʵĻ˾ڹһšչ˲ƽ̨Ӫ׷׿Խ׵ĹΧѡΪʵÿһ幤УΪЩâ޵ҵ羫Ӣṩֵķչռ䣬šԵõĹҵȤ˵ʽͨÿԱңԼĶؼֵ۶Թ׼ȷжϣʹÿһԱԳǳɫƷλеĹԺ׿ԽĴ·ʱ̱ܡϹ룬Զʱǰˡ˾չ ͼΣչδ˾ѷչҵ뷢˲ŲԽܽϣᾫӢھǱܣΪŬӪгɵĹΧΪ˲ŵӱṩ˾뷢չҵͬʱͨиŬ˾ĻԻ </p>', 1294714215);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(23, 7, '', 1, 255, 'ϵ', '<p>ӭǵվ㡢ƷͷԼ顣ǽʱ𸴡ͬʱҲӭǹ˾Ǣҵ</p>\r\n<p><br />\r\n<strong>˾</strong> ǴƼι˾ <br />\r\n<strong>ͨŵַ</strong> Ͽ·220Ż۹ȴ712 <br />\r\n<strong></strong> 300072 <br />\r\n<strong>绰</strong> 400-611-5098 <br />\r\n<strong>Ǣ̸</strong> 86-022-87631069 <br />\r\n<strong></strong> 86-022-87631069 <br />\r\n<strong>ҵ</strong> 120193000029441 <br />\r\n<strong>ȨǼǺ</strong> 2008SR07843 <br />\r\n<strong>ICP</strong> ICP08000171 </p>', 1294714228);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(24, 7, '', 1, 255, 'ƸӢ', '<dl> <h3>PHPԱ</h3>\r\n<dt>ְλҪ <dd>ϤPHP5ԣ<br />\r\nϤMySQL5ݿ⣬ͬʱϤsqlserveroracleȣ<br />\r\nϤ˼룬MVCϵʹùĿǰ֪PHPһ֣<br />\r\nϤSERVER2003/LinuxϵͳϤLinux<br />\r\nϤMysqlݿӦÿ˽MysqlݿùŻȻܣ<br />\r\nϤjquerysmartyȳÿԴ<br />\r\n߱õĴϰ߼ǿĵд<br />\r\n߱õŶӺ<br />\r\nϤģʽȣ<br />\r\nϤjavac++,c#,pythonһȣ </dd> <dt>ѧҪ <dd> </dd> <dt>飺 <dd>һ </dd> <dt>ص㣺 <dd> </dd></dl> <dl> <h3>ҳƣ2</h3>\r\n<dt>λְ <dd>վUIơ ƬԼHTML </dd> <dt>ְλҪ <dd>дվƾ飻վİ桢Ƶ辭ȿǣ <br />\r\nphotoshop,fireworks,dreamwaver <br />\r\nDiv+CssҳCSS2.0-W3C׼ղͬ£ͬ汾CSSԪص<br />\r\nϤվ̣ò޸ļJavaScript <br />\r\nϣõ˼ʹͨõĹЭ̤ʵϸɵĹ񣻾õĹͨ<br />\r\nжŶЭ <br />\r\nӦƸڼṩ˽Ʒӡ </dd> <dt>ѧҪ <dd>ר </dd> <dt>飺 <dd>һ </dd> <dt>ص㣺 <dd> </dd></dl> <dl> <h3>߻1</h3>\r\n<dt>ְλҪ <dd>2ϵİ༭ع飬߱һֹףмǿԱ߼˼ά ܶĿıдݸЭ顣Ϥʹð칫 </dd> <dt>ѧҪ <dd>ר </dd> <dt>飺 <dd>һ </dd> <dt>ص㣺 <dd> </dd></dl>', 1294714240);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(25, 7, '', 1, 255, 'Ǣ̸', '<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ShopNCϣ̡鲢Яֿ繺гӵкõĽ飬ӵзḻԴӵڶĿͻӵӦгԴϣShopNCҵ ӭΪShopNCҵ飬ϵ</p>\r\n<p>&nbsp;</p>\r\n<p><strong>˾</strong> ǴƼι˾ <br />\r\n<strong>ͨŵַ</strong> Ͽ·220Ż۹ȴ712 <br />\r\n<strong></strong> 300072 <br />\r\n<strong>绰</strong> 400-611-5098 <br />\r\n<strong>Ǣ̸</strong> 86-022-87631069 <br />\r\n<strong></strong> 86-022-87631069 <br />\r\n</p>', 1294714257);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(26, 5, '', 1, 255, 'ϵ', 'ϵ', 1294714858);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(28, 4, '', 1, 255, 'ڸ', 'ڸ<br />', 1309835564);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(29, 4, '', 1, 255, 'ʾֻ', 'ʾֻ<br />', 1309835582);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(30, 4, '', 1, 255, '˾ת', '˾ת<br />', 1309835600);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(31, 5, '', 1, 255, '˻', '˻', 1309835651);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(32, 5, '', 1, 255, '˻', '˻', 1309835666);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(33, 5, '', 1, 255, '/˻', '/˻', 1309835679);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(34, 5, '', 1, 255, '˿', '˿', 1309835699);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(35, 1, 'http://www.shopnc.net/', 1, 255, '2.2', '2.2<br />', 1342368000);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(38, 1, '', 1, 252, 'ֱͨվӯ', '<h3 style="font-size:16px;text-align:center;">ShopNC̳ϵͳ1.2汾֮"ֱͨ"˵</h3>\r\n<p style="text-indent:2em;">ֱͨǾԿͻϰߵоһվӯģʽ̼ңƽ̨ûʹֱͨƷӪ̼֧ͨʹƷֱܹͨʾƷбƷʣԽԽǰƷ·ʾֱͨ־Ʒʾû͹ᡣվֱͨͨƽ̨ƹ㲢ʵʵʵڵӯվõΪ̼ҷ񣬼̼֮裬ʹ˫õӦĻرֱͨƽ̨ʵְʱԶ۳ֱͨҹܣվӵĲ̡</p>\r\n<p></p>\r\n<p style="color:red;">עϸʹ÷İװdocumentļеذĵ</p>', 1310203091);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(36, 1, '', 1, 253, '°桰˵', '<h3 style="font-size:16px;text-align:center;">ShopNC̳ϵͳ1.2汾֮""˵</h3>\r\n<p style="text-indent:2em;">վһվҪԴҲվӪվҪĿ֮һһǿɣĹϵͳÿһվҪġ</p>\r\n<p style="text-indent:2em;">ShopNC̳ϵͳ1.2汾֮ǰ汾ڹģشĸĽ׵߸֮ǰǳĹϵͳʹվɵλ䶨۲ŵվκһطϵͳṩ"õƬ""ͼƬ""""Flash"ȶֹʽվѡͬʱȫµĹϵͳҲֱ̻߹Ĺܣ1.2汾""ϵͳʹãʹվĹķǳ򵥡ֱӡ̶ܼȵվ롣ɵĹͳͼҲShopNC̳ϵͳ1.2汾һɫͨ߼ʱFlashʽͳͼվֱ۵չϵͳṩ"ͼ""ͼ""ͼ"չʾʽͬʱվں̨ͨλܣѸٵ֪ЩλױûվĹλ۸񣬽һվ롣</p>\r\n<p></p>\r\n<p style="color:red;">עϸʹ÷İװdocumentļеذĵ</p>', 1310198494);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(37, 1, '', 1, 251, 'ˮӡ', '<h3 style="font-size:16px;text-align:center;">ˮӡ֧</h3>\r\n<p style="text-indent:2em;"><b>ʹ÷</b>صϴվĿ¼"վĿ¼\\resource\\font\\"ļڣͬʱҪ޸Ĵļµfont.info.phpļ磺һ""ֿsimsun.ttfǰļڣʹô༭ߣEditPlusfont.info.phpļе$fontInfo = array(''arial''=&gt;''Arial'')ֿϢ"=&gt;"ļұվʾϢ</p>\r\n<p style="text-indent:2em;">Ӻ磺array(''arial''=&gt;''Arial'',''simsun''=&gt;'''')ʾ</p>\r\n<p></p>\r\n<p style="text-indent:2em;">ShopNCٷվļصַ<a href="http://www.shopnc.net/downloads/product/multishop/fonts.zip">ļ[fonts.zip]</a></p>\r\n<p></p>\r\n<p style="color:red;">עϸʹ÷Ҳɲİװuploadļеreadmeĵ</p>', 1310200272);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(40, 1, '', 1, 254, 'ShopNCٷʹʾϢ', '<p style="text-indent:2em;"><b>ٷʾ</b>ShopNC̳ϵͳɹվʹã尲װʹЭװеȨЭĵøʹȨޣϵٷȨ</p>\r\n<p style="text-indent:2em;">ShopNCŶʺվӪ̳ϵͳӭλվٷϵı顣ҪǵĶĻرĿǡ</p>\r\n<ul style="line-height:150%;">\r\n<li>ٷַ<a href="http://www.shopnc.net">http://www.shopnc.net</a></li>\r\n<li>ٷ̳<a href="http://www.shopnc.net/bbs/">http://www.shopnc.net/bbs/</a></li>\r\n<li>ѯQQ1045269763 921362895</li>\r\n<li>ѯ绰<b>400-611-5098</b></li>\r\n</ul>', 1310268647);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(39, 1, '', 1, 254, 'UCenter˵', '<h3 style="font-size:16px;text-align:center;">ShopNC̳ϵͳ1.2汾֮"Ucenter"˵</h3>\r\n<p style="text-indent:2em;">ƽ̨֮ĻԱͨվǵһ󣬻ԱĻͨվֲͬģʽƽ̨ͬӪøƽ̨֮΢ϵǿƽ̨ûճȺҵֵ</p>\r\n<p style="text-indent:2em;">ShopNC̳ϵͳ1.2ܺõUCenterϣʵֻԱĻͨվжģʽϵͳЭӪڽUCenterϵʱҪע¼㣺</p>\r\n<ul>\r\n<li>Ucenterʹõutf8̳ǵҲҪutf8ģgbkľͻ⡣</li>\r\n<li>ʹǰϣΪϳɹԭϵͳеĻԱٵ¼UcenterΪ</li>\r\n<li>̳ϢUcenterп"ͨųɹ"ʾ˵ɡ</li>\r\n<li>˲ͬ¼⣬̳ĺ̨»档</li>\r\n</ul>\r\n<p></p>\r\n<p style="color:red;">עϸʹ÷İװdocumentļеذĵ</p>', 1310262555);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(41, 2, '', 1, 255, 'ϸ', 'ϸϸ', 1322621203);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(42, 2, '', 1, 255, 'ֶһ˵', 'ֶһ˵ֶһ˵<br />', 1322621243);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(43, 1, '', 1, 254, '¹ʹ˵', '<p>&nbsp;&nbsp;&nbsp; ˺ŵ¼Ҫ뿪ͨں̨ÿ</p>\r\n<p>&nbsp;&nbsp;&nbsp; ֶһԤʹվпѡǷͨӦܡ</p>\r\n<p>&nbsp;&nbsp;&nbsp; ϸ˵οװdocumentļеذĵ</p>', 1322789334);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(44, 1, '', 1, 255, 'ʱۿʹ˵', '<p>\r\n	һ<span style="font-size:10.5000pt;font-family:'''';">ҽû <span>-&gt; </span><span> </span><span>-&gt; </span><span> </span><span>-&gt; </span><span>Ʒ </span><span>-&gt; </span><span>ʱۿۣǰûпײͣϵͳʾȹײ͡</span></span><span style="font-size:10.5pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022113_65206.png" alt="" /> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">ҵײͰťײ͹棬дҪύťײ͹롣</span><span style="font-size:10.5000pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022155_70768.png" alt="" /> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">ײƽ̨ûͨǰϵͳʾѾײ͵ûͨˡ</span><span style="font-size:10.5000pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022223_45601.png" alt="" /> \r\n</p>\r\n<p>\r\n	ġ<span style="font-size:10.5000pt;font-family:'''';">ײͨҿԷʱۿۻӻťҳ档ײбӿԲ鿴ײͼ¼</span><span style="font-size:10.5000pt;font-family:'''';"></span><br />\r\n<span style="font-size:10.5000pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022253_29124.png" alt="" /> \r\n</p>\r\n<p>\r\n	塢<span style="font-size:10.5000pt;font-family:'''';">дơʼʱ䡢ʱĬۿۣύťƷѡҳ档</span><span style="font-size:10.5000pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022317_65502.png" alt="" /> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">ƷťѡҪμӻƷ</span><span style="font-size:10.5000pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022344_86225.png" alt="" /> \r\n</p>\r\n<p>\r\n	ߡ<span style="font-size:10.5000pt;font-family:'''';">ƷߵӰťѡƷӵǰСƷѡϺ·ķػťصҳ档</span><span style="font-size:10.5000pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504022411_71122.png" alt="" /> \r\n</p>\r\n<p>\r\n	ˡ<span style="font-size:10.5pt;font-family:'''';">ڻҳԵÿƷۿʣȷťʱۿۻķ</span> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5pt;font-family:'''';"><img src="./upload/editor/20120504022440_49064.png" alt="" /></span> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">šʱۿƷʾƷбУƷбҳԶʱۿƷɸѡƷϸҳʱۿ۱ʶ̹ťʱۿۼ۹Ʒ</span><span style="font-size:10.5000pt;font-family:'''';"></span><span style="font-size:10.5pt;font-family:'''';"></span> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5pt;font-family:'''';"><img src="./upload/editor/20120504022517_84608.png" alt="" /></span> \r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';"><img src="./upload/editor/20120504022542_81820.png" alt="" /></span> \r\n</p>\r\n<br />', 1336098353);
INSERT INTO `#__article` (`article_id`, `ac_id`, `article_url`, `article_show`, `article_sort`, `article_title`, `article_content`, `article_time`) VALUES(45, 1, '', 1, 255, 'ʹ˵', '<p>\r\n	һ<span style="font-size:10.5000pt;font-family:'''';">ҽû&nbsp;<span>-&gt;&nbsp;</span><span>&nbsp;</span><span>-&gt;&nbsp;</span><span>&nbsp;</span><span>-&gt;&nbsp;</span><span>Ʒ&nbsp;</span><span>-&gt;&nbsp;</span><span>ͣǰûпײͣϵͳʾȹײ͡</span></span><span style="font-size:10.5pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025039_83457.png" alt="" />\r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">ҵײͰťײ͹棬дҪύťײ͹롣</span><span style="font-size:10.5000pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025105_16849.png" alt="" />\r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">ײƽ̨ûͨǰϵͳʾѾײ͵ûͨˡ</span><span style="font-size:10.5000pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025127_50866.png" alt="" />\r\n</p>\r\n<p>\r\n	ġ<span style="font-size:10.5000pt;font-family:'''';">ײͨҿԷͻӻťҳ档ײбӿԲ鿴ײͼ¼</span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025157_78499.png" alt="" />\r\n</p>\r\n<p>\r\n	塢<span style="font-size:10.5000pt;font-family:'''';">дơʼʱͽʱ</span><span style="font-size:10.5000pt;font-family:'''';"></span><br />\r\n<span style="font-size:10.5000pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025227_23504.png" alt="" />\r\n</p>\r\n<p>\r\n	<span style="font-size:10.5000pt;font-family:'''';">ͻÿԷֱѡμӼֽ𡢰ʺƷʽһ</span><span style="font-size:10.5000pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025246_12664.png" alt="" />\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025255_72740.png" alt="" />\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025305_38366.png" alt="" />\r\n</p>\r\n<p>\r\n	ߡ<span style="font-size:10.5000pt;font-family:'''';">͹ɺдעϢύťͻķ</span><span style="font-size:10.5000pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025316_42126.png" alt="" />\r\n</p>\r\n<p>\r\n	ˡ<span style="font-size:10.5000pt;font-family:'''';">Ʒϸҳμͻĵ̻ͱʶﳵʱ͹򽫰ͻз</span><span style="font-size:10.5000pt;font-family:'''';"></span>\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025440_23068.png" alt="" />\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025453_64906.png" alt="" />\r\n</p>\r\n<p>\r\n	<img src="./upload/editor/20120504025501_90167.png" alt="" />\r\n</p>\r\n<br />', 1336100107);

INSERT INTO `#__coupon_class` (`class_id`, `class_parent_id`, `class_name`, `class_sort`, `class_show`) VALUES(1, 0, 'Է', 99, '1');

INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(1, 'Ǵ', 'http://www.shopnc.net', 'ac1d6b368d9a8b048b974186c8d467a9.gif', 0);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(29, 'Ѷ', 'http://www.qq.com', '75eb906e1b7a2f568f38517c3b338b76.png', 8);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(28, '', 'http://www.skycn.com', '7e6c4529c180781a4918728c59106a0d.jpg', 6);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(27, 'վ֮', 'http://www.chinaz.com', 'd3f4b551af9621eca9dce6b742c66540.gif', 7);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(26, '', 'http://www.onlinedown.net', '675e3c273601596996c7d9f56340c7ff.gif', 5);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(22, 'PHPChina', 'http://www.phpchina.com', '71f3651a995ef7a8d8bcc00dfe1fa018.gif', 3);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(23, 'ʢ', 'http://www.comsenz.com', '2656c79dff5e988bc20d707d1a73a583.jpg', 2);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(24, 'A5', 'http://down.admin5.com', '1ce6ffadfcf5e45d7fbd86d46d0e90db.gif', 4);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(25, 'DZ', 'http://www.verydz.com', '29269def49a5d57a24490b69b3312260.gif', 1);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(38, '֧ƽ̨', 'https://www.alipay.com/', '', 5);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(37, '΢ƽ̨', 'http://open.weibo.com/', '', 3);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(36, 'Discuz!ƽ̨', 'http://discuz.qq.com/', '', 4);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(35, 'ѿƽ̨', 'http://open.soso.com/', '', 6);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(34, 'QQʱ', 'http://open.cb.qq.com/', '', 8);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(33, 'Ƹͨƽ̨', 'http://open.tenpay.com/', '', 7);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(32, 'Ѷ΢ƽ̨', 'http://open.t.qq.com/', '', 2);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(31, 'Ѷƽ̨', 'http://opensns.qq.com/', '', 1);
INSERT INTO `#__link` (`link_id`, `link_title`, `link_url`, `link_pic`, `link_sort`) VALUES(30, 'QQ½', 'http://connect.opensns.qq.com/', '', 0);

INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>̵˶õʼ֪ͨ', '{$site_name}:{$store_name}Ķ', 'email_tobuyer_adjust_fee_notify', '<p>\r\n	𾴵{$buyer_name}:\r\n</p>\r\n<p style="" padding-left:="" 30px;="">׵ĵ{$store_name}Ϊ{$order_sn}Ķķãʱ\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a><br />\r\n \r\n	</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n	</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ȡʼ֪ͨ', '{$site_name}:Ķ{$order_sn}ѱȡ', 'email_tobuyer_cancel_order_notify', '<p>\r\n	𾴵{$buyer_name}:\r\n</p>\r\n<p style="" padding-left:="" 30px;="">׵ĵ{$store_name}ѾȡĶ{$order_sn}\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">ԭ{$reason}\r\n</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n	</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a> \r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n	</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ȷյʱʵĻɽ׵ʼ֪ͨ', '{$site_name}:{$store_name}ȷյĻɣ', 'email_tobuyer_cod_order_finish_notify', '<p>\r\n	𾴵{$buyer_name}:\r\n</p>\r\n<p style="" padding-left:="" 30px;="">׵ĵ{$store_name}ѾȷյĻ{$order_sn}ĸɣԵû-&gt;ҵĶжԸý׽ۡ\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a> \r\n	</p>\r\n<p style="" padding-left:="" 30px;="">鿴ҵĶб\r\n</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=order" target="_blank">{$site_url}/index.php?act=member&amp;op=order</a> \r\n	</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n	</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ȷ˶ʼ֪ͨ', '{$site_name}:{$store_name}ȷĶ', 'email_tobuyer_confirm_cod_order_notify', '𾴵{$buyer_name}:\r\n<p style="" padding-left:="" 30px;="">׵ĵ{$store_name}ѾȷĻ{$order_sn}ĵȴ\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a> \r\n	</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n	</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ɵʼ֪ͨ', '{$site_name}:Ķ', 'email_tobuyer_new_order_notify', '𾴵{$buyer_name}:\r\n<p style="" padding-left:="" 30px;="">{$site_name}µĶɣ{$order_sn}\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a> \r\n	</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n	</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ȷյ֧Ļʼ֪ͨ', '{$site_name}:{$store_name}ȷյ֧Ļ', 'email_tobuyer_offline_pay_success_notify', '𾴵{$buyer_name}:\r\n<p style="" padding-left:="" 30px;="">׵ĵ{$store_name}ѾȷյĶ{$order_sn}ĸĵȴҷ\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a> \r\n	</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n	</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ѷʼ֪ͨ', '{$site_name}:Ķ{$order_sn}ѷ', 'email_tobuyer_shipped_notify', '𾴵{$buyer_name}:\r\n<p style="" padding-left:="" 30px;="">׵ĵ{$store_name}ѾĶ{$order_sn}ˣעա\r\n	</p>\r\n<p style="" padding-left:="" 30px;="">ţ{$invoice_no}\r\n</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ\r\n	</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=member&amp;op=show_order&amp;order_id={$order_id}</a> \r\n</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}\r\n	</p>\r\n	<div style="text-align:right;">\r\n	</div>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}\r\n</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ȡ˶ʼ֪ͨ', '{$site_name}:{$buyer_name}ȡ˶{$order_sn}', 'email_toseller_cancel_order_notify', '𾴵{$seller_name}:\r\n<p style="" padding-left:="" 30px;="">{$buyer_name}Ѿȡ׵Ķ{$order_sn}</p>\r\n<p style="" padding-left:="" 30px;="">ԭ{$reason}</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}</a></p>\r\n<p style="" padding-left:="" 30px;="">鿴Ķбҳ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=store_order" target="_blank">{$site_url}/index.php?act=store&amp;op=store_order</a></p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ȷ˶ɽ׵ʼ֪ͨ', '{$site_name}:ȷ׵Ķ{$order_sn}', 'email_toseller_finish_notify', '𾴵{$seller_name}:\r\n<p style="" padding-left:="" 30px;="">{$buyer_name}Ѿȷ׵Ķ{$order_sn}</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}</a></p>\r\n<p style="" padding-left:="" 30px;="">鿴Ķбҳ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=store_order" target="_blank">{$site_url}/index.php?act=store&amp;op=store_order</a></p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>¶Ҫʼ֪ͨ', '{$site_name}:һ¶Ҫ', 'email_toseller_new_order_notify', '𾴵{$seller_name}:\r\n<p style="" padding-left:="" 30px;="">һµĶҪ{$order_sn}뾡촦</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}</a></p>\r\n<p style="" padding-left:="" 30px;="">鿴Ķбҳ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=store_order" target="_blank">{$site_url}/index.php?act=store&amp;op=store_order</a></p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>Ѿ¸ʼ֪ͨ', '{$site_name}:{$buyer_name}֧֧ͨ˶ķ', 'email_toseller_offline_pay_notify', '𾴵{$seller_name}:\r\n<p style="" padding-left:="" 30px;="">{$buyer_name}֧֧ͨ׵Ķ{$order_sn}עա</p>\r\n<p style="" padding-left:="" 30px;="">֧Ϣ{$pay_message}</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}</a></p>\r\n<p style="" padding-left:="" 30px;="">鿴Ķбҳ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=store_order" target="_blank">{$site_url}/index.php?act=store&amp;op=store_order</a></p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>Ѹʼ֪ͨ', '{$site_name}:{$buyer_name}Ѹ', 'email_toseller_online_pay_success_notify', '𾴵{$seller_name}:\r\n<p style="" padding-left:="" 30px;="">{$buyer_name}֧ͨ˶{$.order_sn}ĸʵ찲ŷ</p>\r\n<p style="" padding-left:="" 30px;="">鿴ϸϢ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}" target="_blank">{$site_url}/index.php?act=store&amp;op=show_order&amp;order_id={$order_id}</a></p>\r\n<p style="" padding-left:="" 30px;="">鿴Ķбҳ</p>\r\n<p style="" padding-left:="" 30px;=""><a href="{$site_url}/index.php?act=store&amp;op=store_order" target="_blank">{$site_url}/index.php?act=store&amp;op=store_order</a></p>\r\n<p style="text-align: right;" text-align:="" right;="">{$site_name}</p>\r\n<p style="text-align: right;" text-align:="" right;="">{$mail_send_time}</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[û]</strong>û޸ʼ֪ͨ', '{$site_name}:{$user_name}޸', 'email_touser_find_password', '<p>𾴵{$user_name}:</p>\r\n<p>, ղ{$site_name}룬Ϊ<span style="color:#ff9900;">{$new_password}</span></p>\r\n<p><a href="{$site_url}" target="_blank">{$site_url}</a>¼޸롣</p>\r\n<p style="text-align:right;">{$site_name}</p>\r\n<p style="text-align:right;">{$mail_send_time}</p>', 0, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>̱Աرʱ֪ͨ', NULL, 'msg_toseller_store_closed_notify', 'ĵѱرգԭǣ{$reason}', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>̹ڱԶرʱ֪ͨ', NULL, 'msg_toseller_store_expired_closed_notify', 'ĵѱرգԭǣѵ', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>ƷԱɾʱ֪ͨ', NULL, 'msg_toseller_goods_droped_notify', 'ԱɾƷ{$goods_name}\\r\\nԭǣ{$reason}', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>Ʒͨʱ֪ͨ', NULL, 'msg_toseller_brand_passed_notify', 'ϲƷ {$brand_name} ͨˡ', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>Ʒ뱻ܾʱ֪ͨ', NULL, 'msg_toseller_brand_refused_notify', 'ǸƷ {$brand_name} ѱܾԭ£\\r\\n{$reason}', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>̱Աɾʱ֪ͨ', NULL, 'msg_toseller_store_droped_notify', 'ĵѱɾ', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>뱻ͨʱ֪ͨ', NULL, 'msg_toseller_store_passed_notify', 'ϲĵѿͨϿûķƷɡ', 1, 0);
INSERT INTO `#__mail_msg_temlates` (`name`, `title`, `code`, `content`, `type`, `mail_switch`) VALUES('<strong>[]</strong>뱻ܾʱ֪ͨ', NULL, 'msg_toseller_store_refused_notify', 'ǸĿѱܾԭ£ {$reason}', 1, 0);

INSERT INTO `#__navigation` (`nav_id`, `nav_type`, `nav_title`, `nav_url`, `nav_location`, `nav_new_open`, `nav_sort`, `item_id`) VALUES(6, 0, 'ShopNC', 'index.php?act=article&article_id=22', 2, 0, 255, 0);
INSERT INTO `#__navigation` (`nav_id`, `nav_type`, `nav_title`, `nav_url`, `nav_location`, `nav_new_open`, `nav_sort`, `item_id`) VALUES(7, 0, 'ϵ', 'index.php?act=article&article_id=23', 2, 0, 240, 0);
INSERT INTO `#__navigation` (`nav_id`, `nav_type`, `nav_title`, `nav_url`, `nav_location`, `nav_new_open`, `nav_sort`, `item_id`) VALUES(8, 0, '', 'index.php?act=article&article_id=25', 2, 0, 220, 0);
INSERT INTO `#__navigation` (`nav_id`, `nav_type`, `nav_title`, `nav_url`, `nav_location`, `nav_new_open`, `nav_sort`, `item_id`) VALUES(9, 0, 'ƸӢ', 'index.php?act=article&article_id=24', 2, 0, 210, 0);

INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (1, 'رƼ', 'best_item', 'ƷҳرƼʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (2, 'Ů', 'clothing_item', 'ƷҳŮʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (3, 'Ь', 'ornament_item', 'ƷҳЬʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (4, 'ױ', 'cosmetic_item', 'Ʒҳױʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (5, '˶', 'sports_item', 'Ʒҳ˶ʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (6, 'ҵ', 'electron_item', 'Ʒҳҵʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (7, 'ҾӼװ', 'furniture_item', 'ƷҳļҾӼװʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (8, 'ʳƷ', 'food_item', 'ƷҳʳƷʾ', NULL);
INSERT INTO `#__recommend` (`recommend_id`, `recommend_name`, `recommend_code`, `recommend_desc`, `recommend_config`) VALUES (9, 'ĸӤƷ', 'gravida_item', 'ƷҳĸӤƷʾ', NULL);

INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(1, 'Ůװ', 1, 'װ', 0, 0, 1, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(2, 'Ь', 0, '', 0, 0, 2, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(3, 'ױ', 0, '', 0, 0, 3, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(4, 'ҵ', 0, '', 0, 0, 5, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(5, 'ҾӼװ', 0, '', 0, 0, 6, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(6, 'ʳƷ', 0, '', 0, 0, 7, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(7, 'ĸӤƷ', 0, '', 0, 0, 8, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(8, '˶', 0, '', 0, 0, 4, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(9, 'Ļ', 0, '', 0, 0, 9, 1, 0);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(10, '', 0, '', 0, 0, 10, 1, 0);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(11, 'Ʊ', 0, '', 0, 0, 11, 1, 0);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(12, 'Ůװ', 1, 'װ', 0, 1, 255, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(13, 'װ', 1, 'װ', 0, 1, 255, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(14, '/˯', 1, 'װ', 0, 1, 255, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(15, '޷', 1, 'װ', 0, 13, 255, 1, 1);
INSERT INTO `#__goods_class` (`gc_id`, `gc_name`, `type_id`, `type_name`, `store_id`, `gc_parent_id`, `gc_sort`, `gc_show`, `gc_index_show`) VALUES(16, '', 1, 'װ', 0, 12, 255, 1, 1);

INSERT INTO `#__type` (`type_id`, `type_name`, `type_sort`) VALUES(1, 'װ', 1);
INSERT INTO `#__type` (`type_id`, `type_name`, `type_sort`) VALUES(2, 'Ь', 2);
INSERT INTO `#__type` (`type_id`, `type_name`, `type_sort`) VALUES(3, '', 3);
INSERT INTO `#__type` (`type_id`, `type_name`, `type_sort`) VALUES(4, '', 4);
INSERT INTO `#__type` (`type_id`, `type_name`, `type_sort`) VALUES(5, '', 1);

INSERT INTO `#__spec` (`sp_id`, `sp_name`, `sp_format`, `sp_value`, `sp_sort`) VALUES(1, 'ɫ', 'image', 'ɫ,ɫ,ɫ,ɫ,ɫ,ɫ,ɫ,ɫ,ɫ,ɫ,ɫ,͸', 1);
INSERT INTO `#__spec` (`sp_id`, `sp_name`, `sp_format`, `sp_value`, `sp_sort`) VALUES(2, '', 'text', 'XXS,XS,S,M,L,XL,XXL,XXXL,ӴXXXL,', 2);
INSERT INTO `#__spec` (`sp_id`, `sp_name`, `sp_format`, `sp_value`, `sp_sort`) VALUES(3, 'Ь', 'text', '35,45,44,43,42,41,40,39,38,37,36,46', 3);

INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(1, 'ɫ', 1, 'c53bca14dc85bb3af17d8fe91b34e4b2.png_small.png', 0);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(2, 'ɫ', 1, 'ec769a6ddb0704a805bfe5f4b917dbfc.png_small.png', 1);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(3, 'ɫ', 1, '7e79c94b506b4f26064c5ad9cf415d6a.png_small.png', 2);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(4, 'ɫ', 1, '36dffaac297ed95204d5a5e7ffc9cfc0.png_small.png', 3);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(5, 'ɫ', 1, 'cd0a502349ba45ff6e57a9c56faead64.png_small.png', 4);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(6, 'ɫ', 1, '51e66b9e43213cc8eddf6038477dc0ea.png_small.png', 5);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(7, 'ɫ', 1, '17cac2d3e7c5f7a3d258912287c86cf5.png_small.png', 6);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(8, 'ɫ', 1, 'dd12d18ad6d68331149083265ee225f9.png_small.png', 7);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(9, 'ɫ', 1, '9984776d635bd493b9b83a59712283e2.png_small.png', 8);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(10, 'ɫ', 1, '27f09f244c0aea8157d81e9f59e3a2ed.png_small.png', 9);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(11, 'ɫ', 1, 'b700b535d2995468263e92541e2f74c9.png_small.png', 10);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(12, '͸', 1, '81416e9137b049dc494fbc21e18aac58.png_small.png', 11);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(13, 'XXS', 2, '', 1);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(14, 'XS', 2, '', 2);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(15, 'S', 2, '', 3);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(16, 'M', 2, '', 4);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(17, 'L', 2, '', 5);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(18, 'XL', 2, '', 6);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(19, 'XXL', 2, '', 7);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(20, 'XXXL', 2, '', 8);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(21, 'ӴXXXL', 2, '', 9);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(22, '', 2, '', 10);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(23, '35', 3, '', 1);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(24, '36', 3, '', 2);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(25, '37', 3, '', 3);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(26, '38', 3, '', 4);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(27, '39', 3, '', 5);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(28, '40', 3, '', 6);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(29, '41', 3, '', 7);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(30, '42', 3, '', 8);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(31, '43', 3, '', 9);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(32, '44', 3, '', 10);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(33, '45', 3, '', 11);
INSERT INTO `#__spec_value` (`sp_value_id`, `sp_value_name`, `sp_id`, `sp_value_image`, `sp_value_sort`) VALUES(34, '46', 3, '', 12);

INSERT INTO `#__type_spec` (`type_id`, `sp_id`) VALUES(1, 1);
INSERT INTO `#__type_spec` (`type_id`, `sp_id`) VALUES(1, 2);
INSERT INTO `#__type_spec` (`type_id`, `sp_id`) VALUES(2, 3);
INSERT INTO `#__type_spec` (`type_id`, `sp_id`) VALUES(2, 1);
INSERT INTO `#__type_spec` (`type_id`, `sp_id`) VALUES(3, 1);

INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(4, 'װЬ', 0, 1);
INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(13, 'Ůװ', 4, 2);
INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(14, 'װ', 4, 2);
INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(15, 'ŮЬ', 4, 3);
INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(16, '˶Ь', 4, 4);
INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(17, 'Ь/ƤЬ/Ь', 4, 5);
INSERT INTO `#__store_class` (`sc_id`, `sc_name`, `sc_parent_id`, `sc_sort`) VALUES(18, '˶/˶/', 4, 6);

INSERT INTO `#__inform_subject_type` (`inform_type_id`, `inform_type_name`, `inform_type_desc`, `inform_type_state`) VALUES (1, '۽Ʒ', '̳ǽֹƽ׹涨Ʒ', 1);

INSERT INTO `#__inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (1, 'Ƶߡࡢ', 1, '۽Ʒ', 1);
INSERT INTO `#__inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (2, 'Ĳþ', 1, '۽Ʒ', 1);
INSERT INTO `#__inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (3, 'ǹ֧ҩ', 1, '۽Ʒ', 1);
INSERT INTO `#__inform_subject` (`inform_subject_id`, `inform_subject_content`, `inform_subject_type_id`, `inform_subject_type_name`, `inform_subject_state`) VALUES (4, 'Ʒ', 1, '۽Ʒ', 1);

INSERT INTO `#__complain_subject` (`complain_subject_id`, `complain_subject_content`, `complain_subject_desc`, `complain_subject_type`, `complain_subject_state`) VALUES (7, 'δյ', '׳ɹδյǮѾңɽάȨ', 1, 1);
INSERT INTO `#__complain_subject` (`complain_subject_id`, `complain_subject_content`, `complain_subject_desc`, `complain_subject_type`, `complain_subject_state`) VALUES (8, 'ۺϷ', 'ɺ30ڣʹƷУƷ޷ʹãɽάȨ', 1, 1);
INSERT INTO `#__complain_subject` (`complain_subject_id`, `complain_subject_content`, `complain_subject_desc`, `complain_subject_type`, `complain_subject_state`) VALUES (9, 'δյ', 'ѾδյƷѾĸңɽάȨ', 2, 1);

INSERT INTO `#__voucher_price` (`voucher_price_id`, `voucher_price_describe`, `voucher_price`) VALUES (1, '10Ԫ', 10);
INSERT INTO `#__voucher_price` (`voucher_price_id`, `voucher_price_describe`, `voucher_price`) VALUES (2, '50Ԫ', 50);

INSERT INTO `#__store_grade` (`sg_id`, `sg_name`, `sg_goods_limit`, `sg_space_limit`, `sg_template_number`, `sg_template`, `sg_price`, `sg_confirm`, `sg_description`, `sg_function`, `sg_sort`) VALUES(1, 'ϵͳĬ', 100, 100, 6, 'default|style1|style2|style3|style4|style5', '100Ԫ/', 0, 'ûѡĬϵȼͨ', 'groupbuy', 0);
INSERT INTO `#__store_grade` (`sg_id`, `sg_name`, `sg_goods_limit`, `sg_space_limit`, `sg_template_number`, `sg_template`, `sg_price`, `sg_confirm`, `sg_description`, `sg_function`, `sg_sort`) VALUES(2, '׽', 200, 100, 6, 'default|style1|style2|style3|style4|style5', '100Ԫ/', 1, 'ܸȨ', 'groupbuy', 2);

INSERT INTO `#__document` (`doc_id`, `doc_code`, `doc_title`, `doc_content`, `doc_time`) VALUES(1, 'agreement', 'ûЭ', '<p>رûĶûЭ顷(³ơЭ顷) иܱЭ顷ȨʹñվṩطʹΪΪԱЭ顷ĽܣܱͬЭ顷Լ <br /> <br /> <strong>һ</strong><br /></p>\r\n<ol>\r\n<li>"û"ָϱЭ涨ͬرվֹڱЭ飩ʹñվĸ˻</li>\r\n<li>""ָڱվϳƷû""ָڱվƷû</li>\r\n<li>"ɽ"ָҸǵĽҪضʱŵĽȡýƷȨ</li>\r\n</ol>\r\n<p><br /> <br /> <strong>ûʸ</strong><br /> <br /> ֻз֮һԱʵΪվûʹñվķ</p>\r\n<ol>\r\n<li>ʮ꣬ȨΪȻˣ</li>\r\n<li>δʮ꣬໤ˣڸĸͬȻˣ</li>\r\n<li>йɻطɡ/³ϷڵĹ˾ҵλ֯֯</li>\r\n</ol>\r\n<p><br /> ΪˡΪԼ޾ӪضӪʸ֯עΪվû򳬹ȨΪΧ½׵ģ뱾վ֮ЭʼЧվһ֣Ȩעû׷ʹñվ""һзΡ<br /> <br /> <strong>.ûȨ</strong><br /></p>\r\n<ol>\r\n<li>ûȨݱЭĹ涨վعñվϽƽ̨¼ƷϢѯƷϢƷûƷͬڱվμӱվйػȨܱվṩйѶϢ</li>\r\n<li>ûȨҪͽ롣ûӦԸûел¼ȫΡ</li>\r\n<li>ûȷվṩκϡעϢʵ׼ȷʵ֤šϵ绰ַȡ֤վûͨϵʽԼϵͬʱûҲʵʱʱʱйעϡ</li>\r\n<li>ûκʽתûȨʹԼڱվûʺš</li>\r\n<li>ûȷڱվϽƽ̨ϵ¼ƷĽϢʵ׼ȷԡ</li>\r\n<li>ûڱվϽƽ̨ҽֹ۵Ļ۵Ʒַ֪ʶȨϷȨƷҲΥṫ򹫹µƷ</li>\r\n<li>ûڱվΥΥϢƷϢϢӡƷԣԣݵȡ</li>\r\n<li>ûڱվӦسʵԭ򣬲ԸԤƷ۸ȲʽϽ򣬲ôϽ޹صĲΪڽƽ̨ϷκΥϢ</li>\r\n<li>ûӦȡֶΣٽסȷʽöȣòֶζûûöȡ</li>\r\n<li>ûŵԼʹñվϽƽ̨ʵʩΪعҷɡͱվع涨Լṫ򹫹¡κηɺķûԼеӦķΡ</li>\r\n<li>ûڱվϽ׹ûײףվЭû緢ûΥΥЭΪվٱûϽûϵģûȨͨ˾Ҫվṩϡ</li>\r\n<li>ûӦгеײطã˰</li>\r\n<li>δվûýվԼڽƽ̨չʾκϢԸơ޸ġʽƷַ򹫿չʾ</li>\r\n<li>ûͬԱվϢڻϢϢϢȡ</li>\r\n</ol>\r\n<p><br /> <br /> <strong>ġ վȨ</strong><br /></p>\r\n<ol>\r\n<li>վǴͳϵ""ΪûṩһϢƷƽ̨䵱˫֮Ľý飬Ĵ̡ϻ  ˡԱȾӪϵˡڱվϵĽƷûϴн׵ƷǱվСûƷṩϢ뾺Ḷ́  վԼӻƣ಻ƷĽ׹̣͡˿覴õҲеƷƷʡȨϵ覴Լ  нЭκΣڳϵƷƷʡȫԻϷԣվ豣֤</li>\r\n<li>վмˮƽĻŬȷϽƽ̨Ужϻжʱʱڣ֤ûϽ׻˳С</li>\r\n<li>վûעʹñվϽƽ̨⼰ӳʱظ </li>\r\n<li>վȨûעϽвģԴκɵעϣվȨ֪ͨѯûҪûֱ͡ɾȴ</li>\r\n<li>  ڱվϽû׵ģûͨ˾ŻշҪվṩϣվϲṩйϣû  ׸֪վվ֪Ϥģ˺󣬱վȨͨʼ绰ϵ˫˽˽ͨʼ֪ͨ   </li>\r\n<li>Ͻƽ̨ԣվûûעϡеĽΪԼ뽻йص飬緢ΣվȨûĻûʵйϡ֪ͨʱֹڵֹܾûṩ         \r\n<ul>\r\n<li>ûΥЭἰ뱾Эļ</li>\r\n<li>û֪ͨվΪĳû彻Υ򲻵Ϊṩ֤ݣվ޷ϵû֤֤ûվṩκϣ</li>\r\n<li>û֪ͨվΪĳû彻Υ򲻵Ϊṩ֤ݡվͨרҵߵ֪ʶˮƽ׼ݽб𣬿ΪЩݻΪܶԱվûվɲʧΡ </li>\r\n</ul>\r\n</li>\r\n<li>ڷթжУűûԭ򣬵ûٱԼ׿ܴթʱվȨͨжʱû˺ţȨ˶ԵϼҪṩ֤ϡ</li>\r\n<li>ݹҷɷ桢Эݺͱվյʵݣ϶ûΥΥЭΪԼڱվƽ̨ϵΪվȨڱվƽ̨վ緢ʽûΥΪȨʱɾϢûͬ⡣</li>\r\n<li>  վȨڲ֪ͨûǰɾȡԴʩϢԹܷΪĿģԳΪĿģթȶݣ  Ͻ޹ػԽΪĿģڶ⾺ۻͼأϢΥ𺦱վûϷġ</li>\r\n<li>  豾վҵġȫͨõġõġѵϢʹȨվȨԸȨȨȨվȨ(ȫ򲿷ݵ)  ʹáơ޶д롢ִַкչʾûʾվĸϢƷ֪պ󿪷κʽý  ϢƷڡ</li>\r\n</ol>\r\n<p><br /> <br /> <strong>塢жϺֹ</strong><br /></p>\r\n<ol>\r\n<li>  վδûȡطõ£վȫȨκ  (ڱվΪûΥЭ;񣬻ûڳ180δ¼վ)  ֹûķ񣬲ٱûڱվȫϣûϢƷϢϢȣͬʱվȫȨڷ֪ͨ򲻷ͨ  ֪£ʱֹͣṩȫ򲿷ַ񡣷ֹ󣬱վûΪûԭûϻ֮صκϢתκδĶ͵Ϣû  ⣬վֹûķûκεеκΡ </li>\r\n<li>ûվעվעûݣ辭վͬ⣬ɱվעעûû뱾վЭϵվԱȨ         \r\n<ul>\r\n<li>ûע󣬱վȨû,ǰûϡϡƷϺͽ׼¼ȡ </li>\r\n<li>ûעûעǰڱվƽ̨ϴΥΪΥЭΪվԿʹЭ涨Ȩ </li>\r\n</ul>\r\n</li>\r\n<li>վͨעûķʽֹ         \r\n<ul>\r\n<li>ûΥЭع涨ʱվȨֹûṩ񡣱վжϷʱ֪ͨûûڱվֹṩһֱӻӻעΪվûģվȨٴεֹΪûṩ</li>\r\n<li>һվûעҪٵģվȨʱֹΪûṩ </li>\r\n<li>ЭֹʱûδȷµЭġ </li>\r\n<li>վΪֹ </li>\r\n</ul>\r\n</li>\r\n<li>ûΥطɷΥЭ涨ԭʹվжϡֹûģڷжϡֹ֮ǰûΪԭ         \r\n<ul>\r\n<li>վȨǷжϡֹûǰûжϻֹԭ֪ͨû׹ϵڶԸýδɽ׵û,ý׾۵ûѴɽҪԼû</li>\r\n<li>жϡֹ֮ǰûѾϴվƷδ׻δɵģվȨжϡֹͬʱɾƷϢ </li>\r\n<li>жϡֹ֮ǰûѾû۵ľƷҪԼδվȨжϻֹͬʱɾûҪԼϢ</li>\r\n</ul>\r\n</li>\r\n<li>վûΪڿǵƷڱվȣֺ˵ȨΥع涨ܵ׷ܻܵصĴʱûӦ⳥վһʧá</li>\r\n<li>ΥطɷΥЭ涨صûվȨֹû</li>\r\n</ol>\r\n<p><br /> <br /> <strong>Э޶</strong><br /> <br /> Эɱվʱ޶޶Э鹫ڱվ֮ϣ޶ԹʱЧΪЭһ֡ûڱЭ޸֮ԼʹñվΪûܺԸ޶Э顣վʹ޸ĻжϷʱκε<br /> <br /> <strong>ߡ վηΧ </strong><br /> <br /> ûܸЭʱûӦȷ˽Ⲣͬ</p>\r\n<ol>\r\n<li>ǷɱվػȡκϣûпǡԸգκ϶ûϵͳκ𻵻ʧûӦȫΡ</li>\r\n<li>ûɱվȡõĽѶʽ֣ɱЭδʾ涨κα֤</li>\r\n<li>ԭɵʹáʧʧվеκֱӡӡرԻͷ⳥ʹվѱ֪ǰ⳥Ŀԣ         \r\n<ul>\r\n<li>վʹû޷ʹá</li>\r\n<li>ɻͨվȡõκƷ֮Ϣн֮ƷĹɱ</li>\r\n<li>ûĴ⵽δȨĴȡ</li>\r\n<li>վκε֮Ϊ</li>\r\n<li>վˡ</li>\r\n</ul>\r\n</li>\r\n<li>վֻΪûṩһ׵ƽ̨ûǵĽƷĺϷԡʵԼƷʣԼûн׵ȣվһɲκεΡûʹñվ򿯵ڱվκƷʱվκβ⳥Ρ</li>\r\n<li>  վṩϵվԴӣûܻӪ̾ӪվʾվЩӪκιϵӪ̾Ӫվ  ɸӪи𣬲ڱվƼΧ֮ڡڴڻԴڴվԴκݡ桢Ʒϣվ಻豣֤ʹ  ûκδվԴĻɴվԴõκݡƷκ𺦻ʧվκֱӻӵΡ</li>\r\n</ol>\r\n<p><br /> <br /> <strong>.ɿ</strong><br /> <br /> 򲻿ɿ¼ʹñЭвܡҪģ˫еΡ֮ͬɿָԤܱⲢܿ˷  ͹ս̨硢ˮ֡֡׻𡢰չڿ͹粡ŲżơΪκȻ  Ϊɵѵȿ͹<br /> <br /> <strong>šʽ</strong><br /></p>\r\n<ol>\r\n<li>Э鼰޶Чԡк뱾Э鼰޶Чйصˣл񹲺͹ɹϽκл񹲺͹ɡ</li>\r\n<li>  ʹñվ뱾վκ飬ӦύٲίԱᰴոûʱЧٲùٲáӦٲãκ  ٲкϲٲòþվ֣ԸԼ漰鲻ٲýûͬһԺϽ</li>\r\n</ol>', 1293773586);
INSERT INTO `#__document` (`doc_id`, `doc_code`, `doc_title`, `doc_content`, `doc_time`) VALUES(2, 'real_name', 'ʲôʵ֤', '<p><strong>ʲôʵ֤</strong></p>\r\n<p>&ldquo;֤&rdquo;һԵʵʶ񡣵ͨվPM绰ԱEMailķʽ ϵ֤Աȷ˵ʵݣͿԿ֤ͨ</p>\r\n<p>֤ͨ˵ݵʵЧԣΪ罻׵Ĺṩһĺͱ֤</p>\r\n<p><strong>֤ķʽ</strong></p>\r\n<p>EmailXXXX@XX.com</p>\r\n<p>ԱXXXXXX</p>', 1293773817);
INSERT INTO `#__document` (`doc_id`, `doc_code`, `doc_title`, `doc_content`, `doc_time`) VALUES(3, 'real_store', 'ʲôʵ֤', '<p><strong>ʲôʵ֤</strong></p>\r\n<p>&ldquo;֤&rdquo;һԵʵʶ񡣵ͨվPM绰ԱEMailķʽ ϵ֤Աȷ˵ʵݣͿԿ֤ͨ</p>\r\n<p>֤ͨ˵ݵʵЧԣΪ罻׵Ĺṩһĺͱ֤</p>\r\n<p><strong>֤ķʽ</strong></p>\r\n<p>EmailXXXX@XX.com</p>\r\n<p>ԱXXXXXX</p>', 1293773875);
INSERT INTO `#__document` (`doc_id`, `doc_code`, `doc_title`, `doc_content`, `doc_time`) VALUES(4, 'open_store', 'Э', '<p>ʹñ˾ص<br /><br />1.ûʸ<br />˾ķ÷ܹǩзԼĺͬĸṩʹáڲǰ涨ǰ£˾ķ18»ʱֹûṩʸʹñ˾ķ񡣴⣬ʻۣûתûۡ⣬˾ԸֹֹʻȨ<br /><br />2.ϣӵκƷã<br />*թԡ١׼ȷԣ<br />*ַκεȨרȨ̱ȨҵܻרȨ򷢱Ȩ˽Ȩ<br />*Υκõķɻ򷨹棨йسڹơ̷߱ӻó׹/ƽó׷ɵķɻ򷨹棩<br />*߷̰ˣֺ˺ϷȨݣ<br />*ࡢɫ顢Ĳɱֲ߽ݣ<br />*ƻı䡢ɾӰ졢ܽȡδȨӴκϵͳݻϵκβľ桢ʱըɾӬڲʵԳ<br /><br />3.ΥԼ<br />緢Σ˾ĻɾƷ򱾹˾йΪľ桢֪ͨʱֹڵֹֹûʸ񼰾ܾṩ<br />(a)ΥЭ뱾Эļ<br />(b)˾޷֤֤򱾹˾ṩκϣ<br />(c)˾Ϊܶ˾û򱾹˾ʧΡ<br /><br />4.<br />˾˾Ĺ˾ʵ򱾹˾ĹӦκ¾򱾹˾վ˾ķЭ֮йصʧκر𡢼ӻԵ𺦣ԺַʽеκΡͬΪ֮ϷԵеΡͬ⣬˾ͱ˾й˾ʵԱ˾ûΪĺϷԼκνеΡ<br /><br />5.޴ϵ<br />ûͱ˾ǶĺͬЭ⽨ҲûдκδϻӪԱӪϵ˾ҲκûϽΪʾĬƼŵ򵣱<br /><br />6.һ涨<br />Эзл񹲺͹ɹϽЭĹ涨ǿɷָģ籾Эκι涨öΪЧ򲻿ִУù涨ɱɾӦִС</p>', 1293773901);
INSERT INTO `#__document` (`doc_id`, `doc_code`, `doc_title`, `doc_content`, `doc_time`) VALUES(5, 'groupbuy', 'ŹЭ', '<p>\r\n	һŹȨȨ鱾˾\r\n</p>\r\n<p>\r\n	˾ȨڱҪʱ޸ıЭ飬ЭһҳϹͬĶݣӦֹͣʹŹʹ÷ΪܱЭı\r\n</p>\r\n<p>\r\n	緢κһΣ˾Ȩжϻֹṩķ֪ͨ\r\n</p>\r\n1 ṩĸϲʵ<br />\r\n2ΥЭĹ涨<br />\r\n3 ܲŵļҪ<br />\r\n4˾ΪΪΥŹʻΡ\r\n<p>\r\n	ġܱЭ涨˾ȻʱֹЭ顣\r\n</p>\r\n<p>\r\n	塢˾ֹЭȨ˾ӵеڱЭֹǰΥЭ򱾹˾ӦеκȨ\r\n</p>\r\n<p>\r\n	Ⲣȫܣ˾ȨжŹԴߴ\r\n</p>', 1328580944);
