<?php
/*
EMS SHIPPING 
designed by www.oscommerce.com.cn
ver 1.0
2009-7-28
*/
 class ems {
   var $code, $title, $description, $enabled, $num_zones;

// class constructor
   function ems() {
     $this->code = 'ems';
     $this->title = MODULE_SHIPPING_EMS_TEXT_TITLE;
     $this->description = MODULE_SHIPPING_EMS_TEXT_DESCRIPTION;
     $this->sort_order = MODULE_SHIPPING_EMS_SORT_ORDER;
     $this->icon = '';//'images/ems_icon.gif';
     $this->tax_class = MODULE_SHIPPING_EMS_TAX_CLASS;
     $this->enabled = ((MODULE_SHIPPING_EMS_STATUS == 'True') ? true : false);

     // CUSTOMIZE THIS SETTING FOR THE NUMBER OF ZONES NEEDED
     $this->num_zones = 8;
   }

// class methods
   function quote($method = '') {
     global $order, $cart, $_POST;
	 
     if (is_numeric($_POST['country'])){
      $country_array = tep_get_countries($_POST['country'],true); 
      $order->delivery['country']['iso_code_2'] = $country_array['countries_iso_code_2'];
      $order->delivery['country']['title'] = $country_array['countries_name'];
     }
     elseif($order->delivery['country']['title']==''){
      $country_array = tep_get_countries(STORE_COUNTRY,true); 
      $order->delivery['country']['iso_code_2'] = $country_array['countries_iso_code_2'];
      $order->delivery['country']['title'] = $country_array['countries_name'];
     }
	 
     $dest_country = $order->delivery['country']['iso_code_2'];
     $dest_zone = 0;
     $error = false;

    for ($i=1; $i<=$this->num_zones; $i++) {
       $countries_table = constant('MODULE_SHIPPING_EMS_COUNTRIES_' . $i);
       $country_zones =  preg_split("/[,]/", $countries_table);
       if (in_array($dest_country, $country_zones)&&(tep_not_null($dest_country))) {
         $dest_zone = $i;
         break;
       }
     }
					
					if ($dest_zone == 0) {
       $dest_zone = $this->num_zones;    //if not set the default
     }
	    
  // pre data
	 $total_weight = $cart->show_weight();

	 
	 //echo $dest_zone ;
     $base_weight = MODULE_SHIPPING_EMS_START_WEIGHT;
     $over_weight = MODULE_SHIPPING_EMS_OVER_WEIGHT;
     $zones_cost = constant('MODULE_SHIPPING_EMS_COST_' . $dest_zone);
     $zones_over_cost = constant('MODULE_SHIPPING_EMS_OVER_COST_' . $dest_zone);

    //calculate  
	 $shipping_cost = 0;
	 if($total_weight<=MODULE_SHIPPING_EMS_START_WEIGHT){
	  $shipping_cost = $zones_cost;
	 }
	 else{ //
	  $shipping_cost = $zones_cost + ceil(($total_weight-$base_weight)/$over_weight)*$zones_over_cost;
	 }
	 
     $shipping_method = MODULE_SHIPPING_EMS_TEXT_WAY.' <i>'.$order->delivery['country']['title'].' ('.$total_weight.MODULE_SHIPPING_EMS_UNIT.')</i>  '.MODULE_SHIPPING_EMS_TIME;
     $this->quotes = array('id' => $this->code,
                           'module' => MODULE_SHIPPING_EMS_SHOW_NAME,
                           'methods' => array(array('id' => $this->code,
                                                    'title' => $shipping_method,
                                                    'cost' => $shipping_cost)));

     if ($this->tax_class > 0) {
       $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
     }

     if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title,'','',' align="absmiddle"');

     if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_EMS_UNDEFINED_RATE;

     return $this->quotes;
   }

   function check() {
     if (!isset($this->_check)) {
       $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_EMS_STATUS'");
       $this->_check = tep_db_num_rows($check_query);
     }
     return $this->_check;
   }

   // elari - Added to select default country if not in listing
   function install() {
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable World Zones Method', 'MODULE_SHIPPING_EMS_STATUS', 'True', 'Do you want to offer world zone rate shipping?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Method Show Name', 'MODULE_SHIPPING_EMS_SHOW_NAME', 'World Express', 'Set the display name of this method.', '6', '0', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Calculate Method', 'MODULE_SHIPPING_EMS_UNIT', 'g', 'Set the Unit if the weight.', '6', '0', 'tep_cfg_select_option(array(\'g\', \'Kg\',\'Pound\'), ', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Tax Class', 'MODULE_SHIPPING_EMS_TAX_CLASS', '0', 'Use the following tax class on the shipping fee.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort Order', 'MODULE_SHIPPING_EMS_SORT_ORDER', '0', 'Sort order of display.', '6', '0', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Shipping Time', 'MODULE_SHIPPING_EMS_TIME', '7-15 Days', 'Set the time of this method', '6', '0', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Base Units', 'MODULE_SHIPPING_EMS_START_WEIGHT', '500', 'Set the base weight of this shipping method', '6', '0', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Over Per Unit', 'MODULE_SHIPPING_EMS_OVER_WEIGHT', '500', 'Set the over weight of this shipping method.', '6', '0', now())");
//Alane - end percent mod
     for ($i = 1; $i <= $this->num_zones; $i++) {
        $default_countries = '';
		$shipping_fee ='';
		$over_fee = '';
       if ($i == 1) {
         $default_countries = 'US,CA';
         $shipping_fee = '28';
		 $over_fee = '10';
       }
       if ($i == 2) {
         $default_countries = 'AT,BE,GB,DE,FR,GL,IS,IE,IT,NO,DK,PL,ES,SE,CH,FI,PT,IL,GR,NL';
         $shipping_fee = '35';
		 $over_fee = '12';
       }
       if ($i == $this->num_zones) {
         $default_countries = 'All Others'; // this must be the lastest zone
         $shipping_fee = '40';
		 $over_fee = '15';
       }
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('<br>Zone " . $i ." Countries<hr><A HREF=\"country_list.php\" TARGET=\"_blank\" ONCLICK=\"window.open(\'country_list.php\', \'Valid_Categories\', \'scrollbars=yes,resizable=yes,menubar=yes,width=400,height=400\'); return false\">View</A>', 'MODULE_SHIPPING_EMS_COUNTRIES_" . $i ."', '" . $default_countries . "', 'Comma separated list of two character ISO country codes that are part of Zone " . $i . ".', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone " . $i ." Shipping Base Fee', 'MODULE_SHIPPING_EMS_COST_" . $i ."', '" . $shipping_fee . "', 'Shipping rates to Zone " . $i . "Base hipping cost for Zone " . $i . " destinations.', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Zone " . $i ." Over Weight Fee', 'MODULE_SHIPPING_EMS_OVER_COST_" . $i ."', '".$over_fee."', 'Over Fee for this shipping zone', '6', '0', now())");
     }
   }
   // elari - Added to select default country if not in listing

   function remove() {
     tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
   }

   function keys() {
     $keys = array('MODULE_SHIPPING_EMS_STATUS', 'MODULE_SHIPPING_EMS_TAX_CLASS', 'MODULE_SHIPPING_EMS_SORT_ORDER', 'MODULE_SHIPPING_EMS_SHOW_NAME','MODULE_SHIPPING_EMS_TIME','MODULE_SHIPPING_EMS_UNIT','MODULE_SHIPPING_EMS_START_WEIGHT','MODULE_SHIPPING_EMS_OVER_WEIGHT');

     for ($i=1; $i<=$this->num_zones; $i++) {
       $keys[] = 'MODULE_SHIPPING_EMS_COUNTRIES_' . $i;
       $keys[] = 'MODULE_SHIPPING_EMS_COST_' . $i;
       $keys[] = 'MODULE_SHIPPING_EMS_OVER_COST_' . $i;
     }

     return $keys;
   }
 }
?>