<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magentocommerce.com for more information.
 *
 * @category    Mage
 * @package     Mage_Catalog
 * @copyright   Copyright (c) 2010 Magento Inc. (http://www.magentocommerce.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */


/**
 * Catalog entity setup
 *
 * @category   Mage
 * @package    Mage_Catalog
 * @author     Magento Core Team <core@magentocommerce.com>
 */
class Mage_Catalog_Model_Resource_Eav_Mysql4_Setup extends Mage_Eav_Model_Entity_Setup
{

    /**
     * Prepare catalog attribute values to save
     *
     * @param array $attr
     * @return array
     */
    protected function _prepareValues($attr)
    {
        $data = parent::_prepareValues($attr);
        $data = array_merge($data, array(
            'frontend_input_renderer'   => $this->_getValue($attr, 'input_renderer', ''),
            'source_model'              => $this->_getValue($attr, 'source', ''),
            'is_global'                 => $this->_getValue($attr, 'global', 1),
            'is_visible'                => $this->_getValue($attr, 'visible', 1),
            'is_searchable'             => $this->_getValue($attr, 'searchable', 0),
            'is_filterable'             => $this->_getValue($attr, 'filterable', 0),
            'is_comparable'             => $this->_getValue($attr, 'comparable', 0),
            'is_visible_on_front'       => $this->_getValue($attr, 'visible_on_front', 0),
            'is_wysiwyg_enabled'        => $this->_getValue($attr, 'wysiwyg_enabled', 0),
            'is_html_allowed_on_front'  => $this->_getValue($attr, 'is_html_allowed_on_front', 0),
            'is_visible_in_advanced_search'
                                        => $this->_getValue($attr, 'visible_in_advanced_search', 0),
            'is_filterable_in_search'   => $this->_getValue($attr, 'filterable_in_search', 0),
            'used_in_product_listing'   => $this->_getValue($attr, 'used_in_product_listing', 0),
            'used_for_sort_by'          => $this->_getValue($attr, 'used_for_sort_by', 0),
            'apply_to'                  => $this->_getValue($attr, 'apply_to', ''),
            'position'                  => $this->_getValue($attr, 'position', 0),
            'is_configurable'           => $this->_getValue($attr, 'is_configurable', 1),
            'is_used_for_promo_rules'   => $this->_getValue($attr, 'used_for_promo_rules', 0)
        ));
        return $data;
    }

    /**
     * Enter description here...
     *
     * @return array
     */
    public function getDefaultEntities()
    {
        return array(
            'catalog_category' => array(
                'entity_model'      => 'catalog/category',
                'attribute_model'   => 'catalog/resource_eav_attribute',
                'table'             => 'catalog/category',
                'additional_attribute_table' => 'catalog/eav_attribute',
                'entity_attribute_collection' => 'catalog/category_attribute_collection',
                'attributes'        => array(
                    'name' => array(
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Name',
                        'input'             => 'text',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'is_active' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Is Active',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'eav/entity_attribute_source_boolean',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'url_key' => array(
                        'label'             => 'URL key',
                        'backend'           => 'catalog/category_attribute_backend_urlkey',
                        'required'          => false,
                    ),
                    'description' => array(
                        'type'              => 'text',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Description',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'wysiwyg_enabled'   => true,
                        'is_html_allowed_on_front' => true,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'image' => array(
                        'type'              => 'varchar',
                        //'backend'          => 'catalog/category_attribute_backend_image',
                        //'frontend'         => 'catalog/category_attribute_frontend_image',
                        'backend'           => 'catalog/category_attribute_backend_image',
                        'frontend'          => '',
                        'label'             => 'Image',
                        'input'             => 'image',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'meta_title' => array(
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Page Title',
                        'input'             => 'text',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'meta_keywords' => array(
                        'type'              => 'text',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Meta Keywords',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'meta_description' => array(
                        'type'              => 'text',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Meta Description',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'display_mode' => array(
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Display Mode',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/category_attribute_source_mode',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'landing_page' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'CMS Block',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/category_attribute_source_page',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'is_anchor' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Is Anchor',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'eav/entity_attribute_source_boolean',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),

                    'path' => array(
                        'type'              => 'static',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Path',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'position' => array(
                        'type'              => 'static',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Position',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'all_children' => array(
                        'type'              => 'text',
                        //'backend'          => 'catalog/entity_category_attribute_backend_tree_children',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => '',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'path_in_store' => array(
                        'type'              => 'text',
                        //'backend'           => 'catalog/entity_category_attribute_backend_tree_path',
                        'backend'           => '',
                        'frontend'          => '',
                        'table'             => '',
                        'label'             => '',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'children' => array(
                        'type'              => 'text',
                        //'backend'           => 'catalog/entity_category_attribute_backend_tree_children',
                        'frontend'          => '',
                        'table'             => '',
                        'label'             => '',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'url_path' => array(
                        'type'              => 'varchar',
                        'frontend'          => '',
                        'table'             => '',
                        'label'             => '',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => true,
                    ),
                    'custom_design'         => array(
                        'type'              => 'varchar',
                        'label'             => 'Custom Design',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'core/design_source_design',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'custom_design_apply' => array(
                        'type'              => 'int',
                        'label'             => 'Apply To',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'core/design_source_apply',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'custom_design_from' => array(
                        'type'              => 'datetime',
                        'label'             => 'Active From',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'date',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                    ),
                    'custom_design_to' => array(
                        'type'              => 'datetime',
                        'label'             => 'Active To',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'date',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                    ),
                    'page_layout' => array(
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Page Layout',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/category_attribute_source_layout',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'custom_layout_update' => array(
                        'type'              => 'text',
                        'label'             => 'Custom Layout Update',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'level' => array(
                        'type'              => 'static',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Level',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'children_count' => array(
                        'type'              => 'static',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Children Count',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'available_sort_by' => array(
                        'input'         => 'multiselect',
                        'type'          => 'text',
                        'label'         => 'Available Product Listing Sort By',
                        'source'        => 'catalog/category_attribute_source_sortby',
                        'backend'       => 'catalog/category_attribute_backend_sortby',
                        'required'      => true,
                        'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'       => true,
                        'input_renderer'=> 'adminhtml/catalog_category_helper_sortby_available',
                    ),
                    'default_sort_by' => array(
                        'input'         => 'select',
                        'label'         => 'Default Product Listing Sort By',
                        'source'        => 'catalog/category_attribute_source_sortby',
                        'backend'       => 'catalog/category_attribute_backend_sortby',
                        'required'      => true,
                        'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'       => true,
                        'input_renderer'=> 'adminhtml/catalog_category_helper_sortby_default',
                    ),
                ),
            ),
            'catalog_product' => array(
                'entity_model'      => 'catalog/product',
                'attribute_model'   => 'catalog/resource_eav_attribute',
                'table'             => 'catalog/product',
                'additional_attribute_table' => 'catalog/eav_attribute',
                'entity_attribute_collection' => 'catalog/product_attribute_collection',
                'attributes'        => array(
                    'name' => array(
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Name',
                        'input'             => 'text',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'used_in_product_listing' => true,
                        'used_for_sort_by' => true,
                        'unique'            => false,
                    ),
                    'description' => array(
                        'type'              => 'text',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Description',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => false,
                        'comparable'        => true,
                        'wysiwyg_enabled'   => true,
                        'is_html_allowed_on_front' => true,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'unique'            => false,
                    ),
                    'short_description' => array(
                        'type'              => 'text',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Short Description',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => false,
                        'comparable'        => true,
                        'wysiwyg_enabled'   => true,
                        'is_html_allowed_on_front' => true,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                    ),
                    'sku' => array(
                        'type'              => 'static',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'SKU',
                        'input'             => 'text',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => false,
                        'comparable'        => true,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'unique'            => true,
                    ),
                    'price' => array(
                        'group'             => 'Prices',
                        'type'              => 'decimal',
                        'backend'           => 'catalog/product_attribute_backend_price',
                        'frontend'          => '',
                        'label'             => 'Price',
                        'input'             => 'price',
                        'class'             => 'validate-number',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => true,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'used_in_product_listing' => true,
                        'used_for_sort_by' => true,
                        'unique'            => false,
                        'apply_to'          => 'simple,configurable,virtual',
                    ),
                    'special_price' => array(
                        'group'             => 'Prices',
                        'type'              => 'decimal',
                        'backend'           => 'catalog/product_attribute_backend_price',
                        'frontend'          => '',
                        'label'             => 'Special Price',
                        'input'             => 'price',
                        'class'             => 'validate-number',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                        'apply_to'          => 'simple,configurable,virtual',
                    ),
                    'special_from_date' => array(
                        'group'             => 'Prices',
                        'type'              => 'datetime',
                        'backend'           => 'catalog/product_attribute_backend_startdate',
                        'frontend'          => '',
                        'label'             => 'Special Price From Date',
                        'input'             => 'date',
                        'class'             => 'validate-date',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                        'apply_to'          => 'simple,configurable,virtual',
                    ),
                    'special_to_date' => array(
                        'group'             => 'Prices',
                        'type'              => 'datetime',
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                        'frontend'          => '',
                        'label'             => 'Special Price To Date',
                        'input'             => 'date',
                        'class'             => 'validate-date',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                        'apply_to'          => 'simple,configurable,virtual',
                    ),
                    'cost' => array(
                        'group'             => 'Prices',
                        'type'              => 'decimal',
                        'backend'           => 'catalog/product_attribute_backend_price',
                        'frontend'          => '',
                        'label'             => 'Cost',
                        'input'             => 'price',
                        'class'             => 'validate-number',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => true,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'apply_to'          => 'simple,virtual',
                    ),
                    'weight' => array(
                        'type'              => 'decimal',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Weight',
                        'input'             => 'text',
                        'class'             => 'validate-number',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => 0,
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'apply_to'          => 'simple',
                    ),
                    'manufacturer' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Manufacturer',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => true,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => true,
                        'comparable'        => true,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'unique'            => false,
                        'apply_to'          => 'simple',
                    ),
                    'meta_title' => array(
                        'group'             => 'Meta Information',
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Meta Title',
                        'input'             => 'text',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'meta_keyword' => array(
                        'group'             => 'Meta Information',
                        'type'              => 'text',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Meta Keywords',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'meta_description' => array(
                        'group'             => 'Meta Information',
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Meta Description',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'note'              => 'Maximum 255 chars',
                    ),
                    'image' => array(
                        'group'             => 'Images',
                        'type'              => 'varchar',
                        //'backend'           => 'catalog/entity_product_attribute_backend_image',
                        'frontend'          => 'catalog/product_attribute_frontend_image',
                        'label'             => 'Base Image',
                        'input'             => 'media_image',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'small_image' => array(
                        'group'             => 'Images',
                        'type'              => 'varchar',
                        //'backend'           => 'catalog/entity_product_attribute_backend_image',
                        'frontend'          => 'catalog/product_attribute_frontend_image',
                        'label'             => 'Small Image',
                        'input'             => 'media_image',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                    ),
                    'thumbnail' => array(
                        'group'             => 'Images',
                        'type'              => 'varchar',
                        //'backend'           => 'catalog/entity_product_attribute_backend_image',
                        'frontend'          => 'catalog/product_attribute_frontend_image',
                        'label'             => 'Thumbnail',
                        'input'             => 'media_image',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                    ),
                    'media_gallery' =>  array(
                        'group'             => 'Images',
                        'label'             => 'Media Gallery',
                        'input'             => 'gallery',
                        'backend'           => 'catalog/product_attribute_backend_media',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'old_id' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => '',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'tier_price' => array(
                        'group'             => 'Prices',
                        'type'              => 'decimal',
                        'backend'           => 'catalog/product_attribute_backend_tierprice',
                        'label'             => 'Tier Price',
                        'input'             => 'text',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_for_price_rules' => false,
                        'unique'            => false,
                        'apply_to'          => 'simple,configurable,virtual',
                    ),
                    'color' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Color',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => true,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => true,
                        'comparable'        => true,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => true,
                        'unique'            => false,
                        'apply_to'          => 'simple',
                    ),
                    'news_from_date' => array(
                        'type'              => 'datetime',
                        'group'             => 'General',
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                        'frontend'          => '',
                        'label'             => 'Set Product as New from Date',
                        'input'             => 'date',
                        'class'             => 'validate-date',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                    ),
                     'news_to_date' => array(
                        'type'              => 'datetime',
                        'group'             => 'General',
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                        'frontend'          => '',
                        'label'             => 'Set Product as New to Date',
                        'input'             => 'date',
                        'class'             => 'validate-date',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                    ),
                    'gallery' => array(
                        'group'             => 'Images',
                        'type'              => 'varchar',
                        //'backend'           => 'catalog/entity_product_attribute_backend_gallery',
                        //'table'             => 'catalog_product_entity_gallery',
                        'frontend'          => '',
                        'label'             => 'Image Gallery',
                        'input'             => 'gallery',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                    ),
                    'status' => array(
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Status',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/product_status',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_WEBSITE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => true,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => false,
                        'used_in_product_listing' => true,
                        'unique'            => false,
                    ),
                    'url_key' => array(
                        'label'             => 'URL key',
                        'backend'           => 'catalog/product_attribute_backend_urlkey',
                        'required'          => false,
                        'used_in_product_listing' => true,
                    ),
                    'url_path' => array(
                        'type'              => 'varchar',
                        'frontend'          => '',
                        'table'             => '',
                        'label'             => '',
                        'input'             => '',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => true,
                    ),
                    'minimal_price' => array(
                        'group'             => 'Prices',
                        'type'              => 'decimal',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Minimal Price',
                        'input'             => 'price',
                        'class'             => 'validate-number',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => false,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'apply_to'          => 'simple,configurable,virtual',
                    ),
                    /*
                     * 删除定期扣款属性   2012.02.11
                    'is_recurring' => array(
                        'group'             => 'Recurring Profile',
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Enable Recurring Profile',
                        'note'              => 'Nominal price option may be used for manipulating recurring fees.',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'eav/entity_attribute_source_boolean',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'apply_to'          => 'simple,virtual',
                        'is_configurable'   => false
                    ),
                    'recurring_profile' => array(
                        'group'             => 'Recurring Profile',
                        'type'              => 'text',
                        'backend'           => 'catalog/product_attribute_backend_recurring',
                        'frontend'          => '',
                        'label'             => 'Recurring Profile',
                        'input'             => 'text', // doesn't matter
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'apply_to'          => 'simple,virtual',
                        'is_configurable'   => false
                    ),
                    */
                    'visibility' => array(
                        'group'             => 'General',
                        'type'              => 'int',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Visibility',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/product_visibility',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => true,
                        'user_defined'      => false,
                        'default'           => '4',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => false,
                        'unique'            => false,
                    ),
                    'custom_design' => array(
                        'type'              => 'varchar',
                        'label'             => 'Custom Design',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'core/design_source_design',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'group'             => 'Design',
                    ),
                    'custom_design_from' => array(
                        'type'              => 'datetime',
                        'label'             => 'Active From',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'date',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                        'group'             => 'Design',
                    ),
                    'custom_design_to' => array(
                        'type'              => 'datetime',
                        'label'             => 'Active To',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'date',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'backend'           => 'eav/entity_attribute_backend_datetime',
                        'group'             => 'Design',
                    ),
                    'custom_layout_update' => array(
                        'type'              => 'text',
                        'label'             => 'Custom Layout Update',
                        'frontend'          => '',
                        'table'             => '',
                        'input'             => 'textarea',
                        'class'             => '',
                        'source'            => '',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'group'             => 'Design',
                    ),
                    'page_layout' => array(
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Page Layout',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/product_attribute_source_layout',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => '',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'unique'            => false,
                        'group'             => 'Design'
                    ),
                    'options_container' => array(
                        'group'             => 'Design',
                        'type'              => 'varchar',
                        'backend'           => '',
                        'frontend'          => '',
                        'label'             => 'Display product options in',
                        'input'             => 'select',
                        'class'             => '',
                        'source'            => 'catalog/entity_product_attribute_design_options_container',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => true,
                        'required'          => false,
                        'user_defined'      => false,
                        'default'           => 'container2',
                        'searchable'        => false,
                        'filterable'        => false,
                        'comparable'        => false,
                        'visible_on_front'  => false,
                        'visible_in_advanced_search' => false,
                        'unique'            => false,
                    ),
                    'required_options' => array(
                        'type'    => 'static',
                        'visible'                 => false,
                        'default'                 => false,
                        'used_in_product_listing' => true,
                        'required' => false,
                    ),
                    'has_options' => array(
                        'type'    => 'static',
                        'visible' =>false,
                        'default' => false,
                        'required' => false,
                    ),
                    'image_label' => array(
                        'type'              => 'varchar',
                        'label'             => 'Image Label',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => false,
                        'required'          => false,
                        'searchable'        => false,
                        'is_configurable'   => false,
                        'used_in_product_listing' => true,
                    ),
                    'small_image_label' => array(
                        'type'              => 'varchar',
                        'label'             => 'Small Image Label',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => false,
                        'required'          => false,
                        'searchable'        => false,
                        'is_configurable'   => false,
                        'used_in_product_listing' => true,
                    ),
                    'thumbnail_label' => array(
                        'type'              => 'varchar',
                        'label'             => 'Thumbnail Label',
                        'global'            => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                        'visible'           => false,
                        'required'          => false,
                        'searchable'        => false,
                        'is_configurable'   => false,
                        'used_in_product_listing' => true,
                    ),
                    'created_at' => array(
                        'type'      => 'static',
                        'backend'   => 'eav/entity_attribute_backend_time_created',
                        'visible'   => false,
                    ),
                    'updated_at' => array(
                        'type'      => 'static',
                        'backend'   => 'eav/entity_attribute_backend_time_updated',
                        'visible'   => false,
                    )
                ),
            ),
        );
    }

    /**
     * Enter description here...
     *
     * @return Mage_Catalog_Model_Resource_Eav_Mysql4_Setup
     */
    public function convertOldTreeToNew()
    {
        if (!Mage::getModel('catalog/category')->load(1)->getId()) {
            Mage::getModel('catalog/category')->setId(1)->setPath(1)->save();
        }

        $categories = array();

        $select = $this->getConnection()->select();
        $select->from($this->getTable('catalog/category'));
        $categories = $this->getConnection()->fetchAll($select);

        if (is_array($categories)) {
            foreach ($categories as $category) {
                $path = $this->_getCategoryPath($category);
                $path = array_reverse($path);
                $path = implode('/', $path);
                if ($category['entity_id'] != 1 && substr($path, 0, 2) != '1/') {
                    $path = "1/{$path}";
                }

                $this
                    ->getConnection()
                    ->update(
                        $this->getTable('catalog/category'),
                        array('path' => $path),
                        "entity_id = {$category['entity_id']}"
                    );
            }
        }
        return $this;
    }

    /**
     * Enter description here...
     *
     * @param int $id
     * @return array
     */
    protected function _getCategoryEntityRow($id)
    {
        $select = $this->getConnection()->select();

        $select->from($this->getTable('catalog/category'));
        $select->where('entity_id = ?', $id);

        return $this->getConnection()->fetchRow($select);
    }

    /**
     * Enter description here...
     *
     * @param array $category
     * @param array $path
     * @return string
     */
    protected function _getCategoryPath($category, $path = array())
    {
        $path[] = $category['entity_id'];

        if ($category['parent_id'] != 0) {
            $parentCategory = $this->_getCategoryEntityRow($category['parent_id']);

            if ($parentCategory)
                $path = $this->_getCategoryPath($parentCategory, $path);
        }

        return $path;
    }

    /**
     * Creates level values for categories and saves them
     *
     * @return Mage_Catalog_Model_Resource_Eav_Mysql4_Setup
     */
    public function rebuildCategoryLevels()
    {
        $select = $this->getConnection()->select()
            ->from($this->getTable('catalog/category'));

        $categories = $this->getConnection()->fetchAll($select);

        foreach ($categories as $category) {
            $level = count(explode('/', $category['path']))-1;
            $this
                ->getConnection()
                ->update(
                    $this->getTable('catalog/category'),
                    array('level' => $level),
                    "entity_id = {$category['entity_id']}"
                );
        }
        return $this;
    }
}
