<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magentocommerce.com for more information.
 *
 * @category    Mage
 * @package     Mage_Directory
 * @copyright   Copyright (c) 2010 Magento Inc. (http://www.magentocommerce.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */


/**
 * Directory install
 *
 * @category   Mage
 * @package    Mage_Directory
 * @author      Magento Core Team <core@magentocommerce.com>
 */
$installer = $this;
/* @var $installer Mage_Core_Model_Resource_Setup */

$installer->startSetup();
$installer->run("
-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country')}`;
CREATE TABLE `{$installer->getTable('directory_country')}` (
  `country_id` varchar(2) NOT NULL default '',
  `iso2_code` varchar(2) NOT NULL default '',
  `iso3_code` varchar(3) NOT NULL default '',
  PRIMARY KEY  (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Countries';

INSERT INTO `{$installer->getTable('directory_country')}` VALUES
('AD', 'AD', 'AND'),('AE', 'AE', 'ARE'),('AF', 'AF', 'AFG'),('AG', 'AG', 'ATG'),
('AI', 'AI', 'AIA'),('AL', 'AL', 'ALB'),('AM', 'AM', 'ARM'),('AN', 'AN', 'ANT'),
('AO', 'AO', 'AGO'),('AQ', 'AQ', 'ATA'),('AR', 'AR', 'ARG'),('AS', 'AS', 'ASM'),
('AT', 'AT', 'AUT'),('AU', 'AU', 'AUS'),('AW', 'AW', 'ABW'),('AZ', 'AZ', 'AZE'),
('BA', 'BA', 'BIH'),('BB', 'BB', 'BRB'),('BD', 'BD', 'BGD'),('BE', 'BE', 'BEL'),
('BF', 'BF', 'BFA'),('BG', 'BG', 'BGR'),('BH', 'BH', 'BHR'),('BI', 'BI', 'BDI'),
('BJ', 'BJ', 'BEN'),('BM', 'BM', 'BMU'),('BN', 'BN', 'BRN'),('BO', 'BO', 'BOL'),
('BR', 'BR', 'BRA'),('BS', 'BS', 'BHS'),('BT', 'BT', 'BTN'),('BV', 'BV', 'BVT'),
('BW', 'BW', 'BWA'),('BY', 'BY', 'BLR'),('BZ', 'BZ', 'BLZ'),('CA', 'CA', 'CAN'),
('CC', 'CC', 'CCK'),('CF', 'CF', 'CAF'),('CG', 'CG', 'COG'),('CH', 'CH', 'CHE'),
('CI', 'CI', 'CIV'),('CK', 'CK', 'COK'),('CL', 'CL', 'CHL'),('CM', 'CM', 'CMR'),
('CN', 'CN', 'CHN'),('CO', 'CO', 'COL'),('CR', 'CR', 'CRI'),('CU', 'CU', 'CUB'),
('CV', 'CV', 'CPV'),('CX', 'CX', 'CXR'),('CY', 'CY', 'CYP'),('CZ', 'CZ', 'CZE'),
('DE', 'DE', 'DEU'),('DJ', 'DJ', 'DJI'),('DK', 'DK', 'DNK'),('DM', 'DM', 'DMA'),
('DO', 'DO', 'DOM'),('DZ', 'DZ', 'DZA'),('EC', 'EC', 'ECU'),('EE', 'EE', 'EST'),
('EG', 'EG', 'EGY'),('EH', 'EH', 'ESH'),('ER', 'ER', 'ERI'),('ES', 'ES', 'ESP'),
('ET', 'ET', 'ETH'),('FI', 'FI', 'FIN'),('FJ', 'FJ', 'FJI'),('FK', 'FK', 'FLK'),
('FM', 'FM', 'FSM'),('FO', 'FO', 'FRO'),('FR', 'FR', 'FRA'),('FX', 'FX', 'FXX'),
('GA', 'GA', 'GAB'),('GB', 'GB', 'GBR'),('GD', 'GD', 'GRD'),('GE', 'GE', 'GEO'),
('GF', 'GF', 'GUF'),('GH', 'GH', 'GHA'),('GI', 'GI', 'GIB'),('GL', 'GL', 'GRL'),
('GM', 'GM', 'GMB'),('GN', 'GN', 'GIN'),('GP', 'GP', 'GLP'),('GQ', 'GQ', 'GNQ'),
('GR', 'GR', 'GRC'),('GS', 'GS', 'SGS'),('GT', 'GT', 'GTM'),('GU', 'GU', 'GUM'),
('GW', 'GW', 'GNB'),('GY', 'GY', 'GUY'),('HK', 'HK', 'HKG'),('HM', 'HM', 'HMD'),
('HN', 'HN', 'HND'),('HR', 'HR', 'HRV'),('HT', 'HT', 'HTI'),('HU', 'HU', 'HUN'),
('ID', 'ID', 'IDN'),('IE', 'IE', 'IRL'),('IL', 'IL', 'ISR'),('IN', 'IN', 'IND'),
('IO', 'IO', 'IOT'),('IQ', 'IQ', 'IRQ'),('IR', 'IR', 'IRN'),('IS', 'IS', 'ISL'),
('IT', 'IT', 'ITA'),('JM', 'JM', 'JAM'),('JO', 'JO', 'JOR'),('JP', 'JP', 'JPN'),
('KE', 'KE', 'KEN'),('KG', 'KG', 'KGZ'),('KH', 'KH', 'KHM'),('KI', 'KI', 'KIR'),
('KM', 'KM', 'COM'),('KN', 'KN', 'KNA'),('KP', 'KP', 'PRK'),('KR', 'KR', 'KOR'),
('KW', 'KW', 'KWT'),('KY', 'KY', 'CYM'),('KZ', 'KZ', 'KAZ'),('LA', 'LA', 'LAO'),
('LB', 'LB', 'LBN'),('LC', 'LC', 'LCA'),('LI', 'LI', 'LIE'),('LK', 'LK', 'LKA'),
('LR', 'LR', 'LBR'),('LS', 'LS', 'LSO'),('LT', 'LT', 'LTU'),('LU', 'LU', 'LUX'),
('LV', 'LV', 'LVA'),('LY', 'LY', 'LBY'),('MA', 'MA', 'MAR'),('MC', 'MC', 'MCO'),
('MD', 'MD', 'MDA'),('MG', 'MG', 'MDG'),('MH', 'MH', 'MHL'),('MK', 'MK', 'MKD'),
('ML', 'ML', 'MLI'),('MM', 'MM', 'MMR'),('MN', 'MN', 'MNG'),('MO', 'MO', 'MAC'),
('MP', 'MP', 'MNP'),('MQ', 'MQ', 'MTQ'),('MR', 'MR', 'MRT'),('MS', 'MS', 'MSR'),
('MT', 'MT', 'MLT'),('MU', 'MU', 'MUS'),('MV', 'MV', 'MDV'),('MW', 'MW', 'MWI'),
('MX', 'MX', 'MEX'),('MY', 'MY', 'MYS'),('MZ', 'MZ', 'MOZ'),('NA', 'NA', 'NAM'),
('NC', 'NC', 'NCL'),('NE', 'NE', 'NER'),('NF', 'NF', 'NFK'),('NG', 'NG', 'NGA'),
('NI', 'NI', 'NIC'),('NL', 'NL', 'NLD'),('NO', 'NO', 'NOR'),('NP', 'NP', 'NPL'),
('NR', 'NR', 'NRU'),('NU', 'NU', 'NIU'),('NZ', 'NZ', 'NZL'),('OM', 'OM', 'OMN'),
('PA', 'PA', 'PAN'),('PE', 'PE', 'PER'),('PF', 'PF', 'PYF'),('PG', 'PG', 'PNG'),
('PH', 'PH', 'PHL'),('PK', 'PK', 'PAK'),('PL', 'PL', 'POL'),('PM', 'PM', 'SPM'),
('PN', 'PN', 'PCN'),('PR', 'PR', 'PRI'),('PT', 'PT', 'PRT'),('PW', 'PW', 'PLW'),
('PY', 'PY', 'PRY'),('QA', 'QA', 'QAT'),('RE', 'RE', 'REU'),('RO', 'RO', 'ROM'),
('RU', 'RU', 'RUS'),('RW', 'RW', 'RWA'),('SA', 'SA', 'SAU'),('SB', 'SB', 'SLB'),
('SC', 'SC', 'SYC'),('SD', 'SD', 'SDN'),('SE', 'SE', 'SWE'),('SG', 'SG', 'SGP'),
('SH', 'SH', 'SHN'),('SI', 'SI', 'SVN'),('SJ', 'SJ', 'SJM'),('SK', 'SK', 'SVK'),
('SL', 'SL', 'SLE'),('SM', 'SM', 'SMR'),('SN', 'SN', 'SEN'),('SO', 'SO', 'SOM'),
('SR', 'SR', 'SUR'),('ST', 'ST', 'STP'),('SV', 'SV', 'SLV'),('SY', 'SY', 'SYR'),
('SZ', 'SZ', 'SWZ'),('TC', 'TC', 'TCA'),('TD', 'TD', 'TCD'),('TF', 'TF', 'ATF'),
('TG', 'TG', 'TGO'),('TH', 'TH', 'THA'),('TJ', 'TJ', 'TJK'),('TK', 'TK', 'TKL'),
('TM', 'TM', 'TKM'),('TN', 'TN', 'TUN'),('TO', 'TO', 'TON'),('TR', 'TR', 'TUR'),
('TT', 'TT', 'TTO'),('TV', 'TV', 'TUV'),('TW', 'TW', 'TWN'),('TZ', 'TZ', 'TZA'),
('UA', 'UA', 'UKR'),('UG', 'UG', 'UGA'),('UM', 'UM', 'UMI'),('US', 'US', 'USA'),
('UY', 'UY', 'URY'),('UZ', 'UZ', 'UZB'),('VA', 'VA', 'VAT'),('VC', 'VC', 'VCT'),
('VE', 'VE', 'VEN'),('VG', 'VG', 'VGB'),('VI', 'VI', 'VIR'),('VN', 'VN', 'VNM'),
('VU', 'VU', 'VUT'),('WF', 'WF', 'WLF'),('WS', 'WS', 'WSM'),('YE', 'YE', 'YEM'),
('YT', 'YT', 'MYT'),('ZA', 'ZA', 'ZAF'),('ZM', 'ZM', 'ZMB'),('ZW', 'ZW', 'ZWE');

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_format')}`;
CREATE TABLE `{$installer->getTable('directory_country_format')}` (
  `country_format_id` int(10) unsigned NOT NULL auto_increment,
  `country_id` varchar(2) NOT NULL default '',
  `type` varchar(30) NOT NULL default '',
  `format` text NOT NULL,
  PRIMARY KEY  (`country_format_id`),
  UNIQUE KEY `country_type` (`country_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Countries format';

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_region')}`;
CREATE TABLE `{$installer->getTable('directory_country_region')}` (
  `region_id` mediumint(8) unsigned NOT NULL auto_increment,
  `country_id` varchar(4) NOT NULL default '0',
  `code` varchar(32) NOT NULL default '',
  `default_name` varchar(255) default NULL,
  PRIMARY KEY  (`region_id`),
  KEY `FK_REGION_COUNTRY` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Country regions';

INSERT INTO `{$installer->getTable('directory_country_region')}` VALUES
('1', 'CN', 'BJ', '北京市'),('2', 'CN', 'TJ', '天津市'),('3', 'CN', 'HEB', '河北省'),
('4', 'CN', 'SX', '山西省'),('5', 'CN', 'NM', '内蒙古自治区'),('6', 'CN', 'LN', '辽宁省'),
('7', 'CN', 'JL', '吉林省'),('8', 'CN', 'HL', '黑龙江省'),('9', 'CN', 'SH', '上海市'),('10', 'CN', 'JS', '江苏省'),
('11', 'CN', 'ZJ', '浙江省'),('12', 'CN', 'AH', '安徽省'),('13', 'CN', 'FJ', '福建省'),('14', 'CN', 'JX', '江西省'),
('15', 'CN', 'SD', '山东省'),('16', 'CN', 'HEN', '河南省'),('17', 'CN', 'HUB', '湖北省'),('18', 'CN', 'HUN', '湖南省'),
('19', 'CN', 'GD', '广东省'),('20', 'CN', 'HIN', '海南省'),('21', 'CN', 'GX', '广西壮族自治区'),('22', 'CN', 'GS', '甘肃省'),
('23', 'CN', 'SX', '陕西省'),('24', 'CN', 'XJ', '新疆维吾尔自治区'),('25', 'CN', 'QH', '青海省'),('26', 'CN', 'NX', '宁夏回族自治区'),
('27', 'CN', 'CQ', '重庆市'),('28', 'CN', 'SC', '四川省'),('29', 'CN', 'GZ', '贵州省'),('30', 'CN', 'YN', '云南省'),
('31', 'CN', 'XZ', '西藏自治区'),('32', 'CN', 'TW', '台湾省'),('33', 'CN', 'AM', '澳门特别行政区'),('34', 'CN', 'HK', '香港特别行政区');

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_region_name')}`;
CREATE TABLE `{$installer->getTable('directory_country_region_name')}` (
  `locale` varchar(8) NOT NULL default '',
  `region_id` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`locale`,`region_id`),
  KEY `FK_DIRECTORY_REGION_NAME_REGION` (`region_id`),
  CONSTRAINT `FK_DIRECTORY_REGION_NAME_REGION` FOREIGN KEY (`region_id`) REFERENCES {$installer->getTable('directory_country_region')} (`region_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Regions names';

INSERT INTO `{$installer->getTable('directory_country_region_name')}` VALUES
('zh_CN', '1', '北京市'),('zh_CN', '2', '天津市'),('zh_CN', '3', '河北省'),
('zh_CN', '4', '山西省'),('zh_CN', '5', '内蒙古自治区'),('zh_CN', '6', '辽宁省'),
('zh_CN', '7', '吉林省'),('zh_CN', '8', '黑龙江省'),('zh_CN', '9', '上海市'),('zh_CN', '10', '江苏省'),
('zh_CN', '11', '浙江省'),('zh_CN', '12', '安徽省'),('zh_CN', '13', '福建省'),('zh_CN', '14', '江西省'),
('zh_CN', '15', '山东省'),('zh_CN', '16', '河南省'),('zh_CN', '17', '湖北省'),('zh_CN', '18', '湖南省'),
('zh_CN', '19', '广东省'),('zh_CN', '20', '海南省'),('zh_CN', '21', '广西壮族自治区'),('zh_CN', '22', '甘肃省'),
('zh_CN', '23', '陕西省'),('zh_CN', '24', '新 疆维吾尔自治区'),('zh_CN', '25', '青海省'),('zh_CN', '26', '宁夏回族自治区'),
('zh_CN', '27', '重庆市'),('zh_CN', '28', '四川省'),('zh_CN', '29', '贵州省'),('zh_CN', '30', '云南省'),
('zh_CN', '31', '西藏自治区'),('zh_CN', '32', '台湾省'),('zh_CN', '33', '澳门特别行政区'),('zh_CN', '34', '香港特别行政区');

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_city')}`;
CREATE TABLE `{$installer->getTable('directory_country_city')}` (
  `city_id` mediumint(8) unsigned NOT NULL auto_increment,
  `region_id` mediumint(8) NOT NULL default '0',
  `default_name` varchar(255) default NULL,
  PRIMARY KEY  (`city_id`),
  KEY `FK_CITY_REGION` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Country cities';

INSERT INTO `{$installer->getTable('directory_country_city')}` VALUES
('1', '1', '北京市'),('2', '2', '天津市'),('3', '9', '上海市'),('4', '27', '重庆市'),('5', '3', '邯郸市'),
('6', '3', '石家庄市'),('7', '3', '保定市'),('8', '3', '张家口市'),('9', '3', '承德市'),('10', '3', '唐山市'),
('11', '3', '廊坊市'),('12', '3', '沧州市'),('13', '3', '衡水市'),('14', '3', '邢台市'),('15', '3', '秦皇岛市'),
('16', '4', '朔州市'),('17', '4', '忻州市'),('18', '4', '太原市'),('19', '4', '大同市'),('20', '4', '阳泉市'),
('21', '4', '晋中市'),('22', '4', '长治市'),('23', '4', '晋城市'),('24', '4', '临汾市'),('25', '4', '吕梁市'),
('26', '4', '运城市'),('27', '6', '沈阳市'),('28', '6', '铁岭市'),('29', '6', '大连市'),('30', '6', '鞍山市'),
('31', '6', '抚顺市'),('32', '6', '本溪市'),('33', '6', '丹东市'),('34', '6', '锦州市'),('35', '6', '营口市'),
('36', '6', '阜新市'),('37', '6', '辽阳市'),('38', '6', '朝阳市'),('39', '6', '盘锦市'),('40', '6', '葫芦岛市'),
('41', '7', '长春市'),('42', '7', '吉林市'),('43', '7', '延边朝鲜族自治州'),('44', '7', '四平市'),('45', '7', '通化市'),
('46', '7', '白城市'),('47', '7', '辽源市'),('48', '7', '松原市'),('49', '7', '白山市'),('50', '8', '哈尔滨市'),
('51', '8', '齐齐哈尔市'),('52', '8', '鸡西市'),('53', '8', '牡丹江市'),('54', '8', '七台河市'),('55', '8', '佳木斯市'),
('56', '8', '鹤岗市'),('57', '8', '双鸭山市'),('58', '8', '绥化市'),('59', '8', '黑河市'),('60', '8', '大兴安岭地区'),
('61', '8', '伊春市'),('62', '8', '大庆市'),('63', '10', '南京市'),('64', '10', '无锡市'),('65', '10', '镇江市'),
('66', '10', '苏州市'),('67', '10', '南通市'),('68', '10', '扬州市'),('69', '10', '盐城市'),('70', '10', '徐州市'),
('71', '10', '淮安市'),('72', '10', '连云港市'),('73', '10', '常州市'),('74', '10', '泰州市'),('75', '10', '宿迁市'),
('76', '11', '舟山市'),('77', '11', '衢州市'),('78', '11', '杭州市'),('79', '11', '湖州市'),('80', '11', '嘉兴市'),
('81', '11', '宁波市'),('82', '11', '绍兴市'),('83', '11', '温州市'),('84', '11', '丽水市'),('85', '11', '金华市'),
('86', '11', '台州市'),('87', '12', '合肥市'),('88', '12', '芜湖市'),('89', '12', '蚌埠市'),('90', '12', '淮南市'),
('91', '12', '马鞍山市'),('92', '12', '淮北市'),('93', '12', '铜陵市'),('94', '12', '安庆市'),('95', '12', '黄山市'),
('96', '12', '滁州市'),('97', '12', '阜阳市'),('98', '12', '宿州市'),('99', '12', '巢湖市'),('100', '12', '六安市'),
('101', '12', '亳州市'),('102', '12', '池州市'),('103', '12', '宣城市'),('104', '13', '福州市'),('105', '13', '厦门市'),
('106', '13', '宁德市'),('107', '13', '莆田市'),('108', '13', '泉州市'),('109', '13', '漳州市'),('110', '13', '龙岩市'),
('111', '13', '三明市'),('112', '13', '南平市'),('113', '14', '鹰潭市'),('114', '14', '新余市'),('115', '14', '南昌市'),
('116', '14', '九江市'),('117', '14', '上饶市'),('118', '14', '抚州市'),('119', '14', '宜春市'),('120', '14', '吉安市'),
('121', '14', '赣州市'),('122', '14', '景德镇市'),('123', '14', '萍乡市'),('124', '15', '菏泽市'),('125', '15', '济南市'),
('126', '15', '青岛市'),('127', '15', '淄博市'),('128', '15', '德州市'),('129', '15', '烟台市'),('130', '15', '潍坊市'),
('131', '15', '济宁市'),('132', '15', '泰安市'),('133', '15', '临沂市'),('134', '15', '滨州市'),('135', '15', '东营市'),
('136', '15', '威海市'),('137', '15', '枣庄市'),('138', '15', '日照市'),('139', '15', '莱芜市'),('140', '15', '聊城市'),
('141', '16', '商丘市'),('142', '16', '郑州市'),('143', '16', '安阳市'),('144', '16', '新乡市'),('145', '16', '许昌市'),
('146', '16', '平顶山市'),('147', '16', '信阳市'),('148', '16', '南阳市'),('149', '16', '开封市'),('150', '16', '洛阳市'),
('151', '16', '济源市'),('152', '16', '焦作市'),('153', '16', '鹤壁市'),('154', '16', '濮阳市'),('155', '16', '周口市'),
('156', '16', '漯河市'),('157', '16', '驻马店市'),('158', '16', '三门峡市'),('159', '17', '武汉市'),('160', '17', '襄樊市'),
('161', '17', '鄂州市'),('162', '17', '孝感市'),('163', '17', '黄冈市'),('164', '17', '黄石市'),('165', '17', '咸宁市'),
('166', '17', '荆州市'),('167', '17', '宜昌市'),('168', '17', '恩施土家族苗族自治州'),('169', '17', '神农架林区'),('170', '17', '十堰市'),
('171', '17', '随州市'),('172', '17', '荆门市'),('173', '17', '仙桃市'),('174', '17', '天门市'),('175', '17', '潜江市'),
('176', '18', '岳阳市'),('177', '18', '长沙市'),('178', '18', '湘潭市'),('179', '18', '株洲市'),('180', '18', '衡阳市'),
('181', '18', '郴州市'),('182', '18', '常德市'),('183', '18', '益阳市'),('184', '18', '娄底市'),('185', '18', '邵阳市'),
('186', '18', '湘西土家族苗族自治州'),('187', '18', '张家界市'),('188', '18', '怀化市'),('189', '18', '永州市'),('190', '19', '广州市'),
('191', '19', '汕尾市'),('192', '19', '阳江市'),('193', '19', '揭阳市'),('194', '19', '茂名市'),('195', '19', '惠州市'),
('196', '19', '江门市'),('197', '19', '韶关市'),('198', '19', '梅州市'),('199', '19', '汕头市'),('200', '19', '深圳市'),
('201', '19', '珠海市'),('202', '19', '佛山市'),('203', '19', '肇庆市'),('204', '19', '湛江市'),('205', '19', '中山市'),
('206', '19', '河源市'),('207', '19', '清远市'),('208', '19', '云浮市'),('209', '19', '潮州市'),('210', '19', '东莞市'),
('211', '22', '兰州市'),('212', '22', '金昌市'),('213', '22', '白银市'),('214', '22', '天水市'),('215', '22', '嘉峪关市'),
('216', '22', '武威市'),('217', '22', '张掖市'),('218', '22', '平凉市'),('219', '22', '酒泉市'),('220', '22', '庆阳市'),
('221', '22', '定西市'),('222', '22', '陇南市'),('223', '22', '临夏回族自治州'),('224', '22', '甘南藏族自治州'),('225', '28', '成都市'),
('226', '28', '攀枝花市'),('227', '28', '自贡市'),('228', '28', '绵阳市'),('229', '28', '南充市'),('230', '28', '达州市'),
('231', '28', '遂宁市'),('232', '28', '广安市'),('233', '28', '巴中市'),('234', '28', '泸州市'),('235', '28', '宜宾市'),
('236', '28', '资阳市'),('237', '28', '内江市'),('238', '28', '乐山市'),('239', '28', '眉山市'),('240', '28', '凉山彝族自治州'),
('241', '28', '雅安市'),('242', '28', '甘孜藏族自治州'),('243', '28', '阿坝藏族羌族自治州'),('244', '28', '德阳市'),('245', '28', '广元市'),
('246', '29', '贵阳市'),('247', '29', '遵义市'),('248', '29', '安顺市'),('249', '29', '黔南布依族苗族自治州'),('250', '29', '黔东南苗族侗族自治州'),
('251', '29', '铜仁地区'),('252', '29', '毕节地区'),('253', '29', '六盘水市'),('254', '29', '黔西南布依族苗族自治州'),('255', '20', '海口市'),
('256', '20', '三亚市'),('257', '20', '五指山市'),('258', '20', '琼海市'),('259', '20', '儋州市'),('260', '20', '文昌市'),
('261', '20', '万宁市'),('262', '20', '东方市'),('263', '20', '澄迈县'),('264', '20', '定安县'),('265', '20', '屯昌县'),
('266', '20', '临高县'),('267', '20', '白沙黎族自治县'),('268', '20', '昌江黎族自治县'),('269', '20', '乐东黎族自治县'),('270', '20', '陵水黎族自治县'),
('271', '20', '保亭黎族苗族自治县'),('272', '20', '琼中黎族苗族自治县'),('273', '30', '西双版纳傣族自治州'),('274', '30', '德宏傣族景颇族自治州'),('275', '30', '昭通市'),
('276', '30', '昆明市'),('277', '30', '大理白族自治州'),('278', '30', '红河哈尼族彝族自治州'),('279', '30', '曲靖市'),('280', '30', '保山市'),
('281', '30', '文山壮族苗族自治州'),('282', '30', '玉溪市'),('283', '30', '楚雄彝族自治州'),('284', '30', '普洱市'),('285', '30', '临沧市'),
('286', '30', '怒江傈傈族自治州'),('287', '30', '迪庆藏族自治州'),('288', '30', '丽江市'),('289', '25', '海北藏族自治州'),('290', '25', '西宁市'),
('291', '25', '海东地区'),('292', '25', '黄南藏族自治州'),('293', '25', '海南藏族自治州'),('294', '25', '果洛藏族自治州'),('295', '25', '玉树藏族自治州'),
('296', '25', '海西蒙古族藏族自治州'),('297', '23', '西安市'),('298', '23', '咸阳市'),('299', '23', '延安市'),('300', '23', '榆林市'),
('301', '23', '渭南市'),('302', '23', '商洛市'),('303', '23', '安康市'),('304', '23', '汉中市'),('305', '23', '宝鸡市'),
('306', '23', '铜川市'),('307', '21', '防城港市'),('308', '21', '南宁市'),('309', '21', '崇左市'),('310', '21', '来宾市'),
('311', '21', '柳州市'),('312', '21', '桂林市'),('313', '21', '梧州市'),('314', '21', '贺州市'),('315', '21', '贵港市'),
('316', '21', '玉林市'),('317', '21', '百色市'),('318', '21', '钦州市'),('319', '21', '河池市'),('320', '21', '北海市'),
('321', '31', '拉萨市'),('322', '31', '日喀则地区'),('323', '31', '山南地区'),('324', '31', '林芝地区'),('325', '31', '昌都地区'),
('326', '31', '那曲地区'),('327', '31', '阿里地区'),('328', '26', '银川市'),('329', '26', '石嘴山市'),('330', '26', '吴忠市'),
('331', '26', '固原市'),('332', '26', '中卫市'),('333', '24', '塔城地区'),('334', '24', '哈密地区'),('335', '24', '和田地区'),
('336', '24', '阿勒泰地区'),('337', '24', '克孜勒苏柯尔克孜自治州'),('338', '24', '博尔塔拉蒙古自治州'),('339', '24', '克拉玛依市'),('340', '24', '乌鲁木齐市'),
('341', '24', '石河子市'),('342', '24', '昌吉回族自治州'),('343', '24', '五家渠市'),('344', '24', '吐鲁番地区'),('345', '24', '巴音郭楞蒙古自治州'),
('346', '24', '阿克苏地区'),('347', '24', '阿拉尔市'),('348', '24', '喀什地区'),('349', '24', '图木舒克市'),('350', '24', '伊犁哈萨克自治州'),
('351', '5', '呼伦贝尔市'),('352', '5', '呼和浩特市'),('353', '5', '包头市'),('354', '5', '乌海市'),('355', '5', '乌兰察布市'),
('356', '5', '通辽市'),('357', '5', '赤峰市'),('358', '5', '鄂尔多斯市'),('359', '5', '巴彦淖尔市'),('360', '5', '锡林郭勒盟'),
('361', '5', '兴安盟'),('362', '5', '阿拉善盟'),('363', '32', '台北市'),('364', '32', '高雄市'),('365', '32', '基隆市'),
('366', '32', '台中市'),('367', '32', '台南市'),('368', '32', '新竹市'),('369', '32', '嘉义市'),('370', '33', '澳门特别行政区'),('371', '34', '香港特别行政区');

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_city_name')}`;
CREATE TABLE `{$installer->getTable('directory_country_city_name')}` (
  `locale` varchar(8) NOT NULL default '',
  `city_id` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`locale`,`city_id`),
  KEY `FK_DIRECTORY_CITY_NAME_CITY` (`city_id`),
  CONSTRAINT `FK_DIRECTORY_CITY_NAME_CITY` FOREIGN KEY (`city_id`) REFERENCES {$installer->getTable('directory_country_city')} (`city_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cities names';

INSERT INTO `{$installer->getTable('directory_country_city_name')}` VALUES
('zh_CN', '1', '北京市'),('zh_CN', '2', '天津市'),('zh_CN', '3', '上海市'),('zh_CN', '4', '重庆市'),('zh_CN', '5', '邯郸市'),
('zh_CN', '6', '石家庄市'),('zh_CN', '7', '保定市'),('zh_CN', '8', '张家口市'),('zh_CN', '9', '承德市'),('zh_CN', '10', '唐山市'),
('zh_CN', '11', '廊坊市'),('zh_CN', '12', '沧州市'),('zh_CN', '13', '衡水市'),('zh_CN', '14', '邢台市'),('zh_CN', '15', '秦皇岛市'),
('zh_CN', '16', '朔州市'),('zh_CN', '17', '忻州市'),('zh_CN', '18', '太原市'),('zh_CN', '19', '大同市'),('zh_CN', '20', '阳泉市'),
('zh_CN', '21', '晋中市'),('zh_CN', '22', '长治市'),('zh_CN', '23', '晋城市'),('zh_CN', '24', '临汾市'),('zh_CN', '25', '吕梁市'),
('zh_CN', '26', '运城市'),('zh_CN', '27', '沈阳市'),('zh_CN', '28', '铁岭市'),('zh_CN', '29', '大连市'),('zh_CN', '30', '鞍山市'),
('zh_CN', '31', '抚顺市'),('zh_CN', '32', '本溪市'),('zh_CN', '33', '丹东市'),('zh_CN', '34', '锦州市'),('zh_CN', '35', '营口市'),
('zh_CN', '36', '阜新市'),('zh_CN', '37', '辽阳市'),('zh_CN', '38', '朝阳市'),('zh_CN', '39', '盘锦市'),('zh_CN', '40', '葫芦岛市'),
('zh_CN', '41', '长春市'),('zh_CN', '42', '吉林市'),('zh_CN', '43', '延边朝鲜族自治州'),('zh_CN', '44', '四平市'),('zh_CN', '45', '通化市'),
('zh_CN', '46', '白城市'),('zh_CN', '47', '辽源市'),('zh_CN', '48', '松原市'),('zh_CN', '49', '白山市'),('zh_CN', '50', '哈尔滨市'),
('zh_CN', '51', '齐齐哈尔市'),('zh_CN', '52', '鸡西市'),('zh_CN', '53', '牡丹江市'),('zh_CN', '54', '七台河市'),('zh_CN', '55', '佳木斯市'),
('zh_CN', '56', '鹤岗市'),('zh_CN', '57', '双鸭山市'),('zh_CN', '58', '绥化市'),('zh_CN', '59', '黑河市'),('zh_CN', '60', '大兴安岭地区'),
('zh_CN', '61', '伊春市'),('zh_CN', '62', '大庆市'),('zh_CN', '63', '南京市'),('zh_CN', '64', '无锡市'),('zh_CN', '65', '镇江市'),
('zh_CN', '66', '苏州市'),('zh_CN', '67', '南通市'),('zh_CN', '68', '扬州市'),('zh_CN', '69', '盐城市'),('zh_CN', '70', '徐州市'),
('zh_CN', '71', '淮安市'),('zh_CN', '72', '连云港市'),('zh_CN', '73', '常州市'),('zh_CN', '74', '泰州市'),('zh_CN', '75', '宿迁市'),
('zh_CN', '76', '舟山市'),('zh_CN', '77', '衢州市'),('zh_CN', '78', '杭州市'),('zh_CN', '79', '湖州市'),('zh_CN', '80', '嘉兴市'),
('zh_CN', '81', '宁波市'),('zh_CN', '82', '绍兴市'),('zh_CN', '83', '温州市'),('zh_CN', '84', '丽水市'),('zh_CN', '85', '金华市'),
('zh_CN', '86', '台州市'),('zh_CN', '87', '合肥市'),('zh_CN', '88', '芜湖市'),('zh_CN', '89', '蚌埠市'),('zh_CN', '90', '淮南市'),
('zh_CN', '91', '马鞍山市'),('zh_CN', '92', '淮北市'),('zh_CN', '93', '铜陵市'),('zh_CN', '94', '安庆市'),('zh_CN', '95', '黄山市'),
('zh_CN', '96', '滁州市'),('zh_CN', '97', '阜阳市'),('zh_CN', '98', '宿州市'),('zh_CN', '99', '巢湖市'),('zh_CN', '100', '六安市'),
('zh_CN', '101', '亳州市'),('zh_CN', '102', '池州市'),('zh_CN', '103', '宣城市'),('zh_CN', '104', '福州市'),('zh_CN', '105', '厦门市'),
('zh_CN', '106', '宁德市'),('zh_CN', '107', '莆田市'),('zh_CN', '108', '泉州市'),('zh_CN', '109', '漳州市'),('zh_CN', '110', '龙岩市'),
('zh_CN', '111', '三明市'),('zh_CN', '112', '南平市'),('zh_CN', '113', '鹰潭市'),('zh_CN', '114', '新余市'),('zh_CN', '115', '南昌市'),
('zh_CN', '116', '九江市'),('zh_CN', '117', '上饶市'),('zh_CN', '118', '抚州市'),('zh_CN', '119', '宜春市'),('zh_CN', '120', '吉安市'),
('zh_CN', '121', '赣州市'),('zh_CN', '122', '景德镇市'),('zh_CN', '123', '萍乡市'),('zh_CN', '124', '菏泽市'),('zh_CN', '125', '济南市'),
('zh_CN', '126', '青岛市'),('zh_CN', '127', '淄博市'),('zh_CN', '128', '德州市'),('zh_CN', '129', '烟台市'),('zh_CN', '130', '潍坊市'),
('zh_CN', '131', '济宁市'),('zh_CN', '132', '泰安市'),('zh_CN', '133', '临沂市'),('zh_CN', '134', '滨州市'),('zh_CN', '135', '东营市'),
('zh_CN', '136', '威海市'),('zh_CN', '137', '枣庄市'),('zh_CN', '138', '日照市'),('zh_CN', '139', '莱芜市'),('zh_CN', '140', '聊城市'),
('zh_CN', '141', '商丘市'),('zh_CN', '142', '郑州市'),('zh_CN', '143', '安阳市'),('zh_CN', '144', '新乡市'),('zh_CN', '145', '许昌市'),
('zh_CN', '146', '平顶山市'),('zh_CN', '147', '信阳市'),('zh_CN', '148', '南阳市'),('zh_CN', '149', '开封市'),('zh_CN', '150', '洛阳市'),
('zh_CN', '151', '济源市'),('zh_CN', '152', '焦作市'),('zh_CN', '153', '鹤壁市'),('zh_CN', '154', '濮阳市'),('zh_CN', '155', '周口市'),
('zh_CN', '156', '漯河市'),('zh_CN', '157', '驻马店市'),('zh_CN', '158', '三门峡市'),('zh_CN', '159', '武汉市'),('zh_CN', '160', '襄樊市'),
('zh_CN', '161', '鄂州市'),('zh_CN', '162', '孝感市'),('zh_CN', '163', '黄冈市'),('zh_CN', '164', '黄石市'),('zh_CN', '165', '咸宁市'),
('zh_CN', '166', '荆州市'),('zh_CN', '167', '宜昌市'),('zh_CN', '168', '恩施土家族苗族自治州'),('zh_CN', '169', '神农架林区'),('zh_CN', '170', '十堰市'),
('zh_CN', '171', '随州市'),('zh_CN', '172', '荆门市'),('zh_CN', '173', '仙桃市'),('zh_CN', '174', '天门市'),('zh_CN', '175', '潜江市'),
('zh_CN', '176', '岳阳市'),('zh_CN', '177', '长沙市'),('zh_CN', '178', '湘潭市'),('zh_CN', '179', '株洲市'),('zh_CN', '180', '衡阳市'),
('zh_CN', '181', '郴州市'),('zh_CN', '182', '常德市'),('zh_CN', '183', '益阳市'),('zh_CN', '184', '娄底市'),('zh_CN', '185', '邵阳市'),
('zh_CN', '186', '湘西土家族苗族自治州'),('zh_CN', '187', '张家界市'),('zh_CN', '188', '怀化市'),('zh_CN', '189', '永州市'),('zh_CN', '190', '广州市'),
('zh_CN', '191', '汕尾市'),('zh_CN', '192', '阳江市'),('zh_CN', '193', '揭阳市'),('zh_CN', '194', '茂名市'),('zh_CN', '195', '惠州市'),
('zh_CN', '196', '江门市'),('zh_CN', '197', '韶关市'),('zh_CN', '198', '梅州市'),('zh_CN', '199', '汕头市'),('zh_CN', '200', '深圳市'),
('zh_CN', '201', '珠海市'),('zh_CN', '202', '佛山市'),('zh_CN', '203', '肇庆市'),('zh_CN', '204', '湛江市'),('zh_CN', '205', '中山市'),
('zh_CN', '206', '河源市'),('zh_CN', '207', '清远市'),('zh_CN', '208', '云浮市'),('zh_CN', '209', '潮州市'),('zh_CN', '210', '东莞市'),
('zh_CN', '211', '兰州市'),('zh_CN', '212', '金昌市'),('zh_CN', '213', '白银市'),('zh_CN', '214', '天水市'),('zh_CN', '215', '嘉峪关市'),
('zh_CN', '216', '武威市'),('zh_CN', '217', '张掖市'),('zh_CN', '218', '平凉市'),('zh_CN', '219', '酒泉市'),('zh_CN', '220', '庆阳市'),
('zh_CN', '221', '定西市'),('zh_CN', '222', '陇南市'),('zh_CN', '223', '临夏回族自治州'),('zh_CN', '224', '甘南藏族自治州'),('zh_CN', '225', '成都市'),
('zh_CN', '226', '攀枝花市'),('zh_CN', '227', '自贡市'),('zh_CN', '228', '绵阳市'),('zh_CN', '229', '南充市'),('zh_CN', '230', '达州市'),
('zh_CN', '231', '遂宁市'),('zh_CN', '232', '广安市'),('zh_CN', '233', '巴中市'),('zh_CN', '234', '泸州市'),('zh_CN', '235', '宜宾市'),
('zh_CN', '236', '资阳市'),('zh_CN', '237', '内江市'),('zh_CN', '238', '乐山市'),('zh_CN', '239', '眉山市'),('zh_CN', '240', '凉山彝族自治州'),
('zh_CN', '241', '雅安市'),('zh_CN', '242', '甘孜藏族自治州'),('zh_CN', '243', '阿坝藏族羌族自治州'),('zh_CN', '244', '德阳市'),('zh_CN', '245', '广元市'),
('zh_CN', '246', '贵阳市'),('zh_CN', '247', '遵义市'),('zh_CN', '248', '安顺市'),('zh_CN', '249', '黔南布依族苗族自治州'),('zh_CN', '250', '黔东南苗族侗族自治州'),
('zh_CN', '251', '铜仁地区'),('zh_CN', '252', '毕节地区'),('zh_CN', '253', '六盘水市'),('zh_CN', '254', '黔西南布依族苗族自治州'),('zh_CN', '255', '海口市'),
('zh_CN', '256', '三亚市'),('zh_CN', '257', '五指山市'),('zh_CN', '258', '琼海市'),('zh_CN', '259', '儋州市'),('zh_CN', '260', '文昌市'),
('zh_CN', '261', '万宁市'),('zh_CN', '262', '东方市'),('zh_CN', '263', '澄迈县'),('zh_CN', '264', '定安县'),('zh_CN', '265', '屯昌县'),
('zh_CN', '266', '临高县'),('zh_CN', '267', '白沙黎族自治县'),('zh_CN', '268', '昌江黎族自治县'),('zh_CN', '269', '乐东黎族自治县'),('zh_CN', '270', '陵水黎族自治县'),
('zh_CN', '271', '保亭黎族苗族自治县'),('zh_CN', '272', '琼中黎族苗族自治县'),('zh_CN', '273', '西双版纳傣族自治州'),('zh_CN', '274', '德宏傣族景颇族自治州'),('zh_CN', '275', '昭通市'),
('zh_CN', '276', '昆明市'),('zh_CN', '277', '大理白族自治州'),('zh_CN', '278', '红河哈尼族彝族自治州'),('zh_CN', '279', '曲靖市'),('zh_CN', '280', '保山市'),
('zh_CN', '281', '文山壮族苗族自治州'),('zh_CN', '282', '玉溪市'),('zh_CN', '283', '楚雄彝族自治州'),('zh_CN', '284', '普洱市'),('zh_CN', '285', '临沧市'),
('zh_CN', '286', '怒江傈傈族自治州'),('zh_CN', '287', '迪庆藏族自治州'),('zh_CN', '288', '丽江市'),('zh_CN', '289', '海北藏族自治州'),('zh_CN', '290', '西宁市'),
('zh_CN', '291', '海东地区'),('zh_CN', '292', '黄南藏族自治州'),('zh_CN', '293', '海南藏族自治州'),('zh_CN', '294', '果洛藏族自治州'),('zh_CN', '295', '玉树藏族自治州'),
('zh_CN', '296', '海西蒙古族藏族自治州'),('zh_CN', '297', '西安市'),('zh_CN', '298', '咸阳市'),('zh_CN', '299', '延安市'),('zh_CN', '300', '榆林市'),
('zh_CN', '301', '渭南市'),('zh_CN', '302', '商洛市'),('zh_CN', '303', '安康市'),('zh_CN', '304', '汉中市'),('zh_CN', '305', '宝鸡市'),
('zh_CN', '306', '铜川市'),('zh_CN', '307', '防城港市'),('zh_CN', '308', '南宁市'),('zh_CN', '309', '崇左市'),('zh_CN', '310', '来宾市'),
('zh_CN', '311', '柳州市'),('zh_CN', '312', '桂林市'),('zh_CN', '313', '梧州市'),('zh_CN', '314', '贺州市'),('zh_CN', '315', '贵港市'),
('zh_CN', '316', '玉林市'),('zh_CN', '317', '百色市'),('zh_CN', '318', '钦州市'),('zh_CN', '319', '河池市'),('zh_CN', '320', '北海市'),
('zh_CN', '321', '拉萨市'),('zh_CN', '322', '日喀则地区'),('zh_CN', '323', '山南地区'),('zh_CN', '324', '林芝地区'),('zh_CN', '325', '昌都地区'),
('zh_CN', '326', '那曲地区'),('zh_CN', '327', '阿里地区'),('zh_CN', '328', '银川市'),('zh_CN', '329', '石嘴山市'),('zh_CN', '330', '吴忠市'),
('zh_CN', '331', '固原市'),('zh_CN', '332', '中卫市'),('zh_CN', '333', '塔城地区'),('zh_CN', '334', '哈密地区'),('zh_CN', '335', '和田地区'),
('zh_CN', '336', '阿勒泰地区'),('zh_CN', '337', '克孜勒苏柯尔克孜自治州'),('zh_CN', '338', '博尔塔拉蒙古自治州'),('zh_CN', '339', '克拉玛依市'),('zh_CN', '340', '乌鲁木齐市'),
('zh_CN', '341', '石河子市'),('zh_CN', '342', '昌吉回族自治州'),('zh_CN', '343', '五家渠市'),('zh_CN', '344', '吐鲁番地区'),('zh_CN', '345', '巴音郭楞蒙古自治州'),
('zh_CN', '346', '阿克苏地区'),('zh_CN', '347', '阿拉尔市'),('zh_CN', '348', '喀什地区'),('zh_CN', '349', '图木舒克市'),('zh_CN', '350', '伊犁哈萨克自治州'),
('zh_CN', '351', '呼伦贝尔市'),('zh_CN', '352', '呼和浩特市'),('zh_CN', '353', '包头市'),('zh_CN', '354', '乌海市'),('zh_CN', '355', '乌兰察布市'),
('zh_CN', '356', '通辽市'),('zh_CN', '357', '赤峰市'),('zh_CN', '358', '鄂尔多斯市'),('zh_CN', '359', '巴彦淖尔市'),('zh_CN', '360', '锡林郭勒盟'),
('zh_CN', '361', '兴安盟'),('zh_CN', '362', '阿拉善盟'),('zh_CN', '363', '台北市'),('zh_CN', '364', '高雄市'),('zh_CN', '365', '基隆市'),
('zh_CN', '366', '台中市'),('zh_CN', '367', '台南市'),('zh_CN', '368', '新竹市'),('zh_CN', '369', '嘉义市'),('zh_CN', '370', '澳门特别行政区'),('zh_CN', '371', '香港特别行政区');

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_area')}`;
CREATE TABLE `{$installer->getTable('directory_country_area')}` (
  `area_id` mediumint(8) unsigned NOT NULL auto_increment,
  `city_id` mediumint(8) NOT NULL default '0',
  `default_name` varchar(255) default NULL,
  PRIMARY KEY  (`area_id`),
  KEY `FK_AREA_CITY` (`city_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Country areas';

INSERT INTO `{$installer->getTable('directory_country_area')}` VALUES
('1', '1', '东城区'),
('2', '1', '西城区'),
('3', '1', '崇文区'),
('4', '1', '宣武区'),
('5', '1', '朝阳区'),
('6', '1', '丰台区'),
('7', '1', '石景山区'),
('8', '1', '海淀区'),
('9', '1', '门头沟区'),
('10', '1', '房山区'),
('11', '1', '通州区'),
('12', '1', '顺义区'),
('13', '1', '昌平区'),
('14', '1', '大兴区'),
('15', '1', '怀柔区'),
('16', '1', '平谷区'),
('17', '1', '密云县'),
('18', '1', '延庆县'),
('19', '2', '和平区'),
('20', '2', '河东区'),
('21', '2', '河西区'),
('22', '2', '南开区'),
('23', '2', '河北区'),
('24', '2', '红桥区'),
('25', '2', '塘沽区'),
('26', '2', '汉沽区'),
('27', '2', '大港区'),
('28', '2', '东丽区'),
('29', '2', '西青区'),
('30', '2', '津南区'),
('31', '2', '北辰区'),
('32', '2', '武清区'),
('33', '2', '宝坻区'),
('34', '2', '宁河县'),
('35', '2', '静海县'),
('36', '2', '蓟县'),
('37', '3', '黄浦区'),
('38', '3', '卢湾区'),
('39', '3', '徐汇区'),
('40', '3', '长宁区'),
('41', '3', '静安区'),
('42', '3', '普陀区'),
('43', '3', '闸北区'),
('44', '3', '虹口区'),
('45', '3', '杨浦区'),
('46', '3', '闵行区'),
('47', '3', '宝山区'),
('48', '3', '嘉定区'),
('49', '3', '浦东新区'),
('50', '3', '金山区'),
('51', '3', '松江区'),
('52', '3', '青浦区'),
('53', '3', '南汇区'),
('54', '3', '奉贤区'),
('55', '3', '崇明县'),
('56', '4', '万州区'),
('57', '4', '涪陵区'),
('58', '4', '渝中区'),
('59', '4', '大渡口区'),
('60', '4', '江北区'),
('61', '4', '沙坪坝区'),
('62', '4', '九龙坡区'),
('63', '4', '南岸区'),
('64', '4', '北碚区'),
('65', '4', '万盛区'),
('66', '4', '双桥区'),
('67', '4', '渝北区'),
('68', '4', '巴南区'),
('69', '4', '黔江区'),
('70', '4', '长寿区'),
('71', '4', '江津区'),
('72', '4', '合川区'),
('73', '4', '永川区'),
('74', '4', '南川区'),
('75', '4', '綦江县'),
('76', '4', '潼南县'),
('77', '4', '铜梁县'),
('78', '4', '大足县'),
('79', '4', '荣昌县'),
('80', '4', '璧山县'),
('81', '4', '梁平县'),
('82', '4', '城口县'),
('83', '4', '丰都县'),
('84', '4', '垫江县'),
('85', '4', '武隆县'),
('86', '4', '忠县'),
('87', '4', '开县'),
('88', '4', '云阳县'),
('89', '4', '奉节县'),
('90', '4', '巫山县'),
('91', '4', '巫溪县'),
('92', '4', '石柱土家族自治县'),
('93', '4', '秀山土家族苗族自治县'),
('94', '4', '酉阳土家族苗族自治县'),
('95', '4', '彭水苗族土家族自治县'),
('96', '5', '邯山区'),
('97', '5', '丛台区'),
('98', '5', '复兴区'),
('99', '5', '峰峰矿区'),
('100', '5', '邯郸县'),
('101', '5', '临漳县'),
('102', '5', '成安县'),
('103', '5', '大名县'),
('104', '5', '涉县'),
('105', '5', '磁县'),
('106', '5', '肥乡县'),
('107', '5', '永年县'),
('108', '5', '邱县'),
('109', '5', '鸡泽县'),
('110', '5', '广平县'),
('111', '5', '馆陶县'),
('112', '5', '魏县'),
('113', '5', '曲周县'),
('114', '5', '武安市'),
('115', '6', '长安区'),
('116', '6', '桥东区'),
('117', '6', '桥西区'),
('118', '6', '新华区'),
('119', '6', '井陉矿区'),
('120', '6', '裕华区'),
('121', '6', '井陉县'),
('122', '6', '正定县'),
('123', '6', '栾城县'),
('124', '6', '行唐县'),
('125', '6', '灵寿县'),
('126', '6', '高邑县'),
('127', '6', '深泽县'),
('128', '6', '赞皇县'),
('129', '6', '无极县'),
('130', '6', '平山县'),
('131', '6', '元氏县'),
('132', '6', '赵县'),
('133', '6', '辛集市'),
('134', '6', '藁城市'),
('135', '6', '晋州市'),
('136', '6', '新乐市'),
('137', '6', '鹿泉市'),
('138', '7', '新市区'),
('139', '7', '北市区'),
('140', '7', '南市区'),
('141', '7', '满城县'),
('142', '7', '清苑县'),
('143', '7', '涞水县'),
('144', '7', '阜平县'),
('145', '7', '徐水县'),
('146', '7', '定兴县'),
('147', '7', '唐县'),
('148', '7', '高阳县'),
('149', '7', '容城县'),
('150', '7', '涞源县'),
('151', '7', '望都县'),
('152', '7', '安新县'),
('153', '7', '易县'),
('154', '7', '曲阳县'),
('155', '7', '蠡县'),
('156', '7', '顺平县'),
('157', '7', '博野县'),
('158', '7', '雄县'),
('159', '7', '涿州市'),
('160', '7', '定州市'),
('161', '7', '安国市'),
('162', '7', '高碑店市'),
('163', '8', '桥东区'),
('164', '8', '桥西区'),
('165', '8', '宣化区'),
('166', '8', '下花园区'),
('167', '8', '宣化县'),
('168', '8', '张北县'),
('169', '8', '康保县'),
('170', '8', '沽源县'),
('171', '8', '尚义县'),
('172', '8', '蔚县'),
('173', '8', '阳原县'),
('174', '8', '怀安县'),
('175', '8', '万全县'),
('176', '8', '怀来县'),
('177', '8', '涿鹿县'),
('178', '8', '赤城县'),
('179', '8', '崇礼县'),
('180', '9', '双桥区'),
('181', '9', '双滦区'),
('182', '9', '鹰手营子矿区'),
('183', '9', '承德县'),
('184', '9', '兴隆县'),
('185', '9', '平泉县'),
('186', '9', '滦平县'),
('187', '9', '隆化县'),
('188', '9', '丰宁满族自治县'),
('189', '9', '宽城满族自治县'),
('190', '9', '围场满族蒙古族自治县'),
('191', '10', '路南区'),
('192', '10', '路北区'),
('193', '10', '古冶区'),
('194', '10', '开平区'),
('195', '10', '丰南区'),
('196', '10', '丰润区'),
('197', '10', '滦县'),
('198', '10', '滦南县'),
('199', '10', '乐亭县'),
('200', '10', '迁西县'),
('201', '10', '玉田县'),
('202', '10', '唐海县'),
('203', '10', '遵化市'),
('204', '10', '迁安市'),
('205', '11', '安次区'),
('206', '11', '广阳区'),
('207', '11', '固安县'),
('208', '11', '永清县'),
('209', '11', '香河县'),
('210', '11', '大城县'),
('211', '11', '文安县'),
('212', '11', '大厂回族自治县'),
('213', '11', '霸州市'),
('214', '11', '三河市'),
('215', '12', '新华区'),
('216', '12', '运河区'),
('217', '12', '沧县'),
('218', '12', '青县'),
('219', '12', '东光县'),
('220', '12', '海兴县'),
('221', '12', '盐山县'),
('222', '12', '肃宁县'),
('223', '12', '南皮县'),
('224', '12', '吴桥县'),
('225', '12', '献县'),
('226', '12', '孟村回族自治县'),
('227', '12', '泊头市'),
('228', '12', '任丘市'),
('229', '12', '黄骅市'),
('230', '12', '河间市'),
('231', '13', '桃城区'),
('232', '13', '枣强县'),
('233', '13', '武邑县'),
('234', '13', '武强县'),
('235', '13', '饶阳县'),
('236', '13', '安平县'),
('237', '13', '故城县'),
('238', '13', '景县'),
('239', '13', '阜城县'),
('240', '13', '冀州市'),
('241', '13', '深州市'),
('242', '14', '桥东区'),
('243', '14', '桥西区'),
('244', '14', '邢台县'),
('245', '14', '临城县'),
('246', '14', '内丘县'),
('247', '14', '柏乡县'),
('248', '14', '隆尧县'),
('249', '14', '任县'),
('250', '14', '南和县'),
('251', '14', '宁晋县'),
('252', '14', '巨鹿县'),
('253', '14', '新河县'),
('254', '14', '广宗县'),
('255', '14', '平乡县'),
('256', '14', '威县'),
('257', '14', '清河县'),
('258', '14', '临西县'),
('259', '14', '南宫市'),
('260', '14', '沙河市'),
('261', '15', '海港区'),
('262', '15', '山海关区'),
('263', '15', '北戴河区'),
('264', '15', '青龙满族自治县'),
('265', '15', '昌黎县'),
('266', '15', '抚宁县'),
('267', '15', '卢龙县'),
('268', '16', '朔城区'),
('269', '16', '平鲁区'),
('270', '16', '山阴县'),
('271', '16', '应县'),
('272', '16', '右玉县'),
('273', '16', '怀仁县'),
('274', '17', '忻府区'),
('275', '17', '定襄县'),
('276', '17', '五台县'),
('277', '17', '代县'),
('278', '17', '繁峙县'),
('279', '17', '宁武县'),
('280', '17', '静乐县'),
('281', '17', '神池县'),
('282', '17', '五寨县'),
('283', '17', '岢岚县'),
('284', '17', '河曲县'),
('285', '17', '保德县'),
('286', '17', '偏关县'),
('287', '17', '原平市'),
('288', '18', '小店区'),
('289', '18', '迎泽区'),
('290', '18', '杏花岭区'),
('291', '18', '尖草坪区'),
('292', '18', '万柏林区'),
('293', '18', '晋源区'),
('294', '18', '清徐县'),
('295', '18', '阳曲县'),
('296', '18', '娄烦县'),
('297', '18', '古交市'),
('298', '19', '矿区'),
('299', '19', '南郊区'),
('300', '19', '新荣区'),
('301', '19', '阳高县'),
('302', '19', '天镇县'),
('303', '19', '广灵县'),
('304', '19', '灵丘县'),
('305', '19', '浑源县'),
('306', '19', '左云县'),
('307', '19', '大同县'),
('308', '20', '矿区'),
('309', '20', '平定县'),
('310', '20', '盂县'),
('311', '21', '榆次区'),
('312', '21', '榆社县'),
('313', '21', '左权县'),
('314', '21', '和顺县'),
('315', '21', '昔阳县'),
('316', '21', '寿阳县'),
('317', '21', '太谷县'),
('318', '21', '祁县'),
('319', '21', '平遥县'),
('320', '21', '灵石县'),
('321', '21', '介休市'),
('322', '22', '长治县'),
('323', '22', '襄垣县'),
('324', '22', '屯留县'),
('325', '22', '平顺县'),
('326', '22', '黎城县'),
('327', '22', '壶关县'),
('328', '22', '长子县'),
('329', '22', '武乡县'),
('330', '22', '沁县'),
('331', '22', '沁源县'),
('332', '22', '潞城市'),
('333', '23', '沁水县'),
('334', '23', '阳城县'),
('335', '23', '陵川县'),
('336', '23', '泽州县'),
('337', '23', '高平市'),
('338', '24', '尧都区'),
('339', '24', '曲沃县'),
('340', '24', '翼城县'),
('341', '24', '襄汾县'),
('342', '24', '洪洞县'),
('343', '24', '古县'),
('344', '24', '安泽县'),
('345', '24', '浮山县'),
('346', '24', '吉县'),
('347', '24', '乡宁县'),
('348', '24', '大宁县'),
('349', '24', '隰县'),
('350', '24', '永和县'),
('351', '24', '蒲县'),
('352', '24', '汾西县'),
('353', '24', '侯马市'),
('354', '24', '霍州市'),
('355', '25', '离石区'),
('356', '25', '文水县'),
('357', '25', '交城县'),
('358', '25', '兴县'),
('359', '25', '临县'),
('360', '25', '柳林县'),
('361', '25', '石楼县'),
('362', '25', '岚县'),
('363', '25', '方山县'),
('364', '25', '中阳县'),
('365', '25', '交口县'),
('366', '25', '孝义市'),
('367', '25', '汾阳市'),
('368', '26', '盐湖区'),
('369', '26', '临猗县'),
('370', '26', '万荣县'),
('371', '26', '闻喜县'),
('372', '26', '稷山县'),
('373', '26', '新绛县'),
('374', '26', '绛县'),
('375', '26', '垣曲县'),
('376', '26', '夏县'),
('377', '26', '平陆县'),
('378', '26', '芮城县'),
('379', '26', '永济市'),
('380', '26', '河津市'),
('381', '27', '和平区'),
('382', '27', '沈河区'),
('383', '27', '大东区'),
('384', '27', '皇姑区'),
('385', '27', '铁西区'),
('386', '27', '苏家屯区'),
('387', '27', '东陵区'),
('388', '27', '沈北新区'),
('389', '27', '于洪区'),
('390', '27', '辽中县'),
('391', '27', '康平县'),
('392', '27', '法库县'),
('393', '27', '新民市'),
('394', '28', '银州区'),
('395', '28', '清河区'),
('396', '28', '铁岭县'),
('397', '28', '西丰县'),
('398', '28', '昌图县'),
('399', '28', '调兵山市'),
('400', '28', '开原市'),
('401', '29', '长海县'),
('402', '29', '旅顺口区'),
('403', '29', '中山区'),
('404', '29', '西岗区'),
('405', '29', '沙河口区'),
('406', '29', '甘井子区'),
('407', '29', '金州区'),
('408', '29', '普兰店市'),
('409', '29', '瓦房店市'),
('410', '29', '庄河市'),
('411', '30', '铁东区'),
('412', '30', '铁西区'),
('413', '30', '立山区'),
('414', '30', '千山区'),
('415', '30', '台安县'),
('416', '30', '岫岩满族自治县'),
('417', '30', '海城市'),
('418', '31', '新抚区'),
('419', '31', '东洲区'),
('420', '31', '望花区'),
('421', '31', '顺城区'),
('422', '31', '抚顺县'),
('423', '31', '新宾满族自治县'),
('424', '31', '清原满族自治县'),
('425', '32', '平山区'),
('426', '32', '溪湖区'),
('427', '32', '明山区'),
('428', '32', '南芬区'),
('429', '32', '本溪满族自治县'),
('430', '32', '桓仁满族自治县'),
('431', '33', '元宝区'),
('432', '33', '振兴区'),
('433', '33', '振安区'),
('434', '33', '宽甸满族自治县'),
('435', '33', '东港市'),
('436', '33', '凤城市'),
('437', '34', '古塔区'),
('438', '34', '凌河区'),
('439', '34', '太和区'),
('440', '34', '黑山县'),
('441', '34', '义县'),
('442', '34', '凌海市'),
('443', '34', '北镇市'),
('444', '35', '站前区'),
('445', '35', '西市区'),
('446', '35', '鮁鱼圈区'),
('447', '35', '老边区'),
('448', '35', '盖州市'),
('449', '35', '大石桥市'),
('450', '36', '海州区'),
('451', '36', '新邱区'),
('452', '36', '太平区'),
('453', '36', '清河门区'),
('454', '36', '细河区'),
('455', '36', '阜新蒙古族自治县'),
('456', '36', '彰武县'),
('457', '37', '白塔区'),
('458', '37', '文圣区'),
('459', '37', '宏伟区'),
('460', '37', '弓长岭区'),
('461', '37', '太子河区'),
('462', '37', '辽阳县'),
('463', '37', '灯塔市'),
('464', '38', '双塔区'),
('465', '38', '龙城区'),
('466', '38', '朝阳县'),
('467', '38', '建平县'),
('468', '38', '喀喇沁左翼蒙古族自治县'),
('469', '38', '北票市'),
('470', '38', '凌源市'),
('471', '39', '双台子区'),
('472', '39', '兴隆台区'),
('473', '39', '大洼县'),
('474', '39', '盘山县'),
('475', '40', '连山区'),
('476', '40', '龙港区'),
('477', '40', '南票区'),
('478', '40', '绥中县'),
('479', '40', '建昌县'),
('480', '40', '兴城市'),
('481', '41', '南关区'),
('482', '41', '宽城区'),
('483', '41', '朝阳区'),
('484', '41', '二道区'),
('485', '41', '绿园区'),
('486', '41', '双阳区'),
('487', '41', '农安县'),
('488', '41', '九台市'),
('489', '41', '榆树市'),
('490', '41', '德惠市'),
('491', '42', '昌邑区'),
('492', '42', '龙潭区'),
('493', '42', '船营区'),
('494', '42', '丰满区'),
('495', '42', '永吉县'),
('496', '42', '蛟河市'),
('497', '42', '桦甸市'),
('498', '42', '舒兰市'),
('499', '42', '磐石市'),
('500', '43', '延吉市'),
('501', '43', '图们市'),
('502', '43', '敦化市'),
('503', '43', '珲春市'),
('504', '43', '龙井市'),
('505', '43', '和龙市'),
('506', '43', '汪清县'),
('507', '43', '安图县'),
('508', '44', '铁西区'),
('509', '44', '铁东区'),
('510', '44', '梨树县'),
('511', '44', '伊通满族自治县'),
('512', '44', '公主岭市'),
('513', '44', '双辽市'),
('514', '45', '东昌区'),
('515', '45', '二道江区'),
('516', '45', '通化县'),
('517', '45', '辉南县'),
('518', '45', '柳河县'),
('519', '45', '梅河口市'),
('520', '45', '集安市'),
('521', '46', '洮北区'),
('522', '46', '镇赉县'),
('523', '46', '通榆县'),
('524', '46', '洮南市'),
('525', '46', '大安市'),
('526', '47', '龙山区'),
('527', '47', '西安区'),
('528', '47', '东丰县'),
('529', '47', '东辽县'),
('530', '48', '宁江区'),
('531', '48', '前郭尔罗斯蒙古族自治县'),
('532', '48', '长岭县'),
('533', '48', '乾安县'),
('534', '48', '扶余县'),
('535', '49', '八道江区'),
('536', '49', '江源区'),
('537', '49', '抚松县'),
('538', '49', '靖宇县'),
('539', '49', '长白朝鲜族自治县'),
('540', '49', '临江市'),
('541', '50', '道里区'),
('542', '50', '南岗区'),
('543', '50', '道外区'),
('544', '50', '平房区'),
('545', '50', '松北区'),
('546', '50', '香坊区'),
('547', '50', '呼兰区'),
('548', '50', '阿城区'),
('549', '50', '依兰县'),
('550', '50', '方正县'),
('551', '50', '宾县'),
('552', '50', '巴彦县'),
('553', '50', '木兰县'),
('554', '50', '通河县'),
('555', '50', '延寿县'),
('556', '50', '双城市'),
('557', '50', '尚志市'),
('558', '50', '五常市'),
('559', '51', '龙沙区'),
('560', '51', '建华区'),
('561', '51', '铁锋区'),
('562', '51', '昂昂溪区'),
('563', '51', '富拉尔基区'),
('564', '51', '碾子山区'),
('565', '51', '梅里斯达翰尔族区'),
('566', '51', '龙江县'),
('567', '51', '依安县'),
('568', '51', '泰来县'),
('569', '51', '甘南县'),
('570', '51', '富裕县'),
('571', '51', '克山县'),
('572', '51', '克东县'),
('573', '51', '拜泉县'),
('574', '51', '讷河市'),
('575', '52', '鸡冠区'),
('576', '52', '恒山区'),
('577', '52', '滴道区'),
('578', '52', '梨树区'),
('579', '52', '城子河区'),
('580', '52', '麻山区'),
('581', '52', '鸡东县'),
('582', '52', '虎林市'),
('583', '52', '密山市'),
('584', '53', '东安区'),
('585', '53', '阳明区'),
('586', '53', '爱民区'),
('587', '53', '西安区'),
('588', '53', '东宁县'),
('589', '53', '林口县'),
('590', '53', '绥芬河市'),
('591', '53', '海林市'),
('592', '53', '宁安市'),
('593', '53', '穆棱市'),
('594', '54', '新兴区'),
('595', '54', '桃山区'),
('596', '54', '茄子河区'),
('597', '54', '勃利县'),
('598', '55', '向阳区'),
('599', '55', '前进区'),
('600', '55', '东风区'),
('601', '55', '桦南县'),
('602', '55', '桦川县'),
('603', '55', '汤原县'),
('604', '55', '抚远县'),
('605', '55', '同江市'),
('606', '55', '富锦市'),
('607', '56', '向阳区'),
('608', '56', '工农区'),
('609', '56', '南山区'),
('610', '56', '兴安区'),
('611', '56', '东山区'),
('612', '56', '兴山区'),
('613', '56', '萝北县'),
('614', '56', '绥滨县'),
('615', '57', '尖山区'),
('616', '57', '岭东区'),
('617', '57', '四方台区'),
('618', '57', '宝山区'),
('619', '57', '集贤县'),
('620', '57', '友谊县'),
('621', '57', '宝清县'),
('622', '57', '饶河县'),
('623', '58', '北林区'),
('624', '58', '望奎县'),
('625', '58', '兰西县'),
('626', '58', '青冈县'),
('627', '58', '庆安县'),
('628', '58', '明水县'),
('629', '58', '绥棱县'),
('630', '58', '安达市'),
('631', '58', '肇东市'),
('632', '58', '海伦市'),
('633', '59', '爱辉区'),
('634', '59', '嫩江县'),
('635', '59', '逊克县'),
('636', '59', '孙吴县'),
('637', '59', '北安市'),
('638', '59', '五大连池市'),
('639', '60', '呼玛县'),
('640', '60', '塔河县'),
('641', '60', '漠河县'),
('642', '61', '伊春区'),
('643', '61', '南岔区'),
('644', '61', '友好区'),
('645', '61', '西林区'),
('646', '61', '翠峦区'),
('647', '61', '新青区'),
('648', '61', '美溪区'),
('649', '61', '金山屯区'),
('650', '61', '五营区'),
('651', '61', '乌马河区'),
('652', '61', '汤旺河区'),
('653', '61', '带岭区'),
('654', '61', '乌伊岭区'),
('655', '61', '红星区'),
('656', '61', '上甘岭区'),
('657', '61', '嘉荫县'),
('658', '61', '铁力市'),
('659', '62', '萨尔图区'),
('660', '62', '龙凤区'),
('661', '62', '让胡路区'),
('662', '62', '红岗区'),
('663', '62', '大同区'),
('664', '62', '肇州县'),
('665', '62', '肇源县'),
('666', '62', '林甸县'),
('667', '62', '杜尔伯特蒙古族自治县'),
('668', '63', '江宁区'),
('669', '63', '浦口区'),
('670', '63', '玄武区'),
('671', '63', '白下区'),
('672', '63', '秦淮区'),
('673', '63', '建邺区'),
('674', '63', '鼓楼区'),
('675', '63', '下关区'),
('676', '63', '栖霞区'),
('677', '63', '雨花台区'),
('678', '63', '六合区'),
('679', '63', '溧水县'),
('680', '63', '高淳县'),
('681', '64', '崇安区'),
('682', '64', '南长区'),
('683', '64', '北塘区'),
('684', '64', '锡山区'),
('685', '64', '惠山区'),
('686', '64', '滨湖区'),
('687', '64', '江阴市'),
('688', '64', '宜兴市'),
('689', '65', '京口区'),
('690', '65', '润州区'),
('691', '65', '丹徒区'),
('692', '65', '丹阳市'),
('693', '65', '扬中市'),
('694', '65', '句容市'),
('695', '66', '沧浪区'),
('696', '66', '常熟市'),
('697', '66', '平江区'),
('698', '66', '金阊区'),
('699', '66', '虎丘区'),
('700', '66', '昆山市'),
('701', '66', '太仓市'),
('702', '66', '吴江市'),
('703', '66', '吴中区'),
('704', '66', '相城区'),
('705', '66', '张家港市'),
('706', '67', '崇川区'),
('707', '67', '港闸区'),
('708', '67', '海安县'),
('709', '67', '如东县'),
('710', '67', '启东市'),
('711', '67', '如皋市'),
('712', '67', '通州市'),
('713', '67', '海门市'),
('714', '68', '高邮市'),
('715', '68', '广陵区'),
('716', '68', '邗江区'),
('717', '68', '维扬区'),
('718', '68', '宝应县'),
('719', '68', '江都市'),
('720', '68', '仪征市'),
('721', '69', '亭湖区'),
('722', '69', '盐都区'),
('723', '69', '响水县'),
('724', '69', '滨海县'),
('725', '69', '阜宁县'),
('726', '69', '射阳县'),
('727', '69', '建湖县'),
('728', '69', '东台市'),
('729', '69', '大丰市'),
('730', '70', '鼓楼区'),
('731', '70', '云龙区'),
('732', '70', '九里区'),
('733', '70', '贾汪区'),
('734', '70', '泉山区'),
('735', '70', '丰县'),
('736', '70', '沛县'),
('737', '70', '铜山县'),
('738', '70', '睢宁县'),
('739', '70', '新沂市'),
('740', '70', '邳州市'),
('741', '71', '清河区'),
('742', '71', '楚州区'),
('743', '71', '淮阴区'),
('744', '71', '清浦区'),
('745', '71', '涟水县'),
('746', '71', '洪泽县'),
('747', '71', '盱眙县'),
('748', '71', '金湖县'),
('749', '72', '连云区'),
('750', '72', '新浦区'),
('751', '72', '海州区'),
('752', '72', '赣榆县'),
('753', '72', '东海县'),
('754', '72', '灌云县'),
('755', '72', '灌南县'),
('756', '73', '天宁区'),
('757', '73', '钟楼区'),
('758', '73', '戚墅堰区'),
('759', '73', '新北区'),
('760', '73', '武进区'),
('761', '73', '溧阳市'),
('762', '73', '金坛市'),
('763', '74', '海陵区'),
('764', '74', '高港区'),
('765', '74', '兴化市'),
('766', '74', '靖江市'),
('767', '74', '泰兴市'),
('768', '74', '姜堰市'),
('769', '75', '宿城区'),
('770', '75', '宿豫区'),
('771', '75', '沭阳县'),
('772', '75', '泗阳县'),
('773', '75', '泗洪县'),
('774', '76', '定海区'),
('775', '76', '普陀区'),
('776', '76', '岱山县'),
('777', '76', '嵊泗县'),
('778', '77', '柯城区'),
('779', '77', '衢江区'),
('780', '77', '常山县'),
('781', '77', '开化县'),
('782', '77', '龙游县'),
('783', '77', '江山市'),
('784', '78', '上城区'),
('785', '78', '下城区'),
('786', '78', '江干区'),
('787', '78', '拱墅区'),
('788', '78', '西湖区'),
('789', '78', '滨江区'),
('790', '78', '余杭区'),
('791', '78', '桐庐县'),
('792', '78', '淳安县'),
('793', '78', '建德市'),
('794', '78', '富阳市'),
('795', '78', '临安市'),
('796', '78', '萧山区'),
('797', '79', '吴兴区'),
('798', '79', '南浔区'),
('799', '79', '德清县'),
('800', '79', '长兴县'),
('801', '79', '安吉县'),
('802', '80', '南湖区'),
('803', '80', '秀洲区'),
('804', '80', '嘉善县'),
('805', '80', '海盐县'),
('806', '80', '海宁市'),
('807', '80', '平湖市'),
('808', '80', '桐乡市'),
('809', '81', '海曙区'),
('810', '81', '江东区'),
('811', '81', '江北区'),
('812', '81', '北仑区'),
('813', '81', '镇海区'),
('814', '81', '鄞州区'),
('815', '81', '象山县'),
('816', '81', '宁海县'),
('817', '81', '余姚市'),
('818', '81', '慈溪市'),
('819', '81', '奉化市'),
('820', '82', '越城区'),
('821', '82', '绍兴县'),
('822', '82', '新昌县'),
('823', '82', '诸暨市'),
('824', '82', '上虞市'),
('825', '82', '嵊州市'),
('826', '83', '鹿城区'),
('827', '83', '龙湾区'),
('828', '83', '瓯海区'),
('829', '83', '洞头县'),
('830', '83', '永嘉县'),
('831', '83', '平阳县'),
('832', '83', '苍南县'),
('833', '83', '文成县'),
('834', '83', '泰顺县'),
('835', '83', '瑞安市'),
('836', '83', '乐清市'),
('837', '84', '莲都区'),
('838', '84', '青田县'),
('839', '84', '缙云县'),
('840', '84', '遂昌县'),
('841', '84', '松阳县'),
('842', '84', '云和县'),
('843', '84', '庆元县'),
('844', '84', '景宁畲族自治县'),
('845', '84', '龙泉市'),
('846', '85', '婺城区'),
('847', '85', '金东区'),
('848', '85', '武义县'),
('849', '85', '浦江县'),
('850', '85', '磐安县'),
('851', '85', '兰溪市'),
('852', '85', '义乌市'),
('853', '85', '东阳市'),
('854', '85', '永康市'),
('855', '86', '椒江区'),
('856', '86', '黄岩区'),
('857', '86', '路桥区'),
('858', '86', '玉环县'),
('859', '86', '三门县'),
('860', '86', '天台县'),
('861', '86', '仙居县'),
('862', '86', '温岭市'),
('863', '86', '临海市'),
('864', '87', '瑶海区'),
('865', '87', '庐阳区'),
('866', '87', '蜀山区'),
('867', '87', '包河区'),
('868', '87', '长丰县'),
('869', '87', '肥东县'),
('870', '87', '肥西县'),
('871', '88', '镜湖区'),
('872', '88', '弋江区'),
('873', '88', '鸠江区'),
('874', '88', '三山区'),
('875', '88', '芜湖县'),
('876', '88', '繁昌县'),
('877', '88', '南陵县'),
('878', '89', '龙子湖区'),
('879', '89', '蚌山区'),
('880', '89', '禹会区'),
('881', '89', '淮上区'),
('882', '89', '怀远县'),
('883', '89', '五河县'),
('884', '89', '固镇县'),
('885', '90', '大通区'),
('886', '90', '田家庵区'),
('887', '90', '谢家集区'),
('888', '90', '八公山区'),
('889', '90', '潘集区'),
('890', '90', '凤台县'),
('891', '91', '金家庄区'),
('892', '91', '花山区'),
('893', '91', '雨山区'),
('894', '91', '当涂县'),
('895', '92', '杜集区'),
('896', '92', '相山区'),
('897', '92', '烈山区'),
('898', '92', '濉溪县'),
('899', '93', '铜官山区'),
('900', '93', '狮子山区'),
('901', '93', '铜陵县'),
('902', '94', '迎江区'),
('903', '94', '大观区'),
('904', '94', '宜秀区'),
('905', '94', '怀宁县'),
('906', '94', '枞阳县'),
('907', '94', '潜山县'),
('908', '94', '太湖县'),
('909', '94', '宿松县'),
('910', '94', '望江县'),
('911', '94', '岳西县'),
('912', '94', '桐城市'),
('913', '95', '屯溪区'),
('914', '95', '黄山区'),
('915', '95', '徽州区'),
('916', '95', '歙县'),
('917', '95', '休宁县'),
('918', '95', '黟县'),
('919', '95', '祁门县'),
('920', '96', '琅琊区'),
('921', '96', '南谯区'),
('922', '96', '来安县'),
('923', '96', '全椒县'),
('924', '96', '定远县'),
('925', '96', '凤阳县'),
('926', '96', '天长市'),
('927', '96', '明光市'),
('928', '97', '颍州区'),
('929', '97', '颍东区'),
('930', '97', '颍泉区'),
('931', '97', '临泉县'),
('932', '97', '太和县'),
('933', '97', '阜南县'),
('934', '97', '颍上县'),
('935', '97', '界首市'),
('936', '98', '埇桥区'),
('937', '98', '砀山县'),
('938', '98', '萧县'),
('939', '98', '灵璧县'),
('940', '98', '泗县'),
('941', '99', '居巢区'),
('942', '99', '庐江县'),
('943', '99', '无为县'),
('944', '99', '含山县'),
('945', '99', '和县'),
('946', '100', '金安区'),
('947', '100', '裕安区'),
('948', '100', '寿县'),
('949', '100', '霍邱县'),
('950', '100', '舒城县'),
('951', '100', '金寨县'),
('952', '100', '霍山县'),
('953', '101', '谯城区'),
('954', '101', '涡阳县'),
('955', '101', '蒙城县'),
('956', '101', '利辛县'),
('957', '102', '贵池区'),
('958', '102', '东至县'),
('959', '102', '石台县'),
('960', '102', '青阳县'),
('961', '103', '宣州区'),
('962', '103', '郎溪县'),
('963', '103', '广德县'),
('964', '103', '泾县'),
('965', '103', '绩溪县'),
('966', '103', '旌德县'),
('967', '103', '宁国市'),
('968', '104', '鼓楼区'),
('969', '104', '台江区'),
('970', '104', '仓山区'),
('971', '104', '马尾区'),
('972', '104', '晋安区'),
('973', '104', '闽侯县'),
('974', '104', '连江县'),
('975', '104', '罗源县'),
('976', '104', '闽清县'),
('977', '104', '永泰县'),
('978', '104', '平潭县'),
('979', '104', '福清市'),
('980', '104', '长乐市'),
('981', '105', '思明区'),
('982', '105', '海沧区'),
('983', '105', '湖里区'),
('984', '105', '集美区'),
('985', '105', '同安区'),
('986', '105', '翔安区'),
('987', '106', '蕉城区'),
('988', '106', '霞浦县'),
('989', '106', '古田县'),
('990', '106', '屏南县'),
('991', '106', '寿宁县'),
('992', '106', '周宁县'),
('993', '106', '柘荣县'),
('994', '106', '福安市'),
('995', '106', '福鼎市'),
('996', '107', '城厢区'),
('997', '107', '涵江区'),
('998', '107', '荔城区'),
('999', '107', '秀屿区'),
('1000', '107', '仙游县'),
('1001', '108', '鲤城区'),
('1002', '108', '丰泽区'),
('1003', '108', '洛江区'),
('1004', '108', '泉港区'),
('1005', '108', '惠安县'),
('1006', '108', '安溪县'),
('1007', '108', '永春县'),
('1008', '108', '德化县'),
('1009', '108', '石狮市'),
('1010', '108', '晋江市'),
('1011', '108', '南安市'),
('1012', '109', '芗城区'),
('1013', '109', '龙文区'),
('1014', '109', '云霄县'),
('1015', '109', '漳浦县'),
('1016', '109', '诏安县'),
('1017', '109', '长泰县'),
('1018', '109', '东山县'),
('1019', '109', '南靖县'),
('1020', '109', '平和县'),
('1021', '109', '华安县'),
('1022', '109', '龙海市'),
('1023', '110', '新罗区'),
('1024', '110', '长汀县'),
('1025', '110', '永定县'),
('1026', '110', '上杭县'),
('1027', '110', '武平县'),
('1028', '110', '连城县'),
('1029', '110', '漳平市'),
('1030', '111', '梅列区'),
('1031', '111', '三元区'),
('1032', '111', '明溪县'),
('1033', '111', '清流县'),
('1034', '111', '宁化县'),
('1035', '111', '大田县'),
('1036', '111', '尤溪县'),
('1037', '111', '沙县'),
('1038', '111', '将乐县'),
('1039', '111', '泰宁县'),
('1040', '111', '建宁县'),
('1041', '111', '永安市'),
('1042', '112', '延平区'),
('1043', '112', '顺昌县'),
('1044', '112', '浦城县'),
('1045', '112', '光泽县'),
('1046', '112', '松溪县'),
('1047', '112', '政和县'),
('1048', '112', '邵武市'),
('1049', '112', '武夷山市'),
('1050', '112', '建瓯市'),
('1051', '112', '建阳市'),
('1052', '113', '月湖区'),
('1053', '113', '余江县'),
('1054', '113', '贵溪市'),
('1055', '114', '渝水区'),
('1056', '114', '分宜县'),
('1057', '115', '东湖区'),
('1058', '115', '西湖区'),
('1059', '115', '青云谱区'),
('1060', '115', '湾里区'),
('1061', '115', '青山湖区'),
('1062', '115', '南昌县'),
('1063', '115', '新建县'),
('1064', '115', '安义县'),
('1065', '115', '进贤县'),
('1066', '116', '庐山区'),
('1067', '116', '浔阳区'),
('1068', '116', '九江县'),
('1069', '116', '武宁县'),
('1070', '116', '修水县'),
('1071', '116', '永修县'),
('1072', '116', '德安县'),
('1073', '116', '星子县'),
('1074', '116', '都昌县'),
('1075', '116', '湖口县'),
('1076', '116', '彭泽县'),
('1077', '116', '瑞昌市'),
('1078', '117', '信州区'),
('1079', '117', '上饶县'),
('1080', '117', '广丰县'),
('1081', '117', '玉山县'),
('1082', '117', '铅山县'),
('1083', '117', '横峰县'),
('1084', '117', '弋阳县'),
('1085', '117', '余干县'),
('1086', '117', '鄱阳县'),
('1087', '117', '万年县'),
('1088', '117', '婺源县'),
('1089', '117', '德兴市'),
('1090', '118', '临川区'),
('1091', '118', '南城县'),
('1092', '118', '黎川县'),
('1093', '118', '南丰县'),
('1094', '118', '崇仁县'),
('1095', '118', '乐安县'),
('1096', '118', '宜黄县'),
('1097', '118', '金溪县'),
('1098', '118', '资溪县'),
('1099', '118', '东乡县'),
('1100', '118', '广昌县'),
('1101', '119', '袁州区'),
('1102', '119', '奉新县'),
('1103', '119', '万载县'),
('1104', '119', '上高县'),
('1105', '119', '宜丰县'),
('1106', '119', '靖安县'),
('1107', '119', '铜鼓县'),
('1108', '119', '丰城市'),
('1109', '119', '樟树市'),
('1110', '119', '高安市'),
('1111', '120', '吉州区'),
('1112', '120', '青原区'),
('1113', '120', '吉安县'),
('1114', '120', '吉水县'),
('1115', '120', '峡江县'),
('1116', '120', '新干县'),
('1117', '120', '永丰县'),
('1118', '120', '泰和县'),
('1119', '120', '遂川县'),
('1120', '120', '万安县'),
('1121', '120', '安福县'),
('1122', '120', '永新县'),
('1123', '120', '井冈山市'),
('1124', '121', '章贡区'),
('1125', '121', '赣县'),
('1126', '121', '信丰县'),
('1127', '121', '大余县'),
('1128', '121', '上犹县'),
('1129', '121', '崇义县'),
('1130', '121', '安远县'),
('1131', '121', '龙南县'),
('1132', '121', '定南县'),
('1133', '121', '全南县'),
('1134', '121', '宁都县'),
('1135', '121', '于都县'),
('1136', '121', '兴国县'),
('1137', '121', '会昌县'),
('1138', '121', '寻乌县'),
('1139', '121', '石城县'),
('1140', '121', '瑞金市'),
('1141', '121', '南康市'),
('1142', '122', '昌江区'),
('1143', '122', '珠山区'),
('1144', '122', '浮梁县'),
('1145', '122', '乐平市'),
('1146', '123', '安源区'),
('1147', '123', '湘东区'),
('1148', '123', '莲花县'),
('1149', '123', '上栗县'),
('1150', '123', '芦溪县'),
('1151', '124', '牡丹区'),
('1152', '124', '曹县'),
('1153', '124', '单县'),
('1154', '124', '成武县'),
('1155', '124', '巨野县'),
('1156', '124', '郓城县'),
('1157', '124', '鄄城县'),
('1158', '124', '定陶县'),
('1159', '124', '东明县'),
('1160', '125', '历下区'),
('1161', '125', '市中区'),
('1162', '125', '槐荫区'),
('1163', '125', '天桥区'),
('1164', '125', '历城区'),
('1165', '125', '长清区'),
('1166', '125', '平阴县'),
('1167', '125', '济阳县'),
('1168', '125', '商河县'),
('1169', '125', '章丘市'),
('1170', '126', '市南区'),
('1171', '126', '市北区'),
('1172', '126', '四方区'),
('1173', '126', '黄岛区'),
('1174', '126', '崂山区'),
('1175', '126', '李沧区'),
('1176', '126', '城阳区'),
('1177', '126', '胶州市'),
('1178', '126', '即墨市'),
('1179', '126', '平度市'),
('1180', '126', '胶南市'),
('1181', '126', '莱西市'),
('1182', '127', '淄川区'),
('1183', '127', '张店区'),
('1184', '127', '博山区'),
('1185', '127', '临淄区'),
('1186', '127', '周村区'),
('1187', '127', '桓台县'),
('1188', '127', '高青县'),
('1189', '127', '沂源县'),
('1190', '128', '德城区'),
('1191', '128', '陵县'),
('1192', '128', '宁津县'),
('1193', '128', '庆云县'),
('1194', '128', '临邑县'),
('1195', '128', '齐河县'),
('1196', '128', '平原县'),
('1197', '128', '夏津县'),
('1198', '128', '武城县'),
('1199', '128', '乐陵市'),
('1200', '128', '禹城市'),
('1201', '129', '芝罘区'),
('1202', '129', '福山区'),
('1203', '129', '牟平区'),
('1204', '129', '莱山区'),
('1205', '129', '长岛县'),
('1206', '129', '龙口市'),
('1207', '129', '莱阳市'),
('1208', '129', '莱州市'),
('1209', '129', '蓬莱市'),
('1210', '129', '招远市'),
('1211', '129', '栖霞市'),
('1212', '129', '海阳市'),
('1213', '130', '潍城区'),
('1214', '130', '寒亭区'),
('1215', '130', '坊子区'),
('1216', '130', '奎文区'),
('1217', '130', '临朐县'),
('1218', '130', '昌乐县'),
('1219', '130', '青州市'),
('1220', '130', '诸城市'),
('1221', '130', '寿光市'),
('1222', '130', '安丘市'),
('1223', '130', '高密市'),
('1224', '130', '昌邑市'),
('1225', '131', '市中区'),
('1226', '131', '任城区'),
('1227', '131', '微山县'),
('1228', '131', '鱼台县'),
('1229', '131', '金乡县'),
('1230', '131', '嘉祥县'),
('1231', '131', '汶上县'),
('1232', '131', '泗水县'),
('1233', '131', '梁山县'),
('1234', '131', '曲阜市'),
('1235', '131', '兖州市'),
('1236', '131', '邹城市'),
('1237', '132', '泰山区'),
('1238', '132', '岱岳区'),
('1239', '132', '宁阳县'),
('1240', '132', '东平县'),
('1241', '132', '新泰市'),
('1242', '132', '肥城市'),
('1243', '133', '兰山区'),
('1244', '133', '罗庄区'),
('1245', '133', '河东区'),
('1246', '133', '沂南县'),
('1247', '133', '郯城县'),
('1248', '133', '沂水县'),
('1249', '133', '苍山县'),
('1250', '133', '费县'),
('1251', '133', '平邑县'),
('1252', '133', '莒南县'),
('1253', '133', '蒙阴县'),
('1254', '133', '临沭县'),
('1255', '134', '滨城区'),
('1256', '134', '惠民县'),
('1257', '134', '阳信县'),
('1258', '134', '无棣县'),
('1259', '134', '沾化县'),
('1260', '134', '博兴县'),
('1261', '134', '邹平县'),
('1262', '135', '东营区'),
('1263', '135', '河口区'),
('1264', '135', '垦利县'),
('1265', '135', '利津县'),
('1266', '135', '广饶县'),
('1267', '136', '环翠区'),
('1268', '136', '文登市'),
('1269', '136', '荣成市'),
('1270', '136', '乳山市'),
('1271', '137', '市中区'),
('1272', '137', '薛城区'),
('1273', '137', '峄城区'),
('1274', '137', '台儿庄区'),
('1275', '137', '山亭区'),
('1276', '137', '滕州市'),
('1277', '138', '东港区'),
('1278', '138', '岚山区'),
('1279', '138', '五莲县'),
('1280', '138', '莒县'),
('1281', '139', '莱城区'),
('1282', '139', '钢城区'),
('1283', '140', '东昌府区'),
('1284', '140', '阳谷县'),
('1285', '140', '莘县'),
('1286', '140', '茌平县'),
('1287', '140', '东阿县'),
('1288', '140', '冠县'),
('1289', '140', '高唐县'),
('1290', '140', '临清市'),
('1291', '141', '梁园区'),
('1292', '141', '睢阳区'),
('1293', '141', '民权县'),
('1294', '141', '睢县'),
('1295', '141', '宁陵县'),
('1296', '141', '柘城县'),
('1297', '141', '虞城县'),
('1298', '141', '夏邑县'),
('1299', '141', '永城市'),
('1300', '142', '中原区'),
('1301', '142', '二七区'),
('1302', '142', '管城回族区'),
('1303', '142', '金水区'),
('1304', '142', '上街区'),
('1305', '142', '惠济区'),
('1306', '142', '中牟县'),
('1307', '142', '巩义市'),
('1308', '142', '荥阳市'),
('1309', '142', '新密市'),
('1310', '142', '新郑市'),
('1311', '142', '登封市'),
('1312', '143', '文峰区'),
('1313', '143', '北关区'),
('1314', '143', '殷都区'),
('1315', '143', '龙安区'),
('1316', '143', '安阳县'),
('1317', '143', '汤阴县'),
('1318', '143', '滑县'),
('1319', '143', '内黄县'),
('1320', '143', '林州市'),
('1321', '144', '红旗区'),
('1322', '144', '卫滨区'),
('1323', '144', '凤泉区'),
('1324', '144', '牧野区'),
('1325', '144', '新乡县'),
('1326', '144', '获嘉县'),
('1327', '144', '原阳县'),
('1328', '144', '延津县'),
('1329', '144', '封丘县'),
('1330', '144', '长垣县'),
('1331', '144', '卫辉市'),
('1332', '144', '辉县市'),
('1333', '145', '魏都区'),
('1334', '145', '许昌县'),
('1335', '145', '鄢陵县'),
('1336', '145', '襄城县'),
('1337', '145', '禹州市'),
('1338', '145', '长葛市'),
('1339', '146', '新华区'),
('1340', '146', '卫东区'),
('1341', '146', '石龙区'),
('1342', '146', '湛河区'),
('1343', '146', '宝丰县'),
('1344', '146', '叶县'),
('1345', '146', '鲁山县'),
('1346', '146', '郏县'),
('1347', '146', '舞钢市'),
('1348', '146', '汝州市'),
('1349', '147', '浉河区'),
('1350', '147', '平桥区'),
('1351', '147', '罗山县'),
('1352', '147', '光山县'),
('1353', '147', '新县'),
('1354', '147', '商城县'),
('1355', '147', '固始县'),
('1356', '147', '潢川县'),
('1357', '147', '淮滨县'),
('1358', '147', '息县'),
('1359', '148', '宛城区'),
('1360', '148', '卧龙区'),
('1361', '148', '南召县'),
('1362', '148', '方城县'),
('1363', '148', '西峡县'),
('1364', '148', '镇平县'),
('1365', '148', '内乡县'),
('1366', '148', '淅川县'),
('1367', '148', '社旗县'),
('1368', '148', '唐河县'),
('1369', '148', '新野县'),
('1370', '148', '桐柏县'),
('1371', '148', '邓州市'),
('1372', '149', '龙亭区'),
('1373', '149', '顺河回族区'),
('1374', '149', '鼓楼区'),
('1375', '149', '禹王台区'),
('1376', '149', '金明区'),
('1377', '149', '杞县'),
('1378', '149', '通许县'),
('1379', '149', '尉氏县'),
('1380', '149', '开封县'),
('1381', '149', '兰考县'),
('1382', '150', '老城区'),
('1383', '150', '西工区'),
('1384', '150', '瀍河回族区'),
('1385', '150', '涧西区'),
('1386', '150', '吉利区'),
('1387', '150', '洛龙区'),
('1388', '150', '孟津县'),
('1389', '150', '新安县'),
('1390', '150', '栾川县'),
('1391', '150', '嵩县'),
('1392', '150', '汝阳县'),
('1393', '150', '宜阳县'),
('1394', '150', '洛宁县'),
('1395', '150', '伊川县'),
('1396', '150', '偃师市'),
('1397', '152', '解放区'),
('1398', '152', '中站区'),
('1399', '152', '马村区'),
('1400', '152', '山阳区'),
('1401', '152', '修武县'),
('1402', '152', '博爱县'),
('1403', '152', '武陟县'),
('1404', '152', '温县'),
('1405', '152', '沁阳市'),
('1406', '152', '孟州市'),
('1407', '153', '鹤山区'),
('1408', '153', '山城区'),
('1409', '153', '淇滨区'),
('1410', '153', '浚县'),
('1411', '153', '淇县'),
('1412', '154', '华龙区'),
('1413', '154', '清丰县'),
('1414', '154', '南乐县'),
('1415', '154', '范县'),
('1416', '154', '台前县'),
('1417', '154', '濮阳县'),
('1418', '155', '川汇区'),
('1419', '155', '扶沟县'),
('1420', '155', '西华县'),
('1421', '155', '商水县'),
('1422', '155', '沈丘县'),
('1423', '155', '郸城县'),
('1424', '155', '淮阳县'),
('1425', '155', '太康县'),
('1426', '155', '鹿邑县'),
('1427', '155', '项城市'),
('1428', '156', '源汇区'),
('1429', '156', '郾城区'),
('1430', '156', '召陵区'),
('1431', '156', '舞阳县'),
('1432', '156', '临颍县'),
('1433', '157', '驿城区'),
('1434', '157', '西平县'),
('1435', '157', '上蔡县'),
('1436', '157', '平舆县'),
('1437', '157', '正阳县'),
('1438', '157', '确山县'),
('1439', '157', '泌阳县'),
('1440', '157', '汝南县'),
('1441', '157', '遂平县'),
('1442', '157', '新蔡县'),
('1443', '158', '湖滨区'),
('1444', '158', '渑池县'),
('1445', '158', '陕县'),
('1446', '158', '卢氏县'),
('1447', '158', '义马市'),
('1448', '158', '灵宝市'),
('1449', '159', '江岸区'),
('1450', '159', '江汉区'),
('1451', '159', '硚口区'),
('1452', '159', '汉阳区'),
('1453', '159', '武昌区'),
('1454', '159', '青山区'),
('1455', '159', '洪山区'),
('1456', '159', '东西湖区'),
('1457', '159', '汉南区'),
('1458', '159', '蔡甸区'),
('1459', '159', '江夏区'),
('1460', '159', '黄陂区'),
('1461', '159', '新洲区'),
('1462', '160', '襄城区'),
('1463', '160', '樊城区'),
('1464', '160', '襄阳区'),
('1465', '160', '南漳县'),
('1466', '160', '谷城县'),
('1467', '160', '保康县'),
('1468', '160', '老河口市'),
('1469', '160', '枣阳市'),
('1470', '160', '宜城市'),
('1471', '161', '梁子湖区'),
('1472', '161', '华容区'),
('1473', '161', '鄂城区'),
('1474', '162', '孝南区'),
('1475', '162', '孝昌县'),
('1476', '162', '大悟县'),
('1477', '162', '云梦县'),
('1478', '162', '应城市'),
('1479', '162', '安陆市'),
('1480', '162', '汉川市'),
('1481', '163', '黄州区'),
('1482', '163', '团风县'),
('1483', '163', '红安县'),
('1484', '163', '罗田县'),
('1485', '163', '英山县'),
('1486', '163', '浠水县'),
('1487', '163', '蕲春县'),
('1488', '163', '黄梅县'),
('1489', '163', '麻城市'),
('1490', '163', '武穴市'),
('1491', '164', '黄石港区'),
('1492', '164', '西塞山区'),
('1493', '164', '下陆区'),
('1494', '164', '铁山区'),
('1495', '164', '阳新县'),
('1496', '164', '大冶市'),
('1497', '165', '咸安区'),
('1498', '165', '嘉鱼县'),
('1499', '165', '通城县'),
('1500', '165', '崇阳县'),
('1501', '165', '通山县'),
('1502', '165', '赤壁市'),
('1503', '166', '沙市区'),
('1504', '166', '荆州区'),
('1505', '166', '公安县'),
('1506', '166', '监利县'),
('1507', '166', '江陵县'),
('1508', '166', '石首市'),
('1509', '166', '洪湖市'),
('1510', '166', '松滋市'),
('1511', '167', '西陵区'),
('1512', '167', '伍家岗区'),
('1513', '167', '点军区'),
('1514', '167', '猇亭区'),
('1515', '167', '夷陵区'),
('1516', '167', '远安县'),
('1517', '167', '兴山县'),
('1518', '167', '秭归县'),
('1519', '167', '长阳土家族自治县'),
('1520', '167', '五峰土家族自治县'),
('1521', '167', '宜都市'),
('1522', '167', '当阳市'),
('1523', '167', '枝江市'),
('1524', '168', '恩施市'),
('1525', '168', '利川市'),
('1526', '168', '建始县'),
('1527', '168', '巴东县'),
('1528', '168', '宣恩县'),
('1529', '168', '咸丰县'),
('1530', '168', '来凤县'),
('1531', '168', '鹤峰县'),
('1532', '170', '茅箭区'),
('1533', '170', '张湾区'),
('1534', '170', '郧县'),
('1535', '170', '郧西县'),
('1536', '170', '竹山县'),
('1537', '170', '竹溪县'),
('1538', '170', '房县'),
('1539', '170', '丹江口市'),
('1540', '171', '曾都区'),
('1541', '171', '广水市'),
('1542', '172', '东宝区'),
('1543', '172', '掇刀区'),
('1544', '172', '京山县'),
('1545', '172', '沙洋县'),
('1546', '172', '钟祥市'),
('1547', '176', '岳阳楼区'),
('1548', '176', '云溪区'),
('1549', '176', '君山区'),
('1550', '176', '岳阳县'),
('1551', '176', '华容县'),
('1552', '176', '湘阴县'),
('1553', '176', '平江县'),
('1554', '176', '汨罗市'),
('1555', '176', '临湘市'),
('1556', '177', '芙蓉区'),
('1557', '177', '天心区'),
('1558', '177', '岳麓区'),
('1559', '177', '开福区'),
('1560', '177', '雨花区'),
('1561', '177', '长沙县'),
('1562', '177', '望城县'),
('1563', '177', '宁乡县'),
('1564', '177', '浏阳市'),
('1565', '178', '雨湖区'),
('1566', '178', '岳塘区'),
('1567', '178', '湘潭县'),
('1568', '178', '湘乡市'),
('1569', '178', '韶山市'),
('1570', '179', '荷塘区'),
('1571', '179', '芦淞区'),
('1572', '179', '石峰区'),
('1573', '179', '天元区'),
('1574', '179', '株洲县'),
('1575', '179', '攸县'),
('1576', '179', '茶陵县'),
('1577', '179', '炎陵县'),
('1578', '179', '醴陵市'),
('1579', '180', '珠晖区'),
('1580', '180', '雁峰区'),
('1581', '180', '石鼓区'),
('1582', '180', '蒸湘区'),
('1583', '180', '南岳区'),
('1584', '180', '衡阳县'),
('1585', '180', '衡南县'),
('1586', '180', '衡山县'),
('1587', '180', '衡东县'),
('1588', '180', '祁东县'),
('1589', '180', '耒阳市'),
('1590', '180', '常宁市'),
('1591', '181', '北湖区'),
('1592', '181', '苏仙区'),
('1593', '181', '桂阳县'),
('1594', '181', '宜章县'),
('1595', '181', '永兴县'),
('1596', '181', '嘉禾县'),
('1597', '181', '临武县'),
('1598', '181', '汝城县'),
('1599', '181', '桂东县'),
('1600', '181', '安仁县'),
('1601', '181', '资兴市'),
('1602', '182', '武陵区'),
('1603', '182', '鼎城区'),
('1604', '182', '安乡县'),
('1605', '182', '汉寿县'),
('1606', '182', '澧县'),
('1607', '182', '临澧县'),
('1608', '182', '桃源县'),
('1609', '182', '石门县'),
('1610', '182', '津市市'),
('1611', '183', '资阳区'),
('1612', '183', '赫山区'),
('1613', '183', '南县'),
('1614', '183', '桃江县'),
('1615', '183', '安化县'),
('1616', '183', '沅江市'),
('1617', '184', '娄星区'),
('1618', '184', '双峰县'),
('1619', '184', '新化县'),
('1620', '184', '冷水江市'),
('1621', '184', '涟源市'),
('1622', '185', '双清区'),
('1623', '185', '大祥区'),
('1624', '185', '北塔区'),
('1625', '185', '邵东县'),
('1626', '185', '新邵县'),
('1627', '185', '邵阳县'),
('1628', '185', '隆回县'),
('1629', '185', '洞口县'),
('1630', '185', '绥宁县'),
('1631', '185', '新宁县'),
('1632', '185', '城步苗族自治县'),
('1633', '185', '武冈市'),
('1634', '186', '吉首市'),
('1635', '186', '泸溪县'),
('1636', '186', '凤凰县'),
('1637', '186', '花垣县'),
('1638', '186', '保靖县'),
('1639', '186', '古丈县'),
('1640', '186', '永顺县'),
('1641', '186', '龙山县'),
('1642', '187', '永定区'),
('1643', '187', '武陵源区'),
('1644', '187', '慈利县'),
('1645', '187', '桑植县'),
('1646', '188', '鹤城区'),
('1647', '188', '中方县'),
('1648', '188', '沅陵县'),
('1649', '188', '辰溪县'),
('1650', '188', '溆浦县'),
('1651', '188', '会同县'),
('1652', '188', '麻阳苗族自治县'),
('1653', '188', '新晃侗族自治县'),
('1654', '188', '芷江侗族自治县'),
('1655', '188', '靖州苗族侗族自治县'),
('1656', '188', '通道侗族自治县'),
('1657', '188', '洪江市'),
('1658', '189', '零陵区'),
('1659', '189', '冷水滩区'),
('1660', '189', '祁阳县'),
('1661', '189', '东安县'),
('1662', '189', '双牌县'),
('1663', '189', '道县'),
('1664', '189', '江永县'),
('1665', '189', '宁远县'),
('1666', '189', '蓝山县'),
('1667', '189', '新田县'),
('1668', '189', '江华瑶族自治县'),
('1669', '190', '从化市'),
('1670', '190', '荔湾区'),
('1671', '190', '越秀区'),
('1672', '190', '海珠区'),
('1673', '190', '天河区'),
('1674', '190', '白云区'),
('1675', '190', '花都区'),
('1676', '190', '黄埔区'),
('1677', '190', '萝岗区'),
('1678', '190', '南沙区'),
('1679', '190', '番禺区'),
('1680', '190', '增城市'),
('1681', '191', '海丰县'),
('1682', '191', '陆河县'),
('1683', '191', '陆丰市'),
('1684', '192', '江城区'),
('1685', '192', '阳西县'),
('1686', '192', '阳东县'),
('1687', '192', '阳春市'),
('1688', '193', '榕城区'),
('1689', '193', '揭东县'),
('1690', '193', '揭西县'),
('1691', '193', '惠来县'),
('1692', '193', '普宁市'),
('1693', '194', '茂南区'),
('1694', '194', '茂港区'),
('1695', '194', '电白县'),
('1696', '194', '高州市'),
('1697', '194', '化州市'),
('1698', '194', '信宜市'),
('1699', '195', '惠城区'),
('1700', '195', '惠阳区'),
('1701', '195', '博罗县'),
('1702', '195', '惠东县'),
('1703', '195', '龙门县'),
('1704', '196', '蓬江区'),
('1705', '196', '江海区'),
('1706', '196', '新会区'),
('1707', '196', '台山市'),
('1708', '196', '开平市'),
('1709', '196', '鹤山市'),
('1710', '196', '恩平市'),
('1711', '197', '武江区'),
('1712', '197', '浈江区'),
('1713', '197', '曲江区'),
('1714', '197', '始兴县'),
('1715', '197', '仁化县'),
('1716', '197', '翁源县'),
('1717', '197', '乳源瑶族自治县'),
('1718', '197', '新丰县'),
('1719', '197', '乐昌市'),
('1720', '197', '南雄市'),
('1721', '198', '梅江区'),
('1722', '198', '梅县'),
('1723', '198', '大埔县'),
('1724', '198', '丰顺县'),
('1725', '198', '五华县'),
('1726', '198', '平远县'),
('1727', '198', '蕉岭县'),
('1728', '198', '兴宁市'),
('1729', '199', '龙湖区'),
('1730', '199', '金平区'),
('1731', '199', '濠江区'),
('1732', '199', '潮阳区'),
('1733', '199', '潮南区'),
('1734', '199', '澄海区'),
('1735', '199', '南澳县'),
('1736', '200', '罗湖区'),
('1737', '200', '福田区'),
('1738', '200', '南山区'),
('1739', '200', '宝安区'),
('1740', '200', '龙岗区'),
('1741', '200', '盐田区'),
('1742', '201', '香洲区'),
('1743', '201', '斗门区'),
('1744', '201', '金湾区'),
('1745', '202', '禅城区'),
('1746', '202', '南海区'),
('1747', '202', '顺德区'),
('1748', '202', '三水区'),
('1749', '202', '高明区'),
('1750', '203', '端州区'),
('1751', '203', '鼎湖区'),
('1752', '203', '广宁县'),
('1753', '203', '怀集县'),
('1754', '203', '封开县'),
('1755', '203', '德庆县'),
('1756', '203', '高要市'),
('1757', '203', '四会市'),
('1758', '204', '赤坎区'),
('1759', '204', '霞山区'),
('1760', '204', '坡头区'),
('1761', '204', '麻章区'),
('1762', '204', '遂溪县'),
('1763', '204', '徐闻县'),
('1764', '204', '廉江市'),
('1765', '204', '雷州市'),
('1766', '204', '吴川市'),
('1767', '206', '源城区'),
('1768', '206', '紫金县'),
('1769', '206', '龙川县'),
('1770', '206', '连平县'),
('1771', '206', '和平县'),
('1772', '206', '东源县'),
('1773', '207', '清城区'),
('1774', '207', '佛冈县'),
('1775', '207', '阳山县'),
('1776', '207', '连山壮族瑶族自治县'),
('1777', '207', '连南瑶族自治县'),
('1778', '207', '清新县'),
('1779', '207', '英德市'),
('1780', '207', '连州市'),
('1781', '208', '云城区'),
('1782', '208', '新兴县'),
('1783', '208', '郁南县'),
('1784', '208', '云安县'),
('1785', '208', '罗定市'),
('1786', '209', '湘桥区'),
('1787', '209', '潮安县'),
('1788', '209', '饶平县'),
('1789', '211', '城关区'),
('1790', '211', '七里河区'),
('1791', '211', '西固区'),
('1792', '211', '安宁区'),
('1793', '211', '红古区'),
('1794', '211', '永登县'),
('1795', '211', '皋兰县'),
('1796', '211', '榆中县'),
('1797', '212', '金川区'),
('1798', '212', '永昌县'),
('1799', '213', '白银区'),
('1800', '213', '平川区'),
('1801', '213', '靖远县'),
('1802', '213', '会宁县'),
('1803', '213', '景泰县'),
('1804', '214', '秦州区'),
('1805', '214', '麦积区'),
('1806', '214', '清水县'),
('1807', '214', '秦安县'),
('1808', '214', '甘谷县'),
('1809', '214', '武山县'),
('1810', '214', '张家川回族自治县'),
('1811', '216', '凉州区'),
('1812', '216', '民勤县'),
('1813', '216', '古浪县'),
('1814', '216', '天祝藏族自治县'),
('1815', '217', '甘州区'),
('1816', '217', '肃南裕固族自治县'),
('1817', '217', '民乐县'),
('1818', '217', '临泽县'),
('1819', '217', '高台县'),
('1820', '217', '山丹县'),
('1821', '218', '崆峒区'),
('1822', '218', '泾川县'),
('1823', '218', '灵台县'),
('1824', '218', '崇信县'),
('1825', '218', '华亭县'),
('1826', '218', '庄浪县'),
('1827', '218', '静宁县'),
('1828', '219', '肃州区'),
('1829', '219', '金塔县'),
('1830', '219', '瓜州县'),
('1831', '219', '肃北蒙古族自治县'),
('1832', '219', '阿克塞哈萨克族自治县'),
('1833', '219', '玉门市'),
('1834', '219', '敦煌市'),
('1835', '220', '西峰区'),
('1836', '220', '庆城县'),
('1837', '220', '环县'),
('1838', '220', '华池县'),
('1839', '220', '合水县'),
('1840', '220', '正宁县'),
('1841', '220', '宁县'),
('1842', '220', '镇原县'),
('1843', '221', '安定区'),
('1844', '221', '通渭县'),
('1845', '221', '陇西县'),
('1846', '221', '渭源县'),
('1847', '221', '临洮县'),
('1848', '221', '漳县'),
('1849', '221', '岷县'),
('1850', '222', '武都区'),
('1851', '222', '成县'),
('1852', '222', '文县'),
('1853', '222', '宕昌县'),
('1854', '222', '康县'),
('1855', '222', '西和县'),
('1856', '222', '礼县'),
('1857', '222', '徽县'),
('1858', '222', '两当县'),
('1859', '223', '临夏市'),
('1860', '223', '临夏县'),
('1861', '223', '康乐县'),
('1862', '223', '永靖县'),
('1863', '223', '广河县'),
('1864', '223', '和政县'),
('1865', '223', '东乡族自治县'),
('1866', '223', '积石山保安族东乡族撒拉族自治县'),
('1867', '224', '合作市'),
('1868', '224', '临潭县'),
('1869', '224', '卓尼县'),
('1870', '224', '舟曲县'),
('1871', '224', '迭部县'),
('1872', '224', '玛曲县'),
('1873', '224', '碌曲县'),
('1874', '224', '夏河县'),
('1875', '225', '锦江区'),
('1876', '225', '青羊区'),
('1877', '225', '金牛区'),
('1878', '225', '武侯区'),
('1879', '225', '成华区'),
('1880', '225', '龙泉驿区'),
('1881', '225', '青白江区'),
('1882', '225', '新都区'),
('1883', '225', '温江区'),
('1884', '225', '金堂县'),
('1885', '225', '双流县'),
('1886', '225', '郫县'),
('1887', '225', '大邑县'),
('1888', '225', '蒲江县'),
('1889', '225', '新津县'),
('1890', '225', '都江堰市'),
('1891', '225', '彭州市'),
('1892', '225', '邛崃市'),
('1893', '225', '崇州市'),
('1894', '226', '东区'),
('1895', '226', '西区'),
('1896', '226', '仁和区'),
('1897', '226', '米易县'),
('1898', '226', '盐边县'),
('1899', '227', '自流井区'),
('1900', '227', '贡井区'),
('1901', '227', '大安区'),
('1902', '227', '沿滩区'),
('1903', '227', '荣县'),
('1904', '227', '富顺县'),
('1905', '228', '涪城区'),
('1906', '228', '游仙区'),
('1907', '228', '三台县'),
('1908', '228', '盐亭县'),
('1909', '228', '安县'),
('1910', '228', '梓潼县'),
('1911', '228', '北川羌族自治县'),
('1912', '228', '平武县'),
('1913', '228', '江油市'),
('1914', '229', '顺庆区'),
('1915', '229', '高坪区'),
('1916', '229', '嘉陵区'),
('1917', '229', '南部县'),
('1918', '229', '营山县'),
('1919', '229', '蓬安县'),
('1920', '229', '仪陇县'),
('1921', '229', '西充县'),
('1922', '229', '阆中市'),
('1923', '230', '通川区'),
('1924', '230', '达县'),
('1925', '230', '宣汉县'),
('1926', '230', '开江县'),
('1927', '230', '大竹县'),
('1928', '230', '渠县'),
('1929', '230', '万源市'),
('1930', '231', '船山区'),
('1931', '231', '安居区'),
('1932', '231', '蓬溪县'),
('1933', '231', '射洪县'),
('1934', '231', '大英县'),
('1935', '232', '广安区'),
('1936', '232', '岳池县'),
('1937', '232', '武胜县'),
('1938', '232', '邻水县'),
('1939', '232', '华蓥市'),
('1940', '233', '巴州区'),
('1941', '233', '通江县'),
('1942', '233', '南江县'),
('1943', '233', '平昌县'),
('1944', '234', '江阳区'),
('1945', '234', '纳溪区'),
('1946', '234', '龙马潭区'),
('1947', '234', '泸县'),
('1948', '234', '合江县'),
('1949', '234', '叙永县'),
('1950', '234', '古蔺县'),
('1951', '235', '翠屏区'),
('1952', '235', '宜宾县'),
('1953', '235', '南溪县'),
('1954', '235', '江安县'),
('1955', '235', '长宁县'),
('1956', '235', '高县'),
('1957', '235', '珙县'),
('1958', '235', '筠连县'),
('1959', '235', '兴文县'),
('1960', '235', '屏山县'),
('1961', '236', '雁江区'),
('1962', '236', '安岳县'),
('1963', '236', '乐至县'),
('1964', '236', '简阳市'),
('1965', '237', '市中区'),
('1966', '237', '东兴区'),
('1967', '237', '威远县'),
('1968', '237', '资中县'),
('1969', '237', '隆昌县'),
('1970', '238', '市中区'),
('1971', '238', '沙湾区'),
('1972', '238', '五通桥区'),
('1973', '238', '金口河区'),
('1974', '238', '犍为县'),
('1975', '238', '井研县'),
('1976', '238', '夹江县'),
('1977', '238', '沐川县'),
('1978', '238', '峨边彝族自治县'),
('1979', '238', '马边彝族自治县'),
('1980', '238', '峨眉山市'),
('1981', '239', '东坡区'),
('1982', '239', '仁寿县'),
('1983', '239', '彭山县'),
('1984', '239', '洪雅县'),
('1985', '239', '丹棱县'),
('1986', '239', '青神县'),
('1987', '240', '西昌市'),
('1988', '240', '木里藏族自治县'),
('1989', '240', '盐源县'),
('1990', '240', '德昌县'),
('1991', '240', '会理县'),
('1992', '240', '会东县'),
('1993', '240', '宁南县'),
('1994', '240', '普格县'),
('1995', '240', '布拖县'),
('1996', '240', '金阳县'),
('1997', '240', '昭觉县'),
('1998', '240', '喜德县'),
('1999', '240', '冕宁县'),
('2000', '240', '越西县'),
('2001', '240', '甘洛县'),
('2002', '240', '美姑县'),
('2003', '240', '雷波县'),
('2004', '241', '雨城区'),
('2005', '241', '名山县'),
('2006', '241', '荥经县'),
('2007', '241', '汉源县'),
('2008', '241', '石棉县'),
('2009', '241', '天全县'),
('2010', '241', '芦山县'),
('2011', '241', '宝兴县'),
('2012', '242', '康定县'),
('2013', '242', '泸定县'),
('2014', '242', '丹巴县'),
('2015', '242', '九龙县'),
('2016', '242', '雅江县'),
('2017', '242', '道孚县'),
('2018', '242', '炉霍县'),
('2019', '242', '甘孜县'),
('2020', '242', '新龙县'),
('2021', '242', '德格县'),
('2022', '242', '白玉县'),
('2023', '242', '石渠县'),
('2024', '242', '色达县'),
('2025', '242', '理塘县'),
('2026', '242', '巴塘县'),
('2027', '242', '乡城县'),
('2028', '242', '稻城县'),
('2029', '242', '得荣县'),
('2030', '243', '汶川县'),
('2031', '243', '理县'),
('2032', '243', '茂县'),
('2033', '243', '松潘县'),
('2034', '243', '九寨沟县'),
('2035', '243', '金川县'),
('2036', '243', '小金县'),
('2037', '243', '黑水县'),
('2038', '243', '马尔康县'),
('2039', '243', '壤塘县'),
('2040', '243', '阿坝县'),
('2041', '243', '若尔盖县'),
('2042', '243', '红原县'),
('2043', '244', '旌阳区'),
('2044', '244', '中江县'),
('2045', '244', '罗江县'),
('2046', '244', '广汉市'),
('2047', '244', '什邡市'),
('2048', '244', '绵竹市'),
('2049', '245', '市中区'),
('2050', '245', '元坝区'),
('2051', '245', '朝天区'),
('2052', '245', '旺苍县'),
('2053', '245', '青川县'),
('2054', '245', '剑阁县'),
('2055', '245', '苍溪县'),
('2056', '246', '南明区'),
('2057', '246', '云岩区'),
('2058', '246', '花溪区'),
('2059', '246', '乌当区'),
('2060', '246', '白云区'),
('2061', '246', '小河区'),
('2062', '246', '开阳县'),
('2063', '246', '息烽县'),
('2064', '246', '修文县'),
('2065', '246', '清镇市'),
('2066', '247', '红花岗区'),
('2067', '247', '汇川区'),
('2068', '247', '遵义县'),
('2069', '247', '桐梓县'),
('2070', '247', '绥阳县'),
('2071', '247', '正安县'),
('2072', '247', '道真仡佬族苗族自治县'),
('2073', '247', '务川仡佬族苗族自治县'),
('2074', '247', '凤冈县'),
('2075', '247', '湄潭县'),
('2076', '247', '余庆县'),
('2077', '247', '习水县'),
('2078', '247', '赤水市'),
('2079', '247', '仁怀市'),
('2080', '248', '西秀区'),
('2081', '248', '平坝县'),
('2082', '248', '普定县'),
('2083', '248', '镇宁布依族苗族自治县'),
('2084', '248', '关岭布依族苗族自治县'),
('2085', '248', '紫云苗族布依族自治县'),
('2086', '249', '都匀市'),
('2087', '249', '福泉市'),
('2088', '249', '荔波县'),
('2089', '249', '贵定县'),
('2090', '249', '瓮安县'),
('2091', '249', '独山县'),
('2092', '249', '平塘县'),
('2093', '249', '罗甸县'),
('2094', '249', '长顺县'),
('2095', '249', '龙里县'),
('2096', '249', '惠水县'),
('2097', '249', '三都水族自治县'),
('2098', '250', '凯里市'),
('2099', '250', '黄平县'),
('2100', '250', '施秉县'),
('2101', '250', '三穗县'),
('2102', '250', '镇远县'),
('2103', '250', '岑巩县'),
('2104', '250', '天柱县'),
('2105', '250', '锦屏县'),
('2106', '250', '剑河县'),
('2107', '250', '台江县'),
('2108', '250', '黎平县'),
('2109', '250', '榕江县'),
('2110', '250', '从江县'),
('2111', '250', '雷山县'),
('2112', '250', '麻江县'),
('2113', '250', '丹寨县'),
('2114', '251', '铜仁市'),
('2115', '251', '江口县'),
('2116', '251', '玉屏侗族自治县'),
('2117', '251', '石阡县'),
('2118', '251', '思南县'),
('2119', '251', '印江土家族苗族自治县'),
('2120', '251', '德江县'),
('2121', '251', '沿河土家族自治县'),
('2122', '251', '松桃苗族自治县'),
('2123', '251', '万山特区'),
('2124', '252', '毕节市'),
('2125', '252', '大方县'),
('2126', '252', '黔西县'),
('2127', '252', '金沙县'),
('2128', '252', '织金县'),
('2129', '252', '纳雍县'),
('2130', '252', '威宁彝族回族苗族自治县'),
('2131', '252', '赫章县'),
('2132', '253', '钟山区'),
('2133', '253', '六枝特区'),
('2134', '253', '水城县'),
('2135', '253', '盘县'),
('2136', '254', '兴义市'),
('2137', '254', '兴仁县'),
('2138', '254', '普安县'),
('2139', '254', '晴隆县'),
('2140', '254', '贞丰县'),
('2141', '254', '望谟县'),
('2142', '254', '册亨县'),
('2143', '254', '安龙县'),
('2144', '255', '秀英区'),
('2145', '255', '龙华区'),
('2146', '255', '琼山区'),
('2147', '255', '美兰区'),
('2148', '273', '景洪市'),
('2149', '273', '勐海县'),
('2150', '273', '勐腊县'),
('2151', '274', '瑞丽市'),
('2152', '274', '潞西市'),
('2153', '274', '梁河县'),
('2154', '274', '盈江县'),
('2155', '274', '陇川县'),
('2156', '275', '昭阳区'),
('2157', '275', '鲁甸县'),
('2158', '275', '巧家县'),
('2159', '275', '盐津县'),
('2160', '275', '大关县'),
('2161', '275', '永善县'),
('2162', '275', '绥江县'),
('2163', '275', '镇雄县'),
('2164', '275', '彝良县'),
('2165', '275', '威信县'),
('2166', '275', '水富县'),
('2167', '276', '五华区'),
('2168', '276', '盘龙区'),
('2169', '276', '官渡区'),
('2170', '276', '西山区'),
('2171', '276', '东川区'),
('2172', '276', '呈贡县'),
('2173', '276', '晋宁县'),
('2174', '276', '富民县'),
('2175', '276', '宜良县'),
('2176', '276', '石林彝族自治县'),
('2177', '276', '嵩明县'),
('2178', '276', '禄劝彝族苗族自治县'),
('2179', '276', '寻甸回族彝族自治县'),
('2180', '276', '安宁市'),
('2181', '277', '大理市'),
('2182', '277', '漾濞彝族自治县'),
('2183', '277', '祥云县'),
('2184', '277', '宾川县'),
('2185', '277', '弥渡县'),
('2186', '277', '南涧彝族自治县'),
('2187', '277', '巍山彝族回族自治县'),
('2188', '277', '永平县'),
('2189', '277', '云龙县'),
('2190', '277', '洱源县'),
('2191', '277', '剑川县'),
('2192', '277', '鹤庆县'),
('2193', '278', '个旧市'),
('2194', '278', '开远市'),
('2195', '278', '蒙自县'),
('2196', '278', '屏边苗族自治县'),
('2197', '278', '建水县'),
('2198', '278', '石屏县'),
('2199', '278', '弥勒县'),
('2200', '278', '泸西县'),
('2201', '278', '元阳县'),
('2202', '278', '红河县'),
('2203', '278', '金平苗族瑶族傣族自治县'),
('2204', '278', '绿春县'),
('2205', '278', '河口瑶族自治县'),
('2206', '279', '麒麟区'),
('2207', '279', '马龙县'),
('2208', '279', '陆良县'),
('2209', '279', '师宗县'),
('2210', '279', '罗平县'),
('2211', '279', '富源县'),
('2212', '279', '会泽县'),
('2213', '279', '沾益县'),
('2214', '279', '宣威市'),
('2215', '280', '隆阳区'),
('2216', '280', '施甸县'),
('2217', '280', '腾冲县'),
('2218', '280', '龙陵县'),
('2219', '280', '昌宁县'),
('2220', '281', '文山县'),
('2221', '281', '砚山县'),
('2222', '281', '西畴县'),
('2223', '281', '麻栗坡县'),
('2224', '281', '马关县'),
('2225', '281', '丘北县'),
('2226', '281', '广南县'),
('2227', '281', '富宁县'),
('2228', '282', '红塔区'),
('2229', '282', '江川县'),
('2230', '282', '澄江县'),
('2231', '282', '通海县'),
('2232', '282', '华宁县'),
('2233', '282', '易门县'),
('2234', '282', '峨山彝族自治县'),
('2235', '282', '新平彝族傣族自治县'),
('2236', '282', '元江哈尼族彝族傣族自治县'),
('2237', '283', '楚雄市'),
('2238', '283', '双柏县'),
('2239', '283', '牟定县'),
('2240', '283', '南华县'),
('2241', '283', '姚安县'),
('2242', '283', '大姚县'),
('2243', '283', '永仁县'),
('2244', '283', '元谋县'),
('2245', '283', '武定县'),
('2246', '283', '禄丰县'),
('2247', '284', '思茅区'),
('2248', '284', '宁洱哈尼族彝族自治县'),
('2249', '284', '墨江哈尼族自治县'),
('2250', '284', '景东彝族自治县'),
('2251', '284', '景谷傣族彝族自治县'),
('2252', '284', '镇沅彝族哈尼族拉祜族自治县'),
('2253', '284', '江城哈尼族彝族自治县'),
('2254', '284', '孟连傣族拉祜族佤族自治县'),
('2255', '284', '澜沧拉祜族自治县'),
('2256', '284', '西盟佤族自治县'),
('2257', '285', '临翔区'),
('2258', '285', '凤庆县'),
('2259', '285', '云县'),
('2260', '285', '永德县'),
('2261', '285', '镇康县'),
('2262', '285', '双江拉祜族佤族布朗族傣族自治县'),
('2263', '285', '耿马傣族佤族自治县'),
('2264', '285', '沧源佤族自治县'),
('2265', '286', '泸水县'),
('2266', '286', '福贡县'),
('2267', '286', '贡山独龙族怒族自治县'),
('2268', '286', '兰坪白族普米族自治县'),
('2269', '287', '香格里拉县'),
('2270', '287', '德钦县'),
('2271', '287', '维西傈僳族自治县'),
('2272', '288', '古城区'),
('2273', '288', '玉龙纳西族自治县'),
('2274', '288', '永胜县'),
('2275', '288', '华坪县'),
('2276', '288', '宁蒗彝族自治县'),
('2277', '289', '门源回族自治县'),
('2278', '289', '祁连县'),
('2279', '289', '海晏县'),
('2280', '289', '刚察县'),
('2281', '290', '城东区'),
('2282', '290', '城中区'),
('2283', '290', '城西区'),
('2284', '290', '城北区'),
('2285', '290', '大通回族土族自治县'),
('2286', '290', '湟中县'),
('2287', '290', '湟源县'),
('2288', '291', '平安县'),
('2289', '291', '民和回族土族自治县'),
('2290', '291', '乐都县'),
('2291', '291', '互助土族自治县'),
('2292', '291', '化隆回族自治县'),
('2293', '291', '循化撒拉族自治县'),
('2294', '292', '同仁县'),
('2295', '292', '尖扎县'),
('2296', '292', '泽库县'),
('2297', '292', '河南蒙古族自治县'),
('2298', '293', '共和县'),
('2299', '293', '同德县'),
('2300', '293', '贵德县'),
('2301', '293', '兴海县'),
('2302', '293', '贵南县'),
('2303', '294', '玛沁县'),
('2304', '294', '班玛县'),
('2305', '294', '甘德县'),
('2306', '294', '达日县'),
('2307', '294', '久治县'),
('2308', '294', '玛多县'),
('2309', '295', '玉树县'),
('2310', '295', '杂多县'),
('2311', '295', '称多县'),
('2312', '295', '治多县'),
('2313', '295', '囊谦县'),
('2314', '295', '曲麻莱县'),
('2315', '296', '格尔木市'),
('2316', '296', '德令哈市'),
('2317', '296', '乌兰县'),
('2318', '296', '都兰县'),
('2319', '296', '天峻县'),
('2320', '297', '新城区'),
('2321', '297', '碑林区'),
('2322', '297', '莲湖区'),
('2323', '297', '灞桥区'),
('2324', '297', '未央区'),
('2325', '297', '雁塔区'),
('2326', '297', '阎良区'),
('2327', '297', '临潼区'),
('2328', '297', '长安区'),
('2329', '297', '蓝田县'),
('2330', '297', '周至县'),
('2331', '297', '户县'),
('2332', '297', '高陵县'),
('2333', '298', '秦都区'),
('2334', '298', '杨陵区'),
('2335', '298', '渭城区'),
('2336', '298', '三原县'),
('2337', '298', '泾阳县'),
('2338', '298', '乾县'),
('2339', '298', '礼泉县'),
('2340', '298', '永寿县'),
('2341', '298', '彬县'),
('2342', '298', '长武县'),
('2343', '298', '旬邑县'),
('2344', '298', '淳化县'),
('2345', '298', '武功县'),
('2346', '298', '兴平市'),
('2347', '299', '宝塔区'),
('2348', '299', '延长县'),
('2349', '299', '延川县'),
('2350', '299', '子长县'),
('2351', '299', '安塞县'),
('2352', '299', '志丹县'),
('2353', '299', '吴起县'),
('2354', '299', '甘泉县'),
('2355', '299', '富县'),
('2356', '299', '洛川县'),
('2357', '299', '宜川县'),
('2358', '299', '黄龙县'),
('2359', '299', '黄陵县'),
('2360', '300', '榆阳区'),
('2361', '300', '神木县'),
('2362', '300', '府谷县'),
('2363', '300', '横山县'),
('2364', '300', '靖边县'),
('2365', '300', '定边县'),
('2366', '300', '绥德县'),
('2367', '300', '米脂县'),
('2368', '300', '佳县'),
('2369', '300', '吴堡县'),
('2370', '300', '清涧县'),
('2371', '300', '子洲县'),
('2372', '301', '临渭区'),
('2373', '301', '华县'),
('2374', '301', '潼关县'),
('2375', '301', '大荔县'),
('2376', '301', '合阳县'),
('2377', '301', '澄城县'),
('2378', '301', '蒲城县'),
('2379', '301', '白水县'),
('2380', '301', '富平县'),
('2381', '301', '韩城市'),
('2382', '301', '华阴市'),
('2383', '302', '商州区'),
('2384', '302', '洛南县'),
('2385', '302', '丹凤县'),
('2386', '302', '商南县'),
('2387', '302', '山阳县'),
('2388', '302', '镇安县'),
('2389', '302', '柞水县'),
('2390', '303', '汉滨区'),
('2391', '303', '汉阴县'),
('2392', '303', '石泉县'),
('2393', '303', '宁陕县'),
('2394', '303', '紫阳县'),
('2395', '303', '岚皋县'),
('2396', '303', '平利县'),
('2397', '303', '镇坪县'),
('2398', '303', '旬阳县'),
('2399', '303', '白河县'),
('2400', '304', '汉台区'),
('2401', '304', '南郑县'),
('2402', '304', '城固县'),
('2403', '304', '洋县'),
('2404', '304', '西乡县'),
('2405', '304', '勉县'),
('2406', '304', '宁强县'),
('2407', '304', '略阳县'),
('2408', '304', '镇巴县'),
('2409', '304', '留坝县'),
('2410', '304', '佛坪县'),
('2411', '305', '渭滨区'),
('2412', '305', '金台区'),
('2413', '305', '陈仓区'),
('2414', '305', '凤翔县'),
('2415', '305', '岐山县'),
('2416', '305', '扶风县'),
('2417', '305', '眉县'),
('2418', '305', '陇县'),
('2419', '305', '千阳县'),
('2420', '305', '麟游县'),
('2421', '305', '凤县'),
('2422', '305', '太白县'),
('2423', '306', '王益区'),
('2424', '306', '印台区'),
('2425', '306', '耀州区'),
('2426', '306', '宜君县'),
('2427', '307', '港口区'),
('2428', '307', '防城区'),
('2429', '307', '上思县'),
('2430', '307', '东兴市'),
('2431', '308', '兴宁区'),
('2432', '308', '青秀区'),
('2433', '308', '江南区'),
('2434', '308', '西乡塘区'),
('2435', '308', '良庆区'),
('2436', '308', '邕宁区'),
('2437', '308', '武鸣县'),
('2438', '308', '隆安县'),
('2439', '308', '马山县'),
('2440', '308', '上林县'),
('2441', '308', '宾阳县'),
('2442', '308', '横县'),
('2443', '309', '江洲区'),
('2444', '309', '扶绥县'),
('2445', '309', '宁明县'),
('2446', '309', '龙州县'),
('2447', '309', '大新县'),
('2448', '309', '天等县'),
('2449', '309', '凭祥市'),
('2450', '310', '兴宾区'),
('2451', '310', '忻城县'),
('2452', '310', '象州县'),
('2453', '310', '武宣县'),
('2454', '310', '金秀瑶族自治县'),
('2455', '310', '合山市'),
('2456', '311', '城中区'),
('2457', '311', '鱼峰区'),
('2458', '311', '柳南区'),
('2459', '311', '柳北区'),
('2460', '311', '柳江县'),
('2461', '311', '柳城县'),
('2462', '311', '鹿寨县'),
('2463', '311', '融安县'),
('2464', '311', '融水苗族自治县'),
('2465', '311', '三江侗族自治县'),
('2466', '312', '秀峰区'),
('2467', '312', '叠彩区'),
('2468', '312', '象山区'),
('2469', '312', '七星区'),
('2470', '312', '雁山区'),
('2471', '312', '阳朔县'),
('2472', '312', '临桂县'),
('2473', '312', '灵川县'),
('2474', '312', '全州县'),
('2475', '312', '兴安县'),
('2476', '312', '永福县'),
('2477', '312', '灌阳县'),
('2478', '312', '龙胜各族自治县'),
('2479', '312', '资源县'),
('2480', '312', '平乐县'),
('2481', '312', '荔浦县'),
('2482', '312', '恭城瑶族自治县'),
('2483', '313', '万秀区'),
('2484', '313', '碟山区'),
('2485', '313', '长洲区'),
('2486', '313', '苍梧县'),
('2487', '313', '藤县'),
('2488', '313', '蒙山县'),
('2489', '313', '岑溪市'),
('2490', '314', '八步区'),
('2491', '314', '昭平县'),
('2492', '314', '钟山县'),
('2493', '314', '富川瑶族自治县'),
('2494', '315', '港北区'),
('2495', '315', '港南区'),
('2496', '315', '覃塘区'),
('2497', '315', '平南县'),
('2498', '315', '桂平市'),
('2499', '316', '玉州区'),
('2500', '316', '容县'),
('2501', '316', '陆川县'),
('2502', '316', '博白县'),
('2503', '316', '兴业县'),
('2504', '316', '北流市'),
('2505', '317', '右江区'),
('2506', '317', '田阳县'),
('2507', '317', '田东县'),
('2508', '317', '平果县'),
('2509', '317', '德保县'),
('2510', '317', '靖西县'),
('2511', '317', '那坡县'),
('2512', '317', '凌云县'),
('2513', '317', '乐业县'),
('2514', '317', '田林县'),
('2515', '317', '西林县'),
('2516', '317', '隆林各族自治县'),
('2517', '318', '钦南区'),
('2518', '318', '钦北区'),
('2519', '318', '灵山县'),
('2520', '318', '浦北县'),
('2521', '319', '金城江区'),
('2522', '319', '南丹县'),
('2523', '319', '天峨县'),
('2524', '319', '凤山县'),
('2525', '319', '东兰县'),
('2526', '319', '罗城仫佬族自治县'),
('2527', '319', '环江毛南族自治县'),
('2528', '319', '巴马瑶族自治县'),
('2529', '319', '都安瑶族自治县'),
('2530', '319', '大化瑶族自治县'),
('2531', '319', '宜州市'),
('2532', '320', '海城区'),
('2533', '320', '银海区'),
('2534', '320', '铁山港区'),
('2535', '320', '合浦县'),
('2536', '321', '城关区'),
('2537', '321', '林周县'),
('2538', '321', '当雄县'),
('2539', '321', '尼木县'),
('2540', '321', '曲水县'),
('2541', '321', '堆龙德庆县'),
('2542', '321', '达孜县'),
('2543', '321', '墨竹工卡县'),
('2544', '322', '日喀则市'),
('2545', '322', '南木林县'),
('2546', '322', '江孜县'),
('2547', '322', '定日县'),
('2548', '322', '萨迦县'),
('2549', '322', '拉孜县'),
('2550', '322', '昂仁县'),
('2551', '322', '谢通门县'),
('2552', '322', '白朗县'),
('2553', '322', '仁布县'),
('2554', '322', '康马县'),
('2555', '322', '定结县'),
('2556', '322', '仲巴县'),
('2557', '322', '亚东县'),
('2558', '322', '吉隆县'),
('2559', '322', '聂拉木县'),
('2560', '322', '萨嘎县'),
('2561', '322', '岗巴县'),
('2562', '323', '乃东县'),
('2563', '323', '扎囊县'),
('2564', '323', '贡嘎县'),
('2565', '323', '桑日县'),
('2566', '323', '琼结县'),
('2567', '323', '曲松县'),
('2568', '323', '措美县'),
('2569', '323', '洛扎县'),
('2570', '323', '加查县'),
('2571', '323', '隆子县'),
('2572', '323', '错那县'),
('2573', '323', '浪卡子县'),
('2574', '324', '林芝县'),
('2575', '324', '工布江达县'),
('2576', '324', '米林县'),
('2577', '324', '墨脱县'),
('2578', '324', '波密县'),
('2579', '324', '察隅县'),
('2580', '324', '朗县'),
('2581', '325', '昌都县'),
('2582', '325', '江达县'),
('2583', '325', '贡觉县'),
('2584', '325', '类乌齐县'),
('2585', '325', '丁青县'),
('2586', '325', '察雅县'),
('2587', '325', '八宿县'),
('2588', '325', '左贡县'),
('2589', '325', '芒康县'),
('2590', '325', '洛隆县'),
('2591', '325', '边坝县'),
('2592', '326', '那曲县'),
('2593', '326', '嘉黎县'),
('2594', '326', '比如县'),
('2595', '326', '聂荣县'),
('2596', '326', '安多县'),
('2597', '326', '申扎县'),
('2598', '326', '索县'),
('2599', '326', '班戈县'),
('2600', '326', '巴青县'),
('2601', '326', '尼玛县'),
('2602', '327', '普兰县'),
('2603', '327', '札达县'),
('2604', '327', '噶尔县'),
('2605', '327', '日土县'),
('2606', '327', '革吉县'),
('2607', '327', '改则县'),
('2608', '327', '措勤县'),
('2609', '328', '兴庆区'),
('2610', '328', '西夏区'),
('2611', '328', '金凤区'),
('2612', '328', '永宁县'),
('2613', '328', '贺兰县'),
('2614', '328', '灵武市'),
('2615', '329', '大武口区'),
('2616', '329', '惠农区'),
('2617', '329', '平罗县'),
('2618', '330', '利通区'),
('2619', '330', '盐池县'),
('2620', '330', '同心县'),
('2621', '330', '青铜峡市'),
('2622', '331', '原州区'),
('2623', '331', '西吉县'),
('2624', '331', '隆德县'),
('2625', '331', '泾源县'),
('2626', '331', '彭阳县'),
('2627', '332', '沙坡头区'),
('2628', '332', '中宁县'),
('2629', '332', '海原县'),
('2630', '333', '塔城市'),
('2631', '333', '乌苏市'),
('2632', '333', '额敏县'),
('2633', '333', '沙湾县'),
('2634', '333', '托里县'),
('2635', '333', '裕民县'),
('2636', '333', '和布克赛尔蒙古自治县'),
('2637', '334', '哈密市'),
('2638', '334', '巴里坤哈萨克自治县'),
('2639', '334', '伊吾县'),
('2640', '335', '和田市'),
('2641', '335', '和田县'),
('2642', '335', '墨玉县'),
('2643', '335', '皮山县'),
('2644', '335', '洛浦县'),
('2645', '335', '策勒县'),
('2646', '335', '于田县'),
('2647', '335', '民丰县'),
('2648', '336', '阿勒泰市'),
('2649', '336', '布尔津县'),
('2650', '336', '富蕴县'),
('2651', '336', '福海县'),
('2652', '336', '哈巴河县'),
('2653', '336', '青河县'),
('2654', '336', '吉木乃县'),
('2655', '337', '阿图什市'),
('2656', '337', '阿克陶县'),
('2657', '337', '阿合奇县'),
('2658', '337', '乌恰县'),
('2659', '338', '博乐市'),
('2660', '338', '精河县'),
('2661', '338', '温泉县'),
('2662', '339', '独山子区'),
('2663', '339', '克拉玛依区'),
('2664', '339', '白碱滩区'),
('2665', '339', '乌尔禾区'),
('2666', '340', '天山区'),
('2667', '340', '沙依巴克区'),
('2668', '340', '新市区'),
('2669', '340', '水磨沟区'),
('2670', '340', '头屯河区'),
('2671', '340', '达坂城区'),
('2672', '340', '米东区'),
('2673', '340', '乌鲁木齐县'),
('2674', '342', '昌吉市'),
('2675', '342', '阜康市'),
('2676', '342', '呼图壁县'),
('2677', '342', '玛纳斯县'),
('2678', '342', '奇台县'),
('2679', '342', '吉木萨尔县'),
('2680', '342', '木垒哈萨克自治县'),
('2681', '344', '吐鲁番市'),
('2682', '344', '鄯善县'),
('2683', '344', '托克逊县'),
('2684', '345', '库尔勒市'),
('2685', '345', '轮台县'),
('2686', '345', '尉犁县'),
('2687', '345', '若羌县'),
('2688', '345', '且末县'),
('2689', '345', '焉耆回族自治县'),
('2690', '345', '和静县'),
('2691', '345', '和硕县'),
('2692', '345', '博湖县'),
('2693', '346', '阿克苏市'),
('2694', '346', '温宿县'),
('2695', '346', '库车县'),
('2696', '346', '沙雅县'),
('2697', '346', '新和县'),
('2698', '346', '拜城县'),
('2699', '346', '乌什县'),
('2700', '346', '阿瓦提县'),
('2701', '346', '柯坪县'),
('2702', '348', '喀什市'),
('2703', '348', '疏附县'),
('2704', '348', '疏勒县'),
('2705', '348', '英吉沙县'),
('2706', '348', '泽普县'),
('2707', '348', '莎车县'),
('2708', '348', '叶城县'),
('2709', '348', '麦盖提县'),
('2710', '348', '岳普湖县'),
('2711', '348', '伽师县'),
('2712', '348', '巴楚县'),
('2713', '348', '塔什库尔干塔吉克自治县'),
('2714', '350', '伊宁市'),
('2715', '350', '奎屯市'),
('2716', '350', '伊宁县'),
('2717', '350', '察布查尔锡伯自治县'),
('2718', '350', '霍城县'),
('2719', '350', '巩留县'),
('2720', '350', '新源县'),
('2721', '350', '昭苏县'),
('2722', '350', '特克斯县'),
('2723', '350', '尼勒克县'),
('2724', '351', '海拉尔区'),
('2725', '351', '阿荣旗'),
('2726', '351', '莫力达瓦达斡尔族自治旗'),
('2727', '351', '鄂伦春自治旗'),
('2728', '351', '鄂温克族自治旗'),
('2729', '351', '陈巴尔虎旗'),
('2730', '351', '新巴尔虎左旗'),
('2731', '351', '新巴尔虎右旗'),
('2732', '351', '满洲里市'),
('2733', '351', '牙克石市'),
('2734', '351', '扎兰屯市'),
('2735', '351', '额尔古纳市'),
('2736', '351', '根河市'),
('2737', '352', '新城区'),
('2738', '352', '回民区'),
('2739', '352', '玉泉区'),
('2740', '352', '赛罕区'),
('2741', '352', '土默特左旗'),
('2742', '352', '托克托县'),
('2743', '352', '和林格尔县'),
('2744', '352', '清水河县'),
('2745', '352', '武川县'),
('2746', '353', '东河区'),
('2747', '353', '昆都仑区'),
('2748', '353', '青山区'),
('2749', '353', '石拐区'),
('2750', '353', '白云鄂博矿区'),
('2751', '353', '九原区'),
('2752', '353', '土默特右旗'),
('2753', '353', '固阳县'),
('2754', '353', '达尔罕茂明安联合旗'),
('2755', '354', '海勃湾区'),
('2756', '354', '海南区'),
('2757', '354', '乌达区'),
('2758', '355', '集宁区'),
('2759', '355', '卓资县'),
('2760', '355', '化德县'),
('2761', '355', '商都县'),
('2762', '355', '兴和县'),
('2763', '355', '凉城县'),
('2764', '355', '察哈尔右翼前旗'),
('2765', '355', '察哈尔右翼中旗'),
('2766', '355', '察哈尔右翼后旗'),
('2767', '355', '四子王旗'),
('2768', '355', '丰镇市'),
('2769', '356', '科尔沁区'),
('2770', '356', '科尔沁左翼中旗'),
('2771', '356', '科尔沁左翼后旗'),
('2772', '356', '开鲁县'),
('2773', '356', '库伦旗'),
('2774', '356', '奈曼旗'),
('2775', '356', '扎鲁特旗'),
('2776', '356', '霍林郭勒市'),
('2777', '357', '红山区'),
('2778', '357', '元宝山区'),
('2779', '357', '松山区'),
('2780', '357', '阿鲁科尔沁旗'),
('2781', '357', '巴林左旗'),
('2782', '357', '巴林右旗'),
('2783', '357', '林西县'),
('2784', '357', '克什克腾旗'),
('2785', '357', '翁牛特旗'),
('2786', '357', '喀喇沁旗'),
('2787', '357', '宁城县'),
('2788', '357', '敖汉旗'),
('2789', '358', '东胜区'),
('2790', '358', '达拉特旗'),
('2791', '358', '准格尔旗'),
('2792', '358', '鄂托克前旗'),
('2793', '358', '鄂托克旗'),
('2794', '358', '杭锦旗'),
('2795', '358', '乌审旗'),
('2796', '358', '伊金霍洛旗'),
('2797', '359', '临河区'),
('2798', '359', '五原县'),
('2799', '359', '磴口县'),
('2800', '359', '乌拉特前旗'),
('2801', '359', '乌拉特中旗'),
('2802', '359', '乌拉特后旗'),
('2803', '359', '杭锦后旗'),
('2804', '360', '二连浩特市'),
('2805', '360', '锡林浩特市'),
('2806', '360', '阿巴嘎旗'),
('2807', '360', '苏尼特左旗'),
('2808', '360', '苏尼特右旗'),
('2809', '360', '东乌珠穆沁旗'),
('2810', '360', '西乌珠穆沁旗'),
('2811', '360', '太仆寺旗'),
('2812', '360', '镶黄旗'),
('2813', '360', '正镶白旗'),
('2814', '360', '正蓝旗'),
('2815', '360', '多伦县'),
('2816', '361', '乌兰浩特市'),
('2817', '361', '阿尔山市'),
('2818', '361', '科尔沁右翼前旗'),
('2819', '361', '科尔沁右翼中旗'),
('2820', '361', '扎赉特旗'),
('2821', '361', '突泉县'),
('2822', '362', '阿拉善左旗'),
('2823', '362', '阿拉善右旗'),
('2824', '362', '额济纳旗'),
('2825', '210', '南城区'),
('2826', '210', '东城区'),
('2827', '210', '万江区'),
('2828', '210', '莞城区'),
('2829', '210', '石龙镇'),
('2830', '210', '虎门镇'),
('2831', '210', '麻涌镇'),
('2832', '210', '道滘镇'),
('2833', '210', '石碣镇'),
('2834', '210', '沙田镇'),
('2835', '210', '望牛墩'),
('2836', '210', '洪梅镇'),
('2837', '210', '茶山镇'),
('2838', '210', '寮步镇'),
('2839', '210', '大岭山'),
('2840', '210', '大朗镇'),
('2841', '210', '黄江镇'),
('2842', '210', '樟木头'),
('2843', '210', '凤岗镇'),
('2844', '210', '塘厦镇'),
('2845', '210', '谢岗镇'),
('2846', '210', '厚街镇'),
('2847', '210', '清溪镇'),
('2848', '210', '常平镇'),
('2849', '210', '桥头镇'),
('2850', '210', '横沥镇'),
('2851', '210', '东坑镇'),
('2852', '210', '企石镇'),
('2853', '210', '石排镇'),
('2854', '210', '长安镇'),
('2855', '210', '中堂镇'),
('2856', '210', '高埗镇'),
('2857', '23', '城区'),
('2858', '175', '潜江市'),
('2859', '371', '沙田区'),
('2860', '371', '东区'),
('2861', '371', '观塘区'),
('2862', '371', '黄大仙区'),
('2863', '371', '九龙城区'),
('2864', '371', '屯门区'),
('2865', '371', '葵青区'),
('2866', '371', '元朗区'),
('2867', '371', '深水埗区'),
('2868', '371', '西贡区'),
('2869', '371', '大埔区'),
('2870', '371', '湾仔区'),
('2871', '371', '油尖旺区'),
('2872', '371', '北区'),
('2873', '371', '南区'),
('2874', '371', '荃湾区'),
('2875', '371', '中西区'),
('2876', '371', '离岛区'),
('2877', '142', '郑东新区'),
('2878', '60', '加格达奇区'),
('2879', '85', '市区'),
('2880', '173', '仙桃市'),
('2881', '225', '高新区'),
('2882', '64', '新区'),
('2883', '66', '玉山镇'),
('2884', '29', '开发区'),
('2885', '66', '园区'),
('2886', '2', '经济开发区'),
('2887', '22', '郊区'),
('2888', '347', '阿拉尔市'),
('2889', '370', '澳门特别行政区'),
('2890', '77',  '衢州市'),
('2891', '205', '石岐街道'),
('2892', '205', '东区街道'),
('2893', '205', '西区街道'),
('2894', '205', '环城街道'),
('2895', '205', '中山港街道'),
('2896', '205', '五桂山街道'),
('2897', '195', '大亚湾');

-- DROP TABLE IF EXISTS `{$installer->getTable('directory_country_area_name')}`;
CREATE TABLE `{$installer->getTable('directory_country_area_name')}` (
  `locale` varchar(8) NOT NULL default '',
  `area_id` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`locale`,`area_id`),
  KEY `FK_DIRECTORY_AREA_NAME_AREA` (`area_id`),
  CONSTRAINT `FK_DIRECTORY_AREA_NAME_AREA` FOREIGN KEY (`area_id`) REFERENCES {$installer->getTable('directory_country_area')} (`area_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Areas names';

INSERT INTO `{$installer->getTable('directory_country_area_name')}` VALUES
('zh_CN', '1', '东城区'),
('zh_CN', '2', '西城区'),
('zh_CN', '3', '崇文区'),
('zh_CN', '4', '宣武区'),
('zh_CN', '5', '朝阳区'),
('zh_CN', '6', '丰台区'),
('zh_CN', '7', '石景山区'),
('zh_CN', '8', '海淀区'),
('zh_CN', '9', '门头沟区'),
('zh_CN', '10', '房山区'),
('zh_CN', '11', '通州区'),
('zh_CN', '12', '顺义区'),
('zh_CN', '13', '昌平区'),
('zh_CN', '14', '大兴区'),
('zh_CN', '15', '怀柔区'),
('zh_CN', '16', '平谷区'),
('zh_CN', '17', '密云县'),
('zh_CN', '18', '延庆县'),
('zh_CN', '19', '和平区'),
('zh_CN', '20', '河东区'),
('zh_CN', '21', '河西区'),
('zh_CN', '22', '南开区'),
('zh_CN', '23', '河北区'),
('zh_CN', '24', '红桥区'),
('zh_CN', '25', '塘沽区'),
('zh_CN', '26', '汉沽区'),
('zh_CN', '27', '大港区'),
('zh_CN', '28', '东丽区'),
('zh_CN', '29', '西青区'),
('zh_CN', '30', '津南区'),
('zh_CN', '31', '北辰区'),
('zh_CN', '32', '武清区'),
('zh_CN', '33', '宝坻区'),
('zh_CN', '34', '宁河县'),
('zh_CN', '35', '静海县'),
('zh_CN', '36', '蓟县'),
('zh_CN', '37', '黄浦区'),
('zh_CN', '38', '卢湾区'),
('zh_CN', '39', '徐汇区'),
('zh_CN', '40', '长宁区'),
('zh_CN', '41', '静安区'),
('zh_CN', '42', '普陀区'),
('zh_CN', '43', '闸北区'),
('zh_CN', '44', '虹口区'),
('zh_CN', '45', '杨浦区'),
('zh_CN', '46', '闵行区'),
('zh_CN', '47', '宝山区'),
('zh_CN', '48', '嘉定区'),
('zh_CN', '49', '浦东新区'),
('zh_CN', '50', '金山区'),
('zh_CN', '51', '松江区'),
('zh_CN', '52', '青浦区'),
('zh_CN', '53', '南汇区'),
('zh_CN', '54', '奉贤区'),
('zh_CN', '55', '崇明县'),
('zh_CN', '56', '万州区'),
('zh_CN', '57', '涪陵区'),
('zh_CN', '58', '渝中区'),
('zh_CN', '59', '大渡口区'),
('zh_CN', '60', '江北区'),
('zh_CN', '61', '沙坪坝区'),
('zh_CN', '62', '九龙坡区'),
('zh_CN', '63', '南岸区'),
('zh_CN', '64', '北碚区'),
('zh_CN', '65', '万盛区'),
('zh_CN', '66', '双桥区'),
('zh_CN', '67', '渝北区'),
('zh_CN', '68', '巴南区'),
('zh_CN', '69', '黔江区'),
('zh_CN', '70', '长寿区'),
('zh_CN', '71', '江津区'),
('zh_CN', '72', '合川区'),
('zh_CN', '73', '永川区'),
('zh_CN', '74', '南川区'),
('zh_CN', '75', '綦江县'),
('zh_CN', '76', '潼南县'),
('zh_CN', '77', '铜梁县'),
('zh_CN', '78', '大足县'),
('zh_CN', '79', '荣昌县'),
('zh_CN', '80', '璧山县'),
('zh_CN', '81', '梁平县'),
('zh_CN', '82', '城口县'),
('zh_CN', '83', '丰都县'),
('zh_CN', '84', '垫江县'),
('zh_CN', '85', '武隆县'),
('zh_CN', '86', '忠县'),
('zh_CN', '87', '开县'),
('zh_CN', '88', '云阳县'),
('zh_CN', '89', '奉节县'),
('zh_CN', '90', '巫山县'),
('zh_CN', '91', '巫溪县'),
('zh_CN', '92', '石柱土家族自治县'),
('zh_CN', '93', '秀山土家族苗族自治县'),
('zh_CN', '94', '酉阳土家族苗族自治县'),
('zh_CN', '95', '彭水苗族土家族自治县'),
('zh_CN', '96', '邯山区'),
('zh_CN', '97', '丛台区'),
('zh_CN', '98', '复兴区'),
('zh_CN', '99', '峰峰矿区'),
('zh_CN', '100', '邯郸县'),
('zh_CN', '101', '临漳县'),
('zh_CN', '102', '成安县'),
('zh_CN', '103', '大名县'),
('zh_CN', '104', '涉县'),
('zh_CN', '105', '磁县'),
('zh_CN', '106', '肥乡县'),
('zh_CN', '107', '永年县'),
('zh_CN', '108', '邱县'),
('zh_CN', '109', '鸡泽县'),
('zh_CN', '110', '广平县'),
('zh_CN', '111', '馆陶县'),
('zh_CN', '112', '魏县'),
('zh_CN', '113', '曲周县'),
('zh_CN', '114', '武安市'),
('zh_CN', '115', '长安区'),
('zh_CN', '116', '桥东区'),
('zh_CN', '117', '桥西区'),
('zh_CN', '118', '新华区'),
('zh_CN', '119', '井陉矿区'),
('zh_CN', '120', '裕华区'),
('zh_CN', '121', '井陉县'),
('zh_CN', '122', '正定县'),
('zh_CN', '123', '栾城县'),
('zh_CN', '124', '行唐县'),
('zh_CN', '125', '灵寿县'),
('zh_CN', '126', '高邑县'),
('zh_CN', '127', '深泽县'),
('zh_CN', '128', '赞皇县'),
('zh_CN', '129', '无极县'),
('zh_CN', '130', '平山县'),
('zh_CN', '131', '元氏县'),
('zh_CN', '132', '赵县'),
('zh_CN', '133', '辛集市'),
('zh_CN', '134', '藁城市'),
('zh_CN', '135', '晋州市'),
('zh_CN', '136', '新乐市'),
('zh_CN', '137', '鹿泉市'),
('zh_CN', '138', '新市区'),
('zh_CN', '139', '北市区'),
('zh_CN', '140', '南市区'),
('zh_CN', '141', '满城县'),
('zh_CN', '142', '清苑县'),
('zh_CN', '143', '涞水县'),
('zh_CN', '144', '阜平县'),
('zh_CN', '145', '徐水县'),
('zh_CN', '146', '定兴县'),
('zh_CN', '147', '唐县'),
('zh_CN', '148', '高阳县'),
('zh_CN', '149', '容城县'),
('zh_CN', '150', '涞源县'),
('zh_CN', '151', '望都县'),
('zh_CN', '152', '安新县'),
('zh_CN', '153', '易县'),
('zh_CN', '154', '曲阳县'),
('zh_CN', '155', '蠡县'),
('zh_CN', '156', '顺平县'),
('zh_CN', '157', '博野县'),
('zh_CN', '158', '雄县'),
('zh_CN', '159', '涿州市'),
('zh_CN', '160', '定州市'),
('zh_CN', '161', '安国市'),
('zh_CN', '162', '高碑店市'),
('zh_CN', '163', '桥东区'),
('zh_CN', '164', '桥西区'),
('zh_CN', '165', '宣化区'),
('zh_CN', '166', '下花园区'),
('zh_CN', '167', '宣化县'),
('zh_CN', '168', '张北县'),
('zh_CN', '169', '康保县'),
('zh_CN', '170', '沽源县'),
('zh_CN', '171', '尚义县'),
('zh_CN', '172', '蔚县'),
('zh_CN', '173', '阳原县'),
('zh_CN', '174', '怀安县'),
('zh_CN', '175', '万全县'),
('zh_CN', '176', '怀来县'),
('zh_CN', '177', '涿鹿县'),
('zh_CN', '178', '赤城县'),
('zh_CN', '179', '崇礼县'),
('zh_CN', '180', '双桥区'),
('zh_CN', '181', '双滦区'),
('zh_CN', '182', '鹰手营子矿区'),
('zh_CN', '183', '承德县'),
('zh_CN', '184', '兴隆县'),
('zh_CN', '185', '平泉县'),
('zh_CN', '186', '滦平县'),
('zh_CN', '187', '隆化县'),
('zh_CN', '188', '丰宁满族自治县'),
('zh_CN', '189', '宽城满族自治县'),
('zh_CN', '190', '围场满族蒙古族自治县'),
('zh_CN', '191', '路南区'),
('zh_CN', '192', '路北区'),
('zh_CN', '193', '古冶区'),
('zh_CN', '194', '开平区'),
('zh_CN', '195', '丰南区'),
('zh_CN', '196', '丰润区'),
('zh_CN', '197', '滦县'),
('zh_CN', '198', '滦南县'),
('zh_CN', '199', '乐亭县'),
('zh_CN', '200', '迁西县'),
('zh_CN', '201', '玉田县'),
('zh_CN', '202', '唐海县'),
('zh_CN', '203', '遵化市'),
('zh_CN', '204', '迁安市'),
('zh_CN', '205', '安次区'),
('zh_CN', '206', '广阳区'),
('zh_CN', '207', '固安县'),
('zh_CN', '208', '永清县'),
('zh_CN', '209', '香河县'),
('zh_CN', '210', '大城县'),
('zh_CN', '211', '文安县'),
('zh_CN', '212', '大厂回族自治县'),
('zh_CN', '213', '霸州市'),
('zh_CN', '214', '三河市'),
('zh_CN', '215', '新华区'),
('zh_CN', '216', '运河区'),
('zh_CN', '217', '沧县'),
('zh_CN', '218', '青县'),
('zh_CN', '219', '东光县'),
('zh_CN', '220', '海兴县'),
('zh_CN', '221', '盐山县'),
('zh_CN', '222', '肃宁县'),
('zh_CN', '223', '南皮县'),
('zh_CN', '224', '吴桥县'),
('zh_CN', '225', '献县'),
('zh_CN', '226', '孟村回族自治县'),
('zh_CN', '227', '泊头市'),
('zh_CN', '228', '任丘市'),
('zh_CN', '229', '黄骅市'),
('zh_CN', '230', '河间市'),
('zh_CN', '231', '桃城区'),
('zh_CN', '232', '枣强县'),
('zh_CN', '233', '武邑县'),
('zh_CN', '234', '武强县'),
('zh_CN', '235', '饶阳县'),
('zh_CN', '236', '安平县'),
('zh_CN', '237', '故城县'),
('zh_CN', '238', '景县'),
('zh_CN', '239', '阜城县'),
('zh_CN', '240', '冀州市'),
('zh_CN', '241', '深州市'),
('zh_CN', '242', '桥东区'),
('zh_CN', '243', '桥西区'),
('zh_CN', '244', '邢台县'),
('zh_CN', '245', '临城县'),
('zh_CN', '246', '内丘县'),
('zh_CN', '247', '柏乡县'),
('zh_CN', '248', '隆尧县'),
('zh_CN', '249', '任县'),
('zh_CN', '250', '南和县'),
('zh_CN', '251', '宁晋县'),
('zh_CN', '252', '巨鹿县'),
('zh_CN', '253', '新河县'),
('zh_CN', '254', '广宗县'),
('zh_CN', '255', '平乡县'),
('zh_CN', '256', '威县'),
('zh_CN', '257', '清河县'),
('zh_CN', '258', '临西县'),
('zh_CN', '259', '南宫市'),
('zh_CN', '260', '沙河市'),
('zh_CN', '261', '海港区'),
('zh_CN', '262', '山海关区'),
('zh_CN', '263', '北戴河区'),
('zh_CN', '264', '青龙满族自治县'),
('zh_CN', '265', '昌黎县'),
('zh_CN', '266', '抚宁县'),
('zh_CN', '267', '卢龙县'),
('zh_CN', '268', '朔城区'),
('zh_CN', '269', '平鲁区'),
('zh_CN', '270', '山阴县'),
('zh_CN', '271', '应县'),
('zh_CN', '272', '右玉县'),
('zh_CN', '273', '怀仁县'),
('zh_CN', '274', '忻府区'),
('zh_CN', '275', '定襄县'),
('zh_CN', '276', '五台县'),
('zh_CN', '277', '代县'),
('zh_CN', '278', '繁峙县'),
('zh_CN', '279', '宁武县'),
('zh_CN', '280', '静乐县'),
('zh_CN', '281', '神池县'),
('zh_CN', '282', '五寨县'),
('zh_CN', '283', '岢岚县'),
('zh_CN', '284', '河曲县'),
('zh_CN', '285', '保德县'),
('zh_CN', '286', '偏关县'),
('zh_CN', '287', '原平市'),
('zh_CN', '288', '小店区'),
('zh_CN', '289', '迎泽区'),
('zh_CN', '290', '杏花岭区'),
('zh_CN', '291', '尖草坪区'),
('zh_CN', '292', '万柏林区'),
('zh_CN', '293', '晋源区'),
('zh_CN', '294', '清徐县'),
('zh_CN', '295', '阳曲县'),
('zh_CN', '296', '娄烦县'),
('zh_CN', '297', '古交市'),
('zh_CN', '298', '矿区'),
('zh_CN', '299', '南郊区'),
('zh_CN', '300', '新荣区'),
('zh_CN', '301', '阳高县'),
('zh_CN', '302', '天镇县'),
('zh_CN', '303', '广灵县'),
('zh_CN', '304', '灵丘县'),
('zh_CN', '305', '浑源县'),
('zh_CN', '306', '左云县'),
('zh_CN', '307', '大同县'),
('zh_CN', '308', '矿区'),
('zh_CN', '309', '平定县'),
('zh_CN', '310', '盂县'),
('zh_CN', '311', '榆次区'),
('zh_CN', '312', '榆社县'),
('zh_CN', '313', '左权县'),
('zh_CN', '314', '和顺县'),
('zh_CN', '315', '昔阳县'),
('zh_CN', '316', '寿阳县'),
('zh_CN', '317', '太谷县'),
('zh_CN', '318', '祁县'),
('zh_CN', '319', '平遥县'),
('zh_CN', '320', '灵石县'),
('zh_CN', '321', '介休市'),
('zh_CN', '322', '长治县'),
('zh_CN', '323', '襄垣县'),
('zh_CN', '324', '屯留县'),
('zh_CN', '325', '平顺县'),
('zh_CN', '326', '黎城县'),
('zh_CN', '327', '壶关县'),
('zh_CN', '328', '长子县'),
('zh_CN', '329', '武乡县'),
('zh_CN', '330', '沁县'),
('zh_CN', '331', '沁源县'),
('zh_CN', '332', '潞城市'),
('zh_CN', '333', '沁水县'),
('zh_CN', '334', '阳城县'),
('zh_CN', '335', '陵川县'),
('zh_CN', '336', '泽州县'),
('zh_CN', '337', '高平市'),
('zh_CN', '338', '尧都区'),
('zh_CN', '339', '曲沃县'),
('zh_CN', '340', '翼城县'),
('zh_CN', '341', '襄汾县'),
('zh_CN', '342', '洪洞县'),
('zh_CN', '343', '古县'),
('zh_CN', '344', '安泽县'),
('zh_CN', '345', '浮山县'),
('zh_CN', '346', '吉县'),
('zh_CN', '347', '乡宁县'),
('zh_CN', '348', '大宁县'),
('zh_CN', '349', '隰县'),
('zh_CN', '350', '永和县'),
('zh_CN', '351', '蒲县'),
('zh_CN', '352', '汾西县'),
('zh_CN', '353', '侯马市'),
('zh_CN', '354', '霍州市'),
('zh_CN', '355', '离石区'),
('zh_CN', '356', '文水县'),
('zh_CN', '357', '交城县'),
('zh_CN', '358', '兴县'),
('zh_CN', '359', '临县'),
('zh_CN', '360', '柳林县'),
('zh_CN', '361', '石楼县'),
('zh_CN', '362', '岚县'),
('zh_CN', '363', '方山县'),
('zh_CN', '364', '中阳县'),
('zh_CN', '365', '交口县'),
('zh_CN', '366', '孝义市'),
('zh_CN', '367', '汾阳市'),
('zh_CN', '368', '盐湖区'),
('zh_CN', '369', '临猗县'),
('zh_CN', '370', '万荣县'),
('zh_CN', '371', '闻喜县'),
('zh_CN', '372', '稷山县'),
('zh_CN', '373', '新绛县'),
('zh_CN', '374', '绛县'),
('zh_CN', '375', '垣曲县'),
('zh_CN', '376', '夏县'),
('zh_CN', '377', '平陆县'),
('zh_CN', '378', '芮城县'),
('zh_CN', '379', '永济市'),
('zh_CN', '380', '河津市'),
('zh_CN', '381', '和平区'),
('zh_CN', '382', '沈河区'),
('zh_CN', '383', '大东区'),
('zh_CN', '384', '皇姑区'),
('zh_CN', '385', '铁西区'),
('zh_CN', '386', '苏家屯区'),
('zh_CN', '387', '东陵区'),
('zh_CN', '388', '沈北新区'),
('zh_CN', '389', '于洪区'),
('zh_CN', '390', '辽中县'),
('zh_CN', '391', '康平县'),
('zh_CN', '392', '法库县'),
('zh_CN', '393', '新民市'),
('zh_CN', '394', '银州区'),
('zh_CN', '395', '清河区'),
('zh_CN', '396', '铁岭县'),
('zh_CN', '397', '西丰县'),
('zh_CN', '398', '昌图县'),
('zh_CN', '399', '调兵山市'),
('zh_CN', '400', '开原市'),
('zh_CN', '401', '长海县'),
('zh_CN', '402', '旅顺口区'),
('zh_CN', '403', '中山区'),
('zh_CN', '404', '西岗区'),
('zh_CN', '405', '沙河口区'),
('zh_CN', '406', '甘井子区'),
('zh_CN', '407', '金州区'),
('zh_CN', '408', '普兰店市'),
('zh_CN', '409', '瓦房店市'),
('zh_CN', '410', '庄河市'),
('zh_CN', '411', '铁东区'),
('zh_CN', '412', '铁西区'),
('zh_CN', '413', '立山区'),
('zh_CN', '414', '千山区'),
('zh_CN', '415', '台安县'),
('zh_CN', '416', '岫岩满族自治县'),
('zh_CN', '417', '海城市'),
('zh_CN', '418', '新抚区'),
('zh_CN', '419', '东洲区'),
('zh_CN', '420', '望花区'),
('zh_CN', '421', '顺城区'),
('zh_CN', '422', '抚顺县'),
('zh_CN', '423', '新宾满族自治县'),
('zh_CN', '424', '清原满族自治县'),
('zh_CN', '425', '平山区'),
('zh_CN', '426', '溪湖区'),
('zh_CN', '427', '明山区'),
('zh_CN', '428', '南芬区'),
('zh_CN', '429', '本溪满族自治县'),
('zh_CN', '430', '桓仁满族自治县'),
('zh_CN', '431', '元宝区'),
('zh_CN', '432', '振兴区'),
('zh_CN', '433', '振安区'),
('zh_CN', '434', '宽甸满族自治县'),
('zh_CN', '435', '东港市'),
('zh_CN', '436', '凤城市'),
('zh_CN', '437', '古塔区'),
('zh_CN', '438', '凌河区'),
('zh_CN', '439', '太和区'),
('zh_CN', '440', '黑山县'),
('zh_CN', '441', '义县'),
('zh_CN', '442', '凌海市'),
('zh_CN', '443', '北镇市'),
('zh_CN', '444', '站前区'),
('zh_CN', '445', '西市区'),
('zh_CN', '446', '鮁鱼圈区'),
('zh_CN', '447', '老边区'),
('zh_CN', '448', '盖州市'),
('zh_CN', '449', '大石桥市'),
('zh_CN', '450', '海州区'),
('zh_CN', '451', '新邱区'),
('zh_CN', '452', '太平区'),
('zh_CN', '453', '清河门区'),
('zh_CN', '454', '细河区'),
('zh_CN', '455', '阜新蒙古族自治县'),
('zh_CN', '456', '彰武县'),
('zh_CN', '457', '白塔区'),
('zh_CN', '458', '文圣区'),
('zh_CN', '459', '宏伟区'),
('zh_CN', '460', '弓长岭区'),
('zh_CN', '461', '太子河区'),
('zh_CN', '462', '辽阳县'),
('zh_CN', '463', '灯塔市'),
('zh_CN', '464', '双塔区'),
('zh_CN', '465', '龙城区'),
('zh_CN', '466', '朝阳县'),
('zh_CN', '467', '建平县'),
('zh_CN', '468', '喀喇沁左翼蒙古族自治县'),
('zh_CN', '469', '北票市'),
('zh_CN', '470', '凌源市'),
('zh_CN', '471', '双台子区'),
('zh_CN', '472', '兴隆台区'),
('zh_CN', '473', '大洼县'),
('zh_CN', '474', '盘山县'),
('zh_CN', '475', '连山区'),
('zh_CN', '476', '龙港区'),
('zh_CN', '477', '南票区'),
('zh_CN', '478', '绥中县'),
('zh_CN', '479', '建昌县'),
('zh_CN', '480', '兴城市'),
('zh_CN', '481', '南关区'),
('zh_CN', '482', '宽城区'),
('zh_CN', '483', '朝阳区'),
('zh_CN', '484', '二道区'),
('zh_CN', '485', '绿园区'),
('zh_CN', '486', '双阳区'),
('zh_CN', '487', '农安县'),
('zh_CN', '488', '九台市'),
('zh_CN', '489', '榆树市'),
('zh_CN', '490', '德惠市'),
('zh_CN', '491', '昌邑区'),
('zh_CN', '492', '龙潭区'),
('zh_CN', '493', '船营区'),
('zh_CN', '494', '丰满区'),
('zh_CN', '495', '永吉县'),
('zh_CN', '496', '蛟河市'),
('zh_CN', '497', '桦甸市'),
('zh_CN', '498', '舒兰市'),
('zh_CN', '499', '磐石市'),
('zh_CN', '500', '延吉市'),
('zh_CN', '501', '图们市'),
('zh_CN', '502', '敦化市'),
('zh_CN', '503', '珲春市'),
('zh_CN', '504', '龙井市'),
('zh_CN', '505', '和龙市'),
('zh_CN', '506', '汪清县'),
('zh_CN', '507', '安图县'),
('zh_CN', '508', '铁西区'),
('zh_CN', '509', '铁东区'),
('zh_CN', '510', '梨树县'),
('zh_CN', '511', '伊通满族自治县'),
('zh_CN', '512', '公主岭市'),
('zh_CN', '513', '双辽市'),
('zh_CN', '514', '东昌区'),
('zh_CN', '515', '二道江区'),
('zh_CN', '516', '通化县'),
('zh_CN', '517', '辉南县'),
('zh_CN', '518', '柳河县'),
('zh_CN', '519', '梅河口市'),
('zh_CN', '520', '集安市'),
('zh_CN', '521', '洮北区'),
('zh_CN', '522', '镇赉县'),
('zh_CN', '523', '通榆县'),
('zh_CN', '524', '洮南市'),
('zh_CN', '525', '大安市'),
('zh_CN', '526', '龙山区'),
('zh_CN', '527', '西安区'),
('zh_CN', '528', '东丰县'),
('zh_CN', '529', '东辽县'),
('zh_CN', '530', '宁江区'),
('zh_CN', '531', '前郭尔罗斯蒙古族自治县'),
('zh_CN', '532', '长岭县'),
('zh_CN', '533', '乾安县'),
('zh_CN', '534', '扶余县'),
('zh_CN', '535', '八道江区'),
('zh_CN', '536', '江源区'),
('zh_CN', '537', '抚松县'),
('zh_CN', '538', '靖宇县'),
('zh_CN', '539', '长白朝鲜族自治县'),
('zh_CN', '540', '临江市'),
('zh_CN', '541', '道里区'),
('zh_CN', '542', '南岗区'),
('zh_CN', '543', '道外区'),
('zh_CN', '544', '平房区'),
('zh_CN', '545', '松北区'),
('zh_CN', '546', '香坊区'),
('zh_CN', '547', '呼兰区'),
('zh_CN', '548', '阿城区'),
('zh_CN', '549', '依兰县'),
('zh_CN', '550', '方正县'),
('zh_CN', '551', '宾县'),
('zh_CN', '552', '巴彦县'),
('zh_CN', '553', '木兰县'),
('zh_CN', '554', '通河县'),
('zh_CN', '555', '延寿县'),
('zh_CN', '556', '双城市'),
('zh_CN', '557', '尚志市'),
('zh_CN', '558', '五常市'),
('zh_CN', '559', '龙沙区'),
('zh_CN', '560', '建华区'),
('zh_CN', '561', '铁锋区'),
('zh_CN', '562', '昂昂溪区'),
('zh_CN', '563', '富拉尔基区'),
('zh_CN', '564', '碾子山区'),
('zh_CN', '565', '梅里斯达翰尔族区'),
('zh_CN', '566', '龙江县'),
('zh_CN', '567', '依安县'),
('zh_CN', '568', '泰来县'),
('zh_CN', '569', '甘南县'),
('zh_CN', '570', '富裕县'),
('zh_CN', '571', '克山县'),
('zh_CN', '572', '克东县'),
('zh_CN', '573', '拜泉县'),
('zh_CN', '574', '讷河市'),
('zh_CN', '575', '鸡冠区'),
('zh_CN', '576', '恒山区'),
('zh_CN', '577', '滴道区'),
('zh_CN', '578', '梨树区'),
('zh_CN', '579', '城子河区'),
('zh_CN', '580', '麻山区'),
('zh_CN', '581', '鸡东县'),
('zh_CN', '582', '虎林市'),
('zh_CN', '583', '密山市'),
('zh_CN', '584', '东安区'),
('zh_CN', '585', '阳明区'),
('zh_CN', '586', '爱民区'),
('zh_CN', '587', '西安区'),
('zh_CN', '588', '东宁县'),
('zh_CN', '589', '林口县'),
('zh_CN', '590', '绥芬河市'),
('zh_CN', '591', '海林市'),
('zh_CN', '592', '宁安市'),
('zh_CN', '593', '穆棱市'),
('zh_CN', '594', '新兴区'),
('zh_CN', '595', '桃山区'),
('zh_CN', '596', '茄子河区'),
('zh_CN', '597', '勃利县'),
('zh_CN', '598', '向阳区'),
('zh_CN', '599', '前进区'),
('zh_CN', '600', '东风区'),
('zh_CN', '601', '桦南县'),
('zh_CN', '602', '桦川县'),
('zh_CN', '603', '汤原县'),
('zh_CN', '604', '抚远县'),
('zh_CN', '605', '同江市'),
('zh_CN', '606', '富锦市'),
('zh_CN', '607', '向阳区'),
('zh_CN', '608', '工农区'),
('zh_CN', '609', '南山区'),
('zh_CN', '610', '兴安区'),
('zh_CN', '611', '东山区'),
('zh_CN', '612', '兴山区'),
('zh_CN', '613', '萝北县'),
('zh_CN', '614', '绥滨县'),
('zh_CN', '615', '尖山区'),
('zh_CN', '616', '岭东区'),
('zh_CN', '617', '四方台区'),
('zh_CN', '618', '宝山区'),
('zh_CN', '619', '集贤县'),
('zh_CN', '620', '友谊县'),
('zh_CN', '621', '宝清县'),
('zh_CN', '622', '饶河县'),
('zh_CN', '623', '北林区'),
('zh_CN', '624', '望奎县'),
('zh_CN', '625', '兰西县'),
('zh_CN', '626', '青冈县'),
('zh_CN', '627', '庆安县'),
('zh_CN', '628', '明水县'),
('zh_CN', '629', '绥棱县'),
('zh_CN', '630', '安达市'),
('zh_CN', '631', '肇东市'),
('zh_CN', '632', '海伦市'),
('zh_CN', '633', '爱辉区'),
('zh_CN', '634', '嫩江县'),
('zh_CN', '635', '逊克县'),
('zh_CN', '636', '孙吴县'),
('zh_CN', '637', '北安市'),
('zh_CN', '638', '五大连池市'),
('zh_CN', '639', '呼玛县'),
('zh_CN', '640', '塔河县'),
('zh_CN', '641', '漠河县'),
('zh_CN', '642', '伊春区'),
('zh_CN', '643', '南岔区'),
('zh_CN', '644', '友好区'),
('zh_CN', '645', '西林区'),
('zh_CN', '646', '翠峦区'),
('zh_CN', '647', '新青区'),
('zh_CN', '648', '美溪区'),
('zh_CN', '649', '金山屯区'),
('zh_CN', '650', '五营区'),
('zh_CN', '651', '乌马河区'),
('zh_CN', '652', '汤旺河区'),
('zh_CN', '653', '带岭区'),
('zh_CN', '654', '乌伊岭区'),
('zh_CN', '655', '红星区'),
('zh_CN', '656', '上甘岭区'),
('zh_CN', '657', '嘉荫县'),
('zh_CN', '658', '铁力市'),
('zh_CN', '659', '萨尔图区'),
('zh_CN', '660', '龙凤区'),
('zh_CN', '661', '让胡路区'),
('zh_CN', '662', '红岗区'),
('zh_CN', '663', '大同区'),
('zh_CN', '664', '肇州县'),
('zh_CN', '665', '肇源县'),
('zh_CN', '666', '林甸县'),
('zh_CN', '667', '杜尔伯特蒙古族自治县'),
('zh_CN', '668', '江宁区'),
('zh_CN', '669', '浦口区'),
('zh_CN', '670', '玄武区'),
('zh_CN', '671', '白下区'),
('zh_CN', '672', '秦淮区'),
('zh_CN', '673', '建邺区'),
('zh_CN', '674', '鼓楼区'),
('zh_CN', '675', '下关区'),
('zh_CN', '676', '栖霞区'),
('zh_CN', '677', '雨花台区'),
('zh_CN', '678', '六合区'),
('zh_CN', '679', '溧水县'),
('zh_CN', '680', '高淳县'),
('zh_CN', '681', '崇安区'),
('zh_CN', '682', '南长区'),
('zh_CN', '683', '北塘区'),
('zh_CN', '684', '锡山区'),
('zh_CN', '685', '惠山区'),
('zh_CN', '686', '滨湖区'),
('zh_CN', '687', '江阴市'),
('zh_CN', '688', '宜兴市'),
('zh_CN', '689', '京口区'),
('zh_CN', '690', '润州区'),
('zh_CN', '691', '丹徒区'),
('zh_CN', '692', '丹阳市'),
('zh_CN', '693', '扬中市'),
('zh_CN', '694', '句容市'),
('zh_CN', '695', '沧浪区'),
('zh_CN', '696', '常熟市'),
('zh_CN', '697', '平江区'),
('zh_CN', '698', '金阊区'),
('zh_CN', '699', '虎丘区'),
('zh_CN', '700', '昆山市'),
('zh_CN', '701', '太仓市'),
('zh_CN', '702', '吴江市'),
('zh_CN', '703', '吴中区'),
('zh_CN', '704', '相城区'),
('zh_CN', '705', '张家港市'),
('zh_CN', '706', '崇川区'),
('zh_CN', '707', '港闸区'),
('zh_CN', '708', '海安县'),
('zh_CN', '709', '如东县'),
('zh_CN', '710', '启东市'),
('zh_CN', '711', '如皋市'),
('zh_CN', '712', '通州市'),
('zh_CN', '713', '海门市'),
('zh_CN', '714', '高邮市'),
('zh_CN', '715', '广陵区'),
('zh_CN', '716', '邗江区'),
('zh_CN', '717', '维扬区'),
('zh_CN', '718', '宝应县'),
('zh_CN', '719', '江都市'),
('zh_CN', '720', '仪征市'),
('zh_CN', '721', '亭湖区'),
('zh_CN', '722', '盐都区'),
('zh_CN', '723', '响水县'),
('zh_CN', '724', '滨海县'),
('zh_CN', '725', '阜宁县'),
('zh_CN', '726', '射阳县'),
('zh_CN', '727', '建湖县'),
('zh_CN', '728', '东台市'),
('zh_CN', '729', '大丰市'),
('zh_CN', '730', '鼓楼区'),
('zh_CN', '731', '云龙区'),
('zh_CN', '732', '九里区'),
('zh_CN', '733', '贾汪区'),
('zh_CN', '734', '泉山区'),
('zh_CN', '735', '丰县'),
('zh_CN', '736', '沛县'),
('zh_CN', '737', '铜山县'),
('zh_CN', '738', '睢宁县'),
('zh_CN', '739', '新沂市'),
('zh_CN', '740', '邳州市'),
('zh_CN', '741', '清河区'),
('zh_CN', '742', '楚州区'),
('zh_CN', '743', '淮阴区'),
('zh_CN', '744', '清浦区'),
('zh_CN', '745', '涟水县'),
('zh_CN', '746', '洪泽县'),
('zh_CN', '747', '盱眙县'),
('zh_CN', '748', '金湖县'),
('zh_CN', '749', '连云区'),
('zh_CN', '750', '新浦区'),
('zh_CN', '751', '海州区'),
('zh_CN', '752', '赣榆县'),
('zh_CN', '753', '东海县'),
('zh_CN', '754', '灌云县'),
('zh_CN', '755', '灌南县'),
('zh_CN', '756', '天宁区'),
('zh_CN', '757', '钟楼区'),
('zh_CN', '758', '戚墅堰区'),
('zh_CN', '759', '新北区'),
('zh_CN', '760', '武进区'),
('zh_CN', '761', '溧阳市'),
('zh_CN', '762', '金坛市'),
('zh_CN', '763', '海陵区'),
('zh_CN', '764', '高港区'),
('zh_CN', '765', '兴化市'),
('zh_CN', '766', '靖江市'),
('zh_CN', '767', '泰兴市'),
('zh_CN', '768', '姜堰市'),
('zh_CN', '769', '宿城区'),
('zh_CN', '770', '宿豫区'),
('zh_CN', '771', '沭阳县'),
('zh_CN', '772', '泗阳县'),
('zh_CN', '773', '泗洪县'),
('zh_CN', '774', '定海区'),
('zh_CN', '775', '普陀区'),
('zh_CN', '776', '岱山县'),
('zh_CN', '777', '嵊泗县'),
('zh_CN', '778', '柯城区'),
('zh_CN', '779', '衢江区'),
('zh_CN', '780', '常山县'),
('zh_CN', '781', '开化县'),
('zh_CN', '782', '龙游县'),
('zh_CN', '783', '江山市'),
('zh_CN', '784', '上城区'),
('zh_CN', '785', '下城区'),
('zh_CN', '786', '江干区'),
('zh_CN', '787', '拱墅区'),
('zh_CN', '788', '西湖区'),
('zh_CN', '789', '滨江区'),
('zh_CN', '790', '余杭区'),
('zh_CN', '791', '桐庐县'),
('zh_CN', '792', '淳安县'),
('zh_CN', '793', '建德市'),
('zh_CN', '794', '富阳市'),
('zh_CN', '795', '临安市'),
('zh_CN', '796', '萧山区'),
('zh_CN', '797', '吴兴区'),
('zh_CN', '798', '南浔区'),
('zh_CN', '799', '德清县'),
('zh_CN', '800', '长兴县'),
('zh_CN', '801', '安吉县'),
('zh_CN', '802', '南湖区'),
('zh_CN', '803', '秀洲区'),
('zh_CN', '804', '嘉善县'),
('zh_CN', '805', '海盐县'),
('zh_CN', '806', '海宁市'),
('zh_CN', '807', '平湖市'),
('zh_CN', '808', '桐乡市'),
('zh_CN', '809', '海曙区'),
('zh_CN', '810', '江东区'),
('zh_CN', '811', '江北区'),
('zh_CN', '812', '北仑区'),
('zh_CN', '813', '镇海区'),
('zh_CN', '814', '鄞州区'),
('zh_CN', '815', '象山县'),
('zh_CN', '816', '宁海县'),
('zh_CN', '817', '余姚市'),
('zh_CN', '818', '慈溪市'),
('zh_CN', '819', '奉化市'),
('zh_CN', '820', '越城区'),
('zh_CN', '821', '绍兴县'),
('zh_CN', '822', '新昌县'),
('zh_CN', '823', '诸暨市'),
('zh_CN', '824', '上虞市'),
('zh_CN', '825', '嵊州市'),
('zh_CN', '826', '鹿城区'),
('zh_CN', '827', '龙湾区'),
('zh_CN', '828', '瓯海区'),
('zh_CN', '829', '洞头县'),
('zh_CN', '830', '永嘉县'),
('zh_CN', '831', '平阳县'),
('zh_CN', '832', '苍南县'),
('zh_CN', '833', '文成县'),
('zh_CN', '834', '泰顺县'),
('zh_CN', '835', '瑞安市'),
('zh_CN', '836', '乐清市'),
('zh_CN', '837', '莲都区'),
('zh_CN', '838', '青田县'),
('zh_CN', '839', '缙云县'),
('zh_CN', '840', '遂昌县'),
('zh_CN', '841', '松阳县'),
('zh_CN', '842', '云和县'),
('zh_CN', '843', '庆元县'),
('zh_CN', '844', '景宁畲族自治县'),
('zh_CN', '845', '龙泉市'),
('zh_CN', '846', '婺城区'),
('zh_CN', '847', '金东区'),
('zh_CN', '848', '武义县'),
('zh_CN', '849', '浦江县'),
('zh_CN', '850', '磐安县'),
('zh_CN', '851', '兰溪市'),
('zh_CN', '852', '义乌市'),
('zh_CN', '853', '东阳市'),
('zh_CN', '854', '永康市'),
('zh_CN', '855', '椒江区'),
('zh_CN', '856', '黄岩区'),
('zh_CN', '857', '路桥区'),
('zh_CN', '858', '玉环县'),
('zh_CN', '859', '三门县'),
('zh_CN', '860', '天台县'),
('zh_CN', '861', '仙居县'),
('zh_CN', '862', '温岭市'),
('zh_CN', '863', '临海市'),
('zh_CN', '864', '瑶海区'),
('zh_CN', '865', '庐阳区'),
('zh_CN', '866', '蜀山区'),
('zh_CN', '867', '包河区'),
('zh_CN', '868', '长丰县'),
('zh_CN', '869', '肥东县'),
('zh_CN', '870', '肥西县'),
('zh_CN', '871', '镜湖区'),
('zh_CN', '872', '弋江区'),
('zh_CN', '873', '鸠江区'),
('zh_CN', '874', '三山区'),
('zh_CN', '875', '芜湖县'),
('zh_CN', '876', '繁昌县'),
('zh_CN', '877', '南陵县'),
('zh_CN', '878', '龙子湖区'),
('zh_CN', '879', '蚌山区'),
('zh_CN', '880', '禹会区'),
('zh_CN', '881', '淮上区'),
('zh_CN', '882', '怀远县'),
('zh_CN', '883', '五河县'),
('zh_CN', '884', '固镇县'),
('zh_CN', '885', '大通区'),
('zh_CN', '886', '田家庵区'),
('zh_CN', '887', '谢家集区'),
('zh_CN', '888', '八公山区'),
('zh_CN', '889', '潘集区'),
('zh_CN', '890', '凤台县'),
('zh_CN', '891', '金家庄区'),
('zh_CN', '892', '花山区'),
('zh_CN', '893', '雨山区'),
('zh_CN', '894', '当涂县'),
('zh_CN', '895', '杜集区'),
('zh_CN', '896', '相山区'),
('zh_CN', '897', '烈山区'),
('zh_CN', '898', '濉溪县'),
('zh_CN', '899', '铜官山区'),
('zh_CN', '900', '狮子山区'),
('zh_CN', '901', '铜陵县'),
('zh_CN', '902', '迎江区'),
('zh_CN', '903', '大观区'),
('zh_CN', '904', '宜秀区'),
('zh_CN', '905', '怀宁县'),
('zh_CN', '906', '枞阳县'),
('zh_CN', '907', '潜山县'),
('zh_CN', '908', '太湖县'),
('zh_CN', '909', '宿松县'),
('zh_CN', '910', '望江县'),
('zh_CN', '911', '岳西县'),
('zh_CN', '912', '桐城市'),
('zh_CN', '913', '屯溪区'),
('zh_CN', '914', '黄山区'),
('zh_CN', '915', '徽州区'),
('zh_CN', '916', '歙县'),
('zh_CN', '917', '休宁县'),
('zh_CN', '918', '黟县'),
('zh_CN', '919', '祁门县'),
('zh_CN', '920', '琅琊区'),
('zh_CN', '921', '南谯区'),
('zh_CN', '922', '来安县'),
('zh_CN', '923', '全椒县'),
('zh_CN', '924', '定远县'),
('zh_CN', '925', '凤阳县'),
('zh_CN', '926', '天长市'),
('zh_CN', '927', '明光市'),
('zh_CN', '928', '颍州区'),
('zh_CN', '929', '颍东区'),
('zh_CN', '930', '颍泉区'),
('zh_CN', '931', '临泉县'),
('zh_CN', '932', '太和县'),
('zh_CN', '933', '阜南县'),
('zh_CN', '934', '颍上县'),
('zh_CN', '935', '界首市'),
('zh_CN', '936', '埇桥区'),
('zh_CN', '937', '砀山县'),
('zh_CN', '938', '萧县'),
('zh_CN', '939', '灵璧县'),
('zh_CN', '940', '泗县'),
('zh_CN', '941', '居巢区'),
('zh_CN', '942', '庐江县'),
('zh_CN', '943', '无为县'),
('zh_CN', '944', '含山县'),
('zh_CN', '945', '和县'),
('zh_CN', '946', '金安区'),
('zh_CN', '947', '裕安区'),
('zh_CN', '948', '寿县'),
('zh_CN', '949', '霍邱县'),
('zh_CN', '950', '舒城县'),
('zh_CN', '951', '金寨县'),
('zh_CN', '952', '霍山县'),
('zh_CN', '953', '谯城区'),
('zh_CN', '954', '涡阳县'),
('zh_CN', '955', '蒙城县'),
('zh_CN', '956', '利辛县'),
('zh_CN', '957', '贵池区'),
('zh_CN', '958', '东至县'),
('zh_CN', '959', '石台县'),
('zh_CN', '960', '青阳县'),
('zh_CN', '961', '宣州区'),
('zh_CN', '962', '郎溪县'),
('zh_CN', '963', '广德县'),
('zh_CN', '964', '泾县'),
('zh_CN', '965', '绩溪县'),
('zh_CN', '966', '旌德县'),
('zh_CN', '967', '宁国市'),
('zh_CN', '968', '鼓楼区'),
('zh_CN', '969', '台江区'),
('zh_CN', '970', '仓山区'),
('zh_CN', '971', '马尾区'),
('zh_CN', '972', '晋安区'),
('zh_CN', '973', '闽侯县'),
('zh_CN', '974', '连江县'),
('zh_CN', '975', '罗源县'),
('zh_CN', '976', '闽清县'),
('zh_CN', '977', '永泰县'),
('zh_CN', '978', '平潭县'),
('zh_CN', '979', '福清市'),
('zh_CN', '980', '长乐市'),
('zh_CN', '981', '思明区'),
('zh_CN', '982', '海沧区'),
('zh_CN', '983', '湖里区'),
('zh_CN', '984', '集美区'),
('zh_CN', '985', '同安区'),
('zh_CN', '986', '翔安区'),
('zh_CN', '987', '蕉城区'),
('zh_CN', '988', '霞浦县'),
('zh_CN', '989', '古田县'),
('zh_CN', '990', '屏南县'),
('zh_CN', '991', '寿宁县'),
('zh_CN', '992', '周宁县'),
('zh_CN', '993', '柘荣县'),
('zh_CN', '994', '福安市'),
('zh_CN', '995', '福鼎市'),
('zh_CN', '996', '城厢区'),
('zh_CN', '997', '涵江区'),
('zh_CN', '998', '荔城区'),
('zh_CN', '999', '秀屿区'),
('zh_CN', '1000', '仙游县'),
('zh_CN', '1001', '鲤城区'),
('zh_CN', '1002', '丰泽区'),
('zh_CN', '1003', '洛江区'),
('zh_CN', '1004', '泉港区'),
('zh_CN', '1005', '惠安县'),
('zh_CN', '1006', '安溪县'),
('zh_CN', '1007', '永春县'),
('zh_CN', '1008', '德化县'),
('zh_CN', '1009', '石狮市'),
('zh_CN', '1010', '晋江市'),
('zh_CN', '1011', '南安市'),
('zh_CN', '1012', '芗城区'),
('zh_CN', '1013', '龙文区'),
('zh_CN', '1014', '云霄县'),
('zh_CN', '1015', '漳浦县'),
('zh_CN', '1016', '诏安县'),
('zh_CN', '1017', '长泰县'),
('zh_CN', '1018', '东山县'),
('zh_CN', '1019', '南靖县'),
('zh_CN', '1020', '平和县'),
('zh_CN', '1021', '华安县'),
('zh_CN', '1022', '龙海市'),
('zh_CN', '1023', '新罗区'),
('zh_CN', '1024', '长汀县'),
('zh_CN', '1025', '永定县'),
('zh_CN', '1026', '上杭县'),
('zh_CN', '1027', '武平县'),
('zh_CN', '1028', '连城县'),
('zh_CN', '1029', '漳平市'),
('zh_CN', '1030', '梅列区'),
('zh_CN', '1031', '三元区'),
('zh_CN', '1032', '明溪县'),
('zh_CN', '1033', '清流县'),
('zh_CN', '1034', '宁化县'),
('zh_CN', '1035', '大田县'),
('zh_CN', '1036', '尤溪县'),
('zh_CN', '1037', '沙县'),
('zh_CN', '1038', '将乐县'),
('zh_CN', '1039', '泰宁县'),
('zh_CN', '1040', '建宁县'),
('zh_CN', '1041', '永安市'),
('zh_CN', '1042', '延平区'),
('zh_CN', '1043', '顺昌县'),
('zh_CN', '1044', '浦城县'),
('zh_CN', '1045', '光泽县'),
('zh_CN', '1046', '松溪县'),
('zh_CN', '1047', '政和县'),
('zh_CN', '1048', '邵武市'),
('zh_CN', '1049', '武夷山市'),
('zh_CN', '1050', '建瓯市'),
('zh_CN', '1051', '建阳市'),
('zh_CN', '1052', '月湖区'),
('zh_CN', '1053', '余江县'),
('zh_CN', '1054', '贵溪市'),
('zh_CN', '1055', '渝水区'),
('zh_CN', '1056', '分宜县'),
('zh_CN', '1057', '东湖区'),
('zh_CN', '1058', '西湖区'),
('zh_CN', '1059', '青云谱区'),
('zh_CN', '1060', '湾里区'),
('zh_CN', '1061', '青山湖区'),
('zh_CN', '1062', '南昌县'),
('zh_CN', '1063', '新建县'),
('zh_CN', '1064', '安义县'),
('zh_CN', '1065', '进贤县'),
('zh_CN', '1066', '庐山区'),
('zh_CN', '1067', '浔阳区'),
('zh_CN', '1068', '九江县'),
('zh_CN', '1069', '武宁县'),
('zh_CN', '1070', '修水县'),
('zh_CN', '1071', '永修县'),
('zh_CN', '1072', '德安县'),
('zh_CN', '1073', '星子县'),
('zh_CN', '1074', '都昌县'),
('zh_CN', '1075', '湖口县'),
('zh_CN', '1076', '彭泽县'),
('zh_CN', '1077', '瑞昌市'),
('zh_CN', '1078', '信州区'),
('zh_CN', '1079', '上饶县'),
('zh_CN', '1080', '广丰县'),
('zh_CN', '1081', '玉山县'),
('zh_CN', '1082', '铅山县'),
('zh_CN', '1083', '横峰县'),
('zh_CN', '1084', '弋阳县'),
('zh_CN', '1085', '余干县'),
('zh_CN', '1086', '鄱阳县'),
('zh_CN', '1087', '万年县'),
('zh_CN', '1088', '婺源县'),
('zh_CN', '1089', '德兴市'),
('zh_CN', '1090', '临川区'),
('zh_CN', '1091', '南城县'),
('zh_CN', '1092', '黎川县'),
('zh_CN', '1093', '南丰县'),
('zh_CN', '1094', '崇仁县'),
('zh_CN', '1095', '乐安县'),
('zh_CN', '1096', '宜黄县'),
('zh_CN', '1097', '金溪县'),
('zh_CN', '1098', '资溪县'),
('zh_CN', '1099', '东乡县'),
('zh_CN', '1100', '广昌县'),
('zh_CN', '1101', '袁州区'),
('zh_CN', '1102', '奉新县'),
('zh_CN', '1103', '万载县'),
('zh_CN', '1104', '上高县'),
('zh_CN', '1105', '宜丰县'),
('zh_CN', '1106', '靖安县'),
('zh_CN', '1107', '铜鼓县'),
('zh_CN', '1108', '丰城市'),
('zh_CN', '1109', '樟树市'),
('zh_CN', '1110', '高安市'),
('zh_CN', '1111', '吉州区'),
('zh_CN', '1112', '青原区'),
('zh_CN', '1113', '吉安县'),
('zh_CN', '1114', '吉水县'),
('zh_CN', '1115', '峡江县'),
('zh_CN', '1116', '新干县'),
('zh_CN', '1117', '永丰县'),
('zh_CN', '1118', '泰和县'),
('zh_CN', '1119', '遂川县'),
('zh_CN', '1120', '万安县'),
('zh_CN', '1121', '安福县'),
('zh_CN', '1122', '永新县'),
('zh_CN', '1123', '井冈山市'),
('zh_CN', '1124', '章贡区'),
('zh_CN', '1125', '赣县'),
('zh_CN', '1126', '信丰县'),
('zh_CN', '1127', '大余县'),
('zh_CN', '1128', '上犹县'),
('zh_CN', '1129', '崇义县'),
('zh_CN', '1130', '安远县'),
('zh_CN', '1131', '龙南县'),
('zh_CN', '1132', '定南县'),
('zh_CN', '1133', '全南县'),
('zh_CN', '1134', '宁都县'),
('zh_CN', '1135', '于都县'),
('zh_CN', '1136', '兴国县'),
('zh_CN', '1137', '会昌县'),
('zh_CN', '1138', '寻乌县'),
('zh_CN', '1139', '石城县'),
('zh_CN', '1140', '瑞金市'),
('zh_CN', '1141', '南康市'),
('zh_CN', '1142', '昌江区'),
('zh_CN', '1143', '珠山区'),
('zh_CN', '1144', '浮梁县'),
('zh_CN', '1145', '乐平市'),
('zh_CN', '1146', '安源区'),
('zh_CN', '1147', '湘东区'),
('zh_CN', '1148', '莲花县'),
('zh_CN', '1149', '上栗县'),
('zh_CN', '1150', '芦溪县'),
('zh_CN', '1151', '牡丹区'),
('zh_CN', '1152', '曹县'),
('zh_CN', '1153', '单县'),
('zh_CN', '1154', '成武县'),
('zh_CN', '1155', '巨野县'),
('zh_CN', '1156', '郓城县'),
('zh_CN', '1157', '鄄城县'),
('zh_CN', '1158', '定陶县'),
('zh_CN', '1159', '东明县'),
('zh_CN', '1160', '历下区'),
('zh_CN', '1161', '市中区'),
('zh_CN', '1162', '槐荫区'),
('zh_CN', '1163', '天桥区'),
('zh_CN', '1164', '历城区'),
('zh_CN', '1165', '长清区'),
('zh_CN', '1166', '平阴县'),
('zh_CN', '1167', '济阳县'),
('zh_CN', '1168', '商河县'),
('zh_CN', '1169', '章丘市'),
('zh_CN', '1170', '市南区'),
('zh_CN', '1171', '市北区'),
('zh_CN', '1172', '四方区'),
('zh_CN', '1173', '黄岛区'),
('zh_CN', '1174', '崂山区'),
('zh_CN', '1175', '李沧区'),
('zh_CN', '1176', '城阳区'),
('zh_CN', '1177', '胶州市'),
('zh_CN', '1178', '即墨市'),
('zh_CN', '1179', '平度市'),
('zh_CN', '1180', '胶南市'),
('zh_CN', '1181', '莱西市'),
('zh_CN', '1182', '淄川区'),
('zh_CN', '1183', '张店区'),
('zh_CN', '1184', '博山区'),
('zh_CN', '1185', '临淄区'),
('zh_CN', '1186', '周村区'),
('zh_CN', '1187', '桓台县'),
('zh_CN', '1188', '高青县'),
('zh_CN', '1189', '沂源县'),
('zh_CN', '1190', '德城区'),
('zh_CN', '1191', '陵县'),
('zh_CN', '1192', '宁津县'),
('zh_CN', '1193', '庆云县'),
('zh_CN', '1194', '临邑县'),
('zh_CN', '1195', '齐河县'),
('zh_CN', '1196', '平原县'),
('zh_CN', '1197', '夏津县'),
('zh_CN', '1198', '武城县'),
('zh_CN', '1199', '乐陵市'),
('zh_CN', '1200', '禹城市'),
('zh_CN', '1201', '芝罘区'),
('zh_CN', '1202', '福山区'),
('zh_CN', '1203', '牟平区'),
('zh_CN', '1204', '莱山区'),
('zh_CN', '1205', '长岛县'),
('zh_CN', '1206', '龙口市'),
('zh_CN', '1207', '莱阳市'),
('zh_CN', '1208', '莱州市'),
('zh_CN', '1209', '蓬莱市'),
('zh_CN', '1210', '招远市'),
('zh_CN', '1211', '栖霞市'),
('zh_CN', '1212', '海阳市'),
('zh_CN', '1213', '潍城区'),
('zh_CN', '1214', '寒亭区'),
('zh_CN', '1215', '坊子区'),
('zh_CN', '1216', '奎文区'),
('zh_CN', '1217', '临朐县'),
('zh_CN', '1218', '昌乐县'),
('zh_CN', '1219', '青州市'),
('zh_CN', '1220', '诸城市'),
('zh_CN', '1221', '寿光市'),
('zh_CN', '1222', '安丘市'),
('zh_CN', '1223', '高密市'),
('zh_CN', '1224', '昌邑市'),
('zh_CN', '1225', '市中区'),
('zh_CN', '1226', '任城区'),
('zh_CN', '1227', '微山县'),
('zh_CN', '1228', '鱼台县'),
('zh_CN', '1229', '金乡县'),
('zh_CN', '1230', '嘉祥县'),
('zh_CN', '1231', '汶上县'),
('zh_CN', '1232', '泗水县'),
('zh_CN', '1233', '梁山县'),
('zh_CN', '1234', '曲阜市'),
('zh_CN', '1235', '兖州市'),
('zh_CN', '1236', '邹城市'),
('zh_CN', '1237', '泰山区'),
('zh_CN', '1238', '岱岳区'),
('zh_CN', '1239', '宁阳县'),
('zh_CN', '1240', '东平县'),
('zh_CN', '1241', '新泰市'),
('zh_CN', '1242', '肥城市'),
('zh_CN', '1243', '兰山区'),
('zh_CN', '1244', '罗庄区'),
('zh_CN', '1245', '河东区'),
('zh_CN', '1246', '沂南县'),
('zh_CN', '1247', '郯城县'),
('zh_CN', '1248', '沂水县'),
('zh_CN', '1249', '苍山县'),
('zh_CN', '1250', '费县'),
('zh_CN', '1251', '平邑县'),
('zh_CN', '1252', '莒南县'),
('zh_CN', '1253', '蒙阴县'),
('zh_CN', '1254', '临沭县'),
('zh_CN', '1255', '滨城区'),
('zh_CN', '1256', '惠民县'),
('zh_CN', '1257', '阳信县'),
('zh_CN', '1258', '无棣县'),
('zh_CN', '1259', '沾化县'),
('zh_CN', '1260', '博兴县'),
('zh_CN', '1261', '邹平县'),
('zh_CN', '1262', '东营区'),
('zh_CN', '1263', '河口区'),
('zh_CN', '1264', '垦利县'),
('zh_CN', '1265', '利津县'),
('zh_CN', '1266', '广饶县'),
('zh_CN', '1267', '环翠区'),
('zh_CN', '1268', '文登市'),
('zh_CN', '1269', '荣成市'),
('zh_CN', '1270', '乳山市'),
('zh_CN', '1271', '市中区'),
('zh_CN', '1272', '薛城区'),
('zh_CN', '1273', '峄城区'),
('zh_CN', '1274', '台儿庄区'),
('zh_CN', '1275', '山亭区'),
('zh_CN', '1276', '滕州市'),
('zh_CN', '1277', '东港区'),
('zh_CN', '1278', '岚山区'),
('zh_CN', '1279', '五莲县'),
('zh_CN', '1280', '莒县'),
('zh_CN', '1281', '莱城区'),
('zh_CN', '1282', '钢城区'),
('zh_CN', '1283', '东昌府区'),
('zh_CN', '1284', '阳谷县'),
('zh_CN', '1285', '莘县'),
('zh_CN', '1286', '茌平县'),
('zh_CN', '1287', '东阿县'),
('zh_CN', '1288', '冠县'),
('zh_CN', '1289', '高唐县'),
('zh_CN', '1290', '临清市'),
('zh_CN', '1291', '梁园区'),
('zh_CN', '1292', '睢阳区'),
('zh_CN', '1293', '民权县'),
('zh_CN', '1294', '睢县'),
('zh_CN', '1295', '宁陵县'),
('zh_CN', '1296', '柘城县'),
('zh_CN', '1297', '虞城县'),
('zh_CN', '1298', '夏邑县'),
('zh_CN', '1299', '永城市'),
('zh_CN', '1300', '中原区'),
('zh_CN', '1301', '二七区'),
('zh_CN', '1302', '管城回族区'),
('zh_CN', '1303', '金水区'),
('zh_CN', '1304', '上街区'),
('zh_CN', '1305', '惠济区'),
('zh_CN', '1306', '中牟县'),
('zh_CN', '1307', '巩义市'),
('zh_CN', '1308', '荥阳市'),
('zh_CN', '1309', '新密市'),
('zh_CN', '1310', '新郑市'),
('zh_CN', '1311', '登封市'),
('zh_CN', '1312', '文峰区'),
('zh_CN', '1313', '北关区'),
('zh_CN', '1314', '殷都区'),
('zh_CN', '1315', '龙安区'),
('zh_CN', '1316', '安阳县'),
('zh_CN', '1317', '汤阴县'),
('zh_CN', '1318', '滑县'),
('zh_CN', '1319', '内黄县'),
('zh_CN', '1320', '林州市'),
('zh_CN', '1321', '红旗区'),
('zh_CN', '1322', '卫滨区'),
('zh_CN', '1323', '凤泉区'),
('zh_CN', '1324', '牧野区'),
('zh_CN', '1325', '新乡县'),
('zh_CN', '1326', '获嘉县'),
('zh_CN', '1327', '原阳县'),
('zh_CN', '1328', '延津县'),
('zh_CN', '1329', '封丘县'),
('zh_CN', '1330', '长垣县'),
('zh_CN', '1331', '卫辉市'),
('zh_CN', '1332', '辉县市'),
('zh_CN', '1333', '魏都区'),
('zh_CN', '1334', '许昌县'),
('zh_CN', '1335', '鄢陵县'),
('zh_CN', '1336', '襄城县'),
('zh_CN', '1337', '禹州市'),
('zh_CN', '1338', '长葛市'),
('zh_CN', '1339', '新华区'),
('zh_CN', '1340', '卫东区'),
('zh_CN', '1341', '石龙区'),
('zh_CN', '1342', '湛河区'),
('zh_CN', '1343', '宝丰县'),
('zh_CN', '1344', '叶县'),
('zh_CN', '1345', '鲁山县'),
('zh_CN', '1346', '郏县'),
('zh_CN', '1347', '舞钢市'),
('zh_CN', '1348', '汝州市'),
('zh_CN', '1349', '浉河区'),
('zh_CN', '1350', '平桥区'),
('zh_CN', '1351', '罗山县'),
('zh_CN', '1352', '光山县'),
('zh_CN', '1353', '新县'),
('zh_CN', '1354', '商城县'),
('zh_CN', '1355', '固始县'),
('zh_CN', '1356', '潢川县'),
('zh_CN', '1357', '淮滨县'),
('zh_CN', '1358', '息县'),
('zh_CN', '1359', '宛城区'),
('zh_CN', '1360', '卧龙区'),
('zh_CN', '1361', '南召县'),
('zh_CN', '1362', '方城县'),
('zh_CN', '1363', '西峡县'),
('zh_CN', '1364', '镇平县'),
('zh_CN', '1365', '内乡县'),
('zh_CN', '1366', '淅川县'),
('zh_CN', '1367', '社旗县'),
('zh_CN', '1368', '唐河县'),
('zh_CN', '1369', '新野县'),
('zh_CN', '1370', '桐柏县'),
('zh_CN', '1371', '邓州市'),
('zh_CN', '1372', '龙亭区'),
('zh_CN', '1373', '顺河回族区'),
('zh_CN', '1374', '鼓楼区'),
('zh_CN', '1375', '禹王台区'),
('zh_CN', '1376', '金明区'),
('zh_CN', '1377', '杞县'),
('zh_CN', '1378', '通许县'),
('zh_CN', '1379', '尉氏县'),
('zh_CN', '1380', '开封县'),
('zh_CN', '1381', '兰考县'),
('zh_CN', '1382', '老城区'),
('zh_CN', '1383', '西工区'),
('zh_CN', '1384', '瀍河回族区'),
('zh_CN', '1385', '涧西区'),
('zh_CN', '1386', '吉利区'),
('zh_CN', '1387', '洛龙区'),
('zh_CN', '1388', '孟津县'),
('zh_CN', '1389', '新安县'),
('zh_CN', '1390', '栾川县'),
('zh_CN', '1391', '嵩县'),
('zh_CN', '1392', '汝阳县'),
('zh_CN', '1393', '宜阳县'),
('zh_CN', '1394', '洛宁县'),
('zh_CN', '1395', '伊川县'),
('zh_CN', '1396', '偃师市'),
('zh_CN', '1397', '解放区'),
('zh_CN', '1398', '中站区'),
('zh_CN', '1399', '马村区'),
('zh_CN', '1400', '山阳区'),
('zh_CN', '1401', '修武县'),
('zh_CN', '1402', '博爱县'),
('zh_CN', '1403', '武陟县'),
('zh_CN', '1404', '温县'),
('zh_CN', '1405', '沁阳市'),
('zh_CN', '1406', '孟州市'),
('zh_CN', '1407', '鹤山区'),
('zh_CN', '1408', '山城区'),
('zh_CN', '1409', '淇滨区'),
('zh_CN', '1410', '浚县'),
('zh_CN', '1411', '淇县'),
('zh_CN', '1412', '华龙区'),
('zh_CN', '1413', '清丰县'),
('zh_CN', '1414', '南乐县'),
('zh_CN', '1415', '范县'),
('zh_CN', '1416', '台前县'),
('zh_CN', '1417', '濮阳县'),
('zh_CN', '1418', '川汇区'),
('zh_CN', '1419', '扶沟县'),
('zh_CN', '1420', '西华县'),
('zh_CN', '1421', '商水县'),
('zh_CN', '1422', '沈丘县'),
('zh_CN', '1423', '郸城县'),
('zh_CN', '1424', '淮阳县'),
('zh_CN', '1425', '太康县'),
('zh_CN', '1426', '鹿邑县'),
('zh_CN', '1427', '项城市'),
('zh_CN', '1428', '源汇区'),
('zh_CN', '1429', '郾城区'),
('zh_CN', '1430', '召陵区'),
('zh_CN', '1431', '舞阳县'),
('zh_CN', '1432', '临颍县'),
('zh_CN', '1433', '驿城区'),
('zh_CN', '1434', '西平县'),
('zh_CN', '1435', '上蔡县'),
('zh_CN', '1436', '平舆县'),
('zh_CN', '1437', '正阳县'),
('zh_CN', '1438', '确山县'),
('zh_CN', '1439', '泌阳县'),
('zh_CN', '1440', '汝南县'),
('zh_CN', '1441', '遂平县'),
('zh_CN', '1442', '新蔡县'),
('zh_CN', '1443', '湖滨区'),
('zh_CN', '1444', '渑池县'),
('zh_CN', '1445', '陕县'),
('zh_CN', '1446', '卢氏县'),
('zh_CN', '1447', '义马市'),
('zh_CN', '1448', '灵宝市'),
('zh_CN', '1449', '江岸区'),
('zh_CN', '1450', '江汉区'),
('zh_CN', '1451', '硚口区'),
('zh_CN', '1452', '汉阳区'),
('zh_CN', '1453', '武昌区'),
('zh_CN', '1454', '青山区'),
('zh_CN', '1455', '洪山区'),
('zh_CN', '1456', '东西湖区'),
('zh_CN', '1457', '汉南区'),
('zh_CN', '1458', '蔡甸区'),
('zh_CN', '1459', '江夏区'),
('zh_CN', '1460', '黄陂区'),
('zh_CN', '1461', '新洲区'),
('zh_CN', '1462', '襄城区'),
('zh_CN', '1463', '樊城区'),
('zh_CN', '1464', '襄阳区'),
('zh_CN', '1465', '南漳县'),
('zh_CN', '1466', '谷城县'),
('zh_CN', '1467', '保康县'),
('zh_CN', '1468', '老河口市'),
('zh_CN', '1469', '枣阳市'),
('zh_CN', '1470', '宜城市'),
('zh_CN', '1471', '梁子湖区'),
('zh_CN', '1472', '华容区'),
('zh_CN', '1473', '鄂城区'),
('zh_CN', '1474', '孝南区'),
('zh_CN', '1475', '孝昌县'),
('zh_CN', '1476', '大悟县'),
('zh_CN', '1477', '云梦县'),
('zh_CN', '1478', '应城市'),
('zh_CN', '1479', '安陆市'),
('zh_CN', '1480', '汉川市'),
('zh_CN', '1481', '黄州区'),
('zh_CN', '1482', '团风县'),
('zh_CN', '1483', '红安县'),
('zh_CN', '1484', '罗田县'),
('zh_CN', '1485', '英山县'),
('zh_CN', '1486', '浠水县'),
('zh_CN', '1487', '蕲春县'),
('zh_CN', '1488', '黄梅县'),
('zh_CN', '1489', '麻城市'),
('zh_CN', '1490', '武穴市'),
('zh_CN', '1491', '黄石港区'),
('zh_CN', '1492', '西塞山区'),
('zh_CN', '1493', '下陆区'),
('zh_CN', '1494', '铁山区'),
('zh_CN', '1495', '阳新县'),
('zh_CN', '1496', '大冶市'),
('zh_CN', '1497', '咸安区'),
('zh_CN', '1498', '嘉鱼县'),
('zh_CN', '1499', '通城县'),
('zh_CN', '1500', '崇阳县'),
('zh_CN', '1501', '通山县'),
('zh_CN', '1502', '赤壁市'),
('zh_CN', '1503', '沙市区'),
('zh_CN', '1504', '荆州区'),
('zh_CN', '1505', '公安县'),
('zh_CN', '1506', '监利县'),
('zh_CN', '1507', '江陵县'),
('zh_CN', '1508', '石首市'),
('zh_CN', '1509', '洪湖市'),
('zh_CN', '1510', '松滋市'),
('zh_CN', '1511', '西陵区'),
('zh_CN', '1512', '伍家岗区'),
('zh_CN', '1513', '点军区'),
('zh_CN', '1514', '猇亭区'),
('zh_CN', '1515', '夷陵区'),
('zh_CN', '1516', '远安县'),
('zh_CN', '1517', '兴山县'),
('zh_CN', '1518', '秭归县'),
('zh_CN', '1519', '长阳土家族自治县'),
('zh_CN', '1520', '五峰土家族自治县'),
('zh_CN', '1521', '宜都市'),
('zh_CN', '1522', '当阳市'),
('zh_CN', '1523', '枝江市'),
('zh_CN', '1524', '恩施市'),
('zh_CN', '1525', '利川市'),
('zh_CN', '1526', '建始县'),
('zh_CN', '1527', '巴东县'),
('zh_CN', '1528', '宣恩县'),
('zh_CN', '1529', '咸丰县'),
('zh_CN', '1530', '来凤县'),
('zh_CN', '1531', '鹤峰县'),
('zh_CN', '1532', '茅箭区'),
('zh_CN', '1533', '张湾区'),
('zh_CN', '1534', '郧县'),
('zh_CN', '1535', '郧西县'),
('zh_CN', '1536', '竹山县'),
('zh_CN', '1537', '竹溪县'),
('zh_CN', '1538', '房县'),
('zh_CN', '1539', '丹江口市'),
('zh_CN', '1540', '曾都区'),
('zh_CN', '1541', '广水市'),
('zh_CN', '1542', '东宝区'),
('zh_CN', '1543', '掇刀区'),
('zh_CN', '1544', '京山县'),
('zh_CN', '1545', '沙洋县'),
('zh_CN', '1546', '钟祥市'),
('zh_CN', '1547', '岳阳楼区'),
('zh_CN', '1548', '云溪区'),
('zh_CN', '1549', '君山区'),
('zh_CN', '1550', '岳阳县'),
('zh_CN', '1551', '华容县'),
('zh_CN', '1552', '湘阴县'),
('zh_CN', '1553', '平江县'),
('zh_CN', '1554', '汨罗市'),
('zh_CN', '1555', '临湘市'),
('zh_CN', '1556', '芙蓉区'),
('zh_CN', '1557', '天心区'),
('zh_CN', '1558', '岳麓区'),
('zh_CN', '1559', '开福区'),
('zh_CN', '1560', '雨花区'),
('zh_CN', '1561', '长沙县'),
('zh_CN', '1562', '望城县'),
('zh_CN', '1563', '宁乡县'),
('zh_CN', '1564', '浏阳市'),
('zh_CN', '1565', '雨湖区'),
('zh_CN', '1566', '岳塘区'),
('zh_CN', '1567', '湘潭县'),
('zh_CN', '1568', '湘乡市'),
('zh_CN', '1569', '韶山市'),
('zh_CN', '1570', '荷塘区'),
('zh_CN', '1571', '芦淞区'),
('zh_CN', '1572', '石峰区'),
('zh_CN', '1573', '天元区'),
('zh_CN', '1574', '株洲县'),
('zh_CN', '1575', '攸县'),
('zh_CN', '1576', '茶陵县'),
('zh_CN', '1577', '炎陵县'),
('zh_CN', '1578', '醴陵市'),
('zh_CN', '1579', '珠晖区'),
('zh_CN', '1580', '雁峰区'),
('zh_CN', '1581', '石鼓区'),
('zh_CN', '1582', '蒸湘区'),
('zh_CN', '1583', '南岳区'),
('zh_CN', '1584', '衡阳县'),
('zh_CN', '1585', '衡南县'),
('zh_CN', '1586', '衡山县'),
('zh_CN', '1587', '衡东县'),
('zh_CN', '1588', '祁东县'),
('zh_CN', '1589', '耒阳市'),
('zh_CN', '1590', '常宁市'),
('zh_CN', '1591', '北湖区'),
('zh_CN', '1592', '苏仙区'),
('zh_CN', '1593', '桂阳县'),
('zh_CN', '1594', '宜章县'),
('zh_CN', '1595', '永兴县'),
('zh_CN', '1596', '嘉禾县'),
('zh_CN', '1597', '临武县'),
('zh_CN', '1598', '汝城县'),
('zh_CN', '1599', '桂东县'),
('zh_CN', '1600', '安仁县'),
('zh_CN', '1601', '资兴市'),
('zh_CN', '1602', '武陵区'),
('zh_CN', '1603', '鼎城区'),
('zh_CN', '1604', '安乡县'),
('zh_CN', '1605', '汉寿县'),
('zh_CN', '1606', '澧县'),
('zh_CN', '1607', '临澧县'),
('zh_CN', '1608', '桃源县'),
('zh_CN', '1609', '石门县'),
('zh_CN', '1610', '津市市'),
('zh_CN', '1611', '资阳区'),
('zh_CN', '1612', '赫山区'),
('zh_CN', '1613', '南县'),
('zh_CN', '1614', '桃江县'),
('zh_CN', '1615', '安化县'),
('zh_CN', '1616', '沅江市'),
('zh_CN', '1617', '娄星区'),
('zh_CN', '1618', '双峰县'),
('zh_CN', '1619', '新化县'),
('zh_CN', '1620', '冷水江市'),
('zh_CN', '1621', '涟源市'),
('zh_CN', '1622', '双清区'),
('zh_CN', '1623', '大祥区'),
('zh_CN', '1624', '北塔区'),
('zh_CN', '1625', '邵东县'),
('zh_CN', '1626', '新邵县'),
('zh_CN', '1627', '邵阳县'),
('zh_CN', '1628', '隆回县'),
('zh_CN', '1629', '洞口县'),
('zh_CN', '1630', '绥宁县'),
('zh_CN', '1631', '新宁县'),
('zh_CN', '1632', '城步苗族自治县'),
('zh_CN', '1633', '武冈市'),
('zh_CN', '1634', '吉首市'),
('zh_CN', '1635', '泸溪县'),
('zh_CN', '1636', '凤凰县'),
('zh_CN', '1637', '花垣县'),
('zh_CN', '1638', '保靖县'),
('zh_CN', '1639', '古丈县'),
('zh_CN', '1640', '永顺县'),
('zh_CN', '1641', '龙山县'),
('zh_CN', '1642', '永定区'),
('zh_CN', '1643', '武陵源区'),
('zh_CN', '1644', '慈利县'),
('zh_CN', '1645', '桑植县'),
('zh_CN', '1646', '鹤城区'),
('zh_CN', '1647', '中方县'),
('zh_CN', '1648', '沅陵县'),
('zh_CN', '1649', '辰溪县'),
('zh_CN', '1650', '溆浦县'),
('zh_CN', '1651', '会同县'),
('zh_CN', '1652', '麻阳苗族自治县'),
('zh_CN', '1653', '新晃侗族自治县'),
('zh_CN', '1654', '芷江侗族自治县'),
('zh_CN', '1655', '靖州苗族侗族自治县'),
('zh_CN', '1656', '通道侗族自治县'),
('zh_CN', '1657', '洪江市'),
('zh_CN', '1658', '零陵区'),
('zh_CN', '1659', '冷水滩区'),
('zh_CN', '1660', '祁阳县'),
('zh_CN', '1661', '东安县'),
('zh_CN', '1662', '双牌县'),
('zh_CN', '1663', '道县'),
('zh_CN', '1664', '江永县'),
('zh_CN', '1665', '宁远县'),
('zh_CN', '1666', '蓝山县'),
('zh_CN', '1667', '新田县'),
('zh_CN', '1668', '江华瑶族自治县'),
('zh_CN', '1669', '从化市'),
('zh_CN', '1670', '荔湾区'),
('zh_CN', '1671', '越秀区'),
('zh_CN', '1672', '海珠区'),
('zh_CN', '1673', '天河区'),
('zh_CN', '1674', '白云区'),
('zh_CN', '1675', '花都区'),
('zh_CN', '1676', '黄埔区'),
('zh_CN', '1677', '萝岗区'),
('zh_CN', '1678', '南沙区'),
('zh_CN', '1679', '番禺区'),
('zh_CN', '1680', '增城市'),
('zh_CN', '1681', '海丰县'),
('zh_CN', '1682', '陆河县'),
('zh_CN', '1683', '陆丰市'),
('zh_CN', '1684', '江城区'),
('zh_CN', '1685', '阳西县'),
('zh_CN', '1686', '阳东县'),
('zh_CN', '1687', '阳春市'),
('zh_CN', '1688', '榕城区'),
('zh_CN', '1689', '揭东县'),
('zh_CN', '1690', '揭西县'),
('zh_CN', '1691', '惠来县'),
('zh_CN', '1692', '普宁市'),
('zh_CN', '1693', '茂南区'),
('zh_CN', '1694', '茂港区'),
('zh_CN', '1695', '电白县'),
('zh_CN', '1696', '高州市'),
('zh_CN', '1697', '化州市'),
('zh_CN', '1698', '信宜市'),
('zh_CN', '1699', '惠城区'),
('zh_CN', '1700', '惠阳区'),
('zh_CN', '1701', '博罗县'),
('zh_CN', '1702', '惠东县'),
('zh_CN', '1703', '龙门县'),
('zh_CN', '1704', '蓬江区'),
('zh_CN', '1705', '江海区'),
('zh_CN', '1706', '新会区'),
('zh_CN', '1707', '台山市'),
('zh_CN', '1708', '开平市'),
('zh_CN', '1709', '鹤山市'),
('zh_CN', '1710', '恩平市'),
('zh_CN', '1711', '武江区'),
('zh_CN', '1712', '浈江区'),
('zh_CN', '1713', '曲江区'),
('zh_CN', '1714', '始兴县'),
('zh_CN', '1715', '仁化县'),
('zh_CN', '1716', '翁源县'),
('zh_CN', '1717', '乳源瑶族自治县'),
('zh_CN', '1718', '新丰县'),
('zh_CN', '1719', '乐昌市'),
('zh_CN', '1720', '南雄市'),
('zh_CN', '1721', '梅江区'),
('zh_CN', '1722', '梅县'),
('zh_CN', '1723', '大埔县'),
('zh_CN', '1724', '丰顺县'),
('zh_CN', '1725', '五华县'),
('zh_CN', '1726', '平远县'),
('zh_CN', '1727', '蕉岭县'),
('zh_CN', '1728', '兴宁市'),
('zh_CN', '1729', '龙湖区'),
('zh_CN', '1730', '金平区'),
('zh_CN', '1731', '濠江区'),
('zh_CN', '1732', '潮阳区'),
('zh_CN', '1733', '潮南区'),
('zh_CN', '1734', '澄海区'),
('zh_CN', '1735', '南澳县'),
('zh_CN', '1736', '罗湖区'),
('zh_CN', '1737', '福田区'),
('zh_CN', '1738', '南山区'),
('zh_CN', '1739', '宝安区'),
('zh_CN', '1740', '龙岗区'),
('zh_CN', '1741', '盐田区'),
('zh_CN', '1742', '香洲区'),
('zh_CN', '1743', '斗门区'),
('zh_CN', '1744', '金湾区'),
('zh_CN', '1745', '禅城区'),
('zh_CN', '1746', '南海区'),
('zh_CN', '1747', '顺德区'),
('zh_CN', '1748', '三水区'),
('zh_CN', '1749', '高明区'),
('zh_CN', '1750', '端州区'),
('zh_CN', '1751', '鼎湖区'),
('zh_CN', '1752', '广宁县'),
('zh_CN', '1753', '怀集县'),
('zh_CN', '1754', '封开县'),
('zh_CN', '1755', '德庆县'),
('zh_CN', '1756', '高要市'),
('zh_CN', '1757', '四会市'),
('zh_CN', '1758', '赤坎区'),
('zh_CN', '1759', '霞山区'),
('zh_CN', '1760', '坡头区'),
('zh_CN', '1761', '麻章区'),
('zh_CN', '1762', '遂溪县'),
('zh_CN', '1763', '徐闻县'),
('zh_CN', '1764', '廉江市'),
('zh_CN', '1765', '雷州市'),
('zh_CN', '1766', '吴川市'),
('zh_CN', '1767', '源城区'),
('zh_CN', '1768', '紫金县'),
('zh_CN', '1769', '龙川县'),
('zh_CN', '1770', '连平县'),
('zh_CN', '1771', '和平县'),
('zh_CN', '1772', '东源县'),
('zh_CN', '1773', '清城区'),
('zh_CN', '1774', '佛冈县'),
('zh_CN', '1775', '阳山县'),
('zh_CN', '1776', '连山壮族瑶族自治县'),
('zh_CN', '1777', '连南瑶族自治县'),
('zh_CN', '1778', '清新县'),
('zh_CN', '1779', '英德市'),
('zh_CN', '1780', '连州市'),
('zh_CN', '1781', '云城区'),
('zh_CN', '1782', '新兴县'),
('zh_CN', '1783', '郁南县'),
('zh_CN', '1784', '云安县'),
('zh_CN', '1785', '罗定市'),
('zh_CN', '1786', '湘桥区'),
('zh_CN', '1787', '潮安县'),
('zh_CN', '1788', '饶平县'),
('zh_CN', '1789', '城关区'),
('zh_CN', '1790', '七里河区'),
('zh_CN', '1791', '西固区'),
('zh_CN', '1792', '安宁区'),
('zh_CN', '1793', '红古区'),
('zh_CN', '1794', '永登县'),
('zh_CN', '1795', '皋兰县'),
('zh_CN', '1796', '榆中县'),
('zh_CN', '1797', '金川区'),
('zh_CN', '1798', '永昌县'),
('zh_CN', '1799', '白银区'),
('zh_CN', '1800', '平川区'),
('zh_CN', '1801', '靖远县'),
('zh_CN', '1802', '会宁县'),
('zh_CN', '1803', '景泰县'),
('zh_CN', '1804', '秦州区'),
('zh_CN', '1805', '麦积区'),
('zh_CN', '1806', '清水县'),
('zh_CN', '1807', '秦安县'),
('zh_CN', '1808', '甘谷县'),
('zh_CN', '1809', '武山县'),
('zh_CN', '1810', '张家川回族自治县'),
('zh_CN', '1811', '凉州区'),
('zh_CN', '1812', '民勤县'),
('zh_CN', '1813', '古浪县'),
('zh_CN', '1814', '天祝藏族自治县'),
('zh_CN', '1815', '甘州区'),
('zh_CN', '1816', '肃南裕固族自治县'),
('zh_CN', '1817', '民乐县'),
('zh_CN', '1818', '临泽县'),
('zh_CN', '1819', '高台县'),
('zh_CN', '1820', '山丹县'),
('zh_CN', '1821', '崆峒区'),
('zh_CN', '1822', '泾川县'),
('zh_CN', '1823', '灵台县'),
('zh_CN', '1824', '崇信县'),
('zh_CN', '1825', '华亭县'),
('zh_CN', '1826', '庄浪县'),
('zh_CN', '1827', '静宁县'),
('zh_CN', '1828', '肃州区'),
('zh_CN', '1829', '金塔县'),
('zh_CN', '1830', '瓜州县'),
('zh_CN', '1831', '肃北蒙古族自治县'),
('zh_CN', '1832', '阿克塞哈萨克族自治县'),
('zh_CN', '1833', '玉门市'),
('zh_CN', '1834', '敦煌市'),
('zh_CN', '1835', '西峰区'),
('zh_CN', '1836', '庆城县'),
('zh_CN', '1837', '环县'),
('zh_CN', '1838', '华池县'),
('zh_CN', '1839', '合水县'),
('zh_CN', '1840', '正宁县'),
('zh_CN', '1841', '宁县'),
('zh_CN', '1842', '镇原县'),
('zh_CN', '1843', '安定区'),
('zh_CN', '1844', '通渭县'),
('zh_CN', '1845', '陇西县'),
('zh_CN', '1846', '渭源县'),
('zh_CN', '1847', '临洮县'),
('zh_CN', '1848', '漳县'),
('zh_CN', '1849', '岷县'),
('zh_CN', '1850', '武都区'),
('zh_CN', '1851', '成县'),
('zh_CN', '1852', '文县'),
('zh_CN', '1853', '宕昌县'),
('zh_CN', '1854', '康县'),
('zh_CN', '1855', '西和县'),
('zh_CN', '1856', '礼县'),
('zh_CN', '1857', '徽县'),
('zh_CN', '1858', '两当县'),
('zh_CN', '1859', '临夏市'),
('zh_CN', '1860', '临夏县'),
('zh_CN', '1861', '康乐县'),
('zh_CN', '1862', '永靖县'),
('zh_CN', '1863', '广河县'),
('zh_CN', '1864', '和政县'),
('zh_CN', '1865', '东乡族自治县'),
('zh_CN', '1866', '积石山保安族东乡族撒拉族自治县'),
('zh_CN', '1867', '合作市'),
('zh_CN', '1868', '临潭县'),
('zh_CN', '1869', '卓尼县'),
('zh_CN', '1870', '舟曲县'),
('zh_CN', '1871', '迭部县'),
('zh_CN', '1872', '玛曲县'),
('zh_CN', '1873', '碌曲县'),
('zh_CN', '1874', '夏河县'),
('zh_CN', '1875', '锦江区'),
('zh_CN', '1876', '青羊区'),
('zh_CN', '1877', '金牛区'),
('zh_CN', '1878', '武侯区'),
('zh_CN', '1879', '成华区'),
('zh_CN', '1880', '龙泉驿区'),
('zh_CN', '1881', '青白江区'),
('zh_CN', '1882', '新都区'),
('zh_CN', '1883', '温江区'),
('zh_CN', '1884', '金堂县'),
('zh_CN', '1885', '双流县'),
('zh_CN', '1886', '郫县'),
('zh_CN', '1887', '大邑县'),
('zh_CN', '1888', '蒲江县'),
('zh_CN', '1889', '新津县'),
('zh_CN', '1890', '都江堰市'),
('zh_CN', '1891', '彭州市'),
('zh_CN', '1892', '邛崃市'),
('zh_CN', '1893', '崇州市'),
('zh_CN', '1894', '东区'),
('zh_CN', '1895', '西区'),
('zh_CN', '1896', '仁和区'),
('zh_CN', '1897', '米易县'),
('zh_CN', '1898', '盐边县'),
('zh_CN', '1899', '自流井区'),
('zh_CN', '1900', '贡井区'),
('zh_CN', '1901', '大安区'),
('zh_CN', '1902', '沿滩区'),
('zh_CN', '1903', '荣县'),
('zh_CN', '1904', '富顺县'),
('zh_CN', '1905', '涪城区'),
('zh_CN', '1906', '游仙区'),
('zh_CN', '1907', '三台县'),
('zh_CN', '1908', '盐亭县'),
('zh_CN', '1909', '安县'),
('zh_CN', '1910', '梓潼县'),
('zh_CN', '1911', '北川羌族自治县'),
('zh_CN', '1912', '平武县'),
('zh_CN', '1913', '江油市'),
('zh_CN', '1914', '顺庆区'),
('zh_CN', '1915', '高坪区'),
('zh_CN', '1916', '嘉陵区'),
('zh_CN', '1917', '南部县'),
('zh_CN', '1918', '营山县'),
('zh_CN', '1919', '蓬安县'),
('zh_CN', '1920', '仪陇县'),
('zh_CN', '1921', '西充县'),
('zh_CN', '1922', '阆中市'),
('zh_CN', '1923', '通川区'),
('zh_CN', '1924', '达县'),
('zh_CN', '1925', '宣汉县'),
('zh_CN', '1926', '开江县'),
('zh_CN', '1927', '大竹县'),
('zh_CN', '1928', '渠县'),
('zh_CN', '1929', '万源市'),
('zh_CN', '1930', '船山区'),
('zh_CN', '1931', '安居区'),
('zh_CN', '1932', '蓬溪县'),
('zh_CN', '1933', '射洪县'),
('zh_CN', '1934', '大英县'),
('zh_CN', '1935', '广安区'),
('zh_CN', '1936', '岳池县'),
('zh_CN', '1937', '武胜县'),
('zh_CN', '1938', '邻水县'),
('zh_CN', '1939', '华蓥市'),
('zh_CN', '1940', '巴州区'),
('zh_CN', '1941', '通江县'),
('zh_CN', '1942', '南江县'),
('zh_CN', '1943', '平昌县'),
('zh_CN', '1944', '江阳区'),
('zh_CN', '1945', '纳溪区'),
('zh_CN', '1946', '龙马潭区'),
('zh_CN', '1947', '泸县'),
('zh_CN', '1948', '合江县'),
('zh_CN', '1949', '叙永县'),
('zh_CN', '1950', '古蔺县'),
('zh_CN', '1951', '翠屏区'),
('zh_CN', '1952', '宜宾县'),
('zh_CN', '1953', '南溪县'),
('zh_CN', '1954', '江安县'),
('zh_CN', '1955', '长宁县'),
('zh_CN', '1956', '高县'),
('zh_CN', '1957', '珙县'),
('zh_CN', '1958', '筠连县'),
('zh_CN', '1959', '兴文县'),
('zh_CN', '1960', '屏山县'),
('zh_CN', '1961', '雁江区'),
('zh_CN', '1962', '安岳县'),
('zh_CN', '1963', '乐至县'),
('zh_CN', '1964', '简阳市'),
('zh_CN', '1965', '市中区'),
('zh_CN', '1966', '东兴区'),
('zh_CN', '1967', '威远县'),
('zh_CN', '1968', '资中县'),
('zh_CN', '1969', '隆昌县'),
('zh_CN', '1970', '市中区'),
('zh_CN', '1971', '沙湾区'),
('zh_CN', '1972', '五通桥区'),
('zh_CN', '1973', '金口河区'),
('zh_CN', '1974', '犍为县'),
('zh_CN', '1975', '井研县'),
('zh_CN', '1976', '夹江县'),
('zh_CN', '1977', '沐川县'),
('zh_CN', '1978', '峨边彝族自治县'),
('zh_CN', '1979', '马边彝族自治县'),
('zh_CN', '1980', '峨眉山市'),
('zh_CN', '1981', '东坡区'),
('zh_CN', '1982', '仁寿县'),
('zh_CN', '1983', '彭山县'),
('zh_CN', '1984', '洪雅县'),
('zh_CN', '1985', '丹棱县'),
('zh_CN', '1986', '青神县'),
('zh_CN', '1987', '西昌市'),
('zh_CN', '1988', '木里藏族自治县'),
('zh_CN', '1989', '盐源县'),
('zh_CN', '1990', '德昌县'),
('zh_CN', '1991', '会理县'),
('zh_CN', '1992', '会东县'),
('zh_CN', '1993', '宁南县'),
('zh_CN', '1994', '普格县'),
('zh_CN', '1995', '布拖县'),
('zh_CN', '1996', '金阳县'),
('zh_CN', '1997', '昭觉县'),
('zh_CN', '1998', '喜德县'),
('zh_CN', '1999', '冕宁县'),
('zh_CN', '2000', '越西县'),
('zh_CN', '2001', '甘洛县'),
('zh_CN', '2002', '美姑县'),
('zh_CN', '2003', '雷波县'),
('zh_CN', '2004', '雨城区'),
('zh_CN', '2005', '名山县'),
('zh_CN', '2006', '荥经县'),
('zh_CN', '2007', '汉源县'),
('zh_CN', '2008', '石棉县'),
('zh_CN', '2009', '天全县'),
('zh_CN', '2010', '芦山县'),
('zh_CN', '2011', '宝兴县'),
('zh_CN', '2012', '康定县'),
('zh_CN', '2013', '泸定县'),
('zh_CN', '2014', '丹巴县'),
('zh_CN', '2015', '九龙县'),
('zh_CN', '2016', '雅江县'),
('zh_CN', '2017', '道孚县'),
('zh_CN', '2018', '炉霍县'),
('zh_CN', '2019', '甘孜县'),
('zh_CN', '2020', '新龙县'),
('zh_CN', '2021', '德格县'),
('zh_CN', '2022', '白玉县'),
('zh_CN', '2023', '石渠县'),
('zh_CN', '2024', '色达县'),
('zh_CN', '2025', '理塘县'),
('zh_CN', '2026', '巴塘县'),
('zh_CN', '2027', '乡城县'),
('zh_CN', '2028', '稻城县'),
('zh_CN', '2029', '得荣县'),
('zh_CN', '2030', '汶川县'),
('zh_CN', '2031', '理县'),
('zh_CN', '2032', '茂县'),
('zh_CN', '2033', '松潘县'),
('zh_CN', '2034', '九寨沟县'),
('zh_CN', '2035', '金川县'),
('zh_CN', '2036', '小金县'),
('zh_CN', '2037', '黑水县'),
('zh_CN', '2038', '马尔康县'),
('zh_CN', '2039', '壤塘县'),
('zh_CN', '2040', '阿坝县'),
('zh_CN', '2041', '若尔盖县'),
('zh_CN', '2042', '红原县'),
('zh_CN', '2043', '旌阳区'),
('zh_CN', '2044', '中江县'),
('zh_CN', '2045', '罗江县'),
('zh_CN', '2046', '广汉市'),
('zh_CN', '2047', '什邡市'),
('zh_CN', '2048', '绵竹市'),
('zh_CN', '2049', '市中区'),
('zh_CN', '2050', '元坝区'),
('zh_CN', '2051', '朝天区'),
('zh_CN', '2052', '旺苍县'),
('zh_CN', '2053', '青川县'),
('zh_CN', '2054', '剑阁县'),
('zh_CN', '2055', '苍溪县'),
('zh_CN', '2056', '南明区'),
('zh_CN', '2057', '云岩区'),
('zh_CN', '2058', '花溪区'),
('zh_CN', '2059', '乌当区'),
('zh_CN', '2060', '白云区'),
('zh_CN', '2061', '小河区'),
('zh_CN', '2062', '开阳县'),
('zh_CN', '2063', '息烽县'),
('zh_CN', '2064', '修文县'),
('zh_CN', '2065', '清镇市'),
('zh_CN', '2066', '红花岗区'),
('zh_CN', '2067', '汇川区'),
('zh_CN', '2068', '遵义县'),
('zh_CN', '2069', '桐梓县'),
('zh_CN', '2070', '绥阳县'),
('zh_CN', '2071', '正安县'),
('zh_CN', '2072', '道真仡佬族苗族自治县'),
('zh_CN', '2073', '务川仡佬族苗族自治县'),
('zh_CN', '2074', '凤冈县'),
('zh_CN', '2075', '湄潭县'),
('zh_CN', '2076', '余庆县'),
('zh_CN', '2077', '习水县'),
('zh_CN', '2078', '赤水市'),
('zh_CN', '2079', '仁怀市'),
('zh_CN', '2080', '西秀区'),
('zh_CN', '2081', '平坝县'),
('zh_CN', '2082', '普定县'),
('zh_CN', '2083', '镇宁布依族苗族自治县'),
('zh_CN', '2084', '关岭布依族苗族自治县'),
('zh_CN', '2085', '紫云苗族布依族自治县'),
('zh_CN', '2086', '都匀市'),
('zh_CN', '2087', '福泉市'),
('zh_CN', '2088', '荔波县'),
('zh_CN', '2089', '贵定县'),
('zh_CN', '2090', '瓮安县'),
('zh_CN', '2091', '独山县'),
('zh_CN', '2092', '平塘县'),
('zh_CN', '2093', '罗甸县'),
('zh_CN', '2094', '长顺县'),
('zh_CN', '2095', '龙里县'),
('zh_CN', '2096', '惠水县'),
('zh_CN', '2097', '三都水族自治县'),
('zh_CN', '2098', '凯里市'),
('zh_CN', '2099', '黄平县'),
('zh_CN', '2100', '施秉县'),
('zh_CN', '2101', '三穗县'),
('zh_CN', '2102', '镇远县'),
('zh_CN', '2103', '岑巩县'),
('zh_CN', '2104', '天柱县'),
('zh_CN', '2105', '锦屏县'),
('zh_CN', '2106', '剑河县'),
('zh_CN', '2107', '台江县'),
('zh_CN', '2108', '黎平县'),
('zh_CN', '2109', '榕江县'),
('zh_CN', '2110', '从江县'),
('zh_CN', '2111', '雷山县'),
('zh_CN', '2112', '麻江县'),
('zh_CN', '2113', '丹寨县'),
('zh_CN', '2114', '铜仁市'),
('zh_CN', '2115', '江口县'),
('zh_CN', '2116', '玉屏侗族自治县'),
('zh_CN', '2117', '石阡县'),
('zh_CN', '2118', '思南县'),
('zh_CN', '2119', '印江土家族苗族自治县'),
('zh_CN', '2120', '德江县'),
('zh_CN', '2121', '沿河土家族自治县'),
('zh_CN', '2122', '松桃苗族自治县'),
('zh_CN', '2123', '万山特区'),
('zh_CN', '2124', '毕节市'),
('zh_CN', '2125', '大方县'),
('zh_CN', '2126', '黔西县'),
('zh_CN', '2127', '金沙县'),
('zh_CN', '2128', '织金县'),
('zh_CN', '2129', '纳雍县'),
('zh_CN', '2130', '威宁彝族回族苗族自治县'),
('zh_CN', '2131', '赫章县'),
('zh_CN', '2132', '钟山区'),
('zh_CN', '2133', '六枝特区'),
('zh_CN', '2134', '水城县'),
('zh_CN', '2135', '盘县'),
('zh_CN', '2136', '兴义市'),
('zh_CN', '2137', '兴仁县'),
('zh_CN', '2138', '普安县'),
('zh_CN', '2139', '晴隆县'),
('zh_CN', '2140', '贞丰县'),
('zh_CN', '2141', '望谟县'),
('zh_CN', '2142', '册亨县'),
('zh_CN', '2143', '安龙县'),
('zh_CN', '2144', '秀英区'),
('zh_CN', '2145', '龙华区'),
('zh_CN', '2146', '琼山区'),
('zh_CN', '2147', '美兰区'),
('zh_CN', '2148', '景洪市'),
('zh_CN', '2149', '勐海县'),
('zh_CN', '2150', '勐腊县'),
('zh_CN', '2151', '瑞丽市'),
('zh_CN', '2152', '潞西市'),
('zh_CN', '2153', '梁河县'),
('zh_CN', '2154', '盈江县'),
('zh_CN', '2155', '陇川县'),
('zh_CN', '2156', '昭阳区'),
('zh_CN', '2157', '鲁甸县'),
('zh_CN', '2158', '巧家县'),
('zh_CN', '2159', '盐津县'),
('zh_CN', '2160', '大关县'),
('zh_CN', '2161', '永善县'),
('zh_CN', '2162', '绥江县'),
('zh_CN', '2163', '镇雄县'),
('zh_CN', '2164', '彝良县'),
('zh_CN', '2165', '威信县'),
('zh_CN', '2166', '水富县'),
('zh_CN', '2167', '五华区'),
('zh_CN', '2168', '盘龙区'),
('zh_CN', '2169', '官渡区'),
('zh_CN', '2170', '西山区'),
('zh_CN', '2171', '东川区'),
('zh_CN', '2172', '呈贡县'),
('zh_CN', '2173', '晋宁县'),
('zh_CN', '2174', '富民县'),
('zh_CN', '2175', '宜良县'),
('zh_CN', '2176', '石林彝族自治县'),
('zh_CN', '2177', '嵩明县'),
('zh_CN', '2178', '禄劝彝族苗族自治县'),
('zh_CN', '2179', '寻甸回族彝族自治县'),
('zh_CN', '2180', '安宁市'),
('zh_CN', '2181', '大理市'),
('zh_CN', '2182', '漾濞彝族自治县'),
('zh_CN', '2183', '祥云县'),
('zh_CN', '2184', '宾川县'),
('zh_CN', '2185', '弥渡县'),
('zh_CN', '2186', '南涧彝族自治县'),
('zh_CN', '2187', '巍山彝族回族自治县'),
('zh_CN', '2188', '永平县'),
('zh_CN', '2189', '云龙县'),
('zh_CN', '2190', '洱源县'),
('zh_CN', '2191', '剑川县'),
('zh_CN', '2192', '鹤庆县'),
('zh_CN', '2193', '个旧市'),
('zh_CN', '2194', '开远市'),
('zh_CN', '2195', '蒙自县'),
('zh_CN', '2196', '屏边苗族自治县'),
('zh_CN', '2197', '建水县'),
('zh_CN', '2198', '石屏县'),
('zh_CN', '2199', '弥勒县'),
('zh_CN', '2200', '泸西县'),
('zh_CN', '2201', '元阳县'),
('zh_CN', '2202', '红河县'),
('zh_CN', '2203', '金平苗族瑶族傣族自治县'),
('zh_CN', '2204', '绿春县'),
('zh_CN', '2205', '河口瑶族自治县'),
('zh_CN', '2206', '麒麟区'),
('zh_CN', '2207', '马龙县'),
('zh_CN', '2208', '陆良县'),
('zh_CN', '2209', '师宗县'),
('zh_CN', '2210', '罗平县'),
('zh_CN', '2211', '富源县'),
('zh_CN', '2212', '会泽县'),
('zh_CN', '2213', '沾益县'),
('zh_CN', '2214', '宣威市'),
('zh_CN', '2215', '隆阳区'),
('zh_CN', '2216', '施甸县'),
('zh_CN', '2217', '腾冲县'),
('zh_CN', '2218', '龙陵县'),
('zh_CN', '2219', '昌宁县'),
('zh_CN', '2220', '文山县'),
('zh_CN', '2221', '砚山县'),
('zh_CN', '2222', '西畴县'),
('zh_CN', '2223', '麻栗坡县'),
('zh_CN', '2224', '马关县'),
('zh_CN', '2225', '丘北县'),
('zh_CN', '2226', '广南县'),
('zh_CN', '2227', '富宁县'),
('zh_CN', '2228', '红塔区'),
('zh_CN', '2229', '江川县'),
('zh_CN', '2230', '澄江县'),
('zh_CN', '2231', '通海县'),
('zh_CN', '2232', '华宁县'),
('zh_CN', '2233', '易门县'),
('zh_CN', '2234', '峨山彝族自治县'),
('zh_CN', '2235', '新平彝族傣族自治县'),
('zh_CN', '2236', '元江哈尼族彝族傣族自治县'),
('zh_CN', '2237', '楚雄市'),
('zh_CN', '2238', '双柏县'),
('zh_CN', '2239', '牟定县'),
('zh_CN', '2240', '南华县'),
('zh_CN', '2241', '姚安县'),
('zh_CN', '2242', '大姚县'),
('zh_CN', '2243', '永仁县'),
('zh_CN', '2244', '元谋县'),
('zh_CN', '2245', '武定县'),
('zh_CN', '2246', '禄丰县'),
('zh_CN', '2247', '思茅区'),
('zh_CN', '2248', '宁洱哈尼族彝族自治县'),
('zh_CN', '2249', '墨江哈尼族自治县'),
('zh_CN', '2250', '景东彝族自治县'),
('zh_CN', '2251', '景谷傣族彝族自治县'),
('zh_CN', '2252', '镇沅彝族哈尼族拉祜族自治县'),
('zh_CN', '2253', '江城哈尼族彝族自治县'),
('zh_CN', '2254', '孟连傣族拉祜族佤族自治县'),
('zh_CN', '2255', '澜沧拉祜族自治县'),
('zh_CN', '2256', '西盟佤族自治县'),
('zh_CN', '2257', '临翔区'),
('zh_CN', '2258', '凤庆县'),
('zh_CN', '2259', '云县'),
('zh_CN', '2260', '永德县'),
('zh_CN', '2261', '镇康县'),
('zh_CN', '2262', '双江拉祜族佤族布朗族傣族自治县'),
('zh_CN', '2263', '耿马傣族佤族自治县'),
('zh_CN', '2264', '沧源佤族自治县'),
('zh_CN', '2265', '泸水县'),
('zh_CN', '2266', '福贡县'),
('zh_CN', '2267', '贡山独龙族怒族自治县'),
('zh_CN', '2268', '兰坪白族普米族自治县'),
('zh_CN', '2269', '香格里拉县'),
('zh_CN', '2270', '德钦县'),
('zh_CN', '2271', '维西傈僳族自治县'),
('zh_CN', '2272', '古城区'),
('zh_CN', '2273', '玉龙纳西族自治县'),
('zh_CN', '2274', '永胜县'),
('zh_CN', '2275', '华坪县'),
('zh_CN', '2276', '宁蒗彝族自治县'),
('zh_CN', '2277', '门源回族自治县'),
('zh_CN', '2278', '祁连县'),
('zh_CN', '2279', '海晏县'),
('zh_CN', '2280', '刚察县'),
('zh_CN', '2281', '城东区'),
('zh_CN', '2282', '城中区'),
('zh_CN', '2283', '城西区'),
('zh_CN', '2284', '城北区'),
('zh_CN', '2285', '大通回族土族自治县'),
('zh_CN', '2286', '湟中县'),
('zh_CN', '2287', '湟源县'),
('zh_CN', '2288', '平安县'),
('zh_CN', '2289', '民和回族土族自治县'),
('zh_CN', '2290', '乐都县'),
('zh_CN', '2291', '互助土族自治县'),
('zh_CN', '2292', '化隆回族自治县'),
('zh_CN', '2293', '循化撒拉族自治县'),
('zh_CN', '2294', '同仁县'),
('zh_CN', '2295', '尖扎县'),
('zh_CN', '2296', '泽库县'),
('zh_CN', '2297', '河南蒙古族自治县'),
('zh_CN', '2298', '共和县'),
('zh_CN', '2299', '同德县'),
('zh_CN', '2300', '贵德县'),
('zh_CN', '2301', '兴海县'),
('zh_CN', '2302', '贵南县'),
('zh_CN', '2303', '玛沁县'),
('zh_CN', '2304', '班玛县'),
('zh_CN', '2305', '甘德县'),
('zh_CN', '2306', '达日县'),
('zh_CN', '2307', '久治县'),
('zh_CN', '2308', '玛多县'),
('zh_CN', '2309', '玉树县'),
('zh_CN', '2310', '杂多县'),
('zh_CN', '2311', '称多县'),
('zh_CN', '2312', '治多县'),
('zh_CN', '2313', '囊谦县'),
('zh_CN', '2314', '曲麻莱县'),
('zh_CN', '2315', '格尔木市'),
('zh_CN', '2316', '德令哈市'),
('zh_CN', '2317', '乌兰县'),
('zh_CN', '2318', '都兰县'),
('zh_CN', '2319', '天峻县'),
('zh_CN', '2320', '新城区'),
('zh_CN', '2321', '碑林区'),
('zh_CN', '2322', '莲湖区'),
('zh_CN', '2323', '灞桥区'),
('zh_CN', '2324', '未央区'),
('zh_CN', '2325', '雁塔区'),
('zh_CN', '2326', '阎良区'),
('zh_CN', '2327', '临潼区'),
('zh_CN', '2328', '长安区'),
('zh_CN', '2329', '蓝田县'),
('zh_CN', '2330', '周至县'),
('zh_CN', '2331', '户县'),
('zh_CN', '2332', '高陵县'),
('zh_CN', '2333', '秦都区'),
('zh_CN', '2334', '杨陵区'),
('zh_CN', '2335', '渭城区'),
('zh_CN', '2336', '三原县'),
('zh_CN', '2337', '泾阳县'),
('zh_CN', '2338', '乾县'),
('zh_CN', '2339', '礼泉县'),
('zh_CN', '2340', '永寿县'),
('zh_CN', '2341', '彬县'),
('zh_CN', '2342', '长武县'),
('zh_CN', '2343', '旬邑县'),
('zh_CN', '2344', '淳化县'),
('zh_CN', '2345', '武功县'),
('zh_CN', '2346', '兴平市'),
('zh_CN', '2347', '宝塔区'),
('zh_CN', '2348', '延长县'),
('zh_CN', '2349', '延川县'),
('zh_CN', '2350', '子长县'),
('zh_CN', '2351', '安塞县'),
('zh_CN', '2352', '志丹县'),
('zh_CN', '2353', '吴起县'),
('zh_CN', '2354', '甘泉县'),
('zh_CN', '2355', '富县'),
('zh_CN', '2356', '洛川县'),
('zh_CN', '2357', '宜川县'),
('zh_CN', '2358', '黄龙县'),
('zh_CN', '2359', '黄陵县'),
('zh_CN', '2360', '榆阳区'),
('zh_CN', '2361', '神木县'),
('zh_CN', '2362', '府谷县'),
('zh_CN', '2363', '横山县'),
('zh_CN', '2364', '靖边县'),
('zh_CN', '2365', '定边县'),
('zh_CN', '2366', '绥德县'),
('zh_CN', '2367', '米脂县'),
('zh_CN', '2368', '佳县'),
('zh_CN', '2369', '吴堡县'),
('zh_CN', '2370', '清涧县'),
('zh_CN', '2371', '子洲县'),
('zh_CN', '2372', '临渭区'),
('zh_CN', '2373', '华县'),
('zh_CN', '2374', '潼关县'),
('zh_CN', '2375', '大荔县'),
('zh_CN', '2376', '合阳县'),
('zh_CN', '2377', '澄城县'),
('zh_CN', '2378', '蒲城县'),
('zh_CN', '2379', '白水县'),
('zh_CN', '2380', '富平县'),
('zh_CN', '2381', '韩城市'),
('zh_CN', '2382', '华阴市'),
('zh_CN', '2383', '商州区'),
('zh_CN', '2384', '洛南县'),
('zh_CN', '2385', '丹凤县'),
('zh_CN', '2386', '商南县'),
('zh_CN', '2387', '山阳县'),
('zh_CN', '2388', '镇安县'),
('zh_CN', '2389', '柞水县'),
('zh_CN', '2390', '汉滨区'),
('zh_CN', '2391', '汉阴县'),
('zh_CN', '2392', '石泉县'),
('zh_CN', '2393', '宁陕县'),
('zh_CN', '2394', '紫阳县'),
('zh_CN', '2395', '岚皋县'),
('zh_CN', '2396', '平利县'),
('zh_CN', '2397', '镇坪县'),
('zh_CN', '2398', '旬阳县'),
('zh_CN', '2399', '白河县'),
('zh_CN', '2400', '汉台区'),
('zh_CN', '2401', '南郑县'),
('zh_CN', '2402', '城固县'),
('zh_CN', '2403', '洋县'),
('zh_CN', '2404', '西乡县'),
('zh_CN', '2405', '勉县'),
('zh_CN', '2406', '宁强县'),
('zh_CN', '2407', '略阳县'),
('zh_CN', '2408', '镇巴县'),
('zh_CN', '2409', '留坝县'),
('zh_CN', '2410', '佛坪县'),
('zh_CN', '2411', '渭滨区'),
('zh_CN', '2412', '金台区'),
('zh_CN', '2413', '陈仓区'),
('zh_CN', '2414', '凤翔县'),
('zh_CN', '2415', '岐山县'),
('zh_CN', '2416', '扶风县'),
('zh_CN', '2417', '眉县'),
('zh_CN', '2418', '陇县'),
('zh_CN', '2419', '千阳县'),
('zh_CN', '2420', '麟游县'),
('zh_CN', '2421', '凤县'),
('zh_CN', '2422', '太白县'),
('zh_CN', '2423', '王益区'),
('zh_CN', '2424', '印台区'),
('zh_CN', '2425', '耀州区'),
('zh_CN', '2426', '宜君县'),
('zh_CN', '2427', '港口区'),
('zh_CN', '2428', '防城区'),
('zh_CN', '2429', '上思县'),
('zh_CN', '2430', '东兴市'),
('zh_CN', '2431', '兴宁区'),
('zh_CN', '2432', '青秀区'),
('zh_CN', '2433', '江南区'),
('zh_CN', '2434', '西乡塘区'),
('zh_CN', '2435', '良庆区'),
('zh_CN', '2436', '邕宁区'),
('zh_CN', '2437', '武鸣县'),
('zh_CN', '2438', '隆安县'),
('zh_CN', '2439', '马山县'),
('zh_CN', '2440', '上林县'),
('zh_CN', '2441', '宾阳县'),
('zh_CN', '2442', '横县'),
('zh_CN', '2443', '江洲区'),
('zh_CN', '2444', '扶绥县'),
('zh_CN', '2445', '宁明县'),
('zh_CN', '2446', '龙州县'),
('zh_CN', '2447', '大新县'),
('zh_CN', '2448', '天等县'),
('zh_CN', '2449', '凭祥市'),
('zh_CN', '2450', '兴宾区'),
('zh_CN', '2451', '忻城县'),
('zh_CN', '2452', '象州县'),
('zh_CN', '2453', '武宣县'),
('zh_CN', '2454', '金秀瑶族自治县'),
('zh_CN', '2455', '合山市'),
('zh_CN', '2456', '城中区'),
('zh_CN', '2457', '鱼峰区'),
('zh_CN', '2458', '柳南区'),
('zh_CN', '2459', '柳北区'),
('zh_CN', '2460', '柳江县'),
('zh_CN', '2461', '柳城县'),
('zh_CN', '2462', '鹿寨县'),
('zh_CN', '2463', '融安县'),
('zh_CN', '2464', '融水苗族自治县'),
('zh_CN', '2465', '三江侗族自治县'),
('zh_CN', '2466', '秀峰区'),
('zh_CN', '2467', '叠彩区'),
('zh_CN', '2468', '象山区'),
('zh_CN', '2469', '七星区'),
('zh_CN', '2470', '雁山区'),
('zh_CN', '2471', '阳朔县'),
('zh_CN', '2472', '临桂县'),
('zh_CN', '2473', '灵川县'),
('zh_CN', '2474', '全州县'),
('zh_CN', '2475', '兴安县'),
('zh_CN', '2476', '永福县'),
('zh_CN', '2477', '灌阳县'),
('zh_CN', '2478', '龙胜各族自治县'),
('zh_CN', '2479', '资源县'),
('zh_CN', '2480', '平乐县'),
('zh_CN', '2481', '荔浦县'),
('zh_CN', '2482', '恭城瑶族自治县'),
('zh_CN', '2483', '万秀区'),
('zh_CN', '2484', '碟山区'),
('zh_CN', '2485', '长洲区'),
('zh_CN', '2486', '苍梧县'),
('zh_CN', '2487', '藤县'),
('zh_CN', '2488', '蒙山县'),
('zh_CN', '2489', '岑溪市'),
('zh_CN', '2490', '八步区'),
('zh_CN', '2491', '昭平县'),
('zh_CN', '2492', '钟山县'),
('zh_CN', '2493', '富川瑶族自治县'),
('zh_CN', '2494', '港北区'),
('zh_CN', '2495', '港南区'),
('zh_CN', '2496', '覃塘区'),
('zh_CN', '2497', '平南县'),
('zh_CN', '2498', '桂平市'),
('zh_CN', '2499', '玉州区'),
('zh_CN', '2500', '容县'),
('zh_CN', '2501', '陆川县'),
('zh_CN', '2502', '博白县'),
('zh_CN', '2503', '兴业县'),
('zh_CN', '2504', '北流市'),
('zh_CN', '2505', '右江区'),
('zh_CN', '2506', '田阳县'),
('zh_CN', '2507', '田东县'),
('zh_CN', '2508', '平果县'),
('zh_CN', '2509', '德保县'),
('zh_CN', '2510', '靖西县'),
('zh_CN', '2511', '那坡县'),
('zh_CN', '2512', '凌云县'),
('zh_CN', '2513', '乐业县'),
('zh_CN', '2514', '田林县'),
('zh_CN', '2515', '西林县'),
('zh_CN', '2516', '隆林各族自治县'),
('zh_CN', '2517', '钦南区'),
('zh_CN', '2518', '钦北区'),
('zh_CN', '2519', '灵山县'),
('zh_CN', '2520', '浦北县'),
('zh_CN', '2521', '金城江区'),
('zh_CN', '2522', '南丹县'),
('zh_CN', '2523', '天峨县'),
('zh_CN', '2524', '凤山县'),
('zh_CN', '2525', '东兰县'),
('zh_CN', '2526', '罗城仫佬族自治县'),
('zh_CN', '2527', '环江毛南族自治县'),
('zh_CN', '2528', '巴马瑶族自治县'),
('zh_CN', '2529', '都安瑶族自治县'),
('zh_CN', '2530', '大化瑶族自治县'),
('zh_CN', '2531', '宜州市'),
('zh_CN', '2532', '海城区'),
('zh_CN', '2533', '银海区'),
('zh_CN', '2534', '铁山港区'),
('zh_CN', '2535', '合浦县'),
('zh_CN', '2536', '城关区'),
('zh_CN', '2537', '林周县'),
('zh_CN', '2538', '当雄县'),
('zh_CN', '2539', '尼木县'),
('zh_CN', '2540', '曲水县'),
('zh_CN', '2541', '堆龙德庆县'),
('zh_CN', '2542', '达孜县'),
('zh_CN', '2543', '墨竹工卡县'),
('zh_CN', '2544', '日喀则市'),
('zh_CN', '2545', '南木林县'),
('zh_CN', '2546', '江孜县'),
('zh_CN', '2547', '定日县'),
('zh_CN', '2548', '萨迦县'),
('zh_CN', '2549', '拉孜县'),
('zh_CN', '2550', '昂仁县'),
('zh_CN', '2551', '谢通门县'),
('zh_CN', '2552', '白朗县'),
('zh_CN', '2553', '仁布县'),
('zh_CN', '2554', '康马县'),
('zh_CN', '2555', '定结县'),
('zh_CN', '2556', '仲巴县'),
('zh_CN', '2557', '亚东县'),
('zh_CN', '2558', '吉隆县'),
('zh_CN', '2559', '聂拉木县'),
('zh_CN', '2560', '萨嘎县'),
('zh_CN', '2561', '岗巴县'),
('zh_CN', '2562', '乃东县'),
('zh_CN', '2563', '扎囊县'),
('zh_CN', '2564', '贡嘎县'),
('zh_CN', '2565', '桑日县'),
('zh_CN', '2566', '琼结县'),
('zh_CN', '2567', '曲松县'),
('zh_CN', '2568', '措美县'),
('zh_CN', '2569', '洛扎县'),
('zh_CN', '2570', '加查县'),
('zh_CN', '2571', '隆子县'),
('zh_CN', '2572', '错那县'),
('zh_CN', '2573', '浪卡子县'),
('zh_CN', '2574', '林芝县'),
('zh_CN', '2575', '工布江达县'),
('zh_CN', '2576', '米林县'),
('zh_CN', '2577', '墨脱县'),
('zh_CN', '2578', '波密县'),
('zh_CN', '2579', '察隅县'),
('zh_CN', '2580', '朗县'),
('zh_CN', '2581', '昌都县'),
('zh_CN', '2582', '江达县'),
('zh_CN', '2583', '贡觉县'),
('zh_CN', '2584', '类乌齐县'),
('zh_CN', '2585', '丁青县'),
('zh_CN', '2586', '察雅县'),
('zh_CN', '2587', '八宿县'),
('zh_CN', '2588', '左贡县'),
('zh_CN', '2589', '芒康县'),
('zh_CN', '2590', '洛隆县'),
('zh_CN', '2591', '边坝县'),
('zh_CN', '2592', '那曲县'),
('zh_CN', '2593', '嘉黎县'),
('zh_CN', '2594', '比如县'),
('zh_CN', '2595', '聂荣县'),
('zh_CN', '2596', '安多县'),
('zh_CN', '2597', '申扎县'),
('zh_CN', '2598', '索县'),
('zh_CN', '2599', '班戈县'),
('zh_CN', '2600', '巴青县'),
('zh_CN', '2601', '尼玛县'),
('zh_CN', '2602', '普兰县'),
('zh_CN', '2603', '札达县'),
('zh_CN', '2604', '噶尔县'),
('zh_CN', '2605', '日土县'),
('zh_CN', '2606', '革吉县'),
('zh_CN', '2607', '改则县'),
('zh_CN', '2608', '措勤县'),
('zh_CN', '2609', '兴庆区'),
('zh_CN', '2610', '西夏区'),
('zh_CN', '2611', '金凤区'),
('zh_CN', '2612', '永宁县'),
('zh_CN', '2613', '贺兰县'),
('zh_CN', '2614', '灵武市'),
('zh_CN', '2615', '大武口区'),
('zh_CN', '2616', '惠农区'),
('zh_CN', '2617', '平罗县'),
('zh_CN', '2618', '利通区'),
('zh_CN', '2619', '盐池县'),
('zh_CN', '2620', '同心县'),
('zh_CN', '2621', '青铜峡市'),
('zh_CN', '2622', '原州区'),
('zh_CN', '2623', '西吉县'),
('zh_CN', '2624', '隆德县'),
('zh_CN', '2625', '泾源县'),
('zh_CN', '2626', '彭阳县'),
('zh_CN', '2627', '沙坡头区'),
('zh_CN', '2628', '中宁县'),
('zh_CN', '2629', '海原县'),
('zh_CN', '2630', '塔城市'),
('zh_CN', '2631', '乌苏市'),
('zh_CN', '2632', '额敏县'),
('zh_CN', '2633', '沙湾县'),
('zh_CN', '2634', '托里县'),
('zh_CN', '2635', '裕民县'),
('zh_CN', '2636', '和布克赛尔蒙古自治县'),
('zh_CN', '2637', '哈密市'),
('zh_CN', '2638', '巴里坤哈萨克自治县'),
('zh_CN', '2639', '伊吾县'),
('zh_CN', '2640', '和田市'),
('zh_CN', '2641', '和田县'),
('zh_CN', '2642', '墨玉县'),
('zh_CN', '2643', '皮山县'),
('zh_CN', '2644', '洛浦县'),
('zh_CN', '2645', '策勒县'),
('zh_CN', '2646', '于田县'),
('zh_CN', '2647', '民丰县'),
('zh_CN', '2648', '阿勒泰市'),
('zh_CN', '2649', '布尔津县'),
('zh_CN', '2650', '富蕴县'),
('zh_CN', '2651', '福海县'),
('zh_CN', '2652', '哈巴河县'),
('zh_CN', '2653', '青河县'),
('zh_CN', '2654', '吉木乃县'),
('zh_CN', '2655', '阿图什市'),
('zh_CN', '2656', '阿克陶县'),
('zh_CN', '2657', '阿合奇县'),
('zh_CN', '2658', '乌恰县'),
('zh_CN', '2659', '博乐市'),
('zh_CN', '2660', '精河县'),
('zh_CN', '2661', '温泉县'),
('zh_CN', '2662', '独山子区'),
('zh_CN', '2663', '克拉玛依区'),
('zh_CN', '2664', '白碱滩区'),
('zh_CN', '2665', '乌尔禾区'),
('zh_CN', '2666', '天山区'),
('zh_CN', '2667', '沙依巴克区'),
('zh_CN', '2668', '新市区'),
('zh_CN', '2669', '水磨沟区'),
('zh_CN', '2670', '头屯河区'),
('zh_CN', '2671', '达坂城区'),
('zh_CN', '2672', '米东区'),
('zh_CN', '2673', '乌鲁木齐县'),
('zh_CN', '2674', '昌吉市'),
('zh_CN', '2675', '阜康市'),
('zh_CN', '2676', '呼图壁县'),
('zh_CN', '2677', '玛纳斯县'),
('zh_CN', '2678', '奇台县'),
('zh_CN', '2679', '吉木萨尔县'),
('zh_CN', '2680', '木垒哈萨克自治县'),
('zh_CN', '2681', '吐鲁番市'),
('zh_CN', '2682', '鄯善县'),
('zh_CN', '2683', '托克逊县'),
('zh_CN', '2684', '库尔勒市'),
('zh_CN', '2685', '轮台县'),
('zh_CN', '2686', '尉犁县'),
('zh_CN', '2687', '若羌县'),
('zh_CN', '2688', '且末县'),
('zh_CN', '2689', '焉耆回族自治县'),
('zh_CN', '2690', '和静县'),
('zh_CN', '2691', '和硕县'),
('zh_CN', '2692', '博湖县'),
('zh_CN', '2693', '阿克苏市'),
('zh_CN', '2694', '温宿县'),
('zh_CN', '2695', '库车县'),
('zh_CN', '2696', '沙雅县'),
('zh_CN', '2697', '新和县'),
('zh_CN', '2698', '拜城县'),
('zh_CN', '2699', '乌什县'),
('zh_CN', '2700', '阿瓦提县'),
('zh_CN', '2701', '柯坪县'),
('zh_CN', '2702', '喀什市'),
('zh_CN', '2703', '疏附县'),
('zh_CN', '2704', '疏勒县'),
('zh_CN', '2705', '英吉沙县'),
('zh_CN', '2706', '泽普县'),
('zh_CN', '2707', '莎车县'),
('zh_CN', '2708', '叶城县'),
('zh_CN', '2709', '麦盖提县'),
('zh_CN', '2710', '岳普湖县'),
('zh_CN', '2711', '伽师县'),
('zh_CN', '2712', '巴楚县'),
('zh_CN', '2713', '塔什库尔干塔吉克自治县'),
('zh_CN', '2714', '伊宁市'),
('zh_CN', '2715', '奎屯市'),
('zh_CN', '2716', '伊宁县'),
('zh_CN', '2717', '察布查尔锡伯自治县'),
('zh_CN', '2718', '霍城县'),
('zh_CN', '2719', '巩留县'),
('zh_CN', '2720', '新源县'),
('zh_CN', '2721', '昭苏县'),
('zh_CN', '2722', '特克斯县'),
('zh_CN', '2723', '尼勒克县'),
('zh_CN', '2724', '海拉尔区'),
('zh_CN', '2725', '阿荣旗'),
('zh_CN', '2726', '莫力达瓦达斡尔族自治旗'),
('zh_CN', '2727', '鄂伦春自治旗'),
('zh_CN', '2728', '鄂温克族自治旗'),
('zh_CN', '2729', '陈巴尔虎旗'),
('zh_CN', '2730', '新巴尔虎左旗'),
('zh_CN', '2731', '新巴尔虎右旗'),
('zh_CN', '2732', '满洲里市'),
('zh_CN', '2733', '牙克石市'),
('zh_CN', '2734', '扎兰屯市'),
('zh_CN', '2735', '额尔古纳市'),
('zh_CN', '2736', '根河市'),
('zh_CN', '2737', '新城区'),
('zh_CN', '2738', '回民区'),
('zh_CN', '2739', '玉泉区'),
('zh_CN', '2740', '赛罕区'),
('zh_CN', '2741', '土默特左旗'),
('zh_CN', '2742', '托克托县'),
('zh_CN', '2743', '和林格尔县'),
('zh_CN', '2744', '清水河县'),
('zh_CN', '2745', '武川县'),
('zh_CN', '2746', '东河区'),
('zh_CN', '2747', '昆都仑区'),
('zh_CN', '2748', '青山区'),
('zh_CN', '2749', '石拐区'),
('zh_CN', '2750', '白云鄂博矿区'),
('zh_CN', '2751', '九原区'),
('zh_CN', '2752', '土默特右旗'),
('zh_CN', '2753', '固阳县'),
('zh_CN', '2754', '达尔罕茂明安联合旗'),
('zh_CN', '2755', '海勃湾区'),
('zh_CN', '2756', '海南区'),
('zh_CN', '2757', '乌达区'),
('zh_CN', '2758', '集宁区'),
('zh_CN', '2759', '卓资县'),
('zh_CN', '2760', '化德县'),
('zh_CN', '2761', '商都县'),
('zh_CN', '2762', '兴和县'),
('zh_CN', '2763', '凉城县'),
('zh_CN', '2764', '察哈尔右翼前旗'),
('zh_CN', '2765', '察哈尔右翼中旗'),
('zh_CN', '2766', '察哈尔右翼后旗'),
('zh_CN', '2767', '四子王旗'),
('zh_CN', '2768', '丰镇市'),
('zh_CN', '2769', '科尔沁区'),
('zh_CN', '2770', '科尔沁左翼中旗'),
('zh_CN', '2771', '科尔沁左翼后旗'),
('zh_CN', '2772', '开鲁县'),
('zh_CN', '2773', '库伦旗'),
('zh_CN', '2774', '奈曼旗'),
('zh_CN', '2775', '扎鲁特旗'),
('zh_CN', '2776', '霍林郭勒市'),
('zh_CN', '2777', '红山区'),
('zh_CN', '2778', '元宝山区'),
('zh_CN', '2779', '松山区'),
('zh_CN', '2780', '阿鲁科尔沁旗'),
('zh_CN', '2781', '巴林左旗'),
('zh_CN', '2782', '巴林右旗'),
('zh_CN', '2783', '林西县'),
('zh_CN', '2784', '克什克腾旗'),
('zh_CN', '2785', '翁牛特旗'),
('zh_CN', '2786', '喀喇沁旗'),
('zh_CN', '2787', '宁城县'),
('zh_CN', '2788', '敖汉旗'),
('zh_CN', '2789', '东胜区'),
('zh_CN', '2790', '达拉特旗'),
('zh_CN', '2791', '准格尔旗'),
('zh_CN', '2792', '鄂托克前旗'),
('zh_CN', '2793', '鄂托克旗'),
('zh_CN', '2794', '杭锦旗'),
('zh_CN', '2795', '乌审旗'),
('zh_CN', '2796', '伊金霍洛旗'),
('zh_CN', '2797', '临河区'),
('zh_CN', '2798', '五原县'),
('zh_CN', '2799', '磴口县'),
('zh_CN', '2800', '乌拉特前旗'),
('zh_CN', '2801', '乌拉特中旗'),
('zh_CN', '2802', '乌拉特后旗'),
('zh_CN', '2803', '杭锦后旗'),
('zh_CN', '2804', '二连浩特市'),
('zh_CN', '2805', '锡林浩特市'),
('zh_CN', '2806', '阿巴嘎旗'),
('zh_CN', '2807', '苏尼特左旗'),
('zh_CN', '2808', '苏尼特右旗'),
('zh_CN', '2809', '东乌珠穆沁旗'),
('zh_CN', '2810', '西乌珠穆沁旗'),
('zh_CN', '2811', '太仆寺旗'),
('zh_CN', '2812', '镶黄旗'),
('zh_CN', '2813', '正镶白旗'),
('zh_CN', '2814', '正蓝旗'),
('zh_CN', '2815', '多伦县'),
('zh_CN', '2816', '乌兰浩特市'),
('zh_CN', '2817', '阿尔山市'),
('zh_CN', '2818', '科尔沁右翼前旗'),
('zh_CN', '2819', '科尔沁右翼中旗'),
('zh_CN', '2820', '扎赉特旗'),
('zh_CN', '2821', '突泉县'),
('zh_CN', '2822', '阿拉善左旗'),
('zh_CN', '2823', '阿拉善右旗'),
('zh_CN', '2824', '额济纳旗'),
('zh_CN', '2825', '南城区'),
('zh_CN', '2826', '东城区'),
('zh_CN', '2827', '万江区'),
('zh_CN', '2828', '莞城区'),
('zh_CN', '2829', '石龙镇'),
('zh_CN', '2830', '虎门镇'),
('zh_CN', '2831', '麻涌镇'),
('zh_CN', '2832', '道滘镇'),
('zh_CN', '2833', '石碣镇'),
('zh_CN', '2834', '沙田镇'),
('zh_CN', '2835', '望牛墩'),
('zh_CN', '2836', '洪梅镇'),
('zh_CN', '2837', '茶山镇'),
('zh_CN', '2838', '寮步镇'),
('zh_CN', '2839', '大岭山镇'),
('zh_CN', '2840', '大朗镇'),
('zh_CN', '2841', '黄江镇'),
('zh_CN', '2842', '樟木头'),
('zh_CN', '2843', '凤岗镇'),
('zh_CN', '2844', '塘厦镇'),
('zh_CN', '2845', '谢岗镇'),
('zh_CN', '2846', '厚街镇'),
('zh_CN', '2847', '清溪镇'),
('zh_CN', '2848', '常平镇'),
('zh_CN', '2849', '桥头镇'),
('zh_CN', '2850', '横沥镇'),
('zh_CN', '2851', '东坑镇'),
('zh_CN', '2852', '企石镇'),
('zh_CN', '2853', '石排镇'),
('zh_CN', '2854', '长安镇'),
('zh_CN', '2855', '中堂镇'),
('zh_CN', '2856', '高埗镇'),
('zh_CN', '2857', '城区'),
('zh_CN', '2858', '潜江市'),
('zh_CN', '2859', '沙田区'),
('zh_CN', '2860', '东区'),
('zh_CN', '2861', '观塘区'),
('zh_CN', '2862', '黄大仙区'),
('zh_CN', '2863', '九龙城区'),
('zh_CN', '2864', '屯门区'),
('zh_CN', '2865', '葵青区'),
('zh_CN', '2866', '元朗区'),
('zh_CN', '2867', '深水埗区'),
('zh_CN', '2868', '西贡区'),
('zh_CN', '2869', '大埔区'),
('zh_CN', '2870', '湾仔区'),
('zh_CN', '2871', '油尖旺区'),
('zh_CN', '2872', '北区'),
('zh_CN', '2873', '南区'),
('zh_CN', '2874', '荃湾区'),
('zh_CN', '2875', '中西区'),
('zh_CN', '2876', '离岛区'),
('zh_CN', '2877', '郑东新区'),
('zh_CN', '2878', '加格达奇区'),
('zh_CN', '2879', '市区'),
('zh_CN', '2880', '仙桃市'),
('zh_CN', '2881', '高新区'),
('zh_CN', '2882', '新区'),
('zh_CN', '2883', '玉山镇'),
('zh_CN', '2884', '开发区'),
('zh_CN', '2885', '园区'),
('zh_CN', '2886', '经济开发区'),
('zh_CN', '2887', '郊区'),
('zh_CN', '2888', '阿拉尔市'),
('zh_CN', '2889', '澳门特别行政区'),
('zh_CN', '2890', '衢州市'),
('zh_CN', '2891', '石岐街道'),
('zh_CN', '2892', '东区街道'),
('zh_CN', '2893', '西区街道'),
('zh_CN', '2894', '环城街道'),
('zh_CN', '2895', '中山港街道'),
('zh_CN', '2896', '五桂山街道'),
('zh_CN', '2897', '大亚湾');


-- DROP TABLE IF EXISTS `{$installer->getTable('directory_currency_rate')}`;
CREATE TABLE `{$installer->getTable('directory_currency_rate')}` (
  `currency_from` char(3) NOT NULL default '',
  `currency_to` char(3) NOT NULL default '',
  `rate` decimal(24,12) NOT NULL default '0.000000000000',
  PRIMARY KEY  (`currency_from`,`currency_to`),
  KEY `FK_CURRENCY_RATE_TO` (`currency_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `{$installer->getTable('directory_currency_rate')}` VALUES
('EUR', 'EUR', 1.000000000000),('EUR', 'USD', 1.415000000000),
('USD', 'EUR', 0.706700000000),('USD', 'USD', 1.000000000000);

INSERT INTO `{$installer->getTable('directory_country_region')}` (`country_id`, `code`, `default_name`)
VALUES
('FR', '01', 'Ain'),('FR', '02', 'Aisne'),('FR', '03', 'Allier'),
('FR', '04', 'Alpes-de-Haute-Provence'),('FR', '05', 'Hautes-Alpes'),('FR', '06', 'Alpes-Maritimes'),
('FR', '07', 'Ardèche'),('FR', '08', 'Ardennes'),('FR', '09', 'Ariège'),
('FR', '10', 'Aube'),('FR', '11', 'Aude'),('FR', '12', 'Aveyron'),
('FR', '13', 'Bouches-du-Rhône'),('FR', '14', 'Calvados'),('FR', '15', 'Cantal'),
('FR', '16', 'Charente'),('FR', '17', 'Charente-Maritime'),('FR', '18', 'Cher'),
('FR', '19', 'Corrèze'),('FR', '2A', 'Corse-du-Sud'),('FR', '2B', 'Haute-Corse'),
('FR', '21', 'Côte-d\\'Or'),('FR', '22', 'Côtes-d\\'Armor'),('FR', '23', 'Creuse'),
('FR', '24', 'Dordogne'),('FR', '25', 'Doubs'),('FR', '26', 'Drôme'),
('FR', '27', 'Eure'),('FR', '28', 'Eure-et-Loir'),('FR', '29', 'Finistère'),
('FR', '30', 'Gard'),('FR', '31', 'Haute-Garonne'),('FR', '32', 'Gers'),
('FR', '33', 'Gironde'),('FR', '34', 'Hérault'),('FR', '35', 'Ille-et-Vilaine'),
('FR', '36', 'Indre'),('FR', '37', 'Indre-et-Loire'),('FR', '38', 'Isère'),
('FR', '39', 'Jura'),('FR', '40', 'Landes'),('FR', '41', 'Loir-et-Cher'),
('FR', '42', 'Loire'),('FR', '43', 'Haute-Loire'),('FR', '44', 'Loire-Atlantique'),
('FR', '45', 'Loiret'),('FR', '46', 'Lot'),('FR', '47', 'Lot-et-Garonne'),
('FR', '48', 'Lozère'),('FR', '49', 'Maine-et-Loire'),('FR', '50', 'Manche'),
('FR', '51', 'Marne'),('FR', '52', 'Haute-Marne'),('FR', '53', 'Mayenne'),
('FR', '54', 'Meurthe-et-Moselle'),('FR', '55', 'Meuse'),('FR', '56', 'Morbihan'),
('FR', '57', 'Moselle'),('FR', '58', 'Nièvre'),('FR', '59', 'Nord'),
('FR', '60', 'Oise'),('FR', '61', 'Orne'),('FR', '62', 'Pas-de-Calais'),
('FR', '63', 'Puy-de-Dôme'),('FR', '64', 'Pyrénées-Atlantiques'),('FR', '65', 'Hautes-Pyrénées'),
('FR', '66', 'Pyrénées-Orientales'),('FR', '67', 'Bas-Rhin'),('FR', '68', 'Haut-Rhin'),
('FR', '69', 'Rhône'),('FR', '70', 'Haute-Saône'),('FR', '71', 'Saône-et-Loire'),
('FR', '72', 'Sarthe'),('FR', '73', 'Savoie'),('FR', '74', 'Haute-Savoie'),
('FR', '75', 'Paris'),('FR', '76', 'Seine-Maritime'),('FR', '77', 'Seine-et-Marne'),
('FR', '78', 'Yvelines'),('FR', '79', 'Deux-Sèvres'),('FR', '80', 'Somme'),
('FR', '81', 'Tarn'),('FR', '82', 'Tarn-et-Garonne'),('FR', '83', 'Var'),
('FR', '84', 'Vaucluse'),('FR', '85', 'Vendée'),('FR', '86', 'Vienne'),
('FR', '87', 'Haute-Vienne'),('FR', '88', 'Vosges'),('FR', '89', 'Yonne'),
('FR', '90', 'Territoire-de-Belfort'),('FR', '91', 'Essonne'),('FR', '92', 'Hauts-de-Seine'),
('FR', '93', 'Seine-Saint-Denis'),('FR', '94', 'Val-de-Marne'),('FR', '95', 'Val-d\\'Oise');
");
$installer->run("
REPLACE INTO `{$installer->getTable('directory_country_region_name')}` (`locale`, `region_id`, `name`)
SELECT 'en_US', `region_id`, `default_name` FROM `{$installer->getTable('directory_country_region')}` WHERE `country_id` = 'FR';
");

$installer->run("
INSERT INTO `{$installer->getTable('directory_country')}` (`country_id`, `iso2_code`, `iso3_code`) VALUES
('AX', 'AX', 'ALA'),('CD', 'CD', 'COD'),('CS', 'CS', 'SCG'),('PS', 'PS', 'PSE');
");

$installer->run("
INSERT INTO `{$installer->getTable('directory_country')}` (`country_id`, `iso2_code`, `iso3_code`) VALUES
('GG', 'GG', 'GGY'),('IM', 'IM', 'IMN'),('JE', 'JE', 'JEY'),('ME', 'ME', 'MNE'),
('BL', 'BL', 'BLM'),('MF', 'MF', 'MAF'),('RS', 'RS', 'SRB'),('TL', 'TL', 'TLS');
");

$installer->run("
    UPDATE {$installer->getTable('directory/country_region')}
    SET code = 'GR'
    WHERE region_id = 113
");

$installer->run("
    UPDATE {$installer->getTable('directory/country')}
    SET iso3_code = 'ROU'
    WHERE country_id = 'RO'
");

$installer->run("
    DELETE FROM {$installer->getTable('directory/country')}
    WHERE country_id IN('FX','CS')
");

$installer->run("
    UPDATE {$installer->getTable('directory/country_region')}
    SET code = 'NL', default_name = 'Newfoundland and Labrador'
    WHERE region_id = 69
");

$installer->run("
    UPDATE {$installer->getTable('directory/country_region_name')}
    SET `name` = 'Newfoundland and Labrador'
    WHERE `region_id` = 69 AND `name` = 'Newfoundland'
");

/** @var Varien_Db_Adapter_Pdo_Mysql */
$connection  = $this->getConnection();
$regionTable = $installer->getTable('directory/country_region');

$regionsToIns = array(
    array('RO', 'AB', 'Alba'), array('RO', 'AR', 'Arad'), array('RO', 'AG', 'Argeş'),
    array('RO', 'BC', 'Bacău'), array('RO', 'BH', 'Bihor'), array('RO', 'BN', 'Bistriţa-Năsăud'),
    array('RO', 'BT', 'Botoşani'), array('RO', 'BV', 'Braşov'), array('RO', 'BR', 'Brăila'),
    array('RO', 'B', 'Bucureşti'), array('RO', 'BZ', 'Buzău'), array('RO', 'CS', 'Caraş-Severin'),
    array('RO', 'CL', 'Călăraşi'), array('RO', 'CJ', 'Cluj'), array('RO', 'CT', 'Constanţa'),
    array('RO', 'CV', 'Covasna'), array('RO', 'DB', 'Dâmboviţa'), array('RO', 'DJ', 'Dolj'),
    array('RO', 'GL', 'Galaţi'), array('RO', 'GR', 'Giurgiu'), array('RO', 'GJ', 'Gorj'),
    array('RO', 'HR', 'Harghita'), array('RO', 'HD', 'Hunedoara'), array('RO', 'IL', 'Ialomiţa'),
    array('RO', 'IS', 'Iaşi'), array('RO', 'IF', 'Ilfov'), array('RO', 'MM', 'Maramureş'),
    array('RO', 'MH', 'Mehedinţi'), array('RO', 'MS', 'Mureş'), array('RO', 'NT', 'Neamţ'),
    array('RO', 'OT', 'Olt'), array('RO', 'PH', 'Prahova'), array('RO', 'SM', 'Satu-Mare'),
    array('RO', 'SJ', 'Sălaj'), array('RO', 'SB', 'Sibiu'), array('RO', 'SV', 'Suceava'),
    array('RO', 'TR', 'Teleorman'), array('RO', 'TM', 'Timiş'), array('RO', 'TL', 'Tulcea'),
    array('RO', 'VS', 'Vaslui'), array('RO', 'VL', 'Vâlcea'), array('RO', 'VN', 'Vrancea')
);

foreach ($regionsToIns as $row) {
    if (! ($connection->fetchOne("SELECT 1 FROM `{$regionTable}` WHERE `country_id` = :country_id && `code` = :code", array('country_id' => $row[0], 'code' => $row[1])))) {
        $connection->insert($regionTable, array(
            'country_id'   => $row[0],
            'code'         => $row[1],
            'default_name' => $row[2]
        ));
    }
}

/** @var Varien_Db_Adapter_Pdo_Mysql */
$connection   = $this->getConnection();
$regionTable  = $installer->getTable('directory/country_region');
$regNameTable = $installer->getTable('directory/country_region_name');

$regionsToIns = array(
    array('RO', 'AB', 'Alba'), array('RO', 'AR', 'Arad'), array('RO', 'AG', 'Argeş'),
    array('RO', 'BC', 'Bacău'), array('RO', 'BH', 'Bihor'), array('RO', 'BN', 'Bistriţa-Năsăud'),
    array('RO', 'BT', 'Botoşani'), array('RO', 'BV', 'Braşov'), array('RO', 'BR', 'Brăila'),
    array('RO', 'B', 'Bucureşti'), array('RO', 'BZ', 'Buzău'), array('RO', 'CS', 'Caraş-Severin'),
    array('RO', 'CL', 'Călăraşi'), array('RO', 'CJ', 'Cluj'), array('RO', 'CT', 'Constanţa'),
    array('RO', 'CV', 'Covasna'), array('RO', 'DB', 'Dâmboviţa'), array('RO', 'DJ', 'Dolj'),
    array('RO', 'GL', 'Galaţi'), array('RO', 'GR', 'Giurgiu'), array('RO', 'GJ', 'Gorj'),
    array('RO', 'HR', 'Harghita'), array('RO', 'HD', 'Hunedoara'), array('RO', 'IL', 'Ialomiţa'),
    array('RO', 'IS', 'Iaşi'), array('RO', 'IF', 'Ilfov'), array('RO', 'MM', 'Maramureş'),
    array('RO', 'MH', 'Mehedinţi'), array('RO', 'MS', 'Mureş'), array('RO', 'NT', 'Neamţ'),
    array('RO', 'OT', 'Olt'), array('RO', 'PH', 'Prahova'), array('RO', 'SM', 'Satu-Mare'),
    array('RO', 'SJ', 'Sălaj'), array('RO', 'SB', 'Sibiu'), array('RO', 'SV', 'Suceava'),
    array('RO', 'TR', 'Teleorman'), array('RO', 'TM', 'Timiş'), array('RO', 'TL', 'Tulcea'),
    array('RO', 'VS', 'Vaslui'), array('RO', 'VL', 'Vâlcea'), array('RO', 'VN', 'Vrancea')
);

foreach ($regionsToIns as $row) {
    $regionId = $connection->fetchOne("SELECT `region_id` FROM `{$regionTable}` WHERE `country_id` = :country_id && `code` = :code", array('country_id' => $row[0], 'code' => $row[1]));

    if (! $connection->fetchOne("SELECT 1 FROM `{$regNameTable}` WHERE `region_id` = {$regionId}")) {
        $connection->insert($regNameTable, array(
            'locale'    => 'en_US',
            'region_id' => $regionId,
            'name'      => $row[2]
        ));
    }
}

/* @var $connection Varien_Db_Adapter_Pdo_Mysql */
$connection  = $installer->getConnection();

$regionTable = $installer->getTable('directory/country_region');

$regionsToIns = array(
    //After reform of 2010 January
    array('FI', 'Lappi', 'Lappi'),
    array('FI', 'Pohjois-Pohjanmaa', 'Pohjois-Pohjanmaa'),
    array('FI', 'Kainuu', 'Kainuu'),
    array('FI', 'Pohjois-Karjala', 'Pohjois-Karjala'),
    array('FI', 'Pohjois-Savo', 'Pohjois-Savo'),
    array('FI', 'Etelä-Savo', 'Etelä-Savo'),
    array('FI', 'Etelä-Pohjanmaa', 'Etelä-Pohjanmaa'),
    array('FI', 'Pohjanmaa', 'Pohjanmaa'),
    array('FI', 'Pirkanmaa', 'Pirkanmaa'),
    array('FI', 'Satakunta', 'Satakunta'),
    array('FI', 'Keski-Pohjanmaa', 'Keski-Pohjanmaa'),
    array('FI', 'Keski-Suomi', 'Keski-Suomi'),
    array('FI', 'Varsinais-Suomi', 'Varsinais-Suomi'),
    array('FI', 'Etelä-Karjala', 'Etelä-Karjala'),
    array('FI', 'Päijät-Häme', 'Päijät-Häme'),
    array('FI', 'Kanta-Häme', 'Kanta-Häme'),
    array('FI', 'Uusimaa', 'Uusimaa'),
    array('FI', 'Itä-Uusimaa', 'Itä-Uusimaa'),
    array('FI', 'Kymenlaakso', 'Kymenlaakso'),
    array('FI', 'Ahvenanmaa', 'Ahvenanmaa'),

    //ISO-3166-2:EE
    array('EE', 'EE-37', 'Harjumaa'),
    array('EE', 'EE-39', 'Hiiumaa'),
    array('EE', 'EE-44', 'Ida-Virumaa'),
    array('EE', 'EE-49', 'Jõgevamaa'),
    array('EE', 'EE-51', 'Järvamaa'),
    array('EE', 'EE-57', 'Läänemaa'),
    array('EE', 'EE-59', 'Lääne-Virumaa'),
    array('EE', 'EE-65', 'Põlvamaa'),
    array('EE', 'EE-67', 'Pärnumaa'),
    array('EE', 'EE-70', 'Raplamaa'),
    array('EE', 'EE-74', 'Saaremaa'),
    array('EE', 'EE-78', 'Tartumaa'),
    array('EE', 'EE-82', 'Valgamaa'),
    array('EE', 'EE-84', 'Viljandimaa'),
    array('EE', 'EE-86', 'Võrumaa'),

    //After reform of 2009 July
    array('LV', 'LV-DGV', 'Daugavpils'),//now become good
    array('LV', 'LV-JEL', 'Jelgava'),
    array('LV', 'Jēkabpils', 'Jēkabpils'),
    array('LV', 'LV-JUR', 'Jūrmala'),
    array('LV', 'LV-LPX', 'Liepāja'),
    array('LV', 'LV-LE', 'Liepājas novads'),
    array('LV', 'LV-REZ', 'Rēzekne'),
    array('LV', 'LV-RIX', 'Rīga'),
    array('LV', 'LV-RI', 'Rīgas novads'),
    array('LV', 'Valmiera', 'Valmiera'),
    array('LV', 'LV-VEN', 'Ventspils'),
    array('LV', 'Aglonas novads', 'Aglonas novads'),
    array('LV', 'LV-AI', 'Aizkraukles novads'),
    array('LV', 'Aizputes novads', 'Aizputes novads'),
    array('LV', 'Aknīstes novads', 'Aknīstes novads'),
    array('LV', 'Alojas novads', 'Alojas novads'),
    array('LV', 'Alsungas novads', 'Alsungas novads'),
    array('LV', 'LV-AL', 'Alūksnes novads'),
    array('LV', 'Amatas novads', 'Amatas novads'),
    array('LV', 'Apes novads', 'Apes novads'),
    array('LV', 'Auces novads', 'Auces novads'),
    array('LV', 'Babītes novads', 'Babītes novads'),
    array('LV', 'Baldones novads', 'Baldones novads'),
    array('LV', 'Baltinavas novads', 'Baltinavas novads'),
    array('LV', 'LV-BL', 'Balvu novads'),
    array('LV', 'LV-BU', 'Bauskas novads'),
    array('LV', 'Beverīnas novads', 'Beverīnas novads'),
    array('LV', 'Brocēnu novads', 'Brocēnu novads'),
    array('LV', 'Burtnieku novads', 'Burtnieku novads'),
    array('LV', 'Carnikavas novads', 'Carnikavas novads'),
    array('LV', 'Cesvaines novads', 'Cesvaines novads'),
    array('LV', 'Ciblas novads', 'Ciblas novads'),
    array('LV', 'LV-CE', 'Cēsu novads'),
    array('LV', 'Dagdas novads', 'Dagdas novads'),
    array('LV', 'LV-DA', 'Daugavpils novads'),
    array('LV', 'LV-DO', 'Dobeles novads'),
    array('LV', 'Dundagas novads', 'Dundagas novads'),
    array('LV', 'Durbes novads', 'Durbes novads'),
    array('LV', 'Engures novads', 'Engures novads'),
    array('LV', 'Garkalnes novads', 'Garkalnes novads'),
    array('LV', 'Grobiņas novads', 'Grobiņas novads'),
    array('LV', 'LV-GU', 'Gulbenes novads'),
    array('LV', 'Iecavas novads', 'Iecavas novads'),
    array('LV', 'Ikšķiles novads', 'Ikšķiles novads'),
    array('LV', 'Ilūkstes novads', 'Ilūkstes novads'),
    array('LV', 'Inčukalna novads', 'Inčukalna novads'),
    array('LV', 'Jaunjelgavas novads', 'Jaunjelgavas novads'),
    array('LV', 'Jaunpiebalgas novads', 'Jaunpiebalgas novads'),
    array('LV', 'Jaunpils novads', 'Jaunpils novads'),
    array('LV', 'LV-JL', 'Jelgavas novads'),
    array('LV', 'LV-JK', 'Jēkabpils novads'),
    array('LV', 'Kandavas novads', 'Kandavas novads'),
    array('LV', 'Kokneses novads', 'Kokneses novads'),
    array('LV', 'Krimuldas novads', 'Krimuldas novads'),
    array('LV', 'Krustpils novads', 'Krustpils novads'),
    array('LV', 'LV-KR', 'Krāslavas novads'),
    array('LV', 'LV-KU', 'Kuldīgas novads'),
    array('LV', 'Kārsavas novads', 'Kārsavas novads'),
    array('LV', 'Lielvārdes novads', 'Lielvārdes novads'),
    array('LV', 'LV-LM', 'Limbažu novads'),
    array('LV', 'Lubānas novads', 'Lubānas novads'),
    array('LV', 'LV-LU', 'Ludzas novads'),
    array('LV', 'Līgatnes novads', 'Līgatnes novads'),
    array('LV', 'Līvānu novads', 'Līvānu novads'),
    array('LV', 'LV-MA', 'Madonas novads'),
    array('LV', 'Mazsalacas novads', 'Mazsalacas novads'),
    array('LV', 'Mālpils novads', 'Mālpils novads'),
    array('LV', 'Mārupes novads', 'Mārupes novads'),
    array('LV', 'Naukšēnu novads', 'Naukšēnu novads'),
    array('LV', 'Neretas novads', 'Neretas novads'),
    array('LV', 'Nīcas novads', 'Nīcas novads'),
    array('LV', 'LV-OG', 'Ogres novads'),
    array('LV', 'Olaines novads', 'Olaines novads'),
    array('LV', 'Ozolnieku novads', 'Ozolnieku novads'),
    array('LV', 'LV-PR', 'Preiļu novads'),
    array('LV', 'Priekules novads', 'Priekules novads'),
    array('LV', 'Priekuļu novads', 'Priekuļu novads'),
    array('LV', 'Pārgaujas novads', 'Pārgaujas novads'),
    array('LV', 'Pāvilostas novads', 'Pāvilostas novads'),
    array('LV', 'Pļaviņu novads', 'Pļaviņu novads'),
    array('LV', 'Raunas novads', 'Raunas novads'),
    array('LV', 'Riebiņu novads', 'Riebiņu novads'),
    array('LV', 'Rojas novads', 'Rojas novads'),
    array('LV', 'Ropažu novads', 'Ropažu novads'),
    array('LV', 'Rucavas novads', 'Rucavas novads'),
    array('LV', 'Rugāju novads', 'Rugāju novads'),
    array('LV', 'Rundāles novads', 'Rundāles novads'),
    array('LV', 'LV-RE', 'Rēzeknes novads'),
    array('LV', 'Rūjienas novads', 'Rūjienas novads'),
    array('LV', 'Salacgrīvas novads', 'Salacgrīvas novads'),
    array('LV', 'Salas novads', 'Salas novads'),
    array('LV', 'Salaspils novads', 'Salaspils novads'),
    array('LV', 'LV-SA', 'Saldus novads'),
    array('LV', 'Saulkrastu novads', 'Saulkrastu novads'),
    array('LV', 'Siguldas novads', 'Siguldas novads'),
    array('LV', 'Skrundas novads', 'Skrundas novads'),
    array('LV', 'Skrīveru novads', 'Skrīveru novads'),
    array('LV', 'Smiltenes novads', 'Smiltenes novads'),
    array('LV', 'Stopiņu novads', 'Stopiņu novads'),
    array('LV', 'Strenču novads', 'Strenču novads'),
    array('LV', 'Sējas novads', 'Sējas novads'),
    array('LV', 'LV-TA', 'Talsu novads'),
    array('LV', 'LV-TU', 'Tukuma novads'),
    array('LV', 'Tērvetes novads', 'Tērvetes novads'),
    array('LV', 'Vaiņodes novads', 'Vaiņodes novads'),
    array('LV', 'LV-VK', 'Valkas novads'),
    array('LV', 'LV-VM', 'Valmieras novads'),
    array('LV', 'Varakļānu novads', 'Varakļānu novads'),
    array('LV', 'Vecpiebalgas novads', 'Vecpiebalgas novads'),
    array('LV', 'Vecumnieku novads', 'Vecumnieku novads'),
    array('LV', 'LV-VE', 'Ventspils novads'),
    array('LV', 'Viesītes novads', 'Viesītes novads'),
    array('LV', 'Viļakas novads', 'Viļakas novads'),
    array('LV', 'Viļānu novads', 'Viļānu novads'),
    array('LV', 'Vārkavas novads', 'Vārkavas novads'),
    array('LV', 'Zilupes novads', 'Zilupes novads'),
    array('LV', 'Ādažu novads', 'Ādažu novads'),
    array('LV', 'Ērgļu novads', 'Ērgļu novads'),
    array('LV', 'Ķeguma novads', 'Ķeguma novads'),
    array('LV', 'Ķekavas novads', 'Ķekavas novads'),

    //ISO-3166-2:LT
    array('LT', 'LT-AL', 'Alytaus Apskritis'),
    array('LT', 'LT-KU', 'Kauno Apskritis'),
    array('LT', 'LT-KL', 'Klaipėdos Apskritis'),
    array('LT', 'LT-MR', 'Marijampolės Apskritis'),
    array('LT', 'LT-PN', 'Panevėžio Apskritis'),
    array('LT', 'LT-SA', 'Šiaulių Apskritis'),
    array('LT', 'LT-TA', 'Tauragės Apskritis'),
    array('LT', 'LT-TE', 'Telšių Apskritis'),
    array('LT', 'LT-UT', 'Utenos Apskritis'),
    array('LT', 'LT-VL', 'Vilniaus Apskritis'),
);

foreach ($regionsToIns as $row) {
    if (! ($connection->fetchOne("SELECT 1 FROM `{$regionTable}` WHERE `country_id` = :country_id && `code` = :code", array('country_id' => $row[0], 'code' => $row[1])))) {
        $connection->insert($regionTable, array(
            'country_id'   => $row[0],
            'code'         => $row[1],
            'default_name' => $row[2]
        ));
    }
}

$installer->endSetup();
