<?php
class Taoapi_Config
{
    //ȫֲ
    private $_Config;

    /**
     * @var  Taoapi_Config
     */
    private static $_init;
    
    private function __construct()
    {
		$this->_Config = require_once dirname(__FILE__).'/Taoapi_Config.inc.php';

		$this->setTestMode($this->_Config['TestMode']);
		$this->_Config['PostMode'] = array('GET' => 'getSend' , 'POST' => 'postSend' , 'POSTIMG' => 'postImageSend');
    }

    /**
     * @return Taoapi_Config
     */
    public static function Init ()
    {
        if (! self::$_init) {
            self::$_init = new Taoapi_Config();
        }
        return self::$_init;
    }

    /**
	 * ݻ: true Ի false ʽ
	 * @param bool $test
     * @return Taoapi_Config
     */
    public function setTestMode ($test = true)
    {
 		if($test)
 		{
 		    $this->_Config['Container'] = 'http://container.api.tbsandbox.com/container';
 			$this->_Config['Url'] = 'http://gw.api.tbsandbox.com/router/rest';
 		}else{
 			$this->_Config['Url'] = 'http://gw.api.taobao.com/router/rest';
 		    $this->_Config['Container'] = 'http://container.api.taobao.com/container';
 		}
        return $this;
    }

    
    /**
     * ûȡݵı. ֧UTF-8 GBK GB2312 
     * Ҫ iconvmb_convert_encoding ֧
     * UTF-8 дUTF8
     * @param string $Charset
     * @return Taoapi_Config
     */
	public function setCharset($Charset)
	{
 		$this->_Config['Charset'] = $Charset;

        return $this;
	}
    
    /**
     * appKey
     * 
     * @param int $key
     * @return Taoapi_Config
     */
    public function setAppKey ($key)
    {
        if(is_array($key))
        {
            $this->_Config['AppKey'] = $key;
        }else{
            $this->_Config['AppKey'][$key] = 0;
        }

        return $this;
    }

    /**
     * appSecret
     * 
     * @param string $Secret
     * @return Taoapi_Config
     */
    public function setAppSecret ($Secret)
    {
		$key = array_search('0',$this->_Config['AppKey']);

		if($key)
		{
			$this->_Config['AppKey'][$key] = $Secret;
		}

        return $this;
    }
    
    /**
     * appKeyֻһʱ,API޺ԶһAPPKEY
     * 
     * @param bool $Secret
     * @return Taoapi_Config
     */
    public function setAppKeyAuto ($AppKeyAuto)
    {
        $this->_Config['AppKeyAuto'] = (bool)$AppKeyAuto;

        return $this;
    }    
	
    /**
     * API汾,1 ʾ1.0 2ʾ2.0 
     * signܷʽ,֧ md5  hmac
     * 
     * @param int $version
     * @param string $signmode
     * @return Taoapi_Config
     */
    public function setVersion ($version,$signmode = 'md5')
    {
        $this->_Config['Version'] = intval($version);
        $this->_Config['SignMode'] = $signmode;

        return $this;
    }
    
    /**
     * signܷʽ,֧ md5  hmac
     * 
     * @param string $signmode
     * @return Taoapi_Config
     */
    public function setSignMode ($signmode = 'md5')
    {
        $this->_Config['SignMode'] = $signmode;

        return $this;
    }

    /**
     * ʾرմʾ
     * 
     * @param bool $CloseError
     * @return Taoapi_Config
     */
    public function setCloseError($CloseError = true)
    {
        $this->_Config['CloseError'] = (bool)$CloseError;

        return $this;
    }

    /**
     * رAPI־,
     * Բ鿴ÿAPPKEYõĴԼõAPI
     * 
     * @param bool $Log
     * @return Taoapi_Config
     */
    public function setApiLog($Log)
    {
        $this->_Config['ApiLog'] = (bool)$Log;

        return $this;
    }

    /**
     * رմ־
     * 
     * @param bool $Errorlog
     * @return Taoapi_Config
     */
    public function setErrorlog($Errorlog)
    {
        $this->_Config['Errorlog'] = $Errorlog;

        return $this;
    }

    /**
     * APIȡʧʱԵĴ,
     * APIȶ,ƼΪ3
     * 
     * @param int $RestNumberic
     * @return Taoapi_Config
     */
    public function setRestNumberic($RestNumberic)
    {
        $this->_Config['RestNumberic'] = intval($RestNumberic);;

        return $this;
    }

    /**
     * ݻʱ,
     * λ:Сʱ;0ʾ
     * 
     * @param int $cache
     * @return Taoapi_Config
     */
    public function setCache($cache = 0)
    {
        $this->_Config['Cache'] = intval($cache);

        return $this;
    }

    /**
     * û汣Ŀ¼
     * 
     * @param string $CachePath
     * @return Taoapi_Config
     */
    public function setCachePath($CachePath)
    {
        $this->_Config['CachePath'] = $CachePath;

        return $this;
    }    
	
    /**
     * Զջʱ
     * 
     * @param string $ClearCache
     * @return Taoapi_Config
     */
    public function setClearCache($ClearCache)
    {
        $this->_Config['ClearCache'] = $ClearCache;

        return $this;
    }

    /**
     * ȫò
     * 
     * @return object
     */
    public function getConfig()
    {
        return (object)$this->_Config;
    }
}