DROP TABLE IF EXISTS `php_ads`;
CREATE TABLE `php_ads` (
  `ads_id` int(10) unsigned NOT NULL auto_increment,
  `ads_name` varchar(255) default NULL,
  `ads_introduce` varchar(255) default NULL,
  `ads_type` varchar(10) default NULL,
  `ads_imageurl` varchar(255) default NULL,
  `ads_imagehttp` varchar(255) default NULL,
  `ads_linkurl` varchar(255) default NULL,
  `ads_alt` varchar(255) default NULL,
  `ads_text` text,
  `ads_fromdate` int(10) NOT NULL,
  `ads_enddate` int(10) NOT NULL,
  `ads_pass` varchar(11) NOT NULL,
  `ads_clicks` int(11) default '0',
  `ads_placeid` int(11) NOT NULL,
  `w` int(11) default '0',
  `h` int(11) default '0',
  `sign` varchar(30) default NULL,
  `region_id` int(10) default NULL,
  PRIMARY KEY  (`ads_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_ads_place`;
CREATE TABLE `php_ads_place` (
  `place_id` int(10) unsigned NOT NULL auto_increment,
  `place_name` varchar(50) NOT NULL,
  `place_introduce` varchar(50) default NULL,
  `place_width` int(11) NOT NULL default '0',
  `place_height` int(11) NOT NULL default '0',
  `region_id` int(10) default NULL,
  PRIMARY KEY  (`place_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_article`;
CREATE TABLE `php_article` (
  `article_id` int(10) NOT NULL auto_increment,
  `category_id` int(11) NOT NULL,
  `article_seo` text,
  `article_short_content` text,
  `article_content` text NOT NULL,
  `article_source` varchar(100) NOT NULL,
  `article_surl` varchar(255) NOT NULL,
  `article_seq` int(10) NOT NULL,
  `manager_id` int(11) NOT NULL,
  `edit_time` int(10) default NULL,
  `article_date` int(10) NOT NULL,
  `article_long_title` varchar(255) NOT NULL,
  `article_icon` varchar(255) NOT NULL,
  `article_public` tinyint(2) NOT NULL,
  `article_hit` int(10) NOT NULL,
  `article_support` int(5) NOT NULL,
  `article_exturl` varchar(255) NOT NULL,
  `template_file` varchar(255) default NULL,
  `defined_id` int(11) default NULL,
  `html_extend` text,
  `allow_comment` tinyint(2) default '2',
  PRIMARY KEY  (`article_id`),
  KEY `article_date` (`article_date`),
  KEY `category_id` (`category_id`),
  KEY `defined_id` (`defined_id`),
  FULLTEXT KEY `article_content` (`article_content`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_article_attribute`;
CREATE TABLE `php_article_attribute` (
  `attribute_id` int(10) NOT NULL auto_increment,
  `define_id` int(10) NOT NULL,
  `attribute_name` varchar(60) NOT NULL,
  `attribute_inputtype` tinyint(1) NOT NULL default '1',
  `attribute_value` text NOT NULL,
  PRIMARY KEY  (`attribute_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_article_attribute_bind`;
CREATE TABLE `php_article_attribute_bind` (
  `bind_id` int(10) NOT NULL auto_increment,
  `article_id` int(10) NOT NULL,
  `define_id` int(10) NOT NULL,
  `attribute_id` int(10) NOT NULL,
  `attribute_fix_val` varchar(255) NOT NULL,
  PRIMARY KEY  (`bind_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_article_attribute_define`;
CREATE TABLE `php_article_attribute_define` (
  `define_id` int(11) NOT NULL auto_increment,
  `define_name` varchar(10) NOT NULL,
  `attribute_count` int(10) NOT NULL,
  PRIMARY KEY  (`define_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_article_category`;
CREATE TABLE `php_article_category` (
  `category_id` int(11) NOT NULL auto_increment,
  `parent_id` int(10) NOT NULL,
  `category_name` varchar(100) NOT NULL,
  `category_have` int(10) NOT NULL,
  `category_date` int(10) NOT NULL,
  `category_type` tinyint(4) NOT NULL default '0',
  `category_sign` varchar(50) default NULL,
  `category_sort` tinyint(4) default '0',
  `category_seo` varchar(255) default NULL,
  `templete_file` varchar(255) default NULL,
  `out_link` varchar(255) default NULL,
  `html_extend` text,
  `focus_son_use_tpl` tinyint(2) default '0',
  `son_cate_tpl` varchar(255) default NULL,
  `extend_data` text,
  PRIMARY KEY  (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_article_comment`;
CREATE TABLE `php_article_comment` (
  `comment_id` int(10) unsigned NOT NULL auto_increment,
  `article_id` int(10) NOT NULL,
  `user_id` int(10) unsigned default '0',
  `user_name` varchar(50) default NULL,
  `comment_content` text NOT NULL,
  `comment_post_time` int(10) unsigned NOT NULL default '0',
  `comment_admin` varchar(50) default '0',
  `comment_admin_content` text,
  `comment_ip` varchar(15) NOT NULL default '0.0.0.0',
  `comment_admin_post_time` int(10) unsigned default NULL,
  `comment_public` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`comment_id`),
  KEY `keyid` (`comment_public`,`comment_id`),
  KEY `userid` (`user_id`,`comment_public`,`comment_id`),
  KEY `ip` (`comment_ip`,`comment_public`,`comment_id`),
  KEY `status` (`comment_public`,`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_cart_temp`;
CREATE TABLE `php_cart_temp` (
  `session_id` varchar(200) default NULL,
  `sign` varchar(150) default NULL,
  `mem_id` int(11) default NULL,
  `mem_name` varchar(50) default '',
  `goods_num` int(11) default NULL,
  `goods_price` float(20,2) default '0.00',
  `goods_weight` float(20,2) default '0.00',
  `only_use_point` tinyint(2) default '0',
  `goods_point_fee` float(20,2) default '0.00',
  `goods_points` float(20,2) default '0.00',
  `goods_name` varchar(255) default '',
  `goods_id` int(11) default NULL,
  `extend_data` text,
  `extend_two` text,
  `add_time` int(11) default NULL,
  `status` tinyint(2) default '0',
  KEY `mem_id` (`mem_id`),
  KEY `goods_id` (`goods_id`),
  KEY `add_time` (`add_time`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_cart_userfixed`;
CREATE TABLE `php_cart_userfixed` (
  `session_id` varchar(200) default NULL,
  `receive_data` text,
  `insert_order` text,
  `admin_set_deliver_fee` text,
  `add_time` int(11) default NULL,
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_auth_list`;
CREATE TABLE `php_core_auth_list` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `parent_id` int(10) default NULL,
  `action` varchar(50) default NULL,
  `name` varchar(50) default NULL,
  `model` varchar(50) default NULL,
  `extend` varchar(50) default NULL,
  `sort` tinyint(5) default '0',
  `is_show` tinyint(2) default '1',
  `is_orgin` tinyint(2) default '0',
  `every_one` tinyint(2) default '0',
  `not_show_in_config` tinyint(2) default '0',
  `ajax_call` tinyint(2) default '0',
  `width` int(11) default NULL,
  `height` int(11) default NULL,
  UNIQUE KEY `id` (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_components`;
CREATE TABLE `php_core_components` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `sign` varchar(50) default NULL,
  `name` varchar(200) default NULL,
  `extend_data` text,
  `add_time` int(10) default NULL,
  `version` varchar(20) default NULL,
  `author` varchar(200) default NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `sign` (`sign`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_file`;
CREATE TABLE `php_core_file` (
  `fid` int(10) unsigned NOT NULL auto_increment,
  `source_file` varchar(255) default NULL,
  `file_name` varchar(100) default NULL,
  `type` varchar(15) default 'default',
  `create_time` int(10) default NULL,
  `file_size` varchar(20) default NULL,
  `author` int(11) default NULL,
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_forbiden`;
CREATE TABLE `php_core_forbiden` (
  `f_id` int(10) unsigned NOT NULL auto_increment,
  `f_name` varchar(25) default NULL,
  `f_ip` varchar(25) default NULL,
  `f_begain_time` int(10) default NULL,
  `f_end_time` int(10) default NULL,
  `f_try_times` tinyint(5) default '0',
  PRIMARY KEY  (`f_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_group`;
CREATE TABLE `php_core_group` (
  `group_id` int(10) unsigned NOT NULL auto_increment,
  `group_name` varchar(25) default NULL,
  `group_desc` text,
  `auth_list` text,
  `is_manager` varchar(4) default '0',
  `is_system` enum('1','0') default '0',
  PRIMARY KEY  (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_logs`;
CREATE TABLE `php_core_logs` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `who` varchar(15) default NULL,
  `detail` text,
  `type` varchar(10) default NULL,
  `time` int(10) default NULL,
  `ip` varchar(20) default NULL,
  `login_pass` varchar(50) default NULL,
  `login_flag` tinyint(2) default '1',
  `login_name` varchar(25) default NULL,
  PRIMARY KEY  (`id`),
  KEY `type` (`type`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_mail_log`;
CREATE TABLE `php_core_mail_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `content` text,
  `reciver` text,
  `time` int(11) default NULL,
  `type` int(11) default '1',
  `error` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_manager`;
CREATE TABLE `php_core_manager` (
  `manager_id` int(10) unsigned NOT NULL auto_increment,
  `manager_name` varchar(50) default 'NULL',
  `manager_pass` varchar(255) default NULL,
  `group_id` int(4) default '0',
  `manager_desc` varchar(255) default 'NULL',
  `disabled` enum('1','0') default '0',
  `expire_time` int(10) default '0',
  `manager_real_name` varchar(20) default NULL,
  `is_orgin` int(2) default '0',
  `manager_menu` varchar(255) default NULL,
  `manager_serial_number` varchar(20) default NULL,
  `department` varchar(50) default NULL,
  `extend_data` text,
  PRIMARY KEY  (`manager_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_member_login_api`;
CREATE TABLE `php_core_member_login_api` (
  `id` int(11) NOT NULL auto_increment,
  `appname` varchar(50) default NULL,
  `config` text,
  `enable` tinyint(2) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`appname`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_navigation`;
CREATE TABLE `php_core_navigation` (
  `nav_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `sort` tinyint(4) default '0',
  `link` varchar(255) default NULL,
  `position` varchar(10) default 'center',
  `blank` tinyint(4) default '0',
  `display` tinyint(4) default '1',
  `extend_name` varchar(50) default NULL,
  PRIMARY KEY  (`nav_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_online`;
CREATE TABLE `php_core_online` (
  `online_id` int(10) unsigned NOT NULL auto_increment,
  `online_data` text NOT NULL,
  `online_session_id` varchar(50) NOT NULL,
  `online_manager` varchar(50) NOT NULL,
  `time` int(11) default NULL,
  PRIMARY KEY  (`online_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_paycard`;
CREATE TABLE `php_core_paycard` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `card_no` varchar(40) default NULL,
  `end_time` int(10) default NULL,
  `create_time` int(10) default NULL,
  `is_used` tinyint(2) default '0',
  `money` int(11) default NULL,
  `key` varchar(80) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_plugins`;
CREATE TABLE `php_core_plugins` (
  `name` varchar(100) NOT NULL,
  `config` text,
  `status` tinyint(2) default '0',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_session`;
CREATE TABLE `php_core_session` (
  `session_key` varchar(50) NOT NULL,
  `session_data` text,
  `session_exp` int(10) default '0',
  PRIMARY KEY  (`session_key`),
  KEY `session_exp` (`session_exp`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_setting`;
CREATE TABLE `php_core_setting` (
  `s_name` varchar(100) NOT NULL,
  `s_data` text,
  `s_ctime` int(10) NOT NULL,
  `s_etime` int(10) NOT NULL,
  KEY `s_name` (`s_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_slide`;
CREATE TABLE `php_core_slide` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url` varchar(100) default NULL,
  `src` varchar(255) default NULL,
  `title` varchar(60) default NULL,
  `text` varchar(255) default NULL,
  `slide_group` varchar(25) default NULL,
  `sort` tinyint(4) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_core_statistics`;
CREATE TABLE `php_core_statistics` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `agent` varchar(255) default NULL,
  `spider` varchar(100) default NULL,
  `time` int(11) default NULL,
  `ip` varchar(50) default NULL,
  `vist_page` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `time` (`time`),
  KEY `spider` (`spider`),
  KEY `id,spider` (`id`,`spider`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_coupon_type`;
CREATE TABLE `php_coupon_type` (
  `coupon_id` int(10) NOT NULL auto_increment,
  `coupon_number` varchar(35) default NULL,
  `coupon_name` varchar(20) default NULL,
  `coupon_type` int(2) default NULL,
  `coupon_fav_replace` float default NULL,
  `coupon_fav_ration` float default NULL,
  `coupon_activ_type` int(2) default NULL,
  `min_money` float default '0',
  `max_money` float default '0',
  `starttime` int(10) default '0',
  `stoptime` int(10) default '0',
  `mem_type` text,
  `add_time` int(10) default NULL,
  PRIMARY KEY  (`coupon_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_coupon_value`;
CREATE TABLE `php_coupon_value` (
  `coupon_v_id` int(20) NOT NULL auto_increment,
  `coupon_v_number` varchar(50) default '0',
  `coupon_id` int(10) default '0',
  `coupon_number` varbinary(35) default '0',
  `mem_id` int(10) default '0',
  `mem_name` varchar(50) default NULL,
  `add_time` int(10) default '0',
  `used_time` int(10) default '0',
  `is_used` int(4) default '0',
  PRIMARY KEY  (`coupon_v_id`),
  KEY `coupon_id` (`coupon_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_delivery`;
CREATE TABLE `php_delivery` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(25) default NULL,
  `delivery_name` varchar(50) NOT NULL default '',
  `delivery_fee` decimal(20,2) NOT NULL default '0.00',
  `desc` varchar(255) NOT NULL,
  `public` tinyint(4) NOT NULL,
  `delivery_savefee` decimal(20,2) NOT NULL,
  `seq` int(11) NOT NULL,
  `is_system` int(5) default '0',
  `delivery_fee_rate` int(10) default NULL,
  `delivery_extend` text,
  `is_force` tinyint(2) default '0',
  `deliery_money_method` tinyint(2) default '1',
  `time_limit` varchar(255) default NULL,
  `deliver_link` varchar(255) default NULL,
  `man_x_free_fee_type` varchar(30) default 'all',
  `man_x_fee_fee_set` text,
  `man_money_free` float(10,2) default '0.00',
  `is_force_use` tinyint(2) default '0',
  `is_special` tinyint(2) default '0',
  `extend_name` char(100) default NULL,
  `to_pay_extend_fee` float(20,2) default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_delivery_config`;
CREATE TABLE `php_delivery_config` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `deliver_id` int(11) default NULL,
  `region_id` int(11) default NULL,
  `shouzhong` int(11) default NULL,
  `shouzhong_fee` float(10,2) default '0.00',
  `xuzhong_fee` float(10,2) default '0.00',
  `only_use_money` float(10,2) default '0.00',
  `region_fix_select_all` text,
  `is_all` tinyint(2) default '1',
  `region_fix_select_locate` text,
  `region_fix_time_limit` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `deliver_id` (`deliver_id`),
  KEY `region_id` (`region_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_feedback`;
CREATE TABLE `php_feedback` (
  `feedback_id` int(10) unsigned NOT NULL auto_increment,
  `mem_id` int(11) NOT NULL,
  `mem_username` varchar(20) NOT NULL,
  `feedback_title` varchar(20) default NULL,
  `feedback_type` int(11) default NULL,
  `feedback_state` int(11) default '1',
  `feedback_content` text,
  `feedback_time` int(10) default NULL,
  `feedback_parentid` int(11) default NULL,
  `feedback_rar` varchar(100) default NULL,
  `admin_name` varchar(20) default NULL,
  PRIMARY KEY  (`feedback_id`),
  KEY `feedback_time` (`feedback_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_friendlink`;
CREATE TABLE `php_friendlink` (
  `friendlink_id` int(10) unsigned NOT NULL auto_increment,
  `friendlink_name` varchar(50) NOT NULL,
  `friendlink_url` varchar(255) NOT NULL,
  `friendlink_type` varchar(10) NOT NULL,
  `friendlink_image` varchar(255) default NULL,
  `friendlink_isshow` varchar(8) NOT NULL,
  `friendlink_time` int(10) NOT NULL,
  `friendlink_show_order` int(11) default '0',
  `friendlink_desc` varchar(255) default NULL,
  PRIMARY KEY  (`friendlink_id`),
  KEY `friendlink_show_order` (`friendlink_show_order`),
  KEY `friendlink_time` (`friendlink_time`),
  KEY `friendlink_isshow` (`friendlink_isshow`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_additional`;
CREATE TABLE `php_goods_additional` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `price` float default NULL,
  `pic` varchar(255) default NULL,
  `time` int(10) default NULL,
  `other` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_attribute`;
CREATE TABLE `php_goods_attribute` (
  `attr_id` int(10) unsigned NOT NULL auto_increment,
  `attr_name` varchar(255) default NULL,
  `attr_value` text,
  `parent_id` int(11) default '0',
  `type_id` int(11) default NULL,
  `input_mode` enum('input','select','text') default 'input',
  `display_mode` enum('flat','select') default 'flat',
  `bind_in_param` tinyint(4) default '0',
  PRIMARY KEY  (`attr_id`),
  KEY `type_id` (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_attribute_bind`;
CREATE TABLE `php_goods_attribute_bind` (
  `goods_attr_bind_id` int(10) unsigned NOT NULL auto_increment,
  `attr_bind_value` text,
  `goods_id` int(11) unsigned default NULL,
  `attr_id` int(11) default NULL,
  `type_id` int(11) default NULL,
  `extend_model` tinyint(2) default '0',
  PRIMARY KEY  (`goods_attr_bind_id`),
  KEY `goods_id` (`goods_id`),
  KEY `attr_id` (`attr_id`),
  KEY `type_id` (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_brand`;
CREATE TABLE `php_goods_brand` (
  `brand_id` int(10) unsigned NOT NULL auto_increment,
  `brand_name` varchar(50) default NULL,
  `brand_short_desc` varchar(255) default NULL,
  `brand_content` text,
  `sort` tinyint(4) default '0',
  `brand_url` varchar(50) default NULL,
  `brand_logo` varchar(255) default NULL,
  `create_time` int(10) default NULL,
  `show_in_nav` tinyint(4) default '0',
  `ads_space` varchar(255) default NULL,
  `brand_sign` varchar(50) default NULL,
  `template_file` varchar(255) default NULL,
  `seo` text,
  `show_index` tinyint(4) default '0',
  `html_extend` text,
  `pinyin` varchar(60) default NULL,
  `total` int(11) default '0',
  `is_recomend` tinyint(2) default '0',
  `edit_time` int(10) default NULL,
  PRIMARY KEY  (`brand_id`),
  KEY `sort` (`sort`),
  KEY `show_in_nav` (`show_in_nav`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_category`;
CREATE TABLE `php_goods_category` (
  `cate_id` int(11) unsigned NOT NULL auto_increment,
  `cate_name` varchar(50) default NULL,
  `parent_id` int(11) default '0',
  `cate_desc` varchar(255) default NULL,
  `cate_extension` varchar(50) default NULL,
  `cate_sort` int(5) default '0',
  `cate_outlink` varchar(255) default NULL,
  `show_in_nav` tinyint(4) default '0',
  `ads_space` varchar(255) default NULL,
  `cate_brands` varchar(255) default NULL,
  `cate_sign` varchar(50) default NULL,
  `show_in_category` tinyint(4) default '0',
  `seo` text,
  `template_file` varchar(255) default NULL,
  `total` int(11) default '0',
  `html_extend` text,
  `add_time` int(10) default NULL,
  `edit_time` int(10) default NULL,
  PRIMARY KEY  (`cate_id`),
  KEY `cate_sort` (`cate_sort`),
  KEY `cate_brands` (`cate_brands`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_category_extend`;
CREATE TABLE `php_goods_category_extend` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(200) default NULL,
  `extend` text,
  `sign` varchar(100) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_point`;
CREATE TABLE `php_goods_point` (
  `com_id` int(11) default NULL,
  `goods_id` int(11) default NULL,
  `goods_point` int(11) default NULL,
  KEY `com_id` (`com_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_product`;
CREATE TABLE `php_goods_product` (
  `goods_id` int(10) unsigned NOT NULL auto_increment,
  `goods_name` varchar(255) default NULL,
  `goods_alias_name` varchar(255) default NULL,
  `goods_add_time` int(10) default NULL,
  `goods_edit_time` int(10) default NULL,
  `goods_brands_id` int(11) default NULL,
  `goods_category_id` int(11) default NULL,
  `goods_extend_category` text,
  `goods_short_desc` text,
  `goods_contents` text,
  `goods_seo_info` text,
  `goods_is_sale` tinyint(4) NOT NULL default '1',
  `goods_keywords` varchar(255) default NULL,
  `goods_sn` varchar(255) NOT NULL,
  `goods_shop_price` float(10,2) default '0.00',
  `goods_market_price` float(10,2) default '0.00',
  `goods_promotion_price` float(10,2) default '0.00',
  `goods_stock` int(10) default '5',
  `goods_detail_out_link` varchar(255) default NULL,
  `goods_source_pic` varchar(255) default NULL,
  `goods_source_pic_water` varchar(255) default NULL,
  `goods_list_small_pic` varchar(255) default NULL,
  `goods_detail_pic` varchar(255) default NULL,
  `goods_detail_extend_pic` varchar(255) default NULL,
  `goods_detail_water_pic` varchar(255) default NULL,
  `goods_albums_data` text,
  `goods_out_link` varchar(120) default NULL,
  `goods_other_cfg` text,
  `goods_weight` int(10) default NULL,
  `goods_shoper_remark` varchar(255) default NULL,
  `goods_is_special` tinyint(4) default '0',
  `goods_is_hot` tinyint(4) default '0',
  `goods_is_promotion` tinyint(4) default '0',
  `goods_is_new` tinyint(4) default '0',
  `goods_is_recomand` tinyint(4) default '0',
  `goods_extend_prefix` text,
  `is_use_xunjia` tinyint(4) default '0',
  `goods_is_competitive` tinyint(4) default '0',
  `goods_cost_price` float(10,2) default '0.00',
  `goods_tags_id` varchar(100) default NULL,
  `goods_types_id` int(11) default NULL,
  `goods_relative_ids` varchar(200) default NULL,
  `goods_relative` varchar(30) default 'one',
  `goods_visted` int(10) default '0',
  `goods_points` float default '0',
  `goods_packet` text,
  `goods_after_service` text,
  `goods_spec_main_id` int(50) default NULL,
  `goods_spec_extend_name` varchar(250) default NULL,
  `goods_promotion_begain_time` int(11) default NULL,
  `goods_promotion_end_time` int(11) default NULL,
  `other_extend_info` text,
  `template_file` varchar(255) default NULL,
  `html_extend` text,
  `sale_point` int(11) default NULL,
  `is_additional` tinyint(4) default '0',
  `sale_numbers` int(11) default '0',
  `is_try_goods` tinyint(4) default '0',
  `goods_unit` tinyint(4) default '0',
  `region_id` int(11) default NULL,
  `supplier_id` int(10) default NULL,
  `goods_chandi_id` int(10) default '0',
  `goods_special_tags` int(10) default '0',
  `who_add` int(10) default '0',
  `zengpin` tinyint(2) default '0',
  `zenpin_data` text,
  `taozhuang_data` text,
  `taozhuang` tinyint(2) default '0',
  `only_use_point` tinyint(2) default '0',
  `goods_point_fee` float(20,2) default '0.00',
  PRIMARY KEY  (`goods_id`),
  KEY `goods_brands_id` (`goods_brands_id`),
  KEY `goods_category_id` (`goods_category_id`),
  KEY `goods_is_sale` (`goods_is_sale`),
  KEY `goods_is_hot` (`goods_is_hot`),
  KEY `goods_types_id` (`goods_types_id`),
  KEY `goods_is_new` (`goods_is_new`),
  KEY `goods_is_recomand` (`goods_is_recomand`),
  KEY `goods_is_competitive` (`goods_is_competitive`),
  KEY `goods_add_time` (`goods_add_time`),
  KEY `goods_edit_time` (`goods_edit_time`),
  KEY `goods_spec_id` (`goods_spec_main_id`),
  KEY `is_additional` (`is_additional`),
  KEY `is_try_goods` (`is_try_goods`),
  KEY `zengpin` (`zengpin`),
  KEY `taozhuang` (`taozhuang`),
  KEY `goods_spec_main_id` (`goods_spec_main_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_relatives`;
CREATE TABLE `php_goods_relatives` (
  `goods_id` int(11) default NULL,
  `article_rel_data` text,
  `goods_rel_data` text,
  KEY `goods_id` (`goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_searchkey`;
CREATE TABLE `php_goods_searchkey` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `keywords` varchar(255) default NULL,
  `count` int(11) default '0',
  `hot` tinyint(4) default '0',
  `sort` int(11) default '0',
  PRIMARY KEY  (`id`),
  KEY `hot` (`hot`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_spec_bind`;
CREATE TABLE `php_goods_spec_bind` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `goods_id` int(10) default NULL,
  `main_index` int(10) default NULL,
  `prefix_name` varchar(150) default NULL,
  `prefix_alias_name` varchar(150) default NULL,
  `goods_sn` varchar(50) default NULL,
  `goods_stock` int(10) default NULL,
  PRIMARY KEY  (`id`),
  KEY `goods_id` (`goods_id`),
  KEY `main_index` (`main_index`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_spec_index`;
CREATE TABLE `php_goods_spec_index` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `goods_id` int(11) default NULL,
  `index_name` varchar(50) default NULL,
  `sort` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_specfication_bind`;
CREATE TABLE `php_goods_specfication_bind` (
  `b_id` int(10) unsigned NOT NULL auto_increment,
  `spec_id` int(11) default NULL,
  `spec_extend_id` int(11) default NULL,
  `bind_value` varchar(50) default NULL,
  `extend_value` varchar(50) default NULL,
  `goods_id` int(11) default NULL,
  `extend_price` varchar(10) default NULL,
  PRIMARY KEY  (`b_id`),
  KEY `spec_id` (`spec_id`),
  KEY `spec_extend_id` (`spec_extend_id`),
  KEY `goods_id` (`goods_id`),
  KEY `search` (`spec_id`,`spec_extend_id`,`goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_specfication_extend`;
CREATE TABLE `php_goods_specfication_extend` (
  `spec_extend_id` int(10) unsigned NOT NULL auto_increment,
  `spec_id` int(11) default NULL,
  `index_filter` tinyint(4) default '0',
  `other_filter` tinyint(4) default '0',
  `spec_value` varchar(50) default NULL,
  `spec_image` varchar(255) default NULL,
  PRIMARY KEY  (`spec_extend_id`),
  KEY `spec_id` (`spec_id`),
  KEY `index_filter` (`index_filter`),
  KEY `other_filter` (`other_filter`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_specification`;
CREATE TABLE `php_goods_specification` (
  `spec_id` int(10) unsigned NOT NULL auto_increment,
  `spec_name` varchar(250) default NULL,
  `spec_remark` text,
  `spec_display` enum('select','flat','radio') default 'flat',
  PRIMARY KEY  (`spec_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_speicail_tag`;
CREATE TABLE `php_goods_speicail_tag` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `extend` text,
  `en_name` varchar(100) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_suppliers`;
CREATE TABLE `php_goods_suppliers` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `pinyin` varchar(50) default NULL,
  `desc` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_tags`;
CREATE TABLE `php_goods_tags` (
  `tag_id` int(10) unsigned NOT NULL auto_increment,
  `tag_value` varchar(100) default NULL,
  PRIMARY KEY  (`tag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_types`;
CREATE TABLE `php_goods_types` (
  `type_id` int(10) unsigned NOT NULL auto_increment,
  `type_name` varchar(50) default NULL,
  `type_alias` varchar(50) default NULL,
  `types_parameter` text,
  PRIMARY KEY  (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_types_parameter`;
CREATE TABLE `php_goods_types_parameter` (
  `parameter_id` int(10) unsigned NOT NULL auto_increment,
  `parameter_value` varchar(255) default NULL,
  `parent_id` int(11) default '0',
  PRIMARY KEY  (`parameter_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_goods_unit`;
CREATE TABLE `php_goods_unit` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(25) default NULL,
  `en_name` varchar(20) default NULL,
  `group` tinyint(4) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member`;
CREATE TABLE `php_member` (
  `mem_id` int(11) unsigned NOT NULL auto_increment,
  `mem_username` varchar(100) NOT NULL,
  `mem_password` varchar(50) NOT NULL,
  `mem_email` varchar(30) NOT NULL,
  `mem_levelpoint` int(10) default '1',
  `mem_register_time` int(10) default NULL,
  `mem_this_loin_time` int(10) default NULL,
  `mem_last_login_time` int(10) default NULL,
  `mem_state` int(11) default '1',
  `mem_this_login_ip` varchar(15) default NULL,
  `mem_last_login_ip` varchar(15) default NULL,
  `mem_reg_ip` varchar(15) default NULL,
  `mem_group` int(4) default '1',
  `mem_sex` int(4) default '0',
  `mem_phone` varchar(13) default NULL,
  `mem_mobile` varchar(13) default NULL,
  `mem_name` varchar(50) default NULL,
  `mem_conaddress` varchar(255) default NULL,
  `mem_area` varchar(50) default NULL,
  `mem_zip` varchar(6) default NULL,
  `mem_question` varchar(50) default NULL,
  `mem_answer` varchar(50) default NULL,
  `mem_qq` varchar(12) default NULL,
  `mem_msn` varchar(20) default NULL,
  `mem_brith` int(10) default NULL,
  `mem_text` text,
  `mem_recommender` int(10) default '0',
  `thumb` varchar(255) default NULL,
  `mem_salt` varchar(6) default NULL,
  `member_api_extend` text,
  `member_api_appname` varchar(50) default NULL,
  `pay_pass` varchar(255) default NULL,
  PRIMARY KEY  (`mem_id`),
  KEY `mem_group` (`mem_group`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_attr`;
CREATE TABLE `php_member_attr` (
  `attr_id` int(4) unsigned NOT NULL auto_increment,
  `attr_name` varchar(100) default NULL,
  `attr_type` varchar(20) default NULL,
  `attr_required` int(11) default '0',
  `attr_typename` varchar(50) default 'system',
  `attr_show` int(4) default '1',
  `attr_group` varchar(50) default NULL,
  `attr_valname` varchar(50) default NULL,
  `attr_order` int(4) default '50',
  `attr_option` text,
  PRIMARY KEY  (`attr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_collect_goods`;
CREATE TABLE `php_member_collect_goods` (
  `mem_id` int(11) NOT NULL,
  `mem_goods_id` text,
  PRIMARY KEY  (`mem_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_goodscomment`;
CREATE TABLE `php_member_goodscomment` (
  `com_id` int(10) unsigned NOT NULL auto_increment,
  `com_goods` int(4) default '0',
  `com_bads` int(4) default '0',
  `com_type` int(4) default '1',
  `sp_sum` int(4) default '0',
  `wg_sum` int(4) default '0',
  `ss_sum` int(4) default '0',
  `com_goods_id` int(11) NOT NULL,
  `com_mem_username` varchar(20) NOT NULL,
  `com_content` text,
  `com_time` int(10) default NULL,
  `com_ip` varchar(15) default NULL,
  `com_state` tinyint(4) default '2',
  `com_admin` varchar(50) default NULL,
  `com_back_content` text,
  `com_back_time` int(10) default NULL,
  `com_back_state` tinyint(4) default '1',
  `com_flg` int(11) default '1',
  `com_benefits` text,
  `com_shortcomings` text,
  `com_summary` text,
  `com_title` varchar(50) default NULL,
  `com_contact` varchar(100) default NULL,
  PRIMARY KEY  (`com_id`),
  KEY `com_goods_id` (`com_goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_group`;
CREATE TABLE `php_member_group` (
  `group_id` int(10) unsigned NOT NULL auto_increment,
  `group_name` varchar(50) NOT NULL,
  `group_desc` text,
  `group_power` text,
  `discount` float default '1',
  `is_system` tinyint(2) default '0',
  PRIMARY KEY  (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_level`;
CREATE TABLE `php_member_level` (
  `level_id` int(4) unsigned NOT NULL auto_increment,
  `level_name` varchar(50) default NULL,
  `level_point` double default NULL,
  `level_discount` double default '1',
  `level_default` int(4) default '1',
  `level_description` text,
  PRIMARY KEY  (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_money_log`;
CREATE TABLE `php_member_money_log` (
  `id` int(11) NOT NULL auto_increment,
  `mem_id` int(11) default NULL,
  `current_money` decimal(20,2) NOT NULL default '0.00',
  `change_money` decimal(20,2) NOT NULL default '0.00',
  `result_money` decimal(20,2) NOT NULL default '0.00',
  `manager_id` int(11) default NULL,
  `manager_name` varchar(100) default NULL,
  `date` int(11) default NULL,
  `type` tinyint(4) default NULL,
  `desc` text,
  `add_money` decimal(20,2) NOT NULL default '0.00',
  `cut_money` decimal(20,2) NOT NULL default '0.00',
  `order_sn` varchar(50) default NULL,
  `waterline_no` varchar(50) default NULL,
  `pay_code` varchar(255) NOT NULL default 'aaa',
  `extend_data` text,
  `do_type` tinyint(2) default '0',
  PRIMARY KEY  (`id`),
  KEY `mem_id` (`mem_id`),
  KEY `manager_id` (`manager_id`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_point_log`;
CREATE TABLE `php_member_point_log` (
  `p_id` int(10) unsigned NOT NULL auto_increment,
  `order_sn` varchar(55) default NULL,
  `msg` text,
  `status` varchar(10) default '+',
  `time` int(10) default NULL,
  `operator` varchar(20) default NULL,
  `mem_id` int(11) default NULL,
  `point` int(11) default NULL,
  PRIMARY KEY  (`p_id`),
  KEY `time` (`time`),
  KEY `mem_id` (`mem_id`),
  KEY `order_sn` (`order_sn`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_receiver_address`;
CREATE TABLE `php_member_receiver_address` (
  `receive_id` int(11) unsigned NOT NULL auto_increment,
  `receive_realname` varchar(30) default NULL,
  `receive_area` varchar(30) default NULL,
  `receive_address` varchar(200) default NULL,
  `receive_postno` varchar(10) default NULL,
  `receive_phone` varchar(13) default NULL,
  `receive_mobile` varchar(13) default NULL,
  `receive_email` varchar(30) default NULL,
  `receive_date_type` varchar(30) default NULL,
  `receive_time` int(10) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`receive_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_member_visted_logs`;
CREATE TABLE `php_member_visted_logs` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `member_id` int(11) default NULL,
  `goods_id` int(11) default NULL,
  `count` int(11) default NULL,
  `brand_id` int(11) default NULL,
  `category_id` int(11) default NULL,
  `time` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `member_id` (`member_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_message_board`;
CREATE TABLE `php_message_board` (
  `b_id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `other` text,
  `add_time` int(11) default NULL,
  `replay` text,
  `replay_time` int(11) default NULL,
  `content` text,
  `ip` varchar(30) default NULL,
  `status` tinyint(4) default '0',
  `flag` tinyint(4) default '0',
  PRIMARY KEY  (`b_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_message_template`;
CREATE TABLE `php_message_template` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `title` varchar(255) default NULL,
  `type` varchar(20) default 'email',
  `label` text,
  `desc` varchar(100) default NULL,
  `disbled` tinyint(3) default '1',
  `detail` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_messagebox`;
CREATE TABLE `php_messagebox` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `member_id` int(11) default NULL,
  `title` varchar(255) default NULL,
  `content` text,
  `time` int(11) default NULL,
  `is_read` tinyint(4) default NULL,
  PRIMARY KEY  (`id`),
  KEY `time` (`time`),
  KEY `member_id` (`member_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order`;
CREATE TABLE `php_order` (
  `order_id` int(10) unsigned NOT NULL auto_increment,
  `order_sn` varchar(50) NOT NULL,
  `mem_id` int(10) NOT NULL,
  `order_confirm_status` tinyint(4) default '0',
  `pay_status` tinyint(4) NOT NULL default '0',
  `pay_checked_status` tinyint(2) default '0',
  `shiping_rationing_time` int(11) default NULL,
  `shiping_finished_time` int(11) default NULL,
  `shiping_delivery_time` int(11) default NULL,
  `pay_confirm_time` int(10) default NULL,
  `shiping_status` tinyint(4) NOT NULL default '0',
  `add_time` int(11) NOT NULL,
  `confirm_time` int(11) NOT NULL,
  `shipping_time` int(11) NOT NULL,
  `receive_realname` varchar(255) NOT NULL,
  `receive_phone` varchar(20) NOT NULL,
  `receive_mobile` varchar(20) NOT NULL,
  `receive_email` varchar(50) NOT NULL,
  `receive_address` varchar(255) NOT NULL,
  `receive_area` varchar(255) NOT NULL,
  `receive_date_type` varchar(20) NOT NULL,
  `receive_paycode` varchar(20) NOT NULL,
  `receive_note` text NOT NULL,
  `receive_postno` varchar(20) NOT NULL,
  `receive_invoice` varchar(255) NOT NULL,
  `order_money` decimal(20,2) NOT NULL default '0.00',
  `order_goods_point_fee` float(20,2) default '0.00',
  `order_total_point_fee` float(20,2) default '0.00',
  `waterline_no` varchar(50) NOT NULL default '',
  `receive_out_of_stock` varchar(255) NOT NULL,
  `mem_username` varchar(100) NOT NULL default '',
  `order_count` int(11) NOT NULL,
  `delivery_id` int(5) default NULL,
  `delivery_name` varchar(50) NOT NULL,
  `delivery_fee` decimal(20,2) NOT NULL default '0.00',
  `goods_money` decimal(20,2) default '0.00',
  `delivery_no` varchar(255) default NULL,
  `ismerge` int(2) default '0',
  `coupon_number` varchar(50) default NULL,
  `coupon_money` float(20,2) default '0.00',
  `discount` varchar(20) default NULL,
  `discount_money` decimal(20,2) default '0.00',
  `extend_data` text,
  `fapiao_money` float(20,2) default '0.00',
  `is_use_fapiao` tinyint(2) default '0',
  `fapiao_model_all` text,
  `deliver_decline_money` float(20,2) default '0.00',
  `deliver_decline_money_flag` tinyint(2) default '0',
  `deliver_temp_data` text,
  `tuihuo_sign` int(4) default '0',
  `tuihuo_do_flag` int(2) default '0',
  `user_cancel_flag` tinyint(2) default '0',
  `cache_order_reason` text,
  `tuikuan_flag` tinyint(2) default '0',
  `tuikuan_do_flag` tinyint(2) default '0',
  `extend_contact_info` text,
  `payment_extend_data` text,
  `payment_extend_money` float(20,2) default '0.00',
  `delivery_extend_money` float(20,2) default '0.00',
  `delivery_extend_data` text,
  `order_goods_info_all` text,
  PRIMARY KEY  (`order_id`),
  KEY `mem_id` (`mem_id`),
  KEY `order_sn` (`order_sn`),
  KEY `add_time` (`add_time`),
  KEY `order_confirm_status` (`order_confirm_status`),
  KEY `pay_status` (`pay_status`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_goods_explode`;
CREATE TABLE `php_order_goods_explode` (
  `id` int(11) NOT NULL,
  `order_id` int(11) default NULL,
  `order_sn` varchar(50) default NULL,
  `delivery_no` varchar(50) default NULL,
  `goods_id` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_outstock`;
CREATE TABLE `php_order_outstock` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `email` varchar(100) default NULL,
  `goods_name` varchar(255) default NULL,
  `num` varchar(10) default NULL,
  `mobile` varchar(12) default NULL,
  `remark` text,
  `status` tinyint(2) default '0',
  `user` varchar(50) default NULL,
  `to_time` int(10) default NULL,
  `do_time` int(10) default NULL,
  `detail` text,
  `do_user` varchar(30) default NULL,
  `qq` varchar(20) default NULL,
  `ip` varchar(25) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_payed_log`;
CREATE TABLE `php_order_payed_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) default NULL,
  `order_sn` varchar(50) default NULL,
  `payed_money` float(20,2) default '0.00',
  `mem_id` int(11) default NULL,
  `pay_time` int(11) default NULL,
  `pay_sn` varchar(255) default NULL,
  `pay_method` varchar(50) default NULL,
  `extend_data` text,
  `check_status` tinyint(2) default '0',
  `admin_add` tinyint(2) default '0',
  `admin_do_time` int(10) default NULL,
  `old_extend_data` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_payed_point_log`;
CREATE TABLE `php_order_payed_point_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) default NULL,
  `order_sn` varchar(50) default NULL,
  `payed_points` float(20,2) default '0.00',
  `mem_id` int(11) default NULL,
  `pay_time` int(11) default NULL,
  `pay_sn` varchar(255) default NULL,
  `pay_method` varchar(50) default 'member_point',
  `extend_data` text,
  `check_status` tinyint(2) default '0',
  `admin_add` tinyint(2) default '0',
  `admin_do_time` int(10) default NULL,
  `old_extend_data` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_remark`;
CREATE TABLE `php_order_remark` (
  `re_id` int(10) unsigned NOT NULL auto_increment,
  `manager_real_name` varchar(50) default NULL,
  `re_operator_name` varchar(50) default NULL,
  `re_add_time` int(11) default NULL,
  `order_sn` varchar(50) default NULL,
  `order_id` varchar(50) default NULL,
  `re_content` text,
  `pay_status` tinyint(4) default '0',
  `order_confirm_status` tinyint(4) default '0',
  `shiping_status` tinyint(4) default '0',
  `flag` tinyint(4) default '0',
  `order_pay_logs` text,
  `order_pay_point_logs` text,
  `order_goods_log` text,
  `order_log` text,
  `tuikuan_log` text,
  `tuihuo_log` text,
  `order_old_data` text,
  PRIMARY KEY  (`re_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_tuihuo_log`;
CREATE TABLE `php_order_tuihuo_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `order_id` int(11) default NULL,
  `content` text,
  `ip` varchar(50) default NULL,
  `time` int(11) default NULL,
  `mem_id` int(11) default NULL,
  `who_do` varchar(50) default NULL,
  `admin_realy_name` varchar(50) default NULL,
  `do_remark` text,
  `user_contact_method` varchar(100) default NULL,
  `pay_log_extend` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_order_tuikuan_log`;
CREATE TABLE `php_order_tuikuan_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(11) default NULL,
  `contact` varchar(150) default NULL,
  `content` text,
  `add_time` int(11) default NULL,
  `replay_time` text,
  `admin_realy_name` varchar(50) default NULL,
  `manager` varchar(50) default NULL,
  `ip` varchar(50) default NULL,
  `user_contact_method` varchar(150) default NULL,
  `time` int(11) default NULL,
  `who_do` varchar(50) default NULL,
  `mem_id` int(11) default NULL,
  `mem_name` varchar(50) default NULL,
  `do_remark` text,
  `pay_log_extend` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_page`;
CREATE TABLE `php_page` (
  `page_id` int(10) unsigned NOT NULL auto_increment,
  `page_name` varchar(50) default NULL,
  `page_filename` varchar(100) default NULL,
  `seo` text,
  `page_title` varchar(100) default NULL,
  `page_content` text,
  `page_tpl_main` varchar(100) default NULL,
  `page_posttime` int(10) default NULL,
  `page_type` int(11) default NULL,
  `page_sign` varchar(50) default NULL,
  PRIMARY KEY  (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_page_type`;
CREATE TABLE `php_page_type` (
  `type_id` int(10) unsigned NOT NULL auto_increment,
  `type_name` varchar(100) default NULL,
  PRIMARY KEY  (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_pay_goods`;
CREATE TABLE `php_pay_goods` (
  `id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL default '0',
  `goods_category_id` int(11) default '0',
  `goods_brand_id` int(11) default NULL,
  `goods_name` varchar(255) NOT NULL default '',
  `goods_shop_price` decimal(20,2) NOT NULL default '0.00',
  `goods_curent_price` decimal(20,2) default '0.00',
  `goods_total` int(11) NOT NULL,
  `mem_id` int(11) NOT NULL,
  `goods_sn` varchar(100) NOT NULL,
  `order_sn` varchar(100) NOT NULL,
  `goods_points` int(20) default '0',
  `goods_weight` int(11) default '0',
  `mem_recommender` int(10) default NULL,
  `goods_ok_deduct` int(2) default '0',
  `member_ok_deduct` int(2) default '0',
  `region_id` int(11) default '0',
  `is_additional` tinyint(10) default '0',
  `discount` varchar(5) default NULL,
  `discount_money` decimal(20,2) default '0.00',
  `goods_special_tags` int(11) default NULL,
  `taozhuang` tinyint(2) default '0',
  `zenpin_extend_data` text,
  `zenpin_extend_ids` text,
  `zengpin` tinyint(2) default NULL,
  `taozhuang_extend_data` text,
  `taozhuang_extend_ids` text,
  `goods_point_fee` float(20,2) default '0.00',
  `only_use_point` tinyint(2) default '0',
  `goods_add_type` tinyint(2) default '0',
  PRIMARY KEY  (`id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`goods_id`),
  KEY `goods_total` (`goods_total`),
  KEY `mem_id` (`mem_id`),
  KEY `region_id` (`region_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_pay_payment`;
CREATE TABLE `php_pay_payment` (
  `pay_id` tinyint(3) unsigned NOT NULL auto_increment,
  `pay_code` varchar(20) NOT NULL,
  `pay_name` varchar(120) NOT NULL,
  `pay_desc` text NOT NULL,
  `pay_fee` varchar(10) NOT NULL,
  `pay_seq` tinyint(3) unsigned NOT NULL default '0',
  `pay_public` tinyint(1) unsigned NOT NULL default '0',
  `pay_aid` varchar(100) NOT NULL,
  `pay_akey` varchar(100) NOT NULL,
  `pay_line` varchar(255) NOT NULL,
  `pay_extend_fee` float(10,2) default '0.00',
  `pay_config` text NOT NULL,
  `support_area` text,
  `pay_pic` varchar(255) default NULL,
  PRIMARY KEY  (`pay_id`),
  KEY `pay_code` (`pay_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_popularize_log`;
CREATE TABLE `php_popularize_log` (
  `id` int(10) NOT NULL auto_increment,
  `mem_id` int(10) default NULL,
  `comment` text,
  `submittime` int(10) default NULL,
  `money` float(20,2) default NULL,
  `point` int(10) default NULL,
  `type` int(2) default '1',
  `child_id` varchar(50) default NULL,
  `goods_data` text,
  `goods_id` text,
  `int` int(10) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_promotion_mass_log`;
CREATE TABLE `php_promotion_mass_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `content` text,
  `add_time` int(11) default NULL,
  `type` tinyint(2) default '1',
  `data_log` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_region`;
CREATE TABLE `php_region` (
  `region_id` smallint(5) unsigned NOT NULL auto_increment,
  `parent_id` smallint(5) unsigned NOT NULL default '0',
  `region_name` varchar(120) default NULL,
  `sort` int(11) default '0',
  `template_file` varchar(255) default NULL,
  `seo_data` text,
  `html_extend` text,
  `alias_name` varchar(50) default NULL,
  `thumb` varchar(200) default NULL,
  `sign` varchar(50) default NULL,
  `region_ename` varchar(100) default NULL,
  `chandi_total` int(10) default '0',
  `changguan_total` int(10) default '0',
  `special_region` tinyint(2) default '0',
  `display_model` varchar(30) default NULL,
  PRIMARY KEY  (`region_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_region_locate`;
CREATE TABLE `php_region_locate` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `region_main_name` varchar(50) default NULL,
  `extend_data` text,
  `sort` tinyint(4) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_subscribe`;
CREATE TABLE `php_subscribe` (
  `id` int(4) NOT NULL auto_increment,
  `email` varchar(100) NOT NULL default '',
  `mem_id` int(10) default NULL,
  `mem_name` varchar(30) default NULL,
  `add_time` int(10) default NULL,
  `static` tinyint(4) default '0',
  `ip` varchar(25) default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_subscribe_content`;
CREATE TABLE `php_subscribe_content` (
  `scr_id` int(10) NOT NULL auto_increment,
  `scr_title` varchar(50) default NULL,
  `scr_content` text,
  `scr_add_time` int(10) default NULL,
  `exend` text,
  UNIQUE KEY `scr_id` (`scr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_try_goods_list`;
CREATE TABLE `php_try_goods_list` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `compay_name` varchar(255) default NULL,
  `goods_id` int(11) default NULL,
  `extend_info` text,
  `add_time` int(11) default NULL,
  `status` tinyint(4) default '0',
  `opt_time` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `add_time` (`add_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_category`;
CREATE TABLE `php_tuangou_category` (
  `id` int(11) NOT NULL auto_increment,
  `sort` int(3) default '0',
  `name` varchar(100) default NULL,
  `group_name` varchar(50) default NULL,
  `en_name` varchar(100) default NULL,
  `en_first` varchar(5) default NULL,
  `desc` text,
  `seo` text,
  `tpl` varchar(200) default NULL,
  `type` tinyint(2) default '1',
  `add_time` int(10) default NULL,
  `edit_time` int(10) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_goods`;
CREATE TABLE `php_tuangou_goods` (
  `id` int(10) NOT NULL auto_increment,
  `cate_id` int(10) default NULL,
  `project_name` varchar(255) default NULL,
  `seo` text,
  `tpl` varchar(200) default NULL,
  `type` tinyint(2) default '1',
  `add_time` int(10) default NULL,
  `edit_time` int(10) default NULL,
  `conduser` varchar(2) default 'Y',
  `buyonce` varchar(2) default 'Y',
  `sort` int(6) default NULL,
  `market_price` decimal(20,2) default '0.00',
  `shop_price` decimal(20,2) default '0.00',
  `pre_number` int(10) default NULL,
  `start_time` int(10) default NULL,
  `end_time` int(10) default NULL,
  `min_number` int(10) default NULL,
  `max_number` int(10) default NULL,
  `per_buy_number` int(10) default NULL,
  `min_buy_number` int(10) default NULL,
  `short_desc` text,
  `spec_content` text,
  `goods_name` varchar(255) default NULL,
  `goods_extend_prefix` text,
  `pic1` varchar(255) default NULL,
  `pic2` varchar(255) default NULL,
  `pic3` varchar(255) default NULL,
  `pic4` varchar(255) default NULL,
  `flv` varchar(255) default NULL,
  `goods_detail` text,
  `member_dianpin` text,
  `mian_dan_num` tinyint(4) default NULL,
  `peisong_desc` text,
  `peisong_fee` decimal(20,2) default '0.00',
  `is_recomand` tinyint(2) default '0',
  `visted` int(10) default NULL,
  PRIMARY KEY  (`id`),
  KEY `cate_id` (`cate_id`),
  KEY `start_time` (`start_time`),
  KEY `end_time` (`end_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_order`;
CREATE TABLE `php_tuangou_order` (
  `order_id` int(11) NOT NULL auto_increment,
  `order_sn` varchar(60) default NULL,
  `tuan_id` int(11) default NULL,
  `project_name` varchar(255) default NULL,
  `goods_name` varchar(255) default NULL,
  `count` int(11) default NULL,
  `cate_id` int(11) default NULL,
  `add_time` int(10) default NULL,
  `extend_data` text,
  `mem_id` int(10) default NULL,
  `re_name` varchar(50) default NULL,
  `re_phone` varchar(20) default NULL,
  `re_address` varchar(255) default NULL,
  `re_zip` varchar(10) default NULL,
  `re_order_type` text,
  `re_extend` text,
  `total_delivery_fee` float(20,2) default '0.00',
  `delivery_fee` float(20,2) default '0.00',
  `goods_money` float(20,2) default '0.00',
  `total_goods_money` float(20,2) default '0.00',
  `total_order_fee` float(20,2) default '0.00',
  `pay_status` tinyint(2) default '0',
  `pay_time` int(11) default NULL,
  `wuliu_sn` varchar(100) default NULL,
  `wuliu_name` varchar(150) default NULL,
  `order_remark` text,
  PRIMARY KEY  (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_order_remark`;
CREATE TABLE `php_tuangou_order_remark` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(10) default NULL,
  `who` varchar(50) default NULL,
  `time` int(11) default NULL,
  `desc` text,
  `extend_data` text,
  PRIMARY KEY  (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_pay_log`;
CREATE TABLE `php_tuangou_pay_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `order_id` int(11) default NULL,
  `pay_time` int(11) default NULL,
  `pay_sn` varchar(200) default NULL,
  `mem_id` int(11) default NULL,
  `money` float(20,2) default '0.00',
  `pay_method` varchar(50) default NULL,
  `extend_data` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_region_goods`;
CREATE TABLE `php_tuangou_region_goods` (
  `region_id` int(11) default NULL,
  `tuan_id` int(11) default NULL,
  KEY `region_id` (`region_id`),
  KEY `tuan_id` (`tuan_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `php_tuangou_subscribe`;
CREATE TABLE `php_tuangou_subscribe` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `mail` varchar(150) default NULL,
  `time` int(11) default NULL,
  `region_id` int(11) default NULL,
  `region_name` varchar(50) default NULL,
  `phone` varchar(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk;
