<?php
/*
	[Destoon B2B System] Copyright (c) 2008-2011 Destoon.COM
	This is NOT a freeware, use is subject to license.txt
*/
defined('IN_DESTOON') or exit('Access Denied');
class remote {
    var $file;
    var $savename;
    var $savepath;
	var $saveto;
    var $overwrite = false;
    var $maxsize;
    var $ext;
    var $errmsg = errmsg;
	var $userid;
	var $image;
	var $uptime = 0;
	var $adduserid = true;

    function remote($file, $savepath, $savename = '') {
		global $DT, $_userid;
		$this->file = $file;
		$this->userid = $_userid;
		$this->ext = file_ext($file);
		in_array($this->ext, array('jpg', 'jpeg', 'gif', 'png', 'bmp')) or $this->ext = 'jpg';
		$this->maxsize = $DT['uploadsize'] ? $DT['uploadsize']*1024 : 2048*1024;
		$this->savepath = $savepath;
		$this->savename = $savename;
    }

	function save() {
		include load('include.lang');
        if(!$this->is_allow()) return $this->_($L['upload_not_allow']);
        $this->set_savepath($this->savepath);
        $this->set_savename($this->savename);
        if(!is_writable(DT_ROOT.'/'.$this->savepath)) return $this->_($L['upload_unwritable']);
		if(@copy($this->file, DT_ROOT.'/'.$this->saveto)) {
			if(DT_CHMOD) @chmod(DT_ROOT.'/'.$this->saveto, DT_CHMOD);
			if(!@getimagesize(DT_ROOT.'/'.$this->saveto)) {
				file_del(DT_ROOT.'/'.$this->saveto);
				return $this->_($L['upload_bad']);
			}
			if($this->maxsize > 0 && filesize(DT_ROOT.'/'.$this->saveto) > $this->maxsize) {
				file_del(DT_ROOT.'/'.$this->saveto);
				return $this->_($L['upload_size_limit'].' ('.intval($this->maxsize/1024).'Kb)');
			}
			$this->image = 1;
			return true;
		} else {
			return $this->_($L['upload_failed']);
		}
	}

    function is_allow() {
		if(strlen($this->file) < 18 || strpos($this->file, '://') === false) return false;
		return true;
    }

    function set_savepath($savepath) {
		$savepath = str_replace("\\", "/", $savepath);
	    $savepath = substr($savepath, -1) == "/" ? $savepath : $savepath."/";
        $this->savepath = $savepath;
    }

    function set_savename($savename) {
		global $DT_TIME;
        if($savename) {
            $this->savename = $this->adduserid ? str_replace('.'.$this->ext, $this->userid.'.'.$this->ext, $savename) : $savename;
        } else {
			$this->uptime = $DT_TIME;
            $name = date('H-i-s', $this->uptime).'-'.rand(10, 99);
            $this->savename = $this->adduserid ? $name.'-'.$this->userid.'.'.$this->ext : $name.'.'.$this->ext;
        }
		$this->saveto = $this->savepath.$this->savename;		
        if(!$this->overwrite && is_file(DT_ROOT.'/'.$this->saveto)) {
			$i = 1;
			while($i) {
				$saveto = str_replace('.'.$this->ext, '('.$i.').'.$this->ext, $this->saveto);
				if(is_file(DT_ROOT.'/'.$saveto)) {
					$i++;
					continue; 
				} else {
					$this->saveto = $saveto; 
					break;
				}
			}
        }
    }
	
	function _($e) {
		$this->errmsg = $e;
		return false;
	}
}
?>