-- MySQL dump 10.13  Distrib 5.5.22, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: mgt_template1
-- ------------------------------------------------------
-- Server version	5.5.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_assert`
--

DROP TABLE IF EXISTS `admin_assert`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_assert` (
  `assert_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `assert_type` varchar(20) NOT NULL DEFAULT '',
  `assert_data` text,
  PRIMARY KEY (`assert_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='ACL Asserts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_assert`
--

LOCK TABLES `admin_assert` WRITE;
/*!40000 ALTER TABLE `admin_assert` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_assert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_role`
--

DROP TABLE IF EXISTS `admin_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tree_level` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `role_type` char(1) NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `role_name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`role_id`),
  KEY `parent_id` (`parent_id`,`sort_order`),
  KEY `tree_level` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='ACL Roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_role`
--

LOCK TABLES `admin_role` WRITE;
/*!40000 ALTER TABLE `admin_role` DISABLE KEYS */;
INSERT INTO `admin_role` VALUES (1,0,1,1,'G',0,'Administrators'),(5,1,2,0,'U',1,'William');
/*!40000 ALTER TABLE `admin_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_rule`
--

DROP TABLE IF EXISTS `admin_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `resource_id` varchar(255) NOT NULL DEFAULT '',
  `privileges` varchar(20) NOT NULL DEFAULT '',
  `assert_id` int(10) unsigned NOT NULL DEFAULT '0',
  `role_type` char(1) DEFAULT NULL,
  `permission` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`rule_id`),
  KEY `resource` (`resource_id`,`role_id`),
  KEY `role_id` (`role_id`,`resource_id`),
  CONSTRAINT `FK_admin_rule` FOREIGN KEY (`role_id`) REFERENCES `admin_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='ACL Rules';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_rule`
--

LOCK TABLES `admin_rule` WRITE;
/*!40000 ALTER TABLE `admin_rule` DISABLE KEYS */;
INSERT INTO `admin_rule` VALUES (1,1,'all','',0,'G','allow');
/*!40000 ALTER TABLE `admin_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user` (
  `user_id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(32) NOT NULL DEFAULT '',
  `lastname` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `username` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(40) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime DEFAULT NULL,
  `logdate` datetime DEFAULT NULL,
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `reload_acl_flag` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `extra` text,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `UNQ_ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES (1,'William','Wong','william.wong@ecczo.cn','admin','92363b5f704c9cf67d3469615fb96072:m2','2008-08-07 14:39:09','2012-07-12 04:10:31','2012-07-14 10:28:17',30,0,1,'a:1:{s:11:\"configState\";a:9:{s:7:\"web_url\";s:1:\"0\";s:7:\"web_seo\";s:1:\"0\";s:12:\"web_unsecure\";s:1:\"1\";s:10:\"web_secure\";s:1:\"0\";s:11:\"web_default\";s:1:\"0\";s:9:\"web_polls\";s:1:\"0\";s:10:\"web_cookie\";s:1:\"0\";s:11:\"web_session\";s:1:\"0\";s:24:\"web_browser_capabilities\";s:1:\"0\";}}');
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `severity` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `url` varchar(255) NOT NULL,
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_remove` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`notification_id`),
  KEY `IDX_SEVERITY` (`severity`),
  KEY `IDX_IS_READ` (`is_read`),
  KEY `IDX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2008-07-25 01:24:40','Magento 1.1 Production Version Now Available','We are thrilled to announce the availability of the production release of Magento 1.1. Read more about the release in the Magento Blog.','http://www.magentocommerce.com/blog/comments/magento-11-is-here-1/',0,0),(2,4,'2008-08-02 01:30:16','Updated iPhone Theme is now available','Updated iPhone theme for Magento 1.1 is now available on Magento Connect and for upgrade through your Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/updated-iphone-theme-for-magento-11-is-now-available/',0,0),(3,3,'2008-08-02 01:40:27','Magento version 1.1.2 is now available','Magento version 1.1.2 is now available for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-version-112-is-now-available/',0,0),(4,3,'2008-08-13 17:51:46','Magento version 1.1.3 is now available','Magento version 1.1.3 is now available','http://www.magentocommerce.com/blog/comments/magento-version-113-is-now-available/',0,0),(5,1,'2008-09-02 21:10:31','Magento Version 1.1.4 Security Update Now Available','Magento 1.1.4 Security Update Now Available. If you are using Magento version 1.1.x, we highly recommend upgrading to this version as soon as possible.','http://www.magentocommerce.com/blog/comments/magento-version-114-security-update/',0,0),(6,3,'2008-09-15 22:09:54','Magento version 1.1.5 Now Available','Magento version 1.1.5 Now Available.\n\nThis release includes many bug fixes, a new category manager and a new skin for the default Magento theme.','http://www.magentocommerce.com/blog/comments/magento-version-115-now-available/',0,0),(7,3,'2008-09-17 20:18:35','Magento version 1.1.6 Now Available','Magento version 1.1.6 Now Available.\n\nThis version includes bug fixes for Magento 1.1.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-116-now-available/',0,0),(8,4,'2008-11-07 23:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.','',0,0),(9,3,'2008-11-20 01:31:12','Magento version 1.1.7 Now Available','Magento version 1.1.7 Now Available.\n\nThis version includes over 350 issue resolutions for Magento 1.1.x that are listed in the release notes section, and new functionality that includes:\n\n-Google Website Optimizer integration\n-Google Base integration\n-Scheduled DB logs cleaning option','http://www.magentocommerce.com/blog/comments/magento-version-117-now-available/',0,0),(10,3,'2008-11-26 21:24:50','Magento Version 1.1.8 Now Available','Magento version 1.1.8 now available.\n\nThis version includes some issue resolutions for Magento 1.1.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-118-now-available/',0,0),(11,3,'2008-12-30 07:45:59','Magento version 1.2.0 is now available for download and upgrade','We are extremely happy to announce the availability of Magento version 1.2.0 for download and upgrade.\n\nThis version includes numerous issue resolutions for Magento version 1.1.x and some highly requested new features such as:\n\n    * Support for Downloadable/Digital Products. \n    * Added Layered Navigation to site search result page.\n    * Improved site search to utilize MySQL fulltext search\n    * Added support for fixed-taxes on product level.\n    * Upgraded Zend Framework to the latest stable version 1.7.2','http://www.magentocommerce.com/blog/comments/magento-version-120-is-now-available/',0,0),(12,2,'2008-12-30 21:59:22','Magento version 1.2.0.1 now available','Magento version 1.2.0.1 now available.This version includes some issue resolutions for Magento 1.2.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-1201-available/',0,0),(13,2,'2009-01-12 20:41:49','Magento version 1.2.0.2 now available','Magento version 1.2.0.2 is now available for download and upgrade. This version includes an issue resolutions for Magento version 1.2.0.x as listed in the release notes.','http://www.magentocommerce.com/blog/comments/magento-version-1202-now-available/',0,0),(14,3,'2009-01-24 00:25:56','Magento version 1.2.0.3 now available','Magento version 1.2.0.3 is now available for download and upgrade. This version includes issue resolutions for Magento version 1.2.0.x as listed in the release notes.','http://www.magentocommerce.com/blog/comments/magento-version-1203-now-available/',0,0),(15,3,'2009-02-02 21:57:00','Magento version 1.2.1 is now available for download and upgrade','We are happy to announce the availability of Magento version 1.2.1 for download and upgrade.\n\nThis version includes some issue resolutions for Magento version 1.2.x. A full list of items included in this release can be found on the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-121-now-available/',0,0),(16,3,'2009-02-24 00:45:47','Magento version 1.2.1.1 now available','Magento version 1.2.1.1 now available.This version includes some issue resolutions for Magento 1.2.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-1211-now-available/',0,0),(17,3,'2009-02-27 01:39:24','CSRF Attack Prevention','We have just posted a blog entry about a hypothetical CSRF attack on a Magento admin panel. Please read the post to find out if your Magento installation is at risk at http://www.magentocommerce.com/blog/comments/csrf-vulnerabilities-in-web-application-and-how-to-avoid-them-in-magento/','http://www.magentocommerce.com/blog/comments/csrf-vulnerabilities-in-web-application-and-how-to-avoid-them-in-magento/',0,0),(18,2,'2009-03-03 23:03:58','Magento version 1.2.1.2 now available','Magento version 1.2.1.2 is now available for download and upgrade.\nThis version includes some updates to improve admin security as described in the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-1212-now-available/',0,0),(19,3,'2009-03-31 02:22:40','Magento version 1.3.0 now available','Magento version 1.3.0 is now available for download and upgrade. This version includes numerous issue resolutions for Magento version 1.2.x and new features as described on the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-130-is-now-available/',0,0),(20,3,'2009-04-18 04:06:02','Magento version 1.3.1 now available','Magento version 1.3.1 is now available for download and upgrade. This version includes some issue resolutions for Magento version 1.3.x and new features such as Checkout By Amazon and Amazon Flexible Payment. To see a full list of updates please check the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-131-now-available/',0,0),(21,3,'2009-05-19 22:31:21','Magento version 1.3.1.1 now available','Magento version 1.3.1.1 is now available for download and upgrade. This version includes some issue resolutions for Magento version 1.3.x and a security update for Magento installations that run on multiple domains or sub-domains. If you are running Magento with multiple domains or sub-domains we highly recommend upgrading to this version.','http://www.magentocommerce.com/blog/comments/magento-version-1311-now-available/',0,0),(22,3,'2009-05-29 22:54:06','Magento version 1.3.2 now available','This version includes some improvements and issue resolutions for version 1.3.x that are listed on the release notes page. also included is a Beta version of the Compile module.','http://www.magentocommerce.com/blog/comments/magento-version-132-now-available/',0,0),(23,3,'2009-06-01 19:32:52','Magento version 1.3.2.1 now available','Magento version 1.3.2.1 now available for download and upgrade.\n\nThis release solves an issue for users running Magento with PHP 5.2.0, and changes to index.php to support the new Compiler Module.','http://www.magentocommerce.com/blog/comments/magento-version-1321-now-available/',0,0),(24,3,'2009-07-02 01:21:44','Magento version 1.3.2.2 now available','Magento version 1.3.2.2 is now available for download and upgrade.\n\nThis release includes issue resolution for Magento version 1.3.x. To see a full list of changes please visit the release notes page http://www.magentocommerce.com/download/release_notes.','http://www.magentocommerce.com/blog/comments/magento-version-1322-now-available/',0,0),(25,3,'2009-07-23 06:48:54','Magento version 1.3.2.3 now available','Magento version 1.3.2.3 is now available for download and upgrade.\n\nThis release includes issue resolution for Magento version 1.3.x. We recommend to upgrade to this version if PayPal payment modules are in use. To see a full list of changes please visit the release notes page http://www.magentocommerce.com/download/release_notes.','http://www.magentocommerce.com/blog/comments/magento-version-1323-now-available/',0,0),(26,4,'2009-08-28 18:26:28','PayPal is updating Payflow Pro and Website Payments Pro (Payflow Edition) UK.','If you are using Payflow Pro and/or Website Payments Pro (Payflow Edition) UK.  payment methods, you will need to update the URL‘s in your Magento Administrator Panel in order to process transactions after September 1, 2009. Full details are available here: http://www.magentocommerce.com/wiki/paypal_payflow_changes','http://www.magentocommerce.com/wiki/paypal_payflow_changes',0,0),(27,2,'2009-09-23 20:16:49','Magento Version 1.3.2.4 Security Update','Magento Version 1.3.2.4 is now available. This version includes a security updates for Magento 1.3.x that solves possible XSS vulnerability issue on customer registration page and is available through SVN, Download Page and through the Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/magento-version-1324-security-update/',0,0),(28,4,'2009-09-25 14:57:54','Magento Preview Version 1.4.0.0-alpha2 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-alpha2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-alpha2-now-available/',0,0),(29,4,'2009-10-07 00:55:40','Magento Preview Version 1.4.0.0-alpha3 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-alpha3 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-alpha3-now-available/',0,0),(30,4,'2009-12-08 23:30:36','Magento Preview Version 1.4.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-beta1-now-available/',0,0),(31,4,'2009-12-31 09:22:12','Magento Preview Version 1.4.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-rc1-now-available/',0,0),(32,4,'2010-02-13 03:39:53','Magento CE Version 1.4.0.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.0.0 Stable for upgrade and download.','http://bit.ly/c53rpK',0,0),(33,3,'2010-02-20 02:39:36','Magento CE Version 1.4.0.1 Stable is now available','Magento CE 1.4.0.1 Stable is now available for upgrade and download.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1401-stable-now-available/',0,0),(34,4,'2010-04-23 20:09:03','Magento Version CE 1.3.3.0 Stable - Now Available With Support for 3-D Secure','Based on community requests, we are excited to announce the release of Magento CE 1.3.3.0-Stable with support for 3-D Secure. This release is intended for Magento merchants using version 1.3.x, who want to add support for 3-D Secure.','http://www.magentocommerce.com/blog/comments/magento-version-ce-1330-stable-now-available-with-support-for-3-d-secure/',0,0),(35,4,'2010-05-31 17:20:21','Announcing the Launch of Magento Mobile','The Magento team is pleased to announce the launch of Magento mobile, a new product that will allow Magento merchants to easily create branded, native mobile storefront applications that are deeply integrated with Magento’s market-leading eCommerce platform. The product includes a new administrative manager, a native iPhone app that is fully customizable, and a service where Magento manages the submission and maintenance process for the iTunes App Store.\n\nLearn more by visiting the Magento mobile product page and sign-up to be the first to launch a native mobile commerce app, fully integrated with Magento.','http://www.magentocommerce.com/product/mobile',0,0),(36,4,'2010-06-10 20:08:08','Magento CE Version 1.4.1.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.1.0 Stable for upgrade and download. Some of the highlights of this release include: Enhanced PayPal integration (more info to follow), Change of Database structure of the Sales module to no longer use EAV, and much more.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1410-stable-now-available/',0,0),(37,4,'2010-07-26 21:37:34','Magento CE Version 1.4.1.1 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.1.1 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-now-available/',0,0),(38,4,'2010-07-28 05:12:12','Magento CE Version 1.4.2.0-beta1 Preview Release Now Available','This release gives a preview of the new Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-beta1-now-available/',0,0),(39,4,'2010-07-28 20:15:01','Magento CE Version 1.4.1.1 Patch Available','As some users experienced issues with upgrading to CE 1.4.1.1 through PEAR channels we provided a patch for it that is available on our blog http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-patch/','http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-patch/',0,0),(40,4,'2010-11-08 21:52:06','Magento CE Version 1.4.2.0-RC1 Preview Release Now Available','We are happy to announce the availability of Magento Preview Version 1.4.2.0-RC1 for download.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-rc1-now-available/',0,0),(41,4,'2010-12-02 20:33:00','Magento CE Version 1.4.2.0-RC2 Preview Release Now Available','We are happy to announce the availability of Magento Preview Version 1.4.2.0-RC2 for download.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-rc2-now-available/',0,0),(42,4,'2010-12-08 22:29:55','Magento CE Version 1.4.2.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.2.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1420-stable-now-available/',0,0),(43,4,'2010-12-17 23:23:55','Magento Preview Version CE 1.5.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-alpha1-now-available/',0,0),(44,4,'2010-12-29 23:51:08','Magento Preview Version CE 1.5.0.0-alpha2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-alpha2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-alpha2-now-available/',0,0),(45,4,'2011-01-14 00:35:36','Magento Preview Version CE 1.5.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-beta1-now-available/',0,0),(46,4,'2011-01-21 21:19:09','Magento Preview Version CE 1.5.0.0-beta2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-beta2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-beta2-now-available/',0,0),(47,4,'2011-01-27 21:27:57','Magento Preview Version CE 1.5.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-rc1-now-available/',0,0),(48,4,'2011-02-03 21:56:33','Magento Preview Version CE 1.5.0.0-rc2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-rc2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-rc2-now-available/',0,0),(49,4,'2011-02-08 19:43:23','Magento CE Version 1.5.0.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.5.0.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-community-professional-and-enterprise-editions-releases-now-availab/',0,0),(50,4,'2011-02-09 23:42:57','Magento CE 1.5.0.1 stable Now Available','We are excited to announce the availability of Magento CE Version 1.5.0.1 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-1501-stable-now-available/',0,0),(51,3,'2011-03-04 14:34:15','iPhone Theme v.1.2 by aheadWorks has been released!','The iPhone Theme is already compatible with the Android OS as well as iOS 4.2. Since the 1.2 version released today, it is compatible with the BlackBerry OS as well.','http://blog.aheadworks.com/2011/03/the-iphone-theme-for-magento-%E2%80%93-now-with-blackberry-compatibility/',0,0),(52,3,'2011-03-01 15:00:36','New Extension – Featured Products 3 by aheadWorks has been released!','The Featured Products 3 extension is an effective cross-selling and up-selling tool which will dramatically boost your sales by encouraging your customers to spend more.','http://blog.aheadworks.com/2011/02/increase-your-cross-selling-and-up-selling-with-featured-products-3/',0,0),(53,3,'2011-02-16 15:27:11','Video Module v.1.1 by aheadWorks has been released!','Today we release the 1.1 version of the Video Module extension compatible with Magento Enterprise Edition and Magento Community Edition 1.4*.','http://blog.aheadworks.com/2011/02/embed-video-on-the-product-pages-of-your-magento-store/',0,0),(54,3,'2011-02-10 11:10:52','Product Preview Pro v.1.0 by aheadWorks has been released!','Let your customers preview your products exactly at the category page!','http://blog.aheadworks.com/2011/02/let-your-customers-preview-your-products-exactly-at-the-category-page/',0,0),(55,3,'2011-02-02 15:30:29','Automatic Product Callouts v.1.1 by aheadWorks has been released!','Since this new release, our Magento module works faster as the source code was optimized and the cron run was speeded up.','http://blog.aheadworks.com/2011/02/organize-your-top-product-sets-in-blocks-anywhere-on-your-website/',0,0),(56,3,'2011-02-01 16:05:33','iPhone Theme v.1.1.1 by aheadWorks has been released!','With the 1.1.1 version of the iPhone Theme, browsing in your store has become more convenient and faster. ','http://blog.aheadworks.com/2011/02/mobile-shopping-is-on-the-rise-%E2%80%93-do-you-keep-abreast/',0,0),(57,3,'2011-01-31 16:50:26','Help Desk Ultimate v.2.6.5 by aheadWorks has been released!','Today we release the 2.6.5 version of Help Desk Ultimate, which makes the work with this Magento extension easier, faster, and more efficient for your customer support team.','http://blog.aheadworks.com/2011/01/how-can-you-make-your-customers-feel-valued-wanted-and-loved/',0,0),(58,3,'2011-01-12 15:10:02','Advanced Newsletter v.2.0 by aheadWorks has released!','Advanced Newsletter has undergone serious enhancement and got a bulk of new astonishing features, including MailChimp -> Magento synchronization, ability to send test newsletter, newsletter segments at Create an Account and My Account pages, and much more else! ','http://blog.aheadworks.com/2011/01/reap-the-highest-roi-and-reach-the-masses-through-newsletter-marketing/',0,0),(59,3,'2010-12-27 16:57:08','New Extension - Sociable by aheadWorks has been released!','The Sociable extension is a perfect solution for social bookmarking your products and store pages.','http://blog.aheadworks.com/2010/12/social-bookmarking-for-speedy-sales-%E2%80%93-welcome-brand-new-sociable-extension/',0,0),(60,3,'2010-12-23 17:04:14','New Extension – Order Tags by aheadWorks has been released!','The Order Tags extension is a perfect solution for those who want to organize, prioritize, and filter orders by their attributes. Our Magento module gives store administrators an ability to set a tag (icon) for each order manually or specify conditions for their automatic assignment.','http://blog.aheadworks.com/2010/12/faster-orders-management-with-brand-new-order-tags-extension/',0,0),(61,3,'2012-05-03 07:32:32','Featured Products 3 v.3.3 by aheadWorks has been released!','Promote products effectively with the updated version of the Featured Products 3 Magento extension.','http://blog.aheadworks.com/2012/05/promote-products-effectively/?utm_source=feed&utm_medium=zefeed&utm_campaign=FP3_3_3',0,0),(62,3,'2012-04-27 08:00:35','Subscriptions and Recurring Payments v.1.7, Automatic Product Callouts v.1.2, and Product Updates Notifications v.1.2 by aheadWorks have been released!','Get New Opportunities with Our Extensions Updates!','http://blog.aheadworks.com/2012/04/get-new-opportunities-with-our-extensions-updates/?utm_source=feed&utm_medium=zefeed&utm_campaign=SARP_1_7_APC_1_2_PUN_1_2',0,0),(63,3,'2012-04-18 08:27:43','Custom Stock Display v.1.1 by aheadWorks has been released!','We released a new version of Magento module that will help avoid constant questions on the stock status.','http://blog.aheadworks.com/2012/04/keep-your-customers-informed/?utm_source=feed&utm_medium=zefeed&utm_campaign=CSD_1_1',0,0),(64,3,'2012-04-06 08:01:52','Advanced Search v.1.2 and Knowledge Base v.1.2 by aheadWorks have been released!','We released new versions of Magento modules that will help show careful attitude to your clients.','http://blog.aheadworks.com/2012/04/caring-attitude-is-the-key-to-long-term-client-relationship/?utm_source=feed&utm_medium=zefeed&utm_campaign=AS_1_2_KB_1_2',0,0),(65,3,'2012-03-30 08:19:57','Easy Categories v.1.1 and Image Slider v.1.3 by aheadWorks have been released!','We released new versions of Magento modules that will be helpful in making your website appealing for your clients.','http://blog.aheadworks.com/2012/03/images-are-the-best-way-of-grabbing-attention/?utm_source=feed&utm_medium=zefeed&utm_campaign=EC_1_1_IS_1_3',0,0),(66,3,'2012-03-23 09:00:20','Advanced Reports v.2.3 and Additional Units by aheadWorks have been released!','The new version of Advanced Reports is compatible with Magento CE 1.6.2.0. Don\'t forget to update additional units as well.','http://blog.aheadworks.com/2012/03/get-detailed-and-accurate-sales-information-easily/?utm_source=feed&utm_medium=zefeed&utm_campaign=AR_2_3_Units',0,0),(67,3,'2012-03-20 14:25:50','iPhone Theme v.1.4.1 by aheadWorks has been released','The new version detects iPad automatically that means the desktop version of your online store will be displayed. ','http://blog.aheadworks.com/2012/03/be-mobile-and-get-more-potential-traffic/?utm_source=feed&utm_medium=zefeed&utm_campaign=iPhone_Theme_1_4_1',0,0),(68,3,'2012-03-14 12:55:57','Z-Blocks 2.2.6, Market Segmentation Suite 1.2.1, Follow Up Email 3.4, and Advanced Newsletter 2.2 by aheadWorks have been released!','Today we release the Magento extensions that were modified for you to get the best results in your target marketing. With their help, your promotions and sales become easier and more cost-effective.','http://blog.aheadworks.com/2012/03/divide-and-conquer-with-the-newest-versions-of-our-magento-extensions/?utm_source=feed&utm_medium=zefeed&utm_campaign=FUE_34_MSS_121_ZB_226_AN_22',0,0),(69,3,'2012-03-06 14:10:58','Advanced Reviews 2.2.1 and Product Questions 1.4.4 by aheadWorks have been released!','Listen to your customers and show interest in their opinion with powerful extensions from aheadWorks.','http://blog.aheadworks.com/2012/03/listen-to-your-customers-show-interest-in-their-opinion/?utm_source=feed&utm_medium=zefeed&utm_campaign=AR_2_2_1_PQ_1_4_4',0,0),(70,3,'2012-03-01 14:05:24','Product Preview Pro 1.1 and Home Tabs Pro 1.2.1 by aheadWorks have been released!','Broaden standard Magento possibilities and enlarge your store usability with Product Preview Pro 1.1 and Home Tabs Pro 1.2.1','http://blog.aheadworks.com/2012/03/welcome-the-latest-versions-of-home-tabs-pro-and-product-preview-pro/?utm_source=feed&utm_medium=zefeed&utm_campaign=PPP_1_1_HT_1_2_1',0,0),(71,4,'2010-10-12 04:13:25','Magento Mobile is now live!','Magento Mobile is now live! Signup today to have your own native iPhone mobile-shopping app in iTunes for the holiday season! Learn more at http://www.magentomobile.com/','http://www.magentomobile.com/',0,0),(72,4,'2011-03-19 00:15:45','Magento CE 1.5.1.0-beta1 Now Available','We are happy to announce the availability of Magento Preview Version CE 1.5.1.0-beta1 for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1510-beta1-now-available/',0,0),(73,4,'2011-03-31 22:43:02','Magento CE 1.5.1.0-rc1 Now Available','We are happy to announce the availability of Magento Preview Version CE 1.5.1.0-rc1 for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1510-rc1-now-available/',0,0),(74,4,'2011-04-26 23:21:07','Magento CE 1.5.1.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.5.1.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1510-stable-now-available/',0,0),(75,4,'2011-05-26 23:33:23','Magento Preview Version CE 1.6.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-alpha1-now-available/',0,0),(76,4,'2011-06-15 22:12:08','Magento Preview Version CE 1.6.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-beta1for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-beta1-now-available/',0,0),(77,4,'2011-06-30 23:03:58','Magento Preview Version CE 1.6.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-rc1-now-available/',0,0),(78,4,'2011-07-11 23:07:39','Magento Preview Version CE 1.6.0.0-rc2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-rc2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-rc2-now-available/',0,0),(79,4,'2011-08-19 21:58:31','Magento CE 1.6.0.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.0.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1600-stable-now-available/',0,0),(80,4,'2011-09-17 05:31:26','Magento Preview Version CE 1.6.1.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.1.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1610-beta1-now-available/',0,0),(81,4,'2011-09-29 19:44:10','Magento Preview Version CE 1.6.1.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.1.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1610-rc1-now-available/',0,0),(82,4,'2011-10-19 21:50:05','Magento CE 1.6.1.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.1.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1610-stable-now-available/',0,0),(83,4,'2011-12-30 22:39:35','Magento Preview Version CE 1.7.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.7.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-alpha1-now-available/',0,0),(84,4,'2012-01-11 22:24:20','Magento CE 1.6.2.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.2.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1620-stable-now-available/',0,0),(85,4,'2012-03-03 00:54:12','Magento Preview Version CE 1.7.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.7.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-beta1-now-available/',0,0),(86,4,'2012-04-23 14:02:40','Magento Community Preview Version CE 1.7.0.0-RC1 has been released!','Learn more about the exciting new features and updates in this release and how you can take it for a test drive. As this is a preview version, we need to stress that it\'s likely unstable and that we DON\'T recommend that you use it in any production environment just yet.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-rc1-now-available/',0,0),(87,4,'2012-05-11 09:46:54','Magento Community 1.7 and Magento Enterprise 1.12 now available!','Learn more about the exciting new features and updates in these releases.','http://www.magentocommerce.com/blog/comments/magento-enterprise-112-and-community-17-now-available/',0,0),(88,3,'2012-06-02 08:03:49','AJAX Cart Pro v.2.5 by aheadWorks has been released!','Provide convenience for your clients with the updated version of the AJAX Cart Pro Magento extension.','http://blog.aheadworks.com/2012/06/provide-convenience-for-your-clients/?utm_source=feed&utm_medium=zefeed&utm_campaign=ACP_2_5',0,0),(89,4,'2012-06-20 18:54:07','Magento Community Edition 1.7.0.1 now available! ','We have just released an updated version of Magento Community Edition, version 1.7.0.1. This update delivers new, minor functionality and fixes for some potential security vulnerabilities.','http://www.magentocommerce.com/blog/comments/magento-community-edition-1701-released/',0,0),(90,3,'2012-06-08 07:56:20','Subscriptions and Recurring Payments v.1.8 by aheadWorks has been released!','The new version of the Subscriptions and Recurring Payments extension with considerable improvements gives new opportunities.','http://blog.aheadworks.com/2012/06/new-payment-methods-support-in-subscriptions-and-recurring-payments/?utm_source=feed&utm_medium=zefeed&utm_campaign=SARP_1_8',0,0),(91,4,'2012-07-05 19:21:43','Important Security Update - Zend Platform Vulnerability','We have recently learned of a serious vulnerability in the Zend platform on which Magento is built. Learn more and access a patch that addresses this issue. ','http://www.magentocommerce.com/blog/comments/important-security-update-zend-platform-vulnerability/',0,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_assert`
--

DROP TABLE IF EXISTS `api_assert`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_assert` (
  `assert_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `assert_type` varchar(20) NOT NULL DEFAULT '',
  `assert_data` text,
  PRIMARY KEY (`assert_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api ACL Asserts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_assert`
--

LOCK TABLES `api_assert` WRITE;
/*!40000 ALTER TABLE `api_assert` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_assert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_role`
--

DROP TABLE IF EXISTS `api_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tree_level` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `role_type` char(1) NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `role_name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`role_id`),
  KEY `parent_id` (`parent_id`,`sort_order`),
  KEY `tree_level` (`tree_level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api ACL Roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_role`
--

LOCK TABLES `api_role` WRITE;
/*!40000 ALTER TABLE `api_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_rule`
--

DROP TABLE IF EXISTS `api_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `resource_id` varchar(255) NOT NULL DEFAULT '',
  `privileges` varchar(20) NOT NULL DEFAULT '',
  `assert_id` int(10) unsigned NOT NULL DEFAULT '0',
  `role_type` char(1) DEFAULT NULL,
  `permission` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`rule_id`),
  KEY `resource` (`resource_id`,`role_id`),
  KEY `role_id` (`role_id`,`resource_id`),
  CONSTRAINT `FK_api_rule` FOREIGN KEY (`role_id`) REFERENCES `api_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api ACL Rules';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_rule`
--

LOCK TABLES `api_rule` WRITE;
/*!40000 ALTER TABLE `api_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_session`
--

DROP TABLE IF EXISTS `api_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_session` (
  `user_id` mediumint(9) unsigned NOT NULL,
  `logdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sessid` varchar(40) NOT NULL DEFAULT '',
  KEY `API_SESSION_USER` (`user_id`),
  KEY `API_SESSION_SESSID` (`sessid`),
  CONSTRAINT `FK_API_SESSION_USER` FOREIGN KEY (`user_id`) REFERENCES `api_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api Sessions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_session`
--

LOCK TABLES `api_session` WRITE;
/*!40000 ALTER TABLE `api_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_user`
--

DROP TABLE IF EXISTS `api_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_user` (
  `user_id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(32) NOT NULL DEFAULT '',
  `lastname` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `username` varchar(40) NOT NULL DEFAULT '',
  `api_key` varchar(40) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime DEFAULT NULL,
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `reload_acl_flag` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Api Users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_user`
--

LOCK TABLES `api_user` WRITE;
/*!40000 ALTER TABLE `api_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog`
--

DROP TABLE IF EXISTS `aw_blog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog` (
  `post_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `post_content` text NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '0',
  `created_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `user` varchar(255) NOT NULL DEFAULT '',
  `update_user` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text NOT NULL,
  `meta_description` text NOT NULL,
  `comments` tinyint(11) NOT NULL,
  `tags` text NOT NULL,
  `short_content` text NOT NULL,
  PRIMARY KEY (`post_id`),
  UNIQUE KEY `identifier` (`identifier`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog`
--

LOCK TABLES `aw_blog` WRITE;
/*!40000 ALTER TABLE `aw_blog` DISABLE KEYS */;
INSERT INTO `aw_blog` VALUES (1,'Hello World','Welcome to Magento Blog by aheadWorks Co. This is your first post. Edit or delete it, then start blogging!',1,'2011-03-08 19:07:17','2011-03-08 19:07:17','Hello','Joe Blogs','Joe Blogs','Keywords','Description',0,'',''),(2,'测试文章标题','测试文章，内容还没有上传',1,'2011-03-08 12:12:10','2012-06-12 09:12:45','lorem-lpsum','Rong Zhou','Rong Zhou','','',0,'','测试文章，内容还没有上传');
/*!40000 ALTER TABLE `aw_blog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_cat`
--

DROP TABLE IF EXISTS `aw_blog_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_cat` (
  `cat_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `sort_order` tinyint(6) NOT NULL,
  `meta_keywords` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_cat`
--

LOCK TABLES `aw_blog_cat` WRITE;
/*!40000 ALTER TABLE `aw_blog_cat` DISABLE KEYS */;
INSERT INTO `aw_blog_cat` VALUES (1,'行业动态','news',0,'','');
/*!40000 ALTER TABLE `aw_blog_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_cat_store`
--

DROP TABLE IF EXISTS `aw_blog_cat_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_cat_store` (
  `cat_id` smallint(6) unsigned DEFAULT NULL,
  `store_id` smallint(6) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_cat_store`
--

LOCK TABLES `aw_blog_cat_store` WRITE;
/*!40000 ALTER TABLE `aw_blog_cat_store` DISABLE KEYS */;
INSERT INTO `aw_blog_cat_store` VALUES (1,1);
/*!40000 ALTER TABLE `aw_blog_cat_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_comment`
--

DROP TABLE IF EXISTS `aw_blog_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_comment` (
  `comment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` smallint(11) NOT NULL DEFAULT '0',
  `comment` text NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '0',
  `created_time` datetime DEFAULT NULL,
  `user` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_comment`
--

LOCK TABLES `aw_blog_comment` WRITE;
/*!40000 ALTER TABLE `aw_blog_comment` DISABLE KEYS */;
INSERT INTO `aw_blog_comment` VALUES (1,1,'This is the first comment. It can be edited, deleted or set to unapproved so it is not displayed. This can be done in the admin panel.',2,'2011-03-08 19:07:17','Joe Blogs','joe@blogs.com');
/*!40000 ALTER TABLE `aw_blog_comment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_post_cat`
--

DROP TABLE IF EXISTS `aw_blog_post_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_post_cat` (
  `cat_id` smallint(6) unsigned DEFAULT NULL,
  `post_id` smallint(6) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_post_cat`
--

LOCK TABLES `aw_blog_post_cat` WRITE;
/*!40000 ALTER TABLE `aw_blog_post_cat` DISABLE KEYS */;
INSERT INTO `aw_blog_post_cat` VALUES (1,2);
/*!40000 ALTER TABLE `aw_blog_post_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_store`
--

DROP TABLE IF EXISTS `aw_blog_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_store` (
  `post_id` smallint(6) unsigned DEFAULT NULL,
  `store_id` smallint(6) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_store`
--

LOCK TABLES `aw_blog_store` WRITE;
/*!40000 ALTER TABLE `aw_blog_store` DISABLE KEYS */;
INSERT INTO `aw_blog_store` VALUES (2,0);
/*!40000 ALTER TABLE `aw_blog_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_blog_tags`
--

DROP TABLE IF EXISTS `aw_blog_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_blog_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL,
  `tag_count` int(11) NOT NULL DEFAULT '0',
  `store_id` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`,`tag_count`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_blog_tags`
--

LOCK TABLES `aw_blog_tags` WRITE;
/*!40000 ALTER TABLE `aw_blog_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `aw_blog_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aw_core_logger`
--

DROP TABLE IF EXISTS `aw_core_logger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aw_core_logger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` mediumtext NOT NULL,
  `module` varchar(255) NOT NULL,
  `object` varchar(255) NOT NULL,
  `severity` varchar(255) NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT '1',
  `custom_field_1` varchar(255) NOT NULL,
  `custom_field_2` varchar(255) NOT NULL,
  `custom_field_3` varchar(255) NOT NULL,
  `custom_field_4` varchar(255) NOT NULL,
  `file` varchar(255) NOT NULL,
  `line` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `code` varchar(16) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `severity` (`severity`),
  KEY `visibility` (`visibility`),
  KEY `custom_field_1` (`custom_field_1`),
  KEY `custom_field_2` (`custom_field_2`),
  KEY `custom_field_3` (`custom_field_3`),
  KEY `date` (`date`),
  KEY `code` (`code`),
  KEY `custom_field_4` (`custom_field_4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aw_core_logger`
--

LOCK TABLES `aw_core_logger` WRITE;
/*!40000 ALTER TABLE `aw_core_logger` DISABLE KEYS */;
/*!40000 ALTER TABLE `aw_core_logger` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_categs_index_idx`
--

DROP TABLE IF EXISTS `catalog_category_anc_categs_index_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_categs_index_idx` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  KEY `IDX_CATEGORY` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_categs_index_idx`
--

LOCK TABLES `catalog_category_anc_categs_index_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_categs_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_anc_categs_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_categs_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  KEY `IDX_CATEGORY` (`category_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_categs_index_tmp`
--

LOCK TABLES `catalog_category_anc_categs_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_categs_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_products_index_idx`
--

DROP TABLE IF EXISTS `catalog_category_anc_products_index_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_products_index_idx` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_products_index_idx`
--

LOCK TABLES `catalog_category_anc_products_index_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_anc_products_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_anc_products_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_anc_products_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_anc_products_index_tmp`
--

LOCK TABLES `catalog_category_anc_products_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_anc_products_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(8) unsigned NOT NULL DEFAULT '0',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `children_count` int(11) NOT NULL,
  PRIMARY KEY (`entity_id`),
  KEY `IDX_LEVEL` (`level`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8 COMMENT='Category Entityies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES (1,9,12,0,'2007-07-20 18:46:08','2007-08-07 09:50:15','1',1,0,154),(3,9,12,1,'2007-08-22 15:54:41','2012-06-22 03:58:22','1/3',3,1,153),(20,9,12,3,'2007-08-25 13:14:09','2008-08-07 23:58:57','1/3/20',20,2,0),(35,9,12,3,'2011-03-08 11:35:58','2012-06-12 06:26:42','1/3/35',21,2,0),(36,9,12,3,'2012-06-08 06:40:54','2012-06-30 01:39:30','1/3/36',22,2,0),(37,9,12,3,'2012-06-08 06:50:14','2012-06-30 02:12:42','1/3/37',23,2,0),(38,9,12,3,'2012-06-08 07:02:28','2012-06-30 01:42:03','1/3/38',24,2,0),(39,9,12,3,'2012-06-08 07:03:42','2012-06-30 01:42:23','1/3/39',25,2,0),(40,9,12,3,'2012-06-08 07:06:34','2012-06-26 02:40:56','1/3/40',26,2,4),(41,9,12,40,'2012-06-08 07:12:36','2012-06-08 07:12:36','1/3/40/41',1,3,0),(42,9,12,40,'2012-06-08 07:13:32','2012-06-08 07:13:32','1/3/40/42',2,3,0),(43,9,12,40,'2012-06-08 07:16:01','2012-06-08 07:16:01','1/3/40/43',3,3,0),(44,9,12,40,'2012-06-08 07:17:22','2012-06-08 07:17:22','1/3/40/44',4,3,0),(45,9,12,3,'2012-06-08 07:18:06','2012-06-18 06:17:32','1/3/45',27,2,4),(46,9,12,45,'2012-06-08 07:19:06','2012-06-08 07:19:06','1/3/45/46',1,3,0),(47,9,12,45,'2012-06-08 07:20:00','2012-06-08 07:20:00','1/3/45/47',2,3,0),(48,9,12,45,'2012-06-08 07:20:48','2012-06-08 07:20:48','1/3/45/48',3,3,0),(49,9,12,45,'2012-06-08 07:21:47','2012-06-08 07:21:47','1/3/45/49',4,3,0),(50,9,12,3,'2012-06-08 07:22:45','2012-06-18 06:17:40','1/3/50',28,2,5),(51,9,12,50,'2012-06-08 07:23:46','2012-06-08 07:23:46','1/3/50/51',1,3,0),(52,9,12,50,'2012-06-08 07:25:28','2012-06-08 07:25:28','1/3/50/52',2,3,0),(53,9,12,50,'2012-06-08 07:26:24','2012-06-08 07:26:24','1/3/50/53',3,3,0),(54,9,12,50,'2012-06-08 07:28:30','2012-06-08 07:28:30','1/3/50/54',4,3,0),(55,9,12,50,'2012-06-08 07:30:55','2012-06-08 07:30:55','1/3/50/55',5,3,0),(56,9,12,3,'2012-06-08 07:34:57','2012-06-12 11:00:08','1/3/56',29,2,10),(57,9,12,56,'2012-06-08 07:36:31','2012-06-08 07:36:31','1/3/56/57',1,3,0),(58,9,12,56,'2012-06-08 07:37:08','2012-06-08 07:37:08','1/3/56/58',2,3,0),(59,9,12,56,'2012-06-08 07:37:42','2012-06-08 07:37:42','1/3/56/59',3,3,0),(60,9,12,56,'2012-06-08 07:38:13','2012-06-08 07:38:13','1/3/56/60',4,3,0),(61,9,12,56,'2012-06-08 07:39:32','2012-06-08 07:39:32','1/3/56/61',5,3,0),(62,9,12,56,'2012-06-08 07:40:00','2012-06-08 07:40:00','1/3/56/62',6,3,0),(63,9,12,56,'2012-06-08 07:41:58','2012-06-08 07:41:58','1/3/56/63',7,3,0),(64,9,12,56,'2012-06-08 07:42:25','2012-06-08 07:42:25','1/3/56/64',8,3,0),(65,9,12,56,'2012-06-08 07:42:56','2012-06-08 07:42:56','1/3/56/65',9,3,0),(66,9,12,56,'2012-06-08 07:44:42','2012-06-08 07:44:42','1/3/56/66',10,3,0),(67,9,12,3,'2012-06-08 07:47:35','2012-06-18 06:17:48','1/3/67',30,2,4),(68,9,12,67,'2012-06-08 07:48:13','2012-06-08 07:48:13','1/3/67/68',1,3,0),(69,9,12,67,'2012-06-08 07:50:35','2012-06-08 07:50:35','1/3/67/69',2,3,0),(70,9,12,67,'2012-06-08 07:51:31','2012-06-08 07:51:31','1/3/67/70',3,3,0),(71,9,12,67,'2012-06-08 07:53:16','2012-06-08 07:53:16','1/3/67/71',4,3,0),(72,9,12,3,'2012-06-08 07:53:59','2012-06-18 06:17:58','1/3/72',31,2,5),(73,9,12,72,'2012-06-08 07:54:45','2012-06-08 07:54:45','1/3/72/73',1,3,0),(74,9,12,72,'2012-06-08 07:55:24','2012-06-08 07:55:24','1/3/72/74',2,3,0),(75,9,12,72,'2012-06-08 07:56:17','2012-06-08 07:56:17','1/3/72/75',3,3,0),(76,9,12,72,'2012-06-08 07:57:18','2012-06-08 07:57:18','1/3/72/76',4,3,0),(77,9,12,72,'2012-06-08 07:57:50','2012-06-08 07:58:10','1/3/72/77',5,3,0),(78,9,12,3,'2012-06-08 07:58:50','2012-06-18 06:18:07','1/3/78',32,2,11),(79,9,12,78,'2012-06-08 08:02:49','2012-06-08 08:02:49','1/3/78/79',1,3,0),(80,9,12,78,'2012-06-08 08:04:11','2012-06-08 08:04:11','1/3/78/80',2,3,0),(81,9,12,78,'2012-06-08 08:05:08','2012-06-08 08:05:08','1/3/78/81',3,3,0),(82,9,12,78,'2012-06-08 08:07:56','2012-06-08 08:07:56','1/3/78/82',4,3,0),(83,9,12,78,'2012-06-08 08:08:36','2012-06-08 08:08:36','1/3/78/83',5,3,0),(84,9,12,78,'2012-06-08 08:09:18','2012-06-08 08:09:18','1/3/78/84',6,3,0),(85,9,12,78,'2012-06-08 08:10:11','2012-06-08 08:10:11','1/3/78/85',7,3,0),(86,9,12,78,'2012-06-08 08:10:58','2012-06-08 08:10:58','1/3/78/86',8,3,0),(87,9,12,78,'2012-06-08 08:11:28','2012-06-08 08:11:28','1/3/78/87',9,3,0),(88,9,12,78,'2012-06-08 08:15:53','2012-06-08 08:16:01','1/3/78/88',10,3,0),(89,9,12,78,'2012-06-08 08:16:32','2012-06-08 08:16:32','1/3/78/89',11,3,0),(90,9,12,3,'2012-06-08 08:18:11','2012-06-18 06:18:15','1/3/90',33,2,5),(91,9,12,90,'2012-06-08 08:18:50','2012-06-08 08:18:50','1/3/90/91',1,3,0),(92,9,12,90,'2012-06-08 08:19:34','2012-06-08 08:19:34','1/3/90/92',2,3,0),(93,9,12,90,'2012-06-08 08:20:15','2012-06-08 08:20:15','1/3/90/93',3,3,0),(94,9,12,90,'2012-06-08 08:20:48','2012-06-08 08:20:48','1/3/90/94',4,3,0),(95,9,12,90,'2012-06-08 08:21:24','2012-06-08 08:21:24','1/3/90/95',5,3,0),(96,9,12,3,'2012-06-08 08:23:16','2012-06-18 06:18:26','1/3/96',34,2,13),(97,9,12,96,'2012-06-08 08:24:00','2012-06-08 08:24:00','1/3/96/97',1,3,0),(98,9,12,96,'2012-06-08 08:25:05','2012-06-08 08:25:05','1/3/96/98',2,3,0),(99,9,12,96,'2012-06-08 08:26:03','2012-06-08 08:26:03','1/3/96/99',3,3,0),(100,9,12,96,'2012-06-08 08:26:52','2012-06-08 08:26:52','1/3/96/100',4,3,0),(101,9,12,96,'2012-06-08 08:27:30','2012-06-08 08:27:30','1/3/96/101',5,3,0),(102,9,12,96,'2012-06-08 08:28:23','2012-06-08 08:28:23','1/3/96/102',6,3,0),(103,9,12,96,'2012-06-08 08:29:14','2012-06-08 08:29:14','1/3/96/103',7,3,0),(104,9,12,96,'2012-06-08 08:29:58','2012-06-08 08:29:58','1/3/96/104',8,3,0),(105,9,12,96,'2012-06-08 08:31:07','2012-06-08 08:31:07','1/3/96/105',9,3,0),(106,9,12,96,'2012-06-08 08:31:49','2012-06-08 08:31:49','1/3/96/106',10,3,0),(107,9,12,96,'2012-06-08 08:32:33','2012-06-08 08:32:33','1/3/96/107',11,3,0),(108,9,12,96,'2012-06-08 08:34:53','2012-06-08 08:34:53','1/3/96/108',12,3,0),(109,9,12,96,'2012-06-08 08:35:32','2012-06-08 08:35:32','1/3/96/109',13,3,0),(110,9,12,3,'2012-06-08 08:36:18','2012-06-18 06:18:34','1/3/110',35,2,6),(111,9,12,110,'2012-06-08 08:36:55','2012-06-08 08:36:55','1/3/110/111',1,3,0),(112,9,12,110,'2012-06-08 08:37:38','2012-06-08 08:37:38','1/3/110/112',2,3,0),(113,9,12,110,'2012-06-08 08:38:04','2012-06-08 08:38:25','1/3/110/113',3,3,0),(114,9,12,110,'2012-06-08 08:39:21','2012-06-08 08:39:21','1/3/110/114',4,3,0),(115,9,12,110,'2012-06-08 08:40:06','2012-06-08 08:40:06','1/3/110/115',5,3,0),(116,9,12,110,'2012-06-08 08:40:49','2012-06-08 08:40:49','1/3/110/116',6,3,0),(117,9,12,3,'2012-06-08 08:55:19','2012-06-18 06:18:43','1/3/117',36,2,29),(118,9,12,117,'2012-06-08 09:00:28','2012-06-08 09:00:28','1/3/117/118',1,3,0),(119,9,12,117,'2012-06-08 09:01:24','2012-06-08 09:01:24','1/3/117/119',2,3,0),(120,9,12,117,'2012-06-08 09:01:57','2012-06-08 09:01:57','1/3/117/120',3,3,0),(121,9,12,117,'2012-06-08 09:02:29','2012-06-08 09:17:48','1/3/117/121',4,3,0),(122,9,12,117,'2012-06-08 09:03:09','2012-06-08 09:18:12','1/3/117/122',5,3,0),(123,9,12,117,'2012-06-08 09:14:11','2012-06-08 09:14:11','1/3/117/123',6,3,0),(124,9,12,117,'2012-06-08 09:15:06','2012-06-08 09:15:06','1/3/117/124',7,3,0),(125,9,12,117,'2012-06-08 09:15:45','2012-06-08 09:15:45','1/3/117/125',8,3,0),(126,9,12,117,'2012-06-08 09:16:23','2012-06-08 09:16:23','1/3/117/126',9,3,0),(127,9,12,117,'2012-06-08 09:17:32','2012-06-08 09:17:32','1/3/117/127',10,3,0),(128,9,12,117,'2012-06-08 09:19:07','2012-06-08 09:19:07','1/3/117/128',11,3,0),(129,9,12,117,'2012-06-08 09:19:55','2012-06-08 09:19:55','1/3/117/129',12,3,0),(130,9,12,117,'2012-06-08 09:25:56','2012-06-08 09:25:56','1/3/117/130',13,3,0),(131,9,12,117,'2012-06-08 09:26:54','2012-06-08 09:26:54','1/3/117/131',14,3,0),(132,9,12,117,'2012-06-08 09:27:34','2012-06-08 09:27:34','1/3/117/132',15,3,0),(133,9,12,117,'2012-06-08 09:28:18','2012-06-08 09:28:18','1/3/117/133',16,3,0),(134,9,12,117,'2012-06-08 09:35:54','2012-06-08 09:35:54','1/3/117/134',17,3,0),(135,9,12,117,'2012-06-08 09:36:21','2012-06-08 09:36:43','1/3/117/135',18,3,0),(136,9,12,117,'2012-06-08 09:42:29','2012-06-08 09:42:29','1/3/117/136',19,3,0),(137,9,12,117,'2012-06-08 09:42:54','2012-06-08 09:43:23','1/3/117/137',20,3,0),(138,9,12,117,'2012-06-08 09:43:50','2012-06-08 09:44:13','1/3/117/138',21,3,0),(139,9,12,117,'2012-06-08 09:44:41','2012-06-08 09:44:41','1/3/117/139',22,3,0),(140,9,12,117,'2012-06-08 09:45:20','2012-06-08 09:45:20','1/3/117/140',23,3,0),(141,9,12,117,'2012-06-08 09:49:30','2012-06-08 09:49:30','1/3/117/141',24,3,0),(142,9,12,117,'2012-06-08 09:50:14','2012-06-08 09:50:14','1/3/117/142',25,3,0),(143,9,12,117,'2012-06-08 09:51:08','2012-06-08 09:51:08','1/3/117/143',26,3,0),(144,9,12,117,'2012-06-08 09:53:14','2012-06-08 09:53:14','1/3/117/144',27,3,0),(145,9,12,117,'2012-06-08 09:57:39','2012-06-08 09:57:39','1/3/117/145',28,3,0),(146,9,12,117,'2012-06-08 09:58:22','2012-06-08 09:58:22','1/3/117/146',29,3,0),(147,9,12,3,'2012-06-08 09:59:07','2012-06-18 06:18:54','1/3/147',37,2,5),(148,9,12,147,'2012-06-08 10:02:50','2012-06-08 10:02:50','1/3/147/148',1,3,0),(149,9,12,147,'2012-06-08 10:03:32','2012-06-08 10:03:32','1/3/147/149',2,3,0),(150,9,12,147,'2012-06-08 10:04:17','2012-06-08 10:04:17','1/3/147/150',3,3,0),(151,9,12,147,'2012-06-08 10:04:59','2012-06-08 10:04:59','1/3/147/151',4,3,0),(152,9,12,147,'2012-06-08 10:05:30','2012-06-08 10:05:30','1/3/147/152',5,3,0),(153,9,12,3,'2012-06-08 10:06:32','2012-06-18 06:19:06','1/3/153',38,2,18),(154,9,12,153,'2012-06-08 10:07:37','2012-06-08 10:07:37','1/3/153/154',1,3,0),(155,9,12,153,'2012-06-08 10:12:32','2012-06-08 10:12:32','1/3/153/155',2,3,0),(156,9,12,153,'2012-06-08 10:13:19','2012-06-08 10:13:19','1/3/153/156',3,3,0),(157,9,12,153,'2012-06-08 10:14:07','2012-06-08 10:14:07','1/3/153/157',4,3,0),(158,9,12,153,'2012-06-08 10:14:51','2012-06-08 10:14:51','1/3/153/158',5,3,0),(159,9,12,153,'2012-06-08 10:15:30','2012-06-08 10:15:30','1/3/153/159',6,3,0),(160,9,12,153,'2012-06-08 10:16:13','2012-06-08 10:16:13','1/3/153/160',7,3,0),(161,9,12,153,'2012-06-08 10:19:09','2012-06-08 10:19:09','1/3/153/161',8,3,0),(162,9,12,153,'2012-06-08 10:19:51','2012-06-08 10:19:51','1/3/153/162',9,3,0),(163,9,12,153,'2012-06-08 10:21:41','2012-06-08 10:21:41','1/3/153/163',10,3,0),(164,9,12,153,'2012-06-09 01:20:48','2012-06-09 01:20:48','1/3/153/164',11,3,0),(165,9,12,153,'2012-06-09 01:21:48','2012-06-09 01:21:48','1/3/153/165',12,3,0),(166,9,12,153,'2012-06-09 01:22:30','2012-06-09 01:22:30','1/3/153/166',13,3,0),(167,9,12,153,'2012-06-09 01:23:21','2012-06-09 01:23:21','1/3/153/167',14,3,0),(168,9,12,153,'2012-06-09 01:27:06','2012-06-09 01:27:06','1/3/153/168',15,3,0),(169,9,12,153,'2012-06-09 01:27:47','2012-06-09 01:27:47','1/3/153/169',16,3,0),(170,9,12,153,'2012-06-09 01:28:32','2012-06-09 01:28:32','1/3/153/170',17,3,0),(171,9,12,153,'2012-06-09 01:29:18','2012-06-09 01:29:18','1/3/153/171',18,3,0),(172,9,12,3,'2012-06-09 01:30:01','2012-06-18 06:19:17','1/3/172',39,2,0),(173,9,12,3,'2012-06-09 01:30:41','2012-06-18 06:19:37','1/3/173',40,2,4),(174,9,12,173,'2012-06-09 01:31:13','2012-06-09 01:31:13','1/3/173/174',1,3,0),(175,9,12,173,'2012-06-09 01:31:45','2012-06-09 01:31:45','1/3/173/175',2,3,0),(176,9,12,173,'2012-06-09 01:32:20','2012-06-09 01:32:20','1/3/173/176',3,3,0),(177,9,12,173,'2012-06-09 01:33:00','2012-06-09 01:33:00','1/3/173/177',4,3,0),(178,9,12,3,'2012-06-09 01:33:44','2012-06-18 06:19:46','1/3/178',41,2,8),(179,9,12,178,'2012-06-09 01:34:22','2012-06-09 01:34:22','1/3/178/179',1,3,0),(180,9,12,178,'2012-06-09 01:35:13','2012-06-09 01:35:13','1/3/178/180',2,3,0),(181,9,12,178,'2012-06-09 01:36:00','2012-06-09 01:36:00','1/3/178/181',3,3,0),(182,9,12,178,'2012-06-09 01:36:50','2012-06-09 01:36:50','1/3/178/182',4,3,0),(183,9,12,178,'2012-06-09 01:37:31','2012-06-09 01:37:31','1/3/178/183',5,3,0),(184,9,12,178,'2012-06-09 01:38:11','2012-06-09 01:38:11','1/3/178/184',6,3,0),(185,9,12,178,'2012-06-09 01:39:07','2012-06-09 01:39:07','1/3/178/185',7,3,0),(186,9,12,178,'2012-06-09 01:39:49','2012-06-09 01:39:49','1/3/178/186',8,3,0);
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` datetime DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_BASE` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_ATTRIBUTE_DATETIME_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_DATETIME_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DATETIME_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_datetime` VALUES (1,9,565,0,35,NULL),(2,9,566,0,35,NULL),(3,9,565,0,36,NULL),(4,9,566,0,36,NULL),(5,9,565,0,37,NULL),(6,9,566,0,37,NULL),(7,9,565,0,38,NULL),(8,9,566,0,38,NULL),(9,9,565,0,39,NULL),(10,9,566,0,39,NULL),(11,9,565,0,40,NULL),(12,9,566,0,40,NULL),(21,9,565,0,41,NULL),(22,9,566,0,41,NULL),(23,9,565,0,42,NULL),(24,9,566,0,42,NULL),(25,9,565,0,43,NULL),(26,9,566,0,43,NULL),(27,9,565,0,44,NULL),(28,9,566,0,44,NULL),(29,9,565,0,45,NULL),(30,9,566,0,45,NULL),(31,9,565,0,46,NULL),(32,9,566,0,46,NULL),(33,9,565,0,47,NULL),(34,9,566,0,47,NULL),(35,9,565,0,48,NULL),(36,9,566,0,48,NULL),(37,9,565,0,49,NULL),(38,9,566,0,49,NULL),(39,9,565,0,50,NULL),(40,9,566,0,50,NULL),(41,9,565,0,51,NULL),(42,9,566,0,51,NULL),(43,9,565,0,52,NULL),(44,9,566,0,52,NULL),(45,9,565,0,53,NULL),(46,9,566,0,53,NULL),(47,9,565,0,54,NULL),(48,9,566,0,54,NULL),(49,9,565,0,55,NULL),(50,9,566,0,55,NULL),(51,9,565,0,56,NULL),(52,9,566,0,56,NULL),(53,9,565,0,57,NULL),(54,9,566,0,57,NULL),(55,9,565,0,58,NULL),(56,9,566,0,58,NULL),(57,9,565,0,59,NULL),(58,9,566,0,59,NULL),(59,9,565,0,60,NULL),(60,9,566,0,60,NULL),(61,9,565,0,61,NULL),(62,9,566,0,61,NULL),(63,9,565,0,62,NULL),(64,9,566,0,62,NULL),(65,9,565,0,63,NULL),(66,9,566,0,63,NULL),(67,9,565,0,64,NULL),(68,9,566,0,64,NULL),(69,9,565,0,65,NULL),(70,9,566,0,65,NULL),(71,9,565,0,66,NULL),(72,9,566,0,66,NULL),(73,9,565,0,67,NULL),(74,9,566,0,67,NULL),(75,9,565,0,68,NULL),(76,9,566,0,68,NULL),(77,9,565,0,69,NULL),(78,9,566,0,69,NULL),(79,9,565,0,70,NULL),(80,9,566,0,70,NULL),(81,9,565,0,71,NULL),(82,9,566,0,71,NULL),(83,9,565,0,72,NULL),(84,9,566,0,72,NULL),(85,9,565,0,73,NULL),(86,9,566,0,73,NULL),(87,9,565,0,74,NULL),(88,9,566,0,74,NULL),(89,9,565,0,75,NULL),(90,9,566,0,75,NULL),(91,9,565,0,76,NULL),(92,9,566,0,76,NULL),(93,9,565,0,77,NULL),(94,9,566,0,77,NULL),(97,9,565,0,78,NULL),(98,9,566,0,78,NULL),(99,9,565,0,79,NULL),(100,9,566,0,79,NULL),(101,9,565,0,80,NULL),(102,9,566,0,80,NULL),(103,9,565,0,81,NULL),(104,9,566,0,81,NULL),(105,9,565,0,82,NULL),(106,9,566,0,82,NULL),(107,9,565,0,83,NULL),(108,9,566,0,83,NULL),(109,9,565,0,84,NULL),(110,9,566,0,84,NULL),(111,9,565,0,85,NULL),(112,9,566,0,85,NULL),(113,9,565,0,86,NULL),(114,9,566,0,86,NULL),(115,9,565,0,87,NULL),(116,9,566,0,87,NULL),(117,9,565,0,88,NULL),(118,9,566,0,88,NULL),(121,9,565,0,89,NULL),(122,9,566,0,89,NULL),(123,9,565,0,90,NULL),(124,9,566,0,90,NULL),(125,9,565,0,91,NULL),(126,9,566,0,91,NULL),(127,9,565,0,92,NULL),(128,9,566,0,92,NULL),(129,9,565,0,93,NULL),(130,9,566,0,93,NULL),(131,9,565,0,94,NULL),(132,9,566,0,94,NULL),(133,9,565,0,95,NULL),(134,9,566,0,95,NULL),(135,9,565,0,96,NULL),(136,9,566,0,96,NULL),(137,9,565,0,97,NULL),(138,9,566,0,97,NULL),(139,9,565,0,98,NULL),(140,9,566,0,98,NULL),(141,9,565,0,99,NULL),(142,9,566,0,99,NULL),(143,9,565,0,100,NULL),(144,9,566,0,100,NULL),(145,9,565,0,101,NULL),(146,9,566,0,101,NULL),(147,9,565,0,102,NULL),(148,9,566,0,102,NULL),(149,9,565,0,103,NULL),(150,9,566,0,103,NULL),(151,9,565,0,104,NULL),(152,9,566,0,104,NULL),(153,9,565,0,105,NULL),(154,9,566,0,105,NULL),(155,9,565,0,106,NULL),(156,9,566,0,106,NULL),(157,9,565,0,107,NULL),(158,9,566,0,107,NULL),(159,9,565,0,108,NULL),(160,9,566,0,108,NULL),(161,9,565,0,109,NULL),(162,9,566,0,109,NULL),(163,9,565,0,110,NULL),(164,9,566,0,110,NULL),(165,9,565,0,111,NULL),(166,9,566,0,111,NULL),(167,9,565,0,112,NULL),(168,9,566,0,112,NULL),(169,9,565,0,113,NULL),(170,9,566,0,113,NULL),(173,9,565,0,114,NULL),(174,9,566,0,114,NULL),(175,9,565,0,115,NULL),(176,9,566,0,115,NULL),(177,9,565,0,116,NULL),(178,9,566,0,116,NULL),(179,9,565,0,117,NULL),(180,9,566,0,117,NULL),(181,9,565,0,118,NULL),(182,9,566,0,118,NULL),(183,9,565,0,119,NULL),(184,9,566,0,119,NULL),(185,9,565,0,120,NULL),(186,9,566,0,120,NULL),(187,9,565,0,121,NULL),(188,9,566,0,121,NULL),(189,9,565,0,122,NULL),(190,9,566,0,122,NULL),(191,9,565,0,123,NULL),(192,9,566,0,123,NULL),(193,9,565,0,124,NULL),(194,9,566,0,124,NULL),(195,9,565,0,125,NULL),(196,9,566,0,125,NULL),(197,9,565,0,126,NULL),(198,9,566,0,126,NULL),(199,9,565,0,127,NULL),(200,9,566,0,127,NULL),(207,9,565,0,128,NULL),(208,9,566,0,128,NULL),(209,9,565,0,129,NULL),(210,9,566,0,129,NULL),(211,9,565,0,130,NULL),(212,9,566,0,130,NULL),(213,9,565,0,131,NULL),(214,9,566,0,131,NULL),(215,9,565,0,132,NULL),(216,9,566,0,132,NULL),(217,9,565,0,133,NULL),(218,9,566,0,133,NULL),(219,9,565,0,134,NULL),(220,9,566,0,134,NULL),(221,9,565,0,135,NULL),(222,9,566,0,135,NULL),(225,9,565,0,136,NULL),(226,9,566,0,136,NULL),(227,9,565,0,137,NULL),(228,9,566,0,137,NULL),(231,9,565,0,138,NULL),(232,9,566,0,138,NULL),(235,9,565,0,139,NULL),(236,9,566,0,139,NULL),(237,9,565,0,140,NULL),(238,9,566,0,140,NULL),(239,9,565,0,141,NULL),(240,9,566,0,141,NULL),(241,9,565,0,142,NULL),(242,9,566,0,142,NULL),(243,9,565,0,143,NULL),(244,9,566,0,143,NULL),(245,9,565,0,144,NULL),(246,9,566,0,144,NULL),(247,9,565,0,145,NULL),(248,9,566,0,145,NULL),(249,9,565,0,146,NULL),(250,9,566,0,146,NULL),(251,9,565,0,147,NULL),(252,9,566,0,147,NULL),(253,9,565,0,148,NULL),(254,9,566,0,148,NULL),(255,9,565,0,149,NULL),(256,9,566,0,149,NULL),(257,9,565,0,150,NULL),(258,9,566,0,150,NULL),(259,9,565,0,151,NULL),(260,9,566,0,151,NULL),(261,9,565,0,152,NULL),(262,9,566,0,152,NULL),(263,9,565,0,153,NULL),(264,9,566,0,153,NULL),(265,9,565,0,154,NULL),(266,9,566,0,154,NULL),(267,9,565,0,155,NULL),(268,9,566,0,155,NULL),(269,9,565,0,156,NULL),(270,9,566,0,156,NULL),(271,9,565,0,157,NULL),(272,9,566,0,157,NULL),(273,9,565,0,158,NULL),(274,9,566,0,158,NULL),(275,9,565,0,159,NULL),(276,9,566,0,159,NULL),(277,9,565,0,160,NULL),(278,9,566,0,160,NULL),(279,9,565,0,161,NULL),(280,9,566,0,161,NULL),(281,9,565,0,162,NULL),(282,9,566,0,162,NULL),(283,9,565,0,163,NULL),(284,9,566,0,163,NULL),(285,9,565,0,164,NULL),(286,9,566,0,164,NULL),(287,9,565,0,165,NULL),(288,9,566,0,165,NULL),(289,9,565,0,166,NULL),(290,9,566,0,166,NULL),(291,9,565,0,167,NULL),(292,9,566,0,167,NULL),(293,9,565,0,168,NULL),(294,9,566,0,168,NULL),(295,9,565,0,169,NULL),(296,9,566,0,169,NULL),(297,9,565,0,170,NULL),(298,9,566,0,170,NULL),(299,9,565,0,171,NULL),(300,9,566,0,171,NULL),(301,9,565,0,172,NULL),(302,9,566,0,172,NULL),(303,9,565,0,173,NULL),(304,9,566,0,173,NULL),(305,9,565,0,174,NULL),(306,9,566,0,174,NULL),(307,9,565,0,175,NULL),(308,9,566,0,175,NULL),(309,9,565,0,176,NULL),(310,9,566,0,176,NULL),(311,9,565,0,177,NULL),(312,9,566,0,177,NULL),(313,9,565,0,178,NULL),(314,9,566,0,178,NULL),(315,9,565,0,179,NULL),(316,9,566,0,179,NULL),(317,9,565,0,180,NULL),(318,9,566,0,180,NULL),(319,9,565,0,181,NULL),(320,9,566,0,181,NULL),(321,9,565,0,182,NULL),(322,9,566,0,182,NULL),(323,9,565,0,183,NULL),(324,9,566,0,183,NULL),(325,9,565,0,184,NULL),(326,9,566,0,184,NULL),(327,9,565,0,185,NULL),(328,9,566,0,185,NULL),(329,9,565,0,186,NULL),(330,9,566,0,186,NULL),(393,9,565,0,3,NULL),(394,9,566,0,3,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_BASE` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_ATTRIBUTE_DECIMAL_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_DECIMAL_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_DECIMAL_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_decimal`
--

LOCK TABLES `catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` int(11) DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_BASE` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_ATTRIBUTE_INT_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_CATEGORY_EMTITY_INT_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_CATEGORY_EMTITY_INT_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_EMTITY_INT_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_EMTITY_INT_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_EMTITY_INT_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1530 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES (11,9,119,0,1,1),(25,9,119,0,3,1),(26,9,120,0,20,0),(33,9,119,0,20,0),(77,9,932,0,1,1),(78,9,932,0,3,1),(90,9,932,0,20,1),(104,9,119,0,35,1),(105,9,932,0,35,0),(106,9,117,0,35,NULL),(107,9,120,0,35,0),(129,9,945,0,20,1),(130,9,946,0,20,1),(155,9,945,0,35,1),(156,9,946,0,35,1),(176,9,119,0,36,1),(177,9,932,0,36,0),(178,9,117,0,36,NULL),(179,9,120,0,36,1),(180,9,945,0,36,0),(181,9,946,0,36,0),(182,9,947,0,36,NULL),(183,9,119,0,37,1),(184,9,932,0,37,0),(185,9,117,0,37,NULL),(186,9,120,0,37,1),(187,9,945,0,37,0),(188,9,946,0,37,0),(189,9,947,0,37,NULL),(190,9,119,0,38,1),(191,9,932,0,38,0),(192,9,117,0,38,NULL),(193,9,120,0,38,1),(194,9,945,0,38,0),(195,9,946,0,38,0),(196,9,947,0,38,NULL),(197,9,119,0,39,1),(198,9,932,0,39,0),(199,9,117,0,39,NULL),(200,9,120,0,39,1),(201,9,945,0,39,0),(202,9,946,0,39,0),(203,9,947,0,39,NULL),(204,9,119,0,40,1),(205,9,932,0,40,1),(206,9,117,0,40,NULL),(207,9,120,0,40,1),(208,9,945,0,40,0),(209,9,946,0,40,0),(210,9,947,0,40,NULL),(215,9,119,0,41,1),(216,9,932,0,41,1),(217,9,117,0,41,NULL),(218,9,120,0,41,0),(219,9,945,0,41,0),(220,9,946,0,41,0),(221,9,947,0,41,NULL),(222,9,119,0,42,1),(223,9,932,0,42,1),(224,9,117,0,42,NULL),(225,9,120,0,42,1),(226,9,945,0,42,0),(227,9,946,0,42,0),(228,9,947,0,42,NULL),(229,9,119,0,43,1),(230,9,932,0,43,1),(231,9,117,0,43,NULL),(232,9,120,0,43,0),(233,9,945,0,43,0),(234,9,946,0,43,0),(235,9,947,0,43,NULL),(236,9,119,0,44,1),(237,9,932,0,44,1),(238,9,117,0,44,NULL),(239,9,120,0,44,1),(240,9,945,0,44,0),(241,9,946,0,44,0),(242,9,947,0,44,NULL),(243,9,119,0,45,1),(244,9,932,0,45,1),(245,9,117,0,45,NULL),(246,9,120,0,45,1),(247,9,945,0,45,0),(248,9,946,0,45,0),(249,9,947,0,45,NULL),(250,9,119,0,46,1),(251,9,932,0,46,1),(252,9,117,0,46,NULL),(253,9,120,0,46,1),(254,9,945,0,46,0),(255,9,946,0,46,0),(256,9,947,0,46,NULL),(257,9,119,0,47,1),(258,9,932,0,47,1),(259,9,117,0,47,NULL),(260,9,120,0,47,1),(261,9,945,0,47,0),(262,9,946,0,47,0),(263,9,947,0,47,NULL),(264,9,119,0,48,1),(265,9,932,0,48,1),(266,9,117,0,48,NULL),(267,9,120,0,48,1),(268,9,945,0,48,0),(269,9,946,0,48,0),(270,9,947,0,48,NULL),(271,9,119,0,49,1),(272,9,932,0,49,1),(273,9,117,0,49,NULL),(274,9,120,0,49,1),(275,9,945,0,49,0),(276,9,946,0,49,0),(277,9,947,0,49,NULL),(278,9,119,0,50,1),(279,9,932,0,50,1),(280,9,117,0,50,NULL),(281,9,120,0,50,1),(282,9,945,0,50,0),(283,9,946,0,50,0),(284,9,947,0,50,NULL),(285,9,119,0,51,1),(286,9,932,0,51,1),(287,9,117,0,51,NULL),(288,9,120,0,51,1),(289,9,945,0,51,0),(290,9,946,0,51,0),(291,9,947,0,51,NULL),(292,9,119,0,52,1),(293,9,932,0,52,1),(294,9,117,0,52,NULL),(295,9,120,0,52,1),(296,9,945,0,52,0),(297,9,946,0,52,0),(298,9,947,0,52,NULL),(299,9,119,0,53,1),(300,9,932,0,53,1),(301,9,117,0,53,NULL),(302,9,120,0,53,1),(303,9,945,0,53,0),(304,9,946,0,53,0),(305,9,947,0,53,NULL),(306,9,119,0,54,1),(307,9,932,0,54,1),(308,9,117,0,54,NULL),(309,9,120,0,54,1),(310,9,945,0,54,0),(311,9,946,0,54,0),(312,9,947,0,54,NULL),(313,9,119,0,55,1),(314,9,932,0,55,1),(315,9,117,0,55,NULL),(316,9,120,0,55,1),(317,9,945,0,55,0),(318,9,946,0,55,0),(319,9,947,0,55,NULL),(320,9,119,0,56,1),(321,9,932,0,56,1),(322,9,117,0,56,NULL),(323,9,120,0,56,1),(324,9,945,0,56,0),(325,9,946,0,56,0),(326,9,947,0,56,NULL),(327,9,119,0,57,1),(328,9,932,0,57,1),(329,9,117,0,57,NULL),(330,9,120,0,57,1),(331,9,945,0,57,0),(332,9,946,0,57,0),(333,9,947,0,57,NULL),(334,9,119,0,58,1),(335,9,932,0,58,1),(336,9,117,0,58,NULL),(337,9,120,0,58,1),(338,9,945,0,58,0),(339,9,946,0,58,0),(340,9,947,0,58,NULL),(341,9,119,0,59,1),(342,9,932,0,59,1),(343,9,117,0,59,NULL),(344,9,120,0,59,1),(345,9,945,0,59,0),(346,9,946,0,59,0),(347,9,947,0,59,NULL),(348,9,119,0,60,1),(349,9,932,0,60,1),(350,9,117,0,60,NULL),(351,9,120,0,60,1),(352,9,945,0,60,0),(353,9,946,0,60,0),(354,9,947,0,60,NULL),(355,9,119,0,61,1),(356,9,932,0,61,1),(357,9,117,0,61,NULL),(358,9,120,0,61,1),(359,9,945,0,61,0),(360,9,946,0,61,0),(361,9,947,0,61,NULL),(362,9,119,0,62,1),(363,9,932,0,62,1),(364,9,117,0,62,NULL),(365,9,120,0,62,1),(366,9,945,0,62,0),(367,9,946,0,62,0),(368,9,947,0,62,NULL),(369,9,119,0,63,1),(370,9,932,0,63,1),(371,9,117,0,63,NULL),(372,9,120,0,63,1),(373,9,945,0,63,0),(374,9,946,0,63,0),(375,9,947,0,63,NULL),(376,9,119,0,64,1),(377,9,932,0,64,1),(378,9,117,0,64,NULL),(379,9,120,0,64,1),(380,9,945,0,64,0),(381,9,946,0,64,0),(382,9,947,0,64,NULL),(383,9,119,0,65,1),(384,9,932,0,65,1),(385,9,117,0,65,NULL),(386,9,120,0,65,1),(387,9,945,0,65,0),(388,9,946,0,65,0),(389,9,947,0,65,NULL),(390,9,119,0,66,1),(391,9,932,0,66,1),(392,9,117,0,66,NULL),(393,9,120,0,66,1),(394,9,945,0,66,0),(395,9,946,0,66,0),(396,9,947,0,66,NULL),(397,9,119,0,67,1),(398,9,932,0,67,1),(399,9,117,0,67,NULL),(400,9,120,0,67,1),(401,9,945,0,67,0),(402,9,946,0,67,0),(403,9,947,0,67,NULL),(404,9,119,0,68,1),(405,9,932,0,68,1),(406,9,117,0,68,NULL),(407,9,120,0,68,1),(408,9,945,0,68,0),(409,9,946,0,68,0),(410,9,947,0,68,NULL),(411,9,119,0,69,1),(412,9,932,0,69,1),(413,9,117,0,69,NULL),(414,9,120,0,69,1),(415,9,945,0,69,0),(416,9,946,0,69,0),(417,9,947,0,69,NULL),(418,9,119,0,70,1),(419,9,932,0,70,1),(420,9,117,0,70,NULL),(421,9,120,0,70,1),(422,9,945,0,70,0),(423,9,946,0,70,0),(424,9,947,0,70,NULL),(425,9,119,0,71,1),(426,9,932,0,71,1),(427,9,117,0,71,NULL),(428,9,120,0,71,1),(429,9,945,0,71,0),(430,9,946,0,71,0),(431,9,947,0,71,NULL),(432,9,119,0,72,1),(433,9,932,0,72,1),(434,9,117,0,72,NULL),(435,9,120,0,72,1),(436,9,945,0,72,0),(437,9,946,0,72,0),(438,9,947,0,72,NULL),(439,9,119,0,73,1),(440,9,932,0,73,1),(441,9,117,0,73,NULL),(442,9,120,0,73,1),(443,9,945,0,73,0),(444,9,946,0,73,0),(445,9,947,0,73,NULL),(446,9,119,0,74,1),(447,9,932,0,74,1),(448,9,117,0,74,NULL),(449,9,120,0,74,1),(450,9,945,0,74,0),(451,9,946,0,74,0),(452,9,947,0,74,NULL),(453,9,119,0,75,1),(454,9,932,0,75,1),(455,9,117,0,75,NULL),(456,9,120,0,75,1),(457,9,945,0,75,0),(458,9,946,0,75,0),(459,9,947,0,75,NULL),(460,9,119,0,76,1),(461,9,932,0,76,1),(462,9,117,0,76,NULL),(463,9,120,0,76,1),(464,9,945,0,76,0),(465,9,946,0,76,0),(466,9,947,0,76,NULL),(467,9,119,0,77,1),(468,9,932,0,77,1),(469,9,117,0,77,NULL),(470,9,120,0,77,1),(471,9,945,0,77,0),(472,9,946,0,77,0),(473,9,947,0,77,NULL),(475,9,119,0,78,1),(476,9,932,0,78,1),(477,9,117,0,78,NULL),(478,9,120,0,78,1),(479,9,945,0,78,0),(480,9,946,0,78,0),(481,9,947,0,78,NULL),(482,9,119,0,79,1),(483,9,932,0,79,1),(484,9,117,0,79,NULL),(485,9,120,0,79,1),(486,9,945,0,79,0),(487,9,946,0,79,0),(488,9,947,0,79,NULL),(489,9,119,0,80,1),(490,9,932,0,80,1),(491,9,117,0,80,NULL),(492,9,120,0,80,1),(493,9,945,0,80,0),(494,9,946,0,80,0),(495,9,947,0,80,NULL),(496,9,119,0,81,1),(497,9,932,0,81,1),(498,9,117,0,81,NULL),(499,9,120,0,81,1),(500,9,945,0,81,0),(501,9,946,0,81,0),(502,9,947,0,81,NULL),(503,9,119,0,82,1),(504,9,932,0,82,1),(505,9,117,0,82,NULL),(506,9,120,0,82,1),(507,9,945,0,82,0),(508,9,946,0,82,0),(509,9,947,0,82,NULL),(510,9,119,0,83,1),(511,9,932,0,83,1),(512,9,117,0,83,NULL),(513,9,120,0,83,1),(514,9,945,0,83,0),(515,9,946,0,83,0),(516,9,947,0,83,NULL),(517,9,119,0,84,1),(518,9,932,0,84,1),(519,9,117,0,84,NULL),(520,9,120,0,84,1),(521,9,945,0,84,0),(522,9,946,0,84,0),(523,9,947,0,84,NULL),(524,9,119,0,85,1),(525,9,932,0,85,1),(526,9,117,0,85,NULL),(527,9,120,0,85,1),(528,9,945,0,85,0),(529,9,946,0,85,0),(530,9,947,0,85,NULL),(531,9,119,0,86,1),(532,9,932,0,86,1),(533,9,117,0,86,NULL),(534,9,120,0,86,1),(535,9,945,0,86,0),(536,9,946,0,86,0),(537,9,947,0,86,NULL),(538,9,119,0,87,1),(539,9,932,0,87,1),(540,9,117,0,87,NULL),(541,9,120,0,87,1),(542,9,945,0,87,0),(543,9,946,0,87,0),(544,9,947,0,87,NULL),(545,9,119,0,88,1),(546,9,932,0,88,1),(547,9,117,0,88,NULL),(548,9,120,0,88,1),(549,9,945,0,88,0),(550,9,946,0,88,0),(551,9,947,0,88,NULL),(554,9,119,0,89,1),(555,9,932,0,89,1),(556,9,117,0,89,NULL),(557,9,120,0,89,1),(558,9,945,0,89,0),(559,9,946,0,89,0),(560,9,947,0,89,NULL),(561,9,119,0,90,1),(562,9,932,0,90,1),(563,9,117,0,90,NULL),(564,9,120,0,90,1),(565,9,945,0,90,0),(566,9,946,0,90,0),(567,9,947,0,90,NULL),(568,9,119,0,91,1),(569,9,932,0,91,1),(570,9,117,0,91,NULL),(571,9,120,0,91,1),(572,9,945,0,91,0),(573,9,946,0,91,0),(574,9,947,0,91,NULL),(575,9,119,0,92,1),(576,9,932,0,92,1),(577,9,117,0,92,NULL),(578,9,120,0,92,1),(579,9,945,0,92,0),(580,9,946,0,92,0),(581,9,947,0,92,NULL),(582,9,119,0,93,1),(583,9,932,0,93,1),(584,9,117,0,93,NULL),(585,9,120,0,93,1),(586,9,945,0,93,0),(587,9,946,0,93,0),(588,9,947,0,93,NULL),(589,9,119,0,94,1),(590,9,932,0,94,1),(591,9,117,0,94,NULL),(592,9,120,0,94,1),(593,9,945,0,94,0),(594,9,946,0,94,0),(595,9,947,0,94,NULL),(596,9,119,0,95,1),(597,9,932,0,95,1),(598,9,117,0,95,NULL),(599,9,120,0,95,1),(600,9,945,0,95,0),(601,9,946,0,95,0),(602,9,947,0,95,NULL),(603,9,119,0,96,1),(604,9,932,0,96,1),(605,9,117,0,96,NULL),(606,9,120,0,96,1),(607,9,945,0,96,0),(608,9,946,0,96,0),(609,9,947,0,96,NULL),(610,9,119,0,97,1),(611,9,932,0,97,1),(612,9,117,0,97,NULL),(613,9,120,0,97,1),(614,9,945,0,97,0),(615,9,946,0,97,0),(616,9,947,0,97,NULL),(617,9,119,0,98,1),(618,9,932,0,98,1),(619,9,117,0,98,NULL),(620,9,120,0,98,1),(621,9,945,0,98,0),(622,9,946,0,98,0),(623,9,947,0,98,NULL),(624,9,119,0,99,1),(625,9,932,0,99,1),(626,9,117,0,99,NULL),(627,9,120,0,99,1),(628,9,945,0,99,0),(629,9,946,0,99,0),(630,9,947,0,99,NULL),(631,9,119,0,100,1),(632,9,932,0,100,1),(633,9,117,0,100,NULL),(634,9,120,0,100,1),(635,9,945,0,100,0),(636,9,946,0,100,0),(637,9,947,0,100,NULL),(638,9,119,0,101,1),(639,9,932,0,101,1),(640,9,117,0,101,NULL),(641,9,120,0,101,1),(642,9,945,0,101,0),(643,9,946,0,101,0),(644,9,947,0,101,NULL),(645,9,119,0,102,1),(646,9,932,0,102,1),(647,9,117,0,102,NULL),(648,9,120,0,102,1),(649,9,945,0,102,0),(650,9,946,0,102,0),(651,9,947,0,102,NULL),(652,9,119,0,103,1),(653,9,932,0,103,1),(654,9,117,0,103,NULL),(655,9,120,0,103,1),(656,9,945,0,103,0),(657,9,946,0,103,0),(658,9,947,0,103,NULL),(659,9,119,0,104,1),(660,9,932,0,104,1),(661,9,117,0,104,NULL),(662,9,120,0,104,1),(663,9,945,0,104,0),(664,9,946,0,104,0),(665,9,947,0,104,NULL),(666,9,119,0,105,1),(667,9,932,0,105,1),(668,9,117,0,105,NULL),(669,9,120,0,105,1),(670,9,945,0,105,0),(671,9,946,0,105,0),(672,9,947,0,105,NULL),(673,9,119,0,106,1),(674,9,932,0,106,1),(675,9,117,0,106,NULL),(676,9,120,0,106,1),(677,9,945,0,106,0),(678,9,946,0,106,0),(679,9,947,0,106,NULL),(680,9,119,0,107,1),(681,9,932,0,107,1),(682,9,117,0,107,NULL),(683,9,120,0,107,1),(684,9,945,0,107,0),(685,9,946,0,107,0),(686,9,947,0,107,NULL),(687,9,119,0,108,1),(688,9,932,0,108,1),(689,9,117,0,108,NULL),(690,9,120,0,108,1),(691,9,945,0,108,0),(692,9,946,0,108,0),(693,9,947,0,108,NULL),(694,9,119,0,109,1),(695,9,932,0,109,1),(696,9,117,0,109,NULL),(697,9,120,0,109,1),(698,9,945,0,109,0),(699,9,946,0,109,0),(700,9,947,0,109,NULL),(701,9,119,0,110,1),(702,9,932,0,110,1),(703,9,117,0,110,NULL),(704,9,120,0,110,1),(705,9,945,0,110,0),(706,9,946,0,110,0),(707,9,947,0,110,NULL),(708,9,119,0,111,1),(709,9,932,0,111,1),(710,9,117,0,111,NULL),(711,9,120,0,111,1),(712,9,945,0,111,0),(713,9,946,0,111,0),(714,9,947,0,111,NULL),(715,9,119,0,112,1),(716,9,932,0,112,1),(717,9,117,0,112,NULL),(718,9,120,0,112,1),(719,9,945,0,112,0),(720,9,946,0,112,0),(721,9,947,0,112,NULL),(722,9,119,0,113,1),(723,9,932,0,113,1),(724,9,117,0,113,NULL),(725,9,120,0,113,1),(726,9,945,0,113,0),(727,9,946,0,113,0),(728,9,947,0,113,NULL),(730,9,119,0,114,1),(731,9,932,0,114,1),(732,9,117,0,114,NULL),(733,9,120,0,114,1),(734,9,945,0,114,0),(735,9,946,0,114,0),(736,9,947,0,114,NULL),(737,9,119,0,115,1),(738,9,932,0,115,1),(739,9,117,0,115,NULL),(740,9,120,0,115,1),(741,9,945,0,115,0),(742,9,946,0,115,0),(743,9,947,0,115,NULL),(744,9,119,0,116,1),(745,9,932,0,116,1),(746,9,117,0,116,NULL),(747,9,120,0,116,1),(748,9,945,0,116,0),(749,9,946,0,116,0),(750,9,947,0,116,NULL),(751,9,119,0,117,1),(752,9,932,0,117,1),(753,9,117,0,117,NULL),(754,9,120,0,117,1),(755,9,945,0,117,0),(756,9,946,0,117,0),(757,9,947,0,117,NULL),(758,9,119,0,118,1),(759,9,932,0,118,1),(760,9,117,0,118,NULL),(761,9,120,0,118,1),(762,9,945,0,118,0),(763,9,946,0,118,0),(764,9,947,0,118,NULL),(765,9,119,0,119,1),(766,9,932,0,119,1),(767,9,117,0,119,NULL),(768,9,120,0,119,1),(769,9,945,0,119,0),(770,9,946,0,119,0),(771,9,947,0,119,NULL),(772,9,119,0,120,1),(773,9,932,0,120,1),(774,9,117,0,120,NULL),(775,9,120,0,120,1),(776,9,945,0,120,0),(777,9,946,0,120,0),(778,9,947,0,120,NULL),(779,9,119,0,121,1),(780,9,932,0,121,1),(781,9,117,0,121,NULL),(782,9,120,0,121,1),(783,9,945,0,121,0),(784,9,946,0,121,0),(785,9,947,0,121,NULL),(786,9,119,0,122,1),(787,9,932,0,122,1),(788,9,117,0,122,NULL),(789,9,120,0,122,1),(790,9,945,0,122,0),(791,9,946,0,122,0),(792,9,947,0,122,NULL),(793,9,119,0,123,1),(794,9,932,0,123,1),(795,9,117,0,123,NULL),(796,9,120,0,123,1),(797,9,945,0,123,0),(798,9,946,0,123,0),(799,9,947,0,123,NULL),(800,9,119,0,124,1),(801,9,932,0,124,1),(802,9,117,0,124,NULL),(803,9,120,0,124,1),(804,9,945,0,124,0),(805,9,946,0,124,0),(806,9,947,0,124,NULL),(807,9,119,0,125,1),(808,9,932,0,125,1),(809,9,117,0,125,NULL),(810,9,120,0,125,1),(811,9,945,0,125,0),(812,9,946,0,125,0),(813,9,947,0,125,NULL),(814,9,119,0,126,1),(815,9,932,0,126,1),(816,9,117,0,126,NULL),(817,9,120,0,126,1),(818,9,945,0,126,0),(819,9,946,0,126,0),(820,9,947,0,126,NULL),(821,9,119,0,127,1),(822,9,932,0,127,1),(823,9,117,0,127,NULL),(824,9,120,0,127,1),(825,9,945,0,127,0),(826,9,946,0,127,0),(827,9,947,0,127,NULL),(831,9,119,0,128,1),(832,9,932,0,128,1),(833,9,117,0,128,NULL),(834,9,120,0,128,1),(835,9,945,0,128,0),(836,9,946,0,128,0),(837,9,947,0,128,NULL),(838,9,119,0,129,1),(839,9,932,0,129,1),(840,9,117,0,129,NULL),(841,9,120,0,129,1),(842,9,945,0,129,0),(843,9,946,0,129,0),(844,9,947,0,129,NULL),(845,9,119,0,130,1),(846,9,932,0,130,1),(847,9,117,0,130,NULL),(848,9,120,0,130,1),(849,9,945,0,130,0),(850,9,946,0,130,0),(851,9,947,0,130,NULL),(852,9,119,0,131,1),(853,9,932,0,131,1),(854,9,117,0,131,NULL),(855,9,120,0,131,1),(856,9,945,0,131,0),(857,9,946,0,131,0),(858,9,947,0,131,NULL),(859,9,119,0,132,1),(860,9,932,0,132,1),(861,9,117,0,132,NULL),(862,9,120,0,132,1),(863,9,945,0,132,0),(864,9,946,0,132,0),(865,9,947,0,132,NULL),(866,9,119,0,133,1),(867,9,932,0,133,1),(868,9,117,0,133,NULL),(869,9,120,0,133,1),(870,9,945,0,133,0),(871,9,946,0,133,0),(872,9,947,0,133,NULL),(873,9,119,0,134,1),(874,9,932,0,134,1),(875,9,117,0,134,NULL),(876,9,120,0,134,1),(877,9,945,0,134,0),(878,9,946,0,134,0),(879,9,947,0,134,NULL),(880,9,119,0,135,1),(881,9,932,0,135,1),(882,9,117,0,135,NULL),(883,9,120,0,135,1),(884,9,945,0,135,0),(885,9,946,0,135,0),(886,9,947,0,135,NULL),(888,9,119,0,136,1),(889,9,932,0,136,1),(890,9,117,0,136,NULL),(891,9,120,0,136,1),(892,9,945,0,136,0),(893,9,946,0,136,0),(894,9,947,0,136,NULL),(895,9,119,0,137,1),(896,9,932,0,137,1),(897,9,117,0,137,NULL),(898,9,120,0,137,1),(899,9,945,0,137,0),(900,9,946,0,137,0),(901,9,947,0,137,NULL),(903,9,119,0,138,1),(904,9,932,0,138,1),(905,9,117,0,138,NULL),(906,9,120,0,138,1),(907,9,945,0,138,0),(908,9,946,0,138,0),(909,9,947,0,138,NULL),(911,9,119,0,139,1),(912,9,932,0,139,1),(913,9,117,0,139,NULL),(914,9,120,0,139,1),(915,9,945,0,139,0),(916,9,946,0,139,0),(917,9,947,0,139,NULL),(918,9,119,0,140,1),(919,9,932,0,140,1),(920,9,117,0,140,NULL),(921,9,120,0,140,1),(922,9,945,0,140,0),(923,9,946,0,140,0),(924,9,947,0,140,NULL),(925,9,119,0,141,1),(926,9,932,0,141,1),(927,9,117,0,141,NULL),(928,9,120,0,141,1),(929,9,945,0,141,0),(930,9,946,0,141,0),(931,9,947,0,141,NULL),(932,9,119,0,142,1),(933,9,932,0,142,1),(934,9,117,0,142,NULL),(935,9,120,0,142,1),(936,9,945,0,142,0),(937,9,946,0,142,0),(938,9,947,0,142,NULL),(939,9,119,0,143,1),(940,9,932,0,143,1),(941,9,117,0,143,NULL),(942,9,120,0,143,1),(943,9,945,0,143,0),(944,9,946,0,143,0),(945,9,947,0,143,NULL),(946,9,119,0,144,1),(947,9,932,0,144,1),(948,9,117,0,144,NULL),(949,9,120,0,144,1),(950,9,945,0,144,0),(951,9,946,0,144,0),(952,9,947,0,144,NULL),(953,9,119,0,145,1),(954,9,932,0,145,1),(955,9,117,0,145,NULL),(956,9,120,0,145,1),(957,9,945,0,145,0),(958,9,946,0,145,0),(959,9,947,0,145,NULL),(960,9,119,0,146,1),(961,9,932,0,146,1),(962,9,117,0,146,NULL),(963,9,120,0,146,1),(964,9,945,0,146,0),(965,9,946,0,146,0),(966,9,947,0,146,NULL),(967,9,119,0,147,1),(968,9,932,0,147,1),(969,9,117,0,147,NULL),(970,9,120,0,147,1),(971,9,945,0,147,0),(972,9,946,0,147,0),(973,9,947,0,147,NULL),(974,9,119,0,148,1),(975,9,932,0,148,1),(976,9,117,0,148,NULL),(977,9,120,0,148,1),(978,9,945,0,148,0),(979,9,946,0,148,0),(980,9,947,0,148,NULL),(981,9,119,0,149,1),(982,9,932,0,149,1),(983,9,117,0,149,NULL),(984,9,120,0,149,1),(985,9,945,0,149,0),(986,9,946,0,149,0),(987,9,947,0,149,NULL),(988,9,119,0,150,1),(989,9,932,0,150,1),(990,9,117,0,150,NULL),(991,9,120,0,150,1),(992,9,945,0,150,0),(993,9,946,0,150,0),(994,9,947,0,150,NULL),(995,9,119,0,151,1),(996,9,932,0,151,1),(997,9,117,0,151,NULL),(998,9,120,0,151,1),(999,9,945,0,151,0),(1000,9,946,0,151,0),(1001,9,947,0,151,NULL),(1002,9,119,0,152,1),(1003,9,932,0,152,1),(1004,9,117,0,152,NULL),(1005,9,120,0,152,1),(1006,9,945,0,152,0),(1007,9,946,0,152,0),(1008,9,947,0,152,NULL),(1009,9,119,0,153,1),(1010,9,932,0,153,1),(1011,9,117,0,153,NULL),(1012,9,120,0,153,1),(1013,9,945,0,153,0),(1014,9,946,0,153,0),(1015,9,947,0,153,NULL),(1016,9,119,0,154,1),(1017,9,932,0,154,1),(1018,9,117,0,154,NULL),(1019,9,120,0,154,1),(1020,9,945,0,154,0),(1021,9,946,0,154,0),(1022,9,947,0,154,NULL),(1023,9,119,0,155,1),(1024,9,932,0,155,1),(1025,9,117,0,155,NULL),(1026,9,120,0,155,1),(1027,9,945,0,155,0),(1028,9,946,0,155,0),(1029,9,947,0,155,NULL),(1030,9,119,0,156,1),(1031,9,932,0,156,1),(1032,9,117,0,156,NULL),(1033,9,120,0,156,1),(1034,9,945,0,156,0),(1035,9,946,0,156,0),(1036,9,947,0,156,NULL),(1037,9,119,0,157,1),(1038,9,932,0,157,1),(1039,9,117,0,157,NULL),(1040,9,120,0,157,1),(1041,9,945,0,157,0),(1042,9,946,0,157,0),(1043,9,947,0,157,NULL),(1044,9,119,0,158,1),(1045,9,932,0,158,1),(1046,9,117,0,158,NULL),(1047,9,120,0,158,1),(1048,9,945,0,158,0),(1049,9,946,0,158,0),(1050,9,947,0,158,NULL),(1051,9,119,0,159,1),(1052,9,932,0,159,1),(1053,9,117,0,159,NULL),(1054,9,120,0,159,1),(1055,9,945,0,159,0),(1056,9,946,0,159,0),(1057,9,947,0,159,NULL),(1058,9,119,0,160,1),(1059,9,932,0,160,1),(1060,9,117,0,160,NULL),(1061,9,120,0,160,1),(1062,9,945,0,160,0),(1063,9,946,0,160,0),(1064,9,947,0,160,NULL),(1065,9,119,0,161,1),(1066,9,932,0,161,1),(1067,9,117,0,161,NULL),(1068,9,120,0,161,1),(1069,9,945,0,161,0),(1070,9,946,0,161,0),(1071,9,947,0,161,NULL),(1072,9,119,0,162,1),(1073,9,932,0,162,1),(1074,9,117,0,162,NULL),(1075,9,120,0,162,1),(1076,9,945,0,162,0),(1077,9,946,0,162,0),(1078,9,947,0,162,NULL),(1079,9,119,0,163,1),(1080,9,932,0,163,1),(1081,9,117,0,163,NULL),(1082,9,120,0,163,1),(1083,9,945,0,163,0),(1084,9,946,0,163,0),(1085,9,947,0,163,NULL),(1086,9,119,0,164,1),(1087,9,932,0,164,1),(1088,9,117,0,164,NULL),(1089,9,120,0,164,1),(1090,9,945,0,164,0),(1091,9,946,0,164,0),(1092,9,947,0,164,NULL),(1093,9,119,0,165,1),(1094,9,932,0,165,1),(1095,9,117,0,165,NULL),(1096,9,120,0,165,1),(1097,9,945,0,165,0),(1098,9,946,0,165,0),(1099,9,947,0,165,NULL),(1100,9,119,0,166,1),(1101,9,932,0,166,1),(1102,9,117,0,166,NULL),(1103,9,120,0,166,1),(1104,9,945,0,166,0),(1105,9,946,0,166,0),(1106,9,947,0,166,NULL),(1107,9,119,0,167,1),(1108,9,932,0,167,1),(1109,9,117,0,167,NULL),(1110,9,120,0,167,1),(1111,9,945,0,167,0),(1112,9,946,0,167,0),(1113,9,947,0,167,NULL),(1114,9,119,0,168,1),(1115,9,932,0,168,1),(1116,9,117,0,168,NULL),(1117,9,120,0,168,1),(1118,9,945,0,168,0),(1119,9,946,0,168,0),(1120,9,947,0,168,NULL),(1121,9,119,0,169,1),(1122,9,932,0,169,1),(1123,9,117,0,169,NULL),(1124,9,120,0,169,1),(1125,9,945,0,169,0),(1126,9,946,0,169,0),(1127,9,947,0,169,NULL),(1128,9,119,0,170,1),(1129,9,932,0,170,1),(1130,9,117,0,170,NULL),(1131,9,120,0,170,1),(1132,9,945,0,170,0),(1133,9,946,0,170,0),(1134,9,947,0,170,NULL),(1135,9,119,0,171,1),(1136,9,932,0,171,1),(1137,9,117,0,171,NULL),(1138,9,120,0,171,1),(1139,9,945,0,171,0),(1140,9,946,0,171,0),(1141,9,947,0,171,NULL),(1142,9,119,0,172,1),(1143,9,932,0,172,1),(1144,9,117,0,172,NULL),(1145,9,120,0,172,1),(1146,9,945,0,172,0),(1147,9,946,0,172,0),(1148,9,947,0,172,NULL),(1149,9,119,0,173,1),(1150,9,932,0,173,1),(1151,9,117,0,173,NULL),(1152,9,120,0,173,1),(1153,9,945,0,173,0),(1154,9,946,0,173,0),(1155,9,947,0,173,NULL),(1156,9,119,0,174,1),(1157,9,932,0,174,1),(1158,9,117,0,174,NULL),(1159,9,120,0,174,1),(1160,9,945,0,174,0),(1161,9,946,0,174,0),(1162,9,947,0,174,NULL),(1163,9,119,0,175,1),(1164,9,932,0,175,1),(1165,9,117,0,175,NULL),(1166,9,120,0,175,1),(1167,9,945,0,175,0),(1168,9,946,0,175,0),(1169,9,947,0,175,NULL),(1170,9,119,0,176,1),(1171,9,932,0,176,1),(1172,9,117,0,176,NULL),(1173,9,120,0,176,1),(1174,9,945,0,176,0),(1175,9,946,0,176,0),(1176,9,947,0,176,NULL),(1177,9,119,0,177,1),(1178,9,932,0,177,1),(1179,9,117,0,177,NULL),(1180,9,120,0,177,1),(1181,9,945,0,177,0),(1182,9,946,0,177,0),(1183,9,947,0,177,NULL),(1184,9,119,0,178,1),(1185,9,932,0,178,1),(1186,9,117,0,178,NULL),(1187,9,120,0,178,1),(1188,9,945,0,178,0),(1189,9,946,0,178,0),(1190,9,947,0,178,NULL),(1191,9,119,0,179,1),(1192,9,932,0,179,1),(1193,9,117,0,179,NULL),(1194,9,120,0,179,1),(1195,9,945,0,179,0),(1196,9,946,0,179,0),(1197,9,947,0,179,NULL),(1198,9,119,0,180,1),(1199,9,932,0,180,1),(1200,9,117,0,180,NULL),(1201,9,120,0,180,1),(1202,9,945,0,180,0),(1203,9,946,0,180,0),(1204,9,947,0,180,NULL),(1205,9,119,0,181,1),(1206,9,932,0,181,1),(1207,9,117,0,181,NULL),(1208,9,120,0,181,1),(1209,9,945,0,181,0),(1210,9,946,0,181,0),(1211,9,947,0,181,NULL),(1212,9,119,0,182,1),(1213,9,932,0,182,1),(1214,9,117,0,182,NULL),(1215,9,120,0,182,1),(1216,9,945,0,182,0),(1217,9,946,0,182,0),(1218,9,947,0,182,NULL),(1219,9,119,0,183,1),(1220,9,932,0,183,1),(1221,9,117,0,183,NULL),(1222,9,120,0,183,1),(1223,9,945,0,183,0),(1224,9,946,0,183,0),(1225,9,947,0,183,NULL),(1226,9,119,0,184,1),(1227,9,932,0,184,1),(1228,9,117,0,184,NULL),(1229,9,120,0,184,1),(1230,9,945,0,184,0),(1231,9,946,0,184,0),(1232,9,947,0,184,NULL),(1233,9,119,0,185,1),(1234,9,932,0,185,1),(1235,9,117,0,185,NULL),(1236,9,120,0,185,1),(1237,9,945,0,185,0),(1238,9,946,0,185,0),(1239,9,947,0,185,NULL),(1240,9,119,0,186,1),(1241,9,932,0,186,1),(1242,9,117,0,186,NULL),(1243,9,120,0,186,1),(1244,9,945,0,186,0),(1245,9,946,0,186,0),(1246,9,947,0,186,NULL),(1464,9,947,0,35,NULL),(1526,9,117,0,3,NULL),(1527,9,120,0,3,0),(1528,9,946,0,3,0),(1529,9,947,0,3,NULL);
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_BASE` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_ATTRIBUTE_TEXT_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_TEXT_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_TEXT_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_TEXT_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=913 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_text` VALUES (1,9,121,0,3,'3,18,4,5,16,17,19,24,10,22,23,13,8,12,26,25,15,20'),(4,9,123,0,3,'18,10,13,20'),(22,9,122,0,20,'20'),(46,9,122,0,3,''),(125,9,115,0,20,''),(126,9,530,0,20,''),(133,9,121,0,20,'20'),(134,9,123,0,20,''),(145,9,112,0,20,''),(146,9,116,0,20,''),(147,9,112,0,35,''),(148,9,115,0,35,''),(149,9,116,0,35,''),(150,9,530,0,35,''),(151,9,927,0,35,''),(153,9,112,0,36,''),(154,9,115,0,36,''),(155,9,116,0,36,''),(156,9,530,0,36,''),(157,9,927,0,36,''),(158,9,112,0,37,''),(159,9,115,0,37,'创意生日礼物,商务礼品,高档商务礼品,创意礼物,个性礼物,新奇创意小礼品,定制礼品'),(160,9,116,0,37,''),(161,9,530,0,37,''),(162,9,927,0,37,''),(163,9,112,0,38,''),(164,9,115,0,38,'创意礼品,个性定制创意礼品,创意生日礼物,企业礼品定制,创意礼品定制网站'),(165,9,116,0,38,''),(166,9,530,0,38,''),(167,9,927,0,38,''),(168,9,112,0,39,''),(169,9,115,0,39,'个性礼品定制,创意礼品,创意礼物,创意礼品定制,个性定制系统,个性定制软件,创意小礼品,生日礼物,个性定制礼物,个性定制礼品,新奇创意礼品'),(170,9,116,0,39,''),(171,9,530,0,39,''),(172,9,927,0,39,''),(173,9,112,0,40,''),(174,9,115,0,40,'个性定制手表,个性定制钟表,创意礼品钟表,礼品手表'),(175,9,116,0,40,''),(176,9,530,0,40,''),(177,9,927,0,40,''),(178,9,112,0,41,''),(179,9,115,0,41,''),(180,9,116,0,41,''),(181,9,530,0,41,''),(182,9,927,0,41,''),(183,9,112,0,42,''),(184,9,115,0,42,''),(185,9,116,0,42,''),(186,9,530,0,42,''),(187,9,927,0,42,''),(188,9,112,0,43,''),(189,9,115,0,43,''),(190,9,116,0,43,''),(191,9,530,0,43,''),(192,9,927,0,43,''),(193,9,112,0,44,''),(194,9,115,0,44,''),(195,9,116,0,44,''),(196,9,530,0,44,''),(197,9,927,0,44,''),(198,9,112,0,45,''),(199,9,115,0,45,''),(200,9,116,0,45,''),(201,9,530,0,45,''),(202,9,927,0,45,''),(203,9,112,0,46,''),(204,9,115,0,46,''),(205,9,116,0,46,''),(206,9,530,0,46,''),(207,9,927,0,46,''),(208,9,112,0,47,''),(209,9,115,0,47,''),(210,9,116,0,47,''),(211,9,530,0,47,''),(212,9,927,0,47,''),(213,9,112,0,48,''),(214,9,115,0,48,''),(215,9,116,0,48,''),(216,9,530,0,48,''),(217,9,927,0,48,''),(218,9,112,0,49,''),(219,9,115,0,49,''),(220,9,116,0,49,''),(221,9,530,0,49,''),(222,9,927,0,49,''),(223,9,112,0,50,''),(224,9,115,0,50,''),(225,9,116,0,50,''),(226,9,530,0,50,''),(227,9,927,0,50,''),(228,9,112,0,51,''),(229,9,115,0,51,''),(230,9,116,0,51,''),(231,9,530,0,51,''),(232,9,927,0,51,''),(233,9,112,0,52,''),(234,9,115,0,52,''),(235,9,116,0,52,''),(236,9,530,0,52,''),(237,9,927,0,52,''),(238,9,112,0,53,''),(239,9,115,0,53,''),(240,9,116,0,53,''),(241,9,530,0,53,''),(242,9,927,0,53,''),(243,9,112,0,54,''),(244,9,115,0,54,''),(245,9,116,0,54,''),(246,9,530,0,54,''),(247,9,927,0,54,''),(248,9,112,0,55,''),(249,9,115,0,55,''),(250,9,116,0,55,''),(251,9,530,0,55,''),(252,9,927,0,55,''),(253,9,112,0,56,''),(254,9,115,0,56,''),(255,9,116,0,56,''),(256,9,530,0,56,''),(257,9,927,0,56,''),(258,9,112,0,57,''),(259,9,115,0,57,''),(260,9,116,0,57,''),(261,9,530,0,57,''),(262,9,927,0,57,''),(263,9,112,0,58,''),(264,9,115,0,58,''),(265,9,116,0,58,''),(266,9,530,0,58,''),(267,9,927,0,58,''),(268,9,112,0,59,''),(269,9,115,0,59,''),(270,9,116,0,59,''),(271,9,530,0,59,''),(272,9,927,0,59,''),(273,9,112,0,60,''),(274,9,115,0,60,''),(275,9,116,0,60,''),(276,9,530,0,60,''),(277,9,927,0,60,''),(278,9,112,0,61,''),(279,9,115,0,61,''),(280,9,116,0,61,''),(281,9,530,0,61,''),(282,9,927,0,61,''),(283,9,112,0,62,''),(284,9,115,0,62,''),(285,9,116,0,62,''),(286,9,530,0,62,''),(287,9,927,0,62,''),(288,9,112,0,63,''),(289,9,115,0,63,''),(290,9,116,0,63,''),(291,9,530,0,63,''),(292,9,927,0,63,''),(293,9,112,0,64,''),(294,9,115,0,64,''),(295,9,116,0,64,''),(296,9,530,0,64,''),(297,9,927,0,64,''),(298,9,112,0,65,''),(299,9,115,0,65,''),(300,9,116,0,65,''),(301,9,530,0,65,''),(302,9,927,0,65,''),(303,9,112,0,66,''),(304,9,115,0,66,''),(305,9,116,0,66,''),(306,9,530,0,66,''),(307,9,927,0,66,''),(308,9,112,0,67,''),(309,9,115,0,67,''),(310,9,116,0,67,''),(311,9,530,0,67,''),(312,9,927,0,67,''),(313,9,112,0,68,''),(314,9,115,0,68,''),(315,9,116,0,68,''),(316,9,530,0,68,''),(317,9,927,0,68,''),(318,9,112,0,69,''),(319,9,115,0,69,''),(320,9,116,0,69,''),(321,9,530,0,69,''),(322,9,927,0,69,''),(323,9,112,0,70,''),(324,9,115,0,70,''),(325,9,116,0,70,''),(326,9,530,0,70,''),(327,9,927,0,70,''),(328,9,112,0,71,''),(329,9,115,0,71,''),(330,9,116,0,71,''),(331,9,530,0,71,''),(332,9,927,0,71,''),(333,9,112,0,72,''),(334,9,115,0,72,''),(335,9,116,0,72,''),(336,9,530,0,72,''),(337,9,927,0,72,''),(338,9,112,0,73,''),(339,9,115,0,73,''),(340,9,116,0,73,''),(341,9,530,0,73,''),(342,9,927,0,73,''),(343,9,112,0,74,''),(344,9,115,0,74,''),(345,9,116,0,74,''),(346,9,530,0,74,''),(347,9,927,0,74,''),(348,9,112,0,75,''),(349,9,115,0,75,''),(350,9,116,0,75,''),(351,9,530,0,75,''),(352,9,927,0,75,''),(353,9,112,0,76,''),(354,9,115,0,76,''),(355,9,116,0,76,''),(356,9,530,0,76,''),(357,9,927,0,76,''),(358,9,112,0,77,''),(359,9,115,0,77,''),(360,9,116,0,77,''),(361,9,530,0,77,''),(362,9,927,0,77,''),(363,9,112,0,78,''),(364,9,115,0,78,''),(365,9,116,0,78,''),(366,9,530,0,78,''),(367,9,927,0,78,''),(368,9,112,0,79,''),(369,9,115,0,79,''),(370,9,116,0,79,''),(371,9,530,0,79,''),(372,9,927,0,79,''),(373,9,112,0,80,''),(374,9,115,0,80,''),(375,9,116,0,80,''),(376,9,530,0,80,''),(377,9,927,0,80,''),(378,9,112,0,81,''),(379,9,115,0,81,''),(380,9,116,0,81,''),(381,9,530,0,81,''),(382,9,927,0,81,''),(383,9,112,0,82,''),(384,9,115,0,82,''),(385,9,116,0,82,''),(386,9,530,0,82,''),(387,9,927,0,82,''),(388,9,112,0,83,''),(389,9,115,0,83,''),(390,9,116,0,83,''),(391,9,530,0,83,''),(392,9,927,0,83,''),(393,9,112,0,84,''),(394,9,115,0,84,''),(395,9,116,0,84,''),(396,9,530,0,84,''),(397,9,927,0,84,''),(398,9,112,0,85,''),(399,9,115,0,85,''),(400,9,116,0,85,''),(401,9,530,0,85,''),(402,9,927,0,85,''),(403,9,112,0,86,''),(404,9,115,0,86,''),(405,9,116,0,86,''),(406,9,530,0,86,''),(407,9,927,0,86,''),(408,9,112,0,87,''),(409,9,115,0,87,''),(410,9,116,0,87,''),(411,9,530,0,87,''),(412,9,927,0,87,''),(413,9,112,0,88,''),(414,9,115,0,88,''),(415,9,116,0,88,''),(416,9,530,0,88,''),(417,9,927,0,88,''),(418,9,112,0,89,''),(419,9,115,0,89,''),(420,9,116,0,89,''),(421,9,530,0,89,''),(422,9,927,0,89,''),(423,9,112,0,90,''),(424,9,115,0,90,''),(425,9,116,0,90,''),(426,9,530,0,90,''),(427,9,927,0,90,''),(428,9,112,0,91,''),(429,9,115,0,91,''),(430,9,116,0,91,''),(431,9,530,0,91,''),(432,9,927,0,91,''),(433,9,112,0,92,''),(434,9,115,0,92,''),(435,9,116,0,92,''),(436,9,530,0,92,''),(437,9,927,0,92,''),(438,9,112,0,93,''),(439,9,115,0,93,''),(440,9,116,0,93,''),(441,9,530,0,93,''),(442,9,927,0,93,''),(443,9,112,0,94,''),(444,9,115,0,94,''),(445,9,116,0,94,''),(446,9,530,0,94,''),(447,9,927,0,94,''),(448,9,112,0,95,''),(449,9,115,0,95,''),(450,9,116,0,95,''),(451,9,530,0,95,''),(452,9,927,0,95,''),(453,9,112,0,96,''),(454,9,115,0,96,''),(455,9,116,0,96,''),(456,9,530,0,96,''),(457,9,927,0,96,''),(458,9,112,0,97,''),(459,9,115,0,97,''),(460,9,116,0,97,''),(461,9,530,0,97,''),(462,9,927,0,97,''),(463,9,112,0,98,''),(464,9,115,0,98,''),(465,9,116,0,98,''),(466,9,530,0,98,''),(467,9,927,0,98,''),(468,9,112,0,99,''),(469,9,115,0,99,''),(470,9,116,0,99,''),(471,9,530,0,99,''),(472,9,927,0,99,''),(473,9,112,0,100,''),(474,9,115,0,100,''),(475,9,116,0,100,''),(476,9,530,0,100,''),(477,9,927,0,100,''),(478,9,112,0,101,''),(479,9,115,0,101,''),(480,9,116,0,101,''),(481,9,530,0,101,''),(482,9,927,0,101,''),(483,9,112,0,102,''),(484,9,115,0,102,''),(485,9,116,0,102,''),(486,9,530,0,102,''),(487,9,927,0,102,''),(488,9,112,0,103,''),(489,9,115,0,103,''),(490,9,116,0,103,''),(491,9,530,0,103,''),(492,9,927,0,103,''),(493,9,112,0,104,''),(494,9,115,0,104,''),(495,9,116,0,104,''),(496,9,530,0,104,''),(497,9,927,0,104,''),(498,9,112,0,105,''),(499,9,115,0,105,''),(500,9,116,0,105,''),(501,9,530,0,105,''),(502,9,927,0,105,''),(503,9,112,0,106,''),(504,9,115,0,106,''),(505,9,116,0,106,''),(506,9,530,0,106,''),(507,9,927,0,106,''),(508,9,112,0,107,''),(509,9,115,0,107,''),(510,9,116,0,107,''),(511,9,530,0,107,''),(512,9,927,0,107,''),(513,9,112,0,108,''),(514,9,115,0,108,''),(515,9,116,0,108,''),(516,9,530,0,108,''),(517,9,927,0,108,''),(518,9,112,0,109,''),(519,9,115,0,109,''),(520,9,116,0,109,''),(521,9,530,0,109,''),(522,9,927,0,109,''),(523,9,112,0,110,''),(524,9,115,0,110,''),(525,9,116,0,110,''),(526,9,530,0,110,''),(527,9,927,0,110,''),(528,9,112,0,111,''),(529,9,115,0,111,''),(530,9,116,0,111,''),(531,9,530,0,111,''),(532,9,927,0,111,''),(533,9,112,0,112,''),(534,9,115,0,112,''),(535,9,116,0,112,''),(536,9,530,0,112,''),(537,9,927,0,112,''),(538,9,112,0,113,''),(539,9,115,0,113,''),(540,9,116,0,113,''),(541,9,530,0,113,''),(542,9,927,0,113,''),(543,9,112,0,114,''),(544,9,115,0,114,''),(545,9,116,0,114,''),(546,9,530,0,114,''),(547,9,927,0,114,''),(548,9,112,0,115,''),(549,9,115,0,115,''),(550,9,116,0,115,''),(551,9,530,0,115,''),(552,9,927,0,115,''),(553,9,112,0,116,''),(554,9,115,0,116,''),(555,9,116,0,116,''),(556,9,530,0,116,''),(557,9,927,0,116,''),(558,9,112,0,117,''),(559,9,115,0,117,''),(560,9,116,0,117,''),(561,9,530,0,117,''),(562,9,927,0,117,''),(563,9,112,0,118,''),(564,9,115,0,118,''),(565,9,116,0,118,''),(566,9,530,0,118,''),(567,9,927,0,118,''),(568,9,112,0,119,''),(569,9,115,0,119,''),(570,9,116,0,119,''),(571,9,530,0,119,''),(572,9,927,0,119,''),(573,9,112,0,120,''),(574,9,115,0,120,''),(575,9,116,0,120,''),(576,9,530,0,120,''),(577,9,927,0,120,''),(578,9,112,0,121,''),(579,9,115,0,121,''),(580,9,116,0,121,''),(581,9,530,0,121,''),(582,9,927,0,121,''),(583,9,112,0,122,''),(584,9,115,0,122,''),(585,9,116,0,122,''),(586,9,530,0,122,''),(587,9,927,0,122,''),(588,9,112,0,123,''),(589,9,115,0,123,''),(590,9,116,0,123,''),(591,9,530,0,123,''),(592,9,927,0,123,''),(593,9,112,0,124,''),(594,9,115,0,124,''),(595,9,116,0,124,''),(596,9,530,0,124,''),(597,9,927,0,124,''),(598,9,112,0,125,''),(599,9,115,0,125,''),(600,9,116,0,125,''),(601,9,530,0,125,''),(602,9,927,0,125,''),(603,9,112,0,126,''),(604,9,115,0,126,''),(605,9,116,0,126,''),(606,9,530,0,126,''),(607,9,927,0,126,''),(608,9,112,0,127,''),(609,9,115,0,127,''),(610,9,116,0,127,''),(611,9,530,0,127,''),(612,9,927,0,127,''),(613,9,112,0,128,''),(614,9,115,0,128,''),(615,9,116,0,128,''),(616,9,530,0,128,''),(617,9,927,0,128,''),(618,9,112,0,129,''),(619,9,115,0,129,''),(620,9,116,0,129,''),(621,9,530,0,129,''),(622,9,927,0,129,''),(623,9,112,0,130,''),(624,9,115,0,130,''),(625,9,116,0,130,''),(626,9,530,0,130,''),(627,9,927,0,130,''),(628,9,112,0,131,''),(629,9,115,0,131,''),(630,9,116,0,131,''),(631,9,530,0,131,''),(632,9,927,0,131,''),(633,9,112,0,132,''),(634,9,115,0,132,''),(635,9,116,0,132,''),(636,9,530,0,132,''),(637,9,927,0,132,''),(638,9,112,0,133,''),(639,9,115,0,133,''),(640,9,116,0,133,''),(641,9,530,0,133,''),(642,9,927,0,133,''),(643,9,112,0,134,''),(644,9,115,0,134,''),(645,9,116,0,134,''),(646,9,530,0,134,''),(647,9,927,0,134,''),(648,9,112,0,135,''),(649,9,115,0,135,''),(650,9,116,0,135,''),(651,9,530,0,135,''),(652,9,927,0,135,''),(653,9,112,0,136,''),(654,9,115,0,136,''),(655,9,116,0,136,''),(656,9,530,0,136,''),(657,9,927,0,136,''),(658,9,112,0,137,''),(659,9,115,0,137,''),(660,9,116,0,137,''),(661,9,530,0,137,''),(662,9,927,0,137,''),(663,9,112,0,138,''),(664,9,115,0,138,''),(665,9,116,0,138,''),(666,9,530,0,138,''),(667,9,927,0,138,''),(668,9,112,0,139,''),(669,9,115,0,139,''),(670,9,116,0,139,''),(671,9,530,0,139,''),(672,9,927,0,139,''),(673,9,112,0,140,''),(674,9,115,0,140,''),(675,9,116,0,140,''),(676,9,530,0,140,''),(677,9,927,0,140,''),(678,9,112,0,141,''),(679,9,115,0,141,''),(680,9,116,0,141,''),(681,9,530,0,141,''),(682,9,927,0,141,''),(683,9,112,0,142,''),(684,9,115,0,142,''),(685,9,116,0,142,''),(686,9,530,0,142,''),(687,9,927,0,142,''),(688,9,112,0,143,''),(689,9,115,0,143,''),(690,9,116,0,143,''),(691,9,530,0,143,''),(692,9,927,0,143,''),(693,9,112,0,144,''),(694,9,115,0,144,''),(695,9,116,0,144,''),(696,9,530,0,144,''),(697,9,927,0,144,''),(698,9,112,0,145,''),(699,9,115,0,145,''),(700,9,116,0,145,''),(701,9,530,0,145,''),(702,9,927,0,145,''),(703,9,112,0,146,''),(704,9,115,0,146,''),(705,9,116,0,146,''),(706,9,530,0,146,''),(707,9,927,0,146,''),(708,9,112,0,147,''),(709,9,115,0,147,''),(710,9,116,0,147,''),(711,9,530,0,147,''),(712,9,927,0,147,''),(713,9,112,0,148,''),(714,9,115,0,148,''),(715,9,116,0,148,''),(716,9,530,0,148,''),(717,9,927,0,148,''),(718,9,112,0,149,''),(719,9,115,0,149,''),(720,9,116,0,149,''),(721,9,530,0,149,''),(722,9,927,0,149,''),(723,9,112,0,150,''),(724,9,115,0,150,''),(725,9,116,0,150,''),(726,9,530,0,150,''),(727,9,927,0,150,''),(728,9,112,0,151,''),(729,9,115,0,151,''),(730,9,116,0,151,''),(731,9,530,0,151,''),(732,9,927,0,151,''),(733,9,112,0,152,''),(734,9,115,0,152,''),(735,9,116,0,152,''),(736,9,530,0,152,''),(737,9,927,0,152,''),(738,9,112,0,153,''),(739,9,115,0,153,''),(740,9,116,0,153,''),(741,9,530,0,153,''),(742,9,927,0,153,''),(743,9,112,0,154,''),(744,9,115,0,154,''),(745,9,116,0,154,''),(746,9,530,0,154,''),(747,9,927,0,154,''),(748,9,112,0,155,''),(749,9,115,0,155,''),(750,9,116,0,155,''),(751,9,530,0,155,''),(752,9,927,0,155,''),(753,9,112,0,156,''),(754,9,115,0,156,''),(755,9,116,0,156,''),(756,9,530,0,156,''),(757,9,927,0,156,''),(758,9,112,0,157,''),(759,9,115,0,157,''),(760,9,116,0,157,''),(761,9,530,0,157,''),(762,9,927,0,157,''),(763,9,112,0,158,''),(764,9,115,0,158,''),(765,9,116,0,158,''),(766,9,530,0,158,''),(767,9,927,0,158,''),(768,9,112,0,159,''),(769,9,115,0,159,''),(770,9,116,0,159,''),(771,9,530,0,159,''),(772,9,927,0,159,''),(773,9,112,0,160,''),(774,9,115,0,160,''),(775,9,116,0,160,''),(776,9,530,0,160,''),(777,9,927,0,160,''),(778,9,112,0,161,''),(779,9,115,0,161,''),(780,9,116,0,161,''),(781,9,530,0,161,''),(782,9,927,0,161,''),(783,9,112,0,162,''),(784,9,115,0,162,''),(785,9,116,0,162,''),(786,9,530,0,162,''),(787,9,927,0,162,''),(788,9,112,0,163,''),(789,9,115,0,163,''),(790,9,116,0,163,''),(791,9,530,0,163,''),(792,9,927,0,163,''),(793,9,112,0,164,''),(794,9,115,0,164,''),(795,9,116,0,164,''),(796,9,530,0,164,''),(797,9,927,0,164,''),(798,9,112,0,165,''),(799,9,115,0,165,''),(800,9,116,0,165,''),(801,9,530,0,165,''),(802,9,927,0,165,''),(803,9,112,0,166,''),(804,9,115,0,166,''),(805,9,116,0,166,''),(806,9,530,0,166,''),(807,9,927,0,166,''),(808,9,112,0,167,''),(809,9,115,0,167,''),(810,9,116,0,167,''),(811,9,530,0,167,''),(812,9,927,0,167,''),(813,9,112,0,168,''),(814,9,115,0,168,''),(815,9,116,0,168,''),(816,9,530,0,168,''),(817,9,927,0,168,''),(818,9,112,0,169,''),(819,9,115,0,169,''),(820,9,116,0,169,''),(821,9,530,0,169,''),(822,9,927,0,169,''),(823,9,112,0,170,''),(824,9,115,0,170,''),(825,9,116,0,170,''),(826,9,530,0,170,''),(827,9,927,0,170,''),(828,9,112,0,171,''),(829,9,115,0,171,''),(830,9,116,0,171,''),(831,9,530,0,171,''),(832,9,927,0,171,''),(833,9,112,0,172,''),(834,9,115,0,172,''),(835,9,116,0,172,''),(836,9,530,0,172,''),(837,9,927,0,172,''),(838,9,112,0,173,''),(839,9,115,0,173,''),(840,9,116,0,173,''),(841,9,530,0,173,''),(842,9,927,0,173,''),(843,9,112,0,174,''),(844,9,115,0,174,''),(845,9,116,0,174,''),(846,9,530,0,174,''),(847,9,927,0,174,''),(848,9,112,0,175,''),(849,9,115,0,175,''),(850,9,116,0,175,''),(851,9,530,0,175,''),(852,9,927,0,175,''),(853,9,112,0,176,''),(854,9,115,0,176,''),(855,9,116,0,176,''),(856,9,530,0,176,''),(857,9,927,0,176,''),(858,9,112,0,177,''),(859,9,115,0,177,''),(860,9,116,0,177,''),(861,9,530,0,177,''),(862,9,927,0,177,''),(863,9,112,0,178,''),(864,9,115,0,178,''),(865,9,116,0,178,''),(866,9,530,0,178,''),(867,9,927,0,178,''),(868,9,112,0,179,''),(869,9,115,0,179,''),(870,9,116,0,179,''),(871,9,530,0,179,''),(872,9,927,0,179,''),(873,9,112,0,180,''),(874,9,115,0,180,''),(875,9,116,0,180,''),(876,9,530,0,180,''),(877,9,927,0,180,''),(878,9,112,0,181,''),(879,9,115,0,181,''),(880,9,116,0,181,''),(881,9,530,0,181,''),(882,9,927,0,181,''),(883,9,112,0,182,''),(884,9,115,0,182,''),(885,9,116,0,182,''),(886,9,530,0,182,''),(887,9,927,0,182,''),(888,9,112,0,183,''),(889,9,115,0,183,''),(890,9,116,0,183,''),(891,9,530,0,183,''),(892,9,927,0,183,''),(893,9,112,0,184,''),(894,9,115,0,184,''),(895,9,116,0,184,''),(896,9,530,0,184,''),(897,9,927,0,184,''),(898,9,112,0,185,''),(899,9,115,0,185,''),(900,9,116,0,185,''),(901,9,530,0,185,''),(902,9,927,0,185,''),(903,9,112,0,186,''),(904,9,115,0,186,''),(905,9,116,0,186,''),(906,9,530,0,186,''),(907,9,927,0,186,''),(908,9,112,0,3,''),(909,9,115,0,3,''),(910,9,116,0,3,''),(911,9,530,0,3,''),(912,9,927,0,3,'');
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_BASE` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`) USING BTREE,
  KEY `FK_ATTRIBUTE_VARCHAR_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_VARCHAR_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_ENTITY_VARCHAR_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1699 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES (1,9,111,0,3,'Root Catalog'),(2,9,118,0,3,'PRODUCTS'),(3,9,479,0,3,'root-catalog'),(39,9,111,0,20,'Household Items'),(40,9,118,0,20,'PRODUCTS'),(41,9,479,0,20,'household-items'),(69,9,533,0,20,'household-items.html'),(177,9,114,0,20,''),(178,9,563,0,20,''),(179,9,514,0,20,''),(204,9,533,1,20,'household-items.html'),(205,9,111,0,35,'商家推荐商品'),(206,9,114,0,35,''),(207,9,479,0,35,'featured-products'),(208,9,118,0,35,'PRODUCTS'),(209,9,563,0,35,''),(210,9,514,0,35,''),(211,9,533,1,35,'featured-products.html'),(212,9,533,0,35,'featured-products.html'),(213,9,111,0,36,'节日庆典'),(214,9,114,0,36,''),(215,9,479,0,36,'occasion'),(216,9,118,0,36,'PRODUCTS_AND_PAGE'),(217,9,563,0,36,''),(218,9,514,0,36,''),(219,9,533,1,36,'occasion.html'),(220,9,533,0,36,'occasion.html'),(221,9,111,0,37,'送礼对象'),(222,9,114,0,37,''),(223,9,479,0,37,'recipients'),(224,9,118,0,37,'PRODUCTS_AND_PAGE'),(225,9,563,0,37,''),(226,9,514,0,37,''),(227,9,533,1,37,'recipients.html'),(228,9,533,0,37,'recipients.html'),(229,9,111,0,38,'创意礼品'),(230,9,114,0,38,''),(231,9,479,0,38,'gifts'),(232,9,118,0,38,'PRODUCTS_AND_PAGE'),(233,9,563,0,38,''),(234,9,514,0,38,''),(235,9,533,1,38,'gifts.html'),(236,9,533,0,38,'gifts.html'),(237,9,111,0,39,'个性定制'),(238,9,114,0,39,''),(239,9,479,0,39,'diy'),(240,9,118,0,39,'PRODUCTS_AND_PAGE'),(241,9,563,0,39,''),(242,9,514,0,39,''),(243,9,533,1,39,'diy.html'),(244,9,533,0,39,'diy.html'),(245,9,111,0,40,'钟表'),(246,9,114,0,40,''),(247,9,479,0,40,'watch'),(248,9,118,0,40,'PRODUCTS_AND_PAGE'),(249,9,563,0,40,''),(250,9,514,0,40,''),(251,9,533,1,40,'watch.html'),(252,9,533,0,40,'watch.html'),(257,9,111,0,41,'迪士尼定制手表'),(258,9,114,0,41,''),(259,9,479,0,41,'disney-watches'),(260,9,118,0,41,'PRODUCTS'),(261,9,563,0,41,''),(262,9,514,0,41,''),(263,9,533,1,41,'watch/disney-watches.html'),(264,9,533,0,41,'watch/disney-watches.html'),(265,9,111,0,42,'闹钟'),(266,9,114,0,42,''),(267,9,479,0,42,'alarm-clock'),(268,9,118,0,42,'PRODUCTS_AND_PAGE'),(269,9,563,0,42,''),(270,9,514,0,42,''),(271,9,533,1,42,'watch/alarm-clock.html'),(272,9,533,0,42,'watch/alarm-clock.html'),(273,9,111,0,43,'座钟'),(274,9,114,0,43,''),(275,9,479,0,43,'timepiece'),(276,9,118,0,43,'PRODUCTS'),(277,9,563,0,43,''),(278,9,514,0,43,''),(279,9,533,1,43,'watch/timepiece.html'),(280,9,533,0,43,'watch/timepiece.html'),(281,9,111,0,44,'个性定制手表'),(282,9,114,0,44,''),(283,9,479,0,44,'personalized-custom-watches'),(284,9,118,0,44,'PRODUCTS_AND_PAGE'),(285,9,563,0,44,''),(286,9,514,0,44,''),(287,9,533,1,44,'watch/personalized-custom-watches.html'),(288,9,533,0,44,'watch/personalized-custom-watches.html'),(289,9,111,0,45,'饰品'),(290,9,114,0,45,''),(291,9,479,0,45,'jewelry'),(292,9,118,0,45,'PRODUCTS_AND_PAGE'),(293,9,563,0,45,''),(294,9,514,0,45,''),(295,9,533,1,45,'jewelry.html'),(296,9,533,0,45,'jewelry.html'),(297,9,111,0,46,'项链'),(298,9,114,0,46,''),(299,9,479,0,46,'necklace'),(300,9,118,0,46,'PRODUCTS_AND_PAGE'),(301,9,563,0,46,''),(302,9,514,0,46,''),(303,9,533,1,46,'jewelry/necklace.html'),(304,9,533,0,46,'jewelry/necklace.html'),(305,9,111,0,47,'手链'),(306,9,114,0,47,''),(307,9,479,0,47,'bracelet'),(308,9,118,0,47,'PRODUCTS_AND_PAGE'),(309,9,563,0,47,''),(310,9,514,0,47,''),(311,9,533,1,47,'jewelry/bracelet.html'),(312,9,533,0,47,'jewelry/bracelet.html'),(313,9,111,0,48,'耳环'),(314,9,114,0,48,''),(315,9,479,0,48,'earring'),(316,9,118,0,48,'PRODUCTS_AND_PAGE'),(317,9,563,0,48,''),(318,9,514,0,48,''),(319,9,533,1,48,'jewelry/earring.html'),(320,9,533,0,48,'jewelry/earring.html'),(321,9,111,0,49,'戒指'),(322,9,114,0,49,''),(323,9,479,0,49,'ring'),(324,9,118,0,49,'PRODUCTS_AND_PAGE'),(325,9,563,0,49,''),(326,9,514,0,49,''),(327,9,533,1,49,'jewelry/ring.html'),(328,9,533,0,49,'jewelry/ring.html'),(329,9,111,0,50,'U盘'),(330,9,114,0,50,''),(331,9,479,0,50,'usb-card'),(332,9,118,0,50,'PRODUCTS_AND_PAGE'),(333,9,563,0,50,''),(334,9,514,0,50,''),(335,9,533,1,50,'usb-card.html'),(336,9,533,0,50,'usb-card.html'),(337,9,111,0,51,'卡片式U盘'),(338,9,114,0,51,''),(339,9,479,0,51,'u-disk-card'),(340,9,118,0,51,'PRODUCTS_AND_PAGE'),(341,9,563,0,51,''),(342,9,514,0,51,''),(343,9,533,1,51,'usb-card/u-disk-card.html'),(344,9,533,0,51,'usb-card/u-disk-card.html'),(345,9,111,0,52,'木制U盘'),(346,9,114,0,52,''),(347,9,479,0,52,'wodden-usb-disk'),(348,9,118,0,52,'PRODUCTS_AND_PAGE'),(349,9,563,0,52,''),(350,9,514,0,52,''),(351,9,533,1,52,'usb-card/wodden-usb-disk.html'),(352,9,533,0,52,'usb-card/wodden-usb-disk.html'),(353,9,111,0,53,'皮革U盘'),(354,9,114,0,53,''),(355,9,479,0,53,'leather-usb-disk'),(356,9,118,0,53,'PRODUCTS_AND_PAGE'),(357,9,563,0,53,''),(358,9,514,0,53,''),(359,9,533,1,53,'usb-card/leather-usb-disk.html'),(360,9,533,0,53,'usb-card/leather-usb-disk.html'),(361,9,111,0,54,'金属U盘'),(362,9,114,0,54,''),(363,9,479,0,54,'metal-usb-disk'),(364,9,118,0,54,'PRODUCTS_AND_PAGE'),(365,9,563,0,54,''),(366,9,514,0,54,''),(367,9,533,1,54,'usb-card/metal-usb-disk.html'),(368,9,533,0,54,'usb-card/metal-usb-disk.html'),(369,9,111,0,55,'青花瓷U盘'),(370,9,114,0,55,''),(371,9,479,0,55,'white-porcelain-usb-disk'),(372,9,118,0,55,'PRODUCTS_AND_PAGE'),(373,9,563,0,55,''),(374,9,514,0,55,''),(375,9,533,1,55,'usb-card/white-porcelain-usb-disk.html'),(376,9,533,0,55,'usb-card/white-porcelain-usb-disk.html'),(377,9,111,0,56,'数码配件'),(378,9,114,0,56,''),(379,9,479,0,56,'digital-accessories'),(380,9,118,0,56,'PRODUCTS_AND_PAGE'),(381,9,563,0,56,''),(382,9,514,0,56,''),(383,9,533,1,56,'digital-accessories.html'),(384,9,533,0,56,'digital-accessories.html'),(385,9,111,0,57,'浮雕手机外壳'),(386,9,114,0,57,''),(387,9,479,0,57,'fudiao-phone-case'),(388,9,118,0,57,'PRODUCTS_AND_PAGE'),(389,9,563,0,57,''),(390,9,514,0,57,''),(391,9,533,1,57,'digital-accessories/fudiao-phone-case.html'),(392,9,533,0,57,'digital-accessories/fudiao-phone-case.html'),(393,9,111,0,58,'刻字手机外壳'),(394,9,114,0,58,''),(395,9,479,0,58,'kezi-phone-case'),(396,9,118,0,58,'PRODUCTS_AND_PAGE'),(397,9,563,0,58,''),(398,9,514,0,58,''),(399,9,533,1,58,'digital-accessories/kezi-phone-case.html'),(400,9,533,0,58,'digital-accessories/kezi-phone-case.html'),(401,9,111,0,59,'彩印手机外壳'),(402,9,114,0,59,''),(403,9,479,0,59,'caihui-phone-case'),(404,9,118,0,59,'PRODUCTS_AND_PAGE'),(405,9,563,0,59,''),(406,9,514,0,59,''),(407,9,533,1,59,'digital-accessories/caihui-phone-case.html'),(408,9,533,0,59,'digital-accessories/caihui-phone-case.html'),(409,9,111,0,60,'鼠标'),(410,9,114,0,60,''),(411,9,479,0,60,'mouse'),(412,9,118,0,60,'PRODUCTS_AND_PAGE'),(413,9,563,0,60,''),(414,9,514,0,60,''),(415,9,533,1,60,'digital-accessories/mouse.html'),(416,9,533,0,60,'digital-accessories/mouse.html'),(417,9,111,0,61,'电脑内胆包'),(418,9,114,0,61,''),(419,9,479,0,61,'computer-sleeve'),(420,9,118,0,61,'PRODUCTS_AND_PAGE'),(421,9,563,0,61,''),(422,9,514,0,61,''),(423,9,533,1,61,'digital-accessories/computer-sleeve.html'),(424,9,533,0,61,'digital-accessories/computer-sleeve.html'),(425,9,111,0,62,'MP3'),(426,9,114,0,62,''),(427,9,479,0,62,'mp3'),(428,9,118,0,62,'PRODUCTS_AND_PAGE'),(429,9,563,0,62,''),(430,9,514,0,62,''),(431,9,533,1,62,'digital-accessories/mp3.html'),(432,9,533,0,62,'digital-accessories/mp3.html'),(433,9,111,0,63,'CD包'),(434,9,114,0,63,''),(435,9,479,0,63,'cd-bag'),(436,9,118,0,63,'PRODUCTS_AND_PAGE'),(437,9,563,0,63,''),(438,9,514,0,63,''),(439,9,533,1,63,'digital-accessories/cd-bag.html'),(440,9,533,0,63,'digital-accessories/cd-bag.html'),(441,9,111,0,64,'CD'),(442,9,114,0,64,''),(443,9,479,0,64,'cd'),(444,9,118,0,64,'PRODUCTS_AND_PAGE'),(445,9,563,0,64,''),(446,9,514,0,64,''),(447,9,533,1,64,'digital-accessories/cd.html'),(448,9,533,0,64,'digital-accessories/cd.html'),(449,9,111,0,65,'平板电脑'),(450,9,114,0,65,''),(451,9,479,0,65,'tablet-pc'),(452,9,118,0,65,'PRODUCTS_AND_PAGE'),(453,9,563,0,65,''),(454,9,514,0,65,''),(455,9,533,1,65,'digital-accessories/tablet-pc.html'),(456,9,533,0,65,'digital-accessories/tablet-pc.html'),(457,9,111,0,66,'定制iPhone4壳'),(458,9,114,0,66,''),(459,9,479,0,66,'customize-iphone4-case'),(460,9,118,0,66,'PRODUCTS_AND_PAGE'),(461,9,563,0,66,''),(462,9,514,0,66,''),(463,9,533,1,66,'digital-accessories/customize-iphone4-case.html'),(464,9,533,0,66,'digital-accessories/customize-iphone4-case.html'),(465,9,111,0,67,'杯子'),(466,9,114,0,67,''),(467,9,479,0,67,'cups'),(468,9,118,0,67,'PRODUCTS_AND_PAGE'),(469,9,563,0,67,''),(470,9,514,0,67,''),(471,9,533,1,67,'cups.html'),(472,9,533,0,67,'cups.html'),(473,9,111,0,68,'马克杯'),(474,9,114,0,68,''),(475,9,479,0,68,'mug'),(476,9,118,0,68,'PRODUCTS_AND_PAGE'),(477,9,563,0,68,''),(478,9,514,0,68,''),(479,9,533,1,68,'cups/mug.html'),(480,9,533,0,68,'cups/mug.html'),(481,9,111,0,69,'骨瓷杯'),(482,9,114,0,69,''),(483,9,479,0,69,'bone-cup'),(484,9,118,0,69,'PRODUCTS_AND_PAGE'),(485,9,563,0,69,''),(486,9,514,0,69,''),(487,9,533,1,69,'cups/bone-cup.html'),(488,9,533,0,69,'cups/bone-cup.html'),(489,9,111,0,70,'咖啡杯'),(490,9,114,0,70,''),(491,9,479,0,70,'coffee-cup'),(492,9,118,0,70,'PRODUCTS_AND_PAGE'),(493,9,563,0,70,''),(494,9,514,0,70,''),(495,9,533,1,70,'cups/coffee-cup.html'),(496,9,533,0,70,'cups/coffee-cup.html'),(497,9,111,0,71,'变色杯'),(498,9,114,0,71,''),(499,9,479,0,71,'color-cup'),(500,9,118,0,71,'PRODUCTS_AND_PAGE'),(501,9,563,0,71,''),(502,9,514,0,71,''),(503,9,533,1,71,'cups/color-cup.html'),(504,9,533,0,71,'cups/color-cup.html'),(505,9,111,0,72,'水晶'),(506,9,114,0,72,''),(507,9,479,0,72,'crystal'),(508,9,118,0,72,'PRODUCTS_AND_PAGE'),(509,9,563,0,72,''),(510,9,514,0,72,''),(511,9,533,1,72,'crystal.html'),(512,9,533,0,72,'crystal.html'),(513,9,111,0,73,'彩印水晶'),(514,9,114,0,73,''),(515,9,479,0,73,'caiyi-crystal'),(516,9,118,0,73,'PRODUCTS_AND_PAGE'),(517,9,563,0,73,''),(518,9,514,0,73,''),(519,9,533,1,73,'crystal/caiyi-crystal.html'),(520,9,533,0,73,'crystal/caiyi-crystal.html'),(521,9,111,0,74,'雕刻水晶'),(522,9,114,0,74,''),(523,9,479,0,74,'diaoke-crystal'),(524,9,118,0,74,'PRODUCTS_AND_PAGE'),(525,9,563,0,74,''),(526,9,514,0,74,''),(527,9,533,1,74,'crystal/diaoke-crystal.html'),(528,9,533,0,74,'crystal/diaoke-crystal.html'),(529,9,111,0,75,'水晶名片座'),(530,9,114,0,75,''),(531,9,479,0,75,'crystal-card-holder'),(532,9,118,0,75,'PRODUCTS_AND_PAGE'),(533,9,563,0,75,''),(534,9,514,0,75,''),(535,9,533,1,75,'crystal/crystal-card-holder.html'),(536,9,533,0,75,'crystal/crystal-card-holder.html'),(537,9,111,0,76,'内雕水晶'),(538,9,114,0,76,''),(539,9,479,0,76,'laser-crystal'),(540,9,118,0,76,'PRODUCTS_AND_PAGE'),(541,9,563,0,76,''),(542,9,514,0,76,''),(543,9,533,1,76,'crystal/laser-crystal.html'),(544,9,533,0,76,'crystal/laser-crystal.html'),(545,9,111,0,77,'水晶奖杯'),(546,9,114,0,77,''),(547,9,479,0,77,'crystal-trophy'),(548,9,118,0,77,'PRODUCTS_AND_PAGE'),(549,9,563,0,77,''),(550,9,514,0,77,''),(551,9,533,1,77,'crystal/crystal-trophy.html'),(552,9,533,0,77,'crystal/crystal-trophy.html'),(554,9,111,0,78,'办公用品与文具'),(555,9,114,0,78,''),(556,9,479,0,78,'office-supplies'),(557,9,118,0,78,'PRODUCTS_AND_PAGE'),(558,9,563,0,78,''),(559,9,514,0,78,''),(560,9,533,1,78,'office-supplies.html'),(561,9,533,0,78,'office-supplies.html'),(562,9,111,0,79,'宝珠笔'),(563,9,114,0,79,''),(564,9,479,0,79,'roller-pen'),(565,9,118,0,79,'PRODUCTS_AND_PAGE'),(566,9,563,0,79,''),(567,9,514,0,79,''),(568,9,533,1,79,'office-supplies/roller-pen.html'),(569,9,533,0,79,'office-supplies/roller-pen.html'),(570,9,111,0,80,'名片盒'),(571,9,114,0,80,''),(572,9,479,0,80,'cardcase'),(573,9,118,0,80,'PRODUCTS_AND_PAGE'),(574,9,563,0,80,''),(575,9,514,0,80,''),(576,9,533,1,80,'office-supplies/cardcase.html'),(577,9,533,0,80,'office-supplies/cardcase.html'),(578,9,111,0,81,'记事本'),(579,9,114,0,81,''),(580,9,479,0,81,'notepad'),(581,9,118,0,81,'PRODUCTS_AND_PAGE'),(582,9,563,0,81,''),(583,9,514,0,81,''),(584,9,533,1,81,'office-supplies/notepad.html'),(585,9,533,0,81,'office-supplies/notepad.html'),(586,9,111,0,82,'书签'),(587,9,114,0,82,''),(588,9,479,0,82,'bookmark'),(589,9,118,0,82,'PRODUCTS_AND_PAGE'),(590,9,563,0,82,''),(591,9,514,0,82,''),(592,9,533,1,82,'office-supplies/bookmark.html'),(593,9,533,0,82,'office-supplies/bookmark.html'),(594,9,111,0,83,'鼠标垫'),(595,9,114,0,83,''),(596,9,479,0,83,'mouse-mat'),(597,9,118,0,83,'PRODUCTS_AND_PAGE'),(598,9,563,0,83,''),(599,9,514,0,83,''),(600,9,533,1,83,'office-supplies/mouse-mat.html'),(601,9,533,0,83,'office-supplies/mouse-mat.html'),(602,9,111,0,84,'放大镜'),(603,9,114,0,84,''),(604,9,479,0,84,'magnifier'),(605,9,118,0,84,'PRODUCTS_AND_PAGE'),(606,9,563,0,84,''),(607,9,514,0,84,''),(608,9,533,1,84,'office-supplies/magnifier.html'),(609,9,533,0,84,'office-supplies/magnifier.html'),(610,9,111,0,85,'名片'),(611,9,114,0,85,''),(612,9,479,0,85,'business-card'),(613,9,118,0,85,'PRODUCTS_AND_PAGE'),(614,9,563,0,85,''),(615,9,514,0,85,''),(616,9,533,1,85,'office-supplies/business-card.html'),(617,9,533,0,85,'office-supplies/business-card.html'),(618,9,111,0,86,'文具盒'),(619,9,114,0,86,''),(620,9,479,0,86,'writing-case'),(621,9,118,0,86,'PRODUCTS_AND_PAGE'),(622,9,563,0,86,''),(623,9,514,0,86,''),(624,9,533,1,86,'office-supplies/writing-case.html'),(625,9,533,0,86,'office-supplies/writing-case.html'),(626,9,111,0,87,'直尺'),(627,9,114,0,87,''),(628,9,479,0,87,'ruler'),(629,9,118,0,87,'PRODUCTS_AND_PAGE'),(630,9,563,0,87,''),(631,9,514,0,87,''),(632,9,533,1,87,'office-supplies/ruler.html'),(633,9,533,0,87,'office-supplies/ruler.html'),(634,9,111,0,88,'笔筒'),(635,9,114,0,88,''),(636,9,479,0,88,'brush-pot'),(637,9,118,0,88,'PRODUCTS_AND_PAGE'),(638,9,563,0,88,''),(639,9,514,0,88,''),(640,9,533,1,88,'office-supplies/brush-pot.html'),(641,9,533,0,88,'office-supplies/brush-pot.html'),(643,9,111,0,89,'铱金钢笔'),(644,9,114,0,89,''),(645,9,479,0,89,'pen'),(646,9,118,0,89,'PRODUCTS_AND_PAGE'),(647,9,563,0,89,''),(648,9,514,0,89,''),(649,9,533,1,89,'office-supplies/pen.html'),(650,9,533,0,89,'office-supplies/pen.html'),(651,9,111,0,90,'商务礼品'),(652,9,114,0,90,''),(653,9,479,0,90,'business-gifts'),(654,9,118,0,90,'PRODUCTS_AND_PAGE'),(655,9,563,0,90,''),(656,9,514,0,90,''),(657,9,533,1,90,'business-gifts.html'),(658,9,533,0,90,'business-gifts.html'),(659,9,111,0,91,'奖牌'),(660,9,114,0,91,''),(661,9,479,0,91,'medal'),(662,9,118,0,91,'PRODUCTS_AND_PAGE'),(663,9,563,0,91,''),(664,9,514,0,91,''),(665,9,533,1,91,'business-gifts/medal.html'),(666,9,533,0,91,'business-gifts/medal.html'),(667,9,111,0,92,'香水座'),(668,9,114,0,92,''),(669,9,479,0,92,'perfume-bottle'),(670,9,118,0,92,'PRODUCTS_AND_PAGE'),(671,9,563,0,92,''),(672,9,514,0,92,''),(673,9,533,1,92,'business-gifts/perfume-bottle.html'),(674,9,533,0,92,'business-gifts/perfume-bottle.html'),(675,9,111,0,93,'红木礼品套装'),(676,9,114,0,93,''),(677,9,479,0,93,'rosewood-gift-set'),(678,9,118,0,93,'PRODUCTS_AND_PAGE'),(679,9,563,0,93,''),(680,9,514,0,93,''),(681,9,533,1,93,'business-gifts/rosewood-gift-set.html'),(682,9,533,0,93,'business-gifts/rosewood-gift-set.html'),(683,9,111,0,94,'其它礼品套装'),(684,9,114,0,94,''),(685,9,479,0,94,'other-gift-sets'),(686,9,118,0,94,'PRODUCTS_AND_PAGE'),(687,9,563,0,94,''),(688,9,514,0,94,''),(689,9,533,1,94,'business-gifts/other-gift-sets.html'),(690,9,533,0,94,'business-gifts/other-gift-sets.html'),(691,9,111,0,95,'工艺船'),(692,9,114,0,95,''),(693,9,479,0,95,'boat'),(694,9,118,0,95,'PRODUCTS_AND_PAGE'),(695,9,563,0,95,''),(696,9,514,0,95,''),(697,9,533,1,95,'business-gifts/boat.html'),(698,9,533,0,95,'business-gifts/boat.html'),(699,9,111,0,96,'配饰'),(700,9,114,0,96,''),(701,9,479,0,96,'accessories'),(702,9,118,0,96,'PRODUCTS_AND_PAGE'),(703,9,563,0,96,''),(704,9,514,0,96,''),(705,9,533,1,96,'accessories.html'),(706,9,533,0,96,'accessories.html'),(707,9,111,0,97,'酒壶'),(708,9,114,0,97,''),(709,9,479,0,97,'flagon'),(710,9,118,0,97,'PRODUCTS_AND_PAGE'),(711,9,563,0,97,''),(712,9,514,0,97,''),(713,9,533,1,97,'accessories/flagon.html'),(714,9,533,0,97,'accessories/flagon.html'),(715,9,111,0,98,'个性化徽章'),(716,9,114,0,98,''),(717,9,479,0,98,'personalized-badges'),(718,9,118,0,98,'PRODUCTS_AND_PAGE'),(719,9,563,0,98,''),(720,9,514,0,98,''),(721,9,533,1,98,'accessories/personalized-badges.html'),(722,9,533,0,98,'accessories/personalized-badges.html'),(723,9,111,0,99,'烟盒'),(724,9,114,0,99,''),(725,9,479,0,99,'cigarette-case'),(726,9,118,0,99,'PRODUCTS_AND_PAGE'),(727,9,563,0,99,''),(728,9,514,0,99,''),(729,9,533,1,99,'accessories/cigarette-case.html'),(730,9,533,0,99,'accessories/cigarette-case.html'),(731,9,111,0,100,'梳子'),(732,9,114,0,100,''),(733,9,479,0,100,'comb'),(734,9,118,0,100,'PRODUCTS_AND_PAGE'),(735,9,563,0,100,''),(736,9,514,0,100,''),(737,9,533,1,100,'accessories/comb.html'),(738,9,533,0,100,'accessories/comb.html'),(739,9,111,0,101,'卡包'),(740,9,114,0,101,''),(741,9,479,0,101,'card-package'),(742,9,118,0,101,'PRODUCTS_AND_PAGE'),(743,9,563,0,101,''),(744,9,514,0,101,''),(745,9,533,1,101,'accessories/card-package.html'),(746,9,533,0,101,'accessories/card-package.html'),(747,9,111,0,102,'眼镜'),(748,9,114,0,102,''),(749,9,479,0,102,'glasses'),(750,9,118,0,102,'PRODUCTS_AND_PAGE'),(751,9,563,0,102,''),(752,9,514,0,102,''),(753,9,533,1,102,'accessories/glasses.html'),(754,9,533,0,102,'accessories/glasses.html'),(755,9,111,0,103,'钥匙包'),(756,9,114,0,103,''),(757,9,479,0,103,'key-cases'),(758,9,118,0,103,'PRODUCTS_AND_PAGE'),(759,9,563,0,103,''),(760,9,514,0,103,''),(761,9,533,1,103,'accessories/key-cases.html'),(762,9,533,0,103,'accessories/key-cases.html'),(763,9,111,0,104,'ZIPPO打火机'),(764,9,114,0,104,''),(765,9,479,0,104,'zippo-lighter'),(766,9,118,0,104,'PRODUCTS_AND_PAGE'),(767,9,563,0,104,''),(768,9,514,0,104,''),(769,9,533,1,104,'accessories/zippo-lighter.html'),(770,9,533,0,104,'accessories/zippo-lighter.html'),(771,9,111,0,105,'青花瓷打火机'),(772,9,114,0,105,''),(773,9,479,0,105,'qinghua-lighter'),(774,9,118,0,105,'PRODUCTS_AND_PAGE'),(775,9,563,0,105,''),(776,9,514,0,105,''),(777,9,533,1,105,'accessories/qinghua-lighter.html'),(778,9,533,0,105,'accessories/qinghua-lighter.html'),(779,9,111,0,106,'皮夹'),(780,9,114,0,106,''),(781,9,479,0,106,'wallet'),(782,9,118,0,106,'PRODUCTS_AND_PAGE'),(783,9,563,0,106,''),(784,9,514,0,106,''),(785,9,533,1,106,'accessories/wallet.html'),(786,9,533,0,106,'accessories/wallet.html'),(787,9,111,0,107,'化妆镜'),(788,9,114,0,107,''),(789,9,479,0,107,'vanity-mirron'),(790,9,118,0,107,'PRODUCTS_AND_PAGE'),(791,9,563,0,107,''),(792,9,514,0,107,''),(793,9,533,1,107,'accessories/vanity-mirron.html'),(794,9,533,0,107,'accessories/vanity-mirron.html'),(795,9,111,0,108,'钱包'),(796,9,114,0,108,''),(797,9,479,0,108,'purse'),(798,9,118,0,108,'PRODUCTS_AND_PAGE'),(799,9,563,0,108,''),(800,9,514,0,108,''),(801,9,533,1,108,'accessories/purse.html'),(802,9,533,0,108,'accessories/purse.html'),(803,9,111,0,109,'音乐盒'),(804,9,114,0,109,''),(805,9,479,0,109,'music-box'),(806,9,118,0,109,'PRODUCTS_AND_PAGE'),(807,9,563,0,109,''),(808,9,514,0,109,''),(809,9,533,1,109,'accessories/music-box.html'),(810,9,533,0,109,'accessories/music-box.html'),(811,9,111,0,110,'相框'),(812,9,114,0,110,''),(813,9,479,0,110,'photo-frame'),(814,9,118,0,110,'PRODUCTS_AND_PAGE'),(815,9,563,0,110,''),(816,9,514,0,110,''),(817,9,533,1,110,'photo-frame.html'),(818,9,533,0,110,'photo-frame.html'),(819,9,111,0,111,'木制相框'),(820,9,114,0,111,''),(821,9,479,0,111,'wooden-photo-frame'),(822,9,118,0,111,'PRODUCTS_AND_PAGE'),(823,9,563,0,111,''),(824,9,514,0,111,''),(825,9,533,1,111,'photo-frame/wooden-photo-frame.html'),(826,9,533,0,111,'photo-frame/wooden-photo-frame.html'),(827,9,111,0,112,'金属相框'),(828,9,114,0,112,''),(829,9,479,0,112,'metal-photo-frame'),(830,9,118,0,112,'PRODUCTS_AND_PAGE'),(831,9,563,0,112,''),(832,9,514,0,112,''),(833,9,533,1,112,'photo-frame/metal-photo-frame.html'),(834,9,533,0,112,'photo-frame/metal-photo-frame.html'),(835,9,111,0,113,'水晶相框'),(836,9,114,0,113,''),(837,9,479,0,113,'crystal-photo-frame'),(838,9,118,0,113,'PRODUCTS_AND_PAGE'),(839,9,563,0,113,''),(840,9,514,0,113,''),(841,9,533,1,113,'photo-frame/crystal-photo-frame.html'),(842,9,533,0,113,'photo-frame/crystal-photo-frame.html'),(844,9,111,0,114,'皮质相框'),(845,9,114,0,114,''),(846,9,479,0,114,'cortex-photo-frame'),(847,9,118,0,114,'PRODUCTS_AND_PAGE'),(848,9,563,0,114,''),(849,9,514,0,114,''),(850,9,533,1,114,'photo-frame/cortex-photo-frame.html'),(851,9,533,0,114,'photo-frame/cortex-photo-frame.html'),(852,9,111,0,115,'相 册'),(853,9,114,0,115,''),(854,9,479,0,115,'album'),(855,9,118,0,115,'PRODUCTS_AND_PAGE'),(856,9,563,0,115,''),(857,9,514,0,115,''),(858,9,533,1,115,'photo-frame/album.html'),(859,9,533,0,115,'photo-frame/album.html'),(860,9,111,0,116,'亚克力相框'),(861,9,114,0,116,''),(862,9,479,0,116,'acrylic-photo-frame'),(863,9,118,0,116,'PRODUCTS_AND_PAGE'),(864,9,563,0,116,''),(865,9,514,0,116,''),(866,9,533,1,116,'photo-frame/acrylic-photo-frame.html'),(867,9,533,0,116,'photo-frame/acrylic-photo-frame.html'),(868,9,111,0,117,'家居装饰'),(869,9,114,0,117,''),(870,9,479,0,117,'home-decoration'),(871,9,118,0,117,'PRODUCTS_AND_PAGE'),(872,9,563,0,117,''),(873,9,514,0,117,''),(874,9,533,1,117,'home-decoration.html'),(875,9,533,0,117,'home-decoration.html'),(876,9,111,0,118,'玻璃杯'),(877,9,114,0,118,''),(878,9,479,0,118,'glass'),(879,9,118,0,118,'PRODUCTS_AND_PAGE'),(880,9,563,0,118,''),(881,9,514,0,118,''),(882,9,533,1,118,'home-decoration/glass.html'),(883,9,533,0,118,'home-decoration/glass.html'),(884,9,111,0,119,'彩印抱枕'),(885,9,114,0,119,''),(886,9,479,0,119,'printing-pillow'),(887,9,118,0,119,'PRODUCTS_AND_PAGE'),(888,9,563,0,119,''),(889,9,514,0,119,''),(890,9,533,1,119,'home-decoration/printing-pillow.html'),(891,9,533,0,119,'home-decoration/printing-pillow.html'),(892,9,111,0,120,'餐垫'),(893,9,114,0,120,''),(894,9,479,0,120,'placemat'),(895,9,118,0,120,'PRODUCTS_AND_PAGE'),(896,9,563,0,120,''),(897,9,514,0,120,''),(898,9,533,1,120,'home-decoration/placemat.html'),(899,9,533,0,120,'home-decoration/placemat.html'),(900,9,111,0,121,'杯垫'),(901,9,114,0,121,''),(902,9,479,0,121,'cup-pad'),(903,9,118,0,121,'PRODUCTS_AND_PAGE'),(904,9,563,0,121,''),(905,9,514,0,121,''),(906,9,533,1,121,'home-decoration/cup-pad.html'),(907,9,533,0,121,'home-decoration/cup-pad.html'),(908,9,111,0,122,'相册'),(909,9,114,0,122,''),(910,9,479,0,122,'album'),(911,9,118,0,122,'PRODUCTS_AND_PAGE'),(912,9,563,0,122,''),(913,9,514,0,122,''),(914,9,533,1,122,'home-decoration/album.html'),(915,9,533,0,122,'home-decoration/album.html'),(916,9,111,0,123,'隔热罩'),(917,9,114,0,123,''),(918,9,479,0,123,'shrouds'),(919,9,118,0,123,'PRODUCTS_AND_PAGE'),(920,9,563,0,123,''),(921,9,514,0,123,'two_columns_left'),(922,9,533,1,123,'home-decoration/shrouds.html'),(923,9,533,0,123,'home-decoration/shrouds.html'),(924,9,111,0,124,'字牌'),(925,9,114,0,124,''),(926,9,479,0,124,'plates'),(927,9,118,0,124,'PRODUCTS_AND_PAGE'),(928,9,563,0,124,''),(929,9,514,0,124,''),(930,9,533,1,124,'home-decoration/plates.html'),(931,9,533,0,124,'home-decoration/plates.html'),(932,9,111,0,125,'气球'),(933,9,114,0,125,''),(934,9,479,0,125,'ballon'),(935,9,118,0,125,'PRODUCTS_AND_PAGE'),(936,9,563,0,125,''),(937,9,514,0,125,''),(938,9,533,1,125,'home-decoration/ballon.html'),(939,9,533,0,125,'home-decoration/ballon.html'),(940,9,111,0,126,'冰箱贴'),(941,9,114,0,126,''),(942,9,479,0,126,'fridge-magnet'),(943,9,118,0,126,'PRODUCTS_AND_PAGE'),(944,9,563,0,126,''),(945,9,514,0,126,''),(946,9,533,1,126,'home-decoration/fridge-magnet.html'),(947,9,533,0,126,'home-decoration/fridge-magnet.html'),(948,9,111,0,127,'烛台'),(949,9,114,0,127,''),(950,9,479,0,127,'candlestick'),(951,9,118,0,127,'PRODUCTS_AND_PAGE'),(952,9,563,0,127,''),(953,9,514,0,127,''),(954,9,533,1,127,'home-decoration/candlestick.html'),(955,9,533,0,127,'home-decoration/candlestick.html'),(959,9,111,0,128,'烟灰缸'),(960,9,114,0,128,''),(961,9,479,0,128,'ashtray'),(962,9,118,0,128,'PRODUCTS_AND_PAGE'),(963,9,563,0,128,''),(964,9,514,0,128,''),(965,9,533,1,128,'home-decoration/ashtray.html'),(966,9,533,0,128,'home-decoration/ashtray.html'),(967,9,111,0,129,'烟斗'),(968,9,114,0,129,''),(969,9,479,0,129,'pipe'),(970,9,118,0,129,'PRODUCTS_AND_PAGE'),(971,9,563,0,129,''),(972,9,514,0,129,''),(973,9,533,1,129,'home-decoration/pipe.html'),(974,9,533,0,129,'home-decoration/pipe.html'),(975,9,111,0,130,'碗'),(976,9,114,0,130,''),(977,9,479,0,130,'bowl'),(978,9,118,0,130,'PRODUCTS_AND_PAGE'),(979,9,563,0,130,''),(980,9,514,0,130,''),(981,9,533,1,130,'home-decoration/bowl.html'),(982,9,533,0,130,'home-decoration/bowl.html'),(983,9,111,0,131,'筷子'),(984,9,114,0,131,''),(985,9,479,0,131,'chopsticks'),(986,9,118,0,131,'PRODUCTS_AND_PAGE'),(987,9,563,0,131,''),(988,9,514,0,131,''),(989,9,533,1,131,'home-decoration/chopsticks.html'),(990,9,533,0,131,'home-decoration/chopsticks.html'),(991,9,111,0,132,'咖啡杯'),(992,9,114,0,132,''),(993,9,479,0,132,'coffee-cup'),(994,9,118,0,132,'PRODUCTS_AND_PAGE'),(995,9,563,0,132,''),(996,9,514,0,132,''),(997,9,533,1,132,'home-decoration/coffee-cup.html'),(998,9,533,0,132,'home-decoration/coffee-cup.html'),(999,9,111,0,133,'陶瓷杯'),(1000,9,114,0,133,''),(1001,9,479,0,133,'ceramic-cup'),(1002,9,118,0,133,'PRODUCTS_AND_PAGE'),(1003,9,563,0,133,''),(1004,9,514,0,133,''),(1005,9,533,1,133,'home-decoration/ceramic-cup.html'),(1006,9,533,0,133,'home-decoration/ceramic-cup.html'),(1007,9,111,0,134,'定制台灯'),(1008,9,114,0,134,''),(1009,9,479,0,134,'customize-table-lamps'),(1010,9,118,0,134,'PRODUCTS_AND_PAGE'),(1011,9,563,0,134,''),(1012,9,514,0,134,''),(1013,9,533,1,134,'home-decoration/customize-table-lamps.html'),(1014,9,533,0,134,'home-decoration/customize-table-lamps.html'),(1015,9,111,0,135,'储钱罐'),(1016,9,114,0,135,''),(1017,9,479,0,135,'piggy-bank'),(1018,9,118,0,135,'PRODUCTS_AND_PAGE'),(1019,9,563,0,135,''),(1020,9,514,0,135,''),(1021,9,533,1,135,'home-decoration/piggy-bank.html'),(1022,9,533,0,135,'home-decoration/piggy-bank.html'),(1024,9,111,0,136,'墙贴/壁贴'),(1025,9,114,0,136,''),(1026,9,479,0,136,'wall-stickers'),(1027,9,118,0,136,'PRODUCTS_AND_PAGE'),(1028,9,563,0,136,''),(1029,9,514,0,136,''),(1030,9,533,1,136,'home-decoration/wall-stickers.html'),(1031,9,533,0,136,'home-decoration/wall-stickers.html'),(1032,9,111,0,137,'开关贴'),(1033,9,114,0,137,''),(1034,9,479,0,137,'switch-sticker'),(1035,9,118,0,137,'PRODUCTS_AND_PAGE'),(1036,9,563,0,137,''),(1037,9,514,0,137,''),(1038,9,533,1,137,'home-decoration/switch-sticker.html'),(1039,9,533,0,137,'home-decoration/switch-sticker.html'),(1041,9,111,0,138,'水移画'),(1042,9,114,0,138,''),(1043,9,479,0,138,'water-shift-painting'),(1044,9,118,0,138,'PRODUCTS_AND_PAGE'),(1045,9,563,0,138,''),(1046,9,514,0,138,''),(1047,9,533,1,138,'home-decoration/water-shift-painting.html'),(1048,9,533,0,138,'home-decoration/water-shift-painting.html'),(1050,9,111,0,139,'玻璃贴'),(1051,9,114,0,139,''),(1052,9,479,0,139,'glass-paste'),(1053,9,118,0,139,'PRODUCTS_AND_PAGE'),(1054,9,563,0,139,''),(1055,9,514,0,139,''),(1056,9,533,1,139,'home-decoration/glass-paste.html'),(1057,9,533,0,139,'home-decoration/glass-paste.html'),(1058,9,111,0,140,'马桶贴'),(1059,9,114,0,140,''),(1060,9,479,0,140,'toilet-stickers'),(1061,9,118,0,140,'PRODUCTS_AND_PAGE'),(1062,9,563,0,140,''),(1063,9,514,0,140,''),(1064,9,533,1,140,'home-decoration/toilet-stickers.html'),(1065,9,533,0,140,'home-decoration/toilet-stickers.html'),(1066,9,111,0,141,'电脑贴'),(1067,9,114,0,141,''),(1068,9,479,0,141,'computer-stickers'),(1069,9,118,0,141,'PRODUCTS_AND_PAGE'),(1070,9,563,0,141,''),(1071,9,514,0,141,''),(1072,9,533,1,141,'home-decoration/computer-stickers.html'),(1073,9,533,0,141,'home-decoration/computer-stickers.html'),(1074,9,111,0,142,'海螺'),(1075,9,114,0,142,''),(1076,9,479,0,142,'conch'),(1077,9,118,0,142,'PRODUCTS_AND_PAGE'),(1078,9,563,0,142,''),(1079,9,514,0,142,''),(1080,9,533,1,142,'home-decoration/conch.html'),(1081,9,533,0,142,'home-decoration/conch.html'),(1082,9,111,0,143,'招财猫'),(1083,9,114,0,143,''),(1084,9,479,0,143,'lucky-cat'),(1085,9,118,0,143,'PRODUCTS_AND_PAGE'),(1086,9,563,0,143,''),(1087,9,514,0,143,''),(1088,9,533,1,143,'home-decoration/lucky-cat.html'),(1089,9,533,0,143,'home-decoration/lucky-cat.html'),(1090,9,111,0,144,'风铃'),(1091,9,114,0,144,''),(1092,9,479,0,144,'campanula'),(1093,9,118,0,144,'PRODUCTS_AND_PAGE'),(1094,9,563,0,144,''),(1095,9,514,0,144,''),(1096,9,533,1,144,'home-decoration/campanula.html'),(1097,9,533,0,144,'home-decoration/campanula.html'),(1098,9,111,0,145,'毛绒公仔'),(1099,9,114,0,145,''),(1100,9,479,0,145,'hairs-toy'),(1101,9,118,0,145,'PRODUCTS_AND_PAGE'),(1102,9,563,0,145,''),(1103,9,514,0,145,''),(1104,9,533,1,145,'home-decoration/hairs-toy.html'),(1105,9,533,0,145,'home-decoration/hairs-toy.html'),(1106,9,111,0,146,'相片墙'),(1107,9,114,0,146,''),(1108,9,479,0,146,'photo-wall'),(1109,9,118,0,146,'PRODUCTS_AND_PAGE'),(1110,9,563,0,146,''),(1111,9,514,0,146,''),(1112,9,533,1,146,'home-decoration/photo-wall.html'),(1113,9,533,0,146,'home-decoration/photo-wall.html'),(1114,9,111,0,147,'运动旅行'),(1115,9,114,0,147,''),(1116,9,479,0,147,'sports-and-travel'),(1117,9,118,0,147,'PRODUCTS_AND_PAGE'),(1118,9,563,0,147,''),(1119,9,514,0,147,''),(1120,9,533,1,147,'sports-and-travel.html'),(1121,9,533,0,147,'sports-and-travel.html'),(1122,9,111,0,148,'水壶'),(1123,9,114,0,148,''),(1124,9,479,0,148,'kettle'),(1125,9,118,0,148,'PRODUCTS_AND_PAGE'),(1126,9,563,0,148,''),(1127,9,514,0,148,''),(1128,9,533,1,148,'sports-and-travel/kettle.html'),(1129,9,533,0,148,'sports-and-travel/kettle.html'),(1130,9,111,0,149,'吊牌'),(1131,9,114,0,149,''),(1132,9,479,0,149,'hangtag'),(1133,9,118,0,149,'PRODUCTS_AND_PAGE'),(1134,9,563,0,149,''),(1135,9,514,0,149,''),(1136,9,533,1,149,'sports-and-travel/hangtag.html'),(1137,9,533,0,149,'sports-and-travel/hangtag.html'),(1138,9,111,0,150,'行李牌'),(1139,9,114,0,150,''),(1140,9,479,0,150,'luggage-tag'),(1141,9,118,0,150,'PRODUCTS_AND_PAGE'),(1142,9,563,0,150,''),(1143,9,514,0,150,''),(1144,9,533,1,150,'sports-and-travel/luggage-tag.html'),(1145,9,533,0,150,'sports-and-travel/luggage-tag.html'),(1146,9,111,0,151,'折叠小刀'),(1147,9,114,0,151,''),(1148,9,479,0,151,'folding-knife'),(1149,9,118,0,151,'PRODUCTS_AND_PAGE'),(1150,9,563,0,151,''),(1151,9,514,0,151,''),(1152,9,533,1,151,'sports-and-travel/folding-knife.html'),(1153,9,533,0,151,'sports-and-travel/folding-knife.html'),(1154,9,111,0,152,'运动水壶'),(1155,9,114,0,152,''),(1156,9,479,0,152,'e-as-ae-a'),(1157,9,118,0,152,'PRODUCTS_AND_PAGE'),(1158,9,563,0,152,''),(1159,9,514,0,152,''),(1160,9,533,1,152,'sports-and-travel/e-as-ae-a.html'),(1161,9,533,0,152,'sports-and-travel/e-as-ae-a.html'),(1162,9,111,0,153,'印品系列'),(1163,9,114,0,153,''),(1164,9,479,0,153,'printed-materials-series'),(1165,9,118,0,153,'PRODUCTS_AND_PAGE'),(1166,9,563,0,153,''),(1167,9,514,0,153,''),(1168,9,533,1,153,'printed-materials-series.html'),(1169,9,533,0,153,'printed-materials-series.html'),(1170,9,111,0,154,'拼图'),(1171,9,114,0,154,''),(1172,9,479,0,154,'jigsaw'),(1173,9,118,0,154,'PRODUCTS_AND_PAGE'),(1174,9,563,0,154,''),(1175,9,514,0,154,''),(1176,9,533,1,154,'printed-materials-series/jigsaw.html'),(1177,9,533,0,154,'printed-materials-series/jigsaw.html'),(1178,9,111,0,155,'贺卡'),(1179,9,114,0,155,''),(1180,9,479,0,155,'greetings-card'),(1181,9,118,0,155,'PRODUCTS_AND_PAGE'),(1182,9,563,0,155,''),(1183,9,514,0,155,''),(1184,9,533,1,155,'printed-materials-series/greetings-card.html'),(1185,9,533,0,155,'printed-materials-series/greetings-card.html'),(1186,9,111,0,156,'请柬'),(1187,9,114,0,156,''),(1188,9,479,0,156,'invitation-card'),(1189,9,118,0,156,'PRODUCTS_AND_PAGE'),(1190,9,563,0,156,''),(1191,9,514,0,156,''),(1192,9,533,1,156,'printed-materials-series/invitation-card.html'),(1193,9,533,0,156,'printed-materials-series/invitation-card.html'),(1194,9,111,0,157,'海报'),(1195,9,114,0,157,''),(1196,9,479,0,157,'poster'),(1197,9,118,0,157,'PRODUCTS_AND_PAGE'),(1198,9,563,0,157,''),(1199,9,514,0,157,''),(1200,9,533,1,157,'printed-materials-series/poster.html'),(1201,9,533,0,157,'printed-materials-series/poster.html'),(1202,9,111,0,158,'相册'),(1203,9,114,0,158,''),(1204,9,479,0,158,'album'),(1205,9,118,0,158,'PRODUCTS_AND_PAGE'),(1206,9,563,0,158,''),(1207,9,514,0,158,''),(1208,9,533,1,158,'printed-materials-series/album.html'),(1209,9,533,0,158,'printed-materials-series/album.html'),(1210,9,111,0,159,'日历'),(1211,9,114,0,159,''),(1212,9,479,0,159,'calendar'),(1213,9,118,0,159,'PRODUCTS_AND_PAGE'),(1214,9,563,0,159,''),(1215,9,514,0,159,''),(1216,9,533,1,159,'printed-materials-series/calendar.html'),(1217,9,533,0,159,'printed-materials-series/calendar.html'),(1218,9,111,0,160,'菜单'),(1219,9,114,0,160,''),(1220,9,479,0,160,'carte'),(1221,9,118,0,160,'PRODUCTS_AND_PAGE'),(1222,9,563,0,160,''),(1223,9,514,0,160,''),(1224,9,533,1,160,'printed-materials-series/carte.html'),(1225,9,533,0,160,'printed-materials-series/carte.html'),(1226,9,111,0,161,'生日报'),(1227,9,114,0,161,''),(1228,9,479,0,161,'birthday-newspaper'),(1229,9,118,0,161,'PRODUCTS_AND_PAGE'),(1230,9,563,0,161,''),(1231,9,514,0,161,''),(1232,9,533,1,161,'printed-materials-series/birthday-newspaper.html'),(1233,9,533,0,161,'printed-materials-series/birthday-newspaper.html'),(1234,9,111,0,162,'扑克'),(1235,9,114,0,162,''),(1236,9,479,0,162,'poker'),(1237,9,118,0,162,'PRODUCTS_AND_PAGE'),(1238,9,563,0,162,''),(1239,9,514,0,162,''),(1240,9,533,1,162,'printed-materials-series/poker.html'),(1241,9,533,0,162,'printed-materials-series/poker.html'),(1242,9,111,0,163,'竹简'),(1243,9,114,0,163,''),(1244,9,479,0,163,'inscribed-bamgoo-slips'),(1245,9,118,0,163,'PRODUCTS_AND_PAGE'),(1246,9,563,0,163,''),(1247,9,514,0,163,''),(1248,9,533,1,163,'printed-materials-series/inscribed-bamgoo-slips.html'),(1249,9,533,0,163,'printed-materials-series/inscribed-bamgoo-slips.html'),(1250,9,111,0,164,'个性证书/奖状'),(1251,9,114,0,164,''),(1252,9,479,0,164,'personalized-certificate'),(1253,9,118,0,164,'PRODUCTS_AND_PAGE'),(1254,9,563,0,164,''),(1255,9,514,0,164,''),(1256,9,533,1,164,'printed-materials-series/personalized-certificate.html'),(1257,9,533,0,164,'printed-materials-series/personalized-certificate.html'),(1258,9,111,0,165,'卡贴'),(1259,9,114,0,165,''),(1260,9,479,0,165,'card-sticker'),(1261,9,118,0,165,'PRODUCTS_AND_PAGE'),(1262,9,563,0,165,''),(1263,9,514,0,165,''),(1264,9,533,1,165,'printed-materials-series/card-sticker.html'),(1265,9,533,0,165,'printed-materials-series/card-sticker.html'),(1266,9,111,0,166,'Lomo照片'),(1267,9,114,0,166,''),(1268,9,479,0,166,'lomo-photo'),(1269,9,118,0,166,'PRODUCTS_AND_PAGE'),(1270,9,563,0,166,''),(1271,9,514,0,166,''),(1272,9,533,1,166,'printed-materials-series/lomo-photo.html'),(1273,9,533,0,166,'printed-materials-series/lomo-photo.html'),(1274,9,111,0,167,'手印泥'),(1275,9,114,0,167,''),(1276,9,479,0,167,'hand-inkpad'),(1277,9,118,0,167,'PRODUCTS_AND_PAGE'),(1278,9,563,0,167,''),(1279,9,514,0,167,''),(1280,9,533,1,167,'printed-materials-series/hand-inkpad.html'),(1281,9,533,0,167,'printed-materials-series/hand-inkpad.html'),(1282,9,111,0,168,'利是封'),(1283,9,114,0,168,''),(1284,9,479,0,168,'red-packets'),(1285,9,118,0,168,'PRODUCTS_AND_PAGE'),(1286,9,563,0,168,''),(1287,9,514,0,168,''),(1288,9,533,1,168,'printed-materials-series/red-packets.html'),(1289,9,533,0,168,'printed-materials-series/red-packets.html'),(1290,9,111,0,169,'喜糖袋/喜糖盒'),(1291,9,114,0,169,''),(1292,9,479,0,169,'candy-bags'),(1293,9,118,0,169,'PRODUCTS_AND_PAGE'),(1294,9,563,0,169,''),(1295,9,514,0,169,''),(1296,9,533,1,169,'printed-materials-series/candy-bags.html'),(1297,9,533,0,169,'printed-materials-series/candy-bags.html'),(1298,9,111,0,170,'婚庆桌卡'),(1299,9,114,0,170,''),(1300,9,479,0,170,'wedding-table-card'),(1301,9,118,0,170,'PRODUCTS_AND_PAGE'),(1302,9,563,0,170,''),(1303,9,514,0,170,''),(1304,9,533,1,170,'printed-materials-series/wedding-table-card.html'),(1305,9,533,0,170,'printed-materials-series/wedding-table-card.html'),(1306,9,111,0,171,'杂志'),(1307,9,114,0,171,''),(1308,9,479,0,171,'magazine'),(1309,9,118,0,171,'PRODUCTS_AND_PAGE'),(1310,9,563,0,171,''),(1311,9,514,0,171,''),(1312,9,533,1,171,'printed-materials-series/magazine.html'),(1313,9,533,0,171,'printed-materials-series/magazine.html'),(1314,9,111,0,172,'个性印章'),(1315,9,114,0,172,''),(1316,9,479,0,172,'personalized-stamp'),(1317,9,118,0,172,'PRODUCTS_AND_PAGE'),(1318,9,563,0,172,''),(1319,9,514,0,172,''),(1320,9,533,1,172,'personalized-stamp.html'),(1321,9,533,0,172,'personalized-stamp.html'),(1322,9,111,0,173,'服饰'),(1323,9,114,0,173,''),(1324,9,479,0,173,'apparel'),(1325,9,118,0,173,'PRODUCTS_AND_PAGE'),(1326,9,563,0,173,''),(1327,9,514,0,173,''),(1328,9,533,1,173,'apparel.html'),(1329,9,533,0,173,'apparel.html'),(1330,9,111,0,174,'T恤'),(1331,9,114,0,174,''),(1332,9,479,0,174,'t-shirt'),(1333,9,118,0,174,'PRODUCTS_AND_PAGE'),(1334,9,563,0,174,''),(1335,9,514,0,174,''),(1336,9,533,1,174,'apparel/t-shirt.html'),(1337,9,533,0,174,'apparel/t-shirt.html'),(1338,9,111,0,175,'帽子'),(1339,9,114,0,175,''),(1340,9,479,0,175,'hat'),(1341,9,118,0,175,'PRODUCTS_AND_PAGE'),(1342,9,563,0,175,''),(1343,9,514,0,175,''),(1344,9,533,1,175,'apparel/hat.html'),(1345,9,533,0,175,'apparel/hat.html'),(1346,9,111,0,176,'长裤'),(1347,9,114,0,176,''),(1348,9,479,0,176,'trousers'),(1349,9,118,0,176,'PRODUCTS_AND_PAGE'),(1350,9,563,0,176,''),(1351,9,514,0,176,''),(1352,9,533,1,176,'apparel/trousers.html'),(1353,9,533,0,176,'apparel/trousers.html'),(1354,9,111,0,177,'围巾'),(1355,9,114,0,177,''),(1356,9,479,0,177,'scarves'),(1357,9,118,0,177,'PRODUCTS_AND_PAGE'),(1358,9,563,0,177,''),(1359,9,514,0,177,''),(1360,9,533,1,177,'apparel/scarves.html'),(1361,9,533,0,177,'apparel/scarves.html'),(1362,9,111,0,178,'艺术类'),(1363,9,114,0,178,''),(1364,9,479,0,178,'art-series'),(1365,9,118,0,178,'PRODUCTS_AND_PAGE'),(1366,9,563,0,178,''),(1367,9,514,0,178,''),(1368,9,533,1,178,'art-series.html'),(1369,9,533,0,178,'art-series.html'),(1370,9,111,0,179,'风景油画'),(1371,9,114,0,179,''),(1372,9,479,0,179,'landscape-oil-painting'),(1373,9,118,0,179,'PRODUCTS_AND_PAGE'),(1374,9,563,0,179,''),(1375,9,514,0,179,''),(1376,9,533,1,179,'art-series/landscape-oil-painting.html'),(1377,9,533,0,179,'art-series/landscape-oil-painting.html'),(1378,9,111,0,180,'人物油画'),(1379,9,114,0,180,''),(1380,9,479,0,180,'figure-painting'),(1381,9,118,0,180,'PRODUCTS_AND_PAGE'),(1382,9,563,0,180,''),(1383,9,514,0,180,''),(1384,9,533,1,180,'art-series/figure-painting.html'),(1385,9,533,0,180,'art-series/figure-painting.html'),(1386,9,111,0,181,'石头画'),(1387,9,114,0,181,''),(1388,9,479,0,181,'stone-painting'),(1389,9,118,0,181,'PRODUCTS_AND_PAGE'),(1390,9,563,0,181,''),(1391,9,514,0,181,''),(1392,9,533,1,181,'art-series/stone-painting.html'),(1393,9,533,0,181,'art-series/stone-painting.html'),(1394,9,111,0,182,'瓷片画'),(1395,9,114,0,182,''),(1396,9,479,0,182,'porcelain-painting'),(1397,9,118,0,182,'PRODUCTS_AND_PAGE'),(1398,9,563,0,182,''),(1399,9,514,0,182,''),(1400,9,533,1,182,'art-series/porcelain-painting.html'),(1401,9,533,0,182,'art-series/porcelain-painting.html'),(1402,9,111,0,183,'木版画'),(1403,9,114,0,183,''),(1404,9,479,0,183,'woodcut'),(1405,9,118,0,183,'PRODUCTS_AND_PAGE'),(1406,9,563,0,183,''),(1407,9,514,0,183,''),(1408,9,533,1,183,'art-series/woodcut.html'),(1409,9,533,0,183,'art-series/woodcut.html'),(1410,9,111,0,184,'水晶版画'),(1411,9,114,0,184,''),(1412,9,479,0,184,'crystal-engraving'),(1413,9,118,0,184,'PRODUCTS_AND_PAGE'),(1414,9,563,0,184,''),(1415,9,514,0,184,''),(1416,9,533,1,184,'art-series/crystal-engraving.html'),(1417,9,533,0,184,'art-series/crystal-engraving.html'),(1418,9,111,0,185,'冰雕'),(1419,9,114,0,185,''),(1420,9,479,0,185,'ice-art'),(1421,9,118,0,185,'PRODUCTS_AND_PAGE'),(1422,9,563,0,185,''),(1423,9,514,0,185,''),(1424,9,533,1,185,'art-series/ice-art.html'),(1425,9,533,0,185,'art-series/ice-art.html'),(1426,9,111,0,186,'软陶'),(1427,9,114,0,186,''),(1428,9,479,0,186,'fimo'),(1429,9,118,0,186,'PRODUCTS_AND_PAGE'),(1430,9,563,0,186,''),(1431,9,514,0,186,''),(1432,9,533,1,186,'art-series/fimo.html'),(1433,9,533,0,186,'art-series/fimo.html'),(1434,9,948,0,40,''),(1435,9,113,0,40,'watch-165_1.jpg'),(1437,9,113,0,67,'cup_2.jpg'),(1682,9,113,0,45,'susi.jpg'),(1688,9,113,0,50,'u.jpg'),(1689,9,113,0,56,'iphone4s.jpg'),(1692,9,113,0,72,'shuiji-2_1.jpg'),(1694,9,113,0,78,'bangong-1.jpg'),(1695,9,113,0,90,'sawu-1.jpg'),(1696,9,114,0,3,''),(1697,9,563,0,3,''),(1698,9,514,0,3,'');
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_1`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_1` (
  `entity_id` int(11) unsigned NOT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `children_count` int(11) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `meta_title` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text,
  `meta_description` text,
  `landing_page` int(10) NOT NULL DEFAULT '0',
  `display_mode` varchar(255) NOT NULL DEFAULT '',
  `is_active` int(10) NOT NULL DEFAULT '0',
  `is_anchor` int(10) NOT NULL DEFAULT '0',
  `all_children` text,
  `path_in_store` text,
  `children` text,
  `url_key` varchar(255) NOT NULL DEFAULT '',
  `page_layout` varchar(255) NOT NULL DEFAULT '',
  `custom_layout_update` text,
  `url_path` varchar(255) NOT NULL DEFAULT '',
  `custom_design` varchar(255) NOT NULL DEFAULT '',
  `custom_design_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_design_to` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `available_sort_by` text,
  `default_sort_by` varchar(255) NOT NULL DEFAULT '',
  `include_in_menu` int(10) NOT NULL DEFAULT '0',
  `custom_use_parent_settings` int(10) NOT NULL DEFAULT '0',
  `custom_apply_to_products` int(10) NOT NULL DEFAULT '0',
  `filter_price_range` int(10) NOT NULL DEFAULT '0',
  `thumbnail` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_PATH` (`path`),
  KEY `IDX_LEVEL` (`level`),
  CONSTRAINT `FK_CATEGORY_FLAT_CATEGORY_ID_STORE_1` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATEGORY_FLAT_STORE_ID_STORE_1` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_1`
--

LOCK TABLES `catalog_category_flat_store_1` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_1` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_1` VALUES (1,0,'2007-07-20 18:46:08','2007-08-07 09:50:15','1',1,0,154,1,'','','','','','',0,'',1,0,'','','','','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(3,1,'2007-08-22 15:54:41','2012-06-22 03:58:22','1/3',3,1,153,1,'Root Catalog','','','','','',0,'PRODUCTS',1,0,'3,18,4,5,16,17,19,24,10,22,23,13,8,12,26,25,15,20','','18,10,13,20','root-catalog','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(20,3,'2007-08-25 13:14:09','2008-08-07 23:58:57','1/3/20',20,2,0,1,'Household Items','','','','','',0,'PRODUCTS',0,0,'20','20','','household-items','','','household-items.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,1,1,0,''),(35,3,'2011-03-08 11:35:58','2012-06-12 06:26:42','1/3/35',21,2,0,1,'商家推荐商品','','','','','',0,'PRODUCTS',1,0,'','','','featured-products','','','featured-products.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,1,1,0,''),(36,3,'2012-06-08 06:40:54','2012-06-30 01:39:30','1/3/36',22,2,0,1,'节日庆典','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','occasion','','','occasion.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(37,3,'2012-06-08 06:50:14','2012-06-30 02:12:42','1/3/37',23,2,0,1,'送礼对象','','','','创意生日礼物,商务礼品,高档商务礼品,创意礼物,个性礼物,新奇创意小礼品,定制礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','recipients','','','recipients.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(38,3,'2012-06-08 07:02:28','2012-06-30 01:42:03','1/3/38',24,2,0,1,'创意礼品','','','','创意礼品,个性定制创意礼品,创意生日礼物,企业礼品定制,创意礼品定制网站','',0,'PRODUCTS_AND_PAGE',1,1,'','','','gifts','','','gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(39,3,'2012-06-08 07:03:42','2012-06-30 01:42:23','1/3/39',25,2,0,1,'个性定制','','','','个性礼品定制,创意礼品,创意礼物,创意礼品定制,个性定制系统,个性定制软件,创意小礼品,生日礼物,个性定制礼物,个性定制礼品,新奇创意礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diy','','','diy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(40,3,'2012-06-08 07:06:34','2012-06-26 02:40:56','1/3/40',26,2,4,1,'钟表','','watch-165_1.jpg','','个性定制手表,个性定制钟表,创意礼品钟表,礼品手表','',0,'PRODUCTS_AND_PAGE',1,1,'','','','watch','','','watch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(41,40,'2012-06-08 07:12:36','2012-06-08 07:12:36','1/3/40/41',1,3,0,1,'迪士尼定制手表','','','','','',0,'PRODUCTS',1,0,'','','','disney-watches','','','watch/disney-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(42,40,'2012-06-08 07:13:32','2012-06-08 07:13:32','1/3/40/42',2,3,0,1,'闹钟','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','alarm-clock','','','watch/alarm-clock.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(43,40,'2012-06-08 07:16:01','2012-06-08 07:16:01','1/3/40/43',3,3,0,1,'座钟','','','','','',0,'PRODUCTS',1,0,'','','','timepiece','','','watch/timepiece.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(44,40,'2012-06-08 07:17:22','2012-06-08 07:17:22','1/3/40/44',4,3,0,1,'个性定制手表','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-custom-watches','','','watch/personalized-custom-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(45,3,'2012-06-08 07:18:06','2012-06-18 06:17:32','1/3/45',27,2,4,1,'饰品','','susi.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jewelry','','','jewelry.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(46,45,'2012-06-08 07:19:06','2012-06-08 07:19:06','1/3/45/46',1,3,0,1,'项链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','necklace','','','jewelry/necklace.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(47,45,'2012-06-08 07:20:00','2012-06-08 07:20:00','1/3/45/47',2,3,0,1,'手链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bracelet','','','jewelry/bracelet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(48,45,'2012-06-08 07:20:48','2012-06-08 07:20:48','1/3/45/48',3,3,0,1,'耳环','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','earring','','','jewelry/earring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(49,45,'2012-06-08 07:21:47','2012-06-08 07:21:47','1/3/45/49',4,3,0,1,'戒指','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ring','','','jewelry/ring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(50,3,'2012-06-08 07:22:45','2012-06-18 06:17:40','1/3/50',28,2,5,1,'U盘','','u.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','usb-card','','','usb-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(51,50,'2012-06-08 07:23:46','2012-06-08 07:23:46','1/3/50/51',1,3,0,1,'卡片式U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','u-disk-card','','','usb-card/u-disk-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(52,50,'2012-06-08 07:25:28','2012-06-08 07:25:28','1/3/50/52',2,3,0,1,'木制U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wodden-usb-disk','','','usb-card/wodden-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(53,50,'2012-06-08 07:26:24','2012-06-08 07:26:24','1/3/50/53',3,3,0,1,'皮革U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','leather-usb-disk','','','usb-card/leather-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(54,50,'2012-06-08 07:28:30','2012-06-08 07:28:30','1/3/50/54',4,3,0,1,'金属U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-usb-disk','','','usb-card/metal-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(55,50,'2012-06-08 07:30:55','2012-06-08 07:30:55','1/3/50/55',5,3,0,1,'青花瓷U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','white-porcelain-usb-disk','','','usb-card/white-porcelain-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(56,3,'2012-06-08 07:34:57','2012-06-12 11:00:08','1/3/56',29,2,10,1,'数码配件','','iphone4s.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','digital-accessories','','','digital-accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(57,56,'2012-06-08 07:36:31','2012-06-08 07:36:31','1/3/56/57',1,3,0,1,'浮雕手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fudiao-phone-case','','','digital-accessories/fudiao-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(58,56,'2012-06-08 07:37:08','2012-06-08 07:37:08','1/3/56/58',2,3,0,1,'刻字手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kezi-phone-case','','','digital-accessories/kezi-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(59,56,'2012-06-08 07:37:42','2012-06-08 07:37:42','1/3/56/59',3,3,0,1,'彩印手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caihui-phone-case','','','digital-accessories/caihui-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(60,56,'2012-06-08 07:38:13','2012-06-08 07:38:13','1/3/56/60',4,3,0,1,'鼠标','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse','','','digital-accessories/mouse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(61,56,'2012-06-08 07:39:32','2012-06-08 07:39:32','1/3/56/61',5,3,0,1,'电脑内胆包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-sleeve','','','digital-accessories/computer-sleeve.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(62,56,'2012-06-08 07:40:00','2012-06-08 07:40:00','1/3/56/62',6,3,0,1,'MP3','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mp3','','','digital-accessories/mp3.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(63,56,'2012-06-08 07:41:58','2012-06-08 07:41:58','1/3/56/63',7,3,0,1,'CD包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd-bag','','','digital-accessories/cd-bag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(64,56,'2012-06-08 07:42:25','2012-06-08 07:42:25','1/3/56/64',8,3,0,1,'CD','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd','','','digital-accessories/cd.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(65,56,'2012-06-08 07:42:56','2012-06-08 07:42:56','1/3/56/65',9,3,0,1,'平板电脑','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','tablet-pc','','','digital-accessories/tablet-pc.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(66,56,'2012-06-08 07:44:42','2012-06-08 07:44:42','1/3/56/66',10,3,0,1,'定制iPhone4壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-iphone4-case','','','digital-accessories/customize-iphone4-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(67,3,'2012-06-08 07:47:35','2012-06-18 06:17:48','1/3/67',30,2,4,1,'杯子','','cup_2.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cups','','','cups.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(68,67,'2012-06-08 07:48:13','2012-06-08 07:48:13','1/3/67/68',1,3,0,1,'马克杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mug','','','cups/mug.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(69,67,'2012-06-08 07:50:35','2012-06-08 07:50:35','1/3/67/69',2,3,0,1,'骨瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bone-cup','','','cups/bone-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(70,67,'2012-06-08 07:51:31','2012-06-08 07:51:31','1/3/67/70',3,3,0,1,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','cups/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(71,67,'2012-06-08 07:53:16','2012-06-08 07:53:16','1/3/67/71',4,3,0,1,'变色杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','color-cup','','','cups/color-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(72,3,'2012-06-08 07:53:59','2012-06-18 06:17:58','1/3/72',31,2,5,1,'水晶','','shuiji-2_1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal','','','crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(73,72,'2012-06-08 07:54:45','2012-06-08 07:54:45','1/3/72/73',1,3,0,1,'彩印水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caiyi-crystal','','','crystal/caiyi-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(74,72,'2012-06-08 07:55:24','2012-06-08 07:55:24','1/3/72/74',2,3,0,1,'雕刻水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diaoke-crystal','','','crystal/diaoke-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(75,72,'2012-06-08 07:56:17','2012-06-08 07:56:17','1/3/72/75',3,3,0,1,'水晶名片座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-card-holder','','','crystal/crystal-card-holder.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(76,72,'2012-06-08 07:57:18','2012-06-08 07:57:18','1/3/72/76',4,3,0,1,'内雕水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','laser-crystal','','','crystal/laser-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(77,72,'2012-06-08 07:57:50','2012-06-08 07:58:10','1/3/72/77',5,3,0,1,'水晶奖杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-trophy','','','crystal/crystal-trophy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(78,3,'2012-06-08 07:58:50','2012-06-18 06:18:07','1/3/78',32,2,11,1,'办公用品与文具','','bangong-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','office-supplies','','','office-supplies.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(79,78,'2012-06-08 08:02:49','2012-06-08 08:02:49','1/3/78/79',1,3,0,1,'宝珠笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','roller-pen','','','office-supplies/roller-pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(80,78,'2012-06-08 08:04:11','2012-06-08 08:04:11','1/3/78/80',2,3,0,1,'名片盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cardcase','','','office-supplies/cardcase.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(81,78,'2012-06-08 08:05:08','2012-06-08 08:05:08','1/3/78/81',3,3,0,1,'记事本','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','notepad','','','office-supplies/notepad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(82,78,'2012-06-08 08:07:56','2012-06-08 08:07:56','1/3/78/82',4,3,0,1,'书签','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bookmark','','','office-supplies/bookmark.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(83,78,'2012-06-08 08:08:36','2012-06-08 08:08:36','1/3/78/83',5,3,0,1,'鼠标垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse-mat','','','office-supplies/mouse-mat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(84,78,'2012-06-08 08:09:18','2012-06-08 08:09:18','1/3/78/84',6,3,0,1,'放大镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magnifier','','','office-supplies/magnifier.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(85,78,'2012-06-08 08:10:11','2012-06-08 08:10:11','1/3/78/85',7,3,0,1,'名片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-card','','','office-supplies/business-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(86,78,'2012-06-08 08:10:58','2012-06-08 08:10:58','1/3/78/86',8,3,0,1,'文具盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','writing-case','','','office-supplies/writing-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(87,78,'2012-06-08 08:11:28','2012-06-08 08:11:28','1/3/78/87',9,3,0,1,'直尺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ruler','','','office-supplies/ruler.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(88,78,'2012-06-08 08:15:53','2012-06-08 08:16:01','1/3/78/88',10,3,0,1,'笔筒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','brush-pot','','','office-supplies/brush-pot.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(89,78,'2012-06-08 08:16:32','2012-06-08 08:16:32','1/3/78/89',11,3,0,1,'铱金钢笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pen','','','office-supplies/pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(90,3,'2012-06-08 08:18:11','2012-06-18 06:18:15','1/3/90',33,2,5,1,'商务礼品','','sawu-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-gifts','','','business-gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(91,90,'2012-06-08 08:18:50','2012-06-08 08:18:50','1/3/90/91',1,3,0,1,'奖牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','medal','','','business-gifts/medal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(92,90,'2012-06-08 08:19:34','2012-06-08 08:19:34','1/3/90/92',2,3,0,1,'香水座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','perfume-bottle','','','business-gifts/perfume-bottle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(93,90,'2012-06-08 08:20:15','2012-06-08 08:20:15','1/3/90/93',3,3,0,1,'红木礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','rosewood-gift-set','','','business-gifts/rosewood-gift-set.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(94,90,'2012-06-08 08:20:48','2012-06-08 08:20:48','1/3/90/94',4,3,0,1,'其它礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','other-gift-sets','','','business-gifts/other-gift-sets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(95,90,'2012-06-08 08:21:24','2012-06-08 08:21:24','1/3/90/95',5,3,0,1,'工艺船','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','boat','','','business-gifts/boat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(96,3,'2012-06-08 08:23:16','2012-06-18 06:18:26','1/3/96',34,2,13,1,'配饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','accessories','','','accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(97,96,'2012-06-08 08:24:00','2012-06-08 08:24:00','1/3/96/97',1,3,0,1,'酒壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','flagon','','','accessories/flagon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(98,96,'2012-06-08 08:25:05','2012-06-08 08:25:05','1/3/96/98',2,3,0,1,'个性化徽章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-badges','','','accessories/personalized-badges.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(99,96,'2012-06-08 08:26:03','2012-06-08 08:26:03','1/3/96/99',3,3,0,1,'烟盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cigarette-case','','','accessories/cigarette-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(100,96,'2012-06-08 08:26:52','2012-06-08 08:26:52','1/3/96/100',4,3,0,1,'梳子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','comb','','','accessories/comb.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(101,96,'2012-06-08 08:27:30','2012-06-08 08:27:30','1/3/96/101',5,3,0,1,'卡包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-package','','','accessories/card-package.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(102,96,'2012-06-08 08:28:23','2012-06-08 08:28:23','1/3/96/102',6,3,0,1,'眼镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glasses','','','accessories/glasses.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(103,96,'2012-06-08 08:29:14','2012-06-08 08:29:14','1/3/96/103',7,3,0,1,'钥匙包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','key-cases','','','accessories/key-cases.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(104,96,'2012-06-08 08:29:58','2012-06-08 08:29:58','1/3/96/104',8,3,0,1,'ZIPPO打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','zippo-lighter','','','accessories/zippo-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(105,96,'2012-06-08 08:31:07','2012-06-08 08:31:07','1/3/96/105',9,3,0,1,'青花瓷打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','qinghua-lighter','','','accessories/qinghua-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(106,96,'2012-06-08 08:31:49','2012-06-08 08:31:49','1/3/96/106',10,3,0,1,'皮夹','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wallet','','','accessories/wallet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(107,96,'2012-06-08 08:32:33','2012-06-08 08:32:33','1/3/96/107',11,3,0,1,'化妆镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','vanity-mirron','','','accessories/vanity-mirron.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(108,96,'2012-06-08 08:34:53','2012-06-08 08:34:53','1/3/96/108',12,3,0,1,'钱包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','purse','','','accessories/purse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(109,96,'2012-06-08 08:35:32','2012-06-08 08:35:32','1/3/96/109',13,3,0,1,'音乐盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','music-box','','','accessories/music-box.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(110,3,'2012-06-08 08:36:18','2012-06-18 06:18:34','1/3/110',35,2,6,1,'相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-frame','','','photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(111,110,'2012-06-08 08:36:55','2012-06-08 08:36:55','1/3/110/111',1,3,0,1,'木制相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wooden-photo-frame','','','photo-frame/wooden-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(112,110,'2012-06-08 08:37:38','2012-06-08 08:37:38','1/3/110/112',2,3,0,1,'金属相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-photo-frame','','','photo-frame/metal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(113,110,'2012-06-08 08:38:04','2012-06-08 08:38:25','1/3/110/113',3,3,0,1,'水晶相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-photo-frame','','','photo-frame/crystal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(114,110,'2012-06-08 08:39:21','2012-06-08 08:39:21','1/3/110/114',4,3,0,1,'皮质相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cortex-photo-frame','','','photo-frame/cortex-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(115,110,'2012-06-08 08:40:06','2012-06-08 08:40:06','1/3/110/115',5,3,0,1,'相 册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','photo-frame/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(116,110,'2012-06-08 08:40:49','2012-06-08 08:40:49','1/3/110/116',6,3,0,1,'亚克力相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','acrylic-photo-frame','','','photo-frame/acrylic-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(117,3,'2012-06-08 08:55:19','2012-06-18 06:18:43','1/3/117',36,2,29,1,'家居装饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','home-decoration','','','home-decoration.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(118,117,'2012-06-08 09:00:28','2012-06-08 09:00:28','1/3/117/118',1,3,0,1,'玻璃杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass','','','home-decoration/glass.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(119,117,'2012-06-08 09:01:24','2012-06-08 09:01:24','1/3/117/119',2,3,0,1,'彩印抱枕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printing-pillow','','','home-decoration/printing-pillow.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(120,117,'2012-06-08 09:01:57','2012-06-08 09:01:57','1/3/117/120',3,3,0,1,'餐垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','placemat','','','home-decoration/placemat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(121,117,'2012-06-08 09:02:29','2012-06-08 09:17:48','1/3/117/121',4,3,0,1,'杯垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cup-pad','','','home-decoration/cup-pad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(122,117,'2012-06-08 09:03:09','2012-06-08 09:18:12','1/3/117/122',5,3,0,1,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','home-decoration/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(123,117,'2012-06-08 09:14:11','2012-06-08 09:14:11','1/3/117/123',6,3,0,1,'隔热罩','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','shrouds','two_columns_left','','home-decoration/shrouds.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(124,117,'2012-06-08 09:15:06','2012-06-08 09:15:06','1/3/117/124',7,3,0,1,'字牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','plates','','','home-decoration/plates.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(125,117,'2012-06-08 09:15:45','2012-06-08 09:15:45','1/3/117/125',8,3,0,1,'气球','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ballon','','','home-decoration/ballon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(126,117,'2012-06-08 09:16:23','2012-06-08 09:16:23','1/3/117/126',9,3,0,1,'冰箱贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fridge-magnet','','','home-decoration/fridge-magnet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(127,117,'2012-06-08 09:17:32','2012-06-08 09:17:32','1/3/117/127',10,3,0,1,'烛台','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candlestick','','','home-decoration/candlestick.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(128,117,'2012-06-08 09:19:07','2012-06-08 09:19:07','1/3/117/128',11,3,0,1,'烟灰缸','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ashtray','','','home-decoration/ashtray.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(129,117,'2012-06-08 09:19:55','2012-06-08 09:19:55','1/3/117/129',12,3,0,1,'烟斗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pipe','','','home-decoration/pipe.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(130,117,'2012-06-08 09:25:56','2012-06-08 09:25:56','1/3/117/130',13,3,0,1,'碗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bowl','','','home-decoration/bowl.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(131,117,'2012-06-08 09:26:54','2012-06-08 09:26:54','1/3/117/131',14,3,0,1,'筷子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','chopsticks','','','home-decoration/chopsticks.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(132,117,'2012-06-08 09:27:34','2012-06-08 09:27:34','1/3/117/132',15,3,0,1,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','home-decoration/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(133,117,'2012-06-08 09:28:18','2012-06-08 09:28:18','1/3/117/133',16,3,0,1,'陶瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ceramic-cup','','','home-decoration/ceramic-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(134,117,'2012-06-08 09:35:54','2012-06-08 09:35:54','1/3/117/134',17,3,0,1,'定制台灯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-table-lamps','','','home-decoration/customize-table-lamps.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(135,117,'2012-06-08 09:36:21','2012-06-08 09:36:43','1/3/117/135',18,3,0,1,'储钱罐','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','piggy-bank','','','home-decoration/piggy-bank.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(136,117,'2012-06-08 09:42:29','2012-06-08 09:42:29','1/3/117/136',19,3,0,1,'墙贴/壁贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wall-stickers','','','home-decoration/wall-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(137,117,'2012-06-08 09:42:54','2012-06-08 09:43:23','1/3/117/137',20,3,0,1,'开关贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','switch-sticker','','','home-decoration/switch-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(138,117,'2012-06-08 09:43:50','2012-06-08 09:44:13','1/3/117/138',21,3,0,1,'水移画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','water-shift-painting','','','home-decoration/water-shift-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(139,117,'2012-06-08 09:44:41','2012-06-08 09:44:41','1/3/117/139',22,3,0,1,'玻璃贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass-paste','','','home-decoration/glass-paste.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(140,117,'2012-06-08 09:45:20','2012-06-08 09:45:20','1/3/117/140',23,3,0,1,'马桶贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','toilet-stickers','','','home-decoration/toilet-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(141,117,'2012-06-08 09:49:30','2012-06-08 09:49:30','1/3/117/141',24,3,0,1,'电脑贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-stickers','','','home-decoration/computer-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(142,117,'2012-06-08 09:50:14','2012-06-08 09:50:14','1/3/117/142',25,3,0,1,'海螺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','conch','','','home-decoration/conch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(143,117,'2012-06-08 09:51:08','2012-06-08 09:51:08','1/3/117/143',26,3,0,1,'招财猫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lucky-cat','','','home-decoration/lucky-cat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(144,117,'2012-06-08 09:53:14','2012-06-08 09:53:14','1/3/117/144',27,3,0,1,'风铃','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','campanula','','','home-decoration/campanula.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(145,117,'2012-06-08 09:57:39','2012-06-08 09:57:39','1/3/117/145',28,3,0,1,'毛绒公仔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hairs-toy','','','home-decoration/hairs-toy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(146,117,'2012-06-08 09:58:22','2012-06-08 09:58:22','1/3/117/146',29,3,0,1,'相片墙','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-wall','','','home-decoration/photo-wall.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(147,3,'2012-06-08 09:59:07','2012-06-18 06:18:54','1/3/147',37,2,5,1,'运动旅行','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','sports-and-travel','','','sports-and-travel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(148,147,'2012-06-08 10:02:50','2012-06-08 10:02:50','1/3/147/148',1,3,0,1,'水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kettle','','','sports-and-travel/kettle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(149,147,'2012-06-08 10:03:32','2012-06-08 10:03:32','1/3/147/149',2,3,0,1,'吊牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hangtag','','','sports-and-travel/hangtag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(150,147,'2012-06-08 10:04:17','2012-06-08 10:04:17','1/3/147/150',3,3,0,1,'行李牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','luggage-tag','','','sports-and-travel/luggage-tag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(151,147,'2012-06-08 10:04:59','2012-06-08 10:04:59','1/3/147/151',4,3,0,1,'折叠小刀','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','folding-knife','','','sports-and-travel/folding-knife.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(152,147,'2012-06-08 10:05:30','2012-06-08 10:05:30','1/3/147/152',5,3,0,1,'运动水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','e-as-ae-a','','','sports-and-travel/e-as-ae-a.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(153,3,'2012-06-08 10:06:32','2012-06-18 06:19:06','1/3/153',38,2,18,1,'印品系列','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printed-materials-series','','','printed-materials-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(154,153,'2012-06-08 10:07:37','2012-06-08 10:07:37','1/3/153/154',1,3,0,1,'拼图','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jigsaw','','','printed-materials-series/jigsaw.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(155,153,'2012-06-08 10:12:32','2012-06-08 10:12:32','1/3/153/155',2,3,0,1,'贺卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','greetings-card','','','printed-materials-series/greetings-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(156,153,'2012-06-08 10:13:19','2012-06-08 10:13:19','1/3/153/156',3,3,0,1,'请柬','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','invitation-card','','','printed-materials-series/invitation-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(157,153,'2012-06-08 10:14:07','2012-06-08 10:14:07','1/3/153/157',4,3,0,1,'海报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poster','','','printed-materials-series/poster.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(158,153,'2012-06-08 10:14:51','2012-06-08 10:14:51','1/3/153/158',5,3,0,1,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','printed-materials-series/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(159,153,'2012-06-08 10:15:30','2012-06-08 10:15:30','1/3/153/159',6,3,0,1,'日历','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','calendar','','','printed-materials-series/calendar.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(160,153,'2012-06-08 10:16:13','2012-06-08 10:16:13','1/3/153/160',7,3,0,1,'菜单','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','carte','','','printed-materials-series/carte.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(161,153,'2012-06-08 10:19:09','2012-06-08 10:19:09','1/3/153/161',8,3,0,1,'生日报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','birthday-newspaper','','','printed-materials-series/birthday-newspaper.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(162,153,'2012-06-08 10:19:51','2012-06-08 10:19:51','1/3/153/162',9,3,0,1,'扑克','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poker','','','printed-materials-series/poker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(163,153,'2012-06-08 10:21:41','2012-06-08 10:21:41','1/3/153/163',10,3,0,1,'竹简','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','inscribed-bamgoo-slips','','','printed-materials-series/inscribed-bamgoo-slips.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(164,153,'2012-06-09 01:20:48','2012-06-09 01:20:48','1/3/153/164',11,3,0,1,'个性证书/奖状','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-certificate','','','printed-materials-series/personalized-certificate.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(165,153,'2012-06-09 01:21:48','2012-06-09 01:21:48','1/3/153/165',12,3,0,1,'卡贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-sticker','','','printed-materials-series/card-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(166,153,'2012-06-09 01:22:30','2012-06-09 01:22:30','1/3/153/166',13,3,0,1,'Lomo照片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lomo-photo','','','printed-materials-series/lomo-photo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(167,153,'2012-06-09 01:23:21','2012-06-09 01:23:21','1/3/153/167',14,3,0,1,'手印泥','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hand-inkpad','','','printed-materials-series/hand-inkpad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(168,153,'2012-06-09 01:27:06','2012-06-09 01:27:06','1/3/153/168',15,3,0,1,'利是封','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','red-packets','','','printed-materials-series/red-packets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(169,153,'2012-06-09 01:27:47','2012-06-09 01:27:47','1/3/153/169',16,3,0,1,'喜糖袋/喜糖盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candy-bags','','','printed-materials-series/candy-bags.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(170,153,'2012-06-09 01:28:32','2012-06-09 01:28:32','1/3/153/170',17,3,0,1,'婚庆桌卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wedding-table-card','','','printed-materials-series/wedding-table-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(171,153,'2012-06-09 01:29:18','2012-06-09 01:29:18','1/3/153/171',18,3,0,1,'杂志','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magazine','','','printed-materials-series/magazine.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(172,3,'2012-06-09 01:30:01','2012-06-18 06:19:17','1/3/172',39,2,0,1,'个性印章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-stamp','','','personalized-stamp.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(173,3,'2012-06-09 01:30:41','2012-06-18 06:19:37','1/3/173',40,2,4,1,'服饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','apparel','','','apparel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(174,173,'2012-06-09 01:31:13','2012-06-09 01:31:13','1/3/173/174',1,3,0,1,'T恤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','t-shirt','','','apparel/t-shirt.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(175,173,'2012-06-09 01:31:45','2012-06-09 01:31:45','1/3/173/175',2,3,0,1,'帽子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hat','','','apparel/hat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(176,173,'2012-06-09 01:32:20','2012-06-09 01:32:20','1/3/173/176',3,3,0,1,'长裤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','trousers','','','apparel/trousers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(177,173,'2012-06-09 01:33:00','2012-06-09 01:33:00','1/3/173/177',4,3,0,1,'围巾','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','scarves','','','apparel/scarves.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(178,3,'2012-06-09 01:33:44','2012-06-18 06:19:46','1/3/178',41,2,8,1,'艺术类','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','art-series','','','art-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(179,178,'2012-06-09 01:34:22','2012-06-09 01:34:22','1/3/178/179',1,3,0,1,'风景油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','landscape-oil-painting','','','art-series/landscape-oil-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(180,178,'2012-06-09 01:35:13','2012-06-09 01:35:13','1/3/178/180',2,3,0,1,'人物油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','figure-painting','','','art-series/figure-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(181,178,'2012-06-09 01:36:00','2012-06-09 01:36:00','1/3/178/181',3,3,0,1,'石头画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','stone-painting','','','art-series/stone-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(182,178,'2012-06-09 01:36:50','2012-06-09 01:36:50','1/3/178/182',4,3,0,1,'瓷片画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','porcelain-painting','','','art-series/porcelain-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(183,178,'2012-06-09 01:37:31','2012-06-09 01:37:31','1/3/178/183',5,3,0,1,'木版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','woodcut','','','art-series/woodcut.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(184,178,'2012-06-09 01:38:11','2012-06-09 01:38:11','1/3/178/184',6,3,0,1,'水晶版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-engraving','','','art-series/crystal-engraving.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(185,178,'2012-06-09 01:39:07','2012-06-09 01:39:07','1/3/178/185',7,3,0,1,'冰雕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ice-art','','','art-series/ice-art.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(186,178,'2012-06-09 01:39:49','2012-06-09 01:39:49','1/3/178/186',8,3,0,1,'软陶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fimo','','','art-series/fimo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,'');
/*!40000 ALTER TABLE `catalog_category_flat_store_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_2`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_2` (
  `entity_id` int(11) unsigned NOT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `children_count` int(11) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `meta_title` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text,
  `meta_description` text,
  `landing_page` int(10) NOT NULL DEFAULT '0',
  `display_mode` varchar(255) NOT NULL DEFAULT '',
  `is_active` int(10) NOT NULL DEFAULT '0',
  `is_anchor` int(10) NOT NULL DEFAULT '0',
  `all_children` text,
  `path_in_store` text,
  `children` text,
  `url_key` varchar(255) NOT NULL DEFAULT '',
  `page_layout` varchar(255) NOT NULL DEFAULT '',
  `custom_layout_update` text,
  `url_path` varchar(255) NOT NULL DEFAULT '',
  `custom_design` varchar(255) NOT NULL DEFAULT '',
  `custom_design_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_design_to` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `available_sort_by` text,
  `default_sort_by` varchar(255) NOT NULL DEFAULT '',
  `include_in_menu` int(10) NOT NULL DEFAULT '0',
  `custom_use_parent_settings` int(10) NOT NULL DEFAULT '0',
  `custom_apply_to_products` int(10) NOT NULL DEFAULT '0',
  `filter_price_range` int(10) NOT NULL DEFAULT '0',
  `thumbnail` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_PATH` (`path`),
  KEY `IDX_LEVEL` (`level`),
  CONSTRAINT `FK_CATEGORY_FLAT_CATEGORY_ID_STORE_2` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATEGORY_FLAT_STORE_ID_STORE_2` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_2`
--

LOCK TABLES `catalog_category_flat_store_2` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_2` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_2` VALUES (1,0,'2007-07-20 18:46:08','2007-08-07 09:50:15','1',1,0,154,2,'','','','','','',0,'',1,0,'','','','','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(3,1,'2007-08-22 15:54:41','2012-06-22 03:58:22','1/3',3,1,153,2,'Root Catalog','','','','','',0,'PRODUCTS',1,0,'3,18,4,5,16,17,19,24,10,22,23,13,8,12,26,25,15,20','','18,10,13,20','root-catalog','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(20,3,'2007-08-25 13:14:09','2008-08-07 23:58:57','1/3/20',20,2,0,2,'Household Items','','','','','',0,'PRODUCTS',0,0,'20','20','','household-items','','','household-items.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,1,1,0,''),(35,3,'2011-03-08 11:35:58','2012-06-12 06:26:42','1/3/35',21,2,0,2,'商家推荐商品','','','','','',0,'PRODUCTS',1,0,'','','','featured-products','','','featured-products.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,1,1,0,''),(36,3,'2012-06-08 06:40:54','2012-06-30 01:39:30','1/3/36',22,2,0,2,'节日庆典','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','occasion','','','occasion.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(37,3,'2012-06-08 06:50:14','2012-06-30 02:12:42','1/3/37',23,2,0,2,'送礼对象','','','','创意生日礼物,商务礼品,高档商务礼品,创意礼物,个性礼物,新奇创意小礼品,定制礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','recipients','','','recipients.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(38,3,'2012-06-08 07:02:28','2012-06-30 01:42:03','1/3/38',24,2,0,2,'创意礼品','','','','创意礼品,个性定制创意礼品,创意生日礼物,企业礼品定制,创意礼品定制网站','',0,'PRODUCTS_AND_PAGE',1,1,'','','','gifts','','','gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(39,3,'2012-06-08 07:03:42','2012-06-30 01:42:23','1/3/39',25,2,0,2,'个性定制','','','','个性礼品定制,创意礼品,创意礼物,创意礼品定制,个性定制系统,个性定制软件,创意小礼品,生日礼物,个性定制礼物,个性定制礼品,新奇创意礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diy','','','diy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(40,3,'2012-06-08 07:06:34','2012-06-26 02:40:56','1/3/40',26,2,4,2,'钟表','','watch-165_1.jpg','','个性定制手表,个性定制钟表,创意礼品钟表,礼品手表','',0,'PRODUCTS_AND_PAGE',1,1,'','','','watch','','','watch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(41,40,'2012-06-08 07:12:36','2012-06-08 07:12:36','1/3/40/41',1,3,0,2,'迪士尼定制手表','','','','','',0,'PRODUCTS',1,0,'','','','disney-watches','','','watch/disney-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(42,40,'2012-06-08 07:13:32','2012-06-08 07:13:32','1/3/40/42',2,3,0,2,'闹钟','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','alarm-clock','','','watch/alarm-clock.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(43,40,'2012-06-08 07:16:01','2012-06-08 07:16:01','1/3/40/43',3,3,0,2,'座钟','','','','','',0,'PRODUCTS',1,0,'','','','timepiece','','','watch/timepiece.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(44,40,'2012-06-08 07:17:22','2012-06-08 07:17:22','1/3/40/44',4,3,0,2,'个性定制手表','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-custom-watches','','','watch/personalized-custom-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(45,3,'2012-06-08 07:18:06','2012-06-18 06:17:32','1/3/45',27,2,4,2,'饰品','','susi.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jewelry','','','jewelry.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(46,45,'2012-06-08 07:19:06','2012-06-08 07:19:06','1/3/45/46',1,3,0,2,'项链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','necklace','','','jewelry/necklace.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(47,45,'2012-06-08 07:20:00','2012-06-08 07:20:00','1/3/45/47',2,3,0,2,'手链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bracelet','','','jewelry/bracelet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(48,45,'2012-06-08 07:20:48','2012-06-08 07:20:48','1/3/45/48',3,3,0,2,'耳环','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','earring','','','jewelry/earring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(49,45,'2012-06-08 07:21:47','2012-06-08 07:21:47','1/3/45/49',4,3,0,2,'戒指','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ring','','','jewelry/ring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(50,3,'2012-06-08 07:22:45','2012-06-18 06:17:40','1/3/50',28,2,5,2,'U盘','','u.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','usb-card','','','usb-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(51,50,'2012-06-08 07:23:46','2012-06-08 07:23:46','1/3/50/51',1,3,0,2,'卡片式U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','u-disk-card','','','usb-card/u-disk-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(52,50,'2012-06-08 07:25:28','2012-06-08 07:25:28','1/3/50/52',2,3,0,2,'木制U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wodden-usb-disk','','','usb-card/wodden-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(53,50,'2012-06-08 07:26:24','2012-06-08 07:26:24','1/3/50/53',3,3,0,2,'皮革U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','leather-usb-disk','','','usb-card/leather-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(54,50,'2012-06-08 07:28:30','2012-06-08 07:28:30','1/3/50/54',4,3,0,2,'金属U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-usb-disk','','','usb-card/metal-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(55,50,'2012-06-08 07:30:55','2012-06-08 07:30:55','1/3/50/55',5,3,0,2,'青花瓷U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','white-porcelain-usb-disk','','','usb-card/white-porcelain-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(56,3,'2012-06-08 07:34:57','2012-06-12 11:00:08','1/3/56',29,2,10,2,'数码配件','','iphone4s.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','digital-accessories','','','digital-accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(57,56,'2012-06-08 07:36:31','2012-06-08 07:36:31','1/3/56/57',1,3,0,2,'浮雕手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fudiao-phone-case','','','digital-accessories/fudiao-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(58,56,'2012-06-08 07:37:08','2012-06-08 07:37:08','1/3/56/58',2,3,0,2,'刻字手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kezi-phone-case','','','digital-accessories/kezi-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(59,56,'2012-06-08 07:37:42','2012-06-08 07:37:42','1/3/56/59',3,3,0,2,'彩印手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caihui-phone-case','','','digital-accessories/caihui-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(60,56,'2012-06-08 07:38:13','2012-06-08 07:38:13','1/3/56/60',4,3,0,2,'鼠标','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse','','','digital-accessories/mouse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(61,56,'2012-06-08 07:39:32','2012-06-08 07:39:32','1/3/56/61',5,3,0,2,'电脑内胆包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-sleeve','','','digital-accessories/computer-sleeve.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(62,56,'2012-06-08 07:40:00','2012-06-08 07:40:00','1/3/56/62',6,3,0,2,'MP3','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mp3','','','digital-accessories/mp3.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(63,56,'2012-06-08 07:41:58','2012-06-08 07:41:58','1/3/56/63',7,3,0,2,'CD包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd-bag','','','digital-accessories/cd-bag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(64,56,'2012-06-08 07:42:25','2012-06-08 07:42:25','1/3/56/64',8,3,0,2,'CD','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd','','','digital-accessories/cd.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(65,56,'2012-06-08 07:42:56','2012-06-08 07:42:56','1/3/56/65',9,3,0,2,'平板电脑','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','tablet-pc','','','digital-accessories/tablet-pc.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(66,56,'2012-06-08 07:44:42','2012-06-08 07:44:42','1/3/56/66',10,3,0,2,'定制iPhone4壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-iphone4-case','','','digital-accessories/customize-iphone4-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(67,3,'2012-06-08 07:47:35','2012-06-18 06:17:48','1/3/67',30,2,4,2,'杯子','','cup_2.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cups','','','cups.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(68,67,'2012-06-08 07:48:13','2012-06-08 07:48:13','1/3/67/68',1,3,0,2,'马克杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mug','','','cups/mug.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(69,67,'2012-06-08 07:50:35','2012-06-08 07:50:35','1/3/67/69',2,3,0,2,'骨瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bone-cup','','','cups/bone-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(70,67,'2012-06-08 07:51:31','2012-06-08 07:51:31','1/3/67/70',3,3,0,2,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','cups/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(71,67,'2012-06-08 07:53:16','2012-06-08 07:53:16','1/3/67/71',4,3,0,2,'变色杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','color-cup','','','cups/color-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(72,3,'2012-06-08 07:53:59','2012-06-18 06:17:58','1/3/72',31,2,5,2,'水晶','','shuiji-2_1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal','','','crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(73,72,'2012-06-08 07:54:45','2012-06-08 07:54:45','1/3/72/73',1,3,0,2,'彩印水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caiyi-crystal','','','crystal/caiyi-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(74,72,'2012-06-08 07:55:24','2012-06-08 07:55:24','1/3/72/74',2,3,0,2,'雕刻水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diaoke-crystal','','','crystal/diaoke-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(75,72,'2012-06-08 07:56:17','2012-06-08 07:56:17','1/3/72/75',3,3,0,2,'水晶名片座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-card-holder','','','crystal/crystal-card-holder.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(76,72,'2012-06-08 07:57:18','2012-06-08 07:57:18','1/3/72/76',4,3,0,2,'内雕水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','laser-crystal','','','crystal/laser-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(77,72,'2012-06-08 07:57:50','2012-06-08 07:58:10','1/3/72/77',5,3,0,2,'水晶奖杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-trophy','','','crystal/crystal-trophy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(78,3,'2012-06-08 07:58:50','2012-06-18 06:18:07','1/3/78',32,2,11,2,'办公用品与文具','','bangong-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','office-supplies','','','office-supplies.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(79,78,'2012-06-08 08:02:49','2012-06-08 08:02:49','1/3/78/79',1,3,0,2,'宝珠笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','roller-pen','','','office-supplies/roller-pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(80,78,'2012-06-08 08:04:11','2012-06-08 08:04:11','1/3/78/80',2,3,0,2,'名片盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cardcase','','','office-supplies/cardcase.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(81,78,'2012-06-08 08:05:08','2012-06-08 08:05:08','1/3/78/81',3,3,0,2,'记事本','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','notepad','','','office-supplies/notepad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(82,78,'2012-06-08 08:07:56','2012-06-08 08:07:56','1/3/78/82',4,3,0,2,'书签','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bookmark','','','office-supplies/bookmark.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(83,78,'2012-06-08 08:08:36','2012-06-08 08:08:36','1/3/78/83',5,3,0,2,'鼠标垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse-mat','','','office-supplies/mouse-mat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(84,78,'2012-06-08 08:09:18','2012-06-08 08:09:18','1/3/78/84',6,3,0,2,'放大镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magnifier','','','office-supplies/magnifier.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(85,78,'2012-06-08 08:10:11','2012-06-08 08:10:11','1/3/78/85',7,3,0,2,'名片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-card','','','office-supplies/business-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(86,78,'2012-06-08 08:10:58','2012-06-08 08:10:58','1/3/78/86',8,3,0,2,'文具盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','writing-case','','','office-supplies/writing-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(87,78,'2012-06-08 08:11:28','2012-06-08 08:11:28','1/3/78/87',9,3,0,2,'直尺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ruler','','','office-supplies/ruler.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(88,78,'2012-06-08 08:15:53','2012-06-08 08:16:01','1/3/78/88',10,3,0,2,'笔筒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','brush-pot','','','office-supplies/brush-pot.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(89,78,'2012-06-08 08:16:32','2012-06-08 08:16:32','1/3/78/89',11,3,0,2,'铱金钢笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pen','','','office-supplies/pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(90,3,'2012-06-08 08:18:11','2012-06-18 06:18:15','1/3/90',33,2,5,2,'商务礼品','','sawu-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-gifts','','','business-gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(91,90,'2012-06-08 08:18:50','2012-06-08 08:18:50','1/3/90/91',1,3,0,2,'奖牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','medal','','','business-gifts/medal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(92,90,'2012-06-08 08:19:34','2012-06-08 08:19:34','1/3/90/92',2,3,0,2,'香水座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','perfume-bottle','','','business-gifts/perfume-bottle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(93,90,'2012-06-08 08:20:15','2012-06-08 08:20:15','1/3/90/93',3,3,0,2,'红木礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','rosewood-gift-set','','','business-gifts/rosewood-gift-set.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(94,90,'2012-06-08 08:20:48','2012-06-08 08:20:48','1/3/90/94',4,3,0,2,'其它礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','other-gift-sets','','','business-gifts/other-gift-sets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(95,90,'2012-06-08 08:21:24','2012-06-08 08:21:24','1/3/90/95',5,3,0,2,'工艺船','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','boat','','','business-gifts/boat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(96,3,'2012-06-08 08:23:16','2012-06-18 06:18:26','1/3/96',34,2,13,2,'配饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','accessories','','','accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(97,96,'2012-06-08 08:24:00','2012-06-08 08:24:00','1/3/96/97',1,3,0,2,'酒壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','flagon','','','accessories/flagon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(98,96,'2012-06-08 08:25:05','2012-06-08 08:25:05','1/3/96/98',2,3,0,2,'个性化徽章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-badges','','','accessories/personalized-badges.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(99,96,'2012-06-08 08:26:03','2012-06-08 08:26:03','1/3/96/99',3,3,0,2,'烟盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cigarette-case','','','accessories/cigarette-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(100,96,'2012-06-08 08:26:52','2012-06-08 08:26:52','1/3/96/100',4,3,0,2,'梳子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','comb','','','accessories/comb.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(101,96,'2012-06-08 08:27:30','2012-06-08 08:27:30','1/3/96/101',5,3,0,2,'卡包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-package','','','accessories/card-package.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(102,96,'2012-06-08 08:28:23','2012-06-08 08:28:23','1/3/96/102',6,3,0,2,'眼镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glasses','','','accessories/glasses.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(103,96,'2012-06-08 08:29:14','2012-06-08 08:29:14','1/3/96/103',7,3,0,2,'钥匙包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','key-cases','','','accessories/key-cases.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(104,96,'2012-06-08 08:29:58','2012-06-08 08:29:58','1/3/96/104',8,3,0,2,'ZIPPO打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','zippo-lighter','','','accessories/zippo-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(105,96,'2012-06-08 08:31:07','2012-06-08 08:31:07','1/3/96/105',9,3,0,2,'青花瓷打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','qinghua-lighter','','','accessories/qinghua-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(106,96,'2012-06-08 08:31:49','2012-06-08 08:31:49','1/3/96/106',10,3,0,2,'皮夹','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wallet','','','accessories/wallet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(107,96,'2012-06-08 08:32:33','2012-06-08 08:32:33','1/3/96/107',11,3,0,2,'化妆镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','vanity-mirron','','','accessories/vanity-mirron.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(108,96,'2012-06-08 08:34:53','2012-06-08 08:34:53','1/3/96/108',12,3,0,2,'钱包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','purse','','','accessories/purse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(109,96,'2012-06-08 08:35:32','2012-06-08 08:35:32','1/3/96/109',13,3,0,2,'音乐盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','music-box','','','accessories/music-box.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(110,3,'2012-06-08 08:36:18','2012-06-18 06:18:34','1/3/110',35,2,6,2,'相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-frame','','','photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(111,110,'2012-06-08 08:36:55','2012-06-08 08:36:55','1/3/110/111',1,3,0,2,'木制相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wooden-photo-frame','','','photo-frame/wooden-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(112,110,'2012-06-08 08:37:38','2012-06-08 08:37:38','1/3/110/112',2,3,0,2,'金属相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-photo-frame','','','photo-frame/metal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(113,110,'2012-06-08 08:38:04','2012-06-08 08:38:25','1/3/110/113',3,3,0,2,'水晶相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-photo-frame','','','photo-frame/crystal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(114,110,'2012-06-08 08:39:21','2012-06-08 08:39:21','1/3/110/114',4,3,0,2,'皮质相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cortex-photo-frame','','','photo-frame/cortex-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(115,110,'2012-06-08 08:40:06','2012-06-08 08:40:06','1/3/110/115',5,3,0,2,'相 册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','photo-frame/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(116,110,'2012-06-08 08:40:49','2012-06-08 08:40:49','1/3/110/116',6,3,0,2,'亚克力相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','acrylic-photo-frame','','','photo-frame/acrylic-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(117,3,'2012-06-08 08:55:19','2012-06-18 06:18:43','1/3/117',36,2,29,2,'家居装饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','home-decoration','','','home-decoration.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(118,117,'2012-06-08 09:00:28','2012-06-08 09:00:28','1/3/117/118',1,3,0,2,'玻璃杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass','','','home-decoration/glass.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(119,117,'2012-06-08 09:01:24','2012-06-08 09:01:24','1/3/117/119',2,3,0,2,'彩印抱枕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printing-pillow','','','home-decoration/printing-pillow.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(120,117,'2012-06-08 09:01:57','2012-06-08 09:01:57','1/3/117/120',3,3,0,2,'餐垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','placemat','','','home-decoration/placemat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(121,117,'2012-06-08 09:02:29','2012-06-08 09:17:48','1/3/117/121',4,3,0,2,'杯垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cup-pad','','','home-decoration/cup-pad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(122,117,'2012-06-08 09:03:09','2012-06-08 09:18:12','1/3/117/122',5,3,0,2,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','home-decoration/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(123,117,'2012-06-08 09:14:11','2012-06-08 09:14:11','1/3/117/123',6,3,0,2,'隔热罩','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','shrouds','two_columns_left','','home-decoration/shrouds.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(124,117,'2012-06-08 09:15:06','2012-06-08 09:15:06','1/3/117/124',7,3,0,2,'字牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','plates','','','home-decoration/plates.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(125,117,'2012-06-08 09:15:45','2012-06-08 09:15:45','1/3/117/125',8,3,0,2,'气球','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ballon','','','home-decoration/ballon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(126,117,'2012-06-08 09:16:23','2012-06-08 09:16:23','1/3/117/126',9,3,0,2,'冰箱贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fridge-magnet','','','home-decoration/fridge-magnet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(127,117,'2012-06-08 09:17:32','2012-06-08 09:17:32','1/3/117/127',10,3,0,2,'烛台','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candlestick','','','home-decoration/candlestick.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(128,117,'2012-06-08 09:19:07','2012-06-08 09:19:07','1/3/117/128',11,3,0,2,'烟灰缸','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ashtray','','','home-decoration/ashtray.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(129,117,'2012-06-08 09:19:55','2012-06-08 09:19:55','1/3/117/129',12,3,0,2,'烟斗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pipe','','','home-decoration/pipe.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(130,117,'2012-06-08 09:25:56','2012-06-08 09:25:56','1/3/117/130',13,3,0,2,'碗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bowl','','','home-decoration/bowl.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(131,117,'2012-06-08 09:26:54','2012-06-08 09:26:54','1/3/117/131',14,3,0,2,'筷子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','chopsticks','','','home-decoration/chopsticks.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(132,117,'2012-06-08 09:27:34','2012-06-08 09:27:34','1/3/117/132',15,3,0,2,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','home-decoration/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(133,117,'2012-06-08 09:28:18','2012-06-08 09:28:18','1/3/117/133',16,3,0,2,'陶瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ceramic-cup','','','home-decoration/ceramic-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(134,117,'2012-06-08 09:35:54','2012-06-08 09:35:54','1/3/117/134',17,3,0,2,'定制台灯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-table-lamps','','','home-decoration/customize-table-lamps.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(135,117,'2012-06-08 09:36:21','2012-06-08 09:36:43','1/3/117/135',18,3,0,2,'储钱罐','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','piggy-bank','','','home-decoration/piggy-bank.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(136,117,'2012-06-08 09:42:29','2012-06-08 09:42:29','1/3/117/136',19,3,0,2,'墙贴/壁贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wall-stickers','','','home-decoration/wall-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(137,117,'2012-06-08 09:42:54','2012-06-08 09:43:23','1/3/117/137',20,3,0,2,'开关贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','switch-sticker','','','home-decoration/switch-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(138,117,'2012-06-08 09:43:50','2012-06-08 09:44:13','1/3/117/138',21,3,0,2,'水移画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','water-shift-painting','','','home-decoration/water-shift-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(139,117,'2012-06-08 09:44:41','2012-06-08 09:44:41','1/3/117/139',22,3,0,2,'玻璃贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass-paste','','','home-decoration/glass-paste.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(140,117,'2012-06-08 09:45:20','2012-06-08 09:45:20','1/3/117/140',23,3,0,2,'马桶贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','toilet-stickers','','','home-decoration/toilet-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(141,117,'2012-06-08 09:49:30','2012-06-08 09:49:30','1/3/117/141',24,3,0,2,'电脑贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-stickers','','','home-decoration/computer-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(142,117,'2012-06-08 09:50:14','2012-06-08 09:50:14','1/3/117/142',25,3,0,2,'海螺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','conch','','','home-decoration/conch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(143,117,'2012-06-08 09:51:08','2012-06-08 09:51:08','1/3/117/143',26,3,0,2,'招财猫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lucky-cat','','','home-decoration/lucky-cat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(144,117,'2012-06-08 09:53:14','2012-06-08 09:53:14','1/3/117/144',27,3,0,2,'风铃','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','campanula','','','home-decoration/campanula.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(145,117,'2012-06-08 09:57:39','2012-06-08 09:57:39','1/3/117/145',28,3,0,2,'毛绒公仔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hairs-toy','','','home-decoration/hairs-toy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(146,117,'2012-06-08 09:58:22','2012-06-08 09:58:22','1/3/117/146',29,3,0,2,'相片墙','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-wall','','','home-decoration/photo-wall.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(147,3,'2012-06-08 09:59:07','2012-06-18 06:18:54','1/3/147',37,2,5,2,'运动旅行','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','sports-and-travel','','','sports-and-travel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(148,147,'2012-06-08 10:02:50','2012-06-08 10:02:50','1/3/147/148',1,3,0,2,'水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kettle','','','sports-and-travel/kettle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(149,147,'2012-06-08 10:03:32','2012-06-08 10:03:32','1/3/147/149',2,3,0,2,'吊牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hangtag','','','sports-and-travel/hangtag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(150,147,'2012-06-08 10:04:17','2012-06-08 10:04:17','1/3/147/150',3,3,0,2,'行李牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','luggage-tag','','','sports-and-travel/luggage-tag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(151,147,'2012-06-08 10:04:59','2012-06-08 10:04:59','1/3/147/151',4,3,0,2,'折叠小刀','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','folding-knife','','','sports-and-travel/folding-knife.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(152,147,'2012-06-08 10:05:30','2012-06-08 10:05:30','1/3/147/152',5,3,0,2,'运动水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','e-as-ae-a','','','sports-and-travel/e-as-ae-a.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(153,3,'2012-06-08 10:06:32','2012-06-18 06:19:06','1/3/153',38,2,18,2,'印品系列','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printed-materials-series','','','printed-materials-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(154,153,'2012-06-08 10:07:37','2012-06-08 10:07:37','1/3/153/154',1,3,0,2,'拼图','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jigsaw','','','printed-materials-series/jigsaw.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(155,153,'2012-06-08 10:12:32','2012-06-08 10:12:32','1/3/153/155',2,3,0,2,'贺卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','greetings-card','','','printed-materials-series/greetings-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(156,153,'2012-06-08 10:13:19','2012-06-08 10:13:19','1/3/153/156',3,3,0,2,'请柬','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','invitation-card','','','printed-materials-series/invitation-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(157,153,'2012-06-08 10:14:07','2012-06-08 10:14:07','1/3/153/157',4,3,0,2,'海报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poster','','','printed-materials-series/poster.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(158,153,'2012-06-08 10:14:51','2012-06-08 10:14:51','1/3/153/158',5,3,0,2,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','printed-materials-series/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(159,153,'2012-06-08 10:15:30','2012-06-08 10:15:30','1/3/153/159',6,3,0,2,'日历','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','calendar','','','printed-materials-series/calendar.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(160,153,'2012-06-08 10:16:13','2012-06-08 10:16:13','1/3/153/160',7,3,0,2,'菜单','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','carte','','','printed-materials-series/carte.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(161,153,'2012-06-08 10:19:09','2012-06-08 10:19:09','1/3/153/161',8,3,0,2,'生日报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','birthday-newspaper','','','printed-materials-series/birthday-newspaper.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(162,153,'2012-06-08 10:19:51','2012-06-08 10:19:51','1/3/153/162',9,3,0,2,'扑克','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poker','','','printed-materials-series/poker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(163,153,'2012-06-08 10:21:41','2012-06-08 10:21:41','1/3/153/163',10,3,0,2,'竹简','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','inscribed-bamgoo-slips','','','printed-materials-series/inscribed-bamgoo-slips.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(164,153,'2012-06-09 01:20:48','2012-06-09 01:20:48','1/3/153/164',11,3,0,2,'个性证书/奖状','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-certificate','','','printed-materials-series/personalized-certificate.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(165,153,'2012-06-09 01:21:48','2012-06-09 01:21:48','1/3/153/165',12,3,0,2,'卡贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-sticker','','','printed-materials-series/card-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(166,153,'2012-06-09 01:22:30','2012-06-09 01:22:30','1/3/153/166',13,3,0,2,'Lomo照片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lomo-photo','','','printed-materials-series/lomo-photo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(167,153,'2012-06-09 01:23:21','2012-06-09 01:23:21','1/3/153/167',14,3,0,2,'手印泥','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hand-inkpad','','','printed-materials-series/hand-inkpad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(168,153,'2012-06-09 01:27:06','2012-06-09 01:27:06','1/3/153/168',15,3,0,2,'利是封','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','red-packets','','','printed-materials-series/red-packets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(169,153,'2012-06-09 01:27:47','2012-06-09 01:27:47','1/3/153/169',16,3,0,2,'喜糖袋/喜糖盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candy-bags','','','printed-materials-series/candy-bags.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(170,153,'2012-06-09 01:28:32','2012-06-09 01:28:32','1/3/153/170',17,3,0,2,'婚庆桌卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wedding-table-card','','','printed-materials-series/wedding-table-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(171,153,'2012-06-09 01:29:18','2012-06-09 01:29:18','1/3/153/171',18,3,0,2,'杂志','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magazine','','','printed-materials-series/magazine.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(172,3,'2012-06-09 01:30:01','2012-06-18 06:19:17','1/3/172',39,2,0,2,'个性印章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-stamp','','','personalized-stamp.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(173,3,'2012-06-09 01:30:41','2012-06-18 06:19:37','1/3/173',40,2,4,2,'服饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','apparel','','','apparel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(174,173,'2012-06-09 01:31:13','2012-06-09 01:31:13','1/3/173/174',1,3,0,2,'T恤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','t-shirt','','','apparel/t-shirt.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(175,173,'2012-06-09 01:31:45','2012-06-09 01:31:45','1/3/173/175',2,3,0,2,'帽子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hat','','','apparel/hat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(176,173,'2012-06-09 01:32:20','2012-06-09 01:32:20','1/3/173/176',3,3,0,2,'长裤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','trousers','','','apparel/trousers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(177,173,'2012-06-09 01:33:00','2012-06-09 01:33:00','1/3/173/177',4,3,0,2,'围巾','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','scarves','','','apparel/scarves.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(178,3,'2012-06-09 01:33:44','2012-06-18 06:19:46','1/3/178',41,2,8,2,'艺术类','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','art-series','','','art-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(179,178,'2012-06-09 01:34:22','2012-06-09 01:34:22','1/3/178/179',1,3,0,2,'风景油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','landscape-oil-painting','','','art-series/landscape-oil-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(180,178,'2012-06-09 01:35:13','2012-06-09 01:35:13','1/3/178/180',2,3,0,2,'人物油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','figure-painting','','','art-series/figure-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(181,178,'2012-06-09 01:36:00','2012-06-09 01:36:00','1/3/178/181',3,3,0,2,'石头画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','stone-painting','','','art-series/stone-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(182,178,'2012-06-09 01:36:50','2012-06-09 01:36:50','1/3/178/182',4,3,0,2,'瓷片画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','porcelain-painting','','','art-series/porcelain-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(183,178,'2012-06-09 01:37:31','2012-06-09 01:37:31','1/3/178/183',5,3,0,2,'木版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','woodcut','','','art-series/woodcut.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(184,178,'2012-06-09 01:38:11','2012-06-09 01:38:11','1/3/178/184',6,3,0,2,'水晶版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-engraving','','','art-series/crystal-engraving.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(185,178,'2012-06-09 01:39:07','2012-06-09 01:39:07','1/3/178/185',7,3,0,2,'冰雕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ice-art','','','art-series/ice-art.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(186,178,'2012-06-09 01:39:49','2012-06-09 01:39:49','1/3/178/186',8,3,0,2,'软陶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fimo','','','art-series/fimo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,'');
/*!40000 ALTER TABLE `catalog_category_flat_store_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_3`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_3` (
  `entity_id` int(11) unsigned NOT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `children_count` int(11) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `meta_title` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text,
  `meta_description` text,
  `landing_page` int(10) NOT NULL DEFAULT '0',
  `display_mode` varchar(255) NOT NULL DEFAULT '',
  `is_active` int(10) NOT NULL DEFAULT '0',
  `is_anchor` int(10) NOT NULL DEFAULT '0',
  `all_children` text,
  `path_in_store` text,
  `children` text,
  `url_key` varchar(255) NOT NULL DEFAULT '',
  `page_layout` varchar(255) NOT NULL DEFAULT '',
  `custom_layout_update` text,
  `url_path` varchar(255) NOT NULL DEFAULT '',
  `custom_design` varchar(255) NOT NULL DEFAULT '',
  `custom_design_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_design_to` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `available_sort_by` text,
  `default_sort_by` varchar(255) NOT NULL DEFAULT '',
  `include_in_menu` int(10) NOT NULL DEFAULT '0',
  `custom_use_parent_settings` int(10) NOT NULL DEFAULT '0',
  `custom_apply_to_products` int(10) NOT NULL DEFAULT '0',
  `filter_price_range` int(10) NOT NULL DEFAULT '0',
  `thumbnail` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_PATH` (`path`),
  KEY `IDX_LEVEL` (`level`),
  CONSTRAINT `FK_CATEGORY_FLAT_CATEGORY_ID_STORE_3` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATEGORY_FLAT_STORE_ID_STORE_3` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_3`
--

LOCK TABLES `catalog_category_flat_store_3` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_3` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_3` VALUES (1,0,'2007-07-20 18:46:08','2007-08-07 09:50:15','1',1,0,154,3,'','','','','','',0,'',1,0,'','','','','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(3,1,'2007-08-22 15:54:41','2012-06-22 03:58:22','1/3',3,1,153,3,'Root Catalog','','','','','',0,'PRODUCTS',1,0,'3,18,4,5,16,17,19,24,10,22,23,13,8,12,26,25,15,20','','18,10,13,20','root-catalog','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(20,3,'2007-08-25 13:14:09','2008-08-07 23:58:57','1/3/20',20,2,0,3,'Household Items','','','','','',0,'PRODUCTS',0,0,'20','20','','household-items','','','household-items.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,1,1,0,''),(35,3,'2011-03-08 11:35:58','2012-06-12 06:26:42','1/3/35',21,2,0,3,'商家推荐商品','','','','','',0,'PRODUCTS',1,0,'','','','featured-products','','','featured-products.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,1,1,0,''),(36,3,'2012-06-08 06:40:54','2012-06-30 01:39:30','1/3/36',22,2,0,3,'节日庆典','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','occasion','','','occasion.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(37,3,'2012-06-08 06:50:14','2012-06-30 02:12:42','1/3/37',23,2,0,3,'送礼对象','','','','创意生日礼物,商务礼品,高档商务礼品,创意礼物,个性礼物,新奇创意小礼品,定制礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','recipients','','','recipients.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(38,3,'2012-06-08 07:02:28','2012-06-30 01:42:03','1/3/38',24,2,0,3,'创意礼品','','','','创意礼品,个性定制创意礼品,创意生日礼物,企业礼品定制,创意礼品定制网站','',0,'PRODUCTS_AND_PAGE',1,1,'','','','gifts','','','gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(39,3,'2012-06-08 07:03:42','2012-06-30 01:42:23','1/3/39',25,2,0,3,'个性定制','','','','个性礼品定制,创意礼品,创意礼物,创意礼品定制,个性定制系统,个性定制软件,创意小礼品,生日礼物,个性定制礼物,个性定制礼品,新奇创意礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diy','','','diy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(40,3,'2012-06-08 07:06:34','2012-06-26 02:40:56','1/3/40',26,2,4,3,'钟表','','watch-165_1.jpg','','个性定制手表,个性定制钟表,创意礼品钟表,礼品手表','',0,'PRODUCTS_AND_PAGE',1,1,'','','','watch','','','watch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(41,40,'2012-06-08 07:12:36','2012-06-08 07:12:36','1/3/40/41',1,3,0,3,'迪士尼定制手表','','','','','',0,'PRODUCTS',1,0,'','','','disney-watches','','','watch/disney-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(42,40,'2012-06-08 07:13:32','2012-06-08 07:13:32','1/3/40/42',2,3,0,3,'闹钟','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','alarm-clock','','','watch/alarm-clock.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(43,40,'2012-06-08 07:16:01','2012-06-08 07:16:01','1/3/40/43',3,3,0,3,'座钟','','','','','',0,'PRODUCTS',1,0,'','','','timepiece','','','watch/timepiece.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(44,40,'2012-06-08 07:17:22','2012-06-08 07:17:22','1/3/40/44',4,3,0,3,'个性定制手表','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-custom-watches','','','watch/personalized-custom-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(45,3,'2012-06-08 07:18:06','2012-06-18 06:17:32','1/3/45',27,2,4,3,'饰品','','susi.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jewelry','','','jewelry.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(46,45,'2012-06-08 07:19:06','2012-06-08 07:19:06','1/3/45/46',1,3,0,3,'项链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','necklace','','','jewelry/necklace.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(47,45,'2012-06-08 07:20:00','2012-06-08 07:20:00','1/3/45/47',2,3,0,3,'手链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bracelet','','','jewelry/bracelet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(48,45,'2012-06-08 07:20:48','2012-06-08 07:20:48','1/3/45/48',3,3,0,3,'耳环','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','earring','','','jewelry/earring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(49,45,'2012-06-08 07:21:47','2012-06-08 07:21:47','1/3/45/49',4,3,0,3,'戒指','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ring','','','jewelry/ring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(50,3,'2012-06-08 07:22:45','2012-06-18 06:17:40','1/3/50',28,2,5,3,'U盘','','u.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','usb-card','','','usb-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(51,50,'2012-06-08 07:23:46','2012-06-08 07:23:46','1/3/50/51',1,3,0,3,'卡片式U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','u-disk-card','','','usb-card/u-disk-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(52,50,'2012-06-08 07:25:28','2012-06-08 07:25:28','1/3/50/52',2,3,0,3,'木制U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wodden-usb-disk','','','usb-card/wodden-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(53,50,'2012-06-08 07:26:24','2012-06-08 07:26:24','1/3/50/53',3,3,0,3,'皮革U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','leather-usb-disk','','','usb-card/leather-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(54,50,'2012-06-08 07:28:30','2012-06-08 07:28:30','1/3/50/54',4,3,0,3,'金属U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-usb-disk','','','usb-card/metal-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(55,50,'2012-06-08 07:30:55','2012-06-08 07:30:55','1/3/50/55',5,3,0,3,'青花瓷U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','white-porcelain-usb-disk','','','usb-card/white-porcelain-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(56,3,'2012-06-08 07:34:57','2012-06-12 11:00:08','1/3/56',29,2,10,3,'数码配件','','iphone4s.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','digital-accessories','','','digital-accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(57,56,'2012-06-08 07:36:31','2012-06-08 07:36:31','1/3/56/57',1,3,0,3,'浮雕手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fudiao-phone-case','','','digital-accessories/fudiao-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(58,56,'2012-06-08 07:37:08','2012-06-08 07:37:08','1/3/56/58',2,3,0,3,'刻字手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kezi-phone-case','','','digital-accessories/kezi-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(59,56,'2012-06-08 07:37:42','2012-06-08 07:37:42','1/3/56/59',3,3,0,3,'彩印手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caihui-phone-case','','','digital-accessories/caihui-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(60,56,'2012-06-08 07:38:13','2012-06-08 07:38:13','1/3/56/60',4,3,0,3,'鼠标','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse','','','digital-accessories/mouse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(61,56,'2012-06-08 07:39:32','2012-06-08 07:39:32','1/3/56/61',5,3,0,3,'电脑内胆包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-sleeve','','','digital-accessories/computer-sleeve.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(62,56,'2012-06-08 07:40:00','2012-06-08 07:40:00','1/3/56/62',6,3,0,3,'MP3','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mp3','','','digital-accessories/mp3.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(63,56,'2012-06-08 07:41:58','2012-06-08 07:41:58','1/3/56/63',7,3,0,3,'CD包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd-bag','','','digital-accessories/cd-bag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(64,56,'2012-06-08 07:42:25','2012-06-08 07:42:25','1/3/56/64',8,3,0,3,'CD','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd','','','digital-accessories/cd.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(65,56,'2012-06-08 07:42:56','2012-06-08 07:42:56','1/3/56/65',9,3,0,3,'平板电脑','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','tablet-pc','','','digital-accessories/tablet-pc.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(66,56,'2012-06-08 07:44:42','2012-06-08 07:44:42','1/3/56/66',10,3,0,3,'定制iPhone4壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-iphone4-case','','','digital-accessories/customize-iphone4-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(67,3,'2012-06-08 07:47:35','2012-06-18 06:17:48','1/3/67',30,2,4,3,'杯子','','cup_2.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cups','','','cups.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(68,67,'2012-06-08 07:48:13','2012-06-08 07:48:13','1/3/67/68',1,3,0,3,'马克杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mug','','','cups/mug.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(69,67,'2012-06-08 07:50:35','2012-06-08 07:50:35','1/3/67/69',2,3,0,3,'骨瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bone-cup','','','cups/bone-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(70,67,'2012-06-08 07:51:31','2012-06-08 07:51:31','1/3/67/70',3,3,0,3,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','cups/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(71,67,'2012-06-08 07:53:16','2012-06-08 07:53:16','1/3/67/71',4,3,0,3,'变色杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','color-cup','','','cups/color-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(72,3,'2012-06-08 07:53:59','2012-06-18 06:17:58','1/3/72',31,2,5,3,'水晶','','shuiji-2_1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal','','','crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(73,72,'2012-06-08 07:54:45','2012-06-08 07:54:45','1/3/72/73',1,3,0,3,'彩印水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caiyi-crystal','','','crystal/caiyi-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(74,72,'2012-06-08 07:55:24','2012-06-08 07:55:24','1/3/72/74',2,3,0,3,'雕刻水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diaoke-crystal','','','crystal/diaoke-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(75,72,'2012-06-08 07:56:17','2012-06-08 07:56:17','1/3/72/75',3,3,0,3,'水晶名片座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-card-holder','','','crystal/crystal-card-holder.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(76,72,'2012-06-08 07:57:18','2012-06-08 07:57:18','1/3/72/76',4,3,0,3,'内雕水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','laser-crystal','','','crystal/laser-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(77,72,'2012-06-08 07:57:50','2012-06-08 07:58:10','1/3/72/77',5,3,0,3,'水晶奖杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-trophy','','','crystal/crystal-trophy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(78,3,'2012-06-08 07:58:50','2012-06-18 06:18:07','1/3/78',32,2,11,3,'办公用品与文具','','bangong-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','office-supplies','','','office-supplies.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(79,78,'2012-06-08 08:02:49','2012-06-08 08:02:49','1/3/78/79',1,3,0,3,'宝珠笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','roller-pen','','','office-supplies/roller-pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(80,78,'2012-06-08 08:04:11','2012-06-08 08:04:11','1/3/78/80',2,3,0,3,'名片盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cardcase','','','office-supplies/cardcase.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(81,78,'2012-06-08 08:05:08','2012-06-08 08:05:08','1/3/78/81',3,3,0,3,'记事本','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','notepad','','','office-supplies/notepad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(82,78,'2012-06-08 08:07:56','2012-06-08 08:07:56','1/3/78/82',4,3,0,3,'书签','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bookmark','','','office-supplies/bookmark.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(83,78,'2012-06-08 08:08:36','2012-06-08 08:08:36','1/3/78/83',5,3,0,3,'鼠标垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse-mat','','','office-supplies/mouse-mat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(84,78,'2012-06-08 08:09:18','2012-06-08 08:09:18','1/3/78/84',6,3,0,3,'放大镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magnifier','','','office-supplies/magnifier.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(85,78,'2012-06-08 08:10:11','2012-06-08 08:10:11','1/3/78/85',7,3,0,3,'名片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-card','','','office-supplies/business-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(86,78,'2012-06-08 08:10:58','2012-06-08 08:10:58','1/3/78/86',8,3,0,3,'文具盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','writing-case','','','office-supplies/writing-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(87,78,'2012-06-08 08:11:28','2012-06-08 08:11:28','1/3/78/87',9,3,0,3,'直尺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ruler','','','office-supplies/ruler.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(88,78,'2012-06-08 08:15:53','2012-06-08 08:16:01','1/3/78/88',10,3,0,3,'笔筒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','brush-pot','','','office-supplies/brush-pot.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(89,78,'2012-06-08 08:16:32','2012-06-08 08:16:32','1/3/78/89',11,3,0,3,'铱金钢笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pen','','','office-supplies/pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(90,3,'2012-06-08 08:18:11','2012-06-18 06:18:15','1/3/90',33,2,5,3,'商务礼品','','sawu-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-gifts','','','business-gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(91,90,'2012-06-08 08:18:50','2012-06-08 08:18:50','1/3/90/91',1,3,0,3,'奖牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','medal','','','business-gifts/medal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(92,90,'2012-06-08 08:19:34','2012-06-08 08:19:34','1/3/90/92',2,3,0,3,'香水座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','perfume-bottle','','','business-gifts/perfume-bottle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(93,90,'2012-06-08 08:20:15','2012-06-08 08:20:15','1/3/90/93',3,3,0,3,'红木礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','rosewood-gift-set','','','business-gifts/rosewood-gift-set.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(94,90,'2012-06-08 08:20:48','2012-06-08 08:20:48','1/3/90/94',4,3,0,3,'其它礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','other-gift-sets','','','business-gifts/other-gift-sets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(95,90,'2012-06-08 08:21:24','2012-06-08 08:21:24','1/3/90/95',5,3,0,3,'工艺船','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','boat','','','business-gifts/boat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(96,3,'2012-06-08 08:23:16','2012-06-18 06:18:26','1/3/96',34,2,13,3,'配饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','accessories','','','accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(97,96,'2012-06-08 08:24:00','2012-06-08 08:24:00','1/3/96/97',1,3,0,3,'酒壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','flagon','','','accessories/flagon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(98,96,'2012-06-08 08:25:05','2012-06-08 08:25:05','1/3/96/98',2,3,0,3,'个性化徽章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-badges','','','accessories/personalized-badges.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(99,96,'2012-06-08 08:26:03','2012-06-08 08:26:03','1/3/96/99',3,3,0,3,'烟盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cigarette-case','','','accessories/cigarette-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(100,96,'2012-06-08 08:26:52','2012-06-08 08:26:52','1/3/96/100',4,3,0,3,'梳子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','comb','','','accessories/comb.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(101,96,'2012-06-08 08:27:30','2012-06-08 08:27:30','1/3/96/101',5,3,0,3,'卡包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-package','','','accessories/card-package.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(102,96,'2012-06-08 08:28:23','2012-06-08 08:28:23','1/3/96/102',6,3,0,3,'眼镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glasses','','','accessories/glasses.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(103,96,'2012-06-08 08:29:14','2012-06-08 08:29:14','1/3/96/103',7,3,0,3,'钥匙包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','key-cases','','','accessories/key-cases.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(104,96,'2012-06-08 08:29:58','2012-06-08 08:29:58','1/3/96/104',8,3,0,3,'ZIPPO打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','zippo-lighter','','','accessories/zippo-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(105,96,'2012-06-08 08:31:07','2012-06-08 08:31:07','1/3/96/105',9,3,0,3,'青花瓷打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','qinghua-lighter','','','accessories/qinghua-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(106,96,'2012-06-08 08:31:49','2012-06-08 08:31:49','1/3/96/106',10,3,0,3,'皮夹','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wallet','','','accessories/wallet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(107,96,'2012-06-08 08:32:33','2012-06-08 08:32:33','1/3/96/107',11,3,0,3,'化妆镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','vanity-mirron','','','accessories/vanity-mirron.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(108,96,'2012-06-08 08:34:53','2012-06-08 08:34:53','1/3/96/108',12,3,0,3,'钱包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','purse','','','accessories/purse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(109,96,'2012-06-08 08:35:32','2012-06-08 08:35:32','1/3/96/109',13,3,0,3,'音乐盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','music-box','','','accessories/music-box.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(110,3,'2012-06-08 08:36:18','2012-06-18 06:18:34','1/3/110',35,2,6,3,'相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-frame','','','photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(111,110,'2012-06-08 08:36:55','2012-06-08 08:36:55','1/3/110/111',1,3,0,3,'木制相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wooden-photo-frame','','','photo-frame/wooden-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(112,110,'2012-06-08 08:37:38','2012-06-08 08:37:38','1/3/110/112',2,3,0,3,'金属相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-photo-frame','','','photo-frame/metal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(113,110,'2012-06-08 08:38:04','2012-06-08 08:38:25','1/3/110/113',3,3,0,3,'水晶相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-photo-frame','','','photo-frame/crystal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(114,110,'2012-06-08 08:39:21','2012-06-08 08:39:21','1/3/110/114',4,3,0,3,'皮质相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cortex-photo-frame','','','photo-frame/cortex-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(115,110,'2012-06-08 08:40:06','2012-06-08 08:40:06','1/3/110/115',5,3,0,3,'相 册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','photo-frame/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(116,110,'2012-06-08 08:40:49','2012-06-08 08:40:49','1/3/110/116',6,3,0,3,'亚克力相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','acrylic-photo-frame','','','photo-frame/acrylic-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(117,3,'2012-06-08 08:55:19','2012-06-18 06:18:43','1/3/117',36,2,29,3,'家居装饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','home-decoration','','','home-decoration.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(118,117,'2012-06-08 09:00:28','2012-06-08 09:00:28','1/3/117/118',1,3,0,3,'玻璃杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass','','','home-decoration/glass.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(119,117,'2012-06-08 09:01:24','2012-06-08 09:01:24','1/3/117/119',2,3,0,3,'彩印抱枕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printing-pillow','','','home-decoration/printing-pillow.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(120,117,'2012-06-08 09:01:57','2012-06-08 09:01:57','1/3/117/120',3,3,0,3,'餐垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','placemat','','','home-decoration/placemat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(121,117,'2012-06-08 09:02:29','2012-06-08 09:17:48','1/3/117/121',4,3,0,3,'杯垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cup-pad','','','home-decoration/cup-pad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(122,117,'2012-06-08 09:03:09','2012-06-08 09:18:12','1/3/117/122',5,3,0,3,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','home-decoration/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(123,117,'2012-06-08 09:14:11','2012-06-08 09:14:11','1/3/117/123',6,3,0,3,'隔热罩','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','shrouds','two_columns_left','','home-decoration/shrouds.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(124,117,'2012-06-08 09:15:06','2012-06-08 09:15:06','1/3/117/124',7,3,0,3,'字牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','plates','','','home-decoration/plates.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(125,117,'2012-06-08 09:15:45','2012-06-08 09:15:45','1/3/117/125',8,3,0,3,'气球','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ballon','','','home-decoration/ballon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(126,117,'2012-06-08 09:16:23','2012-06-08 09:16:23','1/3/117/126',9,3,0,3,'冰箱贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fridge-magnet','','','home-decoration/fridge-magnet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(127,117,'2012-06-08 09:17:32','2012-06-08 09:17:32','1/3/117/127',10,3,0,3,'烛台','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candlestick','','','home-decoration/candlestick.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(128,117,'2012-06-08 09:19:07','2012-06-08 09:19:07','1/3/117/128',11,3,0,3,'烟灰缸','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ashtray','','','home-decoration/ashtray.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(129,117,'2012-06-08 09:19:55','2012-06-08 09:19:55','1/3/117/129',12,3,0,3,'烟斗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pipe','','','home-decoration/pipe.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(130,117,'2012-06-08 09:25:56','2012-06-08 09:25:56','1/3/117/130',13,3,0,3,'碗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bowl','','','home-decoration/bowl.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(131,117,'2012-06-08 09:26:54','2012-06-08 09:26:54','1/3/117/131',14,3,0,3,'筷子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','chopsticks','','','home-decoration/chopsticks.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(132,117,'2012-06-08 09:27:34','2012-06-08 09:27:34','1/3/117/132',15,3,0,3,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','home-decoration/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(133,117,'2012-06-08 09:28:18','2012-06-08 09:28:18','1/3/117/133',16,3,0,3,'陶瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ceramic-cup','','','home-decoration/ceramic-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(134,117,'2012-06-08 09:35:54','2012-06-08 09:35:54','1/3/117/134',17,3,0,3,'定制台灯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-table-lamps','','','home-decoration/customize-table-lamps.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(135,117,'2012-06-08 09:36:21','2012-06-08 09:36:43','1/3/117/135',18,3,0,3,'储钱罐','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','piggy-bank','','','home-decoration/piggy-bank.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(136,117,'2012-06-08 09:42:29','2012-06-08 09:42:29','1/3/117/136',19,3,0,3,'墙贴/壁贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wall-stickers','','','home-decoration/wall-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(137,117,'2012-06-08 09:42:54','2012-06-08 09:43:23','1/3/117/137',20,3,0,3,'开关贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','switch-sticker','','','home-decoration/switch-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(138,117,'2012-06-08 09:43:50','2012-06-08 09:44:13','1/3/117/138',21,3,0,3,'水移画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','water-shift-painting','','','home-decoration/water-shift-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(139,117,'2012-06-08 09:44:41','2012-06-08 09:44:41','1/3/117/139',22,3,0,3,'玻璃贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass-paste','','','home-decoration/glass-paste.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(140,117,'2012-06-08 09:45:20','2012-06-08 09:45:20','1/3/117/140',23,3,0,3,'马桶贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','toilet-stickers','','','home-decoration/toilet-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(141,117,'2012-06-08 09:49:30','2012-06-08 09:49:30','1/3/117/141',24,3,0,3,'电脑贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-stickers','','','home-decoration/computer-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(142,117,'2012-06-08 09:50:14','2012-06-08 09:50:14','1/3/117/142',25,3,0,3,'海螺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','conch','','','home-decoration/conch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(143,117,'2012-06-08 09:51:08','2012-06-08 09:51:08','1/3/117/143',26,3,0,3,'招财猫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lucky-cat','','','home-decoration/lucky-cat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(144,117,'2012-06-08 09:53:14','2012-06-08 09:53:14','1/3/117/144',27,3,0,3,'风铃','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','campanula','','','home-decoration/campanula.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(145,117,'2012-06-08 09:57:39','2012-06-08 09:57:39','1/3/117/145',28,3,0,3,'毛绒公仔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hairs-toy','','','home-decoration/hairs-toy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(146,117,'2012-06-08 09:58:22','2012-06-08 09:58:22','1/3/117/146',29,3,0,3,'相片墙','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-wall','','','home-decoration/photo-wall.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(147,3,'2012-06-08 09:59:07','2012-06-18 06:18:54','1/3/147',37,2,5,3,'运动旅行','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','sports-and-travel','','','sports-and-travel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(148,147,'2012-06-08 10:02:50','2012-06-08 10:02:50','1/3/147/148',1,3,0,3,'水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kettle','','','sports-and-travel/kettle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(149,147,'2012-06-08 10:03:32','2012-06-08 10:03:32','1/3/147/149',2,3,0,3,'吊牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hangtag','','','sports-and-travel/hangtag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(150,147,'2012-06-08 10:04:17','2012-06-08 10:04:17','1/3/147/150',3,3,0,3,'行李牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','luggage-tag','','','sports-and-travel/luggage-tag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(151,147,'2012-06-08 10:04:59','2012-06-08 10:04:59','1/3/147/151',4,3,0,3,'折叠小刀','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','folding-knife','','','sports-and-travel/folding-knife.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(152,147,'2012-06-08 10:05:30','2012-06-08 10:05:30','1/3/147/152',5,3,0,3,'运动水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','e-as-ae-a','','','sports-and-travel/e-as-ae-a.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(153,3,'2012-06-08 10:06:32','2012-06-18 06:19:06','1/3/153',38,2,18,3,'印品系列','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printed-materials-series','','','printed-materials-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(154,153,'2012-06-08 10:07:37','2012-06-08 10:07:37','1/3/153/154',1,3,0,3,'拼图','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jigsaw','','','printed-materials-series/jigsaw.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(155,153,'2012-06-08 10:12:32','2012-06-08 10:12:32','1/3/153/155',2,3,0,3,'贺卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','greetings-card','','','printed-materials-series/greetings-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(156,153,'2012-06-08 10:13:19','2012-06-08 10:13:19','1/3/153/156',3,3,0,3,'请柬','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','invitation-card','','','printed-materials-series/invitation-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(157,153,'2012-06-08 10:14:07','2012-06-08 10:14:07','1/3/153/157',4,3,0,3,'海报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poster','','','printed-materials-series/poster.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(158,153,'2012-06-08 10:14:51','2012-06-08 10:14:51','1/3/153/158',5,3,0,3,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','printed-materials-series/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(159,153,'2012-06-08 10:15:30','2012-06-08 10:15:30','1/3/153/159',6,3,0,3,'日历','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','calendar','','','printed-materials-series/calendar.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(160,153,'2012-06-08 10:16:13','2012-06-08 10:16:13','1/3/153/160',7,3,0,3,'菜单','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','carte','','','printed-materials-series/carte.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(161,153,'2012-06-08 10:19:09','2012-06-08 10:19:09','1/3/153/161',8,3,0,3,'生日报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','birthday-newspaper','','','printed-materials-series/birthday-newspaper.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(162,153,'2012-06-08 10:19:51','2012-06-08 10:19:51','1/3/153/162',9,3,0,3,'扑克','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poker','','','printed-materials-series/poker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(163,153,'2012-06-08 10:21:41','2012-06-08 10:21:41','1/3/153/163',10,3,0,3,'竹简','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','inscribed-bamgoo-slips','','','printed-materials-series/inscribed-bamgoo-slips.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(164,153,'2012-06-09 01:20:48','2012-06-09 01:20:48','1/3/153/164',11,3,0,3,'个性证书/奖状','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-certificate','','','printed-materials-series/personalized-certificate.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(165,153,'2012-06-09 01:21:48','2012-06-09 01:21:48','1/3/153/165',12,3,0,3,'卡贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-sticker','','','printed-materials-series/card-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(166,153,'2012-06-09 01:22:30','2012-06-09 01:22:30','1/3/153/166',13,3,0,3,'Lomo照片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lomo-photo','','','printed-materials-series/lomo-photo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(167,153,'2012-06-09 01:23:21','2012-06-09 01:23:21','1/3/153/167',14,3,0,3,'手印泥','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hand-inkpad','','','printed-materials-series/hand-inkpad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(168,153,'2012-06-09 01:27:06','2012-06-09 01:27:06','1/3/153/168',15,3,0,3,'利是封','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','red-packets','','','printed-materials-series/red-packets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(169,153,'2012-06-09 01:27:47','2012-06-09 01:27:47','1/3/153/169',16,3,0,3,'喜糖袋/喜糖盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candy-bags','','','printed-materials-series/candy-bags.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(170,153,'2012-06-09 01:28:32','2012-06-09 01:28:32','1/3/153/170',17,3,0,3,'婚庆桌卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wedding-table-card','','','printed-materials-series/wedding-table-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(171,153,'2012-06-09 01:29:18','2012-06-09 01:29:18','1/3/153/171',18,3,0,3,'杂志','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magazine','','','printed-materials-series/magazine.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(172,3,'2012-06-09 01:30:01','2012-06-18 06:19:17','1/3/172',39,2,0,3,'个性印章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-stamp','','','personalized-stamp.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(173,3,'2012-06-09 01:30:41','2012-06-18 06:19:37','1/3/173',40,2,4,3,'服饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','apparel','','','apparel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(174,173,'2012-06-09 01:31:13','2012-06-09 01:31:13','1/3/173/174',1,3,0,3,'T恤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','t-shirt','','','apparel/t-shirt.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(175,173,'2012-06-09 01:31:45','2012-06-09 01:31:45','1/3/173/175',2,3,0,3,'帽子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hat','','','apparel/hat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(176,173,'2012-06-09 01:32:20','2012-06-09 01:32:20','1/3/173/176',3,3,0,3,'长裤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','trousers','','','apparel/trousers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(177,173,'2012-06-09 01:33:00','2012-06-09 01:33:00','1/3/173/177',4,3,0,3,'围巾','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','scarves','','','apparel/scarves.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(178,3,'2012-06-09 01:33:44','2012-06-18 06:19:46','1/3/178',41,2,8,3,'艺术类','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','art-series','','','art-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(179,178,'2012-06-09 01:34:22','2012-06-09 01:34:22','1/3/178/179',1,3,0,3,'风景油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','landscape-oil-painting','','','art-series/landscape-oil-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(180,178,'2012-06-09 01:35:13','2012-06-09 01:35:13','1/3/178/180',2,3,0,3,'人物油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','figure-painting','','','art-series/figure-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(181,178,'2012-06-09 01:36:00','2012-06-09 01:36:00','1/3/178/181',3,3,0,3,'石头画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','stone-painting','','','art-series/stone-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(182,178,'2012-06-09 01:36:50','2012-06-09 01:36:50','1/3/178/182',4,3,0,3,'瓷片画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','porcelain-painting','','','art-series/porcelain-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(183,178,'2012-06-09 01:37:31','2012-06-09 01:37:31','1/3/178/183',5,3,0,3,'木版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','woodcut','','','art-series/woodcut.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(184,178,'2012-06-09 01:38:11','2012-06-09 01:38:11','1/3/178/184',6,3,0,3,'水晶版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-engraving','','','art-series/crystal-engraving.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(185,178,'2012-06-09 01:39:07','2012-06-09 01:39:07','1/3/178/185',7,3,0,3,'冰雕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ice-art','','','art-series/ice-art.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(186,178,'2012-06-09 01:39:49','2012-06-09 01:39:49','1/3/178/186',8,3,0,3,'软陶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fimo','','','art-series/fimo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,'');
/*!40000 ALTER TABLE `catalog_category_flat_store_3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_4`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_4` (
  `entity_id` int(11) unsigned NOT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `children_count` int(11) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `meta_title` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text,
  `meta_description` text,
  `landing_page` int(10) NOT NULL DEFAULT '0',
  `display_mode` varchar(255) NOT NULL DEFAULT '',
  `is_active` int(10) NOT NULL DEFAULT '0',
  `is_anchor` int(10) NOT NULL DEFAULT '0',
  `all_children` text,
  `path_in_store` text,
  `children` text,
  `url_key` varchar(255) NOT NULL DEFAULT '',
  `page_layout` varchar(255) NOT NULL DEFAULT '',
  `custom_layout_update` text,
  `url_path` varchar(255) NOT NULL DEFAULT '',
  `custom_design` varchar(255) NOT NULL DEFAULT '',
  `custom_design_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_design_to` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `available_sort_by` text,
  `default_sort_by` varchar(255) NOT NULL DEFAULT '',
  `include_in_menu` int(10) NOT NULL DEFAULT '0',
  `custom_use_parent_settings` int(10) NOT NULL DEFAULT '0',
  `custom_apply_to_products` int(10) NOT NULL DEFAULT '0',
  `filter_price_range` int(10) NOT NULL DEFAULT '0',
  `thumbnail` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_PATH` (`path`),
  KEY `IDX_LEVEL` (`level`),
  CONSTRAINT `FK_CATEGORY_FLAT_CATEGORY_ID_STORE_4` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATEGORY_FLAT_STORE_ID_STORE_4` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_4`
--

LOCK TABLES `catalog_category_flat_store_4` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_4` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_4` VALUES (1,0,'2007-07-20 18:46:08','2007-08-07 09:50:15','1',1,0,154,4,'','','','','','',0,'',1,0,'','','','','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(3,1,'2007-08-22 15:54:41','2012-06-22 03:58:22','1/3',3,1,153,4,'Root Catalog','','','','','',0,'PRODUCTS',1,0,'3,18,4,5,16,17,19,24,10,22,23,13,8,12,26,25,15,20','','18,10,13,20','root-catalog','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(20,3,'2007-08-25 13:14:09','2008-08-07 23:58:57','1/3/20',20,2,0,4,'Household Items','','','','','',0,'PRODUCTS',0,0,'20','20','','household-items','','','household-items.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,1,1,0,''),(35,3,'2011-03-08 11:35:58','2012-06-12 06:26:42','1/3/35',21,2,0,4,'商家推荐商品','','','','','',0,'PRODUCTS',1,0,'','','','featured-products','','','featured-products.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,1,1,0,''),(36,3,'2012-06-08 06:40:54','2012-06-30 01:39:30','1/3/36',22,2,0,4,'节日庆典','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','occasion','','','occasion.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(37,3,'2012-06-08 06:50:14','2012-06-30 02:12:42','1/3/37',23,2,0,4,'送礼对象','','','','创意生日礼物,商务礼品,高档商务礼品,创意礼物,个性礼物,新奇创意小礼品,定制礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','recipients','','','recipients.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(38,3,'2012-06-08 07:02:28','2012-06-30 01:42:03','1/3/38',24,2,0,4,'创意礼品','','','','创意礼品,个性定制创意礼品,创意生日礼物,企业礼品定制,创意礼品定制网站','',0,'PRODUCTS_AND_PAGE',1,1,'','','','gifts','','','gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(39,3,'2012-06-08 07:03:42','2012-06-30 01:42:23','1/3/39',25,2,0,4,'个性定制','','','','个性礼品定制,创意礼品,创意礼物,创意礼品定制,个性定制系统,个性定制软件,创意小礼品,生日礼物,个性定制礼物,个性定制礼品,新奇创意礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diy','','','diy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(40,3,'2012-06-08 07:06:34','2012-06-26 02:40:56','1/3/40',26,2,4,4,'钟表','','watch-165_1.jpg','','个性定制手表,个性定制钟表,创意礼品钟表,礼品手表','',0,'PRODUCTS_AND_PAGE',1,1,'','','','watch','','','watch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(41,40,'2012-06-08 07:12:36','2012-06-08 07:12:36','1/3/40/41',1,3,0,4,'迪士尼定制手表','','','','','',0,'PRODUCTS',1,0,'','','','disney-watches','','','watch/disney-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(42,40,'2012-06-08 07:13:32','2012-06-08 07:13:32','1/3/40/42',2,3,0,4,'闹钟','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','alarm-clock','','','watch/alarm-clock.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(43,40,'2012-06-08 07:16:01','2012-06-08 07:16:01','1/3/40/43',3,3,0,4,'座钟','','','','','',0,'PRODUCTS',1,0,'','','','timepiece','','','watch/timepiece.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(44,40,'2012-06-08 07:17:22','2012-06-08 07:17:22','1/3/40/44',4,3,0,4,'个性定制手表','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-custom-watches','','','watch/personalized-custom-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(45,3,'2012-06-08 07:18:06','2012-06-18 06:17:32','1/3/45',27,2,4,4,'饰品','','susi.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jewelry','','','jewelry.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(46,45,'2012-06-08 07:19:06','2012-06-08 07:19:06','1/3/45/46',1,3,0,4,'项链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','necklace','','','jewelry/necklace.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(47,45,'2012-06-08 07:20:00','2012-06-08 07:20:00','1/3/45/47',2,3,0,4,'手链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bracelet','','','jewelry/bracelet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(48,45,'2012-06-08 07:20:48','2012-06-08 07:20:48','1/3/45/48',3,3,0,4,'耳环','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','earring','','','jewelry/earring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(49,45,'2012-06-08 07:21:47','2012-06-08 07:21:47','1/3/45/49',4,3,0,4,'戒指','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ring','','','jewelry/ring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(50,3,'2012-06-08 07:22:45','2012-06-18 06:17:40','1/3/50',28,2,5,4,'U盘','','u.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','usb-card','','','usb-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(51,50,'2012-06-08 07:23:46','2012-06-08 07:23:46','1/3/50/51',1,3,0,4,'卡片式U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','u-disk-card','','','usb-card/u-disk-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(52,50,'2012-06-08 07:25:28','2012-06-08 07:25:28','1/3/50/52',2,3,0,4,'木制U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wodden-usb-disk','','','usb-card/wodden-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(53,50,'2012-06-08 07:26:24','2012-06-08 07:26:24','1/3/50/53',3,3,0,4,'皮革U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','leather-usb-disk','','','usb-card/leather-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(54,50,'2012-06-08 07:28:30','2012-06-08 07:28:30','1/3/50/54',4,3,0,4,'金属U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-usb-disk','','','usb-card/metal-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(55,50,'2012-06-08 07:30:55','2012-06-08 07:30:55','1/3/50/55',5,3,0,4,'青花瓷U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','white-porcelain-usb-disk','','','usb-card/white-porcelain-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(56,3,'2012-06-08 07:34:57','2012-06-12 11:00:08','1/3/56',29,2,10,4,'数码配件','','iphone4s.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','digital-accessories','','','digital-accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(57,56,'2012-06-08 07:36:31','2012-06-08 07:36:31','1/3/56/57',1,3,0,4,'浮雕手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fudiao-phone-case','','','digital-accessories/fudiao-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(58,56,'2012-06-08 07:37:08','2012-06-08 07:37:08','1/3/56/58',2,3,0,4,'刻字手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kezi-phone-case','','','digital-accessories/kezi-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(59,56,'2012-06-08 07:37:42','2012-06-08 07:37:42','1/3/56/59',3,3,0,4,'彩印手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caihui-phone-case','','','digital-accessories/caihui-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(60,56,'2012-06-08 07:38:13','2012-06-08 07:38:13','1/3/56/60',4,3,0,4,'鼠标','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse','','','digital-accessories/mouse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(61,56,'2012-06-08 07:39:32','2012-06-08 07:39:32','1/3/56/61',5,3,0,4,'电脑内胆包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-sleeve','','','digital-accessories/computer-sleeve.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(62,56,'2012-06-08 07:40:00','2012-06-08 07:40:00','1/3/56/62',6,3,0,4,'MP3','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mp3','','','digital-accessories/mp3.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(63,56,'2012-06-08 07:41:58','2012-06-08 07:41:58','1/3/56/63',7,3,0,4,'CD包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd-bag','','','digital-accessories/cd-bag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(64,56,'2012-06-08 07:42:25','2012-06-08 07:42:25','1/3/56/64',8,3,0,4,'CD','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd','','','digital-accessories/cd.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(65,56,'2012-06-08 07:42:56','2012-06-08 07:42:56','1/3/56/65',9,3,0,4,'平板电脑','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','tablet-pc','','','digital-accessories/tablet-pc.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(66,56,'2012-06-08 07:44:42','2012-06-08 07:44:42','1/3/56/66',10,3,0,4,'定制iPhone4壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-iphone4-case','','','digital-accessories/customize-iphone4-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(67,3,'2012-06-08 07:47:35','2012-06-18 06:17:48','1/3/67',30,2,4,4,'杯子','','cup_2.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cups','','','cups.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(68,67,'2012-06-08 07:48:13','2012-06-08 07:48:13','1/3/67/68',1,3,0,4,'马克杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mug','','','cups/mug.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(69,67,'2012-06-08 07:50:35','2012-06-08 07:50:35','1/3/67/69',2,3,0,4,'骨瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bone-cup','','','cups/bone-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(70,67,'2012-06-08 07:51:31','2012-06-08 07:51:31','1/3/67/70',3,3,0,4,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','cups/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(71,67,'2012-06-08 07:53:16','2012-06-08 07:53:16','1/3/67/71',4,3,0,4,'变色杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','color-cup','','','cups/color-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(72,3,'2012-06-08 07:53:59','2012-06-18 06:17:58','1/3/72',31,2,5,4,'水晶','','shuiji-2_1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal','','','crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(73,72,'2012-06-08 07:54:45','2012-06-08 07:54:45','1/3/72/73',1,3,0,4,'彩印水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caiyi-crystal','','','crystal/caiyi-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(74,72,'2012-06-08 07:55:24','2012-06-08 07:55:24','1/3/72/74',2,3,0,4,'雕刻水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diaoke-crystal','','','crystal/diaoke-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(75,72,'2012-06-08 07:56:17','2012-06-08 07:56:17','1/3/72/75',3,3,0,4,'水晶名片座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-card-holder','','','crystal/crystal-card-holder.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(76,72,'2012-06-08 07:57:18','2012-06-08 07:57:18','1/3/72/76',4,3,0,4,'内雕水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','laser-crystal','','','crystal/laser-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(77,72,'2012-06-08 07:57:50','2012-06-08 07:58:10','1/3/72/77',5,3,0,4,'水晶奖杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-trophy','','','crystal/crystal-trophy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(78,3,'2012-06-08 07:58:50','2012-06-18 06:18:07','1/3/78',32,2,11,4,'办公用品与文具','','bangong-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','office-supplies','','','office-supplies.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(79,78,'2012-06-08 08:02:49','2012-06-08 08:02:49','1/3/78/79',1,3,0,4,'宝珠笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','roller-pen','','','office-supplies/roller-pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(80,78,'2012-06-08 08:04:11','2012-06-08 08:04:11','1/3/78/80',2,3,0,4,'名片盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cardcase','','','office-supplies/cardcase.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(81,78,'2012-06-08 08:05:08','2012-06-08 08:05:08','1/3/78/81',3,3,0,4,'记事本','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','notepad','','','office-supplies/notepad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(82,78,'2012-06-08 08:07:56','2012-06-08 08:07:56','1/3/78/82',4,3,0,4,'书签','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bookmark','','','office-supplies/bookmark.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(83,78,'2012-06-08 08:08:36','2012-06-08 08:08:36','1/3/78/83',5,3,0,4,'鼠标垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse-mat','','','office-supplies/mouse-mat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(84,78,'2012-06-08 08:09:18','2012-06-08 08:09:18','1/3/78/84',6,3,0,4,'放大镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magnifier','','','office-supplies/magnifier.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(85,78,'2012-06-08 08:10:11','2012-06-08 08:10:11','1/3/78/85',7,3,0,4,'名片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-card','','','office-supplies/business-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(86,78,'2012-06-08 08:10:58','2012-06-08 08:10:58','1/3/78/86',8,3,0,4,'文具盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','writing-case','','','office-supplies/writing-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(87,78,'2012-06-08 08:11:28','2012-06-08 08:11:28','1/3/78/87',9,3,0,4,'直尺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ruler','','','office-supplies/ruler.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(88,78,'2012-06-08 08:15:53','2012-06-08 08:16:01','1/3/78/88',10,3,0,4,'笔筒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','brush-pot','','','office-supplies/brush-pot.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(89,78,'2012-06-08 08:16:32','2012-06-08 08:16:32','1/3/78/89',11,3,0,4,'铱金钢笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pen','','','office-supplies/pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(90,3,'2012-06-08 08:18:11','2012-06-18 06:18:15','1/3/90',33,2,5,4,'商务礼品','','sawu-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-gifts','','','business-gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(91,90,'2012-06-08 08:18:50','2012-06-08 08:18:50','1/3/90/91',1,3,0,4,'奖牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','medal','','','business-gifts/medal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(92,90,'2012-06-08 08:19:34','2012-06-08 08:19:34','1/3/90/92',2,3,0,4,'香水座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','perfume-bottle','','','business-gifts/perfume-bottle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(93,90,'2012-06-08 08:20:15','2012-06-08 08:20:15','1/3/90/93',3,3,0,4,'红木礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','rosewood-gift-set','','','business-gifts/rosewood-gift-set.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(94,90,'2012-06-08 08:20:48','2012-06-08 08:20:48','1/3/90/94',4,3,0,4,'其它礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','other-gift-sets','','','business-gifts/other-gift-sets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(95,90,'2012-06-08 08:21:24','2012-06-08 08:21:24','1/3/90/95',5,3,0,4,'工艺船','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','boat','','','business-gifts/boat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(96,3,'2012-06-08 08:23:16','2012-06-18 06:18:26','1/3/96',34,2,13,4,'配饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','accessories','','','accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(97,96,'2012-06-08 08:24:00','2012-06-08 08:24:00','1/3/96/97',1,3,0,4,'酒壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','flagon','','','accessories/flagon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(98,96,'2012-06-08 08:25:05','2012-06-08 08:25:05','1/3/96/98',2,3,0,4,'个性化徽章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-badges','','','accessories/personalized-badges.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(99,96,'2012-06-08 08:26:03','2012-06-08 08:26:03','1/3/96/99',3,3,0,4,'烟盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cigarette-case','','','accessories/cigarette-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(100,96,'2012-06-08 08:26:52','2012-06-08 08:26:52','1/3/96/100',4,3,0,4,'梳子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','comb','','','accessories/comb.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(101,96,'2012-06-08 08:27:30','2012-06-08 08:27:30','1/3/96/101',5,3,0,4,'卡包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-package','','','accessories/card-package.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(102,96,'2012-06-08 08:28:23','2012-06-08 08:28:23','1/3/96/102',6,3,0,4,'眼镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glasses','','','accessories/glasses.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(103,96,'2012-06-08 08:29:14','2012-06-08 08:29:14','1/3/96/103',7,3,0,4,'钥匙包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','key-cases','','','accessories/key-cases.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(104,96,'2012-06-08 08:29:58','2012-06-08 08:29:58','1/3/96/104',8,3,0,4,'ZIPPO打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','zippo-lighter','','','accessories/zippo-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(105,96,'2012-06-08 08:31:07','2012-06-08 08:31:07','1/3/96/105',9,3,0,4,'青花瓷打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','qinghua-lighter','','','accessories/qinghua-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(106,96,'2012-06-08 08:31:49','2012-06-08 08:31:49','1/3/96/106',10,3,0,4,'皮夹','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wallet','','','accessories/wallet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(107,96,'2012-06-08 08:32:33','2012-06-08 08:32:33','1/3/96/107',11,3,0,4,'化妆镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','vanity-mirron','','','accessories/vanity-mirron.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(108,96,'2012-06-08 08:34:53','2012-06-08 08:34:53','1/3/96/108',12,3,0,4,'钱包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','purse','','','accessories/purse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(109,96,'2012-06-08 08:35:32','2012-06-08 08:35:32','1/3/96/109',13,3,0,4,'音乐盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','music-box','','','accessories/music-box.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(110,3,'2012-06-08 08:36:18','2012-06-18 06:18:34','1/3/110',35,2,6,4,'相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-frame','','','photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(111,110,'2012-06-08 08:36:55','2012-06-08 08:36:55','1/3/110/111',1,3,0,4,'木制相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wooden-photo-frame','','','photo-frame/wooden-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(112,110,'2012-06-08 08:37:38','2012-06-08 08:37:38','1/3/110/112',2,3,0,4,'金属相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-photo-frame','','','photo-frame/metal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(113,110,'2012-06-08 08:38:04','2012-06-08 08:38:25','1/3/110/113',3,3,0,4,'水晶相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-photo-frame','','','photo-frame/crystal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(114,110,'2012-06-08 08:39:21','2012-06-08 08:39:21','1/3/110/114',4,3,0,4,'皮质相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cortex-photo-frame','','','photo-frame/cortex-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(115,110,'2012-06-08 08:40:06','2012-06-08 08:40:06','1/3/110/115',5,3,0,4,'相 册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','photo-frame/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(116,110,'2012-06-08 08:40:49','2012-06-08 08:40:49','1/3/110/116',6,3,0,4,'亚克力相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','acrylic-photo-frame','','','photo-frame/acrylic-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(117,3,'2012-06-08 08:55:19','2012-06-18 06:18:43','1/3/117',36,2,29,4,'家居装饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','home-decoration','','','home-decoration.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(118,117,'2012-06-08 09:00:28','2012-06-08 09:00:28','1/3/117/118',1,3,0,4,'玻璃杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass','','','home-decoration/glass.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(119,117,'2012-06-08 09:01:24','2012-06-08 09:01:24','1/3/117/119',2,3,0,4,'彩印抱枕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printing-pillow','','','home-decoration/printing-pillow.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(120,117,'2012-06-08 09:01:57','2012-06-08 09:01:57','1/3/117/120',3,3,0,4,'餐垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','placemat','','','home-decoration/placemat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(121,117,'2012-06-08 09:02:29','2012-06-08 09:17:48','1/3/117/121',4,3,0,4,'杯垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cup-pad','','','home-decoration/cup-pad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(122,117,'2012-06-08 09:03:09','2012-06-08 09:18:12','1/3/117/122',5,3,0,4,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','home-decoration/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(123,117,'2012-06-08 09:14:11','2012-06-08 09:14:11','1/3/117/123',6,3,0,4,'隔热罩','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','shrouds','two_columns_left','','home-decoration/shrouds.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(124,117,'2012-06-08 09:15:06','2012-06-08 09:15:06','1/3/117/124',7,3,0,4,'字牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','plates','','','home-decoration/plates.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(125,117,'2012-06-08 09:15:45','2012-06-08 09:15:45','1/3/117/125',8,3,0,4,'气球','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ballon','','','home-decoration/ballon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(126,117,'2012-06-08 09:16:23','2012-06-08 09:16:23','1/3/117/126',9,3,0,4,'冰箱贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fridge-magnet','','','home-decoration/fridge-magnet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(127,117,'2012-06-08 09:17:32','2012-06-08 09:17:32','1/3/117/127',10,3,0,4,'烛台','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candlestick','','','home-decoration/candlestick.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(128,117,'2012-06-08 09:19:07','2012-06-08 09:19:07','1/3/117/128',11,3,0,4,'烟灰缸','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ashtray','','','home-decoration/ashtray.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(129,117,'2012-06-08 09:19:55','2012-06-08 09:19:55','1/3/117/129',12,3,0,4,'烟斗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pipe','','','home-decoration/pipe.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(130,117,'2012-06-08 09:25:56','2012-06-08 09:25:56','1/3/117/130',13,3,0,4,'碗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bowl','','','home-decoration/bowl.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(131,117,'2012-06-08 09:26:54','2012-06-08 09:26:54','1/3/117/131',14,3,0,4,'筷子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','chopsticks','','','home-decoration/chopsticks.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(132,117,'2012-06-08 09:27:34','2012-06-08 09:27:34','1/3/117/132',15,3,0,4,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','home-decoration/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(133,117,'2012-06-08 09:28:18','2012-06-08 09:28:18','1/3/117/133',16,3,0,4,'陶瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ceramic-cup','','','home-decoration/ceramic-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(134,117,'2012-06-08 09:35:54','2012-06-08 09:35:54','1/3/117/134',17,3,0,4,'定制台灯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-table-lamps','','','home-decoration/customize-table-lamps.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(135,117,'2012-06-08 09:36:21','2012-06-08 09:36:43','1/3/117/135',18,3,0,4,'储钱罐','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','piggy-bank','','','home-decoration/piggy-bank.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(136,117,'2012-06-08 09:42:29','2012-06-08 09:42:29','1/3/117/136',19,3,0,4,'墙贴/壁贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wall-stickers','','','home-decoration/wall-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(137,117,'2012-06-08 09:42:54','2012-06-08 09:43:23','1/3/117/137',20,3,0,4,'开关贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','switch-sticker','','','home-decoration/switch-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(138,117,'2012-06-08 09:43:50','2012-06-08 09:44:13','1/3/117/138',21,3,0,4,'水移画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','water-shift-painting','','','home-decoration/water-shift-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(139,117,'2012-06-08 09:44:41','2012-06-08 09:44:41','1/3/117/139',22,3,0,4,'玻璃贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass-paste','','','home-decoration/glass-paste.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(140,117,'2012-06-08 09:45:20','2012-06-08 09:45:20','1/3/117/140',23,3,0,4,'马桶贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','toilet-stickers','','','home-decoration/toilet-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(141,117,'2012-06-08 09:49:30','2012-06-08 09:49:30','1/3/117/141',24,3,0,4,'电脑贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-stickers','','','home-decoration/computer-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(142,117,'2012-06-08 09:50:14','2012-06-08 09:50:14','1/3/117/142',25,3,0,4,'海螺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','conch','','','home-decoration/conch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(143,117,'2012-06-08 09:51:08','2012-06-08 09:51:08','1/3/117/143',26,3,0,4,'招财猫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lucky-cat','','','home-decoration/lucky-cat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(144,117,'2012-06-08 09:53:14','2012-06-08 09:53:14','1/3/117/144',27,3,0,4,'风铃','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','campanula','','','home-decoration/campanula.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(145,117,'2012-06-08 09:57:39','2012-06-08 09:57:39','1/3/117/145',28,3,0,4,'毛绒公仔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hairs-toy','','','home-decoration/hairs-toy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(146,117,'2012-06-08 09:58:22','2012-06-08 09:58:22','1/3/117/146',29,3,0,4,'相片墙','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-wall','','','home-decoration/photo-wall.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(147,3,'2012-06-08 09:59:07','2012-06-18 06:18:54','1/3/147',37,2,5,4,'运动旅行','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','sports-and-travel','','','sports-and-travel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(148,147,'2012-06-08 10:02:50','2012-06-08 10:02:50','1/3/147/148',1,3,0,4,'水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kettle','','','sports-and-travel/kettle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(149,147,'2012-06-08 10:03:32','2012-06-08 10:03:32','1/3/147/149',2,3,0,4,'吊牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hangtag','','','sports-and-travel/hangtag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(150,147,'2012-06-08 10:04:17','2012-06-08 10:04:17','1/3/147/150',3,3,0,4,'行李牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','luggage-tag','','','sports-and-travel/luggage-tag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(151,147,'2012-06-08 10:04:59','2012-06-08 10:04:59','1/3/147/151',4,3,0,4,'折叠小刀','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','folding-knife','','','sports-and-travel/folding-knife.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(152,147,'2012-06-08 10:05:30','2012-06-08 10:05:30','1/3/147/152',5,3,0,4,'运动水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','e-as-ae-a','','','sports-and-travel/e-as-ae-a.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(153,3,'2012-06-08 10:06:32','2012-06-18 06:19:06','1/3/153',38,2,18,4,'印品系列','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printed-materials-series','','','printed-materials-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(154,153,'2012-06-08 10:07:37','2012-06-08 10:07:37','1/3/153/154',1,3,0,4,'拼图','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jigsaw','','','printed-materials-series/jigsaw.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(155,153,'2012-06-08 10:12:32','2012-06-08 10:12:32','1/3/153/155',2,3,0,4,'贺卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','greetings-card','','','printed-materials-series/greetings-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(156,153,'2012-06-08 10:13:19','2012-06-08 10:13:19','1/3/153/156',3,3,0,4,'请柬','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','invitation-card','','','printed-materials-series/invitation-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(157,153,'2012-06-08 10:14:07','2012-06-08 10:14:07','1/3/153/157',4,3,0,4,'海报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poster','','','printed-materials-series/poster.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(158,153,'2012-06-08 10:14:51','2012-06-08 10:14:51','1/3/153/158',5,3,0,4,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','printed-materials-series/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(159,153,'2012-06-08 10:15:30','2012-06-08 10:15:30','1/3/153/159',6,3,0,4,'日历','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','calendar','','','printed-materials-series/calendar.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(160,153,'2012-06-08 10:16:13','2012-06-08 10:16:13','1/3/153/160',7,3,0,4,'菜单','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','carte','','','printed-materials-series/carte.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(161,153,'2012-06-08 10:19:09','2012-06-08 10:19:09','1/3/153/161',8,3,0,4,'生日报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','birthday-newspaper','','','printed-materials-series/birthday-newspaper.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(162,153,'2012-06-08 10:19:51','2012-06-08 10:19:51','1/3/153/162',9,3,0,4,'扑克','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poker','','','printed-materials-series/poker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(163,153,'2012-06-08 10:21:41','2012-06-08 10:21:41','1/3/153/163',10,3,0,4,'竹简','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','inscribed-bamgoo-slips','','','printed-materials-series/inscribed-bamgoo-slips.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(164,153,'2012-06-09 01:20:48','2012-06-09 01:20:48','1/3/153/164',11,3,0,4,'个性证书/奖状','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-certificate','','','printed-materials-series/personalized-certificate.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(165,153,'2012-06-09 01:21:48','2012-06-09 01:21:48','1/3/153/165',12,3,0,4,'卡贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-sticker','','','printed-materials-series/card-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(166,153,'2012-06-09 01:22:30','2012-06-09 01:22:30','1/3/153/166',13,3,0,4,'Lomo照片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lomo-photo','','','printed-materials-series/lomo-photo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(167,153,'2012-06-09 01:23:21','2012-06-09 01:23:21','1/3/153/167',14,3,0,4,'手印泥','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hand-inkpad','','','printed-materials-series/hand-inkpad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(168,153,'2012-06-09 01:27:06','2012-06-09 01:27:06','1/3/153/168',15,3,0,4,'利是封','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','red-packets','','','printed-materials-series/red-packets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(169,153,'2012-06-09 01:27:47','2012-06-09 01:27:47','1/3/153/169',16,3,0,4,'喜糖袋/喜糖盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candy-bags','','','printed-materials-series/candy-bags.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(170,153,'2012-06-09 01:28:32','2012-06-09 01:28:32','1/3/153/170',17,3,0,4,'婚庆桌卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wedding-table-card','','','printed-materials-series/wedding-table-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(171,153,'2012-06-09 01:29:18','2012-06-09 01:29:18','1/3/153/171',18,3,0,4,'杂志','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magazine','','','printed-materials-series/magazine.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(172,3,'2012-06-09 01:30:01','2012-06-18 06:19:17','1/3/172',39,2,0,4,'个性印章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-stamp','','','personalized-stamp.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(173,3,'2012-06-09 01:30:41','2012-06-18 06:19:37','1/3/173',40,2,4,4,'服饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','apparel','','','apparel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(174,173,'2012-06-09 01:31:13','2012-06-09 01:31:13','1/3/173/174',1,3,0,4,'T恤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','t-shirt','','','apparel/t-shirt.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(175,173,'2012-06-09 01:31:45','2012-06-09 01:31:45','1/3/173/175',2,3,0,4,'帽子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hat','','','apparel/hat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(176,173,'2012-06-09 01:32:20','2012-06-09 01:32:20','1/3/173/176',3,3,0,4,'长裤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','trousers','','','apparel/trousers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(177,173,'2012-06-09 01:33:00','2012-06-09 01:33:00','1/3/173/177',4,3,0,4,'围巾','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','scarves','','','apparel/scarves.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(178,3,'2012-06-09 01:33:44','2012-06-18 06:19:46','1/3/178',41,2,8,4,'艺术类','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','art-series','','','art-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(179,178,'2012-06-09 01:34:22','2012-06-09 01:34:22','1/3/178/179',1,3,0,4,'风景油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','landscape-oil-painting','','','art-series/landscape-oil-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(180,178,'2012-06-09 01:35:13','2012-06-09 01:35:13','1/3/178/180',2,3,0,4,'人物油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','figure-painting','','','art-series/figure-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(181,178,'2012-06-09 01:36:00','2012-06-09 01:36:00','1/3/178/181',3,3,0,4,'石头画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','stone-painting','','','art-series/stone-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(182,178,'2012-06-09 01:36:50','2012-06-09 01:36:50','1/3/178/182',4,3,0,4,'瓷片画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','porcelain-painting','','','art-series/porcelain-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(183,178,'2012-06-09 01:37:31','2012-06-09 01:37:31','1/3/178/183',5,3,0,4,'木版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','woodcut','','','art-series/woodcut.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(184,178,'2012-06-09 01:38:11','2012-06-09 01:38:11','1/3/178/184',6,3,0,4,'水晶版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-engraving','','','art-series/crystal-engraving.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(185,178,'2012-06-09 01:39:07','2012-06-09 01:39:07','1/3/178/185',7,3,0,4,'冰雕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ice-art','','','art-series/ice-art.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(186,178,'2012-06-09 01:39:49','2012-06-09 01:39:49','1/3/178/186',8,3,0,4,'软陶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fimo','','','art-series/fimo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,'');
/*!40000 ALTER TABLE `catalog_category_flat_store_4` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_flat_store_5`
--

DROP TABLE IF EXISTS `catalog_category_flat_store_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_flat_store_5` (
  `entity_id` int(11) unsigned NOT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(255) NOT NULL,
  `position` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `children_count` int(11) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `meta_title` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text,
  `meta_description` text,
  `landing_page` int(10) NOT NULL DEFAULT '0',
  `display_mode` varchar(255) NOT NULL DEFAULT '',
  `is_active` int(10) NOT NULL DEFAULT '0',
  `is_anchor` int(10) NOT NULL DEFAULT '0',
  `all_children` text,
  `path_in_store` text,
  `children` text,
  `url_key` varchar(255) NOT NULL DEFAULT '',
  `page_layout` varchar(255) NOT NULL DEFAULT '',
  `custom_layout_update` text,
  `url_path` varchar(255) NOT NULL DEFAULT '',
  `custom_design` varchar(255) NOT NULL DEFAULT '',
  `custom_design_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_design_to` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `available_sort_by` text,
  `default_sort_by` varchar(255) NOT NULL DEFAULT '',
  `include_in_menu` int(10) NOT NULL DEFAULT '0',
  `custom_use_parent_settings` int(10) NOT NULL DEFAULT '0',
  `custom_apply_to_products` int(10) NOT NULL DEFAULT '0',
  `filter_price_range` int(10) NOT NULL DEFAULT '0',
  `thumbnail` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`entity_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_PATH` (`path`),
  KEY `IDX_LEVEL` (`level`),
  CONSTRAINT `FK_CATEGORY_FLAT_CATEGORY_ID_STORE_5` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATEGORY_FLAT_STORE_ID_STORE_5` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_flat_store_5`
--

LOCK TABLES `catalog_category_flat_store_5` WRITE;
/*!40000 ALTER TABLE `catalog_category_flat_store_5` DISABLE KEYS */;
INSERT INTO `catalog_category_flat_store_5` VALUES (1,0,'2007-07-20 18:46:08','2007-08-07 09:50:15','1',1,0,154,5,'','','','','','',0,'',1,0,'','','','','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(3,1,'2007-08-22 15:54:41','2012-06-22 03:58:22','1/3',3,1,153,5,'Root Catalog','','','','','',0,'PRODUCTS',1,0,'3,18,4,5,16,17,19,24,10,22,23,13,8,12,26,25,15,20','','18,10,13,20','root-catalog','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(20,3,'2007-08-25 13:14:09','2008-08-07 23:58:57','1/3/20',20,2,0,5,'Household Items','','','','','',0,'PRODUCTS',0,0,'20','20','','household-items','','','household-items.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,1,1,0,''),(35,3,'2011-03-08 11:35:58','2012-06-12 06:26:42','1/3/35',21,2,0,5,'商家推荐商品','','','','','',0,'PRODUCTS',1,0,'','','','featured-products','','','featured-products.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,1,1,0,''),(36,3,'2012-06-08 06:40:54','2012-06-30 01:39:30','1/3/36',22,2,0,5,'节日庆典','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','occasion','','','occasion.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(37,3,'2012-06-08 06:50:14','2012-06-30 02:12:42','1/3/37',23,2,0,5,'送礼对象','','','','创意生日礼物,商务礼品,高档商务礼品,创意礼物,个性礼物,新奇创意小礼品,定制礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','recipients','','','recipients.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(38,3,'2012-06-08 07:02:28','2012-06-30 01:42:03','1/3/38',24,2,0,5,'创意礼品','','','','创意礼品,个性定制创意礼品,创意生日礼物,企业礼品定制,创意礼品定制网站','',0,'PRODUCTS_AND_PAGE',1,1,'','','','gifts','','','gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(39,3,'2012-06-08 07:03:42','2012-06-30 01:42:23','1/3/39',25,2,0,5,'个性定制','','','','个性礼品定制,创意礼品,创意礼物,创意礼品定制,个性定制系统,个性定制软件,创意小礼品,生日礼物,个性定制礼物,个性定制礼品,新奇创意礼品','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diy','','','diy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',0,0,0,0,''),(40,3,'2012-06-08 07:06:34','2012-06-26 02:40:56','1/3/40',26,2,4,5,'钟表','','watch-165_1.jpg','','个性定制手表,个性定制钟表,创意礼品钟表,礼品手表','',0,'PRODUCTS_AND_PAGE',1,1,'','','','watch','','','watch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(41,40,'2012-06-08 07:12:36','2012-06-08 07:12:36','1/3/40/41',1,3,0,5,'迪士尼定制手表','','','','','',0,'PRODUCTS',1,0,'','','','disney-watches','','','watch/disney-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(42,40,'2012-06-08 07:13:32','2012-06-08 07:13:32','1/3/40/42',2,3,0,5,'闹钟','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','alarm-clock','','','watch/alarm-clock.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(43,40,'2012-06-08 07:16:01','2012-06-08 07:16:01','1/3/40/43',3,3,0,5,'座钟','','','','','',0,'PRODUCTS',1,0,'','','','timepiece','','','watch/timepiece.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(44,40,'2012-06-08 07:17:22','2012-06-08 07:17:22','1/3/40/44',4,3,0,5,'个性定制手表','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-custom-watches','','','watch/personalized-custom-watches.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(45,3,'2012-06-08 07:18:06','2012-06-18 06:17:32','1/3/45',27,2,4,5,'饰品','','susi.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jewelry','','','jewelry.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(46,45,'2012-06-08 07:19:06','2012-06-08 07:19:06','1/3/45/46',1,3,0,5,'项链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','necklace','','','jewelry/necklace.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(47,45,'2012-06-08 07:20:00','2012-06-08 07:20:00','1/3/45/47',2,3,0,5,'手链','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bracelet','','','jewelry/bracelet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(48,45,'2012-06-08 07:20:48','2012-06-08 07:20:48','1/3/45/48',3,3,0,5,'耳环','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','earring','','','jewelry/earring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(49,45,'2012-06-08 07:21:47','2012-06-08 07:21:47','1/3/45/49',4,3,0,5,'戒指','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ring','','','jewelry/ring.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(50,3,'2012-06-08 07:22:45','2012-06-18 06:17:40','1/3/50',28,2,5,5,'U盘','','u.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','usb-card','','','usb-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(51,50,'2012-06-08 07:23:46','2012-06-08 07:23:46','1/3/50/51',1,3,0,5,'卡片式U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','u-disk-card','','','usb-card/u-disk-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(52,50,'2012-06-08 07:25:28','2012-06-08 07:25:28','1/3/50/52',2,3,0,5,'木制U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wodden-usb-disk','','','usb-card/wodden-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(53,50,'2012-06-08 07:26:24','2012-06-08 07:26:24','1/3/50/53',3,3,0,5,'皮革U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','leather-usb-disk','','','usb-card/leather-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(54,50,'2012-06-08 07:28:30','2012-06-08 07:28:30','1/3/50/54',4,3,0,5,'金属U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-usb-disk','','','usb-card/metal-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(55,50,'2012-06-08 07:30:55','2012-06-08 07:30:55','1/3/50/55',5,3,0,5,'青花瓷U盘','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','white-porcelain-usb-disk','','','usb-card/white-porcelain-usb-disk.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(56,3,'2012-06-08 07:34:57','2012-06-12 11:00:08','1/3/56',29,2,10,5,'数码配件','','iphone4s.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','digital-accessories','','','digital-accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(57,56,'2012-06-08 07:36:31','2012-06-08 07:36:31','1/3/56/57',1,3,0,5,'浮雕手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fudiao-phone-case','','','digital-accessories/fudiao-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(58,56,'2012-06-08 07:37:08','2012-06-08 07:37:08','1/3/56/58',2,3,0,5,'刻字手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kezi-phone-case','','','digital-accessories/kezi-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(59,56,'2012-06-08 07:37:42','2012-06-08 07:37:42','1/3/56/59',3,3,0,5,'彩印手机外壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caihui-phone-case','','','digital-accessories/caihui-phone-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(60,56,'2012-06-08 07:38:13','2012-06-08 07:38:13','1/3/56/60',4,3,0,5,'鼠标','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse','','','digital-accessories/mouse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(61,56,'2012-06-08 07:39:32','2012-06-08 07:39:32','1/3/56/61',5,3,0,5,'电脑内胆包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-sleeve','','','digital-accessories/computer-sleeve.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(62,56,'2012-06-08 07:40:00','2012-06-08 07:40:00','1/3/56/62',6,3,0,5,'MP3','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mp3','','','digital-accessories/mp3.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(63,56,'2012-06-08 07:41:58','2012-06-08 07:41:58','1/3/56/63',7,3,0,5,'CD包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd-bag','','','digital-accessories/cd-bag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(64,56,'2012-06-08 07:42:25','2012-06-08 07:42:25','1/3/56/64',8,3,0,5,'CD','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cd','','','digital-accessories/cd.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(65,56,'2012-06-08 07:42:56','2012-06-08 07:42:56','1/3/56/65',9,3,0,5,'平板电脑','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','tablet-pc','','','digital-accessories/tablet-pc.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(66,56,'2012-06-08 07:44:42','2012-06-08 07:44:42','1/3/56/66',10,3,0,5,'定制iPhone4壳','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-iphone4-case','','','digital-accessories/customize-iphone4-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(67,3,'2012-06-08 07:47:35','2012-06-18 06:17:48','1/3/67',30,2,4,5,'杯子','','cup_2.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cups','','','cups.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(68,67,'2012-06-08 07:48:13','2012-06-08 07:48:13','1/3/67/68',1,3,0,5,'马克杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mug','','','cups/mug.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(69,67,'2012-06-08 07:50:35','2012-06-08 07:50:35','1/3/67/69',2,3,0,5,'骨瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bone-cup','','','cups/bone-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(70,67,'2012-06-08 07:51:31','2012-06-08 07:51:31','1/3/67/70',3,3,0,5,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','cups/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(71,67,'2012-06-08 07:53:16','2012-06-08 07:53:16','1/3/67/71',4,3,0,5,'变色杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','color-cup','','','cups/color-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(72,3,'2012-06-08 07:53:59','2012-06-18 06:17:58','1/3/72',31,2,5,5,'水晶','','shuiji-2_1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal','','','crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(73,72,'2012-06-08 07:54:45','2012-06-08 07:54:45','1/3/72/73',1,3,0,5,'彩印水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','caiyi-crystal','','','crystal/caiyi-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(74,72,'2012-06-08 07:55:24','2012-06-08 07:55:24','1/3/72/74',2,3,0,5,'雕刻水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','diaoke-crystal','','','crystal/diaoke-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(75,72,'2012-06-08 07:56:17','2012-06-08 07:56:17','1/3/72/75',3,3,0,5,'水晶名片座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-card-holder','','','crystal/crystal-card-holder.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(76,72,'2012-06-08 07:57:18','2012-06-08 07:57:18','1/3/72/76',4,3,0,5,'内雕水晶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','laser-crystal','','','crystal/laser-crystal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(77,72,'2012-06-08 07:57:50','2012-06-08 07:58:10','1/3/72/77',5,3,0,5,'水晶奖杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-trophy','','','crystal/crystal-trophy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(78,3,'2012-06-08 07:58:50','2012-06-18 06:18:07','1/3/78',32,2,11,5,'办公用品与文具','','bangong-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','office-supplies','','','office-supplies.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(79,78,'2012-06-08 08:02:49','2012-06-08 08:02:49','1/3/78/79',1,3,0,5,'宝珠笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','roller-pen','','','office-supplies/roller-pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(80,78,'2012-06-08 08:04:11','2012-06-08 08:04:11','1/3/78/80',2,3,0,5,'名片盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cardcase','','','office-supplies/cardcase.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(81,78,'2012-06-08 08:05:08','2012-06-08 08:05:08','1/3/78/81',3,3,0,5,'记事本','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','notepad','','','office-supplies/notepad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(82,78,'2012-06-08 08:07:56','2012-06-08 08:07:56','1/3/78/82',4,3,0,5,'书签','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bookmark','','','office-supplies/bookmark.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(83,78,'2012-06-08 08:08:36','2012-06-08 08:08:36','1/3/78/83',5,3,0,5,'鼠标垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','mouse-mat','','','office-supplies/mouse-mat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(84,78,'2012-06-08 08:09:18','2012-06-08 08:09:18','1/3/78/84',6,3,0,5,'放大镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magnifier','','','office-supplies/magnifier.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(85,78,'2012-06-08 08:10:11','2012-06-08 08:10:11','1/3/78/85',7,3,0,5,'名片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-card','','','office-supplies/business-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(86,78,'2012-06-08 08:10:58','2012-06-08 08:10:58','1/3/78/86',8,3,0,5,'文具盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','writing-case','','','office-supplies/writing-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(87,78,'2012-06-08 08:11:28','2012-06-08 08:11:28','1/3/78/87',9,3,0,5,'直尺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ruler','','','office-supplies/ruler.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(88,78,'2012-06-08 08:15:53','2012-06-08 08:16:01','1/3/78/88',10,3,0,5,'笔筒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','brush-pot','','','office-supplies/brush-pot.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(89,78,'2012-06-08 08:16:32','2012-06-08 08:16:32','1/3/78/89',11,3,0,5,'铱金钢笔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pen','','','office-supplies/pen.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(90,3,'2012-06-08 08:18:11','2012-06-18 06:18:15','1/3/90',33,2,5,5,'商务礼品','','sawu-1.jpg','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','business-gifts','','','business-gifts.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(91,90,'2012-06-08 08:18:50','2012-06-08 08:18:50','1/3/90/91',1,3,0,5,'奖牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','medal','','','business-gifts/medal.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(92,90,'2012-06-08 08:19:34','2012-06-08 08:19:34','1/3/90/92',2,3,0,5,'香水座','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','perfume-bottle','','','business-gifts/perfume-bottle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(93,90,'2012-06-08 08:20:15','2012-06-08 08:20:15','1/3/90/93',3,3,0,5,'红木礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','rosewood-gift-set','','','business-gifts/rosewood-gift-set.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(94,90,'2012-06-08 08:20:48','2012-06-08 08:20:48','1/3/90/94',4,3,0,5,'其它礼品套装','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','other-gift-sets','','','business-gifts/other-gift-sets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(95,90,'2012-06-08 08:21:24','2012-06-08 08:21:24','1/3/90/95',5,3,0,5,'工艺船','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','boat','','','business-gifts/boat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(96,3,'2012-06-08 08:23:16','2012-06-18 06:18:26','1/3/96',34,2,13,5,'配饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','accessories','','','accessories.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(97,96,'2012-06-08 08:24:00','2012-06-08 08:24:00','1/3/96/97',1,3,0,5,'酒壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','flagon','','','accessories/flagon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(98,96,'2012-06-08 08:25:05','2012-06-08 08:25:05','1/3/96/98',2,3,0,5,'个性化徽章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-badges','','','accessories/personalized-badges.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(99,96,'2012-06-08 08:26:03','2012-06-08 08:26:03','1/3/96/99',3,3,0,5,'烟盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cigarette-case','','','accessories/cigarette-case.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(100,96,'2012-06-08 08:26:52','2012-06-08 08:26:52','1/3/96/100',4,3,0,5,'梳子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','comb','','','accessories/comb.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(101,96,'2012-06-08 08:27:30','2012-06-08 08:27:30','1/3/96/101',5,3,0,5,'卡包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-package','','','accessories/card-package.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(102,96,'2012-06-08 08:28:23','2012-06-08 08:28:23','1/3/96/102',6,3,0,5,'眼镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glasses','','','accessories/glasses.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(103,96,'2012-06-08 08:29:14','2012-06-08 08:29:14','1/3/96/103',7,3,0,5,'钥匙包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','key-cases','','','accessories/key-cases.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(104,96,'2012-06-08 08:29:58','2012-06-08 08:29:58','1/3/96/104',8,3,0,5,'ZIPPO打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','zippo-lighter','','','accessories/zippo-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(105,96,'2012-06-08 08:31:07','2012-06-08 08:31:07','1/3/96/105',9,3,0,5,'青花瓷打火机','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','qinghua-lighter','','','accessories/qinghua-lighter.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(106,96,'2012-06-08 08:31:49','2012-06-08 08:31:49','1/3/96/106',10,3,0,5,'皮夹','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wallet','','','accessories/wallet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(107,96,'2012-06-08 08:32:33','2012-06-08 08:32:33','1/3/96/107',11,3,0,5,'化妆镜','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','vanity-mirron','','','accessories/vanity-mirron.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(108,96,'2012-06-08 08:34:53','2012-06-08 08:34:53','1/3/96/108',12,3,0,5,'钱包','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','purse','','','accessories/purse.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(109,96,'2012-06-08 08:35:32','2012-06-08 08:35:32','1/3/96/109',13,3,0,5,'音乐盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','music-box','','','accessories/music-box.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(110,3,'2012-06-08 08:36:18','2012-06-18 06:18:34','1/3/110',35,2,6,5,'相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-frame','','','photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(111,110,'2012-06-08 08:36:55','2012-06-08 08:36:55','1/3/110/111',1,3,0,5,'木制相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wooden-photo-frame','','','photo-frame/wooden-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(112,110,'2012-06-08 08:37:38','2012-06-08 08:37:38','1/3/110/112',2,3,0,5,'金属相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','metal-photo-frame','','','photo-frame/metal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(113,110,'2012-06-08 08:38:04','2012-06-08 08:38:25','1/3/110/113',3,3,0,5,'水晶相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-photo-frame','','','photo-frame/crystal-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(114,110,'2012-06-08 08:39:21','2012-06-08 08:39:21','1/3/110/114',4,3,0,5,'皮质相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cortex-photo-frame','','','photo-frame/cortex-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(115,110,'2012-06-08 08:40:06','2012-06-08 08:40:06','1/3/110/115',5,3,0,5,'相 册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','photo-frame/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(116,110,'2012-06-08 08:40:49','2012-06-08 08:40:49','1/3/110/116',6,3,0,5,'亚克力相框','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','acrylic-photo-frame','','','photo-frame/acrylic-photo-frame.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(117,3,'2012-06-08 08:55:19','2012-06-18 06:18:43','1/3/117',36,2,29,5,'家居装饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','home-decoration','','','home-decoration.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(118,117,'2012-06-08 09:00:28','2012-06-08 09:00:28','1/3/117/118',1,3,0,5,'玻璃杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass','','','home-decoration/glass.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(119,117,'2012-06-08 09:01:24','2012-06-08 09:01:24','1/3/117/119',2,3,0,5,'彩印抱枕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printing-pillow','','','home-decoration/printing-pillow.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(120,117,'2012-06-08 09:01:57','2012-06-08 09:01:57','1/3/117/120',3,3,0,5,'餐垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','placemat','','','home-decoration/placemat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(121,117,'2012-06-08 09:02:29','2012-06-08 09:17:48','1/3/117/121',4,3,0,5,'杯垫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','cup-pad','','','home-decoration/cup-pad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(122,117,'2012-06-08 09:03:09','2012-06-08 09:18:12','1/3/117/122',5,3,0,5,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','home-decoration/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(123,117,'2012-06-08 09:14:11','2012-06-08 09:14:11','1/3/117/123',6,3,0,5,'隔热罩','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','shrouds','two_columns_left','','home-decoration/shrouds.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(124,117,'2012-06-08 09:15:06','2012-06-08 09:15:06','1/3/117/124',7,3,0,5,'字牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','plates','','','home-decoration/plates.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(125,117,'2012-06-08 09:15:45','2012-06-08 09:15:45','1/3/117/125',8,3,0,5,'气球','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ballon','','','home-decoration/ballon.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(126,117,'2012-06-08 09:16:23','2012-06-08 09:16:23','1/3/117/126',9,3,0,5,'冰箱贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fridge-magnet','','','home-decoration/fridge-magnet.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(127,117,'2012-06-08 09:17:32','2012-06-08 09:17:32','1/3/117/127',10,3,0,5,'烛台','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candlestick','','','home-decoration/candlestick.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(128,117,'2012-06-08 09:19:07','2012-06-08 09:19:07','1/3/117/128',11,3,0,5,'烟灰缸','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ashtray','','','home-decoration/ashtray.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(129,117,'2012-06-08 09:19:55','2012-06-08 09:19:55','1/3/117/129',12,3,0,5,'烟斗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','pipe','','','home-decoration/pipe.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(130,117,'2012-06-08 09:25:56','2012-06-08 09:25:56','1/3/117/130',13,3,0,5,'碗','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','bowl','','','home-decoration/bowl.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(131,117,'2012-06-08 09:26:54','2012-06-08 09:26:54','1/3/117/131',14,3,0,5,'筷子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','chopsticks','','','home-decoration/chopsticks.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(132,117,'2012-06-08 09:27:34','2012-06-08 09:27:34','1/3/117/132',15,3,0,5,'咖啡杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','coffee-cup','','','home-decoration/coffee-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(133,117,'2012-06-08 09:28:18','2012-06-08 09:28:18','1/3/117/133',16,3,0,5,'陶瓷杯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ceramic-cup','','','home-decoration/ceramic-cup.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(134,117,'2012-06-08 09:35:54','2012-06-08 09:35:54','1/3/117/134',17,3,0,5,'定制台灯','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','customize-table-lamps','','','home-decoration/customize-table-lamps.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(135,117,'2012-06-08 09:36:21','2012-06-08 09:36:43','1/3/117/135',18,3,0,5,'储钱罐','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','piggy-bank','','','home-decoration/piggy-bank.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(136,117,'2012-06-08 09:42:29','2012-06-08 09:42:29','1/3/117/136',19,3,0,5,'墙贴/壁贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wall-stickers','','','home-decoration/wall-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(137,117,'2012-06-08 09:42:54','2012-06-08 09:43:23','1/3/117/137',20,3,0,5,'开关贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','switch-sticker','','','home-decoration/switch-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(138,117,'2012-06-08 09:43:50','2012-06-08 09:44:13','1/3/117/138',21,3,0,5,'水移画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','water-shift-painting','','','home-decoration/water-shift-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(139,117,'2012-06-08 09:44:41','2012-06-08 09:44:41','1/3/117/139',22,3,0,5,'玻璃贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','glass-paste','','','home-decoration/glass-paste.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(140,117,'2012-06-08 09:45:20','2012-06-08 09:45:20','1/3/117/140',23,3,0,5,'马桶贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','toilet-stickers','','','home-decoration/toilet-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(141,117,'2012-06-08 09:49:30','2012-06-08 09:49:30','1/3/117/141',24,3,0,5,'电脑贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','computer-stickers','','','home-decoration/computer-stickers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(142,117,'2012-06-08 09:50:14','2012-06-08 09:50:14','1/3/117/142',25,3,0,5,'海螺','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','conch','','','home-decoration/conch.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(143,117,'2012-06-08 09:51:08','2012-06-08 09:51:08','1/3/117/143',26,3,0,5,'招财猫','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lucky-cat','','','home-decoration/lucky-cat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(144,117,'2012-06-08 09:53:14','2012-06-08 09:53:14','1/3/117/144',27,3,0,5,'风铃','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','campanula','','','home-decoration/campanula.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(145,117,'2012-06-08 09:57:39','2012-06-08 09:57:39','1/3/117/145',28,3,0,5,'毛绒公仔','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hairs-toy','','','home-decoration/hairs-toy.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(146,117,'2012-06-08 09:58:22','2012-06-08 09:58:22','1/3/117/146',29,3,0,5,'相片墙','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','photo-wall','','','home-decoration/photo-wall.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(147,3,'2012-06-08 09:59:07','2012-06-18 06:18:54','1/3/147',37,2,5,5,'运动旅行','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','sports-and-travel','','','sports-and-travel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(148,147,'2012-06-08 10:02:50','2012-06-08 10:02:50','1/3/147/148',1,3,0,5,'水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','kettle','','','sports-and-travel/kettle.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(149,147,'2012-06-08 10:03:32','2012-06-08 10:03:32','1/3/147/149',2,3,0,5,'吊牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hangtag','','','sports-and-travel/hangtag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(150,147,'2012-06-08 10:04:17','2012-06-08 10:04:17','1/3/147/150',3,3,0,5,'行李牌','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','luggage-tag','','','sports-and-travel/luggage-tag.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(151,147,'2012-06-08 10:04:59','2012-06-08 10:04:59','1/3/147/151',4,3,0,5,'折叠小刀','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','folding-knife','','','sports-and-travel/folding-knife.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(152,147,'2012-06-08 10:05:30','2012-06-08 10:05:30','1/3/147/152',5,3,0,5,'运动水壶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','e-as-ae-a','','','sports-and-travel/e-as-ae-a.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(153,3,'2012-06-08 10:06:32','2012-06-18 06:19:06','1/3/153',38,2,18,5,'印品系列','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','printed-materials-series','','','printed-materials-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(154,153,'2012-06-08 10:07:37','2012-06-08 10:07:37','1/3/153/154',1,3,0,5,'拼图','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','jigsaw','','','printed-materials-series/jigsaw.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(155,153,'2012-06-08 10:12:32','2012-06-08 10:12:32','1/3/153/155',2,3,0,5,'贺卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','greetings-card','','','printed-materials-series/greetings-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(156,153,'2012-06-08 10:13:19','2012-06-08 10:13:19','1/3/153/156',3,3,0,5,'请柬','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','invitation-card','','','printed-materials-series/invitation-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(157,153,'2012-06-08 10:14:07','2012-06-08 10:14:07','1/3/153/157',4,3,0,5,'海报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poster','','','printed-materials-series/poster.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(158,153,'2012-06-08 10:14:51','2012-06-08 10:14:51','1/3/153/158',5,3,0,5,'相册','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','album','','','printed-materials-series/album.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(159,153,'2012-06-08 10:15:30','2012-06-08 10:15:30','1/3/153/159',6,3,0,5,'日历','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','calendar','','','printed-materials-series/calendar.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(160,153,'2012-06-08 10:16:13','2012-06-08 10:16:13','1/3/153/160',7,3,0,5,'菜单','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','carte','','','printed-materials-series/carte.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(161,153,'2012-06-08 10:19:09','2012-06-08 10:19:09','1/3/153/161',8,3,0,5,'生日报','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','birthday-newspaper','','','printed-materials-series/birthday-newspaper.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(162,153,'2012-06-08 10:19:51','2012-06-08 10:19:51','1/3/153/162',9,3,0,5,'扑克','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','poker','','','printed-materials-series/poker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(163,153,'2012-06-08 10:21:41','2012-06-08 10:21:41','1/3/153/163',10,3,0,5,'竹简','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','inscribed-bamgoo-slips','','','printed-materials-series/inscribed-bamgoo-slips.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(164,153,'2012-06-09 01:20:48','2012-06-09 01:20:48','1/3/153/164',11,3,0,5,'个性证书/奖状','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-certificate','','','printed-materials-series/personalized-certificate.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(165,153,'2012-06-09 01:21:48','2012-06-09 01:21:48','1/3/153/165',12,3,0,5,'卡贴','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','card-sticker','','','printed-materials-series/card-sticker.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(166,153,'2012-06-09 01:22:30','2012-06-09 01:22:30','1/3/153/166',13,3,0,5,'Lomo照片','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','lomo-photo','','','printed-materials-series/lomo-photo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(167,153,'2012-06-09 01:23:21','2012-06-09 01:23:21','1/3/153/167',14,3,0,5,'手印泥','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hand-inkpad','','','printed-materials-series/hand-inkpad.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(168,153,'2012-06-09 01:27:06','2012-06-09 01:27:06','1/3/153/168',15,3,0,5,'利是封','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','red-packets','','','printed-materials-series/red-packets.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(169,153,'2012-06-09 01:27:47','2012-06-09 01:27:47','1/3/153/169',16,3,0,5,'喜糖袋/喜糖盒','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','candy-bags','','','printed-materials-series/candy-bags.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(170,153,'2012-06-09 01:28:32','2012-06-09 01:28:32','1/3/153/170',17,3,0,5,'婚庆桌卡','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','wedding-table-card','','','printed-materials-series/wedding-table-card.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(171,153,'2012-06-09 01:29:18','2012-06-09 01:29:18','1/3/153/171',18,3,0,5,'杂志','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','magazine','','','printed-materials-series/magazine.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(172,3,'2012-06-09 01:30:01','2012-06-18 06:19:17','1/3/172',39,2,0,5,'个性印章','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','personalized-stamp','','','personalized-stamp.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(173,3,'2012-06-09 01:30:41','2012-06-18 06:19:37','1/3/173',40,2,4,5,'服饰','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','apparel','','','apparel.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(174,173,'2012-06-09 01:31:13','2012-06-09 01:31:13','1/3/173/174',1,3,0,5,'T恤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','t-shirt','','','apparel/t-shirt.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(175,173,'2012-06-09 01:31:45','2012-06-09 01:31:45','1/3/173/175',2,3,0,5,'帽子','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','hat','','','apparel/hat.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(176,173,'2012-06-09 01:32:20','2012-06-09 01:32:20','1/3/173/176',3,3,0,5,'长裤','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','trousers','','','apparel/trousers.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(177,173,'2012-06-09 01:33:00','2012-06-09 01:33:00','1/3/173/177',4,3,0,5,'围巾','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','scarves','','','apparel/scarves.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(178,3,'2012-06-09 01:33:44','2012-06-18 06:19:46','1/3/178',41,2,8,5,'艺术类','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','art-series','','','art-series.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(179,178,'2012-06-09 01:34:22','2012-06-09 01:34:22','1/3/178/179',1,3,0,5,'风景油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','landscape-oil-painting','','','art-series/landscape-oil-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(180,178,'2012-06-09 01:35:13','2012-06-09 01:35:13','1/3/178/180',2,3,0,5,'人物油画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','figure-painting','','','art-series/figure-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(181,178,'2012-06-09 01:36:00','2012-06-09 01:36:00','1/3/178/181',3,3,0,5,'石头画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','stone-painting','','','art-series/stone-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(182,178,'2012-06-09 01:36:50','2012-06-09 01:36:50','1/3/178/182',4,3,0,5,'瓷片画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','porcelain-painting','','','art-series/porcelain-painting.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(183,178,'2012-06-09 01:37:31','2012-06-09 01:37:31','1/3/178/183',5,3,0,5,'木版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','woodcut','','','art-series/woodcut.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(184,178,'2012-06-09 01:38:11','2012-06-09 01:38:11','1/3/178/184',6,3,0,5,'水晶版画','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','crystal-engraving','','','art-series/crystal-engraving.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(185,178,'2012-06-09 01:39:07','2012-06-09 01:39:07','1/3/178/185',7,3,0,5,'冰雕','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','ice-art','','','art-series/ice-art.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,''),(186,178,'2012-06-09 01:39:49','2012-06-09 01:39:49','1/3/178/186',8,3,0,5,'软陶','','','','','',0,'PRODUCTS_AND_PAGE',1,1,'','','','fimo','','','art-series/fimo.html','','0000-00-00 00:00:00','0000-00-00 00:00:00','','',1,0,0,0,'');
/*!40000 ALTER TABLE `catalog_category_flat_store_5` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `UNQ_CATEGORY_PRODUCT` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY` (`category_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT` (`product_id`),
  CONSTRAINT `CATALOG_CATEGORY_PRODUCT_CATEGORY` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_PRODUCT_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES (3,188,0),(3,189,0),(3,190,0),(3,191,0),(3,192,0),(3,193,0),(3,194,0),(3,195,0),(3,196,0),(3,197,0),(3,198,0),(3,199,0),(3,200,0),(3,201,0),(3,202,0),(3,203,0),(3,204,0),(3,205,0),(3,206,0),(3,208,0),(3,209,0),(3,210,0),(35,189,1),(36,188,0),(36,189,0),(36,190,0),(36,191,0),(36,192,0),(36,193,0),(36,194,0),(36,195,0),(36,196,0),(36,197,0),(36,198,0),(36,199,0),(36,200,0),(36,201,0),(36,202,0),(36,203,0),(36,204,0),(36,205,0),(36,206,0),(36,208,0),(36,209,0),(36,210,0),(37,188,0),(37,189,0),(37,190,0),(37,191,0),(37,192,0),(37,193,0),(37,194,0),(37,195,0),(37,196,0),(37,197,0),(37,198,0),(37,199,0),(37,200,0),(37,201,0),(37,202,0),(37,203,0),(37,204,0),(37,205,0),(37,206,0),(37,208,0),(37,209,0),(37,210,0),(38,189,1),(38,190,1),(39,188,1),(39,189,1),(39,190,1),(39,191,1),(39,192,1),(39,193,1),(39,194,1),(39,195,1),(39,196,1),(39,197,1),(39,198,1),(39,199,1),(39,200,1),(39,201,1),(39,202,1),(39,203,1),(39,204,1),(39,205,1),(39,206,1),(39,208,1),(39,209,1),(39,210,1),(40,188,1),(40,189,1),(40,190,1),(40,191,1),(40,192,1),(40,193,1),(40,194,1),(40,195,1),(40,196,1),(40,197,1),(40,198,1),(40,199,1),(40,200,1),(40,201,1),(40,202,1),(40,203,1),(40,204,1),(40,205,1),(40,206,1),(40,208,1),(40,209,1),(40,210,1),(44,188,1),(44,189,1),(44,190,1),(44,191,1),(44,192,1),(44,193,1),(44,194,1),(44,195,1),(44,196,1),(44,197,1),(44,198,1),(44,199,1),(44,200,1),(44,201,1),(44,202,1),(44,203,1),(44,204,1),(44,205,1),(44,206,1),(44,208,1),(44,209,1),(44,210,1);
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(10) unsigned DEFAULT NULL,
  `is_parent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `visibility` tinyint(3) unsigned NOT NULL,
  UNIQUE KEY `UNQ_CATEGORY_PRODUCT` (`category_id`,`product_id`,`store_id`),
  KEY `FK_CATALOG_CATEGORY_PRODUCT_INDEX_PRODUCT_ENTITY` (`product_id`),
  KEY `FK_CATALOG_CATEGORY_PRODUCT_INDEX_CATEGORY_ENTITY` (`category_id`),
  KEY `IDX_JOIN` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BASE` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`),
  CONSTRAINT `FK_CATALOG_CATEGORY_PROD_IDX_CATEGORY_ENTITY` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_CATEGORY_PROD_IDX_PROD_ENTITY` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATEGORY_PRODUCT_INDEX_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index` VALUES (3,188,0,1,1,4),(3,189,0,1,1,4),(3,190,0,1,1,4),(3,191,0,1,1,4),(3,192,0,1,1,4),(3,193,0,1,1,4),(3,194,0,1,1,4),(3,195,0,1,1,4),(3,196,0,1,1,4),(3,197,0,1,1,4),(3,198,0,1,1,4),(3,199,0,1,1,4),(3,200,0,1,1,4),(3,201,0,1,1,4),(3,202,0,1,1,4),(3,203,0,1,1,4),(3,204,0,1,1,4),(3,205,0,1,1,4),(3,206,0,1,1,4),(3,208,0,1,1,4),(3,209,0,1,1,4),(3,210,0,1,1,4),(35,189,1,1,1,4),(36,188,0,1,1,4),(36,189,0,1,1,4),(36,190,0,1,1,4),(36,191,0,1,1,4),(36,192,0,1,1,4),(36,193,0,1,1,4),(36,194,0,1,1,4),(36,195,0,1,1,4),(36,196,0,1,1,4),(36,197,0,1,1,4),(36,198,0,1,1,4),(36,199,0,1,1,4),(36,200,0,1,1,4),(36,201,0,1,1,4),(36,202,0,1,1,4),(36,203,0,1,1,4),(36,204,0,1,1,4),(36,205,0,1,1,4),(36,206,0,1,1,4),(36,208,0,1,1,4),(36,209,0,1,1,4),(36,210,0,1,1,4),(37,188,0,1,1,4),(37,189,0,1,1,4),(37,190,0,1,1,4),(37,191,0,1,1,4),(37,192,0,1,1,4),(37,193,0,1,1,4),(37,194,0,1,1,4),(37,195,0,1,1,4),(37,196,0,1,1,4),(37,197,0,1,1,4),(37,198,0,1,1,4),(37,199,0,1,1,4),(37,200,0,1,1,4),(37,201,0,1,1,4),(37,202,0,1,1,4),(37,203,0,1,1,4),(37,204,0,1,1,4),(37,205,0,1,1,4),(37,206,0,1,1,4),(37,208,0,1,1,4),(37,209,0,1,1,4),(37,210,0,1,1,4),(38,189,1,1,1,4),(38,190,1,1,1,4),(39,188,1,1,1,4),(39,189,1,1,1,4),(39,190,1,1,1,4),(39,191,1,1,1,4),(39,192,1,1,1,4),(39,193,1,1,1,4),(39,194,1,1,1,4),(39,195,1,1,1,4),(39,196,1,1,1,4),(39,197,1,1,1,4),(39,198,1,1,1,4),(39,199,1,1,1,4),(39,200,1,1,1,4),(39,201,1,1,1,4),(39,202,1,1,1,4),(39,203,1,1,1,4),(39,204,1,1,1,4),(39,205,1,1,1,4),(39,206,1,1,1,4),(39,208,1,1,1,4),(39,209,1,1,1,4),(39,210,1,1,1,4),(40,188,1,1,1,4),(40,189,1,1,1,4),(40,190,1,1,1,4),(40,191,1,1,1,4),(40,192,1,1,1,4),(40,193,1,1,1,4),(40,194,1,1,1,4),(40,195,1,1,1,4),(40,196,1,1,1,4),(40,197,1,1,1,4),(40,198,1,1,1,4),(40,199,1,1,1,4),(40,200,1,1,1,4),(40,201,1,1,1,4),(40,202,1,1,1,4),(40,203,1,1,1,4),(40,204,1,1,1,4),(40,205,1,1,1,4),(40,206,1,1,1,4),(40,208,1,1,1,4),(40,209,1,1,1,4),(40,210,1,1,1,4),(44,188,1,1,1,4),(44,189,1,1,1,4),(44,190,1,1,1,4),(44,191,1,1,1,4),(44,192,1,1,1,4),(44,193,1,1,1,4),(44,194,1,1,1,4),(44,195,1,1,1,4),(44,196,1,1,1,4),(44,197,1,1,1,4),(44,198,1,1,1,4),(44,199,1,1,1,4),(44,200,1,1,1,4),(44,201,1,1,1,4),(44,202,1,1,1,4),(44,203,1,1,1,4),(44,204,1,1,1,4),(44,205,1,1,1,4),(44,206,1,1,1,4),(44,208,1,1,1,4),(44,209,1,1,1,4),(44,210,1,1,1,4),(3,188,0,1,2,4),(3,189,0,1,2,4),(3,190,0,1,2,4),(3,191,0,1,2,4),(3,192,0,1,2,4),(3,193,0,1,2,4),(3,194,0,1,2,4),(3,195,0,1,2,4),(3,196,0,1,2,4),(3,197,0,1,2,4),(3,198,0,1,2,4),(3,199,0,1,2,4),(3,200,0,1,2,4),(3,201,0,1,2,4),(3,202,0,1,2,4),(3,203,0,1,2,4),(3,204,0,1,2,4),(3,205,0,1,2,4),(3,206,0,1,2,4),(3,208,0,1,2,4),(3,209,0,1,2,4),(3,210,0,1,2,4),(35,189,1,1,2,4),(36,188,0,1,2,4),(36,189,0,1,2,4),(36,190,0,1,2,4),(36,191,0,1,2,4),(36,192,0,1,2,4),(36,193,0,1,2,4),(36,194,0,1,2,4),(36,195,0,1,2,4),(36,196,0,1,2,4),(36,197,0,1,2,4),(36,198,0,1,2,4),(36,199,0,1,2,4),(36,200,0,1,2,4),(36,201,0,1,2,4),(36,202,0,1,2,4),(36,203,0,1,2,4),(36,204,0,1,2,4),(36,205,0,1,2,4),(36,206,0,1,2,4),(36,208,0,1,2,4),(36,209,0,1,2,4),(36,210,0,1,2,4),(37,188,0,1,2,4),(37,189,0,1,2,4),(37,190,0,1,2,4),(37,191,0,1,2,4),(37,192,0,1,2,4),(37,193,0,1,2,4),(37,194,0,1,2,4),(37,195,0,1,2,4),(37,196,0,1,2,4),(37,197,0,1,2,4),(37,198,0,1,2,4),(37,199,0,1,2,4),(37,200,0,1,2,4),(37,201,0,1,2,4),(37,202,0,1,2,4),(37,203,0,1,2,4),(37,204,0,1,2,4),(37,205,0,1,2,4),(37,206,0,1,2,4),(37,208,0,1,2,4),(37,209,0,1,2,4),(37,210,0,1,2,4),(38,189,1,1,2,4),(38,190,1,1,2,4),(39,188,1,1,2,4),(39,189,1,1,2,4),(39,190,1,1,2,4),(39,191,1,1,2,4),(39,192,1,1,2,4),(39,193,1,1,2,4),(39,194,1,1,2,4),(39,195,1,1,2,4),(39,196,1,1,2,4),(39,197,1,1,2,4),(39,198,1,1,2,4),(39,199,1,1,2,4),(39,200,1,1,2,4),(39,201,1,1,2,4),(39,202,1,1,2,4),(39,203,1,1,2,4),(39,204,1,1,2,4),(39,205,1,1,2,4),(39,206,1,1,2,4),(39,208,1,1,2,4),(39,209,1,1,2,4),(39,210,1,1,2,4),(40,188,1,1,2,4),(40,189,1,1,2,4),(40,190,1,1,2,4),(40,191,1,1,2,4),(40,192,1,1,2,4),(40,193,1,1,2,4),(40,194,1,1,2,4),(40,195,1,1,2,4),(40,196,1,1,2,4),(40,197,1,1,2,4),(40,198,1,1,2,4),(40,199,1,1,2,4),(40,200,1,1,2,4),(40,201,1,1,2,4),(40,202,1,1,2,4),(40,203,1,1,2,4),(40,204,1,1,2,4),(40,205,1,1,2,4),(40,206,1,1,2,4),(40,208,1,1,2,4),(40,209,1,1,2,4),(40,210,1,1,2,4),(44,188,1,1,2,4),(44,189,1,1,2,4),(44,190,1,1,2,4),(44,191,1,1,2,4),(44,192,1,1,2,4),(44,193,1,1,2,4),(44,194,1,1,2,4),(44,195,1,1,2,4),(44,196,1,1,2,4),(44,197,1,1,2,4),(44,198,1,1,2,4),(44,199,1,1,2,4),(44,200,1,1,2,4),(44,201,1,1,2,4),(44,202,1,1,2,4),(44,203,1,1,2,4),(44,204,1,1,2,4),(44,205,1,1,2,4),(44,206,1,1,2,4),(44,208,1,1,2,4),(44,209,1,1,2,4),(44,210,1,1,2,4),(3,188,0,1,3,4),(3,189,0,1,3,4),(3,190,0,1,3,4),(3,191,0,1,3,4),(3,192,0,1,3,4),(3,193,0,1,3,4),(3,194,0,1,3,4),(3,195,0,1,3,4),(3,196,0,1,3,4),(3,197,0,1,3,4),(3,198,0,1,3,4),(3,199,0,1,3,4),(3,200,0,1,3,4),(3,201,0,1,3,4),(3,202,0,1,3,4),(3,203,0,1,3,4),(3,204,0,1,3,4),(3,205,0,1,3,4),(3,206,0,1,3,4),(3,208,0,1,3,4),(3,209,0,1,3,4),(3,210,0,1,3,4),(35,189,1,1,3,4),(36,188,0,1,3,4),(36,189,0,1,3,4),(36,190,0,1,3,4),(36,191,0,1,3,4),(36,192,0,1,3,4),(36,193,0,1,3,4),(36,194,0,1,3,4),(36,195,0,1,3,4),(36,196,0,1,3,4),(36,197,0,1,3,4),(36,198,0,1,3,4),(36,199,0,1,3,4),(36,200,0,1,3,4),(36,201,0,1,3,4),(36,202,0,1,3,4),(36,203,0,1,3,4),(36,204,0,1,3,4),(36,205,0,1,3,4),(36,206,0,1,3,4),(36,208,0,1,3,4),(36,209,0,1,3,4),(36,210,0,1,3,4),(37,188,0,1,3,4),(37,189,0,1,3,4),(37,190,0,1,3,4),(37,191,0,1,3,4),(37,192,0,1,3,4),(37,193,0,1,3,4),(37,194,0,1,3,4),(37,195,0,1,3,4),(37,196,0,1,3,4),(37,197,0,1,3,4),(37,198,0,1,3,4),(37,199,0,1,3,4),(37,200,0,1,3,4),(37,201,0,1,3,4),(37,202,0,1,3,4),(37,203,0,1,3,4),(37,204,0,1,3,4),(37,205,0,1,3,4),(37,206,0,1,3,4),(37,208,0,1,3,4),(37,209,0,1,3,4),(37,210,0,1,3,4),(38,189,1,1,3,4),(38,190,1,1,3,4),(39,188,1,1,3,4),(39,189,1,1,3,4),(39,190,1,1,3,4),(39,191,1,1,3,4),(39,192,1,1,3,4),(39,193,1,1,3,4),(39,194,1,1,3,4),(39,195,1,1,3,4),(39,196,1,1,3,4),(39,197,1,1,3,4),(39,198,1,1,3,4),(39,199,1,1,3,4),(39,200,1,1,3,4),(39,201,1,1,3,4),(39,202,1,1,3,4),(39,203,1,1,3,4),(39,204,1,1,3,4),(39,205,1,1,3,4),(39,206,1,1,3,4),(39,208,1,1,3,4),(39,209,1,1,3,4),(39,210,1,1,3,4),(40,188,1,1,3,4),(40,189,1,1,3,4),(40,190,1,1,3,4),(40,191,1,1,3,4),(40,192,1,1,3,4),(40,193,1,1,3,4),(40,194,1,1,3,4),(40,195,1,1,3,4),(40,196,1,1,3,4),(40,197,1,1,3,4),(40,198,1,1,3,4),(40,199,1,1,3,4),(40,200,1,1,3,4),(40,201,1,1,3,4),(40,202,1,1,3,4),(40,203,1,1,3,4),(40,204,1,1,3,4),(40,205,1,1,3,4),(40,206,1,1,3,4),(40,208,1,1,3,4),(40,209,1,1,3,4),(40,210,1,1,3,4),(44,188,1,1,3,4),(44,189,1,1,3,4),(44,190,1,1,3,4),(44,191,1,1,3,4),(44,192,1,1,3,4),(44,193,1,1,3,4),(44,194,1,1,3,4),(44,195,1,1,3,4),(44,196,1,1,3,4),(44,197,1,1,3,4),(44,198,1,1,3,4),(44,199,1,1,3,4),(44,200,1,1,3,4),(44,201,1,1,3,4),(44,202,1,1,3,4),(44,203,1,1,3,4),(44,204,1,1,3,4),(44,205,1,1,3,4),(44,206,1,1,3,4),(44,208,1,1,3,4),(44,209,1,1,3,4),(44,210,1,1,3,4),(3,188,0,1,4,4),(3,189,0,1,4,4),(3,190,0,1,4,4),(3,191,0,1,4,4),(3,192,0,1,4,4),(3,193,0,1,4,4),(3,194,0,1,4,4),(3,195,0,1,4,4),(3,196,0,1,4,4),(3,197,0,1,4,4),(3,198,0,1,4,4),(3,199,0,1,4,4),(3,200,0,1,4,4),(3,201,0,1,4,4),(3,202,0,1,4,4),(3,203,0,1,4,4),(3,204,0,1,4,4),(3,205,0,1,4,4),(3,206,0,1,4,4),(3,208,0,1,4,4),(3,209,0,1,4,4),(3,210,0,1,4,4),(35,189,1,1,4,4),(36,188,0,1,4,4),(36,189,0,1,4,4),(36,190,0,1,4,4),(36,191,0,1,4,4),(36,192,0,1,4,4),(36,193,0,1,4,4),(36,194,0,1,4,4),(36,195,0,1,4,4),(36,196,0,1,4,4),(36,197,0,1,4,4),(36,198,0,1,4,4),(36,199,0,1,4,4),(36,200,0,1,4,4),(36,201,0,1,4,4),(36,202,0,1,4,4),(36,203,0,1,4,4),(36,204,0,1,4,4),(36,205,0,1,4,4),(36,206,0,1,4,4),(36,208,0,1,4,4),(36,209,0,1,4,4),(36,210,0,1,4,4),(37,188,0,1,4,4),(37,189,0,1,4,4),(37,190,0,1,4,4),(37,191,0,1,4,4),(37,192,0,1,4,4),(37,193,0,1,4,4),(37,194,0,1,4,4),(37,195,0,1,4,4),(37,196,0,1,4,4),(37,197,0,1,4,4),(37,198,0,1,4,4),(37,199,0,1,4,4),(37,200,0,1,4,4),(37,201,0,1,4,4),(37,202,0,1,4,4),(37,203,0,1,4,4),(37,204,0,1,4,4),(37,205,0,1,4,4),(37,206,0,1,4,4),(37,208,0,1,4,4),(37,209,0,1,4,4),(37,210,0,1,4,4),(38,189,1,1,4,4),(38,190,1,1,4,4),(39,188,1,1,4,4),(39,189,1,1,4,4),(39,190,1,1,4,4),(39,191,1,1,4,4),(39,192,1,1,4,4),(39,193,1,1,4,4),(39,194,1,1,4,4),(39,195,1,1,4,4),(39,196,1,1,4,4),(39,197,1,1,4,4),(39,198,1,1,4,4),(39,199,1,1,4,4),(39,200,1,1,4,4),(39,201,1,1,4,4),(39,202,1,1,4,4),(39,203,1,1,4,4),(39,204,1,1,4,4),(39,205,1,1,4,4),(39,206,1,1,4,4),(39,208,1,1,4,4),(39,209,1,1,4,4),(39,210,1,1,4,4),(40,188,1,1,4,4),(40,189,1,1,4,4),(40,190,1,1,4,4),(40,191,1,1,4,4),(40,192,1,1,4,4),(40,193,1,1,4,4),(40,194,1,1,4,4),(40,195,1,1,4,4),(40,196,1,1,4,4),(40,197,1,1,4,4),(40,198,1,1,4,4),(40,199,1,1,4,4),(40,200,1,1,4,4),(40,201,1,1,4,4),(40,202,1,1,4,4),(40,203,1,1,4,4),(40,204,1,1,4,4),(40,205,1,1,4,4),(40,206,1,1,4,4),(40,208,1,1,4,4),(40,209,1,1,4,4),(40,210,1,1,4,4),(44,188,1,1,4,4),(44,189,1,1,4,4),(44,190,1,1,4,4),(44,191,1,1,4,4),(44,192,1,1,4,4),(44,193,1,1,4,4),(44,194,1,1,4,4),(44,195,1,1,4,4),(44,196,1,1,4,4),(44,197,1,1,4,4),(44,198,1,1,4,4),(44,199,1,1,4,4),(44,200,1,1,4,4),(44,201,1,1,4,4),(44,202,1,1,4,4),(44,203,1,1,4,4),(44,204,1,1,4,4),(44,205,1,1,4,4),(44,206,1,1,4,4),(44,208,1,1,4,4),(44,209,1,1,4,4),(44,210,1,1,4,4),(3,188,0,1,5,4),(3,189,0,1,5,4),(3,190,0,1,5,4),(3,191,0,1,5,4),(3,192,0,1,5,4),(3,193,0,1,5,4),(3,194,0,1,5,4),(3,195,0,1,5,4),(3,196,0,1,5,4),(3,197,0,1,5,4),(3,198,0,1,5,4),(3,199,0,1,5,4),(3,200,0,1,5,4),(3,201,0,1,5,4),(3,202,0,1,5,4),(3,203,0,1,5,4),(3,204,0,1,5,4),(3,205,0,1,5,4),(3,206,0,1,5,4),(3,208,0,1,5,4),(3,209,0,1,5,4),(3,210,0,1,5,4),(35,189,1,1,5,4),(36,188,0,1,5,4),(36,189,0,1,5,4),(36,190,0,1,5,4),(36,191,0,1,5,4),(36,192,0,1,5,4),(36,193,0,1,5,4),(36,194,0,1,5,4),(36,195,0,1,5,4),(36,196,0,1,5,4),(36,197,0,1,5,4),(36,198,0,1,5,4),(36,199,0,1,5,4),(36,200,0,1,5,4),(36,201,0,1,5,4),(36,202,0,1,5,4),(36,203,0,1,5,4),(36,204,0,1,5,4),(36,205,0,1,5,4),(36,206,0,1,5,4),(36,208,0,1,5,4),(36,209,0,1,5,4),(36,210,0,1,5,4),(37,188,0,1,5,4),(37,189,0,1,5,4),(37,190,0,1,5,4),(37,191,0,1,5,4),(37,192,0,1,5,4),(37,193,0,1,5,4),(37,194,0,1,5,4),(37,195,0,1,5,4),(37,196,0,1,5,4),(37,197,0,1,5,4),(37,198,0,1,5,4),(37,199,0,1,5,4),(37,200,0,1,5,4),(37,201,0,1,5,4),(37,202,0,1,5,4),(37,203,0,1,5,4),(37,204,0,1,5,4),(37,205,0,1,5,4),(37,206,0,1,5,4),(37,208,0,1,5,4),(37,209,0,1,5,4),(37,210,0,1,5,4),(38,189,1,1,5,4),(38,190,1,1,5,4),(39,188,1,1,5,4),(39,189,1,1,5,4),(39,190,1,1,5,4),(39,191,1,1,5,4),(39,192,1,1,5,4),(39,193,1,1,5,4),(39,194,1,1,5,4),(39,195,1,1,5,4),(39,196,1,1,5,4),(39,197,1,1,5,4),(39,198,1,1,5,4),(39,199,1,1,5,4),(39,200,1,1,5,4),(39,201,1,1,5,4),(39,202,1,1,5,4),(39,203,1,1,5,4),(39,204,1,1,5,4),(39,205,1,1,5,4),(39,206,1,1,5,4),(39,208,1,1,5,4),(39,209,1,1,5,4),(39,210,1,1,5,4),(40,188,1,1,5,4),(40,189,1,1,5,4),(40,190,1,1,5,4),(40,191,1,1,5,4),(40,192,1,1,5,4),(40,193,1,1,5,4),(40,194,1,1,5,4),(40,195,1,1,5,4),(40,196,1,1,5,4),(40,197,1,1,5,4),(40,198,1,1,5,4),(40,199,1,1,5,4),(40,200,1,1,5,4),(40,201,1,1,5,4),(40,202,1,1,5,4),(40,203,1,1,5,4),(40,204,1,1,5,4),(40,205,1,1,5,4),(40,206,1,1,5,4),(40,208,1,1,5,4),(40,209,1,1,5,4),(40,210,1,1,5,4),(44,188,1,1,5,4),(44,189,1,1,5,4),(44,190,1,1,5,4),(44,191,1,1,5,4),(44,192,1,1,5,4),(44,193,1,1,5,4),(44,194,1,1,5,4),(44,195,1,1,5,4),(44,196,1,1,5,4),(44,197,1,1,5,4),(44,198,1,1,5,4),(44,199,1,1,5,4),(44,200,1,1,5,4),(44,201,1,1,5,4),(44,202,1,1,5,4),(44,203,1,1,5,4),(44,204,1,1,5,4),(44,205,1,1,5,4),(44,206,1,1,5,4),(44,208,1,1,5,4),(44,209,1,1,5,4),(44,210,1,1,5,4);
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_enbl_idx`
--

DROP TABLE IF EXISTS `catalog_category_product_index_enbl_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_enbl_idx` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `visibility` int(11) unsigned NOT NULL DEFAULT '0',
  KEY `IDX_PRODUCT` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_enbl_idx`
--

LOCK TABLES `catalog_category_product_index_enbl_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_enbl_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_enbl_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_enbl_tmp` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `visibility` int(11) unsigned NOT NULL DEFAULT '0',
  KEY `IDX_PRODUCT` (`product_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_enbl_tmp`
--

LOCK TABLES `catalog_category_product_index_enbl_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_enbl_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_idx`
--

DROP TABLE IF EXISTS `catalog_category_product_index_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_idx` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(10) NOT NULL DEFAULT '0',
  `is_parent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `visibility` tinyint(3) unsigned NOT NULL,
  KEY `IDX_PRODUCT_CATEGORY_STORE` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_idx`
--

LOCK TABLES `catalog_category_product_index_idx` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(10) NOT NULL DEFAULT '0',
  `is_parent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `visibility` tinyint(3) unsigned NOT NULL
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_category_product_index_tmp`
--

LOCK TABLES `catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `visitor_id` int(11) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(11) unsigned DEFAULT NULL,
  `product_id` int(11) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `FK_CATALOG_COMPARE_ITEM_CUSTOMER` (`customer_id`),
  KEY `FK_CATALOG_COMPARE_ITEM_PRODUCT` (`product_id`),
  KEY `IDX_VISITOR_PRODUCTS` (`visitor_id`,`product_id`),
  KEY `IDX_CUSTOMER_PRODUCTS` (`customer_id`,`product_id`),
  KEY `FK_CATALOG_COMPARE_ITEM_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_COMPARE_ITEM_CUSTOMER` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_COMPARE_ITEM_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_COMPARE_ITEM_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_compare_item`
--

LOCK TABLES `catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `catalog_compare_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `frontend_input_renderer` varchar(255) DEFAULT NULL,
  `is_global` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_filterable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_comparable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_visible_on_front` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_html_allowed_on_front` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_used_for_price_rules` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'deprecated after 1.4.0.1',
  `is_filterable_in_search` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `used_in_product_listing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `used_for_sort_by` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_configurable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `apply_to` varchar(255) NOT NULL,
  `is_visible_in_advanced_search` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL,
  `is_wysiwyg_enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_used_for_promo_rules` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`attribute_id`),
  KEY `IDX_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `IDX_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `FK_CATALOG_EAV_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=954 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (96,NULL,0,1,1,0,0,0,0,1,0,1,1,1,'',1,1,0,1),(97,NULL,0,1,1,0,1,0,1,1,0,0,0,1,'',1,1,1,1),(98,NULL,1,1,1,0,1,0,0,1,0,0,0,1,'',1,1,0,1),(99,NULL,2,1,1,1,0,0,0,1,1,1,1,1,'simple,configurable,virtual,bundle,downloadable',1,4,0,1),(100,NULL,2,1,0,0,0,0,0,1,0,0,0,1,'simple,virtual,downloadable',0,1,0,1),(101,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'simple,bundle',0,1,0,1),(102,NULL,1,1,1,1,1,0,0,1,1,0,0,1,'simple',0,1,0,1),(103,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(104,NULL,0,1,1,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(105,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(106,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(107,NULL,1,1,1,1,1,0,0,1,1,0,0,1,'simple,grouped,configurable',0,1,0,1),(109,NULL,0,1,0,0,0,0,0,1,0,1,0,1,'',0,1,0,1),(110,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(111,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(112,NULL,0,1,0,0,0,0,1,1,0,0,0,1,'',0,1,1,1),(113,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(114,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(115,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(116,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(117,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(118,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(119,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(120,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(121,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(122,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(123,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(270,NULL,2,1,0,0,0,0,0,0,0,0,0,1,'simple,configurable,virtual,bundle,downloadable',0,1,0,0),(271,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(272,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'simple',0,1,0,0),(273,NULL,2,1,1,0,0,0,0,1,0,1,0,1,'',0,1,0,1),(274,NULL,2,1,0,0,0,0,0,1,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,1,0,1),(476,NULL,0,1,1,1,1,1,0,1,1,0,0,1,'simple,grouped,configurable',0,1,0,1),(479,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(481,NULL,1,1,0,0,0,0,0,1,0,1,0,1,'',0,1,0,1),(492,NULL,0,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(493,NULL,0,1,0,0,0,0,0,1,0,1,0,1,'',0,1,0,1),(494,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(495,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(496,NULL,1,1,0,0,0,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(497,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple',0,1,0,1),(498,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(499,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(500,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(501,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,0),(502,NULL,1,1,1,0,0,0,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(503,NULL,0,0,0,0,0,0,0,1,0,0,0,1,'simple,configurable,virtual,bundle,downloadable',0,1,0,1),(506,NULL,0,1,1,0,1,0,1,1,0,1,0,1,'',0,1,1,1),(507,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(508,NULL,1,1,1,0,1,0,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(509,NULL,1,1,1,0,1,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(510,NULL,1,1,0,0,0,1,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,0),(513,NULL,1,1,1,1,1,1,0,1,1,0,0,1,'simple,grouped,configurable',0,1,0,1),(514,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(525,NULL,1,1,1,0,0,0,0,1,0,0,0,1,'simple,grouped,configurable',0,1,0,1),(526,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(530,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(531,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(533,NULL,0,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(562,'giftmessage/adminhtml_product_helper_form_config',1,1,0,0,0,0,0,1,0,0,0,0,'',0,1,0,1),(563,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(565,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(566,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(567,NULL,2,1,0,0,0,0,0,1,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,1,0,1),(568,NULL,1,1,0,0,0,0,0,1,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,1,0,1),(569,NULL,1,1,0,0,0,0,0,1,0,1,0,1,'simple,configurable,virtual,bundle,downloadable',0,1,0,1),(570,NULL,0,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(571,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(572,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(573,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(701,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(702,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(703,NULL,1,1,0,0,0,0,0,1,0,0,0,1,'',0,1,0,1),(704,NULL,1,1,0,0,0,0,0,1,0,1,0,1,'',0,1,0,1),(705,NULL,1,1,0,0,0,0,0,1,0,1,0,1,'',0,1,0,1),(835,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(836,NULL,0,1,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(837,NULL,1,0,0,0,0,0,0,1,0,1,0,1,'',0,0,0,1),(838,NULL,1,0,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(859,NULL,1,0,0,0,0,0,0,1,0,1,0,0,'bundle',0,0,0,1),(860,NULL,1,0,0,0,0,0,0,1,0,0,0,0,'bundle',0,0,0,1),(861,NULL,1,0,0,0,0,0,0,1,0,1,0,0,'bundle',0,0,0,1),(862,NULL,1,1,0,0,0,0,0,1,0,1,0,0,'bundle',0,0,0,1),(863,NULL,1,0,0,0,0,0,0,1,0,1,0,0,'bundle',0,0,0,1),(873,NULL,0,1,0,0,0,0,0,1,0,0,0,0,'',0,0,0,1),(874,NULL,0,1,0,0,0,0,0,1,0,0,0,0,'',0,0,0,1),(875,NULL,0,1,0,1,1,1,0,1,1,0,0,0,'',0,0,0,1),(876,NULL,0,1,0,0,0,1,0,1,0,0,0,0,'',0,0,0,1),(877,NULL,0,1,0,0,0,0,0,1,0,0,0,0,'',0,0,0,1),(878,NULL,0,1,0,0,0,1,0,1,0,0,0,0,'',0,0,0,1),(879,NULL,0,0,0,0,0,0,0,1,1,1,0,0,'',0,0,0,1),(880,NULL,0,0,0,0,0,0,0,1,1,1,0,0,'',0,0,0,1),(881,NULL,0,0,0,0,0,0,0,1,1,1,0,0,'',0,0,0,1),(903,NULL,1,1,0,0,0,0,0,1,1,0,0,0,'',0,0,0,1),(904,NULL,1,0,0,0,0,0,0,1,1,1,0,0,'downloadable',0,0,0,1),(905,NULL,0,0,0,0,0,0,0,1,1,0,0,0,'downloadable',0,0,0,1),(906,NULL,0,0,0,0,0,0,0,1,1,0,0,0,'downloadable',0,0,0,1),(927,'adminhtml/catalog_category_helper_sortby_available',0,1,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(928,'adminhtml/catalog_category_helper_sortby_default',0,1,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(929,'',0,1,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(930,'',1,0,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(931,'',1,0,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(932,'',0,1,0,0,0,0,0,1,0,0,0,1,'',0,0,0,1),(933,'',1,1,0,0,0,0,0,1,0,0,0,0,'simple,virtual',0,0,0,0),(934,'',1,1,0,0,0,0,0,1,0,0,0,0,'simple,virtual',0,0,0,0),(944,'',1,0,0,0,0,0,0,1,0,1,0,0,'downloadable',0,0,0,0),(945,'',0,1,0,0,0,0,0,0,0,0,0,1,'',0,0,0,0),(946,'',0,1,0,0,0,0,0,0,0,0,0,1,'',0,0,0,0),(947,'adminhtml/catalog_category_helper_pricestep',0,1,0,0,0,0,0,0,0,0,0,1,'',0,0,0,0),(948,'',0,1,0,0,0,0,0,0,0,0,0,1,'',0,0,0,0),(949,'',1,1,0,0,0,0,0,0,0,1,0,0,'',0,0,0,0),(950,NULL,0,1,0,0,0,0,0,0,0,0,0,0,'',0,0,0,0),(951,NULL,0,1,1,1,0,0,1,0,1,0,0,0,'',0,1,0,0),(952,NULL,0,1,1,1,0,0,1,0,1,0,0,0,'',0,3,0,0),(953,NULL,0,1,1,1,0,0,1,0,1,0,0,0,'',0,2,0,0);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL,
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `position` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`option_id`),
  KEY `FK_CATALOG_PRODUCT_BUNDLE_OPTION_PARENT` (`parent_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_BUNDLE_OPTION_PARENT` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Bundle Options';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option`
--

LOCK TABLES `catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(10) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_OPTION_STORE` (`option_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_BUNDLE_OPTION_VALUE_OPTION` (`option_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_BUNDLE_OPTION_VALUE_OPTION` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Bundle Selections';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_option_value`
--

LOCK TABLES `catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `customer_group_id` smallint(3) unsigned NOT NULL,
  `min_price` decimal(12,4) NOT NULL,
  `max_price` decimal(12,4) NOT NULL,
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `IDX_WEBSITE` (`website_id`),
  KEY `IDX_CUSTOMER_GROUP` (`customer_group_id`),
  CONSTRAINT `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_PRODUCT_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_price_index`
--

LOCK TABLES `catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(10) unsigned NOT NULL,
  `parent_product_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `position` int(10) unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `selection_price_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `selection_qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `selection_can_change_qty` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`selection_id`),
  KEY `FK_CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION` (`option_id`),
  KEY `FK_CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT` (`product_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Bundle Selections';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection`
--

LOCK TABLES `catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `selection_price_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`selection_id`,`website_id`),
  KEY `FK_BUNDLE_PRICE_SELECTION_WEBSITE` (`website_id`),
  CONSTRAINT `FK_BUNDLE_PRICE_SELECTION_ID` FOREIGN KEY (`selection_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_BUNDLE_PRICE_SELECTION_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_selection_price`
--

LOCK TABLES `catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `stock_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `stock_status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`entity_id`,`stock_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_bundle_stock_index`
--

LOCK TABLES `catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_enabled_index`
--

DROP TABLE IF EXISTS `catalog_product_enabled_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_enabled_index` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `visibility` smallint(5) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `UNQ_PRODUCT_STORE` (`product_id`,`store_id`),
  KEY `IDX_PRODUCT_VISIBILITY_IN_STORE` (`product_id`,`store_id`,`visibility`),
  KEY `FK_CATALOG_PRODUCT_ENABLED_INDEX_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENABLED_INDEX_PRODUCT_ENTITY` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENABLED_INDEX_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_enabled_index`
--

LOCK TABLES `catalog_product_enabled_index` WRITE;
/*!40000 ALTER TABLE `catalog_product_enabled_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_enabled_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(8) unsigned NOT NULL DEFAULT '0',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple',
  `sku` varchar(64) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `has_options` smallint(1) NOT NULL DEFAULT '0',
  `required_options` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`entity_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_ENTITY_TYPE` (`entity_type_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `sku` (`sku`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` FOREIGN KEY (`attribute_set_id`) REFERENCES `eav_attribute_set` (`attribute_set_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_ENTITY_TYPE` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8 COMMENT='Product Entityies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES (188,10,63,'simple','tb-16888172712','2012-06-21 09:37:40','2012-07-12 02:29:24',0,0),(189,10,63,'simple','tb-16746748453','2012-06-21 09:37:41','2012-07-12 02:31:20',0,0),(190,10,63,'simple','tb-15173227048','2012-06-21 09:37:43','2012-07-12 02:34:45',0,0),(191,10,63,'simple','tb-15167871086','2012-06-21 09:37:45','2012-07-12 02:38:12',0,0),(192,10,63,'simple','tb-14491898841','2012-06-21 09:37:47','2012-07-12 02:40:01',0,0),(193,10,63,'simple','tb-14420097483','2012-06-21 09:37:49','2012-07-12 02:41:31',0,0),(194,10,63,'simple','tb-16950456931','2012-06-21 09:37:50','2012-07-12 02:42:40',0,0),(195,10,63,'simple','tb-16916368211','2012-06-21 09:37:52','2012-07-12 02:45:51',0,0),(196,10,63,'simple','tb-16769128988','2012-06-21 09:37:55','2012-07-12 02:47:51',0,0),(197,10,63,'simple','tb-15248759961','2012-06-21 09:37:57','2012-07-12 02:52:31',0,0),(198,10,63,'simple','tb-15238419360','2012-06-21 09:37:59','2012-07-12 02:55:21',0,0),(199,10,63,'simple','tb-15237839452','2012-06-21 09:38:01','2012-07-12 02:57:48',0,0),(200,10,63,'simple','tb-15232587893','2012-06-21 09:38:03','2012-07-12 03:00:55',0,0),(201,10,63,'simple','tb-15176883730','2012-06-21 09:38:04','2012-07-12 03:02:56',0,0),(202,10,63,'simple','tb-14501358291','2012-06-21 09:38:06','2012-07-12 03:05:04',0,0),(203,10,63,'simple','tb-14483017901','2012-06-21 09:38:08','2012-07-12 03:08:09',0,0),(204,10,63,'simple','tb-14480890920','2012-06-21 09:38:10','2012-07-12 03:10:32',0,0),(205,10,63,'simple','tb-14470362811','2012-06-21 09:38:11','2012-07-12 03:13:21',0,0),(206,10,63,'simple','tb-14469030397','2012-06-21 09:38:13','2012-07-12 03:14:29',0,0),(208,10,63,'simple','tb-14450913511','2012-06-21 09:38:17','2012-07-12 03:17:08',0,0),(209,10,63,'simple','tb-14425318838','2012-06-21 09:38:19','2012-07-12 03:18:16',0,0),(210,10,63,'simple','tb-10220121642','2012-06-21 09:38:21','2012-07-12 03:19:44',0,0);
/*!40000 ALTER TABLE `catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` datetime DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_ATTRIBUTE_VALUE` (`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_DATETIME_STORE` (`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_DATETIME_PRODUCT_ENTITY` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_DATETIME_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PROD_ENTITY_DATETIME_PROD_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=444 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_datetime`
--

LOCK TABLES `catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_datetime` VALUES (300,10,568,0,188,NULL),(301,10,569,0,188,NULL),(302,10,572,0,188,NULL),(303,10,573,0,188,NULL),(304,10,704,0,188,NULL),(305,10,705,0,188,NULL),(306,10,568,0,189,NULL),(307,10,569,0,189,NULL),(308,10,572,0,189,NULL),(309,10,573,0,189,NULL),(310,10,704,0,189,NULL),(311,10,705,0,189,NULL),(312,10,568,0,190,NULL),(313,10,569,0,190,NULL),(314,10,572,0,190,NULL),(315,10,573,0,190,NULL),(316,10,704,0,190,NULL),(317,10,705,0,190,NULL),(318,10,568,0,191,NULL),(319,10,569,0,191,NULL),(320,10,572,0,191,NULL),(321,10,573,0,191,NULL),(322,10,704,0,191,NULL),(323,10,705,0,191,NULL),(324,10,568,0,192,NULL),(325,10,569,0,192,NULL),(326,10,572,0,192,NULL),(327,10,573,0,192,NULL),(328,10,704,0,192,NULL),(329,10,705,0,192,NULL),(330,10,568,0,193,NULL),(331,10,569,0,193,NULL),(332,10,572,0,193,NULL),(333,10,573,0,193,NULL),(334,10,704,0,193,NULL),(335,10,705,0,193,NULL),(336,10,568,0,194,NULL),(337,10,569,0,194,NULL),(338,10,572,0,194,NULL),(339,10,573,0,194,NULL),(340,10,704,0,194,NULL),(341,10,705,0,194,NULL),(342,10,568,0,195,NULL),(343,10,569,0,195,NULL),(344,10,572,0,195,NULL),(345,10,573,0,195,NULL),(346,10,704,0,195,NULL),(347,10,705,0,195,NULL),(354,10,568,0,196,NULL),(355,10,569,0,196,NULL),(356,10,572,0,196,NULL),(357,10,573,0,196,NULL),(358,10,704,0,196,NULL),(359,10,705,0,196,NULL),(360,10,568,0,197,NULL),(361,10,569,0,197,NULL),(362,10,572,0,197,NULL),(363,10,573,0,197,NULL),(364,10,704,0,197,NULL),(365,10,705,0,197,NULL),(366,10,568,0,198,NULL),(367,10,569,0,198,NULL),(368,10,572,0,198,NULL),(369,10,573,0,198,NULL),(370,10,704,0,198,NULL),(371,10,705,0,198,NULL),(372,10,568,0,199,NULL),(373,10,569,0,199,NULL),(374,10,572,0,199,NULL),(375,10,573,0,199,NULL),(376,10,704,0,199,NULL),(377,10,705,0,199,NULL),(378,10,568,0,200,NULL),(379,10,569,0,200,NULL),(380,10,572,0,200,NULL),(381,10,573,0,200,NULL),(382,10,704,0,200,NULL),(383,10,705,0,200,NULL),(384,10,568,0,201,NULL),(385,10,569,0,201,NULL),(386,10,572,0,201,NULL),(387,10,573,0,201,NULL),(388,10,704,0,201,NULL),(389,10,705,0,201,NULL),(390,10,568,0,202,NULL),(391,10,569,0,202,NULL),(392,10,572,0,202,NULL),(393,10,573,0,202,NULL),(394,10,704,0,202,NULL),(395,10,705,0,202,NULL),(396,10,568,0,203,NULL),(397,10,569,0,203,NULL),(398,10,572,0,203,NULL),(399,10,573,0,203,NULL),(400,10,704,0,203,NULL),(401,10,705,0,203,NULL),(402,10,568,0,204,NULL),(403,10,569,0,204,NULL),(404,10,572,0,204,NULL),(405,10,573,0,204,NULL),(406,10,704,0,204,NULL),(407,10,705,0,204,NULL),(408,10,568,0,205,NULL),(409,10,569,0,205,NULL),(410,10,572,0,205,NULL),(411,10,573,0,205,NULL),(412,10,704,0,205,NULL),(413,10,705,0,205,NULL),(414,10,568,0,206,NULL),(415,10,569,0,206,NULL),(416,10,572,0,206,NULL),(417,10,573,0,206,NULL),(418,10,704,0,206,NULL),(419,10,705,0,206,NULL),(426,10,568,0,208,NULL),(427,10,569,0,208,NULL),(428,10,572,0,208,NULL),(429,10,573,0,208,NULL),(430,10,704,0,208,NULL),(431,10,705,0,208,NULL),(432,10,568,0,209,NULL),(433,10,569,0,209,NULL),(434,10,572,0,209,NULL),(435,10,573,0,209,NULL),(436,10,704,0,209,NULL),(437,10,705,0,209,NULL),(438,10,568,0,210,NULL),(439,10,569,0,210,NULL),(440,10,572,0,210,NULL),(441,10,573,0,210,NULL),(442,10,704,0,210,NULL),(443,10,705,0,210,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_ATTRIBUTE_VALUE` (`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_DECIMAL_STORE` (`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_DECIMAL_PRODUCT_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE` (`attribute_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_DECIMAL_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PROD_ENTITY_DECIMAL_PROD_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=698 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_decimal`
--

LOCK TABLES `catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_decimal` VALUES (578,10,99,0,188,198.0000),(579,10,100,0,188,NULL),(580,10,101,0,188,0.8000),(581,10,503,0,188,NULL),(582,10,567,0,188,NULL),(583,10,99,0,189,188.0000),(584,10,100,0,189,NULL),(585,10,101,0,189,0.8000),(586,10,503,0,189,NULL),(587,10,567,0,189,NULL),(588,10,99,0,190,198.0000),(589,10,100,0,190,NULL),(590,10,101,0,190,0.8000),(591,10,503,0,190,NULL),(592,10,567,0,190,NULL),(593,10,99,0,191,188.0000),(594,10,100,0,191,NULL),(595,10,101,0,191,0.8000),(596,10,503,0,191,NULL),(597,10,567,0,191,NULL),(598,10,99,0,192,258.0000),(599,10,100,0,192,NULL),(600,10,101,0,192,0.8000),(601,10,503,0,192,NULL),(602,10,567,0,192,NULL),(603,10,99,0,193,188.0000),(604,10,100,0,193,NULL),(605,10,101,0,193,0.8000),(606,10,503,0,193,NULL),(607,10,567,0,193,NULL),(608,10,99,0,194,258.0000),(609,10,100,0,194,NULL),(610,10,101,0,194,0.8000),(611,10,503,0,194,NULL),(612,10,567,0,194,NULL),(613,10,99,0,195,188.0000),(614,10,100,0,195,NULL),(615,10,101,0,195,0.8000),(616,10,503,0,195,NULL),(617,10,567,0,195,NULL),(623,10,99,0,196,188.0000),(624,10,100,0,196,NULL),(625,10,101,0,196,0.8000),(626,10,503,0,196,NULL),(627,10,567,0,196,NULL),(628,10,99,0,197,428.0000),(629,10,100,0,197,NULL),(630,10,101,0,197,0.8000),(631,10,503,0,197,NULL),(632,10,567,0,197,NULL),(633,10,99,0,198,198.0000),(634,10,100,0,198,NULL),(635,10,101,0,198,0.8000),(636,10,503,0,198,NULL),(637,10,567,0,198,NULL),(638,10,99,0,199,188.0000),(639,10,100,0,199,NULL),(640,10,101,0,199,0.8000),(641,10,503,0,199,NULL),(642,10,567,0,199,NULL),(643,10,99,0,200,488.0000),(644,10,100,0,200,NULL),(645,10,101,0,200,0.8000),(646,10,503,0,200,NULL),(647,10,567,0,200,NULL),(648,10,99,0,201,188.0000),(649,10,100,0,201,NULL),(650,10,101,0,201,0.8000),(651,10,503,0,201,NULL),(652,10,567,0,201,NULL),(653,10,99,0,202,518.0000),(654,10,100,0,202,NULL),(655,10,101,0,202,0.8000),(656,10,503,0,202,NULL),(657,10,567,0,202,NULL),(658,10,99,0,203,188.0000),(659,10,100,0,203,NULL),(660,10,101,0,203,0.8000),(661,10,503,0,203,NULL),(662,10,567,0,203,NULL),(663,10,99,0,204,208.0000),(664,10,100,0,204,NULL),(665,10,101,0,204,0.8000),(666,10,503,0,204,NULL),(667,10,567,0,204,NULL),(668,10,99,0,205,208.0000),(669,10,100,0,205,NULL),(670,10,101,0,205,0.8000),(671,10,503,0,205,NULL),(672,10,567,0,205,NULL),(673,10,99,0,206,198.0000),(674,10,100,0,206,NULL),(675,10,101,0,206,0.8000),(676,10,503,0,206,NULL),(677,10,567,0,206,NULL),(683,10,99,0,208,188.0000),(684,10,100,0,208,NULL),(685,10,101,0,208,0.8000),(686,10,503,0,208,NULL),(687,10,567,0,208,NULL),(688,10,99,0,209,258.0000),(689,10,100,0,209,NULL),(690,10,101,0,209,0.8000),(691,10,503,0,209,NULL),(692,10,567,0,209,NULL),(693,10,99,0,210,198.0000),(694,10,100,0,210,NULL),(695,10,101,0,210,0.8000),(696,10,503,0,210,NULL),(697,10,567,0,210,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_BASE` (`entity_type_id`,`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_ATTRIBUTE_GALLERY_ENTITY` (`entity_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_GALLERY_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_CATEGORY_ENTITY_GALLERY_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_GALLERY_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_gallery`
--

LOCK TABLES `catalog_product_entity_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` int(11) DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_ATTRIBUTE_VALUE` (`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_INT_STORE` (`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_INT_PRODUCT_ENTITY` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_INT_PRODUCT_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_INT_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2382 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_int`
--

LOCK TABLES `catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_int` VALUES (908,10,273,0,188,1),(909,10,526,0,188,4),(910,10,903,0,188,1),(911,10,933,0,188,0),(912,10,949,0,188,0),(913,10,952,0,188,150),(914,10,273,0,189,1),(915,10,526,0,189,4),(916,10,903,0,189,1),(917,10,933,0,189,0),(918,10,949,0,189,0),(919,10,952,0,189,150),(920,10,273,0,190,1),(921,10,526,0,190,4),(922,10,903,0,190,1),(923,10,933,0,190,0),(924,10,949,0,190,0),(925,10,952,0,190,150),(926,10,273,0,191,1),(927,10,526,0,191,4),(928,10,903,0,191,1),(929,10,933,0,191,0),(930,10,949,0,191,0),(931,10,952,0,191,150),(932,10,273,0,192,1),(933,10,526,0,192,4),(934,10,903,0,192,1),(935,10,933,0,192,0),(936,10,949,0,192,0),(937,10,952,0,192,150),(938,10,273,0,193,1),(939,10,526,0,193,4),(940,10,903,0,193,1),(941,10,933,0,193,0),(942,10,949,0,193,0),(943,10,952,0,193,150),(944,10,273,0,194,1),(945,10,526,0,194,4),(946,10,903,0,194,1),(947,10,933,0,194,0),(948,10,949,0,194,0),(949,10,952,0,194,150),(950,10,273,0,195,1),(951,10,526,0,195,4),(952,10,903,0,195,1),(953,10,933,0,195,0),(954,10,949,0,195,0),(955,10,952,0,195,150),(961,10,273,0,196,1),(962,10,526,0,196,4),(963,10,903,0,196,1),(964,10,933,0,196,0),(965,10,949,0,196,0),(966,10,952,0,196,150),(967,10,273,0,197,1),(968,10,526,0,197,4),(969,10,903,0,197,1),(970,10,933,0,197,0),(971,10,949,0,197,0),(972,10,952,0,197,153),(973,10,273,0,198,1),(974,10,526,0,198,4),(975,10,903,0,198,1),(976,10,933,0,198,0),(977,10,949,0,198,0),(978,10,952,0,198,153),(979,10,273,0,199,1),(980,10,526,0,199,4),(981,10,903,0,199,1),(982,10,933,0,199,0),(983,10,949,0,199,0),(984,10,952,0,199,153),(985,10,273,0,200,1),(986,10,526,0,200,4),(987,10,903,0,200,1),(988,10,933,0,200,0),(989,10,949,0,200,0),(990,10,952,0,200,153),(991,10,273,0,201,1),(992,10,526,0,201,4),(993,10,903,0,201,1),(994,10,933,0,201,0),(995,10,949,0,201,0),(996,10,952,0,201,150),(997,10,273,0,202,1),(998,10,526,0,202,4),(999,10,903,0,202,1),(1000,10,933,0,202,0),(1001,10,949,0,202,0),(1002,10,952,0,202,153),(1003,10,273,0,203,1),(1004,10,526,0,203,4),(1005,10,903,0,203,1),(1006,10,933,0,203,0),(1007,10,949,0,203,0),(1008,10,952,0,203,150),(1009,10,273,0,204,1),(1010,10,526,0,204,4),(1011,10,903,0,204,1),(1012,10,933,0,204,0),(1013,10,949,0,204,0),(1014,10,952,0,204,153),(1015,10,273,0,205,1),(1016,10,526,0,205,4),(1017,10,903,0,205,1),(1018,10,933,0,205,0),(1019,10,949,0,205,0),(1020,10,952,0,205,150),(1021,10,273,0,206,1),(1022,10,526,0,206,4),(1023,10,903,0,206,1),(1024,10,933,0,206,0),(1025,10,949,0,206,0),(1026,10,952,0,206,153),(1033,10,273,0,208,1),(1034,10,526,0,208,4),(1035,10,903,0,208,1),(1036,10,933,0,208,0),(1037,10,949,0,208,0),(1038,10,952,0,208,150),(1039,10,273,0,209,1),(1040,10,526,0,209,4),(1041,10,903,0,209,1),(1042,10,933,0,209,0),(1043,10,949,0,209,0),(1044,10,952,0,209,150),(1045,10,273,0,210,1),(1046,10,526,0,210,4),(1047,10,903,0,210,1),(1048,10,933,0,210,0),(1049,10,949,0,210,0),(1050,10,952,0,210,150),(2360,10,274,0,188,NULL),(2361,10,274,0,189,NULL),(2362,10,274,0,190,NULL),(2363,10,274,0,191,NULL),(2364,10,274,0,192,NULL),(2365,10,274,0,193,NULL),(2366,10,274,0,194,NULL),(2367,10,274,0,195,NULL),(2368,10,274,0,196,NULL),(2369,10,274,0,197,NULL),(2370,10,274,0,198,NULL),(2371,10,274,0,199,NULL),(2372,10,274,0,200,NULL),(2373,10,274,0,201,NULL),(2374,10,274,0,202,NULL),(2375,10,274,0,203,NULL),(2376,10,274,0,204,NULL),(2377,10,274,0,205,NULL),(2378,10,274,0,206,NULL),(2379,10,274,0,208,NULL),(2380,10,274,0,209,NULL),(2381,10,274,0,210,NULL);
/*!40000 ALTER TABLE `catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  KEY `FK_CATALOG_PRODUCT_MEDIA_GALLERY_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_PRODUCT_MEDIA_GALLERY_ENTITY` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_MEDIA_GALLERY_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_MEDIA_GALLERY_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1128 DEFAULT CHARSET=utf8 COMMENT='Catalog product media gallery';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery`
--

LOCK TABLES `catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery` VALUES (432,703,194,'/T/2/T29veEXiVaXXXXXXXX__555275419.jpg'),(433,703,194,'/T/2/T2nvWEXcFXXXXXXXXX__555275419.jpg'),(434,703,194,'/T/1/T1gDO.XntlXXbjqvw4_052636.jpg'),(505,703,194,'/T/2/T29veEXiVaXXXXXXXX__555275419_1.jpg'),(506,703,194,'/T/2/T2nvWEXcFXXXXXXXXX__555275419_1.jpg'),(507,703,194,'/T/1/T1gDO.XntlXXbjqvw4_052636_1.jpg'),(529,703,201,'/T/2/T2XsXCXgtNXXXXXXXX__555275419_1.jpg'),(1060,703,188,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg'),(1061,703,188,'/t/1/t1bee_xb0nxxa_31_a_121029.jpg'),(1062,703,188,'/t/2/t2koudxkjaxxxxxxxx__555275419.jpg'),(1063,703,189,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg'),(1064,703,189,'/t/2/t2m7xkxgpcxxxxxxxx__555275419.jpg'),(1065,703,189,'/t/2/t2w_hmxetbxxxxxxxx__555275419.jpg'),(1066,703,190,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg'),(1067,703,190,'/t/2/t2gx4wxmxmxxxxxxxx__555275419.jpg'),(1068,703,190,'/t/1/t1tk1_xdfmxxxiq7ta_121753_1.jpg'),(1069,703,191,'/t/2/t2sogdxjhaxxxxxxxx__555275419.jpg'),(1070,703,191,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg'),(1071,703,191,'/t/1/t1vre8xixdxxxd_amt_012540.jpg'),(1072,703,192,'/t/2/t2xeeexd4xxxxxxxxx__555275419.jpg'),(1073,703,192,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg'),(1074,703,192,'/t/1/t1mmw_xhfnxxxrrhm4_052928_1.jpg'),(1075,703,193,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg'),(1076,703,193,'/t/1/t1emq_xl8oxxx_ip3y_025321.jpg'),(1077,703,193,'/t/1/t1zvy_xehlxxcibxpa_121357_1.jpg'),(1078,703,194,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg'),(1079,703,194,'/t/2/t29veexivaxxxxxxxx__555275419.jpg'),(1080,703,194,'/t/1/t1gdo_xntlxxbjqvw4_052636_1.jpg'),(1081,703,195,'/t/2/t2mgxixkxcxxxxxxxx__555275419.jpg'),(1082,703,195,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg'),(1083,703,195,'/t/1/t1igm_xifuxxbnsye8_101101_1.jpg'),(1084,703,196,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg'),(1085,703,196,'/t/1/t1h9u8xkvtxxam6pz2_042753_1.jpg'),(1086,703,196,'/t/2/t2ctxcxmxnxxxxxxxx__555275419.jpg'),(1087,703,197,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg'),(1088,703,197,'/t/1/t18_e_xaxlxxxdv3i4_052805_1.jpg'),(1089,703,197,'/t/2/t21g1exgraxxxxxxxx__555275419.jpg'),(1090,703,198,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg'),(1091,703,198,'/t/1/t18g5_xxbhxxb0ekk8_101309.jpg'),(1092,703,198,'/t/2/t2r3jhxgpmxxxxxxxx__555275419.jpg'),(1093,703,198,'/t/1/t1jke_xixixxbodpa5_054523.jpg'),(1094,703,199,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg'),(1095,703,199,'/t/1/t1vak_xmrhxxazm_s4_053944.jpg'),(1096,703,199,'/t/2/t2cunvxglcxxxxxxxx__555275419.jpg'),(1097,703,200,'/t/1/t1wr6xxafexxbyltq4_052430_1.jpg'),(1098,703,200,'/t/2/t2z_udxchaxxxxxxxx__555275419.jpg'),(1099,703,200,'/t/1/t1zni_xjnjxxcmjko__111747.jpg'),(1100,703,201,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg'),(1101,703,201,'/t/2/t2xsxcxgtnxxxxxxxx__555275419.jpg'),(1102,703,201,'/t/1/t1xg59xhnhxxae3eq__111819.jpg'),(1103,703,202,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg'),(1104,703,202,'/t/2/t2eg9exfvaxxxxxxxx__555275419.jpg'),(1105,703,202,'/t/2/t2xncexjpxxxxxxxxx__555275419.jpg'),(1106,703,203,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg'),(1107,703,203,'/t/1/t1i_o_xxdixxajdnmw_023654_1.jpg'),(1108,703,203,'/t/2/t2fmf2xh4cxxxxxxxx__555275419.jpg'),(1109,703,204,'/t/1/t1dms_xcvnxxbxvku0_035121_1.jpg'),(1110,703,204,'/t/2/t2uhiexnlaxxxxxxxx__555275419.jpg'),(1111,703,204,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg'),(1112,703,205,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg'),(1113,703,205,'/t/1/t1ul9_xehexxcxudsz_031705_1.jpg'),(1114,703,205,'/t/2/t2ukbexkxmxxxxxxxx__555275419.jpg'),(1115,703,206,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg'),(1116,703,206,'/t/1/t1g_u_xl8kxxapbe75_055523_1.jpg'),(1117,703,206,'/t/2/t2l_ntxahdxxxxxxxx__555275419.jpg'),(1118,703,208,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg'),(1119,703,208,'/t/1/t1x9w9xn0nxxaxgdst_011314_1.jpg'),(1120,703,208,'/t/2/t2fa4cxmrmxxxxxxxx__555275419.jpg'),(1121,703,208,'/t/2/t2bpxaxgxnxxxxxxxx__555275419.jpg'),(1122,703,209,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg'),(1123,703,209,'/t/2/t2lhphxexmxxxxxxxx__555275419.jpg'),(1124,703,209,'/t/2/t2spcdxxvxxxxxxxxx__555275419.jpg'),(1125,703,210,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg'),(1126,703,210,'/t/2/t27lgdxitaxxxxxxxx__555275419.jpg'),(1127,703,210,'/t/1/t1klilxxbvxxcgwfoz_032237_1.jpg');
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int(11) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `label` varchar(255) DEFAULT NULL,
  `position` int(11) unsigned DEFAULT NULL,
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`value_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_MEDIA_GALLERY_VALUE_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_MEDIA_GALLERY_VALUE_GALLERY` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_MEDIA_GALLERY_VALUE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog product media gallery values';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_media_gallery_value`
--

LOCK TABLES `catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value` VALUES (432,0,'',1,0),(433,0,'',2,0),(434,0,'',3,0),(505,0,'',4,0),(506,0,'',5,0),(507,0,'',6,0),(529,0,'',3,0),(1060,0,'',7,0),(1061,0,'',8,0),(1062,0,'',9,0),(1063,0,'',7,0),(1064,0,'',8,0),(1065,0,'',9,0),(1066,0,'',7,0),(1067,0,'',8,0),(1068,0,'',9,0),(1069,0,'',7,0),(1070,0,'',8,0),(1071,0,'',9,0),(1072,0,'',7,0),(1073,0,'',8,0),(1074,0,'',9,0),(1075,0,'',7,0),(1076,0,'',8,0),(1077,0,'',9,0),(1078,0,'',7,0),(1079,0,'',8,0),(1080,0,'',9,0),(1081,0,'',7,0),(1082,0,'',8,0),(1083,0,'',9,0),(1084,0,'',7,0),(1085,0,'',8,0),(1086,0,'',9,0),(1087,0,'',7,0),(1088,0,'',8,0),(1089,0,'',9,0),(1090,0,'',7,0),(1091,0,'',8,0),(1092,0,'',9,0),(1093,0,'',10,0),(1094,0,'',7,0),(1095,0,'',8,0),(1096,0,'',9,0),(1097,0,'',7,0),(1098,0,'',8,0),(1099,0,'',9,0),(1100,0,'',5,0),(1101,0,'',6,0),(1102,0,'',7,0),(1103,0,'',7,0),(1104,0,'',8,0),(1105,0,'',9,0),(1106,0,'',7,0),(1107,0,'',8,0),(1108,0,'',9,0),(1109,0,'',7,0),(1110,0,'',8,0),(1111,0,'',9,0),(1112,0,'',7,0),(1113,0,'',8,0),(1114,0,'',9,0),(1115,0,'',7,0),(1116,0,'',8,0),(1117,0,'',9,0),(1118,0,'',7,0),(1119,0,'',8,0),(1120,0,'',9,0),(1121,0,'',10,0),(1122,0,'',7,0),(1123,0,'',8,0),(1124,0,'',9,0),(1125,0,'',7,0),(1126,0,'',8,0),(1127,0,'',9,0);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_ATTRIBUTE_VALUE` (`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_TEXT_STORE` (`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_TEXT_PRODUCT_ENTITY` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_TEXT_PRODUCT_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_TEXT_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=876 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_text`
--

LOCK TABLES `catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_text` VALUES (781,10,97,0,188,'  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;400153-wat11701\">型号:&nbsp;400153-wat11701</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;女表\">手表种类:&nbsp;女表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;其他\">表带材质:&nbsp;其他</li><li title=\"&nbsp;心型\">表盘形状:&nbsp;心型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;5mm\">表盘厚度:&nbsp;5mm</li><li title=\"&nbsp;25mm\">尺寸:&nbsp;25mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;手链\">元素:&nbsp;手链</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>  <div><font color=\"#414141\" size=\"2\"></font></div>'),(782,10,104,0,188,'个性定制手表,儿童手表'),(783,10,506,0,188,''),(784,10,531,0,188,''),(785,10,97,0,189,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\">这款手表最受小女孩的青睐，圆形的表面镶嵌着半圆的水晶石。闪耀的水晶石，散发着璀璨的光芒，戴上它，转瞬间就能变成美丽的公主！ <br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:2.6CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">14～18CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">1.7CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:真皮 表壳:合金<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约17g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>\r\n后盖:可以在表壳后盖刻字<br>\r\n表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(786,10,104,0,189,'个性定制手表,儿童手表'),(787,10,506,0,189,''),(788,10,531,0,189,''),(789,10,97,0,190,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\"> 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">16～20CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">3.0CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:真皮 表壳:合金<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约30g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br />\r\n  后盖:可以在表壳后盖刻字<br />\r\n  表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(790,10,104,0,190,'个性定制手表,男款手表'),(791,10,506,0,190,''),(792,10,531,0,190,''),(793,10,97,0,191,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\">时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">14～19CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.0CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:塑胶 表壳:塑胶<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约20g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>\r\n   表壳：可以选择不同颜色的表壳\r\n  后盖:可以在表壳后盖刻字<br></p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(794,10,104,0,191,'个性定制手表,男款运动手表'),(795,10,506,0,191,''),(796,10,531,0,191,''),(797,10,97,0,192,' <p>精致与个性的完美融合,还能在表盘上雕刻特别的文字,赋予这块表特别的涵义,气质独特、 与众不同</p>\r\n  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;50726-wat11901\">型号:&nbsp;50726-wat11901</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;女表\">手表种类:&nbsp;女表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;合金\">表带材质:&nbsp;合金</li><li title=\"&nbsp;酒桶型\">表盘形状:&nbsp;酒桶型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;蝴蝶双按扣\">表扣:&nbsp;蝴蝶双按扣</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;其他\">元素:&nbsp;其他</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>'),(798,10,104,0,192,'个性定制手表,时尚女表'),(799,10,506,0,192,''),(800,10,531,0,192,''),(801,10,97,0,193,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\">时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">14～19CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.0CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:塑胶 表壳:塑胶<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约20g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>\r\n   表壳：可以选择不同颜色的表壳\r\n  后盖:可以在表壳后盖刻字<br></p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(802,10,104,0,193,'个性定制手表,儿童手表'),(803,10,506,0,193,''),(804,10,531,0,193,''),(805,10,97,0,194,'  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;56432-wat12601\">型号:&nbsp;56432-wat12601</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;中性表\">手表种类:&nbsp;中性表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;圆型\">表盘形状:&nbsp;圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;其他\">元素:&nbsp;其他</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul> '),(806,10,104,0,194,'个性定制手表,时尚女表'),(807,10,506,0,194,''),(808,10,531,0,194,''),(809,10,97,0,195,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\"> 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定会很有成就感！ <br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">15～19CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.0CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:尼龙/硅胶 表壳:合金<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约17g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>\r\n  表壳：可选择不同颜色的表壳<br>\r\n后盖:可以在表壳后盖刻字<br>\r\n表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(810,10,104,0,195,'个性定制手表,儿童手表'),(811,10,506,0,195,''),(812,10,531,0,195,''),(816,10,97,0,196,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\"> 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定很有成就感！<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">14～19CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.0CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:真皮 表壳:合金<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约17g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>壳\r\n  后盖:可以在表壳后盖刻字<br>\r\n  表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(817,10,104,0,196,'个性定制手表,儿童手表'),(818,10,506,0,196,''),(819,10,531,0,196,''),(820,10,97,0,197,'  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;50890-wat12201\">型号:&nbsp;50890-wat12201</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;女表\">手表种类:&nbsp;女表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;合金\">表带材质:&nbsp;合金</li><li title=\"&nbsp;方型\">表盘形状:&nbsp;方型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;其他\">元素:&nbsp;其他</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>'),(821,10,104,0,197,'个性定制手表,时尚女表'),(822,10,506,0,197,''),(823,10,531,0,197,''),(824,10,97,0,198,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\">方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.4M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">16.5～22CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.7CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:真皮 表壳:合金<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约30g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br />\r\n  后盖:可以在表壳后盖刻字<br />\r\n  表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(825,10,104,0,198,'个性定制手表,时尚男表'),(826,10,506,0,198,''),(827,10,531,0,198,''),(828,10,97,0,199,'  <p>这款独一无二的手表，由你亲手设计——你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。</p>\r\n  <p>方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。</p>\r\n  <p>本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。</p>\r\n  <p>怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。</p>\r\n  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;84839-wat11301\">型号:&nbsp;84839-wat11301</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;女表\">手表种类:&nbsp;女表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;真皮\">表带材质:&nbsp;真皮</li><li title=\"&nbsp;方型\">表盘形状:&nbsp;方型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;针扣\">表扣:&nbsp;针扣</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;25mm\">尺寸:&nbsp;25mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul> '),(829,10,104,0,199,'个性定制手表,时尚女表'),(830,10,506,0,199,''),(831,10,531,0,199,''),(832,10,97,0,200,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\"> 时尚潮流女士手表，不仅可以体现你的生活品味，而且可以在商务场合中突显你的时尚个性，让你与别人与众不同.<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带26CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">16.5～22CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.2CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:精钢 表壳:316钢<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约65g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>\r\n  后盖:可以在表壳后盖刻字<br></p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(833,10,104,0,200,'个性定制手表,时尚女表'),(834,10,506,0,200,''),(835,10,531,0,200,''),(836,10,97,0,201,'<p>  具有古典怀旧风格的一款手表，圆形的表壳镶嵌着古典风格花纹图案，具有古罗马复古气息，是女孩子的最爱！<br>  表盘可选择你喜欢的公主、可爱的小米妮，或任意一款你喜欢的图案。一定别忘了写上你的名字哦！你叫LINDA?印上你的名字后，这就是一块专属于LINDA的手表啦！<br>  \r\n  真皮表带，戴上后舒适又时尚，还可任意选择你喜欢的颜色。你喜欢甜美的粉红色？没问题，喜欢什么就是什么！</p>\r\n  \r\n<ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;84844-wat10601\">型号:&nbsp;84844-wat10601</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;儿童手表\">手表种类:&nbsp;儿童手表</li><li title=\"&nbsp;可爱童真\">手表风格:&nbsp;可爱童真</li><li title=\"&nbsp;真皮\">表带材质:&nbsp;真皮</li><li title=\"&nbsp;圆型\">表盘形状:&nbsp;圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;针扣\">表扣:&nbsp;针扣</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;30mm\">尺寸:&nbsp;30mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;复古\">元素:&nbsp;复古</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>'),(837,10,104,0,201,'个性定制手表,儿童手表'),(838,10,506,0,201,''),(839,10,531,0,201,''),(840,10,97,0,202,'  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;SA10-wat12801\">型号:&nbsp;SA10-wat12801</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;男表\">手表种类:&nbsp;男表</li><li title=\"&nbsp;商务休闲\">手表风格:&nbsp;商务休闲</li><li title=\"&nbsp;圆型\">表盘形状:&nbsp;圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul> '),(841,10,104,0,202,'个性定制手表,时尚男表'),(842,10,506,0,202,''),(843,10,531,0,202,''),(844,10,97,0,203,'  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;400312-wat12301\">型号:&nbsp;400312-wat12301</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;儿童手表\">手表种类:&nbsp;儿童手表</li><li title=\"&nbsp;可爱童真\">手表风格:&nbsp;可爱童真</li><li title=\"&nbsp;硅胶\">表带材质:&nbsp;硅胶</li><li title=\"&nbsp;圆型\">表盘形状:&nbsp;圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;针扣\">表扣:&nbsp;针扣</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;其他\">元素:&nbsp;其他</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>  <div><font color=\"#414141\" size=\"2\"></font></div><div></div><div></div><div></div><div></div><div></div><div><font size=\"3\"><font color=\"#414141\" face=\"宋体\"><span style=\"font-family: 宋体;\"><font color=\"#000000\"></font></span></font></font><font size=\"4\"><font color=\"#414141\" face=\"宋体\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-family: microsoft yahei;\"><span><span style=\"font-size: 14.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font size=\"4\"><font color=\"#414141\" face=\"宋体\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><span style=\"color: #990000;\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: microsoft yahei;\"><font size=\"4\"><font color=\"#414141\" face=\"宋体\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-family: microsoft yahei;\"><span><span style=\"font-size: 14.0px;\"><span style=\"font-size: 18.0px;\"></span></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></span></span></span></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></div><div><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><span style=\"color: #990000;\"><span style=\"font-size: 14.0px;\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></span></span></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></div><div><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><span style=\"color: #990000;\"><span style=\"font-size: 14.0px;\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></span></span></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></div><div><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><span style=\"color: #990000;\"><span style=\"font-size: 14.0px;\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></span></span></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></div><div><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><span style=\"color: #990000;\"><span style=\"font-size: 14.0px;\"><font size=\"4\"><font color=\"#414141\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-size: 14.0px;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"><span style=\"color: #666666;\"><span style=\"font-family: simsun;\">这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的女孩&mdash;&mdash;通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。<br> 可旋转表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的硅胶表带，戴上舒适又方便。<br> 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。<br> 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。</span></span></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></span></span></font></font></span></span></font></span></s\r\nan></font></span></span></font></span></span></span></span></font></span></font></span></font></font></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font></div><div><br><font size=\"4\"><font color=\"#414141\" face=\"宋体\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></font></font><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"><span style=\"font-family: microsoft yahei;\"><span><span style=\"font-size: 14.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\" size=\"3\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: 宋体;\"><font color=\"#555555\"><span style=\"font-family: 宋体;\"><span style=\"font-family: 宋体;\"><font color=\"#000000\" size=\"4\"></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></span></span></span></font></span></span></font></span></span></font></span></span></font></span></span></span></span></font></span></font></span></div><div></div><div></div><div></div><div style=\"text-align: center;\"><span style=\"display: none;\"></span><span style=\"font-family: verdana;\"></span></div><div><div style=\"text-align: center;\"><span style=\"color: #666666;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"><strong>想要试试吗？点击下面的按钮，快来感受一下定制的乐趣吧！<span style=\"display: none;\"></span></strong></span></span></span></div><div><span style=\"color: #b45f06;\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: kaiti_gb2312;\"><span style=\"color: #b45f06;\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: kaiti_gb2312;\"><span style=\"color: #990000;\"></span></span></span></span></span></span></span></div><div><span style=\"color: #b45f06;\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: kaiti_gb2312;\"><span style=\"color: #b45f06;\"><span style=\"font-size: 14.0px;\"><span style=\"font-family: kaiti_gb2312;\"><span style=\"color: #990000;\"></span></span></span></span></span></span></span></div><div></div></div><div></div><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\">喜爱运动的你，一定会喜欢这些个性十足的运动手表</font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: verdana;\">Color</span>/<font color=\"#000000\" face=\"微软雅黑\">绿色</font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 24.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: verdana;\">Color</span>/<font color=\"#000000\" face=\"微软雅黑\">蓝色</font></span></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 24.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: verdana;\">Color</span>/<font color=\"#000000\" face=\"微软雅黑\">橙色</font></span></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"></span></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: verdana;\">Color</span>/<font color=\"#000000\" face=\"微软雅黑\">黑</font><font color=\"#000000\" face=\"微软雅黑\">色</font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 24.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 24.0px;\"><font color=\"#000000\" face=\"微软雅黑\"></font></span></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\">可旋转表壳，带有分钟数字，可让孩子更好地学习认知时间</font><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\">后盖可激光雕刻你喜欢的祝福文字</span></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"></span></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"></span></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: microsoft yahei;\"></span></span></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\">不锈钢外壳</font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\">可供你选择多种颜色的硅胶表带，戴上舒适又方便</font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"><font color=\"#000000\" face=\"微软雅黑\" size=\"4\"></font></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"text-align: center;margin: 0.0cm 0.0cm 0.0pt;\"></p><p style=\"margin: 0.0cm 0.0cm 0.0pt;\"></p>'),(845,10,104,0,203,'个性定制手表,儿童手表'),(846,10,506,0,203,''),(847,10,531,0,203,''),(848,10,97,0,204,'  <div><font size=\"4\"><font color=\"#414141\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\" size=\"3\"><font color=\"#555555\"><font color=\"#000000\" size=\"4\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\" size=\"3\"><font color=\"#555555\"><font color=\"#000000\" size=\"4\"><font size=\"4\"><font color=\"#414141\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\" size=\"3\"><font color=\"#555555\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><font size=\"4\"><font color=\"#414141\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\"><font color=\"#555555\" size=\"3\"><font color=\"#555555\"><font color=\"#000000\" size=\"4\"><font color=\"#3f3f3f\"><font face=\"宋体\">这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。<br>\r\n圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。<br>\r\n本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。</font><br>\r\n<span style=\"font-family: 宋体;\"><span style=\"font-size: 18.0px;\"><span style=\"font-family: simsun;\"><span><span>怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。</span></span></span></span></span></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></font></div>\r\n<ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;44445-wat12101\">型号:&nbsp;44445-wat12101</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;男表\">手表种类:&nbsp;男表</li><li title=\"&nbsp;商务休闲\">手表风格:&nbsp;商务休闲</li><li title=\"&nbsp;真皮\">表带材质:&nbsp;真皮</li><li title=\"&nbsp;圆型\">表盘形状:&nbsp;圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;针扣\">表扣:&nbsp;针扣</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;其他\">元素:&nbsp;其他</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>'),(849,10,104,0,204,'个性定制手表,时尚男表'),(850,10,506,0,204,''),(851,10,531,0,204,''),(852,10,97,0,205,'  <ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;B6239-wat12001\">型号:&nbsp;B6239-wat12001</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;女表\">手表种类:&nbsp;女表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;合金\">表带材质:&nbsp;合金</li><li title=\"&nbsp;椭圆型\">表盘形状:&nbsp;椭圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;6mm\">表盘厚度:&nbsp;6mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;水钻\">元素:&nbsp;水钻</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul>  '),(853,10,104,0,205,'个性定制手表,时尚女表'),(854,10,506,0,205,''),(855,10,531,0,205,''),(856,10,97,0,206,' <div>\r\n <p>热爱户外运动的你，一定少不了这款个性挂表。</p>\r\n <p>和你一样，这款表也是自由不羁的，可以随意定制。</p>\r\n <p>只要把它挂在背包上，它就会跟随你的脚步，给你时间和方向。</p>\r\n <p>优质合金夜光针和指南针，让你即使在昏暗的野外，也能识别时间。</p>\r\n <p>即使一个人远行，有它一路上的陪伴，也一定不</p>\r\n</div> \r\n<ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;59009-wat11801\">型号:&nbsp;59009-wat11801</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;中性表\">手表种类:&nbsp;中性表</li><li title=\"&nbsp;户外运动\">手表风格:&nbsp;户外运动</li><li title=\"&nbsp;合金\">表带材质:&nbsp;合金</li><li title=\"&nbsp;圆型\">表盘形状:&nbsp;圆型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;合金\">表壳材质:&nbsp;合金</li>  </ul> '),(857,10,104,0,206,'个性定制手表,运动手表'),(858,10,506,0,206,''),(859,10,531,0,206,''),(864,10,97,0,208,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\"> 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。<br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">日本原装<span lang=\"EN-US\"></span>石英机芯</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>尺寸</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带20CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕围<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\">14～18CM<span lang=\"EN-US\"></span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>镜面<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">2.5CM</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>材质<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">表带:真皮 表壳:合金<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">约20g</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"></span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">生活防水</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br />\r\n  后盖:可以在表壳后盖刻字<br />\r\n  表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至5天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n\r\n</div>'),(865,10,104,0,208,'个性定制手表,时尚女表'),(866,10,506,0,208,''),(867,10,531,0,208,''),(868,10,97,0,209,'  <p>这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。</p>\r\n  <p>方形合金表壳，样式大方简洁，纯钢表带，精工制造，高贵中彰显气质。</p>\r\n  <p>本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。</p>\r\n  <p>怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。</p>\r\n<ul class=\"attributes-list\">    <li title=\"&nbsp;店铺保修\">保修:&nbsp;店铺保修</li><li title=\"&nbsp;宜乐生活\">品牌:&nbsp;宜乐生活</li><li title=\"&nbsp;400152-wat11201\">型号:&nbsp;400152-wat11201</li><li title=\"&nbsp;石英表\">机芯类型:&nbsp;石英表</li><li title=\"&nbsp;女表\">手表种类:&nbsp;女表</li><li title=\"&nbsp;潮流时尚\">手表风格:&nbsp;潮流时尚</li><li title=\"&nbsp;精钢\">表带材质:&nbsp;精钢</li><li title=\"&nbsp;方型\">表盘形状:&nbsp;方型</li><li title=\"&nbsp;指针\">显示类型:&nbsp;指针</li><li title=\"&nbsp;2012年\">推出时间:&nbsp;2012年</li><li title=\"&nbsp;全新\">成色:&nbsp;全新</li><li title=\"&nbsp;30米生活防水\">防水:&nbsp;30米生活防水</li><li title=\"&nbsp;普通\">表底:&nbsp;普通</li><li title=\"&nbsp;普通\">表冠:&nbsp;普通</li><li title=\"&nbsp;7mm\">表盘厚度:&nbsp;7mm</li><li title=\"&nbsp;32mm\">尺寸:&nbsp;32mm</li><li title=\"&nbsp;中国\">品牌产地:&nbsp;中国</li><li title=\"&nbsp;其他\">元素:&nbsp;其他</li><li title=\"&nbsp;精钢\">表壳材质:&nbsp;精钢</li>  </ul>'),(869,10,104,0,209,'个性定制手表,时尚女表'),(870,10,506,0,209,''),(871,10,531,0,209,''),(872,10,97,0,210,'<style type=\"text/css\">\r\n.title{font-size:16px; font-weight:bolder;}\r\n.title-2{font-size:14px; font-weight:bolder;}\r\n.hrc{ border:1px solid; height:0px;}\r\n.tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;}\r\n</style>\r\n\r\n<div class=\"msu\">\r\n<p style=\"margin: 0cm 0cm 0pt;\" class=\"MsoNormal\"><font color=\"#3f3f3f\" size=\"2\" face=\"宋体\"> 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的大男孩——通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 <br></font><span lang=\"EN-US\"><!--?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" /--><!--?xml:namespace prefix = o /-->\r\n<div class=\"product-dec\">  \r\n<p class=\"title\">产品特点：</p>\r\n<table class=\"tab-1\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td><p align=\"right\"><strong>表壳</strong><span lang=\"EN-US\"> </span></p></td>\r\n    <td bordercolor=\"#555555\"><p align=\"left\">合金 抛光 宽4.2cm</p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>后盖<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">不锈钢<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>表带<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">硅胶表带<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>表扣<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">不锈钢<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>机芯<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">3</span>指针日本原装机芯，电池可用两年<span lang=\"EN-US\"> </span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>防水<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">3 ATM 生活防水，不可配戴游泳、洗澡</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>长度<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">约25.4 cm</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>重量<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">约60g</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>腕长<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\">适合手腕<span lang=\"EN-US\">13.3cm</span>至<span lang=\"EN-US\">19.2cm</span></p></td>\r\n  </tr>\r\n  <tr>\r\n    <td><p align=\"right\"><strong>保质期<span lang=\"EN-US\"> </span></strong></p></td>\r\n    <td><p align=\"left\"><span lang=\"EN-US\">1</span>年</p></td>\r\n  </tr>\r\n</table>\r\n</div>\r\n<hr class=\"hrc\" />\r\n<div class=\"diy\">\r\n<p class=\"title\">定制详情：</p>\r\n<p class=\"title-2\">	定制特点：</p>\r\n<p>表盘：可上传你喜欢的图案或文字<br>\r\n  表壳：可选择不同颜色的表壳<br>\r\n后盖:可以在表壳后盖刻字<br>\r\n表带：可选择不同颜色的表带</p>\r\n<p>定制周期：3至7天；</p>\r\n<p>包装：可以选用包装盒。</p>\r\n</div>\r\n</div>'),(873,10,104,0,210,'个性定制手表,儿童手表'),(874,10,506,0,210,''),(875,10,531,0,210,'');
/*!40000 ALTER TABLE `catalog_product_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_entity_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_tier_price` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `all_groups` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `qty` decimal(12,4) NOT NULL DEFAULT '1.0000',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `website_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_CATALOG_PRODUCT_TIER_PRICE` (`entity_id`,`all_groups`,`customer_group_id`,`qty`,`website_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_TIER_PRICE_PRODUCT_ENTITY` (`entity_id`),
  KEY `FK_catalog_product_entity_tier_price_group` (`customer_group_id`),
  KEY `FK_CATALOG_PRODUCT_TIER_WEBSITE` (`website_id`),
  CONSTRAINT `FK_catalog_product_entity_tier_price_group` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_TIER_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PROD_ENTITY_TIER_PRICE_PROD_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_tier_price`
--

LOCK TABLES `catalog_product_entity_tier_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_tier_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_entity_tier_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_product_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_type_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `IDX_ATTRIBUTE_VALUE` (`entity_id`,`attribute_id`,`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_VARCHAR_STORE` (`store_id`),
  KEY `FK_CATALOG_PRODUCT_ENTITY_VARCHAR_PRODUCT_ENTITY` (`entity_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_ENTITY_VARCHAR_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PROD_ENTITY_VARCHAR_PROD_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5884 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_entity_varchar`
--

LOCK TABLES `catalog_product_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_varchar` VALUES (2022,10,96,0,188,'个性定制心形手链时装表'),(2023,10,103,0,188,''),(2024,10,105,0,188,''),(2025,10,106,0,188,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg'),(2026,10,109,0,188,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg'),(2027,10,481,0,188,'tb-16888172712'),(2028,10,493,0,188,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg'),(2029,10,562,0,188,'0'),(2030,10,570,0,188,'tb-16888172712.html'),(2031,10,836,0,188,'container2'),(2032,10,879,0,188,''),(2033,10,880,0,188,''),(2034,10,881,0,188,''),(2035,10,929,0,188,''),(2036,10,950,0,188,'1181'),(2037,10,951,0,188,'130'),(2038,10,953,0,188,'169'),(2039,10,96,0,189,'经典定制儿童公主手表'),(2040,10,103,0,189,''),(2041,10,105,0,189,''),(2042,10,106,0,189,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg'),(2043,10,109,0,189,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg'),(2044,10,481,0,189,'tb-16746748453'),(2045,10,493,0,189,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg'),(2046,10,562,0,189,'0'),(2047,10,570,0,189,'tb-16746748453.html'),(2048,10,836,0,189,'container2'),(2049,10,879,0,189,''),(2050,10,880,0,189,''),(2051,10,881,0,189,''),(2052,10,929,0,189,''),(2053,10,950,0,189,'1172'),(2054,10,951,0,189,'130'),(2055,10,953,0,189,'169'),(2056,10,96,0,190,'个性定制手表-男款'),(2057,10,103,0,190,''),(2058,10,105,0,190,''),(2059,10,106,0,190,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg'),(2060,10,109,0,190,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg'),(2061,10,481,0,190,'tb-15173227048'),(2062,10,493,0,190,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg'),(2063,10,562,0,190,'0'),(2064,10,570,0,190,'tb-15173227048.html'),(2065,10,836,0,190,'container2'),(2066,10,879,0,190,''),(2067,10,880,0,190,''),(2068,10,881,0,190,''),(2069,10,929,0,190,''),(2070,10,950,0,190,'1165'),(2071,10,951,0,190,'130'),(2072,10,953,0,190,'169'),(2073,10,96,0,191,'个性定制男款运动手表'),(2074,10,103,0,191,''),(2075,10,105,0,191,''),(2076,10,106,0,191,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg'),(2077,10,109,0,191,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg'),(2078,10,481,0,191,'tb-15167871086'),(2079,10,493,0,191,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg'),(2080,10,562,0,191,'0'),(2081,10,570,0,191,'tb-15167871086.html'),(2082,10,836,0,191,'container2'),(2083,10,879,0,191,''),(2084,10,880,0,191,''),(2085,10,881,0,191,''),(2086,10,929,0,191,''),(2087,10,950,0,191,'1173'),(2088,10,951,0,191,'130'),(2089,10,953,0,191,'169'),(2090,10,96,0,192,'个性定制时装潮流女表'),(2091,10,103,0,192,''),(2092,10,105,0,192,''),(2093,10,106,0,192,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg'),(2094,10,109,0,192,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg'),(2095,10,481,0,192,'tb-14491898841'),(2096,10,493,0,192,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg'),(2097,10,562,0,192,'0'),(2098,10,570,0,192,'tb-14491898841.html'),(2099,10,836,0,192,'container2'),(2100,10,879,0,192,''),(2101,10,880,0,192,''),(2102,10,881,0,192,''),(2103,10,929,0,192,''),(2104,10,950,0,192,'1200'),(2105,10,951,0,192,'130'),(2106,10,953,0,192,'169'),(2107,10,96,0,193,'定制公主水晶石儿童表'),(2108,10,103,0,193,''),(2109,10,105,0,193,''),(2110,10,106,0,193,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg'),(2111,10,109,0,193,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg'),(2112,10,481,0,193,'tb-14420097483'),(2113,10,493,0,193,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg'),(2114,10,562,0,193,'0'),(2115,10,570,0,193,'tb-14420097483.html'),(2116,10,836,0,193,'container2'),(2117,10,879,0,193,''),(2118,10,880,0,193,''),(2119,10,881,0,193,''),(2120,10,929,0,193,''),(2121,10,950,0,193,'1171'),(2122,10,951,0,193,'130'),(2123,10,953,0,193,'169'),(2124,10,96,0,194,'个性定制时装女表'),(2125,10,103,0,194,''),(2126,10,105,0,194,''),(2127,10,106,0,194,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg'),(2128,10,109,0,194,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg'),(2129,10,481,0,194,'tb-16950456931'),(2130,10,493,0,194,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg'),(2131,10,562,0,194,'0'),(2132,10,570,0,194,'tb-16950456931.html'),(2133,10,836,0,194,'container2'),(2134,10,879,0,194,''),(2135,10,880,0,194,''),(2136,10,881,0,194,''),(2137,10,929,0,194,''),(2138,10,950,0,194,'1189'),(2139,10,951,0,194,'130'),(2140,10,953,0,194,'169'),(2141,10,96,0,195,'个性时间认知儿童表'),(2142,10,103,0,195,''),(2143,10,105,0,195,''),(2144,10,106,0,195,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg'),(2145,10,109,0,195,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg'),(2146,10,481,0,195,'tb-16916368211'),(2147,10,493,0,195,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg'),(2148,10,562,0,195,'0'),(2149,10,570,0,195,'tb-16916368211.html'),(2150,10,836,0,195,'container2'),(2151,10,879,0,195,''),(2152,10,880,0,195,''),(2153,10,881,0,195,''),(2154,10,929,0,195,''),(2155,10,950,0,195,'1175'),(2156,10,951,0,195,'130'),(2157,10,953,0,195,'169'),(2163,10,96,0,196,'早教儿童认知时间手表'),(2164,10,103,0,196,''),(2165,10,105,0,196,''),(2166,10,106,0,196,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg'),(2167,10,109,0,196,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg'),(2168,10,481,0,196,'tb-16769128988'),(2169,10,493,0,196,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg'),(2170,10,562,0,196,'0'),(2171,10,570,0,196,'tb-16769128988.html'),(2172,10,836,0,196,'container2'),(2173,10,879,0,196,''),(2174,10,880,0,196,''),(2175,10,881,0,196,''),(2176,10,929,0,196,''),(2177,10,950,0,196,'1180'),(2178,10,951,0,196,'130'),(2179,10,953,0,196,'169'),(2180,10,96,0,197,'个性创意时尚镶钻表'),(2181,10,103,0,197,''),(2182,10,105,0,197,''),(2183,10,106,0,197,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg'),(2184,10,109,0,197,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg'),(2185,10,481,0,197,'tb-15248759961'),(2186,10,493,0,197,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg'),(2187,10,562,0,197,'0'),(2188,10,570,0,197,'tb-15248759961.html'),(2189,10,836,0,197,'container2'),(2190,10,879,0,197,''),(2191,10,880,0,197,''),(2192,10,881,0,197,''),(2193,10,929,0,197,''),(2194,10,950,0,197,'1186'),(2195,10,951,0,197,''),(2196,10,953,0,197,'169'),(2197,10,96,0,198,'个性定制时尚男表'),(2198,10,103,0,198,''),(2199,10,105,0,198,''),(2200,10,106,0,198,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg'),(2201,10,109,0,198,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg'),(2202,10,481,0,198,'tb-15238419360'),(2203,10,493,0,198,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg'),(2204,10,562,0,198,'0'),(2205,10,570,0,198,'tb-15238419360.html'),(2206,10,836,0,198,'container2'),(2207,10,879,0,198,''),(2208,10,880,0,198,''),(2209,10,881,0,198,''),(2210,10,929,0,198,''),(2211,10,950,0,198,'1159'),(2212,10,951,0,198,'134'),(2213,10,953,0,198,'169'),(2214,10,96,0,199,'个性定制时尚女表'),(2215,10,103,0,199,''),(2216,10,105,0,199,''),(2217,10,106,0,199,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg'),(2218,10,109,0,199,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg'),(2219,10,481,0,199,'tb-15237839452'),(2220,10,493,0,199,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg'),(2221,10,562,0,199,'0'),(2222,10,570,0,199,'tb-15237839452.html'),(2223,10,836,0,199,'container2'),(2224,10,879,0,199,''),(2225,10,880,0,199,''),(2226,10,881,0,199,''),(2227,10,929,0,199,''),(2228,10,950,0,199,'1166'),(2229,10,951,0,199,''),(2230,10,953,0,199,'169'),(2231,10,96,0,200,'时尚潮流女性商务手表'),(2232,10,103,0,200,''),(2233,10,105,0,200,''),(2234,10,106,0,200,'/t/1/t1zni_xjnjxxcmjko__111747.jpg'),(2235,10,109,0,200,'/t/1/t1zni_xjnjxxcmjko__111747.jpg'),(2236,10,481,0,200,'tb-15232587893'),(2237,10,493,0,200,'/t/1/t1zni_xjnjxxcmjko__111747.jpg'),(2238,10,562,0,200,'0'),(2239,10,570,0,200,'tb-15232587893.html'),(2240,10,836,0,200,'container2'),(2241,10,879,0,200,''),(2242,10,880,0,200,''),(2243,10,881,0,200,''),(2244,10,929,0,200,''),(2245,10,950,0,200,'1178'),(2246,10,951,0,200,''),(2247,10,953,0,200,'169'),(2248,10,96,0,201,'个性定制复古经典女童手表'),(2249,10,103,0,201,''),(2250,10,105,0,201,''),(2251,10,106,0,201,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg'),(2252,10,109,0,201,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg'),(2253,10,481,0,201,'tb-15176883730'),(2254,10,493,0,201,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg'),(2255,10,562,0,201,'0'),(2256,10,570,0,201,'tb-15176883730.html'),(2257,10,836,0,201,'container2'),(2258,10,879,0,201,''),(2259,10,880,0,201,''),(2260,10,881,0,201,''),(2261,10,929,0,201,''),(2262,10,950,0,201,'1174'),(2263,10,951,0,201,'130'),(2264,10,953,0,201,'169'),(2265,10,96,0,202,'个性刻字定制男钢表'),(2266,10,103,0,202,''),(2267,10,105,0,202,''),(2268,10,106,0,202,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg'),(2269,10,109,0,202,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg'),(2270,10,481,0,202,'tb-14501358291'),(2271,10,493,0,202,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg'),(2272,10,562,0,202,'0'),(2273,10,570,0,202,'tb-14501358291.html'),(2274,10,836,0,202,'container2'),(2275,10,879,0,202,''),(2276,10,880,0,202,''),(2277,10,881,0,202,''),(2278,10,929,0,202,''),(2279,10,950,0,202,'1201'),(2280,10,951,0,202,'134'),(2281,10,953,0,202,'169'),(2282,10,96,0,203,'个性定制儿童运动女表'),(2283,10,103,0,203,''),(2284,10,105,0,203,''),(2285,10,106,0,203,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg'),(2286,10,109,0,203,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg'),(2287,10,481,0,203,'tb-14483017901'),(2288,10,493,0,203,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg'),(2289,10,562,0,203,'0'),(2290,10,570,0,203,'tb-14483017901.html'),(2291,10,836,0,203,'container2'),(2292,10,879,0,203,''),(2293,10,880,0,203,''),(2294,10,881,0,203,''),(2295,10,929,0,203,''),(2296,10,950,0,203,'1199'),(2297,10,951,0,203,'130'),(2298,10,953,0,203,'169'),(2299,10,96,0,204,'个性定制男表'),(2300,10,103,0,204,''),(2301,10,105,0,204,''),(2302,10,106,0,204,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg'),(2303,10,109,0,204,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg'),(2304,10,481,0,204,'tb-14480890920'),(2305,10,493,0,204,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg'),(2306,10,562,0,204,'0'),(2307,10,570,0,204,'tb-14480890920.html'),(2308,10,836,0,204,'container2'),(2309,10,879,0,204,''),(2310,10,880,0,204,''),(2311,10,881,0,204,''),(2312,10,929,0,204,''),(2313,10,950,0,204,'1192'),(2314,10,951,0,204,'134'),(2315,10,953,0,204,'169'),(2316,10,96,0,205,'个性定制时尚潮流镶钻女表'),(2317,10,103,0,205,''),(2318,10,105,0,205,''),(2319,10,106,0,205,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg'),(2320,10,109,0,205,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg'),(2321,10,481,0,205,'tb-14470362811'),(2322,10,493,0,205,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg'),(2323,10,562,0,205,'0'),(2324,10,570,0,205,'tb-14470362811.html'),(2325,10,836,0,205,'container2'),(2326,10,879,0,205,''),(2327,10,880,0,205,''),(2328,10,881,0,205,''),(2329,10,929,0,205,''),(2330,10,950,0,205,'1188'),(2331,10,951,0,205,'130'),(2332,10,953,0,205,'169'),(2333,10,96,0,206,'定制户外运动挂表 '),(2334,10,103,0,206,''),(2335,10,105,0,206,''),(2336,10,106,0,206,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg'),(2337,10,109,0,206,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg'),(2338,10,481,0,206,'tb-14469030397'),(2339,10,493,0,206,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg'),(2340,10,562,0,206,'0'),(2341,10,570,0,206,'tb-14469030397.html'),(2342,10,836,0,206,'container2'),(2343,10,879,0,206,''),(2344,10,880,0,206,''),(2345,10,881,0,206,''),(2346,10,929,0,206,''),(2347,10,950,0,206,'1161'),(2348,10,951,0,206,'134'),(2349,10,953,0,206,'169'),(2367,10,96,0,208,'经典定制女表'),(2368,10,103,0,208,''),(2369,10,105,0,208,''),(2370,10,106,0,208,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg'),(2371,10,109,0,208,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg'),(2372,10,481,0,208,'tb-14450913511'),(2373,10,493,0,208,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg'),(2374,10,562,0,208,'0'),(2375,10,570,0,208,'tb-14450913511.html'),(2376,10,836,0,208,'container2'),(2377,10,879,0,208,''),(2378,10,880,0,208,''),(2379,10,881,0,208,''),(2380,10,929,0,208,''),(2381,10,950,0,208,'1004'),(2382,10,951,0,208,'130'),(2383,10,953,0,208,'169'),(2384,10,96,0,209,'个性创意时尚女钢表'),(2385,10,103,0,209,''),(2386,10,105,0,209,''),(2387,10,106,0,209,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg'),(2388,10,109,0,209,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg'),(2389,10,481,0,209,'tb-14425318838'),(2390,10,493,0,209,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg'),(2391,10,562,0,209,'0'),(2392,10,570,0,209,'tb-14425318838.html'),(2393,10,836,0,209,'container2'),(2394,10,879,0,209,''),(2395,10,880,0,209,''),(2396,10,881,0,209,''),(2397,10,929,0,209,''),(2398,10,950,0,209,'1179'),(2399,10,951,0,209,'130'),(2400,10,953,0,209,'169'),(2401,10,96,0,210,'卡通风个性男款儿童手表'),(2402,10,103,0,210,''),(2403,10,105,0,210,''),(2404,10,106,0,210,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg'),(2405,10,109,0,210,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg'),(2406,10,481,0,210,'tb-10220121642'),(2407,10,493,0,210,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg'),(2408,10,562,0,210,'0'),(2409,10,570,0,210,'tb-10220121642.html'),(2410,10,836,0,210,'container2'),(2411,10,879,0,210,''),(2412,10,880,0,210,''),(2413,10,881,0,210,''),(2414,10,929,0,210,''),(2415,10,950,0,210,'999'),(2416,10,951,0,210,'130'),(2417,10,953,0,210,'169'),(2418,10,570,1,188,'tb-16888172712.html'),(2419,10,570,1,189,'tb-16746748453.html'),(2420,10,570,1,190,'tb-15173227048.html'),(2421,10,570,1,191,'tb-15167871086.html'),(2422,10,570,1,192,'tb-14491898841.html'),(2423,10,570,1,193,'tb-14420097483.html'),(2424,10,570,1,194,'tb-16950456931.html'),(2425,10,570,1,195,'tb-16916368211.html'),(2426,10,570,1,196,'tb-16769128988.html'),(2427,10,570,1,197,'tb-15248759961.html'),(2428,10,570,1,198,'tb-15238419360.html'),(2429,10,570,1,199,'tb-15237839452.html'),(2430,10,570,1,200,'tb-15232587893.html'),(2431,10,570,1,201,'tb-15176883730.html'),(2432,10,570,1,202,'tb-14501358291.html'),(2433,10,570,1,203,'tb-14483017901.html'),(2434,10,570,1,204,'tb-14480890920.html'),(2435,10,570,1,205,'tb-14470362811.html'),(2436,10,570,1,206,'tb-14469030397.html'),(2438,10,570,1,208,'tb-14450913511.html'),(2439,10,570,1,209,'tb-14425318838.html'),(2440,10,570,1,210,'tb-10220121642.html'),(5778,10,571,0,188,''),(5783,10,571,0,189,''),(5788,10,571,0,190,''),(5793,10,571,0,191,''),(5798,10,571,0,192,''),(5803,10,571,0,193,''),(5808,10,571,0,194,''),(5813,10,571,0,195,''),(5818,10,571,0,196,''),(5823,10,571,0,197,''),(5828,10,571,0,198,''),(5833,10,571,0,199,''),(5838,10,571,0,200,''),(5843,10,571,0,201,''),(5848,10,571,0,202,''),(5853,10,571,0,203,''),(5858,10,571,0,204,''),(5863,10,571,0,205,''),(5868,10,571,0,206,''),(5873,10,571,0,208,''),(5878,10,571,0,209,''),(5883,10,571,0,210,'');
/*!40000 ALTER TABLE `catalog_product_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_1`
--

DROP TABLE IF EXISTS `catalog_product_flat_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_1` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple',
  `cost` decimal(12,4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enable_googlecheckout` tinyint(1) DEFAULT NULL,
  `gift_message_available` tinyint(1) DEFAULT NULL,
  `has_options` smallint(6) NOT NULL DEFAULT '0',
  `image_label` varchar(255) DEFAULT NULL,
  `is_imported` tinyint(1) DEFAULT NULL,
  `is_recurring` tinyint(1) DEFAULT NULL,
  `links_exist` int(11) DEFAULT NULL,
  `links_purchased_separately` int(11) DEFAULT NULL,
  `links_title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `news_from_date` datetime DEFAULT NULL,
  `news_to_date` datetime DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `price_type` int(11) DEFAULT NULL,
  `price_view` int(11) DEFAULT NULL,
  `recurring_profile` text,
  `required_options` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `shipment_type` int(11) DEFAULT NULL,
  `short_description` text,
  `sku` varchar(64) DEFAULT NULL,
  `sku_type` int(11) DEFAULT NULL,
  `small_image` varchar(255) DEFAULT NULL,
  `small_image_label` varchar(255) DEFAULT NULL,
  `special_from_date` datetime DEFAULT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `special_to_date` datetime DEFAULT NULL,
  `tax_class_id` int(11) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `thumbnail_label` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url_key` varchar(255) DEFAULT NULL,
  `url_path` varchar(255) DEFAULT NULL,
  `visibility` tinyint(3) unsigned DEFAULT NULL,
  `weight` decimal(12,4) DEFAULT NULL,
  `weight_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_id`),
  KEY `IDX_TYPE_ID` (`type_id`),
  KEY `IDX_ATRRIBUTE_SET` (`attribute_set_id`),
  KEY `IDX_NAME` (`name`),
  KEY `IDX_PRICE` (`price`),
  CONSTRAINT `FK_CATALOG_PRODUCT_FLAT_1_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_1`
--

LOCK TABLES `catalog_product_flat_1` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_1` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_1` VALUES (188,63,'simple',NULL,'2012-06-21 09:37:40',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制心形手链时装表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-16888172712',NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','','2012-07-12 02:29:24','tb-16888172712','tb-16888172712.html',4,0.8000,NULL),(189,63,'simple',NULL,'2012-06-21 09:37:41',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制儿童公主手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16746748453',NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','','2012-07-12 02:31:20','tb-16746748453','tb-16746748453.html',4,0.8000,NULL),(190,63,'simple',NULL,'2012-06-21 09:37:43',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制手表-男款',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15173227048',NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','','2012-07-12 02:34:45','tb-15173227048','tb-15173227048.html',4,0.8000,NULL),(191,63,'simple',NULL,'2012-06-21 09:37:45',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男款运动手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15167871086',NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','','2012-07-12 02:38:12','tb-15167871086','tb-15167871086.html',4,0.8000,NULL),(192,63,'simple',NULL,'2012-06-21 09:37:47',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装潮流女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14491898841',NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','','2012-07-12 02:40:01','tb-14491898841','tb-14491898841.html',4,0.8000,NULL),(193,63,'simple',NULL,'2012-06-21 09:37:49',1,0,0,'',0,0,NULL,NULL,NULL,'定制公主水晶石儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14420097483',NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','','2012-07-12 02:41:31','tb-14420097483','tb-14420097483.html',4,0.8000,NULL),(194,63,'simple',NULL,'2012-06-21 09:37:50',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-16950456931',NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','','2012-07-12 02:42:40','tb-16950456931','tb-16950456931.html',4,0.8000,NULL),(195,63,'simple',NULL,'2012-06-21 09:37:52',1,0,0,'',0,0,NULL,NULL,NULL,'个性时间认知儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16916368211',NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','','2012-07-12 02:45:51','tb-16916368211','tb-16916368211.html',4,0.8000,NULL),(196,63,'simple',NULL,'2012-06-21 09:37:55',1,0,0,'',0,0,NULL,NULL,NULL,'早教儿童认知时间手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16769128988',NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','','2012-07-12 02:47:51','tb-16769128988','tb-16769128988.html',4,0.8000,NULL),(197,63,'simple',NULL,'2012-06-21 09:37:57',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚镶钻表',NULL,NULL,428.0000,NULL,NULL,NULL,0,NULL,'','tb-15248759961',NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','','2012-07-12 02:52:31','tb-15248759961','tb-15248759961.html',4,0.8000,NULL),(198,63,'simple',NULL,'2012-06-21 09:37:59',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚男表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15238419360',NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','','2012-07-12 02:55:21','tb-15238419360','tb-15238419360.html',4,0.8000,NULL),(199,63,'simple',NULL,'2012-06-21 09:38:01',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15237839452',NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','','2012-07-12 02:57:48','tb-15237839452','tb-15237839452.html',4,0.8000,NULL),(200,63,'simple',NULL,'2012-06-21 09:38:03',1,0,0,'',0,0,NULL,NULL,NULL,'时尚潮流女性商务手表',NULL,NULL,488.0000,NULL,NULL,NULL,0,NULL,'','tb-15232587893',NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','','2012-07-12 03:00:55','tb-15232587893','tb-15232587893.html',4,0.8000,NULL),(201,63,'simple',NULL,'2012-06-21 09:38:04',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制复古经典女童手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15176883730',NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','','2012-07-12 03:02:56','tb-15176883730','tb-15176883730.html',4,0.8000,NULL),(202,63,'simple',NULL,'2012-06-21 09:38:06',1,0,0,'',0,0,NULL,NULL,NULL,'个性刻字定制男钢表',NULL,NULL,518.0000,NULL,NULL,NULL,0,NULL,'','tb-14501358291',NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','','2012-07-12 03:05:04','tb-14501358291','tb-14501358291.html',4,0.8000,NULL),(203,63,'simple',NULL,'2012-06-21 09:38:08',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制儿童运动女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14483017901',NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','','2012-07-12 03:08:09','tb-14483017901','tb-14483017901.html',4,0.8000,NULL),(204,63,'simple',NULL,'2012-06-21 09:38:10',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14480890920',NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','','2012-07-12 03:10:32','tb-14480890920','tb-14480890920.html',4,0.8000,NULL),(205,63,'simple',NULL,'2012-06-21 09:38:11',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚潮流镶钻女表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14470362811',NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','','2012-07-12 03:13:21','tb-14470362811','tb-14470362811.html',4,0.8000,NULL),(206,63,'simple',NULL,'2012-06-21 09:38:13',1,0,0,'',0,0,NULL,NULL,NULL,'定制户外运动挂表 ',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-14469030397',NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','','2012-07-12 03:14:29','tb-14469030397','tb-14469030397.html',4,0.8000,NULL),(208,63,'simple',NULL,'2012-06-21 09:38:17',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14450913511',NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','','2012-07-12 03:17:08','tb-14450913511','tb-14450913511.html',4,0.8000,NULL),(209,63,'simple',NULL,'2012-06-21 09:38:19',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚女钢表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14425318838',NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','','2012-07-12 03:18:16','tb-14425318838','tb-14425318838.html',4,0.8000,NULL),(210,63,'simple',NULL,'2012-06-21 09:38:21',1,0,0,'',0,0,NULL,NULL,NULL,'卡通风个性男款儿童手表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-10220121642',NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','','2012-07-12 03:19:44','tb-10220121642','tb-10220121642.html',4,0.8000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_2`
--

DROP TABLE IF EXISTS `catalog_product_flat_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_2` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple',
  `cost` decimal(12,4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enable_googlecheckout` tinyint(1) DEFAULT NULL,
  `gift_message_available` tinyint(1) DEFAULT NULL,
  `has_options` smallint(6) NOT NULL DEFAULT '0',
  `image_label` varchar(255) DEFAULT NULL,
  `is_imported` tinyint(1) DEFAULT NULL,
  `is_recurring` tinyint(1) DEFAULT NULL,
  `links_exist` int(11) DEFAULT NULL,
  `links_purchased_separately` int(11) DEFAULT NULL,
  `links_title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `news_from_date` datetime DEFAULT NULL,
  `news_to_date` datetime DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `price_type` int(11) DEFAULT NULL,
  `price_view` int(11) DEFAULT NULL,
  `recurring_profile` text,
  `required_options` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `shipment_type` int(11) DEFAULT NULL,
  `short_description` text,
  `sku` varchar(64) DEFAULT NULL,
  `sku_type` int(11) DEFAULT NULL,
  `small_image` varchar(255) DEFAULT NULL,
  `small_image_label` varchar(255) DEFAULT NULL,
  `special_from_date` datetime DEFAULT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `special_to_date` datetime DEFAULT NULL,
  `tax_class_id` int(11) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `thumbnail_label` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url_key` varchar(255) DEFAULT NULL,
  `url_path` varchar(255) DEFAULT NULL,
  `visibility` tinyint(3) unsigned DEFAULT NULL,
  `weight` decimal(12,4) DEFAULT NULL,
  `weight_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_id`),
  KEY `IDX_TYPE_ID` (`type_id`),
  KEY `IDX_ATRRIBUTE_SET` (`attribute_set_id`),
  KEY `IDX_NAME` (`name`),
  KEY `IDX_PRICE` (`price`),
  CONSTRAINT `FK_CATALOG_PRODUCT_FLAT_2_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_2`
--

LOCK TABLES `catalog_product_flat_2` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_2` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_2` VALUES (188,63,'simple',NULL,'2012-06-21 09:37:40',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制心形手链时装表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-16888172712',NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','','2012-07-12 02:29:24','tb-16888172712','tb-16888172712.html',4,0.8000,NULL),(189,63,'simple',NULL,'2012-06-21 09:37:41',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制儿童公主手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16746748453',NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','','2012-07-12 02:31:20','tb-16746748453','tb-16746748453.html',4,0.8000,NULL),(190,63,'simple',NULL,'2012-06-21 09:37:43',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制手表-男款',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15173227048',NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','','2012-07-12 02:34:45','tb-15173227048','tb-15173227048.html',4,0.8000,NULL),(191,63,'simple',NULL,'2012-06-21 09:37:45',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男款运动手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15167871086',NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','','2012-07-12 02:38:12','tb-15167871086','tb-15167871086.html',4,0.8000,NULL),(192,63,'simple',NULL,'2012-06-21 09:37:47',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装潮流女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14491898841',NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','','2012-07-12 02:40:01','tb-14491898841','tb-14491898841.html',4,0.8000,NULL),(193,63,'simple',NULL,'2012-06-21 09:37:49',1,0,0,'',0,0,NULL,NULL,NULL,'定制公主水晶石儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14420097483',NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','','2012-07-12 02:41:31','tb-14420097483','tb-14420097483.html',4,0.8000,NULL),(194,63,'simple',NULL,'2012-06-21 09:37:50',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-16950456931',NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','','2012-07-12 02:42:40','tb-16950456931','tb-16950456931.html',4,0.8000,NULL),(195,63,'simple',NULL,'2012-06-21 09:37:52',1,0,0,'',0,0,NULL,NULL,NULL,'个性时间认知儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16916368211',NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','','2012-07-12 02:45:51','tb-16916368211','tb-16916368211.html',4,0.8000,NULL),(196,63,'simple',NULL,'2012-06-21 09:37:55',1,0,0,'',0,0,NULL,NULL,NULL,'早教儿童认知时间手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16769128988',NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','','2012-07-12 02:47:51','tb-16769128988','tb-16769128988.html',4,0.8000,NULL),(197,63,'simple',NULL,'2012-06-21 09:37:57',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚镶钻表',NULL,NULL,428.0000,NULL,NULL,NULL,0,NULL,'','tb-15248759961',NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','','2012-07-12 02:52:31','tb-15248759961','tb-15248759961.html',4,0.8000,NULL),(198,63,'simple',NULL,'2012-06-21 09:37:59',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚男表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15238419360',NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','','2012-07-12 02:55:21','tb-15238419360','tb-15238419360.html',4,0.8000,NULL),(199,63,'simple',NULL,'2012-06-21 09:38:01',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15237839452',NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','','2012-07-12 02:57:48','tb-15237839452','tb-15237839452.html',4,0.8000,NULL),(200,63,'simple',NULL,'2012-06-21 09:38:03',1,0,0,'',0,0,NULL,NULL,NULL,'时尚潮流女性商务手表',NULL,NULL,488.0000,NULL,NULL,NULL,0,NULL,'','tb-15232587893',NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','','2012-07-12 03:00:55','tb-15232587893','tb-15232587893.html',4,0.8000,NULL),(201,63,'simple',NULL,'2012-06-21 09:38:04',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制复古经典女童手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15176883730',NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','','2012-07-12 03:02:56','tb-15176883730','tb-15176883730.html',4,0.8000,NULL),(202,63,'simple',NULL,'2012-06-21 09:38:06',1,0,0,'',0,0,NULL,NULL,NULL,'个性刻字定制男钢表',NULL,NULL,518.0000,NULL,NULL,NULL,0,NULL,'','tb-14501358291',NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','','2012-07-12 03:05:04','tb-14501358291','tb-14501358291.html',4,0.8000,NULL),(203,63,'simple',NULL,'2012-06-21 09:38:08',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制儿童运动女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14483017901',NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','','2012-07-12 03:08:09','tb-14483017901','tb-14483017901.html',4,0.8000,NULL),(204,63,'simple',NULL,'2012-06-21 09:38:10',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14480890920',NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','','2012-07-12 03:10:32','tb-14480890920','tb-14480890920.html',4,0.8000,NULL),(205,63,'simple',NULL,'2012-06-21 09:38:11',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚潮流镶钻女表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14470362811',NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','','2012-07-12 03:13:21','tb-14470362811','tb-14470362811.html',4,0.8000,NULL),(206,63,'simple',NULL,'2012-06-21 09:38:13',1,0,0,'',0,0,NULL,NULL,NULL,'定制户外运动挂表 ',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-14469030397',NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','','2012-07-12 03:14:29','tb-14469030397','tb-14469030397.html',4,0.8000,NULL),(208,63,'simple',NULL,'2012-06-21 09:38:17',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14450913511',NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','','2012-07-12 03:17:08','tb-14450913511','tb-14450913511.html',4,0.8000,NULL),(209,63,'simple',NULL,'2012-06-21 09:38:19',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚女钢表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14425318838',NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','','2012-07-12 03:18:16','tb-14425318838','tb-14425318838.html',4,0.8000,NULL),(210,63,'simple',NULL,'2012-06-21 09:38:21',1,0,0,'',0,0,NULL,NULL,NULL,'卡通风个性男款儿童手表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-10220121642',NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','','2012-07-12 03:19:44','tb-10220121642','tb-10220121642.html',4,0.8000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_3`
--

DROP TABLE IF EXISTS `catalog_product_flat_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_3` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple',
  `cost` decimal(12,4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enable_googlecheckout` tinyint(1) DEFAULT NULL,
  `gift_message_available` tinyint(1) DEFAULT NULL,
  `has_options` smallint(6) NOT NULL DEFAULT '0',
  `image_label` varchar(255) DEFAULT NULL,
  `is_imported` tinyint(1) DEFAULT NULL,
  `is_recurring` tinyint(1) DEFAULT NULL,
  `links_exist` int(11) DEFAULT NULL,
  `links_purchased_separately` int(11) DEFAULT NULL,
  `links_title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `news_from_date` datetime DEFAULT NULL,
  `news_to_date` datetime DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `price_type` int(11) DEFAULT NULL,
  `price_view` int(11) DEFAULT NULL,
  `recurring_profile` text,
  `required_options` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `shipment_type` int(11) DEFAULT NULL,
  `short_description` text,
  `sku` varchar(64) DEFAULT NULL,
  `sku_type` int(11) DEFAULT NULL,
  `small_image` varchar(255) DEFAULT NULL,
  `small_image_label` varchar(255) DEFAULT NULL,
  `special_from_date` datetime DEFAULT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `special_to_date` datetime DEFAULT NULL,
  `tax_class_id` int(11) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `thumbnail_label` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url_key` varchar(255) DEFAULT NULL,
  `url_path` varchar(255) DEFAULT NULL,
  `visibility` tinyint(3) unsigned DEFAULT NULL,
  `weight` decimal(12,4) DEFAULT NULL,
  `weight_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_id`),
  KEY `IDX_TYPE_ID` (`type_id`),
  KEY `IDX_ATRRIBUTE_SET` (`attribute_set_id`),
  KEY `IDX_NAME` (`name`),
  KEY `IDX_PRICE` (`price`),
  CONSTRAINT `FK_CATALOG_PRODUCT_FLAT_3_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_3`
--

LOCK TABLES `catalog_product_flat_3` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_3` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_3` VALUES (188,63,'simple',NULL,'2012-06-21 09:37:40',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制心形手链时装表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-16888172712',NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','','2012-07-12 02:29:24','tb-16888172712','tb-16888172712.html',4,0.8000,NULL),(189,63,'simple',NULL,'2012-06-21 09:37:41',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制儿童公主手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16746748453',NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','','2012-07-12 02:31:20','tb-16746748453','tb-16746748453.html',4,0.8000,NULL),(190,63,'simple',NULL,'2012-06-21 09:37:43',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制手表-男款',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15173227048',NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','','2012-07-12 02:34:45','tb-15173227048','tb-15173227048.html',4,0.8000,NULL),(191,63,'simple',NULL,'2012-06-21 09:37:45',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男款运动手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15167871086',NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','','2012-07-12 02:38:12','tb-15167871086','tb-15167871086.html',4,0.8000,NULL),(192,63,'simple',NULL,'2012-06-21 09:37:47',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装潮流女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14491898841',NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','','2012-07-12 02:40:01','tb-14491898841','tb-14491898841.html',4,0.8000,NULL),(193,63,'simple',NULL,'2012-06-21 09:37:49',1,0,0,'',0,0,NULL,NULL,NULL,'定制公主水晶石儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14420097483',NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','','2012-07-12 02:41:31','tb-14420097483','tb-14420097483.html',4,0.8000,NULL),(194,63,'simple',NULL,'2012-06-21 09:37:50',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-16950456931',NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','','2012-07-12 02:42:40','tb-16950456931','tb-16950456931.html',4,0.8000,NULL),(195,63,'simple',NULL,'2012-06-21 09:37:52',1,0,0,'',0,0,NULL,NULL,NULL,'个性时间认知儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16916368211',NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','','2012-07-12 02:45:51','tb-16916368211','tb-16916368211.html',4,0.8000,NULL),(196,63,'simple',NULL,'2012-06-21 09:37:55',1,0,0,'',0,0,NULL,NULL,NULL,'早教儿童认知时间手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16769128988',NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','','2012-07-12 02:47:51','tb-16769128988','tb-16769128988.html',4,0.8000,NULL),(197,63,'simple',NULL,'2012-06-21 09:37:57',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚镶钻表',NULL,NULL,428.0000,NULL,NULL,NULL,0,NULL,'','tb-15248759961',NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','','2012-07-12 02:52:31','tb-15248759961','tb-15248759961.html',4,0.8000,NULL),(198,63,'simple',NULL,'2012-06-21 09:37:59',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚男表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15238419360',NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','','2012-07-12 02:55:21','tb-15238419360','tb-15238419360.html',4,0.8000,NULL),(199,63,'simple',NULL,'2012-06-21 09:38:01',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15237839452',NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','','2012-07-12 02:57:48','tb-15237839452','tb-15237839452.html',4,0.8000,NULL),(200,63,'simple',NULL,'2012-06-21 09:38:03',1,0,0,'',0,0,NULL,NULL,NULL,'时尚潮流女性商务手表',NULL,NULL,488.0000,NULL,NULL,NULL,0,NULL,'','tb-15232587893',NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','','2012-07-12 03:00:55','tb-15232587893','tb-15232587893.html',4,0.8000,NULL),(201,63,'simple',NULL,'2012-06-21 09:38:04',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制复古经典女童手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15176883730',NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','','2012-07-12 03:02:56','tb-15176883730','tb-15176883730.html',4,0.8000,NULL),(202,63,'simple',NULL,'2012-06-21 09:38:06',1,0,0,'',0,0,NULL,NULL,NULL,'个性刻字定制男钢表',NULL,NULL,518.0000,NULL,NULL,NULL,0,NULL,'','tb-14501358291',NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','','2012-07-12 03:05:04','tb-14501358291','tb-14501358291.html',4,0.8000,NULL),(203,63,'simple',NULL,'2012-06-21 09:38:08',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制儿童运动女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14483017901',NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','','2012-07-12 03:08:09','tb-14483017901','tb-14483017901.html',4,0.8000,NULL),(204,63,'simple',NULL,'2012-06-21 09:38:10',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14480890920',NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','','2012-07-12 03:10:32','tb-14480890920','tb-14480890920.html',4,0.8000,NULL),(205,63,'simple',NULL,'2012-06-21 09:38:11',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚潮流镶钻女表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14470362811',NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','','2012-07-12 03:13:21','tb-14470362811','tb-14470362811.html',4,0.8000,NULL),(206,63,'simple',NULL,'2012-06-21 09:38:13',1,0,0,'',0,0,NULL,NULL,NULL,'定制户外运动挂表 ',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-14469030397',NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','','2012-07-12 03:14:29','tb-14469030397','tb-14469030397.html',4,0.8000,NULL),(208,63,'simple',NULL,'2012-06-21 09:38:17',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14450913511',NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','','2012-07-12 03:17:08','tb-14450913511','tb-14450913511.html',4,0.8000,NULL),(209,63,'simple',NULL,'2012-06-21 09:38:19',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚女钢表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14425318838',NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','','2012-07-12 03:18:16','tb-14425318838','tb-14425318838.html',4,0.8000,NULL),(210,63,'simple',NULL,'2012-06-21 09:38:21',1,0,0,'',0,0,NULL,NULL,NULL,'卡通风个性男款儿童手表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-10220121642',NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','','2012-07-12 03:19:44','tb-10220121642','tb-10220121642.html',4,0.8000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_4`
--

DROP TABLE IF EXISTS `catalog_product_flat_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_4` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple',
  `cost` decimal(12,4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enable_googlecheckout` tinyint(1) DEFAULT NULL,
  `gift_message_available` tinyint(1) DEFAULT NULL,
  `has_options` smallint(6) NOT NULL DEFAULT '0',
  `image_label` varchar(255) DEFAULT NULL,
  `is_imported` tinyint(1) DEFAULT NULL,
  `is_recurring` tinyint(1) DEFAULT NULL,
  `links_exist` int(11) DEFAULT NULL,
  `links_purchased_separately` int(11) DEFAULT NULL,
  `links_title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `news_from_date` datetime DEFAULT NULL,
  `news_to_date` datetime DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `price_type` int(11) DEFAULT NULL,
  `price_view` int(11) DEFAULT NULL,
  `recurring_profile` text,
  `required_options` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `shipment_type` int(11) DEFAULT NULL,
  `short_description` text,
  `sku` varchar(64) DEFAULT NULL,
  `sku_type` int(11) DEFAULT NULL,
  `small_image` varchar(255) DEFAULT NULL,
  `small_image_label` varchar(255) DEFAULT NULL,
  `special_from_date` datetime DEFAULT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `special_to_date` datetime DEFAULT NULL,
  `tax_class_id` int(11) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `thumbnail_label` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url_key` varchar(255) DEFAULT NULL,
  `url_path` varchar(255) DEFAULT NULL,
  `visibility` tinyint(3) unsigned DEFAULT NULL,
  `weight` decimal(12,4) DEFAULT NULL,
  `weight_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_id`),
  KEY `IDX_TYPE_ID` (`type_id`),
  KEY `IDX_ATRRIBUTE_SET` (`attribute_set_id`),
  KEY `IDX_NAME` (`name`),
  KEY `IDX_PRICE` (`price`),
  CONSTRAINT `FK_CATALOG_PRODUCT_FLAT_4_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_4`
--

LOCK TABLES `catalog_product_flat_4` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_4` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_4` VALUES (188,63,'simple',NULL,'2012-06-21 09:37:40',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制心形手链时装表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-16888172712',NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','','2012-07-12 02:29:24','tb-16888172712','tb-16888172712.html',4,0.8000,NULL),(189,63,'simple',NULL,'2012-06-21 09:37:41',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制儿童公主手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16746748453',NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','','2012-07-12 02:31:20','tb-16746748453','tb-16746748453.html',4,0.8000,NULL),(190,63,'simple',NULL,'2012-06-21 09:37:43',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制手表-男款',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15173227048',NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','','2012-07-12 02:34:45','tb-15173227048','tb-15173227048.html',4,0.8000,NULL),(191,63,'simple',NULL,'2012-06-21 09:37:45',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男款运动手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15167871086',NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','','2012-07-12 02:38:12','tb-15167871086','tb-15167871086.html',4,0.8000,NULL),(192,63,'simple',NULL,'2012-06-21 09:37:47',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装潮流女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14491898841',NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','','2012-07-12 02:40:01','tb-14491898841','tb-14491898841.html',4,0.8000,NULL),(193,63,'simple',NULL,'2012-06-21 09:37:49',1,0,0,'',0,0,NULL,NULL,NULL,'定制公主水晶石儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14420097483',NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','','2012-07-12 02:41:31','tb-14420097483','tb-14420097483.html',4,0.8000,NULL),(194,63,'simple',NULL,'2012-06-21 09:37:50',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-16950456931',NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','','2012-07-12 02:42:40','tb-16950456931','tb-16950456931.html',4,0.8000,NULL),(195,63,'simple',NULL,'2012-06-21 09:37:52',1,0,0,'',0,0,NULL,NULL,NULL,'个性时间认知儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16916368211',NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','','2012-07-12 02:45:51','tb-16916368211','tb-16916368211.html',4,0.8000,NULL),(196,63,'simple',NULL,'2012-06-21 09:37:55',1,0,0,'',0,0,NULL,NULL,NULL,'早教儿童认知时间手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16769128988',NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','','2012-07-12 02:47:51','tb-16769128988','tb-16769128988.html',4,0.8000,NULL),(197,63,'simple',NULL,'2012-06-21 09:37:57',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚镶钻表',NULL,NULL,428.0000,NULL,NULL,NULL,0,NULL,'','tb-15248759961',NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','','2012-07-12 02:52:31','tb-15248759961','tb-15248759961.html',4,0.8000,NULL),(198,63,'simple',NULL,'2012-06-21 09:37:59',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚男表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15238419360',NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','','2012-07-12 02:55:21','tb-15238419360','tb-15238419360.html',4,0.8000,NULL),(199,63,'simple',NULL,'2012-06-21 09:38:01',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15237839452',NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','','2012-07-12 02:57:48','tb-15237839452','tb-15237839452.html',4,0.8000,NULL),(200,63,'simple',NULL,'2012-06-21 09:38:03',1,0,0,'',0,0,NULL,NULL,NULL,'时尚潮流女性商务手表',NULL,NULL,488.0000,NULL,NULL,NULL,0,NULL,'','tb-15232587893',NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','','2012-07-12 03:00:55','tb-15232587893','tb-15232587893.html',4,0.8000,NULL),(201,63,'simple',NULL,'2012-06-21 09:38:04',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制复古经典女童手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15176883730',NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','','2012-07-12 03:02:56','tb-15176883730','tb-15176883730.html',4,0.8000,NULL),(202,63,'simple',NULL,'2012-06-21 09:38:06',1,0,0,'',0,0,NULL,NULL,NULL,'个性刻字定制男钢表',NULL,NULL,518.0000,NULL,NULL,NULL,0,NULL,'','tb-14501358291',NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','','2012-07-12 03:05:04','tb-14501358291','tb-14501358291.html',4,0.8000,NULL),(203,63,'simple',NULL,'2012-06-21 09:38:08',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制儿童运动女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14483017901',NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','','2012-07-12 03:08:09','tb-14483017901','tb-14483017901.html',4,0.8000,NULL),(204,63,'simple',NULL,'2012-06-21 09:38:10',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14480890920',NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','','2012-07-12 03:10:32','tb-14480890920','tb-14480890920.html',4,0.8000,NULL),(205,63,'simple',NULL,'2012-06-21 09:38:11',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚潮流镶钻女表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14470362811',NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','','2012-07-12 03:13:21','tb-14470362811','tb-14470362811.html',4,0.8000,NULL),(206,63,'simple',NULL,'2012-06-21 09:38:13',1,0,0,'',0,0,NULL,NULL,NULL,'定制户外运动挂表 ',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-14469030397',NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','','2012-07-12 03:14:29','tb-14469030397','tb-14469030397.html',4,0.8000,NULL),(208,63,'simple',NULL,'2012-06-21 09:38:17',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14450913511',NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','','2012-07-12 03:17:08','tb-14450913511','tb-14450913511.html',4,0.8000,NULL),(209,63,'simple',NULL,'2012-06-21 09:38:19',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚女钢表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14425318838',NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','','2012-07-12 03:18:16','tb-14425318838','tb-14425318838.html',4,0.8000,NULL),(210,63,'simple',NULL,'2012-06-21 09:38:21',1,0,0,'',0,0,NULL,NULL,NULL,'卡通风个性男款儿童手表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-10220121642',NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','','2012-07-12 03:19:44','tb-10220121642','tb-10220121642.html',4,0.8000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_4` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_flat_5`
--

DROP TABLE IF EXISTS `catalog_product_flat_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_flat_5` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple',
  `cost` decimal(12,4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enable_googlecheckout` tinyint(1) DEFAULT NULL,
  `gift_message_available` tinyint(1) DEFAULT NULL,
  `has_options` smallint(6) NOT NULL DEFAULT '0',
  `image_label` varchar(255) DEFAULT NULL,
  `is_imported` tinyint(1) DEFAULT NULL,
  `is_recurring` tinyint(1) DEFAULT NULL,
  `links_exist` int(11) DEFAULT NULL,
  `links_purchased_separately` int(11) DEFAULT NULL,
  `links_title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `news_from_date` datetime DEFAULT NULL,
  `news_to_date` datetime DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `price_type` int(11) DEFAULT NULL,
  `price_view` int(11) DEFAULT NULL,
  `recurring_profile` text,
  `required_options` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `shipment_type` int(11) DEFAULT NULL,
  `short_description` text,
  `sku` varchar(64) DEFAULT NULL,
  `sku_type` int(11) DEFAULT NULL,
  `small_image` varchar(255) DEFAULT NULL,
  `small_image_label` varchar(255) DEFAULT NULL,
  `special_from_date` datetime DEFAULT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `special_to_date` datetime DEFAULT NULL,
  `tax_class_id` int(11) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `thumbnail_label` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url_key` varchar(255) DEFAULT NULL,
  `url_path` varchar(255) DEFAULT NULL,
  `visibility` tinyint(3) unsigned DEFAULT NULL,
  `weight` decimal(12,4) DEFAULT NULL,
  `weight_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`entity_id`),
  KEY `IDX_TYPE_ID` (`type_id`),
  KEY `IDX_ATRRIBUTE_SET` (`attribute_set_id`),
  KEY `IDX_NAME` (`name`),
  KEY `IDX_PRICE` (`price`),
  CONSTRAINT `FK_CATALOG_PRODUCT_FLAT_5_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_flat_5`
--

LOCK TABLES `catalog_product_flat_5` WRITE;
/*!40000 ALTER TABLE `catalog_product_flat_5` DISABLE KEYS */;
INSERT INTO `catalog_product_flat_5` VALUES (188,63,'simple',NULL,'2012-06-21 09:37:40',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制心形手链时装表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-16888172712',NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2gqxtxcvdxxxxxxxx__555275419.jpg','','2012-07-12 02:29:24','tb-16888172712','tb-16888172712.html',4,0.8000,NULL),(189,63,'simple',NULL,'2012-06-21 09:37:41',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制儿童公主手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16746748453',NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t14zi_xijcxxx8_1dx_114732_1.jpg','','2012-07-12 02:31:20','tb-16746748453','tb-16746748453.html',4,0.8000,NULL),(190,63,'simple',NULL,'2012-06-21 09:37:43',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制手表-男款',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15173227048',NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29dplxoxbxxxxxxxx__555275419.jpg','','2012-07-12 02:34:45','tb-15173227048','tb-15173227048.html',4,0.8000,NULL),(191,63,'simple',NULL,'2012-06-21 09:37:45',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男款运动手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15167871086',NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t16iu9xglkxxasrv_u_014600_1.jpg','','2012-07-12 02:38:12','tb-15167871086','tb-15167871086.html',4,0.8000,NULL),(192,63,'simple',NULL,'2012-06-21 09:37:47',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装潮流女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14491898841',NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ndwexhnaxxxxxxxx__555275419.jpg','','2012-07-12 02:40:01','tb-14491898841','tb-14491898841.html',4,0.8000,NULL),(193,63,'simple',NULL,'2012-06-21 09:37:49',1,0,0,'',0,0,NULL,NULL,NULL,'定制公主水晶石儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14420097483',NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2ynedxgfaxxxxxxxx__555275419.jpg','','2012-07-12 02:41:31','tb-14420097483','tb-14420097483.html',4,0.8000,NULL),(194,63,'simple',NULL,'2012-06-21 09:37:50',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时装女表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-16950456931',NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2nvwexcfxxxxxxxxx__555275419.jpg','','2012-07-12 02:42:40','tb-16950456931','tb-16950456931.html',4,0.8000,NULL),(195,63,'simple',NULL,'2012-06-21 09:37:52',1,0,0,'',0,0,NULL,NULL,NULL,'个性时间认知儿童表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16916368211',NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2oxphxj0mxxxxxxxx__555275419.jpg','','2012-07-12 02:45:51','tb-16916368211','tb-16916368211.html',4,0.8000,NULL),(196,63,'simple',NULL,'2012-06-21 09:37:55',1,0,0,'',0,0,NULL,NULL,NULL,'早教儿童认知时间手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-16769128988',NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2k_bqxohmxxxxxxxx__555275419.jpg','','2012-07-12 02:47:51','tb-16769128988','tb-16769128988.html',4,0.8000,NULL),(197,63,'simple',NULL,'2012-06-21 09:37:57',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚镶钻表',NULL,NULL,428.0000,NULL,NULL,NULL,0,NULL,'','tb-15248759961',NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2pw1exjxaxxxxxxxx__555275419.jpg','','2012-07-12 02:52:31','tb-15248759961','tb-15248759961.html',4,0.8000,NULL),(198,63,'simple',NULL,'2012-06-21 09:37:59',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚男表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-15238419360',NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t18g5_xxbhxxb0ekk8_101309_1.jpg','','2012-07-12 02:55:21','tb-15238419360','tb-15238419360.html',4,0.8000,NULL),(199,63,'simple',NULL,'2012-06-21 09:38:01',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15237839452',NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xws_xjnixxcmkr6x_114410_1.jpg','','2012-07-12 02:57:48','tb-15237839452','tb-15237839452.html',4,0.8000,NULL),(200,63,'simple',NULL,'2012-06-21 09:38:03',1,0,0,'',0,0,NULL,NULL,NULL,'时尚潮流女性商务手表',NULL,NULL,488.0000,NULL,NULL,NULL,0,NULL,'','tb-15232587893',NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1zni_xjnjxxcmjko__111747.jpg','','2012-07-12 03:00:55','tb-15232587893','tb-15232587893.html',4,0.8000,NULL),(201,63,'simple',NULL,'2012-06-21 09:38:04',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制复古经典女童手表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-15176883730',NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1xg59xhnhxxae3eq__111819_1.jpg','','2012-07-12 03:02:56','tb-15176883730','tb-15176883730.html',4,0.8000,NULL),(202,63,'simple',NULL,'2012-06-21 09:38:06',1,0,0,'',0,0,NULL,NULL,NULL,'个性刻字定制男钢表',NULL,NULL,518.0000,NULL,NULL,NULL,0,NULL,'','tb-14501358291',NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1ckc_xmboxxbpodm1_040613.jpg','','2012-07-12 03:05:04','tb-14501358291','tb-14501358291.html',4,0.8000,NULL),(203,63,'simple',NULL,'2012-06-21 09:38:08',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制儿童运动女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14483017901',NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2kh42xkncxxxxxxxx__555275419.jpg','','2012-07-12 03:08:09','tb-14483017901','tb-14483017901.html',4,0.8000,NULL),(204,63,'simple',NULL,'2012-06-21 09:38:10',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制男表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14480890920',NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2hv8hxixmxxxxxxxx__555275419.jpg','','2012-07-12 03:10:32','tb-14480890920','tb-14480890920.html',4,0.8000,NULL),(205,63,'simple',NULL,'2012-06-21 09:38:11',1,0,0,'',0,0,NULL,NULL,NULL,'个性定制时尚潮流镶钻女表',NULL,NULL,208.0000,NULL,NULL,NULL,0,NULL,'','tb-14470362811',NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2go8exctmxxxxxxxx__555275419.jpg','','2012-07-12 03:13:21','tb-14470362811','tb-14470362811.html',4,0.8000,NULL),(206,63,'simple',NULL,'2012-06-21 09:38:13',1,0,0,'',0,0,NULL,NULL,NULL,'定制户外运动挂表 ',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-14469030397',NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2unxtxjhcxxxxxxxx__555275419.jpg','','2012-07-12 03:14:29','tb-14469030397','tb-14469030397.html',4,0.8000,NULL),(208,63,'simple',NULL,'2012-06-21 09:38:17',1,0,0,'',0,0,NULL,NULL,NULL,'经典定制女表',NULL,NULL,188.0000,NULL,NULL,NULL,0,NULL,'','tb-14450913511',NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','',NULL,NULL,NULL,NULL,'/t/2/t2fa4cxmrmxxxxxxxx__555275419_1.jpg','','2012-07-12 03:17:08','tb-14450913511','tb-14450913511.html',4,0.8000,NULL),(209,63,'simple',NULL,'2012-06-21 09:38:19',1,0,0,'',0,0,NULL,NULL,NULL,'个性创意时尚女钢表',NULL,NULL,258.0000,NULL,NULL,NULL,0,NULL,'','tb-14425318838',NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','',NULL,NULL,NULL,NULL,'/t/1/t1udk9xblmxxb9thva_121331_1.jpg','','2012-07-12 03:18:16','tb-14425318838','tb-14425318838.html',4,0.8000,NULL),(210,63,'simple',NULL,'2012-06-21 09:38:21',1,0,0,'',0,0,NULL,NULL,NULL,'卡通风个性男款儿童手表',NULL,NULL,198.0000,NULL,NULL,NULL,0,NULL,'','tb-10220121642',NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','',NULL,NULL,NULL,NULL,'/t/2/t29vidxb8bxxxxxxxx__555275419.jpg','','2012-07-12 03:19:44','tb-10220121642','tb-10220121642.html',4,0.8000,NULL);
/*!40000 ALTER TABLE `catalog_product_flat_5` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav`
--

DROP TABLE IF EXISTS `catalog_product_index_eav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav` (
  `entity_id` int(10) unsigned NOT NULL,
  `attribute_id` smallint(5) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `value` int(10) unsigned NOT NULL,
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`),
  KEY `IDX_ATTRIBUTE` (`attribute_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_VALUE` (`value`),
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav`
--

LOCK TABLES `catalog_product_index_eav` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav` VALUES (188,903,1,1),(188,903,2,1),(188,903,3,1),(188,903,4,1),(188,903,5,1),(189,903,1,1),(189,903,2,1),(189,903,3,1),(189,903,4,1),(189,903,5,1),(190,903,1,1),(190,903,2,1),(190,903,3,1),(190,903,4,1),(190,903,5,1),(191,903,1,1),(191,903,2,1),(191,903,3,1),(191,903,4,1),(191,903,5,1),(192,903,1,1),(192,903,2,1),(192,903,3,1),(192,903,4,1),(192,903,5,1),(193,903,1,1),(193,903,2,1),(193,903,3,1),(193,903,4,1),(193,903,5,1),(194,903,1,1),(194,903,2,1),(194,903,3,1),(194,903,4,1),(194,903,5,1),(195,903,1,1),(195,903,2,1),(195,903,3,1),(195,903,4,1),(195,903,5,1),(196,903,1,1),(196,903,2,1),(196,903,3,1),(196,903,4,1),(196,903,5,1),(197,903,1,1),(197,903,2,1),(197,903,3,1),(197,903,4,1),(197,903,5,1),(198,903,1,1),(198,903,2,1),(198,903,3,1),(198,903,4,1),(198,903,5,1),(199,903,1,1),(199,903,2,1),(199,903,3,1),(199,903,4,1),(199,903,5,1),(200,903,1,1),(200,903,2,1),(200,903,3,1),(200,903,4,1),(200,903,5,1),(201,903,1,1),(201,903,2,1),(201,903,3,1),(201,903,4,1),(201,903,5,1),(202,903,1,1),(202,903,2,1),(202,903,3,1),(202,903,4,1),(202,903,5,1),(203,903,1,1),(203,903,2,1),(203,903,3,1),(203,903,4,1),(203,903,5,1),(204,903,1,1),(204,903,2,1),(204,903,3,1),(204,903,4,1),(204,903,5,1),(205,903,1,1),(205,903,2,1),(205,903,3,1),(205,903,4,1),(205,903,5,1),(206,903,1,1),(206,903,2,1),(206,903,3,1),(206,903,4,1),(206,903,5,1),(208,903,1,1),(208,903,2,1),(208,903,3,1),(208,903,4,1),(208,903,5,1),(209,903,1,1),(209,903,2,1),(209,903,3,1),(209,903,4,1),(209,903,5,1),(210,903,1,1),(210,903,2,1),(210,903,3,1),(210,903,4,1),(210,903,5,1),(188,951,1,130),(188,951,2,130),(188,951,3,130),(188,951,4,130),(188,951,5,130),(189,951,1,130),(189,951,2,130),(189,951,3,130),(189,951,4,130),(189,951,5,130),(190,951,1,130),(190,951,2,130),(190,951,3,130),(190,951,4,130),(190,951,5,130),(191,951,1,130),(191,951,2,130),(191,951,3,130),(191,951,4,130),(191,951,5,130),(192,951,1,130),(192,951,2,130),(192,951,3,130),(192,951,4,130),(192,951,5,130),(193,951,1,130),(193,951,2,130),(193,951,3,130),(193,951,4,130),(193,951,5,130),(194,951,1,130),(194,951,2,130),(194,951,3,130),(194,951,4,130),(194,951,5,130),(195,951,1,130),(195,951,2,130),(195,951,3,130),(195,951,4,130),(195,951,5,130),(196,951,1,130),(196,951,2,130),(196,951,3,130),(196,951,4,130),(196,951,5,130),(198,951,1,134),(198,951,2,134),(198,951,3,134),(198,951,4,134),(198,951,5,134),(201,951,1,130),(201,951,2,130),(201,951,3,130),(201,951,4,130),(201,951,5,130),(202,951,1,134),(202,951,2,134),(202,951,3,134),(202,951,4,134),(202,951,5,134),(203,951,1,130),(203,951,2,130),(203,951,3,130),(203,951,4,130),(203,951,5,130),(204,951,1,134),(204,951,2,134),(204,951,3,134),(204,951,4,134),(204,951,5,134),(205,951,1,130),(205,951,2,130),(205,951,3,130),(205,951,4,130),(205,951,5,130),(206,951,1,134),(206,951,2,134),(206,951,3,134),(206,951,4,134),(206,951,5,134),(208,951,1,130),(208,951,2,130),(208,951,3,130),(208,951,4,130),(208,951,5,130),(209,951,1,130),(209,951,2,130),(209,951,3,130),(209,951,4,130),(209,951,5,130),(210,951,1,130),(210,951,2,130),(210,951,3,130),(210,951,4,130),(210,951,5,130),(188,952,1,150),(188,952,2,150),(188,952,3,150),(188,952,4,150),(188,952,5,150),(189,952,1,150),(189,952,2,150),(189,952,3,150),(189,952,4,150),(189,952,5,150),(190,952,1,150),(190,952,2,150),(190,952,3,150),(190,952,4,150),(190,952,5,150),(191,952,1,150),(191,952,2,150),(191,952,3,150),(191,952,4,150),(191,952,5,150),(192,952,1,150),(192,952,2,150),(192,952,3,150),(192,952,4,150),(192,952,5,150),(193,952,1,150),(193,952,2,150),(193,952,3,150),(193,952,4,150),(193,952,5,150),(194,952,1,150),(194,952,2,150),(194,952,3,150),(194,952,4,150),(194,952,5,150),(195,952,1,150),(195,952,2,150),(195,952,3,150),(195,952,4,150),(195,952,5,150),(196,952,1,150),(196,952,2,150),(196,952,3,150),(196,952,4,150),(196,952,5,150),(197,952,1,153),(197,952,2,153),(197,952,3,153),(197,952,4,153),(197,952,5,153),(198,952,1,153),(198,952,2,153),(198,952,3,153),(198,952,4,153),(198,952,5,153),(199,952,1,153),(199,952,2,153),(199,952,3,153),(199,952,4,153),(199,952,5,153),(200,952,1,153),(200,952,2,153),(200,952,3,153),(200,952,4,153),(200,952,5,153),(201,952,1,150),(201,952,2,150),(201,952,3,150),(201,952,4,150),(201,952,5,150),(202,952,1,153),(202,952,2,153),(202,952,3,153),(202,952,4,153),(202,952,5,153),(203,952,1,150),(203,952,2,150),(203,952,3,150),(203,952,4,150),(203,952,5,150),(204,952,1,153),(204,952,2,153),(204,952,3,153),(204,952,4,153),(204,952,5,153),(205,952,1,150),(205,952,2,150),(205,952,3,150),(205,952,4,150),(205,952,5,150),(206,952,1,153),(206,952,2,153),(206,952,3,153),(206,952,4,153),(206,952,5,153),(208,952,1,150),(208,952,2,150),(208,952,3,150),(208,952,4,150),(208,952,5,150),(209,952,1,150),(209,952,2,150),(209,952,3,150),(209,952,4,150),(209,952,5,150),(210,952,1,150),(210,952,2,150),(210,952,3,150),(210,952,4,150),(210,952,5,150),(188,953,1,169),(188,953,2,169),(188,953,3,169),(188,953,4,169),(188,953,5,169),(189,953,1,169),(189,953,2,169),(189,953,3,169),(189,953,4,169),(189,953,5,169),(190,953,1,169),(190,953,2,169),(190,953,3,169),(190,953,4,169),(190,953,5,169),(191,953,1,169),(191,953,2,169),(191,953,3,169),(191,953,4,169),(191,953,5,169),(192,953,1,169),(192,953,2,169),(192,953,3,169),(192,953,4,169),(192,953,5,169),(193,953,1,169),(193,953,2,169),(193,953,3,169),(193,953,4,169),(193,953,5,169),(194,953,1,169),(194,953,2,169),(194,953,3,169),(194,953,4,169),(194,953,5,169),(195,953,1,169),(195,953,2,169),(195,953,3,169),(195,953,4,169),(195,953,5,169),(196,953,1,169),(196,953,2,169),(196,953,3,169),(196,953,4,169),(196,953,5,169),(197,953,1,169),(197,953,2,169),(197,953,3,169),(197,953,4,169),(197,953,5,169),(198,953,1,169),(198,953,2,169),(198,953,3,169),(198,953,4,169),(198,953,5,169),(199,953,1,169),(199,953,2,169),(199,953,3,169),(199,953,4,169),(199,953,5,169),(200,953,1,169),(200,953,2,169),(200,953,3,169),(200,953,4,169),(200,953,5,169),(201,953,1,169),(201,953,2,169),(201,953,3,169),(201,953,4,169),(201,953,5,169),(202,953,1,169),(202,953,2,169),(202,953,3,169),(202,953,4,169),(202,953,5,169),(203,953,1,169),(203,953,2,169),(203,953,3,169),(203,953,4,169),(203,953,5,169),(204,953,1,169),(204,953,2,169),(204,953,3,169),(204,953,4,169),(204,953,5,169),(205,953,1,169),(205,953,2,169),(205,953,3,169),(205,953,4,169),(205,953,5,169),(206,953,1,169),(206,953,2,169),(206,953,3,169),(206,953,4,169),(206,953,5,169),(208,953,1,169),(208,953,2,169),(208,953,3,169),(208,953,4,169),(208,953,5,169),(209,953,1,169),(209,953,2,169),(209,953,3,169),(209,953,4,169),(209,953,5,169),(210,953,1,169),(210,953,2,169),(210,953,3,169),(210,953,4,169),(210,953,5,169);
/*!40000 ALTER TABLE `catalog_product_index_eav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_decimal` (
  `entity_id` int(10) unsigned NOT NULL,
  `attribute_id` smallint(5) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `value` decimal(12,4) NOT NULL,
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`),
  KEY `IDX_ATTRIBUTE` (`attribute_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_VALUE` (`value`),
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal`
--

LOCK TABLES `catalog_product_index_eav_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_decimal_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `attribute_id` smallint(5) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `value` decimal(12,4) NOT NULL,
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`),
  KEY `IDX_ATTRIBUTE` (`attribute_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_idx`
--

LOCK TABLES `catalog_product_index_eav_decimal_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_decimal_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_decimal_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `attribute_id` smallint(5) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `value` decimal(12,4) NOT NULL,
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`),
  KEY `IDX_ATTRIBUTE` (`attribute_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_VALUE` (`value`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_decimal_tmp`
--

LOCK TABLES `catalog_product_index_eav_decimal_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_decimal_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `attribute_id` smallint(5) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `value` int(10) unsigned NOT NULL,
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`),
  KEY `IDX_ATTRIBUTE` (`attribute_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_idx`
--

LOCK TABLES `catalog_product_index_eav_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_eav_idx` VALUES (167,903,1,1),(167,903,2,1),(167,903,3,1),(167,903,4,1),(167,903,5,1),(168,903,1,1),(168,903,2,1),(168,903,3,1),(168,903,4,1),(168,903,5,1),(169,903,1,1),(169,903,2,1),(169,903,3,1),(169,903,4,1),(169,903,5,1),(170,903,1,1),(170,903,2,1),(170,903,3,1),(170,903,4,1),(170,903,5,1),(171,903,1,1),(171,903,2,1),(171,903,3,1),(171,903,4,1),(171,903,5,1),(172,903,1,1),(172,903,2,1),(172,903,3,1),(172,903,4,1),(172,903,5,1),(173,903,1,1),(173,903,2,1),(173,903,3,1),(173,903,4,1),(173,903,5,1),(174,903,1,1),(174,903,2,1),(174,903,3,1),(174,903,4,1),(174,903,5,1),(175,903,1,1),(175,903,2,1),(175,903,3,1),(175,903,4,1),(175,903,5,1),(176,903,1,1),(176,903,2,1),(176,903,3,1),(176,903,4,1),(176,903,5,1),(177,903,1,1),(177,903,2,1),(177,903,3,1),(177,903,4,1),(177,903,5,1),(178,903,1,1),(178,903,2,1),(178,903,3,1),(178,903,4,1),(178,903,5,1),(179,903,1,1),(179,903,2,1),(179,903,3,1),(179,903,4,1),(179,903,5,1),(180,903,1,1),(180,903,2,1),(180,903,3,1),(180,903,4,1),(180,903,5,1),(181,903,1,1),(181,903,2,1),(181,903,3,1),(181,903,4,1),(181,903,5,1),(182,903,1,1),(182,903,2,1),(182,903,3,1),(182,903,4,1),(182,903,5,1),(183,903,1,1),(183,903,2,1),(183,903,3,1),(183,903,4,1),(183,903,5,1),(184,903,1,1),(184,903,2,1),(184,903,3,1),(184,903,4,1),(184,903,5,1),(185,903,1,1),(185,903,2,1),(185,903,3,1),(185,903,4,1),(185,903,5,1),(186,903,1,1),(186,903,2,1),(186,903,3,1),(186,903,4,1),(186,903,5,1),(187,903,1,1),(187,903,2,1),(187,903,3,1),(187,903,4,1),(187,903,5,1),(188,903,1,1),(188,903,2,1),(188,903,3,1),(188,903,4,1),(188,903,5,1),(189,903,1,1),(189,903,2,1),(189,903,3,1),(189,903,4,1),(189,903,5,1),(190,903,1,1),(190,903,2,1),(190,903,3,1),(190,903,4,1),(190,903,5,1),(191,903,1,1),(191,903,2,1),(191,903,3,1),(191,903,4,1),(191,903,5,1),(192,903,1,1),(192,903,2,1),(192,903,3,1),(192,903,4,1),(192,903,5,1),(193,903,1,1),(193,903,2,1),(193,903,3,1),(193,903,4,1),(193,903,5,1),(194,903,1,1),(194,903,2,1),(194,903,3,1),(194,903,4,1),(194,903,5,1),(195,903,1,1),(195,903,2,1),(195,903,3,1),(195,903,4,1),(195,903,5,1),(196,903,1,1),(196,903,2,1),(196,903,3,1),(196,903,4,1),(196,903,5,1),(197,903,1,1),(197,903,2,1),(197,903,3,1),(197,903,4,1),(197,903,5,1),(198,903,1,1),(198,903,2,1),(198,903,3,1),(198,903,4,1),(198,903,5,1),(199,903,1,1),(199,903,2,1),(199,903,3,1),(199,903,4,1),(199,903,5,1),(200,903,1,1),(200,903,2,1),(200,903,3,1),(200,903,4,1),(200,903,5,1),(201,903,1,1),(201,903,2,1),(201,903,3,1),(201,903,4,1),(201,903,5,1),(202,903,1,1),(202,903,2,1),(202,903,3,1),(202,903,4,1),(202,903,5,1),(203,903,1,1),(203,903,2,1),(203,903,3,1),(203,903,4,1),(203,903,5,1),(204,903,1,1),(204,903,2,1),(204,903,3,1),(204,903,4,1),(204,903,5,1),(205,903,1,1),(205,903,2,1),(205,903,3,1),(205,903,4,1),(205,903,5,1),(206,903,1,1),(206,903,2,1),(206,903,3,1),(206,903,4,1),(206,903,5,1),(207,903,1,1),(207,903,2,1),(207,903,3,1),(207,903,4,1),(207,903,5,1),(208,903,1,1),(208,903,2,1),(208,903,3,1),(208,903,4,1),(208,903,5,1),(209,903,1,1),(209,903,2,1),(209,903,3,1),(209,903,4,1),(209,903,5,1),(210,903,1,1),(210,903,2,1),(210,903,3,1),(210,903,4,1),(210,903,5,1),(211,903,1,1),(211,903,2,1),(211,903,3,1),(211,903,4,1),(211,903,5,1),(212,903,1,1),(212,903,2,1),(212,903,3,1),(212,903,4,1),(212,903,5,1),(213,903,1,1),(213,903,2,1),(213,903,3,1),(213,903,4,1),(213,903,5,1),(214,903,1,1),(214,903,2,1),(214,903,3,1),(214,903,4,1),(214,903,5,1),(215,903,1,1),(215,903,2,1),(215,903,3,1),(215,903,4,1),(215,903,5,1),(216,903,1,1),(216,903,2,1),(216,903,3,1),(216,903,4,1),(216,903,5,1),(217,903,1,1),(217,903,2,1),(217,903,3,1),(217,903,4,1),(217,903,5,1),(218,903,1,1),(218,903,2,1),(218,903,3,1),(218,903,4,1),(218,903,5,1),(219,903,1,1),(219,903,2,1),(219,903,3,1),(219,903,4,1),(219,903,5,1),(220,903,1,1),(220,903,2,1),(220,903,3,1),(220,903,4,1),(220,903,5,1),(221,903,1,1),(221,903,2,1),(221,903,3,1),(221,903,4,1),(221,903,5,1),(222,903,1,1),(222,903,2,1),(222,903,3,1),(222,903,4,1),(222,903,5,1),(223,903,1,1),(223,903,2,1),(223,903,3,1),(223,903,4,1),(223,903,5,1),(224,903,1,1),(224,903,2,1),(224,903,3,1),(224,903,4,1),(224,903,5,1),(225,903,1,1),(225,903,2,1),(225,903,3,1),(225,903,4,1),(225,903,5,1),(226,903,1,1),(226,903,2,1),(226,903,3,1),(226,903,4,1),(226,903,5,1),(227,903,1,1),(227,903,2,1),(227,903,3,1),(227,903,4,1),(227,903,5,1),(228,903,1,1),(228,903,2,1),(228,903,3,1),(228,903,4,1),(228,903,5,1),(229,903,1,1),(229,903,2,1),(229,903,3,1),(229,903,4,1),(229,903,5,1),(230,903,1,1),(230,903,2,1),(230,903,3,1),(230,903,4,1),(230,903,5,1),(231,903,1,1),(231,903,2,1),(231,903,3,1),(231,903,4,1),(231,903,5,1),(232,903,1,1),(232,903,2,1),(232,903,3,1),(232,903,4,1),(232,903,5,1),(233,903,1,1),(233,903,2,1),(233,903,3,1),(233,903,4,1),(233,903,5,1),(234,903,1,1),(234,903,2,1),(234,903,3,1),(234,903,4,1),(234,903,5,1),(235,903,1,1),(235,903,2,1),(235,903,3,1),(235,903,4,1),(235,903,5,1),(236,903,1,1),(236,903,2,1),(236,903,3,1),(236,903,4,1),(236,903,5,1),(237,903,1,1),(237,903,2,1),(237,903,3,1),(237,903,4,1),(237,903,5,1),(238,903,1,1),(238,903,2,1),(238,903,3,1),(238,903,4,1),(238,903,5,1),(239,903,1,1),(239,903,2,1),(239,903,3,1),(239,903,4,1),(239,903,5,1),(240,903,1,1),(240,903,2,1),(240,903,3,1),(240,903,4,1),(240,903,5,1),(241,903,1,1),(241,903,2,1),(241,903,3,1),(241,903,4,1),(241,903,5,1),(242,903,1,1),(242,903,2,1),(242,903,3,1),(242,903,4,1),(242,903,5,1),(243,903,1,1),(243,903,2,1),(243,903,3,1),(243,903,4,1),(243,903,5,1),(244,903,1,1),(244,903,2,1),(244,903,3,1),(244,903,4,1),(244,903,5,1),(245,903,1,1),(245,903,2,1),(245,903,3,1),(245,903,4,1),(245,903,5,1),(246,903,1,1),(246,903,2,1),(246,903,3,1),(246,903,4,1),(246,903,5,1),(248,903,1,1),(248,903,2,1),(248,903,3,1),(248,903,4,1),(248,903,5,1),(249,903,1,1),(249,903,2,1),(249,903,3,1),(249,903,4,1),(249,903,5,1),(250,903,1,1),(250,903,2,1),(250,903,3,1),(250,903,4,1),(250,903,5,1),(251,903,1,1),(251,903,2,1),(251,903,3,1),(251,903,4,1),(251,903,5,1),(252,903,1,1),(252,903,2,1),(252,903,3,1),(252,903,4,1),(252,903,5,1),(253,903,1,1),(253,903,2,1),(253,903,3,1),(253,903,4,1),(253,903,5,1),(254,903,1,1),(254,903,2,1),(254,903,3,1),(254,903,4,1),(254,903,5,1),(255,903,1,1),(255,903,2,1),(255,903,3,1),(255,903,4,1),(255,903,5,1),(256,903,1,1),(256,903,2,1),(256,903,3,1),(256,903,4,1),(256,903,5,1),(257,903,1,1),(257,903,2,1),(257,903,3,1),(257,903,4,1),(257,903,5,1),(258,903,1,1),(258,903,2,1),(258,903,3,1),(258,903,4,1),(258,903,5,1),(259,903,1,1),(259,903,2,1),(259,903,3,1),(259,903,4,1),(259,903,5,1),(260,903,1,1),(260,903,2,1),(260,903,3,1),(260,903,4,1),(260,903,5,1),(261,903,1,1),(261,903,2,1),(261,903,3,1),(261,903,4,1),(261,903,5,1),(262,903,1,1),(262,903,2,1),(262,903,3,1),(262,903,4,1),(262,903,5,1),(263,903,1,1),(263,903,2,1),(263,903,3,1),(263,903,4,1),(263,903,5,1),(264,903,1,1),(264,903,2,1),(264,903,3,1),(264,903,4,1),(264,903,5,1),(265,903,1,1),(265,903,2,1),(265,903,3,1),(265,903,4,1),(265,903,5,1),(266,903,1,1),(266,903,2,1),(266,903,3,1),(266,903,4,1),(266,903,5,1),(267,903,1,1),(267,903,2,1),(267,903,3,1),(267,903,4,1),(267,903,5,1),(268,903,1,1),(268,903,2,1),(268,903,3,1),(268,903,4,1),(268,903,5,1),(269,903,1,1),(269,903,2,1),(269,903,3,1),(269,903,4,1),(269,903,5,1),(270,903,1,1),(270,903,2,1),(270,903,3,1),(270,903,4,1),(270,903,5,1),(271,903,1,1),(271,903,2,1),(271,903,3,1),(271,903,4,1),(271,903,5,1),(272,903,1,1),(272,903,2,1),(272,903,3,1),(272,903,4,1),(272,903,5,1),(273,903,1,1),(273,903,2,1),(273,903,3,1),(273,903,4,1),(273,903,5,1),(274,903,1,1),(274,903,2,1),(274,903,3,1),(274,903,4,1),(274,903,5,1),(275,903,1,1),(275,903,2,1),(275,903,3,1),(275,903,4,1),(275,903,5,1),(276,903,1,1),(276,903,2,1),(276,903,3,1),(276,903,4,1),(276,903,5,1),(277,903,1,1),(277,903,2,1),(277,903,3,1),(277,903,4,1),(277,903,5,1),(278,903,1,1),(278,903,2,1),(278,903,3,1),(278,903,4,1),(278,903,5,1),(279,903,1,1),(279,903,2,1),(279,903,3,1),(279,903,4,1),(279,903,5,1),(280,903,1,1),(280,903,2,1),(280,903,3,1),(280,903,4,1),(280,903,5,1),(281,903,1,1),(281,903,2,1),(281,903,3,1),(281,903,4,1),(281,903,5,1),(282,903,1,1),(282,903,2,1),(282,903,3,1),(282,903,4,1),(282,903,5,1),(283,903,1,1),(283,903,2,1),(283,903,3,1),(283,903,4,1),(283,903,5,1),(284,903,1,1),(284,903,2,1),(284,903,3,1),(284,903,4,1),(284,903,5,1),(285,903,1,1),(285,903,2,1),(285,903,3,1),(285,903,4,1),(285,903,5,1),(286,903,1,1),(286,903,2,1),(286,903,3,1),(286,903,4,1),(286,903,5,1),(287,903,1,1),(287,903,2,1),(287,903,3,1),(287,903,4,1),(287,903,5,1),(288,903,1,1),(288,903,2,1),(288,903,3,1),(288,903,4,1),(288,903,5,1),(289,903,1,1),(289,903,2,1),(289,903,3,1),(289,903,4,1),(289,903,5,1),(290,903,1,1),(290,903,2,1),(290,903,3,1),(290,903,4,1),(290,903,5,1),(291,903,1,1),(291,903,2,1),(291,903,3,1),(291,903,4,1),(291,903,5,1),(292,903,1,1),(292,903,2,1),(292,903,3,1),(292,903,4,1),(292,903,5,1),(293,903,1,1),(293,903,2,1),(293,903,3,1),(293,903,4,1),(293,903,5,1),(294,903,1,1),(294,903,2,1),(294,903,3,1),(294,903,4,1),(294,903,5,1),(295,903,1,1),(295,903,2,1),(295,903,3,1),(295,903,4,1),(295,903,5,1),(296,903,1,1),(296,903,2,1),(296,903,3,1),(296,903,4,1),(296,903,5,1),(297,903,1,1),(297,903,2,1),(297,903,3,1),(297,903,4,1),(297,903,5,1),(298,903,1,1),(298,903,2,1),(298,903,3,1),(298,903,4,1),(298,903,5,1),(299,903,1,1),(299,903,2,1),(299,903,3,1),(299,903,4,1),(299,903,5,1),(300,903,1,1),(300,903,2,1),(300,903,3,1),(300,903,4,1),(300,903,5,1),(301,903,1,1),(301,903,2,1),(301,903,3,1),(301,903,4,1),(301,903,5,1),(302,903,1,1),(302,903,2,1),(302,903,3,1),(302,903,4,1),(302,903,5,1),(303,903,1,1),(303,903,2,1),(303,903,3,1),(303,903,4,1),(303,903,5,1),(304,903,1,1),(304,903,2,1),(304,903,3,1),(304,903,4,1),(304,903,5,1),(305,903,1,1),(305,903,2,1),(305,903,3,1),(305,903,4,1),(305,903,5,1),(306,903,1,1),(306,903,2,1),(306,903,3,1),(306,903,4,1),(306,903,5,1),(307,903,1,1),(307,903,2,1),(307,903,3,1),(307,903,4,1),(307,903,5,1),(308,903,1,1),(308,903,2,1),(308,903,3,1),(308,903,4,1),(308,903,5,1),(309,903,1,1),(309,903,2,1),(309,903,3,1),(309,903,4,1),(309,903,5,1),(310,903,1,1),(310,903,2,1),(310,903,3,1),(310,903,4,1),(310,903,5,1),(311,903,1,1),(311,903,2,1),(311,903,3,1),(311,903,4,1),(311,903,5,1),(312,903,1,1),(312,903,2,1),(312,903,3,1),(312,903,4,1),(312,903,5,1),(313,903,1,1),(313,903,2,1),(313,903,3,1),(313,903,4,1),(313,903,5,1),(314,903,1,1),(314,903,2,1),(314,903,3,1),(314,903,4,1),(314,903,5,1),(315,903,1,1),(315,903,2,1),(315,903,3,1),(315,903,4,1),(315,903,5,1),(316,903,1,1),(316,903,2,1),(316,903,3,1),(316,903,4,1),(316,903,5,1),(317,903,1,1),(317,903,2,1),(317,903,3,1),(317,903,4,1),(317,903,5,1),(318,903,1,1),(318,903,2,1),(318,903,3,1),(318,903,4,1),(318,903,5,1),(319,903,1,1),(319,903,2,1),(319,903,3,1),(319,903,4,1),(319,903,5,1),(320,903,1,1),(320,903,2,1),(320,903,3,1),(320,903,4,1),(320,903,5,1),(321,903,1,1),(321,903,2,1),(321,903,3,1),(321,903,4,1),(321,903,5,1),(322,903,1,1),(322,903,2,1),(322,903,3,1),(322,903,4,1),(322,903,5,1),(323,903,1,1),(323,903,2,1),(323,903,3,1),(323,903,4,1),(323,903,5,1),(324,903,1,1),(324,903,2,1),(324,903,3,1),(324,903,4,1),(324,903,5,1),(325,903,1,1),(325,903,2,1),(325,903,3,1),(325,903,4,1),(325,903,5,1),(326,903,1,1),(326,903,2,1),(326,903,3,1),(326,903,4,1),(326,903,5,1),(327,903,1,1),(327,903,2,1),(327,903,3,1),(327,903,4,1),(327,903,5,1),(328,903,1,1),(328,903,2,1),(328,903,3,1),(328,903,4,1),(328,903,5,1),(329,903,1,1),(329,903,2,1),(329,903,3,1),(329,903,4,1),(329,903,5,1),(330,903,1,1),(330,903,2,1),(330,903,3,1),(330,903,4,1),(330,903,5,1),(331,903,1,1),(331,903,2,1),(331,903,3,1),(331,903,4,1),(331,903,5,1),(332,903,1,1),(332,903,2,1),(332,903,3,1),(332,903,4,1),(332,903,5,1),(333,903,1,1),(333,903,2,1),(333,903,3,1),(333,903,4,1),(333,903,5,1),(334,903,1,1),(334,903,2,1),(334,903,3,1),(334,903,4,1),(334,903,5,1),(335,903,1,1),(335,903,2,1),(335,903,3,1),(335,903,4,1),(335,903,5,1),(336,903,1,1),(336,903,2,1),(336,903,3,1),(336,903,4,1),(336,903,5,1),(337,903,1,1),(337,903,2,1),(337,903,3,1),(337,903,4,1),(337,903,5,1),(338,903,1,1),(338,903,2,1),(338,903,3,1),(338,903,4,1),(338,903,5,1),(339,903,1,1),(339,903,2,1),(339,903,3,1),(339,903,4,1),(339,903,5,1),(340,903,1,1),(340,903,2,1),(340,903,3,1),(340,903,4,1),(340,903,5,1),(341,903,1,1),(341,903,2,1),(341,903,3,1),(341,903,4,1),(341,903,5,1),(342,903,1,1),(342,903,2,1),(342,903,3,1),(342,903,4,1),(342,903,5,1),(343,903,1,1),(343,903,2,1),(343,903,3,1),(343,903,4,1),(343,903,5,1),(344,903,1,1),(344,903,2,1),(344,903,3,1),(344,903,4,1),(344,903,5,1),(345,903,1,1),(345,903,2,1),(345,903,3,1),(345,903,4,1),(345,903,5,1),(346,903,1,1),(346,903,2,1),(346,903,3,1),(346,903,4,1),(346,903,5,1),(347,903,1,1),(347,903,2,1),(347,903,3,1),(347,903,4,1),(347,903,5,1),(348,903,1,1),(348,903,2,1),(348,903,3,1),(348,903,4,1),(348,903,5,1),(349,903,1,1),(349,903,2,1),(349,903,3,1),(349,903,4,1),(349,903,5,1),(350,903,1,1),(350,903,2,1),(350,903,3,1),(350,903,4,1),(350,903,5,1),(351,903,1,1),(351,903,2,1),(351,903,3,1),(351,903,4,1),(351,903,5,1),(352,903,1,1),(352,903,2,1),(352,903,3,1),(352,903,4,1),(352,903,5,1),(353,903,1,1),(353,903,2,1),(353,903,3,1),(353,903,4,1),(353,903,5,1),(354,903,1,1),(354,903,2,1),(354,903,3,1),(354,903,4,1),(354,903,5,1),(355,903,1,1),(355,903,2,1),(355,903,3,1),(355,903,4,1),(355,903,5,1),(356,903,1,1),(356,903,2,1),(356,903,3,1),(356,903,4,1),(356,903,5,1),(357,903,1,1),(357,903,2,1),(357,903,3,1),(357,903,4,1),(357,903,5,1),(358,903,1,1),(358,903,2,1),(358,903,3,1),(358,903,4,1),(358,903,5,1),(359,903,1,1),(359,903,2,1),(359,903,3,1),(359,903,4,1),(359,903,5,1),(360,903,1,1),(360,903,2,1),(360,903,3,1),(360,903,4,1),(360,903,5,1),(361,903,1,1),(361,903,2,1),(361,903,3,1),(361,903,4,1),(361,903,5,1),(362,903,1,1),(362,903,2,1),(362,903,3,1),(362,903,4,1),(362,903,5,1),(363,903,1,1),(363,903,2,1),(363,903,3,1),(363,903,4,1),(363,903,5,1),(364,903,1,1),(364,903,2,1),(364,903,3,1),(364,903,4,1),(364,903,5,1),(365,903,1,1),(365,903,2,1),(365,903,3,1),(365,903,4,1),(365,903,5,1),(366,903,1,1),(366,903,2,1),(366,903,3,1),(366,903,4,1),(366,903,5,1),(367,903,1,1),(367,903,2,1),(367,903,3,1),(367,903,4,1),(367,903,5,1),(368,903,1,1),(368,903,2,1),(368,903,3,1),(368,903,4,1),(368,903,5,1),(369,903,1,1),(369,903,2,1),(369,903,3,1),(369,903,4,1),(369,903,5,1),(370,903,1,1),(370,903,2,1),(370,903,3,1),(370,903,4,1),(370,903,5,1),(371,903,1,1),(371,903,2,1),(371,903,3,1),(371,903,4,1),(371,903,5,1),(167,951,1,133),(167,951,2,133),(167,951,3,133),(167,951,4,133),(167,951,5,133),(168,951,1,134),(168,951,1,136),(168,951,1,139),(168,951,2,134),(168,951,2,136),(168,951,2,139),(168,951,3,134),(168,951,3,136),(168,951,3,139),(168,951,4,134),(168,951,4,136),(168,951,4,139),(168,951,5,134),(168,951,5,136),(168,951,5,139),(169,951,1,134),(169,951,2,134),(169,951,3,134),(169,951,4,134),(169,951,5,134),(170,951,1,133),(170,951,2,133),(170,951,3,133),(170,951,4,133),(170,951,5,133),(171,951,1,130),(171,951,2,130),(171,951,3,130),(171,951,4,130),(171,951,5,130),(172,951,1,130),(172,951,2,130),(172,951,3,130),(172,951,4,130),(172,951,5,130),(173,951,1,126),(173,951,1,131),(173,951,2,126),(173,951,2,131),(173,951,3,126),(173,951,3,131),(173,951,4,126),(173,951,4,131),(173,951,5,126),(173,951,5,131),(174,951,1,130),(174,951,1,133),(174,951,2,130),(174,951,2,133),(174,951,3,130),(174,951,3,133),(174,951,4,130),(174,951,4,133),(174,951,5,130),(174,951,5,133),(175,951,1,130),(175,951,2,130),(175,951,3,130),(175,951,4,130),(175,951,5,130),(176,951,1,133),(176,951,1,134),(176,951,2,133),(176,951,2,134),(176,951,3,133),(176,951,3,134),(176,951,4,133),(176,951,4,134),(176,951,5,133),(176,951,5,134),(177,951,1,133),(177,951,2,133),(177,951,3,133),(177,951,4,133),(177,951,5,133),(178,951,1,133),(178,951,2,133),(178,951,3,133),(178,951,4,133),(178,951,5,133),(179,951,1,131),(179,951,2,131),(179,951,3,131),(179,951,4,131),(179,951,5,131),(180,951,1,133),(180,951,2,133),(180,951,3,133),(180,951,4,133),(180,951,5,133),(181,951,1,133),(181,951,2,133),(181,951,3,133),(181,951,4,133),(181,951,5,133),(182,951,1,133),(182,951,1,134),(182,951,2,133),(182,951,2,134),(182,951,3,133),(182,951,3,134),(182,951,4,133),(182,951,4,134),(182,951,5,133),(182,951,5,134),(183,951,1,133),(183,951,1,134),(183,951,2,133),(183,951,2,134),(183,951,3,133),(183,951,3,134),(183,951,4,133),(183,951,4,134),(183,951,5,133),(183,951,5,134),(184,951,1,133),(184,951,1,134),(184,951,2,133),(184,951,2,134),(184,951,3,133),(184,951,3,134),(184,951,4,133),(184,951,4,134),(184,951,5,133),(184,951,5,134),(185,951,1,133),(185,951,1,134),(185,951,2,133),(185,951,2,134),(185,951,3,133),(185,951,3,134),(185,951,4,133),(185,951,4,134),(185,951,5,133),(185,951,5,134),(186,951,1,133),(186,951,1,134),(186,951,2,133),(186,951,2,134),(186,951,3,133),(186,951,3,134),(186,951,4,133),(186,951,4,134),(186,951,5,133),(186,951,5,134),(187,951,1,133),(187,951,1,134),(187,951,2,133),(187,951,2,134),(187,951,3,133),(187,951,3,134),(187,951,4,133),(187,951,4,134),(187,951,5,133),(187,951,5,134),(188,951,1,130),(188,951,2,130),(188,951,3,130),(188,951,4,130),(188,951,5,130),(189,951,1,130),(189,951,2,130),(189,951,3,130),(189,951,4,130),(189,951,5,130),(190,951,1,130),(190,951,2,130),(190,951,3,130),(190,951,4,130),(190,951,5,130),(191,951,1,130),(191,951,2,130),(191,951,3,130),(191,951,4,130),(191,951,5,130),(192,951,1,130),(192,951,2,130),(192,951,3,130),(192,951,4,130),(192,951,5,130),(193,951,1,130),(193,951,2,130),(193,951,3,130),(193,951,4,130),(193,951,5,130),(194,951,1,130),(194,951,2,130),(194,951,3,130),(194,951,4,130),(194,951,5,130),(195,951,1,130),(195,951,2,130),(195,951,3,130),(195,951,4,130),(195,951,5,130),(196,951,1,130),(196,951,2,130),(196,951,3,130),(196,951,4,130),(196,951,5,130),(198,951,1,134),(198,951,2,134),(198,951,3,134),(198,951,4,134),(198,951,5,134),(201,951,1,130),(201,951,2,130),(201,951,3,130),(201,951,4,130),(201,951,5,130),(202,951,1,134),(202,951,2,134),(202,951,3,134),(202,951,4,134),(202,951,5,134),(203,951,1,130),(203,951,2,130),(203,951,3,130),(203,951,4,130),(203,951,5,130),(204,951,1,134),(204,951,2,134),(204,951,3,134),(204,951,4,134),(204,951,5,134),(205,951,1,130),(205,951,2,130),(205,951,3,130),(205,951,4,130),(205,951,5,130),(206,951,1,134),(206,951,2,134),(206,951,3,134),(206,951,4,134),(206,951,5,134),(207,951,1,134),(207,951,2,134),(207,951,3,134),(207,951,4,134),(207,951,5,134),(208,951,1,130),(208,951,2,130),(208,951,3,130),(208,951,4,130),(208,951,5,130),(209,951,1,130),(209,951,2,130),(209,951,3,130),(209,951,4,130),(209,951,5,130),(210,951,1,130),(210,951,2,130),(210,951,3,130),(210,951,4,130),(210,951,5,130),(211,951,1,131),(211,951,2,131),(211,951,3,131),(211,951,4,131),(211,951,5,131),(212,951,1,131),(212,951,2,131),(212,951,3,131),(212,951,4,131),(212,951,5,131),(213,951,1,131),(213,951,2,131),(213,951,3,131),(213,951,4,131),(213,951,5,131),(214,951,1,131),(214,951,2,131),(214,951,3,131),(214,951,4,131),(214,951,5,131),(215,951,1,131),(215,951,2,131),(215,951,3,131),(215,951,4,131),(215,951,5,131),(216,951,1,131),(216,951,2,131),(216,951,3,131),(216,951,4,131),(216,951,5,131),(217,951,1,131),(217,951,2,131),(217,951,3,131),(217,951,4,131),(217,951,5,131),(218,951,1,131),(218,951,2,131),(218,951,3,131),(218,951,4,131),(218,951,5,131),(219,951,1,131),(219,951,2,131),(219,951,3,131),(219,951,4,131),(219,951,5,131),(220,951,1,131),(220,951,2,131),(220,951,3,131),(220,951,4,131),(220,951,5,131),(221,951,1,131),(221,951,2,131),(221,951,3,131),(221,951,4,131),(221,951,5,131),(222,951,1,131),(222,951,2,131),(222,951,3,131),(222,951,4,131),(222,951,5,131),(223,951,1,131),(223,951,2,131),(223,951,3,131),(223,951,4,131),(223,951,5,131),(224,951,1,131),(224,951,2,131),(224,951,3,131),(224,951,4,131),(224,951,5,131),(225,951,1,131),(225,951,2,131),(225,951,3,131),(225,951,4,131),(225,951,5,131),(226,951,1,131),(226,951,2,131),(226,951,3,131),(226,951,4,131),(226,951,5,131),(227,951,1,131),(227,951,2,131),(227,951,3,131),(227,951,4,131),(227,951,5,131),(228,951,1,131),(228,951,2,131),(228,951,3,131),(228,951,4,131),(228,951,5,131),(229,951,1,133),(229,951,1,134),(229,951,2,133),(229,951,2,134),(229,951,3,133),(229,951,3,134),(229,951,4,133),(229,951,4,134),(229,951,5,133),(229,951,5,134),(230,951,1,139),(230,951,2,139),(230,951,3,139),(230,951,4,139),(230,951,5,139),(231,951,1,139),(231,951,2,139),(231,951,3,139),(231,951,4,139),(231,951,5,139),(232,951,1,133),(232,951,2,133),(232,951,3,133),(232,951,4,133),(232,951,5,133),(233,951,1,133),(233,951,1,134),(233,951,2,133),(233,951,2,134),(233,951,3,133),(233,951,3,134),(233,951,4,133),(233,951,4,134),(233,951,5,133),(233,951,5,134),(234,951,1,139),(234,951,2,139),(234,951,3,139),(234,951,4,139),(234,951,5,139),(235,951,1,139),(235,951,2,139),(235,951,3,139),(235,951,4,139),(235,951,5,139),(236,951,1,133),(236,951,2,133),(236,951,3,133),(236,951,4,133),(236,951,5,133),(237,951,1,139),(237,951,2,139),(237,951,3,139),(237,951,4,139),(237,951,5,139),(238,951,1,139),(238,951,2,139),(238,951,3,139),(238,951,4,139),(238,951,5,139),(239,951,1,133),(239,951,2,133),(239,951,3,133),(239,951,4,133),(239,951,5,133),(240,951,1,133),(240,951,2,133),(240,951,3,133),(240,951,4,133),(240,951,5,133),(241,951,1,139),(241,951,2,139),(241,951,3,139),(241,951,4,139),(241,951,5,139),(242,951,1,139),(242,951,2,139),(242,951,3,139),(242,951,4,139),(242,951,5,139),(243,951,1,133),(243,951,2,133),(243,951,3,133),(243,951,4,133),(243,951,5,133),(244,951,1,139),(244,951,2,139),(244,951,3,139),(244,951,4,139),(244,951,5,139),(245,951,1,133),(245,951,2,133),(245,951,3,133),(245,951,4,133),(245,951,5,133),(246,951,1,133),(246,951,2,133),(246,951,3,133),(246,951,4,133),(246,951,5,133),(248,951,1,139),(248,951,2,139),(248,951,3,139),(248,951,4,139),(248,951,5,139),(249,951,1,133),(249,951,2,133),(249,951,3,133),(249,951,4,133),(249,951,5,133),(250,951,1,133),(250,951,2,133),(250,951,3,133),(250,951,4,133),(250,951,5,133),(251,951,1,133),(251,951,2,133),(251,951,3,133),(251,951,4,133),(251,951,5,133),(252,951,1,133),(252,951,2,133),(252,951,3,133),(252,951,4,133),(252,951,5,133),(253,951,1,133),(253,951,2,133),(253,951,3,133),(253,951,4,133),(253,951,5,133),(254,951,1,133),(254,951,2,133),(254,951,3,133),(254,951,4,133),(254,951,5,133),(255,951,1,133),(255,951,2,133),(255,951,3,133),(255,951,4,133),(255,951,5,133),(256,951,1,133),(256,951,2,133),(256,951,3,133),(256,951,4,133),(256,951,5,133),(257,951,1,133),(257,951,2,133),(257,951,3,133),(257,951,4,133),(257,951,5,133),(258,951,1,133),(258,951,2,133),(258,951,3,133),(258,951,4,133),(258,951,5,133),(259,951,1,139),(259,951,2,139),(259,951,3,139),(259,951,4,139),(259,951,5,139),(260,951,1,133),(260,951,2,133),(260,951,3,133),(260,951,4,133),(260,951,5,133),(261,951,1,133),(261,951,2,133),(261,951,3,133),(261,951,4,133),(261,951,5,133),(262,951,1,139),(262,951,2,139),(262,951,3,139),(262,951,4,139),(262,951,5,139),(263,951,1,139),(263,951,2,139),(263,951,3,139),(263,951,4,139),(263,951,5,139),(300,951,1,131),(300,951,2,131),(300,951,3,131),(300,951,4,131),(300,951,5,131),(301,951,1,131),(301,951,2,131),(301,951,3,131),(301,951,4,131),(301,951,5,131),(302,951,1,125),(302,951,1,139),(302,951,2,125),(302,951,2,139),(302,951,3,125),(302,951,3,139),(302,951,4,125),(302,951,4,139),(302,951,5,125),(302,951,5,139),(303,951,1,131),(303,951,2,131),(303,951,3,131),(303,951,4,131),(303,951,5,131),(304,951,1,131),(304,951,2,131),(304,951,3,131),(304,951,4,131),(304,951,5,131),(305,951,1,131),(305,951,2,131),(305,951,3,131),(305,951,4,131),(305,951,5,131),(306,951,1,125),(306,951,1,139),(306,951,2,125),(306,951,2,139),(306,951,3,125),(306,951,3,139),(306,951,4,125),(306,951,4,139),(306,951,5,125),(306,951,5,139),(307,951,1,125),(307,951,1,139),(307,951,2,125),(307,951,2,139),(307,951,3,125),(307,951,3,139),(307,951,4,125),(307,951,4,139),(307,951,5,125),(307,951,5,139),(308,951,1,131),(308,951,2,131),(308,951,3,131),(308,951,4,131),(308,951,5,131),(309,951,1,131),(309,951,2,131),(309,951,3,131),(309,951,4,131),(309,951,5,131),(310,951,1,125),(310,951,1,139),(310,951,2,125),(310,951,2,139),(310,951,3,125),(310,951,3,139),(310,951,4,125),(310,951,4,139),(310,951,5,125),(310,951,5,139),(311,951,1,131),(311,951,2,131),(311,951,3,131),(311,951,4,131),(311,951,5,131),(312,951,1,131),(312,951,2,131),(312,951,3,131),(312,951,4,131),(312,951,5,131),(313,951,1,131),(313,951,2,131),(313,951,3,131),(313,951,4,131),(313,951,5,131),(314,951,1,131),(314,951,2,131),(314,951,3,131),(314,951,4,131),(314,951,5,131),(315,951,1,131),(315,951,2,131),(315,951,3,131),(315,951,4,131),(315,951,5,131),(316,951,1,131),(316,951,2,131),(316,951,3,131),(316,951,4,131),(316,951,5,131),(317,951,1,131),(317,951,2,131),(317,951,3,131),(317,951,4,131),(317,951,5,131),(318,951,1,131),(318,951,2,131),(318,951,3,131),(318,951,4,131),(318,951,5,131),(319,951,1,131),(319,951,2,131),(319,951,3,131),(319,951,4,131),(319,951,5,131),(320,951,1,131),(320,951,2,131),(320,951,3,131),(320,951,4,131),(320,951,5,131),(321,951,1,131),(321,951,2,131),(321,951,3,131),(321,951,4,131),(321,951,5,131),(322,951,1,131),(322,951,2,131),(322,951,3,131),(322,951,4,131),(322,951,5,131),(323,951,1,131),(323,951,2,131),(323,951,3,131),(323,951,4,131),(323,951,5,131),(324,951,1,131),(324,951,2,131),(324,951,3,131),(324,951,4,131),(324,951,5,131),(325,951,1,131),(325,951,2,131),(325,951,3,131),(325,951,4,131),(325,951,5,131),(326,951,1,131),(326,951,2,131),(326,951,3,131),(326,951,4,131),(326,951,5,131),(327,951,1,131),(327,951,2,131),(327,951,3,131),(327,951,4,131),(327,951,5,131),(328,951,1,131),(328,951,2,131),(328,951,3,131),(328,951,4,131),(328,951,5,131),(329,951,1,131),(329,951,2,131),(329,951,3,131),(329,951,4,131),(329,951,5,131),(330,951,1,131),(330,951,2,131),(330,951,3,131),(330,951,4,131),(330,951,5,131),(331,951,1,131),(331,951,2,131),(331,951,3,131),(331,951,4,131),(331,951,5,131),(332,951,1,131),(332,951,2,131),(332,951,3,131),(332,951,4,131),(332,951,5,131),(333,951,1,131),(333,951,2,131),(333,951,3,131),(333,951,4,131),(333,951,5,131),(334,951,1,131),(334,951,2,131),(334,951,3,131),(334,951,4,131),(334,951,5,131),(335,951,1,131),(335,951,2,131),(335,951,3,131),(335,951,4,131),(335,951,5,131),(336,951,1,131),(336,951,2,131),(336,951,3,131),(336,951,4,131),(336,951,5,131),(337,951,1,131),(337,951,2,131),(337,951,3,131),(337,951,4,131),(337,951,5,131),(338,951,1,131),(338,951,2,131),(338,951,3,131),(338,951,4,131),(338,951,5,131),(339,951,1,131),(339,951,2,131),(339,951,3,131),(339,951,4,131),(339,951,5,131),(340,951,1,131),(340,951,2,131),(340,951,3,131),(340,951,4,131),(340,951,5,131),(341,951,1,131),(341,951,2,131),(341,951,3,131),(341,951,4,131),(341,951,5,131),(342,951,1,131),(342,951,2,131),(342,951,3,131),(342,951,4,131),(342,951,5,131),(343,951,1,131),(343,951,2,131),(343,951,3,131),(343,951,4,131),(343,951,5,131),(344,951,1,131),(344,951,2,131),(344,951,3,131),(344,951,4,131),(344,951,5,131),(345,951,1,131),(345,951,2,131),(345,951,3,131),(345,951,4,131),(345,951,5,131),(346,951,1,131),(346,951,2,131),(346,951,3,131),(346,951,4,131),(346,951,5,131),(347,951,1,131),(347,951,2,131),(347,951,3,131),(347,951,4,131),(347,951,5,131),(348,951,1,131),(348,951,2,131),(348,951,3,131),(348,951,4,131),(348,951,5,131),(349,951,1,131),(349,951,2,131),(349,951,3,131),(349,951,4,131),(349,951,5,131),(350,951,1,131),(350,951,2,131),(350,951,3,131),(350,951,4,131),(350,951,5,131),(351,951,1,131),(351,951,2,131),(351,951,3,131),(351,951,4,131),(351,951,5,131),(352,951,1,131),(352,951,2,131),(352,951,3,131),(352,951,4,131),(352,951,5,131),(353,951,1,131),(353,951,2,131),(353,951,3,131),(353,951,4,131),(353,951,5,131),(354,951,1,131),(354,951,2,131),(354,951,3,131),(354,951,4,131),(354,951,5,131),(355,951,1,131),(355,951,2,131),(355,951,3,131),(355,951,4,131),(355,951,5,131),(356,951,1,131),(356,951,2,131),(356,951,3,131),(356,951,4,131),(356,951,5,131),(357,951,1,131),(357,951,2,131),(357,951,3,131),(357,951,4,131),(357,951,5,131),(358,951,1,131),(358,951,2,131),(358,951,3,131),(358,951,4,131),(358,951,5,131),(359,951,1,131),(359,951,2,131),(359,951,3,131),(359,951,4,131),(359,951,5,131),(360,951,1,131),(360,951,2,131),(360,951,3,131),(360,951,4,131),(360,951,5,131),(361,951,1,131),(361,951,2,131),(361,951,3,131),(361,951,4,131),(361,951,5,131),(362,951,1,131),(362,951,2,131),(362,951,3,131),(362,951,4,131),(362,951,5,131),(363,951,1,131),(363,951,2,131),(363,951,3,131),(363,951,4,131),(363,951,5,131),(364,951,1,131),(364,951,2,131),(364,951,3,131),(364,951,4,131),(364,951,5,131),(365,951,1,131),(365,951,2,131),(365,951,3,131),(365,951,4,131),(365,951,5,131),(366,951,1,131),(366,951,2,131),(366,951,3,131),(366,951,4,131),(366,951,5,131),(367,951,1,131),(367,951,2,131),(367,951,3,131),(367,951,4,131),(367,951,5,131),(368,951,1,131),(368,951,2,131),(368,951,3,131),(368,951,4,131),(368,951,5,131),(369,951,1,131),(369,951,2,131),(369,951,3,131),(369,951,4,131),(369,951,5,131),(370,951,1,131),(370,951,2,131),(370,951,3,131),(370,951,4,131),(370,951,5,131),(371,951,1,131),(371,951,2,131),(371,951,3,131),(371,951,4,131),(371,951,5,131),(167,952,1,153),(167,952,2,153),(167,952,3,153),(167,952,4,153),(167,952,5,153),(168,952,1,153),(168,952,2,153),(168,952,3,153),(168,952,4,153),(168,952,5,153),(169,952,1,153),(169,952,2,153),(169,952,3,153),(169,952,4,153),(169,952,5,153),(170,952,1,153),(170,952,2,153),(170,952,3,153),(170,952,4,153),(170,952,5,153),(171,952,1,150),(171,952,2,150),(171,952,3,150),(171,952,4,150),(171,952,5,150),(172,952,1,150),(172,952,2,150),(172,952,3,150),(172,952,4,150),(172,952,5,150),(174,952,1,153),(174,952,2,153),(174,952,3,153),(174,952,4,153),(174,952,5,153),(175,952,1,150),(175,952,2,150),(175,952,3,150),(175,952,4,150),(175,952,5,150),(176,952,1,153),(176,952,2,153),(176,952,3,153),(176,952,4,153),(176,952,5,153),(177,952,1,153),(177,952,2,153),(177,952,3,153),(177,952,4,153),(177,952,5,153),(178,952,1,153),(178,952,2,153),(178,952,3,153),(178,952,4,153),(178,952,5,153),(180,952,1,153),(180,952,2,153),(180,952,3,153),(180,952,4,153),(180,952,5,153),(181,952,1,153),(181,952,2,153),(181,952,3,153),(181,952,4,153),(181,952,5,153),(182,952,1,153),(182,952,2,153),(182,952,3,153),(182,952,4,153),(182,952,5,153),(183,952,1,153),(183,952,2,153),(183,952,3,153),(183,952,4,153),(183,952,5,153),(184,952,1,153),(184,952,2,153),(184,952,3,153),(184,952,4,153),(184,952,5,153),(185,952,1,153),(185,952,2,153),(185,952,3,153),(185,952,4,153),(185,952,5,153),(186,952,1,153),(186,952,2,153),(186,952,3,153),(186,952,4,153),(186,952,5,153),(187,952,1,153),(187,952,2,153),(187,952,3,153),(187,952,4,153),(187,952,5,153),(188,952,1,150),(188,952,2,150),(188,952,3,150),(188,952,4,150),(188,952,5,150),(189,952,1,150),(189,952,2,150),(189,952,3,150),(189,952,4,150),(189,952,5,150),(190,952,1,150),(190,952,2,150),(190,952,3,150),(190,952,4,150),(190,952,5,150),(191,952,1,150),(191,952,2,150),(191,952,3,150),(191,952,4,150),(191,952,5,150),(192,952,1,150),(192,952,2,150),(192,952,3,150),(192,952,4,150),(192,952,5,150),(193,952,1,150),(193,952,2,150),(193,952,3,150),(193,952,4,150),(193,952,5,150),(194,952,1,150),(194,952,2,150),(194,952,3,150),(194,952,4,150),(194,952,5,150),(195,952,1,150),(195,952,2,150),(195,952,3,150),(195,952,4,150),(195,952,5,150),(196,952,1,150),(196,952,2,150),(196,952,3,150),(196,952,4,150),(196,952,5,150),(197,952,1,153),(197,952,2,153),(197,952,3,153),(197,952,4,153),(197,952,5,153),(198,952,1,153),(198,952,2,153),(198,952,3,153),(198,952,4,153),(198,952,5,153),(199,952,1,153),(199,952,2,153),(199,952,3,153),(199,952,4,153),(199,952,5,153),(200,952,1,153),(200,952,2,153),(200,952,3,153),(200,952,4,153),(200,952,5,153),(201,952,1,150),(201,952,2,150),(201,952,3,150),(201,952,4,150),(201,952,5,150),(202,952,1,153),(202,952,2,153),(202,952,3,153),(202,952,4,153),(202,952,5,153),(203,952,1,150),(203,952,2,150),(203,952,3,150),(203,952,4,150),(203,952,5,150),(204,952,1,153),(204,952,2,153),(204,952,3,153),(204,952,4,153),(204,952,5,153),(205,952,1,150),(205,952,2,150),(205,952,3,150),(205,952,4,150),(205,952,5,150),(206,952,1,153),(206,952,2,153),(206,952,3,153),(206,952,4,153),(206,952,5,153),(207,952,1,153),(207,952,2,153),(207,952,3,153),(207,952,4,153),(207,952,5,153),(208,952,1,150),(208,952,2,150),(208,952,3,150),(208,952,4,150),(208,952,5,150),(209,952,1,150),(209,952,2,150),(209,952,3,150),(209,952,4,150),(209,952,5,150),(210,952,1,150),(210,952,2,150),(210,952,3,150),(210,952,4,150),(210,952,5,150),(229,952,1,153),(229,952,2,153),(229,952,3,153),(229,952,4,153),(229,952,5,153),(230,952,1,147),(230,952,2,147),(230,952,3,147),(230,952,4,147),(230,952,5,147),(231,952,1,147),(231,952,2,147),(231,952,3,147),(231,952,4,147),(231,952,5,147),(232,952,1,153),(232,952,2,153),(232,952,3,153),(232,952,4,153),(232,952,5,153),(233,952,1,153),(233,952,2,153),(233,952,3,153),(233,952,4,153),(233,952,5,153),(234,952,1,147),(234,952,2,147),(234,952,3,147),(234,952,4,147),(234,952,5,147),(235,952,1,147),(235,952,2,147),(235,952,3,147),(235,952,4,147),(235,952,5,147),(236,952,1,153),(236,952,2,153),(236,952,3,153),(236,952,4,153),(236,952,5,153),(237,952,1,147),(237,952,2,147),(237,952,3,147),(237,952,4,147),(237,952,5,147),(238,952,1,147),(238,952,2,147),(238,952,3,147),(238,952,4,147),(238,952,5,147),(239,952,1,153),(239,952,2,153),(239,952,3,153),(239,952,4,153),(239,952,5,153),(240,952,1,153),(240,952,2,153),(240,952,3,153),(240,952,4,153),(240,952,5,153),(241,952,1,147),(241,952,2,147),(241,952,3,147),(241,952,4,147),(241,952,5,147),(242,952,1,147),(242,952,2,147),(242,952,3,147),(242,952,4,147),(242,952,5,147),(243,952,1,153),(243,952,2,153),(243,952,3,153),(243,952,4,153),(243,952,5,153),(244,952,1,147),(244,952,2,147),(244,952,3,147),(244,952,4,147),(244,952,5,147),(245,952,1,153),(245,952,2,153),(245,952,3,153),(245,952,4,153),(245,952,5,153),(246,952,1,153),(246,952,2,153),(246,952,3,153),(246,952,4,153),(246,952,5,153),(248,952,1,147),(248,952,2,147),(248,952,3,147),(248,952,4,147),(248,952,5,147),(249,952,1,153),(249,952,2,153),(249,952,3,153),(249,952,4,153),(249,952,5,153),(250,952,1,153),(250,952,2,153),(250,952,3,153),(250,952,4,153),(250,952,5,153),(251,952,1,153),(251,952,2,153),(251,952,3,153),(251,952,4,153),(251,952,5,153),(252,952,1,153),(252,952,2,153),(252,952,3,153),(252,952,4,153),(252,952,5,153),(253,952,1,153),(253,952,2,153),(253,952,3,153),(253,952,4,153),(253,952,5,153),(254,952,1,153),(254,952,2,153),(254,952,3,153),(254,952,4,153),(254,952,5,153),(255,952,1,153),(255,952,2,153),(255,952,3,153),(255,952,4,153),(255,952,5,153),(256,952,1,153),(256,952,2,153),(256,952,3,153),(256,952,4,153),(256,952,5,153),(257,952,1,153),(257,952,2,153),(257,952,3,153),(257,952,4,153),(257,952,5,153),(258,952,1,153),(258,952,2,153),(258,952,3,153),(258,952,4,153),(258,952,5,153),(259,952,1,147),(259,952,2,147),(259,952,3,147),(259,952,4,147),(259,952,5,147),(260,952,1,153),(260,952,2,153),(260,952,3,153),(260,952,4,153),(260,952,5,153),(261,952,1,153),(261,952,2,153),(261,952,3,153),(261,952,4,153),(261,952,5,153),(262,952,1,147),(262,952,2,147),(262,952,3,147),(262,952,4,147),(262,952,5,147),(263,952,1,147),(263,952,2,147),(263,952,3,147),(263,952,4,147),(263,952,5,147),(264,952,1,147),(264,952,2,147),(264,952,3,147),(264,952,4,147),(264,952,5,147),(265,952,1,147),(265,952,2,147),(265,952,3,147),(265,952,4,147),(265,952,5,147),(267,952,1,147),(267,952,2,147),(267,952,3,147),(267,952,4,147),(267,952,5,147),(268,952,1,147),(268,952,2,147),(268,952,3,147),(268,952,4,147),(268,952,5,147),(269,952,1,147),(269,952,2,147),(269,952,3,147),(269,952,4,147),(269,952,5,147),(271,952,1,147),(271,952,2,147),(271,952,3,147),(271,952,4,147),(271,952,5,147),(272,952,1,147),(272,952,2,147),(272,952,3,147),(272,952,4,147),(272,952,5,147),(274,952,1,147),(274,952,2,147),(274,952,3,147),(274,952,4,147),(274,952,5,147),(275,952,1,147),(275,952,2,147),(275,952,3,147),(275,952,4,147),(275,952,5,147),(277,952,1,147),(277,952,2,147),(277,952,3,147),(277,952,4,147),(277,952,5,147),(278,952,1,147),(278,952,2,147),(278,952,3,147),(278,952,4,147),(278,952,5,147),(279,952,1,147),(279,952,2,147),(279,952,3,147),(279,952,4,147),(279,952,5,147),(280,952,1,147),(280,952,2,147),(280,952,3,147),(280,952,4,147),(280,952,5,147),(281,952,1,147),(281,952,2,147),(281,952,3,147),(281,952,4,147),(281,952,5,147),(282,952,1,147),(282,952,2,147),(282,952,3,147),(282,952,4,147),(282,952,5,147),(283,952,1,147),(283,952,2,147),(283,952,3,147),(283,952,4,147),(283,952,5,147),(284,952,1,147),(284,952,2,147),(284,952,3,147),(284,952,4,147),(284,952,5,147),(285,952,1,147),(285,952,2,147),(285,952,3,147),(285,952,4,147),(285,952,5,147),(286,952,1,147),(286,952,2,147),(286,952,3,147),(286,952,4,147),(286,952,5,147),(287,952,1,147),(287,952,2,147),(287,952,3,147),(287,952,4,147),(287,952,5,147),(288,952,1,147),(288,952,2,147),(288,952,3,147),(288,952,4,147),(288,952,5,147),(289,952,1,147),(289,952,2,147),(289,952,3,147),(289,952,4,147),(289,952,5,147),(290,952,1,147),(290,952,2,147),(290,952,3,147),(290,952,4,147),(290,952,5,147),(291,952,1,147),(291,952,2,147),(291,952,3,147),(291,952,4,147),(291,952,5,147),(292,952,1,147),(292,952,2,147),(292,952,3,147),(292,952,4,147),(292,952,5,147),(293,952,1,147),(293,952,2,147),(293,952,3,147),(293,952,4,147),(293,952,5,147),(294,952,1,147),(294,952,2,147),(294,952,3,147),(294,952,4,147),(294,952,5,147),(295,952,1,147),(295,952,2,147),(295,952,3,147),(295,952,4,147),(295,952,5,147),(296,952,1,147),(296,952,2,147),(296,952,3,147),(296,952,4,147),(296,952,5,147),(297,952,1,147),(297,952,2,147),(297,952,3,147),(297,952,4,147),(297,952,5,147),(298,952,1,147),(298,952,2,147),(298,952,3,147),(298,952,4,147),(298,952,5,147),(299,952,1,147),(299,952,2,147),(299,952,3,147),(299,952,4,147),(299,952,5,147),(302,952,1,147),(302,952,2,147),(302,952,3,147),(302,952,4,147),(302,952,5,147),(306,952,1,147),(306,952,2,147),(306,952,3,147),(306,952,4,147),(306,952,5,147),(307,952,1,147),(307,952,2,147),(307,952,3,147),(307,952,4,147),(307,952,5,147),(310,952,1,147),(310,952,2,147),(310,952,3,147),(310,952,4,147),(310,952,5,147),(167,953,1,169),(167,953,2,169),(167,953,3,169),(167,953,4,169),(167,953,5,169),(168,953,1,169),(168,953,2,169),(168,953,3,169),(168,953,4,169),(168,953,5,169),(169,953,1,169),(169,953,2,169),(169,953,3,169),(169,953,4,169),(169,953,5,169),(170,953,1,169),(170,953,2,169),(170,953,3,169),(170,953,4,169),(170,953,5,169),(171,953,1,169),(171,953,2,169),(171,953,3,169),(171,953,4,169),(171,953,5,169),(172,953,1,169),(172,953,2,169),(172,953,3,169),(172,953,4,169),(172,953,5,169),(174,953,1,169),(174,953,2,169),(174,953,3,169),(174,953,4,169),(174,953,5,169),(176,953,1,166),(176,953,2,166),(176,953,3,166),(176,953,4,166),(176,953,5,166),(177,953,1,169),(177,953,2,169),(177,953,3,169),(177,953,4,169),(177,953,5,169),(178,953,1,169),(178,953,2,169),(178,953,3,169),(178,953,4,169),(178,953,5,169),(180,953,1,169),(180,953,2,169),(180,953,3,169),(180,953,4,169),(180,953,5,169),(181,953,1,169),(181,953,2,169),(181,953,3,169),(181,953,4,169),(181,953,5,169),(182,953,1,169),(182,953,2,169),(182,953,3,169),(182,953,4,169),(182,953,5,169),(183,953,1,169),(183,953,2,169),(183,953,3,169),(183,953,4,169),(183,953,5,169),(184,953,1,169),(184,953,2,169),(184,953,3,169),(184,953,4,169),(184,953,5,169),(185,953,1,169),(185,953,2,169),(185,953,3,169),(185,953,4,169),(185,953,5,169),(186,953,1,169),(186,953,2,169),(186,953,3,169),(186,953,4,169),(186,953,5,169),(187,953,1,169),(187,953,2,169),(187,953,3,169),(187,953,4,169),(187,953,5,169),(188,953,1,169),(188,953,2,169),(188,953,3,169),(188,953,4,169),(188,953,5,169),(189,953,1,169),(189,953,2,169),(189,953,3,169),(189,953,4,169),(189,953,5,169),(190,953,1,169),(190,953,2,169),(190,953,3,169),(190,953,4,169),(190,953,5,169),(191,953,1,169),(191,953,2,169),(191,953,3,169),(191,953,4,169),(191,953,5,169),(192,953,1,169),(192,953,2,169),(192,953,3,169),(192,953,4,169),(192,953,5,169),(193,953,1,169),(193,953,2,169),(193,953,3,169),(193,953,4,169),(193,953,5,169),(194,953,1,169),(194,953,2,169),(194,953,3,169),(194,953,4,169),(194,953,5,169),(195,953,1,169),(195,953,2,169),(195,953,3,169),(195,953,4,169),(195,953,5,169),(196,953,1,169),(196,953,2,169),(196,953,3,169),(196,953,4,169),(196,953,5,169),(197,953,1,169),(197,953,2,169),(197,953,3,169),(197,953,4,169),(197,953,5,169),(198,953,1,169),(198,953,2,169),(198,953,3,169),(198,953,4,169),(198,953,5,169),(199,953,1,169),(199,953,2,169),(199,953,3,169),(199,953,4,169),(199,953,5,169),(200,953,1,169),(200,953,2,169),(200,953,3,169),(200,953,4,169),(200,953,5,169),(201,953,1,169),(201,953,2,169),(201,953,3,169),(201,953,4,169),(201,953,5,169),(202,953,1,169),(202,953,2,169),(202,953,3,169),(202,953,4,169),(202,953,5,169),(203,953,1,169),(203,953,2,169),(203,953,3,169),(203,953,4,169),(203,953,5,169),(204,953,1,169),(204,953,2,169),(204,953,3,169),(204,953,4,169),(204,953,5,169),(205,953,1,169),(205,953,2,169),(205,953,3,169),(205,953,4,169),(205,953,5,169),(206,953,1,169),(206,953,2,169),(206,953,3,169),(206,953,4,169),(206,953,5,169),(207,953,1,169),(207,953,2,169),(207,953,3,169),(207,953,4,169),(207,953,5,169),(208,953,1,169),(208,953,2,169),(208,953,3,169),(208,953,4,169),(208,953,5,169),(209,953,1,169),(209,953,2,169),(209,953,3,169),(209,953,4,169),(209,953,5,169),(210,953,1,169),(210,953,2,169),(210,953,3,169),(210,953,4,169),(210,953,5,169),(211,953,1,155),(211,953,1,156),(211,953,2,155),(211,953,2,156),(211,953,3,155),(211,953,3,156),(211,953,4,155),(211,953,4,156),(211,953,5,155),(211,953,5,156),(212,953,1,155),(212,953,1,156),(212,953,1,157),(212,953,2,155),(212,953,2,156),(212,953,2,157),(212,953,3,155),(212,953,3,156),(212,953,3,157),(212,953,4,155),(212,953,4,156),(212,953,4,157),(212,953,5,155),(212,953,5,156),(212,953,5,157),(214,953,1,155),(214,953,1,156),(214,953,1,157),(214,953,2,155),(214,953,2,156),(214,953,2,157),(214,953,3,155),(214,953,3,156),(214,953,3,157),(214,953,4,155),(214,953,4,156),(214,953,4,157),(214,953,5,155),(214,953,5,156),(214,953,5,157),(215,953,1,155),(215,953,1,156),(215,953,1,157),(215,953,2,155),(215,953,2,156),(215,953,2,157),(215,953,3,155),(215,953,3,156),(215,953,3,157),(215,953,4,155),(215,953,4,156),(215,953,4,157),(215,953,5,155),(215,953,5,156),(215,953,5,157),(216,953,1,155),(216,953,1,156),(216,953,1,157),(216,953,2,155),(216,953,2,156),(216,953,2,157),(216,953,3,155),(216,953,3,156),(216,953,3,157),(216,953,4,155),(216,953,4,156),(216,953,4,157),(216,953,5,155),(216,953,5,156),(216,953,5,157),(217,953,1,155),(217,953,1,156),(217,953,1,157),(217,953,2,155),(217,953,2,156),(217,953,2,157),(217,953,3,155),(217,953,3,156),(217,953,3,157),(217,953,4,155),(217,953,4,156),(217,953,4,157),(217,953,5,155),(217,953,5,156),(217,953,5,157),(218,953,1,155),(218,953,1,156),(218,953,1,157),(218,953,2,155),(218,953,2,156),(218,953,2,157),(218,953,3,155),(218,953,3,156),(218,953,3,157),(218,953,4,155),(218,953,4,156),(218,953,4,157),(218,953,5,155),(218,953,5,156),(218,953,5,157),(219,953,1,155),(219,953,1,156),(219,953,1,157),(219,953,2,155),(219,953,2,156),(219,953,2,157),(219,953,3,155),(219,953,3,156),(219,953,3,157),(219,953,4,155),(219,953,4,156),(219,953,4,157),(219,953,5,155),(219,953,5,156),(219,953,5,157),(220,953,1,155),(220,953,1,156),(220,953,1,157),(220,953,2,155),(220,953,2,156),(220,953,2,157),(220,953,3,155),(220,953,3,156),(220,953,3,157),(220,953,4,155),(220,953,4,156),(220,953,4,157),(220,953,5,155),(220,953,5,156),(220,953,5,157),(221,953,1,155),(221,953,1,156),(221,953,1,157),(221,953,2,155),(221,953,2,156),(221,953,2,157),(221,953,3,155),(221,953,3,156),(221,953,3,157),(221,953,4,155),(221,953,4,156),(221,953,4,157),(221,953,5,155),(221,953,5,156),(221,953,5,157),(222,953,1,155),(222,953,1,156),(222,953,1,157),(222,953,2,155),(222,953,2,156),(222,953,2,157),(222,953,3,155),(222,953,3,156),(222,953,3,157),(222,953,4,155),(222,953,4,156),(222,953,4,157),(222,953,5,155),(222,953,5,156),(222,953,5,157),(223,953,1,155),(223,953,1,156),(223,953,1,157),(223,953,2,155),(223,953,2,156),(223,953,2,157),(223,953,3,155),(223,953,3,156),(223,953,3,157),(223,953,4,155),(223,953,4,156),(223,953,4,157),(223,953,5,155),(223,953,5,156),(223,953,5,157),(224,953,1,155),(224,953,1,156),(224,953,1,157),(224,953,2,155),(224,953,2,156),(224,953,2,157),(224,953,3,155),(224,953,3,156),(224,953,3,157),(224,953,4,155),(224,953,4,156),(224,953,4,157),(224,953,5,155),(224,953,5,156),(224,953,5,157),(225,953,1,155),(225,953,1,156),(225,953,1,157),(225,953,2,155),(225,953,2,156),(225,953,2,157),(225,953,3,155),(225,953,3,156),(225,953,3,157),(225,953,4,155),(225,953,4,156),(225,953,4,157),(225,953,5,155),(225,953,5,156),(225,953,5,157),(226,953,1,155),(226,953,1,156),(226,953,1,157),(226,953,2,155),(226,953,2,156),(226,953,2,157),(226,953,3,155),(226,953,3,156),(226,953,3,157),(226,953,4,155),(226,953,4,156),(226,953,4,157),(226,953,5,155),(226,953,5,156),(226,953,5,157),(227,953,1,155),(227,953,1,156),(227,953,1,157),(227,953,2,155),(227,953,2,156),(227,953,2,157),(227,953,3,155),(227,953,3,156),(227,953,3,157),(227,953,4,155),(227,953,4,156),(227,953,4,157),(227,953,5,155),(227,953,5,156),(227,953,5,157),(228,953,1,155),(228,953,1,156),(228,953,1,157),(228,953,2,155),(228,953,2,156),(228,953,2,157),(228,953,3,155),(228,953,3,156),(228,953,3,157),(228,953,4,155),(228,953,4,156),(228,953,4,157),(228,953,5,155),(228,953,5,156),(228,953,5,157),(229,953,1,169),(229,953,2,169),(229,953,3,169),(229,953,4,169),(229,953,5,169),(230,953,1,169),(230,953,2,169),(230,953,3,169),(230,953,4,169),(230,953,5,169),(231,953,1,169),(231,953,2,169),(231,953,3,169),(231,953,4,169),(231,953,5,169),(232,953,1,169),(232,953,2,169),(232,953,3,169),(232,953,4,169),(232,953,5,169),(233,953,1,169),(233,953,2,169),(233,953,3,169),(233,953,4,169),(233,953,5,169),(234,953,1,169),(234,953,2,169),(234,953,3,169),(234,953,4,169),(234,953,5,169),(235,953,1,169),(235,953,2,169),(235,953,3,169),(235,953,4,169),(235,953,5,169),(236,953,1,169),(236,953,2,169),(236,953,3,169),(236,953,4,169),(236,953,5,169),(237,953,1,169),(237,953,2,169),(237,953,3,169),(237,953,4,169),(237,953,5,169),(238,953,1,169),(238,953,2,169),(238,953,3,169),(238,953,4,169),(238,953,5,169),(239,953,1,169),(239,953,2,169),(239,953,3,169),(239,953,4,169),(239,953,5,169),(240,953,1,169),(240,953,2,169),(240,953,3,169),(240,953,4,169),(240,953,5,169),(241,953,1,169),(241,953,2,169),(241,953,3,169),(241,953,4,169),(241,953,5,169),(242,953,1,169),(242,953,2,169),(242,953,3,169),(242,953,4,169),(242,953,5,169),(243,953,1,169),(243,953,2,169),(243,953,3,169),(243,953,4,169),(243,953,5,169),(244,953,1,169),(244,953,2,169),(244,953,3,169),(244,953,4,169),(244,953,5,169),(245,953,1,169),(245,953,2,169),(245,953,3,169),(245,953,4,169),(245,953,5,169),(246,953,1,169),(246,953,2,169),(246,953,3,169),(246,953,4,169),(246,953,5,169),(248,953,1,169),(248,953,2,169),(248,953,3,169),(248,953,4,169),(248,953,5,169),(249,953,1,169),(249,953,2,169),(249,953,3,169),(249,953,4,169),(249,953,5,169),(250,953,1,169),(250,953,2,169),(250,953,3,169),(250,953,4,169),(250,953,5,169),(251,953,1,169),(251,953,2,169),(251,953,3,169),(251,953,4,169),(251,953,5,169),(252,953,1,169),(252,953,2,169),(252,953,3,169),(252,953,4,169),(252,953,5,169),(253,953,1,169),(253,953,2,169),(253,953,3,169),(253,953,4,169),(253,953,5,169),(254,953,1,169),(254,953,2,169),(254,953,3,169),(254,953,4,169),(254,953,5,169),(255,953,1,169),(255,953,2,169),(255,953,3,169),(255,953,4,169),(255,953,5,169),(256,953,1,169),(256,953,2,169),(256,953,3,169),(256,953,4,169),(256,953,5,169),(257,953,1,169),(257,953,2,169),(257,953,3,169),(257,953,4,169),(257,953,5,169),(258,953,1,169),(258,953,2,169),(258,953,3,169),(258,953,4,169),(258,953,5,169),(259,953,1,169),(259,953,2,169),(259,953,3,169),(259,953,4,169),(259,953,5,169),(260,953,1,169),(260,953,2,169),(260,953,3,169),(260,953,4,169),(260,953,5,169),(261,953,1,169),(261,953,2,169),(261,953,3,169),(261,953,4,169),(261,953,5,169),(262,953,1,169),(262,953,2,169),(262,953,3,169),(262,953,4,169),(262,953,5,169),(263,953,1,169),(263,953,2,169),(263,953,3,169),(263,953,4,169),(263,953,5,169),(301,953,1,169),(301,953,2,169),(301,953,3,169),(301,953,4,169),(301,953,5,169),(302,953,1,169),(302,953,2,169),(302,953,3,169),(302,953,4,169),(302,953,5,169),(303,953,1,169),(303,953,2,169),(303,953,3,169),(303,953,4,169),(303,953,5,169),(304,953,1,169),(304,953,2,169),(304,953,3,169),(304,953,4,169),(304,953,5,169),(305,953,1,169),(305,953,2,169),(305,953,3,169),(305,953,4,169),(305,953,5,169),(306,953,1,169),(306,953,2,169),(306,953,3,169),(306,953,4,169),(306,953,5,169),(307,953,1,169),(307,953,2,169),(307,953,3,169),(307,953,4,169),(307,953,5,169),(308,953,1,169),(308,953,2,169),(308,953,3,169),(308,953,4,169),(308,953,5,169),(309,953,1,169),(309,953,2,169),(309,953,3,169),(309,953,4,169),(309,953,5,169),(310,953,1,169),(310,953,2,169),(310,953,3,169),(310,953,4,169),(310,953,5,169),(311,953,1,169),(311,953,2,169),(311,953,3,169),(311,953,4,169),(311,953,5,169),(312,953,1,169),(312,953,2,169),(312,953,3,169),(312,953,4,169),(312,953,5,169),(313,953,1,162),(313,953,2,162),(313,953,3,162),(313,953,4,162),(313,953,5,162),(314,953,1,162),(314,953,2,162),(314,953,3,162),(314,953,4,162),(314,953,5,162),(315,953,1,162),(315,953,2,162),(315,953,3,162),(315,953,4,162),(315,953,5,162),(316,953,1,162),(316,953,2,162),(316,953,3,162),(316,953,4,162),(316,953,5,162),(317,953,1,162),(317,953,2,162),(317,953,3,162),(317,953,4,162),(317,953,5,162),(318,953,1,162),(318,953,2,162),(318,953,3,162),(318,953,4,162),(318,953,5,162),(319,953,1,162),(319,953,2,162),(319,953,3,162),(319,953,4,162),(319,953,5,162),(320,953,1,162),(320,953,2,162),(320,953,3,162),(320,953,4,162),(320,953,5,162),(321,953,1,162),(321,953,2,162),(321,953,3,162),(321,953,4,162),(321,953,5,162),(322,953,1,169),(322,953,2,169),(322,953,3,169),(322,953,4,169),(322,953,5,169),(323,953,1,169),(323,953,2,169),(323,953,3,169),(323,953,4,169),(323,953,5,169),(324,953,1,169),(324,953,2,169),(324,953,3,169),(324,953,4,169),(324,953,5,169),(325,953,1,169),(325,953,2,169),(325,953,3,169),(325,953,4,169),(325,953,5,169),(326,953,1,169),(326,953,2,169),(326,953,3,169),(326,953,4,169),(326,953,5,169),(327,953,1,169),(327,953,2,169),(327,953,3,169),(327,953,4,169),(327,953,5,169),(328,953,1,169),(328,953,2,169),(328,953,3,169),(328,953,4,169),(328,953,5,169),(329,953,1,169),(329,953,2,169),(329,953,3,169),(329,953,4,169),(329,953,5,169),(330,953,1,169),(330,953,2,169),(330,953,3,169),(330,953,4,169),(330,953,5,169),(331,953,1,169),(331,953,2,169),(331,953,3,169),(331,953,4,169),(331,953,5,169),(332,953,1,169),(332,953,2,169),(332,953,3,169),(332,953,4,169),(332,953,5,169),(333,953,1,169),(333,953,2,169),(333,953,3,169),(333,953,4,169),(333,953,5,169),(334,953,1,169),(334,953,2,169),(334,953,3,169),(334,953,4,169),(334,953,5,169),(335,953,1,169),(335,953,2,169),(335,953,3,169),(335,953,4,169),(335,953,5,169),(336,953,1,169),(336,953,2,169),(336,953,3,169),(336,953,4,169),(336,953,5,169),(337,953,1,169),(337,953,2,169),(337,953,3,169),(337,953,4,169),(337,953,5,169),(338,953,1,169),(338,953,2,169),(338,953,3,169),(338,953,4,169),(338,953,5,169),(339,953,1,169),(339,953,2,169),(339,953,3,169),(339,953,4,169),(339,953,5,169),(340,953,1,169),(340,953,2,169),(340,953,3,169),(340,953,4,169),(340,953,5,169),(341,953,1,169),(341,953,2,169),(341,953,3,169),(341,953,4,169),(341,953,5,169),(342,953,1,169),(342,953,2,169),(342,953,3,169),(342,953,4,169),(342,953,5,169),(343,953,1,169),(343,953,2,169),(343,953,3,169),(343,953,4,169),(343,953,5,169),(344,953,1,169),(344,953,2,169),(344,953,3,169),(344,953,4,169),(344,953,5,169),(345,953,1,169),(345,953,2,169),(345,953,3,169),(345,953,4,169),(345,953,5,169),(346,953,1,169),(346,953,2,169),(346,953,3,169),(346,953,4,169),(346,953,5,169),(347,953,1,169),(347,953,2,169),(347,953,3,169),(347,953,4,169),(347,953,5,169),(348,953,1,169),(348,953,2,169),(348,953,3,169),(348,953,4,169),(348,953,5,169),(349,953,1,169),(349,953,2,169),(349,953,3,169),(349,953,4,169),(349,953,5,169),(350,953,1,169),(350,953,2,169),(350,953,3,169),(350,953,4,169),(350,953,5,169),(351,953,1,169),(351,953,2,169),(351,953,3,169),(351,953,4,169),(351,953,5,169),(352,953,1,169),(352,953,2,169),(352,953,3,169),(352,953,4,169),(352,953,5,169),(353,953,1,169),(353,953,2,169),(353,953,3,169),(353,953,4,169),(353,953,5,169),(354,953,1,169),(354,953,2,169),(354,953,3,169),(354,953,4,169),(354,953,5,169),(355,953,1,169),(355,953,2,169),(355,953,3,169),(355,953,4,169),(355,953,5,169),(356,953,1,169),(356,953,2,169),(356,953,3,169),(356,953,4,169),(356,953,5,169),(357,953,1,169),(357,953,2,169),(357,953,3,169),(357,953,4,169),(357,953,5,169),(358,953,1,169),(358,953,2,169),(358,953,3,169),(358,953,4,169),(358,953,5,169),(359,953,1,169),(359,953,2,169),(359,953,3,169),(359,953,4,169),(359,953,5,169),(360,953,1,169),(360,953,2,169),(360,953,3,169),(360,953,4,169),(360,953,5,169),(361,953,1,169),(361,953,2,169),(361,953,3,169),(361,953,4,169),(361,953,5,169),(362,953,1,169),(362,953,2,169),(362,953,3,169),(362,953,4,169),(362,953,5,169),(363,953,1,169),(363,953,2,169),(363,953,3,169),(363,953,4,169),(363,953,5,169),(364,953,1,169),(364,953,2,169),(364,953,3,169),(364,953,4,169),(364,953,5,169),(365,953,1,169),(365,953,2,169),(365,953,3,169),(365,953,4,169),(365,953,5,169),(366,953,1,169),(366,953,2,169),(366,953,3,169),(366,953,4,169),(366,953,5,169),(367,953,1,169),(367,953,2,169),(367,953,3,169),(367,953,4,169),(367,953,5,169),(368,953,1,169),(368,953,2,169),(368,953,3,169),(368,953,4,169),(368,953,5,169),(369,953,1,169),(369,953,2,169),(369,953,3,169),(369,953,4,169),(369,953,5,169),(370,953,1,169),(370,953,2,169),(370,953,3,169),(370,953,4,169),(370,953,5,169),(371,953,1,169),(371,953,2,169),(371,953,3,169),(371,953,4,169),(371,953,5,169);
/*!40000 ALTER TABLE `catalog_product_index_eav_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_eav_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_eav_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `attribute_id` smallint(5) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `value` int(10) unsigned NOT NULL,
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`),
  KEY `IDX_ENTITY` (`entity_id`),
  KEY `IDX_ATTRIBUTE` (`attribute_id`),
  KEY `IDX_STORE` (`store_id`),
  KEY `IDX_VALUE` (`value`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_eav_tmp`
--

LOCK TABLES `catalog_product_index_eav_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_eav_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_eav_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price`
--

DROP TABLE IF EXISTS `catalog_product_index_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `price` decimal(12,4) DEFAULT NULL,
  `final_price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CUSTOMER_GROUP` (`customer_group_id`),
  KEY `IDX_WEBSITE` (`website_id`),
  KEY `IDX_MIN_PRICE` (`min_price`),
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_PRICE_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_PRICE_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price`
--

LOCK TABLES `catalog_product_index_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price` VALUES (188,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(189,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(190,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(191,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(192,0,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,1,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,2,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,3,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,4,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(193,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(194,0,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,1,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,2,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,3,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,4,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(195,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(197,0,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,1,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,2,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,3,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,4,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(198,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(199,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(200,0,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,1,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,2,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,3,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,4,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(201,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(202,0,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,1,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,2,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,3,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,4,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(203,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(204,0,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,1,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,2,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,3,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,4,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,0,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,1,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,2,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,3,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,4,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(206,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(208,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(209,0,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,1,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,2,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,3,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,4,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(210,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `price_type` tinyint(1) unsigned NOT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `tier_percent` decimal(12,4) DEFAULT NULL,
  `orig_price` decimal(12,4) DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  `base_tier` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `min_price` decimal(12,4) DEFAULT NULL,
  `alt_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  `alt_tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `min_price` decimal(12,4) DEFAULT NULL,
  `alt_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  `alt_tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `selection_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_type` tinyint(1) unsigned DEFAULT '0',
  `is_required` tinyint(1) unsigned DEFAULT '0',
  `price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_idx`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `selection_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_type` tinyint(1) unsigned DEFAULT '0',
  `is_required` tinyint(1) unsigned DEFAULT '0',
  `price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_sel_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_sel_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_sel_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_bundle_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_bundle_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `price_type` tinyint(1) unsigned NOT NULL,
  `special_price` decimal(12,4) DEFAULT NULL,
  `tier_percent` decimal(12,4) DEFAULT NULL,
  `orig_price` decimal(12,4) DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  `base_tier` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_bundle_tmp`
--

LOCK TABLES `catalog_product_index_price_bundle_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_bundle_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_idx` (
  `parent_id` int(10) unsigned NOT NULL,
  `child_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_agr_idx`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_agr_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_tmp` (
  `parent_id` int(10) unsigned NOT NULL,
  `child_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_agr_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_agr_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_idx`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_cfg_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_cfg_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_cfg_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_downlod_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_downlod_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_downlod_idx`
--

LOCK TABLES `catalog_product_index_price_downlod_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_downlod_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_downlod_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_downlod_tmp`
--

LOCK TABLES `catalog_product_index_price_downlod_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_downlod_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_final_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_final_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `orig_price` decimal(12,4) DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  `base_tier` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_final_idx`
--

LOCK TABLES `catalog_product_index_price_final_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_final_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_final_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_final_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_final_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `orig_price` decimal(12,4) DEFAULT NULL,
  `price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  `base_tier` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_final_tmp`
--

LOCK TABLES `catalog_product_index_price_final_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_final_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_final_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `price` decimal(12,4) DEFAULT NULL,
  `final_price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CUSTOMER_GROUP` (`customer_group_id`),
  KEY `IDX_WEBSITE` (`website_id`),
  KEY `IDX_MIN_PRICE` (`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_idx`
--

LOCK TABLES `catalog_product_index_price_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_idx` DISABLE KEYS */;
INSERT INTO `catalog_product_index_price_idx` VALUES (188,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(188,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(189,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(189,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(190,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(190,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(191,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(191,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(192,0,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,1,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,2,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,3,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(192,4,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(193,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(193,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(194,0,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,1,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,2,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,3,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(194,4,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(195,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(195,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(196,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(197,0,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,1,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,2,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,3,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(197,4,1,NULL,428.0000,428.0000,428.0000,428.0000,NULL),(198,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(198,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(199,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(199,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(200,0,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,1,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,2,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,3,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(200,4,1,NULL,488.0000,488.0000,488.0000,488.0000,NULL),(201,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(201,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(202,0,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,1,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,2,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,3,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(202,4,1,NULL,518.0000,518.0000,518.0000,518.0000,NULL),(203,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(203,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(204,0,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,1,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,2,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,3,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(204,4,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,0,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,1,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,2,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,3,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(205,4,1,NULL,208.0000,208.0000,208.0000,208.0000,NULL),(206,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(206,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(208,0,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,1,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,2,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,3,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(208,4,1,NULL,188.0000,188.0000,188.0000,188.0000,NULL),(209,0,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,1,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,2,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,3,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(209,4,1,NULL,258.0000,258.0000,258.0000,258.0000,NULL),(210,0,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,1,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,2,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,3,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL),(210,4,1,NULL,198.0000,198.0000,198.0000,198.0000,NULL);
/*!40000 ALTER TABLE `catalog_product_index_price_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_agr_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_agr_idx`
--

LOCK TABLES `catalog_product_index_price_opt_agr_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_agr_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_agr_tmp`
--

LOCK TABLES `catalog_product_index_price_opt_agr_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_agr_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_idx` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_idx`
--

LOCK TABLES `catalog_product_index_price_opt_idx` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_idx` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_opt_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_opt_tmp`
--

LOCK TABLES `catalog_product_index_price_opt_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_opt_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_price_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_price_tmp` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `tax_class_id` smallint(5) unsigned DEFAULT '0',
  `price` decimal(12,4) DEFAULT NULL,
  `final_price` decimal(12,4) DEFAULT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  `max_price` decimal(12,4) DEFAULT NULL,
  `tier_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `IDX_CUSTOMER_GROUP` (`customer_group_id`),
  KEY `IDX_WEBSITE` (`website_id`),
  KEY `IDX_MIN_PRICE` (`min_price`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_price_tmp`
--

LOCK TABLES `catalog_product_index_price_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_price_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_price_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_index_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_tier_price` (
  `entity_id` int(10) unsigned NOT NULL,
  `customer_group_id` smallint(5) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `min_price` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `FK_CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER` (`customer_group_id`),
  KEY `FK_CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE` (`website_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_TIER_PRICE_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_tier_price`
--

LOCK TABLES `catalog_product_index_tier_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_tier_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_index_tier_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_index_website`
--

DROP TABLE IF EXISTS `catalog_product_index_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_index_website` (
  `website_id` smallint(5) unsigned NOT NULL,
  `date` date DEFAULT NULL,
  `rate` float(12,4) unsigned DEFAULT '1.0000',
  PRIMARY KEY (`website_id`),
  KEY `IDX_DATE` (`date`),
  CONSTRAINT `FK_CATALOG_PRODUCT_INDEX_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_index_website`
--

LOCK TABLES `catalog_product_index_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_index_website` DISABLE KEYS */;
INSERT INTO `catalog_product_index_website` VALUES (1,'2012-07-12',1.0000);
/*!40000 ALTER TABLE `catalog_product_index_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link`
--

DROP TABLE IF EXISTS `catalog_product_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link` (
  `link_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `linked_product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `link_type_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `IDX_UNIQUE` (`link_type_id`,`product_id`,`linked_product_id`),
  KEY `FK_LINK_PRODUCT` (`product_id`),
  KEY `FK_LINKED_PRODUCT` (`linked_product_id`),
  KEY `FK_PRODUCT_LINK_TYPE` (`link_type_id`),
  CONSTRAINT `FK_PRODUCT_LINK_LINKED_PRODUCT` FOREIGN KEY (`linked_product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_PRODUCT_LINK_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_PRODUCT_LINK_TYPE` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Related products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link`
--

LOCK TABLES `catalog_product_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute` (
  `product_link_attribute_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `link_type_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `product_link_attribute_code` varchar(32) NOT NULL DEFAULT '',
  `data_type` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`product_link_attribute_id`),
  KEY `FK_ATTRIBUTE_PRODUCT_LINK_TYPE` (`link_type_id`),
  CONSTRAINT `FK_ATTRIBUTE_PRODUCT_LINK_TYPE` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='Attributes for product link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute`
--

LOCK TABLES `catalog_product_link_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute` DISABLE KEYS */;
INSERT INTO `catalog_product_link_attribute` VALUES (1,2,'qty','decimal'),(2,1,'position','int'),(3,4,'position','int'),(4,5,'position','int'),(6,1,'qty','decimal'),(7,3,'position','int'),(8,3,'qty','decimal');
/*!40000 ALTER TABLE `catalog_product_link_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_decimal`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute_decimal` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_link_attribute_id` smallint(6) unsigned DEFAULT NULL,
  `link_id` int(11) unsigned DEFAULT NULL,
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`value_id`),
  KEY `FK_DECIMAL_PRODUCT_LINK_ATTRIBUTE` (`product_link_attribute_id`),
  KEY `FK_DECIMAL_LINK` (`link_id`),
  CONSTRAINT `FK_DECIMAL_LINK` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_DECIMAL_PRODUCT_LINK_ATTRIBUTE` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Decimal attributes values';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_decimal`
--

LOCK TABLES `catalog_product_link_attribute_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_int`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute_int` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_link_attribute_id` smallint(6) unsigned DEFAULT NULL,
  `link_id` int(11) unsigned DEFAULT NULL,
  `value` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_product_link_attribute_id_link_id` (`product_link_attribute_id`,`link_id`),
  KEY `FK_INT_PRODUCT_LINK_ATTRIBUTE` (`product_link_attribute_id`),
  KEY `FK_INT_PRODUCT_LINK` (`link_id`),
  CONSTRAINT `FK_INT_PRODUCT_LINK` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_INT_PRODUCT_LINK_ATTRIBUTE` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_int`
--

LOCK TABLES `catalog_product_link_attribute_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_attribute_varchar`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_attribute_varchar` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_link_attribute_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `link_id` int(11) unsigned DEFAULT NULL,
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`value_id`),
  KEY `FK_VARCHAR_PRODUCT_LINK_ATTRIBUTE` (`product_link_attribute_id`),
  KEY `FK_VARCHAR_LINK` (`link_id`),
  CONSTRAINT `FK_VARCHAR_LINK` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_VARCHAR_PRODUCT_LINK_ATTRIBUTE` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Varchar attributes values';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_attribute_varchar`
--

LOCK TABLES `catalog_product_link_attribute_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_attribute_varchar` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_link_attribute_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_link_type`
--

DROP TABLE IF EXISTS `catalog_product_link_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_link_type` (
  `link_type_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Types of product link(Related, superproduct, bundles)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_link_type`
--

LOCK TABLES `catalog_product_link_type` WRITE;
/*!40000 ALTER TABLE `catalog_product_link_type` DISABLE KEYS */;
INSERT INTO `catalog_product_link_type` VALUES (1,'relation'),(2,'bundle'),(3,'super'),(4,'up_sell'),(5,'cross_sell');
/*!40000 ALTER TABLE `catalog_product_link_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option`
--

DROP TABLE IF EXISTS `catalog_product_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `is_require` tinyint(1) NOT NULL DEFAULT '1',
  `sku` varchar(64) NOT NULL DEFAULT '',
  `max_characters` int(10) unsigned DEFAULT NULL,
  `file_extension` varchar(50) DEFAULT NULL,
  `image_size_x` smallint(5) unsigned NOT NULL,
  `image_size_y` smallint(5) unsigned NOT NULL,
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRODUCT` (`product_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option`
--

LOCK TABLES `catalog_product_option` WRITE;
/*!40000 ALTER TABLE `catalog_product_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_price`
--

DROP TABLE IF EXISTS `catalog_product_option_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_price` (
  `option_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `price_type` enum('fixed','percent') NOT NULL DEFAULT 'fixed',
  PRIMARY KEY (`option_price_id`),
  UNIQUE KEY `UNQ_OPTION_STORE` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRICE_OPTION` (`option_id`),
  KEY `CATALOG_PRODUCT_OPTION_TITLE_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_PRICE_OPTION` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_PRICE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_price`
--

LOCK TABLES `catalog_product_option_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_title`
--

DROP TABLE IF EXISTS `catalog_product_option_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_title` (
  `option_title_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`option_title_id`),
  UNIQUE KEY `UNQ_OPTION_STORE` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TITLE_OPTION` (`option_id`),
  KEY `CATALOG_PRODUCT_OPTION_TITLE_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TITLE_OPTION` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TITLE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_title`
--

LOCK TABLES `catalog_product_option_title` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_title` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_title` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_price`
--

DROP TABLE IF EXISTS `catalog_product_option_type_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_type_price` (
  `option_type_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `price_type` enum('fixed','percent') NOT NULL DEFAULT 'fixed',
  PRIMARY KEY (`option_type_price_id`),
  UNIQUE KEY `UNQ_OPTION_TYPE_STORE` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE` (`option_type_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_price`
--

LOCK TABLES `catalog_product_option_type_price` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_type_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_title`
--

DROP TABLE IF EXISTS `catalog_product_option_type_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_type_title` (
  `option_type_title_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`option_type_title_id`),
  UNIQUE KEY `UNQ_OPTION_TYPE_STORE` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION` (`option_type_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_title`
--

LOCK TABLES `catalog_product_option_type_title` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_title` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_type_title` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_option_type_value`
--

DROP TABLE IF EXISTS `catalog_product_option_type_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_option_type_value` (
  `option_type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sku` varchar(64) NOT NULL DEFAULT '',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`option_type_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION` (`option_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_option_type_value`
--

LOCK TABLES `catalog_product_option_type_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_option_type_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_option_type_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_relation`
--

DROP TABLE IF EXISTS `catalog_product_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_relation` (
  `parent_id` int(10) unsigned NOT NULL,
  `child_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`parent_id`,`child_id`),
  KEY `IDX_CHILD` (`child_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_RELATION_CHILD` FOREIGN KEY (`child_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_RELATION_PARENT` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_relation`
--

LOCK TABLES `catalog_product_relation` WRITE;
/*!40000 ALTER TABLE `catalog_product_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_attribute` (
  `product_super_attribute_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_super_attribute_id`),
  UNIQUE KEY `UNQ_product_id_attribute_id` (`product_id`,`attribute_id`),
  KEY `FK_SUPER_PRODUCT_ATTRIBUTE_PRODUCT` (`product_id`),
  CONSTRAINT `FK_SUPER_PRODUCT_ATTRIBUTE_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute`
--

LOCK TABLES `catalog_product_super_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute_label`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_attribute_label` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_super_attribute_id` int(10) unsigned NOT NULL DEFAULT '0',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `use_default` tinyint(1) unsigned DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_ATTRIBUTE_STORE` (`product_super_attribute_id`,`store_id`),
  KEY `FK_SUPER_PRODUCT_ATTRIBUTE_LABEL` (`product_super_attribute_id`),
  KEY `FK_CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOG_PROD_SUPER_ATTR_LABEL_ATTR` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PROD_SUPER_ATTR_LABEL_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute_label`
--

LOCK TABLES `catalog_product_super_attribute_label` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_attribute_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_attribute_pricing`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_pricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_attribute_pricing` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_super_attribute_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value_index` varchar(255) NOT NULL DEFAULT '',
  `is_percent` tinyint(1) unsigned DEFAULT '0',
  `pricing_value` decimal(12,4) DEFAULT NULL,
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_product_super_attribute_id_value_index_website_id` (`product_super_attribute_id`,`value_index`,`website_id`),
  KEY `FK_SUPER_PRODUCT_ATTRIBUTE_PRICING` (`product_super_attribute_id`),
  KEY `FK_CATALOG_PRODUCT_SUPER_PRICE_WEBSITE` (`website_id`),
  CONSTRAINT `catalog_product_super_attribute_pricing_ibfk_1` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_PRODUCT_SUPER_PRICE_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_SUPER_PRODUCT_ATTRIBUTE_PRICING` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_attribute_pricing`
--

LOCK TABLES `catalog_product_super_attribute_pricing` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_attribute_pricing` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_attribute_pricing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_super_link`
--

DROP TABLE IF EXISTS `catalog_product_super_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_super_link` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `UNQ_product_id_parent_id` (`product_id`,`parent_id`),
  KEY `FK_SUPER_PRODUCT_LINK_PARENT` (`parent_id`),
  KEY `FK_catalog_product_super_link` (`product_id`),
  CONSTRAINT `catalog_product_super_link_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `catalog_product_super_link_ibfk_2` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_SUPER_PRODUCT_LINK_ENTITY` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_SUPER_PRODUCT_LINK_PARENT` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_super_link`
--

LOCK TABLES `catalog_product_super_link` WRITE;
/*!40000 ALTER TABLE `catalog_product_super_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalog_product_super_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_website`
--

DROP TABLE IF EXISTS `catalog_product_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalog_product_website` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `website_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`website_id`),
  KEY `FK_CATALOG_PRODUCT_WEBSITE_WEBSITE` (`website_id`),
  CONSTRAINT `FK_CATALOG_PRODUCT_WEBSITE_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOG_WEBSITE_PRODUCT_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalog_product_website`
--

LOCK TABLES `catalog_product_website` WRITE;
/*!40000 ALTER TABLE `catalog_product_website` DISABLE KEYS */;
INSERT INTO `catalog_product_website` VALUES (188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(208,1),(209,1),(210,1);
/*!40000 ALTER TABLE `catalog_product_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogindex_aggregation`
--

DROP TABLE IF EXISTS `catalogindex_aggregation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogindex_aggregation` (
  `aggregation_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `store_id` smallint(5) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `data` mediumtext,
  PRIMARY KEY (`aggregation_id`),
  UNIQUE KEY `IDX_STORE_KEY` (`store_id`,`key`),
  CONSTRAINT `FK_CATALOGINDEX_AGGREGATION_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogindex_aggregation`
--

LOCK TABLES `catalogindex_aggregation` WRITE;
/*!40000 ALTER TABLE `catalogindex_aggregation` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogindex_aggregation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogindex_aggregation_tag`
--

DROP TABLE IF EXISTS `catalogindex_aggregation_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogindex_aggregation_tag` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag_code` varchar(255) NOT NULL,
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `IDX_CODE` (`tag_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogindex_aggregation_tag`
--

LOCK TABLES `catalogindex_aggregation_tag` WRITE;
/*!40000 ALTER TABLE `catalogindex_aggregation_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogindex_aggregation_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogindex_aggregation_to_tag`
--

DROP TABLE IF EXISTS `catalogindex_aggregation_to_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogindex_aggregation_to_tag` (
  `aggregation_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `IDX_AGGREGATION_TAG` (`aggregation_id`,`tag_id`),
  KEY `FK_CATALOGINDEX_AGGREGATION_TO_TAG_TAG` (`tag_id`),
  CONSTRAINT `FK_CATALOGINDEX_AGGREGATION_TO_TAG_AGGREGATION` FOREIGN KEY (`aggregation_id`) REFERENCES `catalogindex_aggregation` (`aggregation_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINDEX_AGGREGATION_TO_TAG_TAG` FOREIGN KEY (`tag_id`) REFERENCES `catalogindex_aggregation_tag` (`tag_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogindex_aggregation_to_tag`
--

LOCK TABLES `catalogindex_aggregation_to_tag` WRITE;
/*!40000 ALTER TABLE `catalogindex_aggregation_to_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogindex_aggregation_to_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogindex_eav`
--

DROP TABLE IF EXISTS `catalogindex_eav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogindex_eav` (
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`store_id`,`entity_id`,`attribute_id`,`value`),
  KEY `IDX_VALUE` (`value`),
  KEY `FK_CATALOGINDEX_EAV_ENTITY` (`entity_id`),
  KEY `FK_CATALOGINDEX_EAV_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOGINDEX_EAV_STORE` (`store_id`),
  CONSTRAINT `FK_CATALOGINDEX_EAV_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINDEX_EAV_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINDEX_EAV_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogindex_eav`
--

LOCK TABLES `catalogindex_eav` WRITE;
/*!40000 ALTER TABLE `catalogindex_eav` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogindex_eav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogindex_minimal_price`
--

DROP TABLE IF EXISTS `catalogindex_minimal_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogindex_minimal_price` (
  `index_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_group_id` smallint(3) unsigned NOT NULL DEFAULT '0',
  `qty` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `tax_class_id` smallint(6) NOT NULL DEFAULT '0',
  `website_id` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`index_id`),
  KEY `IDX_VALUE` (`value`),
  KEY `IDX_QTY` (`qty`),
  KEY `FK_CATALOGINDEX_MINIMAL_PRICE_ENTITY` (`entity_id`),
  KEY `FK_CATALOGINDEX_MINIMAL_PRICE_CUSTOMER_GROUP` (`customer_group_id`),
  KEY `FK_CI_MINIMAL_PRICE_WEBSITE_ID` (`website_id`),
  KEY `IDX_FULL` (`entity_id`,`qty`,`customer_group_id`,`value`,`website_id`),
  CONSTRAINT `FK_CATALOGINDEX_MINIMAL_PRICE_CUSTOMER_GROUP` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINDEX_MINIMAL_PRICE_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CI_MINIMAL_PRICE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogindex_minimal_price`
--

LOCK TABLES `catalogindex_minimal_price` WRITE;
/*!40000 ALTER TABLE `catalogindex_minimal_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogindex_minimal_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogindex_price`
--

DROP TABLE IF EXISTS `catalogindex_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogindex_price` (
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `customer_group_id` smallint(3) unsigned NOT NULL DEFAULT '0',
  `qty` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `tax_class_id` smallint(6) NOT NULL DEFAULT '0',
  `website_id` smallint(5) unsigned DEFAULT NULL,
  KEY `IDX_VALUE` (`value`),
  KEY `IDX_QTY` (`qty`),
  KEY `FK_CATALOGINDEX_PRICE_ENTITY` (`entity_id`),
  KEY `FK_CATALOGINDEX_PRICE_ATTRIBUTE` (`attribute_id`),
  KEY `FK_CATALOGINDEX_PRICE_CUSTOMER_GROUP` (`customer_group_id`),
  KEY `IDX_RANGE_VALUE` (`entity_id`,`attribute_id`,`customer_group_id`,`value`),
  KEY `FK_CI_PRICE_WEBSITE_ID` (`website_id`),
  KEY `IDX_FULL` (`entity_id`,`attribute_id`,`customer_group_id`,`value`,`website_id`),
  CONSTRAINT `FK_CATALOGINDEX_PRICE_ATTRIBUTE` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINDEX_PRICE_ENTITY` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CI_PRICE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogindex_price`
--

LOCK TABLES `catalogindex_price` WRITE;
/*!40000 ALTER TABLE `catalogindex_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogindex_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock`
--

DROP TABLE IF EXISTS `cataloginventory_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock` (
  `stock_id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `stock_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Catalog inventory Stocks list';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock`
--

LOCK TABLES `cataloginventory_stock` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock` VALUES (1,'Default');
/*!40000 ALTER TABLE `cataloginventory_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_item`
--

DROP TABLE IF EXISTS `cataloginventory_stock_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_item` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `stock_id` smallint(4) unsigned NOT NULL DEFAULT '0',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `min_qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `use_config_min_qty` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_qty_decimal` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `backorders` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `use_config_backorders` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `min_sale_qty` decimal(12,4) NOT NULL DEFAULT '1.0000',
  `use_config_min_sale_qty` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `max_sale_qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `use_config_max_sale_qty` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_in_stock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `low_stock_date` datetime DEFAULT NULL,
  `notify_stock_qty` decimal(12,4) DEFAULT NULL,
  `use_config_notify_stock_qty` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `manage_stock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `use_config_manage_stock` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `stock_status_changed_automatically` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `use_config_qty_increments` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `qty_increments` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `use_config_enable_qty_increments` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `enable_qty_increments` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `IDX_STOCK_PRODUCT` (`product_id`,`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_ITEM_PRODUCT` (`product_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_ITEM_STOCK` (`stock_id`),
  CONSTRAINT `FK_CATALOGINVENTORY_STOCK_ITEM_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINVENTORY_STOCK_ITEM_STOCK` FOREIGN KEY (`stock_id`) REFERENCES `cataloginventory_stock` (`stock_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8 COMMENT='Invetory Stock Item Data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_item`
--

LOCK TABLES `cataloginventory_stock_item` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_item` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_item` VALUES (142,188,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(143,189,1,1000.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(144,190,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(145,191,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(146,192,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(147,193,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(148,194,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(149,195,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(150,196,1,1000.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(151,197,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(152,198,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(153,199,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(154,200,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(155,201,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(156,202,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(157,203,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(158,204,1,1000.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(159,205,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(160,206,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(162,208,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(163,209,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0),(164,210,1,100.0000,0.0000,1,0,0,1,1.0000,1,0.0000,1,1,NULL,0.0000,1,0,1,0,1,0.0000,1,0);
/*!40000 ALTER TABLE `cataloginventory_stock_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_status` (
  `product_id` int(10) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `stock_id` smallint(4) unsigned NOT NULL,
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `stock_status` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_STATUS_STOCK` (`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_STATUS_WEBSITE` (`website_id`),
  CONSTRAINT `FK_CATALOGINVENTORY_STOCK_STATUS_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINVENTORY_STOCK_STATUS_STOCK` FOREIGN KEY (`stock_id`) REFERENCES `cataloginventory_stock` (`stock_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGINVENTORY_STOCK_STATUS_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status`
--

LOCK TABLES `cataloginventory_stock_status` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status` VALUES (188,1,1,100.0000,1),(189,1,1,1000.0000,1),(190,1,1,100.0000,1),(191,1,1,100.0000,1),(192,1,1,100.0000,1),(193,1,1,100.0000,1),(194,1,1,100.0000,1),(195,1,1,100.0000,1),(196,1,1,1000.0000,1),(197,1,1,100.0000,1),(198,1,1,100.0000,1),(199,1,1,100.0000,1),(200,1,1,100.0000,1),(201,1,1,100.0000,1),(202,1,1,100.0000,1),(203,1,1,100.0000,1),(204,1,1,1000.0000,1),(205,1,1,100.0000,1),(206,1,1,100.0000,1),(208,1,1,100.0000,1),(209,1,1,100.0000,1),(210,1,1,100.0000,1);
/*!40000 ALTER TABLE `cataloginventory_stock_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_idx`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_status_idx` (
  `product_id` int(10) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `stock_id` smallint(4) unsigned NOT NULL,
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `stock_status` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_STATUS_STOCK` (`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_STATUS_WEBSITE` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_idx`
--

LOCK TABLES `cataloginventory_stock_status_idx` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` DISABLE KEYS */;
INSERT INTO `cataloginventory_stock_status_idx` VALUES (142,1,1,678.0000,1),(144,1,1,879.0000,1),(146,1,1,543.0000,1),(167,1,1,98.0000,1),(168,1,1,98.0000,1),(169,1,1,98.0000,1),(170,1,1,99.0000,1),(171,1,1,100.0000,1),(172,1,1,100.0000,1),(173,1,1,100.0000,1),(174,1,1,100.0000,1),(175,1,1,1000.0000,1),(176,1,1,100.0000,1),(177,1,1,100.0000,1),(178,1,1,100.0000,1),(179,1,1,100.0000,1),(180,1,1,100.0000,1),(181,1,1,100.0000,1),(182,1,1,1000.0000,1),(183,1,1,100.0000,1),(184,1,1,100.0000,1),(185,1,1,100.0000,1),(186,1,1,100.0000,1),(187,1,1,100.0000,1),(188,1,1,100.0000,1),(189,1,1,1000.0000,1),(190,1,1,100.0000,1),(191,1,1,100.0000,1),(192,1,1,100.0000,1),(193,1,1,100.0000,1),(194,1,1,100.0000,1),(195,1,1,100.0000,1),(196,1,1,1000.0000,1),(197,1,1,100.0000,1),(198,1,1,100.0000,1),(199,1,1,100.0000,1),(200,1,1,100.0000,1),(201,1,1,100.0000,1),(202,1,1,100.0000,1),(203,1,1,100.0000,1),(204,1,1,1000.0000,1),(205,1,1,100.0000,1),(206,1,1,100.0000,1),(207,1,1,100.0000,1),(208,1,1,100.0000,1),(209,1,1,100.0000,1),(210,1,1,100.0000,1),(211,1,1,100.0000,1),(212,1,1,100.0000,1),(213,1,1,1000.0000,1),(214,1,1,100.0000,1),(215,1,1,100.0000,1),(216,1,1,100.0000,1),(217,1,1,100.0000,1),(218,1,1,100.0000,1),(219,1,1,100.0000,1),(220,1,1,1000.0000,1),(221,1,1,100.0000,1),(222,1,1,100.0000,1),(223,1,1,100.0000,1),(224,1,1,100.0000,1),(225,1,1,100.0000,1),(226,1,1,100.0000,1),(227,1,1,100.0000,1),(228,1,1,100.0000,1),(229,1,1,100.0000,1),(230,1,1,100.0000,1),(231,1,1,1000.0000,1),(232,1,1,100.0000,1),(233,1,1,100.0000,1),(234,1,1,100.0000,1),(235,1,1,100.0000,1),(236,1,1,100.0000,1),(237,1,1,100.0000,1),(238,1,1,1000.0000,1),(239,1,1,100.0000,1),(240,1,1,100.0000,1),(241,1,1,100.0000,1),(242,1,1,100.0000,1),(243,1,1,100.0000,1),(244,1,1,100.0000,1),(245,1,1,100.0000,1),(246,1,1,1000.0000,1),(248,1,1,100.0000,1),(249,1,1,100.0000,1),(250,1,1,100.0000,1),(251,1,1,100.0000,1),(252,1,1,100.0000,1),(253,1,1,100.0000,1),(254,1,1,100.0000,1),(255,1,1,100.0000,1),(256,1,1,100.0000,1),(257,1,1,100.0000,1),(258,1,1,100.0000,1),(259,1,1,100.0000,1),(260,1,1,100.0000,1),(261,1,1,100.0000,1),(262,1,1,100.0000,1),(263,1,1,100.0000,1),(264,1,1,100.0000,1),(265,1,1,100.0000,1),(266,1,1,100.0000,1),(267,1,1,100.0000,1),(268,1,1,100.0000,1),(269,1,1,100.0000,1),(270,1,1,100.0000,1),(271,1,1,100.0000,1),(272,1,1,100.0000,1),(273,1,1,1000.0000,1),(274,1,1,100.0000,1),(275,1,1,100.0000,1),(276,1,1,100.0000,1),(277,1,1,100.0000,1),(278,1,1,1000.0000,1),(279,1,1,100.0000,1),(280,1,1,100.0000,1),(281,1,1,100.0000,1),(282,1,1,100.0000,1),(283,1,1,100.0000,1),(284,1,1,100.0000,1),(285,1,1,100.0000,1),(286,1,1,100.0000,1),(287,1,1,100.0000,1),(288,1,1,100.0000,1),(289,1,1,100.0000,1),(290,1,1,100.0000,1),(291,1,1,100.0000,1),(292,1,1,100.0000,1),(293,1,1,100.0000,1),(294,1,1,100.0000,1),(295,1,1,100.0000,1),(296,1,1,100.0000,1),(297,1,1,100.0000,1),(298,1,1,100.0000,1),(299,1,1,100.0000,1),(300,1,1,100.0000,1),(301,1,1,100.0000,1),(302,1,1,1000.0000,1),(303,1,1,100.0000,1),(304,1,1,100.0000,1),(305,1,1,100.0000,1),(306,1,1,100.0000,1),(307,1,1,100.0000,1),(308,1,1,100.0000,1),(309,1,1,100.0000,1),(310,1,1,1000.0000,1),(311,1,1,100.0000,1),(312,1,1,100.0000,1),(313,1,1,100.0000,1),(314,1,1,100.0000,1),(315,1,1,1000.0000,1),(316,1,1,100.0000,1),(317,1,1,1000.0000,1),(318,1,1,100.0000,1),(319,1,1,100.0000,1),(320,1,1,100.0000,1),(321,1,1,100.0000,1),(322,1,1,100.0000,1),(323,1,1,100.0000,1),(324,1,1,1000.0000,1),(325,1,1,100.0000,1),(326,1,1,100.0000,1),(327,1,1,100.0000,1),(328,1,1,100.0000,1),(329,1,1,100.0000,1),(330,1,1,100.0000,1),(331,1,1,100.0000,1),(332,1,1,1000.0000,1),(333,1,1,100.0000,1),(334,1,1,100.0000,1),(335,1,1,100.0000,1),(336,1,1,100.0000,1),(337,1,1,100.0000,1),(338,1,1,100.0000,1),(339,1,1,100.0000,1),(340,1,1,1000.0000,1),(341,1,1,100.0000,1),(342,1,1,100.0000,1),(343,1,1,100.0000,1),(344,1,1,100.0000,1),(345,1,1,100.0000,1),(346,1,1,100.0000,1),(347,1,1,100.0000,1),(348,1,1,100.0000,1),(349,1,1,100.0000,1),(350,1,1,100.0000,1),(351,1,1,100.0000,1),(352,1,1,100.0000,1),(353,1,1,1000.0000,1),(354,1,1,100.0000,1),(355,1,1,100.0000,1),(356,1,1,100.0000,1),(357,1,1,100.0000,1),(358,1,1,100.0000,1),(359,1,1,100.0000,1),(360,1,1,100.0000,1),(361,1,1,1000.0000,1),(362,1,1,100.0000,1),(363,1,1,100.0000,1),(364,1,1,100.0000,1),(365,1,1,100.0000,1),(366,1,1,100.0000,1),(367,1,1,100.0000,1),(368,1,1,100.0000,1),(369,1,1,100.0000,1),(370,1,1,100.0000,1),(371,1,1,100.0000,1);
/*!40000 ALTER TABLE `cataloginventory_stock_status_idx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cataloginventory_stock_status_tmp`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cataloginventory_stock_status_tmp` (
  `product_id` int(10) unsigned NOT NULL,
  `website_id` smallint(5) unsigned NOT NULL,
  `stock_id` smallint(4) unsigned NOT NULL,
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `stock_status` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_STATUS_STOCK` (`stock_id`),
  KEY `FK_CATALOGINVENTORY_STOCK_STATUS_WEBSITE` (`website_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cataloginventory_stock_status_tmp`
--

LOCK TABLES `cataloginventory_stock_status_tmp` WRITE;
/*!40000 ALTER TABLE `cataloginventory_stock_status_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `cataloginventory_stock_status_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule`
--

DROP TABLE IF EXISTS `catalogrule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `customer_group_ids` text,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  `conditions_serialized` mediumtext NOT NULL,
  `actions_serialized` mediumtext NOT NULL,
  `stop_rules_processing` tinyint(1) NOT NULL DEFAULT '1',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  `simple_action` varchar(32) NOT NULL,
  `discount_amount` decimal(12,4) NOT NULL,
  `website_ids` text,
  PRIMARY KEY (`rule_id`),
  KEY `sort_order` (`is_active`,`sort_order`,`to_date`,`from_date`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule`
--

LOCK TABLES `catalogrule` WRITE;
/*!40000 ALTER TABLE `catalogrule` DISABLE KEYS */;
INSERT INTO `catalogrule` VALUES (1,'Sony Sale','20% discount on all Sony products.','2008-08-25','2009-01-31','0,1,2,3',1,'a:7:{s:4:\"type\";s:34:\"catalogrule/rule_condition_combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";s:10:\"conditions\";a:2:{i:0;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:12:\"manufacturer\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:0:\"\";s:18:\"is_value_processed\";b:0;}i:1;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:5:\"price\";s:8:\"operator\";s:2:\"<=\";s:5:\"value\";d:100;s:18:\"is_value_processed\";b:0;}}}','a:4:{s:4:\"type\";s:34:\"catalogrule/rule_action_collection\";s:9:\"attribute\";N;s:8:\"operator\";s:1:\"=\";s:5:\"value\";N;}',1,0,'by_percent',0.0000,'1'),(3,'CODEDEMOSTORE','10% off all Toshiba laptops','2008-08-06','2009-08-23','0,1,2,4',1,'a:7:{s:4:\"type\";s:34:\"catalogrule/rule_condition_combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";s:10:\"conditions\";a:1:{i:0;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:12:\"manufacturer\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:0:\"\";s:18:\"is_value_processed\";b:0;}}}','a:4:{s:4:\"type\";s:34:\"catalogrule/rule_action_collection\";s:9:\"attribute\";N;s:8:\"operator\";s:1:\"=\";s:5:\"value\";N;}',0,0,'by_percent',0.0000,'1'),(4,'Anashria 20 percent Off','','2008-08-27','2009-08-28','0,1,2,4',1,'a:7:{s:4:\"type\";s:34:\"catalogrule/rule_condition_combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";s:10:\"conditions\";a:1:{i:0;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:3:\"sku\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:3:\"ana\";s:18:\"is_value_processed\";b:0;}}}','a:4:{s:4:\"type\";s:34:\"catalogrule/rule_action_collection\";s:9:\"attribute\";N;s:8:\"operator\";s:1:\"=\";s:5:\"value\";N;}',1,0,'by_percent',0.0000,'1'),(5,'20 percent off selected Furniture','','2008-08-24','2009-09-28','0,1,2,4',1,'a:7:{s:4:\"type\";s:34:\"catalogrule/rule_condition_combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"any\";s:10:\"conditions\";a:3:{i:0;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:3:\"sku\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"384822\";s:18:\"is_value_processed\";b:0;}i:1;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:3:\"sku\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"349838\";s:18:\"is_value_processed\";b:0;}i:2;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:3:\"sku\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"1112\";s:18:\"is_value_processed\";b:0;}}}','a:4:{s:4:\"type\";s:34:\"catalogrule/rule_action_collection\";s:9:\"attribute\";N;s:8:\"operator\";s:1:\"=\";s:5:\"value\";N;}',1,0,'by_percent',0.0000,'1'),(6,'20 percent off T shirts','','2008-08-28','2009-10-30','0,1,2',1,'a:7:{s:4:\"type\";s:34:\"catalogrule/rule_condition_combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";s:10:\"conditions\";a:1:{i:0;a:5:{s:4:\"type\";s:34:\"catalogrule/rule_condition_product\";s:9:\"attribute\";s:16:\"attribute_set_id\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:2:\"41\";s:18:\"is_value_processed\";b:0;}}}','a:4:{s:4:\"type\";s:34:\"catalogrule/rule_action_collection\";s:9:\"attribute\";N;s:8:\"operator\";s:1:\"=\";s:5:\"value\";N;}',0,0,'by_percent',0.0000,'1'),(7,'Christmas Rule','','2008-12-21','2009-01-24','0,1,2,3,4',0,'a:6:{s:4:\"type\";s:34:\"catalogrule/rule_condition_combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";}','a:4:{s:4:\"type\";s:34:\"catalogrule/rule_action_collection\";s:9:\"attribute\";N;s:8:\"operator\";s:1:\"=\";s:5:\"value\";N;}',0,0,'by_percent',10.0000,'1');
/*!40000 ALTER TABLE `catalogrule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_affected_product`
--

DROP TABLE IF EXISTS `catalogrule_affected_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_affected_product` (
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_affected_product`
--

LOCK TABLES `catalogrule_affected_product` WRITE;
/*!40000 ALTER TABLE `catalogrule_affected_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_affected_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_group_website`
--

DROP TABLE IF EXISTS `catalogrule_group_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_group_website` (
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `rule_id` (`rule_id`),
  KEY `customer_group_id` (`customer_group_id`),
  KEY `website_id` (`website_id`),
  CONSTRAINT `FK_CATALOGRULE_GROUP_WEBSITE_GROUP` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_GROUP_WEBSITE_RULE` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_GROUP_WEBSITE_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_group_website`
--

LOCK TABLES `catalogrule_group_website` WRITE;
/*!40000 ALTER TABLE `catalogrule_group_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_group_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product`
--

DROP TABLE IF EXISTS `catalogrule_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_product` (
  `rule_product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_time` int(10) unsigned NOT NULL DEFAULT '0',
  `to_time` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `action_operator` enum('to_fixed','to_percent','by_fixed','by_percent') NOT NULL DEFAULT 'to_fixed',
  `action_amount` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `action_stop` tinyint(1) NOT NULL DEFAULT '0',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  `website_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `sort_order` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `FK_catalogrule_product_rule` (`rule_id`),
  KEY `FK_catalogrule_product_customergroup` (`customer_group_id`),
  KEY `FK_catalogrule_product_website` (`website_id`),
  KEY `FK_CATALOGRULE_PRODUCT_PRODUCT` (`product_id`),
  KEY `IDX_FROM_TIME` (`from_time`),
  KEY `IDX_TO_TIME` (`to_time`),
  CONSTRAINT `FK_catalogrule_product_customergroup` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_PRODUCT_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_catalogrule_product_rule` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_catalogrule_product_website` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1167 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product`
--

LOCK TABLES `catalogrule_product` WRITE;
/*!40000 ALTER TABLE `catalogrule_product` DISABLE KEYS */;
INSERT INTO `catalogrule_product` VALUES (1079,3,1217980800,1251071999,0,188,'by_percent',0.0000,0,0,1),(1080,3,1217980800,1251071999,1,188,'by_percent',0.0000,0,0,1),(1081,3,1217980800,1251071999,2,188,'by_percent',0.0000,0,0,1),(1082,3,1217980800,1251071999,4,188,'by_percent',0.0000,0,0,1),(1083,3,1217980800,1251071999,0,189,'by_percent',0.0000,0,0,1),(1084,3,1217980800,1251071999,1,189,'by_percent',0.0000,0,0,1),(1085,3,1217980800,1251071999,2,189,'by_percent',0.0000,0,0,1),(1086,3,1217980800,1251071999,4,189,'by_percent',0.0000,0,0,1),(1087,3,1217980800,1251071999,0,190,'by_percent',0.0000,0,0,1),(1088,3,1217980800,1251071999,1,190,'by_percent',0.0000,0,0,1),(1089,3,1217980800,1251071999,2,190,'by_percent',0.0000,0,0,1),(1090,3,1217980800,1251071999,4,190,'by_percent',0.0000,0,0,1),(1091,3,1217980800,1251071999,0,191,'by_percent',0.0000,0,0,1),(1092,3,1217980800,1251071999,1,191,'by_percent',0.0000,0,0,1),(1093,3,1217980800,1251071999,2,191,'by_percent',0.0000,0,0,1),(1094,3,1217980800,1251071999,4,191,'by_percent',0.0000,0,0,1),(1095,3,1217980800,1251071999,0,192,'by_percent',0.0000,0,0,1),(1096,3,1217980800,1251071999,1,192,'by_percent',0.0000,0,0,1),(1097,3,1217980800,1251071999,2,192,'by_percent',0.0000,0,0,1),(1098,3,1217980800,1251071999,4,192,'by_percent',0.0000,0,0,1),(1099,3,1217980800,1251071999,0,193,'by_percent',0.0000,0,0,1),(1100,3,1217980800,1251071999,1,193,'by_percent',0.0000,0,0,1),(1101,3,1217980800,1251071999,2,193,'by_percent',0.0000,0,0,1),(1102,3,1217980800,1251071999,4,193,'by_percent',0.0000,0,0,1),(1103,3,1217980800,1251071999,0,194,'by_percent',0.0000,0,0,1),(1104,3,1217980800,1251071999,1,194,'by_percent',0.0000,0,0,1),(1105,3,1217980800,1251071999,2,194,'by_percent',0.0000,0,0,1),(1106,3,1217980800,1251071999,4,194,'by_percent',0.0000,0,0,1),(1107,3,1217980800,1251071999,0,195,'by_percent',0.0000,0,0,1),(1108,3,1217980800,1251071999,1,195,'by_percent',0.0000,0,0,1),(1109,3,1217980800,1251071999,2,195,'by_percent',0.0000,0,0,1),(1110,3,1217980800,1251071999,4,195,'by_percent',0.0000,0,0,1),(1111,3,1217980800,1251071999,0,196,'by_percent',0.0000,0,0,1),(1112,3,1217980800,1251071999,1,196,'by_percent',0.0000,0,0,1),(1113,3,1217980800,1251071999,2,196,'by_percent',0.0000,0,0,1),(1114,3,1217980800,1251071999,4,196,'by_percent',0.0000,0,0,1),(1115,3,1217980800,1251071999,0,197,'by_percent',0.0000,0,0,1),(1116,3,1217980800,1251071999,1,197,'by_percent',0.0000,0,0,1),(1117,3,1217980800,1251071999,2,197,'by_percent',0.0000,0,0,1),(1118,3,1217980800,1251071999,4,197,'by_percent',0.0000,0,0,1),(1119,3,1217980800,1251071999,0,198,'by_percent',0.0000,0,0,1),(1120,3,1217980800,1251071999,1,198,'by_percent',0.0000,0,0,1),(1121,3,1217980800,1251071999,2,198,'by_percent',0.0000,0,0,1),(1122,3,1217980800,1251071999,4,198,'by_percent',0.0000,0,0,1),(1123,3,1217980800,1251071999,0,199,'by_percent',0.0000,0,0,1),(1124,3,1217980800,1251071999,1,199,'by_percent',0.0000,0,0,1),(1125,3,1217980800,1251071999,2,199,'by_percent',0.0000,0,0,1),(1126,3,1217980800,1251071999,4,199,'by_percent',0.0000,0,0,1),(1127,3,1217980800,1251071999,0,200,'by_percent',0.0000,0,0,1),(1128,3,1217980800,1251071999,1,200,'by_percent',0.0000,0,0,1),(1129,3,1217980800,1251071999,2,200,'by_percent',0.0000,0,0,1),(1130,3,1217980800,1251071999,4,200,'by_percent',0.0000,0,0,1),(1131,3,1217980800,1251071999,0,201,'by_percent',0.0000,0,0,1),(1132,3,1217980800,1251071999,1,201,'by_percent',0.0000,0,0,1),(1133,3,1217980800,1251071999,2,201,'by_percent',0.0000,0,0,1),(1134,3,1217980800,1251071999,4,201,'by_percent',0.0000,0,0,1),(1135,3,1217980800,1251071999,0,202,'by_percent',0.0000,0,0,1),(1136,3,1217980800,1251071999,1,202,'by_percent',0.0000,0,0,1),(1137,3,1217980800,1251071999,2,202,'by_percent',0.0000,0,0,1),(1138,3,1217980800,1251071999,4,202,'by_percent',0.0000,0,0,1),(1139,3,1217980800,1251071999,0,203,'by_percent',0.0000,0,0,1),(1140,3,1217980800,1251071999,1,203,'by_percent',0.0000,0,0,1),(1141,3,1217980800,1251071999,2,203,'by_percent',0.0000,0,0,1),(1142,3,1217980800,1251071999,4,203,'by_percent',0.0000,0,0,1),(1143,3,1217980800,1251071999,0,204,'by_percent',0.0000,0,0,1),(1144,3,1217980800,1251071999,1,204,'by_percent',0.0000,0,0,1),(1145,3,1217980800,1251071999,2,204,'by_percent',0.0000,0,0,1),(1146,3,1217980800,1251071999,4,204,'by_percent',0.0000,0,0,1),(1147,3,1217980800,1251071999,0,205,'by_percent',0.0000,0,0,1),(1148,3,1217980800,1251071999,1,205,'by_percent',0.0000,0,0,1),(1149,3,1217980800,1251071999,2,205,'by_percent',0.0000,0,0,1),(1150,3,1217980800,1251071999,4,205,'by_percent',0.0000,0,0,1),(1151,3,1217980800,1251071999,0,206,'by_percent',0.0000,0,0,1),(1152,3,1217980800,1251071999,1,206,'by_percent',0.0000,0,0,1),(1153,3,1217980800,1251071999,2,206,'by_percent',0.0000,0,0,1),(1154,3,1217980800,1251071999,4,206,'by_percent',0.0000,0,0,1),(1155,3,1217980800,1251071999,0,208,'by_percent',0.0000,0,0,1),(1156,3,1217980800,1251071999,1,208,'by_percent',0.0000,0,0,1),(1157,3,1217980800,1251071999,2,208,'by_percent',0.0000,0,0,1),(1158,3,1217980800,1251071999,4,208,'by_percent',0.0000,0,0,1),(1159,3,1217980800,1251071999,0,209,'by_percent',0.0000,0,0,1),(1160,3,1217980800,1251071999,1,209,'by_percent',0.0000,0,0,1),(1161,3,1217980800,1251071999,2,209,'by_percent',0.0000,0,0,1),(1162,3,1217980800,1251071999,4,209,'by_percent',0.0000,0,0,1),(1163,3,1217980800,1251071999,0,210,'by_percent',0.0000,0,0,1),(1164,3,1217980800,1251071999,1,210,'by_percent',0.0000,0,0,1),(1165,3,1217980800,1251071999,2,210,'by_percent',0.0000,0,0,1),(1166,3,1217980800,1251071999,4,210,'by_percent',0.0000,0,0,1);
/*!40000 ALTER TABLE `catalogrule_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogrule_product_price`
--

DROP TABLE IF EXISTS `catalogrule_product_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogrule_product_price` (
  `rule_product_price_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rule_date` date NOT NULL DEFAULT '0000-00-00',
  `customer_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rule_price` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `website_id` smallint(5) unsigned NOT NULL,
  `latest_start_date` date DEFAULT NULL,
  `earliest_end_date` date DEFAULT NULL,
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `rule_date` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `FK_catalogrule_product_price_customergroup` (`customer_group_id`),
  KEY `FK_catalogrule_product_price_website` (`website_id`),
  KEY `FK_CATALOGRULE_PRODUCT_PRICE_PRODUCT` (`product_id`),
  CONSTRAINT `FK_catalogrule_product_price_customergroup` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGRULE_PRODUCT_PRICE_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_catalogrule_product_price_website` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogrule_product_price`
--

LOCK TABLES `catalogrule_product_price` WRITE;
/*!40000 ALTER TABLE `catalogrule_product_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogrule_product_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_fulltext`
--

DROP TABLE IF EXISTS `catalogsearch_fulltext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogsearch_fulltext` (
  `product_id` int(10) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  `data_index` longtext NOT NULL,
  PRIMARY KEY (`product_id`,`store_id`),
  FULLTEXT KEY `data_index` (`data_index`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_fulltext`
--

LOCK TABLES `catalogsearch_fulltext` WRITE;
/*!40000 ALTER TABLE `catalogsearch_fulltext` DISABLE KEYS */;
INSERT INTO `catalogsearch_fulltext` VALUES (193,2,'tb-14420097483|激活|儿童节|定制公主水晶石儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(194,2,'tb-16950456931|激活|儿童节|个性定制时装女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;56432-wat12601机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;潮流时尚表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(195,2,'tb-16916368211|激活|儿童节|个性时间认知儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定会很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 15～19CM 镜面 2.0CM 材质 表带:尼龙/硅胶 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(196,2,'tb-16769128988|激活|儿童节|早教儿童认知时间手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(197,2,'tb-15248759961|激活|情人节|个性创意时尚镶钻表||生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50890-wat12201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||428|1'),(201,1,'tb-15176883730|激活|儿童节|个性定制复古经典女童手表|小孩|生日|具有古典怀旧风格的一款手表，圆形的表壳镶嵌着古典风格花纹图案，具有古罗马复古气息，是女孩子的最爱！ 表盘可选择你喜欢的公主、可爱的小米妮，或任意一款你喜欢的图案。一定别忘了写上你的名字哦！你叫LINDA?印上你的名字后，这就是一块专属于LINDA的手表啦！ 真皮表带，戴上后舒适又时尚，还可任意选择你喜欢的颜色。你喜欢甜美的粉红色？没问题，喜欢什么就是什么！ 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84844-wat10601机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;30mm品牌产地:&nbsp;中国元素:&nbsp;复古表壳材质:&nbsp;合金|个性定制手表,儿童手表||188|1'),(193,4,'tb-14420097483|激活|儿童节|定制公主水晶石儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(194,4,'tb-16950456931|激活|儿童节|个性定制时装女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;56432-wat12601机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;潮流时尚表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(196,3,'tb-16769128988|激活|儿童节|早教儿童认知时间手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(193,5,'tb-14420097483|激活|儿童节|定制公主水晶石儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(210,1,'tb-10220121642|激活|儿童节|卡通风个性男款儿童手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的大男孩——通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 产品特点： 表壳 合金 抛光 宽4.2cm 后盖 不锈钢 表带 硅胶表带 表扣 不锈钢 机芯 3指针日本原装机芯，电池可用两年 防水 3 ATM 生活防水，不可配戴游泳、洗澡 长度 约25.4 cm 重量 约60g 腕长 适合手腕13.3cm至19.2cm 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至7天； 包装：可以选用包装盒。|个性定制手表,儿童手表||198|1'),(210,3,'tb-10220121642|激活|儿童节|卡通风个性男款儿童手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的大男孩——通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 产品特点： 表壳 合金 抛光 宽4.2cm 后盖 不锈钢 表带 硅胶表带 表扣 不锈钢 机芯 3指针日本原装机芯，电池可用两年 防水 3 ATM 生活防水，不可配戴游泳、洗澡 长度 约25.4 cm 重量 约60g 腕长 适合手腕13.3cm至19.2cm 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至7天； 包装：可以选用包装盒。|个性定制手表,儿童手表||198|1'),(208,5,'tb-14450913511|激活|儿童节|经典定制女表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带20CM 腕围 14～18CM 镜面 2.5CM 材质 表带:真皮 表壳:合金 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||188|1'),(209,4,'tb-14425318838|激活|儿童节|个性创意时尚女钢表|小孩|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，纯钢表带，精工制造，高贵中彰显气质。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400152-wat11201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;精钢表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;7mm尺寸:&nbsp;32mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;精钢|个性定制手表,时尚女表||258|1'),(210,4,'tb-10220121642|激活|儿童节|卡通风个性男款儿童手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的大男孩——通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 产品特点： 表壳 合金 抛光 宽4.2cm 后盖 不锈钢 表带 硅胶表带 表扣 不锈钢 机芯 3指针日本原装机芯，电池可用两年 防水 3 ATM 生活防水，不可配戴游泳、洗澡 长度 约25.4 cm 重量 约60g 腕长 适合手腕13.3cm至19.2cm 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至7天； 包装：可以选用包装盒。|个性定制手表,儿童手表||198|1'),(208,1,'tb-14450913511|激活|儿童节|经典定制女表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带20CM 腕围 14～18CM 镜面 2.5CM 材质 表带:真皮 表壳:合金 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||188|1'),(209,1,'tb-14425318838|激活|儿童节|个性创意时尚女钢表|小孩|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，纯钢表带，精工制造，高贵中彰显气质。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400152-wat11201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;精钢表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;7mm尺寸:&nbsp;32mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;精钢|个性定制手表,时尚女表||258|1'),(210,5,'tb-10220121642|激活|儿童节|卡通风个性男款儿童手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的大男孩——通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 产品特点： 表壳 合金 抛光 宽4.2cm 后盖 不锈钢 表带 硅胶表带 表扣 不锈钢 机芯 3指针日本原装机芯，电池可用两年 防水 3 ATM 生活防水，不可配戴游泳、洗澡 长度 约25.4 cm 重量 约60g 腕长 适合手腕13.3cm至19.2cm 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至7天； 包装：可以选用包装盒。|个性定制手表,儿童手表||198|1'),(206,1,'tb-14469030397|激活|情人节|定制户外运动挂表|男朋友|生日|热爱户外运动的你，一定少不了这款个性挂表。 和你一样，这款表也是自由不羁的，可以随意定制。 只要把它挂在背包上，它就会跟随你的脚步，给你时间和方向。 优质合金夜光针和指南针，让你即使在昏暗的野外，也能识别时间。 即使一个人远行，有它一路上的陪伴，也一定不 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;59009-wat11801机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;户外运动表带材质:&nbsp;合金表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,运动手表||198|1'),(209,5,'tb-14425318838|激活|儿童节|个性创意时尚女钢表|小孩|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，纯钢表带，精工制造，高贵中彰显气质。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400152-wat11201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;精钢表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;7mm尺寸:&nbsp;32mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;精钢|个性定制手表,时尚女表||258|1'),(205,4,'tb-14470362811|激活|儿童节|个性定制时尚潮流镶钻女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;B6239-wat12001机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;椭圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;水钻表壳材质:&nbsp;合金|个性定制手表,时尚女表||208|1'),(203,1,'tb-14483017901|激活|儿童节|个性定制儿童运动女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400312-wat12301机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;硅胶表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的女孩&mdash;&mdash;通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 可旋转表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的硅胶表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。想要试试吗？点击下面的按钮，快来感受一下定制的乐趣吧！喜爱运动的你，一定会喜欢这些个性十足的运动手表Color/绿色Color/蓝色Color/橙色Color/黑色可旋转表壳，带有分钟数字，可让孩子更好地学习认知时间后盖可激光雕刻你喜欢的祝福文字不锈钢外壳可供你选择多种颜色的硅胶表带，戴上舒适又方便|个性定制手表,儿童手表||188|1'),(204,2,'tb-14480890920|激活|情人节|个性定制男表|男朋友|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;44445-wat12101机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚男表||208|1'),(205,2,'tb-14470362811|激活|儿童节|个性定制时尚潮流镶钻女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;B6239-wat12001机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;椭圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;水钻表壳材质:&nbsp;合金|个性定制手表,时尚女表||208|1'),(209,3,'tb-14425318838|激活|儿童节|个性创意时尚女钢表|小孩|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，纯钢表带，精工制造，高贵中彰显气质。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400152-wat11201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;精钢表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;7mm尺寸:&nbsp;32mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;精钢|个性定制手表,时尚女表||258|1'),(208,4,'tb-14450913511|激活|儿童节|经典定制女表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带20CM 腕围 14～18CM 镜面 2.5CM 材质 表带:真皮 表壳:合金 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||188|1'),(197,1,'tb-15248759961|激活|情人节|个性创意时尚镶钻表||生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50890-wat12201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||428|1'),(208,2,'tb-14450913511|激活|儿童节|经典定制女表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带20CM 腕围 14～18CM 镜面 2.5CM 材质 表带:真皮 表壳:合金 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||188|1'),(205,3,'tb-14470362811|激活|儿童节|个性定制时尚潮流镶钻女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;B6239-wat12001机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;椭圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;水钻表壳材质:&nbsp;合金|个性定制手表,时尚女表||208|1'),(202,4,'tb-14501358291|激活|情人节|个性刻字定制男钢表|男朋友|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;SA10-wat12801机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚男表||518|1'),(203,4,'tb-14483017901|激活|儿童节|个性定制儿童运动女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400312-wat12301机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;硅胶表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的女孩&mdash;&mdash;通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 可旋转表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的硅胶表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。想要试试吗？点击下面的按钮，快来感受一下定制的乐趣吧！喜爱运动的你，一定会喜欢这些个性十足的运动手表Color/绿色Color/蓝色Color/橙色Color/黑色可旋转表壳，带有分钟数字，可让孩子更好地学习认知时间后盖可激光雕刻你喜欢的祝福文字不锈钢外壳可供你选择多种颜色的硅胶表带，戴上舒适又方便|个性定制手表,儿童手表||188|1'),(205,1,'tb-14470362811|激活|儿童节|个性定制时尚潮流镶钻女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;B6239-wat12001机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;椭圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;水钻表壳材质:&nbsp;合金|个性定制手表,时尚女表||208|1'),(210,2,'tb-10220121642|激活|儿童节|卡通风个性男款儿童手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的大男孩——通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 产品特点： 表壳 合金 抛光 宽4.2cm 后盖 不锈钢 表带 硅胶表带 表扣 不锈钢 机芯 3指针日本原装机芯，电池可用两年 防水 3 ATM 生活防水，不可配戴游泳、洗澡 长度 约25.4 cm 重量 约60g 腕长 适合手腕13.3cm至19.2cm 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至7天； 包装：可以选用包装盒。|个性定制手表,儿童手表||198|1'),(209,2,'tb-14425318838|激活|儿童节|个性创意时尚女钢表|小孩|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，纯钢表带，精工制造，高贵中彰显气质。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400152-wat11201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;精钢表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;7mm尺寸:&nbsp;32mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;精钢|个性定制手表,时尚女表||258|1'),(208,3,'tb-14450913511|激活|儿童节|经典定制女表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带20CM 腕围 14～18CM 镜面 2.5CM 材质 表带:真皮 表壳:合金 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||188|1'),(206,3,'tb-14469030397|激活|情人节|定制户外运动挂表|男朋友|生日|热爱户外运动的你，一定少不了这款个性挂表。 和你一样，这款表也是自由不羁的，可以随意定制。 只要把它挂在背包上，它就会跟随你的脚步，给你时间和方向。 优质合金夜光针和指南针，让你即使在昏暗的野外，也能识别时间。 即使一个人远行，有它一路上的陪伴，也一定不 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;59009-wat11801机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;户外运动表带材质:&nbsp;合金表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,运动手表||198|1'),(205,5,'tb-14470362811|激活|儿童节|个性定制时尚潮流镶钻女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;B6239-wat12001机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;椭圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;水钻表壳材质:&nbsp;合金|个性定制手表,时尚女表||208|1'),(206,5,'tb-14469030397|激活|情人节|定制户外运动挂表|男朋友|生日|热爱户外运动的你，一定少不了这款个性挂表。 和你一样，这款表也是自由不羁的，可以随意定制。 只要把它挂在背包上，它就会跟随你的脚步，给你时间和方向。 优质合金夜光针和指南针，让你即使在昏暗的野外，也能识别时间。 即使一个人远行，有它一路上的陪伴，也一定不 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;59009-wat11801机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;户外运动表带材质:&nbsp;合金表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,运动手表||198|1'),(204,5,'tb-14480890920|激活|情人节|个性定制男表|男朋友|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;44445-wat12101机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚男表||208|1'),(206,4,'tb-14469030397|激活|情人节|定制户外运动挂表|男朋友|生日|热爱户外运动的你，一定少不了这款个性挂表。 和你一样，这款表也是自由不羁的，可以随意定制。 只要把它挂在背包上，它就会跟随你的脚步，给你时间和方向。 优质合金夜光针和指南针，让你即使在昏暗的野外，也能识别时间。 即使一个人远行，有它一路上的陪伴，也一定不 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;59009-wat11801机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;户外运动表带材质:&nbsp;合金表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,运动手表||198|1'),(204,1,'tb-14480890920|激活|情人节|个性定制男表|男朋友|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;44445-wat12101机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚男表||208|1'),(206,2,'tb-14469030397|激活|情人节|定制户外运动挂表|男朋友|生日|热爱户外运动的你，一定少不了这款个性挂表。 和你一样，这款表也是自由不羁的，可以随意定制。 只要把它挂在背包上，它就会跟随你的脚步，给你时间和方向。 优质合金夜光针和指南针，让你即使在昏暗的野外，也能识别时间。 即使一个人远行，有它一路上的陪伴，也一定不 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;59009-wat11801机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;户外运动表带材质:&nbsp;合金表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,运动手表||198|1'),(202,3,'tb-14501358291|激活|情人节|个性刻字定制男钢表|男朋友|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;SA10-wat12801机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚男表||518|1'),(203,3,'tb-14483017901|激活|儿童节|个性定制儿童运动女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400312-wat12301机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;硅胶表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的女孩&mdash;&mdash;通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 可旋转表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的硅胶表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。想要试试吗？点击下面的按钮，快来感受一下定制的乐趣吧！喜爱运动的你，一定会喜欢这些个性十足的运动手表Color/绿色Color/蓝色Color/橙色Color/黑色可旋转表壳，带有分钟数字，可让孩子更好地学习认知时间后盖可激光雕刻你喜欢的祝福文字不锈钢外壳可供你选择多种颜色的硅胶表带，戴上舒适又方便|个性定制手表,儿童手表||188|1'),(201,5,'tb-15176883730|激活|儿童节|个性定制复古经典女童手表|小孩|生日|具有古典怀旧风格的一款手表，圆形的表壳镶嵌着古典风格花纹图案，具有古罗马复古气息，是女孩子的最爱！ 表盘可选择你喜欢的公主、可爱的小米妮，或任意一款你喜欢的图案。一定别忘了写上你的名字哦！你叫LINDA?印上你的名字后，这就是一块专属于LINDA的手表啦！ 真皮表带，戴上后舒适又时尚，还可任意选择你喜欢的颜色。你喜欢甜美的粉红色？没问题，喜欢什么就是什么！ 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84844-wat10601机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;30mm品牌产地:&nbsp;中国元素:&nbsp;复古表壳材质:&nbsp;合金|个性定制手表,儿童手表||188|1'),(201,4,'tb-15176883730|激活|儿童节|个性定制复古经典女童手表|小孩|生日|具有古典怀旧风格的一款手表，圆形的表壳镶嵌着古典风格花纹图案，具有古罗马复古气息，是女孩子的最爱！ 表盘可选择你喜欢的公主、可爱的小米妮，或任意一款你喜欢的图案。一定别忘了写上你的名字哦！你叫LINDA?印上你的名字后，这就是一块专属于LINDA的手表啦！ 真皮表带，戴上后舒适又时尚，还可任意选择你喜欢的颜色。你喜欢甜美的粉红色？没问题，喜欢什么就是什么！ 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84844-wat10601机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;30mm品牌产地:&nbsp;中国元素:&nbsp;复古表壳材质:&nbsp;合金|个性定制手表,儿童手表||188|1'),(202,1,'tb-14501358291|激活|情人节|个性刻字定制男钢表|男朋友|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;SA10-wat12801机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚男表||518|1'),(204,3,'tb-14480890920|激活|情人节|个性定制男表|男朋友|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;44445-wat12101机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚男表||208|1'),(202,5,'tb-14501358291|激活|情人节|个性刻字定制男钢表|男朋友|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;SA10-wat12801机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚男表||518|1'),(203,5,'tb-14483017901|激活|儿童节|个性定制儿童运动女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400312-wat12301机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;硅胶表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的女孩&mdash;&mdash;通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 可旋转表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的硅胶表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。想要试试吗？点击下面的按钮，快来感受一下定制的乐趣吧！喜爱运动的你，一定会喜欢这些个性十足的运动手表Color/绿色Color/蓝色Color/橙色Color/黑色可旋转表壳，带有分钟数字，可让孩子更好地学习认知时间后盖可激光雕刻你喜欢的祝福文字不锈钢外壳可供你选择多种颜色的硅胶表带，戴上舒适又方便|个性定制手表,儿童手表||188|1'),(204,4,'tb-14480890920|激活|情人节|个性定制男表|男朋友|生日|这款独一无二的手表，由你亲手设计&mdash;&mdash;你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;44445-wat12101机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚男表||208|1'),(198,1,'tb-15238419360|激活|情人节|个性定制时尚男表|男朋友|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.4M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16.5～22CM 镜面 2.7CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚男表||198|1'),(199,1,'tb-15237839452|激活|情人节|个性定制时尚女表||生日|这款独一无二的手表，由你亲手设计——你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84839-wat11301机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;真皮表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚女表||188|1'),(202,2,'tb-14501358291|激活|情人节|个性刻字定制男钢表|男朋友|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;SA10-wat12801机芯类型:&nbsp;石英表手表种类:&nbsp;男表手表风格:&nbsp;商务休闲表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚男表||518|1'),(197,5,'tb-15248759961|激活|情人节|个性创意时尚镶钻表||生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50890-wat12201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||428|1'),(198,5,'tb-15238419360|激活|情人节|个性定制时尚男表|男朋友|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.4M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16.5～22CM 镜面 2.7CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚男表||198|1'),(198,4,'tb-15238419360|激活|情人节|个性定制时尚男表|男朋友|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.4M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16.5～22CM 镜面 2.7CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚男表||198|1'),(196,1,'tb-16769128988|激活|儿童节|早教儿童认知时间手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(200,2,'tb-15232587893|激活|情人节|时尚潮流女性商务手表||生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚潮流女士手表，不仅可以体现你的生活品味，而且可以在商务场合中突显你的时尚个性，让你与别人与众不同. 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带26CM 腕围 16.5～22CM 镜面 2.2CM 材质 表带:精钢 表壳:316钢 重量 约65g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||488|1'),(201,3,'tb-15176883730|激活|儿童节|个性定制复古经典女童手表|小孩|生日|具有古典怀旧风格的一款手表，圆形的表壳镶嵌着古典风格花纹图案，具有古罗马复古气息，是女孩子的最爱！ 表盘可选择你喜欢的公主、可爱的小米妮，或任意一款你喜欢的图案。一定别忘了写上你的名字哦！你叫LINDA?印上你的名字后，这就是一块专属于LINDA的手表啦！ 真皮表带，戴上后舒适又时尚，还可任意选择你喜欢的颜色。你喜欢甜美的粉红色？没问题，喜欢什么就是什么！ 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84844-wat10601机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;30mm品牌产地:&nbsp;中国元素:&nbsp;复古表壳材质:&nbsp;合金|个性定制手表,儿童手表||188|1'),(200,5,'tb-15232587893|激活|情人节|时尚潮流女性商务手表||生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚潮流女士手表，不仅可以体现你的生活品味，而且可以在商务场合中突显你的时尚个性，让你与别人与众不同. 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带26CM 腕围 16.5～22CM 镜面 2.2CM 材质 表带:精钢 表壳:316钢 重量 约65g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||488|1'),(199,5,'tb-15237839452|激活|情人节|个性定制时尚女表||生日|这款独一无二的手表，由你亲手设计——你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84839-wat11301机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;真皮表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚女表||188|1'),(200,4,'tb-15232587893|激活|情人节|时尚潮流女性商务手表||生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚潮流女士手表，不仅可以体现你的生活品味，而且可以在商务场合中突显你的时尚个性，让你与别人与众不同. 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带26CM 腕围 16.5～22CM 镜面 2.2CM 材质 表带:精钢 表壳:316钢 重量 约65g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||488|1'),(200,1,'tb-15232587893|激活|情人节|时尚潮流女性商务手表||生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚潮流女士手表，不仅可以体现你的生活品味，而且可以在商务场合中突显你的时尚个性，让你与别人与众不同. 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带26CM 腕围 16.5～22CM 镜面 2.2CM 材质 表带:精钢 表壳:316钢 重量 约65g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||488|1'),(203,2,'tb-14483017901|激活|儿童节|个性定制儿童运动女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400312-wat12301机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;硅胶表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金 这款独一无二的宜乐生活定制手表，适合喜爱运动极具个性的女孩&mdash;&mdash;通过淘定制在线系统，亲手设计出你喜欢的表盘图案及文字，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 可旋转表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的硅胶表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。想要试试吗？点击下面的按钮，快来感受一下定制的乐趣吧！喜爱运动的你，一定会喜欢这些个性十足的运动手表Color/绿色Color/蓝色Color/橙色Color/黑色可旋转表壳，带有分钟数字，可让孩子更好地学习认知时间后盖可激光雕刻你喜欢的祝福文字不锈钢外壳可供你选择多种颜色的硅胶表带，戴上舒适又方便|个性定制手表,儿童手表||188|1'),(201,2,'tb-15176883730|激活|儿童节|个性定制复古经典女童手表|小孩|生日|具有古典怀旧风格的一款手表，圆形的表壳镶嵌着古典风格花纹图案，具有古罗马复古气息，是女孩子的最爱！ 表盘可选择你喜欢的公主、可爱的小米妮，或任意一款你喜欢的图案。一定别忘了写上你的名字哦！你叫LINDA?印上你的名字后，这就是一块专属于LINDA的手表啦！ 真皮表带，戴上后舒适又时尚，还可任意选择你喜欢的颜色。你喜欢甜美的粉红色？没问题，喜欢什么就是什么！ 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84844-wat10601机芯类型:&nbsp;石英表手表种类:&nbsp;儿童手表手表风格:&nbsp;可爱童真表带材质:&nbsp;真皮表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;30mm品牌产地:&nbsp;中国元素:&nbsp;复古表壳材质:&nbsp;合金|个性定制手表,儿童手表||188|1'),(200,3,'tb-15232587893|激活|情人节|时尚潮流女性商务手表||生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚潮流女士手表，不仅可以体现你的生活品味，而且可以在商务场合中突显你的时尚个性，让你与别人与众不同. 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带26CM 腕围 16.5～22CM 镜面 2.2CM 材质 表带:精钢 表壳:316钢 重量 约65g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚女表||488|1'),(199,3,'tb-15237839452|激活|情人节|个性定制时尚女表||生日|这款独一无二的手表，由你亲手设计——你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84839-wat11301机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;真皮表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚女表||188|1'),(196,5,'tb-16769128988|激活|儿童节|早教儿童认知时间手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(199,4,'tb-15237839452|激活|情人节|个性定制时尚女表||生日|这款独一无二的手表，由你亲手设计——你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84839-wat11301机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;真皮表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚女表||188|1'),(197,4,'tb-15248759961|激活|情人节|个性创意时尚镶钻表||生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50890-wat12201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||428|1'),(198,3,'tb-15238419360|激活|情人节|个性定制时尚男表|男朋友|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.4M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16.5～22CM 镜面 2.7CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚男表||198|1'),(197,3,'tb-15248759961|激活|情人节|个性创意时尚镶钻表||生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50890-wat12201机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||428|1'),(191,1,'tb-15167871086|激活|儿童节|个性定制男款运动手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款运动手表||188|1'),(192,1,'tb-14491898841|激活|儿童节|个性定制时装潮流女表|小孩|生日|精致与个性的完美融合,还能在表盘上雕刻特别的文字,赋予这块表特别的涵义,气质独特、 与众不同 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50726-wat11901机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;酒桶型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;蝴蝶双按扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(191,2,'tb-15167871086|激活|儿童节|个性定制男款运动手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款运动手表||188|1'),(192,2,'tb-14491898841|激活|儿童节|个性定制时装潮流女表|小孩|生日|精致与个性的完美融合,还能在表盘上雕刻特别的文字,赋予这块表特别的涵义,气质独特、 与众不同 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50726-wat11901机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;酒桶型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;蝴蝶双按扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(192,3,'tb-14491898841|激活|儿童节|个性定制时装潮流女表|小孩|生日|精致与个性的完美融合,还能在表盘上雕刻特别的文字,赋予这块表特别的涵义,气质独特、 与众不同 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50726-wat11901机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;酒桶型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;蝴蝶双按扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(193,3,'tb-14420097483|激活|儿童节|定制公主水晶石儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(191,5,'tb-15167871086|激活|儿童节|个性定制男款运动手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款运动手表||188|1'),(192,5,'tb-14491898841|激活|儿童节|个性定制时装潮流女表|小孩|生日|精致与个性的完美融合,还能在表盘上雕刻特别的文字,赋予这块表特别的涵义,气质独特、 与众不同 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50726-wat11901机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;酒桶型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;蝴蝶双按扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(191,4,'tb-15167871086|激活|儿童节|个性定制男款运动手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款运动手表||188|1'),(192,4,'tb-14491898841|激活|儿童节|个性定制时装潮流女表|小孩|生日|精致与个性的完美融合,还能在表盘上雕刻特别的文字,赋予这块表特别的涵义,气质独特、 与众不同 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;50726-wat11901机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;合金表盘形状:&nbsp;酒桶型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;蝴蝶双按扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(193,1,'tb-14420097483|激活|儿童节|定制公主水晶石儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(194,1,'tb-16950456931|激活|儿童节|个性定制时装女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;56432-wat12601机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;潮流时尚表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(195,1,'tb-16916368211|激活|儿童节|个性时间认知儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定会很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 15～19CM 镜面 2.0CM 材质 表带:尼龙/硅胶 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(198,2,'tb-15238419360|激活|情人节|个性定制时尚男表|男朋友|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.4M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16.5～22CM 镜面 2.7CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,时尚男表||198|1'),(199,2,'tb-15237839452|激活|情人节|个性定制时尚女表||生日|这款独一无二的手表，由你亲手设计——你喜欢的刻度式样、表盘图案及指针的形状，还可选择你喜欢的表带的颜色，气质独特，个性斐然。 方形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 本款表采用日本原装机芯，一年质保。配有精美的包装盒，同时附送吊牌和保修卡。不仅外观漂亮，质量也是绝对保证。 怎么样，心动了吗？快来定制一块你的专属手表吧!自己使用或送给朋友，都是很好的选择。 保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;84839-wat11301机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;真皮表盘形状:&nbsp;方型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表扣:&nbsp;针扣表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国表壳材质:&nbsp;合金|个性定制手表,时尚女表||188|1'),(194,3,'tb-16950456931|激活|儿童节|个性定制时装女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;56432-wat12601机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;潮流时尚表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(195,3,'tb-16916368211|激活|儿童节|个性时间认知儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定会很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 15～19CM 镜面 2.0CM 材质 表带:尼龙/硅胶 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(194,5,'tb-16950456931|激活|儿童节|个性定制时装女表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;56432-wat12601机芯类型:&nbsp;石英表手表种类:&nbsp;中性表手表风格:&nbsp;潮流时尚表盘形状:&nbsp;圆型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;6mm品牌产地:&nbsp;中国元素:&nbsp;其他表壳材质:&nbsp;合金|个性定制手表,时尚女表||258|1'),(195,5,'tb-16916368211|激活|儿童节|个性时间认知儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定会很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 15～19CM 镜面 2.0CM 材质 表带:尼龙/硅胶 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(195,4,'tb-16916368211|激活|儿童节|个性时间认知儿童表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定会很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 15～19CM 镜面 2.0CM 材质 表带:尼龙/硅胶 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可选择不同颜色的表壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(196,4,'tb-16769128988|激活|儿童节|早教儿童认知时间手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 此款儿童表是最经典的儿童认知手表之一，表面的双圈数字既显示小时，又显示分钟，非常方便小朋友学习认知时间。戴上它，不仅仅拥有一块自己的手表，也拥有了认知时间的能力，一定很有成就感！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字壳 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(190,5,'tb-15173227048|激活|儿童节|个性定制手表-男款|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16～20CM 镜面 3.0CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款手表||198|1'),(190,4,'tb-15173227048|激活|儿童节|个性定制手表-男款|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16～20CM 镜面 3.0CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款手表||198|1'),(190,1,'tb-15173227048|激活|儿童节|个性定制手表-男款|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16～20CM 镜面 3.0CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款手表||198|1'),(190,2,'tb-15173227048|激活|儿童节|个性定制手表-男款|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16～20CM 镜面 3.0CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款手表||198|1'),(189,3,'tb-16746748453|激活|儿童节|经典定制儿童公主手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款手表最受小女孩的青睐，圆形的表面镶嵌着半圆的水晶石。闪耀的水晶石，散发着璀璨的光芒，戴上它，转瞬间就能变成美丽的公主！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:2.6CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 14～18CM 镜面 1.7CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(188,5,'tb-16888172712|激活|儿童节|个性定制心形手链时装表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400153-wat11701机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;其他表盘形状:&nbsp;心型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;5mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国元素:&nbsp;手链表壳材质:&nbsp;合金|个性定制手表,儿童手表||198|1'),(188,4,'tb-16888172712|激活|儿童节|个性定制心形手链时装表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400153-wat11701机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;其他表盘形状:&nbsp;心型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;5mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国元素:&nbsp;手链表壳材质:&nbsp;合金|个性定制手表,儿童手表||198|1'),(190,3,'tb-15173227048|激活|儿童节|个性定制手表-男款|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 圆形合金表壳，样式大方简洁，可供你选择多种颜色的真皮表带，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.0M&nbsp;&nbsp;&nbsp;&nbsp;表带23CM 腕围 16～20CM 镜面 3.0CM 材质 表带:真皮 表壳:合金 重量 约30g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款手表||198|1'),(189,1,'tb-16746748453|激活|儿童节|经典定制儿童公主手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款手表最受小女孩的青睐，圆形的表面镶嵌着半圆的水晶石。闪耀的水晶石，散发着璀璨的光芒，戴上它，转瞬间就能变成美丽的公主！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:2.6CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 14～18CM 镜面 1.7CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(188,1,'tb-16888172712|激活|儿童节|个性定制心形手链时装表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400153-wat11701机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;其他表盘形状:&nbsp;心型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;5mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国元素:&nbsp;手链表壳材质:&nbsp;合金|个性定制手表,儿童手表||198|1'),(189,2,'tb-16746748453|激活|儿童节|经典定制儿童公主手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款手表最受小女孩的青睐，圆形的表面镶嵌着半圆的水晶石。闪耀的水晶石，散发着璀璨的光芒，戴上它，转瞬间就能变成美丽的公主！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:2.6CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 14～18CM 镜面 1.7CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(188,2,'tb-16888172712|激活|儿童节|个性定制心形手链时装表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400153-wat11701机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;其他表盘形状:&nbsp;心型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;5mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国元素:&nbsp;手链表壳材质:&nbsp;合金|个性定制手表,儿童手表||198|1'),(191,3,'tb-15167871086|激活|儿童节|个性定制男款运动手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 时尚运动表壳，带有分钟数字，设计新颖别致。可供你选择多种颜色的塑胶表壳，戴上舒适又方便。 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:3.8CM&nbsp;&nbsp;&nbsp;&nbsp;表带:21CM 腕围 14～19CM 镜面 2.0CM 材质 表带:塑胶 表壳:塑胶 重量 约20g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 表壳：可以选择不同颜色的表壳 后盖:可以在表壳后盖刻字 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,男款运动手表||188|1'),(189,5,'tb-16746748453|激活|儿童节|经典定制儿童公主手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款手表最受小女孩的青睐，圆形的表面镶嵌着半圆的水晶石。闪耀的水晶石，散发着璀璨的光芒，戴上它，转瞬间就能变成美丽的公主！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:2.6CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 14～18CM 镜面 1.7CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(189,4,'tb-16746748453|激活|儿童节|经典定制儿童公主手表|小孩|生日|.title{font-size:16px; font-weight:bolder;} .title-2{font-size:14px; font-weight:bolder;} .hrc{ border:1px solid; height:0px;} .tab-1 td, th {padding: 1px 0 1px 5px; line-height:1em;} 这款手表最受小女孩的青睐，圆形的表面镶嵌着半圆的水晶石。闪耀的水晶石，散发着璀璨的光芒，戴上它，转瞬间就能变成美丽的公主！ 产品特点： 机芯 日本原装石英机芯 尺寸 表壳:2.6CM&nbsp;&nbsp;&nbsp;&nbsp;表带:20CM 腕围 14～18CM 镜面 1.7CM 材质 表带:真皮 表壳:合金 重量 约17g 防水 生活防水 保质期 1年 定制详情： 定制特点： 表盘：可上传你喜欢的图案或文字 后盖:可以在表壳后盖刻字 表带：可选择不同颜色的表带 定制周期：3至5天； 包装：可以选用包装盒。|个性定制手表,儿童手表||188|1'),(188,3,'tb-16888172712|激活|儿童节|个性定制心形手链时装表|小孩|生日|保修:&nbsp;店铺保修品牌:&nbsp;宜乐生活型号:&nbsp;400153-wat11701机芯类型:&nbsp;石英表手表种类:&nbsp;女表手表风格:&nbsp;潮流时尚表带材质:&nbsp;其他表盘形状:&nbsp;心型显示类型:&nbsp;指针推出时间:&nbsp;2012年成色:&nbsp;全新防水:&nbsp;30米生活防水表底:&nbsp;普通表冠:&nbsp;普通表盘厚度:&nbsp;5mm尺寸:&nbsp;25mm品牌产地:&nbsp;中国元素:&nbsp;手链表壳材质:&nbsp;合金|个性定制手表,儿童手表||198|1');
/*!40000 ALTER TABLE `catalogsearch_fulltext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_query`
--

DROP TABLE IF EXISTS `catalogsearch_query`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogsearch_query` (
  `query_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `query_text` varchar(255) NOT NULL DEFAULT '',
  `num_results` int(10) unsigned NOT NULL DEFAULT '0',
  `popularity` int(10) unsigned NOT NULL DEFAULT '0',
  `redirect` varchar(255) NOT NULL DEFAULT '',
  `synonym_for` varchar(255) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `display_in_terms` tinyint(1) NOT NULL DEFAULT '1',
  `is_active` tinyint(1) DEFAULT '1',
  `is_processed` tinyint(1) DEFAULT '0',
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`query_id`),
  KEY `FK_CATALOGSEARCH_QUERY_STORE` (`store_id`),
  KEY `IDX_SEARCH_QUERY` (`query_text`,`store_id`,`popularity`),
  CONSTRAINT `FK_CATALOGSEARCH_QUERY_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_query`
--

LOCK TABLES `catalogsearch_query` WRITE;
/*!40000 ALTER TABLE `catalogsearch_query` DISABLE KEYS */;
INSERT INTO `catalogsearch_query` VALUES (41,'iPhone4个性定制手机壳',1,1038,'','',1,1,1,0,'2012-07-04 08:33:23'),(42,'个性定制变色杯',0,72,'','',1,1,1,0,'2012-06-13 02:25:23'),(43,'个性定制水晶',0,61,'','',1,1,1,0,'2012-06-26 19:30:51');
/*!40000 ALTER TABLE `catalogsearch_query` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalogsearch_result`
--

DROP TABLE IF EXISTS `catalogsearch_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogsearch_result` (
  `query_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `relevance` decimal(6,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`query_id`,`product_id`),
  KEY `IDX_QUERY` (`query_id`),
  KEY `IDX_PRODUCT` (`product_id`),
  KEY `IDX_RELEVANCE` (`query_id`,`relevance`),
  CONSTRAINT `FK_CATALOGSEARCH_RESULT_CATALOG_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CATALOGSEARCH_RESULT_QUERY` FOREIGN KEY (`query_id`) REFERENCES `catalogsearch_query` (`query_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `catalogsearch_result`
--

LOCK TABLES `catalogsearch_result` WRITE;
/*!40000 ALTER TABLE `catalogsearch_result` DISABLE KEYS */;
/*!40000 ALTER TABLE `catalogsearch_result` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkout_agreement`
--

DROP TABLE IF EXISTS `checkout_agreement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_agreement` (
  `agreement_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `content_height` varchar(25) DEFAULT NULL,
  `checkbox_text` text NOT NULL,
  `is_active` tinyint(4) NOT NULL DEFAULT '0',
  `is_html` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`agreement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkout_agreement`
--

LOCK TABLES `checkout_agreement` WRITE;
/*!40000 ALTER TABLE `checkout_agreement` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_agreement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `checkout_agreement_store`
--

DROP TABLE IF EXISTS `checkout_agreement_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_agreement_store` (
  `agreement_id` int(10) unsigned NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `agreement_id` (`agreement_id`,`store_id`),
  KEY `FK_CHECKOUT_AGREEMENT_STORE` (`store_id`),
  CONSTRAINT `FK_CHECKOUT_AGREEMENT` FOREIGN KEY (`agreement_id`) REFERENCES `checkout_agreement` (`agreement_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CHECKOUT_AGREEMENT_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `checkout_agreement_store`
--

LOCK TABLES `checkout_agreement_store` WRITE;
/*!40000 ALTER TABLE `checkout_agreement_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_agreement_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chronopay_api_debug`
--

DROP TABLE IF EXISTS `chronopay_api_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chronopay_api_debug` (
  `debug_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `debug_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `request_body` text,
  `response_body` text,
  PRIMARY KEY (`debug_id`),
  KEY `debug_at` (`debug_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chronopay_api_debug`
--

LOCK TABLES `chronopay_api_debug` WRITE;
/*!40000 ALTER TABLE `chronopay_api_debug` DISABLE KEYS */;
/*!40000 ALTER TABLE `chronopay_api_debug` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_block`
--

DROP TABLE IF EXISTS `cms_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_block` (
  `block_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext,
  `creation_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`block_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='CMS Blocks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_block`
--

LOCK TABLES `cms_block` WRITE;
/*!40000 ALTER TABLE `cms_block` DISABLE KEYS */;
INSERT INTO `cms_block` VALUES (3,'Electronics Landing','electronics-landing','<div class=\"left\" style=\"width:284px; margin-right:25px;\">\r\n<h3 style=\"margin-bottom:0;\"><a href=\"{{store direct_url=\"electronics/cell-phones.html\"}}\"><img src=\"{{skin url=\'images/media/head_electronics_cellphones.gif}}\" alt=\"Cell Phones\" style=\"display:block; border:0;\"/></h3>\r\n<p><img src=\"{{skin url=\'images/media/electronics_cellphones.jpg}}\" alt=\"\" usemap=\"#Map\" border=\"0\"/></p>\r\n</div>\r\n<div class=\"left\" style=\"width:284px;\">\r\n<h3 style=\"margin-bottom:0;\"><a href=\"{{store direct_url=\"electronics/cameras/digital-cameras.html\"}}\"><img src=\"{{skin url=\'images/media/head_electronics_digicamera.gif}}\" alt=\"Digital Cameras\" style=\"display:block; border:0;\"/></a></h3>\r\n<p><img src=\"{{skin url=\'images/media/electronics_digitalcameras.jpg}}\" alt=\"\" usemap=\"#Map2\" border=\"0\"/></p>\r\n</div>\r\n<div class=\"right\" style=\"width:284px;\">\r\n<h3 style=\"margin-bottom:0;\"><a href=\"{{store direct_url=\"electronics/computers/laptops.html\"}}\"><img src=\"{{skin url=\'images/media/head_electronics_laptops.gif}}\" alt=\"Laptops\" style=\"display:block; border:0;\"/></a></h3>\r\n<p><img src=\"{{skin url=\'images/media/electronics_laptops.jpg}}\" alt=\"\" usemap=\"#Map3\" border=\"0\"/></p>\r\n</div>\r\n<div class=\"clear\"></div>\r\n\r\n<map name=\"Map\">\r\n  <area shape=\"rect\" coords=\"14,154,78,182\" href=\"{{store direct_url=\"electronics/cell-phones.html?manufacturer=3\"}}\">\r\n  <area shape=\"rect\" coords=\"12,177,80,209\" href=\"{{store direct_url=\"electronics/cell-phones.html?manufacturer=20\"}}\">\r\n  <area shape=\"rect\" coords=\"104,158,167,181\" href=\"{{store direct_url=\"electronics/cell-phones.html?manufacturer=2\"}}\">\r\n  <area shape=\"rect\" coords=\"103,181,179,208\" href=\"{{store direct_url=\"electronics/cell-phones.html?manufacturer=101\"}}\">\r\n <area shape=\"rect\" coords=\"16,203,273,432\" href=\"{{store direct_url=\"electronics/cell-phones/blackberry-8100-pearl.html\"}}\">\r\n</map>\r\n\r\n<map name=\"Map2\">\r\n  <area shape=\"rect\" coords=\"14,152,75,179\" href=\"{{store direct_url=\"electronics/cameras/digital-cameras.html?manufacturer=33\"}}\">\r\n  <area shape=\"rect\" coords=\"109,154,163,183\" href=\"{{store direct_url=\"electronics/cameras/digital-cameras.html?manufacturer=31\"}}\">\r\n  <area shape=\"rect\" coords=\"14,177,73,208\" href=\"{{store direct_url=\"electronics/cameras/digital-cameras.html?manufacturer=32\"}}\">\r\n  <area shape=\"rect\" coords=\"106,180,177,211\" href=\"{{store direct_url=\"electronics/cameras/digital-cameras.html?manufacturer=34\"}}\">\r\n</map>\r\n\r\n\r\n<map name=\"Map3\">\r\n  <area shape=\"rect\" coords=\"15,155,58,179\" href=\"{{store direct_url=\"electronics/computers/laptops?computer_manufacturers=79\"}}\">\r\n  <area shape=\"rect\" coords=\"114,152,159,180\" href=\"{{store direct_url=\"electronics/computers/laptops?computer_manufacturers=76\"}}\">\r\n  <area shape=\"rect\" coords=\"13,178,67,205\" href=\"{{store direct_url=\"electronics/computers/laptops?computer_manufacturers=77\"}}\">\r\n  <area shape=\"rect\" coords=\"114,180,178,205\" href=\"{{store direct_url=\"electronics/computers/laptops?computer_manufacturers=74\"}}\">\r\n  <area shape=\"rect\" coords=\"13,310,154,434\" href=\"{{store direct_url=\"electronics/computers/laptops/acer-ferrari-3200-notebook-computer-pc.html\"}}\">\r\n  <area shape=\"rect\" coords=\"167,310,279,440\" href=\"{{store direct_url=\"electronics/computers/laptops/toshiba-satellite-a135-s4527-155-4-notebook-pc-intel-pentium-dual-core-processor-t2080-1-gb-ram-120-gb-hard-drive-supermulti-dvd-drive-vista-premium.html\"}}\">\r\n</map>','2007-08-28 14:33:10','2008-08-08 13:08:37',1),(4,'Cellphones Landing','cellphones-landing','<a href=\"{{store direct_url=\"electronics/cell-phones/sony-ericsson-w810i.html\"}}\"><img src=\"{{skin url=\'images/media/cell_phone_landing_banner1.jpg}}\" alt=\"\"/></a>','2007-08-28 14:59:44','2008-08-08 13:07:55',1),(5,'Footer Links','footer_links','<ul>\r\n<li><a href=\"{{store direct_url=\"about-magento-demo-store\"}}\">About Us</a></li>\r\n<li class=\"last\"><a href=\"{{store direct_url=\"customer-service\"}}\">Customer Service</a></li>\r\n</ul>','2007-08-30 14:01:52','2007-08-30 14:02:43',1),(6,'Banner 13','banner_13','<div class=\"banner-block\">\r\n<h4>Special Offers</h4>\r\n<ul>\r\n<li class=\"disc\"><a href=\"{{store direct_url=\"#\"}}\">Discount Cell Phone</a></li>\r\n<li class=\"disc\"><a href=\"{{store direct_url=\"#\"}}\">SALE! Electronics</a></li>\r\n<li class=\"disc\"><a href=\"{{store direct_url=\"#\"}}\">SALE! Week Deals</a></li>\r\n<li class=\"disc\"><a href=\"{{store direct_url=\"#\"}}\">Custom Logo Cell Phone</a></li>\r\n<li class=\"last disc\"><a href=\"{{store direct_url=\"c#\"}}\">Dress on Sale</a></li>\r\n</ul>\r\n</div>','2011-03-08 11:20:44','2011-03-08 11:20:44',1),(7,'banner 18','banner_18','<div class=\"banner-block\">\r\n<h4>Special Offers</h4>\r\n<ul banner-imgs>\r\n<li class=\"disc\"><a href=\"{{store direct_url=\"#\"}}\">Discount Car Tech</a></li>\r\n<li class=\"disc\"><a href=\"{{store direct_url=\"#\"}}\">Custom Logo MP3 Player</a></li>\r\n<li class=\"last disc\"><a href=\"{{store direct_url=\"c#\"}}\">Mp3 on Sale</a></li>\r\n</ul>\r\n<a href=\"{{store direct_url=\"electronics/cell-phones/sony-ericsson-w810i.html\"}}\"><img src=\"{{skin url=\'images/media/car_tech.jpg\'}}\" alt=\"\"/></a>\r\n</div>','2011-03-08 11:22:19','2011-03-08 11:22:19',1),(8,'Community Block','community-block','<div class=\"community-block\">\r\n<ul>\r\n    <li class=\"community-title\"><span>Join our community :</span></li>\r\n    <li class=\"i-blog\"><a href=\"{{store direct_url=\"blog\"}}\"><span>blog</span></a></li>\r\n    <li class=\"i-twitter\"><a href=\"http://www.twitter.com\"><span>twitter</span></a></li>\r\n    <li class=\"i-facebook\"><a href=\"http://www.facebook.com\"><span>facebook</span></a></li>\r\n    <li class=\"i-youtube\"><a href=\"http://www.youtube.com\"><span>youtube</span></a></li>\r\n</ul> \r\n</div>','2011-03-08 11:23:41','2012-06-12 09:08:27',0),(9,'Footer CMS Links','footer-cms-links','<div class=\"footer_block\">\r\n<ul class=\"mar_t2\">\r\n      <li><span>宜乐定制</span>\r\n        <ul class=\"mar_t1\">\r\n          <li><a href=\"{{store direct_url=\"about-ecczo\"}}\">关于宜乐</a></li>\r\n          <li><a href=\"{{store direct_url=\"personalized-gifts\"}}\">定制流程</a></li>\r\n\r\n\r\n        </ul>\r\n      </li>\r\n    </ul>\r\n    <ul class=\"mar_t2\">\r\n      <li><span>配送服务</span>\r\n        <ul class=\"mar_t1\">\r\n          <li><a href=\"{{store direct_url=\"shipping\"}}\">发货时间</a></li>\r\n          <li><a href=\"{{store direct_url=\"delivery-time\"}}\">配送时间</a></li>\r\n          <li><a href=\"{{store direct_url=\"fare\"}}\">配送费用</a></li>\r\n        </ul>\r\n      </li>\r\n    </ul>\r\n    <ul class=\"mar_t2\">\r\n      <li><span>信誉保证</span>\r\n        <ul class=\"mar_t1\">\r\n          <li><a href=\"{{store direct_url=\"credit-guarantee\"}}\">信誉保证</a></li>\r\n          <li><a href=\"{{store direct_url=\"return\"}}\">退换货保障</a></li>\r\n        </ul>\r\n      </li>\r\n    </ul>\r\n    <ul class=\"mar_t2\">\r\n      <li><span>合作专区</span>\r\n        <ul class=\"mar_t1\">\r\n          <li><a target=\"_blank\" href=\"http://www.ecczo.cn\">分销平台</a></li>\r\n          <li><a href=\"{{store direct_url=\"partners\"}}\">商务合作</a></li>\r\n        </ul>\r\n      </li>\r\n    </ul>\r\n   <ul class=\"mar_t2\">\r\n      <li><span>客服中心</span>\r\n        <ul class=\"mar_t1\">\r\n          <li><a href=\"{{store direct_url=\"contact-us\"}}\">联系我们</a></li>\r\n        </ul>\r\n      </li>\r\n    </ul>\r\n     <div class=\"clear\"></div>\r\n</div>\r\n','2011-03-08 11:25:29','2012-06-13 09:47:39',1),(10,'Footer Secure','secure','<div class=\"footer-bot secure-block\">\r\n    <div class=\"secure-title\">\r\n        <strong><span>100% Secure</span></strong>\r\n    </div>\r\n    <div class=\"secure-content\">\r\n       <p>Shop in confidence on our site! We accept all major cards as well as Google Checkout & Paypal...</p>\r\n       <img src=\"{{skin url=\'images/payment-logos.gif\'}}\" border=\"0\"  />\r\n    </div>\r\n</div>','2011-03-08 11:26:36','2011-03-08 11:26:36',1),(11,'导航菜单','nav-menu','<div id=\"menu40\" class=\"item1 menu active\">\r\n     <div class=\"parentMenu\">\r\n        <a href=\"{{store direct_url=\'home\'}}\"><span>首页</span></a>\r\n     </div>\r\n</div>\r\n\r\n<div id=\"menu45\" class=\"item2 menu\">\r\n     <div class=\"parentMenu\">\r\n        <a href=\"{{store direct_url=\'occasion.html\'}}\"><span>节日庆典</span></a>\r\n     </div>\r\n</div>\r\n\r\n<div id=\"menu50\" class=\"item3 menu\">\r\n     <div class=\"parentMenu\">\r\n        <a href=\"{{store direct_url=\'recipients.html\'}}\"><span>送礼对象</span></a>\r\n     </div>\r\n</div>\r\n\r\n<div id=\"menu56\" class=\"item4 menu\">\r\n     <div class=\"parentMenu\">\r\n        <a href=\"{{store direct_url=\'gifts.html\'}}\"><span>创意礼品</span></a>\r\n     </div>\r\n</div>\r\n\r\n<div id=\"menu67\" class=\"item5 menu\">\r\n     <div class=\"parentMenu\">\r\n        <a href=\"{{store direct_url=\'diy.html\'}}\"><span>个性定制</span></a>\r\n     </div>\r\n</div>\r\n','2012-06-08 08:15:19','2012-07-14 10:32:27',1);
/*!40000 ALTER TABLE `cms_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_block_store`
--

DROP TABLE IF EXISTS `cms_block_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_block_store` (
  `block_id` smallint(6) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`block_id`,`store_id`),
  KEY `FK_CMS_BLOCK_STORE_STORE` (`store_id`),
  CONSTRAINT `FK_CMS_BLOCK_STORE_BLOCK` FOREIGN KEY (`block_id`) REFERENCES `cms_block` (`block_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CMS_BLOCK_STORE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CMS Blocks to Stores';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_block_store`
--

LOCK TABLES `cms_block_store` WRITE;
/*!40000 ALTER TABLE `cms_block_store` DISABLE KEYS */;
INSERT INTO `cms_block_store` VALUES (3,0),(4,0),(5,0),(6,0),(7,0),(8,0),(9,0),(10,0),(11,0);
/*!40000 ALTER TABLE `cms_block_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_page`
--

DROP TABLE IF EXISTS `cms_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_page` (
  `page_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `root_template` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` text NOT NULL,
  `meta_description` text NOT NULL,
  `identifier` varchar(100) NOT NULL DEFAULT '',
  `content_heading` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext,
  `creation_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `sort_order` tinyint(4) NOT NULL DEFAULT '0',
  `layout_update_xml` text,
  `custom_theme` varchar(100) DEFAULT NULL,
  `custom_root_template` varchar(255) NOT NULL DEFAULT '',
  `custom_layout_update_xml` text,
  `custom_theme_from` date DEFAULT NULL,
  `custom_theme_to` date DEFAULT NULL,
  PRIMARY KEY (`page_id`),
  KEY `identifier` (`identifier`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='CMS pages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_page`
--

LOCK TABLES `cms_page` WRITE;
/*!40000 ALTER TABLE `cms_page` DISABLE KEYS */;
INSERT INTO `cms_page` VALUES (1,'404 Not Found 1','two_columns_right','Page keywords','Page description','no-route','','<div class=\"page-head-alt\"><h3>Whoops, our bad...</h3></div>\r\n<dl>\r\n<dt>The page you requested was not found, and we have a fine guess why.</dt>\r\n<dd>\r\n<ul class=\"disc\">\r\n<li>If you typed the URL directly, please make sure the spelling is correct.</li>\r\n<li>If you clicked on a link to get here, the link is outdated.</li>\r\n</ul></dd>\r\n</dl>\r\n<br/>\r\n<dl>\r\n<dt>What can you do?</dt>\r\n<dd>Have no fear, help is near! There are many ways you can get back on track with Magento Demo Store.</dd>\r\n<dd>\r\n<ul class=\"disc\">\r\n<li><a href=\"#\" onclick=\"history.go(-1);\">Go back</a> to the previous page.</li>\r\n<li>Use the search bar at the top of the page to search for your products.</li>\r\n<li>Follow these links to get you back on track!<br/><a href=\"{{store url=\"\"}}\">Store Home</a><br/><a href=\"{{store url=\"customer/account\"}}\">My Account</a></li></ul></dd></dl><br/>\r\n<p><img src=\"{{skin url=\'images/media/404_callout1.jpg\'}}\" style=\"margin-right:15px;\"/><img src=\"{{skin url=\'images/media/404_callout2.jpg\'}}\" /></p>','2007-06-20 18:38:32','2007-08-26 19:11:13',1,0,NULL,NULL,'',NULL,NULL,NULL),(2,'宜乐定制礼品专卖店','two_columns_left','个性定制礼品,创意礼品,定制礼品专卖店,DIY设计礼物,个性礼品定制,创意礼物,创意小礼品,高档商务礼品,生日礼物,创意礼物,礼物,礼品,个性礼物,个性礼品,个性定制,创意礼品定制,个性礼品定制,企业礼品定制,新奇创意小礼品,创意生日礼物,个性定制软件,个性定制网站系统','宜乐－追寻创意设计和个性定制的生活乐趣','home','','<style>\r\n \r\n.right-images{margin-left:5px;}\r\n\r\n</style>\r\n\r\n<div class=\"top-banners\">\r\n<div id=\"slider\">\r\n    <div class=\"slidercontrolwr\">\r\n        <div class=\"slidercontrol\">\r\n            <a href=\"#section1\" title=\"Slide 1\" class=\"\">1</a>\r\n            <a href=\"#section2\" title=\"Slide 2\" class=\"\">2</a>\r\n            <a href=\"#section3\" title=\"Slide 3\" class=\"\">3</a>\r\n            <a href=\"#section4\" title=\"Slide 4\" class=\"\">4</a>\r\n            <a href=\"#section5\" title=\"Slide 5\" class=\"\">5</a>\r\n        </div>\r\n    </div>\r\n    <div class=\"scroller\">\r\n        <div class=\"content\">\r\n            <div class=\"sectionslide\" id=\"section1\">\r\n                <a href=\"#\"><img src=\"{{media url=\'t-1.jpg\'}}\" alt=\"\" /></a>\r\n            </div>\r\n            <div class=\"sectionslide\" id=\"section2\">\r\n                <a href=\"#\"><img src=\"{{media url=\'t-2.jpg\'}}\" alt=\"\" /></a>\r\n            </div>\r\n            <div class=\"sectionslide\" id=\"section3\">\r\n                <a href=\"#\"><img src=\"{{media url=\'t-3.jpg\'}}\" alt=\"\" /></a>\r\n            </div>\r\n            <div class=\"sectionslide\" id=\"section4\">\r\n                <a href=\"#\"><img src=\"{{media url=\'t-4.jpg\'}}\" alt=\"\" /></a>\r\n            </div>\r\n           <div class=\"sectionslide\" id=\"section5\">\r\n                <a href=\"#\"><img src=\"{{media url=\'t-5.jpg\'}}\" alt=\"\" /></a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<script type=\"text/javascript\" charset=\"utf-8\">\r\n    var my_glider = new Glider(\'slider\', {duration:0.5, autoGlide: true, frequency: 4, initialSection: \'section1\'});\r\n </script>\r\n\r\n<a class=\"top-banner-right\" href=\"{{store direct_url=\"#\"}}\"><img class=\"right-images\" src=\"{{media url=\'iphone4.jpg\'}}\" alt=\"\"/></a>\r\n\r\n<div class=\"clear\"></div>\r\n</div><!-- end of top banner -->\r\n','2007-08-23 10:03:25','2012-07-14 10:29:56',1,0,'<remove name=\"catalog.compare.sidebar\" />\r\n<remove name=\"right.poll\" />\r\n\r\n<reference name=\"head\">\r\n  <action method=\"addItem\"><type>skin_js</type><name>js/scripts.js</name></action>\r\n</reference>\r\n\r\n<reference name=\"left\">\r\n<block type=\"bmproducts/product_bestseller\" name=\"bestseller_sidebar\" template=\"bmproducts/product/sidelist.phtml\">\r\n    <action method=\"setTitle\"><title>Hot Deals</title></action>\r\n    <action method=\"setProductsCount\"><count>7</count></action>\r\n  </block>\r\n\r\n     <block type=\"blog/blog\" name=\"left.blog.menu\"  template=\"aw_blog/menu.phtml\" />\r\n     <block type=\"newsletter/subscribe\" name=\"homepage.newsletter\" template=\"newsletter/left-subscribe.phtml\"/>\r\n     <block type=\"tag/popular\" name=\"tags_popular\" template=\"tag/left-popular.phtml\"/>\r\n</reference>\r\n\r\n\r\n<reference name=\"footer-top\">\r\n       <block type=\"core/template\" name=\"cms_footer_aboutus\"  as=\"footer_aboutus\" template=\"cms/about.phtml\"/>\r\n</reference>\r\n\r\n<reference name=\"content\">\r\n\r\n\r\n<block type=\"catalog/navigation\" name=\"catalog.categoriesImgTopNav\" template=\"easycatalogimg/homepage.phtml\" />\r\n\r\n  <block type=\"core/template\" name=\"tab_wrapper\" template=\"cms/highlight.tab.phtml\" after=\"-\"/>\r\n</reference>\r\n<reference name=\"tab_wrapper\">\r\n <block type=\"bmproducts/product_popular\" name=\"product_popular\" template=\"bmproducts/product/listhome.phtml\">\r\n    <action method=\"setTitle\"><title>Popular Products</title></action>\r\n    <action method=\"setProductsCount\"><count>12</count></action>\r\n    <action method=\"setColumnsCount\"><count>3</count></action>\r\n  </block>\r\n  <block type=\"bmproducts/product_special\" name=\"product_special\" template=\"bmproducts/product/listhome.phtml\">\r\n    <action method=\"setTitle\"><title>Special Products</title></action>\r\n    <action method=\"setProductsCount\"><count>12</count></action>\r\n    <action method=\"setColumnsCount\"><count>3</count></action>\r\n  </block>\r\n  <block type=\"bmproducts/product_featured\" name=\"product_Featured\" template=\"bmproducts/product/listhome.phtml\">\r\n    <action method=\"setCategoryId\"><category_id>35</category_id></action>\r\n    <action method=\"setTitle\"><title>Featured Products</title></action>\r\n    <action method=\"setProductsCount\"><count>12</count></action>\r\n    <action method=\"setColumnsCount\"><count>3</count></action>\r\n  </block>\r\n</reference>','','','',NULL,NULL),(3,'About  Us','one_column','','','about-magento-demo-store','','<div class=\"page-head\">\r\n<h3>About Magento  Demo Store</h3>\r\n</div>\r\n<div class=\"col3-set\">\r\n<div class=\"col-1\"><p><img src=\"http://var-dev.varien.com:81/dev/minu/magento/skin/frontend/default/default/images/media/about_us_img.jpg\" alt=\"Varien office pic\"/></p><p style=\"line-height:1.2em;\"><small>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede.</small></p>\r\n<p style=\"color:#888; font:1.2em/1.4em georgia, serif;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta.</p></div>\r\n<div class=\"col-2\">\r\n<p><strong style=\"color:#de036f;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit.</strong></p>\r\n<p>Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo. </p>\r\n<p>Maecenas ullamcorper, odio vel tempus egestas, dui orci faucibus orci, sit amet aliquet lectus dolor et quam. Pellentesque consequat luctus purus. Nunc et risus. Etiam a nibh. Phasellus dignissim metus eget nisi. Vestibulum sapien dolor, aliquet nec, porta ac, malesuada a, libero. Praesent feugiat purus eget est. Nulla facilisi. Vestibulum tincidunt sapien eu velit. Mauris purus. Maecenas eget mauris eu orci accumsan feugiat. Pellentesque eget velit. Nunc tincidunt.</p></div>\r\n<div class=\"col-3\">\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper </p>\r\n<p><strong style=\"color:#de036f;\">Maecenas ullamcorper, odio vel tempus egestas, dui orci faucibus orci, sit amet aliquet lectus dolor et quam. Pellentesque consequat luctus purus.</strong></p>\r\n<p>Nunc et risus. Etiam a nibh. Phasellus dignissim metus eget nisi.</p>\r\n<div class=\"divider\"></div>\r\n<p>To all of you, from all of us at Magento Demo Store - Thank you and Happy eCommerce!</p>\r\n<p style=\"line-height:1.2em;\"><strong style=\"font:italic 2em Georgia, serif;\">John Doe</strong><br/><small>Some important guy</small></p></div>\r\n</div>','2007-08-30 14:01:18','2007-08-30 14:01:18',1,0,NULL,NULL,'',NULL,NULL,NULL),(4,'Customer Service','three_columns','','','customer-service','','<div class=\"page-head\">\r\n<h3>Customer Service</h3>\r\n</div>\r\n<ul class=\"disc\" style=\"margin-bottom:15px;\">\r\n<li><a href=\"#answer1\">Shipping & Delivery</a></li>\r\n<li><a href=\"#answer2\">Privacy & Security</a></li>\r\n<li><a href=\"#answer3\">Returns & Replacements</a></li>\r\n<li><a href=\"#answer4\">Ordering</a></li>\r\n<li><a href=\"#answer5\">Payment, Pricing & Promotions</a></li>\r\n<li><a href=\"#answer6\">Viewing Orders</a></li>\r\n<li><a href=\"#answer7\">Updating Account Information</a></li>\r\n</ul>\r\n<dl>\r\n<dt id=\"answer1\">Shipping & Delivery</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer2\">Privacy & Security</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer3\">Returns & Replacements</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer4\">Ordering</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer5\">Payment, Pricing & Promotions</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer6\">Viewing Orders</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n<dt id=\"answer7\">Updating Account Information</dt>\r\n<dd style=\"margin-bottom:10px;\">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Morbi luctus. Duis lobortis. Nulla nec velit. Mauris pulvinar erat non massa. Suspendisse tortor turpis, porta nec, tempus vitae, iaculis semper, pede. Cras vel libero id lectus rhoncus porta. Suspendisse convallis felis ac enim. Vivamus tortor nisl, lobortis in, faucibus et, tempus at, dui. Nunc risus. Proin scelerisque augue. Nam ullamcorper. Phasellus id massa. Pellentesque nisl. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc augue. Aenean sed justo non leo vehicula laoreet. Praesent ipsum libero, auctor ac, tempus nec, tempor nec, justo.</dd>\r\n</dl>','2007-08-30 14:02:20','2007-08-30 14:03:37',1,0,NULL,NULL,'',NULL,NULL,NULL),(5,'Home page','one_column','','','home','','<!-- this homepage can be used for modern theme  -->\r\n{{block type=\"core/template\" template=\"sample/home.phtml\"}}','2008-04-16 14:51:52','2008-08-08 12:23:12',0,0,'<!--<reference name=\"content\">\r\n<block type=\"catalog/product_new\" name=\"home.catalog.product.new\" alias=\"product_new\" template=\"catalog/product/new.phtml\" after=\"cms_page\"><action method=\"addPriceBlockType\"><type>bundle</type><block>bundle/catalog_product_price</block><template>bundle/catalog/product/price.phtml</template></action></block>\r\n<block type=\"reports/product_viewed\" name=\"home.reports.product.viewed\" alias=\"product_viewed\" template=\"reports/home_product_viewed.phtml\" after=\"product_new\"><action method=\"addPriceBlockType\"><type>bundle</type><block>bundle/catalog_product_price</block><template>bundle/catalog/product/price.phtml</template></action></block>\r\n<block type=\"reports/product_compared\" name=\"home.reports.product.compared\" template=\"reports/home_product_compared.phtml\" after=\"product_viewed\"><action method=\"addPriceBlockType\"><type>bundle</type><block>bundle/catalog_product_price</block><template>bundle/catalog/product/price.phtml</template></action></block>\r\n</reference><reference name=\"right\">\r\n<action method=\"unsetChild\"><alias>right.reports.product.viewed</alias></action>\r\n<action method=\"unsetChild\"><alias>right.reports.product.compared</alias></action>\r\n</reference>-->','','',NULL,NULL,NULL),(6,'Enable Cookies','one_column','','','enable-cookies','','<div class=\"std\">\r\n    <ul class=\"messages\">\r\n        <li class=\"notice-msg\">\r\n            <ul>\r\n                <li>Please enable cookies in your web browser to continue.</li>\r\n            </ul>\r\n        </li>\r\n    </ul>\r\n    <div class=\"page-title\">\r\n        <h1><a name=\"top\"></a>What are Cookies?</h1>\r\n    </div>\r\n    <p>Cookies are short pieces of data that are sent to your computer when you visit a website. On later visits, this data is then returned to that website. Cookies allow us to recognize you automatically whenever you visit our site so that we can personalize your experience and provide you with better service. We also use cookies (and similar browser data, such as Flash cookies) for fraud prevention and other purposes. If your web browser is set to refuse cookies from our website, you will not be able to complete a purchase or take advantage of certain features of our website, such as storing items in your Shopping Cart or receiving personalized recommendations. As a result, we strongly encourage you to configure your web browser to accept cookies from our website.</p>\r\n    <h2 class=\"subtitle\">Enabling Cookies</h2>\r\n    <ul class=\"disc\">\r\n        <li><a href=\"#ie7\">Internet Explorer 7.x</a></li>\r\n        <li><a href=\"#ie6\">Internet Explorer 6.x</a></li>\r\n        <li><a href=\"#firefox\">Mozilla/Firefox</a></li>\r\n        <li><a href=\"#opera\">Opera 7.x</a></li>\r\n    </ul>\r\n    <h3><a name=\"ie7\"></a>Internet Explorer 7.x</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Start Internet Explorer</p>\r\n        </li>\r\n        <li>\r\n            <p>Under the <strong>Tools</strong> menu, click <strong>Internet Options</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-1.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click the <strong>Privacy</strong> tab</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-2.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click the <strong>Advanced</strong> button</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-3.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Put a check mark in the box for <strong>Override Automatic Cookie Handling</strong>, put another check mark in the <strong>Always accept session cookies </strong>box</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-4.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click <strong>OK</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-5.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click <strong>OK</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie7-6.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Restart Internet Explore</p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n    <h3><a name=\"ie6\"></a>Internet Explorer 6.x</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Select <strong>Internet Options</strong> from the Tools menu</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie6-1.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Privacy</strong> tab</p>\r\n        </li>\r\n        <li>\r\n            <p>Click the <strong>Default</strong> button (or manually slide the bar down to <strong>Medium</strong>) under <strong>Settings</strong>. Click <strong>OK</strong></p>\r\n            <p><img src=\"{{skin url=\"images/cookies/ie6-2.gif\"}}\" alt=\"\" /></p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n    <h3><a name=\"firefox\"></a>Mozilla/Firefox</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Click on the <strong>Tools</strong>-menu in Mozilla</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Options...</strong> item in the menu - a new window open</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Privacy</strong> selection in the left part of the window. (See image below)</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/firefox.png\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>Expand the <strong>Cookies</strong> section</p>\r\n        </li>\r\n        <li>\r\n            <p>Check the <strong>Enable cookies</strong> and <strong>Accept cookies normally</strong> checkboxes</p>\r\n        </li>\r\n        <li>\r\n            <p>Save changes by clicking <strong>Ok</strong>.</p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n    <h3><a name=\"opera\"></a>Opera 7.x</h3>\r\n    <ol>\r\n        <li>\r\n            <p>Click on the <strong>Tools</strong> menu in Opera</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Preferences...</strong> item in the menu - a new window open</p>\r\n        </li>\r\n        <li>\r\n            <p>Click on the <strong>Privacy</strong> selection near the bottom left of the window. (See image below)</p>\r\n            <p><img src=\"{{skin url=\"images/cookies/opera.png\"}}\" alt=\"\" /></p>\r\n        </li>\r\n        <li>\r\n            <p>The <strong>Enable cookies</strong> checkbox must be checked, and <strong>Accept all cookies</strong> should be selected in the &quot;<strong>Normal cookies</strong>&quot; drop-down</p>\r\n        </li>\r\n        <li>\r\n            <p>Save changes by clicking <strong>Ok</strong></p>\r\n        </li>\r\n    </ol>\r\n    <p class=\"a-top\"><a href=\"#top\">Back to Top</a></p>\r\n</div>\r\n','2011-03-07 12:52:59','2011-03-07 12:52:59',1,0,NULL,NULL,'',NULL,NULL,NULL),(7,'关于宜乐','one_column','','','about-ecczo','','<style type=\"text/css\">\r\n\r\n.about {padding-left:20px;}\r\n</style>\r\n\r\n<div>\r\n<h3>宜乐定制礼品专卖店系统</h3>\r\n<p>－－最完整的定制礼品电子商务解决方案</p>\r\n<h4>五大优势</h4>\r\n <p class=\"about\">1. 最简便易用的在线定制设计工具；</p>\r\n <p class=\"about\">2. 最丰富的定制礼品模板选择；</p>\r\n <p class=\"about\">3. 最完善的定制礼品网店管理系统；</p>\r\n <p class=\"about\">4. 最友好的搜索引擎、社会化营销和移动商务特性；</p>\r\n <p class=\"about\">5. 最专业的个性定制系统开发和技术支持团队。</p>\r\n<p>一 用户操作简便的在线定制设计界面－－完全摈弃耗费系统资源的Flash，全面转向JS和HTML5，支持智能手机和平板电脑等移动终端。宜乐定制系统是国内第一个从Flash转向JS和HTML5的在线定制软件，简便易用的前端用户操作界面大大增强了用户体验。无论是PC，还是平板电脑或智能手机，用户随时都可以在线定制设计自己的创意礼品。</p>\r\n<p>二 宜乐及其定制产品供应商联盟目前已经有1000多个定制模板可供选择－－从个性十足的iPhone手机壳，到任意组合搭配的定制手表，从变色杯到定制T恤，凡是你能想像得到而又可以定制生产的产品，我们都可以设计和制作出在线定制的模板。定制礼品卖家不但可以从现有定制产品模板中挑选合适的，还可以请求宜乐为其独特产品专门开发模板。</p>\r\n<p>三 宜乐定制礼品网店管理系统是宜乐开发团队在全球流行的电子商务平台Magento系统的基础上定制开发而成，不但继承了Magento系统前端展示样式灵活和后台管理功能完善的优点，更实现了与宜乐在线定制系统的无缝集成。此外，宜乐还专门针对国内个性定制礼品市场特点和卖家的要求，将网店系统进行了本地化改造，使之更适合国内用户的浏览和购物习惯。</p>\r\n<p>四 宜乐专卖店系统专门针对百度和谷歌搜索引擎进行了优化，让你的B2C网站更容易被搜索引擎抓取和收录，从而提升网站排名。除搜素引擎友好的系统架构外，宜乐还添加了社交网络分享功能，让你的礼品商店成为社会化商务的一部分。用户可以通过新浪微博和QQ等帐户登陆/注册，并可以随时分享和收藏喜欢的个性礼品。此外，宜乐还开发了网站移动版本，兼容iPhone/iPad、Android等移动设备。商家无需搭建单独的移动站点，网站可自动设别不同的访问设备，从而展现相应的页面。</p>\r\n<p>五 宜乐拥有个性定制行业最专业的技术开发团队之一，我们本着开源、开放和共享的开发理念，不但为国内个性定制行业提供了最先进的在线定制系统，而且开发出了适用于定制礼品行业的专卖店系统。我们更会以优质的服务，为你提供业界一流的系统维护和技术支持。</p>\r\n</div>','2012-06-12 11:16:20','2012-06-25 10:14:07',1,0,'','','','',NULL,NULL),(8,'定制流程','one_column','','','personalized-gifts','','<style type=\"text/css\">\r\n.gifts .ad-title { padding-left:20px; font-family:Arial, Helvetica, sans-serif; font-size:15px; font-weight:bolder; color:#000;}\r\n.gifts .ad-title-1 { padding-left:20px; font-family:Arial, Helvetica, sans-serif; font-size:15px; font-weight:bolder; color:#000; text-align:center;}\r\n.gifts .tm-title{padding-left:20px; padding-top:20px; font-family:Arial, Helvetica, sans-serif; font-size:15px; font-weight:bolder; color:#F00;}\r\n.gifts .b-img{ text-align:center; padding:10px;}\r\n</style>\r\n\r\n<div class=\"gifts padding-15 whiteback\">\r\n<p class=\"ad-title\">挑选礼品是一件费时且费钱的麻烦事，淘定制帮你轻松搞定！</p>\r\n<div>\r\n<p class=\"ad-title-1\" ><a title=\"在线提交你的设计或图片，或即时添加文字，简单几步操作即可完成个性定制设计，你可以免费分享给好友，或直接购买自己定制的产品。\" href=\"javascript:ShowDiyWin({\'pid\':\'1165\', \'rid\':10038642});\">立即开始定制体验</a></p>\r\n<p class=\"b-img\"><a title=\"在线提交你的设计或图片，或即时添加文字，简单几步操作即可完成个性定制设计，你可以免费分享给好友，或直接购买自己定制的产品。\" href=\"javascript:ShowDiyWin({\'pid\':\'1165\', \'rid\':10038642});\"><img alt=\"\" src=\"http://www.ecczo.cn/sites/default/files/u16/design.jpg\"  /></a></p></div>\r\n <p style=\"font-size:12px; padding-left:20px;\"> 只需简单三步操作，即可选好富有独特个性的创意礼品，而且还为你节省不少钱哩。</p>\r\n <p class=\"tm-title\"> 步骤一：用宜乐独有的礼品挑选工具来浏览和选择中意的礼品</p>\r\n<p class=\"b-img\"><img alt=\"\" src=\"http://www.ecczo.cn/sites/default/files/u16/design-1.jpg\" style=\"width: 667px;\"/></p>\r\n<p class=\"tm-title\">步骤二：仅花3－5分钟，即可在线完成并提交所选礼品的定制设计</p>\r\n<p class=\"b-img\"> <img alt=\"\" src=\"http://www.ecczo.cn/sites/default/files/u16/design-2.jpg\" style=\"width: 667px;\" /></p>\r\n<p class=\"tm-title\">步骤三：到卖家店铺完成所选礼品的购买和支付</p>\r\n<p class=\"b-img\"> <img alt=\"\" src=\"http://www.ecczo.cn/sites/default/files/u16/design-3.jpg\" style=\"width: 667px;\" /></p>\r\n</div>\r\n            <script>\r\n              (function(){\r\n                  var ac = document.createElement(\'script\'); ac.type = \'text/javascript\'; ac.async = true; \r\n                  ac.src = \'http://www.ecczo.cn/_diyWidget/diy.js?t=\'+new Date().getTime();\r\n                  var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(ac, s);\r\n              })();\r\n            </script>','2012-06-12 11:18:36','2012-07-14 10:44:00',1,0,'','','','',NULL,NULL),(9,'联系我们','one_column','','','contact-us','','<div class=\'whiteback padding-15\'>\r\n        <p>如果您对宜乐网的产品或在定制过程中有任何疑问，对我们的服务有任何意见或建议，欢迎您直接与我们联系，我们将竭诚为您服务！\r\n        <p>如果你想与宜乐合作，请访问：<a href=\"http://www.ecczo.cn/partners\">http://www.ecczo.cn/partners</a>\r\n        <p>想了解有关宜乐在线定制系统的技术信息，请访问：<a href=\"http://www.ecczo.cn/technologies\">http://www.ecczo.cn/technologies</a>\r\n	<h3>联系方式</h3>\r\n        <p>\r\n	公司名称：深圳市宜乐创想信息技术有限公司<br>\r\n	地　　址：深圳市南山区蛇口南山电子商务创新基地B310室<br>\r\n	邮　　编：518067<br>\r\n	电　　话：0755—2696&nbsp;6123<br>\r\n	E-mail  &nbsp;：service(AT)ecczo.cn<br></p>\r\n<p></p>\r\n<p></p>\r\n\r\n<iframe width=\"604\" height=\"875\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\" src=\"http://j.map.baidu.com/95o-f\"></iframe>\r\n\r\n</div>','2012-06-12 11:19:51','2012-06-12 11:19:51',1,0,'','','','',NULL,NULL),(10,'商务合作','one_column','','','partners','','<div class=\'whiteback padding-15\'>\r\n<h1>商务合作</h1>\r\n<p>宜乐是一个开放和协作的平台，欢迎有兴趣的个人、公司或组织与宜乐洽谈商务合作，共同促进中国创意商务市场的发展。\r\n\r\n<h3>定制系统合作</h3>\r\n<p>如果你在运营自己的个性定制产品淘宝店铺或B2C网上商店，你可以利用宜乐在线定制系统为你的客户提供在线定制设计工具，不但可增强用户体验，也可以提高客服效率且降低你的运营成本。宜乐在线定制系统可做为插件集成进你的淘宝店铺或天猫旗舰店，以及基于任何购物车系统的B2C网站。\r\n\r\n<h3>设计师联盟</h3>\r\n<p>如果你是一个专业设计师或摄影师，我们诚邀你加入宜乐设计师联盟。你可以通过分享自己的设计和创意而赢得众多创意社区会员的关注和喜爱，更可通过个性定制产品实现原创的价值，获得设计酬报。\r\n\r\n<h3>供应商网络</h3>\r\n<p>如果你是个性定制产品供应商，或创意设计产品品牌商家，可以申请加入宜乐供应商网络，将你的独特产品分享给宜乐社区会员，同时可得到众多高价值的忠实客户。\r\n\r\n<h3>分销商加盟</h3>\r\n<p>如果你是网上零售商家，希望为自己的产品线添加创意设计和个性定制的产品系列，请申请加盟宜乐分销商网络。无论你是淘宝店铺，还是自己的独立B2C商城，宜乐及其供应商网络的创意产品系列都可满足你的客户需求。无需额外产品采购和库存管理成本，你就可以将自己网站的流量转化为订单，从而带来额外的销售和利润收入。\r\n\r\n<h3>社交网络联盟</h3>\r\n<p>如果你的网站(或者微博/空间)有自己独特的用户/粉丝群，你可以申请成为宜乐社交网络联盟的一员。无论是个人博客站点，新浪微博，QQ空间，还是大型图片分享网站，你都可以将宜乐及其供应商的创意产品推荐给你的用户，一旦成交即可获得订单交易额分成。\r\n\r\n<h3>应用开发者合作</h3>\r\n<p>如果你是网页或移动应用开发者，你可以通过宜乐定制的开放接口API将你的应用与宜乐平台对接，为你的应用用户提供在线定制设计和挑选创意礼品的选项，你可以从成交的订单中获得提成，从而实现化流量为金钱。另外，你也可以将宜乐创意礼品做为可以兑换的礼品植入你的应用，以此奖励和吸引你的客户。\r\n\r\n<p>即便你不符合以上任何一种情况，若有意向跟我们合作，也请联系我们。\r\n\r\n<h3>联系方式：</h3>\r\n<p>\r\n电话：86-755-2696 6123<br/>\r\nEmail: partners(AT)ecczo.cn<br/>\r\nQQ: 9300021\r\n<p>\r\n\r\n\r\n</div>','2012-06-12 11:56:46','2012-06-12 11:56:46',1,0,'','','','',NULL,NULL),(11,'发货时间','one_column','','','shipping','','<p>不同的产品，生产制作的周期也不相同。</p>\r\n<p>一般情况下，照片冲印的制作周期为1-2天；</p>\r\n<p>笔记本、贴贴纸、鼠标垫、照片墙、lomo卡片、贺卡的制作周期为3天；</p>\r\n<p>新年挂历、海报年历、小巧/八寸台历、杯子、明信片、手机贴纸的制作周期为4天；</p>\r\n<p>水晶台历、无框画、画册、相纸lomo卡、T恤、银饰制作周期为5天;</p>\r\n<p>绒面抱枕、木版画的制作周期为6天。</p>\r\n<p>纯棉抱枕、丝巾的制作周期为7天。</p>\r\n<p>I潮品48小时内发货<br>\r\n</p>\r\n','2012-06-12 12:10:04','2012-06-12 12:10:04',1,0,'','','','',NULL,NULL),(12,'配送时间','one_column','','','delivery-time','','普通快递：2-10天；<br>\r\n宅急送快递：2-7天；<br>\r\nE邮宝：3-15天；','2012-06-12 12:13:35','2012-06-12 12:13:35',1,0,'','','','',NULL,NULL),(13,'配送运费','one_column','','','fare','','普通快递：<br>\r\n浙江省、上海市、江苏省6.00元/包裹；<br>\r\n广东省8.00元单；<br>\r\n北京市、天津市、山东省、福建省、湖北省、湖南省、江西省、安徽省、河北省、山西省、河南省、陕西省、四川省、重庆市、广西省、海南省、辽宁省、吉林省、宁夏省、贵州省、云南省10.00元/包裹；<br>\r\n黑龙江省、内蒙古、甘肃省、青海省、西藏、新疆15.00元/包裹。<br>\r\n（单笔订单折后满149元即可免运费）<br>\r\n​<br>\r\n顺丰快递：<br>\r\n浙江省 12.00元/包裹； <br>\r\n广东省、上海市、江苏省、安微省 15.00元/包裹；<br>\r\n​江西省、湖南省、湖北省 22.00元/包裹；<br>\r\n西藏、青海、宁夏、新疆 30.00元/包裹；<br>\r\n中国大陆其它省市 25.00元/包裹。 <br>\r\n​<br>\r\n​<br>\r\nE邮宝：<br>\r\n中国大陆所有省市一律15.00元/包裹。<br>\r\n​<br>\r\nEMS特快：<br>\r\n辽宁省、吉林省、黑龙江省、西藏、新疆30.00元/包裹；<br>\r\n北京市、天津市、河北省、山西省、内蒙古、山东省、陕西省、甘肃省、宁夏、青海25.00元/包裹；<br>\r\n浙江省、上海市、江苏省、安徽省、福建省、江西省、河南省、湖北省、湖南省、广东省、广西省、海南省、重庆市、四川省、云南省、贵州省22.00元/包裹；','2012-06-12 12:14:21','2012-06-12 12:14:21',1,0,'','','','',NULL,NULL),(14,'信誉保证','one_column','','','credit-guarantee','','<p>宜乐网隐私政策<br>\r\n  欢迎访问Ecczo宜乐网。</p>\r\n<p>　　如果您在Ecczo宜乐网上访问或购物，您便接受了以下条件，请仔细阅读这些条件。当您使用现行或未来的Ecczo宜乐网服务(例如，我的账户、礼品卡商城等)，或者在与Ecczo宜乐网有关联的企业进行访问或购物，不论其是否包含在Ecczo宜乐网网站上，您也应受制适用于那些服务和业务的准则和条件；如果以下条件与那些准则和条件不一致，则以那些准则和条件为准。</p>\r\n<p>　　通过使用Ecczo宜乐网及其提供的服务，您将受本使用条件和所有有关的政策、条件和准则的约束。如果您不同意本使用条件中的任何一条，您可以不使用Ecczo宜乐网。</p>\r\n<p>一、隐私<br>\r\n  请阅读我们的隐私声明以了解我们的惯例，该声明也适用于您对Ecczo宜乐网的访问。</p>\r\n<p>二、电子通讯<br>\r\n  当您访问Ecczo宜乐网或给我们发送电子邮件时，您与我们用网络方式进行联系。您同意以网络方式接受我们的信息，我们将用电子邮件或通过在Ecczo宜乐网发布通知的方式与您进行联系。您同意我们用网络方式提供给您的所有协议、通知、披露和其他信息，是符合此类通讯书面形式的法定要求的。如果Ecczo宜乐网能够证明以网络形式的信息已经发送给您，或者Ecczo宜乐网立即在Ecczo宜乐网上张贴这样的通知，将被视为您已收到所有协议、声明、披露和其他信息版权。</p>\r\n<p>　　Ecczo宜乐网的所有内容诸如文字、图表、标识、按钮图标、图像、声音文件片段、数字下载、数据编辑和软件都是Ecczo或其关联公司或其内容提供者的财产，受国际版权法的保护。Ecczo宜乐网所有内容的汇编是Ecczo宜乐网的排他财产，受国际版权法的保护。Ecczo宜乐网所使用的所有软件都是Ecczo宜乐网或其关联公司或其软件供应商的财产，受国际版权法的保护。</p>\r\n<p>三、Ecczo宜乐网的权利<br>\r\n  Ecczo宜乐网的图表、标识、网页页眉、按钮图标、文字、服务品名都是Ecczo宜乐网或其关联公司或Ecczo宜乐网的关联公司的商标或装潢。这些商标或装潢，不可以以任何可能引起消费者混淆的方式或任何贬低或诽谤Ecczo宜乐网或其关联公司或Ecczo宜乐网的关联公司的方式，用于与非Ecczo宜乐网或其关联公司相联系的任何产品或服务上。在Ecczo宜乐网网站上出现的不属于上述主体的所有其他商标是其商标权利人各自的财产，这些权利人可能是也可能不是与Ecczo宜乐网或其关联公司或Ecczo宜乐网的关联公司相关联、相联系或由Ecczo宜乐网或其关联公司或Ecczo宜乐网的关联公司赞助的。未经Ecczo宜乐网或相关商标所有人的书面许可，Ecczo宜乐网的任何东西都不应被解释为以默许或其他方式授予许可或使用网站上出现的商标的权利许可和网站进入。</p>\r\n<p>　　Ecczo宜乐网授予您有限的许可进入和个人使用Ecczo宜乐网网站，未经Ecczo宜乐网的明确书面同意不许下载（除了页面缓存）或修改网站或其任何部分。这一许可不包括对Ecczo宜乐网或其内容的转售或商业利用、任何收集和利用产品目录、说明和价格、任何对Ecczo或宜乐网其内容的衍生利用、任何为其他商业利益而下载或拷贝账户信息或使用任何数据采集、Robots或类似的数据收集和摘录工具。未经Ecczo宜乐网的书面许可，严禁对Ecczo宜乐网的内容进行系统获取以直接或间接创建或编辑文集、汇编、数据库或人名地址录（无论是否通过Robots、Spiders、自动仪器或手工操作）。另外，严禁为任何未经本使用条件明确允许的目的而使用Ecczo宜乐网的内容和材料。</p>\r\n<p>　　</p>\r\n<p>　　未经Ecczo宜乐网明确书面同意，不得以任何商业目的对Ecczo宜乐网或其任何部分进行复制、复印、仿造、出售、转售、访问、或以其他方式加以利用。未经Ecczo宜乐网明确书面同意，您不得用frame或运用frame技巧把Ecczo宜乐网或其关联公司的商标、标识或其他专有信息（包括图像、文字、网页设计或形式）据为己有。未经Ecczo宜乐网明确书面同意，您不得以Meta Tags或任何其他“隐藏文本”方式使用我们的名字和商标。任何未经授权的使用都会终止Ecczo宜乐网所授予的允许或许可。您被授予有限的、可撤销的和非独家的权利建立连接到Ecczo宜乐网主页的超链接，只要这个链接不以虚假、误导、贬毁或其他侵犯性方式描写Ecczo宜乐网、其关联公司、Ecczo宜乐网的关联公司或它们的产品和服务。未经明确书面允许，您不可以使用任何标识或其他专有图标或商标作为这个链接的一部分。</p>\r\n<p>四、您的账户<br>\r\n  如果您使用Ecczo宜乐网，您有责任对您的账户和密码保守秘密并对进入您的计算机作出限制，并且您同意对在您的账户和密码下发生的所有活动承担责任。Ecczo宜乐网的确销售供儿童使用的产品，但只将它们销售给成年人。如果您在18岁以下，您只能在父母或监护人的参与下才能使用Ecczo宜乐网。Ecczo宜乐网及其关联公司保留在法律允许的范围内独自决定拒绝服务、关闭账户、清除或编辑内容或取消订单的权利。</p>\r\n<p>五、评论、意见、消息和其他内容<br>\r\n  访问者可以张贴评论、意见及其他内容，以及提出建议、主意、意见、问题或其他信息，只要内容不是非法、淫秽、威胁、诽谤、侵犯隐私、侵犯知识产权或以其他形式对第三者构成伤害或侵犯或令公众讨厌，也不包含软件病毒、政治宣传、商业招揽、连锁信、大宗邮件或任何形式的“垃圾邮件”。您不可以使用虚假的电子邮件地址、冒充任何他人或实体或以其它方式对卡片或其他内容的来源进行误导。Ecczo宜乐网保留清除或编辑这些内容的权利（但非义务），但不对所张贴的内容进行经常性的审查。如果您确实张贴了内容或提交了材料，除非我们有相反指示，您Ecczo宜乐网及其关联公司非排他的、免费的、永久的、不可撤销的和完全的再许可权而在全世界范围内任何媒体上使用、复制、修改、改写、出版、翻译、创作衍生作品、分发和展示这样的内容。您授予Ecczo宜乐网及其关联公司和被转许可人使用您所提交的与这些内容有关的名字的权利，如果他们选择这样做的话。您声明并担保您拥有或以其它方式控制您所张贴内容的权利，内容是准确的，对您所提供内容的使用不违反本政策并不会对任何人和实体造成伤害。您声明并保证对于因您所提供的内容引起的对Ecczo宜乐网或其关联公司的损害进行赔偿。Ecczo有权（但非义务）监控和编辑或清除任何活动或内容。Ecczo宜乐网对您或任何第三方所张贴的内容不承担责任。</p>\r\n<p>六、版权投诉<br>\r\n  Ecczo宜乐网及其关联公司尊重他人的知识产权。如果您相信您的作品已经以一种构成侵犯知识产权的方式被复制，请按照我们的版权侵权投诉程序行事。<br>\r\n  七、合同缔结<br>\r\n  如果您通过我们网站订购产品，您的订单就成为一种购买产品的申请或要约。我们将发送给您一封确认收到订单的电子邮件，其中载明订单的细节。但是只有当我们向您发出送货确认的电子邮件通知您我们已将产品发出时，我们对您合同申请的批准与接受才成立。如果您在一份订单里订购了多种产品并且我们只给您发出了关于其中一部分的发货确认电子邮件，那么直到我们发出关于其他产品的发货确认电子邮件，关于那部分产品的合同才成立。当您所购买的商品离开了Ecczo宜乐网或其关联公司的库房时，该物品的所有权和灭失风险即转移到您这一方。</p>\r\n<p>八、产品说明<br>\r\n  Ecczo宜乐网及其关联公司努力使产品说明尽可能准确。不过，我们并不保证产品说明或Ecczo宜乐网网站上的其他内容是准确的、完整的、可靠的、最新的或无错误的。如果Ecczo宜乐网提供的产品本身并非如说明所说，您完全可以将该未经使用过的产品退还我们，我们随即将您支付的款项奉还。</p>\r\n<p>九、格价<br>\r\n  直到您发出订单，我们才能确认商品的价格。尽管我们做出最大的努力，我们的商品目录里的一小部分商品可能会有定价错误。如果我们发现错误定价，我们将采取下列之一措施：</p>\r\n<p>（a） 如果某一商品的正确定价低于我们的错误定价，我们将按照较低的定价向您销售交付该商品。<br>\r\n  （b） 如果某一商品的正确定价高于我们的错误定价，我们会根据我们的情况决定，是否在交付前联系您寻求您的指示，或者取消订单并通知您。<br>\r\n  十、其他企业价<br>\r\n  Ecczo宜乐网及其关联企业之外的其他人可能在Ecczo宜乐网上经营商店、提供服务或者销售产品。另外，我们提供与关联公司和其他企业的链接。我们不负责审查和评估也不担保任何这些企业或个人的待售商品及它们网站的内容。我们对所有这些企业或任何其他第三人或其网站的行为、产品和内容不承担责任。您应仔细阅读它们自己的隐私政策及使用条件。</p>\r\n<p>十一、不承诺担保和责任限制价<br>\r\n  除非另有明确的书面说明, Ecczo宜乐网及其所包含的或以其它方式通过本网站提供给您的全部信息、内容、材料、产品（包括软件）和服务，是由Ecczo宜乐网在“按现状”和“按现有”的基础上提供的。除非另有明确的书面说明, Ecczo宜乐网不对本网站的运营及其包含在本网站上的信息、内容、材料、产品(包括软件)或服务作任何形式的、明示或默示的声明或担保（除根据法律规定的以外）。您明确同意自担风险使用本网站。</p>\r\n<p>　　在适用法律所允许的最大限度内 ，Ecczo宜乐网及其关联公司不承诺所有明示或默示的担保，包括但不限于对适销性和满足特定目的的默示担保。Ecczo宜乐网及其关联公司不担保Ecczo宜乐网网站、其所包含的或以其它方式通过本网站提供给您的全部信息、内容、材料、产品（包括软件）和服务、其服务器或从Ecczo宜乐网发出的电子信件没有病毒或其他有害成分。除非另有明确的书面说明，Ecczo宜乐网不对由于使用Ecczo宜乐网网站、或由于其所包含的或以其它方式通过本网站提供给您的全部信息、内容、材料、产品（包括软件）和服务、或购买和使用产品引起的任何损害承担责任（除非根据法律应承担责任的以外），包括但不限于直接、间接或附带的惩罚性和结果性的损害赔偿。</p>\r\n<p>十二、适用法律<br>\r\n  通过访问ecczo.cn网站， 您同意Ecczo宜乐网所在地中华人民共和国的有关法律（不包括其冲突法规则）对本使用条件以及可能在您和Ecczo宜乐网及其关联公司之间发生的任何类型的争议享有管辖权。 争议本条款及本条款之下您与Ecczo宜乐网的关系，受法律管辖。如您与Ecczo宜乐网就本协议内容或其执行发生任何争议，双方应尽量协商解决；协商不成时，任何一方均可向Ecczo宜乐网所在地的深圳市人民法院提起法律诉讼。</p>\r\n<p>十三、网站政策、修改和可分性<br>\r\n  请阅读我们张贴在Ecczo宜乐网网站上的其他政策。这些策略同样也适用于您对本网站的访问。我们保留在任何时候对我们的网站、政策和本使用条件作出更改的权利。任何更改或修改在其被张贴在Ecczo宜乐网时立即生效。您对Ecczo宜乐网的使用应受制于在使用时张贴在本网站上的使用条件。因而，我们建议您在使用Ecczo宜乐网之前阅读使用条件。您在使用条件更改或修改并张贴在本网站后继续使用本网站将构成您对该更改或修改的接受。如果您不同意对本使用条件的任何更改或修改，您可以不使用本网站并立即停止使用本网站。如果本使用条件中任何一条被视为废止、无效或因任何理由不可执行，该条件应视为可分的且并不影响任何其余条款的有效性和可执行性。</p>\r\n<p>十四、版权侵权投诉程序和通知<br>\r\n  如果您相信您的作品已经以一种构成侵犯知识产权的方式被复制，请用书面形式向我们的法律部门提供下列信息。请注意这个程序专为您知会我们您享有版权的材料已被侵权而使用。</p>\r\n<p>　· 被授权代表版权利益所有人行事的人的电子或亲笔签名；<br>\r\n  · 关于您声称已遭侵权的享有版权的作品的描述；<br>\r\n  · 关于您声称已遭侵权的材料在本网站所在位置的描述；<br>\r\n  · 您的地址、电话号码和电子邮件地址；<br>\r\n  · 您确信所引起争议的使用未经版权所有人或其代理人或法律的授权的声明。<br>\r\n  · 您以版权所有人或授权代表的名义声明保证上述信息正确真实，否则将承担作伪证的责任。<br>\r\n  如向Ecczo宜乐网投诉版权侵权，请联系：E-mail：info@ecczo.cn</p>\r\n','2012-06-12 12:18:41','2012-06-12 12:18:41',1,0,'','','','',NULL,NULL),(15,'退换货保障','one_column','','','return','','自客户签收商品之日起30天内，宜乐定制将为您办理退换货服务。<br>\r\n​<br>\r\n​◆特殊说明：<br>\r\n​a. 在退换产品时，请您保持产品的整洁完好,并附上送货单据并在送货单背面注明退换货原因（具体见退换货填写样式），如有遗失，我们将无法为您办理退换货。<br>\r\n​b. 下述情况，视为非产品质量问题，不予退换货。<br>\r\n​ ⅰ. 因环境光、显示器色差等原因而导致的网站上图片与实物的差异。<br>\r\n​ⅱ. 由于上传的数码相片分辨率过低、曝光不足而导致的噪点增加、曝光过度等问题。<br>\r\n​ⅲ. 因客户个人原因造成的商品损坏（T恤尺寸问题等），不予退换。<br>\r\n​c.购买产品时索取了发票的用户，在申请退款时，不论是订单部分金额退款还是全额退款，都请将发票和产品一起退回，否则将不予退款。','2012-06-12 12:20:27','2012-06-12 12:20:27',1,0,'','','','',NULL,NULL);
/*!40000 ALTER TABLE `cms_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cms_page_store`
--

DROP TABLE IF EXISTS `cms_page_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_page_store` (
  `page_id` smallint(6) NOT NULL,
  `store_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`page_id`,`store_id`),
  KEY `FK_CMS_PAGE_STORE_STORE` (`store_id`),
  CONSTRAINT `FK_CMS_PAGE_STORE_PAGE` FOREIGN KEY (`page_id`) REFERENCES `cms_page` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CMS_PAGE_STORE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='CMS Pages to Stores';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cms_page_store`
--

LOCK TABLES `cms_page_store` WRITE;
/*!40000 ALTER TABLE `cms_page_store` DISABLE KEYS */;
INSERT INTO `cms_page_store` VALUES (1,0),(3,0),(4,0),(5,0),(6,0),(7,0),(8,0),(9,0),(11,0),(12,0),(2,1),(10,1),(13,1),(14,1),(15,1),(2,2),(2,3),(2,4),(2,5);
/*!40000 ALTER TABLE `cms_page_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_cache`
--

DROP TABLE IF EXISTS `core_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_cache` (
  `id` varchar(255) NOT NULL,
  `data` mediumblob,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `expire_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_cache`
--

LOCK TABLES `core_cache` WRITE;
/*!40000 ALTER TABLE `core_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_cache_option`
--

DROP TABLE IF EXISTS `core_cache_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_cache_option` (
  `code` varchar(32) NOT NULL,
  `value` tinyint(3) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_cache_option`
--

LOCK TABLES `core_cache_option` WRITE;
/*!40000 ALTER TABLE `core_cache_option` DISABLE KEYS */;
INSERT INTO `core_cache_option` VALUES ('block_html',0),('collections',0),('config',0),('config_api',0),('eav',0),('layout',0),('translate',0);
/*!40000 ALTER TABLE `core_cache_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_cache_tag`
--

DROP TABLE IF EXISTS `core_cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_cache_tag` (
  `tag` varchar(100) NOT NULL DEFAULT '',
  `cache_id` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `IDX_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_cache_tag`
--

LOCK TABLES `core_cache_tag` WRITE;
/*!40000 ALTER TABLE `core_cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_config_data`
--

DROP TABLE IF EXISTS `core_config_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_config_data` (
  `config_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scope` enum('default','websites','stores','config') NOT NULL DEFAULT 'default',
  `scope_id` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT 'general',
  `value` text NOT NULL,
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_scope` (`scope`,`scope_id`,`path`)
) ENGINE=InnoDB AUTO_INCREMENT=583 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_config_data`
--

LOCK TABLES `core_config_data` WRITE;
/*!40000 ALTER TABLE `core_config_data` DISABLE KEYS */;
INSERT INTO `core_config_data` VALUES (1,'default',0,'web/unsecure/base_url','{{base_url}}'),(2,'default',0,'web/secure/base_url','{{base_url}}'),(3,'default',0,'general/locale/code','zh_CN'),(4,'default',0,'general/locale/timezone','Asia/Shanghai'),(5,'default',0,'currency/options/base','CNY'),(6,'default',0,'currency/options/default','CNY'),(7,'default',0,'currency/options/allow','CNY'),(8,'default',0,'awall/install/run','1299582440'),(9,'default',0,'cms/wysiwyg/enabled','hidden'),(10,'default',0,'cms/wysiwyg/use_static_urls_in_catalog','0'),(11,'default',0,'design/package/name','default'),(12,'default',0,'design/package/ua_regexp','a:0:{}'),(13,'default',0,'design/theme/locale',''),(14,'default',0,'design/theme/template',''),(15,'default',0,'design/theme/template_ua_regexp','a:0:{}'),(16,'default',0,'design/theme/skin','se101_blue'),(17,'default',0,'design/theme/skin_ua_regexp','a:0:{}'),(18,'default',0,'design/theme/layout',''),(19,'default',0,'design/theme/layout_ua_regexp','a:0:{}'),(20,'default',0,'design/theme/default','se101'),(21,'default',0,'design/theme/default_ua_regexp','a:0:{}'),(22,'default',0,'design/head/default_title','宜乐定制'),(23,'default',0,'design/head/title_prefix',''),(24,'default',0,'design/head/title_suffix',''),(25,'default',0,'design/head/default_description','宜乐定制'),(26,'default',0,'design/head/default_keywords','个性定制礼品,创意礼品'),(27,'default',0,'design/head/default_robots','INDEX,FOLLOW'),(28,'default',0,'design/head/includes',''),(29,'default',0,'design/head/demonotice','0'),(30,'default',0,'design/header/logo_src','images/logo.jpg'),(31,'default',0,'design/header/logo_alt','定制礼品'),(32,'default',0,'design/header/welcome','欢迎访问宜乐定制礼品专卖店标准演示版'),(33,'default',0,'design/footer/copyright','&copy;宜乐定制礼品专卖店. All Rights Reserved.'),(34,'default',0,'design/footer/absolute_footer',''),(35,'default',0,'design/watermark/image_size',''),(36,'default',0,'design/watermark/image_imageOpacity',''),(37,'default',0,'design/watermark/image_position','stretch'),(38,'default',0,'design/watermark/small_image_size',''),(39,'default',0,'design/watermark/small_image_imageOpacity',''),(40,'default',0,'design/watermark/small_image_position','stretch'),(41,'default',0,'design/watermark/thumbnail_size',''),(42,'default',0,'design/watermark/thumbnail_imageOpacity',''),(43,'default',0,'design/watermark/thumbnail_position','stretch'),(44,'default',0,'design/pagination/pagination_frame','5'),(45,'default',0,'design/pagination/pagination_frame_skip',''),(46,'default',0,'design/pagination/anchor_text_for_previous',''),(47,'default',0,'design/pagination/anchor_text_for_next',''),(48,'default',0,'easy_catalogimg/general/enabled','1'),(49,'default',0,'easy_catalogimg/general/showOnMain','1'),(50,'default',0,'easy_catalogimg/general/plisting','1'),(51,'default',0,'easy_catalogimg/general/anchor','1'),(52,'default',0,'easy_catalogimg/general/columnsCount','12'),(53,'default',0,'easy_catalogimg/general/showImageThumbnails','1'),(54,'default',0,'easy_catalogimg/general/resizeImageThumbnails','1'),(55,'default',0,'easy_catalogimg/general/height','80'),(56,'default',0,'easy_catalogimg/general/width','165'),(57,'default',0,'easy_catalogimg/general/showSubChild','1'),(58,'default',0,'easy_catalogimg/general/countSubChild','2'),(59,'default',0,'blog/blog/title','博客'),(60,'default',0,'blog/blog/route',''),(61,'default',0,'blog/blog/layout','page/2columns-right.phtml'),(62,'default',0,'blog/blog/dateformat','full'),(63,'default',0,'blog/blog/blogcrumbs','1'),(64,'default',0,'blog/blog/readmore',''),(65,'default',0,'blog/blog/useshortcontent','1'),(66,'default',0,'blog/blog/parse_cms','0'),(67,'default',0,'blog/blog/perpage',''),(68,'default',0,'blog/blog/categories_urls','1'),(69,'default',0,'blog/blog/bookmarkslist','0'),(70,'default',0,'blog/blog/bookmarkspost','0'),(71,'default',0,'blog/menu/left','0'),(72,'default',0,'blog/menu/right','2'),(73,'default',0,'blog/menu/footer','0'),(74,'default',0,'blog/menu/top','0'),(75,'default',0,'blog/menu/recent','10'),(76,'default',0,'blog/menu/category','1'),(77,'default',0,'blog/menu/tagcloud_size','10'),(78,'default',0,'blog/comments/enabled','0'),(79,'default',0,'blog/comments/login','0'),(80,'default',0,'blog/comments/approval','0'),(81,'default',0,'blog/comments/loginauto','0'),(82,'default',0,'blog/comments/recipient_email',''),(83,'default',0,'blog/comments/sender_email_identity','general'),(84,'default',0,'blog/comments/email_template','blog_comments_email_template'),(85,'default',0,'blog/recaptcha/enabled','0'),(86,'default',0,'blog/recaptcha/publickey',''),(87,'default',0,'blog/recaptcha/privatekey',''),(88,'default',0,'blog/rss/enable','0'),(89,'default',0,'blog/rss/image',''),(90,'default',0,'blog/rss/posts',''),(91,'default',0,'web/url/use_store','0'),(92,'default',0,'web/url/redirect_to_base','1'),(93,'default',0,'web/seo/use_rewrites','1'),(94,'default',0,'web/unsecure/base_link_url','{{unsecure_base_url}}'),(95,'default',0,'web/unsecure/base_skin_url','{{unsecure_base_url}}skin/'),(96,'default',0,'web/unsecure/base_media_url','{{unsecure_base_url}}media/'),(97,'default',0,'web/unsecure/base_js_url','{{unsecure_base_url}}js/'),(98,'default',0,'web/secure/base_link_url','{{secure_base_url}}'),(99,'default',0,'web/secure/base_skin_url','{{secure_base_url}}skin/'),(100,'default',0,'web/secure/base_media_url','{{secure_base_url}}media/'),(101,'default',0,'web/secure/base_js_url','{{secure_base_url}}js/'),(102,'default',0,'web/secure/use_in_frontend','0'),(103,'default',0,'web/secure/use_in_adminhtml','0'),(104,'default',0,'web/default/front','cms'),(105,'default',0,'web/default/cms_home_page','home'),(106,'default',0,'web/default/no_route','cms/index/noRoute'),(107,'default',0,'web/default/cms_no_route','no-route'),(108,'default',0,'web/default/cms_no_cookies','enable-cookies'),(109,'default',0,'web/default/show_cms_breadcrumbs','1'),(110,'default',0,'web/polls/poll_check_by_ip','0'),(111,'default',0,'web/cookie/cookie_lifetime','2592000'),(112,'default',0,'web/cookie/cookie_path',''),(113,'default',0,'web/cookie/cookie_domain',''),(114,'default',0,'web/cookie/cookie_httponly','1'),(115,'default',0,'web/session/use_remote_addr','0'),(116,'default',0,'web/session/use_http_via','0'),(117,'default',0,'web/session/use_http_x_forwarded_for','0'),(118,'default',0,'web/session/use_http_user_agent','0'),(119,'default',0,'web/session/use_frontend_sid','1'),(120,'default',0,'web/browser_capabilities/cookies','1'),(121,'default',0,'web/browser_capabilities/javascript','1'),(122,'default',0,'advanced/modules_disable_output/AW_All','0'),(123,'default',0,'advanced/modules_disable_output/AW_Blog','0'),(124,'default',0,'advanced/modules_disable_output/AW_Core','0'),(125,'default',0,'advanced/modules_disable_output/Bestmagento_BmProducts','0'),(126,'default',0,'advanced/modules_disable_output/Find_Feed','0'),(127,'default',0,'advanced/modules_disable_output/Mage_Admin','0'),(128,'default',0,'advanced/modules_disable_output/Mage_AdminNotification','1'),(129,'default',0,'advanced/modules_disable_output/Mage_Api','0'),(130,'default',0,'advanced/modules_disable_output/Mage_Authorizenet','0'),(131,'default',0,'advanced/modules_disable_output/Mage_Backup','0'),(132,'default',0,'advanced/modules_disable_output/Mage_Bundle','0'),(133,'default',0,'advanced/modules_disable_output/Mage_Catalog','0'),(134,'default',0,'advanced/modules_disable_output/Mage_CatalogIndex','0'),(135,'default',0,'advanced/modules_disable_output/Mage_CatalogInventory','0'),(136,'default',0,'advanced/modules_disable_output/Mage_CatalogRule','0'),(137,'default',0,'advanced/modules_disable_output/Mage_CatalogSearch','0'),(138,'default',0,'advanced/modules_disable_output/Mage_Centinel','0'),(139,'default',0,'advanced/modules_disable_output/Mage_Checkout','0'),(140,'default',0,'advanced/modules_disable_output/Mage_Cms','0'),(141,'default',0,'advanced/modules_disable_output/Mage_Compiler','0'),(142,'default',0,'advanced/modules_disable_output/Mage_Connect','0'),(143,'default',0,'advanced/modules_disable_output/Mage_Contacts','0'),(144,'default',0,'advanced/modules_disable_output/Mage_Core','0'),(145,'default',0,'advanced/modules_disable_output/Mage_Cron','0'),(146,'default',0,'advanced/modules_disable_output/Mage_Customer','0'),(147,'default',0,'advanced/modules_disable_output/Mage_Dataflow','0'),(148,'default',0,'advanced/modules_disable_output/Mage_Directory','0'),(149,'default',0,'advanced/modules_disable_output/Mage_Downloadable','0'),(150,'default',0,'advanced/modules_disable_output/Mage_Eav','0'),(151,'default',0,'advanced/modules_disable_output/Mage_GiftMessage','0'),(152,'default',0,'advanced/modules_disable_output/Mage_GoogleAnalytics','0'),(153,'default',0,'advanced/modules_disable_output/Mage_GoogleBase','0'),(154,'default',0,'advanced/modules_disable_output/Mage_GoogleCheckout','0'),(155,'default',0,'advanced/modules_disable_output/Mage_GoogleOptimizer','0'),(156,'default',0,'advanced/modules_disable_output/Mage_ImportExport','0'),(157,'default',0,'advanced/modules_disable_output/Mage_Index','0'),(158,'default',0,'advanced/modules_disable_output/Mage_Install','0'),(159,'default',0,'advanced/modules_disable_output/Mage_Log','0'),(160,'default',0,'advanced/modules_disable_output/Mage_Media','0'),(161,'default',0,'advanced/modules_disable_output/Mage_Newsletter','0'),(162,'default',0,'advanced/modules_disable_output/Mage_Page','0'),(163,'default',0,'advanced/modules_disable_output/Mage_PageCache','0'),(164,'default',0,'advanced/modules_disable_output/Mage_Paygate','0'),(165,'default',0,'advanced/modules_disable_output/Mage_Payment','0'),(166,'default',0,'advanced/modules_disable_output/Mage_Paypal','0'),(167,'default',0,'advanced/modules_disable_output/Mage_PaypalUk','0'),(168,'default',0,'advanced/modules_disable_output/Mage_Poll','0'),(169,'default',0,'advanced/modules_disable_output/Mage_ProductAlert','0'),(170,'default',0,'advanced/modules_disable_output/Mage_Rating','0'),(171,'default',0,'advanced/modules_disable_output/Mage_Reports','0'),(172,'default',0,'advanced/modules_disable_output/Mage_Review','0'),(173,'default',0,'advanced/modules_disable_output/Mage_Rss','0'),(174,'default',0,'advanced/modules_disable_output/Mage_Rule','0'),(175,'default',0,'advanced/modules_disable_output/Mage_Sales','0'),(176,'default',0,'advanced/modules_disable_output/Mage_SalesRule','0'),(177,'default',0,'advanced/modules_disable_output/Mage_Sendfriend','0'),(178,'default',0,'advanced/modules_disable_output/Mage_Shipping','0'),(179,'default',0,'advanced/modules_disable_output/Mage_Sitemap','0'),(180,'default',0,'advanced/modules_disable_output/Mage_Tag','0'),(181,'default',0,'advanced/modules_disable_output/Mage_Tax','0'),(182,'default',0,'advanced/modules_disable_output/Mage_Usa','0'),(183,'default',0,'advanced/modules_disable_output/Mage_Weee','0'),(184,'default',0,'advanced/modules_disable_output/Mage_Widget','0'),(185,'default',0,'advanced/modules_disable_output/Mage_Wishlist','0'),(186,'default',0,'advanced/modules_disable_output/Mage_XmlConnect','0'),(187,'default',0,'advanced/modules_disable_output/Phoenix_Moneybookers','0'),(188,'default',0,'advanced/modules_disable_output/TM_EasyCatalogImg','0'),(189,'default',0,'advanced/modules_disable_output/WP_CustomMenu','0'),(190,'default',0,'advanced/modules_disable_output/depends','0'),(191,'default',0,'general/country/default','CN'),(192,'default',0,'general/country/allow','BT,TL,CN,MO,HK,CF,DK,UA,UZ,UG,UY,TD,YE,AM,IL,IQ,IR,BZ,CV,RU,BG,HR,GU,GM,IS,GN,GW,LI,CG,CD,LY,LR,CA,GH,GA,HU,MP,GS,AQ,ZA,BW,QA,RW,LU,IN,ID,GT,EC,ER,SY,CU,TW,KG,DJ,KZ,CO,CR,CM,TV,TM,TR,LC,KN,ST,BL,VC,PM,CX,SH,MF,SM,GY,TZ,EG,ET,KI,TJ,SN,RS,SL,CY,SC,MX,TG,DM,DO,AX,AT,VE,BD,AO,AI,AG,AD,FM,NI,NG,NE,NP,PS,BS,PK,BB,PG,PY,PA,BH,BR,BF,BV,BI,GR,PW,CK,KY,DE,IT,SB,TK,LV,NO,CZ,MD,MA,MC,BN,FJ,SZ,SK,SI,SJ,LK,SG,NC,NZ,JP,CL,IM,KP,KH,GG,GD,GL,GE,VA,BE,MR,MU,TO,SA,FR,TF,GF,PF,FO,PL,PR,BA,TH,JE,ZW,HN,HT,AU,IE,EE,JM,TC,TT,BO,NR,SE,CH,GP,WF,VU,RE,BY,BM,PN,GI,FK,KW,KM,CC,PE,TN,LT,SO,JO,NA,NU,MM,RO,US,UM,VI,AS,LA,KE,FI,SD,SR,GB,IO,VG,NL,AN,MZ,LS,PH,SV,WS,PT,MN,MS,EH,ES,NF,CI,BJ,ZM,GQ,HM,VN,AZ,AF,DZ,AL,AE,OM,AR,AW,KR,MK,MV,MW,MQ,MY,YT,MH,MT,MG,ML,LB,ME'),(193,'default',0,'general/country/optional_zip_countries',''),(194,'default',0,'general/locale/firstday','0'),(195,'default',0,'general/locale/weekend','0,6'),(196,'default',0,'general/store_information/name','宜乐定制礼品专卖店'),(197,'default',0,'general/store_information/phone','0755—2696 6123'),(198,'default',0,'general/store_information/address','深圳市南山区蛇口南山电子商务创新基地B310室'),(199,'websites',1,'dev/debug/template_hints','0'),(200,'websites',1,'dev/debug/template_hints_blocks','0'),(201,'default',0,'currency/webservicex/timeout','100'),(202,'default',0,'currency/import/enabled','0'),(203,'default',0,'currency/import/service','webservicex'),(204,'default',0,'crontab/jobs/currency_rates_update/schedule/cron_expr','0 0 * * *'),(205,'default',0,'currency/import/time','00,00,00'),(206,'default',0,'currency/import/frequency','D'),(207,'default',0,'currency/import/error_email',''),(208,'default',0,'currency/import/error_email_identity','general'),(209,'default',0,'currency/import/error_email_template','currency_import_error_email_template'),(210,'default',0,'trans_email/ident_general/name','宜乐定制 '),(211,'default',0,'trans_email/ident_general/email','ansy.huang@ecczo.cn'),(212,'default',0,'trans_email/ident_sales/name','宜乐定制 '),(213,'default',0,'trans_email/ident_sales/email','ansy.huang@ecczo.cn'),(214,'default',0,'trans_email/ident_support/name','宜乐定制 '),(215,'default',0,'trans_email/ident_support/email','ansy.huang@ecczo.cn'),(216,'default',0,'trans_email/ident_custom1/name','宜乐定制 '),(217,'default',0,'trans_email/ident_custom1/email','ansy.huang@ecczo.cn'),(218,'default',0,'trans_email/ident_custom2/name','宜乐定制 '),(219,'default',0,'trans_email/ident_custom2/email','ansy.huang@ecczo.cn'),(220,'default',0,'contacts/contacts/enabled','1'),(221,'default',0,'contacts/email/recipient_email','宜乐定制'),(222,'default',0,'contacts/email/sender_email_identity','custom2'),(223,'default',0,'contacts/email/email_template','contacts_email_email_template'),(224,'default',0,'sales_email/order/enabled','1'),(225,'default',0,'sales_email/order/identity','sales'),(226,'default',0,'sales_email/order/template','sales_email_order_template'),(227,'default',0,'sales_email/order/guest_template','sales_email_order_guest_template'),(228,'default',0,'sales_email/order/copy_to','ansy.huang@ecczo.cn'),(229,'default',0,'sales_email/order/copy_method','copy'),(230,'default',0,'sales_email/order_comment/enabled','1'),(231,'default',0,'sales_email/order_comment/identity','sales'),(232,'default',0,'sales_email/order_comment/template','sales_email_order_comment_template'),(233,'default',0,'sales_email/order_comment/guest_template','sales_email_order_comment_guest_template'),(234,'default',0,'sales_email/order_comment/copy_to',''),(235,'default',0,'sales_email/order_comment/copy_method','bcc'),(236,'default',0,'sales_email/invoice/enabled','1'),(237,'default',0,'sales_email/invoice/identity','sales'),(238,'default',0,'sales_email/invoice/template','sales_email_invoice_template'),(239,'default',0,'sales_email/invoice/guest_template','sales_email_invoice_guest_template'),(240,'default',0,'sales_email/invoice/copy_to',''),(241,'default',0,'sales_email/invoice/copy_method','bcc'),(242,'default',0,'sales_email/invoice_comment/enabled','1'),(243,'default',0,'sales_email/invoice_comment/identity','sales'),(244,'default',0,'sales_email/invoice_comment/template','sales_email_invoice_comment_template'),(245,'default',0,'sales_email/invoice_comment/guest_template','sales_email_invoice_comment_guest_template'),(246,'default',0,'sales_email/invoice_comment/copy_to',''),(247,'default',0,'sales_email/invoice_comment/copy_method','bcc'),(248,'default',0,'sales_email/shipment/enabled','1'),(249,'default',0,'sales_email/shipment/identity','sales'),(250,'default',0,'sales_email/shipment/template','sales_email_shipment_template'),(251,'default',0,'sales_email/shipment/guest_template','sales_email_shipment_guest_template'),(252,'default',0,'sales_email/shipment/copy_to',''),(253,'default',0,'sales_email/shipment/copy_method','bcc'),(254,'default',0,'sales_email/shipment_comment/enabled','1'),(255,'default',0,'sales_email/shipment_comment/identity','sales'),(256,'default',0,'sales_email/shipment_comment/template','sales_email_shipment_comment_template'),(257,'default',0,'sales_email/shipment_comment/guest_template','sales_email_shipment_comment_guest_template'),(258,'default',0,'sales_email/shipment_comment/copy_to',''),(259,'default',0,'sales_email/shipment_comment/copy_method','bcc'),(260,'default',0,'sales_email/creditmemo/enabled','1'),(261,'default',0,'sales_email/creditmemo/identity','sales'),(262,'default',0,'sales_email/creditmemo/template','sales_email_creditmemo_template'),(263,'default',0,'sales_email/creditmemo/guest_template','sales_email_creditmemo_guest_template'),(264,'default',0,'sales_email/creditmemo/copy_to',''),(265,'default',0,'sales_email/creditmemo/copy_method','bcc'),(266,'default',0,'sales_email/creditmemo_comment/enabled','1'),(267,'default',0,'sales_email/creditmemo_comment/identity','sales'),(268,'default',0,'sales_email/creditmemo_comment/template','sales_email_creditmemo_comment_template'),(269,'default',0,'sales_email/creditmemo_comment/guest_template','sales_email_creditmemo_comment_guest_template'),(270,'default',0,'sales_email/creditmemo_comment/copy_to',''),(271,'default',0,'sales_email/creditmemo_comment/copy_method','bcc'),(272,'default',0,'rss/config/active','0'),(273,'default',0,'rss/wishlist/active','0'),(274,'default',0,'rss/catalog/new','0'),(275,'default',0,'rss/catalog/special','0'),(276,'default',0,'rss/catalog/salesrule','0'),(277,'default',0,'rss/catalog/tag','0'),(278,'default',0,'rss/catalog/category','0'),(279,'default',0,'rss/order/status_notified','1'),(280,'default',0,'payment/ccsave/active','0'),(281,'default',0,'payment/ccsave/title','Credit Card (saved)'),(282,'default',0,'payment/ccsave/order_status','pending'),(283,'default',0,'payment/ccsave/cctypes','AE,VI,MC,DI'),(284,'default',0,'payment/ccsave/useccv','0'),(285,'default',0,'payment/ccsave/centinel','0'),(286,'default',0,'payment/ccsave/allowspecific','0'),(287,'default',0,'payment/ccsave/min_order_total',''),(288,'default',0,'payment/ccsave/max_order_total',''),(289,'default',0,'payment/ccsave/sort_order',''),(290,'default',0,'payment/checkmo/active','0'),(291,'default',0,'payment/checkmo/title','Check / Money order'),(292,'default',0,'payment/checkmo/order_status','pending'),(293,'default',0,'payment/checkmo/allowspecific','0'),(294,'default',0,'payment/checkmo/payable_to',''),(295,'default',0,'payment/checkmo/mailing_address',''),(296,'default',0,'payment/checkmo/min_order_total',''),(297,'default',0,'payment/checkmo/max_order_total',''),(298,'default',0,'payment/checkmo/sort_order',''),(299,'default',0,'payment/free/title','No Payment Information Required'),(300,'default',0,'payment/free/active','0'),(301,'default',0,'payment/free/order_status','pending'),(302,'default',0,'payment/free/payment_action',''),(303,'default',0,'payment/free/allowspecific','0'),(304,'default',0,'payment/free/sort_order','1'),(305,'default',0,'payment/purchaseorder/active','0'),(306,'default',0,'payment/purchaseorder/title','Purchase Order'),(307,'default',0,'payment/purchaseorder/order_status','pending'),(308,'default',0,'payment/purchaseorder/allowspecific','0'),(309,'default',0,'payment/purchaseorder/min_order_total',''),(310,'default',0,'payment/purchaseorder/max_order_total',''),(311,'default',0,'payment/purchaseorder/sort_order',''),(312,'default',0,'payment/authorizenet/active','0'),(313,'default',0,'payment/authorizenet/title','Credit Card (Authorize.net)'),(314,'default',0,'payment/authorizenet/login',''),(315,'default',0,'payment/authorizenet/payment_action','authorize'),(316,'default',0,'payment/authorizenet/trans_key',''),(317,'default',0,'payment/authorizenet/order_status','processing'),(318,'default',0,'payment/authorizenet/test','1'),(319,'default',0,'payment/authorizenet/cgi_url','https://secure.authorize.net/gateway/transact.dll'),(320,'default',0,'payment/authorizenet/currency','USD'),(321,'default',0,'payment/authorizenet/debug','0'),(322,'default',0,'payment/authorizenet/email_customer','0'),(323,'default',0,'payment/authorizenet/merchant_email',''),(324,'default',0,'payment/authorizenet/cctypes','AE,VI,MC,DI'),(325,'default',0,'payment/authorizenet/useccv','0'),(326,'default',0,'payment/authorizenet/allowspecific','0'),(327,'default',0,'payment/authorizenet/min_order_total',''),(328,'default',0,'payment/authorizenet/max_order_total',''),(329,'default',0,'payment/authorizenet/sort_order',''),(330,'default',0,'payment/authorizenet/allow_partial_authorization','0'),(331,'default',0,'payment/authorizenet/centinel','0'),(332,'default',0,'payment/authorizenet_directpost/active','0'),(333,'default',0,'payment/authorizenet_directpost/payment_action','authorize'),(334,'default',0,'payment/authorizenet_directpost/title','Credit Card Direct Post (Authorize.net)'),(335,'default',0,'payment/authorizenet_directpost/login',''),(336,'default',0,'payment/authorizenet_directpost/trans_key',''),(337,'default',0,'payment/authorizenet_directpost/trans_md5',''),(338,'default',0,'payment/authorizenet_directpost/order_status','processing'),(339,'default',0,'payment/authorizenet_directpost/test','1'),(340,'default',0,'payment/authorizenet_directpost/cgi_url','https://secure.authorize.net/gateway/transact.dll'),(341,'default',0,'payment/authorizenet_directpost/currency','USD'),(342,'default',0,'payment/authorizenet_directpost/debug','0'),(343,'default',0,'payment/authorizenet_directpost/email_customer','0'),(344,'default',0,'payment/authorizenet_directpost/merchant_email',''),(345,'default',0,'payment/authorizenet_directpost/cctypes','AE,VI,MC,DI'),(346,'default',0,'payment/authorizenet_directpost/useccv','0'),(347,'default',0,'payment/authorizenet_directpost/allowspecific','0'),(348,'default',0,'payment/authorizenet_directpost/min_order_total',''),(349,'default',0,'payment/authorizenet_directpost/max_order_total',''),(350,'default',0,'payment/authorizenet_directpost/sort_order',''),(351,'default',0,'payment/alipay_payment/active','1'),(352,'default',0,'payment/alipay_payment/title','支付宝'),(353,'default',0,'payment/alipay_payment/service_type','create_partner_trade_by_buyer'),(354,'default',0,'payment/alipay_payment/gateway','www.alipay.com/cooperate/gateway.do?'),(355,'default',0,'payment/alipay_payment/partner_id','2088002402925200'),(356,'default',0,'payment/alipay_payment/security_code','uyn8b861h6fbemznf7drh202i8qzsa3q'),(357,'default',0,'payment/alipay_payment/seller_email','senlin_jiemei@hotmail.com  '),(358,'default',0,'payment/alipay_payment/transport','https'),(359,'default',0,'payment/alipay_payment/order_status','processing'),(360,'default',0,'payment/alipay_payment/order_status_payment_accepted','processing'),(361,'default',0,'payment/alipay_payment/order_status_payment_refused',''),(362,'default',0,'payment/alipay_payment/allowspecific','0'),(363,'default',0,'payment/alipay_payment/sort_order',''),(364,'default',0,'dev/restrict/allow_ips',''),(365,'default',0,'dev/debug/profiler','0'),(366,'default',0,'dev/template/allow_symlink','0'),(367,'default',0,'dev/translate_inline/active','0'),(368,'default',0,'dev/translate_inline/active_admin','0'),(369,'default',0,'dev/log/active','0'),(370,'default',0,'dev/log/file','system.log'),(371,'default',0,'dev/log/exception_file','exception.log'),(372,'default',0,'dev/js/merge_files','0'),(373,'default',0,'dev/js/deprecation','0'),(374,'default',0,'dev/css/merge_css_files','0'),(375,'default',0,'carriers/flatrate/active','0'),(376,'default',0,'carriers/flatrate/title','固定运费'),(377,'default',0,'carriers/flatrate/name','圆通快递'),(378,'default',0,'carriers/flatrate/type','I'),(379,'default',0,'carriers/flatrate/price','20'),(380,'default',0,'carriers/flatrate/handling_type','F'),(381,'default',0,'carriers/flatrate/handling_fee',''),(382,'default',0,'carriers/flatrate/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(383,'default',0,'carriers/flatrate/sallowspecific','0'),(384,'default',0,'carriers/flatrate/specificcountry',''),(385,'default',0,'carriers/flatrate/showmethod','0'),(386,'default',0,'carriers/flatrate/sort_order',''),(387,'default',0,'carriers/tablerate/active','1'),(388,'default',0,'carriers/tablerate/title','快递'),(389,'default',0,'carriers/tablerate/name','圆通快递'),(390,'default',0,'carriers/tablerate/condition_name','package_weight'),(391,'default',0,'carriers/tablerate/include_virtual_price','1'),(392,'default',0,'carriers/tablerate/handling_type','F'),(393,'default',0,'carriers/tablerate/handling_fee',''),(394,'default',0,'carriers/tablerate/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(395,'default',0,'carriers/tablerate/sallowspecific','0'),(396,'default',0,'carriers/tablerate/specificcountry',''),(397,'default',0,'carriers/tablerate/showmethod','0'),(398,'default',0,'carriers/tablerate/sort_order',''),(399,'default',0,'carriers/freeshipping/active','0'),(400,'default',0,'carriers/freeshipping/title','Free Shipping'),(401,'default',0,'carriers/freeshipping/name','Free'),(402,'default',0,'carriers/freeshipping/free_shipping_subtotal',''),(403,'default',0,'carriers/freeshipping/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(404,'default',0,'carriers/freeshipping/sallowspecific','0'),(405,'default',0,'carriers/freeshipping/specificcountry',''),(406,'default',0,'carriers/freeshipping/showmethod','0'),(407,'default',0,'carriers/freeshipping/sort_order','admin'),(408,'default',0,'carriers/ups/active','0'),(409,'default',0,'carriers/ups/type','UPS'),(410,'default',0,'carriers/ups/password','hobeD5FSZEfwELIBMGw5ag=='),(411,'default',0,'carriers/ups/access_license_number',''),(412,'default',0,'carriers/ups/username',''),(413,'default',0,'carriers/ups/mode_xml','1'),(414,'default',0,'carriers/ups/gateway_xml_url','https://onlinetools.ups.com/ups.app/xml/Rate'),(415,'default',0,'carriers/ups/origin_shipment','Shipments Originating in United States'),(416,'default',0,'carriers/ups/negotiated_active','0'),(417,'default',0,'carriers/ups/gateway_url','http://www.ups.com/using/services/rave/qcostcgi.cgi'),(418,'default',0,'carriers/ups/title','United Parcel Service'),(419,'default',0,'carriers/ups/shipper_number',''),(420,'default',0,'carriers/ups/container','CP'),(421,'default',0,'carriers/ups/dest_type','RES'),(422,'default',0,'carriers/ups/unit_of_measure','LBS'),(423,'default',0,'carriers/ups/tracking_xml_url','https://www.ups.com/ups.app/xml/Track'),(424,'default',0,'carriers/ups/pickup','CC'),(425,'default',0,'carriers/ups/max_package_weight','150'),(426,'default',0,'carriers/ups/min_package_weight','0.1'),(427,'default',0,'carriers/ups/handling_type','F'),(428,'default',0,'carriers/ups/handling_action','O'),(429,'default',0,'carriers/ups/handling_fee',''),(430,'default',0,'carriers/ups/allowed_methods','1DM,1DML,1DA,1DAL,1DAPI,1DP,1DPL,2DM,2DML,2DA,2DAL,3DS,GND,GNDCOM,GNDRES,STD,XPR,WXS,XPRL,XDM,XDML,XPD'),(431,'default',0,'carriers/ups/free_method','GND'),(432,'default',0,'carriers/ups/free_shipping_enable','0'),(433,'default',0,'carriers/ups/free_shipping_subtotal',''),(434,'default',0,'carriers/ups/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(435,'default',0,'carriers/ups/sallowspecific','0'),(436,'default',0,'carriers/ups/specificcountry',''),(437,'default',0,'carriers/ups/debug','0'),(438,'default',0,'carriers/ups/showmethod','0'),(439,'default',0,'carriers/ups/sort_order',''),(440,'default',0,'carriers/usps/active','0'),(441,'default',0,'carriers/usps/gateway_url','http://production.shippingapis.com/ShippingAPI.dll'),(442,'default',0,'carriers/usps/title','United States Postal Service'),(443,'default',0,'carriers/usps/userid',''),(444,'default',0,'carriers/usps/container','VARIABLE'),(445,'default',0,'carriers/usps/size','REGULAR'),(446,'default',0,'carriers/usps/machinable','true'),(447,'default',0,'carriers/usps/max_package_weight','70'),(448,'default',0,'carriers/usps/handling_type','F'),(449,'default',0,'carriers/usps/handling_action','O'),(450,'default',0,'carriers/usps/handling_fee',''),(451,'default',0,'carriers/usps/allowed_methods','Bound Printed Matter,Express Mail,Express Mail Flat Rate Envelope,Express Mail Flat Rate Envelope Hold For Pickup,Express Mail Flat-Rate Envelope Sunday/Holiday Guarantee,Express Mail Hold For Pickup,Express Mail International,Express Mail International Flat Rate Envelope,Express Mail PO to PO,Express Mail Sunday/Holiday Guarantee,First-Class Mail International Large Envelope,First-Class Mail International Letters,First-Class Mail International Package,First-Class,First-Class Mail,First-Class Mail Flat,First-Class Mail Large Envelope,First-Class Mail International,First-Class Mail Letter,First-Class Mail Parcel,First-Class Mail Package,Global Express Guaranteed (GXG),Global Express Guaranteed Non-Document Non-Rectangular,Global Express Guaranteed Non-Document Rectangular,Library Mail,Media Mail,Parcel Post,Priority Mail,Priority Mail Small Flat Rate Box,Priority Mail Medium Flat Rate Box,Priority Mail Large Flat Rate Box,Priority Mail Flat Rate Box,Priority Mail Flat Rate Envelope,Priority Mail International,Priority Mail International Flat Rate Box,Priority Mail International Flat Rate Envelope,Priority Mail International Small Flat Rate Box,Priority Mail International Medium Flat Rate Box,Priority Mail International Large Flat Rate Box,USPS GXG Envelopes'),(452,'default',0,'carriers/usps/free_method',''),(453,'default',0,'carriers/usps/free_shipping_enable','0'),(454,'default',0,'carriers/usps/free_shipping_subtotal',''),(455,'default',0,'carriers/usps/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(456,'default',0,'carriers/usps/sallowspecific','0'),(457,'default',0,'carriers/usps/specificcountry',''),(458,'default',0,'carriers/usps/showmethod','0'),(459,'default',0,'carriers/usps/debug','0'),(460,'default',0,'carriers/usps/sort_order',''),(461,'default',0,'carriers/fedex/active','0'),(462,'default',0,'carriers/fedex/title','Federal Express'),(463,'default',0,'carriers/fedex/gateway_url','https://gateway.fedex.com/GatewayDC'),(464,'default',0,'carriers/fedex/account',''),(465,'default',0,'carriers/fedex/packaging','YOURPACKAGING'),(466,'default',0,'carriers/fedex/dropoff','REGULARPICKUP'),(467,'default',0,'carriers/fedex/max_package_weight','150'),(468,'default',0,'carriers/fedex/handling_type','F'),(469,'default',0,'carriers/fedex/handling_action','O'),(470,'default',0,'carriers/fedex/residence_delivery','0'),(471,'default',0,'carriers/fedex/handling_fee',''),(472,'default',0,'carriers/fedex/allowed_methods','PRIORITYOVERNIGHT,STANDARDOVERNIGHT,FIRSTOVERNIGHT,FEDEX2DAY,FEDEXEXPRESSSAVER,INTERNATIONALPRIORITY,INTERNATIONALECONOMY,INTERNATIONALFIRST,FEDEX1DAYFREIGHT,FEDEX2DAYFREIGHT,FEDEX3DAYFREIGHT,FEDEXGROUND,GROUNDHOMEDELIVERY,INTERNATIONALPRIORITY FREIGHT,INTERNATIONALECONOMY FREIGHT,EUROPEFIRSTINTERNATIONALPRIORITY'),(473,'default',0,'carriers/fedex/free_method','FEDEXGROUND'),(474,'default',0,'carriers/fedex/free_shipping_enable','0'),(475,'default',0,'carriers/fedex/free_shipping_subtotal',''),(476,'default',0,'carriers/fedex/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(477,'default',0,'carriers/fedex/sallowspecific','0'),(478,'default',0,'carriers/fedex/specificcountry',''),(479,'default',0,'carriers/fedex/debug','0'),(480,'default',0,'carriers/fedex/showmethod','0'),(481,'default',0,'carriers/fedex/sort_order',''),(482,'default',0,'carriers/dhl/active','0'),(483,'default',0,'carriers/dhl/gateway_url','https://eCommerce.airborne.com/ApiLandingTest.asp'),(484,'default',0,'carriers/dhl/title','DHL'),(485,'default',0,'carriers/dhl/id',''),(486,'default',0,'carriers/dhl/password',''),(487,'default',0,'carriers/dhl/account',''),(488,'default',0,'carriers/dhl/shipping_intlkey',''),(489,'default',0,'carriers/dhl/shipping_key',''),(490,'default',0,'carriers/dhl/shipment_type','P'),(491,'default',0,'carriers/dhl/handling_type','F'),(492,'default',0,'carriers/dhl/handling_action','O'),(493,'default',0,'carriers/dhl/contentdesc','Big Box'),(494,'default',0,'carriers/dhl/handling_fee',''),(495,'default',0,'carriers/dhl/dutiable','0'),(496,'default',0,'carriers/dhl/max_package_weight','150'),(497,'default',0,'carriers/dhl/dutypaymenttype','R'),(498,'default',0,'carriers/dhl/allowed_methods','IE,E SAT,E 10:30AM,E,N,S,G'),(499,'default',0,'carriers/dhl/specificerrmsg','This shipping method is currently unavailable. If you would like to ship using this shipping method, please contact us.'),(500,'default',0,'carriers/dhl/free_method','G'),(501,'default',0,'carriers/dhl/free_shipping_enable','0'),(502,'default',0,'carriers/dhl/free_shipping_subtotal',''),(503,'default',0,'carriers/dhl/additional_protection_enabled','0'),(504,'default',0,'carriers/dhl/additional_protection_min_value',''),(505,'default',0,'carriers/dhl/additional_protection_use_subtotal','0'),(506,'default',0,'carriers/dhl/additional_protection_value',''),(507,'default',0,'carriers/dhl/additional_protection_rounding','0'),(508,'default',0,'carriers/dhl/hazardous_materials','0'),(509,'default',0,'carriers/dhl/default_length',''),(510,'default',0,'carriers/dhl/default_width',''),(511,'default',0,'carriers/dhl/default_height',''),(512,'default',0,'carriers/dhl/shipment_days','1,2,3,4,5,6'),(513,'default',0,'carriers/dhl/intl_shipment_days','1,2,3,4,5'),(514,'default',0,'carriers/dhl/sallowspecific','0'),(515,'default',0,'carriers/dhl/specificcountry',''),(516,'default',0,'carriers/dhl/showmethod','0'),(517,'default',0,'carriers/dhl/debug','0'),(518,'default',0,'carriers/dhl/sort_order',''),(519,'default',0,'design/head/shortcut_icon','default/favicon.ico'),(521,'websites',1,'carriers/tablerate/import','shipping-default-cn.csv'),(522,'default',0,'catalog/frontend/list_mode','grid-list'),(523,'default',0,'catalog/frontend/grid_per_page_values','12,24,32'),(524,'default',0,'catalog/frontend/grid_per_page','12'),(525,'default',0,'catalog/frontend/list_per_page_values','5,10,15,20,25'),(526,'default',0,'catalog/frontend/list_per_page','10'),(527,'default',0,'catalog/frontend/list_allow_all','0'),(528,'default',0,'catalog/frontend/default_sort_by','position'),(529,'default',0,'catalog/frontend/flat_catalog_category','0'),(530,'default',0,'catalog/frontend/flat_catalog_product','0'),(531,'default',0,'catalog/frontend/parse_url_directives','1'),(532,'default',0,'catalog/sitemap/tree_mode','0'),(533,'default',0,'catalog/sitemap/lines_perpage','30'),(534,'default',0,'catalog/review/allow_guest','1'),(535,'default',0,'catalog/productalert/allow_price','0'),(536,'default',0,'catalog/productalert/email_price_template','catalog_productalert_email_price_template'),(537,'default',0,'catalog/productalert/allow_stock','0'),(538,'default',0,'catalog/productalert/email_stock_template','catalog_productalert_email_stock_template'),(539,'default',0,'catalog/productalert/email_identity','general'),(540,'default',0,'catalog/productalert_cron/frequency','D'),(541,'default',0,'crontab/jobs/catalog_product_alert/schedule/cron_expr','0 0 * * *'),(542,'default',0,'crontab/jobs/catalog_product_alert/run/model','productalert/observer::process'),(543,'default',0,'catalog/productalert_cron/time','00,00,00'),(544,'default',0,'catalog/productalert_cron/error_email',''),(545,'default',0,'catalog/productalert_cron/error_email_identity','general'),(546,'default',0,'catalog/productalert_cron/error_email_template','catalog_productalert_cron_error_email_template'),(547,'default',0,'catalog/recently_products/scope','website'),(548,'default',0,'catalog/recently_products/viewed_count','5'),(549,'default',0,'catalog/recently_products/compared_count','5'),(550,'default',0,'catalog/price/scope','0'),(551,'default',0,'catalog/layered_navigation/price_range_calculation','auto'),(552,'default',0,'catalog/navigation/max_depth','0'),(553,'default',0,'catalog/seo/site_map','1'),(554,'default',0,'catalog/seo/search_terms','1'),(555,'default',0,'catalog/seo/product_url_suffix','.html'),(556,'default',0,'catalog/seo/category_url_suffix','.html'),(557,'default',0,'catalog/seo/product_use_categories','1'),(558,'default',0,'catalog/seo/save_rewrites_history','1'),(559,'default',0,'catalog/seo/title_separator','-'),(560,'default',0,'catalog/seo/category_canonical_tag','0'),(561,'default',0,'catalog/seo/product_canonical_tag','0'),(562,'default',0,'catalog/search/min_query_length','1'),(563,'default',0,'catalog/search/max_query_length','128'),(564,'default',0,'catalog/search/max_query_words','10'),(565,'default',0,'catalog/search/search_type','1'),(566,'default',0,'catalog/search/use_layered_navigation_count','2000'),(567,'default',0,'catalog/downloadable/order_item_status','9'),(568,'default',0,'catalog/downloadable/downloads_number','0'),(569,'default',0,'catalog/downloadable/shareable','0'),(570,'default',0,'catalog/downloadable/samples_title','Samples'),(571,'default',0,'catalog/downloadable/links_title','Links'),(572,'default',0,'catalog/downloadable/links_target_new_window','1'),(573,'default',0,'catalog/downloadable/content_disposition','inline'),(574,'default',0,'catalog/downloadable/disable_guest_checkout','1'),(575,'default',0,'catalog/custom_options/use_calendar','0'),(576,'default',0,'catalog/custom_options/date_fields_order','m,d,y'),(577,'default',0,'catalog/custom_options/time_format','12h'),(578,'default',0,'catalog/custom_options/year_range',','),(579,'stores',4,'design/theme/skin','se101_orange'),(580,'stores',5,'design/theme/skin','se101_pink'),(581,'stores',2,'design/theme/skin','se101_green'),(582,'stores',3,'design/theme/skin','se101_blue');
/*!40000 ALTER TABLE `core_config_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_email_template`
--

DROP TABLE IF EXISTS `core_email_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_email_template` (
  `template_id` int(7) unsigned NOT NULL AUTO_INCREMENT,
  `template_code` varchar(150) DEFAULT NULL,
  `template_text` text,
  `template_styles` text,
  `template_type` int(3) unsigned DEFAULT NULL,
  `template_subject` varchar(200) DEFAULT NULL,
  `template_sender_name` varchar(200) DEFAULT NULL,
  `template_sender_email` varchar(200) DEFAULT NULL,
  `added_at` datetime DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `orig_template_code` varchar(200) DEFAULT NULL,
  `orig_template_variables` text NOT NULL,
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `template_code` (`template_code`),
  KEY `added_at` (`added_at`),
  KEY `modified_at` (`modified_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Email templates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_email_template`
--

LOCK TABLES `core_email_template` WRITE;
/*!40000 ALTER TABLE `core_email_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_email_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_flag`
--

DROP TABLE IF EXISTS `core_flag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_flag` (
  `flag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `flag_code` varchar(255) NOT NULL,
  `state` smallint(5) unsigned NOT NULL DEFAULT '0',
  `flag_data` text,
  `last_update` datetime NOT NULL,
  PRIMARY KEY (`flag_id`),
  KEY `last_update` (`last_update`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_flag`
--

LOCK TABLES `core_flag` WRITE;
/*!40000 ALTER TABLE `core_flag` DISABLE KEYS */;
INSERT INTO `core_flag` VALUES (2,'catalog_product_flat',0,'a:1:{s:8:\"is_built\";b:1;}','2012-07-02 10:18:07'),(3,'admin_notification_survey',0,'a:1:{s:13:\"survey_viewed\";b:1;}','2011-03-07 12:54:33');
/*!40000 ALTER TABLE `core_flag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_layout_link`
--

DROP TABLE IF EXISTS `core_layout_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_layout_link` (
  `layout_link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `area` varchar(64) NOT NULL DEFAULT '',
  `package` varchar(64) NOT NULL DEFAULT '',
  `theme` varchar(64) NOT NULL DEFAULT '',
  `layout_update_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`layout_link_id`),
  UNIQUE KEY `store_id` (`store_id`,`package`,`theme`,`layout_update_id`),
  KEY `FK_core_layout_link_update` (`layout_update_id`),
  CONSTRAINT `FK_CORE_LAYOUT_LINK_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_LAYOUT_LINK_UPDATE` FOREIGN KEY (`layout_update_id`) REFERENCES `core_layout_update` (`layout_update_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_layout_link`
--

LOCK TABLES `core_layout_link` WRITE;
/*!40000 ALTER TABLE `core_layout_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_layout_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_layout_update`
--

DROP TABLE IF EXISTS `core_layout_update`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_layout_update` (
  `layout_update_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) DEFAULT NULL,
  `xml` text,
  `sort_order` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`layout_update_id`),
  KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_layout_update`
--

LOCK TABLES `core_layout_update` WRITE;
/*!40000 ALTER TABLE `core_layout_update` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_layout_update` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_resource`
--

DROP TABLE IF EXISTS `core_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_resource` (
  `code` varchar(50) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `data_version` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Resource version registry';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_resource`
--

LOCK TABLES `core_resource` WRITE;
/*!40000 ALTER TABLE `core_resource` DISABLE KEYS */;
INSERT INTO `core_resource` VALUES ('adminnotification_setup','1.0.0','1.0.0'),('admin_setup','0.7.2','0.7.2'),('alipay_setup','0.9.2','0.9.2'),('api_setup','0.8.1','0.8.1'),('awall_setup','2.1.2','2.1.2'),('awcore_setup','1.0.2','1.0.2'),('backup_setup','0.7.0','0.7.0'),('blog_setup','1.0.21','1.0.21'),('bundle_setup','0.1.14','0.1.14'),('catalogindex_setup','0.7.10','0.7.10'),('cataloginventory_setup','0.7.8','0.7.8'),('catalogrule_setup','0.7.10','0.7.10'),('catalogsearch_setup','0.7.7','0.7.7'),('catalog_setup','1.4.0.0.44','1.4.0.0.44'),('checkout_setup','0.9.5','0.9.5'),('chronopay_setup','0.1.0',NULL),('cms_setup','0.7.13','0.7.13'),('compiler_setup','0.1.0','0.1.0'),('contacts_setup','0.8.0','0.8.0'),('core_setup','0.8.28','0.8.28'),('cron_setup','0.7.1','0.7.1'),('customer_setup','1.4.0.0.14','1.4.0.0.14'),('cybermut_setup','0.1.0',NULL),('cybersource_setup','0.7.0',NULL),('dataflow_setup','0.7.4','0.7.4'),('directory_setup','0.8.11','0.8.11'),('downloadable_setup','1.4.0.3','1.4.0.3'),('easycatalogimg_setup','0.5.4','0.5.4'),('eav_setup','0.7.16','0.7.16'),('eway_setup','0.1.0',NULL),('find_feed_setup','0.0.2','0.0.2'),('flo2cash_setup','0.1.1',NULL),('giftmessage_setup','0.7.6','0.7.6'),('googleanalytics_setup','0.1.0',NULL),('googlebase_setup','0.1.2','0.1.2'),('googlecheckout_setup','0.7.4','0.7.4'),('googleoptimizer_setup','0.1.2','0.1.2'),('ideal_setup','0.1.0',NULL),('importexport_setup','0.1.0','0.1.0'),('index_setup','1.4.0.2','1.4.0.2'),('log_setup','0.7.7','0.7.7'),('moneybookers_setup','1.2.0.1','1.2.0.1'),('newsletter_setup','0.8.3','0.8.3'),('oscommerce_setup','0.8.10',NULL),('paybox_setup','0.1.3',NULL),('paygate_setup','0.7.1','0.7.1'),('payment_setup','0.7.0','0.7.0'),('paypaluk_setup','0.7.0','0.7.0'),('paypal_setup','1.4.0.2','1.4.0.2'),('poll_setup','0.7.2','0.7.2'),('productalert_setup','0.7.2','0.7.2'),('protx_setup','0.1.0',NULL),('rating_setup','0.7.2','0.7.2'),('reports_setup','0.7.10','0.7.10'),('review_setup','0.7.6','0.7.6'),('salesrule_setup','1.4.0.0.6','1.4.0.0.6'),('sales_setup','1.4.0.25','1.4.0.25'),('sendfriend_setup','0.7.4','0.7.4'),('shipping_setup','0.7.0','0.7.0'),('sitemap_setup','0.7.2','0.7.2'),('ssologin_setup','0.0.1','0.0.1'),('strikeiron_setup','0.9.1',NULL),('tag_setup','0.7.7','0.7.7'),('tax_setup','1.4.0.1','1.4.0.1'),('usa_setup','0.7.1','0.7.1'),('weee_setup','0.13','0.13'),('widget_setup','1.4.0.0.0','1.4.0.0.0'),('wishlist_setup','0.7.9','0.7.9'),('xmlconnect_setup','1.4.0.13','1.4.0.13');
/*!40000 ALTER TABLE `core_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_session`
--

DROP TABLE IF EXISTS `core_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_session` (
  `session_id` varchar(255) NOT NULL DEFAULT '',
  `website_id` smallint(5) unsigned DEFAULT NULL,
  `session_expires` int(10) unsigned NOT NULL DEFAULT '0',
  `session_data` mediumblob NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `FK_SESSION_WEBSITE` (`website_id`),
  CONSTRAINT `FK_SESSION_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Session data store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_session`
--

LOCK TABLES `core_session` WRITE;
/*!40000 ALTER TABLE `core_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `core_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_store`
--

DROP TABLE IF EXISTS `core_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_store` (
  `store_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL DEFAULT '',
  `website_id` smallint(5) unsigned DEFAULT '0',
  `group_id` smallint(5) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`store_id`),
  UNIQUE KEY `code` (`code`),
  KEY `FK_STORE_WEBSITE` (`website_id`),
  KEY `is_active` (`is_active`,`sort_order`),
  KEY `FK_STORE_GROUP` (`group_id`),
  CONSTRAINT `FK_STORE_GROUP_STORE` FOREIGN KEY (`group_id`) REFERENCES `core_store_group` (`group_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_STORE_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Stores';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_store`
--

LOCK TABLES `core_store` WRITE;
/*!40000 ALTER TABLE `core_store` DISABLE KEYS */;
INSERT INTO `core_store` VALUES (0,'admin',0,0,'Admin',0,1),(1,'default',1,1,'红色主题',0,1),(2,'german',1,1,'绿色主题',2,1),(3,'french',1,1,'蓝色主题',3,1),(4,'orange',1,1,'橙色主题',5,1),(5,'pink',1,1,'粉色主题',4,1);
/*!40000 ALTER TABLE `core_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_store_group`
--

DROP TABLE IF EXISTS `core_store_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_store_group` (
  `group_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `website_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `root_category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `default_store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`),
  KEY `FK_STORE_GROUP_WEBSITE` (`website_id`),
  KEY `default_store_id` (`default_store_id`),
  CONSTRAINT `FK_STORE_GROUP_WEBSITE` FOREIGN KEY (`website_id`) REFERENCES `core_website` (`website_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_store_group`
--

LOCK TABLES `core_store_group` WRITE;
/*!40000 ALTER TABLE `core_store_group` DISABLE KEYS */;
INSERT INTO `core_store_group` VALUES (0,0,'Default',0,0),(1,1,'Main Store',3,1);
/*!40000 ALTER TABLE `core_store_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_translate`
--

DROP TABLE IF EXISTS `core_translate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_translate` (
  `key_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `string` varchar(255) NOT NULL DEFAULT '',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `translate` varchar(255) NOT NULL DEFAULT '',
  `locale` varchar(20) NOT NULL DEFAULT 'en_US',
  PRIMARY KEY (`key_id`),
  UNIQUE KEY `IDX_CODE` (`store_id`,`locale`,`string`),
  KEY `FK_CORE_TRANSLATE_STORE` (`store_id`),
  CONSTRAINT `FK_CORE_TRANSLATE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COMMENT='Translation data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_translate`
--

LOCK TABLES `core_translate` WRITE;
/*!40000 ALTER TABLE `core_translate` DISABLE KEYS */;
INSERT INTO `core_translate` VALUES (1,'Size',0,'Size','en_US'),(2,'Color',0,'Color','en_US'),(3,'Thumbnail Image',0,'Thumbnail Image','en_US'),(4,'Med image',0,'Med image','en_US'),(5,'Large Image',0,'Large Image','en_US'),(6,'Medium Image',0,'Medium Image','en_US'),(7,'Main Image',0,'Main Image','en_US'),(8,'In Depth',0,'In Depth','en_US'),(9,'Small Image',0,'Small Image','en_US'),(10,'Manufacturer',0,'Manufacturer','en_US'),(11,'Dimensions',0,'Dimensions','en_US'),(12,'Model',0,'Model','en_US'),(13,'Activation Information',0,'Activation Information','en_US'),(14,'Thumbnail',0,'Thumbnail','en_US'),(15,'Description',0,'Description','en_US'),(16,'Weight',0,'Weight','en_US'),(17,'Processor',0,'Processor','en_US'),(18,'Memory',0,'Memory','en_US'),(19,'Hardrive',0,'Hardrive','en_US'),(20,'Screensize',0,'Screensize','en_US'),(21,'Gender',0,'Gender','en_US'),(22,'Shoe Size',0,'Shoe Size','en_US'),(23,'Shoe Type',0,'Shoe Type','en_US'),(24,'shape',0,'shape','en_US'),(25,'Short Description',0,'Short Description','en_US'),(26,'Country of Origin',0,'Country of Origin','en_US'),(27,'Room',0,'Room','en_US'),(28,'Finish',0,'Finish','en_US'),(29,'Manufacturer1',0,'Manufacturer1','en_US'),(30,'color-roy',0,'color-roy','en_US'),(31,'Megapixels',0,'Megapixels','en_US'),(32,'Shirt Size',0,'Shirt Size','en_US'),(33,'Visibility',0,'Visibility','en_US'),(34,'Tax Class',0,'Tax Class','en_US'),(35,'Status',0,'Status','en_US'),(36,'Price',0,'Price','en_US'),(37,'Tier Price',0,'Tier Price','en_US'),(38,'Special Price',0,'Special Price','en_US'),(39,'Meta Keywords',0,'Meta Keywords','en_US'),(40,'Max Resolution',0,'Max Resolution','en_US'),(41,'RAM SIze',0,'RAM SIze','en_US'),(42,'Contrast Ratio',0,'Contrast Ratio','en_US'),(43,'Response Time',0,'Response Time','en_US'),(44,'CPU Speed',0,'CPU Speed','en_US'),(45,'Disk Speed',0,'Disk Speed','en_US'),(46,'Brand',0,'Brand','en_US'),(47,'Mage_Checkout::<a class=\"cart-links\" href=\"%s\"><strong>0 <span>item</span></strong></a>',0,'<a class=\"cart-links\" href=\"%s\"><strong>0 <span>件</span></strong></a>','zh_CN'),(48,'Mage_Checkout::<a class=\"cart-links\" href=\"%s\"><strong>0 <span>item</span></strong></a>',1,'<a class=\"cart-links\" href=\"%s\"><strong>0 <span>件</span></strong></a>','zh_CN'),(49,'Bestmagento_BmProducts::Hot Deals',1,'热销商品','zh_CN'),(50,'Mage_Catalog::New Arrivals',1,'新品上市','zh_CN'),(52,'WP_CustomMenu::More Categories >>',1,'更多分类','zh_CN'),(53,'Bestmagento_BmProducts::Popular Products',1,'热门产品','zh_CN'),(54,'Bestmagento_BmProducts::Featured Products',1,'推荐商品','zh_CN'),(55,'Bestmagento_BmProducts::Top Deals',1,'销量排行','zh_CN'),(56,'Mage_Catalog::Click to View Large Image',1,'点击浏览大图','zh_CN'),(57,'Mage_Catalog::Availability:',1,'商品数量:','zh_CN'),(58,'Mage_Catalog::In stock',0,'有库存','zh_CN'),(59,'Bestmagento_BmProducts::Hot Deals',2,'热销商品','zh_CN'),(60,'Bestmagento_BmProducts::Hot Deals',3,'热销商品','zh_CN'),(61,'Bestmagento_BmProducts::Hot Deals',5,'热销商品','zh_CN'),(62,'Bestmagento_BmProducts::Hot Deals',4,'热销商品','zh_CN'),(64,'WP_CustomMenu::Featured Categories',0,'产品分类','zh_CN'),(65,'WP_CustomMenu::More Categories >>',2,'更多分类 >>','zh_CN');
/*!40000 ALTER TABLE `core_translate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `core_url_rewrite`
--

DROP TABLE IF EXISTS `core_url_rewrite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_url_rewrite` (
  `url_rewrite_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `category_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `id_path` varchar(255) NOT NULL DEFAULT '',
  `request_path` varchar(255) NOT NULL DEFAULT '',
  `target_path` varchar(255) NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned DEFAULT '1',
  `options` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`url_rewrite_id`),
  UNIQUE KEY `UNQ_REQUEST_PATH` (`request_path`,`store_id`),
  UNIQUE KEY `UNQ_PATH` (`id_path`,`is_system`,`store_id`),
  KEY `FK_CORE_URL_REWRITE_STORE` (`store_id`),
  KEY `FK_CORE_URL_REWRITE_CATEGORY` (`category_id`),
  KEY `FK_CORE_URL_REWRITE_PRODUCT` (`product_id`),
  KEY `IDX_ID_PATH` (`id_path`),
  KEY `IDX_CATEGORY_REWRITE` (`category_id`,`is_system`,`product_id`,`store_id`,`id_path`),
  KEY `IDX_TARGET_PATH` (`target_path`,`store_id`),
  CONSTRAINT `core_url_rewrite_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_URL_REWRITE_CATEGORY` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_URL_REWRITE_PRODUCT` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_CORE_URL_REWRITE_STORE` FOREIGN KEY (`store_id`) REFERENCES `core_store` (`store_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14942 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `core_url_rewrite`
--

LOCK TABLES `core_url_rewrite` WRITE;
/*!40000 ALTER TABLE `core_url_rewrite` DISABLE KEYS */;
INSERT INTO `core_url_rewrite` VALUES (25,1,20,NULL,'category/20','household-items.html','catalog/category/view/id/20',1,'',NULL),(302,3,20,NULL,'category/20','household-items.html','catalog/category/view/id/20',1,'',NULL),(579,2,20,NULL,'category/20','household-items.html','catalog/category/view/id/20',1,'',NULL),(832,1,35,NULL,'category/35','featured-products.html','catalog/category/view/id/35',1,'',NULL),(845,3,35,NULL,'category/35','featured-products.html','catalog/category/view/id/35',1,'',NULL),(858,2,35,NULL,'category/35','featured-products.html','catalog/category/view/id/35',1,'',NULL),(889,1,36,NULL,'category/36','occasion.html','catalog/category/view/id/36',1,'',NULL),(890,3,36,NULL,'category/36','occasion.html','catalog/category/view/id/36',1,'',NULL),(891,2,36,NULL,'category/36','occasion.html','catalog/category/view/id/36',1,'',NULL),(892,1,37,NULL,'category/37','recipients.html','catalog/category/view/id/37',1,'',NULL),(893,3,37,NULL,'category/37','recipients.html','catalog/category/view/id/37',1,'',NULL),(894,2,37,NULL,'category/37','recipients.html','catalog/category/view/id/37',1,'',NULL),(895,1,38,NULL,'category/38','gifts.html','catalog/category/view/id/38',1,'',NULL),(896,3,38,NULL,'category/38','gifts.html','catalog/category/view/id/38',1,'',NULL),(897,2,38,NULL,'category/38','gifts.html','catalog/category/view/id/38',1,'',NULL),(898,1,39,NULL,'category/39','diy.html','catalog/category/view/id/39',1,'',NULL),(899,3,39,NULL,'category/39','diy.html','catalog/category/view/id/39',1,'',NULL),(900,2,39,NULL,'category/39','diy.html','catalog/category/view/id/39',1,'',NULL),(901,1,40,NULL,'category/40','watch.html','catalog/category/view/id/40',1,'',NULL),(902,3,40,NULL,'category/40','watch.html','catalog/category/view/id/40',1,'',NULL),(903,2,40,NULL,'category/40','watch.html','catalog/category/view/id/40',1,'',NULL),(904,1,39,NULL,'14293500_1339139353','a-ae-a-sa.html','diy.html',0,'RP',NULL),(905,3,39,NULL,'15624600_1339139353','a-ae-a-sa.html','diy.html',0,'RP',NULL),(906,2,39,NULL,'18235800_1339139353','a-ae-a-sa.html','diy.html',0,'RP',NULL),(907,1,38,NULL,'15994300_1339139363','a-ae-c-a.html','gifts.html',0,'RP',NULL),(908,3,38,NULL,'20115600_1339139363','a-ae-c-a.html','gifts.html',0,'RP',NULL),(909,2,38,NULL,'21149700_1339139363','a-ae-c-a.html','gifts.html',0,'RP',NULL),(910,1,37,NULL,'88888200_1339139406','e-c-a-e.html','recipients.html',0,'RP',NULL),(911,3,37,NULL,'90394200_1339139406','e-c-a-e.html','recipients.html',0,'RP',NULL),(912,2,37,NULL,'91428400_1339139406','e-c-a-e.html','recipients.html',0,'RP',NULL),(913,1,40,NULL,'57815600_1339139417','e-e.html','watch.html',0,'RP',NULL),(914,3,40,NULL,'59408100_1339139417','e-e.html','watch.html',0,'RP',NULL),(915,2,40,NULL,'61609700_1339139417','e-e.html','watch.html',0,'RP',NULL),(916,1,41,NULL,'category/41','watch/disney-watches.html','catalog/category/view/id/41',1,'',NULL),(917,3,41,NULL,'category/41','watch/disney-watches.html','catalog/category/view/id/41',1,'',NULL),(918,2,41,NULL,'category/41','watch/disney-watches.html','catalog/category/view/id/41',1,'',NULL),(919,1,42,NULL,'category/42','watch/alarm-clock.html','catalog/category/view/id/42',1,'',NULL),(920,3,42,NULL,'category/42','watch/alarm-clock.html','catalog/category/view/id/42',1,'',NULL),(921,2,42,NULL,'category/42','watch/alarm-clock.html','catalog/category/view/id/42',1,'',NULL),(922,1,43,NULL,'category/43','watch/timepiece.html','catalog/category/view/id/43',1,'',NULL),(923,3,43,NULL,'category/43','watch/timepiece.html','catalog/category/view/id/43',1,'',NULL),(924,2,43,NULL,'category/43','watch/timepiece.html','catalog/category/view/id/43',1,'',NULL),(925,1,44,NULL,'category/44','watch/personalized-custom-watches.html','catalog/category/view/id/44',1,'',NULL),(926,3,44,NULL,'category/44','watch/personalized-custom-watches.html','catalog/category/view/id/44',1,'',NULL),(927,2,44,NULL,'category/44','watch/personalized-custom-watches.html','catalog/category/view/id/44',1,'',NULL),(928,1,45,NULL,'category/45','jewelry.html','catalog/category/view/id/45',1,'',NULL),(929,3,45,NULL,'category/45','jewelry.html','catalog/category/view/id/45',1,'',NULL),(930,2,45,NULL,'category/45','jewelry.html','catalog/category/view/id/45',1,'',NULL),(931,1,46,NULL,'category/46','jewelry/necklace.html','catalog/category/view/id/46',1,'',NULL),(932,3,46,NULL,'category/46','jewelry/necklace.html','catalog/category/view/id/46',1,'',NULL),(933,2,46,NULL,'category/46','jewelry/necklace.html','catalog/category/view/id/46',1,'',NULL),(934,1,47,NULL,'category/47','jewelry/bracelet.html','catalog/category/view/id/47',1,'',NULL),(935,3,47,NULL,'category/47','jewelry/bracelet.html','catalog/category/view/id/47',1,'',NULL),(936,2,47,NULL,'category/47','jewelry/bracelet.html','catalog/category/view/id/47',1,'',NULL),(937,1,48,NULL,'category/48','jewelry/earring.html','catalog/category/view/id/48',1,'',NULL),(938,3,48,NULL,'category/48','jewelry/earring.html','catalog/category/view/id/48',1,'',NULL),(939,2,48,NULL,'category/48','jewelry/earring.html','catalog/category/view/id/48',1,'',NULL),(940,1,49,NULL,'category/49','jewelry/ring.html','catalog/category/view/id/49',1,'',NULL),(941,3,49,NULL,'category/49','jewelry/ring.html','catalog/category/view/id/49',1,'',NULL),(942,2,49,NULL,'category/49','jewelry/ring.html','catalog/category/view/id/49',1,'',NULL),(943,1,50,NULL,'category/50','usb-card.html','catalog/category/view/id/50',1,'',NULL),(944,3,50,NULL,'category/50','usb-card.html','catalog/category/view/id/50',1,'',NULL),(945,2,50,NULL,'category/50','usb-card.html','catalog/category/view/id/50',1,'',NULL),(946,1,51,NULL,'category/51','usb-card/u-disk-card.html','catalog/category/view/id/51',1,'',NULL),(947,3,51,NULL,'category/51','usb-card/u-disk-card.html','catalog/category/view/id/51',1,'',NULL),(948,2,51,NULL,'category/51','usb-card/u-disk-card.html','catalog/category/view/id/51',1,'',NULL),(949,1,52,NULL,'category/52','usb-card/wodden-usb-disk.html','catalog/category/view/id/52',1,'',NULL),(950,3,52,NULL,'category/52','usb-card/wodden-usb-disk.html','catalog/category/view/id/52',1,'',NULL),(951,2,52,NULL,'category/52','usb-card/wodden-usb-disk.html','catalog/category/view/id/52',1,'',NULL),(952,1,53,NULL,'category/53','usb-card/leather-usb-disk.html','catalog/category/view/id/53',1,'',NULL),(953,3,53,NULL,'category/53','usb-card/leather-usb-disk.html','catalog/category/view/id/53',1,'',NULL),(954,2,53,NULL,'category/53','usb-card/leather-usb-disk.html','catalog/category/view/id/53',1,'',NULL),(955,1,54,NULL,'category/54','usb-card/metal-usb-disk.html','catalog/category/view/id/54',1,'',NULL),(956,3,54,NULL,'category/54','usb-card/metal-usb-disk.html','catalog/category/view/id/54',1,'',NULL),(957,2,54,NULL,'category/54','usb-card/metal-usb-disk.html','catalog/category/view/id/54',1,'',NULL),(958,1,55,NULL,'category/55','usb-card/white-porcelain-usb-disk.html','catalog/category/view/id/55',1,'',NULL),(959,3,55,NULL,'category/55','usb-card/white-porcelain-usb-disk.html','catalog/category/view/id/55',1,'',NULL),(960,2,55,NULL,'category/55','usb-card/white-porcelain-usb-disk.html','catalog/category/view/id/55',1,'',NULL),(961,1,56,NULL,'category/56','digital-accessories.html','catalog/category/view/id/56',1,'',NULL),(962,3,56,NULL,'category/56','digital-accessories.html','catalog/category/view/id/56',1,'',NULL),(963,2,56,NULL,'category/56','digital-accessories.html','catalog/category/view/id/56',1,'',NULL),(964,1,57,NULL,'category/57','digital-accessories/fudiao-phone-case.html','catalog/category/view/id/57',1,'',NULL),(965,3,57,NULL,'category/57','digital-accessories/fudiao-phone-case.html','catalog/category/view/id/57',1,'',NULL),(966,2,57,NULL,'category/57','digital-accessories/fudiao-phone-case.html','catalog/category/view/id/57',1,'',NULL),(967,1,58,NULL,'category/58','digital-accessories/kezi-phone-case.html','catalog/category/view/id/58',1,'',NULL),(968,3,58,NULL,'category/58','digital-accessories/kezi-phone-case.html','catalog/category/view/id/58',1,'',NULL),(969,2,58,NULL,'category/58','digital-accessories/kezi-phone-case.html','catalog/category/view/id/58',1,'',NULL),(970,1,59,NULL,'category/59','digital-accessories/caihui-phone-case.html','catalog/category/view/id/59',1,'',NULL),(971,3,59,NULL,'category/59','digital-accessories/caihui-phone-case.html','catalog/category/view/id/59',1,'',NULL),(972,2,59,NULL,'category/59','digital-accessories/caihui-phone-case.html','catalog/category/view/id/59',1,'',NULL),(973,1,60,NULL,'category/60','digital-accessories/mouse.html','catalog/category/view/id/60',1,'',NULL),(974,3,60,NULL,'category/60','digital-accessories/mouse.html','catalog/category/view/id/60',1,'',NULL),(975,2,60,NULL,'category/60','digital-accessories/mouse.html','catalog/category/view/id/60',1,'',NULL),(976,1,61,NULL,'category/61','digital-accessories/computer-sleeve.html','catalog/category/view/id/61',1,'',NULL),(977,3,61,NULL,'category/61','digital-accessories/computer-sleeve.html','catalog/category/view/id/61',1,'',NULL),(978,2,61,NULL,'category/61','digital-accessories/computer-sleeve.html','catalog/category/view/id/61',1,'',NULL),(979,1,62,NULL,'category/62','digital-accessories/mp3.html','catalog/category/view/id/62',1,'',NULL),(980,3,62,NULL,'category/62','digital-accessories/mp3.html','catalog/category/view/id/62',1,'',NULL),(981,2,62,NULL,'category/62','digital-accessories/mp3.html','catalog/category/view/id/62',1,'',NULL),(982,1,63,NULL,'category/63','digital-accessories/cd-bag.html','catalog/category/view/id/63',1,'',NULL),(983,3,63,NULL,'category/63','digital-accessories/cd-bag.html','catalog/category/view/id/63',1,'',NULL),(984,2,63,NULL,'category/63','digital-accessories/cd-bag.html','catalog/category/view/id/63',1,'',NULL),(985,1,64,NULL,'category/64','digital-accessories/cd.html','catalog/category/view/id/64',1,'',NULL),(986,3,64,NULL,'category/64','digital-accessories/cd.html','catalog/category/view/id/64',1,'',NULL),(987,2,64,NULL,'category/64','digital-accessories/cd.html','catalog/category/view/id/64',1,'',NULL),(988,1,65,NULL,'category/65','digital-accessories/tablet-pc.html','catalog/category/view/id/65',1,'',NULL),(989,3,65,NULL,'category/65','digital-accessories/tablet-pc.html','catalog/category/view/id/65',1,'',NULL),(990,2,65,NULL,'category/65','digital-accessories/tablet-pc.html','catalog/category/view/id/65',1,'',NULL),(991,1,66,NULL,'category/66','digital-accessories/customize-iphone4-case.html','catalog/category/view/id/66',1,'',NULL),(992,3,66,NULL,'category/66','digital-accessories/customize-iphone4-case.html','catalog/category/view/id/66',1,'',NULL),(993,2,66,NULL,'category/66','digital-accessories/customize-iphone4-case.html','catalog/category/view/id/66',1,'',NULL),(994,1,67,NULL,'category/67','cups.html','catalog/category/view/id/67',1,'',NULL),(995,3,67,NULL,'category/67','cups.html','catalog/category/view/id/67',1,'',NULL),(996,2,67,NULL,'category/67','cups.html','catalog/category/view/id/67',1,'',NULL),(997,1,68,NULL,'category/68','cups/mug.html','catalog/category/view/id/68',1,'',NULL),(998,3,68,NULL,'category/68','cups/mug.html','catalog/category/view/id/68',1,'',NULL),(999,2,68,NULL,'category/68','cups/mug.html','catalog/category/view/id/68',1,'',NULL),(1000,1,69,NULL,'category/69','cups/bone-cup.html','catalog/category/view/id/69',1,'',NULL),(1001,3,69,NULL,'category/69','cups/bone-cup.html','catalog/category/view/id/69',1,'',NULL),(1002,2,69,NULL,'category/69','cups/bone-cup.html','catalog/category/view/id/69',1,'',NULL),(1003,1,70,NULL,'category/70','cups/coffee-cup.html','catalog/category/view/id/70',1,'',NULL),(1004,3,70,NULL,'category/70','cups/coffee-cup.html','catalog/category/view/id/70',1,'',NULL),(1005,2,70,NULL,'category/70','cups/coffee-cup.html','catalog/category/view/id/70',1,'',NULL),(1006,1,71,NULL,'category/71','cups/color-cup.html','catalog/category/view/id/71',1,'',NULL),(1007,3,71,NULL,'category/71','cups/color-cup.html','catalog/category/view/id/71',1,'',NULL),(1008,2,71,NULL,'category/71','cups/color-cup.html','catalog/category/view/id/71',1,'',NULL),(1009,1,72,NULL,'category/72','crystal.html','catalog/category/view/id/72',1,'',NULL),(1010,3,72,NULL,'category/72','crystal.html','catalog/category/view/id/72',1,'',NULL),(1011,2,72,NULL,'category/72','crystal.html','catalog/category/view/id/72',1,'',NULL),(1012,1,73,NULL,'category/73','crystal/caiyi-crystal.html','catalog/category/view/id/73',1,'',NULL),(1013,3,73,NULL,'category/73','crystal/caiyi-crystal.html','catalog/category/view/id/73',1,'',NULL),(1014,2,73,NULL,'category/73','crystal/caiyi-crystal.html','catalog/category/view/id/73',1,'',NULL),(1015,1,74,NULL,'category/74','crystal/diaoke-crystal.html','catalog/category/view/id/74',1,'',NULL),(1016,3,74,NULL,'category/74','crystal/diaoke-crystal.html','catalog/category/view/id/74',1,'',NULL),(1017,2,74,NULL,'category/74','crystal/diaoke-crystal.html','catalog/category/view/id/74',1,'',NULL),(1018,1,75,NULL,'category/75','crystal/crystal-card-holder.html','catalog/category/view/id/75',1,'',NULL),(1019,3,75,NULL,'category/75','crystal/crystal-card-holder.html','catalog/category/view/id/75',1,'',NULL),(1020,2,75,NULL,'category/75','crystal/crystal-card-holder.html','catalog/category/view/id/75',1,'',NULL),(1021,1,76,NULL,'category/76','crystal/laser-crystal.html','catalog/category/view/id/76',1,'',NULL),(1022,3,76,NULL,'category/76','crystal/laser-crystal.html','catalog/category/view/id/76',1,'',NULL),(1023,2,76,NULL,'category/76','crystal/laser-crystal.html','catalog/category/view/id/76',1,'',NULL),(1024,1,77,NULL,'category/77','crystal/crystal-trophy.html','catalog/category/view/id/77',1,'',NULL),(1025,3,77,NULL,'category/77','crystal/crystal-trophy.html','catalog/category/view/id/77',1,'',NULL),(1026,2,77,NULL,'category/77','crystal/crystal-trophy.html','catalog/category/view/id/77',1,'',NULL),(1027,1,77,NULL,'89610100_1339142290','crystal/ae-ae-a-ae.html','crystal/crystal-trophy.html',0,'RP',NULL),(1028,3,77,NULL,'91459600_1339142290','crystal/ae-ae-a-ae.html','crystal/crystal-trophy.html',0,'RP',NULL),(1029,2,77,NULL,'92927000_1339142290','crystal/ae-ae-a-ae.html','crystal/crystal-trophy.html',0,'RP',NULL),(1030,1,78,NULL,'category/78','office-supplies.html','catalog/category/view/id/78',1,'',NULL),(1031,3,78,NULL,'category/78','office-supplies.html','catalog/category/view/id/78',1,'',NULL),(1032,2,78,NULL,'category/78','office-supplies.html','catalog/category/view/id/78',1,'',NULL),(1033,1,79,NULL,'category/79','office-supplies/roller-pen.html','catalog/category/view/id/79',1,'',NULL),(1034,3,79,NULL,'category/79','office-supplies/roller-pen.html','catalog/category/view/id/79',1,'',NULL),(1035,2,79,NULL,'category/79','office-supplies/roller-pen.html','catalog/category/view/id/79',1,'',NULL),(1036,1,80,NULL,'category/80','office-supplies/cardcase.html','catalog/category/view/id/80',1,'',NULL),(1037,3,80,NULL,'category/80','office-supplies/cardcase.html','catalog/category/view/id/80',1,'',NULL),(1038,2,80,NULL,'category/80','office-supplies/cardcase.html','catalog/category/view/id/80',1,'',NULL),(1039,1,81,NULL,'category/81','office-supplies/notepad.html','catalog/category/view/id/81',1,'',NULL),(1040,3,81,NULL,'category/81','office-supplies/notepad.html','catalog/category/view/id/81',1,'',NULL),(1041,2,81,NULL,'category/81','office-supplies/notepad.html','catalog/category/view/id/81',1,'',NULL),(1042,1,82,NULL,'category/82','office-supplies/bookmark.html','catalog/category/view/id/82',1,'',NULL),(1043,3,82,NULL,'category/82','office-supplies/bookmark.html','catalog/category/view/id/82',1,'',NULL),(1044,2,82,NULL,'category/82','office-supplies/bookmark.html','catalog/category/view/id/82',1,'',NULL),(1045,1,83,NULL,'category/83','office-supplies/mouse-mat.html','catalog/category/view/id/83',1,'',NULL),(1046,3,83,NULL,'category/83','office-supplies/mouse-mat.html','catalog/category/view/id/83',1,'',NULL),(1047,2,83,NULL,'category/83','office-supplies/mouse-mat.html','catalog/category/view/id/83',1,'',NULL),(1048,1,84,NULL,'category/84','office-supplies/magnifier.html','catalog/category/view/id/84',1,'',NULL),(1049,3,84,NULL,'category/84','office-supplies/magnifier.html','catalog/category/view/id/84',1,'',NULL),(1050,2,84,NULL,'category/84','office-supplies/magnifier.html','catalog/category/view/id/84',1,'',NULL),(1051,1,85,NULL,'category/85','office-supplies/business-card.html','catalog/category/view/id/85',1,'',NULL),(1052,3,85,NULL,'category/85','office-supplies/business-card.html','catalog/category/view/id/85',1,'',NULL),(1053,2,85,NULL,'category/85','office-supplies/business-card.html','catalog/category/view/id/85',1,'',NULL),(1054,1,86,NULL,'category/86','office-supplies/writing-case.html','catalog/category/view/id/86',1,'',NULL),(1055,3,86,NULL,'category/86','office-supplies/writing-case.html','catalog/category/view/id/86',1,'',NULL),(1056,2,86,NULL,'category/86','office-supplies/writing-case.html','catalog/category/view/id/86',1,'',NULL),(1057,1,87,NULL,'category/87','office-supplies/ruler.html','catalog/category/view/id/87',1,'',NULL),(1058,3,87,NULL,'category/87','office-supplies/ruler.html','catalog/category/view/id/87',1,'',NULL),(1059,2,87,NULL,'category/87','office-supplies/ruler.html','catalog/category/view/id/87',1,'',NULL),(1060,1,88,NULL,'category/88','office-supplies/brush-pot.html','catalog/category/view/id/88',1,'',NULL),(1061,3,88,NULL,'category/88','office-supplies/brush-pot.html','catalog/category/view/id/88',1,'',NULL),(1062,2,88,NULL,'category/88','office-supplies/brush-pot.html','catalog/category/view/id/88',1,'',NULL),(1063,1,89,NULL,'category/89','office-supplies/pen.html','catalog/category/view/id/89',1,'',NULL),(1064,3,89,NULL,'category/89','office-supplies/pen.html','catalog/category/view/id/89',1,'',NULL),(1065,2,89,NULL,'category/89','office-supplies/pen.html','catalog/category/view/id/89',1,'',NULL),(1066,1,90,NULL,'category/90','business-gifts.html','catalog/category/view/id/90',1,'',NULL),(1067,3,90,NULL,'category/90','business-gifts.html','catalog/category/view/id/90',1,'',NULL),(1068,2,90,NULL,'category/90','business-gifts.html','catalog/category/view/id/90',1,'',NULL),(1069,1,91,NULL,'category/91','business-gifts/medal.html','catalog/category/view/id/91',1,'',NULL),(1070,3,91,NULL,'category/91','business-gifts/medal.html','catalog/category/view/id/91',1,'',NULL),(1071,2,91,NULL,'category/91','business-gifts/medal.html','catalog/category/view/id/91',1,'',NULL),(1072,1,92,NULL,'category/92','business-gifts/perfume-bottle.html','catalog/category/view/id/92',1,'',NULL),(1073,3,92,NULL,'category/92','business-gifts/perfume-bottle.html','catalog/category/view/id/92',1,'',NULL),(1074,2,92,NULL,'category/92','business-gifts/perfume-bottle.html','catalog/category/view/id/92',1,'',NULL),(1075,1,93,NULL,'category/93','business-gifts/rosewood-gift-set.html','catalog/category/view/id/93',1,'',NULL),(1076,3,93,NULL,'category/93','business-gifts/rosewood-gift-set.html','catalog/category/view/id/93',1,'',NULL),(1077,2,93,NULL,'category/93','business-gifts/rosewood-gift-set.html','catalog/category/view/id/93',1,'',NULL),(1078,1,94,NULL,'category/94','business-gifts/other-gift-sets.html','catalog/category/view/id/94',1,'',NULL),(1079,3,94,NULL,'category/94','business-gifts/other-gift-sets.html','catalog/category/view/id/94',1,'',NULL),(1080,2,94,NULL,'category/94','business-gifts/other-gift-sets.html','catalog/category/view/id/94',1,'',NULL),(1081,1,95,NULL,'category/95','business-gifts/boat.html','catalog/category/view/id/95',1,'',NULL),(1082,3,95,NULL,'category/95','business-gifts/boat.html','catalog/category/view/id/95',1,'',NULL),(1083,2,95,NULL,'category/95','business-gifts/boat.html','catalog/category/view/id/95',1,'',NULL),(1084,1,96,NULL,'category/96','accessories.html','catalog/category/view/id/96',1,'',NULL),(1085,3,96,NULL,'category/96','accessories.html','catalog/category/view/id/96',1,'',NULL),(1086,2,96,NULL,'category/96','accessories.html','catalog/category/view/id/96',1,'',NULL),(1087,1,97,NULL,'category/97','accessories/flagon.html','catalog/category/view/id/97',1,'',NULL),(1088,3,97,NULL,'category/97','accessories/flagon.html','catalog/category/view/id/97',1,'',NULL),(1089,2,97,NULL,'category/97','accessories/flagon.html','catalog/category/view/id/97',1,'',NULL),(1090,1,98,NULL,'category/98','accessories/personalized-badges.html','catalog/category/view/id/98',1,'',NULL),(1091,3,98,NULL,'category/98','accessories/personalized-badges.html','catalog/category/view/id/98',1,'',NULL),(1092,2,98,NULL,'category/98','accessories/personalized-badges.html','catalog/category/view/id/98',1,'',NULL),(1093,1,99,NULL,'category/99','accessories/cigarette-case.html','catalog/category/view/id/99',1,'',NULL),(1094,3,99,NULL,'category/99','accessories/cigarette-case.html','catalog/category/view/id/99',1,'',NULL),(1095,2,99,NULL,'category/99','accessories/cigarette-case.html','catalog/category/view/id/99',1,'',NULL),(1096,1,100,NULL,'category/100','accessories/comb.html','catalog/category/view/id/100',1,'',NULL),(1097,3,100,NULL,'category/100','accessories/comb.html','catalog/category/view/id/100',1,'',NULL),(1098,2,100,NULL,'category/100','accessories/comb.html','catalog/category/view/id/100',1,'',NULL),(1099,1,101,NULL,'category/101','accessories/card-package.html','catalog/category/view/id/101',1,'',NULL),(1100,3,101,NULL,'category/101','accessories/card-package.html','catalog/category/view/id/101',1,'',NULL),(1101,2,101,NULL,'category/101','accessories/card-package.html','catalog/category/view/id/101',1,'',NULL),(1102,1,102,NULL,'category/102','accessories/glasses.html','catalog/category/view/id/102',1,'',NULL),(1103,3,102,NULL,'category/102','accessories/glasses.html','catalog/category/view/id/102',1,'',NULL),(1104,2,102,NULL,'category/102','accessories/glasses.html','catalog/category/view/id/102',1,'',NULL),(1105,1,103,NULL,'category/103','accessories/key-cases.html','catalog/category/view/id/103',1,'',NULL),(1106,3,103,NULL,'category/103','accessories/key-cases.html','catalog/category/view/id/103',1,'',NULL),(1107,2,103,NULL,'category/103','accessories/key-cases.html','catalog/category/view/id/103',1,'',NULL),(1108,1,104,NULL,'category/104','accessories/zippo-lighter.html','catalog/category/view/id/104',1,'',NULL),(1109,3,104,NULL,'category/104','accessories/zippo-lighter.html','catalog/category/view/id/104',1,'',NULL),(1110,2,104,NULL,'category/104','accessories/zippo-lighter.html','catalog/category/view/id/104',1,'',NULL),(1111,1,105,NULL,'category/105','accessories/qinghua-lighter.html','catalog/category/view/id/105',1,'',NULL),(1112,3,105,NULL,'category/105','accessories/qinghua-lighter.html','catalog/category/view/id/105',1,'',NULL),(1113,2,105,NULL,'category/105','accessories/qinghua-lighter.html','catalog/category/view/id/105',1,'',NULL),(1114,1,106,NULL,'category/106','accessories/wallet.html','catalog/category/view/id/106',1,'',NULL),(1115,3,106,NULL,'category/106','accessories/wallet.html','catalog/category/view/id/106',1,'',NULL),(1116,2,106,NULL,'category/106','accessories/wallet.html','catalog/category/view/id/106',1,'',NULL),(1117,1,107,NULL,'category/107','accessories/vanity-mirron.html','catalog/category/view/id/107',1,'',NULL),(1118,3,107,NULL,'category/107','accessories/vanity-mirron.html','catalog/category/view/id/107',1,'',NULL),(1119,2,107,NULL,'category/107','accessories/vanity-mirron.html','catalog/category/view/id/107',1,'',NULL),(1120,1,108,NULL,'category/108','accessories/purse.html','catalog/category/view/id/108',1,'',NULL),(1121,3,108,NULL,'category/108','accessories/purse.html','catalog/category/view/id/108',1,'',NULL),(1122,2,108,NULL,'category/108','accessories/purse.html','catalog/category/view/id/108',1,'',NULL),(1123,1,109,NULL,'category/109','accessories/music-box.html','catalog/category/view/id/109',1,'',NULL),(1124,3,109,NULL,'category/109','accessories/music-box.html','catalog/category/view/id/109',1,'',NULL),(1125,2,109,NULL,'category/109','accessories/music-box.html','catalog/category/view/id/109',1,'',NULL),(1126,1,110,NULL,'category/110','photo-frame.html','catalog/category/view/id/110',1,'',NULL),(1127,3,110,NULL,'category/110','photo-frame.html','catalog/category/view/id/110',1,'',NULL),(1128,2,110,NULL,'category/110','photo-frame.html','catalog/category/view/id/110',1,'',NULL),(1129,1,111,NULL,'category/111','photo-frame/wooden-photo-frame.html','catalog/category/view/id/111',1,'',NULL),(1130,3,111,NULL,'category/111','photo-frame/wooden-photo-frame.html','catalog/category/view/id/111',1,'',NULL),(1131,2,111,NULL,'category/111','photo-frame/wooden-photo-frame.html','catalog/category/view/id/111',1,'',NULL),(1132,1,112,NULL,'category/112','photo-frame/metal-photo-frame.html','catalog/category/view/id/112',1,'',NULL),(1133,3,112,NULL,'category/112','photo-frame/metal-photo-frame.html','catalog/category/view/id/112',1,'',NULL),(1134,2,112,NULL,'category/112','photo-frame/metal-photo-frame.html','catalog/category/view/id/112',1,'',NULL),(1135,1,113,NULL,'category/113','photo-frame/crystal-photo-frame.html','catalog/category/view/id/113',1,'',NULL),(1136,3,113,NULL,'category/113','photo-frame/crystal-photo-frame.html','catalog/category/view/id/113',1,'',NULL),(1137,2,113,NULL,'category/113','photo-frame/crystal-photo-frame.html','catalog/category/view/id/113',1,'',NULL),(1138,1,113,NULL,'25965500_1339144705','photo-frame/ae-ae-c-ae.html','photo-frame/crystal-photo-frame.html',0,'RP',NULL),(1139,3,113,NULL,'27739700_1339144705','photo-frame/ae-ae-c-ae.html','photo-frame/crystal-photo-frame.html',0,'RP',NULL),(1140,2,113,NULL,'29204900_1339144705','photo-frame/ae-ae-c-ae.html','photo-frame/crystal-photo-frame.html',0,'RP',NULL),(1141,1,114,NULL,'category/114','photo-frame/cortex-photo-frame.html','catalog/category/view/id/114',1,'',NULL),(1142,3,114,NULL,'category/114','photo-frame/cortex-photo-frame.html','catalog/category/view/id/114',1,'',NULL),(1143,2,114,NULL,'category/114','photo-frame/cortex-photo-frame.html','catalog/category/view/id/114',1,'',NULL),(1144,1,115,NULL,'category/115','photo-frame/album.html','catalog/category/view/id/115',1,'',NULL),(1145,3,115,NULL,'category/115','photo-frame/album.html','catalog/category/view/id/115',1,'',NULL),(1146,2,115,NULL,'category/115','photo-frame/album.html','catalog/category/view/id/115',1,'',NULL),(1147,1,116,NULL,'category/116','photo-frame/acrylic-photo-frame.html','catalog/category/view/id/116',1,'',NULL),(1148,3,116,NULL,'category/116','photo-frame/acrylic-photo-frame.html','catalog/category/view/id/116',1,'',NULL),(1149,2,116,NULL,'category/116','photo-frame/acrylic-photo-frame.html','catalog/category/view/id/116',1,'',NULL),(1150,1,117,NULL,'category/117','home-decoration.html','catalog/category/view/id/117',1,'',NULL),(1151,3,117,NULL,'category/117','home-decoration.html','catalog/category/view/id/117',1,'',NULL),(1152,2,117,NULL,'category/117','home-decoration.html','catalog/category/view/id/117',1,'',NULL),(1153,1,118,NULL,'category/118','home-decoration/glass.html','catalog/category/view/id/118',1,'',NULL),(1154,3,118,NULL,'category/118','home-decoration/glass.html','catalog/category/view/id/118',1,'',NULL),(1155,2,118,NULL,'category/118','home-decoration/glass.html','catalog/category/view/id/118',1,'',NULL),(1156,1,119,NULL,'category/119','home-decoration/printing-pillow.html','catalog/category/view/id/119',1,'',NULL),(1157,3,119,NULL,'category/119','home-decoration/printing-pillow.html','catalog/category/view/id/119',1,'',NULL),(1158,2,119,NULL,'category/119','home-decoration/printing-pillow.html','catalog/category/view/id/119',1,'',NULL),(1159,1,120,NULL,'category/120','home-decoration/placemat.html','catalog/category/view/id/120',1,'',NULL),(1160,3,120,NULL,'category/120','home-decoration/placemat.html','catalog/category/view/id/120',1,'',NULL),(1161,2,120,NULL,'category/120','home-decoration/placemat.html','catalog/category/view/id/120',1,'',NULL),(1162,1,121,NULL,'category/121','home-decoration/cup-pad.html','catalog/category/view/id/121',1,'',NULL),(1163,3,121,NULL,'category/121','home-decoration/cup-pad.html','catalog/category/view/id/121',1,'',NULL),(1164,2,121,NULL,'category/121','home-decoration/cup-pad.html','catalog/category/view/id/121',1,'',NULL),(1165,1,122,NULL,'category/122','home-decoration/album.html','catalog/category/view/id/122',1,'',NULL),(1166,3,122,NULL,'category/122','home-decoration/album.html','catalog/category/view/id/122',1,'',NULL),(1167,2,122,NULL,'category/122','home-decoration/album.html','catalog/category/view/id/122',1,'',NULL),(1168,1,123,NULL,'category/123','home-decoration/shrouds.html','catalog/category/view/id/123',1,'',NULL),(1169,3,123,NULL,'category/123','home-decoration/shrouds.html','catalog/category/view/id/123',1,'',NULL),(1170,2,123,NULL,'category/123','home-decoration/shrouds.html','catalog/category/view/id/123',1,'',NULL),(1171,1,124,NULL,'category/124','home-decoration/plates.html','catalog/category/view/id/124',1,'',NULL),(1172,3,124,NULL,'category/124','home-decoration/plates.html','catalog/category/view/id/124',1,'',NULL),(1173,2,124,NULL,'category/124','home-decoration/plates.html','catalog/category/view/id/124',1,'',NULL),(1174,1,125,NULL,'category/125','home-decoration/ballon.html','catalog/category/view/id/125',1,'',NULL),(1175,3,125,NULL,'category/125','home-decoration/ballon.html','catalog/category/view/id/125',1,'',NULL),(1176,2,125,NULL,'category/125','home-decoration/ballon.html','catalog/category/view/id/125',1,'',NULL),(1177,1,126,NULL,'category/126','home-decoration/fridge-magnet.html','catalog/category/view/id/126',1,'',NULL),(1178,3,126,NULL,'category/126','home-decoration/fridge-magnet.html','catalog/category/view/id/126',1,'',NULL),(1179,2,126,NULL,'category/126','home-decoration/fridge-magnet.html','catalog/category/view/id/126',1,'',NULL),(1180,1,127,NULL,'category/127','home-decoration/candlestick.html','catalog/category/view/id/127',1,'',NULL),(1181,3,127,NULL,'category/127','home-decoration/candlestick.html','catalog/category/view/id/127',1,'',NULL),(1182,2,127,NULL,'category/127','home-decoration/candlestick.html','catalog/category/view/id/127',1,'',NULL),(1183,1,128,NULL,'category/128','home-decoration/ashtray.html','catalog/category/view/id/128',1,'',NULL),(1184,3,128,NULL,'category/128','home-decoration/ashtray.html','catalog/category/view/id/128',1,'',NULL),(1185,2,128,NULL,'category/128','home-decoration/ashtray.html','catalog/category/view/id/128',1,'',NULL),(1186,1,129,NULL,'category/129','home-decoration/pipe.html','catalog/category/view/id/129',1,'',NULL),(1187,3,129,NULL,'category/129','home-decoration/pipe.html','catalog/category/view/id/129',1,'',NULL),(1188,2,129,NULL,'category/129','home-decoration/pipe.html','catalog/category/view/id/129',1,'',NULL),(1189,1,130,NULL,'category/130','home-decoration/bowl.html','catalog/category/view/id/130',1,'',NULL),(1190,3,130,NULL,'category/130','home-decoration/bowl.html','catalog/category/view/id/130',1,'',NULL),(1191,2,130,NULL,'category/130','home-decoration/bowl.html','catalog/category/view/id/130',1,'',NULL),(1192,1,131,NULL,'category/131','home-decoration/chopsticks.html','catalog/category/view/id/131',1,'',NULL),(1193,3,131,NULL,'category/131','home-decoration/chopsticks.html','catalog/category/view/id/131',1,'',NULL),(1194,2,131,NULL,'category/131','home-decoration/chopsticks.html','catalog/category/view/id/131',1,'',NULL),(1195,1,132,NULL,'category/132','home-decoration/coffee-cup.html','catalog/category/view/id/132',1,'',NULL),(1196,3,132,NULL,'category/132','home-decoration/coffee-cup.html','catalog/category/view/id/132',1,'',NULL),(1197,2,132,NULL,'category/132','home-decoration/coffee-cup.html','catalog/category/view/id/132',1,'',NULL),(1198,1,133,NULL,'category/133','home-decoration/ceramic-cup.html','catalog/category/view/id/133',1,'',NULL),(1199,3,133,NULL,'category/133','home-decoration/ceramic-cup.html','catalog/category/view/id/133',1,'',NULL),(1200,2,133,NULL,'category/133','home-decoration/ceramic-cup.html','catalog/category/view/id/133',1,'',NULL),(1201,1,134,NULL,'category/134','home-decoration/customize-table-lamps.html','catalog/category/view/id/134',1,'',NULL),(1202,3,134,NULL,'category/134','home-decoration/customize-table-lamps.html','catalog/category/view/id/134',1,'',NULL),(1203,2,134,NULL,'category/134','home-decoration/customize-table-lamps.html','catalog/category/view/id/134',1,'',NULL),(1204,1,135,NULL,'category/135','home-decoration/piggy-bank.html','catalog/category/view/id/135',1,'',NULL),(1205,3,135,NULL,'category/135','home-decoration/piggy-bank.html','catalog/category/view/id/135',1,'',NULL),(1206,2,135,NULL,'category/135','home-decoration/piggy-bank.html','catalog/category/view/id/135',1,'',NULL),(1207,1,135,NULL,'37803600_1339148203','home-decoration/a-e-c.html','home-decoration/piggy-bank.html',0,'RP',NULL),(1208,3,135,NULL,'39604800_1339148203','home-decoration/a-e-c.html','home-decoration/piggy-bank.html',0,'RP',NULL),(1209,2,135,NULL,'41028800_1339148203','home-decoration/a-e-c.html','home-decoration/piggy-bank.html',0,'RP',NULL),(1210,1,136,NULL,'category/136','home-decoration/wall-stickers.html','catalog/category/view/id/136',1,'',NULL),(1211,3,136,NULL,'category/136','home-decoration/wall-stickers.html','catalog/category/view/id/136',1,'',NULL),(1212,2,136,NULL,'category/136','home-decoration/wall-stickers.html','catalog/category/view/id/136',1,'',NULL),(1213,1,137,NULL,'category/137','home-decoration/switch-sticker.html','catalog/category/view/id/137',1,'',NULL),(1214,3,137,NULL,'category/137','home-decoration/switch-sticker.html','catalog/category/view/id/137',1,'',NULL),(1215,2,137,NULL,'category/137','home-decoration/switch-sticker.html','catalog/category/view/id/137',1,'',NULL),(1216,1,137,NULL,'82108500_1339148603','home-decoration/a-a-e.html','home-decoration/switch-sticker.html',0,'RP',NULL),(1217,3,137,NULL,'84032900_1339148603','home-decoration/a-a-e.html','home-decoration/switch-sticker.html',0,'RP',NULL),(1218,2,137,NULL,'85502800_1339148603','home-decoration/a-a-e.html','home-decoration/switch-sticker.html',0,'RP',NULL),(1219,1,138,NULL,'category/138','home-decoration/water-shift-painting.html','catalog/category/view/id/138',1,'',NULL),(1220,3,138,NULL,'category/138','home-decoration/water-shift-painting.html','catalog/category/view/id/138',1,'',NULL),(1221,2,138,NULL,'category/138','home-decoration/water-shift-painting.html','catalog/category/view/id/138',1,'',NULL),(1222,1,138,NULL,'20845000_1339148653','home-decoration/ae-c-c.html','home-decoration/water-shift-painting.html',0,'RP',NULL),(1223,3,138,NULL,'22646600_1339148653','home-decoration/ae-c-c.html','home-decoration/water-shift-painting.html',0,'RP',NULL),(1224,2,138,NULL,'24080800_1339148653','home-decoration/ae-c-c.html','home-decoration/water-shift-painting.html',0,'RP',NULL),(1225,1,139,NULL,'category/139','home-decoration/glass-paste.html','catalog/category/view/id/139',1,'',NULL),(1226,3,139,NULL,'category/139','home-decoration/glass-paste.html','catalog/category/view/id/139',1,'',NULL),(1227,2,139,NULL,'category/139','home-decoration/glass-paste.html','catalog/category/view/id/139',1,'',NULL),(1228,1,140,NULL,'category/140','home-decoration/toilet-stickers.html','catalog/category/view/id/140',1,'',NULL),(1229,3,140,NULL,'category/140','home-decoration/toilet-stickers.html','catalog/category/view/id/140',1,'',NULL),(1230,2,140,NULL,'category/140','home-decoration/toilet-stickers.html','catalog/category/view/id/140',1,'',NULL),(1231,1,141,NULL,'category/141','home-decoration/computer-stickers.html','catalog/category/view/id/141',1,'',NULL),(1232,3,141,NULL,'category/141','home-decoration/computer-stickers.html','catalog/category/view/id/141',1,'',NULL),(1233,2,141,NULL,'category/141','home-decoration/computer-stickers.html','catalog/category/view/id/141',1,'',NULL),(1234,1,142,NULL,'category/142','home-decoration/conch.html','catalog/category/view/id/142',1,'',NULL),(1235,3,142,NULL,'category/142','home-decoration/conch.html','catalog/category/view/id/142',1,'',NULL),(1236,2,142,NULL,'category/142','home-decoration/conch.html','catalog/category/view/id/142',1,'',NULL),(1237,1,143,NULL,'category/143','home-decoration/lucky-cat.html','catalog/category/view/id/143',1,'',NULL),(1238,3,143,NULL,'category/143','home-decoration/lucky-cat.html','catalog/category/view/id/143',1,'',NULL),(1239,2,143,NULL,'category/143','home-decoration/lucky-cat.html','catalog/category/view/id/143',1,'',NULL),(1240,1,144,NULL,'category/144','home-decoration/campanula.html','catalog/category/view/id/144',1,'',NULL),(1241,3,144,NULL,'category/144','home-decoration/campanula.html','catalog/category/view/id/144',1,'',NULL),(1242,2,144,NULL,'category/144','home-decoration/campanula.html','catalog/category/view/id/144',1,'',NULL),(1243,1,145,NULL,'category/145','home-decoration/hairs-toy.html','catalog/category/view/id/145',1,'',NULL),(1244,3,145,NULL,'category/145','home-decoration/hairs-toy.html','catalog/category/view/id/145',1,'',NULL),(1245,2,145,NULL,'category/145','home-decoration/hairs-toy.html','catalog/category/view/id/145',1,'',NULL),(1246,1,146,NULL,'category/146','home-decoration/photo-wall.html','catalog/category/view/id/146',1,'',NULL),(1247,3,146,NULL,'category/146','home-decoration/photo-wall.html','catalog/category/view/id/146',1,'',NULL),(1248,2,146,NULL,'category/146','home-decoration/photo-wall.html','catalog/category/view/id/146',1,'',NULL),(1249,1,147,NULL,'category/147','sports-and-travel.html','catalog/category/view/id/147',1,'',NULL),(1250,3,147,NULL,'category/147','sports-and-travel.html','catalog/category/view/id/147',1,'',NULL),(1251,2,147,NULL,'category/147','sports-and-travel.html','catalog/category/view/id/147',1,'',NULL),(1252,1,148,NULL,'category/148','sports-and-travel/kettle.html','catalog/category/view/id/148',1,'',NULL),(1253,3,148,NULL,'category/148','sports-and-travel/kettle.html','catalog/category/view/id/148',1,'',NULL),(1254,2,148,NULL,'category/148','sports-and-travel/kettle.html','catalog/category/view/id/148',1,'',NULL),(1255,1,149,NULL,'category/149','sports-and-travel/hangtag.html','catalog/category/view/id/149',1,'',NULL),(1256,3,149,NULL,'category/149','sports-and-travel/hangtag.html','catalog/category/view/id/149',1,'',NULL),(1257,2,149,NULL,'category/149','sports-and-travel/hangtag.html','catalog/category/view/id/149',1,'',NULL),(1258,1,150,NULL,'category/150','sports-and-travel/luggage-tag.html','catalog/category/view/id/150',1,'',NULL),(1259,3,150,NULL,'category/150','sports-and-travel/luggage-tag.html','catalog/category/view/id/150',1,'',NULL),(1260,2,150,NULL,'category/150','sports-and-travel/luggage-tag.html','catalog/category/view/id/150',1,'',NULL),(1261,1,151,NULL,'category/151','sports-and-travel/folding-knife.html','catalog/category/view/id/151',1,'',NULL),(1262,3,151,NULL,'category/151','sports-and-travel/folding-knife.html','catalog/category/view/id/151',1,'',NULL),(1263,2,151,NULL,'category/151','sports-and-travel/folding-knife.html','catalog/category/view/id/151',1,'',NULL),(1264,1,152,NULL,'category/152','sports-and-travel/e-as-ae-a.html','catalog/category/view/id/152',1,'',NULL),(1265,3,152,NULL,'category/152','sports-and-travel/e-as-ae-a.html','catalog/category/view/id/152',1,'',NULL),(1266,2,152,NULL,'category/152','sports-and-travel/e-as-ae-a.html','catalog/category/view/id/152',1,'',NULL),(1267,1,153,NULL,'category/153','printed-materials-series.html','catalog/category/view/id/153',1,'',NULL),(1268,3,153,NULL,'category/153','printed-materials-series.html','catalog/category/view/id/153',1,'',NULL),(1269,2,153,NULL,'category/153','printed-materials-series.html','catalog/category/view/id/153',1,'',NULL),(1270,1,154,NULL,'category/154','printed-materials-series/jigsaw.html','catalog/category/view/id/154',1,'',NULL),(1271,3,154,NULL,'category/154','printed-materials-series/jigsaw.html','catalog/category/view/id/154',1,'',NULL),(1272,2,154,NULL,'category/154','printed-materials-series/jigsaw.html','catalog/category/view/id/154',1,'',NULL),(1273,1,155,NULL,'category/155','printed-materials-series/greetings-card.html','catalog/category/view/id/155',1,'',NULL),(1274,3,155,NULL,'category/155','printed-materials-series/greetings-card.html','catalog/category/view/id/155',1,'',NULL),(1275,2,155,NULL,'category/155','printed-materials-series/greetings-card.html','catalog/category/view/id/155',1,'',NULL),(1276,1,156,NULL,'category/156','printed-materials-series/invitation-card.html','catalog/category/view/id/156',1,'',NULL),(1277,3,156,NULL,'category/156','printed-materials-series/invitation-card.html','catalog/category/view/id/156',1,'',NULL),(1278,2,156,NULL,'category/156','printed-materials-series/invitation-card.html','catalog/category/view/id/156',1,'',NULL),(1279,1,157,NULL,'category/157','printed-materials-series/poster.html','catalog/category/view/id/157',1,'',NULL),(1280,3,157,NULL,'category/157','printed-materials-series/poster.html','catalog/category/view/id/157',1,'',NULL),(1281,2,157,NULL,'category/157','printed-materials-series/poster.html','catalog/category/view/id/157',1,'',NULL),(1282,1,158,NULL,'category/158','printed-materials-series/album.html','catalog/category/view/id/158',1,'',NULL),(1283,3,158,NULL,'category/158','printed-materials-series/album.html','catalog/category/view/id/158',1,'',NULL),(1284,2,158,NULL,'category/158','printed-materials-series/album.html','catalog/category/view/id/158',1,'',NULL),(1285,1,159,NULL,'category/159','printed-materials-series/calendar.html','catalog/category/view/id/159',1,'',NULL),(1286,3,159,NULL,'category/159','printed-materials-series/calendar.html','catalog/category/view/id/159',1,'',NULL),(1287,2,159,NULL,'category/159','printed-materials-series/calendar.html','catalog/category/view/id/159',1,'',NULL),(1288,1,160,NULL,'category/160','printed-materials-series/carte.html','catalog/category/view/id/160',1,'',NULL),(1289,3,160,NULL,'category/160','printed-materials-series/carte.html','catalog/category/view/id/160',1,'',NULL),(1290,2,160,NULL,'category/160','printed-materials-series/carte.html','catalog/category/view/id/160',1,'',NULL),(1291,1,161,NULL,'category/161','printed-materials-series/birthday-newspaper.html','catalog/category/view/id/161',1,'',NULL),(1292,3,161,NULL,'category/161','printed-materials-series/birthday-newspaper.html','catalog/category/view/id/161',1,'',NULL),(1293,2,161,NULL,'category/161','printed-materials-series/birthday-newspaper.html','catalog/category/view/id/161',1,'',NULL),(1294,1,162,NULL,'category/162','printed-materials-series/poker.html','catalog/category/view/id/162',1,'',NULL),(1295,3,162,NULL,'category/162','printed-materials-series/poker.html','catalog/category/view/id/162',1,'',NULL),(1296,2,162,NULL,'category/162','printed-materials-series/poker.html','catalog/category/view/id/162',1,'',NULL),(1297,1,163,NULL,'category/163','printed-materials-series/inscribed-bamgoo-slips.html','catalog/category/view/id/163',1,'',NULL),(1298,3,163,NULL,'category/163','printed-materials-series/inscribed-bamgoo-slips.html','catalog/category/view/id/163',1,'',NULL),(1299,2,163,NULL,'category/163','printed-materials-series/inscribed-bamgoo-slips.html','catalog/category/view/id/163',1,'',NULL),(1300,1,164,NULL,'category/164','printed-materials-series/personalized-certificate.html','catalog/category/view/id/164',1,'',NULL),(1301,3,164,NULL,'category/164','printed-materials-series/personalized-certificate.html','catalog/category/view/id/164',1,'',NULL),(1302,2,164,NULL,'category/164','printed-materials-series/personalized-certificate.html','catalog/category/view/id/164',1,'',NULL),(1303,1,165,NULL,'category/165','printed-materials-series/card-sticker.html','catalog/category/view/id/165',1,'',NULL),(1304,3,165,NULL,'category/165','printed-materials-series/card-sticker.html','catalog/category/view/id/165',1,'',NULL),(1305,2,165,NULL,'category/165','printed-materials-series/card-sticker.html','catalog/category/view/id/165',1,'',NULL),(1306,1,166,NULL,'category/166','printed-materials-series/lomo-photo.html','catalog/category/view/id/166',1,'',NULL),(1307,3,166,NULL,'category/166','printed-materials-series/lomo-photo.html','catalog/category/view/id/166',1,'',NULL),(1308,2,166,NULL,'category/166','printed-materials-series/lomo-photo.html','catalog/category/view/id/166',1,'',NULL),(1309,1,167,NULL,'category/167','printed-materials-series/hand-inkpad.html','catalog/category/view/id/167',1,'',NULL),(1310,3,167,NULL,'category/167','printed-materials-series/hand-inkpad.html','catalog/category/view/id/167',1,'',NULL),(1311,2,167,NULL,'category/167','printed-materials-series/hand-inkpad.html','catalog/category/view/id/167',1,'',NULL),(1312,1,168,NULL,'category/168','printed-materials-series/red-packets.html','catalog/category/view/id/168',1,'',NULL),(1313,3,168,NULL,'category/168','printed-materials-series/red-packets.html','catalog/category/view/id/168',1,'',NULL),(1314,2,168,NULL,'category/168','printed-materials-series/red-packets.html','catalog/category/view/id/168',1,'',NULL),(1315,1,169,NULL,'category/169','printed-materials-series/candy-bags.html','catalog/category/view/id/169',1,'',NULL),(1316,3,169,NULL,'category/169','printed-materials-series/candy-bags.html','catalog/category/view/id/169',1,'',NULL),(1317,2,169,NULL,'category/169','printed-materials-series/candy-bags.html','catalog/category/view/id/169',1,'',NULL),(1318,1,170,NULL,'category/170','printed-materials-series/wedding-table-card.html','catalog/category/view/id/170',1,'',NULL),(1319,3,170,NULL,'category/170','printed-materials-series/wedding-table-card.html','catalog/category/view/id/170',1,'',NULL),(1320,2,170,NULL,'category/170','printed-materials-series/wedding-table-card.html','catalog/category/view/id/170',1,'',NULL),(1321,1,171,NULL,'category/171','printed-materials-series/magazine.html','catalog/category/view/id/171',1,'',NULL),(1322,3,171,NULL,'category/171','printed-materials-series/magazine.html','catalog/category/view/id/171',1,'',NULL),(1323,2,171,NULL,'category/171','printed-materials-series/magazine.html','catalog/category/view/id/171',1,'',NULL),(1324,1,172,NULL,'category/172','personalized-stamp.html','catalog/category/view/id/172',1,'',NULL),(1325,3,172,NULL,'category/172','personalized-stamp.html','catalog/category/view/id/172',1,'',NULL),(1326,2,172,NULL,'category/172','personalized-stamp.html','catalog/category/view/id/172',1,'',NULL),(1327,1,173,NULL,'category/173','apparel.html','catalog/category/view/id/173',1,'',NULL),(1328,3,173,NULL,'category/173','apparel.html','catalog/category/view/id/173',1,'',NULL),(1329,2,173,NULL,'category/173','apparel.html','catalog/category/view/id/173',1,'',NULL),(1330,1,174,NULL,'category/174','apparel/t-shirt.html','catalog/category/view/id/174',1,'',NULL),(1331,3,174,NULL,'category/174','apparel/t-shirt.html','catalog/category/view/id/174',1,'',NULL),(1332,2,174,NULL,'category/174','apparel/t-shirt.html','catalog/category/view/id/174',1,'',NULL),(1333,1,175,NULL,'category/175','apparel/hat.html','catalog/category/view/id/175',1,'',NULL),(1334,3,175,NULL,'category/175','apparel/hat.html','catalog/category/view/id/175',1,'',NULL),(1335,2,175,NULL,'category/175','apparel/hat.html','catalog/category/view/id/175',1,'',NULL),(1336,1,176,NULL,'category/176','apparel/trousers.html','catalog/category/view/id/176',1,'',NULL),(1337,3,176,NULL,'category/176','apparel/trousers.html','catalog/category/view/id/176',1,'',NULL),(1338,2,176,NULL,'category/176','apparel/trousers.html','catalog/category/view/id/176',1,'',NULL),(1339,1,177,NULL,'category/177','apparel/scarves.html','catalog/category/view/id/177',1,'',NULL),(1340,3,177,NULL,'category/177','apparel/scarves.html','catalog/category/view/id/177',1,'',NULL),(1341,2,177,NULL,'category/177','apparel/scarves.html','catalog/category/view/id/177',1,'',NULL),(1342,1,178,NULL,'category/178','art-series.html','catalog/category/view/id/178',1,'',NULL),(1343,3,178,NULL,'category/178','art-series.html','catalog/category/view/id/178',1,'',NULL),(1344,2,178,NULL,'category/178','art-series.html','catalog/category/view/id/178',1,'',NULL),(1345,1,179,NULL,'category/179','art-series/landscape-oil-painting.html','catalog/category/view/id/179',1,'',NULL),(1346,3,179,NULL,'category/179','art-series/landscape-oil-painting.html','catalog/category/view/id/179',1,'',NULL),(1347,2,179,NULL,'category/179','art-series/landscape-oil-painting.html','catalog/category/view/id/179',1,'',NULL),(1348,1,180,NULL,'category/180','art-series/figure-painting.html','catalog/category/view/id/180',1,'',NULL),(1349,3,180,NULL,'category/180','art-series/figure-painting.html','catalog/category/view/id/180',1,'',NULL),(1350,2,180,NULL,'category/180','art-series/figure-painting.html','catalog/category/view/id/180',1,'',NULL),(1351,1,181,NULL,'category/181','art-series/stone-painting.html','catalog/category/view/id/181',1,'',NULL),(1352,3,181,NULL,'category/181','art-series/stone-painting.html','catalog/category/view/id/181',1,'',NULL),(1353,2,181,NULL,'category/181','art-series/stone-painting.html','catalog/category/view/id/181',1,'',NULL),(1354,1,182,NULL,'category/182','art-series/porcelain-painting.html','catalog/category/view/id/182',1,'',NULL),(1355,3,182,NULL,'category/182','art-series/porcelain-painting.html','catalog/category/view/id/182',1,'',NULL),(1356,2,182,NULL,'category/182','art-series/porcelain-painting.html','catalog/category/view/id/182',1,'',NULL),(1357,1,183,NULL,'category/183','art-series/woodcut.html','catalog/category/view/id/183',1,'',NULL),(1358,3,183,NULL,'category/183','art-series/woodcut.html','catalog/category/view/id/183',1,'',NULL),(1359,2,183,NULL,'category/183','art-series/woodcut.html','catalog/category/view/id/183',1,'',NULL),(1360,1,184,NULL,'category/184','art-series/crystal-engraving.html','catalog/category/view/id/184',1,'',NULL),(1361,3,184,NULL,'category/184','art-series/crystal-engraving.html','catalog/category/view/id/184',1,'',NULL),(1362,2,184,NULL,'category/184','art-series/crystal-engraving.html','catalog/category/view/id/184',1,'',NULL),(1363,1,185,NULL,'category/185','art-series/ice-art.html','catalog/category/view/id/185',1,'',NULL),(1364,3,185,NULL,'category/185','art-series/ice-art.html','catalog/category/view/id/185',1,'',NULL),(1365,2,185,NULL,'category/185','art-series/ice-art.html','catalog/category/view/id/185',1,'',NULL),(1366,1,186,NULL,'category/186','art-series/fimo.html','catalog/category/view/id/186',1,'',NULL),(1367,3,186,NULL,'category/186','art-series/fimo.html','catalog/category/view/id/186',1,'',NULL),(1368,2,186,NULL,'category/186','art-series/fimo.html','catalog/category/view/id/186',1,'',NULL),(1828,4,110,NULL,'category/110','photo-frame.html','catalog/category/view/id/110',1,'',NULL),(1829,4,111,NULL,'category/111','photo-frame/wooden-photo-frame.html','catalog/category/view/id/111',1,'',NULL),(1830,4,112,NULL,'category/112','photo-frame/metal-photo-frame.html','catalog/category/view/id/112',1,'',NULL),(1831,4,113,NULL,'category/113','photo-frame/crystal-photo-frame.html','catalog/category/view/id/113',1,'',NULL),(1832,4,114,NULL,'category/114','photo-frame/cortex-photo-frame.html','catalog/category/view/id/114',1,'',NULL),(1833,4,115,NULL,'category/115','photo-frame/album.html','catalog/category/view/id/115',1,'',NULL),(1834,4,116,NULL,'category/116','photo-frame/acrylic-photo-frame.html','catalog/category/view/id/116',1,'',NULL),(1835,4,117,NULL,'category/117','home-decoration.html','catalog/category/view/id/117',1,'',NULL),(1836,4,118,NULL,'category/118','home-decoration/glass.html','catalog/category/view/id/118',1,'',NULL),(1837,4,119,NULL,'category/119','home-decoration/printing-pillow.html','catalog/category/view/id/119',1,'',NULL),(1838,4,120,NULL,'category/120','home-decoration/placemat.html','catalog/category/view/id/120',1,'',NULL),(1839,4,121,NULL,'category/121','home-decoration/cup-pad.html','catalog/category/view/id/121',1,'',NULL),(1840,4,122,NULL,'category/122','home-decoration/album.html','catalog/category/view/id/122',1,'',NULL),(1841,4,123,NULL,'category/123','home-decoration/shrouds.html','catalog/category/view/id/123',1,'',NULL),(1842,4,124,NULL,'category/124','home-decoration/plates.html','catalog/category/view/id/124',1,'',NULL),(1843,4,125,NULL,'category/125','home-decoration/ballon.html','catalog/category/view/id/125',1,'',NULL),(1844,4,126,NULL,'category/126','home-decoration/fridge-magnet.html','catalog/category/view/id/126',1,'',NULL),(1845,4,127,NULL,'category/127','home-decoration/candlestick.html','catalog/category/view/id/127',1,'',NULL),(1846,4,128,NULL,'category/128','home-decoration/ashtray.html','catalog/category/view/id/128',1,'',NULL),(1847,4,129,NULL,'category/129','home-decoration/pipe.html','catalog/category/view/id/129',1,'',NULL),(1848,4,130,NULL,'category/130','home-decoration/bowl.html','catalog/category/view/id/130',1,'',NULL),(1849,4,131,NULL,'category/131','home-decoration/chopsticks.html','catalog/category/view/id/131',1,'',NULL),(1850,4,132,NULL,'category/132','home-decoration/coffee-cup.html','catalog/category/view/id/132',1,'',NULL),(1851,4,133,NULL,'category/133','home-decoration/ceramic-cup.html','catalog/category/view/id/133',1,'',NULL),(1852,4,134,NULL,'category/134','home-decoration/customize-table-lamps.html','catalog/category/view/id/134',1,'',NULL),(1853,4,135,NULL,'category/135','home-decoration/piggy-bank.html','catalog/category/view/id/135',1,'',NULL),(1854,4,136,NULL,'category/136','home-decoration/wall-stickers.html','catalog/category/view/id/136',1,'',NULL),(1855,4,137,NULL,'category/137','home-decoration/switch-sticker.html','catalog/category/view/id/137',1,'',NULL),(1856,4,138,NULL,'category/138','home-decoration/water-shift-painting.html','catalog/category/view/id/138',1,'',NULL),(1857,4,139,NULL,'category/139','home-decoration/glass-paste.html','catalog/category/view/id/139',1,'',NULL),(1858,4,140,NULL,'category/140','home-decoration/toilet-stickers.html','catalog/category/view/id/140',1,'',NULL),(1859,4,141,NULL,'category/141','home-decoration/computer-stickers.html','catalog/category/view/id/141',1,'',NULL),(1860,4,142,NULL,'category/142','home-decoration/conch.html','catalog/category/view/id/142',1,'',NULL),(1861,4,143,NULL,'category/143','home-decoration/lucky-cat.html','catalog/category/view/id/143',1,'',NULL),(1862,4,144,NULL,'category/144','home-decoration/campanula.html','catalog/category/view/id/144',1,'',NULL),(1863,4,145,NULL,'category/145','home-decoration/hairs-toy.html','catalog/category/view/id/145',1,'',NULL),(1864,4,146,NULL,'category/146','home-decoration/photo-wall.html','catalog/category/view/id/146',1,'',NULL),(1865,4,147,NULL,'category/147','sports-and-travel.html','catalog/category/view/id/147',1,'',NULL),(1866,4,148,NULL,'category/148','sports-and-travel/kettle.html','catalog/category/view/id/148',1,'',NULL),(1867,4,149,NULL,'category/149','sports-and-travel/hangtag.html','catalog/category/view/id/149',1,'',NULL),(1868,4,150,NULL,'category/150','sports-and-travel/luggage-tag.html','catalog/category/view/id/150',1,'',NULL),(1869,4,151,NULL,'category/151','sports-and-travel/folding-knife.html','catalog/category/view/id/151',1,'',NULL),(1870,4,152,NULL,'category/152','sports-and-travel/e-as-ae-a.html','catalog/category/view/id/152',1,'',NULL),(1871,4,153,NULL,'category/153','printed-materials-series.html','catalog/category/view/id/153',1,'',NULL),(1872,4,154,NULL,'category/154','printed-materials-series/jigsaw.html','catalog/category/view/id/154',1,'',NULL),(1873,4,155,NULL,'category/155','printed-materials-series/greetings-card.html','catalog/category/view/id/155',1,'',NULL),(1874,4,156,NULL,'category/156','printed-materials-series/invitation-card.html','catalog/category/view/id/156',1,'',NULL),(1875,4,157,NULL,'category/157','printed-materials-series/poster.html','catalog/category/view/id/157',1,'',NULL),(1876,4,158,NULL,'category/158','printed-materials-series/album.html','catalog/category/view/id/158',1,'',NULL),(1877,4,159,NULL,'category/159','printed-materials-series/calendar.html','catalog/category/view/id/159',1,'',NULL),(1878,4,160,NULL,'category/160','printed-materials-series/carte.html','catalog/category/view/id/160',1,'',NULL),(1879,4,161,NULL,'category/161','printed-materials-series/birthday-newspaper.html','catalog/category/view/id/161',1,'',NULL),(1880,4,162,NULL,'category/162','printed-materials-series/poker.html','catalog/category/view/id/162',1,'',NULL),(1881,4,163,NULL,'category/163','printed-materials-series/inscribed-bamgoo-slips.html','catalog/category/view/id/163',1,'',NULL),(1882,4,164,NULL,'category/164','printed-materials-series/personalized-certificate.html','catalog/category/view/id/164',1,'',NULL),(1883,4,165,NULL,'category/165','printed-materials-series/card-sticker.html','catalog/category/view/id/165',1,'',NULL),(1884,4,166,NULL,'category/166','printed-materials-series/lomo-photo.html','catalog/category/view/id/166',1,'',NULL),(1885,4,167,NULL,'category/167','printed-materials-series/hand-inkpad.html','catalog/category/view/id/167',1,'',NULL),(1886,4,168,NULL,'category/168','printed-materials-series/red-packets.html','catalog/category/view/id/168',1,'',NULL),(1887,4,169,NULL,'category/169','printed-materials-series/candy-bags.html','catalog/category/view/id/169',1,'',NULL),(1888,4,170,NULL,'category/170','printed-materials-series/wedding-table-card.html','catalog/category/view/id/170',1,'',NULL),(1889,4,171,NULL,'category/171','printed-materials-series/magazine.html','catalog/category/view/id/171',1,'',NULL),(1890,4,172,NULL,'category/172','personalized-stamp.html','catalog/category/view/id/172',1,'',NULL),(1891,4,173,NULL,'category/173','apparel.html','catalog/category/view/id/173',1,'',NULL),(1892,4,174,NULL,'category/174','apparel/t-shirt.html','catalog/category/view/id/174',1,'',NULL),(1893,4,175,NULL,'category/175','apparel/hat.html','catalog/category/view/id/175',1,'',NULL),(1894,4,176,NULL,'category/176','apparel/trousers.html','catalog/category/view/id/176',1,'',NULL),(1895,4,177,NULL,'category/177','apparel/scarves.html','catalog/category/view/id/177',1,'',NULL),(1896,4,178,NULL,'category/178','art-series.html','catalog/category/view/id/178',1,'',NULL),(1897,4,179,NULL,'category/179','art-series/landscape-oil-painting.html','catalog/category/view/id/179',1,'',NULL),(1898,4,180,NULL,'category/180','art-series/figure-painting.html','catalog/category/view/id/180',1,'',NULL),(1899,4,181,NULL,'category/181','art-series/stone-painting.html','catalog/category/view/id/181',1,'',NULL),(1900,4,182,NULL,'category/182','art-series/porcelain-painting.html','catalog/category/view/id/182',1,'',NULL),(1901,4,183,NULL,'category/183','art-series/woodcut.html','catalog/category/view/id/183',1,'',NULL),(1902,4,184,NULL,'category/184','art-series/crystal-engraving.html','catalog/category/view/id/184',1,'',NULL),(1903,4,185,NULL,'category/185','art-series/ice-art.html','catalog/category/view/id/185',1,'',NULL),(1904,4,186,NULL,'category/186','art-series/fimo.html','catalog/category/view/id/186',1,'',NULL),(1905,4,20,NULL,'category/20','household-items.html','catalog/category/view/id/20',1,'',NULL),(1906,4,35,NULL,'category/35','featured-products.html','catalog/category/view/id/35',1,'',NULL),(1907,4,36,NULL,'category/36','occasion.html','catalog/category/view/id/36',1,'',NULL),(1908,4,37,NULL,'category/37','recipients.html','catalog/category/view/id/37',1,'',NULL),(1909,4,38,NULL,'category/38','gifts.html','catalog/category/view/id/38',1,'',NULL),(1910,4,39,NULL,'category/39','diy.html','catalog/category/view/id/39',1,'',NULL),(1911,4,40,NULL,'category/40','watch.html','catalog/category/view/id/40',1,'',NULL),(1912,4,41,NULL,'category/41','watch/disney-watches.html','catalog/category/view/id/41',1,'',NULL),(1913,4,42,NULL,'category/42','watch/alarm-clock.html','catalog/category/view/id/42',1,'',NULL),(1914,4,43,NULL,'category/43','watch/timepiece.html','catalog/category/view/id/43',1,'',NULL),(1915,4,44,NULL,'category/44','watch/personalized-custom-watches.html','catalog/category/view/id/44',1,'',NULL),(1916,4,45,NULL,'category/45','jewelry.html','catalog/category/view/id/45',1,'',NULL),(1917,4,46,NULL,'category/46','jewelry/necklace.html','catalog/category/view/id/46',1,'',NULL),(1918,4,47,NULL,'category/47','jewelry/bracelet.html','catalog/category/view/id/47',1,'',NULL),(1919,4,48,NULL,'category/48','jewelry/earring.html','catalog/category/view/id/48',1,'',NULL),(1920,4,49,NULL,'category/49','jewelry/ring.html','catalog/category/view/id/49',1,'',NULL),(1921,4,50,NULL,'category/50','usb-card.html','catalog/category/view/id/50',1,'',NULL),(1922,4,51,NULL,'category/51','usb-card/u-disk-card.html','catalog/category/view/id/51',1,'',NULL),(1923,4,52,NULL,'category/52','usb-card/wodden-usb-disk.html','catalog/category/view/id/52',1,'',NULL),(1924,4,53,NULL,'category/53','usb-card/leather-usb-disk.html','catalog/category/view/id/53',1,'',NULL),(1925,4,54,NULL,'category/54','usb-card/metal-usb-disk.html','catalog/category/view/id/54',1,'',NULL),(1926,4,55,NULL,'category/55','usb-card/white-porcelain-usb-disk.html','catalog/category/view/id/55',1,'',NULL),(1927,4,56,NULL,'category/56','digital-accessories.html','catalog/category/view/id/56',1,'',NULL),(1928,4,57,NULL,'category/57','digital-accessories/fudiao-phone-case.html','catalog/category/view/id/57',1,'',NULL),(1929,4,58,NULL,'category/58','digital-accessories/kezi-phone-case.html','catalog/category/view/id/58',1,'',NULL),(1930,4,59,NULL,'category/59','digital-accessories/caihui-phone-case.html','catalog/category/view/id/59',1,'',NULL),(1931,4,60,NULL,'category/60','digital-accessories/mouse.html','catalog/category/view/id/60',1,'',NULL),(1932,4,61,NULL,'category/61','digital-accessories/computer-sleeve.html','catalog/category/view/id/61',1,'',NULL),(1933,4,62,NULL,'category/62','digital-accessories/mp3.html','catalog/category/view/id/62',1,'',NULL),(1934,4,63,NULL,'category/63','digital-accessories/cd-bag.html','catalog/category/view/id/63',1,'',NULL),(1935,4,64,NULL,'category/64','digital-accessories/cd.html','catalog/category/view/id/64',1,'',NULL),(1936,4,65,NULL,'category/65','digital-accessories/tablet-pc.html','catalog/category/view/id/65',1,'',NULL),(1937,4,66,NULL,'category/66','digital-accessories/customize-iphone4-case.html','catalog/category/view/id/66',1,'',NULL),(1938,4,67,NULL,'category/67','cups.html','catalog/category/view/id/67',1,'',NULL),(1939,4,68,NULL,'category/68','cups/mug.html','catalog/category/view/id/68',1,'',NULL),(1940,4,69,NULL,'category/69','cups/bone-cup.html','catalog/category/view/id/69',1,'',NULL),(1941,4,70,NULL,'category/70','cups/coffee-cup.html','catalog/category/view/id/70',1,'',NULL),(1942,4,71,NULL,'category/71','cups/color-cup.html','catalog/category/view/id/71',1,'',NULL),(1943,4,72,NULL,'category/72','crystal.html','catalog/category/view/id/72',1,'',NULL),(1944,4,73,NULL,'category/73','crystal/caiyi-crystal.html','catalog/category/view/id/73',1,'',NULL),(1945,4,74,NULL,'category/74','crystal/diaoke-crystal.html','catalog/category/view/id/74',1,'',NULL),(1946,4,75,NULL,'category/75','crystal/crystal-card-holder.html','catalog/category/view/id/75',1,'',NULL),(1947,4,76,NULL,'category/76','crystal/laser-crystal.html','catalog/category/view/id/76',1,'',NULL),(1948,4,77,NULL,'category/77','crystal/crystal-trophy.html','catalog/category/view/id/77',1,'',NULL),(1949,4,78,NULL,'category/78','office-supplies.html','catalog/category/view/id/78',1,'',NULL),(1950,4,79,NULL,'category/79','office-supplies/roller-pen.html','catalog/category/view/id/79',1,'',NULL),(1951,4,80,NULL,'category/80','office-supplies/cardcase.html','catalog/category/view/id/80',1,'',NULL),(1952,4,81,NULL,'category/81','office-supplies/notepad.html','catalog/category/view/id/81',1,'',NULL),(1953,4,82,NULL,'category/82','office-supplies/bookmark.html','catalog/category/view/id/82',1,'',NULL),(1954,4,83,NULL,'category/83','office-supplies/mouse-mat.html','catalog/category/view/id/83',1,'',NULL),(1955,4,84,NULL,'category/84','office-supplies/magnifier.html','catalog/category/view/id/84',1,'',NULL),(1956,4,85,NULL,'category/85','office-supplies/business-card.html','catalog/category/view/id/85',1,'',NULL),(1957,4,86,NULL,'category/86','office-supplies/writing-case.html','catalog/category/view/id/86',1,'',NULL),(1958,4,87,NULL,'category/87','office-supplies/ruler.html','catalog/category/view/id/87',1,'',NULL),(1959,4,88,NULL,'category/88','office-supplies/brush-pot.html','catalog/category/view/id/88',1,'',NULL),(1960,4,89,NULL,'category/89','office-supplies/pen.html','catalog/category/view/id/89',1,'',NULL),(1961,4,90,NULL,'category/90','business-gifts.html','catalog/category/view/id/90',1,'',NULL),(1962,4,91,NULL,'category/91','business-gifts/medal.html','catalog/category/view/id/91',1,'',NULL),(1963,4,92,NULL,'category/92','business-gifts/perfume-bottle.html','catalog/category/view/id/92',1,'',NULL),(1964,4,93,NULL,'category/93','business-gifts/rosewood-gift-set.html','catalog/category/view/id/93',1,'',NULL),(1965,4,94,NULL,'category/94','business-gifts/other-gift-sets.html','catalog/category/view/id/94',1,'',NULL),(1966,4,95,NULL,'category/95','business-gifts/boat.html','catalog/category/view/id/95',1,'',NULL),(1967,4,96,NULL,'category/96','accessories.html','catalog/category/view/id/96',1,'',NULL),(1968,4,100,NULL,'category/100','accessories/comb.html','catalog/category/view/id/100',1,'',NULL),(1969,4,101,NULL,'category/101','accessories/card-package.html','catalog/category/view/id/101',1,'',NULL),(1970,4,102,NULL,'category/102','accessories/glasses.html','catalog/category/view/id/102',1,'',NULL),(1971,4,103,NULL,'category/103','accessories/key-cases.html','catalog/category/view/id/103',1,'',NULL),(1972,4,104,NULL,'category/104','accessories/zippo-lighter.html','catalog/category/view/id/104',1,'',NULL),(1973,4,105,NULL,'category/105','accessories/qinghua-lighter.html','catalog/category/view/id/105',1,'',NULL),(1974,4,106,NULL,'category/106','accessories/wallet.html','catalog/category/view/id/106',1,'',NULL),(1975,4,107,NULL,'category/107','accessories/vanity-mirron.html','catalog/category/view/id/107',1,'',NULL),(1976,4,108,NULL,'category/108','accessories/purse.html','catalog/category/view/id/108',1,'',NULL),(1977,4,109,NULL,'category/109','accessories/music-box.html','catalog/category/view/id/109',1,'',NULL),(1978,4,97,NULL,'category/97','accessories/flagon.html','catalog/category/view/id/97',1,'',NULL),(1979,4,98,NULL,'category/98','accessories/personalized-badges.html','catalog/category/view/id/98',1,'',NULL),(1980,4,99,NULL,'category/99','accessories/cigarette-case.html','catalog/category/view/id/99',1,'',NULL),(2093,5,110,NULL,'category/110','photo-frame.html','catalog/category/view/id/110',1,'',NULL),(2094,5,111,NULL,'category/111','photo-frame/wooden-photo-frame.html','catalog/category/view/id/111',1,'',NULL),(2095,5,112,NULL,'category/112','photo-frame/metal-photo-frame.html','catalog/category/view/id/112',1,'',NULL),(2096,5,113,NULL,'category/113','photo-frame/crystal-photo-frame.html','catalog/category/view/id/113',1,'',NULL),(2097,5,114,NULL,'category/114','photo-frame/cortex-photo-frame.html','catalog/category/view/id/114',1,'',NULL),(2098,5,115,NULL,'category/115','photo-frame/album.html','catalog/category/view/id/115',1,'',NULL),(2099,5,116,NULL,'category/116','photo-frame/acrylic-photo-frame.html','catalog/category/view/id/116',1,'',NULL),(2100,5,117,NULL,'category/117','home-decoration.html','catalog/category/view/id/117',1,'',NULL),(2101,5,118,NULL,'category/118','home-decoration/glass.html','catalog/category/view/id/118',1,'',NULL),(2102,5,119,NULL,'category/119','home-decoration/printing-pillow.html','catalog/category/view/id/119',1,'',NULL),(2103,5,120,NULL,'category/120','home-decoration/placemat.html','catalog/category/view/id/120',1,'',NULL),(2104,5,121,NULL,'category/121','home-decoration/cup-pad.html','catalog/category/view/id/121',1,'',NULL),(2105,5,122,NULL,'category/122','home-decoration/album.html','catalog/category/view/id/122',1,'',NULL),(2106,5,123,NULL,'category/123','home-decoration/shrouds.html','catalog/category/view/id/123',1,'',NULL),(2107,5,124,NULL,'category/124','home-decoration/plates.html','catalog/category/view/id/124',1,'',NULL),(2108,5,125,NULL,'category/125','home-decoration/ballon.html','catalog/category/view/id/125',1,'',NULL),(2109,5,126,NULL,'category/126','home-decoration/fridge-magnet.html','catalog/category/view/id/126',1,'',NULL),(2110,5,127,NULL,'category/127','home-decoration/candlestick.html','catalog/category/view/id/127',1,'',NULL),(2111,5,128,NULL,'category/128','home-decoration/ashtray.html','catalog/category/view/id/128',1,'',NULL),(2112,5,129,NULL,'category/129','home-decoration/pipe.html','catalog/category/view/id/129',1,'',NULL),(2113,5,130,NULL,'category/130','home-decoration/bowl.html','catalog/category/view/id/130',1,'',NULL),(2114,5,131,NULL,'category/131','home-decoration/chopsticks.html','catalog/category/view/id/131',1,'',NULL),(2115,5,132,NULL,'category/132','home-decoration/coffee-cup.html','catalog/category/view/id/132',1,'',NULL),(2116,5,133,NULL,'category/133','home-decoration/ceramic-cup.html','catalog/category/view/id/133',1,'',NULL),(2117,5,134,NULL,'category/134','home-decoration/customize-table-lamps.html','catalog/category/view/id/134',1,'',NULL),(2118,5,135,NULL,'category/135','home-decoration/piggy-bank.html','catalog/category/view/id/135',1,'',NULL),(2119,5,136,NULL,'category/136','home-decoration/wall-stickers.html','catalog/category/view/id/136',1,'',NULL),(2120,5,137,NULL,'category/137','home-decoration/switch-sticker.html','catalog/category/view/id/137',1,'',NULL),(2121,5,138,NULL,'category/138','home-decoration/water-shift-painting.html','catalog/category/view/id/138',1,'',NULL),(2122,5,139,NULL,'category/139','home-decoration/glass-paste.html','catalog/category/view/id/139',1,'',NULL),(2123,5,140,NULL,'category/140','home-decoration/toilet-stickers.html','catalog/category/view/id/140',1,'',NULL),(2124,5,141,NULL,'category/141','home-decoration/computer-stickers.html','catalog/category/view/id/141',1,'',NULL),(2125,5,142,NULL,'category/142','home-decoration/conch.html','catalog/category/view/id/142',1,'',NULL),(2126,5,143,NULL,'category/143','home-decoration/lucky-cat.html','catalog/category/view/id/143',1,'',NULL),(2127,5,144,NULL,'category/144','home-decoration/campanula.html','catalog/category/view/id/144',1,'',NULL),(2128,5,145,NULL,'category/145','home-decoration/hairs-toy.html','catalog/category/view/id/145',1,'',NULL),(2129,5,146,NULL,'category/146','home-decoration/photo-wall.html','catalog/category/view/id/146',1,'',NULL),(2130,5,147,NULL,'category/147','sports-and-travel.html','catalog/category/view/id/147',1,'',NULL),(2131,5,148,NULL,'category/148','sports-and-travel/kettle.html','catalog/category/view/id/148',1,'',NULL),(2132,5,149,NULL,'category/149','sports-and-travel/hangtag.html','catalog/category/view/id/149',1,'',NULL),(2133,5,150,NULL,'category/150','sports-and-travel/luggage-tag.html','catalog/category/view/id/150',1,'',NULL),(2134,5,151,NULL,'category/151','sports-and-travel/folding-knife.html','catalog/category/view/id/151',1,'',NULL),(2135,5,152,NULL,'category/152','sports-and-travel/e-as-ae-a.html','catalog/category/view/id/152',1,'',NULL),(2136,5,153,NULL,'category/153','printed-materials-series.html','catalog/category/view/id/153',1,'',NULL),(2137,5,154,NULL,'category/154','printed-materials-series/jigsaw.html','catalog/category/view/id/154',1,'',NULL),(2138,5,155,NULL,'category/155','printed-materials-series/greetings-card.html','catalog/category/view/id/155',1,'',NULL),(2139,5,156,NULL,'category/156','printed-materials-series/invitation-card.html','catalog/category/view/id/156',1,'',NULL),(2140,5,157,NULL,'category/157','printed-materials-series/poster.html','catalog/category/view/id/157',1,'',NULL),(2141,5,158,NULL,'category/158','printed-materials-series/album.html','catalog/category/view/id/158',1,'',NULL),(2142,5,159,NULL,'category/159','printed-materials-series/calendar.html','catalog/category/view/id/159',1,'',NULL),(2143,5,160,NULL,'category/160','printed-materials-series/carte.html','catalog/category/view/id/160',1,'',NULL),(2144,5,161,NULL,'category/161','printed-materials-series/birthday-newspaper.html','catalog/category/view/id/161',1,'',NULL),(2145,5,162,NULL,'category/162','printed-materials-series/poker.html','catalog/category/view/id/162',1,'',NULL),(2146,5,163,NULL,'category/163','printed-materials-series/inscribed-bamgoo-slips.html','catalog/category/view/id/163',1,'',NULL),(2147,5,164,NULL,'category/164','printed-materials-series/personalized-certificate.html','catalog/category/view/id/164',1,'',NULL),(2148,5,165,NULL,'category/165','printed-materials-series/card-sticker.html','catalog/category/view/id/165',1,'',NULL),(2149,5,166,NULL,'category/166','printed-materials-series/lomo-photo.html','catalog/category/view/id/166',1,'',NULL),(2150,5,167,NULL,'category/167','printed-materials-series/hand-inkpad.html','catalog/category/view/id/167',1,'',NULL),(2151,5,168,NULL,'category/168','printed-materials-series/red-packets.html','catalog/category/view/id/168',1,'',NULL),(2152,5,169,NULL,'category/169','printed-materials-series/candy-bags.html','catalog/category/view/id/169',1,'',NULL),(2153,5,170,NULL,'category/170','printed-materials-series/wedding-table-card.html','catalog/category/view/id/170',1,'',NULL),(2154,5,171,NULL,'category/171','printed-materials-series/magazine.html','catalog/category/view/id/171',1,'',NULL),(2155,5,172,NULL,'category/172','personalized-stamp.html','catalog/category/view/id/172',1,'',NULL),(2156,5,173,NULL,'category/173','apparel.html','catalog/category/view/id/173',1,'',NULL),(2157,5,174,NULL,'category/174','apparel/t-shirt.html','catalog/category/view/id/174',1,'',NULL),(2158,5,175,NULL,'category/175','apparel/hat.html','catalog/category/view/id/175',1,'',NULL),(2159,5,176,NULL,'category/176','apparel/trousers.html','catalog/category/view/id/176',1,'',NULL),(2160,5,177,NULL,'category/177','apparel/scarves.html','catalog/category/view/id/177',1,'',NULL),(2161,5,178,NULL,'category/178','art-series.html','catalog/category/view/id/178',1,'',NULL),(2162,5,179,NULL,'category/179','art-series/landscape-oil-painting.html','catalog/category/view/id/179',1,'',NULL),(2163,5,180,NULL,'category/180','art-series/figure-painting.html','catalog/category/view/id/180',1,'',NULL),(2164,5,181,NULL,'category/181','art-series/stone-painting.html','catalog/category/view/id/181',1,'',NULL),(2165,5,182,NULL,'category/182','art-series/porcelain-painting.html','catalog/category/view/id/182',1,'',NULL),(2166,5,183,NULL,'category/183','art-series/woodcut.html','catalog/category/view/id/183',1,'',NULL),(2167,5,184,NULL,'category/184','art-series/crystal-engraving.html','catalog/category/view/id/184',1,'',NULL),(2168,5,185,NULL,'category/185','art-series/ice-art.html','catalog/category/view/id/185',1,'',NULL),(2169,5,186,NULL,'category/186','art-series/fimo.html','catalog/category/view/id/186',1,'',NULL),(2170,5,20,NULL,'category/20','household-items.html','catalog/category/view/id/20',1,'',NULL),(2171,5,35,NULL,'category/35','featured-products.html','catalog/category/view/id/35',1,'',NULL),(2172,5,36,NULL,'category/36','occasion.html','catalog/category/view/id/36',1,'',NULL),(2173,5,37,NULL,'category/37','recipients.html','catalog/category/view/id/37',1,'',NULL),(2174,5,38,NULL,'category/38','gifts.html','catalog/category/view/id/38',1,'',NULL),(2175,5,39,NULL,'category/39','diy.html','catalog/category/view/id/39',1,'',NULL),(2176,5,40,NULL,'category/40','watch.html','catalog/category/view/id/40',1,'',NULL),(2177,5,41,NULL,'category/41','watch/disney-watches.html','catalog/category/view/id/41',1,'',NULL),(2178,5,42,NULL,'category/42','watch/alarm-clock.html','catalog/category/view/id/42',1,'',NULL),(2179,5,43,NULL,'category/43','watch/timepiece.html','catalog/category/view/id/43',1,'',NULL),(2180,5,44,NULL,'category/44','watch/personalized-custom-watches.html','catalog/category/view/id/44',1,'',NULL),(2181,5,45,NULL,'category/45','jewelry.html','catalog/category/view/id/45',1,'',NULL),(2182,5,46,NULL,'category/46','jewelry/necklace.html','catalog/category/view/id/46',1,'',NULL),(2183,5,47,NULL,'category/47','jewelry/bracelet.html','catalog/category/view/id/47',1,'',NULL),(2184,5,48,NULL,'category/48','jewelry/earring.html','catalog/category/view/id/48',1,'',NULL),(2185,5,49,NULL,'category/49','jewelry/ring.html','catalog/category/view/id/49',1,'',NULL),(2186,5,50,NULL,'category/50','usb-card.html','catalog/category/view/id/50',1,'',NULL),(2187,5,51,NULL,'category/51','usb-card/u-disk-card.html','catalog/category/view/id/51',1,'',NULL),(2188,5,52,NULL,'category/52','usb-card/wodden-usb-disk.html','catalog/category/view/id/52',1,'',NULL),(2189,5,53,NULL,'category/53','usb-card/leather-usb-disk.html','catalog/category/view/id/53',1,'',NULL),(2190,5,54,NULL,'category/54','usb-card/metal-usb-disk.html','catalog/category/view/id/54',1,'',NULL),(2191,5,55,NULL,'category/55','usb-card/white-porcelain-usb-disk.html','catalog/category/view/id/55',1,'',NULL),(2192,5,56,NULL,'category/56','digital-accessories.html','catalog/category/view/id/56',1,'',NULL),(2193,5,57,NULL,'category/57','digital-accessories/fudiao-phone-case.html','catalog/category/view/id/57',1,'',NULL),(2194,5,58,NULL,'category/58','digital-accessories/kezi-phone-case.html','catalog/category/view/id/58',1,'',NULL),(2195,5,59,NULL,'category/59','digital-accessories/caihui-phone-case.html','catalog/category/view/id/59',1,'',NULL),(2196,5,60,NULL,'category/60','digital-accessories/mouse.html','catalog/category/view/id/60',1,'',NULL),(2197,5,61,NULL,'category/61','digital-accessories/computer-sleeve.html','catalog/category/view/id/61',1,'',NULL),(2198,5,62,NULL,'category/62','digital-accessories/mp3.html','catalog/category/view/id/62',1,'',NULL),(2199,5,63,NULL,'category/63','digital-accessories/cd-bag.html','catalog/category/view/id/63',1,'',NULL),(2200,5,64,NULL,'category/64','digital-accessories/cd.html','catalog/category/view/id/64',1,'',NULL),(2201,5,65,NULL,'category/65','digital-accessories/tablet-pc.html','catalog/category/view/id/65',1,'',NULL),(2202,5,66,NULL,'category/66','digital-accessories/customize-iphone4-case.html','catalog/category/view/id/66',1,'',NULL),(2203,5,67,NULL,'category/67','cups.html','catalog/category/view/id/67',1,'',NULL),(2204,5,68,NULL,'category/68','cups/mug.html','catalog/category/view/id/68',1,'',NULL),(2205,5,69,NULL,'category/69','cups/bone-cup.html','catalog/category/view/id/69',1,'',NULL),(2206,5,70,NULL,'category/70','cups/coffee-cup.html','catalog/category/view/id/70',1,'',NULL),(2207,5,71,NULL,'category/71','cups/color-cup.html','catalog/category/view/id/71',1,'',NULL),(2208,5,72,NULL,'category/72','crystal.html','catalog/category/view/id/72',1,'',NULL),(2209,5,73,NULL,'category/73','crystal/caiyi-crystal.html','catalog/category/view/id/73',1,'',NULL),(2210,5,74,NULL,'category/74','crystal/diaoke-crystal.html','catalog/category/view/id/74',1,'',NULL),(2211,5,75,NULL,'category/75','crystal/crystal-card-holder.html','catalog/category/view/id/75',1,'',NULL),(2212,5,76,NULL,'category/76','crystal/laser-crystal.html','catalog/category/view/id/76',1,'',NULL),(2213,5,77,NULL,'category/77','crystal/crystal-trophy.html','catalog/category/view/id/77',1,'',NULL),(2214,5,78,NULL,'category/78','office-supplies.html','catalog/category/view/id/78',1,'',NULL),(2215,5,79,NULL,'category/79','office-supplies/roller-pen.html','catalog/category/view/id/79',1,'',NULL),(2216,5,80,NULL,'category/80','office-supplies/cardcase.html','catalog/category/view/id/80',1,'',NULL),(2217,5,81,NULL,'category/81','office-supplies/notepad.html','catalog/category/view/id/81',1,'',NULL),(2218,5,82,NULL,'category/82','office-supplies/bookmark.html','catalog/category/view/id/82',1,'',NULL),(2219,5,83,NULL,'category/83','office-supplies/mouse-mat.html','catalog/category/view/id/83',1,'',NULL),(2220,5,84,NULL,'category/84','office-supplies/magnifier.html','catalog/category/view/id/84',1,'',NULL),(2221,5,85,NULL,'category/85','office-supplies/business-card.html','catalog/category/view/id/85',1,'',NULL),(2222,5,86,NULL,'category/86','office-supplies/writing-case.html','catalog/category/view/id/86',1,'',NULL),(2223,5,87,NULL,'category/87','office-supplies/ruler.html','catalog/category/view/id/87',1,'',NULL),(2224,5,88,NULL,'category/88','office-supplies/brush-pot.html','catalog/category/view/id/88',1,'',NULL),(2225,5,89,NULL,'category/89','office-supplies/pen.html','catalog/category/view/id/89',1,'',NULL),(2226,5,90,NULL,'category/90','business-gifts.html','catalog/category/view/id/90',1,'',NULL),(2227,5,91,NULL,'category/91','business-gifts/medal.html','catalog/category/view/id/91',1,'',NULL),(2228,5,92,NULL,'category/92','business-gifts/perfume-bottle.html','catalog/category/view/id/92',1,'',NULL),(2229,5,93,NULL,'category/93','business-gifts/rosewood-gift-set.html','catalog/category/view/id/93',1,'',NULL),(2230,5,94,NULL,'category/94','business-gifts/other-gift-sets.html','catalog/category/view/id/94',1,'',NULL),(2231,5,95,NULL,'category/95','business-gifts/boat.html','catalog/category/view/id/95',1,'',NULL),(2232,5,96,NULL,'category/96','accessories.html','catalog/category/view/id/96',1,'',NULL),(2233,5,100,NULL,'category/100','accessories/comb.html','catalog/category/view/id/100',1,'',NULL),(2234,5,101,NULL,'category/101','accessories/card-package.html','catalog/category/view/id/101',1,'',NULL),(2235,5,102,NULL,'category/102','accessories/glasses.html','catalog/category/view/id/102',1,'',NULL),(2236,5,103,NULL,'category/103','accessories/key-cases.html','catalog/category/view/id/103',1,'',NULL),(2237,5,104,NULL,'category/104','accessories/zippo-lighter.html','catalog/category/view/id/104',1,'',NULL),(2238,5,105,NULL,'category/105','accessories/qinghua-lighter.html','catalog/category/view/id/105',1,'',NULL),(2239,5,106,NULL,'category/106','accessories/wallet.html','catalog/category/view/id/106',1,'',NULL),(2240,5,107,NULL,'category/107','accessories/vanity-mirron.html','catalog/category/view/id/107',1,'',NULL),(2241,5,108,NULL,'category/108','accessories/purse.html','catalog/category/view/id/108',1,'',NULL),(2242,5,109,NULL,'category/109','accessories/music-box.html','catalog/category/view/id/109',1,'',NULL),(2243,5,97,NULL,'category/97','accessories/flagon.html','catalog/category/view/id/97',1,'',NULL),(2244,5,98,NULL,'category/98','accessories/personalized-badges.html','catalog/category/view/id/98',1,'',NULL),(2245,5,99,NULL,'category/99','accessories/cigarette-case.html','catalog/category/view/id/99',1,'',NULL),(2442,1,NULL,188,'product/188','tb-16888172712.html','catalog/product/view/id/188',1,'',NULL),(2443,1,39,188,'product/188/39','diy/tb-16888172712.html','catalog/product/view/id/188/category/39',1,'',NULL),(2444,1,40,188,'product/188/40','watch/tb-16888172712.html','catalog/product/view/id/188/category/40',1,'',NULL),(2445,1,44,188,'product/188/44','watch/personalized-custom-watches/tb-16888172712.html','catalog/product/view/id/188/category/44',1,'',NULL),(2446,1,NULL,189,'product/189','tb-16746748453.html','catalog/product/view/id/189',1,'',NULL),(2447,1,39,189,'product/189/39','diy/tb-16746748453.html','catalog/product/view/id/189/category/39',1,'',NULL),(2448,1,40,189,'product/189/40','watch/tb-16746748453.html','catalog/product/view/id/189/category/40',1,'',NULL),(2449,1,44,189,'product/189/44','watch/personalized-custom-watches/tb-16746748453.html','catalog/product/view/id/189/category/44',1,'',NULL),(2450,1,NULL,190,'product/190','tb-15173227048.html','catalog/product/view/id/190',1,'',NULL),(2451,1,39,190,'product/190/39','diy/tb-15173227048.html','catalog/product/view/id/190/category/39',1,'',NULL),(2452,1,40,190,'product/190/40','watch/tb-15173227048.html','catalog/product/view/id/190/category/40',1,'',NULL),(2453,1,44,190,'product/190/44','watch/personalized-custom-watches/tb-15173227048.html','catalog/product/view/id/190/category/44',1,'',NULL),(2454,1,NULL,191,'product/191','tb-15167871086.html','catalog/product/view/id/191',1,'',NULL),(2455,1,39,191,'product/191/39','diy/tb-15167871086.html','catalog/product/view/id/191/category/39',1,'',NULL),(2456,1,40,191,'product/191/40','watch/tb-15167871086.html','catalog/product/view/id/191/category/40',1,'',NULL),(2457,1,44,191,'product/191/44','watch/personalized-custom-watches/tb-15167871086.html','catalog/product/view/id/191/category/44',1,'',NULL),(2458,1,NULL,192,'product/192','tb-14491898841.html','catalog/product/view/id/192',1,'',NULL),(2459,1,39,192,'product/192/39','diy/tb-14491898841.html','catalog/product/view/id/192/category/39',1,'',NULL),(2460,1,40,192,'product/192/40','watch/tb-14491898841.html','catalog/product/view/id/192/category/40',1,'',NULL),(2461,1,44,192,'product/192/44','watch/personalized-custom-watches/tb-14491898841.html','catalog/product/view/id/192/category/44',1,'',NULL),(2462,1,NULL,193,'product/193','tb-14420097483.html','catalog/product/view/id/193',1,'',NULL),(2463,1,39,193,'product/193/39','diy/tb-14420097483.html','catalog/product/view/id/193/category/39',1,'',NULL),(2464,1,40,193,'product/193/40','watch/tb-14420097483.html','catalog/product/view/id/193/category/40',1,'',NULL),(2465,1,44,193,'product/193/44','watch/personalized-custom-watches/tb-14420097483.html','catalog/product/view/id/193/category/44',1,'',NULL),(2466,1,NULL,194,'product/194','tb-16950456931.html','catalog/product/view/id/194',1,'',NULL),(2467,1,39,194,'product/194/39','diy/tb-16950456931.html','catalog/product/view/id/194/category/39',1,'',NULL),(2468,1,40,194,'product/194/40','watch/tb-16950456931.html','catalog/product/view/id/194/category/40',1,'',NULL),(2469,1,44,194,'product/194/44','watch/personalized-custom-watches/tb-16950456931.html','catalog/product/view/id/194/category/44',1,'',NULL),(2470,1,NULL,195,'product/195','tb-16916368211.html','catalog/product/view/id/195',1,'',NULL),(2471,1,39,195,'product/195/39','diy/tb-16916368211.html','catalog/product/view/id/195/category/39',1,'',NULL),(2472,1,40,195,'product/195/40','watch/tb-16916368211.html','catalog/product/view/id/195/category/40',1,'',NULL),(2473,1,44,195,'product/195/44','watch/personalized-custom-watches/tb-16916368211.html','catalog/product/view/id/195/category/44',1,'',NULL),(2474,1,NULL,196,'product/196','tb-16769128988.html','catalog/product/view/id/196',1,'',NULL),(2475,1,39,196,'product/196/39','diy/tb-16769128988.html','catalog/product/view/id/196/category/39',1,'',NULL),(2476,1,40,196,'product/196/40','watch/tb-16769128988.html','catalog/product/view/id/196/category/40',1,'',NULL),(2477,1,44,196,'product/196/44','watch/personalized-custom-watches/tb-16769128988.html','catalog/product/view/id/196/category/44',1,'',NULL),(2478,1,NULL,197,'product/197','tb-15248759961.html','catalog/product/view/id/197',1,'',NULL),(2479,1,39,197,'product/197/39','diy/tb-15248759961.html','catalog/product/view/id/197/category/39',1,'',NULL),(2480,1,40,197,'product/197/40','watch/tb-15248759961.html','catalog/product/view/id/197/category/40',1,'',NULL),(2481,1,44,197,'product/197/44','watch/personalized-custom-watches/tb-15248759961.html','catalog/product/view/id/197/category/44',1,'',NULL),(2482,1,NULL,198,'product/198','tb-15238419360.html','catalog/product/view/id/198',1,'',NULL),(2483,1,39,198,'product/198/39','diy/tb-15238419360.html','catalog/product/view/id/198/category/39',1,'',NULL),(2484,1,40,198,'product/198/40','watch/tb-15238419360.html','catalog/product/view/id/198/category/40',1,'',NULL),(2485,1,44,198,'product/198/44','watch/personalized-custom-watches/tb-15238419360.html','catalog/product/view/id/198/category/44',1,'',NULL),(2486,1,NULL,199,'product/199','tb-15237839452.html','catalog/product/view/id/199',1,'',NULL),(2487,1,39,199,'product/199/39','diy/tb-15237839452.html','catalog/product/view/id/199/category/39',1,'',NULL),(2488,1,40,199,'product/199/40','watch/tb-15237839452.html','catalog/product/view/id/199/category/40',1,'',NULL),(2489,1,44,199,'product/199/44','watch/personalized-custom-watches/tb-15237839452.html','catalog/product/view/id/199/category/44',1,'',NULL),(2490,1,NULL,200,'product/200','tb-15232587893.html','catalog/product/view/id/200',1,'',NULL),(2491,1,39,200,'product/200/39','diy/tb-15232587893.html','catalog/product/view/id/200/category/39',1,'',NULL),(2492,1,40,200,'product/200/40','watch/tb-15232587893.html','catalog/product/view/id/200/category/40',1,'',NULL),(2493,1,44,200,'product/200/44','watch/personalized-custom-watches/tb-15232587893.html','catalog/product/view/id/200/category/44',1,'',NULL),(2494,1,NULL,201,'product/201','tb-15176883730.html','catalog/product/view/id/201',1,'',NULL),(2495,1,39,201,'product/201/39','diy/tb-15176883730.html','catalog/product/view/id/201/category/39',1,'',NULL),(2496,1,40,201,'product/201/40','watch/tb-15176883730.html','catalog/product/view/id/201/category/40',1,'',NULL),(2497,1,44,201,'product/201/44','watch/personalized-custom-watches/tb-15176883730.html','catalog/product/view/id/201/category/44',1,'',NULL),(2498,1,NULL,202,'product/202','tb-14501358291.html','catalog/product/view/id/202',1,'',NULL),(2499,1,39,202,'product/202/39','diy/tb-14501358291.html','catalog/produc