<?php
class IM_SsoLogin_Helper_Customer_Data extends Mage_Customer_Helper_Data {
    public function getLoginUrl()
    {
        $params = array();

        $referer = $this->_getRequest()->getParam(self::REFERER_QUERY_PARAM_NAME);

        if (!$referer && !Mage::getStoreConfigFlag('customer/startup/redirect_dashboard')) {
            if (!Mage::getSingleton('customer/session')->getNoReferer()) {
                $referer = Mage::getUrl('*/*/*', array('_current' => true, '_use_rewrite' => true));
                $referer = Mage::helper('core')->urlEncode($referer);
            }
        }
        if ($referer) {
            $params = array(self::REFERER_QUERY_PARAM_NAME => $referer);
        }

        return $this->_getUrl('ssologin/login/redirect', $params);
    }
    
    public function getRegisterUrl()
    {
        return $this->_getUrl('ssologin/login/redirect');
    }
    
}