<?php

class IM_SsoLogin_Model_Observer
{
  public function bindSsoUid($observer) {
    $session = Mage::getSingleton('customer/session');
    $user_info  = $session->getSsoUserInfo();
    $customer = $observer->getEvent()->getCustomer();
    if ($user_info && $customer->getId()) {
      Mage::getModel('ssologin/users')->createUser($user_info->UserUID, 'vrose@qq.com', $customer->getId());
      $session->addSuccess(Mage::helper('core/translate')->__("成功绑定 '%s' 账号", $user_info->Name));
      $session->unsSsoUserInfo();
    }
  }
  
  public function deleteUser($observer) {
    $customer = $observer->getEvent()->getCustomer();
    if ($customer->getId()) {
      $ssoUser = Mage::getModel('ssologin/users')->load($customer->getId(), 'customer_id');
      $ssoUser->delete();
    }
  }
  
}