<?php


/**
 *  Sso Login Controller
 *  http://127.0.0.1/magento-nzOnlineDeals/ssologin/login/redirect
 *  http://127.0.0.1/magento-nzOnlineDeals/ssologin/login/callback
 *  
 
 测试地址：
 http://127.0.0.1/magento-nzOnlineDeals/ssologin/login/callback?rspType=code&url=http://127.0.0.1/magento-nzOnlineDeals/index.php/&code=e4rmu452usmitindxmasmg7zj5copa54xt16y5gwcjhve8q6dmrn1jyxxr4prhdl
 
 http://127.0.0.1/magento-nzOnlineDeals/ssologin/callback?rspType=code&url=http://127.0.0.1/magento-nzOnlineDeals/index.php/&code=yotgtgnsr45y8pa29zk8fhx2k8mwrna8pu5mxiw1de8pzr37525jrzohqswltr14
 
 */
class IM_SsoLogin_LoginController extends Mage_Core_Controller_Front_Action
{
  public function getSsoSiteId()
  {
    return Mage::helper('ssologin')->getAppKey();
  }
  
  public function getSsoSecretKey()
  {
    return Mage::helper('ssologin')->getSecret();
  }
  
  public $platform_list = array('taobao', 'qq', 'sina');

  public function redirectAction()
  {
    $referrer = urlencode($_SERVER['HTTP_REFERER']);
    if(!Mage::getSingleton('customer/session')->isLoggedIn()) {
      $site_id      = $this->getSsoSiteId();
      if (!trim($referrer)) {
        $referrer = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK);
      }
      $request_url  = "http://member.ecczo.cn/ssologin.ashx?sid={$site_id}&url={$referrer}&rspType=code";
      $query_parameters = Mage::app()->getRequest()->getQuery();
      if ($query_parameters['iframe']) {
        $request_url .= "&frame=yes";
      }
      
      if ($query_parameters['type'] && in_array($query_parameters['type'], $this->platform_list)) {
        $request_url .= "&type={$query_parameters['type']}";
      }
      
      $this->getResponse()->setRedirect($request_url)->sendResponse();      
    } else {
      //$this->getResponse()->setBody("用户已经登录");
      $this->_redirect('');
      return;
      //$this->getResponse()->setRedirect(Mage::helper('customer')->getLoginUrl())->sendResponse();
    }
  }
  
  public function callbackAction()
  {

    $session = Mage::getSingleton('customer/session');
    if($session->isLoggedIn()) {
      $this->_redirect('');
      return;
    }

    $query_parameters = Mage::app()->getRequest()->getQuery();
    if (isset($query_parameters['rspType']) && $query_parameters['rspType'] == 'code') {
    
    
      $site_id      = $this->getSsoSiteId();
      $secret_key   = $this->getSsoSecretKey();
      $code         = $query_parameters['code'];
      $sign         = md5(strtolower("{$site_id}{$code}{$secret_key}"));
    
      $client = new Varien_Http_Client('http://member.ecczo.cn/Sso/AuthCode.ashx', array('storeresponse'=>FALSE));
      $client->setMethod(Varien_Http_Client::GET);
      $client->setParameterGet('sid', $site_id);
      $client->setParameterGet('code', $code);
      $client->setParameterGet('sign', $sign);
      try{



      ## 请使用编辑器注释功能反注释
       $response = $client->request();
       if ($response->isSuccessful()) {
          // ## echo $response->getBody();
// $response_body = '{"AuthCode":"e4rmu452usmitindxmasmg7zj5copa54xt16y5gwcjhve8q6dmrn1jyxxr4prhdl","ExpireTime":"2012-08-04 10:01:12","IsPartner":false,"IsProvider":false,"IsReseller":false,"MemberID":"unoom","Name":"unoom","PartnerSession":"[{\"RefreshKey\":\"620120955cd46b7dbdf1f874541be8a8fb84ecd542d93cc277916500\",\"SessionKey\":\"6200e09e98022b50bdf1b3ace868fb8628f3c94128dd66c277916500\",\"SiteName\":\"TAOBAO\",\"UserId\":\"unoom\"}]","PartnerSessionList":[{"RefreshKey":"620120955cd46b7dbdf1f874541be8a8fb84ecd542d93cc277916500","SessionKey":"6200e09e98022b50bdf1b3ace868fb8628f3c94128dd66c277916500","SiteName":"TAOBAO","UserId":"unoom"}],"SessionID":"69iibu1siwy3arypg17ys5pbve3ejb84","UserUID":10000409}';
          
         $user_info = json_decode($response->getBody());
// $user_info = json_decode($response_body);
       }




      } catch (Exception $e) {
      }
      
      if ($user_info) {
        $ssoUser = Mage::getModel('ssologin/users')->load($user_info->UserUID, 'sso_uid');
        if ($ssoUser->getCustomerId()) {
          $customer = Mage::getModel('customer/customer')->load($ssoUser->getCustomerId());
          $session->setCustomerAsLoggedIn($customer);
          $this->getResponse()->setRedirect(Mage::getUrl('customer/account'));
        } else {
          $session->addSuccess($this->__('尊敬的%s, 您是首次使用%s账号登录我们网站，请您继续完成注册/登录过程，稍候我们会绑定您的 %s 账号到网店账户上', $user_info->Name, $user_info->PartnerSessionList[0]->SiteName, $user_info->PartnerSessionList[0]->SiteName));
          $session->setSsoUserInfo($user_info);
          //$this->getResponse()->setRedirect(Mage::helper('customer')->getRegisterUrl())->sendResponse();
          $this->getResponse()->setRedirect(Mage::getUrl('customer/account/create'));
        }
        //print_r($user_info);
      }
      
      
    }
  }
  
}



















