/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Helpdeskultimate
 * @copyright  Copyright (c) 2009-2011 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

var AWHDUTicket = Class.create({
    initialize: function(objName) {
        this.messages = [];
        this.quotes = [];
        this.dbmessages = [];
        this.global = window;
        this.global[objName] = this;
        
        this.selectors = {
            contentValue: 'content_value',
            messageBody: 'messageBody',
            messageEdit: 'messageEdit',
            messageBodyText: 'messageBodyText'
        };
        
        this.options = {
            saveUrl: ''
        };

        String.prototype.replaceAll = function(target, replacement) {
            return this.split(target).join(replacement);
	};
    },

    setQuote: function(id, quote) {
        this.quotes[id] = quote;
        return this;
    },
    
    getQuote: function(id) {
        return typeof(this.quotes[id]) != 'undefined' ? this.quotes[id] : null;
    },

    setMessage: function(id, body) {
        this.messages[id] = body;
        return this;
    },
    
    getMessage: function(id) {
        return typeof(this.messages[id]) != 'undefined' ? this.messages[id] : null;
    },
    
    setDBMessage: function(id, body) {
        this.dbmessages[id] = body;
        return this;
    },
    
    getDBMessage: function(id) {
        return typeof(this.dbmessages[id]) != 'undefined' ? this.dbmessages[id] : null;
    },
    
    quoteMessage: function(id) {
        var editorMCE = null;
        if(typeof(tinyMCE) != 'undefined')
            editorMCE = tinyMCE.getInstanceById('content_value');
        if(editorMCE == null) {
            var contentTextarea = $(this.selectors.contentValue);
            contentTextarea.value =
                (contentTextarea.value.replace(/\[quot.*?quot]/, '')) + 
                (this.getQuote(id)).trim() + '\r\n';
            contentTextarea.focus();
        } else {
            editorMCE.setContent(editorMCE.getContent().replace(/\[quot.*?quot]/, '')+(this.getQuote(id)).trim().replaceAll("\n", "<br />") + '\r\n');
            return false;
        }
        return this;
    },
    
    editMessage: function(id) {
        if($(this.selectors.messageBody+id) && $(this.selectors.messageEdit+id)) {
            var messageBody = $(this.selectors.messageBody+id);
            var messageEdit = $(this.selectors.messageEdit+id);
            messageBody.innerHTML = '';
            messageBody.insert(messageEdit);
            messageEdit.show();
        }
    },
    
    saveMessage: function(id) {
        if($(this.selectors.messageBody+id) && $(this.selectors.messageBodyText+id)) {
            var messageBody = $(this.selectors.messageBody+id);
            var messageText = $(this.selectors.messageBodyText+id);
            var messageEdit = $(this.selectors.messageEdit+id);
            new Ajax.Request(this.options.saveUrl, {
                parameters: {
                    id: id,
                    text: messageText.value
                },
                onSuccess: function(transport) {
                    try {
                        var resp = transport.responseText.evalJSON();
                        if(resp.s) {
                            this.setMessage(id, resp.text);
                            this.setQuote(id, resp.quotetext);
                            this.setDBMessage(id, resp.dbtext);
                            messageText.value = resp.text;
                            messageBody.insert({after: messageEdit});
                            messageEdit.hide();
                            messageBody.innerHTML = resp.text;
                        }
                    } catch(ex) {
                    }
                }.bind(this)
            });
        }
    },
    
    cancelMessage: function(id) {
        if($(this.selectors.messageBody+id) && $(this.selectors.messageBodyText+id)) {
            var messageBody = $(this.selectors.messageBody+id);
            var messageText = $(this.selectors.messageBodyText+id);
            var messageEdit = $(this.selectors.messageEdit+id);
            
            messageText.value = this.getDBMessage(id);
            messageBody.insert({after: messageEdit});
            messageEdit.hide();
            messageBody.innerHTML = this.getMessage(id);
        }
    },
    
    setUrl: function(name, url) {
        url = typeof(url) != 'undefined' ? url : '';
        url = url.replace(/^http[s]{0,1}/, window.location.href.replace(/:[^:].*$/i, ''));
        this.options[name] = url;
    }
});

new AWHDUTicket('awhduticket');
;
