<?php
/*
 * smartb2b 工具函数库
 * ============================================================================
 * [smartb2b] (C) 2009-2012 smartb2b Inc.
 * Home page: http://www.smartb2b.net；
 * ============================================================================
 * $Author: liclny $
 * $Id: lib_tool.php 16881 2009年10月27日 8:22:43Z liclny $
*/

if (!defined('IN_SMARTB2B'))
{
    die('Access attempt!');
}

function get_tables()
{
	global $db,$config;
	$row = $db->getRows("SHOW TABLE STATUS LIKE '$config[tabpre]%'", 'SILENT');
	return $row;		
}
function export_db()
{
	global $db,$config;
	$db_name	= $config['dbname'];
	if($_POST['do_export']||$_GET['do_export'])
	{
		require_once(ADMIN_PATH."include/lib_backup.php");
		$path		= ROOT_PATH . '/data/backup/sql/';
		$tmp_file	= $path.'tables_cache.php';
		
		if(!file_exists($path))
		{
			require_once(ROOT_PATH . 'include/lib_file.php');
			make_dir($path);
		}
		$tables		= $_POST['tables'];
		$sizelimit	= is_numeric($_POST['sizelimit'])?$_POST['sizelimit']:2048;
		$sizelimit	= isset($sizelimit)?$sizelimit:$_GET['sizelimit'];
		$bak_file	= $_POST['back_name']; 
		$fname		= isset($_GET['fname']) ? $_GET['fname'] : $bak_file;
		$fileid		= isset($_GET['fileid']) ? $_GET['fileid'] : 1;
		if(is_array($tables)) 
		{
			creat_cache($tmp_file, $tables);
		}
		else
		{
			$tables = read_cache($tmp_file);
		}
		if(!$tables) return null;
		//===Begin Buckup==============
		$sqldump		= '';
		$tableid		= isset($_GET['tableid']) ? $_GET['tableid'] - 1 : 0;
		$startfrom		= isset($_GET['startfrom']) ? intval($_GET['startfrom']) : 0;
		$tablenumber	= count($tables);
		for($i = $tableid; $i < $tablenumber && strlen($sqldump) < $sizelimit * 1000; $i++)
		{
			$data		= sql_dumptable($tables[$i], $startfrom, strlen($sqldump),$sizelimit,$startrow);
			$sqldump   .= $data['dump'];
			$startfrom	= 0;
			$startrow	= $data['row'];
		}
		if(trim($sqldump))
		{
			$sqldump	= "#SmartB2B SQL Dump\n# --------------------------------------------------------\n\n\n".$sqldump;
			$tableid	= $i;
			$filename	= $fname.'_'.$fileid.'.sql';
			$fileid++;
			$bakfile = $path.$filename;
			if(is_writable($path))
			{
				file_put_contents($bakfile, $sqldump);
				msg('?act=database&fname='.$fname.'&sizelimit='.$sizelimit.'&tableid='.$tableid.'&fileid='.$fileid.'&startfrom='.$startrow.'&do_export=1');
			}
		}
		else
		{
		  @unlink($tmp_file);
		}
	}
	else
	{
		$size = $bktables = $bkresults = $results= array();
		$k = 0;
		$totalsize = 0;
		$query = $db->query("SHOW TABLES FROM ".$db_name);
		while($r = $db->fetch_row($query))
		{
			$tables[$k]		= $r[0];
			$count			= $db->getOne("SELECT count(*) as number FROM $r[0] WHERE 1");
			$results[$k]	= $count['number'];
			$bktables[$k]	= $r[0];
			$bkresults[$k]	= $count['number'];
			$s				= $db->getRows("SHOW TABLE STATUS FROM `".$db_name."` LIKE '".$r[0]."'");
			$size[$k]		= round($s['Data_length']/1024/1024, 2);
			$totalsize	   += $size[$k];
			$k++;
		}
	}
}
function repair_db($table)
{
	global $db,$lang;
	if(!empty($table))
	{
		$db->query("REPAIR TABLE ".$table);
	}
}
function optimize_db($table)
{
	global $db,$lang;
	if(!empty($table))
	{
		$db->query("OPTIMIZE TABLE ".$table);
	}
}
function get_sql_files($path)
{
	global $config;
	 $sqlfiles = glob($path);
	 if(is_array($sqlfiles))
	 {
		 $prepre	= '';
		 $info		= $infos = array();
		 foreach($sqlfiles as $id=>$sqlfile)
		 {
			 preg_match("/([0-9a-zA-Z_]_)([0-9]+)\.sql/i",basename($sqlfile),$num);
			 $info['id']			= $id+1;
			 $info['name']			= basename($sqlfile);
			 $info['url']			= $config['url']."/data/backup/sql/".basename($sqlfile);
			 $info['size']			= round(filesize($sqlfile)/(1024*1024), 2);
			 $info['export_time']	= date('Y-m-d H:i:s', filemtime($sqlfile));
			 $info['pre']			= $num[1];
			 $info['number']		= $num[2];
			 if(!$id) $prebgcolor = '#E4EDF9';
			 if($info['pre'] == $prepre)
			 {
				 $info['bgcolor'] = $prebgcolor;
			 }
			 else
			 {
				 $info['bgcolor'] = ($prebgcolor == '#E4EDF9') ? '#f8f8f8' : '#E4EDF9';
			 }
			 $prebgcolor	= $info['bgcolor'];
			 $prepre		= $info['pre'];
			 $infos[]		= $info;
			 
		 }
		 //print_r($infos);
		 return $infos;
	 }
}
function upload_run_sql($file,$path)
{
	$filepath	= $path."tmp_".time().".sql";
	if(move_uploaded_file($file["tmp_name"],$filepath))
	{
		$sql = file_get_contents($filepath);
		sql_execute($sql);
		@unlink($filepath);
	}
}
function run_sql($sql)
{
	global $db;
	$sql = stripslashes($sql);
	if(trim($sql) != '')
	{
		sql_execute($sql);
		return true;
	}
	return false;
}
function sql_execute($sql)
{
	global $db;
    $sqls = sql_split($sql);
	if(is_array($sqls))
    {
		foreach($sqls as $sql)
		{
			if(trim($sql) != '') 
			{
				$db->query($sql);
			}
		}
	}
	else
	{
		$db->query($sqls);
	}
	return true;
}
function sql_split($sql)
{
	global $db_charset, $db;
	if($db->version() > '4.1' && $db_charset)
	{
		$sql = preg_replace("/TYPE=(InnoDB|MyISAM)( DEFAULT CHARSET=[^; ]+)?/", "TYPE=\\1 DEFAULT CHARSET=".$db_charset,$sql);
	}
	$sql = str_replace("\r", "\n", $sql);
	$ret = array();
	$num = 0;
	$queriesarray = explode(";\n", trim($sql));
	unset($sql);
	foreach($queriesarray as $query)
	{
		$ret[$num] = '';
		$queries = explode("\n", trim($query));
		$queries = array_filter($queries);
		foreach($queries as $query)
		{
			$str1 = substr($query, 0, 1);
			if($str1 != '#' && $str1 != '-') $ret[$num] .= $query;
		}
		$num++;
	}
	return($ret);
}
function auto_name($mode=0,$length=8)
{
	switch ($mode) {
		case '1':	$str = '1234567890';	break;
		case '2':	$str = 'abcdefghijklmnopqrstuvwxyz';	break;
		case '4':	$str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';	break;
		default:	$str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';	break;
	}
	$l		= strlen($str);
	$name	.= date('Ymd')."_";
	for($i = 0;$i < $length;$i ++){
		$num = rand(0, $l);
		$name .= $str[$num];
	}
	return $name;
}
?>