<?php
/*
 * SmartB2B 类别函数库
 * ============================================================================
 * [SmartB2B] (C) 2009-2012 SmartB2B Inc.
 * Home page: http://www.smartb2b.net；
 * ============================================================================
 * $Author: liclny $
 * $Id: lib_category.php 16881 2009年10月27日 8:22:43Z liclny $
*/

if (!defined('IN_SMARTB2B'))
{
    die('Access attempt!');
}
/**
 * 获得指定分类下的子分类的数组
 *
 * @access  public
 * @param   int     $type		分类的类型
 * @param   int     $catid      分类的ID
 * @param   boolean $re_type    返回的类型: 值为真时返回下拉列表,否则返回数组
 * @param   int     $level      限定返回的级数。为0时返回所有级数
 * @param   int     $is_show_all 如果为true显示所有分类，如果为false隐藏不可见分类。
 * @return  mix
 */
function cat_list($type,$catid=0)
{
	global $db;
	$ctab	= ($type=='area')?$type:$type.'_cat';
	if ($catid > 0)
		$pid	= $catid;
	else
		$pid = 0;
	$num	= $db->num_rows("SELECT catid FROM ".table($ctab)." WHERE pid = '$pid' AND is_show = 1 ");
	if ($num || $pid== 0)
	{
		/* 获取当前分类及其子分类 */
		$sql = "SELECT * FROM ".table($ctab)." WHERE pid = '$pid' AND is_show = 1 ORDER BY sort ASC, catid ASC";
		$row = $db->getRows($sql);
		foreach ($row AS $key=>$v)
		{
			$cat[$v['catid']]	= $v['cat'];
			if (isset($v['catid']) != NULL)
			{
				if(($catid==0)||($v['catid']==$catid))
				{
					$sub_cat	= get_sub_cat($v['catid'],$type);
					if(is_array($sub_cat))
						$cat		= $cat+$sub_cat;
				}
			}
		}
	}
	return $cat;
}

function get_sub_cat($catid = 0,$type,$i = 0)
{
	global $db;
	$ctab	= ($type=='area')?$type:$type.'_cat';
	$i			= $i+1;
	for($j=$i;$j>=1;$j--)
	{
		$prestr	.="&nbsp;&nbsp;&nbsp;"; 
	}
    $num		= $db->num_rows('SELECT catid FROM ' .table($ctab) . " WHERE pid = '$catid' AND is_show = 1 ");
    if ($num || $catid == 0)
    {
        $child_sql = 'SELECT * FROM ' .table($ctab)." WHERE pid = '$catid' AND is_show = 1 ORDER BY sort ASC, catid ASC";
        $row = $db->getRows($child_sql);
        foreach ($row AS $key=>$v)
        {
			$cat[$v['catid']]	= $prestr."&nbsp;&nbsp;".$v['cat'];
			if (isset($v['catid']) != NULL)
			{
				$sub_cat	= get_sub_cat($v['catid'],$type,$i);
				if(is_array($sub_cat))
				{
					$cat		= $cat+$sub_cat;
				}
			}
        }
    }
    return $cat;
}
function AjaxEdit_cat($id,$type)
{
	global $db;
	$ctab	= ($type=='area')?$type:$type.'_cat';
	if(is_numeric($id))
	{
		$cat	= trim($_POST['cat']);
		$sort	= $_POST['sort'];
		if(!empty($cat))
		{
			$sql	= "update ".table($ctab)." set cat='$cat' where catid='$id'";
			$db->query($sql);
		}
		if(is_numeric($sort))
		{
			$sql	= "update ".table($ctab)." set sort='$sort' where catid='$id'";
			$db->query($sql);
		}
		if($type=='area') update_area_data();
	}
}
function batch_add($type,$pid=0)
{
	global $db;
	$ctab	= ($type=='area')?$type:$type.'_cat';
	if($_POST['cat']&&!empty($type))
	{
		foreach(explode("\r\n",$_POST['cat']) as $catv)
		{
			$catv	= trim($catv);
			if(!empty($catv)){				
				$sql	= "insert into ".table($ctab)." (pid,cat,is_show) values ('$pid','$catv','1')";
				$db->query($sql);
			}
		}
		if($type=='area') update_area_data();
	}
}
/*
function cat_list($type,$catid=0)
{
   global $db;
   $ctab	= $type.'_cat';
   if ($catid > 0)
		$pid	= $catid;
	else
		$pid = 0;
   $sql	= "select * from ".table($ctab)." order by sort,catid";
   $row	= $db->getRows($sql);
   foreach($row as $key=>$v)
   {
		$cat[$v['catid']]	= $v['cat'];
   }
   return $cat;
}
*/
function get_catlist($type=null)
{
	global $db;
	$num	= 20;
	$pid	= !empty($_GET['pid'])?$_GET['pid']:0;	
	$pg		= isset($_GET['pg'])?$_GET['pg']:1;
	$type	= ($type=='area')?$type:$type.'_cat';
	$snum	= ($pg-1)*$num;
	$sql	= "select * from ".table($type)." where pid='$pid' order by sort ASC,catid ASC limit ".$snum.",".$num;
	$list	= $db->getRows($sql);
	$row['list']	= $list;
	require_once(ADMIN_PATH."/include/class_page.php");
	$allnum	= $db->num_rows("select catid from ".table($type)." a where pid='$pid'");
	$page	= new Page($allnum,$num);
	$row['num']		= $allnum;
	$row['page']	= $page->list_page();
	return $row;
}
function get_cat_guide($type,$id=0)
{
	global $db,$do;
	$catab	= ($type=='area')?$type:$type.'_cat';
	if($id)
	{
		$cat	= $db->getRow("select catid,pid,cat from ".table($catab)." where catid='$id'");
		$str	= " » "."<a href='main.php?mod=".$type."&do=category&pid=".$cat['catid']."'>".$cat['cat']."</a>";
		if($cat['pid'])
		{
			$str	= get_cat_guide($type,$cat['pid']).$str;
		}		
	}
	return $str;
}
function Ajax_OnOff($type,$id=0)
{
	global $db;
	$type	= ($type=='area')?$type:$type.'_cat';
	if($id)
	{
		$sql	= "update ".table($type)." set is_show=abs(is_show-1) where catid='$id'";
		$db->query($sql);
		$is_show= $db->getOne("select is_show from ".table($type)." where catid='$id'");
		echo "theme/default/images/".$is_show.".gif";
		if($type=='area') update_area_data();
	}
}
function del_category($type,$id=0)
{
	global $db;
	$type	= ($type=='area')?$type:$type.'_cat';
	if($id)
	{
		$sql	= "delete from ".table($type)." where catid='$id'";
		$db->query($sql);
		if($type=='area') update_area_data();
	}
}

//========
function update_area_data()
{
	global $db,$config;
	$row	= $db->getRows("select catid,cat from ".table('area')." where is_show='1' order by sort,catid");
	foreach($row as $v)
	{
		$area[$v['catid']]	= $v['cat'];
	}
	$path	= ROOT_PATH."lang/".$config['lang']."/data";
	creat_php_file($path,'area',$area);
}

//===Custom category=========================================
function custom_cat($type,$userid=null)
{
	global $db;
	$ctab	= ($type=='area')?$type:$type.'_ucat';
	$row	= $db->getRows("SELECT catid,cat FROM ".table($ctab)." WHERE userid = '$userid' AND is_show = 1 order by sort,catid");
	foreach($row as $v)
	{
		$cat[$v['catid']]	= $v['cat'];
	}
	return $cat;
}
function add_custom_cat($type,$cat,$userid=null)
{
	global $db;
	$cat	= trim($cat);
	if($type&&$cat)
	{
		$ctab	= $type.'_ucat';
		$array	= array('userid'	=> $userid,	'cat'	=> $cat,	'sort'	=> $sort);
		$db->insert(table($ctab),$array);
		$catid	= $db->lastid();
		echo $catid;
	}
}
function update_custom_cat($type,$userid=null)
{
	global $db;
	$ctab	= $type.'_ucat';
	if($_POST['del'])
	{
		foreach($_POST['del'] as $k=>$v)
		{
			if($v)
			{
				$db->query("delete from ".table($ctab)." where catid='$k' and userid='$userid'");
				unset($_POST['sort'][$k]);
			}
		}
	}
	foreach($_POST['sort'] as $k=>$v)
	{
		$sql=" update ".table($ctab)." set sort='$v',cat='".$_POST['cat'][$k]."',is_show='".$_POST['is_show'][$k]."' where catid='".$k."' and userid='$userid'";
		$db->query($sql);
	}
	$new_cat	= trim($_POST['new_cat']);
	$new_sort	= trim($_POST['new_sort']);
	if($new_cat)
	{
		$sort	= trim($_POST['sort']);
		$array	= array('userid'	=> $userid,	'cat'	=> $new_cat,	'sort'	=> $new_sort);
		$db->insert(table($ctab),$array);
	}
}
?>