<?php
/*
 * ============================================================================
 * [SmartB2B] (C) 2009-2012 SmartB2B Inc.
 * Home page: http://www.smartb2b.net；
 * ============================================================================
 * $Author: liclny $
 * $Id: lib_common.php 16881 2009年10月27日 8:22:43Z liclny $
*/

if(!defined('IN_SMARTB2B')) {
	exit('Access attempt!');
}

//获取表名
function table($tab) {
	global $config;
	return $config['tabpre'].$tab;
}
//获得时间
function get_date(){
	return date('Y-m-d H:i:s');
}

//获得当前格林威治时间的时间戳
function get_microtime()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}
function get_time()
{
    return time();	//(time() - date('Z'));
}
//多得真实IP
function get_ip()
{
    static $realip = NULL;

    if ($realip !== NULL)
    {
        return $realip;
    }

    if (isset($_SERVER))
    {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);

            /* 取X-Forwarded-For中第一个非unknown的有效IP字符串 */
            foreach ($arr AS $ip)
            {
                $ip = trim($ip);

                if ($ip != 'unknown')
                {
                    $realip = $ip;

                    break;
                }
            }
        }
        elseif (isset($_SERVER['HTTP_CLIENT_IP']))
        {
            $realip = $_SERVER['HTTP_CLIENT_IP'];
        }
        else
        {
            if (isset($_SERVER['REMOTE_ADDR']))
            {
                $realip = $_SERVER['REMOTE_ADDR'];
            }
            else
            {
                $realip = '0.0.0.0';
            }
        }
    }
    else
    {
        if (getenv('HTTP_X_FORWARDED_FOR'))
        {
            $realip = getenv('HTTP_X_FORWARDED_FOR');
        }
        elseif (getenv('HTTP_CLIENT_IP'))
        {
            $realip = getenv('HTTP_CLIENT_IP');
        }
        else
        {
            $realip = getenv('REMOTE_ADDR');
        }
    }

    preg_match("/[\d\.]{7,15}/", $realip, $onlineip);
    $realip = !empty($onlineip[0]) ? $onlineip[0] : '0.0.0.0';

    return $realip;
}

function getOS($strAgent){
$os = false;
if(eregi('win',$strAgent) && strpos($strAgent,'95')){
$os = 'Windows 95';
} else if(eregi('win 9x',$strAgent) && strpos($strAgent,'4.90')){
$os = 'Windows ME';
} else if(eregi('win',$strAgent) && eregi('98',$strAgent)){
$os = 'Windows 98';
} else if(eregi('win',$strAgent) && eregi('nt 6.0',$strAgent)){
$os = 'Windows Vista';
} else if(eregi('win',$strAgent) && eregi('nt 5.2',$strAgent)){
$os = 'Windows 2003 Server';
} else if(eregi('win',$strAgent) && eregi('nt 5.1',$strAgent)){
$os = 'Windows XP';
} else if(eregi('win',$strAgent) && eregi('nt 5',$strAgent)){
$os = 'Windows 2000'; 
} else if(eregi('win',$strAgent) && eregi('nt',$strAgent)){ 
$os = 'Windows NT'; 
} else if(eregi('win',$strAgent) && eregi('32',$strAgent)){
$os = 'Windows 32';
} else if(eregi('linux',$strAgent)){ 
$os = 'Linux';
} else if(eregi('unix',$strAgent)){
$os = 'Unix';
} else if(eregi('sun',$strAgent) && eregi('os',$strAgent)){
$os = 'SunOS';
} else if(eregi('ibm',$strAgent) && eregi('os',$strAgent)){
$os = 'IBM OS/2'; 
} else if(eregi('mac',$strAgent) && eregi('pc',$strAgent)){
$os = 'Macintosh';
} else if(eregi('powerpc',$strAgent)){
$os = 'PowerPC';
} else if(eregi('aix',$strAgent)){
$os = 'AIX'; 
} else if(eregi('HPUX',$strAgent)){
$os = 'HPUX'; 
} else if(eregi('netbsd',$strAgent)){
$os = 'NetBSD'; 
} else if(eregi('bsd',$strAgent)){ 
$os = 'BSD';
} else if(eregi('OSF1',$strAgent)){ 
$os = 'OSF1'; 
} else if(eregi('IRIX',$strAgent)){ 
$os = 'IRIX'; 
} else if(eregi('FreeBSD',$strAgent)){ 
$os = 'FreeBSD'; 
} else if(eregi('teleport',$strAgent)){ 
$os = 'teleport';
} else if(eregi('flashget',$strAgent)){
$os = 'flashget';
} else if(eregi('webzip',$strAgent)){ 
$os = 'webzip'; 
} else if(eregi('offline',$strAgent)){ 
$os = 'offline'; 
} else{
$os = 'Unknown OS';
} 
return $os;
}
function sizecount($filesize) {
	if($filesize >= 1073741824) {
		$filesize = round($filesize / 1073741824 * 100) / 100 . ' GB';
	} elseif($filesize >= 1048576) {
		$filesize = round($filesize / 1048576 * 100) / 100 . ' MB';
	} elseif($filesize >= 1024) {
		$filesize = round($filesize / 1024 * 100) / 100 . ' KB';
	} else {
		$filesize = $filesize . ' Bytes';
	}
	return $filesize;
}
function sctiptName()
{
	$name = explode('/', $_SERVER['SCRIPT_NAME']);
	return array_pop($name);
}
function serialize_string($string,$arr_name=null,$file)
{
	$out_str	= serialize($string);
	if($arr_name)
		$out_str	= '<?php $'.$arr_name.' = unserialize(\''.$out_str.'\');?>';
	else
		$out_str	= '<?php $config = array_merge($config,unserialize(\''.$out_str.'\'));?>';
	$fp			= fopen(ROOT_PATH.'data/config/'.$file.'_config.php','w');
	fwrite($fp,$out_str,strlen($out_str));
	fclose($fp);
}

function read_dir($dir)
{
	$i		= 0;
	$handle = opendir($dir); 
	$rdir	= array();
	while($filename = readdir($handle))
	{ 
		if($filename!="."&&$filename!="..")
		{
		  if(is_dir($dir.$filename))
		  { 
		  	 if(substr($filename,0,5)!='user_'&&substr($filename,0,8)!='special_'&&substr($filename,0,5)!='email')
		   	 	$rdir[]=$filename;
		  }
	   }
	}
	return $rdir;
}

//=============取得当前的域名
function get_domain()
{
	$protocol = http();

	/* 域名或IP地址 */
	if (isset($_SERVER['HTTP_X_FORWARDED_HOST']))
	{
		$host = $_SERVER['HTTP_X_FORWARDED_HOST'];
	}
	elseif (isset($_SERVER['HTTP_HOST']))
	{
		$host = $_SERVER['HTTP_HOST'];
	}
	else
	{
		/* 端口 */
		if (isset($_SERVER['SERVER_PORT']))
		{
			$port = ':' . $_SERVER['SERVER_PORT'];

			if ((':80' == $port && 'http://' == $protocol) || (':443' == $port && 'https://' == $protocol))
			{
				$port = '';
			}
		}
		else
		{
			$port = '';
		}

		if (isset($_SERVER['SERVER_NAME']))
		{
			$host = $_SERVER['SERVER_NAME'] . $port;
		}
		elseif (isset($_SERVER['SERVER_ADDR']))
		{
			$host = $_SERVER['SERVER_ADDR'] . $port;
		}
	}

	return $protocol . $host;
}

//获得 SmartB2B 当前环境的 URL 地址

function url()
{
	$curr = strpos(PHP_SELF, ADMIN_PATH . '/') !== false ?
			preg_replace('/(.*)(' . ADMIN_PATH . ')(\/?)(.)*/i', '\1', dirname(PHP_SELF)) :
			dirname(PHP_SELF);

	$root = str_replace('\\', '/', $curr);

	if (substr($root, -1) != '/')
	{
		$root .= '/';
	}

	return get_domain() . $root;
}
//获取完整url地址
function get_url() 
{ 
	$URL['PHP_SELF']		= isset($_SERVER['PHP_SELF'])?$_SERVER['PHP_SELF']:(isset($_SERVER['SCRIPT_NAME'])?$_SERVER['SCRIPT_NAME']:$_SERVER['ORIG_PATH_INFO']);   //当前页面名称
	$url_array				= explode('/',$URL['PHP_SELF']);
	$URL['PHP_SELF']		= array_pop($url_array);
	//$URL['DOMAIN']			= $_SERVER['SERVER_NAME'];  //域名(主机名)
	$URL['QUERY_STRING']	= $_SERVER['QUERY_STRING'];   //URL 参数
	$URL['URI']				= $URL['PHP_SELF'].($URL['QUERY_STRING']?"?".$URL['QUERY_STRING']:"");
	$URL['URL']				= $URL['PHP_SELF'].($URL['QUERY_STRING']?"?".$URL['QUERY_STRING']:"");
	return $URL['URL'];
} 
//获得 SmartB2B 当前环境的 HTTP 协议方式

function http()
{
	return (isset($_SERVER['HTTPS']) && (strtolower($_SERVER['HTTPS']) != 'off'))?'https://' : 'http://';
}

//获得数据目录的路径

function data_dir($sid = 0)
{
	if (empty($sid))
	{
		$s = 'data';
	}
	else
	{
		$s = 'user_files/';
		$s .= ceil($sid / 3000) . '/';
		$s .= $sid % 3000;
	}
	return $s;
}
function sizeformat($bytesize)
{
	$i=0;
	 //当$bytesize 大于是1024字节时，开始循环，当循环到第4次时跳出；
	while(abs($bytesize) >= 1024){         
		$bytesize	= $bytesize/1024;
		$i++;
		if($i ==4)break;
	}

	//将Bytes,KB,MB,GB,TB定义成一维数组；
	$units		= array("Bytes","KB","MB","GB","TB");
	$newsize	= round($bytesize,2);
	return("$newsize $units[$i]");
}
function get_dir_file($dir)
{
	$handle = @opendir($dir) or die("Cannot open " . $dir); 
	$array	= array();
	while($file = readdir($handle)){
		if($file != "." && $file != ".."){
			$array[]	= $file;
		}
	}
	closedir($handle);
	return $array;
}
function date2time($date,$format=null)
{
	if(!empty($date))
	{
		$date		= trim($date); 
		//$date		= substr($date,0,19);			//2011-09-19 14:53:15
		$year		= substr($date,0,4);//取得年份
		$month		= substr($date,5,2);//取得月份
		$day		= substr($date,8,2);//取得几号 
		$h			= ((int)substr($date,11,2));//取得几号 
		$m			= ((int)substr($date,14,2));//取得几号 
		$s			= ((int)substr($date,17,2));//取得几号
		//echo $year."-".$month."-".$day." ".$h.":".$m.":".$s;die();
		$time		= mktime($h,$m,$s,$month,$day,$year);
		if($format)
		{
			$time		= date('Y-m-d H:i:s',$time);
		}
		return	$time;
	}
}
function make_time($date,$format=null)
{
	$date		= trim($date); 
	//$date		= substr($date,0,19);			//2011-09-19 14:53:15
	$year		= substr($date,0,4);//取得年份
	$month		= substr($date,5,2);//取得月份
	$day		= substr($date,8,2);//取得几号 
	$h			= ((int)substr($date,11,2));//取得几号 
	$m			= ((int)substr($date,14,2));//取得几号 
	$s			= ((int)substr($date,17,2));//取得几号
	//echo $year."-".$month."-".$day." ".$h.":".$m.":".$s;die();
	$time		= mktime($h,$m,$s,$month,$day,$year);
	if($format)
	{
		$time		= date('Y-m-d H:i:s',$time);
	}
	return	$time;
}
/**
 * 重写 URL 地址
 *
 * @access  public
 * @param   string  $act        执行模块
 * @param   array   $params     参数数组
 * @param   string  $actend     附加字串
 * @param   integer $page       页数
 * @param   string  $keywords   搜索关键词字符串
 * @return  void
 */
function rewrite_url($act, $params=array(), $actend = '', $page = 0, $keywords = '', $size = 0)
{
	global $config;
    static $rewrite = NULL;

    if ($rewrite === NULL)
    {
        $rewrite = intval($config['rewrite']);
    }
	//========================================
	$url	= $config['url']."/".$act."/";
	$do		= $params['do'];
	$catid	= $params['catid'];
	$key	= $params['key'];
	$pg		= $params['pg'];
	$id		= $params['id'];
	$region	= $params['region'];
	$userid	= $params['userid'];
	if($key)	$rewrite	= 0;
	if($rewrite)
	{
		if($do)
		{
			if($userid)
				$url	.= $userid.'-'.$do.'-'.$id;
			else
				$url	.= $do;
			if($do=='list')
			{
				if($region)
				{
					$url	.= '-areaid';
				}
				$url .= '-'.$catid;
				$url .= !empty($pg)?'-'.$pg:'';
				$url .= !empty($key)?'-'.$key:'';
			}
		}
		elseif($id)
		{
			$url	.= $id;
			if($pg)
				$url .= '-'.$pg;
		}
		else
		{
			$url	= $act;
		}
		$url	.= '.html';
	}
	else
	{
		if($do)
		{
			if($userid)
				$url	.= "index.php?uid=".$userid.'&act='.$do."&id=".$id;
			else
				$url	.= $do.".php";
			if($do=='list')
			{
				$url .= "?catid=".$catid;
				$url .= !empty($pg)?'&pg='.$pg:'';
				$url .= !empty($key)?'&key='.$key:'';				
			}
		}
		elseif($id)
		{
			if($act=='shop')
				$url.= 'index.php?uid='.$id;
			else
				$url	.= 'detail.php?id='.$id;
			if($pg)
				$url .= '&pg='.$pg;
		}
		else
		{
			$url	= $act.'.php';
		}
	}
	
	/*
    if ($rewrite)
    {
        if ($rewrite == 2 && !empty($actend))
        {
            $url .= '-' . urlencode(preg_replace('/[\.|\/|\?|&|\+|\\\|\'|"|,]+/', '', $actend));
        }
        $url .= '.html';
    }
    if (($rewrite == 2) && (strpos(strtolower(EC_CHARSET), 'utf') !== 0))
    {
        $url = urlencode($url);
    }*/
    return $url;
}

function msg($url="",$str="")
{
	echo "<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\">";
	if($url&&!$str)
		echo "<script>window.location='$url';</script>";
	if(!$url&&$str)
		echo "<script>alert('$str');</script>";
	if($url&&$str)
		echo "<script>alert('$str');window.location='$url';</script>";
	die();
}
function make_array($array=array(),$selected = null,$type = null,$name=null)
{
	$type	= !empty($type)?$type:'s';
	if(is_array($array))
	{
		switch($type)
		{
			case 's':	
			{
				$select	= '';
				foreach($array as $key=>$v)
				{
					$select .= '<option value=\'' . $key . '\'';
					$select .= ($selected == $key&&$selected!='') ? "selected='ture'" : '';
					$select .= '>';
					$select .= $v. '</option>';
				}
				return $select;
				break;
			}
			case 'r':
			{
				$radio	= '';
				$i		= 0;
				foreach($array as $key=>$v)
				{
					$check	= ($selected == $key&&$selected!='') ? "checked='ture'" : '';
					if(empty($check)&&$i==0)
					{
						$check	= " checked='ture'";
					}
					$radio .= '<input type="radio" ';
					$radio .= !empty($name)?"name='".$name."'":'';
					$radio .= $check;
					$radio .= ' value=\'' . $key . '\' style="border:none;"> '.$v.' ';
					$i++;
				}
				return $radio;
				break;
			}
			default:	
				return $array;
				break;
		}
	}
}

/*
function array_list($array,$selected=0,$type=false)
{
	foreach($array as $key=>$v)
	{
		
	}
}*/
/*function cut_arrpre($array=array(),$str="")
{
	if(!empty($str))
	{
		foreach($array as $key=>$v)
		{
			$array[$key][str_replace()]
		}
	}
	
}
*/

/*
 *  中文截取2，单字节截取模式
 */

function my_substr($str, $startdd=0,$slen )
{
	$str = cn_substr(stripslashes($str), $startdd, $slen);
	return addslashes($str);
}

function cn_substr($str, $startdd=0, $slen)
{
	global $cfg_soft_lang;
	if($cfg_soft_lang!=='utf-8')
	{
		return cn_substr_utf8($str, $startdd, $slen);
	}
	$restr = '';
	$c = '';
	$str_len = strlen($str);
	if($str_len < $startdd+1)
	{
		return '';
	}
	if($str_len < $startdd + $slen || $slen==0)
	{
		$slen = $str_len - $startdd;
	}
	$enddd = $startdd + $slen - 1;
	for($i=0;$i<$str_len;$i++)
	{
		if($startdd==0)
		{
			$restr .= $c;
		}
		else if($i > $startdd)
		{
			$restr .= $c;
		}

		if(ord($str[$i])>0x80)
		{
			if($str_len>$i+1)
			{
				$c = $str[$i].$str[$i+1];
			}
			$i++;
		}
		else
		{
			$c = $str[$i];
		}

		if($i >= $enddd)
		{
			if(strlen($restr)+strlen($c)>$slen)
			{
				break;
			}
			else
			{
				$restr .= $c;
				break;
			}
		}
	}
	return $restr;
}

/**
 *  utf-8中文截取，单字节截取模式
 *
 * @access    public
 * @param     string  $str  需要截取的字符串
 * @param     int  $slen  截取的长度
 * @param     int  $startdd  开始标记处
 * @return    string
 */
function cn_substr_utf8($str, $start=0, $length)
{
	if(strlen($str) < $start+1)
	{
		return '';
	}
	preg_match_all("/./su", $str, $ar);
	$str = '';
	$tstr = '';

	//为了兼容mysql4.1以下版本,与数据库varchar一致,这里使用按字节截取
	for($i=0; isset($ar[0][$i]); $i++)
	{
		if(strlen($tstr) < $start)
		{
			$tstr .= $ar[0][$i];
		}
		else
		{
			if(strlen($str) < $length + strlen($ar[0][$i]) )
			{
				$str .= $ar[0][$i];
			}
			else
			{
				break;
			}
		}
	}
	return $str;
}
function convert_ip($ip)
{
	$ip_arr		= explode('.', $ip);
	$ip_arr[3]	= '*';
	$ip			= implode('.', $ip_arr);
	return $ip;
}
function creat_php_file($dir,$filename,$data,$str=null)
{
	$str		= !empty($str)?$str:$filename;	
	$out_str	= "<?php\n\$".$str." = ";
	$out_str	.= is_array($data)?var_export($data,true):$data;
	$out_str	.= ";\n?>";
	$fp			= fopen($dir.'/'.$filename.'.php','w');
	fwrite($fp,$out_str,strlen($out_str));
	fclose($fp);
}
function swap_words($string)
{
	$words_file	= ROOT_PATH.'/data/config/words_config.php';
	if(file_exists($words_file))
	{
		include($words_file);
		$str	= strtr($string, $swap_words);
		return $str;
	}
	else
	{
		return $string;
	}
}
function RandStr($mode=0,$length=10)
{
	switch ($mode) {
		case '1':	$str = '1234567890';	break;
		case '2':	$str = 'abcdefghijklmnopqrstuvwxyz';	break;
		case '4':	$str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';	break;
		default:	$str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';	break;
	}
	$l		= strlen($str);
	for($i = 0;$i < $length;$i ++){
		$num = rand(0, $l);
		$name .= $str[$num];
	}
	return $name;
}

?>