<?php
/*
 * ============================================================================
 * [SmartB2B] (C) 2009-2012 SmartB2B Inc.
 * Home page: http://www.smartb2b.net；
 * ============================================================================
 * $Author: liclny $
 * $Id: lib_post.php 16881 2009年10月27日 8:22:43Z liclny $
*/

if(!defined('IN_SMARTB2B')) {
	exit('Access attempt!');
}

function down_remote($content,$path, $ext = 'jpg|jpeg|gif|png|bmp')
{
	global	$config;
	if(empty($content))	return $content;
	if(!preg_match_all("/src=([\"|']?)([^ \"'>]+\.($ext))\\1/i", $content, $matches)) return $content;
	require_once(ROOT_PATH."include/lib_file.php");
	$rel_path	= $path.date('Y/m');
	$file_path	= DATA_PATH.$rel_path;
	$new_path	= $config['data_url'].$rel_path;
	foreach($matches[2] as $k=>$url)
	{
		$filename	= time().rand(100, 999).".".get_ext($url);
		$new_url	= $new_path.'/'.$filename;
		$newfile	= $file_path.'/'.$filename;
		if(copy_file($url, $newfile)) 
		{
			if(is_image($newfile)) {
				if(!@getimagesize($newfile)) {
					@unlink($newfile);
					continue;
				}
			}
			$content	= str_replace($url,$new_url,$content);
		}
	}
	unset($matches);
	return $content;
}
function save_thumb($content,$path, $width = 100, $height = 100)
{
	if(!$content) return null;
	$ext = 'jpg|jpeg|gif|png|bmp';
	if(!preg_match_all("/src=([\"|']?)([^ \"'>]+\.($ext))\\1/i", $content, $matches)) return null;
	require_once(ROOT_PATH."include/lib_file.php");
	$rel_path	= $path.date('Y/m');
	$file_path	= DATA_PATH.$rel_path;
	$new_path	= $rel_path;
	foreach($matches[2] as $k=>$url)
	{
		if($k == 0)
		{
			$filename	= time().rand(100, 999).".".get_ext($url);
			$new_url	= $new_path.'/'.$filename;
			$bigImg		= $file_path.'/'.$filename;
			if(copy_file($url, $bigImg)) 
			{
				
				if(is_image($bigImg)) {
					if(!@getimagesize($bigImg)) {
						@unlink($bigImg);
						return null;
					}
					require_once(ROOT_PATH."include/lib_image.php");
					$filename	= time().rand(100, 999).".".get_ext($url);
					$smallImg	= $file_path.'/'.$filename;
					make_thumb($bigImg,$smallImg,$width,$height,1);
					@unlink($bigImg);
					$thumb_name	= date('Y/m/').$filename;
					return $thumb_name;
				}				
			}
		}
	}
	unset($matches);
	return null;
}
function get_img_url($content)
{
	if(!$content) return null;
	$ext = 'jpg|jpeg|gif|png|bmp';
	if(!preg_match_all("/src=([\"|']?)([^ \"'>]+\.($ext))\\1/i", $content, $matches)) return null;
	require_once(ROOT_PATH."include/lib_file.php");
	foreach($matches[2] as $k=>$url)
	{
		if(is_image($url))
		{
			return $url;
		}
	}
	unset($matches);
	return null;
}
/**
 *  删除非站内链接
 *
 * @access    public
 * @param     string  $body  内容
 * @param     array  $allow_urls  允许的超链接
 * @return    string
 */
function del_links( &$body, $allow_urls=array()  )
{
    $host_rule = join('|', $allow_urls);
    $host_rule = preg_replace("#[\n\r]#", '', $host_rule);
    $host_rule = str_replace('.', "\\.", $host_rule);
    $host_rule = str_replace('/', "\\/", $host_rule);
    $arr = '';
    preg_match_all("#<a([^>]*)>(.*)<\/a>#iU", $body, $arr);
    if( is_array($arr[0]) )
    {
        $rparr = array();
        $tgarr = array();
        foreach($arr[0] as $i=>$v)
        {
            if( $host_rule != '' && preg_match('#'.$host_rule.'#i', $arr[1][$i]) )
            {
                continue;
            } else {
                $rparr[] = $v;
                $tgarr[] = $arr[2][$i];
            }
        }
        if( !empty($rparr) )
        {
            $body = str_replace($rparr, $tgarr, $body);
        }
    }
    $arr = $rparr = $tgarr = '';
    return $body;
}

?>