<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {html_select_num} function plugin
 *
 * Type:     function<br>
 * Name:     html_select_num<br>
 * Purpose:  Prints the dropdowns for time selection
 * @link http://smarty.php.net/manual/en/language.function.html.select.time.php {html_select_num}
 *          (Smarty online manual)
 * @author Roberto Berto <roberto@berto.net>
 * @credits Monte Ohrt <monte AT ohrt DOT com>
 * @param array
 * @param Smarty
 * @return string
 * @uses smarty_make_timestamp()
 */
function smarty_function_html_select_num($params, &$smarty)
{
    require_once $smarty->_get_plugin_filepath('shared','make_timestamp');
    require_once $smarty->_get_plugin_filepath('function','html_options');
    /* Default values. */
	$name		= $params['name'];
	$first		= $params['first'];
	$selected	= $params['selected'];
	$min		= !empty($params['min'])?$params['min']:'0';
	$max		= !empty($params['max'])?$params['max']:'100';
	$max		= ($max=='date')?date('Y'):$max;
	$add		= !empty($params['add'])?$params['add']:'1';
	
	if($min<$max)
	{
		$options	= null;
		if(!empty($first))
		{
			$options	.= "<option value=\"\">".$first."</option>";
		}
		for($i=$min;$i<=$max;$i=$i+$add)
		{
			$options	.= "<option value=\"".$i."\"";
			if(!empty($selected)&&$selected==$i)
			{
				$options	.= " selected=\"true\"";
			}
			$options	.= ">".$i."</option>";
		}
	}
	$select		= "<select name=\"".$name."\" id=\"".$name."\">";
	$select		.= $options;
	$select		.= "</select>";

    $html_result = $select;   

    return $html_result;
}

/* vim: set expandtab: */

?>
