<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

/**
 * Smarty {config_load} function plugin
 *
 * Type:     function<br>
 * Name:     config_load<br>
 * Purpose:  load config file vars
 * @link http://smarty.php.net/manual/en/language.function.config.load.php {config_load}
 *       (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @author messju mohr <messju at lammfellpuschen dot de> (added use of resources)
 * @param array Format:
 * <pre>
 * array('file' => required config file name,
 *       'section' => optional config file section to load
 *       'scope' => local/parent/global
 *       'global' => overrides scope, setting to parent if true)
 * </pre>
 * @param Smarty
 */
function smarty_function_tag($params, &$smarty)
{
	global $tpl,$config;
	$file		= array_shift(explode('_',$params['name']));
	$fun		= $params['name'];	
	$temp_dir	= $tpl -> template_dir;
	if(file_exists(ROOT_PATH."module/".$file.'/include/tags/'.$file.'.lib.php'))
	{
		require_once(ROOT_PATH."module/".$file.'/include/tags/'.$file.'.lib.php');
	}
	else
	{
		require_once(ROOT_PATH.'include/tags/'.$file.'.lib.php');
	}
	$tpl->caching			= true;
	$tpl -> template_dir    = ROOT_PATH."/theme/".$config['temp']."/tags";
    $content	= $fun($params);
	$tpl -> template_dir	= $temp_dir;
	return $content;
}
?>
