-- --------------------------------------------------
--
-- SmartB2B SQL File for installation
-- $Id: SmartB2B.sql by liclny $
--
-- --------------------------------------------------

DROP TABLE IF EXISTS smartb2b_admin;
CREATE TABLE `smartb2b_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` mediumint(5) NOT NULL,
  `user` char(30) NOT NULL DEFAULT '',
  `pass` char(32) NOT NULL DEFAULT '',
  `name` char(20) NOT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT '0',
  `email` char(30) NOT NULL,
  `tel` varchar(20) NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `login_num` mediumint(8) NOT NULL,
  `is_enable` tinyint(1) NOT NULL DEFAULT '1',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `last_login` int(10) unsigned NOT NULL DEFAULT '0',
  `last_ip` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='系统管理员';


DROP TABLE IF EXISTS smartb2b_admin_group;
CREATE TABLE `smartb2b_admin_group` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `desc` varchar(255) NOT NULL,
  `access` text NOT NULL,
  `is_enable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员组';

INSERT INTO smartb2b_admin_group VALUES('1','超级管理员','网站创建人','','1');
INSERT INTO smartb2b_admin_group VALUES('2','普通管理员','普通管理员角色','','1');

DROP TABLE IF EXISTS smartb2b_ads;
CREATE TABLE `smartb2b_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `posid` mediumint(3) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `author` varchar(30) NOT NULL DEFAULT '',
  `stime` int(10) unsigned NOT NULL DEFAULT '0',
  `etime` int(10) unsigned NOT NULL DEFAULT '0',
  `no_limit` tinyint(1) NOT NULL DEFAULT '0',
  `ad_code` text NOT NULL,
  `ad_txt` varchar(100) NOT NULL DEFAULT '',
  `ad_url` varchar(255) NOT NULL DEFAULT '',
  `ad_alt` varchar(100) NOT NULL DEFAULT '',
  `ad_src` varchar(255) NOT NULL DEFAULT '',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COMMENT='广告表';

INSERT INTO smartb2b_ads VALUES('1','1','图1','100.00','8','1324971710','admin','1324944000','1577836800','0','','','http://www.smartb2b.net','','20120220145857484.jpg','1');
INSERT INTO smartb2b_ads VALUES('2','1','图2','0.00','0','1311127464','admin','1262217600','1577836800','0','','','http://www.smartb2b.net/bbs','','20120220145902568.jpg','1');
INSERT INTO smartb2b_ads VALUES('3','1','图3','0.00','1','1311127464','admin','1262217600','1577836800','0','','','http://www.smartb2b.net','smartb2b','20120220145908593.jpg','1');
INSERT INTO smartb2b_ads VALUES('32','29','需要','0.00','0','1331691391','admin','1331683200','0','1','','','http://www.smartb2b.net','smartb2b','20120314021631280.jpg','1');
INSERT INTO smartb2b_ads VALUES('6','2','首页旗帜A3','0.00','0','1311127464','admin','1262217600','1577836800','0','','','http://www.smartb2b.net','贸易技巧','20120229131058368.jpg','1');
INSERT INTO smartb2b_ads VALUES('28','5','首页','0.00','0','1330521611','admin','1330473600','0','1','','','http://www.smartb2b.net','','20120314032126200.jpg','1');
INSERT INTO smartb2b_ads VALUES('29','6','SmartB2B','0.00','0','1331689580','admin','1331683200','0','1','','','http://www.smartb2b.net','SmartB2B','20120314032348517.jpg','1');
INSERT INTO smartb2b_ads VALUES('30','7','ssssss','0.00','0','1331690044','admin','1331683200','0','1','','','http://www.smartb2b.net','smartb2b','20120314032650576.jpg','1');
INSERT INTO smartb2b_ads VALUES('12','4','文章模块详情A1','200.00','0','0','admin','1320681600','1323273600','0','','','http://localhost/cms/','文章广告代码','20110926181807754.jpg','1');
INSERT INTO smartb2b_ads VALUES('13','4','文章模块','1200.00','0','1317032593','admin','1316966400','1348848000','0','','','http://www.baiu.com','广告A5','20111127174124296.jpg','1');
INSERT INTO smartb2b_ads VALUES('14','4','代码广告','0.00','0','1317115688','admin','1317052800','1327939200','0','','','http://www.fdsfdas.com','高尔夫','20111129093354658.jpg','1');
INSERT INTO smartb2b_ads VALUES('31','8','ssdd','0.00','0','1331690344','admin','1331683200','0','1','','','http://www.smartb2b.net','smartb2b','20120314021116710.jpg','1');
INSERT INTO smartb2b_ads VALUES('33','30','sfdsa','0.00','0','1331708069','admin','1331683200','0','1','','','http://www.smartb2b.net','','20120314065429329.jpg','1');
INSERT INTO smartb2b_ads VALUES('34','30','1341234','0.00','0','1331708241','admin','1331683200','0','1','','','http://www.smartb2b.net','','20120314065721476.jpg','1');
INSERT INTO smartb2b_ads VALUES('35','30','fdsa','0.00','0','1331708394','admin','1331683200','0','1','','','http://www.smartb2b.net','sdsdf','20120314065954121.jpg','1');

DROP TABLE IF EXISTS smartb2b_ads_pos;
CREATE TABLE `smartb2b_ads_pos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(5) NOT NULL DEFAULT 'i',
  `name` varchar(50) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL,
  `width` smallint(5) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `num` smallint(4) unsigned NOT NULL DEFAULT '0',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `author` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='广告位';

INSERT INTO smartb2b_ads_pos VALUES('1','f','首页图片轮播','首页中心幻灯片轮播','440','190','100.00','3','1311127464','admin');
INSERT INTO smartb2b_ads_pos VALUES('2','i','网站首页横幅980_60','','980','90','500.00','1','1311127464','admin');
INSERT INTO smartb2b_ads_pos VALUES('5','i','商城首页A1','','980','90','0.00','1','1311127464','admin');
INSERT INTO smartb2b_ads_pos VALUES('6','i','供求980_90','','980','90','0.00','1','1311127464','admin');
INSERT INTO smartb2b_ads_pos VALUES('7','i','公司首页710_90','','710','90','0.00','1','1311127464','admin');
INSERT INTO smartb2b_ads_pos VALUES('8','i','公司首页260_150','','260','150','0.00','1','1311127464','admin');
INSERT INTO smartb2b_ads_pos VALUES('29','i','资讯首页','','980','90','0.00','1','1331691369','admin');
INSERT INTO smartb2b_ads_pos VALUES('30','f','商城首页FLASH','','440','230','0.00','3','1331707923','admin');



DROP TABLE IF EXISTS smartb2b_album;
CREATE TABLE `smartb2b_album` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL,
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `num` mediumint(5) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `hits` mediumint(8) NOT NULL,
  `open` tinyint(1) unsigned NOT NULL DEFAULT '3',
  `password` varchar(30) NOT NULL DEFAULT '',
  `question` varchar(30) NOT NULL DEFAULT '',
  `answer` varchar(30) NOT NULL DEFAULT '',
  `sort` mediumint(3) NOT NULL,
  `add_time` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='图库';

DROP TABLE IF EXISTS smartb2b_album_cat;
CREATE TABLE `smartb2b_album_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=117 DEFAULT CHARSET=utf8 COMMENT='图库分类';

INSERT INTO smartb2b_album_cat VALUES('103','会员相册','0','','','0','','0','0');
INSERT INTO smartb2b_album_cat VALUES('104','产品图片','0','','','2','','0','1');
INSERT INTO smartb2b_album_cat VALUES('105','人物','0','','','2','','0','1');
INSERT INTO smartb2b_album_cat VALUES('106','风景','0','','','2','','0','1');
INSERT INTO smartb2b_album_cat VALUES('107','生活','0','','','1','','0','1');
INSERT INTO smartb2b_album_cat VALUES('108','旅行','0','','','1','','0','1');
INSERT INTO smartb2b_album_cat VALUES('110','壁纸','0','','','1','','0','1');

DROP TABLE IF EXISTS smartb2b_album_photo;
CREATE TABLE `smartb2b_album_photo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `name` varchar(20) NOT NULL,
  `img` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `is_cover` tinyint(1) NOT NULL,
  `add_time` int(11) unsigned NOT NULL,
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 COMMENT='产品图片';


DROP TABLE IF EXISTS smartb2b_area;
CREATE TABLE `smartb2b_area` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=3798 DEFAULT CHARSET=utf8 COMMENT='地区分类';

INSERT INTO smartb2b_area VALUES('1','Angola 安哥拉','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2','Afghanistan 阿富汗','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3','Albania 阿尔巴尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('4','Algeria 阿尔及利亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('5','Andorra 安道尔共和国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('6','Anguilla 安圭拉岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('7','Antigua and Barbuda 安提瓜和巴布达','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('8','Argentina 阿根廷','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('9','Armenia 亚美尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('10','Ascension 阿森松','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('11','Australia 澳大利亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('12','Austria 奥地利','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('13','Azerbaijan 阿塞拜疆','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('14','Bahamas 巴哈马','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('15','Bahrain 巴林','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('16','Bangladesh 孟加拉国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('17','Barbados 巴巴多斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('18','Belarus 白俄罗斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('19','Belgium 比利时','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('20','Belize 伯利兹','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('21','Benin 贝宁','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('22','BermudaIs. 百慕大群岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('23','Bolivia 玻利维亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('24','Botswana 博茨瓦纳','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('25','Brazil 巴西','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('26','Brunei 文莱','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('27','Bulgaria 保加利亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('28','Burkina-faso 布基纳法索','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('29','Burma 缅甸','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('30','Burundi 布隆迪','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('31','Cameroon 喀麦隆','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('32','Canada 加拿大','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('33','Cayman Is. 开曼群岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('34','Central African Republic 中非共和国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('35','Chad 乍得','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('36','Chile 智利','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('37','China 中国','0','','','','','-1','1');
INSERT INTO smartb2b_area VALUES('38','Colombia 哥伦比亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('39','Congo 刚果','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('40','Cook Is. 库克群岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('41','Costa Rica 哥斯达黎加','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('42','Cuba 古巴','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('43','Cyprus 塞浦路斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('44','Czech Republic 捷克','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('45','Denmark 丹麦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('46','Djibouti 吉布提','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('47','Dominica Rep. 多米尼加共和国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('48','Ecuador 厄瓜多尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('49','Egypt 埃及','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('50','EISalvador 萨尔瓦多','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('51','Estonia 爱沙尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('52','Ethiopia 埃塞俄比亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('53','Fiji 斐济','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('54','Finland 芬兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('55','France 法国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('56','French Guiana 法属圭亚那','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('57','Gabon 加蓬','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('58','Gambia 冈比亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('59','Georgia 格鲁吉亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('60','Germany 德国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('61','Ghana 加纳','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('62','Gibraltar 直布罗陀','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('63','Greece 希腊','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('64','Grenada 格林纳达','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('65','Guam 关岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('66','Guatemala 危地马拉','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('67','Guinea 几内亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('68','Guyana 圭亚那','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('69','Haiti 海地','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('70','Honduras 洪都拉斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('71','Hongkong 香港','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('72','Hungary 匈牙利','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('73','Iceland 冰岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('74','India 印度','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('75','Indonesia 印度尼西亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('76','Iran 伊朗','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('77','Iraq 伊拉克','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('78','Ireland 爱尔兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('79','Israel 以色列','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('80','Italy 意大利','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('81','IvoryCoast 科特迪瓦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('82','Jamaica 牙买加','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('83','Japan 日本','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('84','Jordan 约旦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('85','Kampuchea (Cambodia ) 柬埔寨','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('86','Kazakstan 哈萨克斯坦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('87','Kenya 肯尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('88','Korea 韩国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('89','Kuwait 科威特','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('90','Kyrgyzstan 吉尔吉斯坦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('91','Laos 老挝','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('92','Latvia 拉脱维亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('93','Lebanon 黎巴嫩','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('94','Lesotho 莱索托','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('95','Liberia 利比里亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('96','Libya 利比亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('97','Liechtenstein 列支敦士登','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('98','Lithuania 立陶宛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('99','Luxembourg 卢森堡','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('100','Madagascar 马达加斯加','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('101','Malawi 马拉维','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('102','Malaysia 马来西亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('103','Maldives 马尔代夫','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('104','Mali 马里','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('105','Malta 马耳他','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('106','Mariana Is 马里亚那群岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('107','Martinique 马提尼克','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('108','Mauritius 毛里求斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('109','Mexico 墨西哥','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('110','Moldova, Republic of 摩尔多瓦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('111','Monaco 摩纳哥','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('112','Mongolia 蒙古','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('113','Montserrat Is 蒙特塞拉特岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('114','Morocco 摩洛哥','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('115','Mozambique 莫桑比克','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('116','Namibia 纳米比亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('117','Nauru 瑙鲁','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('118','Nepal 尼泊尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('119','Netheriands Antilles 荷属安的列斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('120','Netherlands 荷兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('121','NewZealand 新西兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('122','Nicaragua 尼加拉瓜','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('123','Niger 尼日尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('124','Nigeria 尼日利亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('125','North Korea 朝鲜','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('126','Norway 挪威','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('127','Oman 阿曼','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('128','Pakistan 巴基斯坦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('129','Panama 巴拿马','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('130','Papua New Cuinea 巴布亚新几内亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('131','Paraguay 巴拉圭','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('132','Peru 秘鲁','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('133','Philippines 菲律宾','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('134','Poland 波兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('135','French Polynesia 法属玻利尼西亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('136','Portugal 葡萄牙','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('137','PuertoRico 波多黎各','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('138','Qatar 卡塔尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('139','Reunion 留尼旺','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('140','Romania 罗马尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('141','Russia 俄罗斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('142','Saint Lueia 圣卢西亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('143','Saint Vincent 圣文森特岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('144','Samoa Eastern 东萨摩亚(美)','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('145','Samoa Western 西萨摩亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('146','San Marino 圣马力诺','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('147','Sao Tome and Principe 圣多美和普林西比','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('148','Saudi Arabia 沙特阿拉伯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('149','Senegal 塞内加尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('150','Seychelles 塞舌尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('151','Sierra Leone 塞拉利昂','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('152','Singapore 新加坡','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('153','Slovakia 斯洛伐克','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('154','Slovenia 斯洛文尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('155','Solomon Is 所罗门群岛','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('156','Somali 索马里','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('157','South Africa 南非','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('158','Spain 西班牙','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('159','Sri Lanka 斯里兰卡','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('160','St.Lucia 圣卢西亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('161','St.Vincent 圣文森特','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('162','Sudan 苏丹','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('163','Suriname 苏里南','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('164','Swaziland 斯威士兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('165','Sweden 瑞典','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('166','Switzerland 瑞士','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('167','Syria 叙利亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('168','Taiwan 台湾省','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('169','Tajikstan 塔吉克斯坦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('170','Tanzania 坦桑尼亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('171','Thailand 泰国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('172','Togo 多哥','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('173','Tonga 汤加','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('174','Trinidad and Tobago 特立尼达和多巴哥','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('175','Tunisia 突尼斯','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('176','Turkey 土耳其','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('177','Turkmenistan 土库曼斯坦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('178','Uganda 乌干达','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('179','Ukraine 乌克兰','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('180','United Arab Emirates 阿拉伯联合酋长国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('181','United Kiongdom 英国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('182','United States of America 美国','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('183','Uruguay 乌拉圭','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('184','Uzbekistan 乌兹别克斯坦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('185','Venezuela 委内瑞拉','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('186','Vietnam 越南','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('187','Yemen 也门','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('188','Yugoslavia 南斯拉夫','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('189','Zimbabwe 津巴布韦','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('190','Zaire 扎伊尔','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('191','Zambia 赞比亚','0','','','','','0','1');
INSERT INTO smartb2b_area VALUES('200','北京','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('201','安徽','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('202','福建','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('203','甘肃','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('204','广东','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('205','广西','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('206','贵州','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('207','海南','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('208','河北','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('209','河南','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('210','黑龙江','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('211','湖北','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('212','湖南','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('213','吉林','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('214','江苏','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('215','江西','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('216','辽宁','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('217','内蒙古','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('218','宁夏','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('219','青海','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('220','山东','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('221','山西','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('222','陕西','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('223','上海','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('224','四川','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('225','天津','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('226','西藏','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('227','新疆','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('228','云南','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('229','浙江','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('230','重庆','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('231','香港','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('232','澳门','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('233','台湾','37','','','','','0','1');
INSERT INTO smartb2b_area VALUES('234','安庆','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('235','蚌埠','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('236','巢湖','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('237','池州','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('238','滁州','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('239','阜阳','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('240','淮北','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('241','淮南','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('242','黄山','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('243','六安','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('244','马鞍山','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('245','宿州','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('246','铜陵','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('247','芜湖','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('248','宣城','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('249','亳州','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('250','北京','200','','','','','0','1');
INSERT INTO smartb2b_area VALUES('251','福州','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('252','龙岩','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('253','南平','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('254','宁德','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('255','莆田','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('256','泉州','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('257','三明','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('258','厦门','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('259','漳州','202','','','','','0','1');
INSERT INTO smartb2b_area VALUES('260','兰州','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('261','白银','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('262','定西','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('263','甘南','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('264','嘉峪关','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('265','金昌','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('266','酒泉','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('267','临夏','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('268','陇南','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('269','平凉','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('270','庆阳','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('271','天水','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('272','武威','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('273','张掖','203','','','','','0','1');
INSERT INTO smartb2b_area VALUES('274','广州','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('275','深圳','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('276','潮州','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('277','东莞','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('278','佛山','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('279','河源','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('280','惠州','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('281','江门','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('282','揭阳','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('283','茂名','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('284','梅州','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('285','清远','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('286','汕头','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('287','汕尾','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('288','韶关','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('289','阳江','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('290','云浮','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('291','湛江','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('292','肇庆','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('293','中山','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('294','珠海','204','','','','','0','1');
INSERT INTO smartb2b_area VALUES('295','南宁','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('296','桂林','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('297','百色','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('298','北海','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('299','崇左','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('300','防城港','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('301','贵港','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('302','河池','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('303','贺州','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('304','来宾','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('305','柳州','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('306','钦州','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('307','梧州','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('308','玉林','205','','','','','0','1');
INSERT INTO smartb2b_area VALUES('309','贵阳','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('310','安顺','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('311','毕节','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('312','六盘水','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('313','黔东南','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('314','黔南','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('315','黔西南','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('316','铜仁','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('317','遵义','206','','','','','0','1');
INSERT INTO smartb2b_area VALUES('318','海口','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('319','三亚','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('320','白沙','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('321','保亭','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('322','昌江','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('323','澄迈县','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('324','定安县','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('325','东方','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('326','乐东','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('327','临高县','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('328','陵水','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('329','琼海','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('330','琼中','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('331','屯昌县','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('332','万宁','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('333','文昌','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('334','五指山','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('335','儋州','207','','','','','0','1');
INSERT INTO smartb2b_area VALUES('336','石家庄','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('337','保定','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('338','沧州','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('339','承德','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('340','邯郸','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('341','衡水','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('342','廊坊','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('343','秦皇岛','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('344','唐山','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('345','邢台','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('346','张家口','208','','','','','0','1');
INSERT INTO smartb2b_area VALUES('347','郑州','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('348','洛阳','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('349','开封','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('350','安阳','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('351','鹤壁','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('352','济源','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('353','焦作','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('354','南阳','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('355','平顶山','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('356','三门峡','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('357','商丘','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('358','新乡','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('359','信阳','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('360','许昌','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('361','周口','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('362','驻马店','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('363','漯河','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('364','濮阳','209','','','','','0','1');
INSERT INTO smartb2b_area VALUES('365','哈尔滨','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('366','大庆','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('367','大兴安岭','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('368','鹤岗','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('369','黑河','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('370','鸡西','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('371','佳木斯','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('372','牡丹江','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('373','七台河','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('374','齐齐哈尔','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('375','双鸭山','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('376','绥化','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('377','伊春','210','','','','','0','1');
INSERT INTO smartb2b_area VALUES('378','武汉','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('379','仙桃','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('380','鄂州','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('381','黄冈','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('382','黄石','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('383','荆门','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('384','荆州','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('385','潜江','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('386','神农架林区','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('387','十堰','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('388','随州','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('389','天门','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('390','咸宁','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('391','襄樊','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('392','孝感','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('393','宜昌','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('394','恩施','211','','','','','0','1');
INSERT INTO smartb2b_area VALUES('395','长沙','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('396','张家界','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('397','常德','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('398','郴州','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('399','衡阳','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('400','怀化','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('401','娄底','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('402','邵阳','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('403','湘潭','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('404','湘西','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('405','益阳','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('406','永州','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('407','岳阳','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('408','株洲','212','','','','','0','1');
INSERT INTO smartb2b_area VALUES('409','长春','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('410','吉林','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('411','白城','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('412','白山','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('413','辽源','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('414','四平','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('415','松原','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('416','通化','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('417','延边','213','','','','','0','1');
INSERT INTO smartb2b_area VALUES('418','南京','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('419','苏州','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('420','无锡','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('421','常州','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('422','淮安','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('423','连云港','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('424','南通','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('425','宿迁','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('426','泰州','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('427','徐州','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('428','盐城','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('429','扬州','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('430','镇江','214','','','','','0','1');
INSERT INTO smartb2b_area VALUES('431','南昌','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('432','抚州','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('433','赣州','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('434','吉安','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('435','景德镇','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('436','九江','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('437','萍乡','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('438','上饶','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('439','新余','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('440','宜春','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('441','鹰潭','215','','','','','0','1');
INSERT INTO smartb2b_area VALUES('442','沈阳','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('443','大连','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('444','鞍山','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('445','本溪','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('446','朝阳','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('447','丹东','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('448','抚顺','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('449','阜新','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('450','葫芦岛','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('451','锦州','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('452','辽阳','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('453','盘锦','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('454','铁岭','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('455','营口','216','','','','','0','1');
INSERT INTO smartb2b_area VALUES('456','呼和浩特','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('457','阿拉善盟','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('458','巴彦淖尔盟','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('459','包头','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('460','赤峰','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('461','鄂尔多斯','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('462','呼伦贝尔','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('463','通辽','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('464','乌海','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('465','乌兰察布市','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('466','锡林郭勒盟','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('467','兴安盟','217','','','','','0','1');
INSERT INTO smartb2b_area VALUES('468','银川','218','','','','','0','1');
INSERT INTO smartb2b_area VALUES('469','固原','218','','','','','0','1');
INSERT INTO smartb2b_area VALUES('470','石嘴山','218','','','','','0','1');
INSERT INTO smartb2b_area VALUES('471','吴忠','218','','','','','0','1');
INSERT INTO smartb2b_area VALUES('472','中卫','218','','','','','0','1');
INSERT INTO smartb2b_area VALUES('473','西宁','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('474','果洛','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('475','海北','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('476','海东','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('477','海南','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('478','海西','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('479','黄南','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('480','玉树','219','','','','','0','1');
INSERT INTO smartb2b_area VALUES('481','济南','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('482','青岛','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('483','滨州','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('484','德州','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('485','东营','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('486','菏泽','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('487','济宁','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('488','莱芜','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('489','聊城','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('490','临沂','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('491','日照','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('492','泰安','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('493','威海','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('494','潍坊','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('495','烟台','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('496','枣庄','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('497','淄博','220','','','','','0','1');
INSERT INTO smartb2b_area VALUES('498','太原','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('499','长治','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('500','大同','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('501','晋城','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('502','晋中','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('503','临汾','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('504','吕梁','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('505','朔州','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('506','忻州','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('507','阳泉','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('508','运城','221','','','','','0','1');
INSERT INTO smartb2b_area VALUES('509','西安','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('510','安康','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('511','宝鸡','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('512','汉中','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('513','商洛','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('514','铜川','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('515','渭南','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('516','咸阳','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('517','延安','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('518','榆林','222','','','','','0','1');
INSERT INTO smartb2b_area VALUES('519','上海','223','','','','','0','1');
INSERT INTO smartb2b_area VALUES('520','成都','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('521','绵阳','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('522','阿坝','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('523','巴中','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('524','达州','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('525','德阳','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('526','甘孜','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('527','广安','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('528','广元','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('529','乐山','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('530','凉山','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('531','眉山','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('532','南充','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('533','内江','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('534','攀枝花','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('535','遂宁','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('536','雅安','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('537','宜宾','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('538','资阳','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('539','自贡','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('540','泸州','224','','','','','0','1');
INSERT INTO smartb2b_area VALUES('541','天津','225','','','','','0','1');
INSERT INTO smartb2b_area VALUES('542','拉萨','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('543','阿里','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('544','昌都','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('545','林芝','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('546','那曲','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('547','日喀则','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('548','山南','226','','','','','0','1');
INSERT INTO smartb2b_area VALUES('549','乌鲁木齐','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('550','阿克苏','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('551','阿拉尔','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('552','巴音郭楞','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('553','博尔塔拉','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('554','昌吉','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('555','哈密','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('556','和田','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('557','喀什','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('558','克拉玛依','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('559','克孜勒苏','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('560','石河子','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('561','图木舒克','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('562','吐鲁番','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('563','五家渠','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('564','伊犁','227','','','','','0','1');
INSERT INTO smartb2b_area VALUES('565','昆明','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('566','怒江','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('567','普洱','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('568','丽江','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('569','保山','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('570','楚雄','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('571','大理','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('572','德宏','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('573','迪庆','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('574','红河','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('575','临沧','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('576','曲靖','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('577','文山','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('578','西双版纳','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('579','玉溪','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('580','昭通','228','','','','','0','1');
INSERT INTO smartb2b_area VALUES('581','杭州','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('582','湖州','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('583','嘉兴','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('584','金华','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('585','丽水','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('586','宁波','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('587','绍兴','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('588','台州','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('589','温州','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('590','舟山','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('591','衢州','229','','','','','0','1');
INSERT INTO smartb2b_area VALUES('592','重庆','230','','','','','0','1');
INSERT INTO smartb2b_area VALUES('593','香港','231','','','','','0','1');
INSERT INTO smartb2b_area VALUES('594','澳门','232','','','','','0','1');
INSERT INTO smartb2b_area VALUES('595','台湾','233','','','','','0','1');
INSERT INTO smartb2b_area VALUES('596','迎江区','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('597','大观区','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('598','宜秀区','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('599','桐城市','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('600','怀宁县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('601','枞阳县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('602','潜山县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('603','太湖县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('604','宿松县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('605','望江县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('606','岳西县','234','','','','','0','1');
INSERT INTO smartb2b_area VALUES('607','中市区','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('608','东市区','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('609','西市区','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('610','郊区','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('611','怀远县','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('612','五河县','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('613','固镇县','235','','','','','0','1');
INSERT INTO smartb2b_area VALUES('614','居巢区','236','','','','','0','1');
INSERT INTO smartb2b_area VALUES('615','庐江县','236','','','','','0','1');
INSERT INTO smartb2b_area VALUES('616','无为县','236','','','','','0','1');
INSERT INTO smartb2b_area VALUES('617','含山县','236','','','','','0','1');
INSERT INTO smartb2b_area VALUES('618','和县','236','','','','','0','1');
INSERT INTO smartb2b_area VALUES('619','贵池区','237','','','','','0','1');
INSERT INTO smartb2b_area VALUES('620','东至县','237','','','','','0','1');
INSERT INTO smartb2b_area VALUES('621','石台县','237','','','','','0','1');
INSERT INTO smartb2b_area VALUES('622','青阳县','237','','','','','0','1');
INSERT INTO smartb2b_area VALUES('623','琅琊区','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('624','南谯区','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('625','天长市','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('626','明光市','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('627','来安县','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('628','全椒县','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('629','定远县','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('630','凤阳县','238','','','','','0','1');
INSERT INTO smartb2b_area VALUES('631','蚌山区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('632','龙子湖区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('633','禹会区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('634','淮上区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('635','颍州区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('636','颍东区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('637','颍泉区','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('638','界首市','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('639','临泉县','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('640','太和县','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('641','阜南县','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('642','颖上县','239','','','','','0','1');
INSERT INTO smartb2b_area VALUES('643','相山区','240','','','','','0','1');
INSERT INTO smartb2b_area VALUES('644','杜集区','240','','','','','0','1');
INSERT INTO smartb2b_area VALUES('645','烈山区','240','','','','','0','1');
INSERT INTO smartb2b_area VALUES('646','濉溪县','240','','','','','0','1');
INSERT INTO smartb2b_area VALUES('647','田家庵区','241','','','','','0','1');
INSERT INTO smartb2b_area VALUES('648','大通区','241','','','','','0','1');
INSERT INTO smartb2b_area VALUES('649','谢家集区','241','','','','','0','1');
INSERT INTO smartb2b_area VALUES('650','八公山区','241','','','','','0','1');
INSERT INTO smartb2b_area VALUES('651','潘集区','241','','','','','0','1');
INSERT INTO smartb2b_area VALUES('652','凤台县','241','','','','','0','1');
INSERT INTO smartb2b_area VALUES('653','屯溪区','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('654','黄山区','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('655','徽州区','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('656','歙县','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('657','休宁县','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('658','黟县','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('659','祁门县','242','','','','','0','1');
INSERT INTO smartb2b_area VALUES('660','金安区','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('661','裕安区','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('662','寿县','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('663','霍邱县','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('664','舒城县','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('665','金寨县','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('666','霍山县','243','','','','','0','1');
INSERT INTO smartb2b_area VALUES('667','雨山区','244','','','','','0','1');
INSERT INTO smartb2b_area VALUES('668','花山区','244','','','','','0','1');
INSERT INTO smartb2b_area VALUES('669','金家庄区','244','','','','','0','1');
INSERT INTO smartb2b_area VALUES('670','当涂县','244','','','','','0','1');
INSERT INTO smartb2b_area VALUES('671','埇桥区','245','','','','','0','1');
INSERT INTO smartb2b_area VALUES('672','砀山县','245','','','','','0','1');
INSERT INTO smartb2b_area VALUES('673','萧县','245','','','','','0','1');
INSERT INTO smartb2b_area VALUES('674','灵璧县','245','','','','','0','1');
INSERT INTO smartb2b_area VALUES('675','泗县','245','','','','','0','1');
INSERT INTO smartb2b_area VALUES('676','铜官山区','246','','','','','0','1');
INSERT INTO smartb2b_area VALUES('677','狮子山区','246','','','','','0','1');
INSERT INTO smartb2b_area VALUES('678','郊区','246','','','','','0','1');
INSERT INTO smartb2b_area VALUES('679','铜陵县','246','','','','','0','1');
INSERT INTO smartb2b_area VALUES('680','镜湖区','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('681','弋江区','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('682','鸠江区','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('683','三山区','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('684','芜湖县','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('685','繁昌县','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('686','南陵县','247','','','','','0','1');
INSERT INTO smartb2b_area VALUES('687','宣州区','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('688','宁国市','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('689','郎溪县','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('690','广德县','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('691','泾县','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('692','绩溪县','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('693','旌德县','248','','','','','0','1');
INSERT INTO smartb2b_area VALUES('694','涡阳县','249','','','','','0','1');
INSERT INTO smartb2b_area VALUES('695','蒙城县','249','','','','','0','1');
INSERT INTO smartb2b_area VALUES('696','利辛县','249','','','','','0','1');
INSERT INTO smartb2b_area VALUES('697','谯城区','249','','','','','0','1');
INSERT INTO smartb2b_area VALUES('698','东城区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('699','西城区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('700','海淀区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('701','朝阳区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('702','崇文区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('703','宣武区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('704','丰台区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('705','石景山区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('706','房山区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('707','门头沟区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('708','通州区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('709','顺义区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('710','昌平区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('711','怀柔区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('712','平谷区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('713','大兴区','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('714','密云县','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('715','延庆县','250','','','','','0','1');
INSERT INTO smartb2b_area VALUES('716','鼓楼区','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('717','台江区','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('718','仓山区','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('719','马尾区','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('720','晋安区','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('721','福清市','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('722','长乐市','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('723','闽侯县','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('724','连江县','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('725','罗源县','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('726','闽清县','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('727','永泰县','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('728','平潭县','251','','','','','0','1');
INSERT INTO smartb2b_area VALUES('729','新罗区','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('730','漳平市','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('731','长汀县','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('732','永定县','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('733','上杭县','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('734','武平县','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('735','连城县','252','','','','','0','1');
INSERT INTO smartb2b_area VALUES('736','延平区','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('737','邵武市','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('738','武夷山市','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('739','建瓯市','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('740','建阳市','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('741','顺昌县','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('742','浦城县','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('743','光泽县','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('744','松溪县','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('745','政和县','253','','','','','0','1');
INSERT INTO smartb2b_area VALUES('746','蕉城区','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('747','福安市','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('748','福鼎市','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('749','霞浦县','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('750','古田县','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('751','屏南县','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('752','寿宁县','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('753','周宁县','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('754','柘荣县','254','','','','','0','1');
INSERT INTO smartb2b_area VALUES('755','城厢区','255','','','','','0','1');
INSERT INTO smartb2b_area VALUES('756','涵江区','255','','','','','0','1');
INSERT INTO smartb2b_area VALUES('757','荔城区','255','','','','','0','1');
INSERT INTO smartb2b_area VALUES('758','秀屿区','255','','','','','0','1');
INSERT INTO smartb2b_area VALUES('759','仙游县','255','','','','','0','1');
INSERT INTO smartb2b_area VALUES('760','鲤城区','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('761','丰泽区','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('762','洛江区','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('763','清濛开发区','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('764','泉港区','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('765','石狮市','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('766','晋江市','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('767','南安市','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('768','惠安县','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('769','安溪县','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('770','永春县','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('771','德化县','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('772','金门县','256','','','','','0','1');
INSERT INTO smartb2b_area VALUES('773','梅列区','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('774','三元区','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('775','永安市','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('776','明溪县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('777','清流县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('778','宁化县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('779','大田县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('780','尤溪县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('781','沙县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('782','将乐县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('783','泰宁县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('784','建宁县','257','','','','','0','1');
INSERT INTO smartb2b_area VALUES('785','思明区','258','','','','','0','1');
INSERT INTO smartb2b_area VALUES('786','海沧区','258','','','','','0','1');
INSERT INTO smartb2b_area VALUES('787','湖里区','258','','','','','0','1');
INSERT INTO smartb2b_area VALUES('788','集美区','258','','','','','0','1');
INSERT INTO smartb2b_area VALUES('789','同安区','258','','','','','0','1');
INSERT INTO smartb2b_area VALUES('790','翔安区','258','','','','','0','1');
INSERT INTO smartb2b_area VALUES('791','芗城区','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('792','龙文区','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('793','龙海市','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('794','云霄县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('795','漳浦县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('796','诏安县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('797','长泰县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('798','东山县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('799','南靖县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('800','平和县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('801','华安县','259','','','','','0','1');
INSERT INTO smartb2b_area VALUES('802','皋兰县','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('803','城关区','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('804','七里河区','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('805','西固区','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('806','安宁区','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('807','红古区','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('808','永登县','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('809','榆中县','260','','','','','0','1');
INSERT INTO smartb2b_area VALUES('810','白银区','261','','','','','0','1');
INSERT INTO smartb2b_area VALUES('811','平川区','261','','','','','0','1');
INSERT INTO smartb2b_area VALUES('812','会宁县','261','','','','','0','1');
INSERT INTO smartb2b_area VALUES('813','景泰县','261','','','','','0','1');
INSERT INTO smartb2b_area VALUES('814','靖远县','261','','','','','0','1');
INSERT INTO smartb2b_area VALUES('815','临洮县','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('816','陇西县','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('817','通渭县','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('818','渭源县','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('819','漳县','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('820','岷县','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('821','安定区','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('822','安定区','262','','','','','0','1');
INSERT INTO smartb2b_area VALUES('823','合作市','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('824','临潭县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('825','卓尼县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('826','舟曲县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('827','迭部县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('828','玛曲县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('829','碌曲县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('830','夏河县','263','','','','','0','1');
INSERT INTO smartb2b_area VALUES('831','嘉峪关市','264','','','','','0','1');
INSERT INTO smartb2b_area VALUES('832','金川区','265','','','','','0','1');
INSERT INTO smartb2b_area VALUES('833','永昌县','265','','','','','0','1');
INSERT INTO smartb2b_area VALUES('834','肃州区','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('835','玉门市','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('836','敦煌市','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('837','金塔县','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('838','瓜州县','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('839','肃北','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('840','阿克塞','266','','','','','0','1');
INSERT INTO smartb2b_area VALUES('841','临夏市','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('842','临夏县','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('843','康乐县','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('844','永靖县','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('845','广河县','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('846','和政县','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('847','东乡族自治县','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('848','积石山','267','','','','','0','1');
INSERT INTO smartb2b_area VALUES('849','成县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('850','徽县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('851','康县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('852','礼县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('853','两当县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('854','文县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('855','西和县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('856','宕昌县','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('857','武都区','268','','','','','0','1');
INSERT INTO smartb2b_area VALUES('858','崇信县','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('859','华亭县','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('860','静宁县','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('861','灵台县','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('862','崆峒区','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('863','庄浪县','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('864','泾川县','269','','','','','0','1');
INSERT INTO smartb2b_area VALUES('865','合水县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('866','华池县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('867','环县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('868','宁县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('869','庆城县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('870','西峰区','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('871','镇原县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('872','正宁县','270','','','','','0','1');
INSERT INTO smartb2b_area VALUES('873','甘谷县','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('874','秦安县','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('875','清水县','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('876','秦州区','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('877','麦积区','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('878','武山县','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('879','张家川','271','','','','','0','1');
INSERT INTO smartb2b_area VALUES('880','古浪县','272','','','','','0','1');
INSERT INTO smartb2b_area VALUES('881','民勤县','272','','','','','0','1');
INSERT INTO smartb2b_area VALUES('882','天祝','272','','','','','0','1');
INSERT INTO smartb2b_area VALUES('883','凉州区','272','','','','','0','1');
INSERT INTO smartb2b_area VALUES('884','高台县','273','','','','','0','1');
INSERT INTO smartb2b_area VALUES('885','临泽县','273','','','','','0','1');
INSERT INTO smartb2b_area VALUES('886','民乐县','273','','','','','0','1');
INSERT INTO smartb2b_area VALUES('887','山丹县','273','','','','','0','1');
INSERT INTO smartb2b_area VALUES('888','肃南','273','','','','','0','1');
INSERT INTO smartb2b_area VALUES('889','甘州区','273','','','','','0','1');
INSERT INTO smartb2b_area VALUES('890','从化市','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('891','天河区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('892','东山区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('893','白云区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('894','海珠区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('895','荔湾区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('896','越秀区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('897','黄埔区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('898','番禺区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('899','花都区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('900','增城区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('901','从化区','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('902','市郊','274','','','','','0','1');
INSERT INTO smartb2b_area VALUES('903','福田区','275','','','','','0','1');
INSERT INTO smartb2b_area VALUES('904','罗湖区','275','','','','','0','1');
INSERT INTO smartb2b_area VALUES('905','南山区','275','','','','','0','1');
INSERT INTO smartb2b_area VALUES('906','宝安区','275','','','','','0','1');
INSERT INTO smartb2b_area VALUES('907','龙岗区','275','','','','','0','1');
INSERT INTO smartb2b_area VALUES('908','盐田区','275','','','','','0','1');
INSERT INTO smartb2b_area VALUES('909','湘桥区','276','','','','','0','1');
INSERT INTO smartb2b_area VALUES('910','潮安县','276','','','','','0','1');
INSERT INTO smartb2b_area VALUES('911','饶平县','276','','','','','0','1');
INSERT INTO smartb2b_area VALUES('912','南城区','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('913','东城区','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('914','万江区','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('915','莞城区','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('916','石龙镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('917','虎门镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('918','麻涌镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('919','道滘镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('920','石碣镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('921','沙田镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('922','望牛墩镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('923','洪梅镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('924','茶山镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('925','寮步镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('926','大岭山镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('927','大朗镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('928','黄江镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('929','樟木头','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('930','凤岗镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('931','塘厦镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('932','谢岗镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('933','厚街镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('934','清溪镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('935','常平镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('936','桥头镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('937','横沥镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('938','东坑镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('939','企石镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('940','石排镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('941','长安镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('942','中堂镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('943','高埗镇','277','','','','','0','1');
INSERT INTO smartb2b_area VALUES('944','禅城区','278','','','','','0','1');
INSERT INTO smartb2b_area VALUES('945','南海区','278','','','','','0','1');
INSERT INTO smartb2b_area VALUES('946','顺德区','278','','','','','0','1');
INSERT INTO smartb2b_area VALUES('947','三水区','278','','','','','0','1');
INSERT INTO smartb2b_area VALUES('948','高明区','278','','','','','0','1');
INSERT INTO smartb2b_area VALUES('949','东源县','279','','','','','0','1');
INSERT INTO smartb2b_area VALUES('950','和平县','279','','','','','0','1');
INSERT INTO smartb2b_area VALUES('951','源城区','279','','','','','0','1');
INSERT INTO smartb2b_area VALUES('952','连平县','279','','','','','0','1');
INSERT INTO smartb2b_area VALUES('953','龙川县','279','','','','','0','1');
INSERT INTO smartb2b_area VALUES('954','紫金县','279','','','','','0','1');
INSERT INTO smartb2b_area VALUES('955','惠阳区','280','','','','','0','1');
INSERT INTO smartb2b_area VALUES('956','惠城区','280','','','','','0','1');
INSERT INTO smartb2b_area VALUES('957','大亚湾','280','','','','','0','1');
INSERT INTO smartb2b_area VALUES('958','博罗县','280','','','','','0','1');
INSERT INTO smartb2b_area VALUES('959','惠东县','280','','','','','0','1');
INSERT INTO smartb2b_area VALUES('960','龙门县','280','','','','','0','1');
INSERT INTO smartb2b_area VALUES('961','江海区','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('962','蓬江区','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('963','新会区','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('964','台山市','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('965','开平市','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('966','鹤山市','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('967','恩平市','281','','','','','0','1');
INSERT INTO smartb2b_area VALUES('968','榕城区','282','','','','','0','1');
INSERT INTO smartb2b_area VALUES('969','普宁市','282','','','','','0','1');
INSERT INTO smartb2b_area VALUES('970','揭东县','282','','','','','0','1');
INSERT INTO smartb2b_area VALUES('971','揭西县','282','','','','','0','1');
INSERT INTO smartb2b_area VALUES('972','惠来县','282','','','','','0','1');
INSERT INTO smartb2b_area VALUES('973','茂南区','283','','','','','0','1');
INSERT INTO smartb2b_area VALUES('974','茂港区','283','','','','','0','1');
INSERT INTO smartb2b_area VALUES('975','高州市','283','','','','','0','1');
INSERT INTO smartb2b_area VALUES('976','化州市','283','','','','','0','1');
INSERT INTO smartb2b_area VALUES('977','信宜市','283','','','','','0','1');
INSERT INTO smartb2b_area VALUES('978','电白县','283','','','','','0','1');
INSERT INTO smartb2b_area VALUES('979','梅县','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('980','梅江区','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('981','兴宁市','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('982','大埔县','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('983','丰顺县','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('984','五华县','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('985','平远县','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('986','蕉岭县','284','','','','','0','1');
INSERT INTO smartb2b_area VALUES('987','清城区','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('988','英德市','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('989','连州市','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('990','佛冈县','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('991','阳山县','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('992','清新县','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('993','连山','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('994','连南','285','','','','','0','1');
INSERT INTO smartb2b_area VALUES('995','南澳县','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('996','潮阳区','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('997','澄海区','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('998','龙湖区','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('999','金平区','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1000','濠江区','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1001','潮南区','286','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1002','城区','287','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1003','陆丰市','287','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1004','海丰县','287','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1005','陆河县','287','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1006','曲江县','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1007','浈江区','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1008','武江区','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1009','曲江区','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1010','乐昌市','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1011','南雄市','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1012','始兴县','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1013','仁化县','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1014','翁源县','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1015','新丰县','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1016','乳源','288','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1017','江城区','289','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1018','阳春市','289','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1019','阳西县','289','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1020','阳东县','289','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1021','云城区','290','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1022','罗定市','290','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1023','新兴县','290','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1024','郁南县','290','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1025','云安县','290','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1026','赤坎区','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1027','霞山区','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1028','坡头区','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1029','麻章区','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1030','廉江市','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1031','雷州市','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1032','吴川市','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1033','遂溪县','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1034','徐闻县','291','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1035','肇庆市','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1036','高要市','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1037','四会市','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1038','广宁县','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1039','怀集县','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1040','封开县','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1041','德庆县','292','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1042','石岐街道','293','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1043','东区街道','293','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1044','西区街道','293','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1045','环城街道','293','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1046','中山港街道','293','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1047','五桂山街道','293','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1048','香洲区','294','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1049','斗门区','294','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1050','金湾区','294','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1051','邕宁区','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1052','青秀区','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1053','兴宁区','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1054','良庆区','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1055','西乡塘区','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1056','江南区','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1057','武鸣县','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1058','隆安县','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1059','马山县','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1060','上林县','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1061','宾阳县','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1062','横县','295','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1063','秀峰区','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1064','叠彩区','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1065','象山区','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1066','七星区','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1067','雁山区','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1068','阳朔县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1069','临桂县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1070','灵川县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1071','全州县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1072','平乐县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1073','兴安县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1074','灌阳县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1075','荔浦县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1076','资源县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1077','永福县','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1078','龙胜','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1079','恭城','296','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1080','右江区','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1081','凌云县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1082','平果县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1083','西林县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1084','乐业县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1085','德保县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1086','田林县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1087','田阳县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1088','靖西县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1089','田东县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1090','那坡县','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1091','隆林','297','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1092','海城区','298','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1093','银海区','298','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1094','铁山港区','298','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1095','合浦县','298','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1096','江州区','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1097','凭祥市','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1098','宁明县','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1099','扶绥县','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1100','龙州县','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1101','大新县','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1102','天等县','299','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1103','港口区','300','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1104','防城区','300','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1105','东兴市','300','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1106','上思县','300','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1107','港北区','301','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1108','港南区','301','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1109','覃塘区','301','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1110','桂平市','301','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1111','平南县','301','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1112','金城江区','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1113','宜州市','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1114','天峨县','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1115','凤山县','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1116','南丹县','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1117','东兰县','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1118','都安','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1119','罗城','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1120','巴马','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1121','环江','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1122','大化','302','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1123','八步区','303','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1124','钟山县','303','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1125','昭平县','303','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1126','富川','303','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1127','兴宾区','304','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1128','合山市','304','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1129','象州县','304','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1130','武宣县','304','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1131','忻城县','304','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1132','金秀','304','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1133','城中区','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1134','鱼峰区','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1135','柳北区','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1136','柳南区','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1137','柳江县','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1138','柳城县','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1139','鹿寨县','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1140','融安县','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1141','融水','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1142','三江','305','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1143','钦南区','306','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1144','钦北区','306','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1145','灵山县','306','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1146','浦北县','306','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1147','万秀区','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1148','蝶山区','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1149','长洲区','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1150','岑溪市','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1151','苍梧县','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1152','藤县','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1153','蒙山县','307','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1154','玉州区','308','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1155','北流市','308','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1156','容县','308','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1157','陆川县','308','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1158','博白县','308','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1159','兴业县','308','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1160','南明区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1161','云岩区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1162','花溪区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1163','乌当区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1164','白云区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1165','小河区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1166','金阳新区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1167','新天园区','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1168','清镇市','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1169','开阳县','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1170','修文县','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1171','息烽县','309','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1172','西秀区','310','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1173','关岭','310','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1174','镇宁','310','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1175','紫云','310','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1176','平坝县','310','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1177','普定县','310','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1178','毕节市','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1179','大方县','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1180','黔西县','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1181','金沙县','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1182','织金县','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1183','纳雍县','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1184','赫章县','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1185','威宁','311','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1186','钟山区','312','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1187','六枝特区','312','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1188','水城县','312','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1189','盘县','312','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1190','凯里市','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1191','黄平县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1192','施秉县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1193','三穗县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1194','镇远县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1195','岑巩县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1196','天柱县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1197','锦屏县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1198','剑河县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1199','台江县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1200','黎平县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1201','榕江县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1202','从江县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1203','雷山县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1204','麻江县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1205','丹寨县','313','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1206','都匀市','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1207','福泉市','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1208','荔波县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1209','贵定县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1210','瓮安县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1211','独山县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1212','平塘县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1213','罗甸县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1214','长顺县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1215','龙里县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1216','惠水县','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1217','三都','314','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1218','兴义市','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1219','兴仁县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1220','普安县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1221','晴隆县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1222','贞丰县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1223','望谟县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1224','册亨县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1225','安龙县','315','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1226','铜仁市','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1227','江口县','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1228','石阡县','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1229','思南县','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1230','德江县','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1231','玉屏','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1232','印江','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1233','沿河','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1234','松桃','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1235','万山特区','316','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1236','红花岗区','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1237','务川县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1238','道真县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1239','汇川区','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1240','赤水市','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1241','仁怀市','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1242','遵义县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1243','桐梓县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1244','绥阳县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1245','正安县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1246','凤冈县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1247','湄潭县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1248','余庆县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1249','习水县','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1250','道真','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1251','务川','317','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1252','秀英区','318','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1253','龙华区','318','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1254','琼山区','318','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1255','美兰区','318','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1256','市区','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1257','洋浦开发区','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1258','那大镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1259','王五镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1260','雅星镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1261','大成镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1262','中和镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1263','峨蔓镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1264','南丰镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1265','白马井镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1266','兰洋镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1267','和庆镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1268','海头镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1269','排浦镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1270','东成镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1271','光村镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1272','木棠镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1273','新州镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1274','三都镇','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1275','其他','335','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1276','长安区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1277','桥东区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1278','桥西区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1279','新华区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1280','裕华区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1281','井陉矿区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1282','高新区','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1283','辛集市','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1284','藁城市','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1285','晋州市','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1286','新乐市','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1287','鹿泉市','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1288','井陉县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1289','正定县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1290','栾城县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1291','行唐县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1292','灵寿县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1293','高邑县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1294','深泽县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1295','赞皇县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1296','无极县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1297','平山县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1298','元氏县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1299','赵县','336','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1300','新市区','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1301','南市区','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1302','北市区','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1303','涿州市','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1304','定州市','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1305','安国市','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1306','高碑店市','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1307','满城县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1308','清苑县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1309','涞水县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1310','阜平县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1311','徐水县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1312','定兴县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1313','唐县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1314','高阳县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1315','容城县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1316','涞源县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1317','望都县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1318','安新县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1319','易县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1320','曲阳县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1321','蠡县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1322','顺平县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1323','博野县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1324','雄县','337','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1325','运河区','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1326','新华区','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1327','泊头市','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1328','任丘市','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1329','黄骅市','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1330','河间市','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1331','沧县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1332','青县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1333','东光县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1334','海兴县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1335','盐山县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1336','肃宁县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1337','南皮县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1338','吴桥县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1339','献县','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1340','孟村','338','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1341','双桥区','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1342','双滦区','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1343','鹰手营子矿区','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1344','承德县','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1345','兴隆县','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1346','平泉县','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1347','滦平县','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1348','隆化县','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1349','丰宁','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1350','宽城','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1351','围场','339','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1352','从台区','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1353','复兴区','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1354','邯山区','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1355','峰峰矿区','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1356','武安市','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1357','邯郸县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1358','临漳县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1359','成安县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1360','大名县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1361','涉县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1362','磁县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1363','肥乡县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1364','永年县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1365','邱县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1366','鸡泽县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1367','广平县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1368','馆陶县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1369','魏县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1370','曲周县','340','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1371','桃城区','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1372','冀州市','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1373','深州市','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1374','枣强县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1375','武邑县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1376','武强县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1377','饶阳县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1378','安平县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1379','故城县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1380','景县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1381','阜城县','341','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1382','安次区','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1383','广阳区','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1384','霸州市','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1385','三河市','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1386','固安县','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1387','永清县','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1388','香河县','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1389','大城县','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1390','文安县','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1391','大厂','342','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1392','海港区','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1393','山海关区','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1394','北戴河区','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1395','昌黎县','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1396','抚宁县','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1397','卢龙县','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1398','青龙','343','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1399','路北区','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1400','路南区','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1401','古冶区','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1402','开平区','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1403','丰南区','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1404','丰润区','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1405','遵化市','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1406','迁安市','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1407','滦县','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1408','滦南县','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1409','乐亭县','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1410','迁西县','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1411','玉田县','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1412','唐海县','344','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1413','桥东区','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1414','桥西区','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1415','南宫市','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1416','沙河市','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1417','邢台县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1418','临城县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1419','内丘县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1420','柏乡县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1421','隆尧县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1422','任县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1423','南和县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1424','宁晋县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1425','巨鹿县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1426','新河县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1427','广宗县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1428','平乡县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1429','威县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1430','清河县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1431','临西县','345','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1432','桥西区','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1433','桥东区','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1434','宣化区','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1435','下花园区','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1436','宣化县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1437','张北县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1438','康保县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1439','沽源县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1440','尚义县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1441','蔚县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1442','阳原县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1443','怀安县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1444','万全县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1445','怀来县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1446','涿鹿县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1447','赤城县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1448','崇礼县','346','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1449','金水区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1450','邙山区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1451','二七区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1452','管城区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1453','中原区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1454','上街区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1455','惠济区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1456','郑东新区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1457','经济技术开发区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1458','高新技术开发区','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1460','巩义市','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1461','荥阳市','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1462','新密市','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1463','新郑市','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1464','登封市','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1465','中牟县','347','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1466','西工区','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1467','老城区','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1468','涧西区','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1469','瀍河回族区','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1470','洛龙区','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1471','吉利区','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1472','偃师市','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1473','孟津县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1474','新安县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1475','栾川县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1476','嵩县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1477','汝阳县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1478','宜阳县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1479','洛宁县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1480','伊川县','348','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1481','鼓楼区','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1482','龙亭区','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1483','顺河回族区','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1484','金明区','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1485','禹王台区','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1486','杞县','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1487','通许县','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1488','尉氏县','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1489','开封县','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1490','兰考县','349','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1491','北关区','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1492','文峰区','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1493','殷都区','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1494','龙安区','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1495','林州市','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1496','安阳县','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1497','汤阴县','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1498','滑县','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1499','内黄县','350','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1500','淇滨区','351','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1501','山城区','351','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1502','鹤山区','351','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1503','浚县','351','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1504','淇县','351','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1505','济源市','352','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1506','解放区','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1507','中站区','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1508','马村区','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1509','山阳区','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1510','沁阳市','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1511','孟州市','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1512','修武县','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1513','博爱县','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1514','武陟县','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1515','温县','353','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1516','卧龙区','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1517','宛城区','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1518','邓州市','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1519','南召县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1520','方城县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1521','西峡县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1522','镇平县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1523','内乡县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1524','淅川县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1525','社旗县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1526','唐河县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1527','新野县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1528','桐柏县','354','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1529','新华区','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1530','卫东区','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1531','湛河区','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1532','石龙区','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1533','舞钢市','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1534','汝州市','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1535','宝丰县','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1536','叶县','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1537','鲁山县','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1538','郏县','355','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1539','湖滨区','356','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1540','义马市','356','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1541','灵宝市','356','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1542','渑池县','356','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1543','陕县','356','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1544','卢氏县','356','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1545','梁园区','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1546','睢阳区','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1547','永城市','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1548','民权县','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1549','睢县','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1550','宁陵县','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1551','虞城县','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1552','柘城县','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1553','夏邑县','357','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1554','卫滨区','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1555','红旗区','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1556','凤泉区','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1557','牧野区','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1558','卫辉市','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1559','辉县市','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1560','新乡县','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1561','获嘉县','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1562','原阳县','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1563','延津县','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1564','封丘县','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1565','长垣县','358','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1566','浉河区','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1567','平桥区','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1568','罗山县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1569','光山县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1570','新县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1571','商城县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1572','固始县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1573','潢川县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1574','淮滨县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1575','息县','359','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1576','魏都区','360','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1577','禹州市','360','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1578','长葛市','360','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1579','许昌县','360','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1580','鄢陵县','360','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1581','襄城县','360','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1582','川汇区','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1583','项城市','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1584','扶沟县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1585','西华县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1586','商水县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1587','沈丘县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1588','郸城县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1589','淮阳县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1590','太康县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1591','鹿邑县','361','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1592','驿城区','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1593','西平县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1594','上蔡县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1595','平舆县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1596','正阳县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1597','确山县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1598','泌阳县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1599','汝南县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1600','遂平县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1601','新蔡县','362','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1602','郾城区','363','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1603','源汇区','363','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1604','召陵区','363','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1605','舞阳县','363','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1606','临颍县','363','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1607','华龙区','364','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1608','清丰县','364','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1609','南乐县','364','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1610','范县','364','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1611','台前县','364','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1612','濮阳县','364','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1613','道里区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1614','南岗区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1615','动力区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1616','平房区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1617','香坊区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1618','太平区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1619','道外区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1620','阿城区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1621','呼兰区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1622','松北区','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1623','尚志市','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1624','双城市','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1625','五常市','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1626','方正县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1627','宾县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1628','依兰县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1629','巴彦县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1630','通河县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1631','木兰县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1632','延寿县','365','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1633','萨尔图区','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1634','红岗区','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1635','龙凤区','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1636','让胡路区','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1637','大同区','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1638','肇州县','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1639','肇源县','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1640','林甸县','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1641','杜尔伯特','366','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1642','呼玛县','367','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1643','漠河县','367','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1644','塔河县','367','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1645','兴山区','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1646','工农区','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1647','南山区','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1648','兴安区','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1649','向阳区','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1650','东山区','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1651','萝北县','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1652','绥滨县','368','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1653','爱辉区','369','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1654','五大连池市','369','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1655','北安市','369','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1656','嫩江县','369','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1657','逊克县','369','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1658','孙吴县','369','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1659','鸡冠区','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1660','恒山区','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1661','城子河区','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1662','滴道区','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1663','梨树区','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1664','虎林市','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1665','密山市','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1666','鸡东县','370','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1667','前进区','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1668','郊区','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1669','向阳区','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1670','东风区','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1671','同江市','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1672','富锦市','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1673','桦南县','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1674','桦川县','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1675','汤原县','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1676','抚远县','371','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1677','爱民区','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1678','东安区','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1679','阳明区','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1680','西安区','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1681','绥芬河市','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1682','海林市','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1683','宁安市','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1684','穆棱市','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1685','东宁县','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1686','林口县','372','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1687','桃山区','373','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1688','新兴区','373','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1689','茄子河区','373','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1690','勃利县','373','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1691','龙沙区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1692','昂昂溪区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1693','铁峰区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1694','建华区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1695','富拉尔基区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1696','碾子山区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1697','梅里斯达斡尔区','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1698','讷河市','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1699','龙江县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1700','依安县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1701','泰来县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1702','甘南县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1703','富裕县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1704','克山县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1705','克东县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1706','拜泉县','374','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1707','尖山区','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1708','岭东区','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1709','四方台区','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1710','宝山区','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1711','集贤县','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1712','友谊县','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1713','宝清县','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1714','饶河县','375','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1715','北林区','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1716','安达市','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1717','肇东市','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1718','海伦市','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1719','望奎县','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1720','兰西县','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1721','青冈县','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1722','庆安县','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1723','明水县','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1724','绥棱县','376','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1725','伊春区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1726','带岭区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1727','南岔区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1728','金山屯区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1729','西林区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1730','美溪区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1731','乌马河区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1732','翠峦区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1733','友好区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1734','上甘岭区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1735','五营区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1736','红星区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1737','新青区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1738','汤旺河区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1739','乌伊岭区','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1740','铁力市','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1741','嘉荫县','377','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1742','江岸区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1743','武昌区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1744','江汉区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1745','硚口区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1746','汉阳区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1747','青山区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1748','洪山区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1749','东西湖区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1750','汉南区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1751','蔡甸区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1752','江夏区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1753','黄陂区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1754','新洲区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1755','经济开发区','378','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1756','仙桃市','379','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1757','鄂城区','380','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1758','华容区','380','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1759','梁子湖区','380','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1760','黄州区','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1761','麻城市','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1762','武穴市','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1763','团风县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1764','红安县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1765','罗田县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1766','英山县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1767','浠水县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1768','蕲春县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1769','黄梅县','381','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1770','黄石港区','382','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1771','西塞山区','382','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1772','下陆区','382','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1773','铁山区','382','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1774','大冶市','382','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1775','阳新县','382','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1776','东宝区','383','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1777','掇刀区','383','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1778','钟祥市','383','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1779','京山县','383','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1780','沙洋县','383','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1781','沙市区','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1782','荆州区','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1783','石首市','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1784','洪湖市','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1785','松滋市','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1786','公安县','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1787','监利县','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1788','江陵县','384','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1789','潜江市','385','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1790','神农架林区','386','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1791','张湾区','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1792','茅箭区','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1793','丹江口市','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1794','郧县','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1795','郧西县','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1796','竹山县','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1797','竹溪县','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1798','房县','387','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1799','曾都区','388','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1800','广水市','388','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1801','天门市','389','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1802','咸安区','390','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1803','赤壁市','390','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1804','嘉鱼县','390','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1805','通城县','390','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1806','崇阳县','390','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1807','通山县','390','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1808','襄城区','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1809','樊城区','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1810','襄阳区','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1811','老河口市','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1812','枣阳市','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1813','宜城市','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1814','南漳县','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1815','谷城县','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1816','保康县','391','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1817','孝南区','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1818','应城市','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1819','安陆市','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1820','汉川市','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1821','孝昌县','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1822','大悟县','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1823','云梦县','392','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1824','长阳','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1825','五峰','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1826','西陵区','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1827','伍家岗区','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1828','点军区','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1829','猇亭区','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1830','夷陵区','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1831','宜都市','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1832','当阳市','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1833','枝江市','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1834','远安县','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1835','兴山县','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1836','秭归县','393','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1837','恩施市','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1838','利川市','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1839','建始县','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1840','巴东县','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1841','宣恩县','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1842','咸丰县','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1843','来凤县','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1844','鹤峰县','394','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1845','岳麓区','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1846','芙蓉区','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1847','天心区','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1848','开福区','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1849','雨花区','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1850','开发区','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1851','浏阳市','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1852','长沙县','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1853','望城县','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1854','宁乡县','395','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1855','永定区','396','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1856','武陵源区','396','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1857','慈利县','396','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1858','桑植县','396','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1859','武陵区','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1860','鼎城区','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1861','津市市','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1862','安乡县','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1863','汉寿县','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1864','澧县','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1865','临澧县','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1866','桃源县','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1867','石门县','397','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1868','北湖区','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1869','苏仙区','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1870','资兴市','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1871','桂阳县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1872','宜章县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1873','永兴县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1874','嘉禾县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1875','临武县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1876','汝城县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1877','桂东县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1878','安仁县','398','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1879','雁峰区','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1880','珠晖区','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1881','石鼓区','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1882','蒸湘区','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1883','南岳区','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1884','耒阳市','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1885','常宁市','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1886','衡阳县','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1887','衡南县','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1888','衡山县','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1889','衡东县','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1890','祁东县','399','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1891','鹤城区','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1892','靖州','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1893','麻阳','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1894','通道','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1895','新晃','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1896','芷江','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1897','沅陵县','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1898','辰溪县','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1899','溆浦县','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1900','中方县','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1901','会同县','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1902','洪江市','400','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1903','娄星区','401','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1904','冷水江市','401','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1905','涟源市','401','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1906','双峰县','401','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1907','新化县','401','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1908','城步','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1909','双清区','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1910','大祥区','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1911','北塔区','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1912','武冈市','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1913','邵东县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1914','新邵县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1915','邵阳县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1916','隆回县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1917','洞口县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1918','绥宁县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1919','新宁县','402','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1920','岳塘区','403','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1921','雨湖区','403','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1922','湘乡市','403','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1923','韶山市','403','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1924','湘潭县','403','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1925','吉首市','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1926','泸溪县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1927','凤凰县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1928','花垣县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1929','保靖县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1930','古丈县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1931','永顺县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1932','龙山县','404','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1933','赫山区','405','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1934','资阳区','405','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1935','沅江市','405','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1936','南县','405','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1937','桃江县','405','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1938','安化县','405','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1939','江华','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1940','冷水滩区','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1941','零陵区','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1942','祁阳县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1943','东安县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1944','双牌县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1945','道县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1946','江永县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1947','宁远县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1948','蓝山县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1949','新田县','406','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1950','岳阳楼区','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1951','君山区','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1952','云溪区','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1953','汨罗市','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1954','临湘市','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1955','岳阳县','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1956','华容县','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1957','湘阴县','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1958','平江县','407','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1959','天元区','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1960','荷塘区','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1961','芦淞区','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1962','石峰区','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1963','醴陵市','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1964','株洲县','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1965','攸县','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1966','茶陵县','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1967','炎陵县','408','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1968','朝阳区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1969','宽城区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1970','二道区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1971','南关区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1972','绿园区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1973','双阳区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1974','净月潭开发区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1975','高新技术开发区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1976','经济技术开发区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1977','汽车产业开发区','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1978','德惠市','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1979','九台市','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1980','榆树市','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1981','农安县','409','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1982','船营区','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1983','昌邑区','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1984','龙潭区','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1985','丰满区','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1986','蛟河市','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1987','桦甸市','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1988','舒兰市','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1989','磐石市','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1990','永吉县','410','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1991','洮北区','411','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1992','洮南市','411','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1993','大安市','411','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1994','镇赉县','411','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1995','通榆县','411','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1996','江源区','412','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1997','八道江区','412','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1998','长白','412','','','','','0','1');
INSERT INTO smartb2b_area VALUES('1999','临江市','412','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2000','抚松县','412','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2001','靖宇县','412','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2002','龙山区','413','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2003','西安区','413','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2004','东丰县','413','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2005','东辽县','413','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2006','铁西区','414','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2007','铁东区','414','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2008','伊通','414','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2009','公主岭市','414','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2010','双辽市','414','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2011','梨树县','414','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2012','前郭尔罗斯','415','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2013','宁江区','415','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2014','长岭县','415','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2015','乾安县','415','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2016','扶余县','415','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2017','东昌区','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2018','二道江区','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2019','梅河口市','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2020','集安市','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2021','通化县','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2022','辉南县','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2023','柳河县','416','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2024','延吉市','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2025','图们市','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2026','敦化市','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2027','珲春市','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2028','龙井市','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2029','和龙市','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2030','安图县','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2031','汪清县','417','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2032','玄武区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2033','鼓楼区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2034','白下区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2035','建邺区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2036','秦淮区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2037','雨花台区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2038','下关区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2039','栖霞区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2040','浦口区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2041','江宁区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2042','六合区','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2043','溧水县','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2044','高淳县','418','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2045','沧浪区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2046','金阊区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2047','平江区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2048','虎丘区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2049','吴中区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2050','相城区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2051','园区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2052','新区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2053','常熟市','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2054','张家港市','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2055','玉山镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2056','巴城镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2057','周市镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2058','陆家镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2059','花桥镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2060','淀山湖镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2061','张浦镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2062','周庄镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2063','千灯镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2064','锦溪镇','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2065','开发区','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2066','吴江市','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2067','太仓市','419','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2068','崇安区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2069','北塘区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2070','南长区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2071','锡山区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2072','惠山区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2073','滨湖区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2074','新区','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2075','江阴市','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2076','宜兴市','420','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2077','天宁区','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2078','钟楼区','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2079','戚墅堰区','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2080','郊区','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2081','新北区','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2082','武进区','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2083','溧阳市','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2084','金坛市','421','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2085','清河区','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2086','清浦区','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2087','楚州区','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2088','淮阴区','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2089','涟水县','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2090','洪泽县','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2091','盱眙县','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2092','金湖县','422','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2093','新浦区','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2094','连云区','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2095','海州区','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2096','赣榆县','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2097','东海县','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2098','灌云县','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2099','灌南县','423','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2100','崇川区','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2101','港闸区','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2102','经济开发区','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2103','启东市','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2104','如皋市','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2105','通州市','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2106','海门市','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2107','海安县','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2108','如东县','424','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2109','宿城区','425','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2110','宿豫区','425','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2111','宿豫县','425','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2112','沭阳县','425','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2113','泗阳县','425','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2114','泗洪县','425','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2115','海陵区','426','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2116','高港区','426','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2117','兴化市','426','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2118','靖江市','426','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2119','泰兴市','426','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2120','姜堰市','426','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2121','云龙区','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2122','鼓楼区','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2123','九里区','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2124','贾汪区','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2125','泉山区','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2126','新沂市','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2127','邳州市','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2128','丰县','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2129','沛县','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2130','铜山县','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2131','睢宁县','427','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2132','城区','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2133','亭湖区','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2134','盐都区','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2135','盐都县','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2136','东台市','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2137','大丰市','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2138','响水县','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2139','滨海县','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2140','阜宁县','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2141','射阳县','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2142','建湖县','428','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2143','广陵区','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2144','维扬区','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2145','邗江区','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2146','仪征市','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2147','高邮市','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2148','江都市','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2149','宝应县','429','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2150','京口区','430','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2151','润州区','430','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2152','丹徒区','430','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2153','丹阳市','430','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2154','扬中市','430','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2155','句容市','430','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2156','东湖区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2157','西湖区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2158','青云谱区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2159','湾里区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2160','青山湖区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2161','红谷滩新区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2162','昌北区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2163','高新区','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2164','南昌县','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2165','新建县','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2166','安义县','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2167','进贤县','431','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2168','临川区','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2169','南城县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2170','黎川县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2171','南丰县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2172','崇仁县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2173','乐安县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2174','宜黄县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2175','金溪县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2176','资溪县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2177','东乡县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2178','广昌县','432','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2179','章贡区','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2180','于都县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2181','瑞金市','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2182','南康市','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2183','赣县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2184','信丰县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2185','大余县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2186','上犹县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2187','崇义县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2188','安远县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2189','龙南县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2190','定南县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2191','全南县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2192','宁都县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2193','兴国县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2194','会昌县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2195','寻乌县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2196','石城县','433','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2197','安福县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2198','吉州区','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2199','青原区','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2200','井冈山市','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2201','吉安县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2202','吉水县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2203','峡江县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2204','新干县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2205','永丰县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2206','泰和县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2207','遂川县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2208','万安县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2209','永新县','434','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2210','珠山区','435','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2211','昌江区','435','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2212','乐平市','435','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2213','浮梁县','435','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2214','浔阳区','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2215','庐山区','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2216','瑞昌市','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2217','九江县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2218','武宁县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2219','修水县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2220','永修县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2221','德安县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2222','星子县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2223','都昌县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2224','湖口县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2225','彭泽县','436','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2226','安源区','437','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2227','湘东区','437','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2228','莲花县','437','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2229','芦溪县','437','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2230','上栗县','437','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2231','信州区','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2232','德兴市','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2233','上饶县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2234','广丰县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2235','玉山县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2236','铅山县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2237','横峰县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2238','弋阳县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2239','余干县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2240','波阳县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2241','万年县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2242','婺源县','438','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2243','渝水区','439','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2244','分宜县','439','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2245','袁州区','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2246','丰城市','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2247','樟树市','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2248','高安市','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2249','奉新县','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2250','万载县','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2251','上高县','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2252','宜丰县','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2253','靖安县','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2254','铜鼓县','440','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2255','月湖区','441','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2256','贵溪市','441','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2257','余江县','441','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2258','沈河区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2259','皇姑区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2260','和平区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2261','大东区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2262','铁西区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2263','苏家屯区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2264','东陵区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2265','沈北新区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2266','于洪区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2267','浑南新区','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2268','新民市','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2269','辽中县','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2270','康平县','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2271','法库县','442','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2272','西岗区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2273','中山区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2274','沙河口区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2275','甘井子区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2276','旅顺口区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2277','金州区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2278','开发区','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2279','瓦房店市','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2280','普兰店市','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2281','庄河市','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2282','长海县','443','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2283','铁东区','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2284','铁西区','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2285','立山区','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2286','千山区','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2287','岫岩','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2288','海城市','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2289','台安县','444','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2290','本溪','445','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2291','平山区','445','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2292','明山区','445','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2293','溪湖区','445','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2294','南芬区','445','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2295','桓仁','445','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2296','双塔区','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2297','龙城区','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2298','喀喇沁左翼蒙古族自治县','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2299','北票市','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2300','凌源市','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2301','朝阳县','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2302','建平县','446','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2303','振兴区','447','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2304','元宝区','447','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2305','振安区','447','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2306','宽甸','447','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2307','东港市','447','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2308','凤城市','447','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2309','顺城区','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2310','新抚区','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2311','东洲区','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2312','望花区','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2313','清原','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2314','新宾','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2315','抚顺县','448','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2316','阜新','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2317','海州区','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2318','新邱区','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2319','太平区','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2320','清河门区','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2321','细河区','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2322','彰武县','449','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2323','龙港区','450','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2324','南票区','450','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2325','连山区','450','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2326','兴城市','450','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2327','绥中县','450','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2328','建昌县','450','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2329','太和区','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2330','古塔区','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2331','凌河区','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2332','凌海市','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2333','北镇市','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2334','黑山县','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2335','义县','451','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2336','白塔区','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2337','文圣区','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2338','宏伟区','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2339','太子河区','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2340','弓长岭区','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2341','灯塔市','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2342','辽阳县','452','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2343','双台子区','453','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2344','兴隆台区','453','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2345','大洼县','453','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2346','盘山县','453','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2347','银州区','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2348','清河区','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2349','调兵山市','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2350','开原市','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2351','铁岭县','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2352','西丰县','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2353','昌图县','454','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2354','站前区','455','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2355','西市区','455','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2356','鲅鱼圈区','455','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2357','老边区','455','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2358','盖州市','455','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2359','大石桥市','455','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2360','回民区','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2361','玉泉区','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2362','新城区','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2363','赛罕区','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2364','清水河县','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2365','土默特左旗','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2366','托克托县','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2367','和林格尔县','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2368','武川县','456','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2369','阿拉善左旗','457','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2370','阿拉善右旗','457','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2371','额济纳旗','457','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2372','临河区','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2373','五原县','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2374','磴口县','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2375','乌拉特前旗','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2376','乌拉特中旗','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2377','乌拉特后旗','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2378','杭锦后旗','458','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2379','昆都仑区','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2380','青山区','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2381','东河区','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2382','九原区','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2383','石拐区','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2384','白云矿区','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2385','土默特右旗','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2386','固阳县','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2387','达尔罕茂明安联合旗','459','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2388','红山区','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2389','元宝山区','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2390','松山区','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2391','阿鲁科尔沁旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2392','巴林左旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2393','巴林右旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2394','林西县','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2395','克什克腾旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2396','翁牛特旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2397','喀喇沁旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2398','宁城县','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2399','敖汉旗','460','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2400','东胜区','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2401','达拉特旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2402','准格尔旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2403','鄂托克前旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2404','鄂托克旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2405','杭锦旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2406','乌审旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2407','伊金霍洛旗','461','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2408','海拉尔区','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2409','莫力达瓦','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2410','满洲里市','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2411','牙克石市','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2412','扎兰屯市','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2413','额尔古纳市','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2414','根河市','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2415','阿荣旗','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2416','鄂伦春自治旗','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2417','鄂温克族自治旗','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2418','陈巴尔虎旗','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2419','新巴尔虎左旗','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2420','新巴尔虎右旗','462','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2421','科尔沁区','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2422','霍林郭勒市','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2423','科尔沁左翼中旗','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2424','科尔沁左翼后旗','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2425','开鲁县','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2426','库伦旗','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2427','奈曼旗','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2428','扎鲁特旗','463','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2429','海勃湾区','464','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2430','乌达区','464','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2431','海南区','464','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2432','化德县','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2433','集宁区','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2434','丰镇市','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2435','卓资县','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2436','商都县','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2437','兴和县','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2438','凉城县','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2439','察哈尔右翼前旗','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2440','察哈尔右翼中旗','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2441','察哈尔右翼后旗','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2442','四子王旗','465','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2443','二连浩特市','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2444','锡林浩特市','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2445','阿巴嘎旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2446','苏尼特左旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2447','苏尼特右旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2448','东乌珠穆沁旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2449','西乌珠穆沁旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2450','太仆寺旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2451','镶黄旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2452','正镶白旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2453','正蓝旗','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2454','多伦县','466','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2455','乌兰浩特市','467','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2456','阿尔山市','467','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2457','科尔沁右翼前旗','467','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2458','科尔沁右翼中旗','467','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2459','扎赉特旗','467','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2460','突泉县','467','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2461','西夏区','468','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2462','金凤区','468','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2463','兴庆区','468','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2464','灵武市','468','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2465','永宁县','468','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2466','贺兰县','468','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2467','原州区','469','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2468','海原县','469','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2469','西吉县','469','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2470','隆德县','469','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2471','泾源县','469','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2472','彭阳县','469','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2473','惠农县','470','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2474','大武口区','470','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2475','惠农区','470','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2476','陶乐县','470','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2477','平罗县','470','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2478','利通区','471','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2479','中卫县','471','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2480','青铜峡市','471','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2481','中宁县','471','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2482','盐池县','471','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2483','同心县','471','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2484','沙坡头区','472','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2485','海原县','472','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2486','中宁县','472','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2487','城中区','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2488','城东区','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2489','城西区','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2490','城北区','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2491','湟中县','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2492','湟源县','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2493','大通','473','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2494','玛沁县','474','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2495','班玛县','474','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2496','甘德县','474','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2497','达日县','474','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2498','久治县','474','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2499','玛多县','474','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2500','海晏县','475','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2501','祁连县','475','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2502','刚察县','475','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2503','门源','475','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2504','平安县','476','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2505','乐都县','476','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2506','民和','476','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2507','互助','476','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2508','化隆','476','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2509','循化','476','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2510','共和县','477','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2511','同德县','477','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2512','贵德县','477','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2513','兴海县','477','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2514','贵南县','477','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2515','德令哈市','478','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2516','格尔木市','478','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2517','乌兰县','478','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2518','都兰县','478','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2519','天峻县','478','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2520','同仁县','479','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2521','尖扎县','479','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2522','泽库县','479','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2523','河南蒙古族自治县','479','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2524','玉树县','480','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2525','杂多县','480','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2526','称多县','480','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2527','治多县','480','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2528','囊谦县','480','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2529','曲麻莱县','480','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2530','市中区','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2531','历下区','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2532','天桥区','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2533','槐荫区','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2534','历城区','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2535','长清区','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2536','章丘市','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2537','平阴县','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2538','济阳县','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2539','商河县','481','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2540','市南区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2541','市北区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2542','城阳区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2543','四方区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2544','李沧区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2545','黄岛区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2546','崂山区','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2547','胶州市','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2548','即墨市','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2549','平度市','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2550','胶南市','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2551','莱西市','482','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2552','滨城区','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2553','惠民县','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2554','阳信县','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2555','无棣县','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2556','沾化县','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2557','博兴县','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2558','邹平县','483','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2559','德城区','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2560','陵县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2561','乐陵市','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2562','禹城市','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2563','宁津县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2564','庆云县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2565','临邑县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2566','齐河县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2567','平原县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2568','夏津县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2569','武城县','484','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2570','东营区','485','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2571','河口区','485','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2572','垦利县','485','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2573','利津县','485','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2574','广饶县','485','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2575','牡丹区','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2576','曹县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2577','单县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2578','成武县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2579','巨野县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2580','郓城县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2581','鄄城县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2582','定陶县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2583','东明县','486','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2584','市中区','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2585','任城区','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2586','曲阜市','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2587','兖州市','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2588','邹城市','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2589','微山县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2590','鱼台县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2591','金乡县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2592','嘉祥县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2593','汶上县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2594','泗水县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2595','梁山县','487','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2596','莱城区','488','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2597','钢城区','488','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2598','东昌府区','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2599','临清市','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2600','阳谷县','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2601','莘县','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2602','茌平县','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2603','东阿县','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2604','冠县','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2605','高唐县','489','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2606','兰山区','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2607','罗庄区','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2608','河东区','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2609','沂南县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2610','郯城县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2611','沂水县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2612','苍山县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2613','费县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2614','平邑县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2615','莒南县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2616','蒙阴县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2617','临沭县','490','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2618','东港区','491','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2619','岚山区','491','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2620','五莲县','491','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2621','莒县','491','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2622','泰山区','492','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2623','岱岳区','492','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2624','新泰市','492','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2625','肥城市','492','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2626','宁阳县','492','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2627','东平县','492','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2628','荣成市','493','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2629','乳山市','493','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2630','环翠区','493','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2631','文登市','493','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2632','潍城区','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2633','寒亭区','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2634','坊子区','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2635','奎文区','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2636','青州市','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2637','诸城市','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2638','寿光市','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2639','安丘市','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2640','高密市','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2641','昌邑市','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2642','临朐县','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2643','昌乐县','494','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2644','芝罘区','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2645','福山区','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2646','牟平区','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2647','莱山区','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2648','开发区','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2649','龙口市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2650','莱阳市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2651','莱州市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2652','蓬莱市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2653','招远市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2654','栖霞市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2655','海阳市','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2656','长岛县','495','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2657','市中区','496','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2658','山亭区','496','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2659','峄城区','496','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2660','台儿庄区','496','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2661','薛城区','496','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2662','滕州市','496','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2663','张店区','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2664','临淄区','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2665','淄川区','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2666','博山区','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2667','周村区','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2668','桓台县','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2669','高青县','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2670','沂源县','497','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2671','杏花岭区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2672','小店区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2673','迎泽区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2674','尖草坪区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2675','万柏林区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2676','晋源区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2677','高新开发区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2678','民营经济开发区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2679','经济技术开发区','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2680','清徐县','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2681','阳曲县','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2682','娄烦县','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2683','古交市','498','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2684','城区','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2685','郊区','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2686','沁县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2687','潞城市','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2688','长治县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2689','襄垣县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2690','屯留县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2691','平顺县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2692','黎城县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2693','壶关县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2694','长子县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2695','武乡县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2696','沁源县','499','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2697','城区','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2698','矿区','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2699','南郊区','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2700','新荣区','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2701','阳高县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2702','天镇县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2703','广灵县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2704','灵丘县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2705','浑源县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2706','左云县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2707','大同县','500','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2708','城区','501','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2709','高平市','501','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2710','沁水县','501','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2711','阳城县','501','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2712','陵川县','501','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2713','泽州县','501','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2714','榆次区','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2715','介休市','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2716','榆社县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2717','左权县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2718','和顺县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2719','昔阳县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2720','寿阳县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2721','太谷县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2722','祁县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2723','平遥县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2724','灵石县','502','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2725','尧都区','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2726','侯马市','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2727','霍州市','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2728','曲沃县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2729','翼城县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2730','襄汾县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2731','洪洞县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2732','吉县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2733','安泽县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2734','浮山县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2735','古县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2736','乡宁县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2737','大宁县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2738','隰县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2739','永和县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2740','蒲县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2741','汾西县','503','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2742','离石市','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2743','离石区','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2744','孝义市','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2745','汾阳市','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2746','文水县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2747','交城县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2748','兴县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2749','临县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2750','柳林县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2751','石楼县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2752','岚县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2753','方山县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2754','中阳县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2755','交口县','504','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2756','朔城区','505','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2757','平鲁区','505','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2758','山阴县','505','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2759','应县','505','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2760','右玉县','505','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2761','怀仁县','505','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2762','忻府区','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2763','原平市','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2764','定襄县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2765','五台县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2766','代县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2767','繁峙县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2768','宁武县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2769','静乐县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2770','神池县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2771','五寨县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2772','岢岚县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2773','河曲县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2774','保德县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2775','偏关县','506','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2776','城区','507','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2777','矿区','507','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2778','郊区','507','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2779','平定县','507','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2780','盂县','507','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2781','盐湖区','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2782','永济市','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2783','河津市','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2784','临猗县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2785','万荣县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2786','闻喜县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2787','稷山县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2788','新绛县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2789','绛县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2790','垣曲县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2791','夏县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2792','平陆县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2793','芮城县','508','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2794','莲湖区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2795','新城区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2796','碑林区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2797','雁塔区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2798','灞桥区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2799','未央区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2800','阎良区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2801','临潼区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2802','长安区','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2803','蓝田县','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2804','周至县','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2805','户县','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2806','高陵县','509','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2807','汉滨区','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2808','汉阴县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2809','石泉县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2810','宁陕县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2811','紫阳县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2812','岚皋县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2813','平利县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2814','镇坪县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2815','旬阳县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2816','白河县','510','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2817','陈仓区','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2818','渭滨区','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2819','金台区','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2820','凤翔县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2821','岐山县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2822','扶风县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2823','眉县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2824','陇县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2825','千阳县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2826','麟游县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2827','凤县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2828','太白县','511','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2829','汉台区','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2830','南郑县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2831','城固县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2832','洋县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2833','西乡县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2834','勉县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2835','宁强县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2836','略阳县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2837','镇巴县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2838','留坝县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2839','佛坪县','512','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2840','商州区','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2841','洛南县','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2842','丹凤县','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2843','商南县','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2844','山阳县','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2845','镇安县','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2846','柞水县','513','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2847','耀州区','514','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2848','王益区','514','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2849','印台区','514','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2850','宜君县','514','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2851','临渭区','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2852','韩城市','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2853','华阴市','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2854','华县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2855','潼关县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2856','大荔县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2857','合阳县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2858','澄城县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2859','蒲城县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2860','白水县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2861','富平县','515','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2862','秦都区','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2863','渭城区','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2864','杨陵区','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2865','兴平市','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2866','三原县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2867','泾阳县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2868','乾县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2869','礼泉县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2870','永寿县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2871','彬县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2872','长武县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2873','旬邑县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2874','淳化县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2875','武功县','516','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2876','吴起县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2877','宝塔区','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2878','延长县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2879','延川县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2880','子长县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2881','安塞县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2882','志丹县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2883','甘泉县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2884','富县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2885','洛川县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2886','宜川县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2887','黄龙县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2888','黄陵县','517','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2889','榆阳区','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2890','神木县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2891','府谷县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2892','横山县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2893','靖边县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2894','定边县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2895','绥德县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2896','米脂县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2897','佳县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2898','吴堡县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2899','清涧县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2900','子洲县','518','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2901','长宁区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2902','闸北区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2903','闵行区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2904','徐汇区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2905','浦东新区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2906','杨浦区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2907','普陀区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2908','静安区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2909','卢湾区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2910','虹口区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2911','黄浦区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2912','南汇区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2913','松江区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2914','嘉定区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2915','宝山区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2916','青浦区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2917','金山区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2918','奉贤区','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2919','崇明县','519','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2920','青羊区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2921','锦江区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2922','金牛区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2923','武侯区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2924','成华区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2925','龙泉驿区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2926','青白江区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2927','新都区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2928','温江区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2929','高新区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2930','高新西区','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2931','都江堰市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2932','彭州市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2933','邛崃市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2934','崇州市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2935','金堂县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2936','双流县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2937','郫县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2938','大邑县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2939','蒲江县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2940','新津县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2941','都江堰市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2942','彭州市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2943','邛崃市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2944','崇州市','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2945','金堂县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2946','双流县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2947','郫县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2948','大邑县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2949','蒲江县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2950','新津县','520','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2951','涪城区','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2952','游仙区','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2953','江油市','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2954','盐亭县','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2955','三台县','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2956','平武县','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2957','安县','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2958','梓潼县','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2959','北川县','521','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2960','马尔康县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2961','汶川县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2962','理县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2963','茂县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2964','松潘县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2965','九寨沟县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2966','金川县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2967','小金县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2968','黑水县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2969','壤塘县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2970','阿坝县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2971','若尔盖县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2972','红原县','522','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2973','巴州区','523','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2974','通江县','523','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2975','南江县','523','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2976','平昌县','523','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2977','通川区','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2978','万源市','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2979','达县','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2980','宣汉县','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2981','开江县','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2982','大竹县','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2983','渠县','524','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2984','旌阳区','525','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2985','广汉市','525','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2986','什邡市','525','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2987','绵竹市','525','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2988','罗江县','525','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2989','中江县','525','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2990','康定县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2991','丹巴县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2992','泸定县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2993','炉霍县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2994','九龙县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2995','甘孜县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2996','雅江县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2997','新龙县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2998','道孚县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('2999','白玉县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3000','理塘县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3001','德格县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3002','乡城县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3003','石渠县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3004','稻城县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3005','色达县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3006','巴塘县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3007','得荣县','526','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3008','广安区','527','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3009','华蓥市','527','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3010','岳池县','527','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3011','武胜县','527','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3012','邻水县','527','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3013','利州区','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3014','元坝区','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3015','朝天区','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3016','旺苍县','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3017','青川县','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3018','剑阁县','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3019','苍溪县','528','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3020','峨眉山市','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3021','乐山市','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3022','犍为县','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3023','井研县','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3024','夹江县','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3025','沐川县','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3026','峨边','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3027','马边','529','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3028','西昌市','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3029','盐源县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3030','德昌县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3031','会理县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3032','会东县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3033','宁南县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3034','普格县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3035','布拖县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3036','金阳县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3037','昭觉县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3038','喜德县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3039','冕宁县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3040','越西县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3041','甘洛县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3042','美姑县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3043','雷波县','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3044','木里','530','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3045','东坡区','531','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3046','仁寿县','531','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3047','彭山县','531','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3048','洪雅县','531','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3049','丹棱县','531','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3050','青神县','531','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3051','阆中市','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3052','南部县','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3053','营山县','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3054','蓬安县','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3055','仪陇县','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3056','顺庆区','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3057','高坪区','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3058','嘉陵区','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3059','西充县','532','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3060','市中区','533','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3061','东兴区','533','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3062','威远县','533','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3063','资中县','533','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3064','隆昌县','533','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3065','东  区','534','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3066','西  区','534','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3067','仁和区','534','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3068','米易县','534','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3069','盐边县','534','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3070','船山区','535','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3071','安居区','535','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3072','蓬溪县','535','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3073','射洪县','535','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3074','大英县','535','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3075','雨城区','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3076','名山县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3077','荥经县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3078','汉源县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3079','石棉县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3080','天全县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3081','芦山县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3082','宝兴县','536','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3083','翠屏区','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3084','宜宾县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3085','南溪县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3086','江安县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3087','长宁县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3088','高县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3089','珙县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3090','筠连县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3091','兴文县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3092','屏山县','537','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3093','雁江区','538','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3094','简阳市','538','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3095','安岳县','538','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3096','乐至县','538','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3097','大安区','539','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3098','自流井区','539','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3099','贡井区','539','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3100','沿滩区','539','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3101','荣县','539','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3102','富顺县','539','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3103','江阳区','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3104','纳溪区','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3105','龙马潭区','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3106','泸县','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3107','合江县','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3108','叙永县','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3109','古蔺县','540','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3110','和平区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3111','河西区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3112','南开区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3113','河北区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3114','河东区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3115','红桥区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3116','东丽区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3117','津南区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3118','西青区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3119','北辰区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3120','塘沽区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3121','汉沽区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3122','大港区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3123','武清区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3124','宝坻区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3125','经济开发区','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3126','宁河县','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3127','静海县','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3128','蓟县','541','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3129','城关区','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3130','林周县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3131','当雄县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3132','尼木县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3133','曲水县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3134','堆龙德庆县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3135','达孜县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3136','墨竹工卡县','542','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3137','噶尔县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3138','普兰县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3139','札达县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3140','日土县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3141','革吉县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3142','改则县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3143','措勤县','543','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3144','昌都县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3145','江达县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3146','贡觉县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3147','类乌齐县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3148','丁青县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3149','察雅县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3150','八宿县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3151','左贡县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3152','芒康县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3153','洛隆县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3154','边坝县','544','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3155','林芝县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3156','工布江达县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3157','米林县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3158','墨脱县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3159','波密县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3160','察隅县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3161','朗县','545','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3162','那曲县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3163','嘉黎县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3164','比如县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3165','聂荣县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3166','安多县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3167','申扎县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3168','索县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3169','班戈县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3170','巴青县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3171','尼玛县','546','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3172','日喀则市','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3173','南木林县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3174','江孜县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3175','定日县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3176','萨迦县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3177','拉孜县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3178','昂仁县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3179','谢通门县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3180','白朗县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3181','仁布县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3182','康马县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3183','定结县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3184','仲巴县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3185','亚东县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3186','吉隆县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3187','聂拉木县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3188','萨嘎县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3189','岗巴县','547','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3190','乃东县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3191','扎囊县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3192','贡嘎县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3193','桑日县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3194','琼结县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3195','曲松县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3196','措美县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3197','洛扎县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3198','加查县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3199','隆子县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3200','错那县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3201','浪卡子县','548','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3202','天山区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3203','沙依巴克区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3204','新市区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3205','水磨沟区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3206','头屯河区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3207','达坂城区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3208','米东区','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3209','乌鲁木齐县','549','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3210','阿克苏市','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3211','温宿县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3212','库车县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3213','沙雅县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3214','新和县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3215','拜城县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3216','乌什县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3217','阿瓦提县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3218','柯坪县','550','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3219','阿拉尔市','551','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3220','库尔勒市','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3221','轮台县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3222','尉犁县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3223','若羌县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3224','且末县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3225','焉耆','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3226','和静县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3227','和硕县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3228','博湖县','552','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3229','博乐市','553','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3230','精河县','553','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3231','温泉县','553','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3232','呼图壁县','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3233','米泉市','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3234','昌吉市','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3235','阜康市','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3236','玛纳斯县','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3237','奇台县','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3238','吉木萨尔县','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3239','木垒','554','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3240','哈密市','555','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3241','伊吾县','555','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3242','巴里坤','555','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3243','和田市','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3244','和田县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3245','墨玉县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3246','皮山县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3247','洛浦县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3248','策勒县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3249','于田县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3250','民丰县','556','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3251','喀什市','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3252','疏附县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3253','疏勒县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3254','英吉沙县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3255','泽普县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3256','莎车县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3257','叶城县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3258','麦盖提县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3259','岳普湖县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3260','伽师县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3261','巴楚县','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3262','塔什库尔干','557','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3263','克拉玛依市','558','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3264','阿图什市','559','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3265','阿克陶县','559','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3266','阿合奇县','559','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3267','乌恰县','559','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3268','石河子市','560','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3269','图木舒克市','561','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3270','吐鲁番市','562','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3271','鄯善县','562','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3272','托克逊县','562','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3273','五家渠市','563','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3274','阿勒泰市','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3275','布克赛尔','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3276','伊宁市','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3277','布尔津县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3278','奎屯市','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3279','乌苏市','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3280','额敏县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3281','富蕴县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3282','伊宁县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3283','福海县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3284','霍城县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3285','沙湾县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3286','巩留县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3287','哈巴河县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3288','托里县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3289','青河县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3290','新源县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3291','裕民县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3292','和布克赛尔','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3293','吉木乃县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3294','昭苏县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3295','特克斯县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3296','尼勒克县','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3297','察布查尔','564','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3298','盘龙区','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3299','五华区','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3300','官渡区','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3301','西山区','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3302','东川区','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3303','安宁市','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3304','呈贡县','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3305','晋宁县','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3306','富民县','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3307','宜良县','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3308','嵩明县','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3309','石林县','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3310','禄劝','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3311','寻甸','565','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3312','兰坪','566','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3313','泸水县','566','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3314','福贡县','566','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3315','贡山','566','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3316','宁洱','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3317','思茅区','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3318','墨江','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3319','景东','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3320','景谷','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3321','镇沅','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3322','江城','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3323','孟连','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3324','澜沧','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3325','西盟','567','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3326','古城区','568','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3327','宁蒗','568','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3328','玉龙','568','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3329','永胜县','568','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3330','华坪县','568','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3331','隆阳区','569','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3332','施甸县','569','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3333','腾冲县','569','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3334','龙陵县','569','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3335','昌宁县','569','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3336','楚雄市','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3337','双柏县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3338','牟定县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3339','南华县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3340','姚安县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3341','大姚县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3342','永仁县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3343','元谋县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3344','武定县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3345','禄丰县','570','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3346','大理市','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3347','祥云县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3348','宾川县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3349','弥渡县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3350','永平县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3351','云龙县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3352','洱源县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3353','剑川县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3354','鹤庆县','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3355','漾濞','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3356','南涧','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3357','巍山','571','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3358','潞西市','572','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3359','瑞丽市','572','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3360','梁河县','572','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3361','盈江县','572','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3362','陇川县','572','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3363','香格里拉县','573','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3364','德钦县','573','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3365','维西','573','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3366','泸西县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3367','蒙自县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3368','个旧市','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3369','开远市','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3370','绿春县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3371','建水县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3372','石屏县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3373','弥勒县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3374','元阳县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3375','红河县','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3376','金平','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3377','河口','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3378','屏边','574','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3379','临翔区','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3380','凤庆县','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3381','云县','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3382','永德县','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3383','镇康县','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3384','双江','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3385','耿马','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3386','沧源','575','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3387','麒麟区','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3388','宣威市','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3389','马龙县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3390','陆良县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3391','师宗县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3392','罗平县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3393','富源县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3394','会泽县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3395','沾益县','576','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3396','文山县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3397','砚山县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3398','西畴县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3399','麻栗坡县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3400','马关县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3401','丘北县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3402','广南县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3403','富宁县','577','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3404','景洪市','578','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3405','勐海县','578','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3406','勐腊县','578','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3407','红塔区','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3408','江川县','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3409','澄江县','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3410','通海县','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3411','华宁县','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3412','易门县','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3413','峨山','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3414','新平','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3415','元江','579','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3416','昭阳区','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3417','鲁甸县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3418','巧家县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3419','盐津县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3420','大关县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3421','永善县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3422','绥江县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3423','镇雄县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3424','彝良县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3425','威信县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3426','水富县','580','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3427','西湖区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3428','上城区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3429','下城区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3430','拱墅区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3431','滨江区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3432','江干区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3433','萧山区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3434','余杭区','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3435','市郊','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3436','建德市','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3437','富阳市','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3438','临安市','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3439','桐庐县','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3440','淳安县','581','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3441','吴兴区','582','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3442','南浔区','582','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3443','德清县','582','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3444','长兴县','582','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3445','安吉县','582','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3446','南湖区','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3447','秀洲区','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3448','海宁市','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3449','嘉善县','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3450','平湖市','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3451','桐乡市','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3452','海盐县','583','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3453','婺城区','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3454','金东区','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3455','兰溪市','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3456','市区','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3457','佛堂镇','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3458','上溪镇','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3459','义亭镇','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3460','大陈镇','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3461','苏溪镇','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3462','赤岸镇','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3463','东阳市','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3464','永康市','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3465','武义县','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3466','浦江县','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3467','磐安县','584','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3468','莲都区','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3469','龙泉市','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3470','青田县','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3471','缙云县','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3472','遂昌县','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3473','松阳县','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3474','云和县','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3475','庆元县','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3476','景宁','585','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3477','海曙区','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3478','江东区','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3479','江北区','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3480','镇海区','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3481','北仑区','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3482','鄞州区','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3483','余姚市','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3484','慈溪市','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3485','奉化市','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3486','象山县','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3487','宁海县','586','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3488','越城区','587','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3489','上虞市','587','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3490','嵊州市','587','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3491','绍兴县','587','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3492','新昌县','587','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3493','诸暨市','587','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3494','椒江区','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3495','黄岩区','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3496','路桥区','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3497','温岭市','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3498','临海市','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3499','玉环县','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3500','三门县','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3501','天台县','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3502','仙居县','588','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3503','鹿城区','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3504','龙湾区','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3505','瓯海区','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3506','瑞安市','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3507','乐清市','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3508','洞头县','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3509','永嘉县','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3510','平阳县','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3511','苍南县','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3512','文成县','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3513','泰顺县','589','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3514','定海区','590','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3515','普陀区','590','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3516','岱山县','590','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3517','嵊泗县','590','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3518','衢州市','591','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3519','江山市','591','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3520','常山县','591','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3521','开化县','591','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3522','龙游县','591','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3523','合川区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3524','江津区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3525','南川区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3526','永川区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3527','南岸区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3528','渝北区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3529','万盛区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3530','大渡口区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3531','万州区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3532','北碚区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3533','沙坪坝区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3534','巴南区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3535','涪陵区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3536','江北区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3537','九龙坡区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3538','渝中区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3539','黔江开发区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3540','长寿区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3541','双桥区','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3542','綦江县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3543','潼南县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3544','铜梁县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3545','大足县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3546','荣昌县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3547','璧山县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3548','垫江县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3549','武隆县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3550','丰都县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3551','城口县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3552','梁平县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3553','开县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3554','巫溪县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3555','巫山县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3556','奉节县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3557','云阳县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3558','忠县','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3559','石柱','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3560','彭水','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3561','酉阳','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3562','秀山','592','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3563','沙田区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3564','东区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3565','观塘区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3566','黄大仙区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3567','九龙城区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3568','屯门区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3569','葵青区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3570','元朗区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3571','深水埗区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3572','西贡区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3573','大埔区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3574','湾仔区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3575','油尖旺区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3576','北区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3577','南区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3578','荃湾区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3579','中西区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3580','离岛区','593','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3581','澳门','594','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3582','台北','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3583','高雄','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3584','基隆','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3585','台中','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3586','台南','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3587','新竹','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3588','嘉义','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3589','宜兰县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3590','桃园县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3591','苗栗县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3592','彰化县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3593','南投县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3594','云林县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3595','屏东县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3596','台东县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3597','花莲县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3598','澎湖县','595','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3599','合肥','201','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3600','庐阳区','3599','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3601','瑶海区','3599','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3602','蜀山区','3599','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3603','包河区','3599','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3604','长丰县','3599','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3605','肥东县','3599','','','','','0','1');
INSERT INTO smartb2b_area VALUES('3606','肥西县','3599','','','','','0','1');

DROP TABLE IF EXISTS smartb2b_article;
CREATE TABLE `smartb2b_article` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) NOT NULL DEFAULT '0',
  `userid` int(10) NOT NULL,
  `is_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_flash` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_head` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `color` varchar(8) NOT NULL,
  `is_bold` tinyint(1) NOT NULL,
  `thumb` varchar(100) NOT NULL,
  `img` varchar(255) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `content` longtext NOT NULL,
  `is_comment` tinyint(1) NOT NULL DEFAULT '1',
  `author` varchar(30) NOT NULL DEFAULT '',
  `afrom` varchar(30) NOT NULL,
  `flink` varchar(100) NOT NULL,
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) NOT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `flag` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_id` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=207 DEFAULT CHARSET=utf8 COMMENT='文章';


DROP TABLE IF EXISTS smartb2b_article_cat;
CREATE TABLE `smartb2b_article_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL,
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='文章分类';


DROP TABLE IF EXISTS smartb2b_article_comment;
CREATE TABLE `smartb2b_article_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_value` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='文章评论';


DROP TABLE IF EXISTS smartb2b_ask;
CREATE TABLE `smartb2b_ask` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user` varchar(20) NOT NULL,
  `is_anonymous` tinyint(1) NOT NULL,
  `title` char(100) NOT NULL DEFAULT '',
  `coin` smallint(6) unsigned NOT NULL DEFAULT '0',
  `is_rec` tinyint(1) NOT NULL DEFAULT '0',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0',
  `etime` int(11) unsigned NOT NULL DEFAULT '0',
  `slove_time` int(11) unsigned NOT NULL DEFAULT '0',
  `best_answer` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` smallint(6) NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `is_slove` tinyint(1) NOT NULL DEFAULT '0',
  `answer_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `content` mediumtext NOT NULL,
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  `extra` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `disorder` (`catid`,`add_time`),
  KEY `expiredtime` (`etime`),
  KEY `reward` (`coin`),
  KEY `uid` (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='问答表';


DROP TABLE IF EXISTS smartb2b_ask_answer;
CREATE TABLE `smartb2b_ask_answer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ask_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `if_answer` tinyint(1) NOT NULL DEFAULT '0',
  `catid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user` char(32) NOT NULL DEFAULT '',
  `good_rate` smallint(6) unsigned NOT NULL DEFAULT '0',
  `bad_rate` smallint(6) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `brief` char(200) NOT NULL DEFAULT '',
  `content` mediumtext NOT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `askid` (`ask_id`),
  KEY `uid` (`userid`),
  KEY `dateline` (`ask_id`,`add_time`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='回答表';


DROP TABLE IF EXISTS smartb2b_ask_cat;
CREATE TABLE `smartb2b_ask_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL,
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '50',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COMMENT='问答分类';

DROP TABLE IF EXISTS smartb2b_bill;
CREATE TABLE `smartb2b_bill` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) unsigned NOT NULL,
  `type` char(30) NOT NULL,
  `payment` char(30) NOT NULL,
  `account` varchar(255) NOT NULL,
  `paycode` char(30) NOT NULL,
  `money` decimal(10,2) NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `locked` decimal(10,2) NOT NULL,
  `add_time` int(10) unsigned NOT NULL,
  `desc` varchar(255) NOT NULL,
  `is_pay` tinyint(1) NOT NULL DEFAULT '0',
  `pay_time` int(10) NOT NULL,
  `adminid` mediumint(5) NOT NULL,
  `admin` varchar(30) NOT NULL,
  `admin_note` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COMMENT='账单记录';

DROP TABLE IF EXISTS smartb2b_blog;
CREATE TABLE `smartb2b_blog` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) NOT NULL DEFAULT '0',
  `userid` int(10) NOT NULL,
  `rec` char(10) NOT NULL,
  `title` varchar(150) NOT NULL DEFAULT '',
  `color` varchar(8) NOT NULL,
  `is_bold` tinyint(1) NOT NULL,
  `thumb` varchar(100) NOT NULL,
  `img` varchar(255) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `content` longtext NOT NULL,
  `is_comment` tinyint(1) NOT NULL DEFAULT '1',
  `author` varchar(30) NOT NULL DEFAULT '',
  `afrom` varchar(30) NOT NULL,
  `flink` varchar(100) NOT NULL,
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) NOT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `flag` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_id` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=151 DEFAULT CHARSET=utf8 COMMENT='博客表';


DROP TABLE IF EXISTS smartb2b_blog_cat;
CREATE TABLE `smartb2b_blog_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL,
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='博客分类';


DROP TABLE IF EXISTS smartb2b_blog_comment;
CREATE TABLE `smartb2b_blog_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL DEFAULT '',
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `rank` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_value` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='博客评论';


DROP TABLE IF EXISTS smartb2b_blog_ucat;
CREATE TABLE `smartb2b_blog_ucat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(8) DEFAULT NULL,
  `cat` varchar(50) DEFAULT NULL,
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `sort` mediumint(3) DEFAULT '0',
  `num` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COMMENT='博客自定义分类';

DROP TABLE IF EXISTS smartb2b_brand;
CREATE TABLE `smartb2b_brand` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `catid` mediumint(8) NOT NULL,
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `is_rec` tinyint(1) NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0',
  `thumb` varchar(100) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `homepage` varchar(255) NOT NULL DEFAULT '',
  `hits` mediumint(3) NOT NULL DEFAULT '0',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `add_time` int(10) NOT NULL,
  `flag` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `is_show` (`is_show`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COMMENT='品牌';


DROP TABLE IF EXISTS smartb2b_brand_cat;
CREATE TABLE `smartb2b_brand_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 COMMENT='品牌分类';


DROP TABLE IF EXISTS smartb2b_cart;
CREATE TABLE `smartb2b_cart` (
  `rec_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `session_id` char(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `sn` varchar(60) NOT NULL DEFAULT '',
  `product_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `num` smallint(5) unsigned NOT NULL DEFAULT '0',
  `attr` text NOT NULL,
  `is_real` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `extension_code` varchar(30) NOT NULL DEFAULT '',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rec_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_gift` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_handsel` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `goods_attr_id` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`rec_id`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COMMENT='购物车';


DROP TABLE IF EXISTS smartb2b_company;
CREATE TABLE `smartb2b_company` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `userid` int(12) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `group_id` smallint(4) unsigned NOT NULL DEFAULT '0',
  `company` varchar(100) NOT NULL DEFAULT '',
  `country` varchar(50) NOT NULL,
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `rank` int(5) unsigned NOT NULL DEFAULT '0',
  `vip` smallint(2) unsigned NOT NULL DEFAULT '0',
  `type` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL DEFAULT '',
  `catid` varchar(100) NOT NULL DEFAULT '',
  `capital` int(10) NOT NULL,
  `turnover` varchar(50) NOT NULL,
  `size` varchar(20) NOT NULL,
  `founded` int(5) NOT NULL,
  `addr` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL,
  `position` varchar(30) NOT NULL,
  `stime` int(11) unsigned NOT NULL DEFAULT '0',
  `etime` int(11) unsigned NOT NULL DEFAULT '0',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `intro` varchar(255) NOT NULL DEFAULT '',
  `detail` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `is_rec` tinyint(1) NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `banner` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `domain` varchar(100) NOT NULL DEFAULT '',
  `homepage` varchar(255) NOT NULL,
  `icp` varchar(100) NOT NULL DEFAULT '',
  `add_time` int(11) NOT NULL,
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid` (`userid`),
  KEY `domain` (`domain`),
  KEY `vip` (`vip`),
  KEY `groupid` (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4847 DEFAULT CHARSET=utf8 COMMENT='公司';

DROP TABLE IF EXISTS smartb2b_company_album;
CREATE TABLE `smartb2b_company_album` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pro_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `img` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `add_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `goods_id` (`pro_id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='企业相册';


DROP TABLE IF EXISTS smartb2b_company_cat;
CREATE TABLE `smartb2b_company_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=283 DEFAULT CHARSET=utf8 COMMENT='企业分类';


DROP TABLE IF EXISTS smartb2b_company_shop;
CREATE TABLE `smartb2b_company_shop` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `userid` int(6) NOT NULL,
  `title` varchar(100) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `desc` varchar(255) NOT NULL,
  `logo` varchar(50) NOT NULL,
  `banner` varchar(50) NOT NULL,
  `background` varchar(50) NOT NULL,
  `menu_config` text,
  `domain` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid_2` (`userid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COMMENT='企业模板设置';

DROP TABLE IF EXISTS smartb2b_config;
CREATE TABLE `smartb2b_config` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `index` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `tip` varchar(50) NOT NULL,
  `ctype` varchar(20) NOT NULL DEFAULT 'system',
  `type` varchar(10) NOT NULL DEFAULT 's',
  `value` text,
  `is_use` tinyint(1) NOT NULL DEFAULT '1',
  `is_sys` tinyint(1) NOT NULL,
  `sort` mediumint(5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index` (`index`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COMMENT='系统配置';

INSERT INTO smartb2b_config VALUES('2','url','站点网址','','system','s','http://localhost/b2b/smartb2b','1','1','0');
INSERT INTO smartb2b_config VALUES('1','sitename','网站名称','','system','s','SmartB2B行业电子商务建站软件','1','1','0');
INSERT INTO smartb2b_config VALUES('3','temp','默认风格','','system','s','default','1','1','4');
INSERT INTO smartb2b_config VALUES('4','copyright','网站版权信息','','system','t','<p>版权所有 2012 www.smartb2b.net </p>\r\n','1','1','5');
INSERT INTO smartb2b_config VALUES('5','reg_switch','注册开关','打开或关闭注册','register','b','1','1','1','0');
INSERT INTO smartb2b_config VALUES('6','reg_agree','注册协议','注册页面显示的注册协议','register','t','1、在本站注册的会员，必须遵守《互联网电子公告服务管理规定》，不得在本站发表诽谤他人，侵犯他人隐私，侵犯他人知识产权，传播病毒，政治言论，商业讯息等信息。<br>\r\n2、在所有在本站发表的文章，本站都具有最终编辑权，并且保留用于印刷或向第三方发表的权利，如果你的资料不齐全，我们将有权不作任何通知使用你在本站发布的作品。<br>\r\n3、在登记过程中，您将选择注册名和密码。注册名的选择应遵守法律法规及社会公德。您必须对您的密码保密，您将对您注册名和密码下发生的所有活动承担责任。','1','1','0');
INSERT INTO smartb2b_config VALUES('7','smtp_switch','邮件模块开关','是否启用smtp方式发送邮件','smtp','b','1','1','1','0');
INSERT INTO smartb2b_config VALUES('8','smtp_server','SMTP服务器','','smtp','s','smtp.163.com','1','1','0');
INSERT INTO smartb2b_config VALUES('9','smtp_port','服务器端口','','smtp','s','25','1','1','0');
INSERT INTO smartb2b_config VALUES('10','smtp_mail','SMTP用户邮箱','','smtp','s','smartb2b@163.com','1','1','0');
INSERT INTO smartb2b_config VALUES('11','smtp_pass','SMTP用户密码','','smtp','s','123456','1','1','0');
INSERT INTO smartb2b_config VALUES('12','keywords','网站关键字','多个关键字用英文逗号隔开，用于SEO','system','s','SmartB2B,模块建站,CMS,网站建设','1','1','0');
INSERT INTO smartb2b_config VALUES('13','descrip','站点描述','简单描述一下站点的信息，用于SEO','system','t','SmartB2B是一款模块化建站的PHP软件，可建设门户类、B2B垂直行业、分类信息、房产、招聘、下载、视频类网站。','1','1','0');
INSERT INTO smartb2b_config VALUES('14','reg_verify','显示验证码','','register','b','1','1','1','0');
INSERT INTO smartb2b_config VALUES('15','is_cache','缓存开启','','system','b','1','1','1','0');
INSERT INTO smartb2b_config VALUES('16','cache_time','缓存周期','网站缓存的生存时间，单位为秒(S)。','system','s','3600','1','1','0');
INSERT INTO smartb2b_config VALUES('17','base_url','共享cookie的域名','跨域共享cookie的域名(例如: .smartb2b.net)','system','s','.smartb2b.net','1','1','0');
INSERT INTO smartb2b_config VALUES('18','date_format','时间格式','网站显示的时间格式，如“Y-m-d H:i:s”','system','s','Y-m-d H:i:s','1','1','0');
INSERT INTO smartb2b_config VALUES('23','qq','客服QQ','','customer','s','45469095','1','1','0');
INSERT INTO smartb2b_config VALUES('24','qq2','客服QQ2','','customer','s','43524751','1','1','0');
INSERT INTO smartb2b_config VALUES('25','aliww','阿里旺旺','','customer','s','liclny','1','1','0');
INSERT INTO smartb2b_config VALUES('26','skype','Skype','','customer','s','45469095','1','1','0');
INSERT INTO smartb2b_config VALUES('28','rewrite','伪静态','','system','b','1','1','1','0');
INSERT INTO smartb2b_config VALUES('36','web_switch','网站开关','开关打开网站前台将禁止所有人访问','system','b','1','1','1','0');
INSERT INTO smartb2b_config VALUES('37','close_reason','关闭原因','','system','t','系统维护中，请稍后访问','1','1','0');
INSERT INTO smartb2b_config VALUES('46','file_url','文件路径','相对于根目录的路径','system','s','data/upload','1','0','0');
INSERT INTO smartb2b_config VALUES('41','money_symbol','货类符号','','system','s','￥','1','1','0');
INSERT INTO smartb2b_config VALUES('40','currency','货币种类','','system','s','人民币','1','1','0');
INSERT INTO smartb2b_config VALUES('39','lang','默认语言','','system','s','cn','1','1','0');
INSERT INTO smartb2b_config VALUES('42','money_unit','货币单位','','system','s','元','1','1','0');
INSERT INTO smartb2b_config VALUES('43','country','默认国家代码','设置默认国家选择','system','s','37','1','1','0');
INSERT INTO smartb2b_config VALUES('44','reg_show_agree','显示注册协议','','register','b','1','1','0','0');
INSERT INTO smartb2b_config VALUES('45','icp','网站备案代码','显示 ICP 备案信息，如果网站已备案，在此输入您的授权码，如果没有请留空','system','s','','1','0','0');

DROP TABLE IF EXISTS smartb2b_config_type;
CREATE TABLE `smartb2b_config_type` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sort` mediumint(5) NOT NULL,
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='配置类型';

INSERT INTO smartb2b_config_type VALUES('1','系统设置','system','0','1');
INSERT INTO smartb2b_config_type VALUES('2','注册设置','register','0','1');
INSERT INTO smartb2b_config_type VALUES('3','邮件设置','smtp','0','1');
INSERT INTO smartb2b_config_type VALUES('5','在线客服','customer','0','1');

DROP TABLE IF EXISTS smartb2b_exhibit;
CREATE TABLE `smartb2b_exhibit` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) NOT NULL DEFAULT '0',
  `userid` int(10) NOT NULL,
  `user` varchar(20) NOT NULL,
  `is_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `keyword` varchar(100) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thumb` varchar(100) NOT NULL,
  `city` varchar(50) NOT NULL,
  `addr` varchar(200) NOT NULL,
  `content` longtext NOT NULL,
  `contact` varchar(30) NOT NULL,
  `contacts` varchar(255) NOT NULL,
  `sponsor` varchar(100) NOT NULL,
  `is_comment` tinyint(1) NOT NULL DEFAULT '1',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) NOT NULL,
  `stime` int(10) NOT NULL DEFAULT '0',
  `etime` int(10) NOT NULL DEFAULT '0',
  `flag` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_id` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=212 DEFAULT CHARSET=utf8 COMMENT='展会';

DROP TABLE IF EXISTS smartb2b_exhibit_cat;
CREATE TABLE `smartb2b_exhibit_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL DEFAULT '0',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='展会分类';

DROP TABLE IF EXISTS smartb2b_exhibit_cat;
CREATE TABLE `smartb2b_exhibit_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL DEFAULT '0',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='展会分类';

DROP TABLE IF EXISTS smartb2b_frendlink_cat;
CREATE TABLE `smartb2b_frendlink_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 COMMENT='品牌分类';


DROP TABLE IF EXISTS smartb2b_friendlink;
CREATE TABLE `smartb2b_friendlink` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `catid` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '50',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `stime` int(11) NOT NULL,
  `etime` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `show_order` (`sort`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='友情链接';

INSERT INTO smartb2b_friendlink VALUES('7','0','SmartB2B','http://www.smartb2b.net','http://www.smartb2b.net/data/upload/flink/smartb2b.gif','0','1','0','0');


DROP TABLE IF EXISTS smartb2b_help;
CREATE TABLE `smartb2b_help` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) NOT NULL DEFAULT '0',
  `userid` int(10) NOT NULL,
  `is_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_flash` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_head` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `color` varchar(8) NOT NULL,
  `is_bold` tinyint(1) NOT NULL,
  `thumb` varchar(100) NOT NULL,
  `img` varchar(255) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `content` longtext NOT NULL,
  `is_comment` tinyint(1) NOT NULL DEFAULT '1',
  `author` varchar(30) NOT NULL DEFAULT '',
  `afrom` varchar(30) NOT NULL,
  `flink` varchar(100) NOT NULL,
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) NOT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `flag` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_id` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=200 DEFAULT CHARSET=utf8 COMMENT='帮助中心';


DROP TABLE IF EXISTS smartb2b_help_cat;
CREATE TABLE `smartb2b_help_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL,
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='文章分类';

DROP TABLE IF EXISTS smartb2b_hotel;
CREATE TABLE `smartb2b_hotel` (
  `userid` int(12) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `group_id` smallint(4) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `country` varchar(50) NOT NULL,
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `size` mediumint(6) NOT NULL,
  `room` mediumint(5) NOT NULL,
  `to_airport` int(5) NOT NULL,
  `to_city` int(5) NOT NULL,
  `to_exhibit` int(5) NOT NULL,
  `open_date` int(5) NOT NULL,
  `gym` int(5) NOT NULL,
  `restaurant` int(5) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `oprice` decimal(10,2) NOT NULL,
  `rank` int(5) unsigned NOT NULL DEFAULT '0',
  `vip` smallint(2) unsigned NOT NULL DEFAULT '0',
  `type` varchar(100) NOT NULL DEFAULT '',
  `catid` varchar(100) NOT NULL DEFAULT '',
  `tel` varchar(50) NOT NULL DEFAULT '',
  `mobile` varchar(15) DEFAULT NULL,
  `fax` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `qq` varchar(15) NOT NULL,
  `aliww` varchar(100) NOT NULL,
  `skype` varchar(100) NOT NULL,
  `msn` varchar(100) NOT NULL,
  `addr` varchar(255) NOT NULL DEFAULT '',
  `zip` varchar(20) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL,
  `position` varchar(30) NOT NULL,
  `stime` int(11) unsigned NOT NULL DEFAULT '0',
  `etime` int(11) unsigned NOT NULL DEFAULT '0',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `intro` varchar(255) NOT NULL DEFAULT '',
  `detail` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `rec` varchar(10) NOT NULL,
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `banner` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `domain` varchar(100) NOT NULL DEFAULT '',
  `homepage` varchar(255) NOT NULL,
  `icp` varchar(100) NOT NULL DEFAULT '',
  `add_time` int(11) NOT NULL,
  KEY `domain` (`domain`),
  KEY `vip` (`vip`),
  KEY `groupid` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='酒店';


DROP TABLE IF EXISTS smartb2b_hotel_room;
CREATE TABLE `smartb2b_hotel_room` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `size` int(6) NOT NULL,
  `height` int(5) NOT NULL,
  `banquet` int(5) NOT NULL,
  `reception` int(5) NOT NULL,
  `theater` int(5) NOT NULL,
  `classroom` int(5) NOT NULL,
  `boardroom` int(5) NOT NULL,
  `u_shape` int(5) NOT NULL,
  `w_shape` int(5) NOT NULL,
  `fishbone` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='酒店房间';


DROP TABLE IF EXISTS smartb2b_ipban;
CREATE TABLE `smartb2b_ipban` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adminid` mediumint(5) NOT NULL,
  `admin` varchar(30) NOT NULL,
  `ip` varchar(50) NOT NULL DEFAULT '',
  `is_ban` tinyint(1) NOT NULL,
  `stime` int(10) unsigned NOT NULL DEFAULT '0',
  `etime` int(10) unsigned NOT NULL DEFAULT '0',
  `add_time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='禁止IP访问';


DROP TABLE IF EXISTS smartb2b_job;
CREATE TABLE `smartb2b_job` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `user` varchar(30) NOT NULL,
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `department` varchar(100) NOT NULL DEFAULT '',
  `is_rec` tinyint(1) NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0',
  `num` smallint(5) unsigned NOT NULL DEFAULT '0',
  `min_salary` int(10) unsigned NOT NULL DEFAULT '0',
  `max_salary` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL,
  `gender` varchar(5) NOT NULL,
  `marry` varchar(20) NOT NULL,
  `edu` varchar(20) NOT NULL,
  `experience` smallint(2) unsigned NOT NULL DEFAULT '0',
  `min_age` smallint(2) unsigned NOT NULL DEFAULT '0',
  `max_age` smallint(2) unsigned NOT NULL DEFAULT '0',
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `desc` text NOT NULL,
  `contact` varchar(30) NOT NULL DEFAULT '',
  `tel` varchar(50) NOT NULL DEFAULT '',
  `mobile` varchar(50) NOT NULL DEFAULT '',
  `addr` varchar(255) NOT NULL DEFAULT '',
  `qq` varchar(20) NOT NULL DEFAULT '',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `username` (`contact`),
  KEY `editdate` (`edit_time`),
  KEY `edittime` (`edit_time`),
  KEY `catid` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='招聘';

DROP TABLE IF EXISTS smartb2b_job_cat;
CREATE TABLE `smartb2b_job_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT '0',
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=397 DEFAULT CHARSET=utf8 COMMENT='人才分类';


DROP TABLE IF EXISTS smartb2b_job_resume;
CREATE TABLE `smartb2b_job_resume` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` mediumint(7) unsigned NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user` varchar(50) NOT NULL DEFAULT '',
  `apply_job` varchar(100) NOT NULL,
  `hits` int(8) unsigned NOT NULL DEFAULT '0',
  `truename` varchar(16) NOT NULL DEFAULT '',
  `province` varchar(50) NOT NULL,
  `city` varchar(8) NOT NULL DEFAULT '',
  `addr` varchar(255) NOT NULL DEFAULT '',
  `mobile` varchar(248) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `website` varchar(128) NOT NULL DEFAULT '',
  `intro` text NOT NULL,
  `edu_exp` text NOT NULL,
  `work_exp` text NOT NULL,
  `add_time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='简历表';


DROP TABLE IF EXISTS smartb2b_member;
CREATE TABLE `smartb2b_member` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `user` varchar(36) NOT NULL,
  `name` varchar(50) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `pass` char(32) NOT NULL DEFAULT '',
  `face` varchar(50) NOT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT '0',
  `group_id` int(2) NOT NULL DEFAULT '1',
  `country` varchar(50) NOT NULL,
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `tel` varchar(50) NOT NULL,
  `mobile` varchar(50) NOT NULL,
  `fax` varchar(50) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `aliww` varchar(100) NOT NULL,
  `skype` varchar(100) NOT NULL,
  `msn` varchar(100) NOT NULL,
  `zip` varchar(20) NOT NULL,
  `bank` varchar(50) NOT NULL,
  `bank_id` varchar(50) NOT NULL,
  `pay_pass` varchar(40) NOT NULL,
  `wallet` decimal(10,2) NOT NULL,
  `locked` decimal(10,2) NOT NULL,
  `point` int(10) NOT NULL,
  `question` smallint(5) unsigned NOT NULL DEFAULT '0',
  `answer` char(30) NOT NULL DEFAULT '',
  `reg_time` int(11) unsigned NOT NULL DEFAULT '0',
  `reg_ip` char(16) NOT NULL DEFAULT '',
  `login_num` mediumint(8) NOT NULL,
  `is_ban` tinyint(1) NOT NULL DEFAULT '0',
  `last_login` int(11) unsigned NOT NULL DEFAULT '0',
  `last_ip` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `user` (`user`),
  UNIQUE KEY `email` (`email`),
  KEY `logintime` (`last_login`)
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=utf8 COMMENT='会员表';

DROP TABLE IF EXISTS smartb2b_member_addr;
CREATE TABLE `smartb2b_member_addr` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `country` varchar(50) NOT NULL,
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zone` varchar(50) NOT NULL,
  `street` varchar(200) NOT NULL,
  `zip` int(20) NOT NULL,
  `tel` varchar(50) NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='交易地址';

DROP TABLE IF EXISTS smartb2b_member_group;
CREATE TABLE `smartb2b_member_group` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `desc` varchar(100) NOT NULL,
  `is_enable` tinyint(1) NOT NULL DEFAULT '1',
  `access` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='会员组';

INSERT INTO smartb2b_member_group VALUES('1','个人会员','个人会员模型','1','');
INSERT INTO smartb2b_member_group VALUES('2','企业会员','公司企业会员模型','1','');
INSERT INTO smartb2b_member_group VALUES('3','金牌会员','','1','');

DROP TABLE IF EXISTS smartb2b_member_link;
CREATE TABLE `smartb2b_member_link` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `name` varchar(40) NOT NULL,
  `url` varchar(100) NOT NULL,
  `sort` mediumint(3) NOT NULL,
  `add_time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='用户友情链接表';

DROP TABLE IF EXISTS smartb2b_message;
CREATE TABLE `smartb2b_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` char(20) NOT NULL,
  `tid` char(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL,
  `content` text,
  `is_sys` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`is_read`)
) ENGINE=MyISAM AUTO_INCREMENT=218 DEFAULT CHARSET=utf8 COMMENT='站内信息';

DROP TABLE IF EXISTS smartb2b_module;
CREATE TABLE `smartb2b_module` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `index` varchar(30) NOT NULL,
  `sort` int(3) NOT NULL,
  `is_ban` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS smartb2b_nav;
CREATE TABLE `smartb2b_nav` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `is_show` tinyint(1) NOT NULL,
  `sort` tinyint(2) NOT NULL,
  `opennew` tinyint(1) NOT NULL,
  `url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `ifshow` (`is_show`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COMMENT='网站导航';

INSERT INTO smartb2b_nav VALUES('24','top','首页','1','0','0','index.php');
INSERT INTO smartb2b_nav VALUES('34','top','SmartB2B','1','8','1','http://www.smartb2b.net');
INSERT INTO smartb2b_nav VALUES('4','top','供求','1','3','0','trade');
INSERT INTO smartb2b_nav VALUES('6','top','企业','1','2','0','company');
INSERT INTO smartb2b_nav VALUES('7','top','商城','1','5','0','mall');
INSERT INTO smartb2b_nav VALUES('21','top','资讯','1','1','0','article');


DROP TABLE IF EXISTS smartb2b_notice;
CREATE TABLE `smartb2b_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adminid` mediumint(5) NOT NULL,
  `admin` varchar(20) NOT NULL,
  `title` varchar(160) DEFAULT NULL,
  `color` varchar(30) NOT NULL,
  `is_bold` tinyint(1) NOT NULL,
  `content` text,
  `hits` mediumint(8) NOT NULL DEFAULT '0',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `is_comment` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='公告表';

DROP TABLE IF EXISTS smartb2b_notice_comment;
CREATE TABLE `smartb2b_notice_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL DEFAULT '',
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `rank` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_value` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='文章评论';

DROP TABLE IF EXISTS smartb2b_onepage;
CREATE TABLE `smartb2b_onepage` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `color` varchar(8) NOT NULL,
  `is_bold` tinyint(1) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `content` longtext NOT NULL,
  `is_comment` tinyint(1) NOT NULL DEFAULT '1',
  `is_opennew` tinyint(1) NOT NULL,
  `is_show` tinyint(1) NOT NULL,
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(100) NOT NULL,
  `sort` tinyint(3) NOT NULL DEFAULT '0',
  `hits` int(10) NOT NULL,
  `desc` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_id` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=201 DEFAULT CHARSET=utf8 COMMENT='文章';

DROP TABLE IF EXISTS smartb2b_onepage_cat;
CREATE TABLE `smartb2b_onepage_cat` (
  `catid` smallint(5) NOT NULL AUTO_INCREMENT,
  `cat` varchar(50) NOT NULL DEFAULT '',
  `keyword` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) NOT NULL,
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `is_sys` tinyint(1) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `sort_order` (`sort`),
  KEY `parent_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COMMENT='文章分类';

INSERT INTO smartb2b_onepage_cat VALUES('1','底部导航','','底部导航链接','4','50','0','1','1');

DROP TABLE IF EXISTS smartb2b_order;
CREATE TABLE `smartb2b_order` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sn` varchar(20) NOT NULL DEFAULT '',
  `buyer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `seller_id` int(10) NOT NULL DEFAULT '0',
  `buyer` varchar(50) NOT NULL DEFAULT '',
  `seller` varchar(50) NOT NULL,
  `addr` varchar(255) NOT NULL DEFAULT '',
  `zip` varchar(60) NOT NULL DEFAULT '',
  `tel` varchar(60) NOT NULL DEFAULT '',
  `mobile` varchar(60) NOT NULL DEFAULT '',
  `street` varchar(200) NOT NULL,
  `pay_name` varchar(120) NOT NULL DEFAULT '',
  `num` int(8) NOT NULL DEFAULT '1',
  `freight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `pay_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `pay_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ship_time` int(10) unsigned NOT NULL DEFAULT '0',
  `confirm_time` int(10) unsigned NOT NULL DEFAULT '0',
  `msg` varchar(255) NOT NULL DEFAULT '',
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_sn` (`sn`),
  KEY `user_id` (`buyer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COMMENT='订单表';

DROP TABLE IF EXISTS smartb2b_order_product;
CREATE TABLE `smartb2b_order_product` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `userid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(120) NOT NULL DEFAULT '',
  `thumb` varchar(100) NOT NULL,
  `psn` varchar(60) NOT NULL DEFAULT '',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `attr` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COMMENT='订单产品';

DROP TABLE IF EXISTS smartb2b_payment;
CREATE TABLE `smartb2b_payment` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `fee` varchar(10) NOT NULL DEFAULT '0',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `config` text NOT NULL,
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pay_code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='支付工具';

INSERT INTO smartb2b_payment VALUES('1','alipay','支付宝','支付宝是国内先进的网上支付平台。<br/>SmartB2B联合支付宝推出优惠套餐：无预付/年费，单笔费率1.5%，无流量限制。<br>官方网站：<a href=\"http://www.alipay.com\" target=\"_blank\">http://www.alipay.com</a>','1.5%','0','a:4:{i:0;a:3:{s:4:\"name\";s:14:\"alipay_account\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:17:\"liclny007@163.com\";}i:1;a:3:{s:4:\"name\";s:10:\"alipay_key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:15:\"3465324dfgsa223\";}i:2;a:3:{s:4:\"name\";s:14:\"alipay_partner\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:12:\"134565312223\";}i:3;a:3:{s:4:\"name\";s:17:\"alipay_pay_method\";s:4:\"type\";s:6:\"select\";s:5:\"value\";s:1:\"0\";}}','0','0','0');
INSERT INTO smartb2b_payment VALUES('7','chinabank','网银在线','网银在线与中国工商银行、招商银行、中国建设银行、农业银行、民生银行等数十家金融机构达成协议。全面支持全国19家银行的信用卡及借记卡实现网上支付。<br>官方网站：<a href=\"http://www.chinabank.com.cn\" target=\"_blank\">http://www.chinabank.com.cn</a>','0','0','a:2:{i:0;a:3:{s:4:\"name\";s:17:\"chinabank_account\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:3:{s:4:\"name\";s:13:\"chinabank_key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}','0','0','0');
INSERT INTO smartb2b_payment VALUES('4','tenpay','财付通','财付通是腾讯旗下在线支付平台。<br>通过国家权威安全认证，支持各大银行网上支付，免支付手续费。<br>官方网站：<a href=\"http://www.tenpay.com\" target=\"_blank\">http://www.tenpay.com</a>','0','1','a:3:{i:0;a:3:{s:4:\"name\";s:14:\"tenpay_account\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:8:\"23144513\";}i:1;a:3:{s:4:\"name\";s:10:\"tenpay_key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:4:\"3124\";}i:2;a:3:{s:4:\"name\";s:12:\"magic_string\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:4:\"asdf\";}}','0','0','0');
INSERT INTO smartb2b_payment VALUES('6','balance','余额支付','使用帐户余额支付。<br>只有是本站会员且账户余额足够支付本次消费才能使用。<br>官方网站：<a href=\"http://www.smartb2b.net\" target=\"_blank\">http://www.smartb2b.net</a>','0','0','a:0:{}','0','0','0');
INSERT INTO smartb2b_payment VALUES('8','kuaiqian','快钱','快钱是国内领先的独立第三方支付企业，旨在为各类企业及个人提供安全、便捷和保密的支付清算与账务服务，其推出的支付产品包括但不限于人民币支付，外卡支付，神州行卡支付，联通充值卡支付，VPOS支付等众多支付产品, 支持互联网、手机、电话和POS等多种终端, 以满足各类企业和个人的不同支付需求。<br>官方网站：<a href=\"http://www.99bill.com\" target=\"_blank\">http://www.99bill.com</a>','0','3','a:2:{i:0;a:3:{s:4:\"name\";s:10:\"kq_account\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:3:{s:4:\"name\";s:6:\"kq_key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}','0','0','0');
INSERT INTO smartb2b_payment VALUES('9','paypal','PayPal','PayPal 是在线付款解决方案的全球领导者，在全世界有超过七千一百六十万个帐户用户。PayPal 可在 56 个市场以 7 种货币（加元、欧元、英镑、美元、日元、澳元、港元）使用。<br>官方网站：<a href=\"http://www.paypal.com\" target=\"_blank\">http://www.paypal.com</a>','0','2','a:2:{i:0;a:3:{s:4:\"name\";s:14:\"paypal_account\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:3:{s:4:\"name\";s:15:\"paypal_currency\";s:4:\"type\";s:6:\"select\";s:5:\"value\";s:3:\"USD\";}}','0','0','0');

DROP TABLE IF EXISTS smartb2b_product;
CREATE TABLE `smartb2b_product` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL DEFAULT '0',
  `user` varchar(20) NOT NULL,
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ucatid` mediumint(5) NOT NULL,
  `brand_id` smallint(5) DEFAULT '0',
  `brand` varchar(30) NOT NULL,
  `name` varchar(120) NOT NULL DEFAULT '',
  `sn` varchar(60) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `content` text,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `size` varchar(100) NOT NULL,
  `num` smallint(5) unsigned NOT NULL DEFAULT '0',
  `unit` varchar(8) NOT NULL DEFAULT '个',
  `weight` decimal(10,3) unsigned NOT NULL DEFAULT '0.000',
  `w_unit` varchar(8) NOT NULL,
  `mprice` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `sprice` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `pprice` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `freight` varchar(30) NOT NULL DEFAULT '0.00',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `is_sale` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '100',
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `shop_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_new` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_promote` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sdate` int(11) DEFAULT NULL,
  `edate` int(11) DEFAULT NULL,
  `add_time` int(11) DEFAULT NULL,
  `last_update` int(11) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `goods_sn` (`sn`),
  KEY `cat_id` (`catid`),
  KEY `last_update` (`last_update`),
  KEY `brand_id` (`brand_id`),
  KEY `goods_weight` (`weight`),
  KEY `promote_end_date` (`edate`),
  KEY `promote_start_date` (`sdate`),
  KEY `goods_number` (`num`),
  KEY `sort_order` (`sort`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8 COMMENT='产品表';


DROP TABLE IF EXISTS smartb2b_product_album;
CREATE TABLE `smartb2b_product_album` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `img` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `add_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `goods_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=189 DEFAULT CHARSET=utf8 COMMENT='产品图片';

DROP TABLE IF EXISTS smartb2b_product_cat;
CREATE TABLE `smartb2b_product_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COMMENT='产品分类';


DROP TABLE IF EXISTS smartb2b_product_comment;
CREATE TABLE `smartb2b_product_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL DEFAULT '',
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_value` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='产品评论';


DROP TABLE IF EXISTS smartb2b_product_ucat;
CREATE TABLE `smartb2b_product_ucat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(8) DEFAULT NULL,
  `cat` varchar(50) DEFAULT NULL,
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `sort` mediumint(3) DEFAULT '0',
  `num` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=70 DEFAULT CHARSET=utf8 COMMENT='产品自定义分类';


DROP TABLE IF EXISTS smartb2b_smstemp;
CREATE TABLE `smartb2b_smstemp` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COMMENT='邮件模板';

INSERT INTO smartb2b_smstemp VALUES('4','会员注册欢迎信','欢迎您注册我们的会员','您好[user]：<br/>欢迎您注册[sitename]，请记住本站永久域名：[website]，以便下次访问。<br/>以下为你的基本信息：<br/>用户名：[user]<br/>E-mail：[email]<br/>注册时间：[reg_time]<br/>');
INSERT INTO smartb2b_smstemp VALUES('5','会员激活邮件','请激活邮件','尊敬的[user]用户：</br>您好：</br>您的邮件[email]尚未激活，请点击以下链接激活您的账号。</br>[website]');
INSERT INTO smartb2b_smstemp VALUES('6','找回密码邮件','找回密码','尊敬的用户[user]：<br>请点击以下链接重新设置密码：[website]/member/getpass.php');
INSERT INTO smartb2b_smstemp VALUES('8','会员短消息','会员短消息','尊敬的用户[user]：<br>您好：您有新的短消息，请注册查收[website]/member');

DROP TABLE IF EXISTS smartb2b_swap_word;
CREATE TABLE `smartb2b_swap_word` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `adminid` mediumint(5) NOT NULL,
  `admin` varchar(30) NOT NULL,
  `word` varchar(255) NOT NULL DEFAULT '',
  `replace_word` varchar(255) NOT NULL DEFAULT '',
  `add_time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='敏感词替换';


DROP TABLE IF EXISTS smartb2b_trade;
CREATE TABLE `smartb2b_trade` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL DEFAULT '0',
  `user` varchar(20) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'sell',
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ucatid` mediumint(5) NOT NULL,
  `brand_id` smallint(5) DEFAULT '0',
  `brand` varchar(30) NOT NULL,
  `name` varchar(120) NOT NULL DEFAULT '',
  `keyword` varchar(255) DEFAULT NULL,
  `content` text,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `size` varchar(100) NOT NULL,
  `num` smallint(5) unsigned NOT NULL DEFAULT '0',
  `unit` varchar(8) NOT NULL DEFAULT '个',
  `weight` decimal(10,3) unsigned NOT NULL DEFAULT '0.000',
  `w_unit` varchar(8) NOT NULL,
  `mprice` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `sprice` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `pprice` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `freight` varchar(30) NOT NULL DEFAULT '0.00',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `is_sale` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '100',
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `shop_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_rec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_new` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_promote` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sdate` int(11) DEFAULT NULL,
  `edate` int(11) DEFAULT NULL,
  `add_time` int(11) DEFAULT NULL,
  `last_update` int(11) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat_id` (`catid`),
  KEY `last_update` (`last_update`),
  KEY `brand_id` (`brand_id`),
  KEY `goods_weight` (`weight`),
  KEY `promote_end_date` (`edate`),
  KEY `promote_start_date` (`sdate`),
  KEY `goods_number` (`num`),
  KEY `sort_order` (`sort`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COMMENT='供求表';


DROP TABLE IF EXISTS smartb2b_trade_album;
CREATE TABLE `smartb2b_trade_album` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `img` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `add_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `goods_id` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=173 DEFAULT CHARSET=utf8 COMMENT='供求图片';


DROP TABLE IF EXISTS smartb2b_trade_cat;
CREATE TABLE `smartb2b_trade_cat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `cat` varchar(100) DEFAULT NULL,
  `pid` int(10) NOT NULL,
  `keyword` text,
  `desc` varchar(255) DEFAULT NULL,
  `num` int(10) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `sort` int(10) DEFAULT '0',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=106 DEFAULT CHARSET=utf8 COMMENT='供求分类';


DROP TABLE IF EXISTS smartb2b_trade_comment;
CREATE TABLE `smartb2b_trade_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL DEFAULT '',
  `userid` int(10) NOT NULL,
  `user` varchar(30) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_value` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='供求评论';


DROP TABLE IF EXISTS smartb2b_trade_ucat;
CREATE TABLE `smartb2b_trade_ucat` (
  `catid` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(8) DEFAULT NULL,
  `cat` varchar(50) DEFAULT NULL,
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `sort` mediumint(3) DEFAULT '0',
  `num` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COMMENT='产品自定义分类';
