<?php
/*
 * smartb2b 安装函数库
 * ============================================================================
 * [smartb2b] (C) 2009-2012 smartb2b Inc.
 * Home page: http://www.smartb2b.com；
 * ============================================================================
 * $Author: liclny $
 * $Id: lib_install.php 16881 2009年10月27日 8:22:43Z liclny $
*/

if (!defined('IN_SMARTB2B'))
{
    die('Access attempt!');
}
function check_install()
{
	global $lang;
	if(file_exists('./install.lock'))
	{
		echo $lang['install_lock'];
		exit;
	}
}
//===Step 1============================
function get_agreement()
{
	global $language;
	$file		= ROOT_PATH."install/lang/".$language."/license.htm";
	if(file_exists($file))
	{
		$string		= file_get_contents($file);
		return $string;
	}
}
//===Step 2============================
function system_check()
{
	global $lang;
	$system['os']['name']			= $lang['system_item']['os'];
	$system['os']['value']			= getOS($_SERVER['HTTP_USER_AGENT']);

	$system['php']['name']			= $lang['system_item']['php'];
	$system['php']['value']			= PHP_VERSION;
	
	$system['mysql']['name']		= $lang['system_item']['mysql'];
	$system['mysql']['value']		= function_exists('mysql_connect') ? $lang['support'] : $lang['not_support'];

	$system['gdver']['name']		= $lang['system_item']['gdver'];
	$gdver							= function_exists('gd_info')?gd_info(): 'unknow';
	$system['gdver']['value']		= !empty($gdver['GD Version'])?$gdver['GD Version']:'noext';

	$system['upload']['name']		= $lang['system_item']['upload'];
	$system['upload']['value']		= @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'UNknow';

	$system['disk']['name']			= $lang['system_item']['disk'];
	$system['disk']['value']		= function_exists('disk_free_space')?floor(disk_free_space(ROOT_PATH) / (1024*1024)).'M':'unknow';
	return $system;
}
function check_dir_access($dirs)
{
    global $lang;
    $rows	= array('result' => 'OK', 'list' => array());
    foreach ($dirs AS $dir)
    {
        if (!file_exists(ROOT_PATH . $dir))
        {
            $rows['result']	= 'ERROR';
            $rows['list'][]	= array($dir, $lang['not_exists']);
        }
        elseif (get_file_mode(ROOT_PATH . $dir) < 2)
        {
            $rows['result']	= 'ERROR';
            $rows['list'][]	= array($dir, '1');
        }
        else
        {
            $rows['list'][]	= array($dir, '1');
        }
    }
    return $rows;
}
function get_file_mode($fpath)
{
    if (!file_exists($fpath))        return false;
    $mark = 0;
    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN')
    {
        $test_file = $fpath . '/access_test.txt';
        if (is_dir($fpath))
        {
            $dir = @opendir($fpath);
            if ($dir === false)				return $mark;
            if (@readdir($dir) !== false)	$mark ^= 1; 
            @closedir($dir);

            $fp = @fopen($test_file, 'wb');
            if ($fp === false)              return $mark; 
            if (@fwrite($fp, 'Dir access testing.') !== false)
            {
                $mark ^= 2; 
            }
            @fclose($fp);
            @unlink($test_file);

            $fp = @fopen($test_file, 'ab+');
            if ($fp === false)
            {
                return $mark;
            }
            if (@fwrite($fp, "File edit testing.\r\n") !== false)
            {
                $mark ^= 4;
            }
            @fclose($fp);
            if (@rename($test_file, $test_file) !== false)
            {
                $mark ^= 8;
            }
            @unlink($test_file);
        }
        elseif (is_file($fpath))
        {
            $fp = @fopen($fpath, 'rb');
            if ($fp)
            {
                $mark ^= 1;
            }
            @fclose($fp);
            $fp = @fopen($fpath, 'ab+');
            if ($fp && @fwrite($fp, '') !== false)
            {
                $mark ^= 6;
            }
            @fclose($fp);
            if (@rename($test_file, $test_file) !== false)
            {
                $mark ^= 8;
            }
        }
    }
    else
    {
        if (@is_readable($fpath))            $mark ^= 1;
        if (@is_writable($fpath))            $mark ^= 14;
    }
    return $mark;
}
//===Step3======================================
function creat_config_data()
{
	$db_host    = !empty($_POST['db_host'])?trim($_POST['db_host']):'';
	$db_user    = !empty($_POST['db_user'])?trim($_POST['db_user']):'';
	$db_pass    = !empty($_POST['db_pass'])?trim($_POST['db_pass']):'';
	$db_name    = !empty($_POST['db_name'])?trim($_POST['db_name']):'';
	$db_pre     = !empty($_POST['db_pre'])?trim($_POST['db_pre']):'';
	$charset	= 'utf-8';
	$timezone	= 'Asia/Shanghai';
	$cookiedomain	= "smartb2b".md5(time());

    $data    = "<?php\n";
	$data	.= "//===SmartB2B Config setting======================\n";
	$data	.= "\$config = array();\n";
	$data	.= "\$config['dbhost']			= '$db_host';\n";
	$data	.= "\$config['dbuser']			= '$db_user';\n";
	$data	.= "\$config['dbpass']			= '$db_pass';\n";
	$data	.= "\$config['dbcharset']		= '".DB_CHARSET."';\n";
	$data	.= "\$config['pconnect']		= 0;\n";
	$data	.= "\$config['dbname']			= '$db_name';\n";
	$data	.= "\$config['tabpre']			= '$db_pre';\n";
	$data	.= "\$config['charset']			= '$charset';\n";
	$data	.= "\$config['timezone']		= '$timezone';\n";
	$data	.= "\$config['cookiedomain'] 	= '$cookiedomain';\n";
    $data .= '?>';

    $fp = @fopen(ROOT_PATH . 'data/config.php', 'wb+');
    if (!$fp)
    {
        echo 'Open config.php failed...';exit;
    }
    if (!@fwrite($fp, trim($data)))
    {
        echo 'Write config.php failed...';exit;
    }
    @fclose($fp);
    return true;
}
function creat_database()
{
	$db_host    = !empty($_POST['db_host'])?trim($_POST['db_host']):'';
	$db_user    = !empty($_POST['db_user'])?trim($_POST['db_user']):'';
	$db_pass    = !empty($_POST['db_pass'])?trim($_POST['db_pass']):'';
	$db_name    = !empty($_POST['db_name'])?trim($_POST['db_name']):'';

    $link		= mysql_connect($db_host, $db_user, $db_pass) or die(mysql_error());
	if (mysql_select_db($db_name, $link)===false)
	{
		if(mysql_get_server_info() > '4.1'){
			$sql	= "CREATE DATABASE IF NOT EXISTS `$db_name` DEFAULT CHARACTER SET ".DB_CHARSET;
		}
		else{
			$sql	= "CREATE DATABASE IF NOT EXISTS `$db_name`";
		}
		mysql_query($sql,$link) or die(mysql_error());
	}
	@mysql_close($link);
}
function install_sql_data()
{
	global $config;
	$sqlfile	= ROOT_PATH."install/".SQLFILE.".sql";
	if(file_exists($sqlfile))
	{
		$sql	= file_get_contents(ROOT_PATH."install/SmartB2B.sql");
		$sql	= str_replace(TABPRE,$config['tabpre'], $sql);
		sql_execute($sql);
	}
	else
	{
		echo "SQL file '".SQLFILE.".sql' is not exists...";exit;
	}
}

function sql_execute($sql)
{
	global $db;
    $sqls = sql_split($sql);
	if(is_array($sqls))
    {
		foreach($sqls as $sql)
		{
			if(trim($sql) != '') 
			{
				$db->query($sql);
			}
		}
	}
	else
	{
		$db->query($sqls);
	}
	return true;
}
function sql_split($sql)
{
	global $db;
	if($db->version() > '4.1' && DB_CHARSET)
	{
		$sql = preg_replace("/TYPE=(InnoDB|MyISAM)( DEFAULT CHARSET=[^; ]+)?/", "TYPE=\\1 DEFAULT CHARSET=".DB_CHARSET,$sql);
	}
	$sql	= str_replace("\r", "\n", $sql);
	$ret	= array();
	$num	= 0;
	$queriesarray = explode(";\n", trim($sql));
	unset($sql);
	foreach($queriesarray as $query)
	{
		$ret[$num]	= '';
		$queries	= explode("\n", trim($query));
		$queries	= array_filter($queries);
		foreach($queries as $query)
		{
			$str1 = substr($query, 0, 1);
			if($str1 != '#' && $str1 != '-') $ret[$num] .= $query;
		}
		$num++;
	}
	return($ret);
}
function init_admin()
{
	global $db,$config;
	$admin		= !empty($_POST['admin_user'])?trim($_POST['admin_user']):null;
	$pass		= !empty($_POST['admin_pass'])?trim($_POST['admin_pass']):null;
	$email		= !empty($_POST['admin_email'])?trim($_POST['admin_email']):null;
	if($admin&&$pass)
	{
		$array	= array('group_id'	=> '1',
						'user'		=> $admin,
						'pass'		=> md5($pass),
						'email'		=> $email);
		$db->insert(table('admin'),	$array);
	}
}
function get_install_path() 
{ 
	$URL['DOMAIN']			= get_domain();  //域名(主机名)
	$URL['PHP_SELF']		= isset($_SERVER['PHP_SELF'])?$_SERVER['PHP_SELF']:(isset($_SERVER['SCRIPT_NAME'])?$_SERVER['SCRIPT_NAME']:$_SERVER['ORIG_PATH_INFO']);   //当前页面名称
	$URL['IPATH']			= str_replace('/install/index.php','',$URL['PHP_SELF']);
	$URL['ALL_PATH']		= $URL['DOMAIN'].$URL['IPATH'];
	return $URL['ALL_PATH'];
}
function init_config()
{
	global $db,$config;
	$path	= get_install_path();
	$db->query("update ".table('config')." set value='$path' where id='2'");
	update_system_config('system');
}
function creat_install_lock()
{
	$fp = @fopen(ROOT_PATH . 'install/install.lock', 'wb+');
    if (!$fp)
    {
        echo 'Open file install.lock failed...';exit;
    }
    if (!@fwrite($fp, SQLFILE." have installed..."))
    {
         echo 'Write file install.lock failed...';exit;
    }
    @fclose($fp);
}

//=======================================
function update_system_config($type)
{
	global $db;
	$row	= $db->getRows("select * from ".table('config')." where is_use='1' and ctype='$type'");
	foreach($row as $key=>$v)
	{
		$cfg[$v['index']]	= $v['value'];
	}
	serialize_string($cfg,null,$type);
}
?>