<?php
//广告验证类
class AdCheck extends Check {
	
	public function addCheck(Model &$_model) {
		if (self::isNullString($_POST['name'])) {
			$this->_message[] = '广告名称不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['name'], 2, 'min')) {
			$this->_message[] = '广告名称不得小于2位！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['name'], 100, 'max')) {
			$this->_message[] = '广告名称不得大于100位！';
			$this->_flag = false;
		}		
		if (self::isNullString($_POST['url'])) {
			$this->_message[] = '广告URl不得为空！';
			$this->_flag = false;
		}
		if (self::isNullString($_POST['adindex'])) {
			$this->_message[] = '广告标识不得为空！';
			$this->_flag = false;
		}			
		return $this->_flag;
	}
	
	public function updateCheck(Model &$_model) {
		if (self::isNullString($_POST['name'])) {
			$this->_message[] = '广告名称不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['name'], 2, 'min')) {
			$this->_message[] = '广告名称不得小于2位！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['name'], 100, 'max')) {
			$this->_message[] = '广告名称不得大于100位！';
			$this->_flag = false;
		}		
		if (self::isNullString($_POST['url'])) {
			$this->_message[] = '广告URl不得为空！';
			$this->_flag = false;
		}
		if (self::isNullString($_POST['adindex'])) {
			$this->_message[] = '广告标识不得为空！';
			$this->_flag = false;
		}	
		return $this->_flag;
	}
}
?>