<?php
//文章验证类
class ArtileCheck extends Check {
	
	public function addCheck(Model &$_model) {
		if (self::isNullString($_POST['title'])) {
			$this->_message[] = '文章名称不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['title'], 2, 'min')) {
			$this->_message[] = '文章名称不得小于2位！';
			$this->_flag = false;
		}		
		if (self::isNullString($_POST['keywords'])) {
			$this->_message[] = '文章关键词不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['keywords'], 100, 'max')) {
			$this->_message[] = '文章关键词不得大于100位！';
			$this->_flag = false;
		}
		if (self::isNullString($_POST['info'])) {
			$this->_message[] = '文章关键词不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['info'], 200, 'max')) {
			$this->_message[] = '文章摘要不得大于200位！';
			$this->_flag = false;
		}
		if (self::checkStrEquals($_POST['pid'], '0')) {
			$this->_message[] = '请选择文章所属类别';
			$this->_flag = false;
		}
		if (self::isNullString($_POST['content'])) {
			$this->_message[] = '文章内容不得为空！';
			$this->_flag = false;
		}
		
		return $this->_flag;
	}
	
	public function updateCheck(Model &$_model) {
		if (self::checkStrLength($_POST['info'], 200, 'max')) {
			$this->_message[] = '文章简介不得大于200位！';
			$this->_flag = false;
		}
		return $this->_flag;
	}
	
	public function ajax(Model &$_model, Array $_param) {
		echo $_model->isOne($_param) ? 1 : 2;
	}
}
?>